import 'package:flutter/material.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';
import 'package:flutter_test/flutter_test.dart';

import 'helpers.dart';

void main() {
  group('ThreeInOut', () {
    testWidgets(
      'needs either color or itemBuilder',
      (WidgetTester tester) async {
        expect(() => SpinKitThreeInOut(), throwsAssertionError);
        expect(
          () => SpinKitThreeInOut(
            color: Colors.white,
            itemBuilder: fakeBoxBuilder,
          ),
          throwsAssertionError,
        );
      },
    );

    testWidgets('needs color to be non-null', (WidgetTester tester) async {
      expect(() => SpinKitThreeInOut(color: null), throwsAssertionError);
    });

    testWidgets(
      'needs itemBuilder to be non-null',
      (WidgetTester tester) async {
        expect(
          () => SpinKitThreeInOut(itemBuilder: null),
          throwsAssertionError,
        );
      },
    );

    testWidgets('works with color', (WidgetTester tester) async {
      await tester.pumpWidget(
        createMaterialApp(const SpinKitThreeInOut(color: Colors.white)),
      );
      expect(find.byType(SpinKitThreeInOut), findsOneWidget);
      expect(find.byType(DecoratedBox), findsWidgets);
      tester.verifyTickersWereDisposed();
    });

    testWidgets('works with itemBuilder', (WidgetTester tester) async {
      await tester.pumpWidget(
        createMaterialApp(
          const SpinKitThreeInOut(itemBuilder: fakeBoxBuilder),
        ),
      );
      expect(find.byType(SpinKitThreeInOut), findsOneWidget);
      expect(find.byType(FakeBox), findsWidgets);
      tester.verifyTickersWereDisposed();
    });

    testWidgets('works without Material', (WidgetTester tester) async {
      await tester.pumpWidget(
        createWidgetsApp(const SpinKitThreeInOut(color: Colors.white)),
      );
      expect(find.byType(SpinKitThreeInOut), findsOneWidget);
      expect(find.byType(DecoratedBox), findsWidgets);
      tester.verifyTickersWereDisposed();
    });
  });
}
