// test_fixes/fix_test.dart
import 'package:flutter/material.dart';
import 'package:flutter_form_builder/flutter_form_builder.dart';

void main() => runApp(const MyApp());

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter FormBuilder Example',
      debugShowCheckedModeBanner: false,
      home: const _ExamplePage(),
    );
  }
}

class _ExamplePage extends StatefulWidget {
  const _ExamplePage();

  @override
  State<_ExamplePage> createState() => _ExamplePageState();
}

class _ExamplePageState extends State<_ExamplePage> {
  final _formKey = GlobalKey<FormBuilderState>();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('Minimal code example')),
      body: Padding(
        padding: const EdgeInsets.all(16),
        child: FormBuilder(
          key: _formKey,
          onPopInvoked: (p0) {},
          child: Column(
            children: [
              FormBuilderDateTimePicker(
                resetIcon: const Icon(Icons.clear),
                name: 'date',
                disablePicker: true,
                autofocus: true,
                autocorrect: true,
              ),
              FormBuilderChoiceChip<String>(
                name: 'choice_chip',
                options: const [
                  'Option 1',
                  'Option 2',
                  'Option 3',
                ].map((e) => FormBuilderChipOption(value: e)).toList(),
              ),
              FormBuilderFilterChip<String>(
                maxChips: 2,
                decoration: const InputDecoration(
                  labelText: 'The language of my people',
                  enabled: false,
                ),
                name: 'languages_filter',
                selectedColor: Colors.red,
                options: const [
                  FormBuilderChipOption(
                    value: 'Dart',
                    avatar: CircleAvatar(child: Text('D')),
                  ),
                  FormBuilderChipOption(
                    value: 'Kotlin',
                    avatar: CircleAvatar(child: Text('K')),
                  ),
                  FormBuilderChipOption(
                    value: 'Java',
                    avatar: CircleAvatar(child: Text('J')),
                  ),
                  FormBuilderChipOption(
                    value: 'Swift',
                    avatar: CircleAvatar(child: Text('S')),
                  ),
                  FormBuilderChipOption(
                    value: 'Objective-C',
                    avatar: CircleAvatar(child: Text('O')),
                  ),
                ],
              ),
              const SizedBox(height: 10),
              ElevatedButton(
                onPressed: () {
                  _formKey.currentState?.saveAndValidate();
                  debugPrint(_formKey.currentState?.value.toString());
                },
                child: const Text('Print'),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
