# console.dart examples

This package comes with a number of examples to demonstrate various features.

| Example | Description |
|---------|-------------|
| `alt_buffer.dart` | Switches between normal and alternative screen buffer. |
| `bar.dart` | Simple demonstration of DrawingCanvas for drawing a vertical bar. |
| `canvas.dart` | Shows use of ConsoleCanvas for character-based positioning. |
| `choice.dart` | Select a multiple choice option. |
| `clock.dart` | Sophisticated example of using DrawingCanvas to display a clock. |
| `colors.dart` | Setting colored output with the TextPen class. |
| `cube.dart` | Draws a 3D cube with DrawingCanvas. |
| `cursor.dart` | Shows use of cursor positioning operations. |
| `dart_quiz.dart` | Multiple choice quiz demonstrating various console features. |
| `demo.dart` | Shows basic console formatting options. |
| `drawing_canvas.dart` | Simple example of DrawingCanvas for a filled box. |
| `format.dart` | Shows use of custom formatting options for variables. |
| `keyboard.dart` | Traps up and down arrow and echos to console. |
| `loader.dart` | Demonstrates an indeterminate progress bar. |
| `progress.dart` | Demonstrates a determinate progress bar (e.g. download) |
| `prompt.dart` | Shows input fields for regular and secret text entry. |
| `shell.dart` | A simple REPL that echoes input text back to the console. |
| `timer.dart` | Example of a timer. |
| `window.dart` | Example of a full-screen window, as needed for a text editor. |