/*
 * Copyright (C) 2025 Vexzure
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

package com.kin.athena.service.firewall.utils

enum class Port(val port: Int, val serviceName: String) {
    TCPMUX(1, "tcpmux"),
    COMPRESSNET_1(2, "compressnet"),
    COMPRESSNET_2(3, "compressnet"),
    RJE(5, "rje"),
    ECHO(7, "echo"),
    DISCARD(9, "discard"),
    SYSTAT(11, "systat"),
    DAYTIME(13, "daytime"),
    QOTD(17, "qotd"),
    MSP(18, "msp"),
    CHARGEN(19, "chargen"),
    FTP_DATA(20, "ftp-data"),
    FTP(21, "ftp"),
    SSH(22, "ssh"),
    TELNET(23, "telnet"),
    SMTP(25, "smtp"),
    NSW_FE(27, "nsw-fe"),
    MSG_ICP(29, "msg-icp"),
    MSG_AUTH(31, "msg-auth"),
    DSP(33, "dsp"),
    TIME(37, "time"),
    RAP(38, "rap"),
    RLP(39, "rlp"),
    GRAPHICS(41, "graphics"),
    NAME(42, "name"),
    NICNAME(43, "nicname"),
    MPM_FLAGS(44, "mpm-flags"),
    MPM(45, "mpm"),
    MPM_SND(46, "mpm-snd"),
    NI_FTP(47, "ni-ftp"),
    AUDITD(48, "auditd"),
    TACACS(49, "tacacs"),
    RE_MAIL_CK(50, "re-mail-ck"),
    XNS_TIME(52, "xns-time"),
    DNS(53, "dns"),
    XNS_CH(54, "xns-ch"),
    ISI_GL(55, "isi-gl"),
    XNS_AUTH(56, "xns-auth"),
    XNS_MAIL(58, "xns-mail"),
    NI_MAIL(61, "ni-mail"),
    ACAS(62, "acas"),
    WHOISPP(63, "whoispp"),
    COVIA(64, "covia"),
    TACACS_DS(65, "tacacs-ds"),
    SQL_NET(66, "sql-net"),
    BOOTPS(67, "bootps"),
    BOOTPC(68, "bootpc"),
    TFTP(69, "tftp"),
    GOPHER(70, "gopher"),
    NETRJS_1(71, "netrjs-1"),
    NETRJS_2(72, "netrjs-2"),
    NETRJS_3(73, "netrjs-3"),
    NETRJS_4(74, "netrjs-4"),
    DEOS(76, "deos"),
    VETTCP(78, "vettcp"),
    FINGER(79, "finger"),
    HTTP(80, "http"),
    XFER(82, "xfer"),
    MIT_ML_DEV_1(83, "mit-ml-dev"),
    CTF(84, "ctf"),
    MIT_ML_DEV_2(85, "mit-ml-dev"),
    MFCOBOL(86, "mfcobol"),
    KERBEROS(88, "kerberos"),
    SU_MIT_TG(89, "su-mit-tg"),
    DNSIX(90, "dnsix"),
    MIT_DOV(91, "mit-dov"),
    NPP(92, "npp"),
    DCP(93, "dcp"),
    OBJCALL(94, "objcall"),
    SUPDUP(95, "supdup"),
    DIXIE(96, "dixie"),
    SWIFT_RVF(97, "swift-rvf"),
    TACNEWS(98, "tacnews"),
    METAGRAM(99, "metagram"),
    HOSTNAME(101, "hostname"),
    ISO_TSAP(102, "iso-tsap"),
    GPPITNP(103, "gppitnp"),
    ACR_NEMA(104, "acr-nema"),
    CSO(105, "cso"),
    TSMUX(106, "3com-tsmux"),
    RTELNET(107, "rtelnet"),
    SNAGAS(108, "snagas"),
    POP2(109, "pop2"),
    POP3(110, "pop3"),
    SUNRPC(111, "sunrpc"),
    MCIDAS(112, "mcidas"),
    IDENT(113, "ident"),
    SFTP(115, "sftp"),
    ANSANOTIFY(116, "ansanotify"),
    UUCP_PATH(117, "uucp-path"),
    SQLSERV(118, "sqlserv"),
    NNTP(119, "nntp"),
    CFDPTKT(120, "cfdptkt"),
    ERPC(121, "erpc"),
    SMAKYNET(122, "smakynet"),
    NTP(123, "ntp"),
    ANSATRADER(124, "ansatrader"),
    LOCUS_MAP(125, "locus-map"),
    NXEDIT(126, "nxedit"),
    LOCUS_CON(127, "locus-con"),
    GSS_XLICEN(128, "gss-xlicen"),
    PWDGEN(129, "pwdgen"),
    CISCO_FNA(130, "cisco-fna"),
    CISCO_TNA(131, "cisco-tna"),
    CISCO_SYS(132, "cisco-sys"),
    STATSRV(133, "statsrv"),
    INGRES_NET(134, "ingres-net"),
    EPMAP(135, "epmap"),
    PROFILE(136, "profile"),
    NETBIOS_NS(137, "netbios-ns"),
    NETBIOS_DGM(138, "netbios-dgm"),
    NETBIOS_SSN(139, "netbios-ssn"),
    EMFIS_DATA(140, "emfis-data"),
    EMFIS_CNTL(141, "emfis-cntl"),
    BL_IDM(142, "bl-idm"),
    IMAP(143, "imap"),
    UMA(144, "uma"),
    UAAC(145, "uaac"),
    ISO_TP0(146, "iso-tp0"),
    ISO_IP(147, "iso-ip"),
    JARGON(148, "jargon"),
    AED_512(149, "aed-512"),
    SQL_NET_2(150, "sql-net"),
    HEMS(151, "hems"),
    BFTP(152, "bftp"),
    SGMP(153, "sgmp"),
    NETSC_PROD(154, "netsc-prod"),
    NETSC_DEV(155, "netsc-dev"),
    SQLSRV(156, "sqlsrv"),
    KNET_CMP(157, "knet-cmp"),
    PCMAIL_SRV(158, "pcmail-srv"),
    NSS_ROUTING(159, "nss-routing"),
    SGMP_TRAPS(160, "sgmp-traps"),
    SNMP(161, "snmp"),
    SNMPTRAP(162, "snmptrap"),
    CMIP_MAN(163, "cmip-man"),
    CMIP_AGENT(164, "cmip-agent"),
    XNS_COURIER(165, "xns-courier"),
    S_NET(166, "s-net"),
    NAMP(167, "namp"),
    RSVD(168, "rsvd"),
    SEND(169, "send"),
    PRINT_SRV(170, "print-srv"),
    MULTIPLEX(171, "multiplex"),
    CL_1(172, "cl-1"),
    XYPLEX_MUX(173, "xyplex-mux"),
    MAILQ(174, "mailq"),
    VMNET(175, "vmnet"),
    GENRAD_MUX(176, "genrad-mux"),
    XDMCP(177, "xdmcp"),
    NEXTSTEP(178, "nextstep"),
    BGP(179, "bgp"),
    RIS(180, "ris"),
    UNIFY(181, "unify"),
    AUDIT(182, "audit"),
    OCBINDER(183, "ocbinder"),
    OCSERVER(184, "ocserver"),
    REMOTE_KIS(185, "remote-kis"),
    KIS(186, "kis"),
    ACI(187, "aci"),
    MUMPS(188, "mumps"),
    QFT(189, "qft"),
    GACP(190, "gacp"),
    PROSPERO(191, "prospero"),
    OSU_NMS(192, "osu-nms"),
    SRMP(193, "srmp"),
    IRC(194, "irc"),
    DN6_NLM_AUD(195, "dn6-nlm-aud"),
    DN6_SMM_RED(196, "dn6-smm-red"),
    DLS(197, "dls"),
    DLS_MON(198, "dls-mon"),
    SMUX(199, "smux"),
    SRC(200, "src"),
    AT_RTMP(201, "at-rtmp"),
    AT_NBP(202, "at-nbp"),
    AT_3(203, "at-3"),
    AT_ECHO(204, "at-echo"),
    AT_5(205, "at-5"),
    AT_ZIS(206, "at-zis"),
    AT_7(207, "at-7"),
    AT_8(208, "at-8"),
    QMTP(209, "qmtp"),
    Z39_50(210, "z39-50"),
    NINE14C_G(211, "914c-g"),
    ANET(212, "anet"),
    IPX(213, "ipx"),
    VMPWSCS(214, "vmpwscs"),
    SOFTPC(215, "softpc"),
    CAILIC(216, "CAIlic"),
    DBASE(217, "dbase"),
    MPP(218, "mpp"),
    UARPS(219, "uarps"),
    IMAP3(220, "imap3"),
    FLN_SPX(221, "fln-spx"),
    RSH_SPX(222, "rsh-spx"),
    CDC(223, "cdc"),
    MASQDIALER(224, "masqdialer"),
    DIRECT(242, "direct"),
    SUR_MEAS(243, "sur-meas"),
    INBUSINESS(244, "inbusiness"),
    LINK(245, "link"),
    DSP3270(246, "dsp3270"),
    SUBNTBCST_TFTP(247, "subntbcst-tftp"),
    BHFHS(248, "bhfhs"),
    RAP_2(256, "rap"),
    SET(257, "set"),
    ESRO_GEN(259, "esro-gen"),
    OPENPORT(260, "openport"),
    NSIIOPS(261, "nsiiops"),
    ARCISDMS(262, "arcisdms"),
    HDAP(263, "hdap"),
    BGMP(264, "bgmp"),
    X_BONE_CTL(265, "x-bone-ctl"),
    SST(266, "sst"),
    TD_SERVICE(267, "td-service"),
    TD_REPLICA(268, "td-replica"),
    MANET(269, "manet"),
    GIST(270, "gist"),
    PT_TLS(271, "pt-tls"),
    HTTP_MGMT(280, "http-mgmt"),
    PERSONAL_LINK(281, "personal-link"),
    CABLEPORT_AX(282, "cableport-ax"),
    RESCAP(283, "rescap"),
    CORERJD(284, "corerjd"),
    FXP(286, "fxp"),
    K_BLOCK(287, "k-block"),
    NOVASTORBAKCUP(308, "novastorbakcup"),
    ENTRUSTTIME(309, "entrusttime"),
    BHMDS(310, "bhmds"),
    ASIP_WEBADMIN(311, "asip-webadmin"),
    VSLMP(312, "vslmp"),
    MAGENTA_LOGIC(313, "magenta-logic"),
    OPALIS_ROBOT(314, "opalis-robot"),
    DPSI(315, "dpsi"),
    DECAUTH(316, "decauth"),
    ZANNET(317, "zannet"),
    PKIX_TIMESTAMP(318, "pkix-timestamp"),
    PTP_EVENT(319, "ptp-event"),
    PTP_GENERAL(320, "ptp-general"),
    PIP(321, "pip"),
    RTSPS(322, "rtsps"),
    RPKI_RTR(323, "rpki-rtr"),
    RPKI_RTR_TLS(324, "rpki-rtr-tls"),
    TEXAR(333, "texar"),
    PDAP(344, "pdap"),
    PAWSERV(345, "pawserv"),
    ZSERV(346, "zserv"),
    FATSERV(347, "fatserv"),
    CSI_SGWP(348, "csi-sgwp"),
    MFTP(349, "mftp"),
    MATIP_TYPE_A(350, "matip-type-a"),
    MATIP_TYPE_B(351, "matip-type-b"),
    DTAG_STE_SB(352, "dtag-ste-sb"),
    NDSAUTH(353, "ndsauth"),
    BH611(354, "bh611"),
    DATEX_ASN(355, "datex-asn"),
    CLOANTO_NET_1(356, "cloanto-net-1"),
    BHEVENT(357, "bhevent"),
    SHRINKWRAP(358, "shrinkwrap"),
    NSRMP(359, "nsrmp"),
    SCOI2ODIALOG(360, "scoi2odialog"),
    SEMANTIX(361, "semantix"),
    SRSSEND(362, "srssend"),
    RSVP_TUNNEL(363, "rsvp-tunnel"),
    AURORA_CMGR(364, "aurora-cmgr"),
    DTK(365, "dtk"),
    ODMR(366, "odmr"),
    MORTGAGEWARE(367, "mortgageware"),
    QBIKGDP(368, "qbikgdp"),
    RPC2PORTMAP(369, "rpc2portmap"),
    CODAAUTH2(370, "codaauth2"),
    CLEARCASE(371, "clearcase"),
    ULISTPROC(372, "ulistproc"),
    LEGENT_1(373, "legent-1"),
    LEGENT_2(374, "legent-2"),
    HASSLE(375, "hassle"),
    NIP(376, "nip"),
    TNETOS(377, "tnETOS"),
    DSETOS(378, "dsETOS"),
    IS99C(379, "is99c"),
    IS99S(380, "is99s"),
    HP_COLLECTOR(381, "hp-collector"),
    HP_MANAGED_NODE(382, "hp-managed-node"),
    HP_ALARM_MGR(383, "hp-alarm-mgr"),
    ARNS(384, "arns"),
    IBM_APP(385, "ibm-app"),
    ASA(386, "asa"),
    AURP(387, "aurp"),
    UNIDATA_LDM(388, "unidata-ldm"),
    LDAP(389, "ldap"),
    UIS(390, "uis"),
    SYNOTICS_RELAY(391, "synotics-relay"),
    SYNOTICS_BROKER(392, "synotics-broker"),
    META5(393, "meta5"),
    EMBL_NDT(394, "embl-ndt"),
    NETCP(395, "netcp"),
    NETWARE_IP(396, "netware-ip"),
    MPTN(397, "mptn"),
    KRYPTOLAN(398, "kryptolan"),
    ISO_TSAP_C2(399, "iso-tsap-c2"),
    OSB_SD(400, "osb-sd"),
    UPS(401, "ups"),
    GENIE(402, "genie"),
    DECAP(403, "decap"),
    NCED(404, "nced"),
    NCLD(405, "ncld"),
    IMSP(406, "imsp"),
    TIMBUKTU(407, "timbuktu"),
    PRM_SM(408, "prm-sm"),
    PRM_NM(409, "prm-nm"),
    DECLADEBUG(410, "decladebug"),
    RMT(411, "rmt"),
    SYNOPTICS_TRAP(412, "synoptics-trap"),
    SMSP(413, "smsp"),
    INFOSEEK(414, "infoseek"),
    BNET(415, "bnet"),
    SILVERPLATTER(416, "silverplatter"),
    ONMUX(417, "onmux"),
    HYPER_G(418, "hyper-g"),
    ARIEL1(419, "ariel1"),
    SMPTE(420, "smpte"),
    ARIEL2(421, "ariel2"),
    ARIEL3(422, "ariel3"),
    OPC_JOB_START(423, "opc-job-start"),
    OPC_JOB_TRACK(424, "opc-job-track"),
    ICAD_EL(425, "icad-el"),
    SMARTSDP(426, "smartsdp"),
    SVRLOC(427, "svrloc"),
    OCS_CMU(428, "ocs-cmu"),
    OCS_AMU(429, "ocs-amu"),
    UTMPSD(430, "utmpsd"),
    UTMPCD(431, "utmpcd"),
    IASD(432, "iasd"),
    NNSP(433, "nnsp"),
    MOBILEIP_AGENT(434, "mobileip-agent"),
    MOBILIP_MN(435, "mobilip-mn"),
    DNA_CML(436, "dna-cml"),
    COMSCM(437, "comscm"),
    DSFGW(438, "dsfgw"),
    DASP(439, "dasp"),
    SGCP(440, "sgcp"),
    DECVMS_SYSMGT(441, "decvms-sysmgt"),
    CVC_HOSTD(442, "cvc-hostd"),
    HTTPS(443, "https"),
    SNPP(444, "snpp"),
    MICROSOFT_DS(445, "microsoft-ds"),
    DDM_RDB(446, "ddm-rdb"),
    DDM_DFM(447, "ddm-dfm"),
    DDM_SSL(448, "ddm-ssl"),
    AS_SERVERMAP(449, "as-servermap"),
    TSERVER(450, "tserver"),
    SFS_SMP_NET(451, "sfs-smp-net"),
    SFS_CONFIG(452, "sfs-config"),
    CREATIVESERVER(453, "creativeserver"),
    CONTENTSERVER(454, "contentserver"),
    CREATIVEPARTNR(455, "creativepartnr"),
    MACON_TCP(456, "macon-tcp"),
    SCOHELP(457, "scohelp"),
    APPLEQTC(458, "appleqtc"),
    AMPR_RCMD(459, "ampr-rcmd"),
    SKRONK(460, "skronk"),
    DATASURFSRV(461, "datasurfsrv"),
    DATASURFSRVSEC(462, "datasurfsrvsec"),
    ALPES(463, "alpes"),
    KPASSWD(464, "kpasswd"),
    URD(465, "urd"),
    DIGITAL_VRC(466, "digital-vrc"),
    MYLEX_MAPD(467, "mylex-mapd"),
    PHOTURIS(468, "photuris"),
    RCP(469, "rcp"),
    SCX_PROXY(470, "scx-proxy"),
    MONDEX(471, "mondex"),
    LJK_LOGIN(472, "ljk-login"),
    HYBRID_POP(473, "hybrid-pop"),
    TN_TL_W1(474, "tn-tl-w1"),
    TCPNETHASPSRV(475, "tcpnethaspsrv"),
    TN_TL_FD1(476, "tn-tl-fd1"),
    SS7NS(477, "ss7ns"),
    SPSC(478, "spsc"),
    IAFSERVER(479, "iafserver"),
    IAFDBASE(480, "iafdbase"),
    PH(481, "ph"),
    BGS_NSI(482, "bgs-nsi"),
    ULPNET(483, "ulpnet"),
    INTEGRA_SME(484, "integra-sme"),
    POWERBURST(485, "powerburst"),
    AVIAN(486, "avian"),
    SAFT(487, "saft"),
    GSS_HTTP(488, "gss-http"),
    NEST_PROTOCOL(489, "nest-protocol"),
    MICOM_PFS(490, "micom-pfs"),
    GO_LOGIN(491, "go-login"),
    TICF_1(492, "ticf-1"),
    TICF_2(493, "ticf-2"),
    POV_RAY(494, "pov-ray"),
    INTECOURIER(495, "intecourier"),
    PIM_RP_DISC(496, "pim-rp-disc"),
    RETROSPECT(497, "retrospect"),
    SIAM(498, "siam"),
    ISO_ILL(499, "iso-ill"),
    ISAKMP(500, "isakmp"),
    STMF(501, "stmf"),
    MBAP(502, "mbap"),
    INTRINSA(503, "intrinsa"),
    CITADEL(504, "citadel"),
    MAILBOX_LM(505, "mailbox-lm"),
    OHIMSRV(506, "ohimsrv"),
    CRS(507, "crs"),
    XVTTP(508, "xvttp"),
    SNARE(509, "snare"),
    FCP(510, "fcp"),
    PASSGO(511, "passgo"),
    EXEC(512, "exec"),
    LOGIN(513, "login"),
    SHELL(514, "shell"),
    PRINTER(515, "printer"),
    VIDEOTEX(516, "videotex"),
    TALK(517, "talk"),
    NTALK(518, "ntalk"),
    UTIME(519, "utime"),
    EFS(520, "efs"),
    RIPNG(521, "ripng"),
    ULP(522, "ulp"),
    IBM_DB2(523, "ibm-db2"),
    NCP(524, "ncp"),
    TIMED(525, "timed"),
    TEMPO(526, "tempo"),
    STX(527, "stx"),
    CUSTIX(528, "custix"),
    IRC_SERV(529, "irc-serv"),
    COURIER(530, "courier"),
    CONFERENCE(531, "conference"),
    NETNEWS(532, "netnews"),
    NETWALL(533, "netwall"),
    WINDREAM(534, "windream"),
    IIOP(535, "iiop"),
    OPALIS_RDV(536, "opalis-rdv"),
    NMSP(537, "nmsp"),
    GDOMAP(538, "gdomap"),
    APERTUS_LDP(539, "apertus-ldp"),
    UUCP(540, "uucp"),
    UUCP_RLOGIN(541, "uucp-rlogin"),
    COMMERCE(542, "commerce"),
    KLOGIN(543, "klogin"),
    KSHELL(544, "kshell"),
    APPLEQTCSRVR(545, "appleqtcsrvr"),
    DHCPV6_CLIENT(546, "dhcpv6-client"),
    DHCPV6_SERVER(547, "dhcpv6-server"),
    AFPOVERTCP(548, "afpovertcp"),
    IDFP(549, "idfp"),
    NEW_RWHO(550, "new-rwho"),
    CYBERCASH(551, "cybercash"),
    DEVSHR_NTS(552, "devshr-nts"),
    PIRP(553, "pirp"),
    RTSP(554, "rtsp"),
    DSF(555, "dsf"),
    REMOTEFS(556, "remotefs"),
    OPENVMS_SYSIPC(557, "openvms-sysipc"),
    SDNSKMP(558, "sdnskmp"),
    TEEDTAP(559, "teedtap"),
    RMONITOR(560, "rmonitor"),
    MONITOR(561, "monitor"),
    CHSHELL(562, "chshell"),
    NNTPS(563, "nntps"),
    NINE_PFS(564, "9pfs"),
    WHOAMI(565, "whoami"),
    STREETTALK(566, "streettalk"),
    BANYAN_RPC(567, "banyan-rpc"),
    MS_SHUTTLE(568, "ms-shuttle"),
    MS_ROME(569, "ms-rome"),
    METER_1(570, "meter"),
    METER_2(571, "meter"),
    SONAR(572, "sonar"),
    BANYAN_VIP(573, "banyan-vip"),
    FTP_AGENT(574, "ftp-agent"),
    VEMMI(575, "vemmi"),
    IPCD(576, "ipcd"),
    VNAS(577, "vnas"),
    IPDD(578, "ipdd"),
    DECBSRV(579, "decbsrv"),
    SNTP_HEARTBEAT(580, "sntp-heartbeat"),
    BDP(581, "bdp"),
    SCC_SECURITY(582, "scc-security"),
    PHILIPS_VC(583, "philips-vc"),
    KEYSERVER(584, "keyserver"),
    PASSWORD_CHG(586, "password-chg"),
    SUBMISSION(587, "submission"),
    CAL(588, "cal"),
    EYELINK(589, "eyelink"),
    TNS_CML(590, "tns-cml"),
    HTTP_ALT(591, "http-alt"),
    EUDORA_SET(592, "eudora-set"),
    HTTP_RPC_EPMAP(593, "http-rpc-epmap"),
    TPIP(594, "tpip"),
    CAB_PROTOCOL(595, "cab-protocol"),
    SMSD(596, "smsd"),
    PTCNAMESERVICE(597, "ptcnameservice"),
    SCO_WEBSRVRMG3(598, "sco-websrvrmg3"),
    ACP(599, "acp"),
    IPCSERVER(600, "ipcserver"),
    SYSLOG_CONN(601, "syslog-conn"),
    XMLRPC_BEEP(602, "xmlrpc-beep"),
    IDXP(603, "idxp"),
    TUNNEL(604, "tunnel"),
    SOAP_BEEP(605, "soap-beep"),
    URM(606, "urm"),
    NQS(607, "nqs"),
    SIFT_UFT(608, "sift-uft"),
    NPMP_TRAP(609, "npmp-trap"),
    NPMP_LOCAL(610, "npmp-local"),
    NPMP_GUI(611, "npmp-gui"),
    HMMP_IND(612, "hmmp-ind"),
    HMMP_OP(613, "hmmp-op"),
    SSHELL(614, "sshell"),
    SCO_INETMGR(615, "sco-inetmgr"),
    SCO_SYSMGR(616, "sco-sysmgr"),
    SCO_DTMGR(617, "sco-dtmgr"),
    DEI_ICDA(618, "dei-icda"),
    COMPAQ_EVM(619, "compaq-evm"),
    SCO_WEBSRVRMGR(620, "sco-websrvrmgr"),
    ESCP_IP(621, "escp-ip"),
    COLLABORATOR(622, "collaborator"),
    OOB_WS_HTTP(623, "oob-ws-http"),
    CRYPTOADMIN(624, "cryptoadmin"),
    DEC_DLM(625, "dec-dlm"),
    ASIA(626, "asia"),
    PASSGO_TIVOLI(627, "passgo-tivoli"),
    QMQP(628, "qmqp"),
    THREEC_AMP3(629, "3com-amp3"),
    RDA(630, "rda"),
    IPP(631, "ipp"),
    BMPP(632, "bmpp"),
    SERVSTAT(633, "servstat"),
    GINAD(634, "ginad"),
    RLZDBASE(635, "rlzdbase"),
    LDAPS(636, "ldaps"),
    LANSERVER(637, "lanserver"),
    MCNS_SEC(638, "mcns-sec"),
    MSDP(639, "msdp"),
    ENTRUST_SPS(640, "entrust-sps"),
    REPCMD(641, "repcmd"),
    ESRO_EMSDP(642, "esro-emsdp"),
    SANITY(643, "sanity"),
    DWR(644, "dwr"),
    PSSC(645, "pssc"),
    LDP(646, "ldp"),
    DHCP_FAILOVER(647, "dhcp-failover"),
    RRP(648, "rrp"),
    CADVIEW_3D(649, "cadview-3d"),
    OBEX(650, "obex"),
    IEEE_MMS(651, "ieee-mms"),
    HELLO_PORT(652, "hello-port"),
    REPSCMD(653, "repscmd"),
    AODV(654, "aodv"),
    TINC(655, "tinc"),
    SPMP(656, "spmp"),
    RMC(657, "rmc"),
    TENFOLD(658, "tenfold"),
    MAC_SRVR_ADMIN(660, "mac-srvr-admin"),
    HAP(661, "hap"),
    PFTP(662, "pftp"),
    PURENOISE(663, "purenoise"),
    OOB_WS_HTTPS(664, "oob-ws-https"),
    SUN_DR(665, "sun-dr"),
    MDQS(666, "mdqs"),
    DISCLOSE(667, "disclose"),
    MECOMM(668, "mecomm"),
    MEREGISTER(669, "meregister"),
    VACDSM_SWS(670, "vacdsm-sws"),
    VACDSM_APP(671, "vacdsm-app"),
    VPPS_QUA(672, "vpps-qua"),
    CIMPLEX(673, "cimplex"),
    ACAP(674, "acap"),
    DCTP(675, "dctp"),
    VPPS_VIA(676, "vpps-via"),
    VPP(677, "vpp"),
    GGF_NCP(678, "ggf-ncp"),
    MRM(679, "mrm"),
    ENTRUST_AAAS(680, "entrust-aaas"),
    ENTRUST_AAMS(681, "entrust-aams"),
    XFR(682, "xfr"),
    CORBA_IIOP(683, "corba-iiop"),
    CORBA_IIOP_SSL(684, "corba-iiop-ssl"),
    MDC_PORTMAPPER(685, "mdc-portmapper"),
    HCP_WISMAR(686, "hcp-wismar"),
    ASIPREGISTRY(687, "asipregistry"),
    REALM_RUSD(688, "realm-rusd"),
    NMAP(689, "nmap"),
    VATP(690, "vatp"),
    MSEXCH_ROUTING(691, "msexch-routing"),
    HYPERWAVE_ISP(692, "hyperwave-isp"),
    CONNENDP(693, "connendp"),
    HA_CLUSTER(694, "ha-cluster"),
    IEEE_MMS_SSL(695, "ieee-mms-ssl"),
    RUSHD(696, "rushd"),
    UUIDGEN(697, "uuidgen"),
    OLSR(698, "olsr"),
    ACCESSNETWORK(699, "accessnetwork"),
    EPP(700, "epp"),
    LMP(701, "lmp"),
    IRIS_BEEP(702, "iris-beep"),
    ELCSD(704, "elcsd"),
    AGENTX(705, "agentx"),
    SILC(706, "silc"),
    BORLAND_DSJ(707, "borland-dsj"),
    ENTRUST_KMSH(709, "entrust-kmsh"),
    ENTRUST_ASH(710, "entrust-ash"),
    CISCO_TDP(711, "cisco-tdp"),
    TBRPF(712, "tbrpf"),
    IRIS_XPC(713, "iris-xpc"),
    IRIS_XPCS(714, "iris-xpcs"),
    IRIS_LWZ(715, "iris-lwz"),
    PANA(716, "pana"),
    NETVIEWDM1(729, "netviewdm1"),
    NETVIEWDM2(730, "netviewdm2"),
    NETVIEWDM3(731, "netviewdm3"),
    NETGW(741, "netgw"),
    NETRCS(742, "netrcs"),
    FLEXLM(744, "flexlm"),
    FUJITSU_DEV(747, "fujitsu-dev"),
    RIS_CM(748, "ris-cm"),
    KERBEROS_ADM(749, "kerberos-adm"),
    RFILE(750, "rfile"),
    PUMP(751, "pump"),
    QRH(752, "qrh"),
    RRH(753, "rrh"),
    TELL(754, "tell"),
    NLOGIN(758, "nlogin"),
    CON(759, "con"),
    NS(760, "ns"),
    RXE(761, "rxe"),
    QUOTAD(762, "quotad"),
    CYCLESERV(763, "cycleserv"),
    OMSERV(764, "omserv"),
    WEBSTER(765, "webster"),
    PHONEBOOK(767, "phonebook"),
    VID(769, "vid"),
    CADLOCK(770, "cadlock"),
    RTIP(771, "rtip"),
    CYCLESERV2(772, "cycleserv2"),
    SUBMIT(773, "submit"),
    RPASSWD(774, "rpasswd"),
    ENTOMB(775, "entomb"),
    WPAGES(776, "wpages"),
    MULTILING_HTTP(777, "multiling-http"),
    WPGS(780, "wpgs"),
    MDBS_DAEMON(800, "mdbs-daemon"),
    DEVICE(801, "device"),
    MBAP_S(802, "mbap-s"),
    FCP_UDP(810, "fcp-udp"),
    ITM_MCELL_S(828, "itm-mcell-s"),
    PKIX_3_CA_RA(829, "pkix-3-ca-ra"),
    NETCONF_SSH(830, "netconf-ssh"),
    NETCONF_BEEP(831, "netconf-beep"),
    NETCONFSOAPHTTP(832, "netconfsoaphttp"),
    NETCONFSOAPBEEP(833, "netconfsoapbeep"),
    DHCP_FAILOVER2(847, "dhcp-failover2"),
    GDOI(848, "gdoi"),
    SECURE_DNS(853, "secure-dns"),
    ISCSI(860, "iscsi"),
    OWAMP_CONTROL(861, "owamp-control"),
    TWAMP_CONTROL(862, "twamp-control"),
    RSYNC(873, "rsync"),
    ICLCNET_LOCATE(886, "iclcnet-locate"),
    ICLCNET_SVINFO(887, "iclcnet-svinfo"),
    ACCESSBUILDER(888, "accessbuilder"),
    OMGINITIALREFS(900, "omginitialrefs"),
    SMPNAMERES(901, "smpnameres"),
    IDEAFARM_DOOR(902, "ideafarm-door"),
    IDEAFARM_PANIC(903, "ideafarm-panic"),
    KINK(910, "kink"),
    XACT_BACKUP(911, "xact-backup"),
    APEX_MESH(912, "apex-mesh"),
    APEX_EDGE(913, "apex-edge"),
    FTPS_DATA(989, "ftps-data"),
    FTPS(990, "ftps"),
    NAS(991, "nas"),
    TELNETS(992, "telnets"),
    IMAPS(993, "imaps"),
    POP3S(995, "pop3s"),
    VSINET(996, "vsinet"),
    MAITRD(997, "maitrd"),
    BUSBOY(998, "busboy"),
    GARCON(999, "garcon"),
    CADLOCK2(1000, "cadlock2"),
    WEBPUSH(1001, "webpush"),
    SURF(1010, "surf"),
    EXP1(1021, "exp1"),
    EXP2(1022, "exp2"),
    MDNS(5353, "MDNS");

    companion object {
        fun getServiceName(port: Int): String? {
            return values().find { it.port == port }?.serviceName
        }
    }
}
