package com.junkfood.seal.ui.svg

const val LoveSVG = """<svg xmlns="http://www.w3.org/2000/svg"
    width="524.67"
    height="393"
    viewBox="0 0 524.67 393">
    <polygon
        points="146.06 297.5 116.45 300.72 102.28 291.06 94.08 300.72 98.02 321.1 102.52 337.19 129.85 323.31 151.86 321.32 146.06 297.5"
        fill="#a0616a" />
    <polygon
        points="296.09 263.37 224.62 262.08 137.69 298.78 149.28 323.9 227.84 302 349.53 336.77 332.79 254.36 296.09 263.37"
        fill="#2f2e41" />
    <path
        d="m100.05,299.84l14.21-1.11-18.07-38.17s-8.37-2.96-9.66,6.25c-1.29,9.2,9.7,71.53,12.92,71.53s14.02-6.3,14.02-6.3l-15.99-30.27,2.58-1.93s0,0,0,0Z"
        fill="#2f2e41" />
    <path
        d="m456.35,289.39c-1.43.15-2.99.38-4.65.72-7.04,1.43-7.18,6.21-7.12,7.3l-.05-.03c-.71,1.13-1.15,2.28-1.42,3.37l-.32-14.64c.21-.43.4-.93.56-1.43.53,1.62,1.39,3.15,2.13,3.05.97-.13,1.39-2.98,1.21-5,1.23,1.58,3.3,3.28,4.08,2.76.62-.42.25-2.14-.43-3.7,1.42.86,2.99,1.42,3.48.87.67-.74-.93-3.27-2.4-4.68,1.97.18,4.48-.13,4.64-1.03.14-.74-1.36-1.67-2.95-2.27,1.6-.42,3.1-1.16,3.05-1.89-.06-.87-2.28-1.45-4.2-1.53,1.45-1.13,2.78-2.7,2.37-3.41-.37-.65-2.11-.4-3.72.17.95-1.36,1.62-2.89,1.11-3.41-.63-.65-2.88.47-4.42,1.72.3-1.94.15-4.39-.72-4.61-.73-.19-1.76,1.24-2.47,2.79-.31-1.63-.95-3.17-1.68-3.17-1.04,0-1.88,3.14-1.88,5.18,0,.12,0,.22,0,.33-.1-.12-.22-.25-.36-.38-1.47-1.42-4.3-3-5.03-2.26-.51.52.16,2.05,1.11,3.41-1.61-.57-3.35-.83-3.72-.17-.5.88,1.65,3.06,3.39,4.12-.1-.01-.22-.02-.33-.03-2.04-.14-5.23.49-5.3,1.53-.05.73,1.45,1.47,3.05,1.89-1.6.6-3.09,1.53-2.95,2.27.16.9,2.67,1.21,4.64,1.03-1.47,1.41-3.07,3.94-2.4,4.68.49.54,2.06-.02,3.48-.87-.68,1.56-1.05,3.28-.43,3.7.82.55,3.09-1.37,4.28-3.02-.12,2.02.36,4.8,1.32,4.91.4.05.83-.38,1.21-1.04l-1.09,15.74c-.25,1.83,1.37,3.03,1.52,3.78l.23,10.66c-.26-.76-.62-1.54-1.1-2.31l-.05.03c.06-1.1-.08-5.87-7.12-7.3-1.66-.34-3.22-.57-4.65-.72-1.69-.18-2.35,2.13-.82,2.88,2.21,1.08,4.29,2.44,5.37,4.05,2.77,4.12,6.59,1.74,7.14,1.37.61,1.01,1.01,2.03,1.26,3l.12,5.66c-.03.13-.05.21-.05.21l.06.02.3,13.7,2.8-.02-1-14c.17-.76.69-3.33,0-6l-1-11h0s.06.29,0,0l-1.3-4.32c.19-1.34.63-2.84,1.52-4.33.54.37,4.37,2.75,7.14-1.37,1.08-1.61,3.16-2.97,5.37-4.05,1.52-.75.87-3.06-.82-2.88h0Zm-12.77,32.41l-.05-2.4c.11.91.1,1.72.05,2.4Z"
        fill="#f2f2f2" />
    <path
        d="m0,337.11c0,.66.53,1.19,1.19,1.19h522.29c.66,0,1.19-.53,1.19-1.19s-.53-1.19-1.19-1.19H1.19c-.66,0-1.19.53-1.19,1.19Z"
        fill="#3f3d56" />
    <polygon
        points="346.55 177.51 353.64 153.69 374.24 153.04 382.61 182.66 346.55 177.51"
        fill="#a0616a" />
    <polygon
        points="346.55 177.51 353.64 153.69 374.24 153.04 382.61 182.66 346.55 177.51"
        isolation="isolate"
        opacity=".1" />
    <path
        d="m378.18,174.19l-33.48-1.29-10.38,21.35-16.02,94.55,84.03,18.99s5.15-105.6-6.44-120.41-17.71-13.2-17.71-13.2h0Z"
        fill="#e6e6e6" />
    <g>
        <path
            id="uuid-6491ea2e-b6df-4d87-9577-65b18a9d314e-134"
            d="m280.12,100.15c-1.4-7.45-6.37-12.78-11.12-11.89s-7.46,7.65-6.06,15.11c.52,2.99,1.74,5.8,3.57,8.22l6.31,31.51,12.45-2.53-5.52-31.46c.83-2.92.95-5.99.35-8.96Z"
            fill="#a0616a" />
        <polygon
            points="373.17 182.77 304.79 169.3 285.57 111.5 264.04 116.6 285.64 201.98 363.04 212.16 373.17 182.77"
            fill="#e6e6e6" />
    </g>
    <path
        d="m269.03,7.57h0c-.07.07-.13.13-.2.2-10.35-10.28-27.03-10.37-37.5-.2h0c-10.5,10.2-10.86,26.95-.8,37.59h0s.25.26.25.26h0l37.05,38.15,38.41-37.3-.11-.11c.06-.06.13-.12.2-.18h0c10.61-10.3,10.85-27.25.55-37.85h0c-10.3-10.61-27.25-10.85-37.85-.55,0,0,0,0,0,0Z"
        fill="p80" />
    <path
        d="m278.19,196.77h0c-.12.12-.24.25-.36.37-19.07-18.92-49.78-19.09-69.06-.37h0c-19.34,18.79-20,49.64-1.47,69.23h-.01s.46.49.46.49h0l68.24,70.26,70.73-68.7-.2-.2c.12-.11.24-.22.36-.33h0c19.53-18.97,19.99-50.18,1.02-69.72h0c-18.97-19.53-50.18-19.99-69.72-1.02h0Z"
        fill="p80" />
    <path
        d="m382.52,275.08s25.27,21.05,15.89,33.82c-9.37,12.77-41.25,35.63-55.65,28.54s-44.29-58.33-44.29-58.33l-7.82,52.49-20.46-1.81s-14.86-74.14-1.16-85.51c13.71-11.37,76.11,8.73,76.11,8.73l37.37,22.08h0s0,0,0,0Z"
        fill="#2f2e41" />
    <polygon
        points="275.3 322.82 269.44 341.03 257.23 358.14 266.59 372.15 296.34 352.56 296.24 342.48 291.57 336.19 288.27 324.13 275.3 322.82"
        fill="#a0616a" />
    <path
        d="m265.94,365.25l-7.47-12.14-25.72,33.49s1.19,8.8,9.97,5.74,63.21-30.96,61.74-33.83-7.5-18.29-7.5-18.29l-28.12,26.43-2.89-1.41h0Z"
        fill="#2f2e41" />
    <g>
        <path
            id="uuid-c0c993a8-d454-4668-92ed-b9c18bfd3ed5-135"
            d="m281.73,274.91c-7.55.75-13.28,5.25-12.8,10.05s6.98,8.09,14.53,7.34c3.02-.26,5.93-1.24,8.5-2.85l31.93-3.57-1.45-12.62-31.82,2.79c-2.83-1.08-5.88-1.47-8.89-1.13Z"
            fill="#a0616a" />
        <polygon
            points="372.07 189.33 352.75 256.29 293.51 270.45 296.73 292.35 383.66 278.18 400.47 201.95 372.07 189.33"
            fill="#e6e6e6" />
    </g>
    <g>
        <circle
            cx="361.32"
            cy="133.46"
            r="27.36"
            fill="#a0616a" />
        <path
            d="m363.5,96.67c-.79.46-1.85-.24-2.11-1.12-.25-.88.04-1.82.34-2.68.49-1.46.98-2.92,1.48-4.37,1.05-3.1,2.16-6.31,4.43-8.67,3.42-3.56,8.86-4.47,13.76-3.81,6.29.84,12.49,4.25,15.42,9.88,2.92,5.63,1.68,13.49-3.6,17,7.53,8.63,10.15,18.25,9.74,29.69-.41,11.45-12.89,21.98-21.02,30.04-1.82-1.1-3.47-6.26-2.47-8.14,1-1.87-.43-4.05.8-5.77s2.27,1.02,1.02-.69c-.79-1.08,2.29-3.58,1.12-4.22-5.67-3.14-7.56-10.21-11.13-15.63-4.3-6.53-11.66-10.96-19.44-11.69-4.29-.4-8.82.33-12.33,2.82-3.52,2.49-5.79,6.94-4.98,11.17-2.11-2.14-3.16-5.29-2.77-8.27.4-2.98,2.23-5.74,4.83-7.26-1.58-5.22-.23-11.23,3.44-15.27s18.54-3.35,23.89-2.29l-.41-.71s0,0,0,0Z"
            fill="#2f2e41" />
        <path
            d="m364.34,116.64c7.09.77,12.21,6.91,16.53,12.58,2.49,3.27,5.1,6.88,5.04,10.99-.06,4.15-2.84,7.72-4.17,11.66-2.17,6.44-.06,14.09,5.11,18.5-5.1.97-10.62-2.86-11.5-7.98-1.03-5.96,3.49-11.71,2.96-17.74-.47-5.31-4.65-9.39-8.21-13.36-3.56-3.97-6.89-9.23-5.26-14.3l-.5-.34s0,0,0,0Z"
            fill="#2f2e41" />
    </g>
</svg>"""

const val PaletteSVG = """<svg xmlns="http://www.w3.org/2000/svg"
    data-name="Layer 1"
    width="100%"
    height="100%"
    viewBox="0 0 1114.7054 767.3912">
    <title>swatches</title>
    <path
        d="M386.0487,401.15363c0,129.31047-76.873,174.46086-171.7007,174.46086S42.6473,530.4641,42.6473,401.15363,214.348,107.33985,214.348,107.33985,386.0487,271.84316,386.0487,401.15363Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#f2f2f2" />
    <polygon
        points="165.446 489.53 167.204 381.308 240.387 247.423 167.48 364.332 168.27 315.671 218.708 218.806 168.48 302.794 168.48 302.794 169.901 215.275 223.911 138.159 170.125 201.513 171.013 41.035 165.431 253.479 165.889 244.715 110.977 160.663 165.009 261.539 159.892 359.282 159.74 356.687 96.436 268.235 159.548 365.852 158.908 378.076 158.794 378.26 158.846 379.264 145.865 627.246 163.209 627.246 165.29 499.158 228.247 401.78 165.446 489.53"
        fill="#3f3d56" />
    <path
        d="M1157.3527,709.6956c0,44.73506-230.12564,124-514,124s-514-79.26494-514-124,230.12564-38,514-38S1157.3527,664.96053,1157.3527,709.6956Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#3f3d56" />
    <path
        d="M1157.3527,709.6956c0,44.73506-230.12564,124-514,124s-514-79.26494-514-124,230.12564-38,514-38S1157.3527,664.96053,1157.3527,709.6956Z"
        transform="translate(-42.6473 -66.3044)"
        opacity="0.1" />
    <ellipse
        cx="600.7054"
        cy="643.3912"
        rx="514"
        ry="81"
        fill="#3f3d56" />
    <ellipse
        cx="619.4014"
        cy="654.89052"
        rx="122"
        ry="25.5"
        opacity="0.1" />
    <circle
        cx="480.39723"
        cy="96.06285"
        r="48.55464"
        fill="s90" />
    <circle
        cx="386.56093"
        cy="83.01246"
        r="15.49616"
        fill="s90"
        opacity="0.3" />
    <circle
        cx="408.55487"
        cy="49.25521"
        r="15.49616"
        fill="s90"
        opacity="0.5" />
    <circle
        cx="430.54882"
        cy="15.49796"
        r="15.49616"
        fill="s80" />
    <circle
        cx="430.54882"
        cy="15.49796"
        r="15.49616"
        fill="#fff"
        opacity="0.3" />
    <circle
        cx="479.22622"
        cy="329.54006"
        r="48.55464"
        fill="p80" />
    <circle
        cx="443.21837"
        cy="417.16996"
        r="15.49616"
        fill="p80"
        opacity="0.3" />
    <circle
        cx="416.00195"
        cy="387.46217"
        r="15.49616"
        fill="p80"
        opacity="0.5" />
    <circle
        cx="388.78554"
        cy="357.75438"
        r="15.49616"
        fill="p80" />
    <circle
        cx="388.78554"
        cy="357.75438"
        r="15.49616"
        fill="#fff"
        opacity="0.3" />
    <path
        d="M600.13444,661.53373s-.29625,17.33087-1.77752,21.92281,0,10.36889,0,10.36889l-5.62883,14.81271h19.99715s4.74007-21.62655,4.74007-23.55221-2.81441-18.21963-2.81441-18.21963Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#ffb9b9" />
    <path
        d="M615.53966,707.45312s-5.03632-13.77581-26.36662,0c0,0-8.44325,12.44268-3.70318,16.294s12.88706,9.03575,19.7009,6.07321,9.48014-6.22133,10.3689-12.29454A30.52275,30.52275,0,0,0,615.53966,707.45312Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#2f2e41" />
    <path
        d="M707.971,661.53373s.29626,17.33087,1.77753,21.92281,0,10.36889,0,10.36889l5.62883,14.81271H695.38015s-4.74006-21.62655-4.74006-23.55221,2.81441-18.21963,2.81441-18.21963Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#ffb9b9" />
    <path
        d="M692.56574,707.45312s5.03632-13.77581,26.36662,0c0,0,8.44324,12.44268,3.70318,16.294s-12.88706,9.03575-19.70091,6.07321-9.48013-6.22133-10.36889-12.29454A30.52275,30.52275,0,0,1,692.56574,707.45312Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#2f2e41" />
    <path
        d="M595.09812,335.06165s14.51645,19.99716,16.294,26.36662,12.88706,5.777,12.14642,0-20.14528-36.73552-20.14528-36.73552Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#ffb9b9" />
    <path
        d="M712.41477,328.54406s-20.44154,34.66173-15.25709,38.513S722.043,336.83917,722.043,336.83917Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#ffb9b9" />
    <path
        d="M693.30637,355.65131h-33.773c-6.22134,0-26.66287,1.6294-29.92167,0S614.20651,354.17,614.20651,354.17s-24.73722,56.58455-18.0715,101.76331-14.07207,201.45282-4.29568,206.19289,18.51588,10.66515,26.95912,10.9614,24.14472-3.40692,25.92224-5.92508,10.517-222.04249,10.517-222.04249,3.11067,216.56179,8.88763,221.45,22.36719,8.147,32.73608,6.51759,21.03405-7.40635,23.10783-11.25766S712.711,549.2534,712.711,549.2534s14.36833-166.93921-9.332-187.82513Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#2f2e41" />
    <path
        d="M643.6838,183.67578s7.40636,24.29284-7.25822,31.25481,12.5908,63.69464,12.5908,63.69464,38.06866-48.73381,38.06866-59.399l-6.36947-6.36946s-12.44267-20.88592-8.59137-27.40351S643.6838,183.67578,643.6838,183.67578Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#ffb9b9" />
    <path
        d="M643.6838,183.67578s7.40636,24.29284-7.25822,31.25481,12.5908,63.69464,12.5908,63.69464,38.06866-48.73381,38.06866-59.399l-6.36947-6.36946s-12.44267-20.88592-8.59137-27.40351S643.6838,183.67578,643.6838,183.67578Z"
        transform="translate(-42.6473 -66.3044)"
        opacity="0.1" />
    <path
        d="M654.49708,266.47881s-8.88763-23.256-7.85074-31.99545-1.42761-23.02913-5.23168-23.43879-42.90962,12.32926-46.909,14.99555-7.55448,56.8808-7.55448,56.8808l17.479,40.29056s1.48127,33.03234,9.77638,34.51361,86.65434,5.62883,89.17251,2.81442,28.29227-79.69237,28.29227-79.69237l5.777-45.03063S730.19,226.78076,722.48741,224.707s-32.588-10.96141-35.40237-11.25766-11.702,1.33314-12.44268,3.99943S654.49708,266.47881,654.49708,266.47881Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#d0cde1" />
    <circle
        cx="616.96016"
        cy="102.4846"
        r="30.36605"
        fill="#ffb9b9" />
    <path
        d="M670.06533,112.65289c-5.68457-6.85811-17.30315-7.59963-23.81344-1.51982-1.75535,1.63928-3.14023,3.654-4.97182,5.20759a23.40678,23.40678,0,0,1-5.86506,3.377c-6.94327,3.03968-14.31634,5.1996-20.79272,9.13726s-12.15138,10.16895-12.95358,17.70585c-.42428,3.98622.53622,8.06-.193,12.0019-1.143,6.17888-6.107,10.78874-10.26257,15.50214-3.94746,4.47732-7.49927,10.85881-4.67534,16.11755,2.40206,4.47315,8.28812,5.80041,11.596,9.65227,3.81886,4.44688,3.33048,11.1786,1.43943,16.72679s-4.966,10.76134-5.74385,16.57111c-1.28037,9.56283,3.9741,18.93576,10.817,25.73734,3.13108,3.11217,6.73352,5.91827,10.96,7.19354a18.99487,18.99487,0,0,0,18.2969-4.62969,21.00048,21.00048,0,0,0,5.83743-18.12746c-.57619-3.59138-2.053-7.11635-1.66956-10.7334.78755-7.43,8.89195-12.11665,10.81237-19.33726,1.96494-7.388-2.99452-14.58366-5.91323-21.64939-3.68117-8.91156-4.20067-18.77917-4.28719-28.42072-.0495-5.516.51827-11.975,5.16707-14.94452,3.03806-1.9406,6.90344-1.72771,10.49858-1.99367,4.19187-.31011,8.363-1.36013,12.5484-.97277s8.606,2.70333,9.74289,6.75c1.27284,4.53068-1.94472,9.1309-1.91391,13.83689.0151,2.30741.81658,4.55586.83091,6.86328.04161,6.70168-6.16831,11.49165-9.6506,17.21773a23.36753,23.36753,0,0,0,1.99958,26.42684c3.54753,4.23381,8.8963,7.6958,9.51,13.1852.34428,3.07917-.95034,6.06858-1.7305,9.0671s-.90643,6.58008,1.2729,8.78244c1.47771,1.49334,3.67371,1.98533,5.75628,2.26214a44.94408,44.94408,0,0,0,16.0853-.78034,7.65428,7.65428,0,0,0,3.695-1.66845c2.6178-2.53612.9793-7.03186,2.18856-10.47025,1.1816-3.35974,4.85669-5.11289,8.30283-6.01184s7.17052-1.37272,9.98121-3.56c3.12409-2.43113,4.4937-6.62663,4.31761-10.58128s-1.70132-7.72367-3.4793-11.26048a3.653,3.653,0,0,1-.5787-2.17383c.34632-2.03821,3.25513-1.86216,5.3224-1.88721,5.45554-.06611,9.6418-5.65516,9.79278-11.109s-2.75382-10.54266-6.22266-14.75389-7.59449-7.893-10.63654-12.42218c-5.20116-7.74373-7.00787-17.62359-13.32574-24.48666a24.038,24.038,0,0,0-11.36324-6.79359c-3.34981-.91091-8.37875.22962-10.99056-2.15657-1.01981-.93172-1.45463-2.43464-2.453-3.42537-1.62273-1.6103-3.83986-2.08424-5.66064-3.38615C674.19081,120.21706,672.73739,115.87657,670.06533,112.65289Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#2f2e41" />
    <path
        d="M600.13444,227.22514l-5.62883-1.185s-69.916,55.2514-73.3229,62.3615-12.5908,13.47956,6.81384,25.03348,67.2497,30.21792,67.2497,30.21792l11.10953-19.7009-54.36264-27.996s12.5908-17.77525,38.8093-13.77582Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#d0cde1" />
    <path
        d="M732.56005,233.5946l4.88819,2.22191s73.61916,53.17762,64.87966,66.50906-79.84049,45.03063-79.84049,45.03063l-12.5908-19.849s.97614-.4618,2.65488-1.26375c10.60786-5.06742,49.26967-23.71634,46.96769-25.251-2.66629-1.77752-25.03348-21.62655-31.25482-22.36719S732.56005,233.5946,732.56005,233.5946Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#d0cde1" />
    <circle
        cx="759.47575"
        cy="342.13644"
        r="48.55464"
        fill="t60" />
    <circle
        cx="795.44858"
        cy="429.78073"
        r="15.49616"
        fill="t60" />
    <circle
        cx="795.44858"
        cy="429.78073"
        r="15.49616"
        fill="#fff"
        opacity="0.3" />
    <circle
        cx="822.67686"
        cy="400.08382"
        r="15.49616"
        fill="t60"
        opacity="0.5" />
    <circle
        cx="849.90515"
        cy="370.38691"
        r="15.49616"
        fill="t60"
        opacity="0.3" />
    <path
        d="M1096.0487,623.18271c0,59.80585-35.54849,80.68028-79.41024,80.68028-1.01392,0-2.02784-.01069-3.03094-.032-2.03826-.04273-4.04473-.13874-6.04026-.28816-39.58253-2.78538-70.32862-24.73768-70.32862-80.36013,0-57.57544,73.61542-130.25172,79.07961-135.56642l.01068-.01068c.20271-.20277.30953-.29878.30953-.29878S1096.0487,563.38748,1096.0487,623.18271Z"
        transform="translate(-42.6473 -66.3044)"
        fill="p80" />
    <path
        d="M1013.74626,694.71708l29.04915-40.57489-29.11311,45.02516-.07478,4.66365c-2.03826-.04273-4.04473-.13874-6.04026-.28816l3.12683-59.81653-.02137-.46957.05341-.0854.29885-5.64546-29.188-45.14254,29.27322,40.90572.07478,1.19526,2.35847-45.20657-24.98306-46.64732,25.29258,38.70735,2.4653-93.72149.01068-.30946v.29878l-.41635,73.91427,24.87649-29.29465L1015.806,567.89109l-.6511,40.4682,23.22227-38.83541-23.31828,44.7904-.36282,22.50721,33.71281-54.06431L1014.568,644.66545Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#3f3d56" />
    <path
        d="M270.0487,703.93286c0,28.92569-17.19338,39.02181-38.40755,39.02181-.49039,0-.98078-.00516-1.46594-.01546-.98583-.02067-1.95628-.06711-2.92143-.13938-19.14449-1.34717-34.01514-11.96462-34.01514-38.867,0-27.84693,35.60483-62.99754,38.24764-65.568l.00516-.00517c.098-.09807.14971-.14451.14971-.14451S270.0487,675.0123,270.0487,703.93286Z"
        transform="translate(-42.6473 -66.3044)"
        fill="p80" />
    <path
        d="M230.24231,738.53116l14.04991-19.62444-14.08085,21.77686-.03616,2.25563c-.98583-.02067-1.95628-.06711-2.92143-.13938L228.7661,713.869l-.01034-.22711.02584-.0413.14454-2.73049-14.11708-21.83363,14.15828,19.78446.03617.57809,1.1407-21.8646L218.06091,664.973l12.233,18.7212,1.19237-45.32933.00516-.14968v.14451l-.20137,35.74937,12.03176-14.16865-12.0833,17.25015-.31491,19.57284,11.23168-18.78313-11.27812,21.66333-.17548,10.88583,16.30553-26.14874L230.63976,714.3232Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#3f3d56" />
    <path
        d="M937.0487,722.93286c0,28.92569-17.19338,39.02181-38.40755,39.02181-.49039,0-.98078-.00516-1.46594-.01546-.98583-.02067-1.95628-.06711-2.92143-.13938-19.14449-1.34717-34.01514-11.96462-34.01514-38.867,0-27.84693,35.60483-62.99754,38.24764-65.568l.00516-.00517c.098-.09807.14971-.14451.14971-.14451S937.0487,694.0123,937.0487,722.93286Z"
        transform="translate(-42.6473 -66.3044)"
        fill="p80" />
    <path
        d="M897.24231,757.53116l14.04991-19.62444-14.08085,21.77686-.03616,2.25563c-.98583-.02067-1.95628-.06711-2.92143-.13938L895.7661,732.869l-.01034-.22711.02584-.0413.14454-2.73049-14.11708-21.83363,14.15828,19.78446.03617.57809,1.1407-21.8646L885.06091,683.973l12.233,18.7212,1.19237-45.32933.00516-.14968v.14451l-.20137,35.74937,12.03176-14.16865-12.0833,17.25015-.31491,19.57284,11.23168-18.78313-11.27812,21.66333-.17548,10.88583,16.30553-26.14874L897.63976,733.3232Z"
        transform="translate(-42.6473 -66.3044)"
        fill="#3f3d56" />
</svg>"""

const val ThanksSVG = """<svg xmlns="http://www.w3.org/2000/svg"
    data-name="Layer 1"
    width="100%"
    height="100%"
    viewBox="0 0 1097.59 694.62">
    <title>a whole year</title>
    <g opacity="0.2">
        <path
            d="M976.46,703q-11.34,6.83-23.13,13.23c-1.22.66-2.44,1.32-3.66,2q-8.86,4.75-18,9.24.07-.72.18-1.44a43.59,43.59,0,0,1,4.58-14.22,35.82,35.82,0,0,1,3.9-6c5.95-7.43,14.21-11.58,22.65-10.37A22,22,0,0,1,976.46,703Z"
            transform="translate(-51.21 -102.69)"
            fill="#3f3d56" />
        <path
            d="M990.32,691.63c-.15,1.07-.34,2.12-.57,3.16Q983.2,699,976.46,703q-11.34,6.83-23.13,13.23c-1.22.66-2.44,1.32-3.66,2a24.36,24.36,0,0,1-4-3.69,31,31,0,0,1-5.31-8.69,43.32,43.32,0,0,1,6-41.93c6-7.43,14.21-11.58,22.65-10.37s15.2,7.52,18.82,16.32A41.79,41.79,0,0,1,990.32,691.63Z"
            transform="translate(-51.21 -102.69)"
            fill="#3f3d56" />
        <ellipse
            cx="970.13"
            cy="645.93"
            rx="34.66"
            ry="26.48"
            transform="translate(141.57 1411.63) rotate(-81.82)"
            fill="#3f3d56" />
        <path
            d="M1147.49,299.34a126.31,126.31,0,0,1-19,50.84l-74.4-11.26,67.24,21.21a128.68,128.68,0,0,1-11.83,13,126.84,126.84,0,0,1-22.3,155.22,126.22,126.22,0,0,1,16.91,68.48c-31.63,36.81-70.22,69.83-114.33,98Q983.2,699,976.46,703q-11.34,6.83-23.13,13.23c-2.59-.5-5.14-1.07-7.66-1.73-3.13-.79-6.2-1.71-9.21-2.73A126.83,126.83,0,0,1,889.84,500q-1.92-3.31-3.63-6.73h0c-.34-.66-.66-1.32-1-2a126.22,126.22,0,0,1-12.2-61.9l.15-2.21c.09-1.19.2-2.39.32-3.58.18-1.68.39-3.37.63-5.06l0-.16a125.93,125.93,0,0,1,12.38-39.15l90.71,45.68-82.71-59.28a127,127,0,0,1,17.6-20.84A126.83,126.83,0,1,1,1139.66,234l-101.87,54.49,107.36-37.47A126.47,126.47,0,0,1,1147.49,299.34Z"
            transform="translate(-51.21 -102.69)"
            fill="p80" />
        <path
            d="M1104.08,596.79c-31.63,36.81-70.22,69.83-114.33,98Q983.2,699,976.46,703q-11.34,6.83-23.13,13.23c-2.59-.5-5.14-1.07-7.66-1.73-3.13-.79-6.2-1.71-9.21-2.73A126.83,126.83,0,0,1,889.84,500q-1.92-3.31-3.63-6.73h0c-.34-.66-.66-1.32-1-2a126.22,126.22,0,0,1-12.2-61.9l.15-2.21c.09-1.19.2-2.39.32-3.58.18-1.68.39-3.37.63-5.06l0-.16c.78-2.7,11.1-.43,26.82,5h0l3.32,1.18c3.48,1.25,7.19,2.63,11.09,4.14h0c8.51,3.28,17.91,7.15,27.83,11.43h0l.65.28h0l1.38.6h0c66.7,28.92,154.44,75.32,141.86,87.3A126.22,126.22,0,0,1,1104.08,596.79Z"
            transform="translate(-51.21 -102.69)"
            opacity="0.1" />
    </g>
    <g opacity="0.2">
        <path
            d="M370.12,759.12q-6.3-2.18-12.51-4.48-14.46-5.32-28.47-11.25a20.79,20.79,0,0,1,6.35-3.52c8.33-2.86,17.48-.13,24.93,6.45A42.3,42.3,0,0,1,370.12,759.12Z"
            transform="translate(-51.21 -102.69)"
            fill="#3f3d56" />
        <path
            d="M360.42,746.32a33.41,33.41,0,0,1-2.81,8.32q-14.46-5.32-28.47-11.25-12.19-5.13-24-10.71a45.51,45.51,0,0,1-.46-7.21,40.42,40.42,0,0,1,.8-7.48c2-9.83,7.66-17.66,16-20.52s17.48-.13,24.93,6.46a39.43,39.43,0,0,1,4.94,5.26,46.59,46.59,0,0,1,7.48,14.08A45.05,45.05,0,0,1,360.42,746.32Z"
            transform="translate(-51.21 -102.69)"
            fill="#3f3d56" />
        <ellipse
            cx="318.87"
            cy="689.76"
            rx="27.32"
            ry="36.55"
            transform="translate(-244.25 25.48) rotate(-17.54)"
            fill="#3f3d56" />
        <ellipse
            cx="304.81"
            cy="647.35"
            rx="27.32"
            ry="36.55"
            transform="matrix(0.95, -0.3, 0.3, 0.95, -232.13, 19.27)"
            fill="#3f3d56" />
        <path
            d="M351.3,709.19q-4.17,2.44-8.56,4.57a129.57,129.57,0,0,1-14.53,6,127.24,127.24,0,0,1-13.81,3.91q-4.87,1.1-9.75,1.79-6.06.87-12.09,1.14c-48.32-24-91.7-53.36-128.72-86.89-.53-1.42-1-2.85-1.51-4.3a136.3,136.3,0,0,1,.46-87.6,133.67,133.67,0,0,1-52.52-69.38,136.77,136.77,0,0,1-7-43H208L104.29,418.85a136,136,0,0,1,6.44-28,133.61,133.61,0,0,1-52.52-69.37c-23.26-70.11,13.31-146,81.68-169.54,45.77-15.74,94.18-4,128.17,26.5l-68.15,99.76,81.14-86.32a135,135,0,0,1,24.72,44.42,136.59,136.59,0,0,1,6.28,57L238.42,318l71.7-11.93a135.2,135.2,0,0,1-4.81,17.84,133.65,133.65,0,0,1,52.52,69.37,136.8,136.8,0,0,1,7,41.84v.11c0,1.1,0,2.2,0,3.3,0,.47,0,.93,0,1.4a136,136,0,0,1-7.41,41,132,132,0,0,1,27,24.05c.2.22.39.44.57.67a134.83,134.83,0,0,1,24.91,44.65C430.37,612,404.46,678.2,351.3,709.19Z"
            transform="translate(-51.21 -102.69)"
            fill="p80" />
        <path
            d="M351.3,709.19q-4.17,2.44-8.56,4.57a129.57,129.57,0,0,1-14.53,6,127.24,127.24,0,0,1-13.81,3.91q-4.87,1.1-9.75,1.79-6.06.87-12.09,1.14c-48.32-24-91.7-53.36-128.72-86.89-.53-1.42-1-2.85-1.51-4.3a136.3,136.3,0,0,1,.46-87.6,133.67,133.67,0,0,1-52.52-69.38c-3.59-10.82,146.12-19.55,214.31-11.18l1.59.2c20.7,2.67,33.41,7,31.2,13.41a132,132,0,0,1,27,24.05c.2.22.39.44.57.67a134.83,134.83,0,0,1,24.91,44.65C430.37,612,404.46,678.2,351.3,709.19Z"
            transform="translate(-51.21 -102.69)"
            opacity="0.1" />
    </g>
    <path
        d="M433.42,334.35a4.74,4.74,0,0,0,.86-2.64c0-5.75-11.71-10.4-26.15-10.4S382,326,382,331.71a5,5,0,0,0,1.07,3c-16.07,1.79-26.9,5.16-26.9,9,0,5.74,24,10.39,53.55,10.39s53.55-4.65,53.55-10.39C463.26,339.59,451.1,336.05,433.42,334.35Z"
        transform="translate(-51.21 -102.69)"
        fill="t60"
        opacity="0.1" />
    <path
        d="M848.34,123.4a7.61,7.61,0,0,0,1.37-4.21c0-9.11-18.58-16.5-41.5-16.5s-41.5,7.39-41.5,16.5a7.81,7.81,0,0,0,1.71,4.69c-25.52,2.85-42.71,8.19-42.71,14.31,0,9.11,38,16.5,85,16.5s85-7.39,85-16.5C895.71,131.7,876.4,126.09,848.34,123.4Z"
        transform="translate(-51.21 -102.69)"
        fill="t60"
        opacity="0.1" />
    <path
        d="M515.34,123.4a7.61,7.61,0,0,0,1.37-4.21c0-9.11-18.58-16.5-41.5-16.5s-41.5,7.39-41.5,16.5a7.81,7.81,0,0,0,1.71,4.69c-25.52,2.85-42.71,8.19-42.71,14.31,0,9.11,38.05,16.5,85,16.5s85-7.39,85-16.5C562.71,131.7,543.4,126.09,515.34,123.4Z"
        transform="translate(-51.21 -102.69)"
        fill="t60"
        opacity="0.1" />
    <path
        d="M410.13,209.54c2.34-1.35,5.48-.06,7.08,2.11s2.06,5,2.46,7.63c.89,5.91,1.53,12.7-2.45,17.16,6.51-19.77,25.26-34.92,46-37.13"
        transform="translate(-51.21 -102.69)"
        fill="none"
        stroke="#6c63ff"
        stroke-miterlimit="10"
        stroke-width="3"
        opacity="0.1" />
    <path
        d="M671.6,111.52c1.5-.87,3.53,0,4.56,1.35a10.7,10.7,0,0,1,1.57,4.91c.57,3.8,1,8.16-1.57,11a35.86,35.86,0,0,1,29.55-23.87"
        transform="translate(-51.21 -102.69)"
        fill="none"
        stroke="#6c63ff"
        stroke-miterlimit="10"
        stroke-width="3"
        opacity="0.1" />
    <path
        d="M843.6,296.52c1.5-.87,3.53,0,4.56,1.35a10.7,10.7,0,0,1,1.57,4.91c.57,3.8,1,8.16-1.57,11a35.86,35.86,0,0,1,29.55-23.87"
        transform="translate(-51.21 -102.69)"
        fill="none"
        stroke="#6c63ff"
        stroke-miterlimit="10"
        stroke-width="3"
        opacity="0.1" />
    <path
        d="M598.39,167.68c-4.28,3.58-7.3,8.17-12,11.4-5.66,3.9-13.09,5.38-20,7.47s-14,5.37-16.78,11.06c-2.36,4.87-1,10.52-3,15.5-2.15,5.29-7.73,9-12,13.27-8.44,8.42-12.19,20-10,30.8,1.51,7.47,5.64,14.37,8.09,21.66,3,8.92,3.42,18.27,3.84,27.52.78,17.37,1.55,34.91-2.36,52-1,4.29-3.7,69.52-8.93,69.39,13.88-1.19,27.84-1.32,41.79-1.46l209-2c-9.63-12.6-15.78-87.06-17.82-101.91-3.52-25.6,5-51.23,6-77,.14-3.32.14-6.73-1.23-9.85-1.44-3.27-4.32-6.06-5.28-9.45-1.38-4.85,1.39-9.82,1.48-14.8.18-10-10-17.67-18.07-25.08-7.78-7.13-14.25-15.23-22.28-22.18s-18.12-12.84-29.6-13.91c-9.43-.87-18.8,1.58-27.83,4-10.77,2.88-21,6.52-32.43,6.34C616.37,160.23,608.6,161.28,598.39,167.68Z"
        transform="translate(-51.21 -102.69)"
        fill="#2f2e41" />
    <g opacity="0.1">
        <path
            d="M742.35,207.07a13.94,13.94,0,0,0,1.26,3.14A18.46,18.46,0,0,0,742,203.7,12,12,0,0,0,742.35,207.07Z"
            transform="translate(-51.21 -102.69)" />
        <path
            d="M539.66,367.64l-1.16.1A5.45,5.45,0,0,0,539.66,367.64Z"
            transform="translate(-51.21 -102.69)" />
    </g>
    <path
        d="M756.69,728a8.81,8.81,0,0,1-4.4,1.79c-25.57,5.25-51.37,9.73-77.44,11.15-23,1.26-46.07.13-69.08-1s-46-2.27-68.46-6.92a174.48,174.48,0,0,0,17.3-59.81,176.59,176.59,0,0,0,.69-27.5,30.75,30.75,0,0,0-.4-3.29c-1.07-6.58-3.71-16.11-1.31-20.87,3.08-6.12,14.91-6.32,20.69-7.46,9.82-1.93,19.69-3.54,29.6-4.89,39.33-5.35,79.06-6.57,118.69-7.76,5.32-.16,11.66.2,14.43,4.75,1.55,2.55,1.47,5.73,1.39,8.72q-.27,9.71.19,19.42A259.76,259.76,0,0,0,756.76,718C758.08,721.27,759.29,725.55,756.69,728Z"
        transform="translate(-51.21 -102.69)"
        fill="#fbbebe" />
    <path
        d="M601.09,371.89c-4.18,5.15-10.07,8.61-16,11.65a199.86,199.86,0,0,1-21.85,9.68c-1.51,2.29-.31,5.33,1,7.77,11.73,22.78,27.43,45.42,51.11,55.21,12.15,5,25.48,6.25,38.58,7.42,4.08.36,8.24.72,12.22-.26s7.68-3.35,11-5.86a102.61,102.61,0,0,0,39.72-67.73c.32-2.39.32-5.32-1.73-6.6-1.25-.77-2.84-.62-4.31-.61-9.59.1-18.09-7-22.52-15.49s-5.61-18.28-6.7-27.81c0-.21-56.38-1.4-61.47-1.44-7.94-.07-10.56.86-11.33,9C608,355.8,607,364.57,601.09,371.89Z"
        transform="translate(-51.21 -102.69)"
        fill="#fbbebe" />
    <path
        d="M601.09,371.89c-4.18,5.15-10.07,8.61-16,11.65a199.86,199.86,0,0,1-21.85,9.68c-1.51,2.29-.31,5.33,1,7.77,11.73,22.78,27.43,45.42,51.11,55.21,12.15,5,25.48,6.25,38.58,7.42,4.08.36,8.24.72,12.22-.26s7.68-3.35,11-5.86a102.61,102.61,0,0,0,39.72-67.73c.32-2.39.32-5.32-1.73-6.6-1.25-.77-2.84-.62-4.31-.61-9.59.1-18.09-7-22.52-15.49s-5.61-18.28-6.7-27.81c0-.21-56.38-1.4-61.47-1.44-7.94-.07-10.56.86-11.33,9C608,355.8,607,364.57,601.09,371.89Z"
        transform="translate(-51.21 -102.69)"
        opacity="0.1" />
    <circle
        cx="594.69"
        cy="181.55"
        r="77"
        fill="#fbbebe" />
    <path
        d="M702.37,375.53c.85,10.8-115.22,20.91-119.6,7.59-2.6,3.07-7.37,3.32-11.17,2s-7-3.86-10.6-5.73c-6-3.13-12.76-4.29-19.41-5.42-10.83-1.83-23.41-3.17-31.43,4.34-2.77,2.59-4.66,6-7.44,8.6-4.86,4.52-11.73,5.93-18,8-9.05,3-17.39,7.8-25.94,12a229.85,229.85,0,0,1-63.19,20.42c-4.67.79-9.37,1.43-14,2.54-6.5,1.56-13,4.23-17.43,9.24,5.18,6.62,12.62,10.23,20.61,12.84l77.1,25.2c11.6,3.79,23.38,7.66,33.53,14.45,16.91,11.28,27.91,29.82,33.93,49.23s7.57,39.89,9.07,60.16c.65,8.81,1.24,18-2.22,26.16a202.47,202.47,0,0,0,54-.89c17.21-2.62,34.23-7.48,51.64-7.32,19,.19,37.41,6.35,56.14,9.68s39.4,3.43,55.18-7.2c-3.36-4.53-3.87-11-4-16.62l-.4-26.63a39.52,39.52,0,0,1,.64-9.6c1.34-5.7,5.11-10.48,7.52-15.81,4.65-10.29,4-22.05,4.26-33.34S763,496,770.63,487.74c5-5.39,12-8.45,19.1-10.34,12.14-3.24,24.84-3.45,37.38-4.34a334.68,334.68,0,0,0,118-30.73c-2.22-4.69-7.38-7.35-12.09-9.53-11.14-5.15-22.94-10.43-35.16-9.28-5.91.56-11.76,2.62-17.65,1.87-5.58-.72-10.52-3.88-15.94-5.39-4.11-1.14-8.41-1.31-12.63-1.95-9.74-1.49-18.88-5.5-27.89-9.47l-22.76-10c-6-2.65-12.25-5.48-16.37-10.6-1.34-1.67-2.42-3.55-3.88-5.12-2.51-2.69-6-4.28-9.49-5.39a30.74,30.74,0,0,0-13.67-1.5,80.36,80.36,0,0,0-9.35,2.45C733.19,382.48,717.67,378.26,702.37,375.53Z"
        transform="translate(-51.21 -102.69)"
        fill="p80" />
    <path
        d="M790.44,778.28a744.85,744.85,0,0,1-124.8,19h-.07l-105.61,0h-.06q-28.35-1.93-55.88-5.9a198.58,198.58,0,0,1,22.21-45.7,23.93,23.93,0,0,0,3.46-6.62,34.86,34.86,0,0,0,.67-6.71A32.49,32.49,0,0,1,538,713.61q3.12,1.7,6.3,3.27a201.68,201.68,0,0,0,76.94,20.65,296.28,296.28,0,0,0,42.23-.85c31.66-2.55,64.58-8.43,90.08-27.1,1.07-.78,2.13-1.59,3.18-2.42,12.39,11,19.56,27.86,24.69,43.62C784.47,760,787.29,769.2,790.44,778.28Z"
        transform="translate(-51.21 -102.69)"
        fill="n20" />
    <path
        d="M645.48,714.66a11.07,11.07,0,0,0,1.52,9.63,7.79,7.79,0,0,0-1.62-8.72Z"
        transform="translate(-51.21 -102.69)"
        opacity="0.1" />
    <path
        d="M601.73,391.4c3.88-2.12,8.07-4,12.49-4.06,6.64-.06,12.58,4,17.5,8.48A89.62,89.62,0,0,1,644,409.44c1.8,2.45,3.52,5.14,3.79,8.17s-1.39,6.44-4.35,7.16a7.67,7.67,0,0,1-5.39-1.09c-6.84-3.76-11.91-12.37-19.67-11.53-5.32.57-8.92,5.52-11.83,10-2.59,4-5.21,8.11-6.37,12.73s-.6,10,2.62,13.48c2.5,2.73,6.15,4,9.56,5.42A66.63,66.63,0,0,1,632.73,467c2.87,2.74,5.6,6,6,10s-2.63,8.4-6.59,8.12a10.55,10.55,0,0,1-4.89-2.13c-7.16-4.73-14.47-9.69-22.87-11.43-8.55-1.77-17.38,0-26,1.32Q564.2,475,549.88,475.9a23.83,23.83,0,0,1-8.47-.55c-9.44-2.92-12.19-14.93-11.09-23.61,1.17-9.28,8-11.39,15.14-16C565.54,422.6,580.44,403,601.73,391.4Z"
        transform="translate(-51.21 -102.69)"
        fill="#fbbebe" />
    <path
        d="M675.7,391.4c-3.89-2.12-8.07-4-12.5-4.06-6.64-.06-12.58,4-17.5,8.48a89.62,89.62,0,0,0-12.27,13.62c-1.79,2.45-3.51,5.14-3.78,8.17s1.38,6.44,4.34,7.16a7.7,7.7,0,0,0,5.4-1.09c6.84-3.76,11.91-12.37,19.66-11.53,5.33.57,8.93,5.52,11.83,10,2.59,4,5.22,8.11,6.37,12.73s.6,10-2.62,13.48c-2.49,2.73-6.15,4-9.56,5.42A66.75,66.75,0,0,0,644.69,467c-2.87,2.74-5.59,6-6,10s2.63,8.4,6.59,8.12a10.51,10.51,0,0,0,4.89-2.13c7.16-4.73,14.47-9.69,22.87-11.43,8.55-1.77,17.38,0,26,1.32,9.43,1.48,18.94,2.51,28.47,3.08a23.89,23.89,0,0,0,8.48-.55c9.43-2.92,12.18-14.93,11.09-23.61-1.18-9.28-8-11.39-15.15-16C711.89,422.6,697,403,675.7,391.4Z"
        transform="translate(-51.21 -102.69)"
        fill="#fbbebe" />
    <path
        d="M592.66,256.42c4.48-7.08,9.8-14.76,17.07-15.58,10.15-1.15,18.08,11.54,28.18,13.18,13,2.12,25.78-14.52,38-8.44,6,3,10.48,11.32,17,11.16,4.51-.1,8.18-4.33,11.17-8.48a158.2,158.2,0,0,0,13.35-22.12c-12.41-14.23-30.46-17.48-47.31-20.07l-28.33-4.35c-6.82-1.05-13.76-2.09-20.54-.64-6.13,1.31-11.85,4.61-17.4,8.08-6.62,4.16-22.19,10.84-26.25,18.58-2.83,5.37,1.06,7.87,4.71,13.28Q587.46,248.72,592.66,256.42Z"
        transform="translate(-51.21 -102.69)"
        fill="#2f2e41" />
    <path
        d="M549.75,430.22a149,149,0,0,1-37.35,2.66c-4.91-.26-9.84-.77-14.73-.31-5.9.56-11.57,2.51-17.32,3.93-29.79,7.33-60.92.17-91.33-3.85-5.37-.71-10.86-1.32-16.18-.28-4.87.95-9.37,3.23-13.68,5.68a165.25,165.25,0,0,0-20,13.39c-6.63,5.18-13.32,11.78-13.78,20.17-.4,7.22,4,13.87,9.33,18.78,14.4,13.33,35.78,17.34,55.06,13.73,7.33-1.37,14.48-3.73,21.89-4.55,7.59-.84,15.26,0,22.89-.36,15.5-.69,30.34-6.08,45.39-9.83a218.63,218.63,0,0,1,71.94-5.64,1.55,1.55,0,0,1-2.13-1.09c-1.77-4.88-1.86-10.19-1.83-15.38C548,454.68,548.59,442.76,549.75,430.22Z"
        transform="translate(-51.21 -102.69)"
        opacity="0.1" />
    <path
        d="M547.75,431.22a149,149,0,0,1-37.35,2.66c-4.91-.26-9.84-.77-14.73-.31-5.9.56-11.57,2.51-17.32,3.93-29.79,7.33-60.92.17-91.33-3.85-5.37-.71-10.86-1.32-16.18-.28-4.87.95-9.37,3.23-13.68,5.68a165.25,165.25,0,0,0-20,13.39c-6.63,5.18-13.32,11.78-13.78,20.17-.4,7.22,4,13.87,9.33,18.78,14.4,13.33,35.78,17.34,55.06,13.73,7.33-1.37,14.48-3.73,21.89-4.55,7.59-.84,15.26,0,22.89-.36,15.5-.69,30.34-6.08,45.39-9.83a218.63,218.63,0,0,1,71.94-5.64,1.55,1.55,0,0,1-2.13-1.09c-1.77-4.88-1.86-10.19-1.83-15.38C546,455.68,546.59,443.76,547.75,431.22Z"
        transform="translate(-51.21 -102.69)"
        fill="p80" />
    <path
        d="M730,424.87c15.24,3.47,51.92,5,67.54,4.48,7.13-.22,14.24-.86,21.37-.84,12.22,0,24.42,2,36.61,1.19,15.75-1.08,31.22-6.87,46.93-5.38,7.72.74,15.15,3.2,22.51,5.66s15.38,5.24,20.56,11.22c4.8,5.54,6.55,13,8.14,20.16.89,4,1.78,8.13,1,12.14-1.49,7.61-8.5,12.76-15.23,16.6-8,4.56-16.78,8.48-26,8.27-5.47-.12-10.79-1.7-16-3.34-14.93-4.69-30.19-10-45.79-8.83-10.91.84-21.81,4.86-32.54,2.69-6.31-1.28-12-4.62-18-6.84-14.62-5.35-51.73-3.93-67.23-2.45.9-8.71.79-17.49,1.69-26.21.7-6.67,1.37-13.58-.77-19.94C733.45,429.64,733,427.57,730,424.87Z"
        transform="translate(-51.21 -102.69)"
        opacity="0.1" />
    <path
        d="M731,426.87c15.24,3.47,51.92,5,67.54,4.48,7.13-.22,14.24-.86,21.37-.84,12.22,0,24.42,2,36.61,1.19,15.75-1.08,31.22-6.87,46.93-5.38,7.72.74,15.15,3.2,22.51,5.66s15.38,5.24,20.56,11.22c4.8,5.54,6.55,13,8.14,20.16.89,4,1.78,8.13,1,12.14-1.49,7.61-8.5,12.76-15.23,16.6-8,4.56-16.78,8.48-26,8.27-5.47-.12-10.79-1.7-16-3.34-14.93-4.69-30.19-10-45.79-8.83-10.91.84-21.81,4.86-32.54,2.69-6.31-1.28-12-4.62-18-6.84-14.62-5.35-51.73-3.93-67.23-2.45.9-8.71.79-17.49,1.69-26.21.7-6.67,1.37-13.58-.77-19.94C734.45,431.64,734,429.57,731,426.87Z"
        transform="translate(-51.21 -102.69)"
        fill="p80" />
    <path
        d="M572.11,274.59c-2.34-.61-3.24-3.57-5.35-4.76s-4.75-.25-6.27,1.52a10.82,10.82,0,0,0-2.18,6.5,24.58,24.58,0,0,0,15.4,23.72,100.19,100.19,0,0,1-2.4-27.78Z"
        transform="translate(-51.21 -102.69)"
        fill="#fbbebe" />
    <path
        d="M719.68,274.59c2.34-.61,3.23-3.57,5.34-4.76s4.75-.25,6.27,1.52a10.75,10.75,0,0,1,2.18,6.5,24.58,24.58,0,0,1-15.4,23.72,100.19,100.19,0,0,0,2.4-27.78Z"
        transform="translate(-51.21 -102.69)"
        fill="#fbbebe" />
    <g opacity="0.1">
        <path
            d="M623.83,496.34a77.76,77.76,0,0,1,2.75,21.4c0,12.57-2.47,23.54-6.15,29.43-.31,2.8-.66,5.58-1,8.31,5.19-4,9-17.14,9-32.74C628.39,512.08,626.61,502.57,623.83,496.34Z"
            transform="translate(-51.21 -102.69)" />
    </g>
    <g opacity="0.1">
        <path
            d="M652,496.34a77.73,77.73,0,0,0-2.76,21.4c0,12.57,2.48,23.54,6.16,29.43.31,2.8.65,5.58,1,8.31-5.19-4-9-17.14-9-32.74C647.39,512.08,649.17,502.57,652,496.34Z"
            transform="translate(-51.21 -102.69)" />
    </g>
    <path
        d="M704,243.26c-3,4.15-6.66,8.38-11.17,8.48-6.53.16-11-8.14-17-11.16-12.17-6.08-24.92,10.56-38,8.44-10.1-1.64-18-14.33-28.18-13.18-7.27.82-12.59,8.5-17.07,15.58q-5.2-7.69-10.39-15.4c-2-3-4.17-5.15-5.14-7.37-1.94,4.76,1.7,7.28,5.14,12.37s6.92,10.27,10.39,15.4c4.48-7.08,9.8-14.76,17.07-15.58,10.15-1.15,18.08,11.54,28.18,13.18,13,2.12,25.78-14.52,38-8.44,6,3,10.48,11.32,17,11.16,4.51-.1,8.18-4.33,11.17-8.48a158.2,158.2,0,0,0,13.35-22.12c-.54-.62-1.1-1.22-1.67-1.8A159.65,159.65,0,0,1,704,243.26Z"
        transform="translate(-51.21 -102.69)"
        opacity="0.1" />
</svg>"""

