# FunASR 性能优化总结

## 问题分析

### 问题1：UI显示新句速度慢
- **根本原因**：标点化策略过于保守，导致识别到的文本需要等待较长时间才能显示
  - 防抖间隔过长（0.8秒）
  - 最小字符数限制过高（6个字符）
  - partial消息只在标点化后发送，而不是识别到就发送

### 问题2：错误截断句子
- **根本原因**：分句策略过于激进
  - 自动提交门槛太低（18个字符）
  - 停顿检测阈值太低（0.5秒）
  - JavaScript端静音检测超时太短（700ms）

## 优化方案

### 核心原则
**"先显示任何识别到的文本，标点异步优化"**

### 具体改动

#### 1. Python Worker (`asr_funasr_worker.py`)

**参数调整：**
- `MIN_AUTO_COMMIT_CHARS`: 18 → 30（提高自动提交门槛）
- `MAX_SENTENCE_SECONDS`: 15 → 20（延长最大句子时长）
- `SEGMENT_GAP_THRESHOLD`: 0.5 → 1.2秒（提高停顿检测阈值）
- `PUNC_DEBOUNCE_INTERVAL`: 0.8 → 0.3秒（降低标点化防抖）
- `MIN_CHARS_FOR_PUNC`: 6 → 3个字符（降低标点化门槛）

**逻辑优化：**
1. **立即显示原始文本**（第554-556行）
   - 识别到文本后立即更新 `current_sentence.text`
   - 不等待标点化完成

2. **优先发送partial消息**（第558-581行）
   - 先发送原始文本的partial消息
   - 让UI能够实时显示任何识别到的内容

3. **异步标点化**（第583-602行）
   - 标点化作为异步优化过程
   - 满足防抖条件时才触发
   
4. **标点化后再次更新**（第592-602行）
   - 标点化完成后，再次发送partial消息
   - 优化显示效果，添加标点符号

5. **移除重复的partial发送**（第710行）
   - 删除了原来在函数末尾的partial发送逻辑
   - 避免重复发送消息

#### 2. JavaScript Service (`local-asr-service.js`)

**静音检测优化：**
- 静音超时：700ms → 1500ms（减少误触发）
- 音量阈值：0.0015 → 0.003（提高灵敏度）

## 预期效果

### 问题1解决：UI显示速度提升
✅ 识别到文本后立即显示（无标点）
✅ 0.3秒后添加标点符号（防抖）
✅ 只需3个字符即可触发标点化
✅ 用户几乎不会感知到延迟

### 问题2解决：减少句子截断
✅ 需要30个字符才会自动提交（之前18个）
✅ 需要1.2秒停顿才会触发分句（之前0.5秒）
✅ 需要1.5秒静音才触发强制提交（之前0.7秒）
✅ 更长的文本可以在一个气泡内连续显示

## 测试建议

1. **测试连续说话**
   - 连续说一段长句子，观察是否保持在一个气泡内
   - 预期：30个字符内的句子不会被截断

2. **测试短暂停顿**
   - 说话时短暂停顿（0.5-1秒），观察是否会截断
   - 预期：1.2秒以内的停顿不会触发分句

3. **测试显示速度**
   - 说话后观察文字显示的延迟
   - 预期：几乎实时显示原始文本，0.3秒后添加标点

## 环境变量覆盖

如需进一步调整，可以通过环境变量覆盖默认值：

```bash
export MIN_AUTO_COMMIT_CHARS=40        # 进一步提高自动提交门槛
export MAX_SENTENCE_SECONDS=30         # 延长最大句子时长
export SEGMENT_GAP_THRESHOLD=1.5       # 进一步提高停顿阈值
export PUNC_DEBOUNCE_INTERVAL=0.2      # 进一步降低标点延迟
export MIN_CHARS_FOR_PUNC=2            # 进一步降低标点门槛
```

## 回滚方案

如果优化效果不理想，只需修改环境变量即可回滚到旧值：

```bash
export MIN_AUTO_COMMIT_CHARS=18
export MAX_SENTENCE_SECONDS=15
export SEGMENT_GAP_THRESHOLD=0.5
export PUNC_DEBOUNCE_INTERVAL=0.8
export MIN_CHARS_FOR_PUNC=6
```
