# LiveGalGame Desktop

> 🖥️ Windows / macOS 桌面端 —— 让语音聊天也能像 GalGame 一样有字幕和选项

[← 返回主页](../README.md)

---

## 这是什么？

一个浮动在你聊天软件上方的智能助手窗口。它能：

- **实时显示字幕** —— 你说的话、对方说的话，全部转成文字
- **给出 AI 回复建议** —— 关键时刻告诉你该说什么
- **显示好感度变化** —— 让聊天效果可视化

半透明、置顶、可拖动，不干扰你正常使用任何聊天软件。

---

## 🎮 使用流程

### 1️⃣ 创建对话对象
点击"新建对话"，填写：
- 对方昵称
- 你们的关系
- 备注信息（比如对方的喜好）

> 💡 这些信息会帮助 AI 更懂你的场景

### 2️⃣ 启动浮动窗口
点击"开始对话"，一个小窗会出现在屏幕上：
- 半透明设计，不遮挡聊天界面
- 可以拖动到任意位置
- 始终置顶显示

### 3️⃣ 开始聊天
打开你的聊天软件（微信、QQ、Discord...），开始语音对话：
- 你说的话会实时转成文字显示
- 对方说的话也会被识别并显示
- 再也不用担心听漏或忘记

### 4️⃣ 获取 AI 建议
当对方问你问题或对话到了关键时刻：
- AI 会自动弹出回复建议
- 每个选项都带有情感标签（温柔/幽默/直接...）
- 还会预测这样说的效果

### 5️⃣ 看到反馈
选择一个回复说出来后：
- 好感度进度条会动态变化
- 比如：`❤️ 好感度: 50 → 70 (+20 ↗)`
- 把"聊得好"变成看得见的成就

---

## ✨ 设计亮点

| 特性 | 说明 |
|------|------|
| 🪟 场景化设计 | 浮动窗口完美融入你已有的聊天场景 |
| 🎮 游戏化体验 | 好感度预测和实时变化，让聊天像玩游戏 |
| 🧠 可解释 AI | 不只给建议，还告诉你为什么这样说更好 |
| 🔇 离线可用 | 语音识别本地运行，隐私有保障 |

---

## 🚀 快速开始

### 安装

```bash
git clone https://github.com/JStone2934/LiveGalGame.git
cd LiveGalGame/desktop
pnpm install
```

### 配置语音识别

```bash
# 安装 FunASR（推荐，中文识别效果最好）
npm run setup-funasr
```

### 启动

```bash
pnpm dev
```

---

## 💻 系统要求

- **Windows**: 10 / 11
- **macOS**: 12.0+
- 需要麦克风权限
- Node.js 20+, Python 3.8+

---

## ❓ 常见问题

**听不到声音？**
- 检查系统麦克风权限
- 在应用设置中选择正确的音频输入设备

**识别不准确？**
- 调整麦克风距离（建议 20-30cm）
- 在安静环境下效果更好

**窗口挡住了聊天界面？**
- 拖动窗口到合适位置
- 可以调整窗口透明度

---

## 🔧 开发者指南

如果你想参与开发或了解技术细节，请查看项目源码：

- `src/main.js` - Electron 主进程
- `src/renderer/` - React 前端界面
- `src/asr/` - 语音识别服务
- `src/db/` - 本地数据存储

欢迎提交 PR！有问题请加 QQ 群：**1074602400**

