import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
import { SVGProps } from './SVG.props';

const Settings = (props: SVGProps) => {
  const { height, width, fill } = props;

  // https://react-svgr.com/playground/?native=true&typescript=true
  // Paste converted svg below
  return (
    <Svg
      width={width || 32}
      height={height || 35}
      viewBox="0 0 32 35"
      fill="none"
      {...props}>
      <Path
        d="M31.578 21.63l-2.472-2.082a13.187 13.187 0 000-4.3l2.471-2.083a1.175 1.175 0 00.35-1.31l-.033-.096a16.45 16.45 0 00-3.006-5.13l-.068-.077a1.228 1.228 0 00-1.324-.353l-3.068 1.074a13.342 13.342 0 00-3.761-2.142l-.593-3.162a1.187 1.187 0 00-.335-.627 1.215 1.215 0 00-.638-.329L19 .995a17.284 17.284 0 00-5.998 0l-.102.018a1.215 1.215 0 00-.638.329c-.174.17-.29.39-.335.627l-.597 3.177A13.321 13.321 0 007.594 7.28l-3.09-1.083a1.224 1.224 0 00-1.324.354l-.068.078a16.535 16.535 0 00-3.006 5.129l-.034.097c-.17.465-.03.985.35 1.309l2.502 2.105c-.117.7-.174 1.414-.174 2.124 0 .714.057 1.429.174 2.124L.423 21.623a1.176 1.176 0 00-.35 1.31l.033.096a16.493 16.493 0 003.006 5.13l.068.078a1.228 1.228 0 001.324.353l3.09-1.082a13.23 13.23 0 003.735 2.135l.596 3.176c.045.238.162.457.336.628.174.17.396.285.638.328l.102.019c1.983.351 4.015.351 5.998 0l.102-.019c.242-.043.464-.158.638-.328.174-.171.29-.39.335-.628l.593-3.162a13.252 13.252 0 003.761-2.142l3.067 1.075a1.224 1.224 0 001.325-.353l.067-.078a16.536 16.536 0 003.007-5.13l.034-.096c.17-.458.03-.979-.35-1.302zm-5.15-5.943a10.383 10.383 0 010 3.43l-.25 1.49 2.819 2.378c-.427.97-.967 1.889-1.607 2.737l-3.501-1.224-1.185.96a10.579 10.579 0 01-2.992 1.704l-1.437.532-.675 3.608a14.447 14.447 0 01-3.207 0l-.676-3.616-1.426-.54a10.592 10.592 0 01-2.969-1.699l-1.184-.963-3.524 1.234a14.009 14.009 0 01-1.607-2.737l2.848-2.4-.245-1.487c-.09-.554-.14-1.127-.14-1.692 0-.57.046-1.139.14-1.693l.245-1.488-2.848-2.399c.426-.97.966-1.886 1.607-2.737l3.524 1.234 1.184-.963a10.592 10.592 0 012.97-1.7l1.43-.532.675-3.615a14.444 14.444 0 013.206 0l.676 3.608 1.437.532a10.63 10.63 0 012.992 1.703l1.184.96 3.502-1.224c.64.852 1.177 1.77 1.607 2.738l-2.819 2.377.246 1.484zm-10.424-5.204c-3.667 0-6.64 2.931-6.64 6.547 0 3.615 2.973 6.546 6.64 6.546s6.64-2.931 6.64-6.546c0-3.616-2.973-6.547-6.64-6.547zm2.988 9.492a4.215 4.215 0 01-1.37.905 4.263 4.263 0 01-1.618.316 4.241 4.241 0 01-2.988-1.22 4.149 4.149 0 01-.917-1.352 4.122 4.122 0 01.917-4.54c.8-.789 1.86-1.22 2.988-1.22a4.225 4.225 0 013.905 2.57 4.121 4.121 0 01-.917 4.54z"
        fill={fill || '#000'}
      />
    </Svg>
  );
};

export default Settings;
