import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
import { SVGProps } from './SVG.props';

const RotateRight = (props: SVGProps) => {
  const { height, width, fill } = props;

  // https://react-svgr.com/playground/?native=true&typescript=true
  // Paste converted svg below
  return (
    <Svg
      aria-hidden="true"
      width={width || '1em'}
      height={height || '1em'}
      viewBox="0 0 32 32"
      {...props}>
      <Path
        d="M14.091 26.823l-.346 1.968a12.896 12.896 0 01-4.24-1.541l1-1.731a10.909 10.909 0 003.586 1.305zM7.577 23.068l-1.532 1.285a12.981 12.981 0 01-2.25-3.91l1.877-.684a10.98 10.98 0 001.905 3.31zM22.495 27.25a12.896 12.896 0 01-4.24 1.542l-.347-1.968a10.909 10.909 0 003.587-1.305zM26.327 19.759l1.878.683a12.981 12.981 0 01-2.25 3.911l-.311-.261-1.22-1.024a10.982 10.982 0 001.903-3.31zM13.662 5.256c-.16.034-.315.08-.472.121a10.96 10.96 0 00-.633.183c-.164.054-.325.116-.486.178a10.174 10.174 0 00-1.046.465q-.268.136-.526.286c-.153.09-.305.18-.454.276-.167.11-.33.224-.492.342-.14.102-.281.203-.417.312-.161.13-.315.268-.47.406-.122.11-.248.217-.365.332-.167.164-.322.338-.478.512A10.944 10.944 0 005 16H3a12.936 12.936 0 013.05-8.35l-.005-.004c.092-.11.197-.206.293-.312.184-.205.367-.41.563-.603.139-.136.286-.262.43-.391.183-.165.366-.329.558-.482.16-.128.325-.247.49-.367.192-.14.385-.277.585-.406.175-.113.353-.22.532-.324q.309-.179.626-.341a12.028 12.028 0 011.238-.55c.19-.072.378-.145.571-.208.246-.082.498-.15.75-.217.186-.049.368-.102.556-.143.29-.063.587-.107.884-.15.159-.023.314-.056.475-.073A12.933 12.933 0 0126 7.703V4h2v8h-8v-2h5.189A10.961 10.961 0 0016 5a11.111 11.111 0 00-1.189.067c-.136.015-.268.042-.403.061-.25.037-.501.075-.746.128z"
        fill={fill || '#000'}
      />
    </Svg>
  );
};

export default RotateRight;
