import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
import { SVGProps } from './SVG.props';

const SvgComponent = (props: SVGProps) => {
  const { height, width, fill } = props;

  return (
    <Svg
      width={width || 40}
      height={height || 41}
      viewBox="0 0 40 41"
      fill="none"
      {...props}>
      <Path
        d="M9.387 37.746a6.941 6.941 0 01-1.8-.234 6.985 6.985 0 01-4.162-3.22 6.816 6.816 0 01-.688-5.172L5.65 18.225c.23-.877.634-1.7 1.19-2.422a6.896 6.896 0 014.574-2.625 6.882 6.882 0 016.961 3.618h3.25a6.784 6.784 0 011.779-2.18 6.897 6.897 0 012.521-1.283 6.882 6.882 0 015.188.665 6.909 6.909 0 012.046 1.781c.556.722.96 1.545 1.191 2.422l2.913 10.919a6.816 6.816 0 01-.682 5.19 6.985 6.985 0 01-4.181 3.227 6.88 6.88 0 01-7.235-2.446 6.786 6.786 0 01-1.19-2.422l-.225-1.084h-7.5l-.287 1.06c-.23.877-.635 1.7-1.19 2.421a6.893 6.893 0 01-2.048 1.78 6.9 6.9 0 01-3.338.9zm2.9-22.183a4.41 4.41 0 00-2.15.567c-.509.293-.954.683-1.31 1.146a4.386 4.386 0 00-.764 1.553L5.15 29.724a4.382 4.382 0 00.429 3.33 4.49 4.49 0 002.671 2.08 4.347 4.347 0 004.586-1.564c.357-.463.616-.991.764-1.554l.775-2.896h11.25l.762 2.896a4.445 4.445 0 002.075 2.699 4.368 4.368 0 003.288.419 4.464 4.464 0 002.672-2.08 4.357 4.357 0 00.416-3.33l-2.913-10.895a4.324 4.324 0 00-.755-1.555 4.392 4.392 0 00-1.308-1.144 4.366 4.366 0 00-3.287-.419 4.455 4.455 0 00-1.817 1.015 4.37 4.37 0 00-1.145 1.721l-.3.814h-6.625l-.3-.814a4.383 4.383 0 00-1.152-1.723 4.467 4.467 0 00-1.824-1.013 4.407 4.407 0 00-1.125-.148z"
        fill={fill || '#000'}
      />
      <Path
        d="M12.5 25.422c-.495 0-.978-.144-1.389-.415a2.472 2.472 0 01-.92-1.106 2.433 2.433 0 01.541-2.686c.35-.345.795-.58 1.28-.675a2.533 2.533 0 011.445.14c.457.187.847.503 1.122.908a2.44 2.44 0 01-.311 3.113 2.519 2.519 0 01-1.768.721zM27.5 21.725c.69 0 1.25-.551 1.25-1.232 0-.68-.56-1.232-1.25-1.232s-1.25.551-1.25 1.232c0 .68.56 1.232 1.25 1.232zM27.5 26.655c.69 0 1.25-.552 1.25-1.233 0-.68-.56-1.232-1.25-1.232s-1.25.552-1.25 1.232c0 .681.56 1.233 1.25 1.233zM25 24.19c.69 0 1.25-.552 1.25-1.232 0-.68-.56-1.233-1.25-1.233s-1.25.552-1.25 1.233c0 .68.56 1.232 1.25 1.232zM30 24.19c.69 0 1.25-.552 1.25-1.232 0-.68-.56-1.233-1.25-1.233s-1.25.552-1.25 1.233c0 .68.56 1.232 1.25 1.232zM17.188 11.866l-1.875-1.639a6.245 6.245 0 012.115-1.54 6.326 6.326 0 015.143 0c.809.36 1.53.884 2.116 1.54l-1.875 1.64a3.747 3.747 0 00-1.27-.925 3.796 3.796 0 00-3.085 0c-.485.216-.918.53-1.27.924z"
        fill={fill || '#000'}
      />
      <Path
        d="M26.563 8.625A8.744 8.744 0 0023.6 6.468a8.856 8.856 0 00-7.2 0 8.744 8.744 0 00-2.962 2.157l-1.876-1.627a11.241 11.241 0 013.81-2.773 11.387 11.387 0 019.257 0 11.241 11.241 0 013.808 2.773l-1.875 1.627z"
        fill={fill || '#000'}
      />
    </Svg>
  );
};

export default SvgComponent;
