import * as React from 'react';
import Svg, { Path } from 'react-native-svg';
import { SVGProps } from './SVG.props';

const Control = (props: SVGProps) => {
  const { height, width, fill } = props;

  // https://react-svgr.com/playground/?native=true&typescript=true
  // Paste converted svg below
  return (
    <Svg
      width={width || 32}
      height={height || 33}
      viewBox="0 0 32 33"
      fill="none"
      {...props}>
      <Path
        d="M30.72.704H1.28A1.27 1.27 0 000 1.966v29.025a1.27 1.27 0 001.28 1.263h29.44A1.27 1.27 0 0032 30.992V1.965A1.27 1.27 0 0030.72.704zm-1.6 28.71H2.88V3.544h26.24v25.87zm-20-6.192v3.037c0 .174.144.316.32.316h1.92c.176 0 .32-.142.32-.316v-3.037c-.404.13-.832.198-1.28.198-.448 0-.876-.071-1.28-.198zm2.56-7.808V6.7a.319.319 0 00-.32-.316H9.44a.319.319 0 00-.32.316v8.715a4.278 4.278 0 012.56 0zm-2.56 7.809a4.278 4.278 0 002.56 0c1.672-.533 2.88-2.079 2.88-3.905 0-1.826-1.208-3.372-2.88-3.904a4.278 4.278 0 00-2.56 0c-1.672.533-2.88 2.078-2.88 3.904s1.208 3.372 2.88 3.904zm.004-4.563c.012-.024.028-.048.04-.071v-.004l.048-.071.012-.02c.012-.02.028-.035.04-.055l.012-.016c.02-.024.036-.043.056-.063l.012-.012.048-.047.016-.016c.02-.02.04-.035.064-.055a.758.758 0 01.068-.051l.02-.012c.02-.012.036-.028.056-.04.004-.004.012-.008.016-.011.024-.016.048-.028.076-.044.004-.004.012-.004.016-.008.02-.012.04-.02.064-.031l.024-.012c.028-.012.052-.024.08-.032.028-.012.056-.02.084-.027.008-.004.016-.004.024-.008a.428.428 0 01.068-.016c.008 0 .012-.004.02-.004.028-.008.06-.012.088-.016.008 0 .012 0 .02-.004.024-.004.048-.004.072-.008h.024c.032 0 .06-.003.092-.003s.06 0 .092.004h.024a.44.44 0 01.072.007c.008 0 .012 0 .02.004.028.004.06.008.088.016.008 0 .012.004.02.004.024.004.048.012.068.016.008.004.016.004.024.008a.704.704 0 01.084.027c.028.008.052.02.08.032l.024.012c.02.008.044.02.064.031.004.004.012.004.016.008a.735.735 0 01.076.044c.004.003.012.007.016.011.02.012.04.024.056.04l.02.012c.024.015.048.035.068.05.02.017.044.036.064.056l.016.016.048.047.012.012c.02.02.04.043.056.063l.012.016c.016.016.028.035.04.055l.012.02.048.07s0 .005.004.005a1.412 1.412 0 01.04 1.388c-.012.024-.028.047-.04.07 0 0 0 .005-.004.005l-.048.07c-.004.009-.008.013-.012.02-.012.02-.028.036-.04.056-.004.004-.008.012-.012.015-.02.024-.036.044-.056.064l-.012.011-.048.048-.016.016c-.02.02-.04.035-.064.055a.756.756 0 01-.068.051l-.02.012c-.02.012-.036.027-.056.04-.004.003-.012.007-.016.011-.024.016-.048.028-.076.043-.004.004-.012.004-.016.008-.02.012-.04.02-.064.032l-.024.012c-.028.012-.052.023-.08.031-.028.012-.056.02-.084.028-.008.004-.016.004-.024.008a.428.428 0 01-.068.016c-.008 0-.012.003-.02.003-.028.008-.06.012-.088.016-.008 0-.012 0-.02.004-.024.004-.048.004-.072.008h-.024c-.032 0-.06.004-.092.004s-.06 0-.092-.004h-.024a.44.44 0 01-.072-.008c-.008 0-.012 0-.02-.004-.028-.004-.06-.008-.088-.015-.008 0-.012-.004-.02-.004-.024-.004-.048-.012-.068-.016-.008-.004-.016-.004-.024-.008-.028-.008-.056-.016-.084-.028-.028-.008-.052-.02-.08-.031l-.024-.012a.473.473 0 01-.064-.032c-.004-.004-.012-.004-.016-.008a.735.735 0 01-.076-.043l-.016-.012a.286.286 0 01-.056-.04c-.008-.003-.012-.007-.02-.011-.024-.016-.048-.035-.068-.051a.788.788 0 01-.064-.055l-.016-.016-.048-.048-.012-.011a.793.793 0 01-.056-.064c-.004-.003-.008-.011-.012-.015a.275.275 0 01-.04-.056c-.004-.007-.008-.011-.012-.02l-.048-.07v-.004a1.41 1.41 0 01-.04-1.388zm11.196-1.116v8.715c0 .174.144.316.32.316h1.92c.176 0 .32-.142.32-.316v-8.715a4.278 4.278 0 01-2.56 0zm2.56-7.809V6.7a.319.319 0 00-.32-.316h-1.92a.319.319 0 00-.32.316v3.036a4.278 4.278 0 012.56 0zm-2.56 7.809a4.278 4.278 0 002.56 0c1.672-.533 2.88-2.079 2.88-3.905 0-1.825-1.208-3.371-2.88-3.904a4.278 4.278 0 00-2.56 0c-1.672.533-2.88 2.079-2.88 3.904 0 1.826 1.208 3.372 2.88 3.905zm.004-4.563c.012-.024.028-.047.04-.071v-.004l.048-.071.012-.02c.012-.02.028-.035.04-.055l.012-.016c.02-.023.036-.043.056-.063l.012-.012.048-.047.016-.016c.02-.02.04-.035.064-.055a.777.777 0 01.068-.051l.02-.012c.02-.012.036-.028.056-.04.004-.004.012-.007.016-.011.024-.016.048-.028.076-.044.004-.004.012-.004.016-.008.02-.011.04-.02.064-.031l.024-.012c.028-.012.052-.024.08-.032a.704.704 0 01.084-.027c.008-.004.016-.004.024-.008a.417.417 0 01.068-.016c.008 0 .012-.004.02-.004.028-.008.06-.012.088-.016.008 0 .012 0 .02-.004.024-.003.048-.003.072-.007h.024c.032 0 .06-.004.092-.004s.06 0 .092.004h.024a.44.44 0 01.092.011c.028.004.06.008.088.016.008 0 .012.004.02.004.024.004.048.012.068.016.008.004.016.004.024.008a.704.704 0 01.084.027c.028.008.052.02.08.032l.024.012c.02.008.044.02.064.031.004.004.012.004.016.008a.754.754 0 01.076.044c.004.004.012.008.016.011.02.012.04.024.056.04l.02.012c.024.015.048.035.068.051.02.016.044.035.064.055l.016.016.048.047.012.012c.02.02.04.044.056.063l.012.016c.016.016.028.036.04.055l.012.02.048.07v.005a1.412 1.412 0 01.04 1.388c-.012.024-.028.047-.04.071v.004l-.048.07c-.004.009-.008.013-.012.02-.012.02-.028.036-.04.056l-.012.016c-.02.023-.036.043-.056.063l-.012.012-.048.047-.016.016c-.02.02-.04.035-.064.055a.777.777 0 01-.068.051l-.02.012c-.02.012-.036.028-.056.04-.004.003-.012.007-.016.011-.024.016-.048.028-.076.044-.004.004-.012.004-.016.008-.02.011-.04.02-.064.031l-.024.012c-.028.012-.052.024-.08.031a.687.687 0 01-.084.028c-.008.004-.016.004-.024.008a.418.418 0 01-.068.016c-.008 0-.012.004-.02.004-.028.008-.06.012-.088.015-.008 0-.012 0-.02.004-.024.004-.048.004-.072.008h-.024c-.032 0-.06.004-.092.004s-.06 0-.092-.004h-.024c-.024 0-.048-.004-.072-.008-.008 0-.012 0-.02-.004-.028-.003-.06-.008-.088-.015-.008 0-.012-.004-.02-.004-.024-.004-.048-.012-.068-.016-.008-.004-.016-.004-.024-.008a.687.687 0 01-.084-.028c-.028-.007-.052-.02-.08-.031l-.024-.012a.474.474 0 01-.064-.032c-.004-.003-.012-.003-.016-.007a.753.753 0 01-.076-.044l-.016-.012c-.02-.011-.04-.023-.056-.039l-.02-.012c-.024-.016-.048-.035-.068-.051a.806.806 0 01-.064-.055l-.016-.016-.048-.047-.012-.012a.776.776 0 01-.056-.063l-.012-.016c-.016-.016-.028-.036-.04-.055l-.012-.02-.048-.071v-.004a1.41 1.41 0 01-.04-1.388z"
        fill={fill || '#000'}
      />
    </Svg>
  );
};

export default Control;
