"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.from");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.slice");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-properties");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.entries");

require("core-js/modules/es.object.freeze");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensurePanel = ensurePanel;
exports.init = exports.types = void 0;

var _utilDeprecate = _interopRequireDefault(require("util-deprecate"));

var _tsDedent = _interopRequireDefault(require("ts-dedent"));

var _stories = require("../lib/stories");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _templateObject() {
  var data = _taggedTemplateLiteral(["\n    Use 'parameters.key.disable' instead of 'parameters.key.disabled'.\n    \n    https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#deprecated-disabled-parameter\n  "]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

var warnDisabledDeprecated = (0, _utilDeprecate["default"])(function () {}, (0, _tsDedent["default"])(_templateObject()));
var types;
exports.types = types;

(function (types) {
  types["TAB"] = "tab";
  types["PANEL"] = "panel";
  types["TOOL"] = "tool";
  types["PREVIEW"] = "preview";
  types["NOTES_ELEMENT"] = "notes-element";
})(types || (exports.types = types = {}));

function ensurePanel(panels, selectedPanel, currentPanel) {
  var keys = Object.keys(panels);

  if (keys.indexOf(selectedPanel) >= 0) {
    return selectedPanel;
  }

  if (keys.length) {
    return keys[0];
  }

  return currentPanel;
}

var init = function init(_ref) {
  var provider = _ref.provider,
      store = _ref.store,
      fullAPI = _ref.fullAPI;
  var api = {
    getElements: function getElements(type) {
      return provider.getElements(type);
    },
    getPanels: function getPanels() {
      return api.getElements(types.PANEL);
    },
    getStoryPanels: function getStoryPanels() {
      var allPanels = api.getPanels();

      var _store$getState = store.getState(),
          storyId = _store$getState.storyId;

      var story = fullAPI.getData(storyId);

      if (!allPanels || !story || !(0, _stories.isStory)(story)) {
        return allPanels;
      }

      var parameters = story.parameters;
      var filteredPanels = {};
      Object.entries(allPanels).forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            id = _ref3[0],
            panel = _ref3[1];

        var paramKey = panel.paramKey;

        if (paramKey && parameters && parameters[paramKey] && (parameters[paramKey].disabled || parameters[paramKey].disable)) {
          if (parameters[paramKey].disabled) {
            warnDisabledDeprecated();
          }

          return;
        }

        filteredPanels[id] = panel;
      });
      return filteredPanels;
    },
    getSelectedPanel: function getSelectedPanel() {
      var _store$getState2 = store.getState(),
          selectedPanel = _store$getState2.selectedPanel;

      return ensurePanel(api.getPanels(), selectedPanel, selectedPanel);
    },
    setSelectedPanel: function setSelectedPanel(panelName) {
      store.setState({
        selectedPanel: panelName
      }, {
        persistence: 'session'
      });
    },
    setAddonState: function setAddonState(addonId, newStateOrMerger, options) {
      var nextState;

      var _store$getState3 = store.getState(),
          existing = _store$getState3.addons;

      if (typeof newStateOrMerger === 'function') {
        var merger = newStateOrMerger;
        nextState = merger(api.getAddonState(addonId));
      } else {
        nextState = newStateOrMerger;
      }

      return store.setState({
        addons: Object.assign(Object.assign({}, existing), {}, _defineProperty({}, addonId, nextState))
      }, options).then(function () {
        return api.getAddonState(addonId);
      });
    },
    getAddonState: function getAddonState(addonId) {
      return store.getState().addons[addonId];
    }
  };
  return {
    api: api,
    state: {
      selectedPanel: ensurePanel(api.getPanels(), store.getState().selectedPanel),
      addons: {}
    }
  };
};

exports.init = init;