package com.jens.automation2.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

import com.jens.automation2.ActivityPermissions;
import com.jens.automation2.AutomationService;
import com.jens.automation2.Miscellaneous;
import com.jens.automation2.Rule;
import com.jens.automation2.Trigger.Trigger_Enum;

import java.util.ArrayList;

public class ProximityReceiver implements AutomationListenerInterface
{
	public static AutomationService automationServiceRef = null;
	static float proximityLevel = -1;	// initialize with a better value than this
	static boolean proximityReceiverActive = false;

    SensorManager sensorManager;
    Sensor proximitySensor;

	static ProximityReceiver proximityReceiverInstance = null;

	public static float getProximityLevel()
	{
		return proximityLevel;
	}

    public static void startProximityReceiver(final AutomationService automationServiceRef)
    {
        if(!proximityReceiverActive)
        {
            ProximityReceiver.automationServiceRef = automationServiceRef;

            if(proximityReceiverInstance == null)
                proximityReceiverInstance = new ProximityReceiver();

            proximityReceiverInstance.startListener(automationServiceRef);

            proximityReceiverActive = true;
        }
    }
    public static void stopProximityReceiver()
    {
        if(proximityReceiverActive)
        {
            if(proximityReceiverInstance != null)
            {
                proximityReceiverInstance = null;
            }

            proximityReceiverActive = false;
        }
    }

	@Override
	public void startListener(AutomationService automationService)
	{
        if(!proximityReceiverActive)
        {
            ProximityReceiver.automationServiceRef = automationServiceRef;

            sensorManager = (SensorManager) automationService.getSystemService(Context.SENSOR_SERVICE);

            // from sensor service we are
            // calling proximity sensor
            proximitySensor = sensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);

            // handling the case if the proximity
            // sensor is not present in users device.
            if (proximitySensor == null)
            {
                Miscellaneous.logEvent("w", "No proximity sensor", "Device doesn\'t seem to have a proximity sensor.", 4);
            }
            else
            {
                // registering our sensor with sensor manager.
                sensorManager.registerListener(proximitySensorEventListener, proximitySensor, SensorManager.SENSOR_DELAY_NORMAL);
            }

            proximityReceiverActive = true;
        }
	}

	@Override
	public void stopListener(AutomationService automationService)
	{
        if(proximityReceiverActive)
        {
            if(proximityReceiverInstance != null)
            {
                if(proximitySensor != null)
                    sensorManager.unregisterListener(proximitySensorEventListener);

                proximityReceiverInstance = null;
            }

            proximityReceiverActive = false;
        }
	}

    SensorEventListener proximitySensorEventListener = new SensorEventListener()
    {
        @Override
        public void onSensorChanged(SensorEvent sensorEvent)
        {
            // check if the sensor type is proximity sensor.
            if (sensorEvent.sensor.getType() == Sensor.TYPE_PROXIMITY)
            {
                proximityLevel = (int)sensorEvent.values[0];

                Miscellaneous.logEvent("i", "Proximity", String.valueOf(proximityLevel), 5);

//                if (sensorEvent.values[0] == 0)
//                {
////                    sensorStatusTV.setText("Near");
//                }
//                else
//                {
////                    sensorStatusTV.setText("Away");
//                }

                ArrayList<Rule> ruleCandidates = Rule.findRuleCandidates(Trigger_Enum.proximity);
                for(Rule oneRule : ruleCandidates)
                {
                    if(oneRule.getsGreenLight(automationServiceRef))
                        oneRule.activate(automationServiceRef, false);
                }
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int i)
        {

        }
    };

	public static boolean haveAllPermission()
	{
		return ActivityPermissions.havePermission(ActivityPermissions.permissionNameProximity, Miscellaneous.getAnyContext());
	}

	@Override
	public boolean isListenerRunning()
	{
        return proximityReceiverActive;
	}
	@Override
	public Trigger_Enum[] getMonitoredTrigger()
	{
		// actually monitors several
		return new Trigger_Enum[] { Trigger_Enum.proximity };
	}
}