package com.jens.automation2;

import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;

import com.jens.automation2.R.layout;

public class ActivitySettings extends PreferenceActivity
{
	ListPreference lpStartScreenOptionsValues;
	CheckBoxPreference chkPrefUpdateCheck;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		Miscellaneous.setDisplayLanguage(this);

		// Dark Theme doesn't work in PreferenceActivity, so only a bright theme is readable

		if(Settings.uiTheme != 0)
			this.setTheme(R.style.AppThemeCompatLight);
//		Miscellaneous.setUiTheme(this);

		addPreferencesFromResource(layout.activity_settings);

		if(BuildConfig.FLAVOR.equals(AutomationService.flavor_name_apk))
		{
			chkPrefUpdateCheck = (CheckBoxPreference) findPreference("automaticUpdateCheck");
			chkPrefUpdateCheck.setEnabled(true);
		}
	}

	@Override
	protected void onResume()
	{
		super.onResume();
		Miscellaneous.setDisplayLanguage(this);
	}
}