package com.jens.automation2;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;

import com.google.android.material.slider.RangeSlider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActivityManageTriggerProximity extends Activity
{
    TextView tvTriggerProximityHint, tvProximityCurrentValue;
    Button bTriggerProximitySave;
    RangeSlider rsProximity;
    SeekBar sbProximityTest;

    SensorManager sensorManager;
    Sensor proximitySensor;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        Miscellaneous.setDisplayLanguage(this);

		/*
			A modern theme is required for this activity because of the RangeSlider.
			The value configured in settings is ignored.
		 */
        this.setTheme(R.style.AppThemeMaterial);

        setContentView(R.layout.activity_manage_trigger_proximity);

        rsProximity = (RangeSlider) findViewById(R.id.rsProximity);
        sbProximityTest = (SeekBar) findViewById(R.id.sbProximityTest);
        tvTriggerProximityHint = (TextView) findViewById(R.id.tvTriggerProximityHint);
        tvProximityCurrentValue = (TextView) findViewById(R.id.tvProximityCurrentValue);
        bTriggerProximitySave = (Button) findViewById(R.id.bTriggerProximitySave);

        sbProximityTest.setEnabled(false);
        tvTriggerProximityHint.setVisibility(View.GONE);

        bTriggerProximitySave.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                Intent response = new Intent();

                response.putExtra(ActivityManageRule.intentNameTriggerParameter2, String.valueOf(rsProximity.getValues().get(0)) + Trigger.triggerParameter2Split +  String.valueOf(rsProximity.getValues().get(1)));
                setResult(RESULT_OK, response);
                finish();
            }
        });

        if(getIntent().hasExtra(ActivityManageRule.intentNameTriggerParameter2))
        {
            String[] values = getIntent().getStringExtra(ActivityManageRule.intentNameTriggerParameter2).split(Trigger.triggerParameter2Split);
            rsProximity.setValues(Float.parseFloat(values[0]), Float.parseFloat(values[1]));
        }
        else
            rsProximity.setValues(0f, 10f);
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        startPreview();
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        stopPreview();
    }

    void startPreview()
    {
        sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);

        // from sensor service we are
        // calling proximity sensor
        proximitySensor = sensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);

        // handling the case if the proximity
        // sensor is not present in users device.
        if (proximitySensor == null)
        {
            tvTriggerProximityHint.setVisibility(View.VISIBLE);
            finish();
        }
        else
        {
            // registering our sensor with sensor manager.
            sensorManager.registerListener(proximitySensorEventListener, proximitySensor, SensorManager.SENSOR_DELAY_NORMAL);
        }
    }

    void stopPreview()
    {
        if(proximitySensor != null)
            sensorManager.unregisterListener(proximitySensorEventListener);
    }

    SensorEventListener proximitySensorEventListener = new SensorEventListener()
    {
        @Override
        public void onSensorChanged(SensorEvent sensorEvent)
        {
            // check if the sensor type is proximity sensor.
            if (sensorEvent.sensor.getType() == Sensor.TYPE_PROXIMITY)
            {
                sbProximityTest.setProgress((int)sensorEvent.values[0]);
                tvProximityCurrentValue.setText((String.valueOf(sensorEvent.values[0])));

//                if (sensorEvent.values[0] == 0)
//                {
                    // here we are setting our status to our textview..
                    // if sensor event return 0 then object is closed
                    // to sensor else object is away from sensor.
//                    sensorStatusTV.setText("Near");
//                }
//                else
//                {
//                    sensorStatusTV.setText("Away");
//                }
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int i)
        {

        }
    };
}