package com.jens.automation2;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;

import androidx.annotation.Nullable;

import org.apache.commons.lang3.StringUtils;

public class ActivityManageTriggerCheckVariable extends Activity
{
    EditText etVariableKeyTrigger, etVariableValueTrigger;
    CheckBox chkTriggerVariableDirection;
    Button bTriggerVariableSave;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        Miscellaneous.setDisplayLanguage(this);
        Miscellaneous.setUiTheme(this);
        setContentView(R.layout.activity_manage_trigger_check_variable);

        etVariableKeyTrigger = (EditText) findViewById(R.id.etVariableKeyTrigger);
        etVariableValueTrigger = (EditText) findViewById(R.id.etVariableValueTrigger);
        chkTriggerVariableDirection = (CheckBox)findViewById(R.id.chkTriggerVariableDirection);
        bTriggerVariableSave = (Button) findViewById(R.id.bTriggerVariableSave);

        Intent input = getIntent();

        if(input.hasExtra(ActivityManageRule.intentNameTriggerParameter1))
            chkTriggerVariableDirection.setChecked(input.getBooleanExtra(ActivityManageRule.intentNameTriggerParameter1, true));

        if(input.hasExtra(ActivityManageRule.intentNameTriggerParameter2))
        {
            String[] conditions = input.getStringExtra(ActivityManageRule.intentNameTriggerParameter2).split(Trigger.triggerParameter2Split);
            etVariableKeyTrigger.setText(conditions[0]);
            if(conditions.length > 1)
                etVariableValueTrigger.setText(conditions[1]);
        }

        chkTriggerVariableDirection.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean checked)
            {
                if(checked)
                    chkTriggerVariableDirection.setText(getResources().getString(R.string.matches));
                else
                    chkTriggerVariableDirection.setText(getResources().getString(R.string.doesNotMatch));
            }
        });

        bTriggerVariableSave.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                Intent response = new Intent();

                response.putExtra(ActivityManageRule.intentNameTriggerParameter1, chkTriggerVariableDirection.isChecked());

                if(StringUtils.isEmpty(etVariableValueTrigger.getText().toString()))
                    response.putExtra(ActivityManageRule.intentNameTriggerParameter2, etVariableKeyTrigger.getText().toString());
                else
                    response.putExtra(ActivityManageRule.intentNameTriggerParameter2, etVariableKeyTrigger.getText().toString() + Trigger.triggerParameter2Split + etVariableValueTrigger.getText().toString());

                setResult(RESULT_OK, response);
                finish();
            }
        });
    }
}