package com.jens.automation2;

import android.app.Activity;
import android.content.Intent;
import android.os.BatteryManager;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;

import androidx.annotation.Nullable;

import com.jens.automation2.receivers.BatteryReceiver;

public class ActivityManageTriggerCharging extends Activity
{
    RadioButton rbChargingOn, rbChargingOff, rbChargingTypeAny, rbChargingTypeAc, rbChargingTypeUsb, rbChargingTypeWireless;
    Button bTriggerChargingSave;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        Miscellaneous.setDisplayLanguage(this);
        Miscellaneous.setUiTheme(this);
        setContentView(R.layout.activity_manage_trigger_charging);

        rbChargingOn = (RadioButton) findViewById(R.id.rbChargingOn);
        rbChargingOff = (RadioButton) findViewById(R.id.rbChargingOff);
        rbChargingTypeAny = (RadioButton) findViewById(R.id.rbChargingTypeAny);
        rbChargingTypeAc = (RadioButton) findViewById(R.id.rbChargingTypeAc);
        rbChargingTypeUsb = (RadioButton) findViewById(R.id.rbChargingTypeUsb);
        rbChargingTypeWireless = (RadioButton) findViewById(R.id.rbChargingTypeWireless);

        bTriggerChargingSave = (Button) findViewById(R.id.bTriggerChargingSave);

        Intent input = getIntent();
        if(input.hasExtra(ActivityManageRule.intentNameTriggerParameter1))
        {

            rbChargingOn.setChecked(input.getBooleanExtra(ActivityManageRule.intentNameTriggerParameter1, true));
            rbChargingOff.setChecked(!input.getBooleanExtra(ActivityManageRule.intentNameTriggerParameter1, false));

            if(input.hasExtra(ActivityManageRule.intentNameTriggerParameter2))
            {

                String[] params2 = input.getStringExtra(ActivityManageRule.intentNameTriggerParameter2).split(Trigger.triggerParameter2Split);
                int chargingType = Integer.parseInt(params2[0]);

                rbChargingTypeAny.setChecked(chargingType == 0);
                rbChargingTypeAc.setChecked(chargingType == BatteryManager.BATTERY_PLUGGED_AC);
                rbChargingTypeUsb.setChecked(chargingType == BatteryManager.BATTERY_PLUGGED_USB);
                rbChargingTypeWireless.setChecked(chargingType == BatteryManager.BATTERY_PLUGGED_WIRELESS);
            }
        }

        bTriggerChargingSave.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                Intent response = new Intent();
                response.putExtra(ActivityManageRule.intentNameTriggerParameter1, rbChargingOn.isChecked());

                String param2 = "";

                if(rbChargingTypeAny.isChecked())
                    param2 = String.valueOf(BatteryReceiver.batteryChargingTypeAny);
                else if(rbChargingTypeAc.isChecked())
                    param2 = String.valueOf(BatteryReceiver.batteryChargingTypeAc);
                else if(rbChargingTypeUsb.isChecked())
                    param2 = String.valueOf(BatteryReceiver.batteryChargingTypeUsb);
                else if(rbChargingTypeWireless.isChecked())
                    param2 = String.valueOf(BatteryReceiver.batteryChargingTypeWireless);

                response.putExtra(ActivityManageRule.intentNameTriggerParameter2, param2);

                setResult(RESULT_OK, response);
                finish();
            }
        });
    }
}