package com.jens.automation2;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;

import androidx.annotation.Nullable;

public class ActivityManageActionLocationService extends Activity
{
    RadioButton rbActionLocationServiceOff, rbActionLocationServiceSensorsOnly, rbActionLocationServiceBatterySaving, rbActionLocationServiceHighAccuracy;
    Button bActionSetLocationServiceSave;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        Miscellaneous.setDisplayLanguage(this);
        Miscellaneous.setUiTheme(this);
        setContentView(R.layout.activity_manage_action_location_service);

        rbActionLocationServiceOff = (RadioButton) findViewById(R.id.rbActionLocationServiceOff);
        rbActionLocationServiceSensorsOnly = (RadioButton)findViewById(R.id.rbActionLocationServiceSensorsOnly);
        rbActionLocationServiceBatterySaving = (RadioButton)findViewById(R.id.rbActionLocationServiceBatterySaving);
        rbActionLocationServiceHighAccuracy = (RadioButton)findViewById(R.id.rbActionLocationServiceHighAccuracy);
        bActionSetLocationServiceSave = (Button) findViewById(R.id.bActionSetLocationServiceSave);

        Intent input = getIntent();

        if(input.hasExtra(ActivityManageRule.intentNameActionParameter2))
        {
            String[] params = input.getStringExtra(ActivityManageRule.intentNameActionParameter2).split(Action.actionParameter2Split);
            int desiredState = Integer.parseInt(params[0]);

            switch(desiredState)
            {
                case Settings.Secure.LOCATION_MODE_OFF:
                    rbActionLocationServiceOff.setChecked(true);
                    break;
                case Settings.Secure.LOCATION_MODE_SENSORS_ONLY:
                    rbActionLocationServiceSensorsOnly.setChecked(true);
                    break;
                case Settings.Secure.LOCATION_MODE_BATTERY_SAVING:
                    rbActionLocationServiceBatterySaving.setChecked(true);
                    break;
                case Settings.Secure.LOCATION_MODE_HIGH_ACCURACY:
                    rbActionLocationServiceHighAccuracy.setChecked(true);
                    break;
            }
        }

        bActionSetLocationServiceSave.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view)
            {
                Intent response = new Intent();
                if(rbActionLocationServiceOff.isChecked())
                    response.putExtra(ActivityManageRule.intentNameActionParameter2, String.valueOf(Settings.Secure.LOCATION_MODE_OFF));
                else if(rbActionLocationServiceSensorsOnly.isChecked())
                    response.putExtra(ActivityManageRule.intentNameActionParameter2, String.valueOf(Settings.Secure.LOCATION_MODE_SENSORS_ONLY));
                else if(rbActionLocationServiceBatterySaving.isChecked())
                    response.putExtra(ActivityManageRule.intentNameActionParameter2, String.valueOf(Settings.Secure.LOCATION_MODE_BATTERY_SAVING));
                else
                    response.putExtra(ActivityManageRule.intentNameActionParameter2, String.valueOf(Settings.Secure.LOCATION_MODE_HIGH_ACCURACY));

                setResult(RESULT_OK, response);
                finish();
            }
        });
    }
}
