// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get appTitle => 'Alışveriş Listesi';

  @override
  String get changeName => 'İsim değiştir';

  @override
  String get changeNick => 'Takma ad değiştir';

  @override
  String get name => 'İsim';

  @override
  String get nick => 'Takma ad';

  @override
  String get theNameCantBeEmpty => 'İsim boş olamaz';

  @override
  String get cancel => 'İptal';

  @override
  String get save => 'Kaydet';

  @override
  String get thisListHasNoResults => 'Bu listede sonuç yok';

  @override
  String get createEnvironment => 'Ortam oluştur';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Bağlantısız kullanılabilir ortamlar';

  @override
  String get environmentsOnOtherMachines => 'Diğer cihazlardaki ortamlar';

  @override
  String get importEnvironment => 'Ortamı içe aktar';

  @override
  String get syncronization => 'Senkronizasyon';

  @override
  String get loading => 'Yükleniyor...';

  @override
  String get home => 'Ana sayfa';

  @override
  String get shoppingList => 'Alışveriş Listesi';

  @override
  String get recipeList => 'Tarif Listesi';

  @override
  String get agenda => 'Ajanda';

  @override
  String get export => 'Dışa aktar';

  @override
  String get undo => 'Geri al';

  @override
  String get product => 'Ürün';

  @override
  String get markAsNeeded => ' gerekli olarak işaretlendi. ';

  @override
  String get markAsBought => ' satın alındı olarak işaretlendi. ';

  @override
  String get toBuy => 'Satın alınacak';

  @override
  String get editName => 'İsmi düzenle';

  @override
  String get delete => 'Sil';

  @override
  String get setAsBought => 'Satın alındı olarak ayarla';

  @override
  String get setAsNeeded => 'Gerekli olarak ayarla';

  @override
  String get selectRecipe => 'Tarif seç';

  @override
  String get add => 'Ekle';

  @override
  String get noNick => 'Takma ad yok';

  @override
  String get pairings => 'Eşleştirmeler';

  @override
  String get connectionType => 'Bağlantı türü';

  @override
  String get notStablished => 'Kurulmadı';

  @override
  String get stablished => 'Kuruldu';

  @override
  String get connectionState => 'Bağlantı durumu';

  @override
  String get generalConfig => 'Genel yapılandırma';

  @override
  String get scanStarted => 'Tarama başlatıldı';

  @override
  String get noResultsYet => 'Henüz sonuç yok';

  @override
  String get noName => 'İsim yok';

  @override
  String get noHost => 'Sunucu yok';

  @override
  String get error => 'Hata';

  @override
  String get saveFileToYourDesiredLocation =>
      'Dosyayı istediğiniz konuma kaydedin';

  @override
  String get exportToFile => 'Dosyaya aktar';

  @override
  String get sendExport => 'Dışa aktar ve gönder';

  @override
  String get localDeviceAvailableIPs =>
      'Geçerli cihaz aşağıdaki IP\'lerde kullanılabilir';

  @override
  String get stopServer => 'Sunucuyu durdur';

  @override
  String get startServer => 'Sunucuyu başlat';

  @override
  String get startingServer => 'Sunucu başlatılıyor...';

  @override
  String get stoppingServer => 'Sunucu durduruluyor...';

  @override
  String get errorStartingServer => 'Sunucu başlatılırken hata oluştu';

  @override
  String get nearbyDevices => 'Yakındaki cihazlar';

  @override
  String get enterAddressManually => 'Adresi elle girin';

  @override
  String get remoteAddress => 'Uzak adres';

  @override
  String get remotePort => 'Uzak port';

  @override
  String get errorEmptyRemoteAddress => 'Hata: uzak adres boş olamaz';

  @override
  String get connect => 'Bağlan';

  @override
  String get server => 'Sunucu';

  @override
  String get client => 'İstemci';

  @override
  String get inputTheAmount => 'Miktarı girin';

  @override
  String get noIngredientsYet => 'Henüz malzeme eklenmedi';

  @override
  String get addIngredients => 'Malzemeleri ekle';

  @override
  String get showPastDates => 'Geçmiş tarihleri göster';

  @override
  String get ingredients => 'Malzemeler';

  @override
  String get dates => 'Tarihler';

  @override
  String get buy => 'Satın al';

  @override
  String get all => 'Hepsi';

  @override
  String get httpClient => 'HTTP İstemcisi';

  @override
  String get httpServer => 'HTTP Sunucusu';

  @override
  String get addIngredientsToRecipe => 'Malzemeleri seç ';

  @override
  String get recipeWithoutIngredients => 'Bu tarifin malzemesi yok';

  @override
  String get noPlannedDates => 'Planlanmış tarih yok';

  @override
  String get noHTTPPairings => 'HTTP sunucularıyla önceki eşleştirme yok';

  @override
  String get loadingIps => 'IP adresleri yükleniyor';

  @override
  String get ipRefresh => 'IP\'leri yenile';

  @override
  String get planner => 'Planlayıcı';

  @override
  String ipCopied(Object address) {
    return 'IP Adresi ($address) panoya kopyalandı';
  }

  @override
  String get search => 'Ara';

  @override
  String get switchEnvironment => 'Ortamı değiştir';

  @override
  String get actions => 'Eylemler';

  @override
  String get markAllAs => 'Tümünü şu şekilde işaretle';

  @override
  String get editAmount => 'Miktarı düzenle';

  @override
  String get details => 'Ayrıntılar';

  @override
  String get enoughForA => 'Yeterli için';

  @override
  String get knownServers => 'Bilinen sunucular';

  @override
  String get noOpenConnection => 'Açık bağlantı yok';

  @override
  String get neverConnected => 'Hiç bağlanmadı';

  @override
  String get fallbackLocalNick => 'isimsiz-cihaz';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Raflara ürün ekle';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
