// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Thai (`th`).
class AppLocalizationsTh extends AppLocalizations {
  AppLocalizationsTh([String locale = 'th']) : super(locale);

  @override
  String get appTitle => 'รายการซื้อของ';

  @override
  String get changeName => 'เปลี่ยนชื่อ';

  @override
  String get changeNick => 'เปลี่ยนชื่อเล่น';

  @override
  String get name => 'ชื่อ';

  @override
  String get nick => 'ชื่อเล่น';

  @override
  String get theNameCantBeEmpty => 'ชื่อไม่สามารถเว้นว่างได้';

  @override
  String get cancel => 'ยกเลิก';

  @override
  String get save => 'บันทึก';

  @override
  String get thisListHasNoResults => 'รายการนี้ไม่มีผลลัพธ์';

  @override
  String get createEnvironment => 'สร้างสภาพแวดล้อม';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'สภาพแวดล้อมที่ใช้ได้โดยไม่มีการเชื่อมต่อ';

  @override
  String get environmentsOnOtherMachines => 'สภาพแวดล้อมในเครื่องอื่น';

  @override
  String get importEnvironment => 'นำเข้าสภาพแวดล้อม';

  @override
  String get syncronization => 'การซิงโครไนซ์';

  @override
  String get loading => 'กำลังโหลด...';

  @override
  String get home => 'หน้าแรก';

  @override
  String get shoppingList => 'รายการซื้อของ';

  @override
  String get recipeList => 'รายการสูตรอาหาร';

  @override
  String get agenda => 'วาระการประชุม';

  @override
  String get export => 'ส่งออก';

  @override
  String get undo => 'เลิกทำ';

  @override
  String get product => 'สินค้า';

  @override
  String get markAsNeeded => ' ถูกทำเครื่องหมายว่าเป็นสิ่งที่จำเป็น ';

  @override
  String get markAsBought => ' ถูกทำเครื่องหมายว่าได้ซื้อแล้ว ';

  @override
  String get toBuy => 'ที่จะซื้อ';

  @override
  String get editName => 'แก้ไขชื่อ';

  @override
  String get delete => 'ลบ';

  @override
  String get setAsBought => 'ตั้งค่าเป็นซื้อแล้ว';

  @override
  String get setAsNeeded => 'ตั้งค่าเป็นจำเป็น';

  @override
  String get selectRecipe => 'เลือกสูตร';

  @override
  String get add => 'เพิ่ม';

  @override
  String get noNick => 'ไม่มีชื่อเล่น';

  @override
  String get pairings => 'การจับคู่';

  @override
  String get connectionType => 'ประเภทการเชื่อมต่อ';

  @override
  String get notStablished => 'ยังไม่ได้จัดตั้ง';

  @override
  String get stablished => 'จัดตั้งแล้ว';

  @override
  String get connectionState => 'สถานะการเชื่อมต่อ';

  @override
  String get generalConfig => 'การตั้งค่าทั่วไป';

  @override
  String get scanStarted => 'เริ่มการสแกน';

  @override
  String get noResultsYet => 'ยังไม่มีผลลัพธ์';

  @override
  String get noName => 'ไม่มีชื่อ';

  @override
  String get noHost => 'ไม่มีโฮสต์';

  @override
  String get error => 'ข้อผิดพลาด';

  @override
  String get saveFileToYourDesiredLocation =>
      'บันทึกไฟล์ไปยังตำแหน่งที่ต้องการ';

  @override
  String get exportToFile => 'ส่งออกเป็นไฟล์';

  @override
  String get sendExport => 'ส่งออกและส่ง';

  @override
  String get localDeviceAvailableIPs =>
      'อุปกรณ์ปัจจุบันสามารถใช้งานได้ที่ IP ต่อไปนี้';

  @override
  String get stopServer => 'หยุดเซิร์ฟเวอร์';

  @override
  String get startServer => 'เริ่มเซิร์ฟเวอร์';

  @override
  String get startingServer => 'เริ่มเซิร์ฟเวอร์...';

  @override
  String get stoppingServer => 'กำลังหยุดเซิร์ฟเวอร์...';

  @override
  String get errorStartingServer => 'เกิดข้อผิดพลาดขณะเริ่มเซิร์ฟเวอร์';

  @override
  String get nearbyDevices => 'อุปกรณ์ใกล้เคียง';

  @override
  String get enterAddressManually => 'ป้อนที่อยู่ด้วยตนเอง';

  @override
  String get remoteAddress => 'ที่อยู่ระยะไกล';

  @override
  String get remotePort => 'พอร์ตระยะไกล';

  @override
  String get errorEmptyRemoteAddress => 'ข้อผิดพลาด: ที่อยู่ระยะไกลห้ามว่าง';

  @override
  String get connect => 'เชื่อมต่อ';

  @override
  String get server => 'เซิร์ฟเวอร์';

  @override
  String get client => 'ไคลเอ็นต์';

  @override
  String get inputTheAmount => 'ป้อนจำนวน';

  @override
  String get noIngredientsYet => 'ยังไม่ได้เพิ่มส่วนผสมใดๆ';

  @override
  String get addIngredients => 'เพิ่มส่วนผสม';

  @override
  String get showPastDates => 'แสดงวันที่ที่ผ่านมา';

  @override
  String get ingredients => 'ส่วนผสม';

  @override
  String get dates => 'วันที่';

  @override
  String get buy => 'ซื้อ';

  @override
  String get all => 'ทั้งหมด';

  @override
  String get httpClient => 'ไคลเอ็นต์ HTTP';

  @override
  String get httpServer => 'เซิร์ฟเวอร์ HTTP';

  @override
  String get addIngredientsToRecipe => 'เลือกส่วนผสม ';

  @override
  String get recipeWithoutIngredients => 'สูตรนี้ไม่มีส่วนผสม';

  @override
  String get noPlannedDates => 'ไม่มีวันที่วางแผนไว้';

  @override
  String get noHTTPPairings => 'ไม่มีการจับคู่ก่อนหน้ากับเซิร์ฟเวอร์ HTTP';

  @override
  String get loadingIps => 'กำลังโหลดที่อยู่ IP';

  @override
  String get ipRefresh => 'รีเฟรช IP';

  @override
  String get planner => 'ผู้วางแผน';

  @override
  String ipCopied(Object address) {
    return 'ที่อยู่ IP ($address) ถูกคัดลอกไปยังคลิปบอร์ด';
  }

  @override
  String get search => 'ค้นหา';

  @override
  String get switchEnvironment => 'สลับสภาพแวดล้อม';

  @override
  String get actions => 'การกระทำ';

  @override
  String get markAllAs => 'ทำเครื่องหมายทั้งหมดเป็น';

  @override
  String get editAmount => 'แก้ไขจำนวน';

  @override
  String get details => 'รายละเอียด';

  @override
  String get enoughForA => 'เพียงพอสำหรับ';

  @override
  String get knownServers => 'เซิร์ฟเวอร์ที่ทราบ';

  @override
  String get noOpenConnection => 'ไม่มีการเชื่อมต่อเปิด';

  @override
  String get neverConnected => 'ไม่เคยเชื่อมต่อ';

  @override
  String get fallbackLocalNick => 'อุปกรณ์-ไม่มีชื่อ';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'เพิ่มสินค้าลงในช่องทาง';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
