// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Slovak (`sk`).
class AppLocalizationsSk extends AppLocalizations {
  AppLocalizationsSk([String locale = 'sk']) : super(locale);

  @override
  String get appTitle => 'Nákupný zoznam';

  @override
  String get changeName => 'Zmeniť názov';

  @override
  String get changeNick => 'Zmeniť prezývku';

  @override
  String get name => 'Meno';

  @override
  String get nick => 'Prezývka';

  @override
  String get theNameCantBeEmpty => 'Meno nemôže byť prázdne';

  @override
  String get cancel => 'Zrušiť';

  @override
  String get save => 'Uložiť';

  @override
  String get thisListHasNoResults => 'Tento zoznam nemá žiadne výsledky';

  @override
  String get createEnvironment => 'Vytvoriť prostredie';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Dostupné prostredia bez pripojenia';

  @override
  String get environmentsOnOtherMachines => 'Prostredia na iných strojoch';

  @override
  String get importEnvironment => 'Importovať prostredie';

  @override
  String get syncronization => 'Synchronizácia';

  @override
  String get loading => 'Načítava sa...';

  @override
  String get home => 'Domov';

  @override
  String get shoppingList => 'Nákupný zoznam';

  @override
  String get recipeList => 'Zoznam receptov';

  @override
  String get agenda => 'Program';

  @override
  String get export => 'Exportovať';

  @override
  String get undo => 'Späť';

  @override
  String get product => 'Produkt';

  @override
  String get markAsNeeded => ' označené ako potrebné. ';

  @override
  String get markAsBought => ' označené ako kúpené. ';

  @override
  String get toBuy => 'Kúpiť';

  @override
  String get editName => 'Upraviť názov';

  @override
  String get delete => 'Odstrániť';

  @override
  String get setAsBought => 'Označiť ako kúpené';

  @override
  String get setAsNeeded => 'Označiť ako potrebné';

  @override
  String get selectRecipe => 'Vybrať recept';

  @override
  String get add => 'Pridať';

  @override
  String get noNick => 'Žiadna prezývka';

  @override
  String get pairings => 'Párovania';

  @override
  String get connectionType => 'Typ pripojenia';

  @override
  String get notStablished => 'Nezaložené';

  @override
  String get stablished => 'Založené';

  @override
  String get connectionState => 'Stav pripojenia';

  @override
  String get generalConfig => 'Všeobecné nastavenia';

  @override
  String get scanStarted => 'Skenovanie spustené';

  @override
  String get noResultsYet => 'Ešte žiadne výsledky';

  @override
  String get noName => 'Žiadne meno';

  @override
  String get noHost => 'Žiadny host';

  @override
  String get error => 'Chyba';

  @override
  String get saveFileToYourDesiredLocation =>
      'Uložte súbor na požadované miesto';

  @override
  String get exportToFile => 'Exportovať do súboru';

  @override
  String get sendExport => 'Exportovať a odoslať';

  @override
  String get localDeviceAvailableIPs =>
      'Súčasné zariadenie je dostupné na nasledujúcich IP adresách';

  @override
  String get stopServer => 'Zastaviť server';

  @override
  String get startServer => 'Spustiť server';

  @override
  String get startingServer => 'Server sa spúšťa...';

  @override
  String get stoppingServer => 'Server sa zastavuje...';

  @override
  String get errorStartingServer => 'Chyba pri spúšťaní servera';

  @override
  String get nearbyDevices => 'Blízke zariadenia';

  @override
  String get enterAddressManually => 'Zadajte adresu manuálne';

  @override
  String get remoteAddress => 'Vzdialená adresa';

  @override
  String get remotePort => 'Vzdialený port';

  @override
  String get errorEmptyRemoteAddress =>
      'Chyba: vzdialená adresa nemôže byť prázdna';

  @override
  String get connect => 'Pripojiť';

  @override
  String get server => 'Server';

  @override
  String get client => 'Klient';

  @override
  String get inputTheAmount => 'Zadajte množstvo';

  @override
  String get noIngredientsYet => 'Ešte neboli pridané žiadne ingrediencie';

  @override
  String get addIngredients => 'Pridať ingrediencie';

  @override
  String get showPastDates => 'Zobraziť minulé dátumy';

  @override
  String get ingredients => 'Ingrediencie';

  @override
  String get dates => 'Dátumy';

  @override
  String get buy => 'Kúpiť';

  @override
  String get all => 'Všetko';

  @override
  String get httpClient => 'HTTP klient';

  @override
  String get httpServer => 'HTTP server';

  @override
  String get addIngredientsToRecipe => 'Vybrať ingrediencie ';

  @override
  String get recipeWithoutIngredients => 'Tento recept nemá ingrediencie';

  @override
  String get noPlannedDates => 'Žiadne plánované dátumy';

  @override
  String get noHTTPPairings =>
      'Žiadne predchádzajúce párovania s HTTP servermi';

  @override
  String get loadingIps => 'Načítavam IP adresy';

  @override
  String get ipRefresh => 'Obnoviť IP';

  @override
  String get planner => 'Plánovač';

  @override
  String ipCopied(Object address) {
    return 'IP adresa ($address) skopírovaná do schránky';
  }

  @override
  String get search => 'Hľadať';

  @override
  String get switchEnvironment => 'Prepnúť prostredie';

  @override
  String get actions => 'Akcie';

  @override
  String get markAllAs => 'Označiť všetko ako';

  @override
  String get editAmount => 'Upraviť množstvo';

  @override
  String get details => 'Detaily';

  @override
  String get enoughForA => 'Dostatok pre';

  @override
  String get knownServers => 'Známe servery';

  @override
  String get noOpenConnection => 'Žiadne otvorené pripojenia';

  @override
  String get neverConnected => 'Nikdy nepripojené';

  @override
  String get fallbackLocalNick => 'neoznačené-zariadenie';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Pridať produkty do uličky';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
