// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get appTitle => 'Lista zakupów';

  @override
  String get changeName => 'Zmień nazwę';

  @override
  String get changeNick => 'Zmień przydomek';

  @override
  String get name => 'Nazwa';

  @override
  String get nick => 'Przydomek';

  @override
  String get theNameCantBeEmpty => 'Nazwa nie może być pusta';

  @override
  String get cancel => 'Anuluj';

  @override
  String get save => 'Zapisz';

  @override
  String get thisListHasNoResults => 'Ta lista nie zawiera wyników';

  @override
  String get createEnvironment => 'Utwórz środowisko';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Dostępne środowiska bez połączenia';

  @override
  String get environmentsOnOtherMachines => 'Środowiska na innych urządzeniach';

  @override
  String get importEnvironment => 'Importuj środowisko';

  @override
  String get syncronization => 'Synchronizacja';

  @override
  String get loading => 'Wczytywanie...';

  @override
  String get home => 'Strona główna';

  @override
  String get shoppingList => 'Lista zakupów';

  @override
  String get recipeList => 'Lista przepisów';

  @override
  String get agenda => 'Kalendarz';

  @override
  String get export => 'Eksportuj';

  @override
  String get undo => 'Cofnij';

  @override
  String get product => 'Produkt';

  @override
  String get markAsNeeded => ' oznaczono jako potrzebne. ';

  @override
  String get markAsBought => ' oznaczono jako kupione. ';

  @override
  String get toBuy => 'Do kupienia';

  @override
  String get editName => 'Edytuj nazwę';

  @override
  String get delete => 'Usuń';

  @override
  String get setAsBought => 'Oznacz jako kupione';

  @override
  String get setAsNeeded => 'Oznacz jako potrzebne';

  @override
  String get selectRecipe => 'Wybierz przepis';

  @override
  String get add => 'Dodaj';

  @override
  String get noNick => 'Brak przydomku';

  @override
  String get pairings => 'Parowania';

  @override
  String get connectionType => 'Typ połączenia';

  @override
  String get notStablished => 'Nie ustanowione';

  @override
  String get stablished => 'Ustanowione';

  @override
  String get connectionState => 'Stan połączenia';

  @override
  String get generalConfig => 'Ogólne ustawienia';

  @override
  String get scanStarted => 'Rozpoczęto skanowanie';

  @override
  String get noResultsYet => 'Brak wyników';

  @override
  String get noName => 'Brak nazwy';

  @override
  String get noHost => 'Brak hosta';

  @override
  String get error => 'Błąd';

  @override
  String get saveFileToYourDesiredLocation =>
      'Zapisz plik w wybranej lokalizacji';

  @override
  String get exportToFile => 'Eksportuj do pliku';

  @override
  String get sendExport => 'Eksportuj i wyślij';

  @override
  String get localDeviceAvailableIPs =>
      'Obecne urządzenie jest dostępne pod następującymi adresami IP';

  @override
  String get stopServer => 'Zatrzymaj serwer';

  @override
  String get startServer => 'Uruchom serwer';

  @override
  String get startingServer => 'Uruchamianie serwera...';

  @override
  String get stoppingServer => 'Zatrzymywanie serwera...';

  @override
  String get errorStartingServer => 'Błąd podczas uruchamiania serwera';

  @override
  String get nearbyDevices => 'Urządzenia w pobliżu';

  @override
  String get enterAddressManually => 'Wprowadź adres ręcznie';

  @override
  String get remoteAddress => 'Adres zdalny';

  @override
  String get remotePort => 'Zdalny port';

  @override
  String get errorEmptyRemoteAddress => 'Błąd: adres zdalny nie może być pusty';

  @override
  String get connect => 'Połącz';

  @override
  String get server => 'Serwer';

  @override
  String get client => 'Klient';

  @override
  String get inputTheAmount => 'Wprowadź ilość';

  @override
  String get noIngredientsYet => 'Nie dodano jeszcze składników';

  @override
  String get addIngredients => 'Dodaj składniki';

  @override
  String get showPastDates => 'Pokaż poprzednie daty';

  @override
  String get ingredients => 'Składniki';

  @override
  String get dates => 'Daty';

  @override
  String get buy => 'Kup';

  @override
  String get all => 'Wszystko';

  @override
  String get httpClient => 'Klient HTTP';

  @override
  String get httpServer => 'Serwer HTTP';

  @override
  String get addIngredientsToRecipe => 'Wybierz składniki ';

  @override
  String get recipeWithoutIngredients => 'Ten przepis nie ma składników';

  @override
  String get noPlannedDates => 'Brak zaplanowanych dat';

  @override
  String get noHTTPPairings => 'Brak wcześniejszych parowań z serwerami HTTP';

  @override
  String get loadingIps => 'Ładowanie adresów IP';

  @override
  String get ipRefresh => 'Odśwież IP';

  @override
  String get planner => 'Planer';

  @override
  String ipCopied(Object address) {
    return 'Adres IP ($address) skopiowany do schowka';
  }

  @override
  String get search => 'Szukaj';

  @override
  String get switchEnvironment => 'Zmień środowisko';

  @override
  String get actions => 'Akcje';

  @override
  String get markAllAs => 'Oznacz wszystko jako';

  @override
  String get editAmount => 'Edytuj ilość';

  @override
  String get details => 'Szczegóły';

  @override
  String get enoughForA => 'Wystarczy dla';

  @override
  String get knownServers => 'Znane serwery';

  @override
  String get noOpenConnection => 'Brak otwartych połączeń';

  @override
  String get neverConnected => 'Nigdy nie podłączono';

  @override
  String get fallbackLocalNick => 'urządzenie-bez-nazwy';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Dodaj produkty do alejki';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
