// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Malay (`ms`).
class AppLocalizationsMs extends AppLocalizations {
  AppLocalizationsMs([String locale = 'ms']) : super(locale);

  @override
  String get appTitle => 'Senarai membeli-belah';

  @override
  String get changeName => 'Tukar nama';

  @override
  String get changeNick => 'Tukar nama panggilan';

  @override
  String get name => 'Nama';

  @override
  String get nick => 'Nama panggilan';

  @override
  String get theNameCantBeEmpty => 'Nama tidak boleh kosong';

  @override
  String get cancel => 'Batal';

  @override
  String get save => 'Simpan';

  @override
  String get thisListHasNoResults => 'Senarai ini tiada keputusan';

  @override
  String get createEnvironment => 'Cipta persekitaran';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Persekitaran tersedia tanpa sambungan';

  @override
  String get environmentsOnOtherMachines => 'Persekitaran pada mesin lain';

  @override
  String get importEnvironment => 'Import persekitaran';

  @override
  String get syncronization => 'Penyegerakan';

  @override
  String get loading => 'Memuatkan...';

  @override
  String get home => 'Laman utama';

  @override
  String get shoppingList => 'Senarai membeli-belah';

  @override
  String get recipeList => 'Senarai resipi';

  @override
  String get agenda => 'Agenda';

  @override
  String get export => 'Eksport';

  @override
  String get undo => 'Batal';

  @override
  String get product => 'Produk';

  @override
  String get markAsNeeded => ' ditandakan sebagai diperlukan. ';

  @override
  String get markAsBought => ' ditandakan sebagai dibeli. ';

  @override
  String get toBuy => 'Untuk dibeli';

  @override
  String get editName => 'Edit nama';

  @override
  String get delete => 'Padam';

  @override
  String get setAsBought => 'Tandakan sebagai dibeli';

  @override
  String get setAsNeeded => 'Tandakan sebagai diperlukan';

  @override
  String get selectRecipe => 'Pilih resipi';

  @override
  String get add => 'Tambah';

  @override
  String get noNick => 'Tiada nama panggilan';

  @override
  String get pairings => 'Padanan';

  @override
  String get connectionType => 'Jenis sambungan';

  @override
  String get notStablished => 'Tidak ditubuhkan';

  @override
  String get stablished => 'Telah ditubuhkan';

  @override
  String get connectionState => 'Status sambungan';

  @override
  String get generalConfig => 'Konfigurasi am';

  @override
  String get scanStarted => 'Imbasan bermula';

  @override
  String get noResultsYet => 'Tiada keputusan lagi';

  @override
  String get noName => 'Tiada nama';

  @override
  String get noHost => 'Tiada hos';

  @override
  String get error => 'Ralat';

  @override
  String get saveFileToYourDesiredLocation =>
      'Simpan fail ke lokasi yang dikehendaki';

  @override
  String get exportToFile => 'Eksport ke fail';

  @override
  String get sendExport => 'Eksport dan hantar';

  @override
  String get localDeviceAvailableIPs =>
      'Peranti kini boleh diakses pada IP berikut';

  @override
  String get stopServer => 'Hentikan pelayan';

  @override
  String get startServer => 'Mula pelayan';

  @override
  String get startingServer => 'Memulakan pelayan...';

  @override
  String get stoppingServer => 'Menghentikan pelayan...';

  @override
  String get errorStartingServer => 'Ralat semasa memulakan pelayan';

  @override
  String get nearbyDevices => 'Peranti berdekatan';

  @override
  String get enterAddressManually => 'Masukkan alamat secara manual';

  @override
  String get remoteAddress => 'Alamat jauh';

  @override
  String get remotePort => 'Pelabuhan jauh';

  @override
  String get errorEmptyRemoteAddress => 'Ralat: alamat jauh tidak boleh kosong';

  @override
  String get connect => 'Sambung';

  @override
  String get server => 'Pelayan';

  @override
  String get client => 'Pelanggan';

  @override
  String get inputTheAmount => 'Masukkan jumlah';

  @override
  String get noIngredientsYet => 'Belum ada bahan ditambah';

  @override
  String get addIngredients => 'Tambah bahan';

  @override
  String get showPastDates => 'Tunjukkan tarikh lepas';

  @override
  String get ingredients => 'Bahan-bahan';

  @override
  String get dates => 'Tarikh';

  @override
  String get buy => 'Beli';

  @override
  String get all => 'Semua';

  @override
  String get httpClient => 'Klien HTTP';

  @override
  String get httpServer => 'Pelayan HTTP';

  @override
  String get addIngredientsToRecipe => 'Pilih bahan ';

  @override
  String get recipeWithoutIngredients => 'Resipi ini tiada bahan';

  @override
  String get noPlannedDates => 'Tiada tarikh dirancang';

  @override
  String get noHTTPPairings => 'Tiada pasangan sebelumnya dengan pelayan HTTP';

  @override
  String get loadingIps => 'Memuatkan alamat IP';

  @override
  String get ipRefresh => 'Segarkan IP';

  @override
  String get planner => 'Perancang';

  @override
  String ipCopied(Object address) {
    return 'Alamat IP ($address) disalin ke papan keratan';
  }

  @override
  String get search => 'Cari';

  @override
  String get switchEnvironment => 'Tukar persekitaran';

  @override
  String get actions => 'Tindakan';

  @override
  String get markAllAs => 'Tandakan semua sebagai';

  @override
  String get editAmount => 'Edit kuantiti';

  @override
  String get details => 'Perincian';

  @override
  String get enoughForA => 'Cukup untuk';

  @override
  String get knownServers => 'Pelayan yang diketahui';

  @override
  String get noOpenConnection => 'Tiada sambungan terbuka';

  @override
  String get neverConnected => 'Tidak pernah disambungkan';

  @override
  String get fallbackLocalNick => 'peranti-tanpa-nama';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Tambah produk ke lorong';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
