// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get appTitle => 'Lista della spesa';

  @override
  String get changeName => 'Cambia nome';

  @override
  String get changeNick => 'Cambia soprannome';

  @override
  String get name => 'Nome';

  @override
  String get nick => 'Soprannome';

  @override
  String get theNameCantBeEmpty => 'Il nome non può essere vuoto';

  @override
  String get cancel => 'Annulla';

  @override
  String get save => 'Salva';

  @override
  String get thisListHasNoResults => 'Questa lista non ha risultati';

  @override
  String get createEnvironment => 'Crea ambiente';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Ambienti disponibili senza connessione';

  @override
  String get environmentsOnOtherMachines => 'Ambienti su altri dispositivi';

  @override
  String get importEnvironment => 'Importa ambiente';

  @override
  String get syncronization => 'Sincronizzazione';

  @override
  String get loading => 'Caricamento...';

  @override
  String get home => 'Home';

  @override
  String get shoppingList => 'Lista della spesa';

  @override
  String get recipeList => 'Lista delle ricette';

  @override
  String get agenda => 'Agenda';

  @override
  String get export => 'Esporta';

  @override
  String get undo => 'Annulla';

  @override
  String get product => 'Prodotto';

  @override
  String get markAsNeeded => ' contrassegnato come necessario. ';

  @override
  String get markAsBought => ' contrassegnato come acquistato. ';

  @override
  String get toBuy => 'Da comprare';

  @override
  String get editName => 'Modifica nome';

  @override
  String get delete => 'Elimina';

  @override
  String get setAsBought => 'Segna come acquistato';

  @override
  String get setAsNeeded => 'Segna come necessario';

  @override
  String get selectRecipe => 'Seleziona ricetta';

  @override
  String get add => 'Aggiungi';

  @override
  String get noNick => 'Nessun soprannome';

  @override
  String get pairings => 'Accoppiamenti';

  @override
  String get connectionType => 'Tipo di connessione';

  @override
  String get notStablished => 'Non stabilita';

  @override
  String get stablished => 'Stabilita';

  @override
  String get connectionState => 'Stato della connessione';

  @override
  String get generalConfig => 'Configurazione generale';

  @override
  String get scanStarted => 'Scansione avviata';

  @override
  String get noResultsYet => 'Ancora nessun risultato';

  @override
  String get noName => 'Nessun nome';

  @override
  String get noHost => 'Nessun host';

  @override
  String get error => 'Errore';

  @override
  String get saveFileToYourDesiredLocation =>
      'Salva il file nella posizione desiderata';

  @override
  String get exportToFile => 'Esporta su file';

  @override
  String get sendExport => 'Esporta e invia';

  @override
  String get localDeviceAvailableIPs =>
      'Il dispositivo corrente è disponibile sui seguenti IP';

  @override
  String get stopServer => 'Arresta server';

  @override
  String get startServer => 'Avvia server';

  @override
  String get startingServer => 'Avvio del server...';

  @override
  String get stoppingServer => 'Arresto del server...';

  @override
  String get errorStartingServer => 'Errore nell\'avvio del server';

  @override
  String get nearbyDevices => 'Dispositivi vicini';

  @override
  String get enterAddressManually => 'Inserisci l\'indirizzo manualmente';

  @override
  String get remoteAddress => 'Indirizzo remoto';

  @override
  String get remotePort => 'Porta remota';

  @override
  String get errorEmptyRemoteAddress =>
      'Errore: l\'indirizzo remoto non può essere vuoto';

  @override
  String get connect => 'Connetti';

  @override
  String get server => 'Server';

  @override
  String get client => 'Client';

  @override
  String get inputTheAmount => 'Inserisci la quantità';

  @override
  String get noIngredientsYet => 'Non sono stati ancora aggiunti ingredienti';

  @override
  String get addIngredients => 'Aggiungi ingredienti';

  @override
  String get showPastDates => 'Mostra date passate';

  @override
  String get ingredients => 'Ingredienti';

  @override
  String get dates => 'Date';

  @override
  String get buy => 'Compra';

  @override
  String get all => 'Tutto';

  @override
  String get httpClient => 'Client HTTP';

  @override
  String get httpServer => 'Server HTTP';

  @override
  String get addIngredientsToRecipe => 'Seleziona ingredienti ';

  @override
  String get recipeWithoutIngredients => 'Questa ricetta non ha ingredienti';

  @override
  String get noPlannedDates => 'Nessuna data pianificata';

  @override
  String get noHTTPPairings =>
      'Non ci sono accoppiamenti precedenti con server HTTP';

  @override
  String get loadingIps => 'Caricamento indirizzi IP';

  @override
  String get ipRefresh => 'Aggiorna IP';

  @override
  String get planner => 'Pianificatore';

  @override
  String ipCopied(Object address) {
    return 'Indirizzo IP ($address) copiato negli appunti';
  }

  @override
  String get search => 'Cerca';

  @override
  String get switchEnvironment => 'Cambia ambiente';

  @override
  String get actions => 'Azioni';

  @override
  String get markAllAs => 'Segna tutto come';

  @override
  String get editAmount => 'Modifica quantità';

  @override
  String get details => 'Dettagli';

  @override
  String get enoughForA => 'Sufficiente per un(a)';

  @override
  String get knownServers => 'Server conosciuti';

  @override
  String get noOpenConnection => 'Nessuna connessione aperta';

  @override
  String get neverConnected => 'Mai connesso';

  @override
  String get fallbackLocalNick => 'dispositivo-senza-nome';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Aggiungi prodotti al corridoio';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
