// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Indonesian (`id`).
class AppLocalizationsId extends AppLocalizations {
  AppLocalizationsId([String locale = 'id']) : super(locale);

  @override
  String get appTitle => 'Daftar belanja';

  @override
  String get changeName => 'Ubah nama';

  @override
  String get changeNick => 'Ubah julukan';

  @override
  String get name => 'Nama';

  @override
  String get nick => 'Julukan';

  @override
  String get theNameCantBeEmpty => 'Nama tidak boleh kosong';

  @override
  String get cancel => 'Batal';

  @override
  String get save => 'Simpan';

  @override
  String get thisListHasNoResults => 'Daftar ini tidak memiliki hasil';

  @override
  String get createEnvironment => 'Buat lingkungan';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Lingkungan tersedia tanpa koneksi';

  @override
  String get environmentsOnOtherMachines => 'Lingkungan di mesin lain';

  @override
  String get importEnvironment => 'Impor lingkungan';

  @override
  String get syncronization => 'Sinkronisasi';

  @override
  String get loading => 'Memuat...';

  @override
  String get home => 'Beranda';

  @override
  String get shoppingList => 'Daftar belanja';

  @override
  String get recipeList => 'Daftar resep';

  @override
  String get agenda => 'Agenda';

  @override
  String get export => 'Ekspor';

  @override
  String get undo => 'Batalkan';

  @override
  String get product => 'Produk';

  @override
  String get markAsNeeded => ' ditandai sebagai diperlukan. ';

  @override
  String get markAsBought => ' ditandai sebagai dibeli. ';

  @override
  String get toBuy => 'Untuk dibeli';

  @override
  String get editName => 'Edit nama';

  @override
  String get delete => 'Hapus';

  @override
  String get setAsBought => 'Tandai sebagai dibeli';

  @override
  String get setAsNeeded => 'Tandai sebagai diperlukan';

  @override
  String get selectRecipe => 'Pilih resep';

  @override
  String get add => 'Tambah';

  @override
  String get noNick => 'Tidak ada julukan';

  @override
  String get pairings => 'Pemasangan';

  @override
  String get connectionType => 'Jenis koneksi';

  @override
  String get notStablished => 'Tidak terhubung';

  @override
  String get stablished => 'Terhubung';

  @override
  String get connectionState => 'Status koneksi';

  @override
  String get generalConfig => 'Konfigurasi umum';

  @override
  String get scanStarted => 'Pemindaian dimulai';

  @override
  String get noResultsYet => 'Belum ada hasil';

  @override
  String get noName => 'Tidak ada nama';

  @override
  String get noHost => 'Tidak ada host';

  @override
  String get error => 'Kesalahan';

  @override
  String get saveFileToYourDesiredLocation =>
      'Simpan file ke lokasi yang Anda inginkan';

  @override
  String get exportToFile => 'Ekspor ke file';

  @override
  String get sendExport => 'Ekspor dan kirim';

  @override
  String get localDeviceAvailableIPs =>
      'Perangkat saat ini tersedia pada IP berikut';

  @override
  String get stopServer => 'Hentikan server';

  @override
  String get startServer => 'Mulai server';

  @override
  String get startingServer => 'Memulai server...';

  @override
  String get stoppingServer => 'Menghentikan server...';

  @override
  String get errorStartingServer => 'Kesalahan memulai server';

  @override
  String get nearbyDevices => 'Perangkat terdekat';

  @override
  String get enterAddressManually => 'Masukkan alamat secara manual';

  @override
  String get remoteAddress => 'Alamat jarak jauh';

  @override
  String get remotePort => 'Port jarak jauh';

  @override
  String get errorEmptyRemoteAddress =>
      'Kesalahan: alamat jarak jauh tidak boleh kosong';

  @override
  String get connect => 'Hubungkan';

  @override
  String get server => 'Server';

  @override
  String get client => 'Klien';

  @override
  String get inputTheAmount => 'Masukkan jumlah';

  @override
  String get noIngredientsYet => 'Belum ada bahan yang ditambahkan';

  @override
  String get addIngredients => 'Tambahkan bahan';

  @override
  String get showPastDates => 'Tampilkan tanggal sebelumnya';

  @override
  String get ingredients => 'Bahan';

  @override
  String get dates => 'Tanggal';

  @override
  String get buy => 'Beli';

  @override
  String get all => 'Semua';

  @override
  String get httpClient => 'Klien HTTP';

  @override
  String get httpServer => 'Server HTTP';

  @override
  String get addIngredientsToRecipe => 'Pilih bahan ';

  @override
  String get recipeWithoutIngredients => 'Resep ini tidak memiliki bahan';

  @override
  String get noPlannedDates => 'Tidak ada tanggal yang direncanakan';

  @override
  String get noHTTPPairings =>
      'Tidak ada pasangan sebelumnya dengan server HTTP';

  @override
  String get loadingIps => 'Memuat alamat IP';

  @override
  String get ipRefresh => 'Segarkan IP';

  @override
  String get planner => 'Perencana';

  @override
  String ipCopied(Object address) {
    return 'Alamat IP ($address) disalin ke clipboard';
  }

  @override
  String get search => 'Cari';

  @override
  String get switchEnvironment => 'Ganti lingkungan';

  @override
  String get actions => 'Tindakan';

  @override
  String get markAllAs => 'Tandai semua sebagai';

  @override
  String get editAmount => 'Ubah jumlah';

  @override
  String get details => 'Detail';

  @override
  String get enoughForA => 'Cukup untuk';

  @override
  String get knownServers => 'Server yang dikenal';

  @override
  String get noOpenConnection => 'Tidak ada koneksi terbuka';

  @override
  String get neverConnected => 'Tidak pernah terhubung';

  @override
  String get fallbackLocalNick => 'perangkat-tanpa-nama';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Tambahkan produk ke lorong';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
