// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class AppLocalizationsHi extends AppLocalizations {
  AppLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get appTitle => 'खरीदारी की सूची';

  @override
  String get changeName => 'नाम बदलें';

  @override
  String get changeNick => 'निकनेम बदलें';

  @override
  String get name => 'नाम';

  @override
  String get nick => 'निकनेम';

  @override
  String get theNameCantBeEmpty => 'नाम खाली नहीं हो सकता';

  @override
  String get cancel => 'रद्द करें';

  @override
  String get save => 'सहेजें';

  @override
  String get thisListHasNoResults => 'इस सूची में कोई परिणाम नहीं हैं';

  @override
  String get createEnvironment => 'पर्यावरण बनाएं';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'कनेक्शन के बिना उपलब्ध वातावरण';

  @override
  String get environmentsOnOtherMachines => 'अन्य मशीनों पर वातावरण';

  @override
  String get importEnvironment => 'पर्यावरण आयात करें';

  @override
  String get syncronization => 'समनकरण';

  @override
  String get loading => 'लोड हो रहा है...';

  @override
  String get home => 'होम';

  @override
  String get shoppingList => 'खरीदारी की सूची';

  @override
  String get recipeList => 'रेसिपी सूची';

  @override
  String get agenda => 'एजेंडा';

  @override
  String get export => 'निर्यात';

  @override
  String get undo => 'पूर्ववत करें';

  @override
  String get product => 'उत्पाद';

  @override
  String get markAsNeeded => ' को आवश्यक के रूप में चिह्नित किया गया। ';

  @override
  String get markAsBought => ' को खरीदा गया के रूप में चिह्नित किया गया। ';

  @override
  String get toBuy => 'खरीदने के लिए';

  @override
  String get editName => 'नाम संपादित करें';

  @override
  String get delete => 'हटाएँ';

  @override
  String get setAsBought => 'खरीदा गया के रूप में सेट करें';

  @override
  String get setAsNeeded => 'आवश्यक के रूप में सेट करें';

  @override
  String get selectRecipe => 'रेसिपी चुनें';

  @override
  String get add => 'जोड़ें';

  @override
  String get noNick => 'कोई निकनेम नहीं';

  @override
  String get pairings => 'पेयरिंग्स';

  @override
  String get connectionType => 'कनेक्शन प्रकार';

  @override
  String get notStablished => 'स्थापित नहीं';

  @override
  String get stablished => 'स्थापित';

  @override
  String get connectionState => 'कनेक्शन स्थिति';

  @override
  String get generalConfig => 'सामान्य कॉन्फ़िग';

  @override
  String get scanStarted => 'स्कैन शुरू हुआ';

  @override
  String get noResultsYet => 'अभी तक कोई परिणाम नहीं';

  @override
  String get noName => 'कोई नाम नहीं';

  @override
  String get noHost => 'कोई होस्ट नहीं';

  @override
  String get error => 'त्रुटि';

  @override
  String get saveFileToYourDesiredLocation =>
      'अपनी वांछित स्थान पर फ़ाइल सहेजें';

  @override
  String get exportToFile => 'फ़ाइल में निर्यात करें';

  @override
  String get sendExport => 'निर्यात और भेजें';

  @override
  String get localDeviceAvailableIPs =>
      'वर्तमान डिवाइस निम्नलिखित IP पर उपलब्ध है';

  @override
  String get stopServer => 'सर्वर रोकें';

  @override
  String get startServer => 'सर्वर शुरू करें';

  @override
  String get startingServer => 'सर्वर शुरू हो रहा है...';

  @override
  String get stoppingServer => 'सर्वर रोक दिया जा रहा है...';

  @override
  String get errorStartingServer => 'सर्वर शुरू करते समय त्रुटि';

  @override
  String get nearbyDevices => 'पास के उपकरण';

  @override
  String get enterAddressManually => 'पता मैन्युअल रूप से दर्ज करें';

  @override
  String get remoteAddress => 'रिमोट पता';

  @override
  String get remotePort => 'रिमोट पोर्ट';

  @override
  String get errorEmptyRemoteAddress => 'त्रुटि: रिमोट पता खाली नहीं हो सकता';

  @override
  String get connect => 'कनेक्ट';

  @override
  String get server => 'सर्वर';

  @override
  String get client => 'क्लाइंट';

  @override
  String get inputTheAmount => 'मात्रा दर्ज करें';

  @override
  String get noIngredientsYet => 'अभी तक कोई सामग्री नहीं जोड़ी गई';

  @override
  String get addIngredients => 'सामग्री जोड़ें';

  @override
  String get showPastDates => 'पिछली तिथियाँ दिखाएँ';

  @override
  String get ingredients => 'सामग्री';

  @override
  String get dates => 'तिथियाँ';

  @override
  String get buy => 'खरीदें';

  @override
  String get all => 'सब कुछ';

  @override
  String get httpClient => 'HTTP क्लाइंट';

  @override
  String get httpServer => 'HTTP सर्वर';

  @override
  String get addIngredientsToRecipe => 'सामग्री चुनें ';

  @override
  String get recipeWithoutIngredients => 'इस रेसिपी में कोई सामग्री नहीं है';

  @override
  String get noPlannedDates => 'कोई योजनाबद्ध तिथि नहीं';

  @override
  String get noHTTPPairings => 'HTTP सर्वरों के साथ कोई पिछले पेयरिंग नहीं है';

  @override
  String get loadingIps => 'IP पते लोड हो रहे हैं';

  @override
  String get ipRefresh => 'IP रिफ्रेश';

  @override
  String get planner => 'प्लैनर';

  @override
  String ipCopied(Object address) {
    return 'IP पता ($address) क्लिपबोर्ड पर कॉपी किया गया';
  }

  @override
  String get search => 'खोज';

  @override
  String get switchEnvironment => 'पर्यावरण बदलें';

  @override
  String get actions => 'क्रियाएँ';

  @override
  String get markAllAs => 'सभी चिह्नित करें';

  @override
  String get editAmount => 'राशि संपादित करें';

  @override
  String get details => 'विवरण';

  @override
  String get enoughForA => 'के लिए पर्याप्त';

  @override
  String get knownServers => 'ज्ञात सर्वर';

  @override
  String get noOpenConnection => 'कोई खुला कनेक्शन नहीं';

  @override
  String get neverConnected => 'कभी कनेक्ट नहीं हुआ';

  @override
  String get fallbackLocalNick => 'अनाम-डिवाइस';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'एक आइल में उत्पाद जोड़ें';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
