// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class AppLocalizationsHe extends AppLocalizations {
  AppLocalizationsHe([String locale = 'he']) : super(locale);

  @override
  String get appTitle => 'רשימת קניות';

  @override
  String get changeName => 'שנה שם';

  @override
  String get changeNick => 'שנה כינוי';

  @override
  String get name => 'שם';

  @override
  String get nick => 'כינוי';

  @override
  String get theNameCantBeEmpty => 'השם לא יכול להיות ריק';

  @override
  String get cancel => 'ביטול';

  @override
  String get save => 'שמור';

  @override
  String get thisListHasNoResults => 'רשימה זו אין לה תוצאות';

  @override
  String get createEnvironment => 'צור סביבה';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'סביבות זמינות ללא חיבור';

  @override
  String get environmentsOnOtherMachines => 'סביבות במכונות אחרות';

  @override
  String get importEnvironment => 'ייבא סביבה';

  @override
  String get syncronization => 'סנכרון';

  @override
  String get loading => 'טוען...';

  @override
  String get home => 'בית';

  @override
  String get shoppingList => 'רשימת קניות';

  @override
  String get recipeList => 'רשימת מתכונים';

  @override
  String get agenda => 'סדר יום';

  @override
  String get export => 'ייצא';

  @override
  String get undo => 'בטל';

  @override
  String get product => 'מוצר';

  @override
  String get markAsNeeded => ' סומן כנדרש. ';

  @override
  String get markAsBought => ' סומן כנרכש. ';

  @override
  String get toBuy => 'לקנות';

  @override
  String get editName => 'ערוך שם';

  @override
  String get delete => 'מחק';

  @override
  String get setAsBought => 'סמן כנרכש';

  @override
  String get setAsNeeded => 'סמן כנדרש';

  @override
  String get selectRecipe => 'בחר מתכון';

  @override
  String get add => 'הוספה';

  @override
  String get noNick => 'אין כינוי';

  @override
  String get pairings => 'זיווגים';

  @override
  String get connectionType => 'סוג חיבור';

  @override
  String get notStablished => 'לא הוקם';

  @override
  String get stablished => 'הוקם';

  @override
  String get connectionState => 'מצב חיבור';

  @override
  String get generalConfig => 'הגדרות כלליות';

  @override
  String get scanStarted => 'סריקה התחילה';

  @override
  String get noResultsYet => 'עדיין אין תוצאות';

  @override
  String get noName => 'אין שם';

  @override
  String get noHost => 'אין מארח';

  @override
  String get error => 'שגיאה';

  @override
  String get saveFileToYourDesiredLocation => 'שמור קובץ למיקום הרצוי';

  @override
  String get exportToFile => 'ייצא לקובץ';

  @override
  String get sendExport => 'ייצא ושלח';

  @override
  String get localDeviceAvailableIPs => 'המכשיר הנוכחי זמין בכתובות ה-IP הבאות';

  @override
  String get stopServer => 'עצור שרת';

  @override
  String get startServer => 'הפעל שרת';

  @override
  String get startingServer => 'השרת מתחיל...';

  @override
  String get stoppingServer => 'השרת נעצר...';

  @override
  String get errorStartingServer => 'שגיאה בהפעלת השרת';

  @override
  String get nearbyDevices => 'מכשירים בקרבת מקום';

  @override
  String get enterAddressManually => 'הזן כתובת באופן ידני';

  @override
  String get remoteAddress => 'כתובת מרוחקת';

  @override
  String get remotePort => 'פורט מרוחק';

  @override
  String get errorEmptyRemoteAddress =>
      'שגיאה: הכתובת המרוחקת לא יכולה להיות ריקה';

  @override
  String get connect => 'התחבר';

  @override
  String get server => 'שרת';

  @override
  String get client => 'לקוח';

  @override
  String get inputTheAmount => 'הזן את הכמות';

  @override
  String get noIngredientsYet => 'טרם נוספו רכיבים';

  @override
  String get addIngredients => 'הוסף רכיבים';

  @override
  String get showPastDates => 'הצג תאריכים קודמים';

  @override
  String get ingredients => 'מרכיבים';

  @override
  String get dates => 'תאריכים';

  @override
  String get buy => 'קנה';

  @override
  String get all => 'הכל';

  @override
  String get httpClient => 'קליינט HTTP';

  @override
  String get httpServer => 'שרת HTTP';

  @override
  String get addIngredientsToRecipe => 'בחר מרכיבים ';

  @override
  String get recipeWithoutIngredients => 'מתכון זה אינו כולל מרכיבים';

  @override
  String get noPlannedDates => 'אין תאריכים מתוכננים';

  @override
  String get noHTTPPairings => 'אין זיווגים קודמים עם שרתי HTTP';

  @override
  String get loadingIps => 'טוען כתובות IP';

  @override
  String get ipRefresh => 'רענן IP';

  @override
  String get planner => 'מתכנן';

  @override
  String ipCopied(Object address) {
    return 'כתובת ה-IP ($address) הועתקה ללוח';
  }

  @override
  String get search => 'חפש';

  @override
  String get switchEnvironment => 'החלף סביבה';

  @override
  String get actions => 'פעולות';

  @override
  String get markAllAs => 'סמן הכל כ';

  @override
  String get editAmount => 'ערוך כמות';

  @override
  String get details => 'פרטים';

  @override
  String get enoughForA => 'מספיק עבור';

  @override
  String get knownServers => 'שרתים ידועים';

  @override
  String get noOpenConnection => 'אין חיבור פתוח';

  @override
  String get neverConnected => 'מעולם לא התחבר';

  @override
  String get fallbackLocalNick => 'מכשיר-ללא-שם';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'הוסף מוצרים למסלול';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
