// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get appTitle => 'Λίστα αγορών';

  @override
  String get changeName => 'Αλλαγή ονόματος';

  @override
  String get changeNick => 'Αλλαγή ψευδώνυμου';

  @override
  String get name => 'Όνομα';

  @override
  String get nick => 'Παρατσούκλι';

  @override
  String get theNameCantBeEmpty => 'Το όνομα δεν μπορεί να είναι κενό';

  @override
  String get cancel => 'Ακύρωση';

  @override
  String get save => 'Αποθήκευση';

  @override
  String get thisListHasNoResults => 'Αυτή η λίστα δεν έχει αποτελέσματα';

  @override
  String get createEnvironment => 'Δημιουργία περιβάλλοντος';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'Διαθέσιμα περιβάλλοντα χωρίς σύνδεση';

  @override
  String get environmentsOnOtherMachines =>
      'Περιβάλλοντα σε άλλους υπολογιστές';

  @override
  String get importEnvironment => 'Εισαγωγή περιβάλλοντος';

  @override
  String get syncronization => 'Συγχρονισμός';

  @override
  String get loading => 'Φόρτωση...';

  @override
  String get home => 'Αρχική';

  @override
  String get shoppingList => 'Λίστα αγορών';

  @override
  String get recipeList => 'Λίστα συνταγών';

  @override
  String get agenda => 'Ημερήσια διάταξη';

  @override
  String get export => 'Εξαγωγή';

  @override
  String get undo => 'Αναίρεση';

  @override
  String get product => 'Προϊόν';

  @override
  String get markAsNeeded => ' επισημάνθηκε ως απαραίτητο. ';

  @override
  String get markAsBought => ' επισημάνθηκε ως αγορασμένο. ';

  @override
  String get toBuy => 'Να αγοραστεί';

  @override
  String get editName => 'Επεξεργασία ονόματος';

  @override
  String get delete => 'Διαγραφή';

  @override
  String get setAsBought => 'Ορισμός ως αγορασμένο';

  @override
  String get setAsNeeded => 'Ορισμός ως απαραίτητο';

  @override
  String get selectRecipe => 'Επιλογή συνταγής';

  @override
  String get add => 'Προσθήκη';

  @override
  String get noNick => 'Χωρίς παρατσούκλι';

  @override
  String get pairings => 'Ζευγαρώματα';

  @override
  String get connectionType => 'Τύπος σύνδεσης';

  @override
  String get notStablished => 'Μη καθιερωμένο';

  @override
  String get stablished => 'Καθιερωμένο';

  @override
  String get connectionState => 'Κατάσταση σύνδεσης';

  @override
  String get generalConfig => 'Γενικές ρυθμίσεις';

  @override
  String get scanStarted => 'Ξεκίνησε σάρωση';

  @override
  String get noResultsYet => 'Δεν υπάρχουν ακόμη αποτελέσματα';

  @override
  String get noName => 'Δεν υπάρχει όνομα';

  @override
  String get noHost => 'Δεν υπάρχει κεντρικός υπολογιστής';

  @override
  String get error => 'Σφάλμα';

  @override
  String get saveFileToYourDesiredLocation =>
      'Αποθηκεύστε το αρχείο στη θέση που επιθυμείτε';

  @override
  String get exportToFile => 'Εξαγωγή σε αρχείο';

  @override
  String get sendExport => 'Εξαγωγή και αποστολή';

  @override
  String get localDeviceAvailableIPs =>
      'Η τρέχουσα συσκευή είναι διαθέσιμη στις ακόλουθες διευθύνσεις IP';

  @override
  String get stopServer => 'Διακοπή διακομιστή';

  @override
  String get startServer => 'Έναρξη διακομιστή';

  @override
  String get startingServer => 'Εκκίνηση διακομιστή...';

  @override
  String get stoppingServer => 'Τερματισμός διακομιστή...';

  @override
  String get errorStartingServer => 'Σφάλμα κατά την εκκίνηση του διακομιστή';

  @override
  String get nearbyDevices => 'Συσκευές κοντά';

  @override
  String get enterAddressManually => 'Εισαγάγετε διεύθυνση χειροκίνητα';

  @override
  String get remoteAddress => 'Απομακρυσμένη διεύθυνση';

  @override
  String get remotePort => 'Απομακρυσμένη θύρα';

  @override
  String get errorEmptyRemoteAddress =>
      'Σφάλμα: η απομακρυσμένη διεύθυνση δεν μπορεί να είναι κενή';

  @override
  String get connect => 'Σύνδεση';

  @override
  String get server => 'Διακομιστής';

  @override
  String get client => 'Πελάτης';

  @override
  String get inputTheAmount => 'Εισάγετε την ποσότητα';

  @override
  String get noIngredientsYet => 'Δεν έχουν προστεθεί ακόμη υλικά';

  @override
  String get addIngredients => 'Προσθήκη υλικών';

  @override
  String get showPastDates => 'Εμφάνιση παλαιότερων ημερομηνιών';

  @override
  String get ingredients => 'Υλικά';

  @override
  String get dates => 'Ημερομηνίες';

  @override
  String get buy => 'Αγορά';

  @override
  String get all => 'Όλα';

  @override
  String get httpClient => 'HTTP πελάτης';

  @override
  String get httpServer => 'HTTP διακομιστής';

  @override
  String get addIngredientsToRecipe => 'Επιλέξτε υλικά ';

  @override
  String get recipeWithoutIngredients => 'Αυτή η συνταγή δεν έχει υλικά';

  @override
  String get noPlannedDates => 'Δεν υπάρχουν προγραμματισμένες ημερομηνίες';

  @override
  String get noHTTPPairings =>
      'Δεν υπάρχουν προηγούμενα ζευγαρώματα με HTTP διακομιστές';

  @override
  String get loadingIps => 'Φόρτωση διευθύνσεων IP';

  @override
  String get ipRefresh => 'Ανανέωση IP';

  @override
  String get planner => 'Προγραμματιστής';

  @override
  String ipCopied(Object address) {
    return 'Διεύθυνση IP ($address) αντιγράφηκε στο πρόχειρο';
  }

  @override
  String get search => 'Αναζήτηση';

  @override
  String get switchEnvironment => 'Αλλαγή περιβάλλοντος';

  @override
  String get actions => 'Ενέργειες';

  @override
  String get markAllAs => 'Σήμανση όλων ως';

  @override
  String get editAmount => 'Επεξεργασία ποσότητας';

  @override
  String get details => 'Λεπτομέρειες';

  @override
  String get enoughForA => 'Αρκετό για ένα';

  @override
  String get knownServers => 'Γνωστοί διακομιστές';

  @override
  String get noOpenConnection => 'Καμία ανοιχτή σύνδεση';

  @override
  String get neverConnected => 'Ποτέ συνδεδεμένο';

  @override
  String get fallbackLocalNick => 'ανώνυμη-συσκευή';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'Προσθήκη προϊόντων στη λωρίδα';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
