// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Bengali Bangla (`bn`).
class AppLocalizationsBn extends AppLocalizations {
  AppLocalizationsBn([String locale = 'bn']) : super(locale);

  @override
  String get appTitle => 'কেনাকাটার তালিকা';

  @override
  String get changeName => 'নাম পরিবর্তন করুন';

  @override
  String get changeNick => 'ডাকনাম পরিবর্তন করুন';

  @override
  String get name => 'নাম';

  @override
  String get nick => 'ডাকনাম';

  @override
  String get theNameCantBeEmpty => 'নাম খালি থাকতে পারে না';

  @override
  String get cancel => 'বাতিল';

  @override
  String get save => 'সংরক্ষণ';

  @override
  String get thisListHasNoResults => 'এই তালিকায় কোনও ফলাফল নেই';

  @override
  String get createEnvironment => 'পরিবেশ তৈরি করুন';

  @override
  String get availableEnvironmentsWithoutConnection =>
      'সংযোগ ছাড়া উপলভ্য পরিবেশসমূহ';

  @override
  String get environmentsOnOtherMachines => 'অন্যান্য মেশিনগুলির পরিবেশ';

  @override
  String get importEnvironment => 'পরিবেশ আমদানি করুন';

  @override
  String get syncronization => 'সিঙ্ক্রোনাইজেশন';

  @override
  String get loading => 'লোড হচ্ছে...';

  @override
  String get home => 'হোম';

  @override
  String get shoppingList => 'কেনাকাটার তালিকা';

  @override
  String get recipeList => 'রেসিপি তালিকা';

  @override
  String get agenda => 'অ্যাজেন্ডা';

  @override
  String get export => 'রপ্তানি';

  @override
  String get undo => 'পূর্বাবস্থা';

  @override
  String get product => 'পণ্য';

  @override
  String get markAsNeeded => ' চিহ্নিত করা হয়েছে প্রয়োজনীয়। ';

  @override
  String get markAsBought => ' চিহ্নিত করা হয়েছে কেনা হয়েছে। ';

  @override
  String get toBuy => 'কিনতে';

  @override
  String get editName => 'নাম সম্পাদনা করুন';

  @override
  String get delete => 'মুছুন';

  @override
  String get setAsBought => 'কেনা হিসাবে সেট করুন';

  @override
  String get setAsNeeded => 'প্রয়োজনিয় হিসাবে সেট করুন';

  @override
  String get selectRecipe => 'রেসিপি নির্বাচন করুন';

  @override
  String get add => 'যোগ করুন';

  @override
  String get noNick => 'কোনও ডাকনাম নেই';

  @override
  String get pairings => 'পেয়ারিংস';

  @override
  String get connectionType => 'সংযোগের ধরন';

  @override
  String get notStablished => 'স্থাপিত নয়';

  @override
  String get stablished => 'স্থাপিত';

  @override
  String get connectionState => 'সংযোগ অবস্থা';

  @override
  String get generalConfig => 'সাধারণ কনফিগ';

  @override
  String get scanStarted => 'স্ক্যান শুরু হয়েছে';

  @override
  String get noResultsYet => 'এখনও কোনো ফলাফল নেই';

  @override
  String get noName => 'কোনো নাম নেই';

  @override
  String get noHost => 'কোনো হোস্ট নেই';

  @override
  String get error => 'ত্রুটি';

  @override
  String get saveFileToYourDesiredLocation =>
      'আপনার পছন্দের স্থানে ফাইল সংরক্ষণ করুন';

  @override
  String get exportToFile => 'ফাইলে রপ্তানি করুন';

  @override
  String get sendExport => 'রপ্তানি এবং পাঠান';

  @override
  String get localDeviceAvailableIPs =>
      'বর্তমান ডিভাইস নিম্নলিখিত আইপি-তে উপলব্ধ';

  @override
  String get stopServer => 'সার্ভার বন্ধ করুন';

  @override
  String get startServer => 'সার্ভার শুরু করুন';

  @override
  String get startingServer => 'সার্ভার শুরু হচ্ছে...';

  @override
  String get stoppingServer => 'সার্ভার বন্ধ করা হচ্ছে...';

  @override
  String get errorStartingServer => 'সার্ভার শুরু করতে ত্রুটি';

  @override
  String get nearbyDevices => 'কাছের ডিভাইসসমূহ';

  @override
  String get enterAddressManually => 'ঠিকানা ম্যানুয়ালি লিখুন';

  @override
  String get remoteAddress => 'রিমোট ঠিকানা';

  @override
  String get remotePort => 'রিমোট পোর্ট';

  @override
  String get errorEmptyRemoteAddress => 'ত্রুটি: রিমোট ঠিকানা খালি হতে পারে না';

  @override
  String get connect => 'সংযোগ করুন';

  @override
  String get server => 'সার্ভার';

  @override
  String get client => 'ক্লায়েন্ট';

  @override
  String get inputTheAmount => 'পরিমাণ লিখুন';

  @override
  String get noIngredientsYet => 'এখনও কোনও উপকরণ যোগ করা হয়নি';

  @override
  String get addIngredients => 'উপকরণ যোগ করুন';

  @override
  String get showPastDates => 'পূর্ববর্তী তারিখগুলি দেখান';

  @override
  String get ingredients => 'উপকরণ';

  @override
  String get dates => 'তারিখগুলি';

  @override
  String get buy => 'কিনুন';

  @override
  String get all => 'সব কিছু';

  @override
  String get httpClient => 'HTTP ক্লায়েন্ট';

  @override
  String get httpServer => 'HTTP সার্ভার';

  @override
  String get addIngredientsToRecipe => 'উপকরণ নির্বাচন করুন ';

  @override
  String get recipeWithoutIngredients => 'এই রেসিপিতে কোনও উপকরণ নেই';

  @override
  String get noPlannedDates => 'কোনও পরিকল্পিত তারিখ নেই';

  @override
  String get noHTTPPairings =>
      'HTTP সার্ভারগুলির সাথে কোনো পূর্ববর্তী পেয়ারিং নেই';

  @override
  String get loadingIps => 'IP ঠিকানা লোড হচ্ছে';

  @override
  String get ipRefresh => 'IP রিফ্রেশ';

  @override
  String get planner => 'পরিকল্পনাকারী';

  @override
  String ipCopied(Object address) {
    return 'আইপি ঠিকানা ($address) ক্লিপবোর্ডে কপি করা হয়েছে';
  }

  @override
  String get search => 'অনুসন্ধান';

  @override
  String get switchEnvironment => 'পরিবেশ পরিবর্তন করুন';

  @override
  String get actions => 'কর্মগুলি';

  @override
  String get markAllAs => 'সবগুলোকে হিসাবে চিহ্নিত করুন';

  @override
  String get editAmount => 'পরিমাণ সম্পাদনা করুন';

  @override
  String get details => 'বিস্তারিত';

  @override
  String get enoughForA => 'পর্যাপ্ত একটি';

  @override
  String get knownServers => 'পরিচিত সার্ভার';

  @override
  String get noOpenConnection => 'কোনও খোলা সংযোগ নেই';

  @override
  String get neverConnected => 'কখনও সংযুক্ত হয়নি';

  @override
  String get fallbackLocalNick => 'অনামা-ডিভাইস';

  @override
  String get supermarketList => 'Supermarket list';

  @override
  String get aisles => 'Aisles';

  @override
  String numberOfProducts(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: '1 product',
      zero: 'No products',
    );
    return '$_temp0';
  }

  @override
  String numberOfAisles(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count aisles',
      one: '1 aisle',
      zero: 'No aisles',
    );
    return '$_temp0';
  }

  @override
  String get addProductsToAisle => 'শেলফে পণ্য যোগ করুন';

  @override
  String get selectSupermarket => 'Select Supermarket...';
}
