## 2.26.1

- Fix `generatedAs` not being generated for versioned schema imports.
- Avoid the use of the shared database cache in the `SchemaVerifier`
  implementation.
- Fix crash when `drift_dev schema dump` is used on SQLite databases with
  triggers, views or indexes.
- CLI: Don't exit with code `0` when no command was selected.

## 2.26.0

- Fix warning on Dart-defined views referencing the same table multiple times.
- Don't generate unnecessary verification code.
- Suggest a test with data integrity when adding a new column without a default
  value in `make-migrations`.

## 2.25.2

- Fix `generateInsertable: true` on `@UseRowClass` not respecting inherited
  getters.
- Fix lints in generated test code for `make-migrations`.

## 2.25.1

- Fix schema exports ignoring `store_date_time_values_as_text: true` when Dart
  tables with default constraints on columns are involved.

## 2.25.0

- Fix incorrect code when applying non-nullable type converters with a nullable
  JSON type to nullable column.
- Fix missing outputs for drift files only consisting of imports in modular
  generation mode.
- Allow generating manager references across different files in modular
  generation mode.
- Fix class names with dollar signs not being escaped in drift-generated
  `toString()`.
- Make-migrations command: Use `flutter_test` if the core `test` package is
  unavailable and warn when database class needs changes for test.

## 2.24.0

- Support versions `7.x` of the `analyzer` package.

## 2.23.1

- Generate typed reference-resolving queries through the manager API when
  modular code-generation is enabled. Previously, this feature was only enabled
  for monolithic generation modes.
- Fix generating manager code around references when custom row classes are involved.

## 2.23.0

- Fix custom companion names on `@DataClassName` not being recognized.
- Improve schema exports to resolve default values instead of embedding their source.
- Update dependencies to support latest `dart_style` version.
- Fix generating dialect-specific code when only a single dialect (that isn't `sqlite3`) is enabled.

## 2.22.1

- Fix generating Dart expressions without an inferred type.

## 2.22.0

- CLI options dealing with schemas now support views defined in Dart ([#3285](https://github.com/simolus3/drift/issues/3285)).
- Pass language version to dart formatter when generating code.
- Deprecate `package:drift_dev/api/migrations.dart` in favor of `package:drift_dev/api/migrations_native.dart`.
- Support [runtime schema verification](https://drift.simonbinder.eu/migrations/tests/#verifying-a-database-schema-at-runtime)
  on the web.
- Fix generated code missing question marks for nullable types in some instances.
- Add (opt-in) `row_class_constructor_all_required` builder option.
- Support the `dbstat` table in drift-file queries when enabling the `dbstat` module.
- Fix `make-migrations` using invalid import URIs in generated test on Windows.

## 2.21.2

- Fix test template generated by `make-migrations` to not assume the name of
  the database class.

## 2.21.1

- Fix generated code missing question marks for nullable types in some instances.

## 2.21.0

- Fix Dart-defined `check` constraints not being considered in exported
  schemas.
- Columns can now be defined with `late final` fields. Defining columns with getters `=>` is still supported too.
  ```dart
  class MyTable extends Table {
    // Before:
    IntColumn get id => integer().autoIncrement()();

    // After:
    late final id = integer().nullable()();
  }
  ```
- Make `build.yaml` definitions pass `build_runner doctor`.
- Fix `generate_manager` option not consistently being applied to modular builds.
- Add the `make-migrations` command which combines the existing schema commands
  into a single tool.

## 2.20.3

- Fix internal serialization-related errors for triggers targeting views.

## 2.20.2

- Strip leading numbers when generating modular accessor names for drift files,
  fixing syntax errors.
- Support triggers targeting views.
- Include dialect-specific constraints in exported schema files.
- Fix `schema export` not respecting column constraints of the target dialect.

## 2.20.1

- Fix a code generation bug causing managers to reference the wrong column when
  building joins.

## 2.20.0

- Add `drift dev schema export` command, which exports the DDL statements making
  up a database schema based on its definition in source.

## 2.19.1

- Fix `drift_dev schema dump` not working with older versions of the `analyzer`
  package that are still supported by `drift_dev`.

## 2.19.0

- Fix generated `CREATE VIEW` statements containing existing row class syntax
  only supposed to be used during static analysis.
- Fix Dart views referencing the same column from different table aliases using
  columns with the same name.
- Fix `drift_dev schema steps` generating invalid code when no migrations have
  been defined yet.
- Fix generated imports for extension member references in modular mode.

## 2.18.0

- Add support for the `geopoly` extension in drift files.
- Improve finding the correct import alias in generated code for part files.

## 2.17.0

- Fix drift using the wrong import alias in generated part files.
- Add the `use_sql_column_name_as_json_key` builder option.
- Add a `setup` parameter to `SchemaVerifier`. It is called when the verifier
  creates database connections (similar to the callback on `NativeDatabase`)
  and can be used to register custom functions.

## 2.16.0

- Keep import alias when referencing existing elements in generated code
  ([#2845](https://github.com/simolus3/drift/issues/2845)).

## 2.15.0

- Potentially __breaking change__: Fix a bug causing `NULL` column constraints
  not to show up in generated table definitions.
  This is a breaking change drift's migration tooling is used, since they will
  not expect the `NULL` column constraint to be there.
  After upgrading, you can either drop the `NULL` constraint from your drift
  files to make it consistent with the schema (since `NULL` column constraints
  are the default ignored by sqlite3), or increment the schema version and run
  a `TableMigration` on affected tables to make column constraints consistent.

## 2.14.1

- Fix inconsistencies when generating `Variable` instances for columns with
  custom types.
- Fix a build performance regression introduced in version 2.14.0 related to
  analyzing imports in drift files.

## 2.14.0

- __Breaking change__: The name of the generated row class derived from the name
  of the Dart table name now supports more forms of plurals.
  For instance, a table without a `@DataClassName` annotation named `Categories`
  would now generate a `Category` class instead of `Categorie`. This is done in
  a minor release because we assume most users are using `@DataClassName` in those
  cases.
- Make versioned schema snapshots generated by `drift_dev schema steps` public.
- Don't generate `const` row classes when they are extending a class which
  isn't const.
- Fix indices attached to tables not generating reliably.

## 2.13.2

- Fix generated queries relying on custom types.

## 2.13.1

- Add `has_separate_analyzer` option to optimize builds using the `not_shared` builder.
- Avoid illegal references to implicitly nullable variant of type converter when no such
  field exists.

## 2.13.0

- Fix indices not being created for Dart tables from different files.
- Fix type converters on `int64` columns not propagating properly.

## 2.12.1

- Fix invalid types listed in `views` crashing the generator.
- Fix indices in drift files crashing the generator when they index expressions.

## 2.12.0

- Adds the static getter `$name` to generated table classes.
- Recognize and analyze the `@TableIndex` annotation.

## 2.11.2

- Follow `export` directives when looking for table imports.

## 2.11.1

- Reduce the amount of assets read by drift, improving build performance and enabling faster
  incremental rebuilds.
- Fix missing import references around `@UseRowClass` with `generateInsertable: true` when
  modular code generation is enabled.
- Support references to builtin sqlite3 tables in drift files.

## 2.11.0

- [Nested result columns](https://drift.simonbinder.eu/docs/using-sql/drift_files/#nested-results)
  in drift files can now refer to any result set (e.g. a table-valued function or a subquery).
  They were restricted to direct table references before.
- Add the `dialects` builder option to generate code supporting multiple SQL dialects.
- Add the `preamble` option for non-shared or modular build setups to mirror the `preamble`
  option from `source_gen:combining_builder`.

## 2.10.0

- Add the `schema steps` command to generate help in writing step-by-step schema migrations.
- Report a warning when Dart tables are implicitly added due to `include`. They should be
  added to a database via `tables` or `views` explicitly.

## 2.9.0

- Add `fatal_warnings` builder option to fail the build when drift reports warnings.

## 2.8.3

- Allow Dart-defined tables to reference imported tables through SQL
  [#2433](https://github.com/simolus3/drift/issues/2433).

## 2.8.2

- Fix generated to write qualified column references for Dart components in
  drift files if the same table is available under different names.

## 2.8.1

- Add documentation comments for comments on columns in drift files.
- Fix modular generation not generating imports correctly with the latest analyzer.

## 2.8.0

- Support named constructors for existing row types in drift files ([#2399](https://github.com/simolus3/drift/issues/2399)).
- Fix compilation issues with `analyzer: 5.12.0`.

## 2.7.0

- Make `validateDatabaseSchema()` work in migration tests.
- Fix elements from transitive imports in drift files not being added reliably.

## 2.6.0

- Fix invalid schema verification code being generated for columns with a
  `clientDefault`.
- Support drift 2.6.0

## 2.5.2

- Fix generated code for `blob` columns when modular generation is enabled.

## 2.5.1

- Fix an error resolving multiple table references across different files.
- Fix crash when giving a query with two identical columns a custom result class name.

## 2.5.0+1

- Support `MAPPED BY` for individual columns in queries or in views defined with SQL.
- Consistently interpret `CAST (x AS DATETIME)` and `CAST(x AS TEXT)` in drift files.
- Support a `CAST` to an enum type in drift types.
- The `generate_connect_constructor` option is now deprecated, as a `DatabaseConnection`
  can be passed whereever a `QueryExecutor` is used too.
- Support two different queries using `LIST()` columns having the same result class name.
- Fix table classes not extending defining Dart classes with modular generation.
- Fix `@UseDataClass` with `extending` not working with modular generation.
- Fix generating invalid code when using a type converter with a nullable JSON type.
- Avoid unecessary `async` modifier when mapping queries to existing row classes.

## 2.4.1

- Improvements and fixes for schema files:
  - Fix views with an existing row type generating invalid SQL in schema files.
  - Fix `schema generate --companions` implicitly requiring `--data-classes` as well.
  - Fix `toColumns()` not being generated correclty.
  - Fix conflicting names being generated by `schema generate` when using existing
    row types on views.

## 2.4.0

- Add support for `textEnum` columns in Dart (or `ENUMNAME` in `.drift`) to store enum columns as text (via `Enum.name`).
- Adds the `case_from_dart_to_sql` option with the possible values: `preserve`, `camelCase`, `CONSTANT_CASE`, `snake_case`, `PascalCase`, `lowercase` and `UPPERCASE` (default: `snake_case`).
- `drift_dev schema dump` can now dump the schema of existing sqlite3 database files as well.
- Warn about suspicious int or text literals being inserted into enum columns.
- Support [existing row types on queries](https://drift.simonbinder.eu/docs/advanced-features/custom_row_classes/#queries)
  defined in drift files.
- For Dart-defined columns, `customConstraint`s are now parsed and respected by the generator.
- It is now allowed to interleave queries and tables in a drift file.
- Experimental support for Dart records as existing row or query types. Please note that
  records aren't stable yet in Dart or Drift, so this feature might be changed
  or removed depending on its development in the Dart language.

## 2.3.3

- Fix a crash in `schema generate`.

## 2.3.2

- Fix a builder crash when importing triggers or indices.

## 2.3.1

- Fix invalid code being generated through `drift_dev schema generate`.

## 2.3.0

- Support drift 2.3.x
- Re-implement drift's internal analyzer to make the build process more efficient.
- Add an optional, modular build mode in which drift generates code for each
  file declaring tables instead of emitting a large file just for the entrypoint.

## 2.2.0+1

- __Potentially breaking bug-fix__: Fix the nullability of columns generated for
  Dart-defined views.
- Serialize `uniqueKeys` overrides into a database schema.
- Support latest version of the `analyzer` package.

## 2.1.0

- Analysis support `fts5` tables with external content tables.
- Analysis support for the `rtree` module.
- Prepare for an upcoming breaking analyzer change around how classes are mapped
  to elements.

## 2.0.2

- Generate public typedefs for the signatures of `scoped_dart_components`,
  making it easier to re-use them for own methods.

## 2.0.1

- Recognize options for an applied `not_shared` builder when exporting schemas.

## 2.0.0

- Removes the following build options, which are always turned on now:
 - `null_aware_type_converters`
 - `new_sql_code_generation`
 - `compact_query_methods`
- Starting from this version, drift only supports generating non-nullable Dart code.
  You'll have to at least opt your database code into null-safety to use this and
  upcoming drift releases.

These changes help reduce complexity in the generator.

## 1.7.1

- Support the latest versions of the `analyzer` and `analyzer_plugin` packages.

## 1.7.0

- Support for new drift 1.7 features like `int64` columns.
- Analysis support for upcoming sqlite 3.39 features in `.drift` files.

## 1.6.0

- Write Dart references into schema files.
- Support new drift features from version 1.6.0, like `check` and `unique`
  column constraints in Dart tables.

## 1.5.2

- Fix crash when reading dynamic type converters.

## 1.5.1

- Support migrations from `moor_flutter` to `drift_sqflite` in the `migrate`
  command.

## 1.5.0

- Add `validateDatabaseSchema` extension to `api/migrations.dart`. It validates
  that the schema of a database at runtime matches what one would expect.
- Allow cascade operators in the query for Dart-defined views.

## 1.4.0

- Generator support for the `LIST()` feature introduced in drift 1.4.
- Fix imported views in `.drift` files not being available in all cases.

## 1.3.0

- Support `drift` version `1.3.x`.

## 1.2.1

- Support the latest `analyzer` and `analyzer_plugin` packages.

## 1.2.0

- Generate code needed to support streams of views.

## 1.1.1

- Improve error handling around custom row classes.

## 1.1.0

- Consider `drift`-named files when generating schema migrations ([#1486](https://github.com/simolus3/drift/issues/1486))
- Emit correct SQL code when using arrays with the `new_sql_code_generation`
  option in specific scenarios.
- Transform `.moor.dart` part files in the `migrate` command.

## 1.0.2

- Also transform `analysis_options.yaml` files in the `drift_dev migrate` command.

## 1.0.1

This is the initial release of the `drift_dev` package (formally known as `moor_generator`).
For an overview of old `moor` releases, see its [changelog](https://pub.dev/packages/moor_generator/changelog).
