import 'package:flutter/material.dart';
import 'package:lista_de_la_compra/UI/env_manager.dart';
import 'package:lista_de_la_compra/UI/home.dart';
import 'package:lista_de_la_compra/shared_preference_providers/persistant_shared_preferences_provider.dart';
import 'package:provider/provider.dart';

import 'package:lista_de_la_compra_backend/lista_de_la_compra_backend.dart';


class SelectedEnvironmentFork extends StatelessWidget {
  final OpenConnectionManager openConnectionManager;

  const SelectedEnvironmentFork(this.openConnectionManager, {super.key});

  @override
  Widget build(BuildContext context) {
    SharedPreferencesProvider sharedPreferencesProvider = context.watch<PersistantSharedPreferencesProvider>();

    return FutureBuilder(
      future: sharedPreferencesProvider.getSelectedEnvironment(),
      builder: (context, asyncSnapshot) {
        if (asyncSnapshot.connectionState == ConnectionState.done) {
          String? selectedEnvironment = asyncSnapshot.data;

          if (selectedEnvironment == null) {
            return EnvSelect(openConnectionManager);
          } else {
            return Home(selectedEnvironment, openConnectionManager);
          }
        }
        if (asyncSnapshot.hasError) {
          return Text("$asyncSnapshot");
        } else {
          return Scaffold();
        }
      },
    );
  }
}
