# How to contribute

Thanks for considering to contribute to this project.

## Ideas or bugs

If you have an idea or you found a bug, please create an issue and we will happily discuss with you how to implement / fix the mentioned issue. 
It doesn't matter if you have a rough idea or already some example code, just share it and we will see how everything progresses.

## Code

To contribute to this project please use the following flow.

- Check if an issue already exists, if not create an issue regarding the feature or bug
- Fork the repository
- Implement the feature or fix the bug in your fork
- Write tests for your code
- Create a PR mentioning the issue

# Coding conventions

This project tries to adhere to the following guidelines in terms of code structure and styling.

- [Effective Dart](https://dart.dev/guides/language/effective-dart)

To ensure the code is formatted well we additionally use some tooling.

- [flutter_lints  package](https://pub.dev/packages/flutter_lints)

# Git conventions

This project has some base rules for Git handling, please try to adhere to those if you want to contribute.

- [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/)

# Testing

If possible everything should get tested and a commit shouldn't lower the current testing score. 
Please see our current [test setup](https://github.com/Boehrsi/device_marketing_names/tree/main/test) and add test for code you write.
