<div align="center">

<img src="assets/logo_2.png" alt="FinalBenchmark 2 Logo" width="200"/>

# FinalBenchmark 2

<a href="https://play.google.com/store/apps/details?id=com.ivarna.finalbenchmark2">
  <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" alt="Get it on Google Play" height="80"/>
</a>

<a href="https://f-droid.org/packages/com.ivarna.finalbenchmark2">
  <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80"/>
</a>

---

[![GitHub Downloads](https://img.shields.io/github/downloads/abhay-byte/finalbenchmark-platform/total?style=for-the-badge&logo=github&logoColor=white&labelColor=24292e&color=success)](https://github.com/abhay-byte/finalbenchmark-platform/releases)
[![GitHub Stars](https://img.shields.io/github/stars/abhay-byte/finalbenchmark-platform?style=for-the-badge&logo=github&logoColor=white&labelColor=24292e&color=yellow)](https://github.com/abhay-byte/finalbenchmark-platform/stargazers)
[![GitHub Forks](https://img.shields.io/github/forks/abhay-byte/finalbenchmark-platform?style=for-the-badge&logo=github&logoColor=white&labelColor=24292e&color=blue)](https://github.com/abhay-byte/finalbenchmark-platform/network/members)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg?style=for-the-badge&logo=apache&logoColor=white)](LICENSE)
[![FOSS](https://img.shields.io/badge/FOSS-100%25-brightgreen?style=for-the-badge&logo=opensourceinitiative&logoColor=white)](https://opensource.org/)

![Play Store Downloads](https://playbadges.pavi2410.com/badge/downloads?id=com.ivarna.finalbenchmark2&pretty)
![Play Store Rating](https://playbadges.pavi2410.com/badge/ratings?id=com.ivarna.finalbenchmark2&pretty)
![Play Store Version](https://playbadges.pavi2410.com/badge/version?id=com.ivarna.finalbenchmark2)

A comprehensive Android CPU benchmarking application with detailed scoring and visualization. *(GPU, RAM, and Storage benchmarks coming soon)*

</div>

---

## 📱 Screenshots

<div align="center">
  <table>
    <tr>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="180"/>
        <br/>
        <sub><b>Home Screen</b></sub>
      </td>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="180"/>
        <br/>
        <sub><b>Device Info</b></sub>
      </td>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="180"/>
        <br/>
        <sub><b>Results</b></sub>
      </td>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width="180"/>
        <br/>
        <sub><b>Running Tests</b></sub>
      </td>
    </tr>
    <tr>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" width="180"/>
        <br/>
        <sub><b>History</b></sub>
      </td>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.png" width="180"/>
        <br/>
        <sub><b>Rankings</b></sub>
      </td>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/7.png" width="180"/>
        <br/>
        <sub><b>Settings</b></sub>
      </td>
      <td align="center">
        <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/8.png" width="180"/>
        <br/>
        <sub><b>CPU Comparison</b></sub>
      </td>
    </tr>
  </table>
</div>

---

## 🚀 Features

### ✅ Currently Implemented
- **Comprehensive CPU Benchmarking**: Tests integer operations, floating-point calculations, multi-core performance, compression algorithms, and cryptographic operations
- **Scoring System**: Normalized scores with single-core and multi-core performance ratings
- **Results History**: Stores and displays historical benchmark results
- **Rankings**: Compare your device with other popular devices
- **Export Functionality**: Export results in JSON, CSV, or text formats
- **Modern UI**: Jetpack Compose with Material Design 3 components
- **Thermal Management**: Prevents device overheating during intensive tests

### 🔜 Coming Soon
- **AI/ML Benchmarking**: LLM inference, image classification, object detection, text embedding, and speech-to-text
- **GPU Benchmarking**: Rendering performance, compute operations, and memory bandwidth
- **RAM Benchmarking**: Memory read/write speeds, latency, and bandwidth
- **Storage Benchmarking**: Storage read/write speeds, IOPS, and latency
- **Productivity Tests**: UI rendering, image processing, video encoding, and multi-tasking

## 📋 CPU Benchmark Tests

All tests run in both **Single-Core** and **Multi-Core** modes:

- Prime Generation
- Fibonacci Iterative
- Matrix Multiplication
- Hash Computing (SHA-256/MD5)
- String Sorting
- Ray Tracing
- Compression (LZMA)
- Monte Carlo
- JSON Parsing
- N-Queens

## 🔧 Building

```bash
git clone https://github.com/abhay-byte/finalbenchmark-platform.git
cd finalbenchmark-platform
./gradlew assembleDebug
```

## 📄 License

This project is licensed under the Apache 2.0 License - see the [LICENSE](LICENSE) file for details.

---

<div align="center">

Made with ❤️ by [Abhay](https://github.com/abhay-byte)

</div>
