# Benchmark Tests Documentation

This directory contains comprehensive documentation for all benchmark tests in the system.

## Available Benchmark Categories

- [CPU Tests](cpu.md) - 10 tests evaluating central processing unit performance
- [AI/ML Tests](aiml.md) - 5 tests for artificial intelligence and machine learning workloads
- [GPU Native Tests](gpu_native.md) - 5 native Kotlin GPU tests for graphics performance
- [GPU External Tests](gpu_external.md) - 5 external engine tests (Unity and Unreal)
- [RAM Tests](ram.md) - 5 tests for memory subsystem performance
- [Storage Tests](storage.md) - 6 tests for storage performance
- [Productivity Tests](productivity.md) - 10 tests for real-world application performance

## Benchmark Modes

- [Full Benchmark Mode](../modes/full.md) - Complete system evaluation with all 46 tests
- [Throttle Test Mode](../modes/throttle.md) - Stress test for thermal throttling evaluation
- [GPU External Engine Tests](gpu_external.md) - Separate APKs for Unity and Unreal benchmarks

## Full Benchmark Mode

For complete system evaluation, see [Full Benchmark Mode](../modes/full.md) which combines all tests across categories to provide comprehensive performance assessment.