# KeePassVault
Android client app for KeePass databases.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/com.ivanovsky.passnotes/)
[<img src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png"
      alt="Get it on Google Play"
	height="80">](https://play.google.com/store/apps/details?id=com.ivanovsky.passnotes)

**This app is orientated for my personal use. It may have some bugs, so please make a backups before using it.**

# Features
- Synchronization:
    - Sync with WebDav server
    - Sync with Git repository (via HTTPS and SSH)

- Database Management:
    - Create new databases
    - Edit existing databases
    - Manage entry history
    - Manage attachments
    - Dynamic templates (compatible with other android applications: [KeePassDX](https://github.com/Kunzisoft/KeePassDX), [keepass2android](https://github.com/PhilippC/keepass2android))

- Advanced Database Tools:
    - Built-in diff viewer for database changes
    - TOTP (Time-based One-Time Password) and HOTP (HMAC-based One-Time Password) support for Two-Factor Authentication (2FA)

- Security Features:
    - Unlock using password or key file
    - Supports biometric unlock (fingerprint)

- File Compatibility:
    - Supports .kdbx files up to version 4.1

- User Convenience:
    - Autofill for Android >= 8.0
    - Dark theme (controlled by system settings)
    - Fuzzy search for easy finding of entries

# Screenshots
<img src="https://github.com/aivanovski/keepassvault/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="200"><img src="https://github.com/aivanovski/keepassvault/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="200"><img src="https://github.com/aivanovski/keepassvault/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="200"><img src="https://github.com/aivanovski/keepassvault/blob/master/fastlane/metadata/android/en-US/images/phoneScreenshots/6.png" width="200">

# License
```
Copyright (c) 2021 Aleksey Ivanovsky

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
