// Project imports:
import 'package:invoiceninja_flutter/utils/strings.dart';

abstract class LocaleCodeAware {
  LocaleCodeAware(this.localeCode);

  final String localeCode;

  String get baseLocaleCode => localeCode.split('_').first;
}

///
/// It provides localization strings to be statically used via getters
///
/// It should be used by a [LocaleCodeAware] to get the i18n strings for
/// a specified locale.
mixin LocalizationsProvider on LocaleCodeAware {
  static final Map<String, Map<String, String>> _localizedValues = {
    'en': {
      // STARTER: lang key - do not remove comment
      'empty': 'Empty',
      'location_name': 'Location Name',
      'location_field': 'Location Field',
      'activity_151': 'Client :notes merged into :client by :user',
      'activity_152': 'Vendor :notes merged into :vendor by :user',
      'activity_153': 'Client :notes purged by :user',
      'secret_key': 'Secret Key',
      'access_key': 'Access Key',
      'from_address': 'From Address',
      'topic_arn': 'Topic ARN',
      'replaced': 'Replaced',
      'tax_names': 'Tax Names',
      'location': 'Location',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Successfully deleted location',
      'added_location': 'Successfully added location',
      'updated_location': 'Successfully upated location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': 'Locations',
      'preference_product_notes_for_html_view':
          'Display HTML version of entity when viewing on mobile',
      'preference_product_notes_for_html_view_help':
          'For improved visualization, displays a HTML version of the invoice/quote when viewing on mobile',
      'in_stock_quantity': 'In Stock Quantity',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update': 'Allow clients to update their profile',
      'enable_client_profile_update_help':
          'Allow clients to update their profile information from the client portal',
      'participant': 'Participant',
      'merged_vendors': 'Successfully merged vendors',
      'activity_146': 'E-Invoice :invoice for :client was delivered',
      'activity_147': 'E-Invoice :invoice for :client failed to send',
      'activity_148': 'E-Exepnse :expense created',
      'payment_failed': 'Payment Failed',
      'activity_141': 'User :user entered note :notes',
      'activity_142': 'Quote :number reminder 1 sent',
      'activity_143': 'Auto Bill succeeded for invoice :invoice',
      'activity_144': 'Auto Bill failed for invoice :invoice',
      'activity_145': 'E-Invoice :invoice for :client was sent',
      'ssl_host_override': 'SSL Host Override',
      'upload_logo_short': 'Upload Logo',
      'show_pdfhtml_on_mobile_help':
          'For improved visualization, displays a HTML version of the invoice/quote when viewing on mobile.',
      'accept_purchase_order': 'Accept Purchase Order',
      'one_page_checkout': 'One-Page Checkout',
      'one_page_checkout_help': 'Enable the new single page payment flow',
      'applies_to': 'Applies To',
      'purchase_order_items': 'Purchase Order Items',
      'assigned_group': 'Successfully assigned group',
      'assign_group': 'Assign Group',
      'merge_to_pdf': 'Merge to PDF',
      'emails': 'Emails',
      'latest_requires_php_version':
          'Note: the latest version requires PHP :version',
      'quote_reminder1': 'First Quote Reminder',
      'before_valid_until': 'Before the valid until',
      'after_valid_until': 'After the valid until',
      'after_quote_date': 'After the quote date',
      'remind_quote': 'Remind Quote',
      'task_assigned_notification': 'Task Assigned Notification',
      'task_assigned_notification_help':
          'Send an email when a task is assigned',
      'invoices_locked_end_of_month':
          'Invoices are locked at the end of the month',
      'end_of_month': 'End of Month',
      'referral_url': 'Referral URL',
      'referral_program': 'Referral Program',
      'comment': 'Comment',
      'add_comment': 'Add Comment',
      'added_comment': 'Successfully saved comment',
      'disconnected': 'Disconnected',
      'reconnect': 'Reconnect',
      'e_invoice_settings': 'E-Invoice Settings',
      'calculate': 'Calculate',
      'sum': 'Sum',
      'money': 'Money',
      'time': 'Time',
      'format': 'Format',
      'web_app': 'Web App',
      'desktop_app': 'Desktop App',
      'invoice_net_amount': 'Invoice Net Amount',
      'round_to_seconds': 'Round To Seconds',
      '1_minute': '1 Minute',
      '5_minutes': '5 Minutes',
      '15_minutes': '15 Minutes',
      '30_minutes': '30 Minutes',
      '1_hour': '1 Hour',
      '1_day': '1 Day',
      'round_tasks': 'Round Tasks',
      'round_tasks_help': 'Round time intervals when saving tasks',
      'direction': 'Direction',
      'round_up': 'Round Up',
      'round_down': 'Round Down',
      'task_round_to_nearest': 'Round To Nearest',
      'activity_139': 'Expense :expense notification sent to :contact',
      'activity_140': 'Statement sent to :client',
      'bulk_updated': 'Successfully updated data',
      'bulk_update': 'Bulk Update',
      'advanced_cards': 'Advanced Cards',
      'always_show_required_fields': 'Always Show Required Fields',
      'always_show_required_fields_help':
          'Show required fields regardless if they are filled or not',
      'flutter_web_warning':
          'We recommend using the new web app or the desktop app for the best performance',
      'rappen_rounding': 'Rappen Rounding',
      'rappen_rounding_help': 'Round amount to 5 cents',
      'check_credentials': 'Check Credentials',
      'valid_credentials': 'Credentials are valid',
      'invalid_credentials': 'Credentials are not valid',
      'e_quote': 'E-Quote',
      'e_credit': 'E-Credit',
      'e_purchase_order': 'E-Purchase Order',
      'valid_vat_number': 'Valid VAT Number',
      'use_available_payments': 'Use Available Payments',
      'test_email_sent': 'Successfully sent email',
      'send_test_email': 'Send Test Email',
      'gateway_type': 'Gateway Type',
      'please_select_an_invoice_or_credit':
          'Please select an invoice or credit',
      'mobile_version': 'Mobile Version',
      'venmo': 'Venmo',
      'mercado_pago': 'Mercado Pago',
      'my_bank': 'MyBank',
      'pay_later': 'Pay Later',
      'email_report': 'Email Report',
      'host': 'Host',
      'port': 'Port',
      'encryption': 'Encryption',
      'local_domain': 'Local Domain',
      'verify_peer': 'Verify Peer',
      'username': 'Username',
      'nordigen_help':
          'Note: connecting an account requires a GoCardless/Nordigen API key',
      'participant_name': 'Participant Name',
      'yodlee_regions': 'Regions: USA, UK, Australia & India',
      'nordigen_regions': 'Regions: Europe & UK',
      'select_provider': 'Select Provider',
      'payment_type_credit': 'Payment Type Credit',
      'payment_type_debit': 'Payment Type Debit',
      'send_emails_to': 'Send Emails To',
      'primary_contact': 'Primary Contact',
      'all_contacts': 'All Contacts',
      'insert_below': 'Insert Below',
      'ar_detailed': 'Accounts Receivable Detailed',
      'ar_summary': 'Accounts Receivable Summary',
      'client_sales': 'Client Sales',
      'tax_summary': 'Tax Summary',
      'user_sales': 'User Sales',
      'run_template': 'Run Template',
      'task_extension_banner':
          'Install the Chrome extension to manage tasks in your browser',
      'watch_video': 'Watch Video',
      'view_extension': 'View Extension',
      'reactivate_email': 'Reactivate Email',
      'email_reactivated': 'Successfully reactivated email',
      'template_help': 'Enable using the design as a template',
      'delivery_note_design': 'Delivery Note Design',
      'statement_design': 'Statement Design',
      'payment_receipt_design': 'Payment Receipt Design',
      'payment_refund_design': 'Payment Refund Design',
      'quarter': 'Quarter',
      'item_description': 'Item Description',
      'task_item': 'Task Item',
      'record_state': 'Record State',
      'last_login': 'Last Login',
      'save_files_to_this_folder': 'Save files to this folder',
      'downloads_folder': 'Downloads Folder',
      'total_invoiced_quotes': 'Invoiced Quotes',
      'total_invoice_paid_quotes': 'Invoice Paid Quotes',
      'downloads_folder_does_not_exist':
          'The downloads folder does not exist :value',
      'user_logged_in_notification': 'User Logged in Notification',
      'user_logged_in_notification_help':
          'Send an email when logging in from a new location',
      'client_contact': 'Client Contact',
      'expense_status_4': 'Unpaid',
      'expense_status_5': 'Paid',
      'recurring': 'Recurring',
      'ziptax_help':
          'Note: this feature requires a Zip-Tax API key to lookup US sales tax by address',
      'cache_data': 'Cache Data',
      'unknown': 'Unknown',
      'webhook_failure': 'Webhook Failure',
      'email_opened': 'Email Opened',
      'email_delivered': 'Email Delivered',
      'log': 'Log',
      'individual': 'Individual',
      'partnership': 'Partnership',
      'trust': 'Trust',
      'charity': 'Charity',
      'government': 'Government',
      'classification': 'Classification',
      'click_or_drop_files_here': 'Click or drop files here',
      'public': 'Public',
      'private': 'Private',
      'image': 'Image',
      'other': 'Other',
      'hash': 'Hash',
      'linked_to': 'Linked To',
      'file_saved_in_path': 'The file has been saved to :path',
      'unlinked_transactions': 'Successfully unlinked :count transactions',
      'unlinked_transaction': 'Successfully unlinked transaction',
      'unlink': 'Unlink',
      'view_dashboard_permission':
          'Allow user to access the dashboard, data is limited to available permissions',
      'is_tax_exempt': 'Tax Exempt',
      'district': 'District',
      'region': 'Region',
      'county': 'County',
      'tax_details': 'Tax Details',
      'activity_10_online':
          ':contact entered payment :payment for invoice :invoice for :client',
      'activity_10_manual':
          ':user entered payment :payment for invoice :invoice for :client',
      'default_payment_type': 'Default Payment Type',
      'admin_initiated_payments': 'Admin Initiated Payments',
      'admin_initiated_payments_help':
          'Support entering a payment in the admin portal without an invoice',
      'use_mobile_to_manage_plan':
          'Use your phone subscription settings to manage your plan',
      'show_task_billable': 'Show Task Billable',
      'credit_item': 'Credit Item',
      'files': 'Files',
      'camera': 'Camera',
      'gallery': 'Gallery',
      'email_count_invoices': 'Email :count invoices',
      'project_location': 'Project Location',
      'invoice_task_item_description': 'Invoice Task Item Description',
      'invoice_task_item_description_help':
          'Add the item description to the invoice line items',
      'next_send_time': 'Next Send Time',
      'uploaded_certificate': 'Successfully uploaded certificate',
      'certificate_set': 'Certificate set',
      'certificate_not_set': 'Certificate not set',
      'passphrase_set': 'Passphrase set',
      'passphrase_not_set': 'Passphrase not set',
      'upload_certificate': 'Upload Certificate',
      'certificate_passphrase': 'Certificate Passphrase',
      'rename': 'Rename',
      'renamed_document': 'Successfully renamed document',
      'e_invoice': 'E-Invoice',
      'light_dark_mode': 'Light/Dark Mode',
      'activities': 'Activities',
      'routing_id': 'Routing ID',
      'enable_e_invoice': 'Enable E-Invoice',
      'e_invoice_type': 'E-Invoice Type',
      'e_quote_type': 'E-Quote Type',
      'reduced_tax': 'Reduced',
      'override_tax': 'Override',
      'zero_rated': 'Zero Rated',
      'reverse_tax': 'Reverse',
      'updated_tax_category': 'Successfully updated the tax category',
      'updated_tax_categories': 'Successfully updated the tax categories',
      'set_tax_category': 'Set Tax Category',
      'payment_manual': 'Payment Manual',
      'tax_category': 'Tax Category',
      'physical_goods': 'Physical Goods',
      'digital_products': 'Digital Products',
      'services': 'Services',
      'shipping': 'Shipping',
      'tax_exempt': 'Exempt',
      'reduced_rate': 'Reduced Rate',
      'tax_all': 'Tax All',
      'tax_selected': 'Tax Selected',
      'version': 'version',
      'seller_subregion': 'Seller Subregion',
      'calculate_taxes': 'Calculate Taxes',
      'calculate_taxes_help':
          'Automatically calculate taxes when saving invoices',
      'admin': 'Admin',
      'owner': 'Owner',
      'link_expenses': 'Link Expenses',
      'converted_client_balance': 'Converted Client Balance',
      'converted_payment_balance': 'Converted Payment Balance',
      'total_hours': 'Total Hours',
      'date_picker_hint': 'Use +days to set the date in the future',
      'browser_pdf_viewer': 'Use Browser PDF Viewer',
      'browser_pdf_viewer_help':
          'Warning: Prevents interacting with app over the PDF',
      'increase_prices': 'Increase Prices',
      'update_prices': 'Update Prices',
      'incresed_prices': 'Successfully queued prices to be increased',
      'updated_prices': 'Successfully queued prices to be updated',
      'bacs': 'Bacs',
      'api_token': 'API Token',
      'api_key': 'API Key',
      'endpoint': 'Endpoint',
      'billable': 'Billable',
      'not_billable': 'Not Billable',
      'allow_billable_task_items': 'Allow Billable Task Items',
      'allow_billable_task_items_help':
          'Enable specifying which task items are billed',
      'show_task_item_description': 'Show Task Item Description',
      'show_task_item_description_help':
          'Enable specifying task item descriptions',
      'email_record': 'Email Record',
      'invoice_product_columns': 'Invoice Product Columns',
      'quote_product_columns': 'Quote Product Columns',
      'minimum_payment_amount': 'Minimum Payment Amount',
      'client_initiated_payments': 'Client Initiated Payments',
      'client_initiated_payments_help':
          'Support entering a payment in the client portal without an invoice',
      'share_invoice_quote_columns': 'Share Invoice/Quote Columns',
      'cc_email': 'CC Email',
      'payment_balance': 'Payment Balance',
      'view_report_permission':
          'Allow user to access the reports, data is limited to available permissions',
      'activity_138': 'Payment :payment was emailed to :contact',
      'one_time_products': 'One-Time Products',
      'optional_one_time_products': 'Optional One-Time Products',
      'required': 'Required',
      'hidden': 'Hidden',
      'payment_links': 'Payment Links',
      'action': 'Action',
      'upgrade_to_paid_plan_to_schedule':
          'Upgrade to a paid plan to create schedules',
      'next_run': 'Next Run',
      'all_clients': 'All Clients',
      'show_aging_table': 'Show Aging Table',
      'show_payments_table': 'Show Payments Table',
      'only_clients_with_invoices': 'Only Clients with Invoices',
      'email_statement': 'Email Statement',
      'once': 'Once',
      'schedule': 'Schedule',
      'schedules': 'Schedules',
      'new_schedule': 'New Schedule',
      'edit_schedule': 'Edit Schedule',
      'created_schedule': 'Successfully created schedule',
      'updated_schedule': 'Successfully updated schedule',
      'archived_schedule': 'Successfully archived schedule',
      'deleted_schedule': 'Successfully deleted schedule',
      'removed_schedule': 'Successfully removed schedule',
      'restored_schedule': 'Successfully restored schedule',
      'search_schedule': 'Search Schedule',
      'search_schedules': 'Search Schedules',

      'archive_payment': 'Archive Payment',
      'archive_invoice': 'Archive Invoice',
      'archive_quote': 'Archive Quote',
      'archive_credit': 'Archive Credit',
      'archive_task': 'Archive Task',
      'archive_client': 'Archive Client',
      'archive_project': 'Archive Project',
      'archive_expense': 'Archive Expense',
      'restore_payment': 'Restore Payment',
      'restore_invoice': 'Restore Invoice',
      'restore_quote': 'Restore Quote',
      'restore_credit': 'Restore Credit',
      'restore_task': 'Restore Task',
      'restore_client': 'Restore Client',
      'restore_project': 'Restore Project',
      'restore_expense': 'Restore Expense',
      'archive_vendor': 'Archive Vendor',
      'restore_vendor': 'Restore Vendor',
      'create_product': 'Create Product',
      'update_product': 'Update Product',
      'delete_product': 'Delete Product',
      'restore_product': 'Restore Product',
      'archive_product': 'Archive Product',
      'create_purchase_order': 'Create Purchase Order',
      'update_purchase_order': 'Update Purchase Order',
      'delete_purchase_order': 'Delete Purchase Order',
      'restore_purchase_order': 'Restore Purchase Order',
      'archive_purchase_order': 'Archive Purchase Order',
      'sent_invoice': 'Sent Invoice',
      'sent_quote': 'Sent Quote',
      'sent_credit': 'Sent Credit',
      'sent_purchase_order': 'Sent Purchase Order',
      'image_url': 'Image URL',
      'max_quantity': 'Max Quantity',
      'test_url': 'Test URL',
      'auto_bill_help_off': 'Option is not shown',
      'auto_bill_help_optin': 'Option is shown but not selected',
      'auto_bill_help_optout': 'Option is shown and selected',
      'auto_bill_help_always': 'Option is not shown',
      'payment_methods': 'Payment Methods',
      'view_all': 'View All',
      'edit_all': 'Edit All',
      'accept_purchase_order_number': 'Accept Purchase Order Number',
      'accept_purchase_order_number_help':
          'Enable clients to provide a PO number when approving a quote',
      'from_email': 'From Email',
      'show_preview': 'Show Preview',
      'show_paid_stamp': 'Show Paid Stamp',
      'show_shipping_address': 'Show Shipping Address',
      'no_documents_to_download':
          'There are no documents in the selected records to download',
      'pixels': 'Pixels',
      'logo_size': 'Logo Size',
      'postal_city': 'Postal/City',
      'failed': 'Failed',
      'client_contacts': 'Client Contacts',
      'sync_from': 'Sync From',
      'inventory_threshold': 'Inventory Threshold',
      'hour': 'Hour',
      'emailed_statement': 'Successfully queued statement to be sent',
      'show_email_footer': 'Show Email Footer',
      'invoice_task_hours': 'Invoice Task Hours',
      'invoice_task_hours_help': 'Add the hours to the invoice line items',
      'auto_bill_standard_invoices': 'Auto Bill Standard Invoices',
      'auto_bill_recurring_invoices': 'Auto Bill Recurring Invoices',
      'email_alignment': 'Email Alignment',
      'pdf_preview_location': 'PDF Preview Location',
      'mailgun': 'Mailgun',
      'postmark': 'Postmark',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Click + to create a record',
      'last365_days': 'Last 365 Days',
      'import_design': 'Import Design',
      'imported_design': 'Successfully imported design',
      'invalid_design': 'The design is invalid, the :value section is missing',
      'setup_wizard_logo': 'Would you like to upload your logo?',
      'upload': 'Upload',
      'installed_version': 'Installed Version',
      'notify_vendor_when_paid': 'Notify Vendor When Paid',
      'notify_vendor_when_paid_help':
          'Send an email to the vendor when the expense is marked as paid',
      'update_payment': 'Update Payment',
      'markup': 'Markup',
      'purchase_order_created': 'Purchase Order Created',
      'purchase_order_sent': 'Purchase Order Sent',
      'purchase_order_viewed': 'Purchase Order Viewed',
      'purchase_order_accepted': 'Purchase Order Accepted',
      'credit_payment_error':
          'The credit amount can not be greater than the payment amount',
      'klarna': 'Klarna',
      'convert_payment_currency_help':
          'Set an exchange rate when entering a manual payment',
      'convert_expense_currency_help':
          'Set an exchange rate when creating an expense',
      'matomo_url': 'Matomo URL',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Add To Invoice',
      'online_payment_email_help':
          'Send an email when an online payment is made',
      'manual_payment_email_help':
          'Send an email when manually entering a payment',
      'mark_paid_payment_email_help':
          'Send an email when marking an invoice as paid',
      'delete_project': 'Delete Project',
      'linked_transaction': 'Successfully linked transaction',
      'link_payment': 'Link Payment',
      'link_expense': 'Link Expense',
      'lock_invoiced_tasks': 'Lock Invoiced Tasks',
      'lock_invoiced_tasks_help':
          'Prevent tasks from being edited once invoiced',
      'registration_required': 'Registration Required',
      'registration_required_help': 'Require clients to register',
      'use_inventory_management': 'Use Inventory Management',
      'use_inventory_management_help': 'Require products to be in stock',
      'optional_products': 'Optional Products',
      'optional_recurring_products': 'Optional Recurring Products',
      'convert_matched': 'Convert',
      'auto_billed_invoice': 'Successfully queued invoice to be auto-billed',
      'auto_billed_invoices': 'Successfully queued invoices to be auto-billed',
      'operator': 'Operator',
      'value': 'Value',
      'is': 'Is',
      'contains': 'Contains',
      'starts_with': 'Starts with',
      'is_empty': 'Is empty',
      'add_rule': 'Add Rule',
      'match_all_rules': 'Match All Rules',
      'match_all_rules_help':
          'All criteria needs to match for the rule to be applied',
      'auto_convert_help':
          'Automatically convert matched transactions to expenses',
      'rules': 'Rules',
      'transaction_rule': 'Transaction Rule',
      'transaction_rules': 'Transaction Rules',
      'new_transaction_rule': 'New Transaction Rule',
      'edit_transaction_rule': 'Edit Transaction Rule',
      'created_transaction_rule': 'Successfully created rule',
      'updated_transaction_rule': 'Successfully updated transaction rule',
      'archived_transaction_rule': 'Successfully archived transaction rule',
      'deleted_transaction_rule': 'Successfully deleted transaction rule',
      'removed_transaction_rule': 'Successfully removed transaction rule',
      'restored_transaction_rule': 'Successfully restored transaction rule',
      'search_transaction_rule': 'Search Transaction Rule',
      'search_transaction_rules': 'Search Transaction Rules',
      'save_as_default_terms': 'Save as default terms',
      'save_as_default_footer': 'Save as default footer',
      'auto_sync': 'Auto Sync',
      'refresh_accounts': 'Refresh Accounts',
      'upgrade_to_connect_bank_account':
          'Upgrade to Enterprise to connect your bank account',
      'click_here_to_connect_bank_account':
          'Click here to connect your bank account',
      'disable_2fa': 'Disable 2FA',
      'change_number': 'Change Number',
      'resend_code': 'Resend Code',
      'base_type': 'Base Type',
      'category_type': 'Category Type',
      'bank_transaction': 'Transaction',
      'bulk_print': 'Print PDF',
      'vendor_postal_code': 'Vendor Postal Code',
      'preview_location': 'Preview Location',
      'bottom': 'Bottom',
      'side': 'Side',
      'pdf_preview': 'PDF Preview',
      'long_press_to_select': 'Long Press to Select',
      'purchase_order_number': 'Purchase Order Number',
      'purchase_order_item': 'Purchase Order Item',
      'would_you_rate_the_app': 'Would you like to rate the app?',
      'include_deleted': 'Include Deleted',
      'include_deleted_help': 'Include deleted records in reports',
      'due_on': 'Due On',
      'converted_transactions': 'Successfully converted transactions',
      'created_bank_account': 'Successfully created bank account',
      'updated_bank_account': 'Successfully updated bank account',
      'edit_bank_account': 'Edit Bank Account',
      'default_category': 'Default Category',
      'account_type': 'Account Type',
      'new_bank_account': 'New Bank Account',
      'connect_accounts': 'Connect Accounts',
      'manage_rules': 'Manage Rules',
      'search_category': 'Search 1 Category',
      'search_categories': 'Search :count Categories',
      'min_amount': 'Min Amount',
      'max_amount': 'Max Amount',
      'selected': 'Selected',
      'converted_transaction': 'Successfully converted transaction',
      'convert_to_payment': 'Convert to Payment',
      'deposit': 'Deposit',
      'withdrawal': 'Withdrawal',
      'deposits': 'Deposits',
      'withdrawals': 'Withdrawals',
      'matched': 'Matched',
      'unmatched': 'Unmatched',
      'create_credit': 'Create Credit',
      'update_credit': 'Update Credit',
      'delete_credit': 'Delete Credit',
      'transaction': 'Transaction',
      'transactions': 'Transactions',
      'new_transaction': 'New Transaction',
      'edit_transaction': 'Edit Transaction',
      'created_transaction': 'Successfully created transaction',
      'updated_transaction': 'Successfully updated transaction',
      'archived_transaction': 'Successfully archived transaction',
      'deleted_transaction': 'Successfully deleted transaction',
      'removed_transaction': 'Successfully removed transaction',
      'restored_transaction': 'Successfully restored transaction',
      'search_transaction': 'Search Transaction',
      'search_transactions': 'Search :count Transactions',
      'bank_account': 'Bank Account',
      'bank_accounts': 'Bank Accounts',
      'archived_bank_account': 'Successfully archived bank account',
      'deleted_bank_account': 'Successfully deleted bank account',
      'removed_bank_account': 'Successfully removed bank account',
      'restored_bank_account': 'Successfully restored bank account',
      'search_bank_account': 'Search Bank Account',
      'search_bank_accounts': 'Search :count Bank Accounts',
      'connect': 'Connect',
      'mark_paid_payment_email': 'Mark Paid Payment Email',
      'convert_to_project': 'Convert to Project',
      'client_email': 'Client Email',
      'invoice_task_project': 'Invoice Task Project',
      'invoice_task_project_help': 'Add the project to the invoice line items',
      'field': 'Field',
      'period': 'Period',
      'fields_per_row': 'Fields Per Row',
      'total_active_invoices': 'Active Invoices',
      'total_outstanding_invoices': 'Outstanding Invoices',
      'total_completed_payments': 'Completed Payments',
      'total_refunded_payments': 'Refunded Payments',
      'total_active_quotes': 'Active Quotes',
      'total_approved_quotes': 'Approved Quotes',
      'total_unapproved_quotes': 'Unapproved Quotes',
      'total_logged_tasks': 'Logged Tasks',
      'total_invoiced_tasks': 'Invoiced Tasks',
      'total_paid_tasks': 'Paid Tasks',
      'total_logged_expenses': 'Logged Expenses',
      'total_pending_expenses': 'Pending Expenses',
      'total_invoiced_expenses': 'Invoiced Expenses',
      'total_invoice_paid_expenses': 'Invoice Paid Expenses',
      'activity_130': ':user created purchase order :purchase_order',
      'activity_131': ':user updated purchase order :purchase_order',
      'activity_132': ':user archived purchase order :purchase_order',
      'activity_133': ':user deleted purchase order :purchase_order',
      'activity_134': ':user restored purchase order :purchase_order',
      'activity_135': ':user emailed purchase order :purchase_order',
      'activity_136': ':contact viewed purchase order :purchase_order',
      'activity_137': ':contact accepted purchase order :purchase_order',
      'vendor_portal': 'Vendor Portal',
      'send_code': 'Send Code',
      'save_to_upload_documents': 'Save the record to upload documents',
      'expense_tax_rates': 'Expense Tax Rates',
      'invoice_item_tax_rates': 'Invoice Item Tax Rates',
      'verified_phone_number': 'Successfully verified phone number',
      'code_was_sent': 'A code has been sent via SMS',
      'code_was_sent_to': 'A code has been sent via SMS to :number',
      'resend': 'Resend',
      'verify': 'Verify',
      'enter_phone_number': 'Please provide a phone number',
      'invalid_phone_number': 'Invalid phone number',
      'verify_phone_number': 'Verify Phone Number',
      'verify_phone_number_help':
          'Please verify your phone number to send emails',
      'verify_phone_number_2fa_help':
          'Please verify your phone number for 2FA backup',
      'merged_clients': 'Successfully merged clients',
      'merge_into': 'Merge Into',
      'merge': 'Merge',
      'price_change_accepted': 'Price change accepted',
      'price_change_failed': 'Price change failed with code',
      'restore_purchases': 'Restore Purchases',
      'activate': 'Activate',
      'connect_apple': 'Connect Apple',
      'disconnect_apple': 'Disconnect Apple',
      'disconnected_apple': 'Successfully disconnected Apple',
      'send_now': 'Send Now',
      'received': 'Received',
      'purchase_order_date': 'Purchase Order Date',
      'converted_to_expense': 'Successfully converted to expense',
      'converted_to_expenses': 'Successfully converted to expenses',
      'convert_to_expense': 'Convert to Expense',
      'add_to_inventory': 'Add to Inventory',
      'added_purchase_order_to_inventory':
          'Successfully added purchase order to inventory',
      'added_purchase_orders_to_inventory':
          'Successfully added purchase orders to inventory',
      'client_document_upload': 'Client Document Upload',
      'vendor_document_upload': 'Vendor Document Upload',
      'vendor_document_upload_help': 'Enable vendors to upload documents',
      'are_you_enjoying_the_app': 'Are you enjoying the app?',
      'yes_its_great': 'Yes, it\'s great!',
      'not_so_much': 'Not so much',
      'would_you_rate_it': 'Great to hear! Would you like to rate it?',
      'would_you_tell_us_more':
          'Sorry to hear it! Would you like to tell us more?',
      'sure_happy_to': 'Sure, happy to',
      'no_not_now': 'No, not now',
      'add': 'Add',
      'last_sent_template': 'Last Sent Template',
      'enable_flexible_search': 'Enable Flexible Search',
      'enable_flexible_search_help':
          'Match non-contiguous characters, ie. \'ct\' matches \'cat\'',
      'vendor_details': 'Vendor Details',
      'purchase_order_details': 'Purchase Order Details',
      'qr_iban': 'QR IBAN',
      'besr_id': 'BESR ID',
      'accept': 'Accept',
      'clone_to_purchase_order': 'Clone to PO',
      'vendor_email_not_set': 'Vendor does not have an email address set',
      'bulk_send_email': 'Send Email',
      'marked_purchase_order_as_sent':
          'Successfully marked purchase order as sent',
      'marked_purchase_orders_as_sent':
          'Successfully marked purchase orders as sent',
      'accepted_purchase_order': 'Successfully accepted purchase order',
      'accepted_purchase_orders': 'Successfully accepted purchase orders',
      'cancelled_purchase_order': 'Successfully cancelled purchase order',
      'cancelled_purchase_orders': 'Successfully cancelled purchase orders',
      'accepted': 'Accepted',
      'please_select_a_vendor': 'Please select a vendor',
      'purchase_order_total': 'Purchase Order Total',
      'email_purchase_order': 'Email Purchase Order',
      'bulk_email_purchase_orders': 'Email Purchase Orders',
      'disconnected_email': 'Successfully disconnected email',
      'connect_email': 'Connect Email',
      'disconnect_email': 'Disconnect Email',
      'use_web_app_to_connect_microsoft':
          'Please use the web app to connect to Microsoft',
      'email_provider': 'Email Provider',
      'connect_microsoft': 'Connect Microsoft',
      'disconnect_microsoft': 'Disconnect Microsoft',
      'connected_microsoft': 'Successfully connected Microsoft',
      'disconnected_microsoft': 'Successfully disconnected Microsoft',
      'microsoft_sign_in': 'Login with Microsoft',
      'microsoft_sign_up': 'Sign up with Microsoft',
      'emailed_purchase_order': 'Successfully queued purchase order to be sent',
      'emailed_purchase_orders':
          'Successfully queued purchase orders to be sent',
      'enable_react_app': 'Change to the React web app',
      'purchase_order_design': 'Purchase Order Design',
      'purchase_order_terms': 'Purchase Order Terms',
      'purchase_order_footer': 'Purchase Order Footer',
      'require_purchase_order_signature': 'Purchase Order Signature',
      'require_purchase_order_signature_help':
          'Require vendor to provide their signature.',
      'purchase_order': 'Purchase Order',
      'purchase_orders': 'Purchase Orders',
      'new_purchase_order': 'New Purchase Order',
      'edit_purchase_order': 'Edit Purchase Order',
      'created_purchase_order': 'Successfully created purchase order',
      'updated_purchase_order': 'Successfully updated purchase order',
      'archived_purchase_order': 'Successfully archived purchase order',
      'deleted_purchase_order': 'Successfully deleted purchase order',
      'removed_purchase_order': 'Successfully removed purchase order',
      'restored_purchase_order': 'Successfully restored purchase order',
      'search_purchase_order': 'Search Purchase Order',
      'search_purchase_orders': 'Search Purchase Orders',
      'login_url': 'Login URL',
      'payment_settings': 'Payment Settings',
      'default': 'Default',
      'stock_quantity': 'Stock Quantity',
      'notification_threshold': 'Notification Threshold',
      'track_inventory': 'Track Inventory',
      'track_inventory_help':
          'Display a product stock field and update when invoices are sent',
      'stock_notifications': 'Stock Notifications',
      'stock_notifications_help':
          'Send an email when the stock reaches the threshold',
      'vat': 'VAT',
      'standing': 'Standing',
      'view_map': 'View Map',
      'set_default_design': 'Set Default Design',
      'add_gateway': 'Add Gateway',
      'add_gateway_help_message':
          'Add a payment gateway (ie. Stripe, WePay or PayPal) to accept online payments',
      'left': 'Left',
      'right': 'Right',
      'center': 'Center',
      'page_numbering': 'Page Numbering',
      'page_numbering_alignment': 'Page Numbering Alignment',
      'invoice_sent_notification_label': 'Invoice Sent',
      'show_product_description': 'Show Product Description',
      'show_product_description_help':
          'Include the description in the product dropdown',
      'invoice_items': 'Invoice Items',
      'quote_items': 'Quote Items',
      'profitloss': 'Profit and Loss',
      'import_format': 'Import Format',
      'export_format': 'Export Format',
      'export_type': 'Export Type',
      'stop_on_unpaid': 'Stop On Unpaid',
      'stop_on_unpaid_help':
          'Stop creating recurring invoices if the last invoice is unpaid.',
      'use_quote_terms': 'Use Quote Terms',
      'use_quote_terms_help': 'When converting a quote to an invoice',
      'add_country': 'Add Country',
      'enable_tooltips': 'Enable Tooltips',
      'enable_tooltips_help': 'Show tooltips when hovering the mouse',
      'multiple_client_error': 'Error: records belong to more than one client',
      'register_label': 'Create your account in seconds',
      'login_label': 'Login to an existing account',
      'add_to_invoice': 'Add To Invoice',
      'no_invoices_found': 'No invoices found',
      'week': 'Week',
      'created_record': 'Successfully created record',
      'auto_archive_paid_invoices': 'Auto Archive Paid',
      'auto_archive_paid_invoices_help':
          'Automatically archive invoices when they are paid.',
      'auto_archive_cancelled_invoices': 'Auto Archive Cancelled',
      'auto_archive_cancelled_invoices_help':
          'Automatically archive invoices when they are cancelled.',
      'alternate_pdf_viewer': 'Alternate PDF Viewer',
      'alternate_pdf_viewer_help': 'Improve scrolling over the PDF preview',
      'invoice_currency': 'Invoice Currency',
      'range': 'Range',
      'tax_amount1': 'Tax Amount 1',
      'tax_amount2': 'Tax Amount 2',
      'tax_amount3': 'Tax Amount 3',
      'create_project': 'Create Project',
      'update_project': 'Update Project',
      'view_task': 'View Task',
      'cancel_invoice': 'Cancel Invoice',
      'changed_status': 'Successfully changed task status',
      'change_status': 'Change Status',
      'fees_sample': 'The fee for a :amount invoice would be :total.',
      'enable_touch_events': 'Enable Touch Events',
      'enable_touch_events_help': 'Support drag events to scroll',
      'after_saving': 'After Saving',
      'view_record': 'View Record',
      'enable_email_markdown': 'Enable Email Markdown',
      'enable_email_markdown_help':
          'Use visual WYSIWYG markdown editor for emails',
      'enable_pdf_markdown': 'Enable PDF Markdown',
      'json_help': 'Note: JSON files generated by the v4 app are not supported',
      'release_notes': 'Release Notes',
      'upgrade_to_view_reports': 'Upgrade your plan to view reports',
      'started_tasks': 'Successfully started :value tasks',
      'stopped_tasks': 'Successfully stopped :value tasks',
      'approved_quote': 'Successfully approved quote',
      'approved_quotes': 'Successfully :value approved quotes',
      'approve': 'Approve',
      'client_website': 'Client Website',
      'invalid_time': 'Invalid Time',
      'client_shipping_state': 'Client Shipping State',
      'client_shipping_city': 'Client Shipping City',
      'client_shipping_postal_code': 'Client Shipping Postal Code',
      'client_shipping_country': 'Client Shipping Country',
      'load_pdf': 'Load PDF',
      'start_free_trial': 'Pro Plan Trial / Account Upgrade',
      'start_free_trial_message': 'Start your FREE 14 day Pro Plan trial',
      'due_on_receipt': 'Due on Receipt',
      'is_paid': 'Is Paid',
      'age_group_paid': 'Paid',
      'id': 'Id',
      'convert_to': 'Convert To',
      'client_currency': 'Client Currency',
      'company_currency': 'Company Currency',
      'purged_client': 'Successfully purged client',
      'custom_emails_disabled_help':
          'To prevent spam we require upgrading to a paid account to customize the email',
      'upgrade_to_add_company': 'Upgrade your plan to add companies',
      'small': 'Small',
      'marked_credit_as_paid': 'Successfully marked credit as paid',
      'marked_credits_as_paid': 'Successfully marked credits as paid',
      'wait_for_loading': 'Data loading - please wait for it to complete',
      'wait_for_saving': 'Data saving - please wait for it to complete',
      'html_preview_warning':
          'Note: changes made here are only previewed, they must be applied in the tabs above to be saved',
      'remaining': 'Remaining',
      'invoice_paid': 'Invoice Paid',
      'activity_120': ':user created recurring expense :recurring_expense',
      'activity_121': ':user updated recurring expense :recurring_expense',
      'activity_122': ':user archived recurring expense :recurring_expense',
      'activity_123': ':user deleted recurring expense :recurring_expense',
      'activity_124': ':user restored recurring expense :recurring_expense',
      'normal': 'Normal',
      'large': 'Large',
      'extra_large': 'Extra Large',
      'show_pdf_preview': 'Show PDF Preview',
      'show_pdf_preview_help': 'Display PDF preview while editing invoices',
      'print_pdf': 'Print PDF',
      'remind_me': 'Remind Me',
      'instant_bank_pay': 'Instant Bank Pay',
      'click_selected': 'Click Selected',
      'hide_preview': 'Hide Preview',
      'edit_record': 'Edit Record',
      'credit_is_more_than_invoice':
          'The credit amount can not be more than the invoice amount',
      'giropay': 'Giropay',
      'direct_debit': 'Direct Debit',
      'please_set_a_password': 'Please set an account password',
      'set_password': 'Set Password',
      'disconnected_gateway': 'Successfully disconnected gateway',
      'disconnect': 'Disconnect',
      'add_to_invoices': 'Add to Invoices',
      'acss': 'ACSS',
      'becs': 'BECS',
      'bulk_download': 'Download',
      'persist_data_help':
          'Save data locally to enable the app to start faster, disabling may improve performance in large accounts',
      'persist_ui': 'Persist UI',
      'persist_ui_help':
          'Save UI state locally to enable the app to start at the last location, disabling may improve performance',
      'client_postal_code': 'Client Postal Code',
      'client_vat_number': 'Client VAT Number',
      'has_tasks': 'Has Tasks',
      'registration': 'Registration',
      'unauthorized_stripe_warning':
          'Please authorize Stripe to accept online payments.',
      'view_expense': 'View Expense',
      'view_statement': 'View Statement',
      'sepa': 'SEPA',
      'ideal': 'iDEAL',
      'przelewy24': 'Przelewy24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'Update all records',
      'system': 'System',
      'set_default_company': 'Set Default Company',
      'updated_company': 'Successfully updated company',
      'kbc': 'KBC',
      'bancontact': 'Bancontact',
      'why_are_you_leaving': 'Help us improve by telling us why (optional)',
      'webhook_success': 'Webhook Success',
      'error_cross_client_tasks': 'Tasks must all belong to the same client',
      'error_cross_client_expenses':
          'Expenses must all belong to the same client',
      'app': 'App',
      'for_best_performance': 'For the best performance download the :app app',
      'gross_line_total': 'Gross Line Total',
      'bulk_email_invoices': 'Email Invoices',
      'bulk_email_quotes': 'Email Quotes',
      'bulk_email_credits': 'Email Credits',
      'from_name': 'From Name',
      'clone_to_expense': 'Clone to Expense',
      'recurring_expense': 'Recurring Expense',
      'recurring_expenses': 'Recurring Expenses',
      'new_recurring_expense': 'New Recurring Expense',
      'edit_recurring_expense': 'Edit Recurring Expense',
      'created_recurring_expense': 'Successfully created recurring expense',
      'updated_recurring_expense': 'Successfully updated recurring expense',
      'archived_recurring_expense': 'Successfully archived recurring expense',
      'deleted_recurring_expense': 'Successfully deleted recurring expense',
      'removed_recurring_expense': 'Successfully removed recurring expense',
      'restored_recurring_expense': 'Successfully restored recurring expense',
      'search_recurring_expense': 'Search Recurring Expense',
      'search_recurring_expenses': 'Search Recurring Expenses',
      'last_sent_date': 'Last Sent Date',
      'include_drafts': 'Include Drafts',
      'include_drafts_help': 'Include draft records in reports',
      'is_invoiced': 'Is Invoiced',
      'change_plan': 'Change Plan',
      'persist_data': 'Persist Data',
      'customer_count': 'Customer Count',
      'verify_customers': 'Verify Customers',
      'google_analytics': 'Google Analytics',
      'google_analytics_tracking_id': 'Google Analytics Tracking ID',
      'decimal_comma': 'Decimal Comma',
      'use_comma_as_decimal_place': 'Use comma as decimal place in forms',
      'select_method': 'Select Method',
      'select_platform': 'Select Platform',
      'use_web_app_to_connect_gmail':
          'Please use the web app to connect to Gmail',
      'expense_tax_help': 'Expense tax rates are disabled',
      'enable_markdown': 'Enable Markdown',
      'enable_markdown_help': 'Convert markdown to HTML on the PDF',
      'user_guide': 'User Guide',
      'add_second_contact': 'Add Second Contact',
      'previous_page': 'Previous Page',
      'next_page': 'Next Page',
      'export_colors': 'Export Colors',
      'import_colors': 'Import Colors',
      'clear_all': 'Clear All',
      'contrast': 'Contrast',
      'custom_colors': 'Custom Colors',
      'colors': 'Colors',
      'sidebar_active_background_color': 'Sidebar Active Background Color',
      'sidebar_active_font_color': 'Sidebar Active Font Color',
      'sidebar_inactive_background_color': 'Sidebar Inactive Background Color',
      'sidebar_inactive_font_color': 'Sidebar Inactive Font Color',
      'table_alternate_row_background_color':
          'Table Alternate Row Background Color',
      'invoice_header_background_color': 'Invoice Header Background Color',
      'invoice_header_font_color': 'Invoice Header Font Color',
      'net_subtotal': 'Net Subtotal',
      'review_app': 'Review App',
      'check_status': 'Check Status',
      'free_trial': 'Free Trial',
      'free_trial_ends_in_days': 'The Pro plan trial ends in :count days',
      'free_trial_ends_today': 'Today is the last day of the Pro plan trial',
      'change_email': 'Change Email',
      'client_portal_domain_hint':
          'Optionally configure a separate client portal domain',
      'tasks_shown_in_portal': 'Tasks Shown in Portal',
      'uninvoiced': 'Uninvoiced',
      'subdomain_guide':
          'The subdomain is used in the client portal to personalize links to match your brand. ie, https://your-brand.invoicing.co',
      'send_time': 'Send Time',
      'import_data': 'Import Data',
      'import_settings': 'Import Settings',
      'json_file_missing': 'Please provide the JSON file',
      'json_option_missing': 'Please select to import the settings and/or data',
      'json': 'JSON',
      'no_payment_types_enabled': 'No payment types enabled',
      'wait_for_data': 'Please wait for the data to finish loading',
      'net_total': 'Net Total',
      'has_taxes': 'Has Taxes',
      'import_customers': 'Import Customers',
      'imported_customers': 'Successfully started importing customers',
      'login_success': 'Successful Login',
      'login_failure': 'Failed Login',
      'exported_data':
          'Once the file is ready you\'ll receive an email with a download link',
      'include_deleted_clients': 'Include Deleted Clients',
      'include_deleted_clients_help':
          'Load records belonging to deleted clients',
      'step_1_sign_in': 'Step 1: Sign In',
      'step_2_authorize': 'Step 2: Authorize',
      'account_id': 'Account ID',
      'migration_not_yet_completed': 'The migration has not yet completed',
      'activity_100': ':user created recurring invoice :recurring_invoice',
      'activity_101': ':user updated recurring invoice :recurring_invoice',
      'activity_102': ':user archived recurring invoice :recurring_invoice',
      'activity_103': ':user deleted recurring invoice :recurring_invoice',
      'activity_104': ':user restored recurring invoice :recurring_invoice',
      'show_task_end_date': 'Show Task End Date',
      'show_task_end_date_help': 'Enable specifying the task end date',
      'gateway_setup': 'Gateway Setup',
      'preview_sidebar': 'Preview Sidebar',
      'years_data_shown': 'Years Data Shown',
      'ended_all_sessions': 'Successfully ended all sessions',
      'end_all_sessions': 'End All Sessions',
      'count_session': '1 Session',
      'count_sessions': ':count Sessions',
      'invoice_created': 'Invoice Created',
      'quote_created': 'Quote Created',
      'credit_created': 'Credit Created',
      'pro': 'Pro',
      'enterprise': 'Enterprise',
      'last_updated': 'Last Updated',
      'invoice_item': 'Invoice Item',
      'quote_item': 'Quote Item',
      'contact_first_name': 'Contact First Name',
      'contact_last_name': 'Contact Last Name',
      'order': 'Order',
      'unassigned': 'Unassigned',
      'partial_value': 'Must be greater than zero and less than the total',
      'search_kanban': 'Search Kanban',
      'search_kanbans': 'Search Kanban',
      'kanban': 'Kanban',
      'enable': 'Enable',
      'move_top': 'Move Top',
      'move_up': 'Move Up',
      'move_down': 'Move Down',
      'move_bottom': 'Move Bottom',
      'subdomain_help': 'Lowercase letters, numbers and hyphens are supported',
      'body_variable_missing':
          'Error: the custom email must include a :body variable',
      'add_body_variable_message': 'Make sure to include a :body variable',
      'view_date_formats': 'View Date Formats',
      'is_viewed': 'Is Viewed',
      'letter': 'Letter',
      'legal': 'Legal',
      'page_layout': 'Page Layout',
      'portrait': 'Portrait',
      'landscape': 'Landscape',
      'owner_upgrade_to_paid_plan':
          'The account owner can upgrade to a paid plan to enable the advanced advanced settings',
      'upgrade_to_paid_plan':
          'Upgrade to a paid plan to enable the advanced settings',
      'invoice_payment_terms': 'Invoice Payment Terms',
      'quote_valid_until': 'Quote Valid Until',
      'no_headers': 'No Headers',
      'add_header': 'Add Header',
      'remove_header': 'Remove Header',
      'return_url': 'Return URL',
      'rest_method': 'REST Method',
      'header_key': 'Header Key',
      'header_value': 'Header Value',
      'recurring_products': 'Recurring Products',
      'promo_code': 'Promo Code',
      'promo_discount': 'Promo Discount',
      'allow_cancellation': 'Allow Cancellation',
      'per_seat_enabled': 'Per Seat Enabled',
      'max_seats_limit': 'Max Seats Limit',
      'trial_enabled': 'Trial Enabled',
      'trial_duration': 'Trial Duration',
      'allow_query_overrides': 'Allow Query Overrides',
      'allow_plan_changes': 'Allow Plan Changes',
      'plan_map': 'Plan Map',
      'refund_period': 'Refund Period',
      'webhook_configuration': 'Webhook Configuration',
      'purchase_page': 'Purchase Page',
      'security': 'Security',
      'email_bounced': 'Email Bounced',
      'email_spam_complaint': 'Spam Complaint',
      'email_delivery': 'Email Delivery',
      'webhook_response': 'Webhook Response',
      'pdf_response': 'PDF Response',
      'authentication_failure': 'Authentication Failure',
      'pdf_failed': 'PDF Failed',
      'pdf_success': 'PDF Success',
      'modified': 'Modified',
      'payment_link': 'Payment Link',
      'new_payment_link': 'New Payment Link',
      'edit_payment_link': 'Edit Payment Link',
      'created_payment_link': 'Successfully created payment link',
      'updated_payment_link': 'Successfully updated payment link',
      'archived_payment_link': 'Successfully archived payment link',
      'deleted_payment_link': 'Successfully deleted payment link',
      'removed_payment_link': 'Successfully removed payment link',
      'restored_payment_link': 'Successfully restored payment link',
      'search_payment_link': 'Search 1 Payment Link',
      'search_payment_links': 'Search :count Payment Links',
      'subdomain_is_not_available': 'Subdomain is not available',
      'connect_gmail': 'Connect Gmail',
      'disconnect_gmail': 'Disconnect Gmail',
      'connected_gmail': 'Successfully connected Gmail',
      'disconnected_gmail': 'Successfully disconnected Gmail',
      'update_fail_help':
          'Changes to the codebase may be blocking the update, you can run this command to discard the changes:',
      'client_id_number': 'Client ID Number',
      'count_minutes': ':count Minutes',
      'password_timeout': 'Password Timeout',
      'shared_invoice_credit_counter': 'Shared Invoice/Credit Counter',
      'use_last_email': 'Use last email',
      'activate_company': 'Activate Company',
      'activate_company_help':
          'Enable emails, recurring invoices, webhooks and notifications',
      'an_error_occurred_try_again': 'An error occurred, please try again',
      'please_first_set_a_password': 'Please first set a password',
      'changing_phone_disables_two_factor':
          'Warning: Changing your phone number will disable 2FA',
      'help_translate': 'Help Translate',
      'please_select_a_country': 'Please select a country',
      'resend_invite': 'Resend Invite',
      'disabled_two_factor': 'Successfully disabled 2FA',
      'connected_google': 'Successfully connected account',
      'disconnected_google': 'Successfully disconnected account',
      'delivered': 'Delivered',
      'bounced': 'Bounced',
      'spam': 'Spam',
      'view_docs': 'View Docs',
      'enter_phone_to_enable_two_factor':
          'Please provide a mobile phone number to enable two factor authentication',
      'send_sms': 'Send SMS',
      'sms_code': 'SMS Code',
      'two_factor_setup_help': 'Scan the bar code with a :link compatible app.',
      'enabled_two_factor': 'Successfully enabled Two-Factor Authentication',
      'connect_google': 'Connect Google',
      'disconnect_google': 'Disconnect Google',
      'enable_two_factor': 'Enable Two Factor',
      'disable_two_factor': 'Disable Two Factor',
      'require_password_with_social_login':
          'Require Password with Social Login',
      'stay_logged_in': 'Stay Logged In',
      'session_about_to_expire': 'Warning: Your session is about to expire',
      'count_hours': ':count Hours',
      'count_day': '1 Day',
      'count_days': ':count Days',
      'web_session_timeout': 'Web Session Timeout',
      'security_settings': 'Security Settings',
      'resend_email': 'Resend Email',
      'confirm_your_email_address': 'Please confirm your email address',
      'refunded_payment': 'Successfully refunded payment',
      'partially_unapplied': 'Partially Unapplied',
      'select_a_gmail_user': 'Please select a user authenticated with Gmail',
      'list_long_press': 'List Long Press',
      'show_actions': 'Show Actions',
      'start_multiselect': 'Start Multiselect',
      'email_sent_to_confirm_email':
          'An email has been sent to confirm the email address',
      'counter_pattern_error':
          'To use :client_counter please add either :client_number or :client_id_number to prevent conflicts',
      'this_quarter': 'This Quarter',
      'last_quarter': 'Last Quarter',
      'to_update_run': 'To update run',
      'convert_to_invoice': 'Convert to Invoice',
      'registration_url': 'Registration URL',
      'invoice_project': 'Invoice Project',
      'invoice_task': 'Invoice Task',
      'invoice_expense': 'Invoice Expense',
      'search_payment_term': 'Search 1 Payment Term',
      'search_payment_terms': 'Search :count Payment Terms',
      'save_and_preview': 'Save and Preview',
      'save_and_email': 'Save and Email',
      'supported_events': 'Supported Events',
      'converted_amount': 'Converted Amount',
      'converted_balance': 'Converted Balance',
      'converted_paid_to_date': 'Converted Paid to Date',
      'converted_credit_balance': 'Converted Credit Balance',
      'converted_total': 'Converted Total',
      'is_sent': 'Is Sent',
      'default_documents': 'Default Documents',
      'document_upload': 'Document Upload',
      'document_upload_help': 'Enable clients to upload documents',
      'expense_total': 'Expense Total',
      'enter_taxes': 'Enter Taxes',
      'by_rate': 'By Rate',
      'by_amount': 'By Amount',
      'enter_amount': 'Enter Amount',
      'before_taxes': 'Before Taxes',
      'after_taxes': 'After Taxes',
      'color': 'Color',
      'show': 'Show',
      'hide': 'Hide',
      'empty_columns': 'Empty Columns',
      'debug_mode_is_enabled': 'Debug mode is enabled',
      'debug_mode_is_enabled_help':
          'Warning: it is intended for use on local machines, it can leak credentials. Click to learn more.',
      'running_tasks': 'Running Tasks',
      'recent_tasks': 'Recent Tasks',
      'recent_expenses': 'Recent Expenses',
      'upcoming_expenses': 'Upcoming Expenses',
      'update_app': 'Update App',
      'started_import': 'Successfully started import',
      'duplicate_column_mapping': 'Duplicate column mapping',
      'uses_inclusive_taxes': 'Uses Inclusive Taxes',
      'is_amount_discount': 'Is Amount Discount',
      'column': 'Column',
      'sample': 'Sample',
      'map_to': 'Map To',
      'import': 'Import',
      'first_row_as_column_names': 'Use first row as column names',
      'select_file': 'Select File',
      'no_file_selected': 'No File Selected',
      'csv_file': 'CSV File',
      'csv': 'CSV',
      'freshbooks': 'FreshBooks',
      'invoice2go': 'Invoice2go',
      'invoicely': 'Invoicely',
      'waveaccounting': 'Wave Accounting',
      'zoho': 'Zoho',
      'accounting': 'Accounting',
      'required_files_missing': 'Please provide all CSVs.',
      'import_type': 'Import Type',
      'html_mode': 'HTML Mode',
      'html_mode_help': 'Preview updates faster but is less accurate',
      'view_licenses': 'View Licenses',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': 'Fullscreen Editor',
      'sidebar_editor': 'Sidebar Editor',
      'please_type_to_confirm': 'Please type \':value\' to confirm',
      'purge': 'Purge',
      'service': 'Service',
      'clone_to': 'Clone To',
      'clone_to_other': 'Clone to Other',
      'labels': 'Labels',
      'add_custom': 'Add Custom',
      'payment_tax': 'Payment Tax',
      'unpaid': 'Unpaid',
      'white_label': 'White Label',
      'delivery_note': 'Delivery Note',
      'sent_invoices_are_locked': 'Sent invoices are locked',
      'paid_invoices_are_locked': 'Paid invoices are locked',
      'source_code': 'Source Code',
      'app_platforms': 'App Platforms',
      'invoice_late': 'Invoice Late',
      'quote_expired': 'Quote Expired',
      'partial_due': 'Partial Due',
      'invoice_total': 'Invoice Total',
      'quote_total': 'Quote Total',
      'credit_total': 'Credit Total',
      'recurring_invoice_total': 'Invoice Total',
      'actions': 'Actions',
      'expense_number': 'Expense Number',
      'task_number': 'Task Number',
      'project_number': 'Project Number',
      'project_name': 'Project Name',
      'warning': 'Warning',
      'view_settings': 'View Settings',
      'company_disabled_warning': 'Company is not activated',
      'late_invoice': 'Late Invoice',
      'expired_quote': 'Expired Quote',
      'remind_invoice': 'Remind Invoice',
      'cvv': 'CVV',
      'client_name': 'Client Name',
      'client_phone': 'Client Phone',
      'required_fields': 'Required Fields',
      'calculated_rate': 'Calculated Rate',
      'default_task_rate': 'Default Task Rate',
      'clear_cache': 'Clear Cache',
      'sort_order': 'Sort Order',
      'task_status': 'Status',
      'task_statuses': 'Task Statuses',
      'new_task_status': 'New Task Status',
      'edit_task_status': 'Edit Task Status',
      'created_task_status': 'Successfully created task status',
      'updated_task_status': 'Successfully updated task status',
      'archived_task_status': 'Successfully archived task status',
      'deleted_task_status': 'Successfully deleted task status',
      'removed_task_status': 'Successfully removed task status',
      'restored_task_status': 'Successfully restored task status',
      'archived_task_statuses': 'Successfully archived :value task statuses',
      'deleted_task_statuses': 'Successfully deleted :value task statuses',
      'restored_task_statuses': 'Successfully restored :value task statuses',
      'search_task_status': 'Search 1 Task Status',
      'search_task_statuses': 'Search :count Task Statuses',
      'show_tasks_table': 'Show Tasks Table',
      'show_tasks_table_help':
          'Always show the tasks section when creating invoices',
      'invoice_task_timelog': 'Invoice Task Timelog',
      'invoice_task_timelog_help': 'Add time details to the invoice line items',
      'invoice_task_datelog': 'Invoice Task Datelog',
      'invoice_task_datelog_help': 'Add date details to the invoice line items',
      'auto_start_tasks_help': 'Start tasks before saving',
      'configure_statuses': 'Configure Statuses',
      'task_settings': 'Task Settings',
      'configure_categories': 'Configure Categories',
      'expense_categories': 'Expense Categories',
      'new_expense_category': 'New Expense Category',
      'edit_expense_category': 'Edit Expense Category',
      'created_expense_category': 'Successfully created expense category',
      'updated_expense_category': 'Successfully updated expense category',
      'archived_expense_category': 'Successfully archived expense category',
      'deleted_expense_category': 'Successfully deleted expense category',
      'removed_expense_category': 'Successfully removed expense category',
      'restored_expense_category': 'Successfully restored expense category',
      'archived_expense_categories':
          'Successfully archived expense :value categories',
      'deleted_expense_categories':
          'Successfully deleted expense :value categories',
      'restored_expense_categories':
          'Successfully restored expense :value categories',
      'search_expense_category': 'Search 1 Expense Category',
      'search_expense_categories': 'Search :count Expense Categories',
      'use_available_credits': 'Use Available Credits',
      'show_option': 'Show Option',
      'negative_payment_error': 'The payment amount can not be negative',
      'view_changes': 'View Changes',
      'force_update': 'Force Update',
      'force_update_help':
          'You are running the latest version but there may be pending fixes available.',
      'mark_paid_help': 'Track the expense has been paid to the vendor',
      'should_be_invoiced': 'Should be Invoiced',
      'should_be_invoiced_help':
          'Enable the expense to be invoiced to your client',
      'add_documents_to_invoice_help': 'Make the documents visible to clients',
      'convert_currency_help': 'Set an exchange rate',
      'expense_settings': 'Expense Settings',
      'clone_to_recurring': 'Clone to Recurring',
      'crypto': 'Crypto',
      'paypal': 'PayPal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple Pay',
      'user_field': 'User Field',
      'variables': 'Variables',
      'show_password': 'Show Password',
      'hide_password': 'Hide Password',
      'copy_error': 'Copy Error',
      'capture_card': 'Capture Card',
      'auto_bill_enabled': 'Auto Bill Enabled',
      'total_taxes': 'Total Taxes',
      'line_taxes': 'Line Taxes', 'total_fields': 'Total Fields',
      'stopped_recurring_invoice': 'Successfully stopped recurring invoice',
      'started_recurring_invoice': 'Successfully started recurring invoice',
      'resumed_recurring_invoice': 'Successfully resumed recurring invoice',
      'gateway_refund': 'Gateway Refund',
      'gateway_refund_help': 'Process the refund with the payment gateway',
      'due_date_days': 'Due Date',
      'paused': 'Paused',
      'mark_active': 'Mark Active',
      'day_count': 'Day :count',
      'first_day_of_the_month': 'First Day of the Month',
      'last_day_of_the_month': 'Last Day of the Month',
      'use_payment_terms': 'Use Payment Terms',
      'endless': 'Endless',
      'next_send_date': 'Next Send Date',
      'remaining_cycles': 'Remaining Cycles',
      'recurring_invoice': 'Recurring Invoice',
      'recurring_invoices': 'Recurring Invoices',
      'new_recurring_invoice': 'New Recurring Invoice',
      'edit_recurring_invoice': 'Edit Recurring Invoice',
      'created_recurring_invoice': 'Successfully created recurring invoice',
      'updated_recurring_invoice': 'Successfully updated recurring invoice',
      'archived_recurring_invoice': 'Successfully archived recurring invoice',
      'deleted_recurring_invoice': 'Successfully deleted recurring invoice',
      'removed_recurring_invoice': 'Successfully removed recurring invoice',
      'restored_recurring_invoice': 'Successfully restored recurring invoice',
      'archived_recurring_invoices':
          'Successfully archived recurring :value invoices',
      'deleted_recurring_invoices':
          'Successfully deleted recurring :value invoices',
      'restored_recurring_invoices':
          'Successfully restored recurring :value invoices',
      'search_recurring_invoice': 'Search 1 Recurring Invoice',
      'search_recurring_invoices': 'Search :count Recurring Invoices',
      'send_date': 'Send Date',
      'auto_bill_on': 'Auto Bill On',
      'minimum_under_payment_amount': 'Minimum Under Payment Amount',
      'profit': 'Profit',
      'line_item': 'Line Item',
      'allow_over_payment': 'Allow Over Payment',
      'allow_over_payment_help':
          'Support paying extra to accept tips in the client portal',
      'allow_under_payment': 'Allow Under Payment',
      'allow_under_payment_help':
          'Support paying a minimum amount in the client portal',
      'test_mode': 'Test Mode',
      'opened': 'Opened',
      'payment_reconciliation_failure': 'Reconciliation Failure',
      'payment_reconciliation_success': 'Reconciliation Success',
      'gateway_success': 'Gateway Success',
      'gateway_failure': 'Gateway Failure',
      'gateway_error': 'Gateway Error',
      'email_send': 'Email Send',
      'email_retry_queue': 'Email Retry Queue',
      'failure': 'Failure',
      'quota_exceeded': 'Quota Exceeded',
      'upstream_failure': 'Upstream Failure',
      'system_logs': 'System Logs',
      'view_portal': 'View Portal',
      'copy_link': 'Copy Link',
      'token_billing': 'Token Billing',
      'welcome_to_invoice_ninja': 'Welcome to Invoice Ninja',
      'always': 'Enabled',
      'optin': 'Disabled by default',
      'optout': 'Enabled by default',
      'label': 'Label',
      'client_number': 'Client Number',
      'auto_convert': 'Auto Convert',
      'company_name': 'Company Name',
      'reminder1_sent': 'Reminder 1 Sent',
      'reminder2_sent': 'Reminder 2 Sent',
      'reminder3_sent': 'Reminder 3 Sent',
      'reminder_last_sent': 'Reminder Last Sent',
      'pdf_page_info': 'Page :current of :total',
      'emailed_invoices': 'Successfully queued invoices to be sent',
      'emailed_quotes': 'Successfully queued quotes to be sent',
      'emailed_credits': 'Successfully queued credits to be sent',
      'gateway': 'Gateway',
      'view_in_stripe': 'View in Stripe',
      'rows_per_page': 'Rows Per Page',
      'hours': 'Hours',
      'statement': 'Statement',
      'taxes': 'Taxes',
      'surcharge': 'Surcharge',
      'apply_payment': 'Apply Payment',
      'apply_credit': 'Apply Credit',
      'apply': 'Apply',
      'unapplied': 'Unapplied',
      'select_label': 'Select Label',
      'custom_labels': 'Custom Labels',
      'record_type': 'Record Type',
      'record_name': 'Record Name',
      'file_type': 'File Type',
      'height': 'Height',
      'width': 'Width',
      'to': 'To',
      'health_check': 'Health Check',
      'payment_type_id': 'Payment Type',
      'last_login_at': 'Last Login At',
      'company_key': 'Company Key',
      'storefront': 'Storefront',
      'storefront_help': 'Enable third-party apps to create invoices',
      'client_created': 'Client Created',
      'online_payment_email': 'Online Payment Email',
      'manual_payment_email': 'Manual Payment Email',
      'completed': 'Completed',
      'gross': 'Gross',
      'net_amount': 'Net Amount',
      'net_balance': 'Net Balance',
      'client_settings': 'Client Settings',
      'selected_invoices': 'Selected Invoices',
      'selected_payments': 'Selected Payments',
      'selected_quotes': 'Selected Quotes',
      'selected_tasks': 'Selected Tasks',
      'selected_expenses': 'Selected Expenses',
      'upcoming_invoices': 'Upcoming Invoices',
      'past_due_invoices': 'Past Due Invoices',
      'recent_payments': 'Recent Payments',
      'upcoming_quotes': 'Upcoming Quotes',
      'expired_quotes': 'Expired Quotes',
      'create_client': 'Create Client',
      'create_invoice': 'Create Invoice',
      'create_quote': 'Create Quote',
      'create_payment': 'Create Payment',
      'create_vendor': 'Create Vendor',
      'update_quote': 'Update Quote',
      'delete_quote': 'Delete Quote',
      'update_invoice': 'Update Invoice',
      'delete_invoice': 'Delete Invoice',
      'update_client': 'Update Client',
      'delete_client': 'Delete Client',
      'delete_payment': 'Delete Payment',
      'update_vendor': 'Update Vendor',
      'delete_vendor': 'Delete Vendor',
      'create_expense': 'Create Expense',
      'update_expense': 'Update Expense',
      'delete_expense': 'Delete Expense',
      'create_task': 'Create Task',
      'update_task': 'Update Task',
      'delete_task': 'Delete Task',
      'approve_quote': 'Approve Quote',
      'off': 'Off',
      'when_paid': 'When Paid',
      'expires_on': 'Expires On',
      'free': 'Free',
      'plan': 'Plan',
      'show_sidebar': 'Show Sidebar',
      'hide_sidebar': 'Hide Sidebar',
      'event_type': 'Event Type',
      'target_url': 'Target URL',
      'copy': 'Copy',
      'must_be_online': 'Please restart the app once connected to the internet',
      'crons_not_enabled': 'The crons need to be enabled',
      'api_webhooks': 'API Webhooks',
      'search_webhooks': 'Search :count Webhooks',
      'search_webhook': 'Search 1 Webhook',
      'webhook': 'Webhook',
      'webhooks': 'Webhooks',
      'new_webhook': 'New Webhook',
      'edit_webhook': 'Edit Webhook',
      'created_webhook': 'Successfully created webhook',
      'updated_webhook': 'Successfully updated webhook',
      'archived_webhook': 'Successfully archived webhook',
      'deleted_webhook': 'Successfully deleted webhook',
      'removed_webhook': 'Successfully removed webhook',
      'restored_webhook': 'Successfully restored webhook',
      'archived_webhooks': 'Successfully archived :value webhooks',
      'deleted_webhooks': 'Successfully deleted :value webhooks',
      'removed_webhooks': 'Successfully removed :value webhooks',
      'restored_webhooks': 'Successfully restored :value webhooks',
      'api_tokens': 'API Tokens',
      'api_docs': 'API Docs',
      'search_tokens': 'Search :count Tokens',
      'search_token': 'Search 1 Token',
      'token': 'Token',
      'tokens': 'Tokens',
      'new_token': 'New Token',
      'edit_token': 'Edit Token',
      'created_token': 'Successfully created token',
      'updated_token': 'Successfully updated token',
      'archived_token': 'Successfully archived token',
      'deleted_token': 'Successfully deleted token',
      'removed_token': 'Successfully removed token',
      'restored_token': 'Successfully restored token',
      'archived_tokens': 'Successfully archived :value tokens',
      'deleted_tokens': 'Successfully deleted :value tokens',
      'restored_tokens': 'Successfully restored :value tokens',
      'client_registration': 'Client Registration',
      'client_registration_help':
          'Enable clients to self register in the portal',
      'email_invoice': 'Email Invoice',
      'email_quote': 'Email Quote',
      'email_credit': 'Email Credit',
      'email_payment': 'Email Payment',
      'client_email_not_set': 'Client does not have an email address set',
      'ledger': 'Ledger',
      'view_pdf': 'View PDF',
      'all_records': 'All records',
      'owned_by_user': 'Owned by user',
      'credit_remaining': 'Credit Remaining',
      'contact_name': 'Contact Name',
      'use_default': 'Use Default',
      'reminder_endless': 'Endless Reminders',
      'number_of_days': 'Number of days',
      'configure_payment_terms': 'Configure Payment Terms',
      'payment_term': 'Payment Term',
      'new_payment_term': 'New Payment Term',
      'edit_payment_term': 'Edit Payment Term',
      'created_payment_term': 'Successfully created payment term',
      'updated_payment_term': 'Successfully updated payment term',
      'archived_payment_term': 'Successfully archived payment term',
      'deleted_payment_term': 'Successfully deleted payment term',
      'removed_payment_term': 'Successfully removed payment term',
      'restored_payment_term': 'Successfully restored payment term',
      'archived_payment_terms': 'Successfully archived :value payment terms',
      'deleted_payment_terms': 'Successfully deleted :value payment terms',
      'restored_payment_terms': 'Successfully restored :value payment terms',
      'email_sign_in': 'Login with email',
      'change': 'Change',
      'change_to_mobile_layout': 'Change to the mobile layout?',
      'change_to_desktop_layout': 'Change to the desktop layout?',
      'send_from_gmail': 'Send from Gmail',
      'reversed': 'Reversed',
      'cancelled': 'Cancelled',
      'credit_amount': 'Credit Amount',
      'quote_amount': 'Quote Amount',
      'hosted': 'Hosted',
      'selfhosted': 'Self-Hosted',
      'exclusive': 'Exclusive',
      'inclusive': 'Inclusive',
      'hide_menu': 'Hide Menu',
      'show_menu': 'Show Menu',
      'partially_refunded': 'Partially Refunded',
      'search_documents': 'Search :count Documents',
      'search_designs': 'Search :count Designs',
      'search_invoices': 'Search :count Invoices',
      'search_clients': 'Search :count Clients',
      'search_products': 'Search :count Products',
      'search_quotes': 'Search :count Quotes',
      'search_credits': 'Search :count Credits',
      'search_vendors': 'Search :count Vendors',
      'search_users': 'Search :count Users',
      'search_tax_rates': 'Search :count Tax Rates',
      'search_tasks': 'Search :count Tasks',
      'search_settings': 'Search Settings',
      'search_projects': 'Search :count Projects',
      'search_expenses': 'Search :count Expenses',
      'search_payments': 'Search :count Payments',
      'search_groups': 'Search :count Groups',
      'search_company': 'Search Company',
      'search_document': 'Search 1 Document',
      'search_design': 'Search 1 Design',
      'search_invoice': 'Search 1 Invoice',
      'search_client': 'Search 1 Client',
      'search_product': 'Search 1 Product',
      'search_quote': 'Search 1 Quote',
      'search_credit': 'Search 1 Credit',
      'search_vendor': 'Search 1 Vendor',
      'search_user': 'Search 1 User',
      'search_tax_rate': 'Search 1 Tax Rate',
      'search_task': 'Search 1 Tasks',
      'search_project': 'Search 1 Project',
      'search_expense': 'Search 1 Expense',
      'search_payment': 'Search 1 Payment',
      'search_group': 'Search 1 Group',
      'refund_payment': 'Refund Payment',
      'cancelled_invoice': 'Successfully cancelled invoice',
      'cancelled_invoices': 'Successfully cancelled invoices',
      'reversed_invoice': 'Successfully reversed invoice',
      'reversed_invoices': 'Successfully reversed invoices',
      'reverse': 'Reverse',
      'full_name': 'Full Name',
      'city_state_postal': 'City/State/Postal',
      'postal_city_state': 'Postal/City/State',
      'custom1': 'Custom 1',
      'custom2': 'Custom 2',
      'custom3': 'Custom 3',
      'custom4': 'Custom 4',
      'optional': 'Optional',
      'license': 'License',
      'purge_data': 'Purge Data',
      'purge_successful': 'Successfully purged company data',
      'purge_data_message':
          'Warning: This will permanently erase your data, there is no undo.',
      'invoice_balance': 'Invoice Balance',
      'age_group_0': '0 - 30 Days',
      'age_group_30': '30 - 60 Days',
      'age_group_60': '60 - 90 Days',
      'age_group_90': '90 - 120 Days',
      'age_group_120': '120+ Days',
      'refresh': 'Refresh',
      'saved_design': 'Successfully saved design',
      'client_details': 'Client Details',
      'company_address': 'Company Address',
      'invoice_details': 'Invoice Details',
      'quote_details': 'Quote Details',
      'credit_details': 'Credit Details',
      'product_columns': 'Product Columns',
      'task_columns': 'Task Columns',
      'add_field': 'Add Field',
      'all_events': 'All Events',
      'permissions': 'Permissions',
      'none': 'None',
      'owned': 'Owned',
      'payment_success': 'Payment Success',
      'payment_failure': 'Payment Failure',
      'invoice_sent': 'Invoice Sent',
      'quote_sent': 'Quote Sent',
      'credit_sent': 'Credit Sent',
      'invoice_viewed': 'Invoice Viewed',
      'quote_viewed': 'Quote Viewed',
      'credit_viewed': 'Credit Viewed',
      'quote_approved': 'Quote Approved',
      'receive_all_notifications': 'Receive All Notifications',
      'purchase_license': 'Purchase License',
      'apply_license': 'Apply License',
      'cancel_account': 'Delete Account',
      'cancel_account_message':
          'Warning: This will permanently delete your account [:company], there is no undo',
      'delete_company': 'Delete Company',
      'delete_company_message':
          'Warning: This will permanently delete your company [:company], there is no undo',
      'enabled_modules': 'Enabled Modules',
      'converted_quote': 'Successfully converted quote',
      'credit_design': 'Credit Design',
      'includes': 'Includes',
      'header': 'Header',
      'load_design': 'Load Design',
      'css_framework': 'CSS Framework',
      'custom_designs': 'Custom Designs',
      'designs': 'Designs',
      'new_design': 'New Design',
      'edit_design': 'Edit Design',
      'created_design': 'Successfully created design',
      'updated_design': 'Successfully updated design',
      'archived_design': 'Successfully archived design',
      'deleted_design': 'Successfully deleted design',
      'removed_design': 'Successfully removed design',
      'restored_design': 'Successfully restored design',
      'archived_designs': 'Successfully archived :value designs',
      'deleted_designs': 'Successfully deleted :value designs',
      'restored_designs': 'Successfully restored :value designs',
      'proposals': 'Proposals',
      'tickets': 'Tickets',
      'recurring_quotes': 'Recurring Quotes',
      'recurring_tasks': 'Recurring Tasks',
      'account_management': 'Account Management',
      'credit_date': 'Credit Date',
      'credit': 'Credit',
      'credits': 'Credits',
      'new_credit': 'New Credit',
      'edit_credit': 'Edit Credit',
      'created_credit': 'Successfully created credit',
      'updated_credit': 'Successfully updated credit',
      'archived_credit': 'Successfully archived credit',
      'deleted_credit': 'Successfully deleted credit',
      'removed_credit': 'Successfully removed credit',
      'restored_credit': 'Successfully restored credit',
      'archived_credits': 'Successfully archived :value credits',
      'deleted_credits': 'Successfully deleted :value credits',
      'restored_credits': 'Successfully restored :value credits',
      'current_version': 'Current Version',
      'latest_version': 'Latest Version',
      'update_now': 'Update Now',
      'a_new_version_is_available': 'A new version of the web app is available',
      'update_available': 'Update Available',
      'app_updated': 'Update successfully completed',
      'learn_more': 'Learn More',
      'integrations': 'Integrations',
      'tracking_id': 'Tracking ID',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': 'Credit Footer',
      'credit_terms': 'Credit Terms',
      'new_company': 'New Company',
      'added_company': 'Successfully added company',
      'company1': 'Custom Company 1',
      'company2': 'Custom Company 2',
      'company3': 'Custom Company 3',
      'company4': 'Custom Company 4',
      'product1': 'Custom Product 1',
      'product2': 'Custom Product 2',
      'product3': 'Custom Product 3',
      'product4': 'Custom Product 4',
      'client1': 'Custom Client 1',
      'client2': 'Custom Client 2',
      'client3': 'Custom Client 3',
      'client4': 'Custom Client 4',
      'contact1': 'Custom Contact 1',
      'contact2': 'Custom Contact 2',
      'contact3': 'Custom Contact 3',
      'contact4': 'Custom Contact 4',
      'task1': 'Custom Task 1',
      'task2': 'Custom Task 2',
      'task3': 'Custom Task 3',
      'task4': 'Custom Task 4',
      'project1': 'Custom Project 1',
      'project2': 'Custom Project 2',
      'project3': 'Custom Project 3',
      'project4': 'Custom Project 4',
      'expense1': 'Custom Expense 1',
      'expense2': 'Custom Expense 2',
      'expense3': 'Custom Expense 3',
      'expense4': 'Custom Expense 4',
      'vendor1': 'Custom Vendor 1',
      'vendor2': 'Custom Vendor 2',
      'vendor3': 'Custom Vendor 3',
      'vendor4': 'Custom Vendor 4',
      'invoice1': 'Custom Invoice 1',
      'invoice2': 'Custom Invoice 2',
      'invoice3': 'Custom Invoice 3',
      'invoice4': 'Custom Invoice 4',
      'payment1': 'Custom Payment 1',
      'payment2': 'Custom Payment 2',
      'payment3': 'Custom Payment 3',
      'payment4': 'Custom Payment 4',
      'surcharge1': 'Custom Surcharge 1',
      'surcharge2': 'Custom Surcharge 2',
      'surcharge3': 'Custom Surcharge 3',
      'surcharge4': 'Custom Surcharge 4',
      'group1': 'Custom Group 1',
      'group2': 'Custom Group 2',
      'group3': 'Custom Group 3',
      'group4': 'Custom Group 4',
      'reset': 'Reset',
      'number': 'Number',
      'export': 'Export',
      'chart': 'Chart',
      'count': 'Count',
      'totals': 'Totals',
      'blank': 'Blank',
      'day': 'Day',
      'month': 'Month',
      'year': 'Year',
      'subgroup': 'Subgroup',
      'is_active': 'Is Active',
      'group_by': 'Group By',
      'credit_balance': 'Credit Balance',
      'contact_last_login': 'Contact Last Login',
      'contact_full_name': 'Contact Full Name',
      'contact_phone': 'Contact Phone',
      'contact_custom_value1': 'Contact Custom Value 1',
      'contact_custom_value2': 'Contact Custom Value 2',
      'contact_custom_value3': 'Contact Custom Value 3',
      'contact_custom_value4': 'Contact Custom Value 4',
      'shipping_address1': 'Shipping Street',
      'shipping_address2': 'Shipping Apt/Suite',
      'shipping_city': 'Shipping City',
      'shipping_state': 'Shipping State/Province',
      'shipping_postal_code': 'Shipping Postal Code',
      'shipping_country': 'Shipping Country',
      'billing_address1': 'Billing Street',
      'billing_address2': 'Billing Apt/Suite',
      'billing_city': 'Billing City',
      'billing_state': 'Billing State/Province',
      'billing_postal_code': 'Billing Postal Code',
      'billing_country': 'Billing Country',
      'client_id': 'Client ID',
      'assigned_to': 'Assigned To',
      'created_by': 'Created By',
      'assigned_to_id': 'Assigned To ID',
      'created_by_id': 'Created By ID',
      'add_column': 'Add Column',
      'edit_columns': 'Edit Columns',
      'columns': 'Columns',
      'aging': 'Aging',
      'profit_and_loss': 'Profit and Loss',
      'reports': 'Reports',
      'report': 'Report',
      'add_company': 'Add Company',
      'unpaid_invoice': 'Unpaid Invoice',
      'paid_invoice': 'Paid Invoice',
      'unapproved_quote': 'Unapproved Quote',
      'help': 'Help',
      'refund': 'Refund',
      'refund_date': 'Refund Date',
      'filtered_by': 'Filtered by :value',
      'contact_email': 'Contact Email',
      'multiselect': 'Multiselect',
      'entity_state': 'Entity State',
      'verify_password': 'Verify Password',
      'applied': 'Applied',
      'include_recent_errors': 'Include recent errors from the logs',
      'your_message_has_been_received':
          'We have received your message and will try to respond promptly.',
      'message': 'Message',
      'from': 'From',
      'show_product_details': 'Show Product Details',
      'show_product_details_help':
          'Include the description and cost in the product dropdown',
      'pdf_min_requirements': 'The PDF renderer requires :version',
      'adjust_fee_percent': 'Adjust Fee Percent',
      'adjust_fee_percent_help': 'Ensure client fee matches the gateway fee',
      'configure_settings': 'Configure Settings',
      'support_forum': 'Support Forum',
      'about': 'About',
      'documentation': 'Documentation',
      'contact_us': 'Contact Us',
      'subtotal': 'Subtotal',
      'line_total': 'Line Total',
      'item': 'Item',
      'credit_email': 'Credit Email',
      'iframe_url': 'iFrame URL',
      'domain_url': 'Domain URL',
      'password_is_too_short': 'Password must be at least 8 character long',
      'password_is_too_easy':
          'Password must contain an upper case character and a number',
      'client_portal_tasks': 'Client Portal Tasks',
      'client_portal_dashboard': 'Client Portal Dashboard',
      'please_enter_a_value': 'Please enter a value',
      'deleted_logo': 'Successfully deleted logo',
      'yes': 'Yes',
      'no': 'No',
      'generate_number': 'Generate Number',
      'when_saved': 'When Saved',
      'when_sent': 'When Sent',
      'select_company': 'Select Company',
      'float': 'Float',
      'collapse': 'Collapse',
      'show_or_hide': 'Show/hide',
      'menu_sidebar': 'Menu Sidebar',
      'history_sidebar': 'History Sidebar',
      'tablet': 'Tablet',
      'mobile': 'Mobile',
      'desktop': 'Desktop',
      'layout': 'Layout',
      'view': 'View',
      'module': 'Module',
      'first_custom': 'First Custom',
      'second_custom': 'Second Custom',
      'third_custom': 'Third Custom',
      'show_cost': 'Show Cost',
      'show_product_cost': 'Show Product Cost',
      'show_cost_help':
          'Display a product cost field to track the markup/profit',
      'show_product_quantity': 'Show Product Quantity',
      'show_product_quantity_help':
          'Display a product quantity field, otherwise default to one',
      'show_invoice_quantity': 'Show Invoice Quantity',
      'show_invoice_quantity_help':
          'Display a line item quantity field, otherwise default to one',
      'show_product_discount': 'Show Product Discount',
      'show_product_discount_help': 'Display a line item discount field',
      'default_quantity': 'Default Quantity',
      'default_quantity_help':
          'Automatically set the line item quantity to one',
      'one_tax_rate': 'One Tax Rate',
      'two_tax_rates': 'Two Tax Rates',
      'three_tax_rates': 'Three Tax Rates',
      'default_tax_rate': 'Default Tax Rate',
      'user': 'User',
      'invoice_tax': 'Invoice Tax',
      'line_item_tax': 'Line Item Tax',
      'inclusive_taxes': 'Inclusive Taxes',
      'invoice_tax_rates': 'Invoice Tax Rates',
      'item_tax_rates': 'Item Tax Rates',
      'no_client_selected': 'No client selected',
      'configure_rates': 'Configure Rates',
      'configure_gateways': 'Configure Gateways',
      'tax_settings': 'Tax Settings',
      'tax_settings_rates': 'Tax Rates',
      'accent_color': 'Accent Color',
      'switch': 'Switch',
      'comma_sparated_list': 'Comma separated list',
      'options': 'Options',
      'single_line_text': 'Single-line text',
      'multi_line_text': 'Multi-line text',
      'dropdown': 'Dropdown',
      'field_type': 'Field Type',
      'recover_password_email_sent': 'A password recovery email has been sent',
      'submit': 'Submit',
      'recover_password': 'Recover Password',
      'late_fees': 'Late Fees',
      'credit_number': 'Credit Number',
      'payment_number': 'Payment Number',
      'late_fee_amount': 'Late Fee Amount',
      'late_fee_percent': 'Late Fee Percent',
      'before_due_date': 'Before the due date',
      'after_due_date': 'After the due date',
      'after_invoice_date': 'After the invoice date',
      'days': 'Days',
      'invoice_email': 'Invoice Email',
      'payment_email': 'Payment Email',
      'partial_payment': 'Partial Payment',
      'payment_partial': 'Partial Payment',
      'partial_payment_email': 'Partial Payment Email',
      'quote_email': 'Quote Email',
      'endless_reminder': 'Endless Reminder',
      'filtered_by_user': 'Filtered by User',
      'administrator': 'Administrator',
      'administrator_help':
          'Allow user to manage users, change settings and modify all records',
      'user_management': 'User Management',
      'users': 'Users',
      'new_user': 'New User',
      'edit_user': 'Edit User',
      'created_user': 'Successfully created user',
      'updated_user': 'Successfully updated user',
      'archived_user': 'Successfully archived user',
      'deleted_user': 'Successfully deleted user',
      'removed_user': 'Successfully removed user',
      'restored_user': 'Successfully restored user',
      'archived_users': 'Successfully archived :value users',
      'deleted_users': 'Successfully deleted :value users',
      'removed_users': 'Successfully removed :value users',
      'restored_users': 'Successfully restored :value users',
      'general_settings': 'General Settings',
      'invoice_options': 'Invoice Options',
      'hide_paid_to_date': 'Hide Paid to Date',
      'hide_paid_to_date_help':
          'Only display the \'Paid to Date\' area on your invoices once a payment has been received.',
      'invoice_embed_documents': 'Embed Documents',
      'invoice_embed_documents_help': 'Include attached images in the invoice.',
      'all_pages_header': 'Show Header on',
      'all_pages_footer': 'Show Footer on',
      'first_page': 'First page',
      'all_pages': 'All pages',
      'last_page': 'Last page',
      'primary_font': 'Primary Font',
      'secondary_font': 'Secondary Font',
      'primary_color': 'Primary Color',
      'secondary_color': 'Secondary Color',
      'page_size': 'Page Size',
      'font_size': 'Font Size',
      'quote_design': 'Quote Design',
      'invoice_fields': 'Invoice Fields',
      'product_fields': 'Product Fields',
      'invoice_terms': 'Invoice Terms',
      'invoice_footer': 'Invoice Footer',
      'quote_terms': 'Quote Terms',
      'quote_footer': 'Quote Footer',
      'auto_email_invoice': 'Auto Email',
      'auto_email_invoice_help':
          'Automatically email recurring invoices when they are created.',
      'auto_archive_quote': 'Auto Archive',
      'auto_archive_quote_help':
          'Automatically archive quotes when they are converted.',
      'auto_convert_quote': 'Auto Convert',
      'auto_convert_quote_help':
          'Automatically convert a quote to an invoice when approved by a client.',
      'workflow_settings': 'Workflow Settings',
      'freq_daily': 'Daily',
      'freq_weekly': 'Weekly',
      'freq_two_weeks': 'Two Weeks',
      'freq_four_weeks': 'Four Weeks',
      'freq_monthly': 'Monthly',
      'freq_two_months': 'Two Months',
      'freq_three_months': 'Three Months',
      'freq_four_months': 'Four Months',
      'freq_six_months': 'Six Months',
      'freq_annually': 'Annually',
      'freq_two_years': 'Two Years',
      'freq_three_years': 'Three Years',
      'never': 'Never',
      'company': 'Company',
      'generated_numbers': 'Generated Numbers',
      'charge_taxes': 'Charge Taxes',
      'next_reset': 'Next Reset',
      'reset_counter': 'Reset Counter',
      'recurring_prefix': 'Recurring Prefix',
      'number_padding': 'Number Padding',
      'general': 'General',
      'surcharge_field': 'Surcharge Field',
      'company_field': 'Company Field',
      'company_value': 'Company Value',
      'credit_field': 'Credit Field',
      'invoice_field': 'Invoice Field',
      'invoice_surcharge': 'Invoice Surcharge',
      'client_field': 'Client Field',
      'product_field': 'Product Field',
      'payment_field': 'Payment Field',
      'contact_field': 'Contact Field',
      'vendor_field': 'Vendor Field',
      'expense_field': 'Expense Field',
      'project_field': 'Project Field',
      'task_field': 'Task Field',
      'group_field': 'Group Field',
      'number_counter': 'Number Counter',
      'prefix': 'Prefix',
      'number_pattern': 'Number Pattern',
      'messages': 'Messages',
      'custom_css': 'Custom CSS',
      'custom_javascript': 'Custom JavaScript',
      'signature_on_pdf': 'Show on PDF',
      'signature_on_pdf_help':
          'Show the client signature on the invoice/quote PDF.',
      'show_accept_invoice_terms': 'Invoice Terms Checkbox',
      'show_accept_invoice_terms_help':
          'Require client to confirm that they accept the invoice terms.',
      'show_accept_quote_terms': 'Quote Terms Checkbox',
      'show_accept_quote_terms_help':
          'Require client to confirm that they accept the quote terms.',
      'require_invoice_signature': 'Invoice Signature',
      'require_invoice_signature_help':
          'Require client to provide their signature.',
      'require_quote_signature': 'Quote Signature',
      'enable_portal_password': 'Password Protect Invoices',
      'enable_portal_password_help':
          'If enabled the contact will be able to set a password when viewing their first invoice.',
      'authorization': 'Authorization',
      'subdomain': 'Subdomain',
      'domain': 'Domain',
      'portal_mode': 'Portal Mode',
      'email_signature': 'Email Signature',
      'enable_email_markup_help':
          'Make it easier for your clients to pay you by adding schema.org markup to your emails.',
      'plain': 'Plain',
      'light': 'Light',
      'dark': 'Dark',
      'email_design': 'Email Design',
      'attach_pdf': 'Attach PDF',
      'attach_documents': 'Attach Documents',
      'attach_ubl': 'Attach UBL',
      'email_style': 'Email Style',
      'enable_email_markup': 'Enable Markup',
      'reply_to_email': 'Reply-To Email',
      'reply_to_name': 'Reply-To Name',
      'bcc_email': 'BCC Email',
      'processed': 'Processed',
      'credit_card': 'Credit Card',
      'bank_transfer': 'Bank Transfer',
      'priority': 'Priority',
      'fee_amount': 'Fee Amount',
      'fee_percent': 'Fee Percent',
      'fee_cap': 'Fee Cap',
      'limits_and_fees': 'Limits/Fees',
      'enable_min': 'Enable Min',
      'enable_max': 'Enable Max',
      'min_limit': 'Min Limit',
      'max_limit': 'Max Limit',
      'min': 'Min',
      'max': 'Max',
      'accepted_card_logos': 'Accepted Card Logos',
      'credentials': 'Credentials',
      'update_address': 'Update Address',
      'update_address_help': 'Update client\'s address with provided details',
      'rate': 'Rate',
      'tax_rate': 'Tax Rate',
      'new_tax_rate': 'New Tax Rate',
      'edit_tax_rate': 'Edit Tax Rate',
      'created_tax_rate': 'Successfully created tax rate',
      'updated_tax_rate': 'Successfully updated tax rate',
      'archived_tax_rate': 'Successfully archived tax rate',
      'deleted_tax_rate': 'Successfully deleted tax rate',
      'restored_tax_rate': 'Successfully restored tax rate',
      'archived_tax_rates': 'Successfully archived :value tax rates',
      'deleted_tax_rates': 'Successfully deleted :value tax rates',
      'restored_tax_rates': 'Successfully restored :value tax rates',
      'fill_products': 'Fill Products',
      'fill_products_help':
          'Selecting a product will automatically fill in the description and cost',
      'update_products': 'Update Products',
      'update_products_help':
          'Updating an invoice will automatically update the product library',
      'convert_products': 'Convert Products',
      'convert_products_help':
          'Automatically convert product prices using current exchange rate',
      'fees': 'Fees',
      'limits': 'Limits',
      'provider': 'Provider',
      'company_gateway': 'Gateway',
      'company_gateways': 'Payment Gateways',
      'new_company_gateway': 'New Gateway',
      'edit_company_gateway': 'Edit Gateway',
      'created_company_gateway': 'Successfully created gateway',
      'updated_company_gateway': 'Successfully updated gateway',
      'archived_company_gateway': 'Successfully archived gateway',
      'deleted_company_gateway': 'Successfully deleted gateway',
      'restored_company_gateway': 'Successfully restored gateway',
      'archived_company_gateways': 'Successfully archived :value gateways',
      'deleted_company_gateways': 'Successfully deleted :value gateways',
      'restored_company_gateways': 'Successfully restored :value gateways',
      'continue_editing': 'Continue Editing',
      'discard_changes': 'Discard Changes',
      'default_value': 'Default value',
      'disabled': 'Disabled',
      'currency_format': 'Currency Format',
      'first_day_of_the_week': 'First Day of the Week',
      'first_month_of_the_year': 'First Month of the Year',
      'sunday': 'Sunday',
      'monday': 'Monday',
      'tuesday': 'Tuesday',
      'wednesday': 'Wednesday',
      'thursday': 'Thursday',
      'friday': 'Friday',
      'saturday': 'Saturday',
      'january': 'January',
      'february': 'February',
      'march': 'March',
      'april': 'April',
      'may': 'May',
      'june': 'June',
      'july': 'July',
      'august': 'August',
      'september': 'September',
      'october': 'October',
      'november': 'November',
      'december': 'December',
      'symbol': 'Symbol',
      'ocde': 'Code',
      'date_format': 'Date Format',
      'datetime_format': 'Datetime Format',
      'military_time': 'Military Time',
      'military_time_help': '24 Hour Display',
      'send_reminders': 'Send Reminders',
      'timezone': 'Timezone',
      'filtered_by_project': 'Filtered by Project',
      'filtered_by_group': 'Filtered by Group',
      'filtered_by_invoice': 'Filtered by Invoice',
      'filtered_by_client': 'Filtered by Client',
      'filtered_by_vendor': 'Filtered by Vendor',
      'group_settings': 'Group Settings',
      'group': 'Group',
      'groups': 'Groups',
      'new_group': 'New Group',
      'edit_group': 'Edit Group',
      'created_group': 'Successfully created group',
      'updated_group': 'Successfully updated group',
      'archived_groups': 'Successfully archived :value groups',
      'deleted_groups': 'Successfully deleted :value groups',
      'restored_groups': 'Successfully restored :value groups',
      'archived_group': 'Successfully archived group',
      'deleted_group': 'Successfully deleted group',
      'restored_group': 'Successfully restored group',
      'upload_logo': 'Upload Logo',
      'uploaded_logo': 'Successfully uploaded logo',
      'logo': 'Logo',
      'saved_settings': 'Successfully saved settings',
      'product_settings': 'Product Settings',
      'device_settings': 'Device Settings',
      'defaults': 'Defaults',
      'basic_settings': 'Basic Settings',
      'advanced_settings': 'Advanced Settings',
      'company_details': 'Company Details',
      'user_details': 'User Details',
      'localization': 'Localization',
      'online_payments': 'Online Payments',
      'tax_rates': 'Tax Rates',
      'notifications': 'Notifications',
      'import_export': 'Import | Export',
      'custom_fields': 'Custom Fields',
      'invoice_design': 'Invoice Design',
      'buy_now_buttons': 'Buy Now Buttons',
      'email_settings': 'Email Settings',
      'templates_and_reminders': 'Templates & Reminders',
      'credit_cards_and_banks': 'Credit Cards & Banks',
      'data_visualizations': 'Data Visualizations',
      'price': 'Price',
      'email_sign_up': 'Sign up with email',
      'google_sign_up': 'Sign up with Google',
      'thank_you_for_your_purchase': 'Thank you for your purchase!',
      'redeem': 'Redeem',
      'back': 'Back',
      'past_purchases': 'Past Purchases',
      'annual_subscription': 'Annual Subscription',
      'pro_plan': 'Pro Plan',
      'enterprise_plan': 'Enterprise Plan',
      'count_users': ':count users',
      'upgrade': 'Upgrade',
      'please_enter_a_first_name': 'Please enter a first name',
      'please_enter_a_last_name': 'Please enter a last name',
      'please_agree_to_terms_and_privacy':
          'Please agree to the terms of service and privacy policy to create an account.',
      'i_agree_to_the': 'I agree to the',
      'terms_of_service': 'Terms of Service',
      'privacy_policy': 'Privacy Policy',
      'sign_up': 'Sign Up',
      'account_login': 'Account Login',
      'view_website': 'View Website',
      'create_account': 'Create Account',
      'email_login': 'Email Login',
      'create_new': 'Create New',
      'no_record_selected': 'No record selected',
      'error_unsaved_changes': 'Please save or cancel your changes',
      'download': 'Download',
      'requires_an_enterprise_plan': 'Requires an Enterprise plan',
      'take_picture': 'Take Picture',
      'upload_files': 'Upload Files',
      'document': 'Document',
      'documents': 'Documents',
      'new_document': 'New Document',
      'edit_document': 'Edit Document',
      'uploaded_document': 'Successfully uploaded document',
      'updated_document': 'Successfully updated document',
      'archived_document': 'Successfully archived document',
      'deleted_document': 'Successfully deleted document',
      'restored_document': 'Successfully restored document',
      'archived_documents': 'Successfully archived :value documents',
      'deleted_documents': 'Successfully deleted :value documents',
      'restored_documents': 'Successfully restored :value documents',
      'no_history': 'No History',
      'expense_date': 'Expense Date',
      'pending': 'Pending',
      'expense_status_1': 'Logged',
      'expense_status_2': 'Pending',
      'expense_status_3': 'Invoiced',
      'converted': 'Converted',
      'add_documents_to_invoice': 'Add Documents to Invoice',
      'exchange_rate': 'Exchange Rate',
      'convert_currency': 'Convert Currency',
      'mark_paid': 'Mark Paid',
      'category': 'Category',
      'address': 'Address',
      'new_vendor': 'New Vendor',
      'created_vendor': 'Successfully created vendor',
      'updated_vendor': 'Successfully updated vendor',
      'archived_vendor': 'Successfully archived vendor',
      'deleted_vendor': 'Successfully deleted vendor',
      'restored_vendor': 'Successfully restored vendor',
      'archived_vendors': 'Successfully archived :value vendors',
      'deleted_vendors': 'Successfully deleted :value vendors',
      'restored_vendors': 'Successfully restored :value vendors',
      'new_expense': 'New Expense',
      'created_expense': 'Successfully created expense',
      'updated_expense': 'Successfully updated expense',
      'archived_expense': 'Successfully archived expense',
      'deleted_expense': 'Successfully deleted expense',
      'restored_expense': 'Successfully restored expense',
      'archived_expenses': 'Successfully archived :value expenses',
      'deleted_expenses': 'Successfully deleted :value expenses',
      'restored_expenses': 'Successfully restored :value expenses',
      'copy_shipping': 'Copy Shipping',
      'copy_billing': 'Copy Billing',
      'design': 'Design',
      'failed_to_find_record': 'Failed to find record',
      'invoiced': 'Invoiced',
      'logged': 'Logged',
      'running': 'Running',
      'resume': 'Resume',
      'task_errors': 'Please correct any overlapping times',
      'start': 'Start',
      'stop': 'Stop',
      'started_task': 'Successfully started task',
      'stopped_task': 'Successfully stopped task',
      'resumed_task': 'Successfully resumed task',
      'now': 'Now',
      'auto_start_tasks': 'Auto Start Tasks',
      'timer': 'Timer',
      'manual': 'Manual',
      'budgeted': 'Budgeted',
      'start_time': 'Start Time',
      'end_time': 'End Time',
      'date': 'Date',
      'times': 'Times',
      'duration': 'Duration',
      'new_task': 'New Task',
      'created_task': 'Successfully created task',
      'updated_task': 'Successfully updated task',
      'archived_task': 'Successfully archived task',
      'deleted_task': 'Successfully deleted task',
      'restored_task': 'Successfully restored task',
      'archived_tasks': 'Successfully archived :value tasks',
      'deleted_tasks': 'Successfully deleted :value tasks',
      'restored_tasks': 'Successfully restored :value tasks',
      'please_enter_a_name': 'Please enter a name',
      'budgeted_hours': 'Budgeted Hours',
      'created_project': 'Successfully created project',
      'updated_project': 'Successfully updated project',
      'archived_project': 'Successfully archived project',
      'deleted_project': 'Successfully deleted project',
      'restored_project': 'Successfully restored project',
      'archived_projects': 'Successfully archived :value projects',
      'deleted_projects': 'Successfully deleted :value projects',
      'restored_projects': 'Successfully restored :value projects',
      'new_project': 'New Project',
      'thank_you_for_using_our_app': 'Thank you for using our app!',
      'if_you_like_it': 'If you like it please',
      'click_here': 'click here',
      'click_here_capital': 'Click here',
      'to_rate_it': 'to rate it.',
      'average': 'Average',
      'unapproved': 'Unapproved',
      'authenticate_to_change_setting':
          'Please authenticate to change this setting',
      'locked': 'Locked',
      'authenticate': 'Authenticate',
      'please_authenticate': 'Please authenticate',
      'biometric_authentication': 'Biometric Authentication',
      'footer': 'Footer',
      'compare': 'Compare',
      'hosted_login': 'Hosted Login',
      'selfhost_login': 'Selfhost Login',
      'google_sign_in': 'Login with Google',
      'today': 'Today',
      'custom_range': 'Custom',
      'date_range': 'Date Range',
      'current': 'Current',
      'previous': 'Previous',
      'current_period': 'Current Period',
      'comparison_period': 'Comparison Period',
      'previous_period': 'Previous Period',
      'previous_year': 'Previous Year',
      'compare_to': 'Compare to',
      'last7_days': 'Last 7 Days',
      'last_week': 'Last Week',
      'last30_days': 'Last 30 Days',
      'this_month': 'This Month',
      'last_month': 'Last Month',
      'this_year': 'This Year',
      'last_year': 'Last Year',
      'all_time': 'All Time',
      'custom': 'Custom',
      'clone_to_invoice': 'Clone to Invoice',
      'clone_to_quote': 'Clone to Quote',
      'clone_to_credit': 'Clone to Credit',
      'view_invoice': 'View Invoice',
      'convert': 'Convert',
      'more': 'More',
      'edit_client': 'Edit Client',
      'edit_product': 'Edit Product',
      'edit_invoice': 'Edit Invoice',
      'edit_quote': 'Edit Quote',
      'edit_payment': 'Edit Payment',
      'edit_task': 'Edit Task',
      'edit_expense': 'Edit Expense',
      'edit_vendor': 'Edit Vendor',
      'edit_project': 'Edit Project',
      'edit_recurring_quote': 'Edit Recurring Quote',
      'billing_address': 'Billing Address',
      'shipping_address': 'Shipping Address',
      'total_revenue': 'Total Revenue',
      'average_invoice': 'Average Invoice',
      'outstanding': 'Outstanding',
      'invoices_sent': 'Invoices Sent',
      'active_clients': 'Active Clients',
      'close': 'Close',
      'email': 'Email',
      'password': 'Password',
      'url': 'URL',
      'secret': 'Secret',
      'name': 'Name',
      'logout': 'Log Out',
      'login': 'Login',
      'filter': 'Filter',
      'sort': 'Sort',
      'search': 'Search',
      'active': 'Active',
      'archived': 'Archived',
      'deleted': 'Deleted',
      'dashboard': 'Dashboard',
      'archive': 'Archive',
      'delete': 'Delete',
      'restore': 'Restore',
      'refresh_complete': 'Refresh Complete',
      'please_enter_your_email': 'Please enter your email',
      'please_enter_your_password': 'Please enter your password',
      'please_enter_your_url': 'Please enter your URL',
      'please_enter_a_product_key': 'Please enter a product key',
      'ascending': 'Ascending',
      'descending': 'Descending',
      'save': 'Save',
      'an_error_occurred': 'An error occurred',
      'paid_to_date': 'Paid to Date',
      'balance_due': 'Balance Due',
      'balance': 'Balance',
      'overview': 'Overview',
      'details': 'Details',
      'phone': 'Phone',
      'website': 'Website',
      'vat_number': 'VAT Number',
      'id_number': 'ID Number',
      'create': 'Create',
      'copied_to_clipboard': 'Copied :value to the clipboard',
      'error': 'Error',
      'could_not_launch': 'Could not launch',
      'contacts': 'Contacts',
      'additional': 'Additional',
      'first_name': 'First Name',
      'last_name': 'Last Name',
      'add_contact': 'Add Contact',
      'are_you_sure': 'Are you sure?',
      'cancel': 'Cancel',
      'ok': 'Ok',
      'remove': 'Remove',
      'email_is_invalid': 'Email is invalid',
      'product': 'Product',
      'products': 'Products',
      'new_product': 'New Product',
      'created_product': 'Successfully created product',
      'updated_product': 'Successfully updated product',
      'archived_product': 'Successfully archived product',
      'deleted_product': 'Successfully deleted product',
      'restored_product': 'Successfully restored product',
      'archived_products': 'Successfully archived :value products',
      'deleted_products': 'Successfully deleted :value products',
      'restored_products': 'Successfully restored :value products',
      'product_key': 'Product',
      'notes': 'Notes',
      'cost': 'Cost',
      'client': 'Client',
      'clients': 'Clients',
      'new_client': 'New Client',
      'created_client': 'Successfully created client',
      'updated_client': 'Successfully updated client',
      'archived_client': 'Successfully archived client',
      'archived_clients': 'Successfully archived :value clients',
      'deleted_client': 'Successfully deleted client',
      'deleted_clients': 'Successfully deleted :value clients',
      'restored_client': 'Successfully restored client',
      'restored_clients': 'Successfully restored :value clients',
      'address1': 'Street',
      'address2': 'Apt/Suite',
      'city': 'City',
      'state': 'State/Province',
      'postal_code': 'Postal Code',
      'country': 'Country',
      'invoice': 'Invoice',
      'invoices': 'Invoices',
      'new_invoice': 'New Invoice',
      'created_invoice': 'Successfully created invoice',
      'updated_invoice': 'Successfully updated invoice',
      'archived_invoice': 'Successfully archived invoice',
      'deleted_invoice': 'Successfully deleted invoice',
      'restored_invoice': 'Successfully restored invoice',
      'archived_invoices': 'Successfully archived :value invoices',
      'deleted_invoices': 'Successfully deleted :value invoices',
      'restored_invoices': 'Successfully restored :value invoices',
      'emailed_invoice': 'Successfully queued invoice to be sent',
      'emailed_payment': 'Successfully queued payment to be sent',
      'amount': 'Amount',
      'invoice_number': 'Invoice Number',
      'invoice_date': 'Invoice Date',
      'discount': 'Discount',
      'po_number': 'PO Number',
      'terms': 'Terms',
      'public_notes': 'Public Notes',
      'private_notes': 'Private Notes',
      'frequency': 'Frequency',
      'start_date': 'Start Date',
      'end_date': 'End Date',
      'quote_number': 'Quote Number',
      'quote_date': 'Quote Date',
      'valid_until': 'Valid Until',
      'items': 'Items',
      'partial_deposit': 'Partial/Deposit',
      'description': 'Description',
      'unit_cost': 'Unit Cost',
      'quantity': 'Quantity',
      'add_item': 'Add Item',
      'contact': 'Contact',
      'work_phone': 'Phone',
      'total_amount': 'Total Amount',
      'pdf': 'PDF',
      'due_date': 'Due Date',
      'partial_due_date': 'Partial Due Date',
      'paid_date': 'Paid Date',
      'status': 'Status',
      'invoice_status_id': 'Invoice Status',
      'quote_status': 'Quote Status',
      'click_plus_to_add_item': 'Click + to add an item',
      'click_plus_to_add_time': 'Click ▶ to add time',
      'count_selected': ':count selected',
      'total': 'Total',
      'percent': 'Percent',
      'edit': 'Edit',
      'dismiss': 'Dismiss',
      'please_select_a_date': 'Please select a date',
      'please_select_a_client': 'Please select a client',
      'please_select_an_invoice': 'Please select an invoice',
      'task_rate': 'Task Rate',
      'settings': 'Settings',
      'language': 'Language',
      'currency': 'Currency',
      'created_at': 'Created At',
      'created_on': 'Created On',
      'updated_at': 'Updated At',
      'tax': 'Tax',
      'please_enter_an_invoice_number': 'Please enter an invoice number',
      'please_enter_a_quote_number': 'Please enter a quote number',
      'past_due': 'Past Due',
      'draft': 'Draft',
      'sent': 'Sent',
      'viewed': 'Viewed',
      'approved': 'Approved',
      'partial': 'Partial',
      'paid': 'Paid',
      'mark_sent': 'Mark Sent',
      'marked_invoice_as_sent': 'Successfully marked invoice as sent',
      'marked_invoice_as_paid': 'Successfully marked invoice as paid',
      'marked_invoices_as_sent': 'Successfully marked invoices as sent',
      'marked_invoices_as_paid': 'Successfully marked invoices as paid',
      'done': 'Done',
      'please_enter_a_client_or_contact_name':
          'Please enter a client or contact name',
      'dark_mode': 'Dark Mode',
      'restart_app_to_apply_change': 'Restart the app to apply the change',
      'refresh_data': 'Refresh Data',
      'blank_contact': 'Blank Contact',
      'activity': 'Activity',
      'no_records_found': 'No records found',
      'clone': 'Clone',
      'loading': 'Loading',
      'industry': 'Industry',
      'size': 'Size',
      'payment_terms': 'Payment Terms',
      'payment_date': 'Payment Date',
      'payment_status': 'Payment Status',
      'payment_status_1': 'Pending',
      'payment_status_2': 'Cancelled',
      'payment_status_3': 'Failed',
      'payment_status_4': 'Completed',
      'payment_status_5': 'Partially Refunded',
      'payment_status_6': 'Refunded',
      'payment_status_-1': 'Unapplied',
      'payment_status_-2': 'Partially Unapplied',
      'net': 'Net',
      'client_portal': 'Client Portal',
      'show_tasks': 'Show tasks',
      'email_reminders': 'Email Reminders',
      'enabled': 'Enabled',
      'recipients': 'Recipients',
      'initial_email': 'Initial Email',
      'first_reminder': 'First Reminder',
      'second_reminder': 'Second Reminder',
      'third_reminder': 'Third Reminder',
      'reminder1': 'Reminder 1',
      'reminder2': 'Reminder 2',
      'reminder3': 'Reminder 3',
      'template': 'Template',
      'send': 'Send',
      'subject': 'Subject',
      'body': 'Body',
      'send_email': 'Send Email',
      'email_receipt': 'Email payment receipt to the client',
      'auto_billing': 'Auto billing',
      'button': 'Button',
      'preview': 'Preview',
      'customize': 'Customize',
      'history': 'History',
      'payment': 'Payment',
      'payments': 'Payments',
      'refunded': 'Refunded',
      'payment_type': 'Payment Type',
      'transaction_reference': 'Transaction Reference',
      'enter_payment': 'Enter Payment',
      'new_payment': 'Enter Payment',
      'created_payment': 'Successfully created payment',
      'updated_payment': 'Successfully updated payment',
      'archived_payment': 'Successfully archived payment',
      'deleted_payment': 'Successfully deleted payment',
      'restored_payment': 'Successfully restored payment',
      'archived_payments': 'Successfully archived :value payments',
      'deleted_payments': 'Successfully deleted :value payments',
      'restored_payments': 'Successfully restored :value payments',
      'quote': 'Quote',
      'quotes': 'Quotes',
      'new_quote': 'New Quote',
      'created_quote': 'Successfully created quote',
      'updated_quote': 'Successfully updated quote',
      'archived_quote': 'Successfully archived quote',
      'deleted_quote': 'Successfully deleted quote',
      'restored_quote': 'Successfully restored quote',
      'archived_quotes': 'Successfully archived :value quotes',
      'deleted_quotes': 'Successfully deleted :value quotes',
      'restored_quotes': 'Successfully restored :value quotes',
      'expense': 'Expense',
      'expenses': 'Expenses',
      'vendor': 'Vendor',
      'vendors': 'Vendors',
      'task': 'Task',
      'tasks': 'Tasks',
      'project': 'Project',
      'projects': 'Projects',
      'activity_1': ':user created client :client',
      'activity_2': ':user archived client :client',
      'activity_3': ':user deleted client :client',
      'activity_4': ':user created invoice :invoice',
      'activity_5': ':user updated invoice :invoice',
      'activity_6': ':user emailed invoice :invoice to :contact',
      'activity_7': ':contact viewed invoice :invoice',
      'activity_8': ':user archived invoice :invoice',
      'activity_9': ':user deleted invoice :invoice',
      'activity_10': ':contact entered payment :payment for invoice :invoice',
      'activity_11': ':user updated payment :payment',
      'activity_12': ':user archived payment :payment',
      'activity_13': ':user deleted payment :payment',
      'activity_14': ':user entered :credit credit',
      'activity_15': ':user updated :credit credit',
      'activity_16': ':user archived :credit credit',
      'activity_17': ':user deleted :credit credit',
      'activity_18': ':user created quote :quote',
      'activity_19': ':user updated quote :quote',
      'activity_20': ':user emailed quote :quote to :contact',
      'activity_21': ':contact viewed quote :quote',
      'activity_22': ':user archived quote :quote',
      'activity_23': ':user deleted quote :quote',
      'activity_24': ':user restored quote :quote',
      'activity_25': ':user restored invoice :invoice',
      'activity_26': ':user restored client :client',
      'activity_27': ':user restored payment :payment',
      'activity_28': ':user restored :credit credit',
      'activity_29': ':contact approved quote :quote',
      'activity_30': ':user created vendor :vendor',
      'activity_31': ':user archived vendor :vendor',
      'activity_32': ':user deleted vendor :vendor',
      'activity_33': ':user restored vendor :vendor',
      'activity_34': ':user created expense :expense',
      'activity_35': ':user archived expense :expense',
      'activity_36': ':user deleted expense :expense',
      'activity_37': ':user restored expense :expense',
      'activity_39': ':user cancelled payment :payment',
      'activity_40': ':user refunded payment :payment',
      'activity_41': 'Payment :payment failed',
      'activity_42': ':user created task :task',
      'activity_43': ':user updated task :task',
      'activity_44': ':user archived task :task',
      'activity_45': ':user deleted task :task',
      'activity_46': ':user restored task :task',
      'activity_47': ':user updated expense :expense',
      'activity_48': ':user created user',
      'activity_49': ':user updated user',
      'activity_50': ':user archived user',
      'activity_51': ':user deleted user',
      'activity_52': ':user restored user',
      'activity_53': ':user marked invoice :invoice as sent',
      'activity_54': ':user applied payment :payment to invoice :invoice',
      'activity_55': '',
      'activity_56': '',
      'activity_57': 'System failed to email invoice :invoice',
      'activity_58': ':user reversed invoice :invoice',
      'activity_59': ':user cancelled invoice :invoice',
      'activity_60': ':contact viewed quote :quote',
      'activity_61': ':user updated client :client',
      'activity_62': ':user updated vendor :vendor',
      'activity_63':
          ':user emailed first reminder for invoice :invoice to :contact',
      'activity_64':
          ':user emailed second reminder for invoice :invoice to :contact',
      'activity_65':
          ':user emailed third reminder for invoice :invoice to :contact',
      'activity_66':
          ':user emailed endless reminder for invoice :invoice to :contact',
      'activity_80': ':user created subscription',
      'activity_81': ':user updated subscription',
      'activity_82': ':user archived subscription',
      'activity_83': ':user deleted subscription',
      'activity_84': ':user restored subscription',
      'one_time_password': 'One Time Password',
      'emailed_quote': 'Successfully queued quote to be sent',
      'emailed_credit': 'Successfully queued credit to be sent',
      'marked_quote_as_sent': 'Successfully marked quote as sent',
      'marked_credit_as_sent': 'Successfully marked credit as sent',
      'expired': 'Expired',
      'all': 'All',
      'select': 'Select',
      'long_press_multiselect': 'Long-press Multiselect',
      'custom_value1': 'Custom Value 1',
      'custom_value2': 'Custom Value 2',
      'custom_value3': 'Custom Value 3',
      'custom_value4': 'Custom Value 4',
      'email_style_custom': 'Custom Email Style',
      'custom_message_dashboard': 'Custom Dashboard Message',
      'custom_message_unpaid_invoice': 'Custom Unpaid Invoice Message',
      'custom_message_paid_invoice': 'Custom Paid Invoice Message',
      'custom_message_unapproved_quote': 'Custom Unapproved Quote Message',
      'lock_invoices': 'Lock Invoices',
      'translations': 'Translations',
      'task_number_pattern': 'Task Number Pattern',
      'task_number_counter': 'Task Number Counter',
      'expense_number_pattern': 'Expense Number Pattern',
      'expense_number_counter': 'Expense Number Counter',
      'vendor_number_pattern': 'Vendor Number Pattern',
      'vendor_number_counter': 'Vendor Number Counter',
      'ticket_number_pattern': 'Ticket Number Pattern',
      'ticket_number_counter': 'Ticket Number Counter',
      'payment_number_pattern': 'Payment Number Pattern',
      'payment_number_counter': 'Payment Number Counter',
      'invoice_number_pattern': 'Invoice Number Pattern',
      'invoice_number_counter': 'Invoice Number Counter',
      'quote_number_pattern': 'Quote Number Pattern',
      'quote_number_counter': 'Quote Number Counter',
      'client_number_pattern': 'Credit Number Pattern',
      'client_number_counter': 'Credit Number Counter',
      'credit_number_pattern': 'Credit Number Pattern',
      'credit_number_counter': 'Credit Number Counter',
      'reset_counter_date': 'Reset Counter Date',
      'counter_padding': 'Counter Padding',
      'shared_invoice_quote_counter': 'Shared Invoice/Quote Counter',
      'default_tax_name_1': 'Default Tax Name 1',
      'default_tax_rate_1': 'Default Tax Rate 1',
      'default_tax_name_2': 'Default Tax Name 2',
      'default_tax_rate_2': 'Default Tax Rate 2',
      'default_tax_name_3': 'Default Tax Name 3',
      'default_tax_rate_3': 'Default Tax Rate 3',
      'email_subject_invoice': 'Email Invoice Subject',
      'email_subject_quote': 'Email Quote Subject',
      'email_subject_payment': 'Email Payment Subject',
      'email_subject_payment_partial': 'Email Partial Payment Subject',
      'show_table': 'Show Table',
      'show_list': 'Show List',
      'client_city': 'Client City',
      'client_state': 'Client State',
      'client_country': 'Client Country',
      'client_is_active': 'Client is Active',
      'client_balance': 'Client Balance',
      'client_address1': 'Client Street',
      'client_address2': 'Client Apt/Suite',
      'vendor_address1': 'Vendor Street',
      'vendor_address2': 'Vendor Apt/Suite',
      'client_shipping_address1': 'Client Shipping Street',
      'client_shipping_address2': 'Client Shipping Apt/Suite',
      'type': 'Type',
      'invoice_amount': 'Invoice Amount',
      'invoice_due_date': 'Invoice Due Date',
      'tax_rate1': 'Tax Rate 1',
      'tax_rate2': 'Tax Rate 2',
      'tax_rate3': 'Tax Rate 3',
      'auto_bill': 'Auto Bill',
      'archived_at': 'Archived At',
      'has_expenses': 'Has Expenses',
      'custom_taxes1': 'Custom Taxes 1',
      'custom_taxes2': 'Custom Taxes 2',
      'custom_taxes3': 'Custom Taxes 3',
      'custom_taxes4': 'Custom Taxes 4',
      'custom_surcharge1': 'Custom Surcharge 1',
      'custom_surcharge2': 'Custom Surcharge 2',
      'custom_surcharge3': 'Custom Surcharge 3',
      'custom_surcharge4': 'Custom Surcharge 4',
      'is_deleted': 'Is Deleted',
      'vendor_city': 'Vendor City',
      'vendor_state': 'Vendor State',
      'vendor_country': 'Vendor Country',
      'is_approved': 'Is Approved',
      'tax_name': 'Tax Name',
      'tax_amount': 'Tax Amount',
      'tax_paid': 'Tax Paid Amount',
      'payment_amount': 'Payment Amount',
      'age': 'Age',
      'is_running': 'Is Running',
      'time_log': 'Time Log',
      'bank_id': 'Bank Id',
      'expense_category_id': 'Expense Category ID',
      'expense_category': 'Category',
      'invoice_currency_id': 'Invoice Currency ID',
      'tax_name1': 'Tax Name 1',
      'tax_name2': 'Tax Name 2',
      'tax_name3': 'Tax Name 3',
      'transaction_id': 'Transaction ID',
      'status_color_theme': 'Status Color Theme',
      'load_color_theme': 'Load Color Theme',
    },
    'sq': {
      'location': 'Location',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Location Deleted',
      'added_location': 'Successfully added location',
      'updated_location': 'Updated Location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': 'Locations',
      'preference_product_notes_for_html_view': 'Use Item Notes for HTML View',
      'preference_product_notes_for_html_view_help':
          'Preference the item Description over the item title if displaying the invoice in HTML.',
      'in_stock_quantity': 'Stock quantity',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update': 'Allow clients to update their profile',
      'enable_client_profile_update_help':
          'Allow clients to update their profile information from the client portal',
      'participant': 'Participant',
      'merged_vendors': 'Successfully merged vendors',
      'activity_146':
          'E-Invoice :invoice for :client successfully delivered! :notes',
      'activity_147': 'E-Invoice :invoice for :client failed delivery. :notes',
      'activity_148': 'E-Expense :expense received from :vendor',
      'payment_failed': 'Payment Failed',
      'activity_141': 'User :user entered note: :notes',
      'activity_142': 'Quote :quote reminder 1 sent',
      'activity_143': 'Auto Bill succeeded for invoice :invoice',
      'activity_144': 'Auto Bill failed for invoice :invoice. :notes',
      'activity_145': 'E-Invoice :invoice for :client was sent. :notes',
      'ssl_host_override': 'SSL Host Override',
      'upload_logo_short': 'Upload Logo',
      'show_pdfhtml_on_mobile_help':
          'For improved visualization, displays a HTML version of the invoice/quote when viewing on mobile.',
      'accept_purchase_order': 'Accept Purchase Order',
      'one_page_checkout': 'One-Page Checkout',
      'one_page_checkout_help': 'Enable the new single page payment flow',
      'applies_to': 'Applies To',
      'purchase_order_items': 'Purchase Order Items',
      'assigned_group': 'Successfully assigned group',
      'assign_group': 'Assign group',
      'merge_to_pdf': 'Merge to PDF',
      'emails': 'Emails',
      'latest_requires_php_version':
          'Note: the latest version requires PHP :version',
      'quote_reminder1': 'First Quote Reminder',
      'before_valid_until': 'Before the valid until',
      'after_valid_until': 'After the valid until',
      'after_quote_date': 'After the quote date',
      'remind_quote': 'Remind Quote',
      'task_assigned_notification': 'Task Assigned Notification',
      'task_assigned_notification_help':
          'Send an email when a task is assigned',
      'invoices_locked_end_of_month':
          'Invoices are locked at the end of the month',
      'end_of_month': 'End Of Month',
      'referral_url': 'Referral URL',
      'referral_program': 'Programi i referimit',
      'comment': 'Comments',
      'add_comment': 'Add Comment',
      'added_comment': 'Successfully saved comment',
      'disconnected': 'Disconnected',
      'reconnect': 'Reconnect',
      'e_invoice_settings': 'E-Invoice Settings',
      'calculate': 'Calculate',
      'sum': 'Sum',
      'money': 'Money',
      'time': 'Koha',
      'format': 'Format',
      'web_app': 'Web App',
      'desktop_app': 'Desktop App',
      'invoice_net_amount': 'Invoice Net Amount',
      'round_to_seconds': 'Round To Seconds',
      '1_minute': '1 Minute',
      '5_minutes': '5 Minutes',
      '15_minutes': '15 Minutes',
      '30_minutes': '30 Minutes',
      '1_hour': '1 Hour',
      '1_day': '1 Day',
      'round_tasks': 'Task Rounding Direction',
      'round_tasks_help': 'Round task times up or down.',
      'direction': 'Direction',
      'round_up': 'Round Up',
      'round_down': 'Round Down',
      'task_round_to_nearest': 'Round To Nearest',
      'activity_139': 'Expense :expense notification sent to :contact',
      'activity_140': 'Statement sent to :client',
      'bulk_updated': 'Successfully updated data',
      'bulk_update': 'Bulk Update',
      'advanced_cards': 'Advanced Cards',
      'always_show_required_fields': 'Always show required fields form',
      'always_show_required_fields_help':
          'Displays the required fields form always at checkout',
      'flutter_web_warning':
          'We recommend using the new web app or the desktop app for the best performance',
      'rappen_rounding': 'Rappen Rounding',
      'rappen_rounding_help': 'Round amount to 5 cents',
      'check_credentials': 'Check Credentials',
      'valid_credentials': 'Credentials are valid',
      'invalid_credentials': 'Këto kredenciale nuk përputhen me të dhënat tona',
      'e_quote': 'E-Quote',
      'e_credit': 'E-Credit',
      'e_purchase_order': 'E-Purchase Order',
      'valid_vat_number': 'Valid VAT Number',
      'use_available_payments': 'Use Available Payments',
      'test_email_sent': 'Successfully sent email',
      'send_test_email': 'Send Test Email',
      'gateway_type': 'Gateway Type',
      'please_select_an_invoice_or_credit':
          'Please select an invoice or credit',
      'mobile_version': 'Mobile Version',
      'venmo': 'Venmo',
      'mercado_pago': 'Mercado Pago',
      'my_bank': 'MyBank',
      'pay_later': 'Pay Later',
      'email_report': 'Email Report',
      'host': 'Host',
      'port': 'Port',
      'encryption': 'Encryption',
      'local_domain': 'Local Domain',
      'verify_peer': 'Verify Peer',
      'username': 'identifikimi',
      'nordigen_help':
          'Note: connecting an account requires a GoCardless/Nordigen API key',
      'participant_name': 'Participant name',
      'yodlee_regions': 'Regions: USA, UK, Australia & India',
      'nordigen_regions': 'Regions: Europe & UK',
      'select_provider': 'Select Provider',
      'payment_type_credit': 'Payment Type Credit',
      'payment_type_debit': 'Payment Type Debit',
      'send_emails_to': 'Send Emails To',
      'primary_contact': 'Primary Contact',
      'all_contacts': 'All Contacts',
      'insert_below': 'Insert Below',
      'ar_detailed': 'Accounts Receivable Detailed',
      'ar_summary': 'Accounts Receivable Summary',
      'client_sales': 'Client Sales',
      'tax_summary': 'Tax Summary',
      'user_sales': 'User Sales',
      'run_template': 'Run Template',
      'task_extension_banner': 'Add the Chrome extension to manage your tasks',
      'watch_video': 'Watch Video',
      'view_extension': 'View Extension',
      'reactivate_email': 'Reactivate Email',
      'email_reactivated': 'Successfully reactivated email',
      'template_help': 'Enable using the design as a template',
      'delivery_note_design': 'Delivery Note Design',
      'statement_design': 'Statement Design',
      'payment_receipt_design': 'Payment Receipt Design',
      'payment_refund_design': 'Payment Refund Design',
      'quarter': 'Quarter',
      'item_description': 'Item Description',
      'task_item': 'Task Item',
      'record_state': 'Record State',
      'last_login': 'Hera e fundit që është lidhur',
      'save_files_to_this_folder': 'Save files to this folder',
      'downloads_folder': 'Downloads Folder',
      'total_invoiced_quotes': 'Invoiced Quotes',
      'total_invoice_paid_quotes': 'Invoice Paid Quotes',
      'downloads_folder_does_not_exist':
          'The downloads folder does not exist :value',
      'user_logged_in_notification': 'User Logged in Notification',
      'user_logged_in_notification_help':
          'Send an email when logging in from a new location',
      'client_contact': 'Client Contact',
      'expense_status_4': 'Unpaid',
      'expense_status_5': 'Paid',
      'recurring': 'Përsëristshme',
      'ziptax_help':
          'Note: this feature requires a Zip-Tax API key to lookup US sales tax by address',
      'cache_data': 'Cache Data',
      'unknown': 'Unknown',
      'webhook_failure': 'Webhook Failure',
      'email_opened': 'Email Opened',
      'email_delivered': 'Email Delivered',
      'log': 'Log',
      'individual': 'Individual',
      'partnership': 'Partnership',
      'trust': 'Trust',
      'charity': 'Charity',
      'government': 'Government',
      'classification': 'Classification',
      'click_or_drop_files_here': 'Click or drop files here',
      'public': 'Public',
      'private': 'Private',
      'image': 'Image',
      'other': 'Other',
      'hash': 'Hash',
      'linked_to': 'Linked To',
      'file_saved_in_path': 'The file has been saved in :path',
      'unlinked_transactions': 'Successfully unlinked :count transactions',
      'unlinked_transaction': 'Successfully unlinked transaction',
      'unlink': 'Zgjidh',
      'view_dashboard_permission':
          'Allow user to access the dashboard, data is limited to available permissions',
      'is_tax_exempt': 'Tax Exempt',
      'district': 'District',
      'region': 'Region',
      'county': 'County',
      'tax_details': 'Tax Details',
      'activity_10_online':
          ':contact made payment :payment for invoice :invoice for :client',
      'activity_10_manual':
          ':user entered payment :payment for invoice :invoice for :client',
      'default_payment_type': 'Default Payment Type',
      'admin_initiated_payments': 'Admin Initiated Payments',
      'admin_initiated_payments_help':
          'Support entering a payment in the admin portal without an invoice',
      'use_mobile_to_manage_plan':
          'Use your phone subscription settings to manage your plan',
      'show_task_billable': 'Show Task Billable',
      'credit_item': 'Credit Item',
      'files': 'Files',
      'camera': 'Camera',
      'gallery': 'Gallery',
      'email_count_invoices': 'Email :count invoices',
      'project_location': 'Project Location',
      'invoice_task_item_description': 'Invoice Task Item Description',
      'invoice_task_item_description_help':
          'Add the item description to the invoice line items',
      'next_send_time': 'Next Send Time',
      'uploaded_certificate': 'Successfully uploaded certificate',
      'certificate_set': 'Certificate set',
      'certificate_not_set': 'Certificate not set',
      'passphrase_set': 'Passphrase set',
      'passphrase_not_set': 'Passphrase not set',
      'upload_certificate': 'Upload Certificate',
      'certificate_passphrase': 'Certificate Passphrase',
      'rename': 'Rename',
      'renamed_document': 'Successfully renamed document',
      'e_invoice': 'E-Invoice',
      'light_dark_mode': 'Light/Dark Mode',
      'activities': 'Activities',
      'routing_id': 'Routing ID',
      'enable_e_invoice': 'Enable E-Invoice',
      'e_invoice_type': 'E-Invoice Type',
      'e_quote_type': 'E-Quote Type',
      'reduced_tax': 'Reduced Tax',
      'override_tax': 'Override Tax',
      'zero_rated': 'Zero Rated',
      'reverse_tax': 'Reverse Tax',
      'updated_tax_category': 'Successfully updated the tax category',
      'updated_tax_categories': 'Successfully updated the tax categories',
      'set_tax_category': 'Set Tax Category',
      'payment_manual': 'Payment Manual',
      'tax_category': 'Tax Category',
      'physical_goods': 'Physical Goods',
      'digital_products': 'Digital Products',
      'services': 'Services',
      'shipping': 'Shipping',
      'tax_exempt': 'Tax Exempt',
      'reduced_rate': 'Reduced Rate',
      'tax_all': 'Tax All',
      'tax_selected': 'Tax Selected',
      'version': 'version',
      'seller_subregion': 'Seller Subregion',
      'calculate_taxes': 'Calculate Taxes',
      'calculate_taxes_help':
          'Automatically calculate taxes when saving invoices',
      'admin': 'Admin',
      'owner': 'Pronari',
      'link_expenses': 'Link Expenses',
      'converted_client_balance': 'Converted Client Balance',
      'converted_payment_balance': 'Converted Payment Balance',
      'total_hours': 'Total Hours',
      'date_picker_hint': 'Use +days to set the date in the future',
      'browser_pdf_viewer': 'Use Browser PDF Viewer',
      'browser_pdf_viewer_help':
          'Warning: Prevents interacting with app over the PDF',
      'increase_prices': 'Increase Prices',
      'update_prices': 'Update Prices',
      'incresed_prices': 'Successfully queued prices to be increased',
      'updated_prices': 'Successfully queued prices to be updated',
      'bacs': 'BACS Direct Debit',
      'api_token': 'API Token',
      'api_key': 'API Key',
      'endpoint': 'Endpoint',
      'billable': 'Billable',
      'not_billable': 'Not Billable',
      'allow_billable_task_items': 'Allow Billable Task Items',
      'allow_billable_task_items_help':
          'Enable configuring which task items are billed',
      'show_task_item_description': 'Show Task Item Description',
      'show_task_item_description_help':
          'Enable specifying task item descriptions',
      'email_record': 'Email Record',
      'invoice_product_columns': 'Invoice Product Columns',
      'quote_product_columns': 'Quote Product Columns',
      'minimum_payment_amount': 'Minimum Payment Amount',
      'client_initiated_payments': 'Client Initiated Payments',
      'client_initiated_payments_help':
          'Support making a payment in the client portal without an invoice',
      'share_invoice_quote_columns': 'Share Invoice/Quote Columns',
      'cc_email': 'CC Email',
      'payment_balance': 'Payment Balance',
      'view_report_permission':
          'Allow user to access the reports, data is limited to available permissions',
      'activity_138': 'Payment :payment was emailed to :client',
      'one_time_products': 'One-Time Products',
      'optional_one_time_products': 'Optional One-Time Products',
      'required': 'Required',
      'hidden': 'Hidden',
      'payment_links': 'Payment Links',
      'action': 'Vepro',
      'upgrade_to_paid_plan_to_schedule':
          'Upgrade to a paid plan to create schedules',
      'next_run': 'Next Run',
      'all_clients': 'All Clients',
      'show_aging_table': 'Show Aging Table',
      'show_payments_table': 'Show Payments Table',
      'only_clients_with_invoices': 'Only Clients with Invoices',
      'email_statement': 'Email Statement',
      'once': 'Once',
      'schedule': 'Orari',
      'schedules': 'Schedules',
      'new_schedule': 'New Schedule',
      'edit_schedule': 'Edit Schedule',
      'created_schedule': 'Successfully created schedule',
      'updated_schedule': 'Successfully updated schedule',
      'archived_schedule': 'Successfully archived schedule',
      'deleted_schedule': 'Successfully deleted schedule',
      'removed_schedule': 'Successfully removed schedule',
      'restored_schedule': 'Successfully restored schedule',
      'search_schedule': 'Search Schedule',
      'search_schedules': 'Search Schedules',
      'archive_payment': 'Arkivo Pagesën',
      'archive_invoice': 'Arkivo faturën',
      'archive_quote': 'Arkivo Ofertën',
      'archive_credit': 'Arkivo Kreditin',
      'archive_task': 'Arkivo Detyrën',
      'archive_client': 'Arkivo Klientin',
      'archive_project': 'Archive Project',
      'archive_expense': 'Arkivo shpenzimin',
      'restore_payment': 'Rikthe Pagesën',
      'restore_invoice': 'Rikthe Faturën',
      'restore_quote': 'Rikthe Ofertën',
      'restore_credit': 'Rikthe Kreditin',
      'restore_task': 'Rikthe Detyrën',
      'restore_client': 'Rikthe Klientin',
      'restore_project': 'Restore Project',
      'restore_expense': 'Rikthe shpenzimet',
      'archive_vendor': 'Arkivo kompaninë',
      'restore_vendor': 'Rikthe kompaninë',
      'create_product': 'Shto produkt',
      'update_product': 'Update Product',
      'delete_product': 'Delete Product',
      'restore_product': 'Rikthe Produktin',
      'archive_product': 'Arkivo produktin',
      'create_purchase_order': 'Create Purchase Order',
      'update_purchase_order': 'Update Purchase Order',
      'delete_purchase_order': 'Delete Purchase Order',
      'restore_purchase_order': 'Restore Purchase Order',
      'archive_purchase_order': 'Archive Purchase Order',
      'sent_invoice': 'Sent Invoice',
      'sent_quote': 'Sent Quote',
      'sent_credit': 'Sent Credit',
      'sent_purchase_order': 'Sent Purchase Order',
      'image_url': 'Image URL',
      'max_quantity': 'Max Quantity',
      'test_url': 'Test URL',
      'auto_bill_help_off': 'Option is not shown',
      'auto_bill_help_optin': 'Option is shown but not selected',
      'auto_bill_help_optout': 'Option is shown and selected',
      'auto_bill_help_always': 'Option is not shown',
      'payment_methods': 'Metodat e pagesës',
      'view_all': 'View All',
      'edit_all': 'Edit All',
      'accept_purchase_order_number': 'Accept Purchase Order Number',
      'accept_purchase_order_number_help':
          'Enable clients to provide a PO number when approving a quote',
      'from_email': 'From Email',
      'show_preview': 'Show Preview',
      'show_paid_stamp': 'Show Paid Stamp',
      'show_shipping_address': 'Show Shipping Address',
      'no_documents_to_download':
          'There are no documents in the selected records to download',
      'pixels': 'Pixels',
      'logo_size': 'Logo Size',
      'postal_city': 'Postal/City',
      'failed': 'Failed',
      'client_contacts': 'Client Contacts',
      'sync_from': 'Sync From',
      'inventory_threshold': 'Inventory Threshold',
      'hour': 'Ore',
      'emailed_statement': 'Successfully queued statement to be sent',
      'show_email_footer': 'Show Email Footer',
      'invoice_task_hours': 'Invoice Task Hours',
      'invoice_task_hours_help': 'Add the hours to the invoice line items',
      'auto_bill_standard_invoices': 'Auto Bill Standard Invoices',
      'auto_bill_recurring_invoices': 'Auto Bill Recurring Invoices',
      'email_alignment': 'Email Alignment',
      'pdf_preview_location': 'PDF Preview Location',
      'mailgun': 'Mailgun',
      'postmark': 'Postmark',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Click + to create a record',
      'last365_days': 'Last 365 Days',
      'import_design': 'Import Design',
      'imported_design': 'Successfully imported design',
      'invalid_design': 'The design is invalid, the :value section is missing',
      'setup_wizard_logo': 'Would you like to upload your logo?',
      'upload': 'Ngarko',
      'installed_version': 'Installed Version',
      'notify_vendor_when_paid': 'Notify Vendor When Paid',
      'notify_vendor_when_paid_help':
          'Send an email to the vendor when the expense is marked as paid',
      'update_payment': 'Update Payment',
      'markup': 'Markup',
      'purchase_order_created': 'Purchase Order Created',
      'purchase_order_sent': 'Purchase Order Sent',
      'purchase_order_viewed': 'Purchase Order Viewed',
      'purchase_order_accepted': 'Purchase Order Accepted',
      'credit_payment_error':
          'The credit amount can not be greater than the payment amount',
      'klarna': 'Klarna',
      'convert_payment_currency_help':
          'Set an exchange rate when entering a manual payment',
      'convert_expense_currency_help':
          'Set an exchange rate when creating an expense',
      'matomo_url': 'Matomo URL',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Add To Invoice',
      'online_payment_email_help':
          'Send an email when an online payment is made',
      'manual_payment_email_help':
          'Send an email when manually entering a payment',
      'mark_paid_payment_email_help':
          'Send an email when marking an invoice as paid',
      'delete_project': 'Delete Project',
      'linked_transaction': 'Successfully linked transaction',
      'link_payment': 'Link Payment',
      'link_expense': 'Link Expense',
      'lock_invoiced_tasks': 'Lock Invoiced Tasks',
      'lock_invoiced_tasks_help':
          'Prevent tasks from being edited once invoiced',
      'registration_required': 'Registration Required',
      'registration_required_help': 'Require clients to register',
      'use_inventory_management': 'Use Inventory Management',
      'use_inventory_management_help': 'Require products to be in stock',
      'optional_products': 'Optional Products',
      'optional_recurring_products': 'Optional Recurring Products',
      'convert_matched': 'Convert',
      'auto_billed_invoice': 'Successfully queued invoice to be auto-billed',
      'auto_billed_invoices': 'Successfully queued invoices to be auto-billed',
      'operator': 'Operator',
      'value': 'Value',
      'is': 'Is',
      'contains': 'Contains',
      'starts_with': 'Starts with',
      'is_empty': 'Is empty',
      'add_rule': 'Add Rule',
      'match_all_rules': 'Match All Rules',
      'match_all_rules_help':
          'All criteria needs to match for the rule to be applied',
      'auto_convert_help':
          'Automatically convert matched transactions to expenses',
      'rules': 'Rules',
      'transaction_rule': 'Transaction Rule',
      'transaction_rules': 'Transaction Rules',
      'new_transaction_rule': 'New Transaction Rule',
      'edit_transaction_rule': 'Edit Transaction Rule',
      'created_transaction_rule': 'Successfully created rule',
      'updated_transaction_rule': 'Successfully updated transaction rule',
      'archived_transaction_rule': 'Successfully archived transaction rule',
      'deleted_transaction_rule': 'Successfully deleted transaction rule',
      'removed_transaction_rule': 'Successfully removed transaction rule',
      'restored_transaction_rule': 'Successfully restored transaction rule',
      'search_transaction_rule': 'Search Transaction Rule',
      'search_transaction_rules': 'Search Transaction Rules',
      'save_as_default_terms': 'Ruaj si njësi e paracaktuar',
      'save_as_default_footer': 'Ruaj si footer i paracaktuar',
      'auto_sync': 'Auto Sync',
      'refresh_accounts': 'Refresh Accounts',
      'upgrade_to_connect_bank_account':
          'Upgrade to Enterprise to connect your bank account',
      'click_here_to_connect_bank_account':
          'Click here to connect your bank account',
      'disable_2fa': 'Disable 2FA',
      'change_number': 'Change Number',
      'resend_code': 'Resend Code',
      'base_type': 'Base Type',
      'category_type': 'Category Type',
      'bank_transaction': 'Transaction',
      'bulk_print': 'Print PDF',
      'vendor_postal_code': 'Vendor Postal Code',
      'preview_location': 'Preview Location',
      'bottom': 'Bottom',
      'side': 'Side',
      'pdf_preview': 'PDF Preview',
      'long_press_to_select': 'Long Press to Select',
      'purchase_order_number': 'Purchase Order Number',
      'purchase_order_item': 'Purchase Order Item',
      'would_you_rate_the_app': 'Would you like to rate the app?',
      'include_deleted': 'Include Deleted',
      'include_deleted_help': 'Include deleted records in reports',
      'due_on': 'Due On',
      'converted_transactions': 'Successfully converted transactions',
      'created_bank_account': 'Llogaria bankare është krijuar me sukses',
      'updated_bank_account': 'Llogaria bankare është perditesuar me sukses',
      'edit_bank_account': 'Edito llogarinë bankare',
      'default_category': 'Default Category',
      'account_type': 'Account type',
      'new_bank_account': 'Add Bank Account',
      'connect_accounts': 'Connect Accounts',
      'manage_rules': 'Manage Rules',
      'search_category': 'Search 1 Category',
      'search_categories': 'Search :count Categories',
      'min_amount': 'Min Amount',
      'max_amount': 'Max Amount',
      'selected': 'Të selektuara',
      'converted_transaction': 'Successfully converted transaction',
      'convert_to_payment': 'Convert to Payment',
      'deposit': 'Deposit',
      'withdrawal': 'Withdrawal',
      'deposits': 'Deposits',
      'withdrawals': 'Withdrawals',
      'matched': 'Matched',
      'unmatched': 'Unmatched',
      'create_credit': 'Create Credit',
      'update_credit': 'Update Credit',
      'delete_credit': 'Fshi Kreditin',
      'transaction': 'Transaction',
      'transactions': 'Transactions',
      'new_transaction': 'New Transaction',
      'edit_transaction': 'Edit Transaction',
      'created_transaction': 'Successfully created transaction',
      'updated_transaction': 'Successfully updated transaction',
      'archived_transaction': 'Successfully archived transaction',
      'deleted_transaction': 'Successfully deleted transaction',
      'removed_transaction': 'Successfully removed transaction',
      'restored_transaction': 'Successfully restored transaction',
      'search_transaction': 'Search Transaction',
      'search_transactions': 'Search :count Transactions',
      'bank_account': 'Llogaria Bankare',
      'bank_accounts': 'Kredit Kartat & Bankat',
      'archived_bank_account': 'Llogaria bankare është azhurnuar me sukses',
      'deleted_bank_account': 'Successfully deleted bank account',
      'removed_bank_account': 'Successfully removed bank account',
      'restored_bank_account': 'Successfully restored bank account',
      'search_bank_account': 'Search Bank Account',
      'search_bank_accounts': 'Search :count Bank Accounts',
      'connect': 'Connect',
      'mark_paid_payment_email': 'Mark Paid Payment Email',
      'convert_to_project': 'Convert to Project',
      'client_email': 'Client Email',
      'invoice_task_project': 'Invoice Task Project',
      'invoice_task_project_help': 'Add the project to the invoice line items',
      'field': 'Field',
      'period': 'Period',
      'fields_per_row': 'Fields Per Row',
      'total_active_invoices': 'Active Invoices',
      'total_outstanding_invoices': 'Outstanding Invoices',
      'total_completed_payments': 'Completed Payments',
      'total_refunded_payments': 'Refunded Payments',
      'total_active_quotes': 'Active Quotes',
      'total_approved_quotes': 'Approved Quotes',
      'total_unapproved_quotes': 'Unapproved Quotes',
      'total_logged_tasks': 'Logged Tasks',
      'total_invoiced_tasks': 'Invoiced Tasks',
      'total_paid_tasks': 'Paid Tasks',
      'total_logged_expenses': 'Logged Expenses',
      'total_pending_expenses': 'Pending Expenses',
      'total_invoiced_expenses': 'Invoiced Expenses',
      'total_invoice_paid_expenses': 'Invoice Paid Expenses',
      'activity_130': ':user created purchase order :purchase_order',
      'activity_131': ':user updated purchase order :purchase_order',
      'activity_132': ':user archived purchase order :purchase_order',
      'activity_133': ':user deleted purchase order :purchase_order',
      'activity_134': ':user restored purchase order :purchase_order',
      'activity_135': ':user emailed purchase order :purchase_order',
      'activity_136': ':contact viewed purchase order :purchase_order',
      'activity_137': ':contact accepted purchase order :purchase_order',
      'vendor_portal': 'Vendor Portal',
      'send_code': 'Send Code',
      'save_to_upload_documents': 'Save the record to upload documents',
      'expense_tax_rates': 'Expense Tax Rates',
      'invoice_item_tax_rates': 'Invoice Item Tax Rates',
      'verified_phone_number': 'Successfully verified phone number',
      'code_was_sent': 'A code has been sent via SMS',
      'code_was_sent_to': 'A code has been sent via SMS to :number',
      'resend': 'Resend',
      'verify': 'Verify',
      'enter_phone_number': 'Please provide a phone number',
      'invalid_phone_number': 'Invalid phone number',
      'verify_phone_number': 'Verify Phone Number',
      'verify_phone_number_help':
          'Please verify your phone number to send emails',
      'verify_phone_number_2fa_help':
          'Please verify your phone number for 2FA backup',
      'merged_clients': 'Successfully merged clients',
      'merge_into': 'Merge Into',
      'merge': 'Merge',
      'price_change_accepted': 'Price change accepted',
      'price_change_failed': 'Price change failed with code',
      'restore_purchases': 'Restore Purchases',
      'activate': 'Activate',
      'connect_apple': 'Connect Apple',
      'disconnect_apple': 'Disconnect Apple',
      'disconnected_apple': 'Successfully disconnected Apple',
      'send_now': 'Send Now',
      'received': 'Received',
      'purchase_order_date': 'Purchase Order Date',
      'converted_to_expense': 'Successfully converted to expense',
      'converted_to_expenses': 'Successfully converted to expenses',
      'convert_to_expense': 'Convert to Expense',
      'add_to_inventory': 'Add to Inventory',
      'added_purchase_order_to_inventory':
          'Successfully added purchase order to inventory',
      'added_purchase_orders_to_inventory':
          'Successfully added purchase orders to inventory',
      'client_document_upload': 'Client Document Upload',
      'vendor_document_upload': 'Vendor Document Upload',
      'vendor_document_upload_help': 'Enable vendors to upload documents',
      'are_you_enjoying_the_app': 'Are you enjoying the app?',
      'yes_its_great': 'Yes, it\'s great!',
      'not_so_much': 'Not so much',
      'would_you_rate_it': 'Great to hear! Would you like to rate it?',
      'would_you_tell_us_more':
          'Sorry to hear it! Would you like to tell us more?',
      'sure_happy_to': 'Sure, happy to',
      'no_not_now': 'No, not now',
      'add': 'Add',
      'last_sent_template': 'Last Sent Template',
      'enable_flexible_search': 'Enable Flexible Search',
      'enable_flexible_search_help':
          'Match non-contiguous characters, ie. \'ct\' matches \'cat\'',
      'vendor_details': 'Vendor Details',
      'purchase_order_details': 'Purchase Order Details',
      'qr_iban': 'QR IBAN',
      'besr_id': 'BESR ID',
      'accept': 'Accept',
      'clone_to_purchase_order': 'Clone to PO',
      'vendor_email_not_set': 'Vendor does not have an email address set',
      'bulk_send_email': 'Send Email',
      'marked_purchase_order_as_sent':
          'Successfully marked purchase order as sent',
      'marked_purchase_orders_as_sent':
          'Successfully marked purchase orders as sent',
      'accepted_purchase_order': 'Successfully accepted purchase order',
      'accepted_purchase_orders': 'Successfully accepted purchase orders',
      'cancelled_purchase_order': 'Successfully cancelled purchase order',
      'cancelled_purchase_orders': 'Successfully cancelled purchase orders',
      'accepted': 'Accepted',
      'please_select_a_vendor': 'Please select a vendor',
      'purchase_order_total': 'Purchase Order Total',
      'email_purchase_order': 'Email Purchase Order',
      'bulk_email_purchase_orders': 'Email Purchase Orders',
      'disconnected_email': 'Successfully disconnected email',
      'connect_email': 'Connect Email',
      'disconnect_email': 'Disconnect Email',
      'use_web_app_to_connect_microsoft':
          'Please use the web app to connect to Microsoft',
      'email_provider': 'Email Provider',
      'connect_microsoft': 'Connect Microsoft',
      'disconnect_microsoft': 'Disconnect Microsoft',
      'connected_microsoft': 'Successfully connected Microsoft',
      'disconnected_microsoft': 'Successfully disconnected Microsoft',
      'microsoft_sign_in': 'Login with Microsoft',
      'microsoft_sign_up': 'Sign up with Microsoft',
      'emailed_purchase_order': 'Successfully queued purchase order to be sent',
      'emailed_purchase_orders':
          'Successfully queued purchase orders to be sent',
      'enable_react_app': 'Change to the React web app',
      'purchase_order_design': 'Purchase Order Design',
      'purchase_order_terms': 'Purchase Order Terms',
      'purchase_order_footer': 'Purchase Order Footer',
      'require_purchase_order_signature': 'Purchase Order Signature',
      'require_purchase_order_signature_help':
          'Require vendor to provide their signature.',
      'purchase_order': 'Purchase Order',
      'purchase_orders': 'Purchase Orders',
      'new_purchase_order': 'New Purchase Order',
      'edit_purchase_order': 'Edit Purchase Order',
      'created_purchase_order': 'Successfully created purchase order',
      'updated_purchase_order': 'Successfully updated purchase order',
      'archived_purchase_order': 'Successfully archived purchase order',
      'deleted_purchase_order': 'Successfully deleted purchase order',
      'removed_purchase_order': 'Successfully removed purchase order',
      'restored_purchase_order': 'Successfully restored purchase order',
      'search_purchase_order': 'Search Purchase Order',
      'search_purchase_orders': 'Search Purchase Orders',
      'login_url': 'Login URL',
      'payment_settings': 'Rregullimi i pagesës',
      'default': 'Default',
      'stock_quantity': 'Stock Quantity',
      'notification_threshold': 'Notification Threshold',
      'track_inventory': 'Track Inventory',
      'track_inventory_help':
          'Display a product stock field and update when invoices are sent',
      'stock_notifications': 'Stock Notifications',
      'stock_notifications_help':
          'Send an email when the stock reaches the threshold',
      'vat': 'VAT',
      'standing': 'Gjendja',
      'view_map': 'View Map',
      'set_default_design': 'Set Default Design',
      'add_gateway': 'Add Payment Gateway',
      'add_gateway_help_message':
          'Add a payment gateway (ie. Stripe, WePay or PayPal) to accept online payments',
      'left': 'Left',
      'right': 'Right',
      'center': 'Center',
      'page_numbering': 'Page Numbering',
      'page_numbering_alignment': 'Page Numbering Alignment',
      'invoice_sent_notification_label': 'Invoice Sent',
      'show_product_description': 'Show Product Description',
      'show_product_description_help':
          'Include the description in the product dropdown',
      'invoice_items': 'Invoice Items',
      'quote_items': 'Quote Items',
      'profitloss': 'Profit and Loss',
      'import_format': 'Import Format',
      'export_format': 'Export Format',
      'export_type': 'Export Type',
      'stop_on_unpaid': 'Stop On Unpaid',
      'stop_on_unpaid_help':
          'Stop creating recurring invoices if the last invoice is unpaid.',
      'use_quote_terms': 'Use Quote Terms',
      'use_quote_terms_help': 'When converting a quote to an invoice',
      'add_country': 'Add Country',
      'enable_tooltips': 'Enable Tooltips',
      'enable_tooltips_help': 'Show tooltips when hovering the mouse',
      'multiple_client_error': 'Error: records belong to more than one client',
      'register_label': 'Create your account in seconds',
      'login_label': 'Login to an existing account',
      'add_to_invoice': 'Shto në faturën :invoice',
      'no_invoices_found': 'No invoices found',
      'week': 'Jave',
      'created_record': 'Successfully created record',
      'auto_archive_paid_invoices': 'Auto Archive Paid',
      'auto_archive_paid_invoices_help':
          'Automatically archive invoices when they are paid.',
      'auto_archive_cancelled_invoices': 'Auto Archive Cancelled',
      'auto_archive_cancelled_invoices_help':
          'Automatically archive invoices when cancelled.',
      'alternate_pdf_viewer': 'Alternate PDF Viewer',
      'alternate_pdf_viewer_help':
          'Improve scrolling over the PDF preview [BETA]',
      'invoice_currency': 'Valuta e Faturës',
      'range': 'Range',
      'tax_amount1': 'Tax Amount 1',
      'tax_amount2': 'Tax Amount 2',
      'tax_amount3': 'Tax Amount 3',
      'create_project': 'Create project',
      'update_project': 'Update Project',
      'view_task': 'View Task',
      'cancel_invoice': 'Cancel',
      'changed_status': 'Successfully changed task status',
      'change_status': 'Change Status',
      'fees_sample': 'The fee for a :amount invoice would be :total.',
      'enable_touch_events': 'Enable Touch Events',
      'enable_touch_events_help': 'Support drag events to scroll',
      'after_saving': 'After Saving',
      'view_record': 'View Record',
      'enable_email_markdown': 'Enable Email Markdown',
      'enable_email_markdown_help': 'Use visual markdown editor for emails',
      'enable_pdf_markdown': 'Enable PDF Markdown',
      'json_help': 'Note: JSON files generated by the v4 app are not supported',
      'release_notes': 'Release Notes',
      'upgrade_to_view_reports': 'Upgrade your plan to view reports',
      'started_tasks': 'Successfully started :value tasks',
      'stopped_tasks': 'Successfully stopped :value tasks',
      'approved_quote': 'Successfully apporved quote',
      'approved_quotes': 'Successfully :value approved quotes',
      'approve': 'Aprovo',
      'client_website': 'Client Website',
      'invalid_time': 'Invalid Time',
      'client_shipping_state': 'Client Shipping State',
      'client_shipping_city': 'Client Shipping City',
      'client_shipping_postal_code': 'Client Shipping Postal Code',
      'client_shipping_country': 'Client Shipping Country',
      'load_pdf': 'Load PDF',
      'start_free_trial': 'Start Free Trial',
      'start_free_trial_message':
          'Start your FREE 14 day trial of the Pro Plan',
      'due_on_receipt': 'Due on Receipt',
      'is_paid': 'Is Paid',
      'age_group_paid': 'Paid',
      'id': 'Id',
      'convert_to': 'Convert To',
      'client_currency': 'Client Currency',
      'company_currency': 'Company Currency',
      'purged_client': 'Successfully purged client',
      'custom_emails_disabled_help':
          'To prevent spam we require upgrading to a paid account to customize the email',
      'upgrade_to_add_company': 'Upgrade your plan to add companies',
      'small': 'Small',
      'marked_credit_as_paid': 'Successfully marked credit as paid',
      'marked_credits_as_paid': 'Successfully marked credits as paid',
      'wait_for_loading': 'Data loading - please wait for it to complete',
      'wait_for_saving': 'Data saving - please wait for it to complete',
      'html_preview_warning':
          'Note: changes made here are only previewed, they must be applied in the tabs above to be saved',
      'remaining': 'Remaining',
      'invoice_paid': 'Invoice Paid',
      'activity_120': ':user created recurring expense :recurring_expense',
      'activity_121': ':user updated recurring expense :recurring_expense',
      'activity_122': ':user archived recurring expense :recurring_expense',
      'activity_123': ':user deleted recurring expense :recurring_expense',
      'activity_124': ':user restored recurring expense :recurring_expense',
      'normal': 'Normal',
      'large': 'Large',
      'extra_large': 'Extra Large',
      'show_pdf_preview': 'Show PDF Preview',
      'show_pdf_preview_help': 'Display PDF preview while editing invoices',
      'print_pdf': 'Print PDF',
      'remind_me': 'Remind Me',
      'instant_bank_pay': 'Instant Bank Pay',
      'click_selected': 'Click Selected',
      'hide_preview': 'Hide Preview',
      'edit_record': 'Edit Record',
      'credit_is_more_than_invoice':
          'The credit amount can not be more than the invoice amount',
      'giropay': 'GiroPay',
      'direct_debit': 'Direct Debit',
      'please_set_a_password': 'Please set an account password',
      'set_password': 'Vendos Fjalëkalim',
      'disconnected_gateway': 'Successfully disconnected gateway',
      'disconnect': 'Disconnect',
      'add_to_invoices': 'Add to Invoices',
      'acss': 'ACSS Debit',
      'becs': 'BECS Direct Debit',
      'bulk_download': 'Download',
      'persist_data_help':
          'Save data locally to enable the app to start faster, disabling may improve performance in large accounts',
      'persist_ui': 'Persist UI',
      'persist_ui_help':
          'Save UI state locally to enable the app to start at the last location, disabling may improve performance',
      'client_postal_code': 'Client Postal Code',
      'client_vat_number': 'Client VAT Number',
      'has_tasks': 'Has Tasks',
      'registration': 'Registration',
      'unauthorized_stripe_warning':
          'Please authorize Stripe to accept online payments.',
      'view_expense': 'Shiko # :expense të shpenzimit',
      'view_statement': 'View Statement',
      'sepa': 'SEPA Direct Debit',
      'ideal': 'iDEAL',
      'przelewy24': 'Przelewy24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'Update all records',
      'system': 'Sistem',
      'set_default_company': 'Set Default Company',
      'updated_company': 'Successfully updated company',
      'kbc': 'KBC',
      'bancontact': 'Bancontact',
      'why_are_you_leaving': 'Help us improve by telling us why (optional)',
      'webhook_success': 'Webhook Success',
      'error_cross_client_tasks': 'Tasks must all belong to the same client',
      'error_cross_client_expenses':
          'Expenses must all belong to the same client',
      'app': 'App',
      'for_best_performance': 'For the best performance download the :app app',
      'gross_line_total': 'Gross Line Total',
      'bulk_email_invoices': 'Email Invoices',
      'bulk_email_quotes': 'Email Quotes',
      'bulk_email_credits': 'Email Credits',
      'from_name': 'From Name',
      'clone_to_expense': 'Clone to Expense',
      'recurring_expense': 'Recurring Expense',
      'recurring_expenses': 'Recurring Expenses',
      'new_recurring_expense': 'New Recurring Expense',
      'edit_recurring_expense': 'Edit Recurring Expense',
      'created_recurring_expense': 'Successfully created recurring expense',
      'updated_recurring_expense': 'Successfully updated recurring expense',
      'archived_recurring_expense': 'Successfully archived recurring expense',
      'deleted_recurring_expense': 'Successfully deleted recurring expense',
      'removed_recurring_expense': 'Successfully removed recurring expense',
      'restored_recurring_expense': 'Successfully restored recurring expense',
      'search_recurring_expense': 'Search Recurring Expense',
      'search_recurring_expenses': 'Search Recurring Expenses',
      'last_sent_date': 'Last Sent Date',
      'include_drafts': 'Include Drafts',
      'include_drafts_help': 'Include draft records in reports',
      'is_invoiced': 'Is Invoiced',
      'change_plan': 'Manage Plan',
      'persist_data': 'Persist Data',
      'customer_count': 'Customer Count',
      'verify_customers': 'Verify Customers',
      'google_analytics': 'Google Analytics',
      'google_analytics_tracking_id': 'Google Analytics Tracking ID',
      'decimal_comma': 'Decimal Comma',
      'use_comma_as_decimal_place': 'Use comma as decimal place in forms',
      'select_method': 'Select Method',
      'select_platform': 'Select Platform',
      'use_web_app_to_connect_gmail':
          'Please use the web app to connect to Gmail',
      'expense_tax_help': 'Item tax rates are disabled',
      'enable_markdown': 'Enable Markdown',
      'enable_markdown_help': 'Convert markdown to HTML on the PDF',
      'user_guide': 'User Guide',
      'add_second_contact': 'Add Second Contact',
      'previous_page': 'Previous Page',
      'next_page': 'Next Page',
      'export_colors': 'Export Colors',
      'import_colors': 'Import Colors',
      'clear_all': 'Clear All',
      'contrast': 'Contrast',
      'custom_colors': 'Custom Colors',
      'colors': 'Colors',
      'sidebar_active_background_color': 'Sidebar Active Background Color',
      'sidebar_active_font_color': 'Sidebar Active Font Color',
      'sidebar_inactive_background_color': 'Sidebar Inactive Background Color',
      'sidebar_inactive_font_color': 'Sidebar Inactive Font Color',
      'table_alternate_row_background_color':
          'Table Alternate Row Background Color',
      'invoice_header_background_color': 'Invoice Header Background Color',
      'invoice_header_font_color': 'Invoice Header Font Color',
      'net_subtotal': 'Net',
      'review_app': 'Review App',
      'check_status': 'Check Status',
      'free_trial': 'Free Trial',
      'free_trial_ends_in_days':
          'The Pro plan trial ends in :count days, click to upgrade.',
      'free_trial_ends_today':
          'Today is the last day of the Pro plan trial, click to upgrade.',
      'change_email': 'Change Email',
      'client_portal_domain_hint':
          'Optionally configure a separate client portal domain',
      'tasks_shown_in_portal': 'Tasks Shown in Portal',
      'uninvoiced': 'Uninvoiced',
      'subdomain_guide':
          'The subdomain is used in the client portal to personalize links to match your brand. ie, https://your-brand.invoicing.co',
      'send_time': 'Send Time',
      'import_data': 'Importo të dhëna',
      'import_settings': 'Import Settings',
      'json_file_missing': 'Please provide the JSON file',
      'json_option_missing': 'Please select to import the settings and/or data',
      'json': 'JSON',
      'no_payment_types_enabled': 'No payment types enabled',
      'wait_for_data': 'Please wait for the data to finish loading',
      'net_total': 'Net Total',
      'has_taxes': 'Has Taxes',
      'import_customers': 'Import Customers',
      'imported_customers': 'Successfully started importing customers',
      'login_success': 'Successful Login',
      'login_failure': 'Failed Login',
      'exported_data':
          'Once the file is ready you\'ll receive an email with a download link',
      'include_deleted_clients': 'Include Deleted Clients',
      'include_deleted_clients_help':
          'Load records belonging to deleted clients',
      'step_1_sign_in': 'Step 1: Sign In',
      'step_2_authorize': 'Step 2: Authorize',
      'account_id': 'Account ID',
      'migration_not_yet_completed': 'The migration has not yet completed',
      'activity_100': ':user created recurring invoice :recurring_invoice',
      'activity_101': ':user updated recurring invoice :recurring_invoice',
      'activity_102': ':user archived recurring invoice :recurring_invoice',
      'activity_103': ':user deleted recurring invoice :recurring_invoice',
      'activity_104': ':user restored recurring invoice :recurring_invoice',
      'show_task_end_date': 'Show Task End Date',
      'show_task_end_date_help': 'Enable specifying the task end date',
      'gateway_setup': 'Gateway Setup',
      'preview_sidebar': 'Preview Sidebar',
      'years_data_shown': 'Years Data Shown',
      'ended_all_sessions': 'Successfully ended all sessions',
      'end_all_sessions': 'End All Sessions',
      'count_session': '1 Session',
      'count_sessions': ':count Sessions',
      'invoice_created': 'Invoice Created',
      'quote_created': 'Quote Created',
      'credit_created': 'Credit Created',
      'pro': 'Pro',
      'enterprise': 'Enterprise',
      'last_updated': 'Last Updated',
      'invoice_item': 'Invoice Item',
      'quote_item': 'Quote Item',
      'contact_first_name': 'Contact First Name',
      'contact_last_name': 'Contact Last Name',
      'order': 'Order',
      'unassigned': 'E pacaktuar',
      'partial_value': 'Duhet të jetë më shumë se zero dhe më pak se totali',
      'search_kanban': 'Search Kanban',
      'search_kanbans': 'Search Kanban',
      'kanban': 'Kanban',
      'enable': 'Aktivizo',
      'move_top': 'Move Top',
      'move_up': 'Move Up',
      'move_down': 'Move Down',
      'move_bottom': 'Move Bottom',
      'subdomain_help':
          'Set the subdomain or display the invoice on your own website.',
      'body_variable_missing':
          'Error: the custom email must include a :body variable',
      'add_body_variable_message': 'Make sure to include a :body variable',
      'view_date_formats': 'View Date Formats',
      'is_viewed': 'Is Viewed',
      'letter': 'Letter',
      'legal': 'Legal',
      'page_layout': 'Page Layout',
      'portrait': 'Portrait',
      'landscape': 'Landscape',
      'owner_upgrade_to_paid_plan':
          'The account owner can upgrade to a paid plan to enable the advanced advanced settings',
      'upgrade_to_paid_plan':
          'Upgrade to a paid plan to enable the advanced settings',
      'invoice_payment_terms': 'Invoice Payment Terms',
      'quote_valid_until': 'Quote Valid Until',
      'no_headers': 'No Headers',
      'add_header': 'Add Header',
      'remove_header': 'Remove Header',
      'return_url': 'Return URL',
      'rest_method': 'REST Method',
      'header_key': 'Header Key',
      'header_value': 'Header Value',
      'recurring_products': 'Recurring Products',
      'promo_code': 'Promo code',
      'promo_discount': 'Promo Discount',
      'allow_cancellation': 'Allow Cancellation',
      'per_seat_enabled': 'Per Seat Enabled',
      'max_seats_limit': 'Max Seats Limit',
      'trial_enabled': 'Trial Enabled',
      'trial_duration': 'Trial Duration',
      'allow_query_overrides': 'Allow Query Overrides',
      'allow_plan_changes': 'Allow Plan Changes',
      'plan_map': 'Plan Map',
      'refund_period': 'Refund Period',
      'webhook_configuration': 'Webhook Configuration',
      'purchase_page': 'Purchase Page',
      'security': 'Siguria',
      'email_bounced': 'Email Bounced',
      'email_spam_complaint': 'Spam Complaint',
      'email_delivery': 'Email Delivery',
      'webhook_response': 'Webhook Response',
      'pdf_response': 'PDF Response',
      'authentication_failure': 'Authentication Failure',
      'pdf_failed': 'PDF Failed',
      'pdf_success': 'PDF Success',
      'modified': 'Modified',
      'payment_link': 'Payment Link',
      'new_payment_link': 'New Payment Link',
      'edit_payment_link': 'Edit Payment Link',
      'created_payment_link': 'Successfully created payment link',
      'updated_payment_link': 'Successfully updated payment link',
      'archived_payment_link': 'Successfully archived payment link',
      'deleted_payment_link': 'Successfully deleted payment link',
      'removed_payment_link': 'Successfully removed payment link',
      'restored_payment_link': 'Successfully restored payment link',
      'search_payment_link': 'Search 1 Payment Link',
      'search_payment_links': 'Search :count Payment Links',
      'subdomain_is_not_available': 'Subdomain is not available',
      'connect_gmail': 'Connect Gmail',
      'disconnect_gmail': 'Disconnect Gmail',
      'connected_gmail': 'Successfully connected Gmail',
      'disconnected_gmail': 'Successfully disconnected Gmail',
      'update_fail_help':
          'Changes to the codebase may be blocking the update, you can run this command to discard the changes:',
      'client_id_number': 'Client ID Number',
      'count_minutes': ':count Minutes',
      'password_timeout': 'Password Timeout',
      'shared_invoice_credit_counter': 'Share Invoice/Credit Counter',
      'use_last_email': 'Use last email',
      'activate_company': 'Activate Company',
      'activate_company_help':
          'Enable emails, recurring invoices and notifications',
      'an_error_occurred_try_again': 'An error occurred, please try again',
      'please_first_set_a_password': 'Please first set a password',
      'changing_phone_disables_two_factor':
          'Warning: Changing your phone number will disable 2FA',
      'help_translate': 'Help Translate',
      'please_select_a_country': 'Please select a country',
      'resend_invite': 'Resend Invitation',
      'disabled_two_factor': 'Successfully disabled 2FA',
      'connected_google': 'Successfully connected account',
      'disconnected_google': 'Successfully disconnected account',
      'delivered': 'Delivered',
      'bounced': 'Bounced',
      'spam': 'Spam',
      'view_docs': 'View Docs',
      'enter_phone_to_enable_two_factor':
          'Please provide a mobile phone number to enable two factor authentication',
      'send_sms': 'Send SMS',
      'sms_code': 'SMS Code',
      'two_factor_setup_help': 'Scan the bar code with a :link compatible app.',
      'enabled_two_factor': 'Successfully enabled Two-Factor Authentication',
      'connect_google': 'Connect Google',
      'disconnect_google': 'Disconnect Google',
      'enable_two_factor': 'Two-Factor Authentication',
      'disable_two_factor': 'Disable Two Factor',
      'require_password_with_social_login':
          'Require Password with Social Login',
      'stay_logged_in': 'Stay Logged In',
      'session_about_to_expire': 'Warning: Your session is about to expire',
      'count_hours': ':count Hours',
      'count_day': '1 Day',
      'count_days': ':count Days',
      'web_session_timeout': 'Web Session Timeout',
      'security_settings': 'Security Settings',
      'resend_email': 'Resend Email',
      'confirm_your_email_address': 'Please confirm your email address',
      'refunded_payment': 'Pagesë e rimbursuar',
      'partially_unapplied': 'Partially Unapplied',
      'select_a_gmail_user': 'Please select a user authenticated with Gmail',
      'list_long_press': 'List Long Press',
      'show_actions': 'Show Actions',
      'start_multiselect': 'Start Multiselect',
      'email_sent_to_confirm_email':
          'An email has been sent to confirm the email address',
      'counter_pattern_error':
          'To use :client_counter please add either :client_number or :client_id_number to prevent conflicts',
      'this_quarter': 'This Quarter',
      'last_quarter': 'Last Quarter',
      'to_update_run': 'To update run',
      'convert_to_invoice': 'Ktheje Ofertën në Faturë',
      'registration_url': 'Registration URL',
      'invoice_project': 'Invoice Project',
      'invoice_task': 'Faturo detyrën',
      'invoice_expense': 'Faturë shpenzimesh',
      'search_payment_term': 'Search 1 Payment Term',
      'search_payment_terms': 'Search :count Payment Terms',
      'save_and_preview': 'Save and Preview',
      'save_and_email': 'Save and Email',
      'supported_events': 'Supported Events',
      'converted_amount': 'Converted Amount',
      'converted_balance': 'Converted Balance',
      'converted_paid_to_date': 'Converted Paid to Date',
      'converted_credit_balance': 'Converted Credit Balance',
      'converted_total': 'Converted Total',
      'is_sent': 'Is Sent',
      'default_documents': 'Default Documents',
      'document_upload': 'Document Upload',
      'document_upload_help': 'Enable clients to upload documents',
      'expense_total': 'Expense Total',
      'enter_taxes': 'Enter Taxes',
      'by_rate': 'By Rate',
      'by_amount': 'By Amount',
      'enter_amount': 'Enter Amount',
      'before_taxes': 'Before Taxes',
      'after_taxes': 'After Taxes',
      'color': 'Color',
      'show': 'Show',
      'hide': 'Fshih',
      'empty_columns': 'Empty Columns',
      'debug_mode_is_enabled': 'Debug mode is enabled',
      'debug_mode_is_enabled_help':
          'Warning: it is intended for use on local machines, it can leak credentials. Click to learn more.',
      'running_tasks': 'Running Tasks',
      'recent_tasks': 'Recent Tasks',
      'recent_expenses': 'Recent Expenses',
      'upcoming_expenses': 'Upcoming Expenses',
      'update_app': 'Update App',
      'started_import': 'Successfully started import',
      'duplicate_column_mapping': 'Duplicate column mapping',
      'uses_inclusive_taxes': 'Uses Inclusive Taxes',
      'is_amount_discount': 'Is Amount Discount',
      'column': 'Kolona',
      'sample': 'Shembull',
      'map_to': 'Map To',
      'import': 'Importo',
      'first_row_as_column_names': 'Use first row as column names',
      'select_file': 'Ju lutem zgjedhni një fajll',
      'no_file_selected': 'No File Selected',
      'csv_file': 'Skedar CSV',
      'csv': 'CSV',
      'freshbooks': 'FreshBooks',
      'invoice2go': 'Invoice2go',
      'invoicely': 'Invoicely',
      'waveaccounting': 'Wave Accounting',
      'zoho': 'Zoho',
      'accounting': 'Accounting',
      'required_files_missing': 'Please provide all CSVs.',
      'import_type': 'Import Type',
      'html_mode': 'HTML Mode',
      'html_mode_help': 'Preview updates faster but is less accurate',
      'view_licenses': 'View Licenses',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': 'Fullscreen Editor',
      'sidebar_editor': 'Sidebar Editor',
      'please_type_to_confirm': 'Please type \':value\' to confirm',
      'purge': 'Purge',
      'service': 'Service',
      'clone_to': 'Clone To',
      'clone_to_other': 'Clone to Other',
      'labels': 'Labels',
      'add_custom': 'Add Custom',
      'payment_tax': 'Payment Tax',
      'unpaid': 'Unpaid',
      'white_label': 'White Label',
      'delivery_note': 'Delivery Note',
      'sent_invoices_are_locked': 'Sent invoices are locked',
      'paid_invoices_are_locked': 'Paid invoices are locked',
      'source_code': 'Source Code',
      'app_platforms': 'App Platforms',
      'invoice_late': 'Invoice Late',
      'quote_expired': 'Quote Expired',
      'partial_due': 'Paguar pjesërisht',
      'invoice_total': 'Totali i faturës',
      'quote_total': 'Totali i Ofertës',
      'credit_total': 'Credit Total',
      'recurring_invoice_total': 'Invoice Total',
      'actions': 'Actions',
      'expense_number': 'Expense Number',
      'task_number': 'Task Number',
      'project_number': 'Project Number',
      'project_name': 'Project Name',
      'warning': 'Paralajmerim',
      'view_settings': 'View Settings',
      'company_disabled_warning':
          'Warning: this company has not yet been activated',
      'late_invoice': 'Late Invoice',
      'expired_quote': 'Expired Quote',
      'remind_invoice': 'Remind Invoice',
      'cvv': 'CVV',
      'client_name': 'Emri i klientit',
      'client_phone': 'Client Phone',
      'required_fields': 'Required Fields',
      'calculated_rate': 'Calculated Rate',
      'default_task_rate': 'Default Task Rate',
      'clear_cache': 'Clear Cache',
      'sort_order': 'Sort Order',
      'task_status': 'Status',
      'task_statuses': 'Task Statuses',
      'new_task_status': 'New Task Status',
      'edit_task_status': 'Edit Task Status',
      'created_task_status': 'Successfully created task status',
      'updated_task_status': 'Successfully update task status',
      'archived_task_status': 'Successfully archived task status',
      'deleted_task_status': 'Successfully deleted task status',
      'removed_task_status': 'Successfully removed task status',
      'restored_task_status': 'Successfully restored task status',
      'archived_task_statuses': 'Successfully archived :value task statuses',
      'deleted_task_statuses': 'Successfully deleted :value task statuses',
      'restored_task_statuses': 'Successfully restored :value task statuses',
      'search_task_status': 'Search 1 Task Status',
      'search_task_statuses': 'Search :count Task Statuses',
      'show_tasks_table': 'Show Tasks Table',
      'show_tasks_table_help':
          'Always show the tasks section when creating invoices',
      'invoice_task_timelog': 'Invoice Task Timelog',
      'invoice_task_timelog_help': 'Add time details to the invoice line items',
      'invoice_task_datelog': 'Invoice Task Datelog',
      'invoice_task_datelog_help': 'Add date details to the invoice line items',
      'auto_start_tasks_help': 'Start tasks before saving',
      'configure_statuses': 'Configure Statuses',
      'task_settings': 'Task Settings',
      'configure_categories': 'Configure Categories',
      'expense_categories': 'Kategoritë e shpenzimeve',
      'new_expense_category': 'Kategori e re e shpenzimeve',
      'edit_expense_category': 'Edit Expense Category',
      'created_expense_category':
          'Kategoria e shpenzimeve është krijuar me sukses',
      'updated_expense_category':
          'Është perditesuar me sukses kategoria e shpenzimeve',
      'archived_expense_category':
          'Kategoria e shpenzimeve është arkivuar me sukses',
      'deleted_expense_category': 'Successfully deleted category',
      'removed_expense_category': 'Successfully removed expense category',
      'restored_expense_category':
          'Kategoria e shpenzimeve është rikthyer me sukses',
      'archived_expense_categories':
          ':count kategori të shpenzimeve janë arkivuar me sukses',
      'deleted_expense_categories':
          'Successfully deleted expense :value categories',
      'restored_expense_categories':
          'Successfully restored expense :value categories',
      'search_expense_category': 'Search 1 Expense Category',
      'search_expense_categories': 'Search :count Expense Categories',
      'use_available_credits': 'Use Available Credits',
      'show_option': 'Show Option',
      'negative_payment_error':
          'The credit amount cannot exceed the payment amount',
      'view_changes': 'View Changes',
      'force_update': 'Force Update',
      'force_update_help':
          'You are running the latest version but there may be pending fixes available.',
      'mark_paid_help': 'Track the expense has been paid',
      'should_be_invoiced': 'Duhet të faturohet',
      'should_be_invoiced_help': 'Enable the expense to be invoiced',
      'add_documents_to_invoice_help': 'Make the documents visible to client',
      'convert_currency_help': 'Set an exchange rate',
      'expense_settings': 'Expense Settings',
      'clone_to_recurring': 'Clone to Recurring',
      'crypto': 'Crypto',
      'paypal': 'PayPal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple/Google Pay',
      'user_field': 'User Field',
      'variables': 'Variables',
      'show_password': 'Show Password',
      'hide_password': 'Hide Password',
      'copy_error': 'Copy Error',
      'capture_card': 'Capture Card',
      'auto_bill_enabled': 'Auto Bill Enabled',
      'total_taxes': 'Total Taxes',
      'line_taxes': 'Line Taxes',
      'total_fields': 'Total Fields',
      'stopped_recurring_invoice': 'Successfully stopped recurring invoice',
      'started_recurring_invoice': 'Successfully started recurring invoice',
      'resumed_recurring_invoice': 'Successfully resumed recurring invoice',
      'gateway_refund': 'Gateway Refund',
      'gateway_refund_help': 'Process the refund with the payment gateway',
      'due_date_days': 'Due Date',
      'paused': 'Paused',
      'mark_active': 'Mark Active',
      'day_count': 'Day :count',
      'first_day_of_the_month': 'First Day of the Month',
      'last_day_of_the_month': 'Last Day of the Month',
      'use_payment_terms': 'Use Payment Terms',
      'endless': 'Endless',
      'next_send_date': 'Next Send Date',
      'remaining_cycles': 'Remaining Cycles',
      'recurring_invoice': 'Faturë e përsëritshme',
      'recurring_invoices': 'Fatura të përsëritshme',
      'new_recurring_invoice': 'Faturë e re e përsëritshme',
      'edit_recurring_invoice': 'Edit Recurring Invoice',
      'created_recurring_invoice': 'Successfully created recurring invoice',
      'updated_recurring_invoice': 'Successfully updated recurring invoice',
      'archived_recurring_invoice':
          'Faturat e përsëritshme janë arkivuar me sukses',
      'deleted_recurring_invoice':
          'Faturat e përsëritshme janë fshirë  me sukses',
      'removed_recurring_invoice': 'Successfully removed recurring invoice',
      'restored_recurring_invoice':
          'Faturat e përsëritshme janë rikthyer me sukses',
      'archived_recurring_invoices':
          'Successfully archived recurring :value invoices',
      'deleted_recurring_invoices':
          'Successfully deleted recurring :value invoices',
      'restored_recurring_invoices':
          'Successfully restored recurring :value invoices',
      'search_recurring_invoice': 'Search 1 Recurring Invoice',
      'search_recurring_invoices': 'Search :count Recurring Invoices',
      'send_date': 'Send Date',
      'auto_bill_on': 'Auto Bill On',
      'minimum_under_payment_amount': 'Minimum Under Payment Amount',
      'profit': 'Profit',
      'line_item': 'Line Item',
      'allow_over_payment': 'Allow Overpayment',
      'allow_over_payment_help': 'Support paying extra to accept tips',
      'allow_under_payment': 'Allow Underpayment',
      'allow_under_payment_help':
          'Support paying at minimum the partial/deposit amount',
      'test_mode': 'Test Mode',
      'opened': 'Opened',
      'payment_reconciliation_failure': 'Reconciliation Failure',
      'payment_reconciliation_success': 'Reconciliation Success',
      'gateway_success': 'Gateway Success',
      'gateway_failure': 'Gateway Failure',
      'gateway_error': 'Gateway Error',
      'email_send': 'Email Send',
      'email_retry_queue': 'Email Retry Queue',
      'failure': 'Failure',
      'quota_exceeded': 'Quota Exceeded',
      'upstream_failure': 'Upstream Failure',
      'system_logs': 'System Logs',
      'view_portal': 'Shiko portalin',
      'copy_link': 'Copy Link',
      'token_billing': 'Ruaj detajet e pagesës',
      'welcome_to_invoice_ninja': 'Welcome to Invoice Ninja',
      'always': 'Gjithmonë',
      'optin': 'Opt-In',
      'optout': 'Opt-Out',
      'label': 'Label',
      'client_number': 'Client Number',
      'auto_convert': 'Auto Convert',
      'company_name': 'Emri i kompanisë',
      'reminder1_sent': 'Reminder 1 Sent',
      'reminder2_sent': 'Reminder 2 Sent',
      'reminder3_sent': 'Reminder 3 Sent',
      'reminder_last_sent': 'Reminder Last Sent',
      'pdf_page_info': 'Page :current of :total',
      'emailed_invoices': 'Successfully emailed invoices',
      'emailed_quotes': 'Successfully emailed quotes',
      'emailed_credits': 'Successfully emailed credits',
      'gateway': 'Gateway',
      'view_in_stripe': 'View in Stripe',
      'rows_per_page': 'Rows Per Page',
      'hours': 'Ore',
      'statement': 'Statement',
      'taxes': 'Taksat',
      'surcharge': 'Surcharge',
      'apply_payment': 'Apply Payment',
      'apply_credit': 'Apliko kreditin',
      'apply': 'Apply',
      'unapplied': 'Unapplied',
      'select_label': 'Select Label',
      'custom_labels': 'Custom Labels',
      'record_type': 'Record Type',
      'record_name': 'Record Name',
      'file_type': 'File Type',
      'height': 'Height',
      'width': 'Width',
      'to': 'Për',
      'health_check': 'Health Check',
      'payment_type_id': 'Lloji i pagesës',
      'last_login_at': 'Last Login At',
      'company_key': 'Company Key',
      'storefront': 'Storefront',
      'storefront_help': 'Enable third-party apps to create invoices',
      'client_created': 'Client Created',
      'online_payment_email': 'Online Payment Email',
      'manual_payment_email': 'Manual Payment Email',
      'completed': 'Completed',
      'gross': 'Gross',
      'net_amount': 'Net Amount',
      'net_balance': 'Net Balance',
      'client_settings': 'Client Settings',
      'selected_invoices': 'Selected Invoices',
      'selected_payments': 'Selected Payments',
      'selected_quotes': 'Selected Quotes',
      'selected_tasks': 'Selected Tasks',
      'selected_expenses': 'Selected Expenses',
      'upcoming_invoices': 'Faturat e ardhshme',
      'past_due_invoices': 'Past Due Invoices',
      'recent_payments': 'Pagesat e fundit',
      'upcoming_quotes': 'Ofertat e ardhshme',
      'expired_quotes': 'Ofertat e skaduara',
      'create_client': 'Create Client',
      'create_invoice': 'Krijo faturë',
      'create_quote': 'Krijo Ofertë',
      'create_payment': 'Create Payment',
      'create_vendor': 'Create vendor',
      'update_quote': 'Update Quote',
      'delete_quote': 'Fshi Ofertën',
      'update_invoice': 'Update Invoice',
      'delete_invoice': 'Fshi faturën',
      'update_client': 'Update Client',
      'delete_client': 'Fshi Klientin',
      'delete_payment': 'Fshi Pagesën',
      'update_vendor': 'Update Vendor',
      'delete_vendor': 'Fshi kompaninë',
      'create_expense': 'Create Expense',
      'update_expense': 'Update Expense',
      'delete_expense': 'Fshi shpenzimin',
      'create_task': 'Krijo Detyrë',
      'update_task': 'Update Task',
      'delete_task': 'Fshi Detyrën',
      'approve_quote': 'Approve Quote',
      'off': 'Ndalur',
      'when_paid': 'When Paid',
      'expires_on': 'Expires On',
      'free': 'Falas',
      'plan': 'Plan',
      'show_sidebar': 'Show Sidebar',
      'hide_sidebar': 'Hide Sidebar',
      'event_type': 'Event Type',
      'target_url': 'Target',
      'copy': 'Copy',
      'must_be_online': 'Please restart the app once connected to the internet',
      'crons_not_enabled': 'The crons need to be enabled',
      'api_webhooks': 'API Webhooks',
      'search_webhooks': 'Search :count Webhooks',
      'search_webhook': 'Search 1 Webhook',
      'webhook': 'Webhook',
      'webhooks': 'Webhooks',
      'new_webhook': 'New Webhook',
      'edit_webhook': 'Edit Webhook',
      'created_webhook': 'Successfully created webhook',
      'updated_webhook': 'Successfully updated webhook',
      'archived_webhook': 'Successfully archived webhook',
      'deleted_webhook': 'Successfully deleted webhook',
      'removed_webhook': 'Successfully removed webhook',
      'restored_webhook': 'Successfully restored webhook',
      'archived_webhooks': 'Successfully archived :value webhooks',
      'deleted_webhooks': 'Successfully deleted :value webhooks',
      'removed_webhooks': 'Successfully removed :value webhooks',
      'restored_webhooks': 'Successfully restored :value webhooks',
      'api_tokens': 'API Tokenët',
      'api_docs': 'API Docs',
      'search_tokens': 'Search :count Tokens',
      'search_token': 'Search 1 Token',
      'token': 'Token',
      'tokens': 'Tokenët',
      'new_token': 'New Token',
      'edit_token': 'Edito Tokenin',
      'created_token': 'Tokeni është fshirë me sukses',
      'updated_token': 'Tokeni është perditesuar me sukses',
      'archived_token': 'Tokeni është arkivuar me sukses',
      'deleted_token': 'Tokeni është fshirë me sukses',
      'removed_token': 'Successfully removed token',
      'restored_token': 'Successfully restored token',
      'archived_tokens': 'Successfully archived :value tokens',
      'deleted_tokens': 'Successfully deleted :value tokens',
      'restored_tokens': 'Successfully restored :value tokens',
      'client_registration': 'Client Registration',
      'client_registration_help':
          'Enable clients to self register in the portal',
      'email_invoice': 'Dërgo faturën me email',
      'email_quote': 'Dërgo me email Ofertën',
      'email_credit': 'Email Credit',
      'email_payment': 'Email Payment',
      'client_email_not_set': 'Client does not have an email address set',
      'ledger': 'Ledger',
      'view_pdf': 'View PDF',
      'all_records': 'All records',
      'owned_by_user': 'Owned by user',
      'credit_remaining': 'Credit Remaining',
      'contact_name': 'Emri i Kontaktit',
      'use_default': 'Use default',
      'reminder_endless': 'Endless Reminders',
      'number_of_days': 'Number of days',
      'configure_payment_terms': 'Configure Payment Terms',
      'payment_term': 'Payment Term',
      'new_payment_term': 'New Payment Term',
      'edit_payment_term': 'Edito kushtet e pagesës',
      'created_payment_term': 'Successfully created payment term',
      'updated_payment_term': 'Successfully updated payment term',
      'archived_payment_term': 'Successfully archived payment term',
      'deleted_payment_term': 'Successfully deleted payment term',
      'removed_payment_term': 'Successfully removed payment term',
      'restored_payment_term': 'Successfully restored payment term',
      'archived_payment_terms': 'Successfully archived :value payment terms',
      'deleted_payment_terms': 'Successfully deleted :value payment terms',
      'restored_payment_terms': 'Successfully restored :value payment terms',
      'email_sign_in': 'Sign in with email',
      'change': 'Change',
      'change_to_mobile_layout': 'Change to the mobile layout?',
      'change_to_desktop_layout': 'Change to the desktop layout?',
      'send_from_gmail': 'Send from Gmail',
      'reversed': 'Reversed',
      'cancelled': 'Cancelled',
      'credit_amount': 'Shuma e kredituar',
      'quote_amount': 'Quote Amount',
      'hosted': 'Hosted',
      'selfhosted': 'Self-Hosted',
      'exclusive': 'Exclusive',
      'inclusive': 'Inclusive',
      'hide_menu': 'Hide Menu',
      'show_menu': 'Show Menu',
      'partially_refunded': 'Partially Refunded',
      'search_documents': 'Search Documents',
      'search_designs': 'Search Designs',
      'search_invoices': 'Search Invoices',
      'search_clients': 'Search Clients',
      'search_products': 'Search Products',
      'search_quotes': 'Search Quotes',
      'search_credits': 'Search Credits',
      'search_vendors': 'Search Vendors',
      'search_users': 'Search Users',
      'search_tax_rates': 'Search Tax Rates',
      'search_tasks': 'Search Tasks',
      'search_settings': 'Search Settings',
      'search_projects': 'Search Projects',
      'search_expenses': 'Search Expenses',
      'search_payments': 'Search Payments',
      'search_groups': 'Search Groups',
      'search_company': 'Search Company',
      'search_document': 'Search 1 Document',
      'search_design': 'Search 1 Design',
      'search_invoice': 'Search 1 Invoice',
      'search_client': 'Search 1 Client',
      'search_product': 'Search 1 Product',
      'search_quote': 'Search 1 Quote',
      'search_credit': 'Search 1 Credit',
      'search_vendor': 'Search 1 Vendor',
      'search_user': 'Search 1 User',
      'search_tax_rate': 'Search 1 Tax Rate',
      'search_task': 'Search 1 Tasks',
      'search_project': 'Search 1 Project',
      'search_expense': 'Search 1 Expense',
      'search_payment': 'Search 1 Payment',
      'search_group': 'Search 1 Group',
      'refund_payment': 'Rimburso pagesën',
      'cancelled_invoice': 'Successfully cancelled invoice',
      'cancelled_invoices': 'Successfully cancelled invoices',
      'reversed_invoice': 'Successfully reversed invoice',
      'reversed_invoices': 'Successfully reversed invoices',
      'reverse': 'Reverse',
      'full_name': 'Full Name',
      'city_state_postal': 'Qytet/Shtet/Poste',
      'postal_city_state': 'Postal/City/State',
      'custom1': 'First Custom',
      'custom2': 'Second Custom',
      'custom3': 'Third Custom',
      'custom4': 'Fourth Custom',
      'optional': 'Optional',
      'license': 'License',
      'purge_data': 'Purge Data',
      'purge_successful': 'Successfully purged company data',
      'purge_data_message':
          'Warning: This will permanently erase your data, there is no undo.',
      'invoice_balance': 'Invoice Balance',
      'age_group_0': '0 - 30 Days',
      'age_group_30': '30 - 60 Days',
      'age_group_60': '60 - 90 Days',
      'age_group_90': '90 - 120 Days',
      'age_group_120': '120+ Days',
      'refresh': 'Refresh',
      'saved_design': 'Successfully saved design',
      'client_details': 'Client Details',
      'company_address': 'Company Address',
      'invoice_details': 'Invoice Details',
      'quote_details': 'Quote Details',
      'credit_details': 'Credit Details',
      'product_columns': 'Product Columns',
      'task_columns': 'Task Columns',
      'add_field': 'Add Field',
      'all_events': 'All Events',
      'permissions': 'Lejet',
      'none': 'None',
      'owned': 'Owned',
      'payment_success': 'Payment Success',
      'payment_failure': 'Payment Failure',
      'invoice_sent': ':count invoice sent',
      'quote_sent': 'Quote Sent',
      'credit_sent': 'Credit Sent',
      'invoice_viewed': 'Invoice Viewed',
      'quote_viewed': 'Quote Viewed',
      'credit_viewed': 'Credit Viewed',
      'quote_approved': 'Quote Approved',
      'receive_all_notifications': 'Receive All Notifications',
      'purchase_license': 'Purchase License',
      'apply_license': 'Apply License',
      'cancel_account': 'Fshi llogarinë',
      'cancel_account_message':
          'Vërrejtje: Kjo do të fshijë të gjitha të dhënat tuaja, ky veprim nuk ka mundësi të kthehet mbrapa.',
      'delete_company': 'Delete Company',
      'delete_company_message':
          'Warning: This will permanently delete your company, there is no undo.',
      'enabled_modules': 'Enabled Modules',
      'converted_quote': 'Successfully converted quote',
      'credit_design': 'Credit Design',
      'includes': 'Includes',
      'header': 'Header',
      'load_design': 'Load Design',
      'css_framework': 'CSS Framework',
      'custom_designs': 'Custom Designs',
      'designs': 'Designs',
      'new_design': 'New Design',
      'edit_design': 'Edit Design',
      'created_design': 'Successfully created design',
      'updated_design': 'Successfully updated design',
      'archived_design': 'Successfully archived design',
      'deleted_design': 'Successfully deleted design',
      'removed_design': 'Successfully removed design',
      'restored_design': 'Successfully restored design',
      'archived_designs': 'Successfully archived :value designs',
      'deleted_designs': 'Successfully deleted :value designs',
      'restored_designs': 'Successfully restored :value designs',
      'proposals': 'Proposals',
      'tickets': 'Tickets',
      'recurring_quotes': 'Recurring Quotes',
      'recurring_tasks': 'Recurring Tasks',
      'account_management': 'Menaxhimi i llogarive',
      'credit_date': 'Data e kreditit',
      'credit': 'Kredi',
      'credits': 'Kredi',
      'new_credit': 'Vendos Kredi',
      'edit_credit': 'Edit Credit',
      'created_credit': 'Krediti është krijuar me sukses',
      'updated_credit': 'Successfully updated credit',
      'archived_credit': 'Krediti është arkivuar me sukses',
      'deleted_credit': 'Krediti është fshirë me sukses',
      'removed_credit': 'Successfully removed credit',
      'restored_credit': 'Krediti është rikhyer me sukses',
      'archived_credits': ':count kredite janë arkivuar me sukses',
      'deleted_credits': ':kredi janë fshirë me sukses',
      'restored_credits': 'Successfully restored :value credits',
      'current_version': 'Versioni aktual',
      'latest_version': 'Latest Version',
      'update_now': 'Update Now',
      'a_new_version_is_available': 'A new version of the web app is available',
      'update_available': 'Update Available',
      'app_updated': 'Update successfully completed',
      'learn_more': 'Mëso më shumë',
      'integrations': 'Integrations',
      'tracking_id': 'Tracking Id',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': 'Credit Footer',
      'credit_terms': 'Credit Terms',
      'new_company': 'Kompani e re',
      'added_company': 'Successfully added company',
      'company1': 'Custom Company 1',
      'company2': 'Custom Company 2',
      'company3': 'Custom Company 3',
      'company4': 'Custom Company 4',
      'product1': 'Custom Product 1',
      'product2': 'Custom Product 2',
      'product3': 'Custom Product 3',
      'product4': 'Custom Product 4',
      'client1': 'Custom Client 1',
      'client2': 'Custom Client 2',
      'client3': 'Custom Client 3',
      'client4': 'Custom Client 4',
      'contact1': 'Custom Contact 1',
      'contact2': 'Custom Contact 2',
      'contact3': 'Custom Contact 3',
      'contact4': 'Custom Contact 4',
      'task1': 'Custom Task 1',
      'task2': 'Custom Task 2',
      'task3': 'Custom Task 3',
      'task4': 'Custom Task 4',
      'project1': 'Custom Project 1',
      'project2': 'Custom Project 2',
      'project3': 'Custom Project 3',
      'project4': 'Custom Project 4',
      'expense1': 'Custom Expense 1',
      'expense2': 'Custom Expense 2',
      'expense3': 'Custom Expense 3',
      'expense4': 'Custom Expense 4',
      'vendor1': 'Custom Vendor 1',
      'vendor2': 'Custom Vendor 2',
      'vendor3': 'Custom Vendor 3',
      'vendor4': 'Custom Vendor 4',
      'invoice1': 'Custom Invoice 1',
      'invoice2': 'Custom Invoice 2',
      'invoice3': 'Custom Invoice 3',
      'invoice4': 'Custom Invoice 4',
      'payment1': 'Custom Payment 1',
      'payment2': 'Custom Payment 2',
      'payment3': 'Custom Payment 3',
      'payment4': 'Custom Payment 4',
      'surcharge1': 'Custom Surcharge 1',
      'surcharge2': 'Custom Surcharge 2',
      'surcharge3': 'Custom Surcharge 3',
      'surcharge4': 'Custom Surcharge 4',
      'group1': 'Custom Group 1',
      'group2': 'Custom Group 2',
      'group3': 'Custom Group 3',
      'group4': 'Custom Group 4',
      'reset': 'Reseto',
      'number': 'Number',
      'export': 'Export',
      'chart': 'Grafik',
      'count': 'Count',
      'totals': 'Totale',
      'blank': 'Bosh',
      'day': 'Dite',
      'month': 'Muaj',
      'year': 'Year',
      'subgroup': 'Subgroup',
      'is_active': 'Is Active',
      'group_by': 'Grupo sipas',
      'credit_balance': 'Bilanci i kreditit',
      'contact_last_login': 'Contact Last Login',
      'contact_full_name': 'Contact Full Name',
      'contact_phone': 'Contact Phone',
      'contact_custom_value1': 'Contact Custom Value 1',
      'contact_custom_value2': 'Contact Custom Value 2',
      'contact_custom_value3': 'Contact Custom Value 3',
      'contact_custom_value4': 'Contact Custom Value 4',
      'shipping_address1': 'Shipping Street',
      'shipping_address2': 'Shipping Apt/Suite',
      'shipping_city': 'Shipping City',
      'shipping_state': 'Shipping State/Province',
      'shipping_postal_code': 'Shipping Postal Code',
      'shipping_country': 'Shipping Country',
      'billing_address1': 'Billing Street',
      'billing_address2': 'Billing Apt/Suite',
      'billing_city': 'Billing City',
      'billing_state': 'Billing State/Province',
      'billing_postal_code': 'Billing Postal Code',
      'billing_country': 'Billing Country',
      'client_id': 'ID e klientit',
      'assigned_to': 'Assigned to',
      'created_by': 'Created by :name',
      'assigned_to_id': 'Assigned To Id',
      'created_by_id': 'Created By Id',
      'add_column': 'Add Column',
      'edit_columns': 'Edit Columns',
      'columns': 'Columns',
      'aging': 'Aging',
      'profit_and_loss': 'Profit and Loss',
      'reports': 'Raporte',
      'report': 'Raport',
      'add_company': 'Shto Kompani',
      'unpaid_invoice': 'Unpaid Invoice',
      'paid_invoice': 'Paid Invoice',
      'unapproved_quote': 'Unapproved Quote',
      'help': 'Ndihmë',
      'refund': 'Rimburso',
      'refund_date': 'Refund Date',
      'filtered_by': 'Filtered by',
      'contact_email': 'Contact Email',
      'multiselect': 'Multiselect',
      'entity_state': 'State',
      'verify_password': 'Verify Password',
      'applied': 'Applied',
      'include_recent_errors': 'Include recent errors from the logs',
      'your_message_has_been_received':
          'We have received your message and will try to respond promptly.',
      'message': 'Mesazhi',
      'from': 'Nga',
      'show_product_details': 'Show Product Details',
      'show_product_details_help':
          'Include the description and cost in the product dropdown',
      'pdf_min_requirements': 'The PDF renderer requires :version',
      'adjust_fee_percent': 'Adjust Fee Percent',
      'adjust_fee_percent_help': 'Adjust percent to account for fee',
      'configure_settings': 'Configure Settings',
      'support_forum': 'Support Forums',
      'about': 'About',
      'documentation': 'Dokumentim',
      'contact_us': 'Contact Us',
      'subtotal': 'Nëntotali',
      'line_total': 'Totali i linjës',
      'item': 'Njësi',
      'credit_email': 'Credit Email',
      'iframe_url': 'iFrame URL',
      'domain_url': 'Domain URL',
      'password_is_too_short': 'Password is too short',
      'password_is_too_easy':
          'Password must contain an upper case character and a number',
      'client_portal_tasks': 'Client Portal Tasks',
      'client_portal_dashboard': 'Client Portal Dashboard',
      'please_enter_a_value': 'Please enter a value',
      'deleted_logo': 'Successfully deleted logo',
      'yes': 'Po',
      'no': 'Jo',
      'generate_number': 'Generate Number',
      'when_saved': 'When Saved',
      'when_sent': 'When Sent',
      'select_company': 'Select Company',
      'float': 'Float',
      'collapse': 'Collapse',
      'show_or_hide': 'Show/hide',
      'menu_sidebar': 'Menu Sidebar',
      'history_sidebar': 'History Sidebar',
      'tablet': 'Tablet',
      'mobile': 'Mobile',
      'desktop': 'Desktop',
      'layout': 'Layout',
      'view': 'Shiko',
      'module': 'Module',
      'first_custom': 'First Custom',
      'second_custom': 'Second Custom',
      'third_custom': 'Third Custom',
      'show_cost': 'Show Cost',
      'show_product_cost': 'Show Product Cost',
      'show_cost_help':
          'Display a product cost field to track the markup/profit',
      'show_product_quantity': 'Show Product Quantity',
      'show_product_quantity_help':
          'Display a product quantity field, otherwise default to one',
      'show_invoice_quantity': 'Show Invoice Quantity',
      'show_invoice_quantity_help':
          'Display a line item quantity field, otherwise default to one',
      'show_product_discount': 'Show Product Discount',
      'show_product_discount_help': 'Display a line item discount field',
      'default_quantity': 'Default Quantity',
      'default_quantity_help':
          'Automatically set the line item quantity to one',
      'one_tax_rate': 'One Tax Rate',
      'two_tax_rates': 'Two Tax Rates',
      'three_tax_rates': 'Three Tax Rates',
      'default_tax_rate': 'Default Tax Rate',
      'user': 'Përdorues',
      'invoice_tax': 'Invoice Tax',
      'line_item_tax': 'Line Item Tax',
      'inclusive_taxes': 'Inclusive Taxes',
      'invoice_tax_rates': 'Invoice Tax Rates',
      'item_tax_rates': 'Item Tax Rates',
      'no_client_selected': 'Ju lutem zgjedhni një klient',
      'configure_rates': 'Configure rates',
      'configure_gateways': 'Configure Gateways',
      'tax_settings': 'Rregullimet e Taksave',
      'tax_settings_rates': 'Tax Rates',
      'accent_color': 'Accent Color',
      'switch': 'Kalo',
      'comma_sparated_list': 'Comma separated list',
      'options': 'Options',
      'single_line_text': 'Single-line text',
      'multi_line_text': 'Multi-line text',
      'dropdown': 'Dropdown',
      'field_type': 'Field Type',
      'recover_password_email_sent': 'A password recovery email has been sent',
      'submit': 'Submit',
      'recover_password': 'Riktheni fjalëkalimin tuaj',
      'late_fees': 'Late Fees',
      'credit_number': 'Credit Number',
      'payment_number': 'Payment Number',
      'late_fee_amount': 'Late Fee Amount',
      'late_fee_percent': 'Late Fee Percent',
      'before_due_date': 'Before the due date',
      'after_due_date': 'After the due date',
      'after_invoice_date': 'After the invoice date',
      'days': 'Days',
      'invoice_email': 'Emaili i Faturës',
      'payment_email': 'Emaili i Pagesës',
      'partial_payment': 'Partial Payment',
      'payment_partial': 'Partial Payment',
      'partial_payment_email': 'Partial Payment Email',
      'quote_email': 'Emaili i Ofertës',
      'endless_reminder': 'Endless Reminder',
      'filtered_by_user': 'Filtered by User',
      'administrator': 'Administrator',
      'administrator_help':
          'Lejon përdoruesit të menaxhoj përdoruesit, të ndryshojë rregullimet dhe të modifikojë të gjitha shënimet.',
      'user_management': 'Menaxhimi i përdoruesve',
      'users': 'Përdorues',
      'new_user': 'Përdorues i ri',
      'edit_user': 'Edito përdoruesin',
      'created_user': 'Successfully created user',
      'updated_user': 'Përdoruesi është perditesuar me sukses',
      'archived_user': 'Përdoruesi është arkivuar me sukses',
      'deleted_user': 'Përdoruesi është fshirë me sukses',
      'removed_user': 'Successfully removed user',
      'restored_user': 'Përdoruesi është rikthyer me sukses',
      'archived_users': 'Successfully archived :value users',
      'deleted_users': 'Successfully deleted :value users',
      'removed_users': 'Successfully removed :value users',
      'restored_users': 'Successfully restored :value users',
      'general_settings': 'Rregullimet Gjenerale',
      'invoice_options': 'Opsionet e faturës',
      'hide_paid_to_date': 'Fshihe Paguar deri më tash',
      'hide_paid_to_date_help':
          'Shfaqni \'Paguar deri më tash\' në faturat tuaja pasi të jetë pranuar pagesa.',
      'invoice_embed_documents': 'Embed Images/Documents',
      'invoice_embed_documents_help':
          'Include attached images/pdfs in the invoice.',
      'all_pages_header': 'Shfaqe Header',
      'all_pages_footer': 'Shfaqe Footer',
      'first_page': 'Faqja e parë',
      'all_pages': 'Të gjitha faqet',
      'last_page': 'Faqja e fundit',
      'primary_font': 'Primary Font',
      'secondary_font': 'Secondary Font',
      'primary_color': 'Ngjyra kryesore',
      'secondary_color': 'Ngjyra dytësore',
      'page_size': 'Madhësia e faqes',
      'font_size': 'Madhësia e fontit',
      'quote_design': 'Quote Design',
      'invoice_fields': 'Fushat e faturës',
      'product_fields': 'Product Fields',
      'invoice_terms': 'Kushtet e faturës',
      'invoice_footer': 'Footer i Faturës',
      'quote_terms': 'Kushtet e Ofertave',
      'quote_footer': 'Footer i Ofertës',
      'auto_email_invoice': 'Auto Email',
      'auto_email_invoice_help':
          'Automatically email recurring invoices when created.',
      'auto_archive_quote': 'Auto Archive',
      'auto_archive_quote_help':
          'Automatically archive quotes when converted to invoice.',
      'auto_convert_quote': 'Auto Convert',
      'auto_convert_quote_help':
          'Automatically convert a quote to an invoice when approved.',
      'workflow_settings': 'Workflow Settings',
      'freq_daily': 'Daily',
      'freq_weekly': 'Javore',
      'freq_two_weeks': 'Dy javore',
      'freq_four_weeks': 'Katër javore',
      'freq_monthly': 'Mujore',
      'freq_two_months': 'Two months',
      'freq_three_months': 'Tre mujore',
      'freq_four_months': 'Four months',
      'freq_six_months': 'Gjashtë mujore',
      'freq_annually': 'Vjetore',
      'freq_two_years': 'Two years',
      'freq_three_years': 'Three Years',
      'never': 'Asnjëherë',
      'company': 'Company',
      'generated_numbers': 'Generated Numbers',
      'charge_taxes': 'Vendos taksat',
      'next_reset': 'Next Reset',
      'reset_counter': 'Reset Counter',
      'recurring_prefix': 'Recurring Prefix',
      'number_padding': 'Number Padding',
      'general': 'General',
      'surcharge_field': 'Surcharge Field',
      'company_field': 'Company Field',
      'company_value': 'Company Value',
      'credit_field': 'Credit Field',
      'invoice_field': 'Invoice Field',
      'invoice_surcharge': 'Invoice Surcharge',
      'client_field': 'Client Field',
      'product_field': 'Product Field',
      'payment_field': 'Payment Field',
      'contact_field': 'Contact Field',
      'vendor_field': 'Vendor Field',
      'expense_field': 'Expense Field',
      'project_field': 'Project Field',
      'task_field': 'Task Field',
      'group_field': 'Group Field',
      'number_counter': 'Number Counter',
      'prefix': 'Prefiks',
      'number_pattern': 'Number Pattern',
      'messages': 'Messages',
      'custom_css': 'CSS i ndryshushëm',
      'custom_javascript': 'Custom JavaScript',
      'signature_on_pdf': 'Show on PDF',
      'signature_on_pdf_help':
          'Show the client signature on the invoice/quote PDF.',
      'show_accept_invoice_terms': 'Invoice Terms Checkbox',
      'show_accept_invoice_terms_help':
          'Require client to confirm that they accept the invoice terms.',
      'show_accept_quote_terms': 'Quote Terms Checkbox',
      'show_accept_quote_terms_help':
          'Require client to confirm that they accept the quote terms.',
      'require_invoice_signature': 'Invoice Signature',
      'require_invoice_signature_help':
          'Require client to provide their signature.',
      'require_quote_signature': 'Quote Signature',
      'enable_portal_password': 'Password Protect Invoices',
      'enable_portal_password_help':
          'Ju mundëson të vendosni fjalëkalim për secilin kontakt. Nëse vendoset fjalëkalimi, kontakti duhet të vendos fjalëkalimin para se t\'i sheh faturat.',
      'authorization': 'Authorization',
      'subdomain': 'Subdomain',
      'domain': 'Domain',
      'portal_mode': 'Portal Mode',
      'email_signature': 'Përshëndetje',
      'enable_email_markup_help':
          'Bëjeni më të lehtë për klientët tuaj të realizojnë pagesat duke vendosur schema.org markimin në emailat tuaj.',
      'plain': 'E thjeshtë',
      'light': 'E lehtë',
      'dark': 'E mbylltë',
      'email_design': 'Dizajno emailin',
      'attach_pdf': 'Attach PDF',
      'attach_documents': 'Attach Documents',
      'attach_ubl': 'Attach UBL/E-Invoice',
      'email_style': 'Email Style',
      'enable_email_markup': 'Aktivizo Markimin',
      'reply_to_email': 'Reply-To Email',
      'reply_to_name': 'Reply-To Name',
      'bcc_email': 'BCC Email',
      'processed': 'Processed',
      'credit_card': 'Kredit kartë',
      'bank_transfer': 'Transfer bankar',
      'priority': 'Priority',
      'fee_amount': 'Fee Amount',
      'fee_percent': 'Fee Percent',
      'fee_cap': 'Fee Cap',
      'limits_and_fees': 'Limits/Fees',
      'enable_min': 'Aktivizo min',
      'enable_max': 'Aktivizo max',
      'min_limit': 'Min: :min',
      'max_limit': 'Max: :max',
      'min': 'Min',
      'max': 'Max',
      'accepted_card_logos': 'Accepted Card Logos',
      'credentials': 'Credentials',
      'update_address': 'Perditeso Adresën',
      'update_address_help':
          'Perditeso adresën e klientit me detajet e ofruara',
      'rate': 'Norma',
      'tax_rate': 'Norma e taksave',
      'new_tax_rate': 'Normë e re e taksave',
      'edit_tax_rate': 'Edito normën e taksës',
      'created_tax_rate': 'Norma e taksës është krijuar me sukses',
      'updated_tax_rate': 'Norma e taksës është perditesuar me sukses',
      'archived_tax_rate': 'Norma e taksës është arkivuar me sukses',
      'deleted_tax_rate': 'Successfully deleted tax rate',
      'restored_tax_rate': 'Successfully restored tax rate',
      'archived_tax_rates': 'Successfully archived :value tax rates',
      'deleted_tax_rates': 'Successfully deleted :value tax rates',
      'restored_tax_rates': 'Successfully restored :value tax rates',
      'fill_products': 'Plotëso-automatikisht produktet',
      'fill_products_help':
          'Duke zgjedhur produktin, automatikisht do të plotësohen fill in the description and cost',
      'update_products': 'Perditeso-automatikisht produktet',
      'update_products_help':
          'Perditesimi i faturës automatikisht do të perditesoje librarine e produktit',
      'convert_products': 'Convert Products',
      'convert_products_help':
          'Automatically convert product prices to the client\'s currency',
      'fees': 'Fees',
      'limits': 'Limits',
      'provider': 'Provider',
      'company_gateway': 'Payment Gateway',
      'company_gateways': 'Payment Gateways',
      'new_company_gateway': 'New Gateway',
      'edit_company_gateway': 'Edit Gateway',
      'created_company_gateway': 'Successfully created gateway',
      'updated_company_gateway': 'Successfully updated gateway',
      'archived_company_gateway': 'Successfully archived gateway',
      'deleted_company_gateway': 'Successfully deleted gateway',
      'restored_company_gateway': 'Successfully restored gateway',
      'archived_company_gateways': 'Successfully archived :value gateways',
      'deleted_company_gateways': 'Successfully deleted :value gateways',
      'restored_company_gateways': 'Successfully restored :value gateways',
      'continue_editing': 'Continue Editing',
      'discard_changes': 'Discard Changes',
      'default_value': 'Default value',
      'disabled': 'E ç\'aktivizuar',
      'currency_format': 'Currency Format',
      'first_day_of_the_week': 'First Day of the Week',
      'first_month_of_the_year': 'First Month of the Year',
      'sunday': 'E diel',
      'monday': 'E hënë',
      'tuesday': 'E marte',
      'wednesday': 'E mërkure',
      'thursday': 'E enjëte',
      'friday': 'E premte',
      'saturday': 'E shtune',
      'january': 'Janar',
      'february': 'Shkurt',
      'march': 'Mars',
      'april': 'Prill',
      'may': 'Maj',
      'june': 'Qershor',
      'july': 'Korrik',
      'august': 'Gusht',
      'september': 'Shtator',
      'october': 'Tetor',
      'november': 'Nëntor',
      'december': 'Dhjetor',
      'symbol': 'Symbol',
      'ocde': 'Code',
      'date_format': 'Date Format',
      'datetime_format': 'Datetime Format',
      'military_time': 'Koha 24 orëshe',
      'military_time_help': '24 Hour Display',
      'send_reminders': 'Send Reminders',
      'timezone': 'Timezone',
      'filtered_by_project': 'Filtered by Project',
      'filtered_by_group': 'Filtered by Group',
      'filtered_by_invoice': 'Filtered by Invoice',
      'filtered_by_client': 'Filtered by Client',
      'filtered_by_vendor': 'Filtered by Vendor',
      'group_settings': 'Group Settings',
      'group': 'Group',
      'groups': 'Groups',
      'new_group': 'New Group',
      'edit_group': 'Edit Group',
      'created_group': 'Successfully created group',
      'updated_group': 'Successfully updated group',
      'archived_groups': 'Successfully archived :value groups',
      'deleted_groups': 'Successfully deleted :value groups',
      'restored_groups': 'Successfully restored :value groups',
      'archived_group': 'Successfully archived group',
      'deleted_group': 'Successfully deleted group',
      'restored_group': 'Successfully restored group',
      'upload_logo': 'Upload Your Company Logo',
      'uploaded_logo': 'Successfully uploaded logo',
      'logo': 'Logo',
      'saved_settings': 'Successfully saved settings',
      'product_settings': 'Rregullimi i Produktit',
      'device_settings': 'Device Settings',
      'defaults': 'Të paracaktuara',
      'basic_settings': 'Rregullimet bazike',
      'advanced_settings': 'Rregullimi i Avansuar',
      'company_details': 'Detajet e kompanisë',
      'user_details': 'Detajet e përdoruesit',
      'localization': 'Vendore',
      'online_payments': 'Pagesat Online',
      'tax_rates': 'Normat e taksave',
      'notifications': 'Njoftimet',
      'import_export': 'Import | Export',
      'custom_fields': 'Fushat e ndryshueshme',
      'invoice_design': 'Dizajni i Faturës',
      'buy_now_buttons': 'Butonat Blej Tash',
      'email_settings': 'Rregullimi i Emailit',
      'templates_and_reminders': 'Shabllonet & Përkujtueset',
      'credit_cards_and_banks': 'Credit Cards & Banks',
      'data_visualizations': 'Vizualizimi i të dhënave',
      'price': 'Price',
      'email_sign_up': 'Email Sign Up',
      'google_sign_up': 'Google Sign Up',
      'thank_you_for_your_purchase': 'Thank you for your purchase!',
      'redeem': 'Redeem',
      'back': 'Back',
      'past_purchases': 'Past Purchases',
      'annual_subscription': 'Annual Subscription',
      'pro_plan': 'Pro Plan',
      'enterprise_plan': 'Enterprise Plan',
      'count_users': ':count users',
      'upgrade': 'Upgrade',
      'please_enter_a_first_name': 'Please enter a first name',
      'please_enter_a_last_name': 'Please enter a last name',
      'please_agree_to_terms_and_privacy':
          'Please agree to the terms of service and privacy policy to create an account.',
      'i_agree_to_the': 'I agree to the',
      'terms_of_service': 'Kushtet e shërbimit',
      'privacy_policy': 'Politika e Privatësisë',
      'sign_up': 'Regjistrohu',
      'account_login': 'Hyrja me llogari',
      'view_website': 'View Website',
      'create_account': 'Create Account',
      'email_login': 'Email Login',
      'create_new': 'Krijo',
      'no_record_selected': 'No record selected',
      'error_unsaved_changes': 'Please save or cancel your changes',
      'download': 'Shkarko',
      'requires_an_enterprise_plan': 'Requires an Enterprise Plan',
      'take_picture': 'Take Picture',
      'upload_files': 'Upload Files',
      'document': 'Document',
      'documents': 'Dokumente',
      'new_document': 'New Document',
      'edit_document': 'Edit Document',
      'uploaded_document': 'Successfully uploaded document',
      'updated_document': 'Successfully updated document',
      'archived_document': 'Successfully archived document',
      'deleted_document': 'Successfully deleted document',
      'restored_document': 'Successfully restored document',
      'archived_documents': 'Successfully archived :value documents',
      'deleted_documents': 'Successfully deleted :value documents',
      'restored_documents': 'Successfully restored :value documents',
      'no_history': 'No History',
      'expense_date': 'Data e shpenzimit',
      'pending': 'Në pritje',
      'expense_status_1': 'Logged',
      'expense_status_2': 'Pending',
      'expense_status_3': 'Invoiced',
      'converted': 'Konvertuar',
      'add_documents_to_invoice': 'Add Documents to Invoice',
      'exchange_rate': 'Kursi i këmbimit',
      'convert_currency': 'Konverto valutën',
      'mark_paid': 'Mark Paid',
      'category': 'Kategoria',
      'address': 'Adresa',
      'new_vendor': 'Kompani e re',
      'created_vendor': 'Kompania është krijuar me sukses',
      'updated_vendor': 'Kompania është perditesuar me sukses',
      'archived_vendor': 'Kompania është arkivuar me sukses',
      'deleted_vendor': 'Kompania është fshirë me sukses',
      'restored_vendor': 'Kompania u rikthye me sukses',
      'archived_vendors': ':counts kompani janë arkivuar me sukses',
      'deleted_vendors': ':count kompani janë fshirë me sukses',
      'restored_vendors': 'Successfully restored :value vendors',
      'new_expense': 'Enter Expense',
      'created_expense': 'Shpenzimi është krijuar me sukses',
      'updated_expense': 'Shpenzimi është perditesuar me sukses',
      'archived_expense': 'Shpenzimi është arkivuar me sukses',
      'deleted_expense': 'Shpenzimi është fshirë me sukses',
      'restored_expense': 'Shpenzimet janë rikthyer me sukses',
      'archived_expenses': 'Shpenzimet janë arkivuar me sukses',
      'deleted_expenses': 'Shpenzimet janë fshirë me sukses',
      'restored_expenses': 'Successfully restored :value expenses',
      'copy_shipping': 'Copy Shipping',
      'copy_billing': 'Copy Billing',
      'design': 'Design',
      'failed_to_find_record': 'Failed to find record',
      'invoiced': 'Faturuar',
      'logged': 'Regjistruar',
      'running': 'Duke ndodhur',
      'resume': 'Vazhdo',
      'task_errors': 'Ju lutem korrigjoni kohët e vendosura mbi njëra-tjetrën',
      'start': 'Fillo',
      'stop': 'Ndalo',
      'started_task': 'Successfully started task',
      'stopped_task': 'Detyra është ndaluar me sukses',
      'resumed_task': 'Successfully resumed task',
      'now': 'Tash',
      'auto_start_tasks': 'Auto Start Tasks',
      'timer': 'Kohëmatësi',
      'manual': 'Manual',
      'budgeted': 'Budgeted',
      'start_time': 'Koha e fillimit',
      'end_time': 'Koha e përfundimit',
      'date': 'Data',
      'times': 'Kohët',
      'duration': 'Kohëzgjatja',
      'new_task': 'Detyrë e re',
      'created_task': 'Detyra u krijua me sukses',
      'updated_task': 'Detyra është perditesuar me sukses',
      'archived_task': 'Detyra është arkivuar me sukses',
      'deleted_task': 'Detyra është fshirë me sukses',
      'restored_task': 'Detyra është rikthyer me sukses',
      'archived_tasks': ':count detyra janë arkivuar me sukses',
      'deleted_tasks': ':count detyra janë fshirë me sukses',
      'restored_tasks': 'Successfully restored :value tasks',
      'please_enter_a_name': 'Please enter a name',
      'budgeted_hours': 'Budgeted Hours',
      'created_project': 'Successfully created project',
      'updated_project': 'Successfully updated project',
      'archived_project': 'Successfully archived project',
      'deleted_project': 'Successfully deleted project',
      'restored_project': 'Successfully restored project',
      'archived_projects': 'Successfully archived :count projects',
      'deleted_projects': 'Successfully deleted :count projects',
      'restored_projects': 'Successfully restored :value projects',
      'new_project': 'New Project',
      'thank_you_for_using_our_app': 'Thank you for using our app!',
      'if_you_like_it': 'If you like it please',
      'click_here': 'kliko këtu',
      'click_here_capital': 'Click here',
      'to_rate_it': 'to rate it.',
      'average': 'Average',
      'unapproved': 'Unapproved',
      'authenticate_to_change_setting':
          'Please authenticate to change this setting',
      'locked': 'Locked',
      'authenticate': 'Authenticate',
      'please_authenticate': 'Please authenticate',
      'biometric_authentication': 'Biometric Authentication',
      'footer': 'Footer',
      'compare': 'Compare',
      'hosted_login': 'Hosted Login',
      'selfhost_login': 'Selfhost Login',
      'google_sign_in': 'Sign in with Google',
      'today': 'Today',
      'custom_range': 'Custom Range',
      'date_range': 'Shtrirja e Dates',
      'current': 'Current',
      'previous': 'Previous',
      'current_period': 'Current Period',
      'comparison_period': 'Comparison Period',
      'previous_period': 'Previous Period',
      'previous_year': 'Previous Year',
      'compare_to': 'Compare to',
      'last7_days': 'Last 7 Days',
      'last_week': 'Last Week',
      'last30_days': 'Last 30 Days',
      'this_month': 'This Month',
      'last_month': 'Last Month',
      'this_year': 'This Year',
      'last_year': 'Last Year',
      'all_time': 'All Time',
      'custom': 'E ndryshueshme',
      'clone_to_invoice': 'Clone to Invoice',
      'clone_to_quote': 'Clone to Quote',
      'clone_to_credit': 'Clone to Credit',
      'view_invoice': 'Shiko Faturën',
      'convert': 'Convert',
      'more': 'More',
      'edit_client': 'Edito klientin',
      'edit_product': 'Edito produkt',
      'edit_invoice': 'Edito Faturën',
      'edit_quote': 'Edito Ofertën',
      'edit_payment': 'Edito Pagesën',
      'edit_task': 'Edito Detyrën',
      'edit_expense': 'Edito shpenzimi',
      'edit_vendor': 'Edito kompaninë',
      'edit_project': 'Edit Project',
      'edit_recurring_quote': 'Edit Recurring Quote',
      'billing_address': 'Adresa e faturimit',
      'shipping_address': 'Shipping Address',
      'total_revenue': 'Totali i Qarkullimit',
      'average_invoice': 'Mesatarja e faturës',
      'outstanding': 'Pa paguar1',
      'invoices_sent': ':count invoices sent',
      'active_clients': 'klientë aktiv',
      'close': 'Mbyll',
      'email': 'Emaili',
      'password': 'Fjalëkalimi',
      'url': 'URL',
      'secret': 'Sekret',
      'name': 'Emri',
      'logout': 'Ç\'identifikohu',
      'login': 'Identifikohu',
      'filter': 'Filtro',
      'sort': 'Sort',
      'search': 'Kërko',
      'active': 'Aktiv',
      'archived': 'Arkivuar',
      'deleted': 'E fshirë',
      'dashboard': 'Paneli',
      'archive': 'Arkivo',
      'delete': 'Fshi',
      'restore': 'Rikthe',
      'refresh_complete': 'Refresh Complete',
      'please_enter_your_email': 'Please enter your email',
      'please_enter_your_password': 'Please enter your password',
      'please_enter_your_url': 'Please enter your URL',
      'please_enter_a_product_key': 'Please enter a product key',
      'ascending': 'Ascending',
      'descending': 'Descending',
      'save': 'Ruaj',
      'an_error_occurred': 'An error occurred',
      'paid_to_date': 'Paguar deri më sot',
      'balance_due': 'Bilanci aktual',
      'balance': 'Bilanci',
      'overview': 'Overview',
      'details': 'Detajet',
      'phone': 'Telefoni',
      'website': 'Website',
      'vat_number': 'Numri i TVSH',
      'id_number': 'ID numri',
      'create': 'Krijo',
      'copied_to_clipboard': 'Copied :value to the clipboard',
      'error': 'Error',
      'could_not_launch': 'Could not launch',
      'contacts': 'Kontaktet',
      'additional': 'Additional',
      'first_name': 'Emri',
      'last_name': 'Mbiemri',
      'add_contact': 'Shto kontaktin',
      'are_you_sure': 'A jeni të sigurtë',
      'cancel': 'Anulo',
      'ok': 'Ok',
      'remove': 'Largo',
      'email_is_invalid': 'Email is invalid',
      'product': 'Produkt',
      'products': 'Produktet',
      'new_product': 'Produkt i ri',
      'created_product': 'Produkti është krijuar me sukses',
      'updated_product': 'Produkti është perditesuar me sukses',
      'archived_product': 'Produkti është arkivuar me sukses',
      'deleted_product': 'Successfully deleted product',
      'restored_product': 'Successfully restored product',
      'archived_products': 'Successfully archived :count products',
      'deleted_products': 'Successfully deleted :count products',
      'restored_products': 'Successfully restored :value products',
      'product_key': 'Produkt',
      'notes': 'Shënime',
      'cost': 'Kosto',
      'client': 'Klient',
      'clients': 'Klientët',
      'new_client': 'Klient i ri',
      'created_client': 'Klienti është krijuar me sukses',
      'updated_client': 'Klienti është perditesuar me sukses',
      'archived_client': 'Klienti është arkivuar me sukses',
      'archived_clients': ':count klientë janë arkivuar me sukses',
      'deleted_client': 'Klienti është fshirë me sukses',
      'deleted_clients': ':count klientë janë fshirë me sukses',
      'restored_client': 'Klienti është rikthyer me sukses',
      'restored_clients': 'Successfully restored :value clients',
      'address1': 'Rruga',
      'address2': 'Apartamenti/banesa',
      'city': 'Qyteti',
      'state': 'Shteti/Provinca',
      'postal_code': 'Kodi postar',
      'country': 'Shteti',
      'invoice': 'Fatura',
      'invoices': 'Faturat',
      'new_invoice': 'Faturë e re',
      'created_invoice': 'Fatura është krijuar me sukses',
      'updated_invoice': 'Fatura është perditesuar me sukses',
      'archived_invoice': 'Fatura është arkivuar me sukses',
      'deleted_invoice': 'Fatura është fshirë me sukses',
      'restored_invoice': 'Fatura është rikthyer me sukses',
      'archived_invoices': ':count fatura janë arkivuar me sukes',
      'deleted_invoices': ':count fatura janë fshirë me sukses',
      'restored_invoices': 'Successfully restored :value invoices',
      'emailed_invoice': 'Fatura është dërguar me sukses me email',
      'emailed_payment': 'Successfully emailed payment',
      'amount': 'Shuma',
      'invoice_number': 'Numri i faturës',
      'invoice_date': 'Data e faturës',
      'discount': 'Zbritje',
      'po_number': 'Numri UB',
      'terms': 'Kushtet',
      'public_notes': 'Shënime publike',
      'private_notes': 'Shënime private',
      'frequency': 'Frekuenca',
      'start_date': 'Data e fillimit',
      'end_date': 'Data e përfundimit',
      'quote_number': 'Numri i ofertës',
      'quote_date': 'Data e Ofertës',
      'valid_until': 'Valide deri',
      'items': 'Items',
      'partial_deposit': 'Partial/Deposit',
      'description': 'Përshkrimi',
      'unit_cost': 'Kosto për njësi',
      'quantity': 'Sasia',
      'add_item': 'Add Item',
      'contact': 'Kontakt',
      'work_phone': 'Telefoni',
      'total_amount': 'Total Amount',
      'pdf': 'PDF',
      'due_date': 'Deri më datë',
      'partial_due_date': 'Partial Due Date',
      'paid_date': 'Paid Date',
      'status': 'Statusi',
      'invoice_status_id': 'Invoice Status',
      'quote_status': 'Quote Status',
      'click_plus_to_add_item': 'Click + to add an item',
      'click_plus_to_add_time': 'Click + to add time',
      'count_selected': ':count selected',
      'total': 'Totali',
      'percent': 'Percent',
      'edit': 'Edito',
      'dismiss': 'Dismiss',
      'please_select_a_date': 'Please select a date',
      'please_select_a_client': 'Please select a client',
      'please_select_an_invoice': 'Please select an invoice',
      'task_rate': 'Task Rate',
      'settings': 'Rregullimet',
      'language': 'Language',
      'currency': 'Currency',
      'created_at': 'Date Created',
      'created_on': 'Created On',
      'updated_at': 'Updated',
      'tax': 'Taksë',
      'please_enter_an_invoice_number': 'Please enter an invoice number',
      'please_enter_a_quote_number': 'Please enter a quote number',
      'past_due': 'Past Due',
      'draft': 'Draft',
      'sent': 'Dërguar',
      'viewed': 'Viewed',
      'approved': 'Approved',
      'partial': 'E pjesshme/depozite',
      'paid': 'Paguar',
      'mark_sent': 'Shenja është dërguar',
      'marked_invoice_as_sent': 'Successfully marked invoice as sent',
      'marked_invoice_as_paid': 'Successfully marked invoice as paid',
      'marked_invoices_as_sent': 'Successfully marked invoices as sent',
      'marked_invoices_as_paid': 'Successfully marked invoices as paid',
      'done': 'Përfundo',
      'please_enter_a_client_or_contact_name':
          'Please enter a client or contact name',
      'dark_mode': 'Modeli i errët',
      'restart_app_to_apply_change': 'Restart the app to apply the change',
      'refresh_data': 'Refresh Data',
      'blank_contact': 'Blank Contact',
      'activity': 'Aktiviteti',
      'no_records_found': 'No records found',
      'clone': 'Klono',
      'loading': 'Loading',
      'industry': 'Industry',
      'size': 'Size',
      'payment_terms': 'Kushtet e pagesës',
      'payment_date': 'Data e pagesës',
      'payment_status': 'Payment Status',
      'payment_status_1': 'Pending',
      'payment_status_2': 'Voided',
      'payment_status_3': 'Failed',
      'payment_status_4': 'Completed',
      'payment_status_5': 'Partially Refunded',
      'payment_status_6': 'Refunded',
      'payment_status_-1': 'Unapplied',
      'payment_status_-2': 'Partially Unapplied',
      'net': 'Net',
      'client_portal': 'Portali i klientit',
      'show_tasks': 'Show tasks',
      'email_reminders': 'Email Reminders',
      'enabled': 'Aktivizuar',
      'recipients': 'Recipients',
      'initial_email': 'Initial Email',
      'first_reminder': 'Përkujtuesi i parë',
      'second_reminder': 'Përkujtuesi i dytë',
      'third_reminder': 'Përkujtuesi i tretë',
      'reminder1': 'First Reminder',
      'reminder2': 'Second Reminder',
      'reminder3': 'Third Reminder',
      'template': 'Template',
      'send': 'Send',
      'subject': 'Tema',
      'body': 'Përmbajtja',
      'send_email': 'Dërgo email',
      'email_receipt': 'Dërgo fletëpagesën tek klienti me email',
      'auto_billing': 'Auto billing',
      'button': 'Button',
      'preview': 'Parashiko',
      'customize': 'Ndrysho',
      'history': 'Historia',
      'payment': 'Pagesa',
      'payments': 'Pagesat',
      'refunded': 'Refunded',
      'payment_type': 'Lloji i pagesës',
      'transaction_reference': 'Referenca e transaksionit',
      'enter_payment': 'Cakto pagesën',
      'new_payment': 'Cakto pagesën',
      'created_payment': 'Pagesa është krijuar me sukses',
      'updated_payment': 'Pagesa është perditesuar me sukses',
      'archived_payment': 'Pagesa është arkivuar me sukses',
      'deleted_payment': 'Pagesa është fshirë me sukses',
      'restored_payment': 'Pagesa është rikthyer me sukses',
      'archived_payments': ':count pagesa janë arkivuar me sukses',
      'deleted_payments': ':count pagesa janë fshirë me sukses',
      'restored_payments': 'Successfully restored :value payments',
      'quote': 'Ofertë',
      'quotes': 'Oferta',
      'new_quote': 'Ofertë e re',
      'created_quote': 'Oferta është krijuar me sukses',
      'updated_quote': 'Oferta është perditesuar me sukses',
      'archived_quote': 'Oferta është arkivuar me sukses',
      'deleted_quote': 'Oferta është fshirë me sukses',
      'restored_quote': 'Oferta është rikthyer me sukses',
      'archived_quotes': ': count oferta janë arkivuar me sukses',
      'deleted_quotes': ':count oferta janë fshirë me sukses',
      'restored_quotes': 'Successfully restored :value quotes',
      'expense': 'Shpenzimet',
      'expenses': 'Shpenzimet',
      'vendor': 'Kompani',
      'vendors': 'Kompanitë',
      'task': 'Detyre',
      'tasks': 'Detyrat',
      'project': 'Project',
      'projects': 'Projects',
      'activity_1': ':user ka krijuar klientin :client',
      'activity_2': ':user ka arkivuar klientin :client',
      'activity_3': ':user ka fshirë klientin :client',
      'activity_4': ':user ka krijuar faturën :invoice',
      'activity_5': ':user ka perditesuar faturën :invoice',
      'activity_6': ':user emailed invoice :invoice for :client to :contact',
      'activity_7': ':contact viewed invoice :invoice for :client',
      'activity_8': ':user ka arkivuar faturën :invoice',
      'activity_9': ':user ka fshirë faturën :invoice',
      'activity_10':
          ':user entered payment :payment for :payment_amount on invoice :invoice for :client',
      'activity_11': ':user ka perditesuar pagesën :payment',
      'activity_12': ':user ka arkivuar pagesën :payment',
      'activity_13': ':user ka fshirë pagesën :payment',
      'activity_14': ':user ka shtuar :credit kredit',
      'activity_15': ':user ka perditesuar :credit kredit',
      'activity_16': ':user ka arkivuar :credit kredit',
      'activity_17': ':user ka fshirë:credit kredit',
      'activity_18': ':user ka krijuar ofertë :quote',
      'activity_19': ':user ka perditesuar ofertën :quote',
      'activity_20': ':user emailed quote :quote for :client to :contact',
      'activity_21': ':contact ka shikuar ofertën :quote',
      'activity_22': ':user ka arkivuar ofertën :quote',
      'activity_23': ':user ka fshirë ofertën :quote',
      'activity_24': ':user ka rikthyer ofertën :quote',
      'activity_25': ':user ka rikthyer faturën :invoice',
      'activity_26': ':user ka rikthyer klientin :client',
      'activity_27': ':user ka rikthyer pagesën :payment',
      'activity_28': ':user ka rikthyer :credit kredit',
      'activity_29': ':contact approved quote :quote for :client',
      'activity_30': ':user created vendor :vendor',
      'activity_31': ':user archived vendor :vendor',
      'activity_32': ':user deleted vendor :vendor',
      'activity_33': ':user restored vendor :vendor',
      'activity_34': ':user ka krijuar shpeznim :expense',
      'activity_35': ':user archived expense :expense',
      'activity_36': ':user deleted expense :expense',
      'activity_37': ':user restored expense :expense',
      'activity_39': ':user cancelled a :payment_amount payment :payment',
      'activity_40':
          ':user refunded :adjustment of a :payment_amount payment :payment',
      'activity_41': ':payment_amount payment (:payment) ka dështuar',
      'activity_42': ':user created task :task',
      'activity_43': ':user updated task :task',
      'activity_44': ':user archived task :task',
      'activity_45': ':user deleted task :task',
      'activity_46': ':user restored task :task',
      'activity_47': ':user updated expense :expense',
      'activity_48': ':user created user :user',
      'activity_49': ':user updated user :user',
      'activity_50': ':user archived user :user',
      'activity_51': ':user deleted user :user',
      'activity_52': ':user restored user :user',
      'activity_53': ':user marked sent :invoice',
      'activity_54': ':user paid invoice :invoice',
      'activity_55': ':contact replied ticket :ticket',
      'activity_56': ':user viewed ticket :ticket',
      'activity_57': 'System failed to email invoice :invoice',
      'activity_58': ':user reversed invoice :invoice',
      'activity_59': ':user cancelled invoice :invoice',
      'activity_60': ':contact viewed quote :quote',
      'activity_61': ':user updated client :client',
      'activity_62': ':user updated vendor :vendor',
      'activity_63':
          ':user emailed first reminder for invoice :invoice to :contact',
      'activity_64':
          ':user emailed second reminder for invoice :invoice to :contact',
      'activity_65':
          ':user emailed third reminder for invoice :invoice to :contact',
      'activity_66':
          ':user emailed endless reminder for invoice :invoice to :contact',
      'activity_80': ':user created subscription :subscription',
      'activity_81': ':user updated subscription :subscription',
      'activity_82': ':user archived subscription :subscription',
      'activity_83': ':user deleted subscription :subscription',
      'activity_84': ':user restored subscription :subscription',
      'one_time_password': 'One Time Password',
      'emailed_quote': 'Oferta është dërguar me sukses me email',
      'emailed_credit': 'Successfully emailed credit',
      'marked_quote_as_sent': 'Successfully marked quote as sent',
      'marked_credit_as_sent': 'Successfully marked credit as sent',
      'expired': 'Skaduar',
      'all': 'Të gjitha',
      'select': 'Selekto',
      'long_press_multiselect': 'Long-press Multiselect',
      'custom_value1': 'Custom Value 1',
      'custom_value2': 'Custom Value 2',
      'custom_value3': 'Custom Value 3',
      'custom_value4': 'Custom Value 4',
      'email_style_custom': 'Custom Email Style',
      'custom_message_dashboard': 'Custom Dashboard Message',
      'custom_message_unpaid_invoice': 'Custom Unpaid Invoice Message',
      'custom_message_paid_invoice': 'Custom Paid Invoice Message',
      'custom_message_unapproved_quote': 'Custom Unapproved Quote Message',
      'lock_invoices': 'Lock Invoices',
      'translations': 'Translations',
      'task_number_pattern': 'Task Number Pattern',
      'task_number_counter': 'Task Number Counter',
      'expense_number_pattern': 'Expense Number Pattern',
      'expense_number_counter': 'Expense Number Counter',
      'vendor_number_pattern': 'Vendor Number Pattern',
      'vendor_number_counter': 'Vendor Number Counter',
      'ticket_number_pattern': 'Ticket Number Pattern',
      'ticket_number_counter': 'Ticket Number Counter',
      'payment_number_pattern': 'Payment Number Pattern',
      'payment_number_counter': 'Payment Number Counter',
      'invoice_number_pattern': 'Invoice Number Pattern',
      'invoice_number_counter': 'Numruesi i numrit të faturës',
      'quote_number_pattern': 'Quote Number Pattern',
      'quote_number_counter': 'Numruesi i numrit të ofertës',
      'client_number_pattern': 'Credit Number Pattern',
      'client_number_counter': 'Credit Number Counter',
      'credit_number_pattern': 'Credit Number Pattern',
      'credit_number_counter': 'Credit Number Counter',
      'reset_counter_date': 'Reset Counter Date',
      'counter_padding': 'Counter Padding',
      'shared_invoice_quote_counter': 'Share Invoice/Quote Counter',
      'default_tax_name_1': 'Default Tax Name 1',
      'default_tax_rate_1': 'Default Tax Rate 1',
      'default_tax_name_2': 'Default Tax Name 2',
      'default_tax_rate_2': 'Default Tax Rate 2',
      'default_tax_name_3': 'Default Tax Name 3',
      'default_tax_rate_3': 'Default Tax Rate 3',
      'email_subject_invoice': 'Email Invoice Subject',
      'email_subject_quote': 'Email Quote Subject',
      'email_subject_payment': 'Email Payment Subject',
      'email_subject_payment_partial': 'Email Partial Payment Subject',
      'show_table': 'Show Table',
      'show_list': 'Show List',
      'client_city': 'Client City',
      'client_state': 'Client State',
      'client_country': 'Client Country',
      'client_is_active': 'Client is Active',
      'client_balance': 'Client Balance',
      'client_address1': 'Client Street',
      'client_address2': 'Client Apt/Suite',
      'vendor_address1': 'Vendor Street',
      'vendor_address2': 'Vendor Apt/Suite',
      'client_shipping_address1': 'Client Shipping Street',
      'client_shipping_address2': 'Client Shipping Apt/Suite',
      'type': 'Shkruaj',
      'invoice_amount': 'Shuma e faturës',
      'invoice_due_date': 'Deri më datë',
      'tax_rate1': 'Tax Rate 1',
      'tax_rate2': 'Tax Rate 2',
      'tax_rate3': 'Tax Rate 3',
      'auto_bill': 'Faturo Automatikisht',
      'archived_at': 'Archived At',
      'has_expenses': 'Has Expenses',
      'custom_taxes1': 'Custom Taxes 1',
      'custom_taxes2': 'Custom Taxes 2',
      'custom_taxes3': 'Custom Taxes 3',
      'custom_taxes4': 'Custom Taxes 4',
      'custom_surcharge1': 'Custom Surcharge 1',
      'custom_surcharge2': 'Custom Surcharge 2',
      'custom_surcharge3': 'Custom Surcharge 3',
      'custom_surcharge4': 'Custom Surcharge 4',
      'is_deleted': 'Is Deleted',
      'vendor_city': 'Vendor City',
      'vendor_state': 'Vendor State',
      'vendor_country': 'Vendor Country',
      'is_approved': 'Is Approved',
      'tax_name': 'Emri i taksës',
      'tax_amount': 'Tax Amount',
      'tax_paid': 'Tax Paid',
      'payment_amount': 'Shuma e paguar',
      'age': 'Age',
      'is_running': 'Is Running',
      'time_log': 'Time Log',
      'bank_id': 'Banka',
      'expense_category_id': 'Expense Category ID',
      'expense_category': 'Expense Category',
      'invoice_currency_id': 'Invoice Currency ID',
      'tax_name1': 'Tax Name 1',
      'tax_name2': 'Tax Name 2',
      'tax_name3': 'Tax Name 3',
      'transaction_id': 'Transaction ID',
      'status_color_theme': 'Status Color Theme',
      'load_color_theme': 'Load Color Theme',
    },
    'ar': {
      'location': 'موقع',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'تم حذف الموقع',
      'added_location': 'Successfully added location',
      'updated_location': 'موقع محدث',
      'edit_location': 'تعديل الموقع',
      'add_location': 'اضافة موقع',
      'locations': 'المواقع',
      'preference_product_notes_for_html_view':
          'إستخدم ملاحظات العنصر عند عرض HTML',
      'preference_product_notes_for_html_view_help':
          'تفضيل وصف العنصر على عنوان العنصر عند عرض الفاتورة بصيغة HTML',
      'in_stock_quantity': 'كمية المخزون',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update': 'السماح للعملاء بتحديث ملفاتهم الشخصية',
      'enable_client_profile_update_help':
          'السماح للعملاء بتحديث معلومات ملفاتهم الشخصية من بوابة العميل',
      'participant': 'مشارك',
      'merged_vendors': 'تم دمج البائعين بنجاح',
      'activity_146':
          'تم تسليم الفاتورة الإلكترونية :invoice لـ :client بنجاح! :notes',
      'activity_147': 'E-Invoice :invoice for :client failed delivery :notes',
      'activity_148': 'تم استلام المصروفات الإلكترونية :expense من :vendor',
      'payment_failed': 'فشل الدفع',
      'activity_141': 'المستخدم :user أدخل ملاحظة: :notes',
      'activity_142': 'اقتباس :quote تذكير 1 تم الإرسال',
      'activity_143': 'تم إصدار فاتورة تلقائية بنجاح للفاتورة :invoice',
      'activity_144': 'فشل إصدار الفاتورة تلقائيًا للفاتورة :invoice . :notes',
      'activity_145':
          'تم إرسال الفاتورة الإلكترونية :invoice لـ :client . :notes',
      'ssl_host_override': 'تجاوز مضيف SSL',
      'upload_logo_short': 'تحميل الشعار',
      'show_pdfhtml_on_mobile_help':
          'لتحسين التصور، يتم عرض نسخة HTML من الفاتورة/عرض الأسعار عند عرضها على الهاتف المحمول.',
      'accept_purchase_order': 'قبول طلب الشراء',
      'one_page_checkout': 'الدفع بصفحة واحدة',
      'one_page_checkout_help': 'تمكين تدفق الدفع الجديد بصفحة واحدة',
      'applies_to': 'ينطبق على',
      'purchase_order_items': 'عناصر أمر الشراء',
      'assigned_group': 'تم تعيين المجموعة بنجاح',
      'assign_group': 'تعيين المجموعة',
      'merge_to_pdf': 'دمج إلى PDF',
      'emails': 'رسائل البريد الإلكتروني',
      'latest_requires_php_version':
          'ملاحظة: الإصدار الأحدث يتطلب PHP :version',
      'quote_reminder1': 'تذكير بالاقتباس الأول',
      'before_valid_until': 'قبل أن تصبح صالحة حتى',
      'after_valid_until': 'بعد انتهاء الصلاحية حتى',
      'after_quote_date': 'بعد تاريخ الاقتباس',
      'remind_quote': 'تذكير الاقتباس',
      'task_assigned_notification': 'إشعار تعيين المهمة',
      'task_assigned_notification_help': 'إرسال بريد إلكتروني عند تعيين مهمة',
      'invoices_locked_end_of_month': 'يتم قفل الفواتير في نهاية الشهر',
      'end_of_month': 'نهاية الشهر',
      'referral_url': 'رابط الإحالة',
      'referral_program': 'برنامج الإحالة',
      'comment': 'تعليق',
      'add_comment': 'اضافة تعليق',
      'added_comment': 'تم حفظ التعليق بنجاح',
      'disconnected': 'انقطع الاتصال',
      'reconnect': 'أعد الاتصال',
      'e_invoice_settings': 'إعدادات الفاتورة الإلكترونية',
      'calculate': 'احسب',
      'sum': 'مجموع',
      'money': 'مال',
      'time': 'وقت',
      'format': 'شكل',
      'web_app': 'التطبيق على شبكة الإنترنت',
      'desktop_app': 'التطبيق سطح المكتب',
      'invoice_net_amount': 'صافي مبلغ الفاتورة',
      'round_to_seconds': 'التقريب إلى الثواني',
      '1_minute': '1 دقيقة',
      '5_minutes': '5 دقائق',
      '15_minutes': '15 دقيقة',
      '30_minutes': '30 دقيقة',
      '1_hour': '1 ساعة',
      '1_day': 'يوم 1',
      'round_tasks': 'اتجاه تقريب المهمة',
      'round_tasks_help': 'قم بتقريب أوقات المهام لأعلى أو لأسفل.',
      'direction': 'اتجاه',
      'round_up': 'جمع الشمل',
      'round_down': 'المستدير لأسفل',
      'task_round_to_nearest': 'جولة إلى الأقرب',
      'activity_139': 'تم إرسال إشعار النفقات :expense إلى :contact',
      'activity_140': 'تم إرسال البيان إلى :client',
      'bulk_updated': 'تم تحديث البيانات بنجاح',
      'bulk_update': 'تحديث بالجملة',
      'advanced_cards': 'بطاقات متقدمة',
      'always_show_required_fields': 'إظهار نموذج الحقول المطلوبة دائمًا',
      'always_show_required_fields_help':
          'يعرض نموذج الحقول المطلوبة دائمًا عند الخروج',
      'flutter_web_warning':
          'نوصي باستخدام تطبيق الويب الجديد أو تطبيق سطح المكتب للحصول على أفضل أداء',
      'rappen_rounding': 'تقريب رابين',
      'rappen_rounding_help': 'جولة المبلغ إلى 5 سنتات',
      'check_credentials': 'التحقق من بيانات الاعتماد',
      'valid_credentials': 'أوراق الاعتماد صالحة',
      'invalid_credentials': 'أوراق الاعتماد هذه لا تتطابق مع سجلاتنا',
      'e_quote': 'الاقتباس الإلكتروني',
      'e_credit': 'الائتمان الإلكتروني',
      'e_purchase_order': 'أمر الشراء الإلكتروني',
      'valid_vat_number': 'رقم ضريبة القيمة المضافة صالح',
      'use_available_payments': 'استخدم المدفوعات المتاحة',
      'test_email_sent': 'تم إرسال البريد الإلكتروني بنجاح',
      'send_test_email': 'Send Test Email',
      'gateway_type': 'نوع البوابة',
      'please_select_an_invoice_or_credit': 'الرجاء تحديد فاتورة أو رصيد',
      'mobile_version': 'اصدار المحمول',
      'venmo': 'فينمو',
      'mercado_pago': 'ميركادو باجو',
      'my_bank': 'بنكي',
      'pay_later': 'ادفع لاحقا',
      'email_report': 'تقرير البريد الإلكتروني',
      'host': 'يستضيف',
      'port': 'ميناء',
      'encryption': 'التشفير',
      'local_domain': 'المجال المحلي',
      'verify_peer': 'التحقق من النظير',
      'username': 'اسم المستخدم',
      'nordigen_help': 'ملاحظة: يتطلب ربط حساب مفتاح GoCardless/Nordigen API',
      'participant_name': 'اسم المشارك',
      'yodlee_regions':
          'المناطق: الولايات المتحدة الأمريكية والمملكة المتحدة وأستراليا والهند',
      'nordigen_regions': 'المناطق: أوروبا والمملكة المتحدة',
      'select_provider': 'حدد الموفر',
      'payment_type_credit': 'نوع الدفع الائتمان',
      'payment_type_debit': 'نوع الدفع الخصم',
      'send_emails_to': 'إرسال رسائل البريد الإلكتروني إلى',
      'primary_contact': 'اتصال رئيسي',
      'all_contacts': 'كل الاتصالات',
      'insert_below': 'أدخل أدناه',
      'ar_detailed': 'حسابات القبض مفصلة',
      'ar_summary': 'ملخص حسابات القبض',
      'client_sales': 'مبيعات العملاء',
      'tax_summary': 'ملخص الضرائب',
      'user_sales': 'مبيعات المستخدم',
      'run_template': 'Run Template',
      'task_extension_banner': 'اضافة ملحق Chrome لإدارة مهامك',
      'watch_video': 'شاهد الفيديو',
      'view_extension': 'عرض الامتداد',
      'reactivate_email': 'إعادة تنشيط البريد الإلكتروني',
      'email_reactivated': 'تم إعادة تنشيط البريد الإلكتروني بنجاح',
      'template_help': 'تمكين استخدام التصميم كقالب',
      'delivery_note_design': 'تصميم مذكرة التسليم',
      'statement_design': 'تصميم البيان',
      'payment_receipt_design': 'تصميم إيصال الدفع',
      'payment_refund_design': 'تصميم استرداد الدفع',
      'quarter': 'ربع',
      'item_description': 'وصف السلعة',
      'task_item': 'عنصر المهمة',
      'record_state': 'حالة السجل',
      'last_login': 'آخر تسجيل دخول',
      'save_files_to_this_folder': 'حفظ الملفات في هذا المجلد',
      'downloads_folder': 'مجلد التنزيلات',
      'total_invoiced_quotes': 'عروض الأسعار المفوترة',
      'total_invoice_paid_quotes': 'اقتباسات الفاتورة المدفوعة',
      'downloads_folder_does_not_exist': 'مجلد التنزيلات غير موجود :value',
      'user_logged_in_notification': 'إشعار تسجيل دخول المستخدم',
      'user_logged_in_notification_help':
          'إرسال بريد إلكتروني عند تسجيل الدخول من موقع جديد',
      'client_contact': 'الاتصال بالعميل',
      'expense_status_4': 'غير مدفوعة الأجر',
      'expense_status_5': 'مدفوع',
      'recurring': 'يتكرر',
      'ziptax_help':
          'ملاحظة: تتطلب هذه الميزة مفتاح Zip-Tax API للبحث عن ضريبة المبيعات الأمريكية حسب العنوان',
      'cache_data': 'بيانات ذاكرة التخزين المؤقت',
      'unknown': 'مجهول',
      'webhook_failure': 'فشل خطاف الويب',
      'email_opened': 'تم فتح البريد الإلكتروني',
      'email_delivered': 'تم تسليم البريد الإلكتروني',
      'log': 'سجل',
      'individual': 'فردي',
      'partnership': 'شراكة',
      'trust': 'يثق',
      'charity': 'صدقة',
      'government': 'حكومة',
      'classification': 'تصنيف',
      'click_or_drop_files_here': 'انقر أو أسقط الملفات هنا',
      'public': 'عام',
      'private': 'خاص',
      'image': 'صورة',
      'other': 'آخر',
      'hash': 'تجزئة',
      'linked_to': 'مرتبط ب',
      'file_saved_in_path': 'تم حفظ الملف في :path',
      'unlinked_transactions': 'تم إلغاء ربط معاملات :count بنجاح',
      'unlinked_transaction': 'تم إلغاء ربط المعاملة بنجاح',
      'unlink': 'فك الارتباط',
      'view_dashboard_permission':
          'السماح للمستخدم بالوصول إلى لوحة المعلومات، تقتصر البيانات على الأذونات المتاحة',
      'is_tax_exempt': 'معفاة من الضرائب',
      'district': 'يصرف',
      'region': 'منطقة',
      'county': 'مقاطعة',
      'tax_details': 'التفاصيل الضريبية',
      'activity_10_online':
          ':contact تم الدفع :payment للفاتورة :invoice لـ :client',
      'activity_10_manual':
          ':user الدفعة المدخلة :payment للفاتورة :invoice لـ :client',
      'default_payment_type': 'نوع الدفع الافتراضي',
      'admin_initiated_payments': 'بدأ المشرف المدفوعات',
      'admin_initiated_payments_help':
          'دعم إدخال دفعة في بوابة الإدارة بدون فاتورة',
      'use_mobile_to_manage_plan': 'استخدم إعدادات اشتراك هاتفك لإدارة خطتك',
      'show_task_billable': 'إظهار المهمة القابلة للفوترة',
      'credit_item': 'عنصر الائتمان',
      'files': 'ملفات',
      'camera': 'آلة تصوير',
      'gallery': 'صالة عرض',
      'email_count_invoices': 'إرسال الفواتير عبر البريد الإلكتروني :count',
      'project_location': 'موقع المشروع',
      'invoice_task_item_description': 'وصف عنصر مهمة الفاتورة',
      'invoice_task_item_description_help': 'اضافة وصف الصنف إلى بنود الفاتورة',
      'next_send_time': 'وقت الإرسال التالي',
      'uploaded_certificate': 'تم تحميل الشهادة بنجاح',
      'certificate_set': 'مجموعة الشهادات',
      'certificate_not_set': 'لم يتم تعيين الشهادة',
      'passphrase_set': 'مجموعة عبارة المرور',
      'passphrase_not_set': 'لم يتم تعيين عبارة المرور',
      'upload_certificate': 'تحميل الشهادة',
      'certificate_passphrase': 'عبارة مرور الشهادة',
      'rename': 'إعادة تسمية',
      'renamed_document': 'تمت إعادة تسمية المستند بنجاح',
      'e_invoice': 'الفاتورة الإلكترونية',
      'light_dark_mode': 'وضع الضوء/الظلام',
      'activities': 'أنشطة',
      'routing_id': 'معرف التوجيه',
      'enable_e_invoice': 'تفعيل الفاتورة الإلكترونية',
      'e_invoice_type': 'نوع الفاتورة الإلكترونية',
      'e_quote_type': 'نوع الاقتباس الإلكتروني',
      'reduced_tax': 'تخفيض الضرائب',
      'override_tax': 'تجاوز الضريبة',
      'zero_rated': 'تصنيف صفر',
      'reverse_tax': 'عكس الضريبة',
      'updated_tax_category': 'تم تحديث فئة الضريبة بنجاح',
      'updated_tax_categories': 'تم تحديث فئات الضرائب بنجاح',
      'set_tax_category': 'تعيين فئة الضريبة',
      'payment_manual': 'دليل الدفع',
      'tax_category': 'فئة الضريبة',
      'physical_goods': 'البضائع المادية',
      'digital_products': 'المنتجات الرقمية',
      'services': 'خدمات',
      'shipping': 'شحن',
      'tax_exempt': 'معفاة من الضرائب',
      'reduced_rate': 'نسبة مخفضة',
      'tax_all': 'ضريبة الكل',
      'tax_selected': 'تم تحديد الضريبة',
      'version': 'إصدار',
      'seller_subregion': 'منطقة البائع الفرعية',
      'calculate_taxes': 'حساب الضرائب',
      'calculate_taxes_help': 'حساب الضرائب تلقائيًا عند حفظ الفواتير',
      'admin': 'مسؤل',
      'owner': 'مالك',
      'link_expenses': 'ربط المصاريف',
      'converted_client_balance': 'رصيد العميل المحول',
      'converted_payment_balance': 'رصيد الدفع المحول',
      'total_hours': 'مجموع الساعات',
      'date_picker_hint': 'استخدم + أيام لتعيين التاريخ في المستقبل',
      'browser_pdf_viewer': 'استخدم متصفح عارض PDF',
      'browser_pdf_viewer_help': 'تحذير: يمنع التفاعل مع التطبيق عبر ملف PDF',
      'increase_prices': 'زيادة الأسعار',
      'update_prices': 'تحديث الأسعار',
      'incresed_prices': 'تم رفع الأسعار في قائمة الانتظار بنجاح',
      'updated_prices': 'يتم تحديث الأسعار في قائمة الانتظار بنجاح',
      'bacs': 'الخصم المباشر من BACS',
      'api_token': 'رمز API',
      'api_key': 'مفتاح API',
      'endpoint': 'نقطة النهاية',
      'billable': 'قابل للفوترة',
      'not_billable': 'غير قابل للفوترة',
      'allow_billable_task_items': 'السماح بعناصر المهام القابلة للفوترة',
      'allow_billable_task_items_help':
          'تمكين تكوين عناصر المهام التي تتم فوترتها',
      'show_task_item_description': 'إظهار وصف عنصر المهمة',
      'show_task_item_description_help': 'تمكين تحديد أوصاف عنصر المهمة',
      'email_record': 'سجل البريد الإلكتروني',
      'invoice_product_columns': 'أعمدة منتج الفاتورة',
      'quote_product_columns': 'أعمدة المنتج اقتباس',
      'minimum_payment_amount': 'الحد الأدنى لمبلغ السداد',
      'client_initiated_payments': 'مدفوعات يبدأها العميل',
      'client_initiated_payments_help':
          'دعم إجراء الدفع في بوابة العميل بدون فاتورة',
      'share_invoice_quote_columns': 'مشاركة أعمدة الفاتورة / الاقتباس',
      'cc_email': 'CC البريد الإلكتروني',
      'payment_balance': 'رصيد المدفوعات',
      'view_report_permission':
          'السماح للمستخدم بالوصول إلى التقارير ، تقتصر البيانات على الأذونات المتاحة',
      'activity_138': 'الدفع: تم إرسال الدفع بالبريد الإلكتروني إلى: العميل',
      'one_time_products': 'منتجات المرة الواحدة',
      'optional_one_time_products': 'المنتجات الاختيارية لمرة واحدة',
      'required': 'مطلوب',
      'hidden': 'مختفي',
      'payment_links': 'روابط الدفع',
      'action': 'إجراء',
      'upgrade_to_paid_plan_to_schedule':
          'قم بالترقية إلى خطة مدفوعة لإنشاء جداول',
      'next_run': 'تشغيل المقبل',
      'all_clients': 'كل العملاء',
      'show_aging_table': 'عرض جدول التقادم',
      'show_payments_table': 'إظهار جدول المدفوعات',
      'only_clients_with_invoices': 'فقط العملاء الذين لديهم فواتير',
      'email_statement': 'بيان البريد الإلكتروني',
      'once': 'مرة واحدة',
      'schedule': 'جدول',
      'schedules': 'جداول',
      'new_schedule': 'جدول جديد',
      'edit_schedule': 'تحرير الجدول',
      'created_schedule': 'تم إنشاء الجدول الزمني بنجاح',
      'updated_schedule': 'تم تحديث الجدول بنجاح',
      'archived_schedule': 'تمت أرشفة الجدول الزمني بنجاح',
      'deleted_schedule': 'تم حذف الجدول الزمني بنجاح',
      'removed_schedule': 'تمت إزالة الجدول الزمني بنجاح',
      'restored_schedule': 'تمت استعادة الجدول الزمني بنجاح',
      'search_schedule': 'جدول البحث',
      'search_schedules': 'جداول البحث',
      'archive_payment': 'أرشفة الدفعة',
      'archive_invoice': 'أرشفة الفاتورة',
      'archive_quote': 'أرشفة عرض السعر',
      'archive_credit': 'أرشفة الرصيد',
      'archive_task': 'مهمة الأرشفة',
      'archive_client': 'أرشفة العميل',
      'archive_project': 'أرشفة المشروع',
      'archive_expense': 'أرشفة المصاريف',
      'restore_payment': 'استعادة الدفع',
      'restore_invoice': 'استعادة الفاتورة',
      'restore_quote': 'استعادة الاقتباس',
      'restore_credit': 'استعادة الائتمان',
      'restore_task': 'استعادة المهمة',
      'restore_client': 'استعادة العميل',
      'restore_project': 'استعادة المشروع',
      'restore_expense': 'استعادة المصاريف',
      'archive_vendor': 'بائع الأرشيف',
      'restore_vendor': 'استعادة البائع',
      'create_product': 'إضافة منتج',
      'update_product': 'تحديث المنتج',
      'delete_product': 'حذف المنتج',
      'restore_product': 'استعادة المنتج',
      'archive_product': 'ارشفة المنتج',
      'create_purchase_order': 'إنشاء أمر شراء',
      'update_purchase_order': 'تحديث أمر الشراء',
      'delete_purchase_order': 'حذف أمر الشراء',
      'restore_purchase_order': 'استعادة أمر الشراء',
      'archive_purchase_order': 'أرشفة طلب الشراء',
      'sent_invoice': 'الفاتورة المرسلة',
      'sent_quote': 'إرسال اقتباس',
      'sent_credit': 'الائتمان المرسل',
      'sent_purchase_order': 'أمر الشراء المرسل',
      'image_url': 'رابط الصورة',
      'max_quantity': 'الكمية القصوى',
      'test_url': 'اختبار URL',
      'auto_bill_help_off': 'الخيار غير معروض',
      'auto_bill_help_optin': 'يظهر الخيار ولكن لم يتم تحديده',
      'auto_bill_help_optout': 'يظهر الخيار ويتم تحديده',
      'auto_bill_help_always': 'الخيار غير معروض',
      'payment_methods': 'طرق الدفع',
      'view_all': 'مشاهدة الكل',
      'edit_all': 'تحرير الكل',
      'accept_purchase_order_number': 'قبول رقم طلب الشراء',
      'accept_purchase_order_number_help':
          'تمكين العملاء من تقديم رقم أمر الشراء عند الموافقة على عرض أسعار',
      'from_email': 'من البريد الإلكترونى',
      'show_preview': 'عرض المعاينة',
      'show_paid_stamp': 'إظهار الطابع المدفوع',
      'show_shipping_address': 'إظهار عنوان الشحن',
      'no_documents_to_download': 'لا توجد مستندات في السجلات المحددة للتنزيل',
      'pixels': 'بكسل',
      'logo_size': 'حجم الشعار',
      'postal_city': 'البريد / المدينة',
      'failed': 'فشل',
      'client_contacts': 'جهات اتصال العميل',
      'sync_from': 'مزامنة من',
      'inventory_threshold': 'عتبة المخزون',
      'hour': 'ساعة',
      'emailed_statement': 'تم بنجاح إرسال البيان في قائمة الانتظار',
      'show_email_footer': 'إظهار تذييل البريد الإلكتروني',
      'invoice_task_hours': 'ساعات عمل الفاتورة',
      'invoice_task_hours_help': 'أضف الساعات إلى بنود سطر الفاتورة',
      'auto_bill_standard_invoices': 'الفواتير القياسية لفواتير السيارات',
      'auto_bill_recurring_invoices': 'الفواتير المتكررة للفواتير',
      'email_alignment': 'محاذاة البريد الإلكتروني',
      'pdf_preview_location': 'موقع معاينة PDF',
      'mailgun': 'Mailgun',
      'postmark': 'ختم البريد',
      'microsoft': 'مايكروسوفت',
      'click_plus_to_create_record': 'انقر فوق + لإنشاء سجل',
      'last365_days': 'آخر 365 يومًا',
      'import_design': 'تصميم الاستيراد',
      'imported_design': 'تم استيراد التصميم بنجاح',
      'invalid_design': 'التصميم غير صالح ، قسم :value مفقود',
      'setup_wizard_logo': 'هل ترغب في تحميل شعارك؟',
      'upload': 'رفع',
      'installed_version': 'الإصدار المثبت',
      'notify_vendor_when_paid': 'إخطار البائع عند الدفع',
      'notify_vendor_when_paid_help':
          'أرسل بريدًا إلكترونيًا إلى البائع عندما يتم تمييز المصاريف على أنها مدفوعة',
      'update_payment': 'تحديث الدفع',
      'markup': 'وضع علامة على',
      'purchase_order_created': 'تم إنشاء أمر الشراء',
      'purchase_order_sent': 'تم إرسال طلب الشراء',
      'purchase_order_viewed': 'تم عرض طلب الشراء',
      'purchase_order_accepted': 'تم قبول طلب الشراء',
      'credit_payment_error':
          'لا يمكن أن يكون مبلغ الائتمان أكبر من مبلغ الدفع',
      'klarna': 'كلارنا',
      'convert_payment_currency_help': 'حدد سعر الصرف عند إدخال دفعة يدوية',
      'convert_expense_currency_help': 'حدد سعر الصرف عند إنشاء حساب',
      'matomo_url': 'ماتومو URL',
      'matomo_id': 'معرف ماتومو',
      'action_add_to_invoice': 'أضف إلى الفاتورة',
      'online_payment_email_help':
          'أرسل بريدًا إلكترونيًا عند إجراء الدفع عبر الإنترنت',
      'manual_payment_email_help':
          'أرسل بريدًا إلكترونيًا عند إدخال دفعة يدويًا',
      'mark_paid_payment_email_help':
          'أرسل بريدًا إلكترونيًا عند وضع علامة على فاتورة على أنها مدفوعة',
      'delete_project': 'حذف المشروع',
      'linked_transaction': 'تم ربط المعاملة بنجاح',
      'link_payment': 'ربط الدفع',
      'link_expense': 'مصاريف الارتباط',
      'lock_invoiced_tasks': 'قفل المهام المفوترة',
      'lock_invoiced_tasks_help': 'منع تحرير المهام بمجرد إصدار الفواتير',
      'registration_required': 'التسجيل مطلوب',
      'registration_required_help': 'مطالبة العملاء بالتسجيل',
      'use_inventory_management': 'استخدم إدارة المخزون',
      'use_inventory_management_help': 'تتطلب أن تكون المنتجات في المخزون',
      'optional_products': 'المنتجات الاختيارية',
      'optional_recurring_products': 'المنتجات المتكررة الاختيارية',
      'convert_matched': 'يتحول',
      'auto_billed_invoice':
          'الفاتورة في قائمة الانتظار بنجاح ليتم إصدار فواتير بها تلقائيًا',
      'auto_billed_invoices':
          'تم بنجاح وضع الفواتير في قائمة الانتظار ليتم تحرير فواتيرها تلقائيًا',
      'operator': 'المشغل أو العامل',
      'value': 'قيمة',
      'is': 'يكون',
      'contains': 'يتضمن',
      'starts_with': 'ابدا ب',
      'is_empty': 'فارغ',
      'add_rule': 'أضف القاعدة',
      'match_all_rules': 'تطابق جميع القواعد',
      'match_all_rules_help':
          'يجب أن تتطابق جميع المعايير حتى يتم تطبيق القاعدة',
      'auto_convert_help': 'تحويل المعاملات المتطابقة تلقائيًا إلى نفقات',
      'rules': 'قواعد',
      'transaction_rule': 'قاعدة الصفقة',
      'transaction_rules': 'قواعد الصفقة',
      'new_transaction_rule': 'قاعدة الصفقة الجديدة',
      'edit_transaction_rule': 'تحرير قاعدة المعاملة',
      'created_transaction_rule': 'تم إنشاء القاعدة بنجاح',
      'updated_transaction_rule': 'تم تحديث قاعدة المعاملة بنجاح',
      'archived_transaction_rule': 'تمت أرشفة قاعدة المعاملة بنجاح',
      'deleted_transaction_rule': 'تم حذف قاعدة المعاملة بنجاح',
      'removed_transaction_rule': 'تمت إزالة قاعدة المعاملة بنجاح',
      'restored_transaction_rule': 'تمت استعادة قاعدة المعاملة بنجاح',
      'search_transaction_rule': 'البحث في قاعدة المعاملات',
      'search_transaction_rules': 'البحث في قواعد المعاملات',
      'save_as_default_terms': 'حفظ كشروط افتراضية',
      'save_as_default_footer': 'حفظ كتذييل افتراضي',
      'auto_sync': 'تزامن تلقائي',
      'refresh_accounts': 'تحديث الحسابات',
      'upgrade_to_connect_bank_account':
          'قم بالترقية إلى Enterprise لربط حسابك المصرفي',
      'click_here_to_connect_bank_account': 'انقر هنا لتوصيل حسابك المصرفي',
      'disable_2fa': 'تعطيل 2FA',
      'change_number': 'تغيير رقم',
      'resend_code': 'أعد إرسال الرمز',
      'base_type': 'نوع القاعدة',
      'category_type': 'نوع الفئة',
      'bank_transaction': 'عملية',
      'bulk_print': 'طباعة PDF',
      'vendor_postal_code': 'البائع الرمز البريدي',
      'preview_location': 'معاينة الموقع',
      'bottom': 'قاع',
      'side': 'جانب',
      'pdf_preview': 'معاينة PDF',
      'long_press_to_select': 'الضغط لفترة طويلة للتحديد',
      'purchase_order_number': 'رقم طلب الشراء',
      'purchase_order_item': 'عنصر أمر الشراء',
      'would_you_rate_the_app': 'هل ترغب في تقييم التطبيق؟',
      'include_deleted': 'تضمين المحذوفة',
      'include_deleted_help': 'تضمين السجلات المحذوفة في التقارير',
      'due_on': 'تاريخ الاستحقاق',
      'converted_transactions': 'تم تحويل المعاملات بنجاح',
      'created_bank_account': 'تم إنشاء حساب مصرفي بنجاح',
      'updated_bank_account': 'تم تحديث الحساب المصرفي بنجاح',
      'edit_bank_account': 'تحرير الحساب المصرفي',
      'default_category': 'الفئة الافتراضية',
      'account_type': 'نوع الحساب',
      'new_bank_account': 'اضافة حساب البنك',
      'connect_accounts': 'ربط الحسابات',
      'manage_rules': 'إدارة القواعد',
      'search_category': 'بحث 1 فئة',
      'search_categories': 'بحث :count التصنيفات',
      'min_amount': 'المبلغ الأدنى',
      'max_amount': 'المبلغ الأقصى',
      'selected': 'المحدد',
      'converted_transaction': 'تم تحويل المعاملة بنجاح',
      'convert_to_payment': 'التحويل إلى الدفع',
      'deposit': 'إيداع',
      'withdrawal': 'انسحاب',
      'deposits': 'الودائع',
      'withdrawals': 'الانسحابات',
      'matched': 'متطابقة',
      'unmatched': 'لا مثيل لها',
      'create_credit': 'إنشاء رصيد',
      'update_credit': 'تحديث الائتمان',
      'delete_credit': 'حذف الرصيد',
      'transaction': 'عملية',
      'transactions': 'المعاملات',
      'new_transaction': 'معاملة جديدة',
      'edit_transaction': 'تحرير المعاملة',
      'created_transaction': 'تم إنشاء المعاملة بنجاح',
      'updated_transaction': 'تم تحديث المعاملة بنجاح',
      'archived_transaction': 'تمت أرشفة المعاملة بنجاح',
      'deleted_transaction': 'تم حذف المعاملة بنجاح',
      'removed_transaction': 'تمت إزالة المعاملة بنجاح',
      'restored_transaction': 'تمت استعادة المعاملة بنجاح',
      'search_transaction': 'البحث عن معاملة',
      'search_transactions': 'ابحث في :count المعاملات',
      'bank_account': 'حساب البنك',
      'bank_accounts': 'بطاقات الائتمان والبنوك',
      'archived_bank_account': 'تمت أرشفة الحساب المصرفي بنجاح',
      'deleted_bank_account': 'تم حذف الحساب المصرفي بنجاح',
      'removed_bank_account': 'تمت إزالة الحساب المصرفي بنجاح',
      'restored_bank_account': 'تمت استعادة الحساب المصرفي بنجاح',
      'search_bank_account': 'ابحث عن حساب مصرفي',
      'search_bank_accounts': 'ابحث في حسابات :count المصرفية',
      'connect': 'الاتصال',
      'mark_paid_payment_email':
          'وضع علامة على البريد الإلكتروني للدفع المدفوع',
      'convert_to_project': 'تحويل إلى مشروع',
      'client_email': 'البريد الإلكتروني للعميل',
      'invoice_task_project': 'مشروع مهمة الفاتورة',
      'invoice_task_project_help': 'أضف المشروع إلى بنود سطر الفاتورة',
      'field': 'مجال',
      'period': 'فترة',
      'fields_per_row': 'الحقول في كل صف',
      'total_active_invoices': 'الفواتير النشطة',
      'total_outstanding_invoices': 'الفواتير المستحقة',
      'total_completed_payments': 'المدفوعات المكتملة',
      'total_refunded_payments': 'المدفوعات المعادة',
      'total_active_quotes': 'عروض نشطة',
      'total_approved_quotes': 'العروض المعتمدة',
      'total_unapproved_quotes': 'عروض غير معتمدة',
      'total_logged_tasks': 'المهام المسجلة',
      'total_invoiced_tasks': 'المهام المفوترة',
      'total_paid_tasks': 'المهام المدفوعة',
      'total_logged_expenses': 'المصاريف المسجلة',
      'total_pending_expenses': 'المصاريف المعلقة',
      'total_invoiced_expenses': 'المصاريف المفوترة',
      'total_invoice_paid_expenses': 'مصاريف الفاتورة المدفوعة',
      'activity_130': 'إنشاء :user أمر الشراء :purchase_order',
      'activity_131': ':user تحديث أمر الشراء :purchase_order',
      'activity_132': ':user أمر شراء مؤرشف :purchase_order',
      'activity_133': ':user أمر الشراء المحذوف :purchase_order',
      'activity_134': ':user استعادة أمر الشراء :purchase_order',
      'activity_135': ':user أمر الشراء بالبريد الإلكتروني :purchase_order',
      'activity_136': ':contact عرض أمر الشراء :purchase_order',
      'activity_137': ':contact قبول أمر الشراء :purchase_order',
      'vendor_portal': 'بوابة البائعين',
      'send_code': 'أرسل الرمز',
      'save_to_upload_documents': 'احفظ السجل لتحميل المستندات',
      'expense_tax_rates': 'معدلات ضريبة المصاريف',
      'invoice_item_tax_rates': 'معدلات ضريبة عنصر الفاتورة',
      'verified_phone_number': 'تم التحقق من رقم الهاتف بنجاح',
      'code_was_sent': 'تم إرسال رمز عبر الرسائل القصيرة',
      'code_was_sent_to': 'تم إرسال رمز عبر رسالة نصية قصيرة إلى :number',
      'resend': 'إعادة إرسال',
      'verify': 'تحقق',
      'enter_phone_number': 'يرجى تقديم رقم هاتف',
      'invalid_phone_number': 'رقم الهاتف غير صحيح',
      'verify_phone_number': 'تحقق من رقم الهاتف',
      'verify_phone_number_help':
          'يرجى التحقق من رقم هاتفك لإرسال رسائل البريد الإلكتروني',
      'verify_phone_number_2fa_help':
          'يرجى التحقق من رقم هاتفك للنسخ الاحتياطي 2FA',
      'merged_clients': 'تم دمج العملاء بنجاح',
      'merge_into': 'دمج الي',
      'merge': 'دمج',
      'price_change_accepted': 'تم قبول تغيير السعر',
      'price_change_failed': 'فشل تغيير السعر مع الرمز',
      'restore_purchases': 'استعادة المشتريات',
      'activate': 'تفعيل',
      'connect_apple': 'قم بتوصيل Apple',
      'disconnect_apple': 'افصل Apple',
      'disconnected_apple': 'تم قطع اتصال Apple بنجاح',
      'send_now': 'ارسل الان',
      'received': 'مستلم',
      'purchase_order_date': 'تاريخ أمر الشراء',
      'converted_to_expense': 'تم تحويلها بنجاح إلى مصروف',
      'converted_to_expenses': 'تم تحويلها بنجاح إلى نفقات',
      'convert_to_expense': 'تحويل إلى المصاريف',
      'add_to_inventory': 'أضف إلى المخزون',
      'added_purchase_order_to_inventory':
          'تمت إضافة أمر الشراء إلى المخزون بنجاح',
      'added_purchase_orders_to_inventory':
          'تمت إضافة أوامر الشراء إلى المخزون بنجاح',
      'client_document_upload': 'تحميل مستند العميل',
      'vendor_document_upload': 'تحميل مستند البائع',
      'vendor_document_upload_help': 'تمكن البائعين من تحميل المستندات',
      'are_you_enjoying_the_app': 'هل تستمتع بالتطبيق؟',
      'yes_its_great': 'نعم انه رائع!',
      'not_so_much': 'ليس كثيرا',
      'would_you_rate_it': 'عظيم أن نسمع! هل ترغب في تقييمه؟',
      'would_you_tell_us_more': 'آسف لسماع ذلك! تريد أن تقول لنا أكثر من ذلك؟',
      'sure_happy_to': 'بالتأكيد ، سعيد',
      'no_not_now': 'لا ليس الآن',
      'add': 'يضيف',
      'last_sent_template': 'آخر نموذج تم إرساله',
      'enable_flexible_search': 'تمكين البحث المرن',
      'enable_flexible_search_help':
          'تطابق الأحرف غير المتجاورة ، مثل. يطابق &quot;ct&quot; &quot;cat&quot;',
      'vendor_details': 'تفاصيل البائع',
      'purchase_order_details': 'تفاصيل أمر الشراء',
      'qr_iban': 'QR IBAN',
      'besr_id': 'معرف BESR',
      'accept': 'يقبل',
      'clone_to_purchase_order': 'استنساخ إلى PO',
      'vendor_email_not_set': 'البائع لم يتم تعيين عنوان بريد إلكتروني',
      'bulk_send_email': 'ارسل بريد الكتروني',
      'marked_purchase_order_as_sent':
          'نجح وضع علامة على أمر الشراء على أنه تم الإرسال',
      'marked_purchase_orders_as_sent':
          'نجح وضع علامة على أوامر الشراء على أنها مرسلة',
      'accepted_purchase_order': 'تم قبول طلب الشراء بنجاح',
      'accepted_purchase_orders': 'قبول أوامر الشراء بنجاح',
      'cancelled_purchase_order': 'تم إلغاء طلب الشراء بنجاح',
      'cancelled_purchase_orders': 'تم إلغاء أوامر الشراء بنجاح',
      'accepted': 'قبلت',
      'please_select_a_vendor': 'الرجاء تحديد بائع',
      'purchase_order_total': 'إجمالي طلب الشراء',
      'email_purchase_order': 'طلب الشراء عبر البريد الإلكتروني',
      'bulk_email_purchase_orders': 'طلبات الشراء بالبريد الإلكتروني',
      'disconnected_email': 'قطع البريد الإلكتروني بنجاح',
      'connect_email': 'ربط البريد الإلكتروني',
      'disconnect_email': 'افصل البريد الإلكتروني',
      'use_web_app_to_connect_microsoft':
          'الرجاء استخدام تطبيق الويب للاتصال بـ Microsoft',
      'email_provider': 'مزود البريد الإلكتروني',
      'connect_microsoft': 'قم بتوصيل Microsoft',
      'disconnect_microsoft': 'افصل Microsoft',
      'connected_microsoft': 'تم توصيل Microsoft بنجاح',
      'disconnected_microsoft': 'قطع اتصال Microsoft بنجاح',
      'microsoft_sign_in': 'تسجيل الدخول مع Microsoft',
      'microsoft_sign_up': 'قم بالتسجيل مع Microsoft',
      'emailed_purchase_order': 'سيتم إرسال طلب الشراء في قائمة الانتظار بنجاح',
      'emailed_purchase_orders':
          'سيتم إرسال طلبات الشراء في قائمة الانتظار بنجاح',
      'enable_react_app': 'غيّر إلى تطبيق الويب React',
      'purchase_order_design': 'تصميم طلب الشراء',
      'purchase_order_terms': 'شروط طلب الشراء',
      'purchase_order_footer': 'تذييل طلب الشراء',
      'require_purchase_order_signature': 'توقيع طلب الشراء',
      'require_purchase_order_signature_help': 'مطالبة البائع بتقديم توقيعه.',
      'purchase_order': 'أمر شراء',
      'purchase_orders': 'طلبات الشراء',
      'new_purchase_order': 'طلب شراء جديد',
      'edit_purchase_order': 'تحرير طلب الشراء',
      'created_purchase_order': 'تم إنشاء طلب الشراء بنجاح',
      'updated_purchase_order': 'تم تحديث طلب الشراء بنجاح',
      'archived_purchase_order': 'تمت أرشفة طلب الشراء بنجاح',
      'deleted_purchase_order': 'تم حذف طلب الشراء بنجاح',
      'removed_purchase_order': 'تمت إزالة طلب الشراء بنجاح',
      'restored_purchase_order': 'تمت استعادة طلب الشراء بنجاح',
      'search_purchase_order': 'بحث طلب الشراء',
      'search_purchase_orders': 'بحث طلبات الشراء',
      'login_url': 'رابط تسجيل الدخول',
      'payment_settings': 'إعدادات الدفع',
      'default': 'تقصير',
      'stock_quantity': 'كمية المخزون',
      'notification_threshold': 'عتبة الإخطار',
      'track_inventory': 'حساب المخزون',
      'track_inventory_help':
          'اعرض حقل مخزون المنتج وقم بالتحديث عند إرسال الفواتير',
      'stock_notifications': 'إخطارات المخزون',
      'stock_notifications_help':
          'أرسل بريدًا إلكترونيًا عندما يصل المخزون إلى الحد الأدنى',
      'vat': 'ضريبة القيمة المضافة',
      'standing': 'احتياط',
      'view_map': 'عرض الخريطة',
      'set_default_design': 'تعيين التصميم الافتراضي',
      'add_gateway': 'اضافة بوابة الدفع',
      'add_gateway_help_message':
          'اضافة بوابة دفع (مثل Stripe أو WePay أو PayPal) لقبول الدفع عبر الإنترنت',
      'left': 'غادر',
      'right': 'يمين',
      'center': 'مركز',
      'page_numbering': 'ترقيم الصفحات',
      'page_numbering_alignment': 'محاذاة ترقيم الصفحات',
      'invoice_sent_notification_label': 'الفاتورة المرسلة',
      'show_product_description': 'عرض وصف المنتج',
      'show_product_description_help':
          'قم بتضمين الوصف في القائمة المنسدلة للمنتج',
      'invoice_items': 'عناصر الفاتورة',
      'quote_items': 'عناصر الاقتباس',
      'profitloss': 'الربح والخسارة',
      'import_format': 'تنسيق الاستيراد',
      'export_format': 'تنسيق التصدير',
      'export_type': 'نوع التصدير',
      'stop_on_unpaid': 'توقف على غير مدفوعة الأجر',
      'stop_on_unpaid_help':
          'توقف عن إنشاء فواتير متكررة إذا كانت آخر فاتورة غير مدفوعة.',
      'use_quote_terms': 'استخدم شروط الاقتباس',
      'use_quote_terms_help': 'عند تحويل عرض الأسعار إلى فاتورة',
      'add_country': 'أضف الدولة',
      'enable_tooltips': 'قم بتمكين تلميحات الأدوات',
      'enable_tooltips_help': 'إظهار تلميحات الأدوات عند تحريك الماوس',
      'multiple_client_error': 'خطأ: السجلات تنتمي إلى أكثر من عميل',
      'register_label': 'أنشئ حسابك في ثوانٍ',
      'login_label': 'تسجيل الدخول إلى حساب موجود',
      'add_to_invoice': 'أضف إلى الفاتورة :invoice',
      'no_invoices_found': 'لم يتم العثور على فواتير',
      'week': 'أسبوع',
      'created_record': 'تم إنشاء السجل بنجاح',
      'auto_archive_paid_invoices': 'أرشفة تلقائية مدفوعة',
      'auto_archive_paid_invoices_help': 'أرشفة الفواتير تلقائيًا عند دفعها.',
      'auto_archive_cancelled_invoices': 'تم إلغاء الأرشفة التلقائية',
      'auto_archive_cancelled_invoices_help':
          'أرشفة الفواتير تلقائيًا عند إلغائها.',
      'alternate_pdf_viewer': 'عارض PDF البديل',
      'alternate_pdf_viewer_help': 'تحسين التمرير فوق معاينة PDF [تجريبي]',
      'invoice_currency': 'عملة الفاتورة',
      'range': 'النطاق',
      'tax_amount1': 'مبلغ الضريبة 1',
      'tax_amount2': 'مبلغ الضريبة 2',
      'tax_amount3': 'مبلغ الضريبة 3',
      'create_project': 'أنشئ مشروعًا',
      'update_project': 'تحديث المشروع',
      'view_task': 'مشاهدة المهمة',
      'cancel_invoice': 'يلغي',
      'changed_status': 'تم تغيير حالة المهمة بنجاح',
      'change_status': 'تغيير الوضع',
      'fees_sample': 'ستكون رسوم فاتورة :amount :total.',
      'enable_touch_events': 'تفعيل أحداث اللمس',
      'enable_touch_events_help': 'دعم أحداث السحب للتمرير',
      'after_saving': 'بعد الحفظ',
      'view_record': 'مشاهدة السجل',
      'enable_email_markdown': 'تفعيل تسجيل البريد الإلكتروني',
      'enable_email_markdown_help':
          'استخدم محرر التخفيض المرئي لرسائل البريد الإلكتروني',
      'enable_pdf_markdown': 'تمكين PDF Markdown',
      'json_help':
          'ملاحظة: ملفات JSON التي تم إنشاؤها بواسطة تطبيق v4 غير مدعومة',
      'release_notes': 'ملاحظات الإصدار',
      'upgrade_to_view_reports': 'قم بترقية خطتك لعرض التقارير',
      'started_tasks': 'بدأ بنجاح مهام :value',
      'stopped_tasks': 'تم إيقاف مهام :value بنجاح',
      'approved_quote': 'تم وضع الاقتباس بنجاح',
      'approved_quotes': 'تمت الموافقة على اقتباسات :value بنجاح',
      'approve': 'يعتمد',
      'client_website': 'موقع العميل',
      'invalid_time': 'الوقت غير صحيح',
      'client_shipping_state': 'حالة شحن العميل',
      'client_shipping_city': 'مدينة شحن العميل',
      'client_shipping_postal_code': 'الرمز البريدي لشحن العميل',
      'client_shipping_country': 'بلد شحن العميل',
      'load_pdf': 'قم بتحميل ملف PDF',
      'start_free_trial': 'ابدأ الإصدار التجريبي المجاني',
      'start_free_trial_message':
          'ابدأ تجربتك المجانية لمدة 14 يومًا للخطة الاحترافية',
      'due_on_receipt': 'المستحقة على إيصال',
      'is_paid': 'مدفوع',
      'age_group_paid': 'مدفوع',
      'id': 'بطاقة تعريف',
      'convert_to': 'حول الى',
      'client_currency': 'عملة العميل',
      'company_currency': 'عملة الشركة',
      'purged_client': 'تم حذف العميل بنجاح',
      'custom_emails_disabled_help':
          'لمنع البريد العشوائي ، نطلب الترقية إلى حساب مدفوع لتخصيص البريد الإلكتروني',
      'upgrade_to_add_company': 'قم بترقية خطتك لإضافة شركات',
      'small': 'صغير',
      'marked_credit_as_paid': 'نجح وضع علامة على الائتمان كمدفوع',
      'marked_credits_as_paid': 'نجح وضع علامة على الائتمانات على أنها مدفوعة',
      'wait_for_loading': 'تحميل البيانات - يرجى الانتظار حتى يكتمل',
      'wait_for_saving': 'حفظ البيانات - يرجى الانتظار حتى يكتمل',
      'html_preview_warning':
          'ملاحظة: التغييرات التي تم إجراؤها هنا تتم معاينتها فقط ، ويجب تطبيقها في علامات التبويب أعلاه ليتم حفظها',
      'remaining': 'متبقي',
      'invoice_paid': 'فاتورة المدفوعة',
      'activity_120': 'إنشاء :user حساب متكرر :recurring_expense',
      'activity_121': ':user المصاريف المتكررة المحدثة :recurring_expense',
      'activity_122': ':user المصاريف المتكررة المؤرشفة :recurring_expense',
      'activity_123': ':user المصاريف المتكررة المحذوفة :recurring_expense',
      'activity_124': ':user المصاريف المتكررة المستعادة :recurring_expense',
      'normal': 'طبيعي',
      'large': 'كبير',
      'extra_large': 'كبير جدا',
      'show_pdf_preview': 'إظهار معاينة PDF',
      'show_pdf_preview_help': 'عرض معاينة PDF أثناء تحرير الفواتير',
      'print_pdf': 'طباعة PDF',
      'remind_me': 'ذكرني',
      'instant_bank_pay': 'الدفع البنكي الفوري',
      'click_selected': 'انقر فوق المحدد',
      'hide_preview': 'إخفاء المعاينة',
      'edit_record': 'تحرير السجل',
      'credit_is_more_than_invoice':
          'لا يمكن أن يكون مبلغ الائتمان أكثر من مبلغ الفاتورة',
      'giropay': 'GiroPay',
      'direct_debit': 'الخصم المباشر',
      'please_set_a_password': 'الرجاء تعيين كلمة مرور الحساب',
      'set_password': 'ضبط كلمة السر',
      'disconnected_gateway': 'تم قطع اتصال البوابة بنجاح',
      'disconnect': 'قطع الاتصال',
      'add_to_invoices': 'أضف إلى الفواتير',
      'acss': 'الخصم ACSS',
      'becs': 'الخصم المباشر BECS',
      'bulk_download': 'تحميل',
      'persist_data_help':
          'احفظ البيانات محليًا لتمكين التطبيق من البدء بشكل أسرع ، وقد يؤدي التعطيل إلى تحسين الأداء في الحسابات الكبيرة',
      'persist_ui': 'استمرار واجهة المستخدم',
      'persist_ui_help':
          'احفظ حالة واجهة المستخدم محليًا لتمكين التطبيق من البدء في الموقع الأخير ، وقد يؤدي التعطيل إلى تحسين الأداء',
      'client_postal_code': 'الرمز البريدي للعميل',
      'client_vat_number': 'رقم ضريبة القيمة المضافة للعميل',
      'has_tasks': 'لديه مهام',
      'registration': 'تسجيل',
      'unauthorized_stripe_warning':
          'يرجى تفويض Stripe لقبول المدفوعات عبر الإنترنت.',
      'view_expense': 'عرض المصاريف # :expense',
      'view_statement': 'عرض كشف حساب',
      'sepa': 'الخصم المباشر لمنطقة الدفعات المالية الموحدة باليورو SEPA',
      'ideal': 'مثالي',
      'przelewy24': 'برزيلوي 24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'قم بتحديث كافة السجلات',
      'system': 'نظام',
      'set_default_company': 'تعيين الشركة الافتراضية',
      'updated_company': 'تم تحديث الشركة بنجاح',
      'kbc': 'KBC',
      'bancontact': 'بانكونتاكت',
      'why_are_you_leaving': 'ساعدنا في التحسين بإخبارنا بالسبب (اختياري)',
      'webhook_success': 'نجاح Webhook',
      'error_cross_client_tasks': 'يجب أن تنتمي جميع المهام إلى نفس العميل',
      'error_cross_client_expenses': 'يجب أن تنتمي جميع النفقات إلى نفس العميل',
      'app': 'برنامج',
      'for_best_performance': 'للحصول على أفضل أداء ، قم بتنزيل تطبيق :app',
      'gross_line_total': 'إجمالي الخط الإجمالي',
      'bulk_email_invoices': 'فواتير البريد الإلكتروني',
      'bulk_email_quotes': 'عروض البريد الإلكتروني',
      'bulk_email_credits': 'ائتمانات البريد الإلكتروني',
      'from_name': 'من الاسم',
      'clone_to_expense': 'استنساخ للمصروفات',
      'recurring_expense': 'المصاريف المتكررة',
      'recurring_expenses': 'المصاريف المتكررة',
      'new_recurring_expense': 'مصاريف متكررة جديدة',
      'edit_recurring_expense': 'تحرير المصاريف المتكررة',
      'created_recurring_expense': 'تم إنشاء حساب متكرر بنجاح',
      'updated_recurring_expense': 'تم تحديث المصاريف المتكررة بنجاح',
      'archived_recurring_expense': 'تمت أرشفة المصاريف المتكررة بنجاح',
      'deleted_recurring_expense': 'تم حذف النفقات المتكررة بنجاح',
      'removed_recurring_expense': 'تمت إزالة المصاريف المتكررة بنجاح',
      'restored_recurring_expense': 'تمت استعادة النفقات المتكررة بنجاح',
      'search_recurring_expense': 'البحث عن المصاريف المتكررة',
      'search_recurring_expenses': 'البحث عن المصاريف المتكررة',
      'last_sent_date': 'تاريخ آخر إرسال',
      'include_drafts': 'قم بتضمين المسودات',
      'include_drafts_help': 'تضمين مسودة السجلات في التقارير',
      'is_invoiced': 'مفوتر',
      'change_plan': 'إدارة الخطة',
      'persist_data': 'استمرارية البيانات',
      'customer_count': 'عدد العملاء',
      'verify_customers': 'تحقق من العملاء',
      'google_analytics': 'تحليلات كوكل',
      'google_analytics_tracking_id': 'معرف تتبع Google Analytics',
      'decimal_comma': 'فاصلة عشرية',
      'use_comma_as_decimal_place': 'استخدم الفاصلة كمكان عشري في النماذج',
      'select_method': 'حدد الطريقة',
      'select_platform': 'حدد النظام الأساسي',
      'use_web_app_to_connect_gmail':
          'الرجاء استخدام تطبيق الويب للاتصال بـ Gmail',
      'expense_tax_help': 'تم تعطيل معدلات ضريبة العنصر',
      'enable_markdown': 'تمكين Markdown',
      'enable_markdown_help': 'تحويل تخفيض السعر إلى HTML في ملف PDF',
      'user_guide': 'دليل المستخدم',
      'add_second_contact': 'إضافة جهة اتصال ثانية',
      'previous_page': 'الصفحة السابقة',
      'next_page': 'الصفحة التالية',
      'export_colors': 'ألوان التصدير',
      'import_colors': 'استيراد الألوان',
      'clear_all': 'امسح الكل',
      'contrast': 'مقابلة',
      'custom_colors': 'ألوان العرف',
      'colors': 'الألوان',
      'sidebar_active_background_color': 'لون الخلفية النشط للشريط الجانبي',
      'sidebar_active_font_color': 'لون الخط النشط للشريط الجانبي',
      'sidebar_inactive_background_color': 'لون خلفية الشريط الجانبي غير نشط',
      'sidebar_inactive_font_color': 'لون الخط غير النشط للشريط الجانبي',
      'table_alternate_row_background_color': 'لون خلفية الصف البديل للجدول',
      'invoice_header_background_color': 'لون خلفية رأس الفاتورة',
      'invoice_header_font_color': 'لون خط رأس الفاتورة',
      'net_subtotal': 'صافي',
      'review_app': 'مراجعة التطبيق',
      'check_status': 'تحقق من حالة',
      'free_trial': 'تجربة مجانية',
      'free_trial_ends_in_days':
          'تنتهي النسخة التجريبية لخطة Pro في :count يوم ، انقر للترقية.',
      'free_trial_ends_today':
          'اليوم هو اليوم الأخير من الإصدار التجريبي لخطة Pro ، انقر للترقية.',
      'change_email': 'تغيير الايميل',
      'client_portal_domain_hint':
          'اختياريًا ، قم بتكوين مجال بوابة عميل منفصل',
      'tasks_shown_in_portal': 'تظهر المهام في البوابة',
      'uninvoiced': 'صامت',
      'subdomain_guide':
          'يتم استخدام النطاق الفرعي في بوابة العميل لتخصيص الروابط لتتناسب مع علامتك التجارية. على سبيل المثال ، https://your-brand.invoicing.co',
      'send_time': 'وقت الإرسال',
      'import_data': 'بيانات الاستيراد',
      'import_settings': 'اعدادات مهمه',
      'json_file_missing': 'يرجى تقديم ملف JSON',
      'json_option_missing': 'الرجاء تحديد استيراد الإعدادات و / أو البيانات',
      'json': 'جسون',
      'no_payment_types_enabled': 'لم يتم تمكين أنواع الدفع',
      'wait_for_data': 'يرجى الانتظار حتى تنتهي البيانات من التحميل',
      'net_total': 'صافي الإجمالي',
      'has_taxes': 'الضرائب',
      'import_customers': 'عملاء الاستيراد',
      'imported_customers': 'بدأ بنجاح في استيراد العملاء',
      'login_success': 'تسجيل ناجح',
      'login_failure': 'الدخول الفاشلة',
      'exported_data':
          'بمجرد أن يصبح الملف جاهزًا ، ستتلقى رسالة بريد إلكتروني تحتوي على رابط تنزيل',
      'include_deleted_clients': 'تضمين العملاء المحذوفين',
      'include_deleted_clients_help': 'تحميل السجلات الخاصة بالعملاء المحذوفين',
      'step_1_sign_in': 'الخطوة الأولى: تسجيل الدخول',
      'step_2_authorize': 'الخطوة 2: التصريح',
      'account_id': 'معرف الحساب',
      'migration_not_yet_completed': 'لم تكتمل الهجرة بعد',
      'activity_100': ': تم انشاء المستخدم فاتورة متكررة:recurring_invoice',
      'activity_101': ':user الفاتورة المتكررة المحدثة :recurring_invoice',
      'activity_102': ':user الفاتورة المتكررة المؤرشفة :recurring_invoice',
      'activity_103': ':user الفاتورة المتكررة المحذوفة :recurring_invoice',
      'activity_104': ':user الفاتورة المتكررة المستعادة :recurring_invoice',
      'show_task_end_date': 'إظهار تاريخ انتهاء المهمة',
      'show_task_end_date_help': 'قم بتمكين تحديد تاريخ انتهاء المهمة',
      'gateway_setup': 'إعداد البوابة',
      'preview_sidebar': 'معاينة الشريط الجانبي',
      'years_data_shown': 'بيانات السنوات المعروضة',
      'ended_all_sessions': 'تم إنهاء جميع الجلسات بنجاح',
      'end_all_sessions': 'إنهاء جميع الجلسات',
      'count_session': 'جلسة واحدة',
      'count_sessions': 'الجلسات :count',
      'invoice_created': 'الفاتورة المُنشأة',
      'quote_created': 'إنشاء اقتباس',
      'credit_created': 'تم إنشاء الائتمان',
      'pro': 'طليعة',
      'enterprise': 'مَشرُوع',
      'last_updated': 'آخر تحديث',
      'invoice_item': 'بند الفاتورة',
      'quote_item': 'عنصر اقتباس',
      'contact_first_name': 'اتصل بالاسم الأول',
      'contact_last_name': 'الاسم الأخير للاتصال',
      'order': 'طلب',
      'unassigned': 'غير معين',
      'partial_value': 'يجب أن يكون أكبر من صفر وأقل من الإجمالي',
      'search_kanban': 'ابحث في كانبان',
      'search_kanbans': 'ابحث في كانبان',
      'kanban': 'كانبان',
      'enable': 'تفعيل',
      'move_top': 'تحريك للأعلى',
      'move_up': 'تحرك',
      'move_down': 'تحرك لأسفل',
      'move_bottom': 'تحريك لأسفل',
      'subdomain_help':
          'قم بتعيين المجال الفرعي أو عرض الفاتورة على موقع الويب الخاص بك.',
      'body_variable_missing':
          'خطأ: يجب أن يشتمل البريد الإلكتروني المخصص على متغير :body',
      'add_body_variable_message': 'تأكد من تضمين متغير :body',
      'view_date_formats': 'عرض تنسيقات التاريخ',
      'is_viewed': 'وينظر',
      'letter': 'خطاب',
      'legal': 'قانوني',
      'page_layout': 'تخطيط الصفحة',
      'portrait': 'لَوحَة',
      'landscape': 'منظر جمالي',
      'owner_upgrade_to_paid_plan':
          'يمكن لمالك الحساب الترقية إلى خطة مدفوعة لتمكين الإعدادات المتقدمة',
      'upgrade_to_paid_plan':
          'قم بالترقية إلى خطة مدفوعة لتمكين الإعدادات المتقدمة',
      'invoice_payment_terms': 'شروط دفع الفاتورة',
      'quote_valid_until': 'اقتباس صالح حتى',
      'no_headers': 'لا رؤوس',
      'add_header': 'إضافة رأس',
      'remove_header': 'إزالة الرأس',
      'return_url': 'عودة URL',
      'rest_method': 'طريقة REST',
      'header_key': 'مفتاح الرأس',
      'header_value': 'قيمة الرأس',
      'recurring_products': 'المنتجات المتكررة',
      'promo_code': 'رمز ترويجي',
      'promo_discount': 'الخصم الترويجي',
      'allow_cancellation': 'السماح بالإلغاء',
      'per_seat_enabled': 'تمكين لكل جهاز',
      'max_seats_limit': 'الحد الأقصى لعدد المقاعد',
      'trial_enabled': 'تم تمكين التجربة',
      'trial_duration': 'مدة التجربة',
      'allow_query_overrides': 'السماح بتجاوزات الاستعلام',
      'allow_plan_changes': 'السماح بتغييرات الخطة',
      'plan_map': 'خريطة الخطة',
      'refund_period': 'فترة الاسترداد',
      'webhook_configuration': 'تكوين Webhook',
      'purchase_page': 'صفحة الشراء',
      'security': 'حماية',
      'email_bounced': 'ارتد البريد الإلكتروني',
      'email_spam_complaint': 'شكوى بشأن البريد العشوائي',
      'email_delivery': 'تسليم البريد الإلكتروني',
      'webhook_response': 'استجابة Webhook',
      'pdf_response': 'استجابة PDF',
      'authentication_failure': 'فشل المصادقة',
      'pdf_failed': 'فشل ملف PDF',
      'pdf_success': 'نجاح PDF',
      'modified': 'معدل',
      'payment_link': 'رابط الدفع',
      'new_payment_link': 'رابط دفع جديد',
      'edit_payment_link': 'تحرير رابط الدفع',
      'created_payment_link': 'تم إنشاء رابط الدفع بنجاح',
      'updated_payment_link': 'تم تحديث رابط الدفع بنجاح',
      'archived_payment_link': 'تمت أرشفة رابط الدفع بنجاح',
      'deleted_payment_link': 'تم حذف رابط الدفع بنجاح',
      'removed_payment_link': 'تمت إزالة رابط الدفع بنجاح',
      'restored_payment_link': 'تمت استعادة رابط الدفع بنجاح',
      'search_payment_link': 'بحث 1 رابط الدفع',
      'search_payment_links': 'بحث: حساب روابط الدفع',
      'subdomain_is_not_available': 'المجال الفرعي غير متوفر',
      'connect_gmail': 'ربط Gmail',
      'disconnect_gmail': 'افصل Gmail',
      'connected_gmail': 'تم توصيل Gmail بنجاح',
      'disconnected_gmail': 'قطع اتصال Gmail بنجاح',
      'update_fail_help':
          'قد تؤدي التغييرات التي تم إجراؤها على مصدر البرنامج إلى حظر التحديث ، يمكنك تشغيل هذا الأمر لتجاهل التغييرات:',
      'client_id_number': 'رقم هوية العميل',
      'count_minutes': '0 دقيقة',
      'password_timeout': 'مهلة كلمة المرور',
      'shared_invoice_credit_counter': 'فاتورة الأسهم / عداد الائتمان',
      'use_last_email': 'استخدم البريد الإلكتروني الأخير',
      'activate_company': 'تفعيل الشركة',
      'activate_company_help':
          'تمكين رسائل البريد الإلكتروني والفواتير المتكررة والإشعارات',
      'an_error_occurred_try_again': 'حدث خطأ ، يرجى المحاولة مرة أخرى',
      'please_first_set_a_password': 'يرجى أولا تعيين كلمة مرور',
      'changing_phone_disables_two_factor':
          'تحذير: سيؤدي تغيير رقم هاتفك إلى تعطيل المصادقة الثنائية',
      'help_translate': 'مساعدة الترجمة',
      'please_select_a_country': 'رجاء قم بإختيار دوله',
      'resend_invite': 'اعادة ارسال الدعوة',
      'disabled_two_factor': 'تم تعطيل 2FA بنجاح',
      'connected_google': 'تم ربط الحساب بنجاح',
      'disconnected_google': 'تم قطع اتصال الحساب بنجاح',
      'delivered': 'تم التوصيل',
      'bounced': 'ارتد',
      'spam': 'رسائل إلكترونية مزعجة',
      'view_docs': 'عرض المستندات',
      'enter_phone_to_enable_two_factor':
          'يرجى تقديم رقم هاتف محمول لتمكين المصادقة الثنائية',
      'send_sms': 'أرسل رسالة نصية قصيرة',
      'sms_code': 'رمز الرسائل القصيرة',
      'two_factor_setup_help':
          'امسح الرمز الشريطي ضوئيًا باستخدام تطبيق متوافق مع :link.',
      'enabled_two_factor': 'تم تمكين المصادقة الثنائية بنجاح',
      'connect_google': 'ربط جوجل',
      'disconnect_google': 'افصل Google',
      'enable_two_factor': 'توثيق ذو عاملين',
      'disable_two_factor': 'تعطيل العامل الثاني',
      'require_password_with_social_login':
          'طلب كلمة المرور مع تسجيل الدخول الاجتماعي',
      'stay_logged_in': 'ابق متصلا',
      'session_about_to_expire': 'تحذير: جلستك على وشك الانتهاء',
      'count_hours': ':count ساعة',
      'count_day': 'يوم 1',
      'count_days': ':count أيام',
      'web_session_timeout': 'مهلة جلسة الويب',
      'security_settings': 'اعدادات الامان',
      'resend_email': 'إعادة إرسال البريد الإلكتروني',
      'confirm_your_email_address':
          'يرجى تأكيد عنوان البريد الإلكتروني الخاص بك',
      'refunded_payment': 'المبلغ المردود',
      'partially_unapplied': 'غير مطبق جزئيًا',
      'select_a_gmail_user': 'الرجاء تحديد مستخدم تمت مصادقته مع Gmail',
      'list_long_press': 'اضغط على قائمة طويلة',
      'show_actions': 'إظهار الإجراءات',
      'start_multiselect': 'بدء التحديد المتعدد',
      'email_sent_to_confirm_email':
          'تم إرسال بريد إلكتروني لتأكيد عنوان البريد الإلكتروني',
      'counter_pattern_error':
          'لاستخدام :client_counter الرجاء إضافة إما :client_number أو :client_id_number لمنع التعارضات',
      'this_quarter': 'هذا الربع',
      'last_quarter': 'الربع الأخير',
      'to_update_run': 'لتحديث المدى',
      'convert_to_invoice': 'تحويل إلى فاتورة',
      'registration_url': 'URL التسجيل',
      'invoice_project': 'مشروع الفاتورة',
      'invoice_task': 'مهمة الفاتورة',
      'invoice_expense': 'مصاريف الفاتورة',
      'search_payment_term': 'بحث 1 مصطلح الدفع',
      'search_payment_terms': 'ابحث عن شروط الدفع في :count',
      'save_and_preview': 'حغظ واستعراض',
      'save_and_email': 'حفظ وإرسال بريد',
      'supported_events': 'الأحداث المدعومة',
      'converted_amount': 'المبلغ المحول',
      'converted_balance': 'الرصيد المحول',
      'converted_paid_to_date': 'تم تحويله إلى تاريخ',
      'converted_credit_balance': 'رصيد الائتمان المحول',
      'converted_total': 'المجموع المحول',
      'is_sent': 'أرسل',
      'default_documents': 'المستندات الافتراضية',
      'document_upload': 'تحميل الوثيقة',
      'document_upload_help': 'تمكين العملاء من تحميل المستندات',
      'expense_total': 'إجمالي المصروف',
      'enter_taxes': 'أدخل الضرائب',
      'by_rate': 'بالنسبة',
      'by_amount': 'بالقيمة',
      'enter_amount': 'أدخل القيمة',
      'before_taxes': 'قبل الضرائب',
      'after_taxes': 'بعد الضرائب',
      'color': 'اللون',
      'show': 'يعرض',
      'hide': 'يخفي',
      'empty_columns': 'الأعمدة الفارغة',
      'debug_mode_is_enabled': 'تم تمكين وضع التصحيح',
      'debug_mode_is_enabled_help':
          'تحذير: إنه مخصص للاستخدام على الأجهزة المحلية ، ويمكن أن يؤدي إلى تسريب بيانات الاعتماد. اضغط لتتعلم المزيد.',
      'running_tasks': 'المهام النشطة',
      'recent_tasks': 'المهام الأخيرة',
      'recent_expenses': 'المصاريف الأخيرة',
      'upcoming_expenses': 'المصاريف القادمة',
      'update_app': 'تحديث التطبيق',
      'started_import': 'بدأ الاستيراد بنجاح',
      'duplicate_column_mapping': 'تكرار تعيين العمود',
      'uses_inclusive_taxes': 'يستخدم الضرائب الشاملة',
      'is_amount_discount': 'هو مبلغ الخصم',
      'column': 'عمود',
      'sample': 'عينة',
      'map_to': 'الخريطة ل',
      'import': 'استيراد',
      'first_row_as_column_names': 'استخدم الصف الأول كأسماء أعمدة',
      'select_file': 'يرجى اختيار ملف',
      'no_file_selected': 'لم يتم اختيار اي ملف',
      'csv_file': 'ملف CSV',
      'csv': 'CSV',
      'freshbooks': 'FreshBooks',
      'invoice2go': 'Invoice2go',
      'invoicely': 'بشكل غير مباشر',
      'waveaccounting': 'محاسبة الموجة',
      'zoho': 'زوهو',
      'accounting': 'محاسبة',
      'required_files_missing': 'يرجى تقديم جميع ملفات CSV.',
      'import_type': 'نوع الاستيراد',
      'html_mode': 'وضع HTML',
      'html_mode_help': 'معاينة التحديثات بشكل أسرع ولكنها أقل دقة',
      'view_licenses': 'عرض التراخيص',
      'webhook_url': 'عنوان URL للويب هوك',
      'fullscreen_editor': 'محرر ملء الشاشة',
      'sidebar_editor': 'محرر الشريط الجانبي',
      'please_type_to_confirm': 'الرجاء كتابة &quot;:value&quot; للتأكيد',
      'purge': 'تطهير',
      'service': 'خدمة',
      'clone_to': 'نسخ إلى',
      'clone_to_other': 'نسخ لأخرى',
      'labels': 'العلامات',
      'add_custom': 'أضف مخصص',
      'payment_tax': 'ضريبة الدفع',
      'unpaid': 'غير مدفوعة',
      'white_label': 'العلامة البيضاء',
      'delivery_note': 'مذكرة تسليم',
      'sent_invoices_are_locked': 'الفواتير المرسلة مقفولة',
      'paid_invoices_are_locked': 'الفواتير المدفوعة مقفولة',
      'source_code': 'كود المصدر',
      'app_platforms': 'منصات التطبيق',
      'invoice_late': 'فاتورة متأخرة',
      'quote_expired': 'انتهى الاقتباس',
      'partial_due': 'استحقاق جزئي',
      'invoice_total': 'مجموع الفاتورة',
      'quote_total': 'إجمالي عرض السعر',
      'credit_total': 'إجمالي الائتمان',
      'recurring_invoice_total': 'إجمالي الفاتورة',
      'actions': 'الإجراءات',
      'expense_number': 'رقم المصاريف',
      'task_number': 'رقم المهمة',
      'project_number': 'رقم المشروع',
      'project_name': 'اسم المشروع',
      'warning': 'تحذير',
      'view_settings': 'عرض الإعدادات',
      'company_disabled_warning': 'تحذير: هذه الشركة لم يتم تفعيلها بعد',
      'late_invoice': 'فاتورة متأخرة',
      'expired_quote': 'عرض أسعار منتهي الصلاحية',
      'remind_invoice': 'تذكير الفاتورة',
      'cvv': 'CVV',
      'client_name': 'اسم العميل',
      'client_phone': 'هاتف العميل',
      'required_fields': 'الحقول المطلوبة',
      'calculated_rate': 'السعر المحسوب',
      'default_task_rate': 'معدل المهمة الافتراضي',
      'clear_cache': 'مسح التخزين المؤقت',
      'sort_order': 'امر ترتيب',
      'task_status': 'الحالة',
      'task_statuses': 'حالات المهمة',
      'new_task_status': 'حالة مهمة جديدة',
      'edit_task_status': 'تحرير حالة المهمة',
      'created_task_status': 'تم إنشاء حالة المهمة بنجاح',
      'updated_task_status': 'تم تحديث حالة المهمة بنجاح',
      'archived_task_status': 'تمت أرشفة حالة المهمة بنجاح',
      'deleted_task_status': 'تم حذف حالة المهمة بنجاح',
      'removed_task_status': 'تمت إزالة حالة المهمة بنجاح',
      'restored_task_status': 'تمت استعادة حالة المهمة بنجاح',
      'archived_task_statuses': 'تمت أرشفة حالات مهمة :value بنجاح',
      'deleted_task_statuses': 'تم حذف حالات مهمة :value بنجاح',
      'restored_task_statuses': 'تمت استعادة حالات مهمة :value بنجاح',
      'search_task_status': 'بحث 1 حالة المهمة',
      'search_task_statuses': 'ابحث في حالة مهام :count',
      'show_tasks_table': 'إظهار جدول المهام',
      'show_tasks_table_help': 'اعرض قسم المهام دائمًا عند إنشاء الفواتير',
      'invoice_task_timelog': 'فاتورة مهمة Timelog',
      'invoice_task_timelog_help': 'أضف تفاصيل الوقت إلى بنود الفاتورة',
      'invoice_task_datelog': 'سجل بيانات مهمة الفاتورة',
      'invoice_task_datelog_help': 'أضف تفاصيل التاريخ إلى بنود الفاتورة',
      'auto_start_tasks_help': 'ابدأ المهام قبل الحفظ',
      'configure_statuses': 'تكوين الحالات',
      'task_settings': 'إعدادات المهام',
      'configure_categories': 'تكوين الفئات',
      'expense_categories': 'فئات المصاريف',
      'new_expense_category': 'فئة المصاريف الجديدة',
      'edit_expense_category': 'تحرير فئة المصاريف',
      'created_expense_category': 'تم إنشاء فئة المصاريف بنجاح',
      'updated_expense_category': 'تم تحديث فئة المصاريف بنجاح',
      'archived_expense_category': 'تمت أرشفة فئة المصاريف بنجاح',
      'deleted_expense_category': 'تم حذف الفئة بنجاح',
      'removed_expense_category': 'تمت إزالة فئة المصاريف بنجاح',
      'restored_expense_category': 'تمت استعادة فئة المصروفات بنجاح',
      'archived_expense_categories': 'تمت أرشفة فئة المصاريف :count بنجاح',
      'deleted_expense_categories': 'تم حذف فئات المصاريف :value بنجاح',
      'restored_expense_categories': 'تمت استعادة فئات المصاريف :value بنجاح',
      'search_expense_category': 'بحث 1 فئة المصاريف',
      'search_expense_categories': 'ابحث في :count فئات المصاريف',
      'use_available_credits': 'استخدم الاعتمادات المتاحة',
      'show_option': 'خيار العرض',
      'negative_payment_error': 'لا يمكن أن يتجاوز مبلغ الائتمان مبلغ الدفع',
      'view_changes': 'عرض التعديلات',
      'force_update': 'تحديث إجباري',
      'force_update_help':
          'أنت تقوم بتشغيل أحدث إصدار ولكن قد تكون هناك إصلاحات معلقة متاحة.',
      'mark_paid_help': 'تم دفع المسار النفقة',
      'should_be_invoiced': 'ينبغي تحرير فاتورة',
      'should_be_invoiced_help': 'تفعيل النفقات لتتم فوترتها',
      'add_documents_to_invoice_help': 'اجعل المستندات مرئية للعميل',
      'convert_currency_help': 'حدد سعر الصرف',
      'expense_settings': 'إعدادات المصاريف',
      'clone_to_recurring': 'استنساخ للتكرار',
      'crypto': 'تشفير',
      'paypal': 'باي بال',
      'alipay': 'أليباي',
      'sofort': 'سوفورت',
      'apple_pay': 'Apple / Google Pay',
      'user_field': 'مجال المستخدم',
      'variables': 'المتغيرات',
      'show_password': 'إظهار كلمة المرور',
      'hide_password': 'إخفاء كلمة المرور',
      'copy_error': 'خطأ بالنسخ',
      'capture_card': 'القبض على البطاقة',
      'auto_bill_enabled': 'تمكين فاتورة السيارات',
      'total_taxes': 'مجموع الضرائب',
      'line_taxes': 'ضرائب البنود',
      'total_fields': 'إجمالي الحقول',
      'stopped_recurring_invoice': 'تم إيقاف الفاتورة المتكررة بنجاح',
      'started_recurring_invoice': 'بدء الفاتورة المتكررة بنجاح',
      'resumed_recurring_invoice': 'تم استئناف الفاتورة المتكررة بنجاح',
      'gateway_refund': 'رد أموال البوابة',
      'gateway_refund_help': 'معالجة عملية الاسترداد من خلال بوابة الدفع',
      'due_date_days': 'تاريخ الاستحقاق',
      'paused': 'متوقف مؤقتاً',
      'mark_active': 'مارك بالموقع',
      'day_count': 'اليوم :count',
      'first_day_of_the_month': 'أول يوم في الشهر',
      'last_day_of_the_month': 'آخر يوم في الشهر',
      'use_payment_terms': 'استخدام شروط الدفع',
      'endless': 'بلا نهاية',
      'next_send_date': 'تاريخ الإرسال التالي',
      'remaining_cycles': 'الدورات المتبقية',
      'recurring_invoice': 'فاتورة متكررة',
      'recurring_invoices': 'الفواتير الدورية',
      'new_recurring_invoice': 'فاتورة متكررة جديدة',
      'edit_recurring_invoice': 'تحرير الفاتورة المتكررة',
      'created_recurring_invoice': 'تم إنشاء الفاتورة المتكررة بنجاح',
      'updated_recurring_invoice': 'تم تحديث الفاتورة المتكررة بنجاح',
      'archived_recurring_invoice': 'تمت أرشفة الفاتورة المتكررة بنجاح',
      'deleted_recurring_invoice': 'تم حذف الفاتورة المتكررة بنجاح',
      'removed_recurring_invoice': 'تمت إزالة الفاتورة المتكررة بنجاح',
      'restored_recurring_invoice': 'تمت استعادة الفاتورة المتكررة بنجاح',
      'archived_recurring_invoices': 'تمت أرشفة فواتير :value المتكررة بنجاح',
      'deleted_recurring_invoices': 'تم حذف فواتير :value المتكررة بنجاح',
      'restored_recurring_invoices': 'تمت استعادة فواتير :value المتكررة بنجاح',
      'search_recurring_invoice': 'بحث 1 فاتورة متكررة',
      'search_recurring_invoices': 'ابحث في :count الفواتير المتكررة',
      'send_date': 'تاريخ الإرسال',
      'auto_bill_on': 'فوترة تلقائية في',
      'minimum_under_payment_amount': 'الحد الأدنى لمبلغ الدفع',
      'profit': 'ربح',
      'line_item': 'خط سلعة',
      'allow_over_payment': 'السماح بالدفع الزائد',
      'allow_over_payment_help': 'دعم دفع مبلغ إضافي لقبول الإكراميات',
      'allow_under_payment': 'السماح بالدفع الناقص',
      'allow_under_payment_help':
          'دعم دفع الحد الأدنى من مبلغ الإيداع / الجزئي',
      'test_mode': 'الوضع التجريبي',
      'opened': 'افتتح',
      'payment_reconciliation_failure': 'فشل المصالحة',
      'payment_reconciliation_success': 'نجاح المصالحة',
      'gateway_success': 'نجاح البوابة',
      'gateway_failure': 'فشل البوابة',
      'gateway_error': 'خطأ في البوابة',
      'email_send': 'إرسال بريد',
      'email_retry_queue': 'قائمة انتظار إعادة محاولة البريد الإلكتروني',
      'failure': 'فشل',
      'quota_exceeded': 'حصة تجاوزت',
      'upstream_failure': 'فشل المنبع',
      'system_logs': 'تقارير النظام',
      'view_portal': 'عرض البوابة',
      'copy_link': 'نسخ الرابط',
      'token_billing': 'حفظ تفاصيل البطاقة',
      'welcome_to_invoice_ninja': 'أهلا بك في Invoice Ninja',
      'always': 'دائماً',
      'optin': 'اشتراك',
      'optout': 'إلغاء اشتراك',
      'label': 'ملصق',
      'client_number': 'رقم الزبون',
      'auto_convert': 'تحويل تلقائي',
      'company_name': 'اسم الشركة',
      'reminder1_sent': 'تم إرسال التذكير 1',
      'reminder2_sent': 'تم إرسال التذكير 2',
      'reminder3_sent': 'تم إرسال التذكير 3',
      'reminder_last_sent': 'تم إرسال التذكير الأخير',
      'pdf_page_info': 'الصفحة :current من :total',
      'emailed_invoices': 'إرسال الفواتير عبر البريد الإلكتروني بنجاح',
      'emailed_quotes': 'الاقتباسات المرسلة عبر البريد الإلكتروني بنجاح',
      'emailed_credits': 'الاعتمادات المرسلة بنجاح عبر البريد الإلكتروني',
      'gateway': 'بوابة',
      'view_in_stripe': 'عرض في Stripe',
      'rows_per_page': 'الصفوف في الصفحة',
      'hours': 'ساعات',
      'statement': 'كشف حساب',
      'taxes': 'ضرائب',
      'surcharge': 'تكلفة إضافية',
      'apply_payment': 'تطبيق الدفع',
      'apply_credit': 'تطبيق الائتمان',
      'apply': 'يتقدم',
      'unapplied': 'غير مطبق',
      'select_label': 'حدد تسمية',
      'custom_labels': 'تسميات مخصصة',
      'record_type': 'نوع السجل',
      'record_name': 'اسم السجل',
      'file_type': 'نوع الملف',
      'height': 'الطول',
      'width': 'العرض',
      'to': 'ل',
      'health_check': 'فحص الحالة',
      'payment_type_id': 'نوع الدفعة',
      'last_login_at': 'آخر دخول في',
      'company_key': 'مفتاح الشركة',
      'storefront': 'واجهة المتجر',
      'storefront_help': 'قم بتمكين تطبيقات الطرف الثالث لإنشاء الفواتير',
      'client_created': 'تم إنشاء العميل',
      'online_payment_email': 'البريد الإلكتروني للدفع عبر الإنترنت',
      'manual_payment_email': 'البريد الإلكتروني للدفع اليدوي',
      'completed': 'منتهي',
      'gross': 'النمو',
      'net_amount': 'القيمة الصافية',
      'net_balance': 'الرصيد الصافي',
      'client_settings': 'إعدادات العميل',
      'selected_invoices': 'الفواتير المختارة',
      'selected_payments': 'الدفعات المختارة',
      'selected_quotes': 'العروض المختارة',
      'selected_tasks': 'المهام المختارة',
      'selected_expenses': 'المصاريف المختارة',
      'upcoming_invoices': 'الفواتير القادمة',
      'past_due_invoices': 'الفواتير المتأخرة',
      'recent_payments': 'المدفوعات الأخيرة',
      'upcoming_quotes': 'الاقتباسات القادمة',
      'expired_quotes': 'اقتباسات منتهية الصلاحية',
      'create_client': 'إنشاء عميل',
      'create_invoice': 'إنشاء فاتورة',
      'create_quote': 'إنشاء عرض سعر',
      'create_payment': 'أنشئ دفعة',
      'create_vendor': 'إنشاء بائع',
      'update_quote': 'تعديل العرض',
      'delete_quote': 'مسح عرض السعر',
      'update_invoice': 'تعديل الفاتورة',
      'delete_invoice': 'حذف الفاتورة',
      'update_client': 'تعديل العميل',
      'delete_client': 'حذف العميل',
      'delete_payment': 'حذف الدفعة',
      'update_vendor': 'تعديل المورد',
      'delete_vendor': 'حذف البائع',
      'create_expense': 'أنشئ مصروف',
      'update_expense': 'تعديل المصروف',
      'delete_expense': 'حذف المصاريف',
      'create_task': 'إنشاء مهمة',
      'update_task': 'تعديل المهمة',
      'delete_task': 'حذف المهمة',
      'approve_quote': 'قبول العرض',
      'off': 'عن',
      'when_paid': 'متى ستدفع',
      'expires_on': 'ينتهي في',
      'free': 'حر',
      'plan': 'يخطط',
      'show_sidebar': 'عرض الشريط الجانبي',
      'hide_sidebar': 'إخفاء الشريط الجانبي',
      'event_type': 'ع الحدث',
      'target_url': 'هدف',
      'copy': 'ينسخ',
      'must_be_online': 'يرجى إعادة تشغيل التطبيق عند الاتصال بالشبكة',
      'crons_not_enabled': 'يجب تمكين crons',
      'api_webhooks': 'API Webhooks',
      'search_webhooks': 'ابحث في :count Webhooks',
      'search_webhook': 'ابحث في 1 Webhook',
      'webhook': 'الويب هوك',
      'webhooks': 'ويب هوك',
      'new_webhook': 'Webhook الجديد',
      'edit_webhook': 'تحرير Webhook',
      'created_webhook': 'تم إنشاء الرد التلقائي على الويب بنجاح',
      'updated_webhook': 'تم تحديث الويب هوك بنجاح',
      'archived_webhook': 'تمت أرشفة webhook بنجاح',
      'deleted_webhook': 'تم حذف الويب هوك بنجاح',
      'removed_webhook': 'تمت إزالة الويب هوك بنجاح',
      'restored_webhook': 'تمت استعادة Webhook بنجاح',
      'archived_webhooks': 'تمت أرشفة خطافات الويب :value بنجاح',
      'deleted_webhooks': 'تم حذف خطافات الويب :value بنجاح',
      'removed_webhooks': 'تمت إزالة خطافات الويب :value بنجاح',
      'restored_webhooks': 'تمت استعادة خطافات الويب :value بنجاح',
      'api_tokens': 'رموز API',
      'api_docs': 'مستندات API',
      'search_tokens': 'ابحث في :count الرموز',
      'search_token': 'ابحث عن 1 رمز',
      'token': 'رمز',
      'tokens': 'الرموز',
      'new_token': 'رمز جديد',
      'edit_token': 'تحرير الرمز',
      'created_token': 'تم إنشاء الرمز المميز بنجاح',
      'updated_token': 'تم تحديث الرمز المميز بنجاح',
      'archived_token': 'تم أرشفة الرمز المميز بنجاح',
      'deleted_token': 'تم حذف الرمز المميز بنجاح',
      'removed_token': 'تم مسح الرمز بنجاح',
      'restored_token': 'تم استعادة الرمز بنجاح',
      'archived_tokens': 'تمت أرشفة الرموز المميزة :value بنجاح',
      'deleted_tokens': 'تم حذف الرموز المميزة :value بنجاح',
      'restored_tokens': 'تمت استعادة الرموز المميزة لـ :value بنجاح',
      'client_registration': 'تسجيل العميل',
      'client_registration_help': 'تمكين العملاء من التسجيل الذاتي في البوابة',
      'email_invoice': 'ارسال الفاتورة عبر الايميل',
      'email_quote': 'إرسال عرض السعر',
      'email_credit': 'رصيد البريد الإلكتروني',
      'email_payment': 'الدفع بالبريد الإلكتروني',
      'client_email_not_set': 'لا يوجد بريد إلكتروني مسجل للعميل',
      'ledger': 'موازنة',
      'view_pdf': 'عرض ملف PDF',
      'all_records': 'جميع السجلات',
      'owned_by_user': 'العائدة للمستخدم',
      'credit_remaining': 'الرصيد المتبقي',
      'contact_name': 'اسم جهة الاتصال',
      'use_default': 'استخدم الافتراضي',
      'reminder_endless': 'تذكير لا نهاية لها',
      'number_of_days': 'عدد الأيام',
      'configure_payment_terms': 'إعداد شروط الدفع',
      'payment_term': 'شرط الدفع',
      'new_payment_term': 'شرط دفع جديد',
      'edit_payment_term': 'تحرير مصطلح الدفع',
      'created_payment_term': 'تم إنشاء مصطلح الدفع بنجاح',
      'updated_payment_term': 'تم تحديث مصطلح الدفع بنجاح',
      'archived_payment_term': 'تمت أرشفة مصطلح الدفع بنجاح',
      'deleted_payment_term': 'تم حذف شرط الدفع بنجاح',
      'removed_payment_term': 'تمت إزالة شرط الدفع بنجاح',
      'restored_payment_term': 'تم استرجاع شرط الدفع بنجاح',
      'archived_payment_terms': 'تمت أرشفة شروط الدفع :value بنجاح',
      'deleted_payment_terms': 'تم حذف شروط الدفع :value بنجاح',
      'restored_payment_terms': 'تمت استعادة شروط الدفع :value بنجاح',
      'email_sign_in': 'تسجيل الدخول بالبريد الإلكتروني',
      'change': 'تغيير',
      'change_to_mobile_layout': 'تحويل إلى تنسيق الجوال',
      'change_to_desktop_layout': 'تحويل إلى تنسيق سطح المكتب',
      'send_from_gmail': 'أرسل من Gmail',
      'reversed': 'معكوس',
      'cancelled': 'ملغى',
      'credit_amount': 'مبلغ الائتمان',
      'quote_amount': 'قيمة العرض',
      'hosted': 'مستضاف',
      'selfhosted': 'استضافة خاصة',
      'exclusive': 'حصري',
      'inclusive': 'شامل',
      'hide_menu': 'إخفاء القائمة',
      'show_menu': 'إظهار القائمة',
      'partially_refunded': 'المردودة جزئيا',
      'search_documents': 'البحث عن الملفات',
      'search_designs': 'البحث عن التصاميم',
      'search_invoices': 'البحث عن الفواتير',
      'search_clients': 'البحث عن العملاء',
      'search_products': 'البحث عن المنتجات',
      'search_quotes': 'البحث في العروض',
      'search_credits': 'البحث عن الأرصدة',
      'search_vendors': 'البحث عن الموردين',
      'search_users': 'البحث عن المستخدمين',
      'search_tax_rates': 'البحث في معدلات الضرائب',
      'search_tasks': 'البحث في المهام',
      'search_settings': 'البحث في الإعدادات',
      'search_projects': 'البحث في المشاريع',
      'search_expenses': 'البحث في المصاريف',
      'search_payments': 'البحث في الدفعات',
      'search_groups': 'البحث في المجموعات',
      'search_company': 'البحث عن شركة',
      'search_document': 'ابحث عن مستند واحد',
      'search_design': 'بحث 1 تصميم',
      'search_invoice': 'بحث 1 فاتورة',
      'search_client': 'بحث 1 عميل',
      'search_product': 'بحث 1 منتج',
      'search_quote': 'بحث 1 اقتباس',
      'search_credit': 'بحث 1 الائتمان',
      'search_vendor': 'ابحث عن بائع واحد',
      'search_user': 'بحث 1 مستخدم',
      'search_tax_rate': 'بحث 1 معدل الضريبة',
      'search_task': 'بحث 1 المهام',
      'search_project': 'بحث 1 مشروع',
      'search_expense': 'بحث 1 حساب',
      'search_payment': 'بحث 1 الدفع',
      'search_group': 'بحث 1 مجموعة',
      'refund_payment': 'دفع مبلغ معاد',
      'cancelled_invoice': 'فاتورة ملغاة بنجاح',
      'cancelled_invoices': 'فواتير ملغاة بنجاح',
      'reversed_invoice': 'تم عكس الفاتورة بنجاح',
      'reversed_invoices': 'تم عكس الفواتير بنجاح',
      'reverse': 'يعكس',
      'full_name': 'الاسم الكامل',
      'city_state_postal': 'المدينة / الولاية / البريد',
      'postal_city_state': 'البريد / المدينة / الولاية',
      'custom1': 'أول مخصص',
      'custom2': 'العرف الثاني',
      'custom3': 'العرف الثالث',
      'custom4': 'العرف الرابع',
      'optional': 'خياري',
      'license': 'رخصة',
      'purge_data': 'تطهير البيانات',
      'purge_successful': 'تم حذف بيانات الشركة بنجاح',
      'purge_data_message':
          'تحذير: سيؤدي هذا إلى محو بياناتك بشكل دائم ، ولا يوجد تراجع.',
      'invoice_balance': 'رصيد الفاتورة',
      'age_group_0': '0-30 يوم',
      'age_group_30': '30-60 يوم',
      'age_group_60': '60-90 يوم',
      'age_group_90': '90 - 120 يوم',
      'age_group_120': '120+ يوم',
      'refresh': 'ينعش',
      'saved_design': 'تم حفظ التصميم بنجاح',
      'client_details': 'تفاصيل العميل',
      'company_address': 'عنوان الشركة',
      'invoice_details': 'تفاصيل الفاتورة',
      'quote_details': 'تفاصيل الاقتباس',
      'credit_details': 'تفاصيل الائتمان',
      'product_columns': 'أعمدة المنتج',
      'task_columns': 'أعمدة المهام',
      'add_field': 'إضافة حقل',
      'all_events': 'كل الأحداث',
      'permissions': 'أذونات',
      'none': 'لا أحد',
      'owned': 'مملوكة',
      'payment_success': 'الدفع الناجح',
      'payment_failure': 'فشل الدفع',
      'invoice_sent': 'إرسال فاتورة :count',
      'quote_sent': 'أرسل اقتباس',
      'credit_sent': 'تم إرسال الائتمان',
      'invoice_viewed': 'عرض الفاتورة',
      'quote_viewed': 'عرض اقتباس',
      'credit_viewed': 'مشاهدة الائتمان',
      'quote_approved': 'تمت الموافقة على اقتباس',
      'receive_all_notifications': 'تلقي كافة الإخطارات',
      'purchase_license': 'رخصة شراء',
      'apply_license': 'تطبيق الترخيص',
      'cancel_account': 'حذف حساب',
      'cancel_account_message':
          'تحذير: هذه العملية ستقوم بحذف حسابك بشكل دائم ولا يمكنك التراجع بعدها',
      'delete_company': 'حذف الشركة',
      'delete_company_message':
          'تحذير: سيؤدي هذا إلى حذف شركتك نهائيًا ، ولا يوجد تراجع.',
      'enabled_modules': 'الوحدات الممكّنة',
      'converted_quote': 'تم تحويل الاقتباس بنجاح',
      'credit_design': 'تصميم الائتمان',
      'includes': 'يشمل',
      'header': 'رأس',
      'load_design': 'تصميم التحميل',
      'css_framework': 'إطار عمل CSS',
      'custom_designs': 'تصاميم مخصصة',
      'designs': 'تصميمات',
      'new_design': 'تصميم جديد',
      'edit_design': 'تحرير التصميم',
      'created_design': 'تم إنشاء التصميم بنجاح',
      'updated_design': 'تم تحديث التصميم بنجاح',
      'archived_design': 'تمت أرشفة التصميم بنجاح',
      'deleted_design': 'تم حذف التصميم بنجاح',
      'removed_design': 'تمت إزالة التصميم بنجاح',
      'restored_design': 'تمت استعادة التصميم بنجاح',
      'archived_designs': 'تمت أرشفة تصاميم :value بنجاح',
      'deleted_designs': 'تم حذف تصميمات :value بنجاح',
      'restored_designs': 'تمت استعادة تصميمات :value بنجاح',
      'proposals': 'اقتراحات',
      'tickets': 'التذاكر',
      'recurring_quotes': 'الفواتير الدورية',
      'recurring_tasks': 'المهام المتكررة',
      'account_management': 'ادارة الحساب',
      'credit_date': 'تاريخ الائتمان',
      'credit': 'دائن',
      'credits': 'الأرصدة',
      'new_credit': 'أدخل الرصيد',
      'edit_credit': 'تحرير الائتمان',
      'created_credit': 'تم إنشاء القرض بنجاح',
      'updated_credit': 'تم تحديث الائتمان بنجاح',
      'archived_credit': 'تم ارشفة القرض بنجاح',
      'deleted_credit': 'تم حذف القرض بنجاح',
      'removed_credit': 'تمت إزالة الائتمان بنجاح',
      'restored_credit': 'تمت استعادة الائتمان بنجاح',
      'archived_credits': 'تم ارشفة  :count فروض',
      'deleted_credits': 'تم حذف :count قروض بنجاح',
      'restored_credits': 'تمت استعادة ائتمانات :value بنجاح',
      'current_version': 'النسخة الحالية',
      'latest_version': 'احدث اصدار',
      'update_now': 'تحديث الان',
      'a_new_version_is_available': 'يتوفر إصدار جديد من تطبيق الويب',
      'update_available': 'التحديث متاح',
      'app_updated': 'اكتمل التحديث بنجاح',
      'learn_more': 'للمزيد من المعلومات',
      'integrations': 'تكاملات',
      'tracking_id': 'معرف التتبع',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': 'تذييل الائتمان',
      'credit_terms': 'شروط الائتمان',
      'new_company': 'شركة جديدة',
      'added_company': 'تم إضافة الشركة بنجاح',
      'company1': 'شركة مخصصة 1',
      'company2': 'شركة مخصصة 2',
      'company3': 'شركة مخصصة 3',
      'company4': 'شركة مخصصة 4',
      'product1': 'المنتج المخصص 1',
      'product2': 'المنتج المخصص 2',
      'product3': 'المنتج المخصص 3',
      'product4': 'المنتج المخصص 4',
      'client1': 'العميل المخصص 1',
      'client2': 'العميل المخصص 2',
      'client3': 'العميل المخصص 3',
      'client4': 'العميل المخصص 4',
      'contact1': 'جهة اتصال مخصصة 1',
      'contact2': 'جهة اتصال مخصصة 2',
      'contact3': 'جهة اتصال مخصصة 3',
      'contact4': 'جهة اتصال مخصصة 4',
      'task1': 'المهمة المخصصة 1',
      'task2': 'المهمة المخصصة 2',
      'task3': 'المهمة المخصصة 3',
      'task4': 'المهمة المخصصة 4',
      'project1': 'مشروع مخصص 1',
      'project2': 'مشروع مخصص 2',
      'project3': 'مشروع مخصص 3',
      'project4': 'مشروع مخصص 4',
      'expense1': 'المصاريف المخصصة 1',
      'expense2': 'المصاريف المخصصة 2',
      'expense3': 'المصاريف المخصصة 3',
      'expense4': 'المصاريف المخصصة 4',
      'vendor1': 'بائع مخصص 1',
      'vendor2': 'بائع مخصص 2',
      'vendor3': 'بائع مخصص 3',
      'vendor4': 'بائع مخصص 4',
      'invoice1': 'الفاتورة المخصصة 1',
      'invoice2': 'الفاتورة المخصصة 2',
      'invoice3': 'الفاتورة المخصصة 3',
      'invoice4': 'الفاتورة المخصصة 4',
      'payment1': 'الدفع المخصص 1',
      'payment2': 'الدفع المخصص 2',
      'payment3': 'الدفع المخصص 3',
      'payment4': 'الدفع المخصص 4',
      'surcharge1': 'رسوم إضافية مخصصة 1',
      'surcharge2': 'رسوم إضافية مخصصة 2',
      'surcharge3': 'رسوم إضافية مخصصة 3',
      'surcharge4': 'رسوم إضافية مخصصة 4',
      'group1': 'المجموعة المخصصة 1',
      'group2': 'المجموعة المخصصة 2',
      'group3': 'المجموعة المخصصة 3',
      'group4': 'المجموعة المخصصة 4',
      'reset': 'إعادة ضبط',
      'number': 'رقم',
      'export': 'يصدّر',
      'chart': 'جدول',
      'count': 'عدد',
      'totals': 'المجاميع',
      'blank': 'فارغ',
      'day': 'يوم',
      'month': 'شهر',
      'year': 'سنة',
      'subgroup': 'المجموعة الفرعية',
      'is_active': 'نشط',
      'group_by': 'مجموعة من',
      'credit_balance': 'رصيد دائن',
      'contact_last_login': 'الاتصال آخر تسجيل دخول',
      'contact_full_name': 'الاسم الكامل للاتصال',
      'contact_phone': 'هاتف الاتصال',
      'contact_custom_value1': 'القيمة المخصصة لجهة الاتصال 1',
      'contact_custom_value2': 'القيمة المخصصة لجهة الاتصال 2',
      'contact_custom_value3': 'الاتصال بالقيمة المخصصة 3',
      'contact_custom_value4': 'القيمة المخصصة لجهة الاتصال 4',
      'shipping_address1': 'شارع الشحن',
      'shipping_address2': 'شقة الشحن / الجناح',
      'shipping_city': 'مدينة الشحن',
      'shipping_state': 'ولاية / مقاطعة الشحن',
      'shipping_postal_code': 'الرمز البريدي للشحن',
      'shipping_country': 'بلد الشحن',
      'billing_address1': 'شارع الفواتير',
      'billing_address2': 'الفواتير شقة / جناح',
      'billing_city': 'مدينة الفوترة',
      'billing_state': 'ولاية / مقاطعة الفوترة',
      'billing_postal_code': 'الفواتير الرمز البريدي',
      'billing_country': 'بلد إرسال الفواتير',
      'client_id': 'معرف العميل',
      'assigned_to': 'مخصص ل',
      'created_by': 'تم إنشاؤه بواسطة :name',
      'assigned_to_id': 'مخصص للمعرف',
      'created_by_id': 'تم إنشاؤها بواسطة Id',
      'add_column': 'أضف عمود',
      'edit_columns': 'تحرير الأعمدة',
      'columns': 'الأعمدة',
      'aging': 'شيخوخة',
      'profit_and_loss': 'الربح والخسارة',
      'reports': 'التقارير',
      'report': 'تقرير',
      'add_company': 'أضف شركة',
      'unpaid_invoice': 'فاتورة غير مدفوعة',
      'paid_invoice': 'فاتورة مدفوعة',
      'unapproved_quote': 'اقتباس غير معتمد',
      'help': 'يساعد',
      'refund': 'استرداد',
      'refund_date': 'تاريخ الاسترداد',
      'filtered_by': 'تمت تصفيتها بواسطة',
      'contact_email': 'تواصل بالبريد الاكتروني',
      'multiselect': 'تحديد متعدد',
      'entity_state': 'ولاية',
      'verify_password': 'اكد كلمة المرور',
      'applied': 'مُطبَّق',
      'include_recent_errors': 'قم بتضمين الأخطاء الأخيرة من السجلات',
      'your_message_has_been_received':
          'لقد تلقينا رسالتك وسنحاول الرد على الفور.',
      'message': 'رسالة',
      'from': 'من',
      'show_product_details': 'إظهار تفاصيل المنتج',
      'show_product_details_help':
          'قم بتضمين الوصف والتكلفة في القائمة المنسدلة للمنتج',
      'pdf_min_requirements': 'يتطلب جهاز عرض PDF :version',
      'adjust_fee_percent': 'ضبط نسبة الرسوم',
      'adjust_fee_percent_help': 'ضبط النسبة المئوية لحساب الرسوم',
      'configure_settings': 'تكوين الإعدادات',
      'support_forum': 'منتديات الدعم',
      'about': 'عن',
      'documentation': 'توثيق',
      'contact_us': 'اتصل بنا',
      'subtotal': 'المبلغ الإجمالي',
      'line_total': 'الإجمالي',
      'item': 'غرض',
      'credit_email': 'البريد الإلكتروني الائتماني',
      'iframe_url': 'عنوان URL لإطار iFrame',
      'domain_url': 'URL المجال',
      'password_is_too_short': 'كلمة المرور قصيرة جدا',
      'password_is_too_easy': 'يجب أن تحتوي كلمة المرور على أحرف كبيرة ورقم',
      'client_portal_tasks': 'مهام بوابة العميل',
      'client_portal_dashboard': 'لوحة معلومات بوابة العميل',
      'please_enter_a_value': 'ادخل قيمه من فضلك',
      'deleted_logo': 'تم حذف الشعار بنجاح',
      'yes': 'نعم',
      'no': 'لا',
      'generate_number': 'توليد الرقم',
      'when_saved': 'عند الحفظ',
      'when_sent': 'عند الإرسال',
      'select_company': 'حدد شركة',
      'float': 'يطفو',
      'collapse': 'ينهار',
      'show_or_hide': 'اظهر المخفي',
      'menu_sidebar': 'القائمة الشريط الجانبي',
      'history_sidebar': 'الشريط الجانبي للتاريخ',
      'tablet': 'لوح',
      'mobile': 'متحرك',
      'desktop': 'سطح المكتب',
      'layout': 'تَخطِيط',
      'view': 'منظر',
      'module': 'وحدة',
      'first_custom': 'أول مخصص',
      'second_custom': 'العرف الثاني',
      'third_custom': 'العرف الثالث',
      'show_cost': 'عرض التكلفة',
      'show_product_cost': 'عرض تكلفة المنتج',
      'show_cost_help': 'اعرض حقل تكلفة المنتج لتتبع العلامة / الربح',
      'show_product_quantity': 'إظهار كمية المنتج',
      'show_product_quantity_help':
          'اعرض حقل كمية المنتج ، وإلا فسيكون واحدًا افتراضيًا',
      'show_invoice_quantity': 'إظهار كمية الفاتورة',
      'show_invoice_quantity_help':
          'عرض حقل كمية البند ، وإلا فسيكون افتراضيًا واحدًا',
      'show_product_discount': 'إظهار خصم المنتج',
      'show_product_discount_help': 'عرض حقل خصم البند',
      'default_quantity': 'الكمية الافتراضية',
      'default_quantity_help': 'قم بتعيين كمية البند تلقائيًا على واحد',
      'one_tax_rate': 'معدل ضريبة واحد',
      'two_tax_rates': 'اثنين من معدلات الضرائب',
      'three_tax_rates': 'ثلاثة معدلات ضريبية',
      'default_tax_rate': 'معدل الضريبة الافتراضي',
      'user': 'مستخدم',
      'invoice_tax': 'ضريبة الفاتورة',
      'line_item_tax': 'ضريبة العنصر',
      'inclusive_taxes': 'الضرائب الشاملة',
      'invoice_tax_rates': 'معدلات ضريبة الفاتورة',
      'item_tax_rates': 'معدلات ضريبة العنصر',
      'no_client_selected': 'الرجاء تحديد عميل',
      'configure_rates': 'تكوين الأسعار',
      'configure_gateways': 'تكوين العبّارات',
      'tax_settings': 'إعدادات الضرائب',
      'tax_settings_rates': 'معدلات الضرائب',
      'accent_color': 'لون التمييز',
      'switch': 'يُحوّل',
      'comma_sparated_list': 'قائمة مفصولة بفواصل',
      'options': 'خيارات',
      'single_line_text': 'نص من سطر واحد',
      'multi_line_text': 'نص متعدد الأسطر',
      'dropdown': 'اسقاط',
      'field_type': 'نوع الحقل',
      'recover_password_email_sent':
          'تم إرسال بريد إلكتروني لاستعادة كلمة المرور',
      'submit': 'يُقدِّم',
      'recover_password': 'استعادة كلمة المرور الخاصة بك',
      'late_fees': 'الرسوم المتأخرة',
      'credit_number': 'رقم الائتمان',
      'payment_number': 'رقم الدفع',
      'late_fee_amount': 'مبلغ الرسوم المتأخرة',
      'late_fee_percent': 'نسبة الرسوم المتأخرة',
      'before_due_date': 'قبل تاريخ الاستحقاق',
      'after_due_date': 'بعد تاريخ الاستحقاق',
      'after_invoice_date': 'بعد تاريخ الفاتورة',
      'days': 'أيام',
      'invoice_email': 'الفاتورة البريد الإلكتروني',
      'payment_email': 'دفع البريد الإلكتروني',
      'partial_payment': 'دفع جزء من المال',
      'payment_partial': 'دفع جزء من المال',
      'partial_payment_email': 'البريد الإلكتروني للدفع الجزئي',
      'quote_email': 'البريد الإلكتروني اقتباس',
      'endless_reminder': 'تذكير لا نهاية له',
      'filtered_by_user': 'تمت تصفيتها من قبل المستخدم',
      'administrator': 'مدير',
      'administrator_help':
          'السماح للمستخدم بإدارة المستخدمين وتغيير الإعدادات وتعديل جميع السجلات',
      'user_management': 'ادارة المستخدم',
      'users': 'المستخدمين',
      'new_user': 'مستخدم جديد',
      'edit_user': 'تعديل بيانات المستخدم',
      'created_user': 'تم إنشاء المستخدم بنجاح',
      'updated_user': 'تم تحديث بيانات المستخدم بنجاح',
      'archived_user': 'تمت أرشفة المستخدم بنجاح',
      'deleted_user': 'تم حذف المستخدم بنجاح',
      'removed_user': 'تمت إزالة المستخدم بنجاح',
      'restored_user': 'تمت استعادة المستخدم بنجاح',
      'archived_users': 'تمت أرشفة مستخدمي :value بنجاح',
      'deleted_users': 'تم حذف مستخدمي :value بنجاح',
      'removed_users': 'تمت إزالة مستخدمي :value بنجاح',
      'restored_users': 'تمت استعادة مستخدمي :value بنجاح',
      'general_settings': 'الإعدادات العامة',
      'invoice_options': 'خيارات الفاتورة',
      'hide_paid_to_date': 'اخفاء ما تم دفعة حتى الان',
      'hide_paid_to_date_help':
          'اعرض فقط -ما تم دفعه حتى الان- في فواتيرك اذا تم استلام الدفعه',
      'invoice_embed_documents': 'تضمين الصور/المستندات',
      'invoice_embed_documents_help':
          'قم بإدراج الصور/ملفات PDF المرفقة في الفاتورة.',
      'all_pages_header': 'إظهار الرأس في',
      'all_pages_footer': 'إظهار التذييل في',
      'first_page': 'الصفحة الأولى',
      'all_pages': 'كل الصفحات',
      'last_page': 'آخر صفحة',
      'primary_font': 'الخط الأساسي',
      'secondary_font': 'الخط الثانوي',
      'primary_color': 'لون أصلي',
      'secondary_color': 'اللون الثانوي',
      'page_size': 'مقاس الصفحه',
      'font_size': 'حجم الخط',
      'quote_design': 'تصميم اقتباس',
      'invoice_fields': 'حقول الفاتورة',
      'product_fields': 'حقول المنتج',
      'invoice_terms': 'شروط الفاتورة',
      'invoice_footer': 'تذييل الفاتورة',
      'quote_terms': 'شروط الاقتباس',
      'quote_footer': 'اقتباس التذييل',
      'auto_email_invoice': 'البريد الإلكتروني التلقائي',
      'auto_email_invoice_help':
          'إرسال الفواتير المتكررة بالبريد الإلكتروني تلقائيًا عند إنشائها.',
      'auto_archive_quote': 'الأرشفة التلقائية',
      'auto_archive_quote_help':
          'أرشفة عروض الأسعار تلقائيًا عند تحويلها إلى فاتورة.',
      'auto_convert_quote': 'تحويل تلقائي',
      'auto_convert_quote_help':
          'تحويل عرض الأسعار تلقائيًا إلى فاتورة عند الموافقة عليها.',
      'workflow_settings': 'إعدادات سير العمل',
      'freq_daily': 'يوميًا',
      'freq_weekly': 'أسبوعي',
      'freq_two_weeks': 'إسبوعين',
      'freq_four_weeks': 'أربعة أسابيع',
      'freq_monthly': 'شهريا',
      'freq_two_months': 'شهرين',
      'freq_three_months': 'ثلاثة أشهر',
      'freq_four_months': 'أربعة أشهر',
      'freq_six_months': 'ستة أشهر',
      'freq_annually': 'سنويا',
      'freq_two_years': 'سنتان',
      'freq_three_years': 'ثلاث سنوات',
      'never': 'أبداً',
      'company': 'شركة',
      'generated_numbers': 'الأرقام المولدة',
      'charge_taxes': 'فرض الضرائب',
      'next_reset': 'إعادة التعيين التالية',
      'reset_counter': 'إعادة تعيين العداد',
      'recurring_prefix': 'البادئة المتكررة',
      'number_padding': 'المساحة المتروكة',
      'general': 'عام',
      'surcharge_field': 'مجال الشحن الإضافي',
      'company_field': 'مجال الشركة',
      'company_value': 'قيمة الشركة',
      'credit_field': 'مجال الائتمان',
      'invoice_field': 'مجال الفاتورة',
      'invoice_surcharge': 'تكلفة الفاتورة الإضافية',
      'client_field': 'مجال العميل',
      'product_field': 'مجال المنتج',
      'payment_field': 'مجال الدفع',
      'contact_field': 'مجال الاتصال',
      'vendor_field': 'مجال البائع',
      'expense_field': 'مجال المصاريف',
      'project_field': 'مجال المشروع',
      'task_field': 'مجال المهمة',
      'group_field': 'مجال المجموعة',
      'number_counter': 'عداد رقم',
      'prefix': 'بادئة',
      'number_pattern': 'نمط الرقم',
      'messages': 'رسائل',
      'custom_css': 'كود مخصص CSS',
      'custom_javascript': 'جافا سكريبت مخصص',
      'signature_on_pdf': 'عرض على PDF',
      'signature_on_pdf_help':
          'أظهر توقيع العميل على الفاتورة / عرض أسعار PDF.',
      'show_accept_invoice_terms': 'خانة اختيار شروط الفاتورة',
      'show_accept_invoice_terms_help':
          'مطالبة العميل بتأكيد قبوله لشروط الفاتورة.',
      'show_accept_quote_terms': 'مربع اختيار شروط الاقتباس',
      'show_accept_quote_terms_help':
          'مطالبة العميل بتأكيد قبوله لشروط عرض الأسعار.',
      'require_invoice_signature': 'توقيع الفاتورة',
      'require_invoice_signature_help': 'مطالبة العميل بتقديم توقيعه.',
      'require_quote_signature': 'اقتباس التوقيع',
      'enable_portal_password': 'حماية الفواتير بكلمة مرور',
      'enable_portal_password_help':
          'يسمح لك بتعيين كلمة مرور لكل جهة اتصال. إذا تم تعيين كلمة مرور ، فسيُطلب من جهة الاتصال إدخال كلمة مرور قبل عرض الفواتير.',
      'authorization': 'تفويض',
      'subdomain': 'المجال الفرعي',
      'domain': 'اِختِصاص',
      'portal_mode': 'وضع البوابة',
      'email_signature': 'مع تحياتي،',
      'enable_email_markup_help':
          'اجعل من السهل على عملائك الدفع لك عن طريق إضافة ترميز schema.org إلى رسائلك الإلكترونية.',
      'plain': 'سهل',
      'light': 'ضوء',
      'dark': 'مظلم',
      'email_design': 'تصميم البريد الإلكتروني',
      'attach_pdf': 'إرفاق ملف PDF',
      'attach_documents': 'إرفاق المستندات',
      'attach_ubl': 'إرفاق UBL/الفاتورة الإلكترونية',
      'email_style': 'نمط البريد الإلكتروني',
      'enable_email_markup': 'تمكين التوصيف',
      'reply_to_email': 'الرد على البريد الإلكتروني',
      'reply_to_name': 'الرد على الاسم',
      'bcc_email': 'بريد إلكتروني BCC',
      'processed': 'معالجتها',
      'credit_card': 'بطاقة إئتمان',
      'bank_transfer': 'التحويل المصرفي',
      'priority': 'أولوية',
      'fee_amount': 'مبلغ الرسوم',
      'fee_percent': 'نسبة الرسوم',
      'fee_cap': 'سقف الرسوم',
      'limits_and_fees': 'الحدود / الرسوم',
      'enable_min': 'تمكين min',
      'enable_max': 'تمكين ماكس',
      'min_limit': 'الحد الأدنى: :min',
      'max_limit': 'الحد الأقصى: :max',
      'min': 'دقيقة',
      'max': 'الأعلى',
      'accepted_card_logos': 'شعارات البطاقات المقبولة',
      'credentials': 'أوراق اعتماد',
      'update_address': 'تحديث العنوان',
      'update_address_help': 'تحديث عنوان العميل مع التفاصيل المقدمة',
      'rate': 'معدل',
      'tax_rate': 'معدل الضريبة',
      'new_tax_rate': 'معدل الضريبة الجديد',
      'edit_tax_rate': 'تحرير معدل الضريبة',
      'created_tax_rate': 'تم إنشاء معدل الضريبة بنجاح',
      'updated_tax_rate': 'تم تحديث معدل الضريبة بنجاح',
      'archived_tax_rate': 'تمت أرشفة معدل الضريبة بنجاح',
      'deleted_tax_rate': 'تم حذف معدل الضريبة بنجاح',
      'restored_tax_rate': 'تمت استعادة معدل الضريبة بنجاح',
      'archived_tax_rates': 'تمت أرشفة معدلات الضرائب :value بنجاح',
      'deleted_tax_rates': 'تم حذف معدلات الضرائب :value بنجاح',
      'restored_tax_rates': 'تمت استعادة معدلات الضرائب :value بنجاح',
      'fill_products': 'منتجات التعبئة التلقائية',
      'fill_products_help':
          'سيؤدي تحديد المنتج إلى ملء الوصف والتكلفة تلقائيًا',
      'update_products': 'منتجات التحديث التلقائي',
      'update_products_help':
          'سيؤدي تحديث الفاتورة إلى تحديث مكتبة المنتجات تلقائيًا',
      'convert_products': 'تحويل المنتجات',
      'convert_products_help': 'تحويل أسعار المنتجات إلى عملة العميل تلقائيًا',
      'fees': 'مصاريف',
      'limits': 'حدود',
      'provider': 'مزود',
      'company_gateway': 'بوابة الدفع',
      'company_gateways': 'بوابات الدفع',
      'new_company_gateway': 'بوابة جديدة',
      'edit_company_gateway': 'تحرير البوابة',
      'created_company_gateway': 'تم إنشاء البوابة بنجاح',
      'updated_company_gateway': 'تم تحديث البوابة بنجاح',
      'archived_company_gateway': 'تمت أرشفة البوابة بنجاح',
      'deleted_company_gateway': 'تم حذف البوابة بنجاح',
      'restored_company_gateway': 'تمت استعادة البوابة بنجاح',
      'archived_company_gateways': 'تمت أرشفة بوابات :value بنجاح',
      'deleted_company_gateways': 'تم حذف بوابات :value بنجاح',
      'restored_company_gateways': 'تمت استعادة بوابات :value بنجاح',
      'continue_editing': 'الاستمرار في التعديل',
      'discard_changes': 'تجاهل التغييرات',
      'default_value': 'القيمة الافتراضية',
      'disabled': 'عاجز',
      'currency_format': 'تنسيق العملة',
      'first_day_of_the_week': 'اول يوم من الاسبوع',
      'first_month_of_the_year': 'الشهر الأول من العام',
      'sunday': 'الأحد',
      'monday': 'الاثنين',
      'tuesday': 'يوم الثلاثاء',
      'wednesday': 'الأربعاء',
      'thursday': 'يوم الخميس',
      'friday': 'جمعة',
      'saturday': 'السبت',
      'january': 'يناير',
      'february': 'شهر فبراير',
      'march': 'يمشي',
      'april': 'أبريل',
      'may': 'يمكن',
      'june': 'يونيو',
      'july': 'يوليو',
      'august': 'أغسطس',
      'september': 'سبتمبر',
      'october': 'اكتوبر',
      'november': 'شهر نوفمبر',
      'december': 'ديسمبر',
      'symbol': 'رمز',
      'ocde': 'شفرة',
      'date_format': 'صيغة التاريخ',
      'datetime_format': 'تنسيق التاريخ والوقت',
      'military_time': 'توقيت 24 ساعة',
      'military_time_help': 'عرض 24 ساعة',
      'send_reminders': 'إرسال تذكير',
      'timezone': 'وحدة زمنية',
      'filtered_by_project': 'تمت تصفيتها حسب المشروع',
      'filtered_by_group': 'تمت تصفيتها حسب المجموعة',
      'filtered_by_invoice': 'تمت تصفيتها حسب الفاتورة',
      'filtered_by_client': 'تمت تصفيتها حسب العميل',
      'filtered_by_vendor': 'تمت تصفيتها حسب البائع',
      'group_settings': 'إعدادات المجموعة',
      'group': 'مجموعة',
      'groups': 'مجموعات',
      'new_group': 'مجموعة جديدة',
      'edit_group': 'تحرير المجموعة',
      'created_group': 'تم إنشاء المجموعة بنجاح',
      'updated_group': 'تم تحديث المجموعة بنجاح',
      'archived_groups': 'تمت أرشفة مجموعات :value بنجاح',
      'deleted_groups': 'تم حذف مجموعات :value بنجاح',
      'restored_groups': 'تمت استعادة مجموعات :value بنجاح',
      'archived_group': 'تمت أرشفة المجموعة بنجاح',
      'deleted_group': 'تم حذف المجموعة بنجاح',
      'restored_group': 'تمت استعادة المجموعة بنجاح',
      'upload_logo': 'قم بتحميل شعار شركتك',
      'uploaded_logo': 'تم تحميل الشعار بنجاح',
      'logo': 'شعار',
      'saved_settings': 'تم حفظ الإعدادات بنجاح',
      'product_settings': 'إعدادات المنتج',
      'device_settings': 'إعدادات الجهاز',
      'defaults': 'الافتراضات',
      'basic_settings': 'الإعدادات الأساسية',
      'advanced_settings': 'الإعدادات المتقدمة',
      'company_details': 'تفاصيل الشركة',
      'user_details': 'بيانات المستخدم',
      'localization': 'تغيير اللغة',
      'online_payments': 'الدفعات الإلكترونية',
      'tax_rates': 'معدلات الضريبة',
      'notifications': 'تنبيهات',
      'import_export': 'استيراد | تصدير',
      'custom_fields': 'حقوك مخصصة',
      'invoice_design': 'تصميم الفاتورة',
      'buy_now_buttons': 'أزرار الشراء الآن',
      'email_settings': 'إعدادت البريد الإلكتروني',
      'templates_and_reminders': 'القوالب والتذكيرات',
      'credit_cards_and_banks': 'بطاقات الائتمان والبنوك',
      'data_visualizations': 'تصورات البيانات',
      'price': 'سعر',
      'email_sign_up': 'البريد الإلكتروني الاشتراك',
      'google_sign_up': 'جوجل الاشتراك',
      'thank_you_for_your_purchase': 'شكرا لك على الشراء!',
      'redeem': 'يسترد',
      'back': 'خلف',
      'past_purchases': 'المشتريات السابقة',
      'annual_subscription': 'اشتراك سنوي',
      'pro_plan': 'خطة احترافية',
      'enterprise_plan': 'خطة المؤسسة',
      'count_users': 'مستخدمي :count',
      'upgrade': 'يرقي',
      'please_enter_a_first_name': 'الرجاء إدخال الاسم الأول',
      'please_enter_a_last_name': 'الرجاء إدخال اسم العائلة',
      'please_agree_to_terms_and_privacy':
          'يرجى الموافقة على شروط الخدمة وسياسة الخصوصية لإنشاء حساب.',
      'i_agree_to_the': 'أنا أوافق على',
      'terms_of_service': 'شروط الخدمة',
      'privacy_policy': 'سياسة الخصوصية',
      'sign_up': 'تسجيل',
      'account_login': 'تسجل الدخول',
      'view_website': 'عرض الموقع',
      'create_account': 'إنشاء حساب',
      'email_login': 'تسجيل الدخول بالبريد الإلكتروني',
      'create_new': 'خلق جديد إبداع جديد',
      'no_record_selected': 'لم يتم تحديد سجل',
      'error_unsaved_changes': 'يرجى حفظ أو إلغاء التغييرات الخاصة بك',
      'download': 'تحميل',
      'requires_an_enterprise_plan': 'يتطلب خطة المؤسسة',
      'take_picture': 'التقط صورة',
      'upload_files': 'تحميل الملفات',
      'document': 'وثيقة',
      'documents': 'المستندات',
      'new_document': 'مستند جديد',
      'edit_document': 'تحرير المستند',
      'uploaded_document': 'تم تحميل المستند بنجاح',
      'updated_document': 'تم تحديث المستند بنجاح',
      'archived_document': 'تمت أرشفة المستند بنجاح',
      'deleted_document': 'تم حذف المستند بنجاح',
      'restored_document': 'تمت استعادة المستند بنجاح',
      'archived_documents': 'تمت أرشفته بنجاح: مستندات القيمة',
      'deleted_documents': 'تمت عملية الحذف بنجاح: مستندات القيمة',
      'restored_documents': 'تمت الاستعادة بنجاح: مستندات القيمة',
      'no_history': 'لا تاريخ',
      'expense_date': 'تاريخ المصاريف',
      'pending': 'قيد الانتظار',
      'expense_status_1': 'مسجّل',
      'expense_status_2': 'قيد الانتظار',
      'expense_status_3': 'مفوترة',
      'converted': 'محولة',
      'add_documents_to_invoice': 'أضف مستندات إلى الفاتوره',
      'exchange_rate': 'سعر الصرف',
      'convert_currency': 'تحويل العملة',
      'mark_paid': 'مارك مدفوعة',
      'category': 'فئة',
      'address': 'العنوان',
      'new_vendor': 'بائع جديد',
      'created_vendor': 'تم إنشاء البائع بنجاح',
      'updated_vendor': 'تم تحديث البائع بنجاح',
      'archived_vendor': 'تم ارشفة البائع بنجاح',
      'deleted_vendor': 'تم حذف البائع بنجاح',
      'restored_vendor': 'تمت استعادة البائع بنجاح',
      'archived_vendors': 'تم ارشفة :count بائعين بنجاح',
      'deleted_vendors': 'تم حذف :count بائعين بنجاح',
      'restored_vendors': 'تمت استعادة بائعي :value بنجاح',
      'new_expense': 'أدخل المصاريف',
      'created_expense': 'تم إنشاء حساب بنجاح',
      'updated_expense': 'تم تحديث المصاريف بنجاح',
      'archived_expense': 'تمت أرشفة المصاريف بنجاح',
      'deleted_expense': 'تم حذف المصاريف بنجاح',
      'restored_expense': 'تمت استعادة النفقات بنجاح',
      'archived_expenses': 'تمت أرشفة النفقات بنجاح',
      'deleted_expenses': 'تم حذف المصاريف بنجاح',
      'restored_expenses': 'تمت استعادة نفقات :value بنجاح',
      'copy_shipping': 'نسخ الشحن',
      'copy_billing': 'نسخ الفواتير',
      'design': 'تصميم',
      'failed_to_find_record': 'فشل في العثور على السجل',
      'invoiced': 'مفوترة',
      'logged': 'مسجّل',
      'running': 'جري',
      'resume': 'سيرة ذاتية',
      'task_errors': 'يرجى تصحيح أي أوقات متداخلة',
      'start': 'يبدأ',
      'stop': 'قف',
      'started_task': 'بدأت المهمة بنجاح',
      'stopped_task': 'تم إيقاف المهمة بنجاح',
      'resumed_task': 'تم استئناف المهمة بنجاح',
      'now': 'الآن',
      'auto_start_tasks': 'مهام البدء التلقائي',
      'timer': 'الموقت',
      'manual': 'يدوي',
      'budgeted': 'الميزانية',
      'start_time': 'وقت البدء',
      'end_time': 'وقت النهاية',
      'date': 'تاريخ',
      'times': 'مرات',
      'duration': 'مدة',
      'new_task': 'مهمة جديدة',
      'created_task': 'تم إنشاء المهمة بنجاح',
      'updated_task': 'تم تحديث المهمة بنجاح',
      'archived_task': 'تمت أرشفة المهمة بنجاح',
      'deleted_task': 'تم حذف المهمة بنجاح',
      'restored_task': 'تمت استعادة المهمة بنجاح',
      'archived_tasks': 'تمت أرشفته بنجاح: عد المهام',
      'deleted_tasks': 'تم حذف مهام :count بنجاح',
      'restored_tasks': 'تمت استعادة مهام :value بنجاح',
      'please_enter_a_name': 'الرجاء إدخال اسم',
      'budgeted_hours': 'ساعات الميزانية',
      'created_project': 'تم إنشاء المشروع بنجاح',
      'updated_project': 'تم تحديث المشروع بنجاح',
      'archived_project': 'تمت أرشفة المشروع بنجاح',
      'deleted_project': 'تم حذف المشروع بنجاح',
      'restored_project': 'تمت استعادة المشروع بنجاح',
      'archived_projects': 'تمت أرشفة مشاريع :count بنجاح',
      'deleted_projects': 'تم حذف مشاريع :count بنجاح',
      'restored_projects': 'تمت استعادة مشاريع :value بنجاح',
      'new_project': 'مشروع جديد',
      'thank_you_for_using_our_app': 'شكرا لك على استخدام التطبيق لدينا!',
      'if_you_like_it': 'إذا كنت ترغب في ذلك من فضلك',
      'click_here': 'انقر هنا',
      'click_here_capital': 'انقر هنا',
      'to_rate_it': 'لتقييمها.',
      'average': 'متوسط',
      'unapproved': 'غير موافق عليه',
      'authenticate_to_change_setting': 'يرجى المصادقة لتغيير هذا الإعداد',
      'locked': 'مقفل',
      'authenticate': 'المصادقة',
      'please_authenticate': 'يرجى المصادقة',
      'biometric_authentication': 'المصادقة البيومترية',
      'footer': 'تذييل',
      'compare': 'يقارن',
      'hosted_login': 'مستضاف تسجيل الدخول',
      'selfhost_login': 'تسجيل الدخول إلى Selfhost',
      'google_sign_in': 'الدخول مع جوجل',
      'today': 'اليوم',
      'custom_range': 'نطاق مخصص',
      'date_range': 'نطاق الموعد',
      'current': 'حاضِر',
      'previous': 'سابق',
      'current_period': 'الفترة الحالية',
      'comparison_period': 'فترة المقارنة',
      'previous_period': 'الفترة السابقة',
      'previous_year': 'السنة الماضية',
      'compare_to': 'قارن ب',
      'last7_days': 'اخر 7 ايام',
      'last_week': 'الأسبوع الماضي',
      'last30_days': 'آخر 30 يومًا',
      'this_month': 'هذا الشهر',
      'last_month': 'الشهر الماضي',
      'this_year': 'هذا العام',
      'last_year': 'العام الماضي',
      'all_time': 'كل الوقت',
      'custom': 'مخصص',
      'clone_to_invoice': 'استنساخ إلى الفاتورة',
      'clone_to_quote': 'استنساخ للاقتباس',
      'clone_to_credit': 'استنساخ للائتمان',
      'view_invoice': 'عرض الفاتورة',
      'convert': 'يتحول',
      'more': 'أكثر',
      'edit_client': 'تعديل العميل',
      'edit_product': 'تعديل المنتج',
      'edit_invoice': 'تعديل الفاتورة',
      'edit_quote': 'تعديل عرض سعر',
      'edit_payment': 'تحرير الدفع',
      'edit_task': 'تحرير المهمة',
      'edit_expense': 'تحرير المصاريف',
      'edit_vendor': 'تحرير البائع',
      'edit_project': 'تحرير المشروع',
      'edit_recurring_quote': 'تحرير الاقتباس المتكرر',
      'billing_address': 'عنوان وصول الفواتير',
      'shipping_address': 'عنوان الشحن',
      'total_revenue': 'إجمالي الإيرادات',
      'average_invoice': 'معدل الفاتورة',
      'outstanding': 'متميز',
      'invoices_sent': ':count الفواتير المرسلة',
      'active_clients': 'عملاء فعّالين',
      'close': 'إغلاق',
      'email': 'البريد الإلكتروني',
      'password': 'كلمة السر',
      'url': 'URL',
      'secret': 'سر',
      'name': 'الاسم',
      'logout': 'تسجيل الخروج',
      'login': 'تسجيل الدخول',
      'filter': 'ترشيح',
      'sort': 'نوع',
      'search': 'البحث',
      'active': 'نشط',
      'archived': 'مؤرشف',
      'deleted': 'تم الحذف',
      'dashboard': 'لوحة التحكم',
      'archive': 'ارشيف',
      'delete': 'حذف',
      'restore': 'يعيد',
      'refresh_complete': 'اكتمال التحديث',
      'please_enter_your_email': 'رجاءا أدخل بريدك الإلكتروني',
      'please_enter_your_password': 'من فضلك أدخل رقمك السري',
      'please_enter_your_url': 'الرجاء إدخال عنوان URL الخاص بك',
      'please_enter_a_product_key': 'الرجاء إدخال مفتاح المنتج',
      'ascending': 'تصاعدي',
      'descending': 'تنازلي',
      'save': 'حفظ',
      'an_error_occurred': 'حدث خطأ',
      'paid_to_date': 'دفعت حتى الان',
      'balance_due': 'الرصيد المستحق',
      'balance': 'الرصيد',
      'overview': 'ملخص',
      'details': 'تفاصيل',
      'phone': 'الهاتف',
      'website': 'الموقع الإلكتروني',
      'vat_number': 'ظريبه الشراء',
      'id_number': 'رقم الهوية',
      'create': 'إنشاء',
      'copied_to_clipboard': 'نسخ :value إلى الحافظة',
      'error': 'خطأ',
      'could_not_launch': 'تعذر الإطلاق',
      'contacts': 'جهات الاتصال',
      'additional': 'إضافي',
      'first_name': 'الاسم الأول',
      'last_name': 'الاسم الأخير',
      'add_contact': 'إضافة جهة اتصال',
      'are_you_sure': 'هل أنت متأكد؟',
      'cancel': 'إلغاء',
      'ok': 'نعم',
      'remove': 'يزيل',
      'email_is_invalid': 'البريد الإلكتروني غير صالح',
      'product': 'منتج',
      'products': 'المنتجات',
      'new_product': 'منتج جديد',
      'created_product': 'تم إضافة المنتج بنجاح',
      'updated_product': 'تم تعديل المنتج بنجاح',
      'archived_product': 'تمت ارشفة المنتج بنجاح',
      'deleted_product': 'تم حذف المنتج بنجاح',
      'restored_product': 'تمت استعادة المنتج بنجاح',
      'archived_products': 'تمت أرشفة منتجات :count بنجاح',
      'deleted_products': 'تم حذف منتجات :count بنجاح',
      'restored_products': 'تمت استعادة منتجات :value بنجاح',
      'product_key': 'منتج',
      'notes': 'ملحوظات',
      'cost': 'يكلف',
      'client': 'العميل',
      'clients': 'العملاء',
      'new_client': 'عميل جديد',
      'created_client': 'تم إنشاء العميل بنجاح',
      'updated_client': 'تم تحديث العميل بنجاح',
      'archived_client': 'تمت أرشفة العميل بنجاح',
      'archived_clients': 'تمت أرشفته :count عملاء بنجاح',
      'deleted_client': 'تم حذف العميل بنجاح',
      'deleted_clients': 'تم حذف  :count عملاء بنجاح',
      'restored_client': 'تمت استعادة العميل بنجاح',
      'restored_clients': 'تمت استعادة عملاء :value بنجاح',
      'address1': 'الشارع',
      'address2': 'شقة / جناح',
      'city': 'المدينة',
      'state': 'الولاية/المنطقة',
      'postal_code': 'الرمز البريدي',
      'country': 'دولة',
      'invoice': 'الفاتورة',
      'invoices': 'الفواتير',
      'new_invoice': 'فاتورة جديدة',
      'created_invoice': 'تم انشاء الفاتورة بنجاح',
      'updated_invoice': 'تم تحديث الفاتورة بنجاح',
      'archived_invoice': 'تمت أرشفة الفاتورة بنجاح',
      'deleted_invoice': 'تم حذف الفاتورة بنجاح',
      'restored_invoice': 'تمت استعادة الفاتورة بنجاح',
      'archived_invoices': 'تم ارشفة  :count فواتير بنجاح',
      'deleted_invoices': 'تم حذف :count فواتير بنجاح',
      'restored_invoices': 'تمت استعادة فواتير :value بنجاح',
      'emailed_invoice': 'تم ارسال الفاتورة الى البريد بنجاح',
      'emailed_payment': 'الدفع عبر البريد الإلكتروني بنجاح',
      'amount': 'القيمة',
      'invoice_number': 'رقم الفاتورة',
      'invoice_date': 'تاريخ الفاتورة',
      'discount': 'خصم',
      'po_number': 'رقم أمر الشراء',
      'terms': 'الشروط',
      'public_notes': 'ملاحظات عامة',
      'private_notes': 'ملاحظات خاصة',
      'frequency': 'التكرار',
      'start_date': 'تاريخ البداية',
      'end_date': 'تاريخ النهاية',
      'quote_number': 'رقم عرض السعر',
      'quote_date': 'تاريخ عرض السعر',
      'valid_until': 'صالح حتى',
      'items': 'أغراض',
      'partial_deposit': 'جزئي / إيداع',
      'description': 'وصف',
      'unit_cost': 'تكلفة الوحدة',
      'quantity': 'الكمية',
      'add_item': 'اضافة عنصر',
      'contact': 'جهة إتصال',
      'work_phone': 'الهاتف',
      'total_amount': 'المبلغ الإجمالي',
      'pdf': 'بي دي إف',
      'due_date': 'تاريخ الاستحقاق',
      'partial_due_date': 'تاريخ الاستحقاق الجزئي',
      'paid_date': 'تاريخ المدفوعة',
      'status': 'الحالة',
      'invoice_status_id': 'حالة الفاتورة',
      'quote_status': 'حالة الاقتباس',
      'click_plus_to_add_item': 'انقر فوق + لإضافة عنصر',
      'click_plus_to_add_time': 'انقر فوق + لإضافة الوقت',
      'count_selected': ':count محدد',
      'total': 'المجموع',
      'percent': 'نسبه مئويه',
      'edit': 'تعديل',
      'dismiss': 'رفض',
      'please_select_a_date': 'الرجاء تحديد تاريخ',
      'please_select_a_client': 'الرجاء تحديد عميل',
      'please_select_an_invoice': 'الرجاء تحديد فاتورة',
      'task_rate': 'معدل المهمة',
      'settings': 'الإعدادات',
      'language': 'لغة',
      'currency': 'عملة',
      'created_at': 'تاريخ الإنشاء',
      'created_on': 'تم إنشاؤها على',
      'updated_at': 'محدث',
      'tax': 'ضريبة',
      'please_enter_an_invoice_number': 'الرجاء إدخال رقم الفاتورة',
      'please_enter_a_quote_number': 'الرجاء إدخال رقم الاقتباس',
      'past_due': 'تجاوز تاريخ الاستحقاق',
      'draft': 'مسودة',
      'sent': 'مرسل',
      'viewed': 'ينظر',
      'approved': 'موافقة',
      'partial': 'جزئي / إيداع',
      'paid': 'مدفوع',
      'mark_sent': 'مارك المرسلة',
      'marked_invoice_as_sent': 'نجح وضع علامة على الفاتورة على أنها مرسلة',
      'marked_invoice_as_paid':
          'تم وضع علامة على الفاتورة على أنها مدفوعة بنجاح',
      'marked_invoices_as_sent': 'نجح وضع علامة على الفواتير على أنها مرسلة',
      'marked_invoices_as_paid':
          'تم وضع علامة على الفواتير على أنها مدفوعة بنجاح',
      'done': 'تم',
      'please_enter_a_client_or_contact_name':
          'الرجاء إدخال اسم العميل أو جهة الاتصال',
      'dark_mode': 'الوضع الداكن',
      'restart_app_to_apply_change': 'أعد تشغيل التطبيق لتطبيق التغيير',
      'refresh_data': 'تحديث البيانات',
      'blank_contact': 'اتصال فارغ',
      'activity': 'نشاط',
      'no_records_found': 'لا توجد سجلات',
      'clone': 'استنساخ',
      'loading': 'تحميل',
      'industry': 'صناعة',
      'size': 'مقاس',
      'payment_terms': 'شروط الدفع',
      'payment_date': 'تاريخ الدفعة',
      'payment_status': 'حالة السداد',
      'payment_status_1': 'قيد الانتظار',
      'payment_status_2': 'باطل',
      'payment_status_3': 'فشل',
      'payment_status_4': 'مكتمل',
      'payment_status_5': 'المردودة جزئيا',
      'payment_status_6': 'معاد',
      'payment_status_-1': 'غير مطبق',
      'payment_status_-2': 'غير مطبق جزئيًا',
      'net': 'شبكة',
      'client_portal': 'بوابة العميل',
      'show_tasks': 'إظهار المهام',
      'email_reminders': 'تذكير البريد الإلكتروني',
      'enabled': 'ممكن',
      'recipients': 'المستلمون',
      'initial_email': 'البريد الإلكتروني الأولي',
      'first_reminder': 'أول تذكير',
      'second_reminder': 'التنبيه الثاني',
      'third_reminder': 'التذكير الثالث',
      'reminder1': 'أول تذكير',
      'reminder2': 'التنبيه الثاني',
      'reminder3': 'التذكير الثالث',
      'template': 'نموذج',
      'send': 'يرسل',
      'subject': 'موضوع',
      'body': 'جسم',
      'send_email': 'ارسل بريد الكتروني',
      'email_receipt': 'إيصال الدفع بالبريد الإلكتروني إلى العميل',
      'auto_billing': 'الفواتير التلقائية',
      'button': 'زر',
      'preview': 'معاينة',
      'customize': 'يعدل أو يكيف',
      'history': 'سجل',
      'payment': 'قسط',
      'payments': 'الدفعات',
      'refunded': 'معاد',
      'payment_type': 'نوع الدفع',
      'transaction_reference': 'رمز العملية',
      'enter_payment': 'ادخل الدفعة',
      'new_payment': 'أدخل الدفعة',
      'created_payment': 'تم إنشاء الدفع بنجاح',
      'updated_payment': 'تم تحديث الدفع بنجاح',
      'archived_payment': 'تمت أرشفة الدفع بنجاح',
      'deleted_payment': 'تم حذف الدفع بنجاح',
      'restored_payment': 'تمت استعادة الدفع بنجاح',
      'archived_payments': 'تمت ارشفة :count مدفوعات بنجاح',
      'deleted_payments': 'تم حذف :count مدفوعات بنجاح',
      'restored_payments': 'تمت استعادة مدفوعات :value بنجاح',
      'quote': 'عرض أسعار',
      'quotes': 'عروض أسعار',
      'new_quote': 'عرض سعر جديد',
      'created_quote': 'تم إنشاء عرض السعر بنجاح',
      'updated_quote': 'تم تعديل عرض السعر بنجاح',
      'archived_quote': 'تم أرشفة عرض السعر بنجاح',
      'deleted_quote': 'تم حذف عرض السعر بنجاح',
      'restored_quote': 'تمت استعادة الاقتباس بنجاح',
      'archived_quotes': 'تم أرشفة عرض السعر بنجاح :count quotes',
      'deleted_quotes': 'تم حذف علامات الاقتباس :count بنجاح',
      'restored_quotes': 'تمت استعادة اقتباسات :value بنجاح',
      'expense': 'مصروف',
      'expenses': 'نفقات',
      'vendor': 'بائع',
      'vendors': 'الباعة',
      'task': 'مهمة',
      'tasks': 'المهام',
      'project': 'مشروع',
      'projects': 'المشاريع',
      'activity_1': ':user أنشأ العميل :client',
      'activity_2': ':user العميل المؤرشف :client',
      'activity_3': ':user العميل المحذوف :client',
      'activity_4': ':user إنشاء فاتورة :invoice',
      'activity_5': ':user الفاتورة المحدثة :invoice',
      'activity_6':
          ':user فاتورة بالبريد الإلكتروني :invoice لـ :client إلى :contact',
      'activity_7': ':contact الفاتورة المعروضة :invoice لـ :client',
      'activity_8': ':user الفاتورة المؤرشفة :invoice',
      'activity_9': ':user الفاتورة المحذوفة :invoice',
      'activity_10':
          ':user الدفعة المدخلة :payment لـ :payment _المبلغ الموجود في الفاتورة :invoice لـ :client',
      'activity_11': ':user الدفع المحدث :payment',
      'activity_12': ':user الدفع المؤرشف :payment',
      'activity_13': ':user الدفعة المحذوفة :payment',
      'activity_14': 'دخل :user رصيد :credit',
      'activity_15': ':user محدث :credit الائتمان',
      'activity_16': ':user مؤرشفة :credit الائتمان',
      'activity_17': ':user حذف رصيد :credit',
      'activity_18': 'تم إنشاء اقتباس :user :quote',
      'activity_19': ':user اقتباس محدث :quote',
      'activity_20':
          ':user اقتباس بالبريد الإلكتروني :quote لـ :client إلى :contact',
      'activity_21': ':contact عرض الاقتباس :quote',
      'activity_22': 'اقتباس مؤرشف :user :quote',
      'activity_23': ':user اقتباس محذوف :quote',
      'activity_24': ':user المستعادة اقتباس :quote',
      'activity_25': ':user الفاتورة المستعادة :invoice',
      'activity_26': ':user العميل المستعاد :client',
      'activity_27': ':user المستعادة الدفع :payment',
      'activity_28': ':user تمت استعادة رصيد :credit',
      'activity_29': ':contact اقتباس معتمد :quote لـ :client',
      'activity_30': 'إنشاء :user البائع :vendor',
      'activity_31': ':user بائع مؤرشف :vendor',
      'activity_32': ':user البائع المحذوف :vendor',
      'activity_33': ':user البائع المستعاد :vendor',
      'activity_34': 'إنشاء :user حساب :expense',
      'activity_35': 'مصاريف مؤرشفة :user :expense',
      'activity_36': ':user مصاريف محذوفة :expense',
      'activity_37': ':user المصاريف المستعادة :expense',
      'activity_39': 'إلغاء :user :payment_amount دفعة :payment',
      'activity_40':
          ':user المستردة :adjustment من :payment_amount payment :payment',
      'activity_41': ':payment_amount payment (:payment) فشل',
      'activity_42': 'تم إنشاء مهمة :user :task',
      'activity_43': 'مهمة :user المحدثة :task',
      'activity_44': ':user مهمة مؤرشفة :task',
      'activity_45': 'مهمة :user المحذوفة :task',
      'activity_46': 'مهمة :user المستعادة :task',
      'activity_47': ':user المصاريف المحدثة :expense',
      'activity_48': ':user أنشىء  :user',
      'activity_49': ':user المستخدم المحدث :user',
      'activity_50': ':user المستخدم المؤرشف :user',
      'activity_51': ':user المستخدم المحذوف :user',
      'activity_52': ':user المستخدم المستعاد :user',
      'activity_53': 'تم وضع علامة :user المرسلة :invoice',
      'activity_54': ':user فاتورة مدفوعة :invoice',
      'activity_55': 'رد :contact تذكرة: تذكرة',
      'activity_56': ':user عرض التذكرة: تذكرة',
      'activity_57': 'فشل النظام في إرسال الفاتورة بالبريد الإلكتروني :invoice',
      'activity_58': ':user فاتورة معكوسة :invoice',
      'activity_59': ':user الفاتورة الملغاة :invoice',
      'activity_60': ':contact شاهد العرض :quote',
      'activity_61': ':user تحديث العميل :client',
      'activity_62': ':user البائع المحدث :vendor',
      'activity_63':
          ':user عبر البريد الإلكتروني التذكير الأول للفاتورة :invoice إلى :contact',
      'activity_64':
          ':user البريد الإلكتروني التذكير الثاني للفاتورة :invoice إلى :contact',
      'activity_65':
          ':user البريد الإلكتروني التذكير الثالث للفاتورة :invoice إلى :contact',
      'activity_66':
          ':user عبر البريد الإلكتروني تذكير لا نهاية له للفاتورة :invoice إلى :contact',
      'activity_80': 'إنشاء :user الاشتراك :subscription',
      'activity_81': ':user تحديث الاشتراك :subscription',
      'activity_82': ':user الاشتراك المؤرشف :subscription',
      'activity_83': ':user تم حذف الاشتراك :subscription',
      'activity_84': ':user تمت استعادة الاشتراك :subscription',
      'one_time_password': 'كلمة السر لمرة واحدة',
      'emailed_quote': 'تم إرسال عرض السعر بنجاح',
      'emailed_credit': 'نجح إرسال الائتمان بالبريد الإلكتروني',
      'marked_quote_as_sent': 'نجح وضع علامة على الاقتباس على أنه تم الإرسال',
      'marked_credit_as_sent': 'نجح وضع علامة على الائتمان على أنه مرسل',
      'expired': 'منتهي الصلاحية',
      'all': 'الجميع',
      'select': 'اختيار',
      'long_press_multiselect': 'اضغط مطولاً على التحديد المتعدد',
      'custom_value1': 'القيمة المخصصة 1',
      'custom_value2': 'القيمة المخصصة 2',
      'custom_value3': 'القيمة المخصصة 3',
      'custom_value4': 'القيمة المخصصة 4',
      'email_style_custom': 'نمط البريد الإلكتروني المخصص',
      'custom_message_dashboard': 'رسالة مخصصة للوحة المعلومات',
      'custom_message_unpaid_invoice': 'رسالة فاتورة مخصصة غير مدفوعة',
      'custom_message_paid_invoice': 'رسالة فاتورة مخصصة مدفوعة',
      'custom_message_unapproved_quote': 'رسالة اقتباس مخصصة غير معتمدة',
      'lock_invoices': 'قفل الفواتير',
      'translations': 'الترجمات',
      'task_number_pattern': 'نمط رقم المهمة',
      'task_number_counter': 'عداد رقم المهمة',
      'expense_number_pattern': 'نمط رقم المصاريف',
      'expense_number_counter': 'عداد رقم المصاريف',
      'vendor_number_pattern': 'نمط رقم البائع',
      'vendor_number_counter': 'عداد رقم البائع',
      'ticket_number_pattern': 'نمط رقم التذكرة',
      'ticket_number_counter': 'عداد رقم التذكرة',
      'payment_number_pattern': 'نمط رقم الدفع',
      'payment_number_counter': 'عداد رقم الدفع',
      'invoice_number_pattern': 'نمط رقم الفاتورة',
      'invoice_number_counter': 'عداد رقم الفاتورة',
      'quote_number_pattern': 'نمط رقم الاقتباس',
      'quote_number_counter': 'عداد رقم الاقتباس',
      'client_number_pattern': 'نمط رقم الائتمان',
      'client_number_counter': 'عداد رقم الائتمان',
      'credit_number_pattern': 'نمط رقم الائتمان',
      'credit_number_counter': 'عداد رقم الائتمان',
      'reset_counter_date': 'إعادة تعيين تاريخ العداد',
      'counter_padding': 'الحشو العداد',
      'shared_invoice_quote_counter': 'مشاركة الفاتورة/عداد الأسعار',
      'default_tax_name_1': 'الاسم الضريبي الافتراضي 1',
      'default_tax_rate_1': 'معدل الضريبة الافتراضي 1',
      'default_tax_name_2': 'الاسم الضريبي الافتراضي 2',
      'default_tax_rate_2': 'معدل الضريبة الافتراضي 2',
      'default_tax_name_3': 'الاسم الضريبي الافتراضي 3',
      'default_tax_rate_3': 'معدل الضريبة الافتراضي 3',
      'email_subject_invoice': 'موضوع فاتورة البريد الإلكتروني',
      'email_subject_quote': 'موضوع اقتباس البريد الإلكتروني',
      'email_subject_payment': 'موضوع الدفع بالبريد الإلكتروني',
      'email_subject_payment_partial': 'موضوع الدفع الجزئي بالبريد الإلكتروني',
      'show_table': 'عرض الجدول',
      'show_list': 'عرض القائمة',
      'client_city': 'مدينة العميل',
      'client_state': 'دولة عميلة',
      'client_country': 'بلد العميل',
      'client_is_active': 'العميل نشط',
      'client_balance': 'رصيد العميل',
      'client_address1': 'شارع العميل',
      'client_address2': 'شقة/جناح العميل',
      'vendor_address1': 'شارع البائع',
      'vendor_address2': 'بائع شقة / جناح',
      'client_shipping_address1': 'شارع الشحن للعميل',
      'client_shipping_address2': 'شقة/جناح الشحن للعميل',
      'type': 'يكتب',
      'invoice_amount': 'قيمة الفاتورة',
      'invoice_due_date': 'تاريخ الاستحقاق',
      'tax_rate1': 'معدل الضريبة 1',
      'tax_rate2': 'معدل الضريبة 2',
      'tax_rate3': 'معدل الضريبة 3',
      'auto_bill': 'فاتورة السيارات',
      'archived_at': 'مؤرشف في',
      'has_expenses': 'لها مصاريف',
      'custom_taxes1': 'الضرائب الجمركية 1',
      'custom_taxes2': 'الضرائب الجمركية 2',
      'custom_taxes3': 'الضرائب الجمركية 3',
      'custom_taxes4': 'الضرائب الجمركية 4',
      'custom_surcharge1': 'رسوم إضافية مخصصة 1',
      'custom_surcharge2': 'رسوم إضافية مخصصة 2',
      'custom_surcharge3': 'رسوم إضافية مخصصة 3',
      'custom_surcharge4': 'رسوم إضافية مخصصة 4',
      'is_deleted': 'يتم حذف',
      'vendor_city': 'مدينة البائع',
      'vendor_state': 'دولة البائع',
      'vendor_country': 'بلد البائع',
      'is_approved': 'تمت الموافقة',
      'tax_name': 'الاسم الضريبي',
      'tax_amount': 'قيمة الضريبة',
      'tax_paid': 'الضريبة المدفوعة',
      'payment_amount': 'قيمة الدفعة',
      'age': 'عمر',
      'is_running': 'يجري',
      'time_log': 'سجل الوقت',
      'bank_id': 'بنك',
      'expense_category_id': 'معرف فئة المصاريف',
      'expense_category': 'فئة المصاريف',
      'invoice_currency_id': 'معرف عملة الفاتورة',
      'tax_name1': 'اسم الضريبة 1',
      'tax_name2': 'اسم الضريبة 2',
      'tax_name3': 'اسم الضريبة 3',
      'transaction_id': 'معرف العملية',
      'status_color_theme': 'موضوع لون الحالة',
      'load_color_theme': 'تحميل موضوع اللون',
    },
    'bg': {
      'location': 'Местоположение',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Местоположение изтрит',
      'added_location': 'Successfully added location',
      'updated_location': 'обновена Местоположение',
      'edit_location': 'Редактирай местоположението',
      'add_location': 'Добавете местоположение',
      'locations': 'Местоположения',
      'preference_product_notes_for_html_view':
          'Use Item Notes for HTML Прегледай',
      'preference_product_notes_for_html_view_help':
          'Предпочитайте описанието на артикула пред заглавието му, ако показвате Фактура в HTML.',
      'in_stock_quantity': 'Складово количество',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update':
          'Позволете на Клиенти до актуализират своя профил',
      'enable_client_profile_update_help':
          'Позволете на Клиенти до актуализират информацията за своя профил от клиент портал',
      'participant': 'участник',
      'merged_vendors': 'Успешно обединени доставчици',
      'activity_146':
          'E- Фактура :invoice за :client Успешно доставено! :notes',
      'activity_147':
          'E- Фактура :invoice за :client неуспешна доставка. :notes',
      'activity_148': 'E- Разход :expense получен от :vendor',
      'payment_failed': 'Плащане Failed',
      'activity_141': 'Потребител :user влезе Бележка : :notes',
      'activity_142': 'цитат :quote напомняне 1 изпратено',
      'activity_143': 'Auto Bill успя за Фактура :invoice',
      'activity_144': 'Auto Bill се провали за Фактура :invoice . :notes',
      'activity_145': 'E- Фактура :invoice за :client беше изпратена. :notes',
      'ssl_host_override': 'SSL Host Override',
      'upload_logo_short': 'Качване на лого',
      'show_pdfhtml_on_mobile_help':
          'За подобрена визуализация, показва HTML версия на Фактура / цитат при гледане на мобилно устройство.',
      'accept_purchase_order': 'Приемане на поръчката за покупка',
      'one_page_checkout': 'Плащане на една страница',
      'one_page_checkout_help': 'Enable the нов single page Плащане flow',
      'applies_to': 'Прилага се до',
      'purchase_order_items': 'Артикули за поръчка за покупка',
      'assigned_group': 'Успешно назначена група',
      'assign_group': 'Присвояване на група',
      'merge_to_pdf': 'Обединяване до PDF',
      'emails': 'Имейли',
      'latest_requires_php_version':
          'Бележка : най-новата версия изисква PHP :version',
      'quote_reminder1': 'Първо цитат напомняне',
      'before_valid_until': 'Преди валидно до',
      'after_valid_until': 'След валидно до',
      'after_quote_date': 'След датата цитат',
      'remind_quote': 'Напомни цитат',
      'task_assigned_notification': 'Задача Присвоено известие',
      'task_assigned_notification_help':
          'Изпратете имейл , когато е назначена Задача',
      'invoices_locked_end_of_month': 'Фактури се заключват в края на месеца',
      'end_of_month': 'Краят на месеца',
      'referral_url': 'URL адрес за препоръка',
      'referral_program': 'Referral Program',
      'comment': 'Коментар',
      'add_comment': 'Добавете коментар',
      'added_comment': 'Успешно запазен коментар',
      'disconnected': 'Прекъсната връзка',
      'reconnect': 'Свържете се отново',
      'e_invoice_settings': 'E- Фактура Настройки',
      'calculate': 'Изчислете',
      'sum': 'Сума',
      'money': 'Пари',
      'time': 'Време',
      'format': 'Формат',
      'web_app': 'Уеб приложение',
      'desktop_app': 'Настолно приложение',
      'invoice_net_amount': 'Фактура Net Сума',
      'round_to_seconds': 'Кръг до секунди',
      '1_minute': '1 минута',
      '5_minutes': '5 минути',
      '15_minutes': '15 минути',
      '30_minutes': '30 минути',
      '1_hour': '1 час',
      '1_day': '1 ден',
      'round_tasks': 'Задача Посока на закръгляване',
      'round_tasks_help': 'Кръгла Задача пъти нагоре или надолу.',
      'direction': 'Посока',
      'round_up': 'Закръглете нагоре',
      'round_down': 'Закръглете надолу',
      'task_round_to_nearest': 'Кръг до Най-близкия',
      'activity_139': 'Разход :expense известие изпратено до :contact',
      'activity_140': 'Изявлението е изпратено до :client',
      'bulk_updated': 'Успешно обновена данни',
      'bulk_update': 'Групово актуализиране',
      'advanced_cards': 'Разширени карти',
      'always_show_required_fields':
          'Винаги показвай формата за задължителни полета',
      'always_show_required_fields_help':
          'Показва формуляра за задължителни полета винаги при плащане',
      'flutter_web_warning':
          'Препоръчваме да използвате нов уеб приложение или настолното приложение за най-добра производителност',
      'rappen_rounding': 'Рапен закръгляване',
      'rappen_rounding_help': 'Кръгла Сума до 5 цента',
      'check_credentials': 'Проверете идентификационните данни',
      'valid_credentials': 'Идентификационните данни са валидни',
      'invalid_credentials':
          'Въведените данни не зъвпадат със записаните при нас',
      'e_quote': 'Е- цитат',
      'e_credit': 'Електронен кредит',
      'e_purchase_order': 'Електронна поръчка за покупка',
      'valid_vat_number': 'Валиден ДДС номер',
      'use_available_payments': 'Използвайте Налични Плащания',
      'test_email_sent': 'Успешно изпратен имейл',
      'send_test_email': 'Изпратете тест имейл',
      'gateway_type': 'тип вход',
      'please_select_an_invoice_or_credit': 'Моля, изберете Фактура или кредит',
      'mobile_version': 'Мобилна версия',
      'venmo': 'Венмо',
      'mercado_pago': 'Меркадо Паго',
      'my_bank': 'MyBank',
      'pay_later': 'Платете по-късно',
      'email_report': 'имейл Доклад',
      'host': 'Host',
      'port': 'Порт',
      'encryption': 'Криптиране',
      'local_domain': 'Локален домейн',
      'verify_peer': 'Проверете Peer',
      'username': 'Потребителско име',
      'nordigen_help':
          'Бележка : свързването на сметка изисква GoCardless/Nordigen API ключ',
      'participant_name': 'Име на участник',
      'yodlee_regions': 'Региони: САЩ, Великобритания, Австралия и Индия',
      'nordigen_regions': 'Региони: Европа и Великобритания',
      'select_provider': 'Изберете Доставчик',
      'payment_type_credit': 'Плащане Вид Кредит',
      'payment_type_debit': 'Плащане Тип Дебит',
      'send_emails_to': 'Изпращане на имейли до',
      'primary_contact': 'Основен контакт',
      'all_contacts': 'Всички контакти',
      'insert_below': 'Вмъкнете по-долу',
      'ar_detailed': 'Подробности за вземанията',
      'ar_summary': 'Резюме на вземанията',
      'client_sales': 'Клиент Продажби',
      'tax_summary': 'Данъчно резюме',
      'user_sales': 'Потребител Продажби',
      'run_template': 'Стартиране на шаблон',
      'task_extension_banner':
          'Добавете разширението за Chrome, до управлявате своите Задачи',
      'watch_video': 'Гледайте видео',
      'view_extension': 'Прегледай Extension',
      'reactivate_email': 'Реактивирайте имейл',
      'email_reactivated': 'Успешно реактивиран имейл',
      'template_help': 'Разрешете използването на дизайна като шаблон',
      'delivery_note_design': 'Доставка Бележка Дизайн',
      'statement_design': 'Изявление дизайн',
      'payment_receipt_design': 'Дизайн на касова бележка Плащане',
      'payment_refund_design': 'Плащане Refund Design',
      'quarter': 'Квартал',
      'item_description': 'Описание на елемента',
      'task_item': 'Задача Item',
      'record_state': 'Състояние на записа',
      'last_login': 'Последно влизане',
      'save_files_to_this_folder': 'Запази файловете до тази папка',
      'downloads_folder': 'Папка за изтегляния',
      'total_invoiced_quotes': 'Фактурирани цитати',
      'total_invoice_paid_quotes': 'Фактура Платени цитати',
      'downloads_folder_does_not_exist':
          'Папката за изтегляне не съществува :value',
      'user_logged_in_notification': 'Потребител Уведомление за влизане',
      'user_logged_in_notification_help':
          'Изпращане на имейл при влизане от нов място',
      'client_contact': 'Клиент контакт',
      'expense_status_4': 'Неплатени',
      'expense_status_5': 'Платено',
      'recurring': 'Периодично',
      'ziptax_help':
          'Бележка : тази функция изисква Zip-Tax API ключ до търсене на данък върху продажбите в САЩ по адрес',
      'cache_data': 'Кеширане на данни',
      'unknown': 'неизвестен',
      'webhook_failure': 'Неуспешна уебкукичка',
      'email_opened': 'имейл отворен',
      'email_delivered': 'имейл Доставено',
      'log': 'Дневник',
      'individual': 'Индивидуален',
      'partnership': 'Партньорство',
      'trust': 'доверие',
      'charity': 'Благотворителност',
      'government': 'Правителство',
      'classification': 'Класификация',
      'click_or_drop_files_here': 'Щракнете или пуснете файлове тук',
      'public': 'Обществен',
      'private': 'Частно',
      'image': 'Изображение',
      'other': 'други',
      'hash': 'Хеш',
      'linked_to': 'Свързан до',
      'file_saved_in_path': 'Файлът е записан в :path',
      'unlinked_transactions': 'Успешно несвързани :count транзакции',
      'unlinked_transaction': 'Успешно несвързана транзакция',
      'unlink': 'Разделяне',
      'view_dashboard_permission':
          'Разрешете Потребител до достъп до таблото за управление, данните са ограничени до наличните разрешения',
      'is_tax_exempt': 'Освободени от данъци',
      'district': 'област',
      'region': 'Регион',
      'county': 'окръг',
      'tax_details': 'Данъчни детайли',
      'activity_10_online':
          ':contact направи Плащане :payment за Фактура :invoice за :client',
      'activity_10_manual':
          ':user влезе в Плащане :payment за Фактура :invoice за :client',
      'default_payment_type': 'Тип Плащане по подразбиране',
      'admin_initiated_payments': 'Admin Initiated Плащания',
      'admin_initiated_payments_help':
          'Подкрепете въвеждането на Плащане в админ портала без Фактура',
      'use_mobile_to_manage_plan':
          'Използвайте абонамента си Телефон Настройки до управление на вашия план',
      'show_task_billable': 'Покажи Задача Платима',
      'credit_item': 'Кредитна позиция',
      'files': 'файлове',
      'camera': 'Камера',
      'gallery': 'Галерия',
      'email_count_invoices': 'имейл :count Фактури',
      'project_location': 'Местоположение на проекта',
      'invoice_task_item_description': 'Фактура Задача Item Description',
      'invoice_task_item_description_help':
          'Добавете описанието на артикула до елементите Фактура',
      'next_send_time': 'Следващо време за изпращане',
      'uploaded_certificate': 'Успешно качен сертификат',
      'certificate_set': 'Комплект сертификати',
      'certificate_not_set': 'Сертификатът не е зададен',
      'passphrase_set': 'Зададена парола',
      'passphrase_not_set': 'Паролата не е зададена',
      'upload_certificate': 'Качване на сертификат',
      'certificate_passphrase': 'Парола за сертификат',
      'rename': 'Преименуване',
      'renamed_document': 'Успешно преименуван документ',
      'e_invoice': 'E- Фактура',
      'light_dark_mode': 'Светъл/тъмен режим',
      'activities': 'дейности',
      'routing_id': 'ID на маршрута',
      'enable_e_invoice': 'Активирайте E- Фактура',
      'e_invoice_type': 'Тип E- Фактура',
      'e_quote_type': 'Е- цитат Тип',
      'reduced_tax': 'Намален данък',
      'override_tax': 'Отменен данък',
      'zero_rated': 'Нулева оценка',
      'reverse_tax': 'Обратен данък',
      'updated_tax_category': 'Успешно обновена данъчната категория',
      'updated_tax_categories': 'Успешно обновена данъчните категории',
      'set_tax_category': 'Задайте данъчна категория',
      'payment_manual': 'Плащане Ръководство',
      'tax_category': 'Данъчна категория',
      'physical_goods': 'Физически стоки',
      'digital_products': 'Дигитални продукти',
      'services': 'Услуги',
      'shipping': 'Доставка',
      'tax_exempt': 'Освободени от данъци',
      'reduced_rate': 'Намалена ставка',
      'tax_all': 'Всички данъци',
      'tax_selected': 'Избран данък',
      'version': 'версия',
      'seller_subregion': 'Подрегион на продавача',
      'calculate_taxes': 'Изчисляване на данъци',
      'calculate_taxes_help':
          'Автоматично изчисляване на данъци при запазване Фактури',
      'admin': 'Администриране',
      'owner': 'Собственик',
      'link_expenses': 'Разходи за връзка',
      'converted_client_balance': 'Преобразуван Клиент баланс',
      'converted_payment_balance': 'Преобразуван баланс Плащане',
      'total_hours': 'Общо часове',
      'date_picker_hint': 'Използвайте + дни до да зададете датата в бъдещето',
      'browser_pdf_viewer': 'Използвайте Browser PDF Viewer',
      'browser_pdf_viewer_help':
          'Предупреждение: Предотвратява взаимодействието с приложението през PDF',
      'increase_prices': 'Увеличаване на цените',
      'update_prices': 'Актуализиране на цените',
      'incresed_prices': 'Успешно queued цените до се увеличават',
      'updated_prices': 'Успешно queued цени до бъдат обновена',
      'bacs': 'BACS Директен дебит',
      'api_token': 'API токен',
      'api_key': 'API ключ',
      'endpoint': 'Крайна точка',
      'billable': 'За плащане',
      'not_billable': 'Не се таксува',
      'allow_billable_task_items': 'Разрешаване на таксувани елементи Задача',
      'allow_billable_task_items_help':
          'Активиране на конфигурирането на артикулите Задача се таксуват',
      'show_task_item_description': 'Покажи Задача Описание на елемента',
      'show_task_item_description_help':
          'Разрешете посочването на описания на артикули Задача',
      'email_record': 'имейл запис',
      'invoice_product_columns': 'Фактура Продуктови колони',
      'quote_product_columns': 'цитат Продуктови колони',
      'minimum_payment_amount': 'Минимум Плащане Сума',
      'client_initiated_payments': 'Клиент Initiated Плащания',
      'client_initiated_payments_help':
          'Подкрепете създаването на Плащане в клиент портал без Фактура',
      'share_invoice_quote_columns': 'Сподели Фактура / цитат Колони',
      'cc_email': 'CC имейл',
      'payment_balance': 'Плащане Balance',
      'view_report_permission':
          'Разрешете Потребител до достъп до отчетите, данните са ограничени до наличните разрешения',
      'activity_138': 'Плащане :payment е изпратен по имейл до :client',
      'one_time_products': 'Еднократни продукти',
      'optional_one_time_products': 'Опционални еднократни продукти',
      'required': 'Задължително',
      'hidden': 'Скрити',
      'payment_links': 'Плащане Links',
      'action': 'Действие',
      'upgrade_to_paid_plan_to_schedule':
          'Надградете до платен план до Създай графици',
      'next_run': 'Следващо изпълнение',
      'all_clients': 'Всички Клиенти',
      'show_aging_table': 'Показване на таблицата за стареене',
      'show_payments_table': 'Покажи Плащания Таблица',
      'only_clients_with_invoices': 'Само Клиенти с Фактури',
      'email_statement': 'имейл изявление',
      'once': 'Веднъж',
      'schedule': 'График',
      'schedules': 'Графици',
      'new_schedule': 'Нов график',
      'edit_schedule': 'Редактирай График',
      'created_schedule': 'Успешно Създадена график',
      'updated_schedule': 'Успешно обновена график',
      'archived_schedule': 'Успешно архивиран график',
      'deleted_schedule': 'Успешно изтрит график',
      'removed_schedule': 'Успешно премахнат график',
      'restored_schedule': 'Успешно възстановена график',
      'search_schedule': 'График за търсене',
      'search_schedules': 'Графици за търсене',
      'archive_payment': 'Архивирай плащане',
      'archive_invoice': 'Архивиране на фактура',
      'archive_quote': 'Архивирай Оферта',
      'archive_credit': 'Архивирай кредит',
      'archive_task': 'Архивиране на задача',
      'archive_client': 'Архивирай клиент',
      'archive_project': 'Архивиране на проект',
      'archive_expense': 'Архивиране на разход',
      'restore_payment': 'Възтанови Плащане',
      'restore_invoice': 'Възтанови Фактура',
      'restore_quote': 'Възтанови Оферта',
      'restore_credit': 'Възтанови Кредит',
      'restore_task': 'Възстановяване на задача',
      'restore_client': 'Възтанови Клиент',
      'restore_project': 'Възстановяване на проект',
      'restore_expense': 'Възстановяване на разход',
      'archive_vendor': 'Архивиране на доставчик',
      'restore_vendor': 'Възстановяване на доставчик',
      'create_product': 'Нов продукт',
      'update_product': 'Актуализирайте продукта',
      'delete_product': 'Изтриване на продукт',
      'restore_product': 'Възстановяване на продукт',
      'archive_product': 'Архивирай продукт',
      'create_purchase_order': 'Създай поръчка за покупка',
      'update_purchase_order': 'Актуализиране на поръчката за покупка',
      'delete_purchase_order': 'Изтрий Поръчка за покупка',
      'restore_purchase_order': 'Възстанови Поръчка за покупка',
      'archive_purchase_order': 'Архивирай Поръчка за покупка',
      'sent_invoice': 'Изпратено Фактура',
      'sent_quote': 'Изпратен цитат',
      'sent_credit': 'Изпратен кредит',
      'sent_purchase_order': 'Изпратена поръчка за покупка',
      'image_url': 'URL адрес на изображението',
      'max_quantity': 'Максимално количество',
      'test_url': 'Тествайте URL',
      'auto_bill_help_off': 'Опцията не е показана',
      'auto_bill_help_optin': 'Опцията е показана, но не е избрана',
      'auto_bill_help_optout': 'Опцията е показана и избрана',
      'auto_bill_help_always': 'Опцията не е показана',
      'payment_methods': 'Методи за плащане',
      'view_all': 'Прегледай All',
      'edit_all': 'Редактирай All',
      'accept_purchase_order_number': 'Приемете номера на поръчката за покупка',
      'accept_purchase_order_number_help':
          'Активирайте Клиенти до предоставяне на номер на поръчка при одобряване на цитат',
      'from_email': 'От имейл',
      'show_preview': 'Показване на визуализация',
      'show_paid_stamp': 'Показване на платен печат',
      'show_shipping_address': 'Показване на адреса за доставка',
      'no_documents_to_download':
          'Няма документи в избраните записи до изтегляне',
      'pixels': 'Пиксели',
      'logo_size': 'Размер на логото',
      'postal_city': 'Поща/Град',
      'failed': 'Неуспешно',
      'client_contacts': 'Клиент Контакти',
      'sync_from': 'Синхронизиране от',
      'inventory_threshold': 'Праг на инвентара',
      'hour': 'час',
      'emailed_statement': 'Успешно queued statement до се изпраща',
      'show_email_footer': 'Показване имейл Footer',
      'invoice_task_hours': 'Фактура Задача Часове',
      'invoice_task_hours_help': 'Добавете часовете до елементите Фактура',
      'auto_bill_standard_invoices': 'Auto Bill Standard Фактури',
      'auto_bill_recurring_invoices': 'Auto Bill Периодична Фактури',
      'email_alignment': 'имейл подравняване',
      'pdf_preview_location': 'Местоположение за визуализация PDF',
      'mailgun': 'Пощенски пистолет',
      'postmark': 'Пощенско клеймо',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Щракнете върху + до Създай запис',
      'last365_days': 'Последните 365 дни',
      'import_design': 'Импортиране на дизайн',
      'imported_design': 'Успешно импортиран дизайн',
      'invalid_design': 'Дизайнът е невалиден, липсва разделът :value',
      'setup_wizard_logo': 'Искате ли до качите вашето лого?',
      'upload': 'Качване',
      'installed_version': 'Инсталирана версия',
      'notify_vendor_when_paid': 'Уведомете Доставчик при плащане',
      'notify_vendor_when_paid_help':
          'Изпратете имейл до Доставчик , когато Разход е маркиран като платен',
      'update_payment': 'Update Плащане',
      'markup': 'Маркиране',
      'purchase_order_created': 'Поръчка за покупка Създадена',
      'purchase_order_sent': 'Поръчката за покупка е изпратена',
      'purchase_order_viewed': 'Поръчката за покупка е прегледана',
      'purchase_order_accepted': 'Поръчката за покупка е приета',
      'credit_payment_error':
          'Кредитът Сума не може да бъде по-голям от Плащане Сума',
      'klarna': 'Кларна',
      'convert_payment_currency_help':
          'Задаване на обменен курс при ръчно въвеждане Плащане',
      'convert_expense_currency_help':
          'Задайте обменен курс, когато създавате Разход',
      'matomo_url': 'URL на Matomo',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Добавете до Фактура',
      'online_payment_email_help':
          'Изпратете имейл , когато се направи онлайн Плащане',
      'manual_payment_email_help':
          'Изпращане имейл при ръчно въвеждане на Плащане',
      'mark_paid_payment_email_help':
          'Изпратете имейл , когато маркирате Фактура като платена',
      'delete_project': 'Изтриване на проект',
      'linked_transaction': 'Успешно свързана транзакция',
      'link_payment': 'Линк Плащане',
      'link_expense': 'Линк Разход',
      'lock_invoiced_tasks': 'Заключване Фактурирани Задачи',
      'lock_invoiced_tasks_help':
          'Предотвратяване на редактиране Задачи след фактуриране',
      'registration_required': 'Необходима е регистрация',
      'registration_required_help': 'Изискване Клиенти до регистрация',
      'use_inventory_management': 'Използвайте управление на инвентара',
      'use_inventory_management_help': 'Изисквайте продуктите до са на склад',
      'optional_products': 'Опционални продукти',
      'optional_recurring_products': 'Периодична продукти по избор',
      'convert_matched': 'Преобразуване',
      'auto_billed_invoice': 'Успешно queued Фактура до be auto-billing',
      'auto_billed_invoices': 'Успешно queued Фактури до be auto-billing',
      'operator': 'Оператор',
      'value': 'Стойност',
      'is': 'Е',
      'contains': 'Съдържа',
      'starts_with': 'Започва с',
      'is_empty': 'е празен',
      'add_rule': 'Добавете правило',
      'match_all_rules': 'Съвпадение на всички правила',
      'match_all_rules_help':
          'Всички критерии трябва до съвпадат, за до се приложи правилото',
      'auto_convert_help':
          'Автоматично преобразувайте съответстващи транзакции до разходи',
      'rules': 'правила',
      'transaction_rule': 'Правило за транзакция',
      'transaction_rules': 'Правила за транзакции',
      'new_transaction_rule': 'Ново правило за транзакция',
      'edit_transaction_rule': 'Редактирай Правило за транзакция',
      'created_transaction_rule': 'Успешно Създадена правило',
      'updated_transaction_rule': 'Успешно обновена правило за транзакция',
      'archived_transaction_rule': 'Успешно архивиран правило за транзакция',
      'deleted_transaction_rule': 'Успешно изтрит правило за транзакция',
      'removed_transaction_rule': 'Успешно премахнато правило за транзакция',
      'restored_transaction_rule': 'Успешно възстановена правило за транзакция',
      'search_transaction_rule': 'Правило за транзакция за търсене',
      'search_transaction_rules': 'Търсете правила за транзакции',
      'save_as_default_terms': 'Запази като условия по подразбиране',
      'save_as_default_footer': 'Запази като футър по подразбиране',
      'auto_sync': 'Автоматично синхронизиране',
      'refresh_accounts': 'Обновяване на акаунти',
      'upgrade_to_connect_bank_account':
          'Надстройте до Enterprise, до да свържете вашата Банкова сметка',
      'click_here_to_connect_bank_account':
          'Щракнете тук, до свържете своята Банкова сметка',
      'disable_2fa': 'Деактивирайте 2FA',
      'change_number': 'Смяна на номера',
      'resend_code': 'Повторно изпращане код',
      'base_type': 'Основен тип',
      'category_type': 'Тип категория',
      'bank_transaction': 'Транзакция',
      'bulk_print': 'Отпечатайте PDF',
      'vendor_postal_code': 'Доставчик Пощенски код',
      'preview_location': 'Визуализация на местоположението',
      'bottom': 'Отдолу',
      'side': 'отстрани',
      'pdf_preview': 'PDF визуализация',
      'long_press_to_select': 'Натиснете продължително до Избор',
      'purchase_order_number': 'Номер на поръчката за покупка',
      'purchase_order_item': 'Поръчка за покупка',
      'would_you_rate_the_app': 'Искате ли до оцените приложението?',
      'include_deleted': 'Включете изтрит',
      'include_deleted_help': 'Включете изтрит записи в отчетите',
      'due_on': 'дължимото On',
      'converted_transactions': 'Успешно конвертирани транзакции',
      'created_bank_account': 'Успешно създадена банкова сметка',
      'updated_bank_account': 'Успешно актуализирана банкова сметка',
      'edit_bank_account': 'Редакция на банкова сметка',
      'default_category': 'Категория по подразбиране',
      'account_type': 'тип сметка',
      'new_bank_account': 'Добавете Банкова Сметка',
      'connect_accounts': 'Свържете акаунти',
      'manage_rules': 'Управление на правилата',
      'search_category': 'Търсене 1 категория',
      'search_categories': 'Търсене :count Категории',
      'min_amount': 'Мин Сума',
      'max_amount': 'Макс Сума',
      'selected': 'Избрани',
      'converted_transaction': 'Успешно конвертирана транзакция',
      'convert_to_payment': 'Convert до Плащане',
      'deposit': 'Депозит',
      'withdrawal': 'Оттегляне',
      'deposits': 'депозити',
      'withdrawals': 'Тегления',
      'matched': 'Съвпадение',
      'unmatched': 'несравнимо',
      'create_credit': 'Създай Кредит',
      'update_credit': 'Актуализация на кредит',
      'delete_credit': 'Изтрий кредит',
      'transaction': 'Транзакция',
      'transactions': 'Транзакции',
      'new_transaction': 'Нова транзакция',
      'edit_transaction': 'Редактирай Transaction',
      'created_transaction': 'Успешно Създадена транзакция',
      'updated_transaction': 'Успешно обновена сделка',
      'archived_transaction': 'Успешно архивиран транзакция',
      'deleted_transaction': 'Успешно изтрит транзакцията',
      'removed_transaction': 'Успешно премахната транзакция',
      'restored_transaction': 'Успешно възстановена сделка',
      'search_transaction': 'Транзакция за търсене',
      'search_transactions': 'Търсете :count транзакции',
      'bank_account': 'Банкова сметка',
      'bank_accounts': 'Кредитни карти и банки',
      'archived_bank_account': 'Успешно архивирана банкова сметка',
      'deleted_bank_account': 'Успешно изтрит Банкова сметка',
      'removed_bank_account': 'Успешно премахната Банкова сметка',
      'restored_bank_account': 'Успешно възстановена Банкова сметка',
      'search_bank_account': 'Търсене Банкова Сметка',
      'search_bank_accounts': 'Търсене :count Банка сметки',
      'connect': 'Свържете се',
      'mark_paid_payment_email': 'Маркирайте платено Плащане имейл',
      'convert_to_project': 'Конвертиране до Project',
      'client_email': 'Клиент имейл',
      'invoice_task_project': 'Фактура Задача Project',
      'invoice_task_project_help': 'Добавете проекта до позициите Фактура',
      'field': 'Поле',
      'period': 'Точка',
      'fields_per_row': 'Полета на ред',
      'total_active_invoices': 'Активни Фактури',
      'total_outstanding_invoices': 'Изключителни Фактури',
      'total_completed_payments': 'Завършен Плащания',
      'total_refunded_payments': 'Възстановени Плащания',
      'total_active_quotes': 'Активни цитати',
      'total_approved_quotes': 'Одобрена цитати',
      'total_unapproved_quotes': 'Неодобрени цитати',
      'total_logged_tasks': 'Записани Задачи',
      'total_invoiced_tasks': 'Фактурирани Задачи',
      'total_paid_tasks': 'Платени Задачи',
      'total_logged_expenses': 'Регистрирани разходи',
      'total_pending_expenses': 'Предстоящи разходи',
      'total_invoiced_expenses': 'Фактурирани разходи',
      'total_invoice_paid_expenses': 'Фактура Платени разходи',
      'activity_130': ':user Създадена поръчка за покупка :purchase_order',
      'activity_131': ':user обновена поръчка за покупка :purchase_order',
      'activity_132': ':user архивиран поръчка за покупка :purchase_order',
      'activity_133': ':user изтрит поръчка за покупка :purchase_order',
      'activity_134': ':user възстановена поръчка за покупка :purchase_order',
      'activity_135':
          ':user изпратена по имейл поръчка за покупка :purchase_order',
      'activity_136': ':contact прегледана поръчка за покупка :purchase_order',
      'activity_137': ':contact приета поръчка за покупка :purchase_order',
      'vendor_portal': 'Доставчик Портал',
      'send_code': 'Изпрати код',
      'save_to_upload_documents': 'Запази записа до да качите документи',
      'expense_tax_rates': 'Разход Данъчни ставки',
      'invoice_item_tax_rates': 'Фактура Данъчни ставки на предмета',
      'verified_phone_number': 'Успешно потвърден Телефон номер',
      'code_was_sent': 'Изпратен е код чрез SMS',
      'code_was_sent_to': 'Изпратен е код чрез SMS до :number',
      'resend': 'Повторно изпращане',
      'verify': 'Проверете',
      'enter_phone_number': 'Моля, предоставете Телефон номер',
      'invalid_phone_number': 'Невалиден Телефон номер',
      'verify_phone_number': 'Потвърдете Телефон номер',
      'verify_phone_number_help':
          'Моля, потвърдете Телефон си номер до изпращате имейли',
      'verify_phone_number_2fa_help':
          'Моля, потвърдете Телефон си номер за 2FA архивиране',
      'merged_clients': 'Успешно обединени Клиенти',
      'merge_into': 'Сливане в',
      'merge': 'Обединяване',
      'price_change_accepted': 'Приема се промяна на цената',
      'price_change_failed': 'Неуспешна промяна на цената с код',
      'restore_purchases': 'Възстанови покупки',
      'activate': 'Активирайте',
      'connect_apple': 'Свържете Apple',
      'disconnect_apple': 'Прекъснете връзката с Apple',
      'disconnected_apple': 'Успешно прекъсна връзката с Apple',
      'send_now': 'Изпратете сега',
      'received': 'получено',
      'purchase_order_date': 'Дата на поръчката за покупка',
      'converted_to_expense': 'Успешно converted до Разход',
      'converted_to_expenses': 'Успешно преобразувани до разходи',
      'convert_to_expense': 'Преобразуване до Разход',
      'add_to_inventory': 'Добавете до Inventory',
      'added_purchase_order_to_inventory':
          'Успешно добавена поръчка за покупка до инвентара',
      'added_purchase_orders_to_inventory':
          'Успешно добавени поръчки за покупка до инвентара',
      'client_document_upload': 'Клиент Качване на документ',
      'vendor_document_upload': 'Доставчик Качване на документи',
      'vendor_document_upload_help':
          'Разрешете доставчиците до качват документи',
      'are_you_enjoying_the_app': 'Харесвате ли приложението?',
      'yes_its_great': 'Да, страхотно е!',
      'not_so_much': 'Не толкова',
      'would_you_rate_it': 'Страхотно до чуеш! Искате ли до го оцените?',
      'would_you_tell_us_more':
          'Съжалявам до го чувам! Искате ли до ни кажете повече?',
      'sure_happy_to': 'Разбира се, щастлив до',
      'no_not_now': 'Не, не сега',
      'add': 'Добавете',
      'last_sent_template': 'Последно изпратен шаблон',
      'enable_flexible_search': 'Активиране на гъвкаво търсене',
      'enable_flexible_search_help':
          'Съвпадение на несъседни знаци, т.е. &quot;ct&quot; съвпада с &quot;cat&quot;',
      'vendor_details': 'Доставчик детайли',
      'purchase_order_details': 'Поръчка за покупка детайли',
      'qr_iban': 'QR IBAN',
      'besr_id': 'BESR ID',
      'accept': 'Приемам',
      'clone_to_purchase_order': 'Копирай до PO',
      'vendor_email_not_set': 'Доставчик няма зададен имейл адрес',
      'bulk_send_email': 'Изпратете имейл',
      'marked_purchase_order_as_sent':
          'Успешно маркира поръчката за покупка като изпратена',
      'marked_purchase_orders_as_sent':
          'Успешно маркира поръчките за покупка като изпратени',
      'accepted_purchase_order': 'Успешно приета поръчка за покупка',
      'accepted_purchase_orders': 'Успешно приети поръчки за покупка',
      'cancelled_purchase_order': 'Успешно отменена поръчка за покупка',
      'cancelled_purchase_orders': 'Успешно анулирани поръчки за покупка',
      'accepted': 'Прието',
      'please_select_a_vendor': 'Моля, изберете Доставчик',
      'purchase_order_total': 'Поръчка за покупка Общо',
      'email_purchase_order': 'имейл поръчка за покупка',
      'bulk_email_purchase_orders': 'имейл поръчки за покупка',
      'disconnected_email': 'Успешно прекъсва връзката имейл',
      'connect_email': 'Свържете имейл',
      'disconnect_email': 'Прекъснете имейл',
      'use_web_app_to_connect_microsoft':
          'Моля, използвайте уеб приложението до да се свържете до Microsoft',
      'email_provider': 'имейл доставчик',
      'connect_microsoft': 'Свържете Microsoft',
      'disconnect_microsoft': 'Прекъснете връзката с Microsoft',
      'connected_microsoft': 'Успешно свързан Microsoft',
      'disconnected_microsoft': 'Успешно прекъсна връзката с Microsoft',
      'microsoft_sign_in': 'Влезте с Microsoft',
      'microsoft_sign_up': 'Регистрирайте се с Microsoft',
      'emailed_purchase_order':
          'Успешно поставената на опашка поръчка за покупка до бъде изпратена',
      'emailed_purchase_orders':
          'Успешно поставените на опашка поръчки за покупка до се изпращат',
      'enable_react_app': 'Променете до уеб приложението React',
      'purchase_order_design': 'Дизайн на поръчка за покупка',
      'purchase_order_terms': 'Условия за поръчка за покупка',
      'purchase_order_footer': 'Долен колонтитул на поръчката за покупка',
      'require_purchase_order_signature': 'Подпис на поръчката за покупка',
      'require_purchase_order_signature_help':
          'Изисквайте Доставчик до предостави своя подпис.',
      'purchase_order': 'Поръчка за покупка',
      'purchase_orders': 'Поръчки за покупка',
      'new_purchase_order': 'Нова поръчка за покупка',
      'edit_purchase_order': 'Редактирай Поръчка за покупка',
      'created_purchase_order': 'Успешно Създадена поръчка за покупка',
      'updated_purchase_order': 'Успешно обновена поръчка за покупка',
      'archived_purchase_order': 'Успешно архивиран поръчка за покупка',
      'deleted_purchase_order': 'Успешно изтрит поръчка за покупка',
      'removed_purchase_order': 'Успешно премахната поръчка за покупка',
      'restored_purchase_order': 'Успешно възстановена поръчка за покупка',
      'search_purchase_order': 'Търсене на поръчка за покупка',
      'search_purchase_orders': 'Търсене на поръчки за покупка',
      'login_url': 'URL адрес за влизане',
      'payment_settings': 'Настройки за плащания',
      'default': 'По подразбиране',
      'stock_quantity': 'Количество на склад',
      'notification_threshold': 'Праг за уведомяване',
      'track_inventory': 'Проследяване на инвентара',
      'track_inventory_help':
          'Показване на поле за наличност на продукт и актуализиране при изпращане на Фактури',
      'stock_notifications': 'Известия за акции',
      'stock_notifications_help':
          'Изпратете имейл , когато акциите достигнат прага',
      'vat': 'ДДС',
      'standing': 'Отворен',
      'view_map': 'Прегледай Карта',
      'set_default_design': 'Задайте дизайн по подразбиране',
      'add_gateway': 'Добавете Вход за плащане',
      'add_gateway_help_message':
          'Добавете Вход за плащане (т.е. Stripe, WePay или PayPal ), до да приемете онлайн Плащания',
      'left': 'наляво',
      'right': 'вярно',
      'center': 'Център',
      'page_numbering': 'Номериране на страници',
      'page_numbering_alignment': 'Подравняване на номерирането на страници',
      'invoice_sent_notification_label': 'Фактура Изпратено',
      'show_product_description': 'Показване на описанието на продукта',
      'show_product_description_help':
          'Включете описанието в падащото меню на продукта',
      'invoice_items': 'Фактура Items',
      'quote_items': 'цитат Предмети',
      'profitloss': 'Печалби и загуби',
      'import_format': 'Формат за импортиране',
      'export_format': 'Формат за експортиране',
      'export_type': 'Тип експорт',
      'stop_on_unpaid': 'Спрете на неплатено',
      'stop_on_unpaid_help':
          'Спрете създаването на Периодична Фактури , ако последната Фактура не е платена.',
      'use_quote_terms': 'Използвайте цитат Условия',
      'use_quote_terms_help': 'При преобразуване на цитат до Фактура',
      'add_country': 'Добавете държава',
      'enable_tooltips': 'Активиране на подсказки',
      'enable_tooltips_help': 'Показване на подсказки при задържане на мишката',
      'multiple_client_error':
          'Грешка: записите принадлежат до повече от един клиент',
      'register_label': 'Създай сметка си за секунди',
      'login_label': 'Влезте до съществуваща сметка',
      'add_to_invoice': 'Добавяне към фактура :invoice',
      'no_invoices_found': 'Няма намерени Фактури',
      'week': 'Седмица',
      'created_record': 'Успешно Създадена запис',
      'auto_archive_paid_invoices': 'Автоматично Архивирай Платено',
      'auto_archive_paid_invoices_help':
          'Автоматично Архивирай Фактури , когато са платени.',
      'auto_archive_cancelled_invoices': 'Автоматичното Архивирай е отменено',
      'auto_archive_cancelled_invoices_help':
          'Автоматично Архивирай Фактури при отмяна.',
      'alternate_pdf_viewer': 'Алтернативен PDF Viewer',
      'alternate_pdf_viewer_help':
          'Подобрете превъртането върху визуализацията PDF [БЕТА]',
      'invoice_currency': 'Валута на фактурата',
      'range': 'Интервал',
      'tax_amount1': 'Данъчна Сума 1',
      'tax_amount2': 'Данък Сума 2',
      'tax_amount3': 'Данък Сума 3',
      'create_project': 'Създаване на проект',
      'update_project': 'Актуализиране на проекта',
      'view_task': 'Прегледай Задача',
      'cancel_invoice': 'анулиране',
      'changed_status': 'Успешно променен статус Задача',
      'change_status': 'Промяна на състоянието',
      'fees_sample': 'Таксата за фактура на стойност :amount ще бъде :total.',
      'enable_touch_events': 'Активиране на събития с докосване',
      'enable_touch_events_help':
          'Поддръжка на събития за плъзгане до превъртане',
      'after_saving': 'След запазване',
      'view_record': 'Прегледай Record',
      'enable_email_markdown': 'Активиране имейл Markdown',
      'enable_email_markdown_help':
          'Използвайте визуален редактор за маркиране за имейли',
      'enable_pdf_markdown': 'Активирайте PDF Markdown',
      'json_help':
          'Бележка : JSON файловете, генерирани от приложението v4, не се поддържат',
      'release_notes': 'Бележки по изданието',
      'upgrade_to_view_reports': 'Upgrade your plan до Прегледай reports',
      'started_tasks': 'Успешно започна :value Задачи',
      'stopped_tasks': 'Успешно спря :value Задачи',
      'approved_quote': 'Успешно одобрен цитат',
      'approved_quotes': 'Успешно :value Одобрена цитати',
      'approve': 'Одобрение',
      'client_website': 'Клиент Уеб сайт',
      'invalid_time': 'Невалиден час',
      'client_shipping_state': 'Клиент Състояние на доставка',
      'client_shipping_city': 'Клиент Доставка Град',
      'client_shipping_postal_code': 'Клиент Доставка Пощенски код',
      'client_shipping_country': 'Клиент Държава на доставка',
      'load_pdf': 'Заредете PDF',
      'start_free_trial': 'начало Безплатна пробна версия',
      'start_free_trial_message':
          'начало вашата БЕЗПЛАТНА 14-дневна пробна версия на Pro Plan',
      'due_on_receipt': 'дължимото при получаване',
      'is_paid': 'е платено',
      'age_group_paid': 'Платено',
      'id': 'Id',
      'convert_to': 'Преобразувайте до',
      'client_currency': 'Валута Клиент',
      'company_currency': 'Валута на компанията',
      'purged_client': 'Успешно изчистен клиент',
      'custom_emails_disabled_help':
          'до предотвратяване на спам изискваме надграждане до платена сметка до персонализиране на имейл',
      'upgrade_to_add_company': 'Надстройте своя план до Добавете компании',
      'small': 'малък',
      'marked_credit_as_paid': 'Успешно отбеляза кредита като платен',
      'marked_credits_as_paid': 'Успешно маркирани кредити като платени',
      'wait_for_loading': 'Зареждане на данни - моля изчакайте до завърши',
      'wait_for_saving': 'Запазване на данни - моля, изчакайте до завърши',
      'html_preview_warning':
          'Бележка : направените тук промени се визуализират само предварително, те трябва да бъдат приложени в разделите по-горе, до да бъдат запазени',
      'remaining': 'оставащи',
      'invoice_paid': 'Фактура Платено',
      'activity_120': ':user Създадена Периодична Разход :recurring_expense',
      'activity_121': ':user обновена Периодична Разход :recurring_expense',
      'activity_122': ':user архивиран Периодична Разход :recurring_expense',
      'activity_123': ':user изтрит Периодична Разход :recurring_expense',
      'activity_124': ':user възстановена Периодична Разход :recurring_expense',
      'normal': 'нормално',
      'large': 'Голям',
      'extra_large': 'Изключително голям',
      'show_pdf_preview': 'Показване PDF визуализация',
      'show_pdf_preview_help':
          'Показване на PDF визуализация, докато редактирате Фактури',
      'print_pdf': 'Отпечатайте PDF',
      'remind_me': 'Напомни ми',
      'instant_bank_pay': 'Незабавно Банка Pay',
      'click_selected': 'Щракнете върху Избрано',
      'hide_preview': 'Скриване на визуализация',
      'edit_record': 'Редактирай Record',
      'credit_is_more_than_invoice':
          'Кредитът Сума не може да бъде повече от Фактура Сума',
      'giropay': 'GiroPay',
      'direct_debit': 'Директен дебит',
      'please_set_a_password': 'Моля, задайте парола за сметка',
      'set_password': 'Задаване на парола',
      'disconnected_gateway': 'Успешно прекъснат вход',
      'disconnect': 'Прекъснете връзката',
      'add_to_invoices': 'Добавете до Фактури',
      'acss': 'ACSS дебит',
      'becs': 'BECS Директен дебит',
      'bulk_download': 'Изтегляне',
      'persist_data_help':
          'Запази данните локално до да активирате приложението до стартирате по-бързо, деактивирането може да подобри производителността в големи акаунти',
      'persist_ui': 'Устойчив потребителски интерфейс',
      'persist_ui_help':
          'Запази състоянието на потребителския интерфейс локално до да активирате приложението до да стартирате на последното място, деактивирането може да подобри производителността',
      'client_postal_code': 'Клиент Пощенски код',
      'client_vat_number': 'Номер по ДДС Клиент',
      'has_tasks': 'Има Задачи',
      'registration': 'Регистрация',
      'unauthorized_stripe_warning':
          'Моля, упълномощете Stripe до приемете онлайн Плащания .',
      'view_expense': 'Преглед на разход # :expense',
      'view_statement': 'Вижте извлечение',
      'sepa': 'SEPA Direct Debit',
      'ideal': 'ИДЕАЛЕН',
      'przelewy24': 'Przelewy24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'Актуализирайте всички записи',
      'system': 'Система',
      'set_default_company': 'Задайте фирма по подразбиране',
      'updated_company': 'Успешно обновена фирма',
      'kbc': 'KBC',
      'bancontact': 'Bancontact',
      'why_are_you_leaving':
          'Помогнете ни да се подобрим, като ни кажете защо (по избор)',
      'webhook_success': 'Webhook успех',
      'error_cross_client_tasks':
          'Всички Задачи трябва да принадлежат до един и същ клиент',
      'error_cross_client_expenses':
          'Всички разходи трябва да принадлежат до един и същ клиент',
      'app': 'Приложение',
      'for_best_performance':
          'За най-добра производителност изтеглете приложението :app',
      'gross_line_total': 'Gross Line Общо',
      'bulk_email_invoices': 'имейл Фактури',
      'bulk_email_quotes': 'имейл цитати',
      'bulk_email_credits': 'имейл кредити',
      'from_name': 'От - Име',
      'clone_to_expense': 'Копирай до Разход',
      'recurring_expense': 'Повтарящ се разход',
      'recurring_expenses': 'Повтарящи се разходи',
      'new_recurring_expense': 'Нов повтарящ се разход',
      'edit_recurring_expense': 'Редакция на повтарящ се разход',
      'created_recurring_expense': 'Успешно създаден повтарящ се разход',
      'updated_recurring_expense': 'Успешна актуализация на повтарящ се разход',
      'archived_recurring_expense': 'Успешно архивиран повтарящ се разход',
      'deleted_recurring_expense': 'Успешно изтрит Периодична Разход',
      'removed_recurring_expense': 'Успешно премахнато Периодична Разход',
      'restored_recurring_expense': 'Успешно възстановен повтарящ се разход',
      'search_recurring_expense': 'Търсене Периодична Разход',
      'search_recurring_expenses': 'Търсене Периодична разходи',
      'last_sent_date': 'Последна дата на изпращане',
      'include_drafts': 'Включете чернови',
      'include_drafts_help': 'Включете чернови на записи в отчетите',
      'is_invoiced': 'Фактурирана е',
      'change_plan': 'Управление на плана',
      'persist_data': 'Устойчиви данни',
      'customer_count': 'Брой клиенти',
      'verify_customers': 'Проверете клиентите',
      'google_analytics': 'Google Analytics',
      'google_analytics_tracking_id': 'ID за проследяване на Google Анализ',
      'decimal_comma': 'Десетична запетая',
      'use_comma_as_decimal_place':
          'Използвайте запетая като десетичен знак във формуляри',
      'select_method': 'Изберете Метод',
      'select_platform': 'Изберете Платформа',
      'use_web_app_to_connect_gmail':
          'Моля, използвайте уеб приложението до да се свържете до Gmail',
      'expense_tax_help': 'Данъчните ставки за артикули са деактивирани',
      'enable_markdown': 'Активирайте Markdown',
      'enable_markdown_help': 'Преобразувайте маркдаун до HTML на PDF',
      'user_guide': 'Ръководство за потребителя',
      'add_second_contact': 'Добавете Втори контакт',
      'previous_page': 'Предишна страница',
      'next_page': 'Следваща страница',
      'export_colors': 'Експортиране на цветове',
      'import_colors': 'Импортиране на цветове',
      'clear_all': 'Изчистване на всички',
      'contrast': 'Контраст',
      'custom_colors': 'персонализиран цветове',
      'colors': 'Цветове',
      'sidebar_active_background_color':
          'Активен фонов цвят на страничната лента',
      'sidebar_active_font_color':
          'Активен цвят на шрифта на страничната лента',
      'sidebar_inactive_background_color':
          'Неактивен фонов цвят на страничната лента',
      'sidebar_inactive_font_color':
          'Неактивен цвят на шрифта на страничната лента',
      'table_alternate_row_background_color':
          'Цвят на фона на алтернативния ред на таблицата',
      'invoice_header_background_color': 'Фактура Цвят на фона на заглавката',
      'invoice_header_font_color': 'Фактура Цвят на шрифта на заглавието',
      'net_subtotal': 'Нето',
      'review_app': 'Преглед на приложението',
      'check_status': 'Проверка на състоянието',
      'free_trial': 'Безплатна пробна версия',
      'free_trial_ends_in_days':
          'Пробната версия на плана Pro приключва след :count дни, щракнете до надграждане.',
      'free_trial_ends_today':
          'Днес е последният ден от пробната версия на плана Pro, кликнете до надграждане.',
      'change_email': 'Смени имейл',
      'client_portal_domain_hint':
          'По избор конфигурирайте отделен домейн на клиент портал',
      'tasks_shown_in_portal': 'Задачи Показани в портала',
      'uninvoiced': 'Нефактуриран',
      'subdomain_guide':
          'Поддомейнът се използва в клиент портал до персонализиране на връзките, до да съответстват на вашата марка. т.е. https://вашата-марка. фактуриране .co',
      'send_time': 'Време за изпращане',
      'import_data': 'Импорт на данни',
      'import_settings': 'Импортиране Настройки',
      'json_file_missing': 'Моля, предоставете JSON файла',
      'json_option_missing':
          'Моля, изберете до импортиране на Настройки и/или данните',
      'json': 'JSON',
      'no_payment_types_enabled': 'Няма активирани типове Плащане',
      'wait_for_data': 'Моля, изчакайте данните до завършат зареждането',
      'net_total': 'Нет Общо',
      'has_taxes': 'Има данъци',
      'import_customers': 'Импортиране на клиенти',
      'imported_customers': 'Успешно започна да внася клиенти',
      'login_success': 'Успешно влизане',
      'login_failure': 'Неуспешно влизане',
      'exported_data':
          'След като файлът е готов, ще получите имейл с връзка за изтегляне',
      'include_deleted_clients': 'Включете изтрит Клиенти',
      'include_deleted_clients_help':
          'Зареди записи, принадлежащи до изтрит Клиенти',
      'step_1_sign_in': 'Стъпка 1: Влезте',
      'step_2_authorize': 'Стъпка 2: Упълномощаване',
      'account_id': 'сметка ID',
      'migration_not_yet_completed': 'миграцията все още не е приключила',
      'activity_100': ':user Създадена Периодична Фактура :recurring_invoice',
      'activity_101': ':user обновена Периодична Фактура :recurring_invoice',
      'activity_102': ':user архивиран Периодична Фактура :recurring_invoice',
      'activity_103': ':user изтрит Периодична Фактура :recurring_invoice',
      'activity_104':
          ':user възстановена Периодична Фактура :recurring_invoice',
      'show_task_end_date': 'Показване на крайна дата Задача',
      'show_task_end_date_help':
          'Разрешете посочването на крайната дата Задача',
      'gateway_setup': 'вход Настройка',
      'preview_sidebar': 'Преглед на страничната лента',
      'years_data_shown': 'Показани са данни за годините',
      'ended_all_sessions': 'Успешно приключи всички сесии',
      'end_all_sessions': 'Край на всички сесии',
      'count_session': '1 сесия',
      'count_sessions': ':count Сесии',
      'invoice_created': 'Фактура Създадена',
      'quote_created': 'цитат Създадена',
      'credit_created': 'Кредит Създадена',
      'pro': 'Pro',
      'enterprise': 'Предприятие',
      'last_updated': 'Последно актуализиран',
      'invoice_item': 'Фактура Item',
      'quote_item': 'цитат Item',
      'contact_first_name': 'Контакт - Име',
      'contact_last_name': 'Контакт - Фамилия',
      'order': 'ред',
      'unassigned': 'Неприсвоена',
      'partial_value':
          'Трябва да бъде повече от 0 и по-малко от общата стойност.',
      'search_kanban': 'Търсете Kanban',
      'search_kanbans': 'Търсете Kanban',
      'kanban': 'Kanban',
      'enable': 'Разреши',
      'move_top': 'Преместване отгоре',
      'move_up': 'Преместване нагоре',
      'move_down': 'Преместване надолу',
      'move_bottom': 'Преместване на дъното',
      'subdomain_help':
          'Заложете subdomain или показвайте фактурите на собствения си сайт.',
      'body_variable_missing':
          'Грешка: персонализиран имейл трябва да включва променлива :body',
      'add_body_variable_message': 'Уверете се до включвате променлива :body',
      'view_date_formats': 'Прегледай формати за дата',
      'is_viewed': 'Преглежда се',
      'letter': 'Писмо',
      'legal': 'Законни',
      'page_layout': 'Оформление на страницата',
      'portrait': 'Портрет',
      'landscape': 'Пейзаж',
      'owner_upgrade_to_paid_plan':
          'Собственикът сметка може да надстрои до платен план до да активира разширените разширени Настройки',
      'upgrade_to_paid_plan':
          'Надстройте до платен план до да активирате разширените Настройки',
      'invoice_payment_terms': 'Фактура Плащане Условия',
      'quote_valid_until': 'цитат Валиден до',
      'no_headers': 'Без заглавки',
      'add_header': 'Добавете Header',
      'remove_header': 'Премахване на заглавката',
      'return_url': 'URL за връщане',
      'rest_method': 'Метод REST',
      'header_key': 'Ключ за заглавие',
      'header_value': 'Заглавна стойност',
      'recurring_products': 'Периодична Продукти',
      'promo_code': 'Промо код',
      'promo_discount': 'Промоционална отстъпка',
      'allow_cancellation': 'Разрешаване на анулиране',
      'per_seat_enabled': 'Активирано на място',
      'max_seats_limit': 'Максимален лимит за места',
      'trial_enabled': 'Пробният период е активиран',
      'trial_duration': 'Продължителност на пробния период',
      'allow_query_overrides': 'Разрешаване на заместване на заявки',
      'allow_plan_changes': 'Разрешаване на промени в плана',
      'plan_map': 'Карта на плана',
      'refund_period': 'Период на възстановяване',
      'webhook_configuration': 'Конфигурация на Webhook',
      'purchase_page': 'Страница за покупка',
      'security': 'Сигурност',
      'email_bounced': 'имейл отхвърлен',
      'email_spam_complaint': 'Жалба за спам',
      'email_delivery': 'имейл Доставка',
      'webhook_response': 'Отговор на Webhook',
      'pdf_response': 'PDF отговор',
      'authentication_failure': 'Неуспешно удостоверяване',
      'pdf_failed': 'PDF неуспешен',
      'pdf_success': 'PDF успех',
      'modified': 'Променен',
      'payment_link': 'Плащане Link',
      'new_payment_link': 'Нова връзка Плащане',
      'edit_payment_link': 'Редактирай Плащане Link',
      'created_payment_link': 'Успешно Създадена Плащане link',
      'updated_payment_link': 'Успешно обновена Плащане link',
      'archived_payment_link': 'Успешно архивиран Плащане link',
      'deleted_payment_link': 'Успешно изтрит Плащане link',
      'removed_payment_link': 'Успешно премахната връзката Плащане',
      'restored_payment_link': 'Успешно възстановена Плащане link',
      'search_payment_link': 'Търсене 1 Плащане Link',
      'search_payment_links': 'Търсене :count Плащане Links',
      'subdomain_is_not_available': 'Поддомейнът не е наличен',
      'connect_gmail': 'Свържете Gmail',
      'disconnect_gmail': 'Прекъснете връзката с Gmail',
      'connected_gmail': 'Успешно свързан Gmail',
      'disconnected_gmail': 'Успешно прекъсна връзката с Gmail',
      'update_fail_help':
          'Промените до кодовата база може да блокират актуализацията, можете да изпълните тази команда до да отхвърлите промените:',
      'client_id_number': 'ID номер Клиент',
      'count_minutes': ':count Минути',
      'password_timeout': 'Време за изчакване на паролата',
      'shared_invoice_credit_counter': 'Сподели Фактура /Credit Counter',
      'use_last_email': 'Използвайте последния имейл',
      'activate_company': 'Активирайте фирма',
      'activate_company_help':
          'Разрешете имейли, Периодична Фактури и известия',
      'an_error_occurred_try_again': 'Възникна грешка, моля опитайте отново',
      'please_first_set_a_password': 'Моля, първо задайте парола',
      'changing_phone_disables_two_factor':
          'Предупреждение: Промяната на вашия Телефон номер ще деактивира 2FA',
      'help_translate': 'Помощ за превод',
      'please_select_a_country': 'Моля, изберете държава',
      'resend_invite': 'Повторно изпращане на покана',
      'disabled_two_factor': 'Успешно деактивиран 2FA',
      'connected_google': 'Успешно свързана сметка',
      'disconnected_google': 'Успешно прекъсната сметка',
      'delivered': 'Доставено',
      'bounced': 'Върнати',
      'spam': 'Спам',
      'view_docs': 'Прегледай Docs',
      'enter_phone_to_enable_two_factor':
          'Моля, предоставете номер на мобилен Телефон до да разрешите двуфакторно удостоверяване',
      'send_sms': 'Изпратете SMS',
      'sms_code': 'SMS код',
      'two_factor_setup_help':
          'Сканирайте баркода с :link съвместимо приложение.',
      'enabled_two_factor': 'Успешно активирана Two-Factor Authentication',
      'connect_google': 'Свържете Google',
      'disconnect_google': 'Прекъснете връзката с Google',
      'enable_two_factor': 'Two-Factor Authentication',
      'disable_two_factor': 'Деактивирайте два фактора',
      'require_password_with_social_login':
          'Изискване на парола със социално влизане',
      'stay_logged_in': 'Останете в системата',
      'session_about_to_expire':
          'Предупреждение: Вашата сесия е на път до изтече',
      'count_hours': ':count Часове',
      'count_day': '1 ден',
      'count_days': ':count Дни',
      'web_session_timeout': 'Изчакване на уеб сесията',
      'security_settings': 'Настройки за сигурност',
      'resend_email': 'Повторно изпращане имейл',
      'confirm_your_email_address': 'Моля, потвърдете имейл адреса си',
      'refunded_payment': 'Възстановено плащане',
      'partially_unapplied': 'Частично неприложен',
      'select_a_gmail_user': 'Моля, изберете Потребител , удостоверен с Gmail',
      'list_long_press': 'Продължително натискане на списък',
      'show_actions': 'Показване на действия',
      'start_multiselect': 'начало Multiselect',
      'email_sent_to_confirm_email':
          'Изпратен е имейл до потвърждение на имейл адреса',
      'counter_pattern_error':
          'до използвайте :client _counter моля Добавете или :client _number или :client _id_number до предотвратяване на конфликти',
      'this_quarter': 'Това тримесечие',
      'last_quarter': 'Предишно тримесечие',
      'to_update_run': 'до актуализиране',
      'convert_to_invoice': 'Конвертирай като Фактура',
      'registration_url': 'URL за регистрация',
      'invoice_project': 'Фактуриране на проект',
      'invoice_task': 'Фактуриране на задача',
      'invoice_expense': 'Префактуриране на разход',
      'search_payment_term': 'Търсене 1 Условия за плащане',
      'search_payment_terms': 'Търсене :count Плащане Условия',
      'save_and_preview': 'Запази и прегледай',
      'save_and_email': 'Запази и изпрати имейл',
      'supported_events': 'Поддържани събития',
      'converted_amount': 'Конвертирана сума',
      'converted_balance': 'Преобразуван баланс',
      'converted_paid_to_date': 'Преобразувано платено до дата',
      'converted_credit_balance': 'Преобразуван кредитен баланс',
      'converted_total': 'Преобразувано Общо',
      'is_sent': 'Изпратено е',
      'default_documents': 'Документи по подразбиране',
      'document_upload': 'Качване на документ',
      'document_upload_help': 'Разрешете Клиенти до качване на документи',
      'expense_total': 'Разход Общо',
      'enter_taxes': 'Въведи Данъци',
      'by_rate': 'По тарифа',
      'by_amount': 'От Сума',
      'enter_amount': 'Въведи Сума',
      'before_taxes': 'Преди данъци',
      'after_taxes': 'След данъци',
      'color': 'Цвят',
      'show': 'Покажи',
      'hide': 'Скрий',
      'empty_columns': 'Празни колони',
      'debug_mode_is_enabled': 'Режимът за отстраняване на грешки е активиран',
      'debug_mode_is_enabled_help':
          'Предупреждение: предназначено е за използване на локални машини, може да изтече идентификационна информация. Кликнете, до да научите повече.',
      'running_tasks': 'Бягащи Задачи',
      'recent_tasks': 'Последни Задачи',
      'recent_expenses': 'Скорошни разходи',
      'upcoming_expenses': 'Предстоящи разходи',
      'update_app': 'Обнови приложението',
      'started_import': 'Успешно започна импортирането',
      'duplicate_column_mapping': 'Дублиране на съпоставяне на колони',
      'uses_inclusive_taxes': 'Използва включени данъци',
      'is_amount_discount': 'Е Сума Отстъпка',
      'column': 'Колона',
      'sample': 'Пример',
      'map_to': 'Карта до',
      'import': 'Импорт',
      'first_row_as_column_names':
          'Използвайте първия ред като имена на колони',
      'select_file': 'Моля изберете файл',
      'no_file_selected': 'Няма избран файл',
      'csv_file': 'CSV файл',
      'csv': 'CSV',
      'freshbooks': 'FreshBooks',
      'invoice2go': 'Invoice2go',
      'invoicely': 'Фактуриране',
      'waveaccounting': 'Вълново счетоводство',
      'zoho': 'Зохо',
      'accounting': 'Счетоводство',
      'required_files_missing': 'Моля, предоставете всички CSV файлове.',
      'import_type': 'Тип импортиране',
      'html_mode': 'HTML режим',
      'html_mode_help':
          'Предварителният преглед се актуализира по-бързо, но е по-малко точен',
      'view_licenses': 'Виж лицензи',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': 'Редактор на цял екран',
      'sidebar_editor': 'Редактор на страничната лента',
      'please_type_to_confirm': 'За да потвърдите, моля напишете \':value\'',
      'purge': 'Изчистете',
      'service': 'Услуга',
      'clone_to': 'Клонирай към',
      'clone_to_other': 'Клонирай към нещо друго',
      'labels': 'Етикети',
      'add_custom': 'Добави персонализирано',
      'payment_tax': 'Данък върху плащанията',
      'unpaid': 'Неплатена',
      'white_label': 'White Label',
      'delivery_note': 'Документ за доставка',
      'sent_invoices_are_locked': 'Изпратените фактури са заключени',
      'paid_invoices_are_locked': 'Платените фактури са заключени',
      'source_code': 'Изходен код',
      'app_platforms': 'Платформи за приложения',
      'invoice_late': 'Закъсняла Фактура',
      'quote_expired': 'Изтекла Оферта',
      'partial_due': 'Частично дължима',
      'invoice_total': 'Тотал на фактура',
      'quote_total': 'Обща стойност на офертата',
      'credit_total': 'Общ кредит',
      'recurring_invoice_total': 'Общо по фактурата',
      'actions': 'Действия',
      'expense_number': 'Номер на разхода',
      'task_number': 'Номер на задачата',
      'project_number': 'Номер на проекта',
      'project_name': 'Име на проекта',
      'warning': 'Внимание',
      'view_settings': 'Виж настройки',
      'company_disabled_warning': 'Внимание: компанията не е активирана',
      'late_invoice': 'Късна фактура',
      'expired_quote': 'Изтекла оферта',
      'remind_invoice': 'Напомняне за фактура',
      'cvv': 'CVV',
      'client_name': 'Име на клиент',
      'client_phone': 'Телефон на клиент',
      'required_fields': 'Задължителни полета',
      'calculated_rate': 'Изчислен рейт',
      'default_task_rate': 'Рейт по подразбиране за задача',
      'clear_cache': 'Изчисти кеша',
      'sort_order': 'Подредба',
      'task_status': 'Статус',
      'task_statuses': 'Статуси на задачата',
      'new_task_status': 'Статус на нова задача',
      'edit_task_status': 'Смени статуса на задачата',
      'created_task_status': 'Статус на задача е създаден успешно',
      'updated_task_status': 'Успешно променен статус на задача',
      'archived_task_status': 'Статус на задача е архивиран успешно',
      'deleted_task_status': 'Статус на задача е изтрит успешно',
      'removed_task_status': 'Статус на задача е премахнат успешно',
      'restored_task_status': 'Статус на задача е възстановен успешно',
      'archived_task_statuses': 'Успешно архивирахте :value статуси на задачи',
      'deleted_task_statuses': 'Успешно изтрихте :value статуси на задачи',
      'restored_task_statuses':
          'Успешно възстановихте :value статуси на задачи',
      'search_task_status': 'Търси 1 статус на задача',
      'search_task_statuses': 'Търси :count статуси на задачи',
      'show_tasks_table': 'Покажи таблица със задачи',
      'show_tasks_table_help':
          'Винаги показвайте секцията със задачи, когато създавате фактури',
      'invoice_task_timelog': 'График на задачите за фактура',
      'invoice_task_timelog_help':
          'Добавете подробности за времето към редовете на фактурата',
      'invoice_task_datelog': 'Фактура Задача Datelog',
      'invoice_task_datelog_help': 'Добавете дата детайли до позициите Фактура',
      'auto_start_tasks_help': 'Стартирайте задачите преди запазване',
      'configure_statuses': 'Конфигуриране на състояния',
      'task_settings': 'Настройки на задача',
      'configure_categories': 'Конфигуриране на категории',
      'expense_categories': 'Категории разходи',
      'new_expense_category': 'Нова категория разходи',
      'edit_expense_category': 'Редактиране на категорията на разхода',
      'created_expense_category': 'Успешно създаване на категория разходи',
      'updated_expense_category': 'Успешна актуализация на категория разходи',
      'archived_expense_category': 'Успешно архивиране на категория разходи',
      'deleted_expense_category': 'Успешно изтрита категория',
      'removed_expense_category':
          'Категорията на разходите е премахната успешно',
      'restored_expense_category':
          'Успешно възстановяване на категория разходи',
      'archived_expense_categories':
          'Успешно архивирани :count категории разходи',
      'deleted_expense_categories': 'Успешно изтрит разход :value категории',
      'restored_expense_categories':
          'Успешно възстановени разходи :value стойности',
      'search_expense_category': 'Търсете в 1 категория разходи',
      'search_expense_categories': 'Търсене в :count категории на разходите',
      'use_available_credits': 'Използвайте наличните кредити',
      'show_option': 'Покажи опция',
      'negative_payment_error':
          'Сумата на кредита не може да надвишава сумата на плащане',
      'view_changes': 'Виж промените',
      'force_update': 'Актуализирай насила',
      'force_update_help':
          'Използвате най-новата версия, но е възможно да има налични поправки.',
      'mark_paid_help': 'Проследете, че разходът е бил платен',
      'should_be_invoiced': 'Трябва да се префактурира',
      'should_be_invoiced_help': 'Разрешете фактурирането на разходите',
      'add_documents_to_invoice_help':
          'Направете документите видими за клиента',
      'convert_currency_help': 'Задай обменен курс',
      'expense_settings': 'Настройки на разход',
      'clone_to_recurring': 'Клонирай към периодичен',
      'crypto': 'Крипто',
      'paypal': 'PayPal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple/Google Pay',
      'user_field': 'Потребителско поле',
      'variables': 'Променливи',
      'show_password': 'Покажи парола',
      'hide_password': 'Скрий парола',
      'copy_error': 'Грешка при копиране',
      'capture_card': 'Прихвани карта',
      'auto_bill_enabled': 'Автоматично плащане включено',
      'total_taxes': 'Общо данъци',
      'line_taxes': 'Данъци на редовете',
      'total_fields': 'Сумарни полета',
      'stopped_recurring_invoice': 'Успешно спиране на периодична фактура',
      'started_recurring_invoice': 'Успешно стартиране на периодична фактура',
      'resumed_recurring_invoice':
          'Успешно възобновяване на периодична фактура',
      'gateway_refund': 'Портал за връщане',
      'gateway_refund_help': 'Върни сума чрез платежния портал',
      'due_date_days': 'Краен срок',
      'paused': 'На пауза',
      'mark_active': 'Маркирай в архив',
      'day_count': 'Ден :count',
      'first_day_of_the_month': 'Първи ден от месеца',
      'last_day_of_the_month': 'Последен ден на месеца',
      'use_payment_terms': 'Използвай условия за плащане',
      'endless': 'Безкрайни',
      'next_send_date': 'Дата на следващото изпращане',
      'remaining_cycles': 'Оставащи периоди',
      'recurring_invoice': 'Периодична фактура',
      'recurring_invoices': 'Периодични фактури',
      'new_recurring_invoice': 'Нова периодична фактура',
      'edit_recurring_invoice': 'Редакция на периодична фактура',
      'created_recurring_invoice': 'Успешно създадена периодична фактура',
      'updated_recurring_invoice': 'Успешно обновена периодична фактура',
      'archived_recurring_invoice': 'Успешно архивиране на периодична фактура',
      'deleted_recurring_invoice': 'Успешно изтриване на периодична фактура',
      'removed_recurring_invoice': 'Успешно премахната периодична фактура',
      'restored_recurring_invoice':
          'Успешно възстановяване на периодична фактура',
      'archived_recurring_invoices':
          'Успешно архивирани повтарящи се :value фактури',
      'deleted_recurring_invoices':
          'Успешно изтрити повтарящи се :value фактури',
      'restored_recurring_invoices':
          'Успешно възстановени повтарящи се :value фактури',
      'search_recurring_invoice': 'Търси 1 периодична фактура',
      'search_recurring_invoices': 'Търси :count периодични фактури',
      'send_date': 'Дата на изпращане',
      'auto_bill_on': 'Автоматично плащане на',
      'minimum_under_payment_amount': 'Минимална сума за авансово плащане',
      'profit': 'Печалба',
      'line_item': 'Ред',
      'allow_over_payment': 'Разрешете надплащане',
      'allow_over_payment_help':
          'Поддържай плащане над основна сума за да приемаш бакшиши',
      'allow_under_payment': 'Позволете подплащане',
      'allow_under_payment_help':
          'Поддръжка на плащане на минимална частична/депозитна сума',
      'test_mode': 'Тестов решим',
      'opened': 'Отворени',
      'payment_reconciliation_failure': 'Неуспешно съгласуване',
      'payment_reconciliation_success': 'Успешно съгласуване',
      'gateway_success': 'Портал - успешно',
      'gateway_failure': 'Портал - неуспешно',
      'gateway_error': 'Портал - грешка',
      'email_send': 'Изпрати имейл',
      'email_retry_queue': 'Опашка за повторни опити на имейли',
      'failure': 'Неуспешно',
      'quota_exceeded': 'Превишена квота',
      'upstream_failure': 'Грешка нагоре по веригата',
      'system_logs': 'Системни логове',
      'view_portal': 'Преглед на портала',
      'copy_link': 'Копирай линк',
      'token_billing': 'Запазване на данните на картата',
      'welcome_to_invoice_ninja': 'Добре дошли в Инвойс Нинджа',
      'always': 'Винаги',
      'optin': 'Запишете се',
      'optout': 'Отпишете се',
      'label': 'Етикет',
      'client_number': 'Клиентски номер',
      'auto_convert': 'Автомативно конвертиране',
      'company_name': 'Име на фирма',
      'reminder1_sent': 'Първо напомняне изпратено',
      'reminder2_sent': 'Второ напомняне изпратено',
      'reminder3_sent': 'Трето напомняне изпратено',
      'reminder_last_sent': 'Последно изпратено напомняне',
      'pdf_page_info': 'Страница :current от :total',
      'emailed_invoices': 'Успешно изпратени фактури',
      'emailed_quotes': 'Успешно изпратени оферти',
      'emailed_credits': 'Успешно изпратен имейл за кредити',
      'gateway': 'Портал',
      'view_in_stripe': 'Виж в Страйп',
      'rows_per_page': 'Редове на страница',
      'hours': 'Часове',
      'statement': 'Извлечение',
      'taxes': 'Данъци',
      'surcharge': 'Доплащане',
      'apply_payment': 'Приложи плащане',
      'apply_credit': 'Прилагане на кредит',
      'apply': 'Приложи',
      'unapplied': 'Неприложени',
      'select_label': 'Избор на етикет',
      'custom_labels': 'Персонализирани етикети',
      'record_type': 'Тип запис',
      'record_name': 'Име на запис',
      'file_type': 'Файлов тип',
      'height': 'Височина',
      'width': 'Широчина',
      'to': 'До',
      'health_check': 'Проверка на състояние',
      'payment_type_id': 'Начин на плащане',
      'last_login_at': 'Последен логин в',
      'company_key': 'Ключ на компанията',
      'storefront': 'Режим на магазин',
      'storefront_help':
          'Разрешаване на приложения на трети страни да създават фактури',
      'client_created': 'Създаден клиент',
      'online_payment_email': 'Имейл за онлайн плащане',
      'manual_payment_email': 'Имейл за ръчно плащане',
      'completed': 'Завършен',
      'gross': 'Бруто',
      'net_amount': 'Нетна сума',
      'net_balance': 'Нетен баланс',
      'client_settings': 'Настройки на клиент',
      'selected_invoices': 'Маркирани фактури',
      'selected_payments': 'Маркирани плащания',
      'selected_quotes': 'Маркирани оферти',
      'selected_tasks': 'Маркирани задачи',
      'selected_expenses': 'Маркирани разходи',
      'upcoming_invoices': 'Предстоящи фактури',
      'past_due_invoices': 'Просрочени фактури',
      'recent_payments': 'Последни плащания',
      'upcoming_quotes': 'Предстоящи оферти',
      'expired_quotes': 'Изтекли оферти',
      'create_client': 'Създаване на клиент',
      'create_invoice': 'Създай фактура',
      'create_quote': 'Създай Оферта',
      'create_payment': 'Създай плащане',
      'create_vendor': 'Създаване на доставчик',
      'update_quote': 'Обнови оферта',
      'delete_quote': 'Изтрий Оферта',
      'update_invoice': 'Обнови фактура',
      'delete_invoice': 'Изтриване на фактура',
      'update_client': 'Обнови клиент',
      'delete_client': 'Изтрий клиент',
      'delete_payment': 'Изтрий плащане',
      'update_vendor': 'Обнови доставчик',
      'delete_vendor': 'Изтриване на доставчик',
      'create_expense': 'Създай разход',
      'update_expense': 'Обнови разход',
      'delete_expense': 'Изтриване на разход',
      'create_task': 'Нова задача',
      'update_task': 'Обнови задача',
      'delete_task': 'Изтриване на задача',
      'approve_quote': 'Одобри оферта',
      'off': 'Изкл.',
      'when_paid': 'Когато е платена',
      'expires_on': 'Изтича на',
      'free': 'Безплатно',
      'plan': 'План',
      'show_sidebar': 'Покажи странично меню',
      'hide_sidebar': 'Скрий страничното меню',
      'event_type': 'Тип събитие',
      'target_url': 'Target',
      'copy': 'Копирай',
      'must_be_online':
          'Моля, рестартирайте приложението, когато се свържете към Интернет',
      'crons_not_enabled': 'Cron задачите трябва да са включени',
      'api_webhooks': 'API webhooks',
      'search_webhooks': 'Търси :count webhook-ове',
      'search_webhook': 'Търси 1 webhook',
      'webhook': 'Webhook',
      'webhooks': 'Webhook-ове',
      'new_webhook': 'Нов Webhook',
      'edit_webhook': 'Промени Webhook',
      'created_webhook': 'Успешно създаден webhook',
      'updated_webhook': 'Успешно обновен webhook',
      'archived_webhook': 'Успешно архивиран webhook',
      'deleted_webhook': 'Успешно изтрит webhook',
      'removed_webhook': 'Успешно премахнат webhook',
      'restored_webhook': 'Успешно възстановен webhook',
      'archived_webhooks': 'Успешно архивиран :value webhooks',
      'deleted_webhooks': 'Успешно изтрит :value webhooks',
      'removed_webhooks': 'Успешно премахна :value webhooks',
      'restored_webhooks': 'Успешно възстановена :value webhooks',
      'api_tokens': 'API токъни',
      'api_docs': 'API документация',
      'search_tokens': 'Търси :count токени',
      'search_token': 'Търси 1 токен',
      'token': 'Токън',
      'tokens': 'Токъни',
      'new_token': 'Нов токен',
      'edit_token': 'Редакция на токън',
      'created_token': 'Успешно създаден токън',
      'updated_token': 'Успешно актуализиран токън',
      'archived_token': 'Успешно архивиран токен',
      'deleted_token': 'Успешно изтрит токън',
      'removed_token': 'Успешно премахнат токен',
      'restored_token': 'Успешно възстановен токен',
      'archived_tokens': 'Успешно архивиран :value токени',
      'deleted_tokens': 'Успешно изтрит :value токени',
      'restored_tokens': 'Успешно възстановена :value tokens',
      'client_registration': 'Регистрация на клиент',
      'client_registration_help':
          'Разреши на клиентите да правят собствени регистрации в портала',
      'email_invoice': 'Изпращане на фактура',
      'email_quote': 'Изпрати оферта по имейл',
      'email_credit': 'Изпрати имейл за кредит',
      'email_payment': 'Имейл за плащане',
      'client_email_not_set': 'Клиентът няма зададен имейл адрес',
      'ledger': 'Леджър',
      'view_pdf': 'Виж PDF',
      'all_records': 'Всички записи',
      'owned_by_user': 'Притежавани от потребителя',
      'credit_remaining': 'Остатъчен кредит',
      'contact_name': 'Контакт - име',
      'use_default': 'Използвай по подразбиране',
      'reminder_endless': 'Безкрайни напомняния',
      'number_of_days': 'Брой дни',
      'configure_payment_terms': 'Настрой условия за плащане',
      'payment_term': 'Условие за плащане',
      'new_payment_term': 'Ново условие за плащане',
      'edit_payment_term': 'Редакция на условие за плащане',
      'created_payment_term': 'Успешно създадено условие на плащане',
      'updated_payment_term': 'Успешно актуализирано условие на плащане',
      'archived_payment_term': 'Успешно архивирано условие на плащане',
      'deleted_payment_term': 'Успешно изтрито условие за плащане',
      'removed_payment_term': 'Успешно премахнато условие за плащане',
      'restored_payment_term': 'Успешно възстановено условие за плащане',
      'archived_payment_terms': 'Успешно архивиран :value Плащане Условия',
      'deleted_payment_terms': 'Успешно изтрит :value Плащане Условия',
      'restored_payment_terms': 'Успешно възстановена :value Плащане Условия',
      'email_sign_in': 'Влез с имейл',
      'change': 'Промени',
      'change_to_mobile_layout': 'Смени на мобилен режим?',
      'change_to_desktop_layout': 'Смени на десктоп режим?',
      'send_from_gmail': 'Изпрати от Gmail',
      'reversed': 'Сторнирана',
      'cancelled': 'Анулирана',
      'credit_amount': 'Сума на кредита',
      'quote_amount': 'Сума на оферта',
      'hosted': 'Хостнат',
      'selfhosted': 'Самостоятелно хостнат',
      'exclusive': 'Изключени',
      'inclusive': 'Включени',
      'hide_menu': 'Скрий менюто',
      'show_menu': 'Покажи меню',
      'partially_refunded': 'Частично възстановено',
      'search_documents': 'Търси документи',
      'search_designs': 'Търси дизайни',
      'search_invoices': 'Търси фактури',
      'search_clients': 'Търси клиенти',
      'search_products': 'Търси продукти',
      'search_quotes': 'Търси оферти',
      'search_credits': 'Търси кредити',
      'search_vendors': 'Търси доставчици',
      'search_users': 'Търси потребители',
      'search_tax_rates': 'Търси данъчни ставки',
      'search_tasks': 'Търси задачи',
      'search_settings': 'Търси настройки',
      'search_projects': 'Търси проекти',
      'search_expenses': 'Търси разходи',
      'search_payments': 'Търси плащания',
      'search_groups': 'Търси групи',
      'search_company': 'Търси в компания',
      'search_document': 'Търси 1 документ',
      'search_design': 'Търси 1 дизайн',
      'search_invoice': 'Търси 1 фактура',
      'search_client': 'Търси 1 клиент',
      'search_product': 'Търси 1 продукт',
      'search_quote': 'Търси 1 оферта',
      'search_credit': 'Търси 1 кредит',
      'search_vendor': 'Търси 1 доставчик',
      'search_user': 'Търси 1 потребител',
      'search_tax_rate': 'Търси 1 данъчна ставка',
      'search_task': 'Търси 1 задача',
      'search_project': 'Търси 1 проект',
      'search_expense': 'Търси 1 разход',
      'search_payment': 'Търси 1 плащане',
      'search_group': 'Търси 1 група',
      'refund_payment': 'Възстановяване на плащане',
      'cancelled_invoice': 'Успешно анулирана фактура',
      'cancelled_invoices': 'Успешно анулирани фактури',
      'reversed_invoice': 'Успешно сторнирана фактура',
      'reversed_invoices': 'Успешно сторнирани фактури',
      'reverse': 'Сторнирай',
      'full_name': 'Пълно име',
      'city_state_postal': 'Град / Щат / Пощ. код',
      'postal_city_state': 'Пощ. код / Щат / Град',
      'custom1': 'Първа колона',
      'custom2': 'Втора колона',
      'custom3': 'Трето персонализиране',
      'custom4': 'Четвърто персонализиране',
      'optional': 'По избор',
      'license': 'Лиценз',
      'purge_data': 'Изчистване на данни',
      'purge_successful': 'Успешно изчистени фирмени данни',
      'purge_data_message':
          'Внимание: Това ще изтрие данните перманентно без възможност за възстановяване.',
      'invoice_balance': 'Баланс на фактурата',
      'age_group_0': '0 - 30 дни',
      'age_group_30': '30 - 60 дни',
      'age_group_60': '60 - 90 дни',
      'age_group_90': '90 - 120 дни',
      'age_group_120': '120+ дни',
      'refresh': 'Опресняване',
      'saved_design': 'Успешно запазен дизайн',
      'client_details': 'Данни на клиента',
      'company_address': 'Адрес на компанията',
      'invoice_details': 'Детайли на фактурата',
      'quote_details': 'Данни на офертата',
      'credit_details': 'Данни на кредита',
      'product_columns': 'Продуктови колони',
      'task_columns': 'Колони на задача',
      'add_field': 'Добави поле',
      'all_events': 'Всички събития',
      'permissions': 'Права за достъп',
      'none': 'Няма',
      'owned': 'Собствен',
      'payment_success': 'Успешно плащане',
      'payment_failure': 'Неуспешно плащане',
      'invoice_sent': ':count изпратена фактура',
      'quote_sent': 'Изпратена оферта',
      'credit_sent': 'Изпратен кредит',
      'invoice_viewed': 'Прегледана фактура',
      'quote_viewed': 'Прегледана оферта',
      'credit_viewed': 'Прегледан кредит',
      'quote_approved': 'Одобрена оферта',
      'receive_all_notifications': 'Получавай всички известия',
      'purchase_license': 'Купи лиценз',
      'apply_license': 'Въведете лиценз',
      'cancel_account': 'Изтрий Профил',
      'cancel_account_message':
          'ВНИМАНИЕ: Това действие ще изтрие перманентно вашият профил и данните в него. След това данните няма как да бъдат възстановени.',
      'delete_company': 'Изтриване на фирма',
      'delete_company_message':
          'Внимание: Това ще изтрие перманентно фирматаВи без възможност за възстановяване.',
      'enabled_modules': 'Включени модули',
      'converted_quote': 'Успешно конвертирана оферта',
      'credit_design': 'Дизайн на кредит',
      'includes': 'Съдържа',
      'header': 'Хедър',
      'load_design': 'Зареждане на дизайн',
      'css_framework': 'CSS framework',
      'custom_designs': 'Персонализирани дизайни',
      'designs': 'Дизайни',
      'new_design': 'Нов дизайн',
      'edit_design': 'Редактирай дизайн',
      'created_design': 'Успешно създаден дизайн',
      'updated_design': 'Успешно обновен дизайн',
      'archived_design': 'Успешно архивиран дизайн',
      'deleted_design': 'Успешно изтрит дизайн',
      'removed_design': 'Успешно премахнат дизайн',
      'restored_design': 'Успешно възстановен дизайн',
      'archived_designs': 'Успешно архивиран :value дизайни',
      'deleted_designs': 'Успешно изтрит :value designs',
      'restored_designs': 'Успешно възстановена :value designs',
      'proposals': 'Предложения',
      'tickets': 'Билети',
      'recurring_quotes': 'Периодични Оферти',
      'recurring_tasks': 'Периодични задачи',
      'account_management': 'Управление на акаунтите',
      'credit_date': 'Кредитна Дата',
      'credit': 'Кредит',
      'credits': 'Кредити',
      'new_credit': 'Въведи кредит',
      'edit_credit': 'Редакция на кредит',
      'created_credit': 'Успешно създаден кредит',
      'updated_credit': 'Успешна актуализация на кредит',
      'archived_credit': 'Успешно архивиран кредит',
      'deleted_credit': 'Успешно изтрит кредит',
      'removed_credit': 'Успешно премахнат кредит',
      'restored_credit': 'Успешно възстановен кредит',
      'archived_credits': 'Успешно архивирани :count кредита',
      'deleted_credits': 'Успешно изтрити :count кредита',
      'restored_credits': 'Успешно възстановена :value кредити',
      'current_version': 'Текуща версия',
      'latest_version': 'Последна версия',
      'update_now': 'Ъпдейтни',
      'a_new_version_is_available': 'Налична е нова версия на уеб приложението',
      'update_available': 'Има ъпдейт',
      'app_updated': 'Ъпдейтът приключи успешно',
      'learn_more': 'Научи повече',
      'integrations': 'Интеграции',
      'tracking_id': 'ID за проследяване',
      'slack_webhook_url': 'Slack webhook URL',
      'credit_footer': 'Футър на кредит',
      'credit_terms': 'Условия на кредит',
      'new_company': 'Нова фирма',
      'added_company': 'Успешно добавена компания',
      'company1': 'Персонализирана Компания 1',
      'company2': 'Персонализирана Компания 2',
      'company3': 'Персонализирана Компания 3',
      'company4': 'Персонализирана Компания 4',
      'product1': 'Персонализиран Продукт 1',
      'product2': 'Персонализиран Продукт 2',
      'product3': 'Персонализиран Продукт 3',
      'product4': 'Персонализиран Продукт 4',
      'client1': 'Персонализиран клиент 1',
      'client2': 'Персонализиран клиент 2',
      'client3': 'Персонализиран клиент 3',
      'client4': 'Персонализиран клиент 4',
      'contact1': 'Персонализиран контакт 1',
      'contact2': 'Персонализиран контакт 2',
      'contact3': 'Персонализиран контакт 3',
      'contact4': 'Персонализиран контакт 4',
      'task1': 'Персонализирана задача 1',
      'task2': 'Персонализирана задача 2',
      'task3': 'Персонализирана задача 3',
      'task4': 'Персонализирана задача 4',
      'project1': 'Персонализиран проект 1',
      'project2': 'Персонализиран проект 2',
      'project3': 'Персонализиран проект 3',
      'project4': 'Персонализиран проект 4',
      'expense1': 'Персонализиран разход 1',
      'expense2': 'Персонализиран разход 2',
      'expense3': 'Персонализиран разход 3',
      'expense4': 'Персонализиран разход 4',
      'vendor1': 'Персонализиран доставчик 1',
      'vendor2': 'Персонализиран доставчик 2',
      'vendor3': 'Персонализиран доставчик 3',
      'vendor4': 'Персонализиран доставчик 4',
      'invoice1': 'Персонализирана фактура 1',
      'invoice2': 'Персонализирана фактура 2',
      'invoice3': 'Персонализирана фактура 3',
      'invoice4': 'Персонализирана фактура 4',
      'payment1': 'Персонализирано плащане 1',
      'payment2': 'Персонализирано плащане 2',
      'payment3': 'Персонализирано плащане 3',
      'payment4': 'Персонализирано плащане 4',
      'surcharge1': 'Персонализирано доплащане 1',
      'surcharge2': 'Персонализирано доплащане 2',
      'surcharge3': 'Персонализирано доплащане 3',
      'surcharge4': 'Персонализирано доплащане 4',
      'group1': 'Персонализирана група 1',
      'group2': 'Персонализирана група 2',
      'group3': 'Персонализирана група 3',
      'group4': 'Персонализирана група 4',
      'reset': 'Нулиране',
      'number': 'Номер',
      'export': 'Експорт',
      'chart': 'Графика',
      'count': 'Брой',
      'totals': 'Общи суми',
      'blank': 'Празно',
      'day': 'Ден',
      'month': 'Месец',
      'year': 'Година',
      'subgroup': 'Подгрупа',
      'is_active': 'Е активен',
      'group_by': 'Групиране по',
      'credit_balance': 'Баланс на кредита',
      'contact_last_login': 'Последно влизане на контакта',
      'contact_full_name': 'Пълно име на контакта',
      'contact_phone': 'Телефон за връзка',
      'contact_custom_value1': 'Персонализирана контактна стойност 1',
      'contact_custom_value2': 'Персонализирана контактна стойност 2',
      'contact_custom_value3': 'Персонализирана контактна стойност 3',
      'contact_custom_value4': 'Персонализирана контактна стойност 4',
      'shipping_address1': 'Доставка - Улица',
      'shipping_address2': 'Доставка - Ап.',
      'shipping_city': 'Доставка - Град',
      'shipping_state': 'Доставка - Щат/Провинция',
      'shipping_postal_code': 'Доставка - Пощ. код',
      'shipping_country': 'Доставка - Държава',
      'billing_address1': 'Фактура - Улица',
      'billing_address2': 'Фактура - Ап.',
      'billing_city': 'Фактура - Град',
      'billing_state': 'Фактура - Щат/Провинция',
      'billing_postal_code': 'Фактура - Пощ. код',
      'billing_country': 'Фактура - Държава',
      'client_id': 'Client Id',
      'assigned_to': 'Присвоен на',
      'created_by': 'Създаден от :name',
      'assigned_to_id': 'Присвоен на Id',
      'created_by_id': 'Създаден от Id',
      'add_column': 'Добави колона',
      'edit_columns': 'Редактирай колони',
      'columns': 'Колони',
      'aging': 'По дата на издаване',
      'profit_and_loss': 'Печалба и загуба',
      'reports': 'Справки',
      'report': 'Справка',
      'add_company': 'Добавяне на фирма',
      'unpaid_invoice': 'Неплатена фактура',
      'paid_invoice': 'Платена фактура',
      'unapproved_quote': 'Неодобрена оферта',
      'help': 'Помощ',
      'refund': 'Възстановяване',
      'refund_date': 'Дата на възтановяване',
      'filtered_by': 'Филтрирано по',
      'contact_email': 'Имейл за връзка',
      'multiselect': 'Мултиселекция',
      'entity_state': 'Щат',
      'verify_password': 'Потвърди паролата',
      'applied': 'Приложено',
      'include_recent_errors': 'Включи последните грешки от логовете',
      'your_message_has_been_received':
          'Ние получихме съобщението Ви и ще се опитаме да отговорим незабавно.',
      'message': 'Съобщение',
      'from': 'От',
      'show_product_details': 'Показване на детайлите на продукта',
      'show_product_details_help':
          'Включване на описанието и цената в падащото меню на продукта',
      'pdf_min_requirements': 'PDF рендер-а изисква :version',
      'adjust_fee_percent': 'Настойка на процент таксата',
      'adjust_fee_percent_help': 'Adjust percent to account for fee',
      'configure_settings': 'Конфигуриране на настройките',
      'support_forum': 'Форуми за поддръжка',
      'about': 'За',
      'documentation': 'Документация',
      'contact_us': 'Свържете се с нас',
      'subtotal': 'Субтотал',
      'line_total': 'Обща цена',
      'item': 'Продукт',
      'credit_email': 'Кредитен е-мейл',
      'iframe_url': 'iFrame URL',
      'domain_url': 'Домейн адрес',
      'password_is_too_short': 'Паролата е твърде кратка',
      'password_is_too_easy': 'Паролата трябва да съдържа главна буква и цифра',
      'client_portal_tasks': 'Задачи от клиентския портал',
      'client_portal_dashboard': 'Табло на клиентския портал',
      'please_enter_a_value': 'Моля въведете стойност',
      'deleted_logo': 'Успешно изтрито лого',
      'yes': 'Да',
      'no': 'Не',
      'generate_number': 'Генерирай номер',
      'when_saved': 'е запазена',
      'when_sent': 'е изпратена',
      'select_company': 'Избери компания',
      'float': 'Плаващ',
      'collapse': 'Събери',
      'show_or_hide': 'Покажи/Скрий',
      'menu_sidebar': 'Меню на страничната лента',
      'history_sidebar': 'История на страничната лента',
      'tablet': 'Таблет',
      'mobile': 'Мобилно',
      'desktop': 'Десктоп',
      'layout': 'Оформление',
      'view': 'Преглед',
      'module': 'Модул',
      'first_custom': 'Първо персонализиране',
      'second_custom': 'Второ персонализиране',
      'third_custom': 'Трето персонализиране',
      'show_cost': 'Показване на цена',
      'show_product_cost': 'Показване на цената на продукта',
      'show_cost_help':
          'Покажи цената на продуктовото поле за да проследиш печалбата',
      'show_product_quantity': 'Показване на продуктовата наличност',
      'show_product_quantity_help':
          'Покажи полето за наличност на продукта, или ще се използва стандартното поле',
      'show_invoice_quantity': 'Покажи броят на фактурите',
      'show_invoice_quantity_help':
          'Покажи реда за наличност, или ще се използва стандартен ред',
      'show_product_discount': 'Показване на продуктовата отстъпка',
      'show_product_discount_help':
          'Показване на поле за отстъпка за договорена позиция',
      'default_quantity': 'Наличност по подразбиране',
      'default_quantity_help':
          'Автоматично слагане на линията за наличност на едно',
      'one_tax_rate': 'Една данъчна ставка',
      'two_tax_rates': 'Две данъчни ставки',
      'three_tax_rates': 'Три данъчни ставки',
      'default_tax_rate': 'Данъчна ставка по подразбиране',
      'user': 'Потребител',
      'invoice_tax': 'Такса за фактура',
      'line_item_tax': 'Данък върху договорената покупка',
      'inclusive_taxes': 'Включени такси',
      'invoice_tax_rates': 'Данъчни ставки на фактури',
      'item_tax_rates': 'Данъчни ставки',
      'no_client_selected': 'Моля, изберете клиент',
      'configure_rates': 'Конфигуриране на тарифите',
      'configure_gateways': 'Конфигуриране на Gateways',
      'tax_settings': 'Настройки за данък',
      'tax_settings_rates': 'Размер на данъци',
      'accent_color': 'Акцентен цвят',
      'switch': 'Прехвърляне',
      'comma_sparated_list': 'Лист разделен със запетаи',
      'options': 'Настройки',
      'single_line_text': 'Едноредов текст',
      'multi_line_text': 'Многоредов текст',
      'dropdown': 'Падащо меню',
      'field_type': 'Вид поле',
      'recover_password_email_sent':
          'Изпратен е e-mail за възстановяване на парола',
      'submit': 'Изпращане',
      'recover_password': 'Възстановяване на парола',
      'late_fees': 'Закъснели Такси',
      'credit_number': 'Кредит номер',
      'payment_number': 'Номер на плащане',
      'late_fee_amount': 'Стойност на таксата за закъснение',
      'late_fee_percent': 'Процент на таксата за закъснение',
      'before_due_date': 'Преди крайната дата',
      'after_due_date': 'След крайната дата',
      'after_invoice_date': 'След датата на фактурата',
      'days': 'Дни',
      'invoice_email': 'Имейл за фактура',
      'payment_email': 'Имейл за плащане',
      'partial_payment': 'Частично плащане',
      'payment_partial': 'Частично плащане',
      'partial_payment_email': 'Имейл за частично плащане',
      'quote_email': 'Имейл за оферта',
      'endless_reminder': 'Безкрайно подсещане',
      'filtered_by_user': 'Филтрирано по Потребител',
      'administrator': 'Администратор',
      'administrator_help':
          'Даване на права на потребителя да управлява другите потребители, да променя настойки и да редактира всички записи',
      'user_management': 'Управление на потребителите',
      'users': 'Потребители',
      'new_user': 'Нов потребител',
      'edit_user': 'Редактирай Потребител',
      'created_user': 'Успешно създаден потребител',
      'updated_user': 'Успешно обновен потребител',
      'archived_user': 'Успешно архивиране на потребител',
      'deleted_user': 'Успешно изтрит Потребител',
      'removed_user': 'Потребителя е премахнат успешно',
      'restored_user': 'Успешно възстановен Потребител',
      'archived_users': 'Успешно архивиран :value потребители',
      'deleted_users': 'Успешно изтрит :value потребители',
      'removed_users': 'Успешно премахнати :value потребители',
      'restored_users': 'Успешно възстановена :value потребители',
      'general_settings': 'Общи настройки',
      'invoice_options': 'Опции на фактурата',
      'hide_paid_to_date': 'Скрий \'Изплатено до момента\'',
      'hide_paid_to_date_help':
          'Покажи \'Изплатено до момента\' във фактурите, след като е получено плащане.',
      'invoice_embed_documents': 'Вграждане на изображения/документи',
      'invoice_embed_documents_help':
          'Включете прикачени изображения/pdf файлове във Фактура .',
      'all_pages_header': 'Показване на хедъра на',
      'all_pages_footer': 'Показване на футъра на',
      'first_page': 'Първа страница',
      'all_pages': 'Всички страници',
      'last_page': 'Последна страница',
      'primary_font': 'Основен Шрифт',
      'secondary_font': 'Допълнителен Шрифт',
      'primary_color': 'Основен цвят',
      'secondary_color': 'Допълнителен цвят',
      'page_size': 'Размер на страницата',
      'font_size': 'Размер на шрифта',
      'quote_design': 'Дизайн на оферта',
      'invoice_fields': 'Полета на фактурата',
      'product_fields': 'Продуктови полета',
      'invoice_terms': 'Условия на фактура',
      'invoice_footer': 'Футър на фактурата',
      'quote_terms': 'Условия на оферта',
      'quote_footer': 'Футър на оферта',
      'auto_email_invoice': 'Auto Email',
      'auto_email_invoice_help':
          'Автоматично изпращане на повтарящи се фактури по имейл, когато бъдат създадени.',
      'auto_archive_quote': 'Auto Archive',
      'auto_archive_quote_help':
          'Автоматично архивиране на офертите, когато се преобразуват във фактура.',
      'auto_convert_quote': 'Автоматично конвертиране',
      'auto_convert_quote_help':
          'Автоматично конвертиране на оферта във фактура след одобрение.',
      'workflow_settings': 'Настройки на работния процес',
      'freq_daily': 'Ежедневно',
      'freq_weekly': 'Седмично',
      'freq_two_weeks': 'Две седмици',
      'freq_four_weeks': 'Четири седмици',
      'freq_monthly': 'Месечно',
      'freq_two_months': 'Два месеца',
      'freq_three_months': 'Три месеца',
      'freq_four_months': 'Четири месеца',
      'freq_six_months': 'Шест месеца',
      'freq_annually': 'Годишно',
      'freq_two_years': 'На две години',
      'freq_three_years': 'Три години',
      'never': 'Никога',
      'company': 'Фирма',
      'generated_numbers': 'Генерирани номера',
      'charge_taxes': 'Начисли данъци',
      'next_reset': 'Следващо нулиране',
      'reset_counter': 'Нулиране на брояч',
      'recurring_prefix': 'Префикс за периодични документи',
      'number_padding': 'Номер на отстояние',
      'general': 'Общ',
      'surcharge_field': 'Етикет допълнителна такса',
      'company_field': 'Поле на Фирмата',
      'company_value': 'Фирмена стойност',
      'credit_field': 'Кредитно поле',
      'invoice_field': 'Поле на фактурата',
      'invoice_surcharge': 'Допълнителна такса по фактура',
      'client_field': 'Поле на клиента',
      'product_field': 'Поле на продукта',
      'payment_field': 'Поле за плащане',
      'contact_field': 'Поле за контакти',
      'vendor_field': 'Поле на доставчика',
      'expense_field': 'Поле Разход',
      'project_field': 'Поле на проекта',
      'task_field': 'Поле Задача',
      'group_field': 'Поле за група',
      'number_counter': 'Брояч на номера',
      'prefix': 'Префикс',
      'number_pattern': 'Модел номер',
      'messages': 'Съобщения',
      'custom_css': 'Персонализиран CSS',
      'custom_javascript': 'Персонализиран JavaScript',
      'signature_on_pdf': 'Показване в PDF документа',
      'signature_on_pdf_help':
          'Показване на подписа на клиента в PDF фактурата / офертата.',
      'show_accept_invoice_terms': 'Чек-бокс за условия на фактура',
      'show_accept_invoice_terms_help':
          'Изискване клиенът да потвърди, че приема условията на фактурата',
      'show_accept_quote_terms': 'Чек-бокс за условия на офертата',
      'show_accept_quote_terms_help':
          'Изискване клиенът да потвърди, че приема условията на офертата',
      'require_invoice_signature': 'Подпис на фактурата',
      'require_invoice_signature_help': 'Изискване клиентът да подпише',
      'require_quote_signature': 'Подпис на офертата',
      'enable_portal_password': 'Защита на фактурите с парола',
      'enable_portal_password_help':
          'Дава възможност да заложите парола за всеки контакт. Ако такава е заложена, контактното лице ще трябва да я въведе преди да види фактурите,',
      'authorization': 'Оторизация',
      'subdomain': 'Subdomain',
      'domain': 'Домейн',
      'portal_mode': 'Портален режим',
      'email_signature': 'Поздрави,',
      'enable_email_markup_help':
          'Направете плащането към Вас по-лесно за клиентите си като добавите в имейлите си schema.org markup.',
      'plain': 'Изчистено',
      'light': 'Светло',
      'dark': 'Тъмно',
      'email_design': 'Дизайн на имейл',
      'attach_pdf': 'Прикачете PDF',
      'attach_documents': 'Прикачване на документи',
      'attach_ubl': 'Прикачете UBL/E- Фактура',
      'email_style': 'Стилове на имейла',
      'enable_email_markup': 'Активиране на Markup',
      'reply_to_email': 'Reply-To Email',
      'reply_to_name': 'Отговор до Име',
      'bcc_email': 'BCC Email',
      'processed': 'Обработен',
      'credit_card': 'Кредитна карта',
      'bank_transfer': 'Банков трансфер',
      'priority': 'Приоритет',
      'fee_amount': 'Сума на таксата',
      'fee_percent': 'Процент такса',
      'fee_cap': 'Ограничение за такса',
      'limits_and_fees': 'Лимити/Такси',
      'enable_min': 'Активиране на min',
      'enable_max': 'Активиране на max',
      'min_limit': 'Мин.: :min',
      'max_limit': 'Макс.: :max',
      'min': 'Min',
      'max': 'Max',
      'accepted_card_logos': 'Лога на приемани карти',
      'credentials': 'Удостоверение за самоличност',
      'update_address': 'Актуализация на адреса',
      'update_address_help':
          'Актуализация на адреса на клиента с предоставените данни',
      'rate': 'Размер',
      'tax_rate': 'Данъчна ставка',
      'new_tax_rate': 'Нова такса',
      'edit_tax_rate': 'Редакция на данъчна ставка',
      'created_tax_rate': 'Успешно създадена данъчна ставка',
      'updated_tax_rate': 'Успешно актуализирана данъчна ставка',
      'archived_tax_rate': 'Успешно архивиране на данъчна ставка',
      'deleted_tax_rate': 'Успешно изтрита данъчна ставка',
      'restored_tax_rate': 'Успешно възтановена данъчна ставка',
      'archived_tax_rates': 'Успешно архивиран :value данъчни ставки',
      'deleted_tax_rates': 'Успешно изтрит :value данъчни ставки',
      'restored_tax_rates': 'Успешно възстановена :value данъчни ставки',
      'fill_products': 'Автоматично попълвай продукти',
      'fill_products_help':
          'Избирането на продукт автоматично ще попълни описанието и цената',
      'update_products': 'Автоматично обнови продукти',
      'update_products_help':
          'Промяната на фактура автоматично ще обнови продуктовия каталог',
      'convert_products': 'Конвертиране на продукти',
      'convert_products_help':
          'Автоматично конвертиране на цените на продуктите във валутата на клиента',
      'fees': 'Такси',
      'limits': 'Лимити',
      'provider': 'Доставчик',
      'company_gateway': 'Портал за плащане',
      'company_gateways': 'Портали за плащане',
      'new_company_gateway': 'Нов портал',
      'edit_company_gateway': 'Редактиране на портал',
      'created_company_gateway': 'Успешно създаден портал',
      'updated_company_gateway': 'Успешно актуализиран портал',
      'archived_company_gateway': 'Успешно архивиране на портал',
      'deleted_company_gateway': 'Успешно изтрит портал',
      'restored_company_gateway': 'Успешно възстановен портал',
      'archived_company_gateways': 'Успешно архивиран :value gateways',
      'deleted_company_gateways': 'Успешно изтрит :value gateways',
      'restored_company_gateways': 'Успешно възстановена :value gateways',
      'continue_editing': 'Продължете редактирането',
      'discard_changes': 'Отмяна на промените',
      'default_value': 'Стойност по подразбиране',
      'disabled': 'Неактивно',
      'currency_format': 'Формат на валутата',
      'first_day_of_the_week': 'Първи ден от седмицата',
      'first_month_of_the_year': 'Първи месец на годината',
      'sunday': 'неделя',
      'monday': 'понеделник',
      'tuesday': 'вторник',
      'wednesday': 'сряда',
      'thursday': 'четвъртък',
      'friday': 'петък',
      'saturday': 'събота',
      'january': 'Януари',
      'february': 'Февруари',
      'march': 'Март',
      'april': 'Април',
      'may': 'Май',
      'june': 'Юни',
      'july': 'Юли',
      'august': 'Август',
      'september': 'Септември',
      'october': 'Октомври',
      'november': 'Ноември',
      'december': 'Декември',
      'symbol': 'Символ',
      'ocde': 'Код',
      'date_format': 'Формат на датата',
      'datetime_format': 'Формат за дата',
      'military_time': '24 часово време',
      'military_time_help': '24-часов формат',
      'send_reminders': 'Изпращане на напомняния',
      'timezone': 'Часова зона',
      'filtered_by_project': 'Филтрирай по проект',
      'filtered_by_group': 'Филтрирано по група',
      'filtered_by_invoice': 'Филтрирано по фактура',
      'filtered_by_client': 'Филтрирано по клиент',
      'filtered_by_vendor': 'Филтрирано по доставчик',
      'group_settings': 'Настройки на групата',
      'group': 'Групиране',
      'groups': 'Групи',
      'new_group': 'Нова Група',
      'edit_group': 'Редактира не Група',
      'created_group': 'Групата беше създадена успешно',
      'updated_group': 'Групата беше обновена успешно',
      'archived_groups': 'Успешно архивиран :value групи',
      'deleted_groups': 'Успешно изтрит :value групи',
      'restored_groups': 'Успешно възстановена :value групи',
      'archived_group': 'Групата беше архивирана успешно',
      'deleted_group': 'Групата беше изтрита успешно',
      'restored_group': 'Групата беше възстановена успешно',
      'upload_logo': 'Качете логото на фирмата си',
      'uploaded_logo': 'Логото беше качено успешно',
      'logo': 'Лого',
      'saved_settings': 'Настройките бяха записани успешно',
      'product_settings': 'Настройки на продукти',
      'device_settings': 'Настройка на Устройство',
      'defaults': 'По подразбиране',
      'basic_settings': 'Основни настройки',
      'advanced_settings': 'Разширени настройки',
      'company_details': 'Данни на фирма',
      'user_details': 'Данни за потребителя',
      'localization': 'Локализация',
      'online_payments': 'Онлайн плащания',
      'tax_rates': 'Размер на данъци',
      'notifications': 'Известия',
      'import_export': 'Импорт | Експорт',
      'custom_fields': 'Собствени полета',
      'invoice_design': 'Дизайн на фактура',
      'buy_now_buttons': 'Бутони \'Купи сега\'',
      'email_settings': 'Email настройки',
      'templates_and_reminders': 'Шаблони и напомняния',
      'credit_cards_and_banks': 'Кредитни Карти & Банки',
      'data_visualizations': 'Визуализация на данни',
      'price': 'Цена',
      'email_sign_up': 'Регистрация с E-mail',
      'google_sign_up': 'Регистрация с Google',
      'thank_you_for_your_purchase': 'Благодарим за покупката!',
      'redeem': 'Осребряване',
      'back': 'Назад',
      'past_purchases': 'Минали покупки',
      'annual_subscription': 'Годишен абонамен',
      'pro_plan': 'Pro Абонамент',
      'enterprise_plan': 'Enterprise План',
      'count_users': ':count потребители',
      'upgrade': 'Обнови',
      'please_enter_a_first_name': 'Моля въведете собствено име',
      'please_enter_a_last_name': 'Моля въведете фамилно име',
      'please_agree_to_terms_and_privacy':
          'Моля съгласете се с общите условия и политиката за поверителност за да създадете профил.',
      'i_agree_to_the': 'Съгласявам се с',
      'terms_of_service': 'Условия за ползване',
      'privacy_policy': 'Политика за защита на личните данни',
      'sign_up': 'Регистрация',
      'account_login': 'Вход в профила',
      'view_website': 'Виж уебсайт',
      'create_account': 'Създай Профил',
      'email_login': 'Влизане зрез email',
      'create_new': 'Нов',
      'no_record_selected': 'Няма избрани записи',
      'error_unsaved_changes': 'Моля запазете или откажете промените',
      'download': 'Сваляне',
      'requires_an_enterprise_plan': 'Изисква Enterprise Plan',
      'take_picture': 'Направи Снимка',
      'upload_files': 'Качване на файлове',
      'document': 'Документ',
      'documents': 'Документи',
      'new_document': 'Нов Документ',
      'edit_document': 'Редакция на Документ',
      'uploaded_document': 'Документът беше качен успешно',
      'updated_document': 'Документът беше обновен успешно',
      'archived_document': 'Документът беше архивиран успешно',
      'deleted_document': 'Документът беше изтрит успешно',
      'restored_document': 'Документът беше възстановен успешно',
      'archived_documents': 'Успешно архивиран :value документи',
      'deleted_documents': 'Успешно изтрит :value документи',
      'restored_documents': 'Успешно възстановена :value документи',
      'no_history': 'Няма История',
      'expense_date': 'Дата разход',
      'pending': 'Очаквано',
      'expense_status_1': 'Логнат',
      'expense_status_2': 'Изчакващи',
      'expense_status_3': 'Фактурирано',
      'converted': 'Конвертирано',
      'add_documents_to_invoice': 'Добави документи към фактурата',
      'exchange_rate': 'Курс',
      'convert_currency': 'Конвертиране на валутата',
      'mark_paid': 'Маркирай платено',
      'category': 'Категория',
      'address': 'Адрес',
      'new_vendor': 'Нов доставчик',
      'created_vendor': 'Успешно създаден доставчик',
      'updated_vendor': 'Успешно обновен доставчик',
      'archived_vendor': 'Успешно архивиран доставчик',
      'deleted_vendor': 'Успешно изтрит доставчик',
      'restored_vendor': 'Успешно възстановяване на доставчик',
      'archived_vendors': 'Успешно архивирани :count доставчици',
      'deleted_vendors': 'Успешно изтрити :count доставчици',
      'restored_vendors': 'Успешно възстановена :value vendors',
      'new_expense': 'Въведете разход',
      'created_expense': 'Успешно създаден разход',
      'updated_expense': 'Успешна актуализация на разход',
      'archived_expense': 'Успешно архивиран разход',
      'deleted_expense': 'Успешно изтрит разход',
      'restored_expense': 'Успешно възстановяване на разход',
      'archived_expenses': 'Успешно архивирани разходи',
      'deleted_expenses': 'Успешно изтрити разходи',
      'restored_expenses': 'Успешно възстановена :value разходи',
      'copy_shipping': 'Копиране на адрес за доставка',
      'copy_billing': 'Копиране на адрес за фактуриране',
      'design': 'Дизайн',
      'failed_to_find_record': 'Записът не е намерен',
      'invoiced': 'Фактурирано',
      'logged': 'Логвано',
      'running': 'Стартирано',
      'resume': 'Продължаване',
      'task_errors': 'Моля, коригирайте припокриващите се интервали',
      'start': 'Старт',
      'stop': 'Стоп',
      'started_task': 'Успешно стартирана задача',
      'stopped_task': 'Успешно спряна задача',
      'resumed_task': 'Успешно възобновяване на работата по задачата',
      'now': 'Сега',
      'auto_start_tasks': 'Автоматично стартиране на задачите',
      'timer': 'Таймер',
      'manual': 'Ръчно',
      'budgeted': 'Бюджетирано',
      'start_time': 'Начало',
      'end_time': 'Край',
      'date': 'Дата',
      'times': 'Време',
      'duration': 'Продължителност',
      'new_task': 'Нова задача',
      'created_task': 'Успешно създадена задача',
      'updated_task': 'Успешно актуализирана задача',
      'archived_task': 'Успешно архивирана задача',
      'deleted_task': 'Успешно изтрита задача',
      'restored_task': 'Успешно възстановена задача',
      'archived_tasks': 'Успешно архивирани :count задачи',
      'deleted_tasks': 'Успешно изтрити :count задачи',
      'restored_tasks': 'Успешно възстановена :value Задачи',
      'please_enter_a_name': 'Моля, въведете име',
      'budgeted_hours': 'Часове по бюджет',
      'created_project': 'Успешно създаден проект',
      'updated_project': 'Успешна актуализация на проект',
      'archived_project': 'Успешно архивиран проект',
      'deleted_project': 'Успешно изтрит проект',
      'restored_project': 'Успешно възстановен проект',
      'archived_projects': 'Успешно архивирани :count проекта',
      'deleted_projects': 'Успешно изтрити :count проекта',
      'restored_projects': 'Успешно възстановена :value проекти',
      'new_project': 'Нов проект',
      'thank_you_for_using_our_app':
          'Благодарим Ви, че използвате нашето приложение!',
      'if_you_like_it': 'Ако го харесвате Ви молим',
      'click_here': 'натиснете тук',
      'click_here_capital': 'Натиснете тук',
      'to_rate_it': 'да го оцените.',
      'average': 'Средно',
      'unapproved': 'Неодобрено',
      'authenticate_to_change_setting':
          'Моля, влезте в профила си за промяна на тази настойка',
      'locked': 'Блокирано',
      'authenticate': 'Вход в профила',
      'please_authenticate': 'Моля, влезте в профила си',
      'biometric_authentication': 'Биометричен вход',
      'footer': 'Футър',
      'compare': 'Сравнение',
      'hosted_login': 'Hosted Login',
      'selfhost_login': 'Selfhost Login',
      'google_sign_in': 'Влез с Google',
      'today': 'Днес',
      'custom_range': 'Друг период',
      'date_range': 'Период',
      'current': 'Настоящ',
      'previous': 'Предишен',
      'current_period': 'Настоящ период',
      'comparison_period': 'Период за сравнение',
      'previous_period': 'Предишен период',
      'previous_year': 'Предишна година',
      'compare_to': 'Сравнение със',
      'last7_days': 'Последни 7 дни',
      'last_week': 'Предишна седмица',
      'last30_days': 'Последни 30 дни',
      'this_month': 'Този месец',
      'last_month': 'Предишния месец',
      'this_year': 'Тази година',
      'last_year': 'Предишна година',
      'all_time': 'Всички времена',
      'custom': 'Custom',
      'clone_to_invoice': 'Копирай във фактура',
      'clone_to_quote': 'Копирай в оферта',
      'clone_to_credit': 'Копирай в кредит',
      'view_invoice': 'Прегледай Фактура',
      'convert': 'Конвертирай',
      'more': 'Още',
      'edit_client': 'Редактирай клиент',
      'edit_product': 'Редактирай продукт',
      'edit_invoice': 'Редактирай фактура',
      'edit_quote': 'Редактирай Оферта',
      'edit_payment': 'Редактирай Плащане',
      'edit_task': 'Редакция на задача',
      'edit_expense': 'Редакция на разход',
      'edit_vendor': 'Редакция на доставчик',
      'edit_project': 'Редакция на проект',
      'edit_recurring_quote': 'Редакция на периодична оферта',
      'billing_address': 'Адрес за фактуриране',
      'shipping_address': 'Адрес за доставка',
      'total_revenue': 'Общо приходи',
      'average_invoice': 'Средна стойност на фактура',
      'outstanding': 'Оставащи',
      'invoices_sent': ':count изпратени фактури',
      'active_clients': 'активни клиенти',
      'close': 'Затвори',
      'email': 'Електронна поща',
      'password': 'Парола',
      'url': 'URL',
      'secret': 'Secret',
      'name': 'Име',
      'logout': 'Изход',
      'login': 'Вход',
      'filter': 'Филтър',
      'sort': 'Сортиране',
      'search': 'Търсене',
      'active': 'Активен',
      'archived': 'Архив',
      'deleted': 'изтрита',
      'dashboard': 'Табло',
      'archive': 'Архивирай',
      'delete': 'Изтрий',
      'restore': 'Възтанови',
      'refresh_complete': 'Обновяването завършено',
      'please_enter_your_email': 'Моля въведете вашият имейл',
      'please_enter_your_password': 'Моля въведете вашата парола',
      'please_enter_your_url': 'Моля, въведете своя URL',
      'please_enter_a_product_key': 'Моля, въведете product key',
      'ascending': 'Нарастващо',
      'descending': 'Намаляващо',
      'save': 'Запазване',
      'an_error_occurred': 'Настъпила е грешка',
      'paid_to_date': 'Платени до момента',
      'balance_due': 'Остават за плащане',
      'balance': 'Баланс',
      'overview': 'Преглед',
      'details': 'Подробности',
      'phone': 'Телефон',
      'website': 'Уебсайт',
      'vat_number': 'ДДС Номер',
      'id_number': 'ЕИК/Булстат',
      'create': 'Създаване',
      'copied_to_clipboard': 'Копирано :value в клипборда',
      'error': 'Грешка',
      'could_not_launch': 'Не може да стартира',
      'contacts': 'Контакти',
      'additional': 'Допълнително',
      'first_name': 'Първо име',
      'last_name': 'Фамилно име',
      'add_contact': 'Добави контакт',
      'are_you_sure': 'Сигурен ли сте?',
      'cancel': 'Отказ',
      'ok': 'Ок',
      'remove': 'Премахване',
      'email_is_invalid': 'Имейл адресът е невалиден',
      'product': 'Продукт',
      'products': 'Продукти',
      'new_product': 'Нов продукт',
      'created_product': 'Продуктът беше успешно създаден',
      'updated_product': 'Продуктът беше успешно променен',
      'archived_product': 'Продуктът беше успешно архивиран',
      'deleted_product': 'Успешно изтрит продукт',
      'restored_product': 'Успешно възстановен продукт',
      'archived_products': 'Успешно архивирани :count продукта',
      'deleted_products': 'Успешно изтрити :count продукта',
      'restored_products': 'Успешно възстановена :value продукти',
      'product_key': 'Продукт',
      'notes': 'Забележки',
      'cost': 'Цена',
      'client': 'Клиент',
      'clients': 'Клиенти',
      'new_client': 'Нов клиент',
      'created_client': 'Клиентът е създаден успешно',
      'updated_client': 'Успешно редактиран клиент',
      'archived_client': 'Успешно архивиран клиент',
      'archived_clients': 'Успешно архивирани :count клиенти',
      'deleted_client': 'Успешно изтрит клиент',
      'deleted_clients': 'Успешно изтрити :count клиенти',
      'restored_client': 'Успешно възстановен Клиент',
      'restored_clients': 'Успешно възстановена :value Клиенти',
      'address1': 'Улица',
      'address2': 'Апартамент',
      'city': 'Град',
      'state': 'Област',
      'postal_code': 'Пощенски код',
      'country': 'Държава',
      'invoice': 'Фактура',
      'invoices': 'Фактури',
      'new_invoice': 'Нова фактура',
      'created_invoice': 'Успешно създадена фактура',
      'updated_invoice': 'Успешно редактирана фактура',
      'archived_invoice': 'Успешно архивирана фактура',
      'deleted_invoice': 'Успешно изтрита фактура',
      'restored_invoice': 'Успешно възстановена фактура',
      'archived_invoices': 'Успешно архивирани :count фактури',
      'deleted_invoices': 'Успешно изтрити :count фактури',
      'restored_invoices': 'Успешно възстановена :value Фактури',
      'emailed_invoice': 'Успешно изпратена фактура по имейл',
      'emailed_payment': 'Успешно изпратен имейл за плащане',
      'amount': 'Сума',
      'invoice_number': 'Номер на фактура',
      'invoice_date': 'Дата на фактура',
      'discount': 'Отстъпка',
      'po_number': 'номер на пощенска кутия',
      'terms': 'Условия',
      'public_notes': 'Публични забележки',
      'private_notes': 'Лични бележки',
      'frequency': 'Честота',
      'start_date': 'Начална дата',
      'end_date': 'Крайна дата',
      'quote_number': 'Номер на оферта',
      'quote_date': 'Дата на оферта',
      'valid_until': 'Валидна до',
      'items': 'Редове',
      'partial_deposit': 'Частично/Депозит',
      'description': 'Описание',
      'unit_cost': 'Ед. цена',
      'quantity': 'Количество',
      'add_item': 'Добавяне на ред',
      'contact': 'Контакт',
      'work_phone': 'Телефон',
      'total_amount': 'Обща стойност',
      'pdf': 'PDF',
      'due_date': 'Крайна дата за плащане',
      'partial_due_date': 'Частичен падеж',
      'paid_date': 'Платена дата',
      'status': 'Статус',
      'invoice_status_id': 'Статус на фактурите',
      'quote_status': 'Статус на оферта',
      'click_plus_to_add_item': 'Натиснете + за добавяне на ред',
      'click_plus_to_add_time': 'Натиснете + за да добавите време',
      'count_selected': ':count избрани',
      'total': 'Общо',
      'percent': 'Процент',
      'edit': 'Редактиране',
      'dismiss': 'Отхвърляне',
      'please_select_a_date': 'Моля изберете дата',
      'please_select_a_client': 'Моля изберете клиент',
      'please_select_an_invoice': 'Моля, изберете фактура',
      'task_rate': 'Ставка',
      'settings': 'Настройки',
      'language': 'Език',
      'currency': 'Валута',
      'created_at': 'Дата на създаване',
      'created_on': 'Създадено на',
      'updated_at': 'Актуализиран',
      'tax': 'Данък',
      'please_enter_an_invoice_number': 'Моля, въведете номер на фактура',
      'please_enter_a_quote_number': 'Моля, въведете номер на оферта',
      'past_due': 'Просрочено',
      'draft': 'Чернова',
      'sent': 'Изпратена',
      'viewed': 'Прегледано',
      'approved': 'Одобрено',
      'partial': 'Частично плащане / депозит',
      'paid': 'Платено',
      'mark_sent': 'Маркирай като изпратена',
      'marked_invoice_as_sent': 'Фактурата е успешно маркирана като изпратена',
      'marked_invoice_as_paid': 'Успешно отбеляза Фактура като платена',
      'marked_invoices_as_sent': 'Фактурите са маркирани като изпратени',
      'marked_invoices_as_paid': 'Успешно отбеляза Фактури като платен',
      'done': 'Готово',
      'please_enter_a_client_or_contact_name':
          'Моля, въведете клиент или лице за контакт',
      'dark_mode': 'Тъмен режим',
      'restart_app_to_apply_change':
          'Рестартирайте приложението за прилагане на промяната',
      'refresh_data': 'Опресняване на данни',
      'blank_contact': 'Празен контакт',
      'activity': 'Активност',
      'no_records_found': 'Няма намерени записи',
      'clone': 'Копирай',
      'loading': 'Зареждане',
      'industry': 'Бранш',
      'size': 'Размер',
      'payment_terms': 'Условия за плащане',
      'payment_date': 'Дата на плащане',
      'payment_status': 'Статус на Плащането',
      'payment_status_1': 'Изчакващи',
      'payment_status_2': 'Анулирани',
      'payment_status_3': 'Грешни',
      'payment_status_4': 'Готови',
      'payment_status_5': 'Частично възстановяване',
      'payment_status_6': 'Възстановена',
      'payment_status_-1': 'Наприложено',
      'payment_status_-2': 'Частично неприложен',
      'net': 'Нето',
      'client_portal': 'Клиентски портал',
      'show_tasks': 'Показване на задачи',
      'email_reminders': 'Изпращане на напомняния по имейл',
      'enabled': 'Активно',
      'recipients': 'Получатели',
      'initial_email': 'Първоначален имейл',
      'first_reminder': 'Първо напомняне',
      'second_reminder': 'Второ напомняне',
      'third_reminder': 'Трето напомняне',
      'reminder1': 'Първо напомняне',
      'reminder2': 'Второ напомняне',
      'reminder3': 'Трето напомняне',
      'template': 'Шаблон',
      'send': 'Изпращане',
      'subject': 'Относно',
      'body': 'Основен текст',
      'send_email': 'Изпращане на имейл',
      'email_receipt': 'Изпращане на имейл за плащане към клиента',
      'auto_billing': 'Auto billing',
      'button': 'Бутон',
      'preview': 'Преглед',
      'customize': 'Персонализиране',
      'history': 'История',
      'payment': 'Плащане',
      'payments': 'Плащания',
      'refunded': 'Възстановена',
      'payment_type': 'Тип плащане',
      'transaction_reference': 'Основание за превод',
      'enter_payment': 'Въведи плащане',
      'new_payment': 'Въведи плащане',
      'created_payment': 'Успешно създадено плащане',
      'updated_payment': 'Успешно обновено Плащане',
      'archived_payment': 'Успешно архивирано плащане',
      'deleted_payment': 'Успешно изтрито плащане',
      'restored_payment': 'Успешно възстановенo Плащане',
      'archived_payments': 'Успешно архивирани :count плащания',
      'deleted_payments': 'Успешно изтрити :count плащания',
      'restored_payments': 'Успешно възстановена :value Плащания',
      'quote': 'Оферта',
      'quotes': 'Оферти',
      'new_quote': 'Нова оферта',
      'created_quote': 'Успешно Създадена Оферта',
      'updated_quote': 'Успешно обновена Оферта',
      'archived_quote': 'Успешно архивирана Оферта',
      'deleted_quote': 'Успешно изтрита Оферта',
      'restored_quote': 'Успешно възстановена Оферта',
      'archived_quotes': 'Успешно архивирани :count Оферти',
      'deleted_quotes': 'Успешно изтрити :count Оферти',
      'restored_quotes': 'Успешно възстановена :value цитати',
      'expense': 'Разход',
      'expenses': 'Разходи',
      'vendor': 'Доставчик',
      'vendors': 'Доставчици',
      'task': 'Задача',
      'tasks': 'Задачи',
      'project': 'Проект',
      'projects': 'Проекти',
      'activity_1': ':user зъздаде клиент :client',
      'activity_2': ':user архивира клиент :client',
      'activity_3': ':user изтри клиент :client',
      'activity_4': ':user създаде фактура :invoice',
      'activity_5': ':user актуализира фактура :invoice',
      'activity_6': ':user изпрати фактура :invoice, към :client, на :contact',
      'activity_7': ':contact прегледа фактура :invoice, към :client',
      'activity_8': ':user архивира фактура :invoice',
      'activity_9': ':user изтри фактура :invoice',
      'activity_10':
          ':user влезе в Плащане :payment за :payment _сума на Фактура :invoice за :client',
      'activity_11': ':user актуализира плащане :payment',
      'activity_12': ':user архивира плащане :payment',
      'activity_13': ':user изтри плащане :payment',
      'activity_14': ':user въведе :credit credit',
      'activity_15': ':user актуализира :credit credit',
      'activity_16': ':user архивира :credit credit',
      'activity_17': ':user изтри кредит :credit',
      'activity_18': ':user създаде оферта :quote',
      'activity_19': ':user актуализира оферта :quote',
      'activity_20': ':user изпрати оферта :quote, към :client, на :contact',
      'activity_21': ':contact прегледа оферта :quote',
      'activity_22': ':user архивира оферта :quote',
      'activity_23': ':user изтри оферта :quote',
      'activity_24': ':user възстанови оферта :quote',
      'activity_25': ':user възстанови фактура :invoice',
      'activity_26': ':user възстанови клиент :client',
      'activity_27': ':user възстанови плащане :payment',
      'activity_28': ':user възстанови кредит :credit',
      'activity_29': ':contact одобри оферта :quote, към :client',
      'activity_30': ':user създаде доставчик :vendor',
      'activity_31': ':user архивира доставчик :vendor',
      'activity_32': ':user изтри доставчик :vendor',
      'activity_33': ':user възстанови доставчик :vendor',
      'activity_34': ':user създаде покупка :expense',
      'activity_35': ':user архивира покупка :expense',
      'activity_36': ':user изтри покупка :expense',
      'activity_37': ':user възстанови покупка :expense',
      'activity_39': ':user е отказал :payment_amount за плащане :payment',
      'activity_40':
          ':user е възстановил :adjustment на стойност :payment_amount за плащане :payment',
      'activity_41': 'Отказани :payment_amount по плащане (:payment)',
      'activity_42': ':user създаде задача :task',
      'activity_43': ':user актуализира задача :task',
      'activity_44': ':user архивира задача :task',
      'activity_45': ':user изтри задача :task',
      'activity_46': ':user възстанови задача :task',
      'activity_47': ':user актуализира покупка :expense',
      'activity_48': ':user създаде потребител :user',
      'activity_49': ':user актуализира потребител :user',
      'activity_50': ':user архивира потребител :user',
      'activity_51': ':user изтри потребител :user',
      'activity_52': ':user възстанови потребител :user',
      'activity_53': ':user маркира като изпратена фактура :invoice',
      'activity_54': ':user заплати фактура :invoice',
      'activity_55': ':contact отговори на тикет :ticket',
      'activity_56': ':user прегледа тикет :ticket',
      'activity_57': 'Системата не успя да изпрати фактура :invoice по e-mail',
      'activity_58': ':user сторнира фактура :invoice',
      'activity_59': ':user анулира фактура :invoice',
      'activity_60': ':contact прегледа оферта :quote',
      'activity_61': ':user актуализира клиент :client',
      'activity_62': ':user актуализира доставчик :vendor',
      'activity_63':
          ':user изпрати първо имейл напомняне за фактура :invoice до :contact',
      'activity_64':
          ':user изпрати второ имейл напомняне за фактура :invoice до :contact',
      'activity_65':
          ':user изпрати трето имейл напомняне за фактура :invoice до :contact',
      'activity_66':
          ':user изпрати безкрайно имейл напомняне за фактура :invoice до :contact',
      'activity_80': ':user Създадена абонамент :subscription',
      'activity_81': ':user обновена абонамент :subscription',
      'activity_82': ':user архивиран абонамент :subscription',
      'activity_83': ':user изтрит абонамент :subscription',
      'activity_84': ':user възстановена абонамент :subscription',
      'one_time_password': 'Еднократна парола',
      'emailed_quote': 'Успешно изпратена Оферта',
      'emailed_credit': 'Успешно изпратен имейл за кредит',
      'marked_quote_as_sent': 'Офертата е успешно маркирана като изпратена',
      'marked_credit_as_sent': 'Успешно отбелязан кредит като изпратен',
      'expired': 'Изтекла',
      'all': 'Всички',
      'select': 'Избери',
      'long_press_multiselect': 'Натиснете дълго за мултиселекция',
      'custom_value1': 'персонализиран Стойност 1',
      'custom_value2': 'персонализиран Стойност 2',
      'custom_value3': 'Персонифицирана стойност 3',
      'custom_value4': 'Персонифицирана стойност 4',
      'email_style_custom': 'Персонифициран стил на имейла',
      'custom_message_dashboard': 'Персонифицирано съобщение на таблото',
      'custom_message_unpaid_invoice':
          'Персонифицирано съобшение за неплатена фактура',
      'custom_message_paid_invoice':
          'Персонифицирано съобшение за платена фактура',
      'custom_message_unapproved_quote':
          'Персонифицирано съобшение за непотвърдена фактура',
      'lock_invoices': 'Заключи фактурите',
      'translations': 'Преводи',
      'task_number_pattern': 'Задача номер',
      'task_number_counter': 'Брояч на номер на задача',
      'expense_number_pattern': 'Разход номер',
      'expense_number_counter': 'Брояч на номер на разход',
      'vendor_number_pattern': 'Номер на доставчик',
      'vendor_number_counter': 'Брояч на номер на доставчик',
      'ticket_number_pattern': 'Билет номер',
      'ticket_number_counter': 'Брояч на номер на билет',
      'payment_number_pattern': 'Номер на плащане',
      'payment_number_counter': 'Брояч на номер на плащане',
      'invoice_number_pattern': 'Номер на фактура',
      'invoice_number_counter': 'Следващ номер на фактура',
      'quote_number_pattern': 'Номер на оферта',
      'quote_number_counter': 'Следващ номер на оферта',
      'client_number_pattern': 'Номер на кредит',
      'client_number_counter': 'Брояч на номер на кредит',
      'credit_number_pattern': 'Номер на кредит',
      'credit_number_counter': 'Брояч на номер на кредит',
      'reset_counter_date': 'Нулиране на датата на брояча',
      'counter_padding': 'подравняване на брояч',
      'shared_invoice_quote_counter': 'Сподели Фактура / цитат Counter',
      'default_tax_name_1': 'Данъчно име по подразбиране 1',
      'default_tax_rate_1': 'Данъчна ставка по подразбиране 1',
      'default_tax_name_2': 'Данъчно име по подразбиране 2',
      'default_tax_rate_2': 'Данъчна ставка по подразбиране 2',
      'default_tax_name_3': 'Данъчно име по подразбиране 3',
      'default_tax_rate_3': 'Данъчна ставка по подразбиране 3',
      'email_subject_invoice': 'Заглавие на имейл за фактура',
      'email_subject_quote': 'Заглавие на имейл за оферта',
      'email_subject_payment': 'Заглавие на имейл за плащане',
      'email_subject_payment_partial': 'Заглавие на имейл за частично плащане',
      'show_table': 'Покажи таблица',
      'show_list': 'Покажи лист',
      'client_city': 'Град на клиента',
      'client_state': 'Щат на клиента',
      'client_country': 'Държава на клиента',
      'client_is_active': 'Клиентът е активен',
      'client_balance': 'Баланс на клиента',
      'client_address1': 'Улица на клиента',
      'client_address2': 'Апартамент/стая на клиента',
      'vendor_address1': 'Доставчик ул',
      'vendor_address2': 'Доставчик Apt/Suite',
      'client_shipping_address1': 'Доставка (клиент) - улица',
      'client_shipping_address2': 'Доставка (клиент) - апартамент/стая',
      'type': 'Тип',
      'invoice_amount': 'Стойност на фактура',
      'invoice_due_date': 'Падеж',
      'tax_rate1': 'Данъчна ставка 1',
      'tax_rate2': 'Данъчна ставка 2',
      'tax_rate3': 'Данъчна ставка 3',
      'auto_bill': 'Автоматично фактуриране',
      'archived_at': 'Архивиран на',
      'has_expenses': 'Има разходи',
      'custom_taxes1': 'Персонализирани данъци 1',
      'custom_taxes2': 'Персонализирани данъци 2',
      'custom_taxes3': 'Персонализирани данъци 3',
      'custom_taxes4': 'Персонализирани данъци 4',
      'custom_surcharge1': 'Персонализирано доплащане 1',
      'custom_surcharge2': 'Персонализирано доплащане 2',
      'custom_surcharge3': 'Персонализирано доплащане 3',
      'custom_surcharge4': 'Персонализирано доплащане 4',
      'is_deleted': 'Е изтрита',
      'vendor_city': 'Доставчик - град',
      'vendor_state': 'Доставчик - щат',
      'vendor_country': 'Доставчик - държава',
      'is_approved': 'Е одобрена',
      'tax_name': 'Има на такса',
      'tax_amount': 'Такса',
      'tax_paid': 'Платена такса',
      'payment_amount': 'Сума на плащане',
      'age': 'Издадена преди',
      'is_running': 'Изпълнява се',
      'time_log': 'Лог за време',
      'bank_id': 'Банка',
      'expense_category_id': 'Идентификатор на категорията на разходите',
      'expense_category': 'Категория разход',
      'invoice_currency_id': 'Идент. № на валутата на фактурата',
      'tax_name1': 'Данъчно наименование 1',
      'tax_name2': 'Данъчно наименование 2',
      'tax_name3': 'Данъчно име 3',
      'transaction_id': 'Номер на транзакцията',
      'status_color_theme': 'Цветна тема за състоянието',
      'load_color_theme': 'Заредете цветна тема',
    },
    'zh_TW': {
      'location': '地點',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Location Deleted',
      'added_location': 'Successfully added location',
      'updated_location': 'Updated Location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': '地點',
      'preference_product_notes_for_html_view': 'Use Item Notes for HTML View',
      'preference_product_notes_for_html_view_help':
          'Preference the item Description over the item title if displaying the invoice in HTML.',
      'in_stock_quantity': '庫存數量',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update': 'Allow clients to update their profile',
      'enable_client_profile_update_help':
          'Allow clients to update their profile information from the client portal',
      'participant': '參加者',
      'merged_vendors': '成功合併供應商',
      'activity_146': ':client的電子發票:invoice已成功交付！ ：筆記',
      'activity_147': ':client的電子發票:invoice交付失敗。 :notes',
      'activity_148': '從:vendor收到的電子費用:expense',
      'payment_failed': '付款失敗',
      'activity_141': '使用者:user輸入註解: :notes',
      'activity_142': '報價:quote提醒 1 已發送',
      'activity_143': '發票:invoice的自動計費成功',
      'activity_144': '發票:invoice的自動計費失敗。 ：筆記',
      'activity_145': ':client的電子發票:invoice已發送。 ：筆記',
      'ssl_host_override': 'SSL 主機覆蓋',
      'upload_logo_short': '上傳標誌',
      'show_pdfhtml_on_mobile_help': '為了改善視覺化效果，在行動裝置上查看時顯示 HTML 版本的發票/報價。',
      'accept_purchase_order': '接受採購訂單',
      'one_page_checkout': '一頁結帳',
      'one_page_checkout_help': '啟用新的單頁支付流程',
      'applies_to': '適用於',
      'purchase_order_items': '採購訂單項目',
      'assigned_group': '成功分配組',
      'assign_group': '分配群組',
      'merge_to_pdf': '合併為 PDF',
      'emails': '電子郵件',
      'latest_requires_php_version': '注意：最新版本需要 PHP :version',
      'quote_reminder1': '首次報價提醒',
      'before_valid_until': '有效期限至之前',
      'after_valid_until': '有效期限後至',
      'after_quote_date': '報價日期後',
      'remind_quote': '提醒報價',
      'task_assigned_notification': '任務分配通知',
      'task_assigned_notification_help': '分配任務時發送電子郵件',
      'invoices_locked_end_of_month': '發票在月底被鎖定',
      'end_of_month': '月底',
      'referral_url': '推薦網址',
      'referral_program': '推薦計劃',
      'comment': 'Comment',
      'add_comment': '新增評論',
      'added_comment': '已成功儲存評論',
      'disconnected': '已斷開連接',
      'reconnect': '重新連接',
      'e_invoice_settings': '電子發票設定',
      'calculate': '計算',
      'sum': '和',
      'money': '錢',
      'time': '時間',
      'format': '格式',
      'web_app': '網頁應用程式',
      'desktop_app': '桌面應用程式',
      'invoice_net_amount': '發票淨額',
      'round_to_seconds': '四捨五入到秒',
      '1_minute': '1分鐘',
      '5_minutes': '5分鐘',
      '15_minutes': '15 分鐘',
      '30_minutes': '30分鐘',
      '1_hour': '1小時',
      '1_day': '1 天',
      'round_tasks': '任務舍入方向',
      'round_tasks_help': '向上或向下舍入任務時間。',
      'direction': '方向',
      'round_up': '圍捕',
      'round_down': '向下舍入',
      'task_round_to_nearest': '舍入到最近的值',
      'activity_139': '費用:expense通知已發送至:contact',
      'activity_140': '聲明已發送至:client',
      'bulk_updated': '數據更新成功',
      'bulk_update': '大量更新',
      'advanced_cards': '高級卡',
      'always_show_required_fields': '始終顯示必填欄位表單',
      'always_show_required_fields_help': '結帳時始終顯示必填欄位表單',
      'flutter_web_warning': '我們建議使用新的網頁應用程式或桌面應用程式以獲得最佳效能',
      'rappen_rounding': '拉彭舍入',
      'rappen_rounding_help': '金額為 5 美分',
      'check_credentials': '檢查憑證',
      'valid_credentials': '憑證有效',
      'invalid_credentials': '這些憑證不符我們的紀錄',
      'e_quote': '電子報價',
      'e_credit': '電子信貸',
      'e_purchase_order': '電子採購訂單',
      'valid_vat_number': '有效增值稅號',
      'use_available_payments': '使用可用付款',
      'test_email_sent': '已成功發送電子郵件',
      'send_test_email': '發送測試電子郵件',
      'gateway_type': '網關類型',
      'please_select_an_invoice_or_credit': '請選擇發票或信用證',
      'mobile_version': '手機版',
      'venmo': '文莫',
      'mercado_pago': '梅爾卡多帕戈',
      'my_bank': '網路商家',
      'pay_later': '以後支付',
      'email_report': '電子郵件報告',
      'host': '主機',
      'port': '埠',
      'encryption': '加密',
      'local_domain': '本地域',
      'verify_peer': '驗證對等點',
      'username': '使用者名稱',
      'nordigen_help': '注意：連接帳戶需要 GoCardless/Nordigen API 金鑰',
      'participant_name': '參加者姓名',
      'yodlee_regions': '地區：美國、英國、澳洲和印度',
      'nordigen_regions': '地區： 歐洲和英國',
      'select_provider': '選擇提供者',
      'payment_type_credit': '付款方式 信用證',
      'payment_type_debit': '付款類型 金融卡',
      'send_emails_to': '發送電子郵件至',
      'primary_contact': '主要聯絡人',
      'all_contacts': '所有聯絡人',
      'insert_below': '在下面插入',
      'ar_detailed': '應收帳款明細',
      'ar_summary': '應收帳款匯總',
      'client_sales': '客戶銷售',
      'tax_summary': '稅務摘要',
      'user_sales': '用戶銷售',
      'run_template': '運行模板',
      'task_extension_banner': '新增 Chrome 擴充功能來管理您的任務',
      'watch_video': '看影片',
      'view_extension': '查看擴充',
      'reactivate_email': '重新啟動電子郵件',
      'email_reactivated': '已成功重新啟動電子郵件',
      'template_help': '允許使用設計作為模板',
      'delivery_note_design': '送貨單設計',
      'statement_design': '聲明設計',
      'payment_receipt_design': '付款收據設計',
      'payment_refund_design': '付款退款設計',
      'quarter': '四分之一',
      'item_description': '商品描述',
      'task_item': '任務項',
      'record_state': '記錄狀態',
      'last_login': '上次登入',
      'save_files_to_this_folder': '將檔案儲存到此資料夾',
      'downloads_folder': '下載資料夾',
      'total_invoiced_quotes': '發票報價',
      'total_invoice_paid_quotes': '發票已付報價',
      'downloads_folder_does_not_exist': '下載資料夾不存在:value',
      'user_logged_in_notification': '用戶登入通知',
      'user_logged_in_notification_help': '從新位置登入時發送電子郵件',
      'client_contact': '客戶聯繫',
      'expense_status_4': '未付',
      'expense_status_5': '有薪資的',
      'recurring': '週期性',
      'ziptax_help': '注意：此功能需要 Zip-Tax API 金鑰才能按地址查找美國銷售稅',
      'cache_data': '快取數據',
      'unknown': '未知',
      'webhook_failure': 'Webhook 失敗',
      'email_opened': '電子郵件已開啟',
      'email_delivered': '電子郵件已送達',
      'log': '紀錄',
      'individual': '個人',
      'partnership': '合夥',
      'trust': '相信',
      'charity': '慈善機構',
      'government': '政府',
      'classification': '分類',
      'click_or_drop_files_here': '點擊或將檔案拖放到此處',
      'public': '民眾',
      'private': '私人的',
      'image': '影像',
      'other': '其他',
      'hash': '哈希值',
      'linked_to': '連結到',
      'file_saved_in_path': '文件已保存在 :path 中',
      'unlinked_transactions': '已成功取消連結:count事務',
      'unlinked_transaction': '成功取消關聯交易',
      'unlink': '取消連結',
      'view_dashboard_permission': '允許使用者存取儀表板，資料僅限於可用權限',
      'is_tax_exempt': '免稅',
      'district': '區',
      'region': '地區',
      'county': '縣',
      'tax_details': '稅務詳情',
      'activity_10_online': ':contact已為:client的發票:payment付款:invoice',
      'activity_10_manual': ':user輸入了發票:payment的付款:invoice的:client',
      'default_payment_type': '預設付款類型',
      'admin_initiated_payments': '管理員發起付款',
      'admin_initiated_payments_help': '支援在管理入口網站中輸入付款而無需發票',
      'use_mobile_to_manage_plan': '使用您的手機訂閱設定來管理您的計劃',
      'show_task_billable': '顯示可計費任務',
      'credit_item': '信用項目',
      'files': '文件',
      'camera': '相機',
      'gallery': '畫廊',
      'email_count_invoices': '透過電子郵件發送:count發票',
      'project_location': '專案地點',
      'invoice_task_item_description': '發票任務項目說明',
      'invoice_task_item_description_help': '將項目描述新增至發票行項目',
      'next_send_time': '下次發送時間',
      'uploaded_certificate': '憑證上傳成功',
      'certificate_set': '憑證套',
      'certificate_not_set': '證書未設定',
      'passphrase_set': '密碼短語集',
      'passphrase_not_set': '未設定密碼',
      'upload_certificate': '上傳證書',
      'certificate_passphrase': '證書密碼',
      'rename': '改名',
      'renamed_document': '文檔重命名成功',
      'e_invoice': '電子發票',
      'light_dark_mode': '明/暗模式',
      'activities': '活動',
      'routing_id': '路由ID',
      'enable_e_invoice': '啟用電子發票',
      'e_invoice_type': '電子發票類型',
      'e_quote_type': '電子報價類型',
      'reduced_tax': '減稅',
      'override_tax': '覆蓋稅',
      'zero_rated': '零評級',
      'reverse_tax': '反向稅',
      'updated_tax_category': '已成功更新稅種',
      'updated_tax_categories': '已成功更新稅種',
      'set_tax_category': '設定稅種',
      'payment_manual': '付款手冊',
      'tax_category': '稅種',
      'physical_goods': '實體商品',
      'digital_products': '數位產品',
      'services': '服務',
      'shipping': '船運',
      'tax_exempt': '免稅',
      'reduced_rate': '降低費率',
      'tax_all': '全部徵稅',
      'tax_selected': '已選擇稅',
      'version': '版本',
      'seller_subregion': '賣家分區',
      'calculate_taxes': '計算稅金',
      'calculate_taxes_help': '儲存發票時自動計算稅費',
      'admin': '管理者',
      'owner': '擁有者',
      'link_expenses': '連結費用',
      'converted_client_balance': '轉換後的客戶餘額',
      'converted_payment_balance': '轉換後的付款餘額',
      'total_hours': '全部小時數',
      'date_picker_hint': '使用 +days 設定未來的日期',
      'browser_pdf_viewer': '使用瀏覽器 PDF 檢視器',
      'browser_pdf_viewer_help': '警告：阻止透過 PDF 與應用程式交互',
      'increase_prices': '提高價格',
      'update_prices': '更新價格',
      'incresed_prices': '成功排隊等待漲價',
      'updated_prices': '已成功排隊等待更新價格',
      'bacs': 'BACS 直接借記',
      'api_token': 'API令牌',
      'api_key': 'API金鑰',
      'endpoint': '端點',
      'billable': '可結帳的',
      'not_billable': '不可計費',
      'allow_billable_task_items': '允許計費任務項目',
      'allow_billable_task_items_help': '啟用配置對哪些任務項目進行計費',
      'show_task_item_description': '顯示任務項目描述',
      'show_task_item_description_help': '啟用指定任務項目描述',
      'email_record': '郵件記錄',
      'invoice_product_columns': '發票產品欄',
      'quote_product_columns': '報價產品欄',
      'minimum_payment_amount': '最低付款金額',
      'client_initiated_payments': '客戶發起的付款',
      'client_initiated_payments_help': '支援在客戶入口網站中進行無發票付款',
      'share_invoice_quote_columns': '共享發票/報價欄',
      'cc_email': '副本電子郵件',
      'payment_balance': '付款餘額',
      'view_report_permission': '允許使用者存取報告，數據僅限於可用權限',
      'activity_138': '付款:payment已透過電子郵件發送至:client',
      'one_time_products': '一次性產品',
      'optional_one_time_products': '可選的一次性產品',
      'required': '必需的',
      'hidden': '隱',
      'payment_links': '付款連結',
      'action': '動作',
      'upgrade_to_paid_plan_to_schedule': '升級到付費計劃以創建時間表',
      'next_run': '下次運行',
      'all_clients': '所有客戶',
      'show_aging_table': '顯示老化表',
      'show_payments_table': '顯示付款表',
      'only_clients_with_invoices': '僅限有發票的客戶',
      'email_statement': '電子郵件聲明',
      'once': '一次',
      'schedule': '時間表',
      'schedules': '時間表',
      'new_schedule': '新時間表',
      'edit_schedule': '編輯日程',
      'created_schedule': '已成功建立時間表',
      'updated_schedule': '已成功更新時間表',
      'archived_schedule': '已成功存檔時間表',
      'deleted_schedule': '已成功刪除行程',
      'removed_schedule': '已成功刪除行程',
      'restored_schedule': '已成功復原行程',
      'search_schedule': '搜尋時間表',
      'search_schedules': '搜尋時間表',
      'archive_payment': '存檔付款',
      'archive_invoice': '存檔發票',
      'archive_quote': '歸檔報價單',
      'archive_credit': '檔案信用',
      'archive_task': '歸檔任務項目',
      'archive_client': '存檔客戶端',
      'archive_project': '歸檔專案',
      'archive_expense': '歸檔支出資料',
      'restore_payment': '復原付款資料',
      'restore_invoice': '復原發票',
      'restore_quote': '復原報價單',
      'restore_credit': '復原貸款資料',
      'restore_task': '復原任務',
      'restore_client': '復原用戶',
      'restore_project': '復原之專案',
      'restore_expense': '復原支出資料',
      'archive_vendor': '歸檔供應商',
      'restore_vendor': '復原供應商',
      'create_product': '加入產品',
      'update_product': '更新產品',
      'delete_product': '刪除貸款資料',
      'restore_product': '復原產品資料',
      'archive_product': '歸檔產品資料',
      'create_purchase_order': '建立採購訂單',
      'update_purchase_order': '更新採購訂單',
      'delete_purchase_order': '刪除採購訂單',
      'restore_purchase_order': '恢復採購訂單',
      'archive_purchase_order': '存檔採購訂單',
      'sent_invoice': '已發送發票',
      'sent_quote': '已發送報價',
      'sent_credit': '發送信用證',
      'sent_purchase_order': '發送採購訂單',
      'image_url': '圖片網址',
      'max_quantity': '最大數量',
      'test_url': '測試網址',
      'auto_bill_help_off': '選項未顯示',
      'auto_bill_help_optin': '顯示選項但未選擇',
      'auto_bill_help_optout': '顯示並選擇選項',
      'auto_bill_help_always': '選項未顯示',
      'payment_methods': '付款方式',
      'view_all': '看全部',
      'edit_all': '全部編輯',
      'accept_purchase_order_number': '接受採購訂單編號',
      'accept_purchase_order_number_help': '使客戶能夠在批准報價時提供採購訂單編號',
      'from_email': '來自電子郵件',
      'show_preview': '顯示預覽',
      'show_paid_stamp': '顯示付費郵票',
      'show_shipping_address': '顯示送貨地址',
      'no_documents_to_download': '所選記錄中沒有可供下載的文檔',
      'pixels': '像素',
      'logo_size': '標誌尺寸',
      'postal_city': '郵政/城市',
      'failed': '失敗的',
      'client_contacts': '客戶聯絡方式',
      'sync_from': '同步自',
      'inventory_threshold': '庫存閾值',
      'hour': '時',
      'emailed_statement': '已成功排隊要傳送的語句',
      'show_email_footer': '顯示電子郵件頁腳',
      'invoice_task_hours': '發票任務時間',
      'invoice_task_hours_help': '將小時數加入發票行項目',
      'auto_bill_standard_invoices': '自動帳單標準發票',
      'auto_bill_recurring_invoices': '自動開立定期發票',
      'email_alignment': '電子郵件對齊',
      'pdf_preview_location': 'PDF 預覽位置',
      'mailgun': '郵件槍',
      'postmark': '郵戳',
      'microsoft': '微軟',
      'click_plus_to_create_record': '點擊+建立記錄',
      'last365_days': '過去 365 天',
      'import_design': '導入設計',
      'imported_design': '成功導入設計',
      'invalid_design': '設計無效，缺:value部分',
      'setup_wizard_logo': '您想上傳您的徽標嗎？',
      'upload': '上傳',
      'installed_version': '安裝版本',
      'notify_vendor_when_paid': '付款後通知供應商',
      'notify_vendor_when_paid_help': '當費用標記為已付款時，向供應商發送電子郵件',
      'update_payment': '更新付款方式',
      'markup': '標記',
      'purchase_order_created': '已建立採購訂單',
      'purchase_order_sent': '採購訂單已發送',
      'purchase_order_viewed': '查看採購訂單',
      'purchase_order_accepted': '採購訂單已接受',
      'credit_payment_error': '信用金額不能大於付款金額',
      'klarna': '克拉納',
      'convert_payment_currency_help': '輸入手動付款時設定匯率',
      'convert_expense_currency_help': '創建費用時設定匯率',
      'matomo_url': '馬托網址',
      'matomo_id': '馬托莫 ID',
      'action_add_to_invoice': '新增到發票',
      'online_payment_email_help': '線上付款時發送電子郵件',
      'manual_payment_email_help': '手動輸入付款時發送電子郵件',
      'mark_paid_payment_email_help': '將發票標記為已付款時發送電子郵件',
      'delete_project': '刪除專案',
      'linked_transaction': '關聯交易成功',
      'link_payment': '連結支付',
      'link_expense': '鏈路費用',
      'lock_invoiced_tasks': '鎖定開票任務',
      'lock_invoiced_tasks_help': '防止任務在開立發票後被編輯',
      'registration_required': '需要註冊',
      'registration_required_help': '要求客戶註冊',
      'use_inventory_management': '使用庫存管理',
      'use_inventory_management_help': '要求產品有庫存',
      'optional_products': '可選產品',
      'optional_recurring_products': '可選的經常性產品',
      'convert_matched': '轉變',
      'auto_billed_invoice': '已成功排隊發票以自動計費',
      'auto_billed_invoices': '已成功將發票排隊以自動計費',
      'operator': '操作員',
      'value': '價值',
      'is': '是',
      'contains': '包含',
      'starts_with': '以。。開始',
      'is_empty': '是空的',
      'add_rule': '新增規則',
      'match_all_rules': '符合所有規則',
      'match_all_rules_help': '所有條件都需要符合才能應用規則',
      'auto_convert_help': '自動將匹配交易轉換為費用',
      'rules': '規則',
      'transaction_rule': '交易規則',
      'transaction_rules': '交易規則',
      'new_transaction_rule': '新交易規則',
      'edit_transaction_rule': '編輯交易規則',
      'created_transaction_rule': '規則創建成功',
      'updated_transaction_rule': '交易規則更新成功',
      'archived_transaction_rule': '交易規則存檔成功',
      'deleted_transaction_rule': '成功刪除交易規則',
      'removed_transaction_rule': '成功刪除交易規則',
      'restored_transaction_rule': '交易規則恢復成功',
      'search_transaction_rule': '搜尋交易規則',
      'search_transaction_rules': '搜尋交易規則',
      'save_as_default_terms': '儲存為預設條款',
      'save_as_default_footer': '儲存為預設的頁尾',
      'auto_sync': '自動同步',
      'refresh_accounts': '刷新帳戶',
      'upgrade_to_connect_bank_account': '升級至企業版以連結您的銀行帳戶',
      'click_here_to_connect_bank_account': '按此連接您的銀行帳戶',
      'disable_2fa': '停用 2FA',
      'change_number': '更改號碼',
      'resend_code': '重新發送驗證碼',
      'base_type': '底座類型',
      'category_type': '類別類型',
      'bank_transaction': '交易',
      'bulk_print': '列印 PDF',
      'vendor_postal_code': '供應商郵遞區號',
      'preview_location': '預覽地點',
      'bottom': '底部',
      'side': '邊',
      'pdf_preview': 'PDF預覽',
      'long_press_to_select': '長按選擇',
      'purchase_order_number': '訂購單號',
      'purchase_order_item': '採購訂單項目',
      'would_you_rate_the_app': '您想評價該應用程式嗎？',
      'include_deleted': '包括已刪除',
      'include_deleted_help': '在報告中包含已刪除的記錄',
      'due_on': '由於上',
      'converted_transactions': '交易成功轉換',
      'created_bank_account': '已成功建立銀行帳號',
      'updated_bank_account': '更新銀行帳號成功',
      'edit_bank_account': '編輯銀行帳號',
      'default_category': '預設類別',
      'account_type': '帳戶類型',
      'new_bank_account': '新增銀行帳戶',
      'connect_accounts': '連接帳戶',
      'manage_rules': '管理規則',
      'search_category': '搜尋 1 類別',
      'search_categories': '搜尋:count類別',
      'min_amount': '最低金額',
      'max_amount': '最大金額',
      'selected': '已選的',
      'converted_transaction': '交易成功轉換',
      'convert_to_payment': '轉換為付款',
      'deposit': '訂金',
      'withdrawal': '退出',
      'deposits': '存款',
      'withdrawals': '提款',
      'matched': '匹配的',
      'unmatched': '無與倫比',
      'create_credit': '創造信用',
      'update_credit': '更新貸款資料',
      'delete_credit': '刪除信用',
      'transaction': '交易',
      'transactions': '交易',
      'new_transaction': '新交易',
      'edit_transaction': '編輯交易',
      'created_transaction': '交易創建成功',
      'updated_transaction': '交易更新成功',
      'archived_transaction': '已成功存檔交易',
      'deleted_transaction': '成功刪除交易',
      'removed_transaction': '成功刪除交易',
      'restored_transaction': '交易恢復成功',
      'search_transaction': '搜尋交易',
      'search_transactions': '搜尋:count交易',
      'bank_account': '銀行帳戶',
      'bank_accounts': '信用卡與銀行',
      'archived_bank_account': '歸檔銀行帳號成功',
      'deleted_bank_account': '已成功刪除銀行帳戶',
      'removed_bank_account': '已成功刪除銀行帳戶',
      'restored_bank_account': '已成功恢復銀行帳戶',
      'search_bank_account': '搜尋銀行帳戶',
      'search_bank_accounts': '搜尋:count銀行帳戶',
      'connect': '連接',
      'mark_paid_payment_email': '標記已付款電子郵件',
      'convert_to_project': '轉換為項目',
      'client_email': '客戶信箱',
      'invoice_task_project': '發票任務項目',
      'invoice_task_project_help': '將項目新增至發票行項目',
      'field': '場地',
      'period': '時期',
      'fields_per_row': '每行字段數',
      'total_active_invoices': '有效發票',
      'total_outstanding_invoices': '過期未付支票',
      'total_completed_payments': '已完成付款',
      'total_refunded_payments': '退款',
      'total_active_quotes': '活躍行情',
      'total_approved_quotes': '核准的報價',
      'total_unapproved_quotes': '未經批准的報價',
      'total_logged_tasks': '記錄的任務',
      'total_invoiced_tasks': '開立發票的任務',
      'total_paid_tasks': '有償任務',
      'total_logged_expenses': '記錄的費用',
      'total_pending_expenses': '待處理費用',
      'total_invoiced_expenses': '已開立發票的費用',
      'total_invoice_paid_expenses': '發票支付費用',
      'activity_130': ':user建立採購訂單:purchase_order',
      'activity_131': ':user更新的採購訂單:purchase_order',
      'activity_132': ':user已歸檔採購訂單:purchase_order',
      'activity_133': ':user已刪除採購訂單:purchase_order',
      'activity_134': ':user恢復採購訂單:purchase_order',
      'activity_135': ':user透過電子郵件發送採購訂單:purchase_order',
      'activity_136': ':contact查看採購訂單:purchase_order',
      'activity_137': ':contact已接受採購訂單:purchase_order',
      'vendor_portal': '供應商入口網站',
      'send_code': '傳送代碼',
      'save_to_upload_documents': '儲存上傳文檔記錄',
      'expense_tax_rates': '費用稅率',
      'invoice_item_tax_rates': '發票項目稅率',
      'verified_phone_number': '手機號碼驗證成功',
      'code_was_sent': '代碼已透過簡訊發送',
      'code_was_sent_to': '代碼已透過簡訊發送至:number',
      'resend': '重發',
      'verify': '核實',
      'enter_phone_number': '請提供電話號碼',
      'invalid_phone_number': '無效的電話號碼',
      'verify_phone_number': '驗證電話號碼',
      'verify_phone_number_help': '請驗證您的電話號碼以發送電子郵件',
      'verify_phone_number_2fa_help': '請驗證您的電話號碼以進行 2FA 備份',
      'merged_clients': '成功合併客戶',
      'merge_into': '合併到',
      'merge': '合併',
      'price_change_accepted': '接受價格變更',
      'price_change_failed': '價格更改失敗並顯示代碼',
      'restore_purchases': '恢復購買',
      'activate': '啟用',
      'connect_apple': '連接蘋果',
      'disconnect_apple': '斷開蘋果連接',
      'disconnected_apple': '成功斷開蘋果連接',
      'send_now': '現在發送',
      'received': '已收到',
      'purchase_order_date': '採購訂單日期',
      'converted_to_expense': '成功轉為費用',
      'converted_to_expenses': '成功轉為費用',
      'convert_to_expense': '轉換為費用',
      'add_to_inventory': '新增到庫存',
      'added_purchase_order_to_inventory': '已成功將採購訂單新增至庫存',
      'added_purchase_orders_to_inventory': '已成功將採購訂單新增至庫存',
      'client_document_upload': '客戶文件上傳',
      'vendor_document_upload': '供應商文件上傳',
      'vendor_document_upload_help': '允許供應商上傳文檔',
      'are_you_enjoying_the_app': '您喜歡這個應用程式嗎？',
      'yes_its_great': '是的這很好！',
      'not_so_much': '沒那麼多',
      'would_you_rate_it': '很高興聽到！您願意評價一下嗎？',
      'would_you_tell_us_more': '很抱歉聽到這個消息！您願意告訴我們更多嗎？',
      'sure_happy_to': '當然，很高興',
      'no_not_now': '不，現在不行',
      'add': '添加',
      'last_sent_template': '最後發送的模板',
      'enable_flexible_search': '啟用靈活搜尋',
      'enable_flexible_search_help': '匹配不連續的字符，即。 “ct”匹配“貓”',
      'vendor_details': '供應商詳情',
      'purchase_order_details': '採購訂單詳細信息',
      'qr_iban': 'QR 圖碼 IBAN',
      'besr_id': 'BESR ID',
      'accept': '接受',
      'clone_to_purchase_order': '克隆到 PO',
      'vendor_email_not_set': '供應商沒有設定電子郵件地址',
      'bulk_send_email': '發電子郵件',
      'marked_purchase_order_as_sent': '已成功將採購訂單標記為已發送',
      'marked_purchase_orders_as_sent': '已成功將採購訂單標記為已發送',
      'accepted_purchase_order': '成功接受採購訂單',
      'accepted_purchase_orders': '成功接受採購訂單',
      'cancelled_purchase_order': '已成功取消採購訂單',
      'cancelled_purchase_orders': '已成功取消採購訂單',
      'accepted': '公認',
      'please_select_a_vendor': '請選擇供應商',
      'purchase_order_total': '採購訂單總計',
      'email_purchase_order': '電子郵件採購訂單',
      'bulk_email_purchase_orders': '透過電子郵件發送採購訂單',
      'disconnected_email': '成功斷開電子郵件連接',
      'connect_email': '連線電子郵件',
      'disconnect_email': '斷開電子郵件連接',
      'use_web_app_to_connect_microsoft': '請使用網頁應用程式連接到 Microsoft',
      'email_provider': '電子郵件提供者',
      'connect_microsoft': '連接微軟',
      'disconnect_microsoft': '斷開與微軟的連接',
      'connected_microsoft': '已成功連接微軟',
      'disconnected_microsoft': '已成功斷開 Microsoft 的連接',
      'microsoft_sign_in': '使用微軟登入',
      'microsoft_sign_up': '與微軟註冊',
      'emailed_purchase_order': '已成功排隊待發送的採購訂單',
      'emailed_purchase_orders': '已成功排隊待發送的採購訂單',
      'enable_react_app': '變更為 React Web 應用程式',
      'purchase_order_design': '採購訂單設計',
      'purchase_order_terms': '採購訂單條款',
      'purchase_order_footer': '採購訂單頁腳',
      'require_purchase_order_signature': '採購訂單簽名',
      'require_purchase_order_signature_help': '要求供應商提供簽名。',
      'purchase_order': '採購訂單',
      'purchase_orders': '訂單',
      'new_purchase_order': '新採購訂單',
      'edit_purchase_order': '編輯採購訂單',
      'created_purchase_order': '採購訂單建立成功',
      'updated_purchase_order': '已成功更新採購訂單',
      'archived_purchase_order': '已成功歸檔採購訂單',
      'deleted_purchase_order': '已成功刪除採購訂單',
      'removed_purchase_order': '已成功刪除採購訂單',
      'restored_purchase_order': '已成功恢復採購訂單',
      'search_purchase_order': '搜尋採購訂單',
      'search_purchase_orders': '搜尋採購訂單',
      'login_url': '登入網址',
      'payment_settings': '付款設定',
      'default': '預設',
      'stock_quantity': '庫存數量',
      'notification_threshold': '通知閾值',
      'track_inventory': '追蹤庫存',
      'track_inventory_help': '顯示產品庫存欄位並在發送發票時更新',
      'stock_notifications': '庫存通知',
      'stock_notifications_help': '庫存達到閾值時發送電子郵件',
      'vat': '加值稅',
      'standing': '資格',
      'view_map': '查看地圖',
      'set_default_design': '設定預設設計',
      'add_gateway': '新增支付網關',
      'add_gateway_help_message': '新增支付網關（即 Stripe、WePay 或 PayPal）以接受線上支付',
      'left': '左邊',
      'right': '正確的',
      'center': '中心',
      'page_numbering': '頁碼',
      'page_numbering_alignment': '頁碼對齊',
      'invoice_sent_notification_label': '發票已發送',
      'show_product_description': '顯示產品說明',
      'show_product_description_help': '在產品下拉清單中包含描述',
      'invoice_items': '發票項目',
      'quote_items': '報價項目',
      'profitloss': '收益與損失',
      'import_format': '導入格式',
      'export_format': '導出格式',
      'export_type': '出口類型',
      'stop_on_unpaid': '停止未付款',
      'stop_on_unpaid_help': '如果最後一張發票未付款，請停止建立定期發票。',
      'use_quote_terms': '使用報價條款',
      'use_quote_terms_help': '將報價單轉換為發票時',
      'add_country': '新增國家/地區',
      'enable_tooltips': '啟用工具提示',
      'enable_tooltips_help': '滑鼠懸停時顯示工具提示',
      'multiple_client_error': '錯誤：記錄屬於多個客戶',
      'register_label': '在幾秒鐘內建立您的帳戶',
      'login_label': '登入現有帳戶',
      'add_to_invoice': '新增至發票 :invoice',
      'no_invoices_found': '沒有找到發票',
      'week': '星期',
      'created_record': '記錄創建成功',
      'auto_archive_paid_invoices': '自動存檔付費',
      'auto_archive_paid_invoices_help': '付款後自動存檔發票。',
      'auto_archive_cancelled_invoices': '自動存檔已取消',
      'auto_archive_cancelled_invoices_help': '取消時自動存檔發票。',
      'alternate_pdf_viewer': '備用 PDF 檢視器',
      'alternate_pdf_viewer_help': '改進 PDF 預覽的滾動功能 [BETA]',
      'invoice_currency': '發票使用的貨幣',
      'range': 'Range',
      'tax_amount1': '稅額1',
      'tax_amount2': '稅額2',
      'tax_amount3': '稅額3',
      'create_project': '建立專案',
      'update_project': '更新項目',
      'view_task': '查看任務',
      'cancel_invoice': '取消',
      'changed_status': '已成功更改任務狀態',
      'change_status': '更改狀態',
      'fees_sample': ':amount 份發票的費用應為 :total。',
      'enable_touch_events': '啟用觸控事件',
      'enable_touch_events_help': '支援拖曳事件滾動',
      'after_saving': '儲存後',
      'view_record': '查看記錄',
      'enable_email_markdown': '啟用電子郵件 Markdown',
      'enable_email_markdown_help': '使用視覺化 Markdown 編輯器處理電子郵件',
      'enable_pdf_markdown': '啟用 PDF Markdown',
      'json_help': '注意：不支援 v4 應用程式產生的 JSON 文件',
      'release_notes': '發行說明',
      'upgrade_to_view_reports': '升級您的計劃以查看報告',
      'started_tasks': '成功啟動:value任務',
      'stopped_tasks': '成功停止:value任務',
      'approved_quote': '報價已成功批准',
      'approved_quotes': '已成功:value核准報價',
      'approve': '同意',
      'client_website': '客戶網站',
      'invalid_time': '無效時間',
      'client_shipping_state': '客戶運輸狀態',
      'client_shipping_city': '客戶出貨城市',
      'client_shipping_postal_code': '客戶出貨郵遞區號',
      'client_shipping_country': '客戶出貨國家/地區',
      'load_pdf': '載入 PDF',
      'start_free_trial': '開啟免費體驗',
      'start_free_trial_message': '開始 14 天免費試用 Pro 計劃',
      'due_on_receipt': '收據到期',
      'is_paid': '已經付款了',
      'age_group_paid': '有薪資的',
      'id': 'ID',
      'convert_to': '轉換成',
      'client_currency': '客戶貨幣',
      'company_currency': '公司貨幣',
      'purged_client': '清除用戶成功',
      'custom_emails_disabled_help': '為了防止垃圾郵件，我們需要升級到付費帳戶來自訂電子郵件',
      'upgrade_to_add_company': '升級您的計劃以添加公司',
      'small': '小的',
      'marked_credit_as_paid': '已成功將信用標記為已付款',
      'marked_credits_as_paid': '已成功將積分標記為已付款',
      'wait_for_loading': '資料載入 - 請等待完成',
      'wait_for_saving': '資料保存 - 請等待完成',
      'html_preview_warning': '注意：此處所做的更改只能預覽，必須在上面的選項卡中應用才能保存',
      'remaining': '其餘的',
      'invoice_paid': '發票已付',
      'activity_120': ':user創建經常性費用:recurring_expense',
      'activity_121': ':user更新經常性費用:recurring_expense',
      'activity_122': ':user存檔的經常性費用:recurring_expense',
      'activity_123': ':user刪除經常性費用:recurring_expense',
      'activity_124': ':user恢復經常性費用:recurring_expense',
      'normal': '普通的',
      'large': '大的',
      'extra_large': '特大號',
      'show_pdf_preview': '顯示 PDF 預覽',
      'show_pdf_preview_help': '編輯發票時顯示 PDF 預覽',
      'print_pdf': '列印 PDF',
      'remind_me': '提醒我',
      'instant_bank_pay': '即時銀行支付',
      'click_selected': '按一下選定',
      'hide_preview': '隱藏預覽',
      'edit_record': '編輯記錄',
      'credit_is_more_than_invoice': '信用金額不能超過發票金額',
      'giropay': '匯路支付',
      'direct_debit': '直接借記',
      'please_set_a_password': '請設定帳戶密碼',
      'set_password': '設定密碼',
      'disconnected_gateway': '成功斷開網關',
      'disconnect': '斷開',
      'add_to_invoices': '新增到發票',
      'acss': 'ACSS 金融卡',
      'becs': 'BECS 直接扣記',
      'bulk_download': '下載',
      'persist_data_help': '在本地保存資料以使應用程式能夠更快地啟動，禁用可能會提高大型帳戶的效能',
      'persist_ui': '保留使用者介面',
      'persist_ui_help': '在本機上保存 UI 狀態以使應用程式能夠在上次位置啟動，停用可能會提高效能',
      'client_postal_code': '客戶郵遞區號',
      'client_vat_number': '客戶增值稅號',
      'has_tasks': '有任務',
      'registration': '登記',
      'unauthorized_stripe_warning': '請授權 Stripe 接受線上付款。',
      'view_expense': '檢視支出 # :expense',
      'view_statement': '檢視財務報表',
      'sepa': 'SEPA Direct Debit',
      'ideal': '理想的',
      'przelewy24': '普澤萊維24',
      'eps': '每股盈餘',
      'fpx': 'FPX',
      'update_all_records': '更新所有記錄',
      'system': '系統',
      'set_default_company': '設定預設公司',
      'updated_company': '公司更新成功',
      'kbc': '韓國廣播公司',
      'bancontact': '聯繫銀行',
      'why_are_you_leaving': '告訴我們原因，幫助我們改進（可選）',
      'webhook_success': 'Webhook 成功',
      'error_cross_client_tasks': '任務必須全部屬於同一個客戶端',
      'error_cross_client_expenses': '費用必須全部屬於同一客戶',
      'app': '應用程式',
      'for_best_performance': '為了獲得最佳性能，請下載:app應用程式',
      'gross_line_total': '總行總計',
      'bulk_email_invoices': '電子郵件發票',
      'bulk_email_quotes': '電子郵件報價',
      'bulk_email_credits': '電子郵件積分',
      'from_name': '按照姓名',
      'clone_to_expense': '克隆到費用',
      'recurring_expense': '週期性支出',
      'recurring_expenses': '週期性支出',
      'new_recurring_expense': '新的週期性支出',
      'edit_recurring_expense': '編輯週期性支出',
      'created_recurring_expense': '建立週期性支出成功',
      'updated_recurring_expense': '更新週期性支出成功',
      'archived_recurring_expense': '歸檔週期性支出成功',
      'deleted_recurring_expense': '已成功刪除經常性費用',
      'removed_recurring_expense': '成功消除經常性費用',
      'restored_recurring_expense': '復原週期性支出成功',
      'search_recurring_expense': '搜尋經常性費用',
      'search_recurring_expenses': '搜尋經常性費用',
      'last_sent_date': '最後發送日期',
      'include_drafts': '包括草稿',
      'include_drafts_help': '在報告中包含草稿記錄',
      'is_invoiced': '已開立發票',
      'change_plan': '管理計劃',
      'persist_data': '保留資料',
      'customer_count': '顧客數量',
      'verify_customers': '驗證客戶',
      'google_analytics': 'Googlezp 分析',
      'google_analytics_tracking_id': 'Google分析追蹤ID',
      'decimal_comma': '十進制逗號',
      'use_comma_as_decimal_place': '在表格中使用逗號作為小數位',
      'select_method': '選擇方法',
      'select_platform': '選擇平台',
      'use_web_app_to_connect_gmail': '請使用網頁應用程式連接到 Gmail',
      'expense_tax_help': '商品稅率已禁用',
      'enable_markdown': '啟用降價',
      'enable_markdown_help': '將 PDF 上的 Markdown 轉換為 HTML',
      'user_guide': '使用者指南',
      'add_second_contact': '增加第二個聯絡人',
      'previous_page': '上一頁',
      'next_page': '下一頁',
      'export_colors': '匯出顏色',
      'import_colors': '導入顏色',
      'clear_all': '全部清除',
      'contrast': '對比',
      'custom_colors': '客製化顏色',
      'colors': '顏色',
      'sidebar_active_background_color': '側邊欄活動背景顏色',
      'sidebar_active_font_color': '側邊欄活動字體顏色',
      'sidebar_inactive_background_color': '側邊欄非活動背景顏色',
      'sidebar_inactive_font_color': '側邊欄非活動字體顏色',
      'table_alternate_row_background_color': '表備用行背景顏色',
      'invoice_header_background_color': '發票標題背景顏色',
      'invoice_header_font_color': '發票標題字體顏色',
      'net_subtotal': '網',
      'review_app': '評論應用程式',
      'check_status': '檢查狀態',
      'free_trial': '免費試用',
      'free_trial_ends_in_days': 'Pro 計畫試用期將於:count天後結束，點選升級。',
      'free_trial_ends_today': '今天是Pro計畫試用的最後一天，點選升級。',
      'change_email': '更改電子郵件',
      'client_portal_domain_hint': '可以選擇配置單獨的客戶端入口網站網域',
      'tasks_shown_in_portal': '門戶中顯示的任務',
      'uninvoiced': '未開發票',
      'subdomain_guide':
          '子網域在客戶端入口網站中用於個性化連結以匹配您的品牌。即，https://your-brand.invoicing.co',
      'send_time': '發送時間',
      'import_data': '匯入資料',
      'import_settings': '導入設定',
      'json_file_missing': '請提供 JSON 文件',
      'json_option_missing': '請選擇匯入設定和/或數據',
      'json': 'JSON',
      'no_payment_types_enabled': '未啟用付款類型',
      'wait_for_data': '請等待資料載入完成',
      'net_total': '淨總值',
      'has_taxes': '有稅',
      'import_customers': '進口客戶',
      'imported_customers': '成功開始導入客戶',
      'login_success': '登入成功',
      'login_failure': '登入失敗',
      'exported_data': '文件準備好後，您將收到一封包含下載連結的電子郵件',
      'include_deleted_clients': '包括已刪除的客戶',
      'include_deleted_clients_help': '載入屬於已刪除客戶端的記錄',
      'step_1_sign_in': '第 1 步：登入',
      'step_2_authorize': '第 2 步：授權',
      'account_id': '帳戶ID',
      'migration_not_yet_completed': '遷移尚未完成',
      'activity_100': ':user創建了定期發票:recurring_invoice',
      'activity_101': ':user更新的經常性發票:recurring_invoice',
      'activity_102': ':user存檔的經常性發票:recurring_invoice',
      'activity_103': ':user刪除定期發票:recurring_invoice',
      'activity_104': ':user恢復定期發票:recurring_invoice',
      'show_task_end_date': '顯示任務結束日期',
      'show_task_end_date_help': '啟用指定任務結束日期',
      'gateway_setup': '網關設定',
      'preview_sidebar': '預覽側邊欄',
      'years_data_shown': '顯示的年份數據',
      'ended_all_sessions': '成功結束所有會話',
      'end_all_sessions': '結束所有會話',
      'count_session': '1 節課',
      'count_sessions': ':count會話',
      'invoice_created': '發票已建立',
      'quote_created': '報價已創建',
      'credit_created': '創造信用',
      'pro': '專業版',
      'enterprise': '企業',
      'last_updated': '上次更新時間',
      'invoice_item': '發票項目',
      'quote_item': '報價項目',
      'contact_first_name': '聯絡人名字',
      'contact_last_name': '聯絡人姓氏',
      'order': '命令',
      'unassigned': '未分配的',
      'partial_value': '必須大於零且小於總額',
      'search_kanban': '搜尋看板',
      'search_kanbans': '搜尋看板',
      'kanban': '看板',
      'enable': '使能夠',
      'move_top': '移至頂部',
      'move_up': '提升',
      'move_down': '下移',
      'move_bottom': '移動底部',
      'subdomain_help': '設定子網域或在您的網站上顯示發票。',
      'body_variable_missing': '錯誤：自訂電子郵件必須包含:body變量',
      'add_body_variable_message': '確保包含:body變量',
      'view_date_formats': '查看日期格式',
      'is_viewed': '已瀏覽',
      'letter': '信',
      'legal': '合法的',
      'page_layout': '頁面佈局',
      'portrait': '肖像',
      'landscape': '景觀',
      'owner_upgrade_to_paid_plan': '帳戶所有者可以升級到付費計劃以啟用高級高級設置',
      'upgrade_to_paid_plan': '升級到付費計劃以啟用高級設置',
      'invoice_payment_terms': '發票付款條款',
      'quote_valid_until': '報價有效期限至',
      'no_headers': '無標題',
      'add_header': '新增標題',
      'remove_header': '刪除標題',
      'return_url': '返回網址',
      'rest_method': '休息法',
      'header_key': '標題鍵',
      'header_value': '標頭值',
      'recurring_products': '重複產品',
      'promo_code': '促銷代碼',
      'promo_discount': '促銷折扣',
      'allow_cancellation': '允許取消',
      'per_seat_enabled': '每個席位已啟用',
      'max_seats_limit': '最大座位數限制',
      'trial_enabled': '試用已啟用',
      'trial_duration': '試用時間',
      'allow_query_overrides': '允許查詢覆蓋',
      'allow_plan_changes': '允許計劃變更',
      'plan_map': '平面圖',
      'refund_period': '退款期限',
      'webhook_configuration': 'Webhook 配置',
      'purchase_page': '購買頁面',
      'security': '安全',
      'email_bounced': '電子郵件被退回',
      'email_spam_complaint': '垃圾郵件投訴',
      'email_delivery': '電子郵件傳送',
      'webhook_response': 'Webhook 回應',
      'pdf_response': 'PDF 回覆',
      'authentication_failure': '驗證失敗',
      'pdf_failed': 'PDF 失敗',
      'pdf_success': 'PDF 成功',
      'modified': '修改的',
      'payment_link': '支付連結',
      'new_payment_link': '新的付款連結',
      'edit_payment_link': '編輯付款連結',
      'created_payment_link': '付款連結建立成功',
      'updated_payment_link': '付款連結已成功更新',
      'archived_payment_link': '付款連結已成功存檔',
      'deleted_payment_link': '已成功刪除付款鏈接',
      'removed_payment_link': '已成功刪除付款鏈接',
      'restored_payment_link': '付款連結已成功恢復',
      'search_payment_link': '搜尋 1 條付款鏈接',
      'search_payment_links': '搜尋:count付款鏈接',
      'subdomain_is_not_available': '子網域不可用',
      'connect_gmail': '連接 Gmail',
      'disconnect_gmail': '斷開 Gmail 連接',
      'connected_gmail': '已成功連接 Gmail',
      'disconnected_gmail': '已成功斷開 Gmail 連接',
      'update_fail_help': '對程式碼庫的變更可能會阻止更新，您可以執行以下命令來放棄變更：',
      'client_id_number': '客戶 ID 號碼',
      'count_minutes': ':count分鐘',
      'password_timeout': '密碼超時',
      'shared_invoice_credit_counter': '共享發票/信用櫃檯',
      'use_last_email': '使用最後的電子郵件',
      'activate_company': '啟動公司',
      'activate_company_help': '啟用電子郵件、定期發票和通知',
      'an_error_occurred_try_again': '發生錯誤，請重試',
      'please_first_set_a_password': '請先設定密碼',
      'changing_phone_disables_two_factor': '警告：更改您的電話號碼將停用 2FA',
      'help_translate': '幫助翻譯',
      'please_select_a_country': '請選擇一個國家',
      'resend_invite': '重寄邀請函',
      'disabled_two_factor': '已成功停用 2FA',
      'connected_google': '帳號關聯成功',
      'disconnected_google': '帳號註銷成功',
      'delivered': '發表',
      'bounced': '已退回',
      'spam': '垃圾郵件',
      'view_docs': '查看文件',
      'enter_phone_to_enable_two_factor': '請提供手機號碼以啟用兩步驟驗證',
      'send_sms': '發簡訊',
      'sms_code': '簡訊代碼',
      'two_factor_setup_help': '使用 :link 相容的 App 掃描條碼。',
      'enabled_two_factor': '啟用兩步驟驗證成功',
      'connect_google': '連接谷歌',
      'disconnect_google': '斷開與Google的連接',
      'enable_two_factor': '兩步驟驗證',
      'disable_two_factor': '禁用二因素',
      'require_password_with_social_login': '社群登入需要密碼',
      'stay_logged_in': '保持登入狀態',
      'session_about_to_expire': '警告：您的會話即將過期',
      'count_hours': ':count小時',
      'count_day': '1天',
      'count_days': ':count天',
      'web_session_timeout': '網路會話逾時',
      'security_settings': '安全設定',
      'resend_email': '重發電子郵件',
      'confirm_your_email_address': '請確認您的電子郵件地址',
      'refunded_payment': '已退款的付款',
      'partially_unapplied': '部分未應用',
      'select_a_gmail_user': '請選擇透過 Gmail 驗證的用戶',
      'list_long_press': '列表長按',
      'show_actions': '顯示動作',
      'start_multiselect': '開始多選',
      'email_sent_to_confirm_email': '已發送一封電子郵件以確認電子郵件地址',
      'counter_pattern_error':
          '要使用:client _counter，請新增:client _number 或:client _id_number 以防止衝突',
      'this_quarter': '本季',
      'last_quarter': 'Last Quarter',
      'to_update_run': '更新運行',
      'convert_to_invoice': '轉換至發票',
      'registration_url': '註冊網址',
      'invoice_project': '發票專案',
      'invoice_task': '為任務開立發票',
      'invoice_expense': '為支出開立發票',
      'search_payment_term': '搜尋 1 付款條件',
      'search_payment_terms': '搜尋:count付款條件',
      'save_and_preview': '儲存並預覽',
      'save_and_email': '儲存並透過電子郵件發送',
      'supported_events': '支持的活動',
      'converted_amount': '轉換的金額',
      'converted_balance': '換算餘額',
      'converted_paid_to_date': '轉換為付費日期',
      'converted_credit_balance': '轉換後的貸方餘額',
      'converted_total': '換算總計',
      'is_sent': '已發送',
      'default_documents': '預設的文件',
      'document_upload': '文件上傳',
      'document_upload_help': '允許客戶上傳文檔',
      'expense_total': '費用總計',
      'enter_taxes': '輸入稅費',
      'by_rate': '按費率',
      'by_amount': '按金額',
      'enter_amount': '輸入金額',
      'before_taxes': '稅前',
      'after_taxes': '稅後',
      'color': '顏色',
      'show': '展示',
      'hide': '隱藏',
      'empty_columns': '空列',
      'debug_mode_is_enabled': '調試模式已啟用',
      'debug_mode_is_enabled_help': '警告：它適用於本機計算機，它可能會洩漏憑證。點擊了解更多。',
      'running_tasks': '運行任務',
      'recent_tasks': '最近的任務',
      'recent_expenses': '近期開支',
      'upcoming_expenses': '即將發生的費用',
      'update_app': '更新應用程式',
      'started_import': '成功開始導入',
      'duplicate_column_mapping': '重複列映射',
      'uses_inclusive_taxes': '使用包容性稅收',
      'is_amount_discount': '是金額折扣',
      'column': '欄',
      'sample': '樣本',
      'map_to': '地圖至',
      'import': '進口',
      'first_row_as_column_names': '使用第一行作為列名稱',
      'select_file': '請選擇一個檔案',
      'no_file_selected': '未選擇文件',
      'csv_file': 'CSV 檔案',
      'csv': 'CSV',
      'freshbooks': '新書',
      'invoice2go': '發票2go',
      'invoicely': '開立發票',
      'waveaccounting': '波浪會計',
      'zoho': '佐霍',
      'accounting': '會計',
      'required_files_missing': '請提供所有 CSV。',
      'import_type': '進口類型',
      'html_mode': 'HTML模式',
      'html_mode_help': '預覽更新速度較快，但準確性較差',
      'view_licenses': '查看許可證',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': '全螢幕編輯器',
      'sidebar_editor': '側邊欄編輯器',
      'please_type_to_confirm': '請輸入「 :value 」確認',
      'purge': '清除',
      'service': '服務',
      'clone_to': '克隆到',
      'clone_to_other': '克隆到其他',
      'labels': '標籤',
      'add_custom': '新增自訂',
      'payment_tax': '繳稅',
      'unpaid': '未付款',
      'white_label': '白色標籤',
      'delivery_note': '寄送註記',
      'sent_invoices_are_locked': '發送的發票已鎖定',
      'paid_invoices_are_locked': '已付款發票已鎖定',
      'source_code': '原始碼',
      'app_platforms': '應用程式平台',
      'invoice_late': '發票遲到',
      'quote_expired': '報價已過期',
      'partial_due': '部分應付款',
      'invoice_total': '發票總額',
      'quote_total': '報價單總計',
      'credit_total': '貸款總額',
      'recurring_invoice_total': '發票總計',
      'actions': '行動',
      'expense_number': '費用號碼',
      'task_number': '任務編號',
      'project_number': '項目編號',
      'project_name': '專案名',
      'warning': '警告',
      'view_settings': '查看設定',
      'company_disabled_warning': '警告：該公司尚未激活',
      'late_invoice': '逾期發票',
      'expired_quote': '過期報價',
      'remind_invoice': '提醒發票',
      'cvv': '信用卡認證編號',
      'client_name': '用戶名稱',
      'client_phone': '客戶電話',
      'required_fields': '必填字段',
      'calculated_rate': '計算費率',
      'default_task_rate': '預設任務率',
      'clear_cache': '清除快取',
      'sort_order': '排序',
      'task_status': '地位',
      'task_statuses': '任務狀態',
      'new_task_status': '新任務狀態',
      'edit_task_status': '編輯任務狀態',
      'created_task_status': '建立成功任務狀態',
      'updated_task_status': '更新工作狀態成功',
      'archived_task_status': '成功歸檔任務狀態',
      'deleted_task_status': '成功刪除任務狀態',
      'removed_task_status': '已成功刪除任務狀態',
      'restored_task_status': '成功恢復任務狀態',
      'archived_task_statuses': '已成功存檔:value任務狀態',
      'deleted_task_statuses': '已成功刪除:value任務狀態',
      'restored_task_statuses': '成功恢復:value任務狀態',
      'search_task_status': '搜尋 1 任務狀態',
      'search_task_statuses': '搜尋:count任務狀態',
      'show_tasks_table': '顯示任務表',
      'show_tasks_table_help': '建立發票時始終顯示任務部分',
      'invoice_task_timelog': '發票任務時間日誌',
      'invoice_task_timelog_help': '將時間詳細資料新增至發票行項目',
      'invoice_task_datelog': '發票任務日期日誌',
      'invoice_task_datelog_help': '將日期詳細資料新增至發票行項目',
      'auto_start_tasks_help': '儲存前啟動任務',
      'configure_statuses': '配置狀態',
      'task_settings': '任務設定',
      'configure_categories': '配置類別',
      'expense_categories': '支出類別',
      'new_expense_category': '新的支出類別',
      'edit_expense_category': '編輯費用類別',
      'created_expense_category': '成功建立支出類別',
      'updated_expense_category': '更新支出類別成功',
      'archived_expense_category': '歸檔支出類別成功',
      'deleted_expense_category': '刪除類別成功',
      'removed_expense_category': '已成功刪除費用類別',
      'restored_expense_category': '復原支出類別成功',
      'archived_expense_categories': '歸檔 :count 項支出類別成功',
      'deleted_expense_categories': '已成功刪除費用:value類別',
      'restored_expense_categories': '成功恢復費用:value類別',
      'search_expense_category': '搜尋 1 費用類別',
      'search_expense_categories': '搜尋:count費用類別',
      'use_available_credits': '使用可用積分',
      'show_option': '顯示選項',
      'negative_payment_error': '信用金額不能超過付款金額',
      'view_changes': '查看變更',
      'force_update': '強制性升級',
      'force_update_help': '您正在運行最新版本，但可能有待修復的可用補丁。',
      'mark_paid_help': '追蹤已支付的費用',
      'should_be_invoiced': '應為此開立發票',
      'should_be_invoiced_help': '啟用費用發票',
      'add_documents_to_invoice_help': '使文件對客戶可見',
      'convert_currency_help': '設定匯率',
      'expense_settings': '費用設定',
      'clone_to_recurring': '克隆到重複',
      'crypto': '加密貨幣',
      'paypal': 'PayPal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple/Google Pay',
      'user_field': '使用者欄位',
      'variables': '變數',
      'show_password': '顯示密碼',
      'hide_password': '隱藏密碼',
      'copy_error': '複製錯誤',
      'capture_card': '採集卡',
      'auto_bill_enabled': '自動計費已啟用',
      'total_taxes': '總稅金',
      'line_taxes': '行稅',
      'total_fields': '總字段數',
      'stopped_recurring_invoice': '已成功停止定期發票',
      'started_recurring_invoice': '已成功開始定期發票',
      'resumed_recurring_invoice': '已成功恢復定期發票',
      'gateway_refund': '網關退款',
      'gateway_refund_help': '透過支付網關處理退款',
      'due_date_days': '到期日',
      'paused': '已暫停',
      'mark_active': '標記使用中',
      'day_count': '日:count',
      'first_day_of_the_month': '該月的第一天',
      'last_day_of_the_month': '本月最後一天',
      'use_payment_terms': '使用付款條件',
      'endless': '無盡',
      'next_send_date': '下次發送日期',
      'remaining_cycles': '剩餘週期',
      'recurring_invoice': '週期性發票',
      'recurring_invoices': '定期發票',
      'new_recurring_invoice': '新的週期性發票',
      'edit_recurring_invoice': '編輯週期性發票',
      'created_recurring_invoice': '已成功建立定期發票',
      'updated_recurring_invoice': '已成功更新定期發票',
      'archived_recurring_invoice': '歸檔週期性發票成功',
      'deleted_recurring_invoice': '刪除週期性發票成功',
      'removed_recurring_invoice': '已成功刪除定期發票',
      'restored_recurring_invoice': '復原週期性發票成功',
      'archived_recurring_invoices': '已成功存檔定期:value發票',
      'deleted_recurring_invoices': '已成功刪除定期:value發票',
      'restored_recurring_invoices': '已成功恢復定期:value發票',
      'search_recurring_invoice': '搜尋 1 份經常性發票',
      'search_recurring_invoices': '搜尋:count經常性發票',
      'send_date': '發送日期',
      'auto_bill_on': '自動計費開啟',
      'minimum_under_payment_amount': '最低付款金額',
      'profit': '利潤',
      'line_item': '單列品項',
      'allow_over_payment': '允許超額支付',
      'allow_over_payment_help': '支持額外付費接受小費',
      'allow_under_payment': '允許少付',
      'allow_under_payment_help': '支持至少支付部分/存款金額',
      'test_mode': '測試模式',
      'opened': '已開啟',
      'payment_reconciliation_failure': '協調失敗',
      'payment_reconciliation_success': '和解成功',
      'gateway_success': '成功之路',
      'gateway_failure': '網關故障',
      'gateway_error': '網關錯誤',
      'email_send': '電子郵件發送',
      'email_retry_queue': '電子郵件重試佇列',
      'failure': '失敗',
      'quota_exceeded': '超過配額',
      'upstream_failure': '上游故障',
      'system_logs': '系統日誌',
      'view_portal': '檢視入口頁面',
      'copy_link': '複製連結',
      'token_billing': '儲存卡片詳細資料',
      'welcome_to_invoice_ninja': '歡迎來到發票忍者',
      'always': '永遠',
      'optin': '選擇參加',
      'optout': '選擇退出',
      'label': '標籤',
      'client_number': '用戶編號',
      'auto_convert': '自動轉換',
      'company_name': '公司名稱',
      'reminder1_sent': '提醒 1 已發送',
      'reminder2_sent': '提醒 2 已發送',
      'reminder3_sent': '提醒 3 已發送',
      'reminder_last_sent': '上次發送提醒',
      'pdf_page_info': ':total的頁面:current',
      'emailed_invoices': '以電子郵件寄出發票成功',
      'emailed_quotes': '以電子郵件寄出報價單成功',
      'emailed_credits': '已成功透過電子郵件發送積分',
      'gateway': '閘道',
      'view_in_stripe': '條紋視圖',
      'rows_per_page': '每頁行數',
      'hours': '時',
      'statement': '財務報表',
      'taxes': '稅費',
      'surcharge': '額外費用',
      'apply_payment': '申請付款',
      'apply_credit': '套用貸款',
      'apply': '套用',
      'unapplied': '未應用',
      'select_label': '選擇標籤',
      'custom_labels': '客製化標籤',
      'record_type': '記錄類型',
      'record_name': '記錄名稱',
      'file_type': '文件類型',
      'height': '高度',
      'width': '寬度',
      'to': '到',
      'health_check': '健康檢查',
      'payment_type_id': '付款方式',
      'last_login_at': '上次登入時間',
      'company_key': '公司金鑰',
      'storefront': '店面',
      'storefront_help': '允許第三方應用程式建立發票',
      'client_created': '客戶已創建',
      'online_payment_email': '網上支付郵箱',
      'manual_payment_email': '手動付款電子郵件',
      'completed': '完全的',
      'gross': '總的',
      'net_amount': '淨額',
      'net_balance': '淨餘額',
      'client_settings': '客戶端設定',
      'selected_invoices': '選定的發票',
      'selected_payments': '選定的付款方式',
      'selected_quotes': '精選行情',
      'selected_tasks': '選定的任務',
      'selected_expenses': '選定的費用',
      'upcoming_invoices': '即將開立的發票',
      'past_due_invoices': '逾期發票',
      'recent_payments': '最近的支付',
      'upcoming_quotes': '即將到期的報價單',
      'expired_quotes': '過期的報價單',
      'create_client': '建立用戶',
      'create_invoice': '建立發票',
      'create_quote': '建立報價單',
      'create_payment': '建立付款',
      'create_vendor': '建立供應商',
      'update_quote': '更新報價',
      'delete_quote': '刪除報價單',
      'update_invoice': '更新發票',
      'delete_invoice': '刪除發票',
      'update_client': '更新客戶端',
      'delete_client': '刪除客戶端',
      'delete_payment': '刪除付款',
      'update_vendor': '更新供應商',
      'delete_vendor': '刪除供應商',
      'create_expense': '創建費用',
      'update_expense': '更新費用',
      'delete_expense': '刪除支出',
      'create_task': '建立工作項目',
      'update_task': '更新任務',
      'delete_task': '刪除工作項目',
      'approve_quote': '批准報價',
      'off': '關',
      'when_paid': '付款時',
      'expires_on': '到期',
      'free': '免費',
      'plan': '資費案',
      'show_sidebar': '顯示側邊欄',
      'hide_sidebar': '隱藏側邊欄',
      'event_type': '事件類型',
      'target_url': '目標',
      'copy': '複製',
      'must_be_online': '連接到互聯網後請重新啟動應用程式',
      'crons_not_enabled': '需要啟用 crons',
      'api_webhooks': 'API 網路鉤子',
      'search_webhooks': '搜尋:count Webhooks',
      'search_webhook': '搜尋 1 個 Webhook',
      'webhook': '網路鉤子',
      'webhooks': '網路鉤子',
      'new_webhook': '新的Webhook',
      'edit_webhook': '編輯網路鉤子',
      'created_webhook': '成功創建網路鉤子',
      'updated_webhook': '已成功更新網路鉤子',
      'archived_webhook': '成功歸檔 webhook',
      'deleted_webhook': '成功刪除網路鉤子',
      'removed_webhook': '已成功刪除網路鉤子',
      'restored_webhook': '成功恢復網路鉤子',
      'archived_webhooks': '已成功存檔:value webhooks',
      'deleted_webhooks': '已成功刪除:value webhooks',
      'removed_webhooks': '已成功刪除:value webhooks',
      'restored_webhooks': '已成功恢復:value webhooks',
      'api_tokens': 'API 的安全代碼',
      'api_docs': 'API文件',
      'search_tokens': '搜尋:count代幣',
      'search_token': '搜尋 1 代幣',
      'token': '安全代碼',
      'tokens': '安全代碼',
      'new_token': '新代幣',
      'edit_token': '編輯安全代碼',
      'created_token': '安全代碼建立成功',
      'updated_token': '更新安全代碼成功',
      'archived_token': '歸檔安全代碼成功',
      'deleted_token': '刪除安全代碼成功',
      'removed_token': '成功刪除令牌',
      'restored_token': '成功恢復令牌',
      'archived_tokens': '已成功存檔:value令牌',
      'deleted_tokens': '已成功刪除:value令牌',
      'restored_tokens': '已成功恢復:value令牌',
      'client_registration': '客戶註冊',
      'client_registration_help': '使客戶能夠在入口網站中自行註冊',
      'email_invoice': '電郵發票',
      'email_quote': '以電子郵件傳送報價單',
      'email_credit': '電子郵件信用',
      'email_payment': '以電子郵件傳送付款資料',
      'client_email_not_set': '客戶沒有設定電子郵件地址',
      'ledger': '分類帳',
      'view_pdf': '查看PDF',
      'all_records': '所有記錄',
      'owned_by_user': '歸用戶所有',
      'credit_remaining': '剩餘信用',
      'contact_name': '聯絡人姓名',
      'use_default': '預設使用',
      'reminder_endless': '無盡的提醒',
      'number_of_days': '天數',
      'configure_payment_terms': '配置付款條件',
      'payment_term': '付款期限',
      'new_payment_term': '新的付款期限',
      'edit_payment_term': '編輯付款條件',
      'created_payment_term': '建立付款條款成功',
      'updated_payment_term': '更新付款條款成功',
      'archived_payment_term': '歸檔付款條款成功',
      'deleted_payment_term': '已成功刪除付款條件',
      'removed_payment_term': '已成功刪除付款條件',
      'restored_payment_term': '成功恢復付款期限',
      'archived_payment_terms': '已成功存檔:value付款條件',
      'deleted_payment_terms': '已成功刪除:value付款條件',
      'restored_payment_terms': '已成功恢復:value付款條件',
      'email_sign_in': '使用電子郵件登入',
      'change': '改變',
      'change_to_mobile_layout': '更改移動佈局？',
      'change_to_desktop_layout': '更改桌面佈局？',
      'send_from_gmail': '從 Gmail 傳送',
      'reversed': '反轉',
      'cancelled': '取消',
      'credit_amount': '貸款金額',
      'quote_amount': '報價金額',
      'hosted': '主辦',
      'selfhosted': '自託管',
      'exclusive': '不含',
      'inclusive': '內含',
      'hide_menu': '隱藏選單',
      'show_menu': '顯示選單',
      'partially_refunded': '部分退款',
      'search_documents': '搜尋文件',
      'search_designs': '搜尋設計',
      'search_invoices': '搜尋發票',
      'search_clients': '搜尋客戶',
      'search_products': '搜尋產品',
      'search_quotes': '搜尋行情',
      'search_credits': '搜尋製作人員',
      'search_vendors': '搜尋供應商',
      'search_users': '搜尋用戶',
      'search_tax_rates': '搜尋稅率',
      'search_tasks': '搜尋任務',
      'search_settings': '搜尋設定',
      'search_projects': '搜尋項目',
      'search_expenses': '搜尋費用',
      'search_payments': '搜尋付款',
      'search_groups': '搜尋組',
      'search_company': '搜尋公司',
      'search_document': '搜尋 1 個文檔',
      'search_design': '搜尋 1 設計',
      'search_invoice': '搜尋 1 份發票',
      'search_client': '搜尋 1 客戶',
      'search_product': '搜尋 1 個產品',
      'search_quote': '搜尋 1 個報價',
      'search_credit': '搜尋 1 點',
      'search_vendor': '搜尋 1 供應商',
      'search_user': '搜尋 1 用戶',
      'search_tax_rate': '搜尋 1 稅率',
      'search_task': '搜尋 1 任務',
      'search_project': '搜尋 1 個項目',
      'search_expense': '搜尋 1 費用',
      'search_payment': '搜尋 1 付款',
      'search_group': '搜尋 1 組',
      'refund_payment': '已退款的支付',
      'cancelled_invoice': '已成功取消發票',
      'cancelled_invoices': '已成功取消發票',
      'reversed_invoice': '成功沖銷發票',
      'reversed_invoices': '已成功沖銷發票',
      'reverse': '反向',
      'full_name': '全名',
      'city_state_postal': '城市/州省/郵遞區號',
      'postal_city_state': '城市/州省/郵遞區號',
      'custom1': '首位顧客',
      'custom2': '第二名顧客',
      'custom3': '第三個習慣',
      'custom4': '第四個習慣',
      'optional': '選修的',
      'license': '執照',
      'purge_data': '清除資料',
      'purge_successful': '清除公司資料成功',
      'purge_data_message': '警告: 這將永久性地抹除您的資料；沒有恢復的可能。',
      'invoice_balance': '發票餘額',
      'age_group_0': '0 - 30 天',
      'age_group_30': '30 - 60 天',
      'age_group_60': '60 - 90 天',
      'age_group_90': '90 - 120 天',
      'age_group_120': '120 天以上',
      'refresh': '更新',
      'saved_design': '成功保存設計',
      'client_details': '客戶詳情',
      'company_address': '公司地址',
      'invoice_details': '發票詳細內容',
      'quote_details': '報價詳情',
      'credit_details': '信用詳情',
      'product_columns': '產品專欄',
      'task_columns': '工作列',
      'add_field': '新增字段',
      'all_events': '所有活動',
      'permissions': '權限',
      'none': '無',
      'owned': '擁有',
      'payment_success': '支付成功',
      'payment_failure': '付款失敗',
      'invoice_sent': '已寄出 :count 份發票',
      'quote_sent': '報價已發送',
      'credit_sent': '信用已發送',
      'invoice_viewed': '已查看發票',
      'quote_viewed': '已查看報價',
      'credit_viewed': '信用查看',
      'quote_approved': '報價已獲批准',
      'receive_all_notifications': '接收所有通知',
      'purchase_license': '購買許可證',
      'apply_license': '套用授權',
      'cancel_account': '刪除帳戶',
      'cancel_account_message': '警告: 這將永久刪除您的帳戶，而且無法恢復。',
      'delete_company': '刪除公司資料',
      'delete_company_message': '警告: 這將永久刪除您的公司資料，而且不可能復原。',
      'enabled_modules': '啟用的模組',
      'converted_quote': '報價轉換成功',
      'credit_design': '信用設計',
      'includes': '包括',
      'header': '頁首',
      'load_design': '載入設計',
      'css_framework': 'CSS框架',
      'custom_designs': '客製化設計',
      'designs': '設計',
      'new_design': '新設計',
      'edit_design': '編輯設計',
      'created_design': '成功創建設計',
      'updated_design': '成功更新設計',
      'archived_design': '成功歸檔設計',
      'deleted_design': '成功刪除設計',
      'removed_design': '成功刪除設計',
      'restored_design': '成功恢復設計',
      'archived_designs': '成功存檔:value設計',
      'deleted_designs': '成功刪除:value設計',
      'restored_designs': '成功恢復:value設計',
      'proposals': '提案',
      'tickets': '門票',
      'recurring_quotes': '重複報價',
      'recurring_tasks': '重複任務',
      'account_management': '帳號管理',
      'credit_date': '貸款日期',
      'credit': '貸款',
      'credits': '致謝',
      'new_credit': '輸入貸款資料',
      'edit_credit': '編輯貸款資料',
      'created_credit': '建立貸款資料完成',
      'updated_credit': '更新貸款資料成功',
      'archived_credit': '歸檔貸款資料成功',
      'deleted_credit': '刪除貸款資料成功',
      'removed_credit': '已成功刪除信用',
      'restored_credit': '復原貸款資料成功',
      'archived_credits': '歸檔 :count 筆貸款資料成功',
      'deleted_credits': '刪除 :count 筆貸款資料成功',
      'restored_credits': '已成功恢復:value積分',
      'current_version': '目前版本',
      'latest_version': '最新版本',
      'update_now': '現在更新',
      'a_new_version_is_available': '新版本的網路應用程式現已推出',
      'update_available': '可用更新',
      'app_updated': '更新成功完成',
      'learn_more': '了解更多',
      'integrations': '整合',
      'tracking_id': '追蹤號碼',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': '信用頁腳',
      'credit_terms': '信用條款',
      'new_company': '新的公司資料',
      'added_company': '添加公司成功',
      'company1': '自訂公司1',
      'company2': '自訂公司2',
      'company3': '自訂公司3',
      'company4': '自訂公司4',
      'product1': '客製化產品1',
      'product2': '客製化產品2',
      'product3': '客製化產品3',
      'product4': '客製化產品4',
      'client1': '客製化客戶端1',
      'client2': '客製化客戶端2',
      'client3': '客製化客戶端3',
      'client4': '客製化客戶端4',
      'contact1': '客製化聯絡方式 1',
      'contact2': '客製化聯絡方式2',
      'contact3': '客製化聯絡方式 3',
      'contact4': '客製化聯絡方式 4',
      'task1': '自訂任務1',
      'task2': '自訂任務2',
      'task3': '自訂任務3',
      'task4': '自訂任務 4',
      'project1': '客製化項目1',
      'project2': '客製化項目2',
      'project3': '客製化項目3',
      'project4': '客製化項目4',
      'expense1': '客製費用1',
      'expense2': '客製費用2',
      'expense3': '客製化費用3',
      'expense4': '客製化費用 4',
      'vendor1': '客製化供應商 1',
      'vendor2': '客製化供應商 2',
      'vendor3': '客製化供應商 3',
      'vendor4': '客製化供應商 4',
      'invoice1': '定制發票1',
      'invoice2': '定制發票2',
      'invoice3': '定制發票3',
      'invoice4': '定制發票 4',
      'payment1': '客製支付1',
      'payment2': '客製化支付2',
      'payment3': '客製支付3',
      'payment4': '客製支付4',
      'surcharge1': '客製化附加費 1',
      'surcharge2': '客製化附加費2',
      'surcharge3': '客製化附加費3',
      'surcharge4': '客製化附加費 4',
      'group1': '自訂組 1',
      'group2': '自訂組 2',
      'group3': '自訂組 3',
      'group4': '自訂組 4',
      'reset': '重設',
      'number': '數位',
      'export': '匯出',
      'chart': '圖表',
      'count': '數數',
      'totals': '總計',
      'blank': '空白',
      'day': '日',
      'month': '月',
      'year': '年',
      'subgroup': '次群組',
      'is_active': '活躍',
      'group_by': '分組方式',
      'credit_balance': '貸款餘額',
      'contact_last_login': '聯絡方式 上次登入',
      'contact_full_name': '聯絡全名',
      'contact_phone': '聯絡人電話',
      'contact_custom_value1': '聯繫客製化價值 1',
      'contact_custom_value2': '聯繫客製化價值 2',
      'contact_custom_value3': '聯繫客製化價值 3',
      'contact_custom_value4': '聯繫客製化價值 4',
      'shipping_address1': '送貨地址之街道',
      'shipping_address2': '送貨地址之大樓/套房',
      'shipping_city': '送貨地址之城市',
      'shipping_state': '送貨地址之州/省',
      'shipping_postal_code': '送貨地址之郵遞區號',
      'shipping_country': '送貨地址之國家',
      'billing_address1': '帳單地址之街/路',
      'billing_address2': '帳單地址之大樓/套房',
      'billing_city': '帳單地址之城市',
      'billing_state': '帳單地址之州/省',
      'billing_postal_code': '帳單地址之郵遞區號',
      'billing_country': '帳單地址之國家',
      'client_id': '用戶 Id',
      'assigned_to': '分配給',
      'created_by': '由 :name 建立',
      'assigned_to_id': '分配給 ID',
      'created_by_id': '創建者： ID',
      'add_column': '新增列',
      'edit_columns': '編輯列',
      'columns': '欄',
      'aging': '帳齡',
      'profit_and_loss': '利潤與損失',
      'reports': '報告',
      'report': '報告',
      'add_company': '新增公司資料',
      'unpaid_invoice': '未付款之發票',
      'paid_invoice': '已付款之發票',
      'unapproved_quote': '未同意之報價單',
      'help': '說明',
      'refund': '退款',
      'refund_date': '退款日期',
      'filtered_by': '篩選依據',
      'contact_email': '聯絡人電子郵件',
      'multiselect': '多選',
      'entity_state': '狀態',
      'verify_password': '驗證密碼',
      'applied': '應用',
      'include_recent_errors': '包括日誌中的最近錯誤',
      'your_message_has_been_received': '我們已收到您的留言，並將盡力及時回覆。',
      'message': '訊息',
      'from': '從',
      'show_product_details': '顯示產品詳情',
      'show_product_details_help': '在產品下拉清單中包含描述和成本',
      'pdf_min_requirements': 'PDF 渲染器需要:version',
      'adjust_fee_percent': '調整費用百分比',
      'adjust_fee_percent_help': '調整百分比以計入費用',
      'configure_settings': '配置設定',
      'support_forum': '支援論壇',
      'about': '關於',
      'documentation': '文件',
      'contact_us': '聯絡我們',
      'subtotal': '小計',
      'line_total': '行總計',
      'item': '物品',
      'credit_email': '信用電子郵件',
      'iframe_url': 'iFrame 網址',
      'domain_url': '網域網址',
      'password_is_too_short': '密碼太短',
      'password_is_too_easy': '密碼必須包含大寫字元和數字',
      'client_portal_tasks': '客戶端任務',
      'client_portal_dashboard': '客戶入口網站儀表板',
      'please_enter_a_value': '請輸入一個值',
      'deleted_logo': '成功刪除標誌',
      'yes': '是',
      'no': '否',
      'generate_number': '產生號碼',
      'when_saved': '保存時',
      'when_sent': '發送時',
      'select_company': '選擇公司',
      'float': '漂浮',
      'collapse': '坍塌',
      'show_or_hide': '顯示隱藏',
      'menu_sidebar': '選單側邊欄',
      'history_sidebar': '歷史側邊欄',
      'tablet': '藥片',
      'mobile': '行動裝置',
      'desktop': '電腦桌面',
      'layout': '佈局',
      'view': '檢視',
      'module': '模組',
      'first_custom': '第一次客製化',
      'second_custom': '第二個客製化',
      'third_custom': '第三個習慣',
      'show_cost': '顯示費用',
      'show_product_cost': '顯示產品成本',
      'show_cost_help': '顯示產品成本欄位以追蹤加價/利潤',
      'show_product_quantity': '顯示產品數量',
      'show_product_quantity_help': '顯示產品數量字段，否則預設為 1',
      'show_invoice_quantity': '顯示發票數量',
      'show_invoice_quantity_help': '顯示行項目數量字段，否則預設為 1',
      'show_product_discount': '顯示產品折扣',
      'show_product_discount_help': '顯示訂單項目折扣字段',
      'default_quantity': '預設數量',
      'default_quantity_help': '自動將行項目數量設定為 1',
      'one_tax_rate': '一種稅率',
      'two_tax_rates': '兩種稅率',
      'three_tax_rates': '三種稅率',
      'default_tax_rate': '預設稅率',
      'user': '使用者',
      'invoice_tax': '發票稅',
      'line_item_tax': '行項目稅',
      'inclusive_taxes': '普惠稅',
      'invoice_tax_rates': '發票稅率',
      'item_tax_rates': '項目稅率',
      'no_client_selected': '請選取一個用戶',
      'configure_rates': '配置費率',
      'configure_gateways': '設定網關',
      'tax_settings': '稅額設定',
      'tax_settings_rates': '稅率',
      'accent_color': '強調色',
      'switch': 'Switch',
      'comma_sparated_list': '逗號分隔列表',
      'options': '選項',
      'single_line_text': '單行文字',
      'multi_line_text': '多行文字',
      'dropdown': '落下',
      'field_type': '字段類型',
      'recover_password_email_sent': '密碼恢復電子郵件已發送',
      'submit': '提交',
      'recover_password': '重設您的密碼',
      'late_fees': '滯納金',
      'credit_number': '貸款編號',
      'payment_number': '付款號碼',
      'late_fee_amount': '逾期費用金額',
      'late_fee_percent': '逾期費用率',
      'before_due_date': '到期日之前',
      'after_due_date': '到期日之後',
      'after_invoice_date': '發票日之後',
      'days': '日',
      'invoice_email': '發票電子郵件',
      'payment_email': '付款資料電子郵件',
      'partial_payment': '部分付款',
      'payment_partial': '部分付款',
      'partial_payment_email': '部分付款電子郵件',
      'quote_email': '報價單電子郵件',
      'endless_reminder': '不終止的提醒函',
      'filtered_by_user': '依使用者篩選',
      'administrator': '管理者',
      'administrator_help': '允許使用者管理所有使用者、改變設定、修改所有紀錄',
      'user_management': '管理使用者',
      'users': '使用者',
      'new_user': '新使用者',
      'edit_user': '編輯使用者',
      'created_user': '已成功建立使用者',
      'updated_user': '更新使用者資料成功',
      'archived_user': '歸檔使用者資料成功',
      'deleted_user': '刪除使用者成功',
      'removed_user': '成功刪除用戶',
      'restored_user': '復原使用者資料成功',
      'archived_users': '已成功歸檔:value用戶',
      'deleted_users': '已成功刪除:value用戶',
      'removed_users': '已成功刪除:value用戶',
      'restored_users': '成功恢復:value用戶',
      'general_settings': '一般設定',
      'invoice_options': '發票選項',
      'hide_paid_to_date': '隱藏迄今之付款金額',
      'hide_paid_to_date_help': '一旦收到付款，僅在您的發票上顯示「迄今之付款金額」。',
      'invoice_embed_documents': 'Embed Images/Documents',
      'invoice_embed_documents_help':
          'Include attached images/pdfs in the invoice.',
      'all_pages_header': '顯示頁首於',
      'all_pages_footer': '顯示頁尾於',
      'first_page': '第一頁',
      'all_pages': '所有頁面',
      'last_page': '最後一頁',
      'primary_font': '主要字型',
      'secondary_font': '次要字型',
      'primary_color': '主要色彩',
      'secondary_color': '次要色彩',
      'page_size': '頁面尺寸',
      'font_size': '字型大小',
      'quote_design': '報價單設計',
      'invoice_fields': '發票欄位',
      'product_fields': '產品欄位',
      'invoice_terms': '發票條款',
      'invoice_footer': '發票頁尾',
      'quote_terms': '報價單條款',
      'quote_footer': '報價單頁尾',
      'auto_email_invoice': '自動電子郵件',
      'auto_email_invoice_help': '建立後自動透過電子郵件發送定期發票。',
      'auto_archive_quote': '自動歸檔',
      'auto_archive_quote_help': '轉換為發票後自動存檔報價。',
      'auto_convert_quote': '自動轉換',
      'auto_convert_quote_help': '批准後自動將報價轉換為發票。',
      'workflow_settings': '工作流程設定',
      'freq_daily': '每天',
      'freq_weekly': '每星期',
      'freq_two_weeks': '兩星期',
      'freq_four_weeks': '四星期',
      'freq_monthly': '每月',
      'freq_two_months': '兩個月',
      'freq_three_months': '三個月',
      'freq_four_months': '四個月',
      'freq_six_months': '六個月',
      'freq_annually': 'Annually',
      'freq_two_years': '兩年',
      'freq_three_years': '三年',
      'never': '永不',
      'company': '公司',
      'generated_numbers': '自動產生之號碼',
      'charge_taxes': '附收稅款',
      'next_reset': '下一次重設',
      'reset_counter': '重設計數器',
      'recurring_prefix': '用以標示週期性的前置符號',
      'number_padding': '數字填充',
      'general': '一般',
      'surcharge_field': '附加費欄位',
      'company_field': '公司欄位',
      'company_value': '公司值',
      'credit_field': '信用欄位',
      'invoice_field': '發票欄位',
      'invoice_surcharge': '發票額外費用',
      'client_field': '用戶欄位',
      'product_field': '產品欄位',
      'payment_field': '付款欄位',
      'contact_field': '聯絡人欄位',
      'vendor_field': '供應商欄位',
      'expense_field': '支出欄位',
      'project_field': '專案欄位',
      'task_field': '任務欄位',
      'group_field': '群組欄位',
      'number_counter': '數字計數器',
      'prefix': '前置符號',
      'number_pattern': '數字模式',
      'messages': '訊息',
      'custom_css': '自訂樣式表',
      'custom_javascript': '自訂 JavaScript',
      'signature_on_pdf': '在 PDF 檔案上顯示',
      'signature_on_pdf_help': '在發票/報價單 PDF 顯示用戶簽名。',
      'show_accept_invoice_terms': '發票條款核取方塊',
      'show_accept_invoice_terms_help': '要求用戶確認他們接受發票條款。',
      'show_accept_quote_terms': '報價單條款核取方塊',
      'show_accept_quote_terms_help': '要求用戶確認他們接受報價條款。',
      'require_invoice_signature': '發票簽名',
      'require_invoice_signature_help': '要求用戶提供其簽名。',
      'require_quote_signature': '報價單簽名',
      'enable_portal_password': '用以保護發票的密碼',
      'enable_portal_password_help':
          '使您能夠為每位聯絡人設定密碼。若設定密碼，聯絡人將會在查看發票之前被要求輸入密碼。',
      'authorization': '授權',
      'subdomain': '子網域',
      'domain': '網域',
      'portal_mode': '入口網站模式',
      'email_signature': '向您致意，',
      'enable_email_markup_help': '透過在電子郵件中加入 schema.org 標記，使您的用戶更輕鬆地支付您的費用。',
      'plain': '純文字',
      'light': '淺色',
      'dark': '深色',
      'email_design': '電子郵件的設計',
      'attach_pdf': '附上PDF',
      'attach_documents': '附加文件',
      'attach_ubl': '附上 UBL/電子發票',
      'email_style': '電子郵件樣式',
      'enable_email_markup': '啟用網頁標示',
      'reply_to_email': '回覆電子郵件',
      'reply_to_name': '回覆名稱',
      'bcc_email': '電子郵件密件副本',
      'processed': '處理',
      'credit_card': '信用卡',
      'bank_transfer': '銀行轉帳',
      'priority': '優先順序',
      'fee_amount': '費用金額',
      'fee_percent': '費用百分比',
      'fee_cap': '費用上限',
      'limits_and_fees': '限額/費用',
      'enable_min': '啟用最小值',
      'enable_max': '啟用最大值',
      'min_limit': '最小值: :min',
      'max_limit': '最大值: :max',
      'min': '最小值',
      'max': '最大值',
      'accepted_card_logos': '接受的卡片標誌',
      'credentials': '認證',
      'update_address': '更新地址',
      'update_address_help': '使用提供的詳細資料更新用戶的地址',
      'rate': '速度',
      'tax_rate': '稅率',
      'new_tax_rate': '新稅率',
      'edit_tax_rate': '編輯稅率',
      'created_tax_rate': '已成功地建立稅率',
      'updated_tax_rate': '更新稅率成功',
      'archived_tax_rate': '歸檔稅率資料成功',
      'deleted_tax_rate': '成功刪除稅率',
      'restored_tax_rate': '成功恢復稅率',
      'archived_tax_rates': '成功存檔:value稅率',
      'deleted_tax_rates': '已成功刪除:value稅率',
      'restored_tax_rates': '成功恢復:value稅率',
      'fill_products': '自動填入之產品項目',
      'fill_products_help': '選擇產品將自動填寫描述和成本',
      'update_products': '自動更新產品',
      'update_products_help': '更新發票時會自動 更新產品資料庫',
      'convert_products': '轉換產品',
      'convert_products_help': '自動將產品價格轉換為用戶的貨幣',
      'fees': '費用',
      'limits': '限制',
      'provider': '供應商',
      'company_gateway': '付款閘道',
      'company_gateways': '付款閘道',
      'new_company_gateway': '新增閘道',
      'edit_company_gateway': '編輯閘道',
      'created_company_gateway': '建立閘道資料成功',
      'updated_company_gateway': '更新閘道資料成功',
      'archived_company_gateway': '封存閘道資料成功',
      'deleted_company_gateway': '刪除閘道資料成功',
      'restored_company_gateway': '復原閘道成功',
      'archived_company_gateways': '已成功存檔:value網關',
      'deleted_company_gateways': '已成功刪除:value網關',
      'restored_company_gateways': '成功恢復:value網關',
      'continue_editing': '繼續編輯',
      'discard_changes': '放棄變更',
      'default_value': '預設值',
      'disabled': '已停用',
      'currency_format': '貨幣格式',
      'first_day_of_the_week': '每星期的第一天',
      'first_month_of_the_year': '年度的第一個月',
      'sunday': '星期日',
      'monday': '星期一',
      'tuesday': '星期二',
      'wednesday': '星期三',
      'thursday': '星期四',
      'friday': '星期五',
      'saturday': '星期六',
      'january': '一月',
      'february': '二月',
      'march': '三月',
      'april': '四月',
      'may': '五月',
      'june': '六月',
      'july': '七月',
      'august': '八月',
      'september': '九月',
      'october': '十月',
      'november': '十一月',
      'december': '十二月',
      'symbol': '符號',
      'ocde': '代碼',
      'date_format': '日期格式',
      'datetime_format': '日期時間格式',
      'military_time': '24 小時制',
      'military_time_help': '24小時顯示',
      'send_reminders': '傳送提醒',
      'timezone': '時區',
      'filtered_by_project': '按項目過濾',
      'filtered_by_group': '依群組篩選',
      'filtered_by_invoice': '依發票篩選',
      'filtered_by_client': '依用戶端篩選',
      'filtered_by_vendor': '依供應商篩選',
      'group_settings': '群組設定',
      'group': '群組',
      'groups': '群組',
      'new_group': '新增群組',
      'edit_group': '編輯群組',
      'created_group': '已成功建立群組',
      'updated_group': '已成功更新群組',
      'archived_groups': '已成功存檔:value組',
      'deleted_groups': '已成功刪除:value組',
      'restored_groups': '成功恢復:value組',
      'archived_group': '已成功封存群組',
      'deleted_group': '已成功刪除群組',
      'restored_group': '已成功還原群組',
      'upload_logo': '上傳您的公司徽標',
      'uploaded_logo': '已成功上傳徽標',
      'logo': '標誌',
      'saved_settings': '已成功儲存設定',
      'product_settings': '產品設定',
      'device_settings': '裝置設定',
      'defaults': '預設值',
      'basic_settings': '基本設定',
      'advanced_settings': '進階設定',
      'company_details': '公司詳細信息',
      'user_details': '使用者詳細資料',
      'localization': '本地化',
      'online_payments': '網上支付',
      'tax_rates': '稅率',
      'notifications': '通知',
      'import_export': '導入 |出口',
      'custom_fields': '自訂欄位',
      'invoice_design': '發票設計',
      'buy_now_buttons': '現在即購買按鈕',
      'email_settings': '電子郵件設定',
      'templates_and_reminders': '範本與提醒',
      'credit_cards_and_banks': '信用卡 & 銀行',
      'data_visualizations': '資料視覺化',
      'price': '價格',
      'email_sign_up': '電子郵件註冊',
      'google_sign_up': 'Google 註冊',
      'thank_you_for_your_purchase': '感謝您的購買!',
      'redeem': '兌換',
      'back': '返回',
      'past_purchases': '過去購買',
      'annual_subscription': '年度訂閱',
      'pro_plan': '專業方案',
      'enterprise_plan': '企業方案',
      'count_users': ':count users',
      'upgrade': '升級',
      'please_enter_a_first_name': '請輸入名字',
      'please_enter_a_last_name': '請輸入姓氏',
      'please_agree_to_terms_and_privacy': '請同意服務條款和隱私政策以建立帳戶。',
      'i_agree_to_the': '我同意',
      'terms_of_service': '服務條款',
      'privacy_policy': '隱私權政策',
      'sign_up': '報名',
      'account_login': '登入帳戶',
      'view_website': '檢視網站',
      'create_account': '建立帳戶',
      'email_login': '電子郵件登入',
      'create_new': '建立新的',
      'no_record_selected': '未選取任何記錄',
      'error_unsaved_changes': '請儲存或取消您的變更',
      'download': '下載',
      'requires_an_enterprise_plan': '需要企業計劃',
      'take_picture': '拍照',
      'upload_files': '上傳文件',
      'document': '文件',
      'documents': '文件',
      'new_document': '新新文件',
      'edit_document': '編輯文件',
      'uploaded_document': '已成功上載文件',
      'updated_document': '已成功更新文件',
      'archived_document': '已成功封存文件',
      'deleted_document': '已成功刪除文件',
      'restored_document': '已成功還原文件',
      'archived_documents': '已成功歸檔:value文檔',
      'deleted_documents': '成功刪除:value文檔',
      'restored_documents': '成功恢復:value文檔',
      'no_history': '無歷史記錄',
      'expense_date': '支出日期',
      'pending': '擱置',
      'expense_status_1': '已登入',
      'expense_status_2': '擱置',
      'expense_status_3': '已開立發票的',
      'converted': '已轉換',
      'add_documents_to_invoice': '將文件新增至發票',
      'exchange_rate': '匯率',
      'convert_currency': '轉換貨幣單位',
      'mark_paid': '標記已付',
      'category': '類別',
      'address': '地址',
      'new_vendor': '新供應商',
      'created_vendor': '建立供應商資料成功',
      'updated_vendor': '更新供應商資料成功',
      'archived_vendor': '歸檔供應商資料成功',
      'deleted_vendor': '刪除供應商成功',
      'restored_vendor': '復原供應商成功',
      'archived_vendors': '歸檔 :count 筆供應商資料成功',
      'deleted_vendors': '刪除 :count 筆供應商成功',
      'restored_vendors': '成功恢復:value供應商',
      'new_expense': '輸入支出',
      'created_expense': '已成功建立支出',
      'updated_expense': '更新支出資料成功',
      'archived_expense': '歸檔支出項目成功',
      'deleted_expense': '刪除支出項目成功',
      'restored_expense': '復原支出資料成功',
      'archived_expenses': '歸檔支出項目成功',
      'deleted_expenses': '刪除支出項目成功',
      'restored_expenses': '成功恢復:value費用',
      'copy_shipping': '複製送貨地址',
      'copy_billing': '複製帳單地址',
      'design': '設計',
      'failed_to_find_record': '找不到記錄',
      'invoiced': '已開立發票的',
      'logged': '已登入',
      'running': '執行中',
      'resume': '繼續',
      'task_errors': '請修正所有的重疊時段',
      'start': '開始',
      'stop': '停止',
      'started_task': '展開任務成功',
      'stopped_task': '停止任務成功',
      'resumed_task': '復原任務成功',
      'now': '現在',
      'auto_start_tasks': '自動啟動任務',
      'timer': '計時器',
      'manual': '手動',
      'budgeted': '預算',
      'start_time': '開始時間',
      'end_time': '結束時間',
      'date': '日期',
      'times': '時段',
      'duration': '時間長度',
      'new_task': '新任務',
      'created_task': '建立工作項目成功',
      'updated_task': '更新工作項目成功',
      'archived_task': '歸檔任務資料成功',
      'deleted_task': '刪除任務成功',
      'restored_task': '復原任務資料成功',
      'archived_tasks': '歸檔 :count 項任務成功',
      'deleted_tasks': '刪除 :count 項任務成功',
      'restored_tasks': '成功恢復:value任務',
      'please_enter_a_name': '請輸入姓名',
      'budgeted_hours': '列入預算的小時',
      'created_project': '建立專案成功',
      'updated_project': '成功更新的專案',
      'archived_project': '歸檔專案項目成功',
      'deleted_project': 'Successfully deleted project',
      'restored_project': '復原專案成功',
      'archived_projects': '歸檔 :count 項專案成功',
      'deleted_projects': '刪除 :count 件專案成功',
      'restored_projects': '成功恢復:value項目',
      'new_project': '新專案',
      'thank_you_for_using_our_app': '感謝您使用我們的應用程式!',
      'if_you_like_it': '如果您喜歡，請',
      'click_here': '按一下此處',
      'click_here_capital': '點這裡',
      'to_rate_it': '給它評分。',
      'average': '平均',
      'unapproved': '未同意',
      'authenticate_to_change_setting': '請進行身份驗證以變更這個設定',
      'locked': '鎖定',
      'authenticate': '身份驗證',
      'please_authenticate': '請驗證',
      'biometric_authentication': '生物識別驗證',
      'footer': '頁尾',
      'compare': '比較',
      'hosted_login': '託管登入',
      'selfhost_login': 'Selfhost 登入',
      'google_sign_in': '使用 Google 登入',
      'today': '今天',
      'custom_range': '自訂範圍',
      'date_range': '日期範圍',
      'current': '目前',
      'previous': '以前',
      'current_period': '目前期限',
      'comparison_period': '比較期限',
      'previous_period': '上一期限',
      'previous_year': '上一年度',
      'compare_to': '比較',
      'last7_days': '最近 7 天',
      'last_week': '上個星期',
      'last30_days': '最近 30 天',
      'this_month': '本月',
      'last_month': '上個月',
      'this_year': '今年',
      'last_year': '下個月',
      'all_time': '整天',
      'custom': '自訂',
      'clone_to_invoice': '再製到發票',
      'clone_to_quote': '再製到報價單',
      'clone_to_credit': '克隆到信用',
      'view_invoice': '檢視發票',
      'convert': '轉換',
      'more': '更多',
      'edit_client': '編輯用戶',
      'edit_product': '編輯產品資料',
      'edit_invoice': '編輯發票',
      'edit_quote': '編輯報價單',
      'edit_payment': '編輯付款資料',
      'edit_task': '編輯工作項目',
      'edit_expense': '編輯支出',
      'edit_vendor': '編輯供應商',
      'edit_project': '編輯專案',
      'edit_recurring_quote': '編輯週期性報價單',
      'billing_address': '帳單地址',
      'shipping_address': '送貨位址',
      'total_revenue': '總收入',
      'average_invoice': '平均發票',
      'outstanding': '未付清的',
      'invoices_sent': '已寄出 :count 份發票',
      'active_clients': '活躍客戶',
      'close': '關閉',
      'email': '電子郵件',
      'password': '密碼',
      'url': 'URL',
      'secret': '秘密',
      'name': '姓名',
      'logout': '登出',
      'login': '登入',
      'filter': '篩選',
      'sort': '排序',
      'search': '搜尋',
      'active': '使用中',
      'archived': '已歸檔',
      'deleted': '已刪除',
      'dashboard': '儀表板',
      'archive': '檔案',
      'delete': '刪除',
      'restore': '復原',
      'refresh_complete': '重新整理完成',
      'please_enter_your_email': '請輸入您的電子郵件',
      'please_enter_your_password': '請輸入您的密碼',
      'please_enter_your_url': '請輸入您的網址',
      'please_enter_a_product_key': '請輸入產品金鑰',
      'ascending': '遞增',
      'descending': '遞減',
      'save': '節省',
      'an_error_occurred': '發生錯誤',
      'paid_to_date': '迄今付款',
      'balance_due': '欠款餘額',
      'balance': '差額',
      'overview': '總覽',
      'details': '詳細資料',
      'phone': '電話',
      'website': '網站',
      'vat_number': '加值稅編號',
      'id_number': 'ID 編號',
      'create': '創造',
      'copied_to_clipboard': '複製 :value 到剪貼簿',
      'error': '錯誤',
      'could_not_launch': '無法啟動',
      'contacts': '聯絡方式',
      'additional': '額外',
      'first_name': '名',
      'last_name': '姓',
      'add_contact': '新增聯絡人',
      'are_you_sure': '您確定嗎?',
      'cancel': '取消',
      'ok': '正常',
      'remove': '刪除',
      'email_is_invalid': '電子郵件無效',
      'product': '產品',
      'products': '產品',
      'new_product': '新產品',
      'created_product': '建立產品資料成功',
      'updated_product': '成功更新的產品資料',
      'archived_product': '歸檔產品資料成功',
      'deleted_product': '已成功刪除產品資料',
      'restored_product': '復原產品資料成功',
      'archived_products': '歸檔 :count 項產品資料成功',
      'deleted_products': '刪除 :count 筆產品資料成功',
      'restored_products': '成功恢復:value產品',
      'product_key': '產品',
      'notes': '註記',
      'cost': '成本',
      'client': '客戶',
      'clients': '客戶',
      'new_client': '新客戶',
      'created_client': '建立用戶資料成功',
      'updated_client': '更新用戶資料成功',
      'archived_client': '歸檔用戶資料成功',
      'archived_clients': '歸檔 :count 個用戶資料成功',
      'deleted_client': '刪除用戶資料成功',
      'deleted_clients': '刪除 :count 筆用戶資料成功',
      'restored_client': '復原用戶資料成功',
      'restored_clients': '成功恢復:value客戶端',
      'address1': '街道',
      'address2': '公寓/套房',
      'city': '城市',
      'state': '州/省',
      'postal_code': '郵遞區號',
      'country': '國家',
      'invoice': '發票',
      'invoices': '發票',
      'new_invoice': '新發票',
      'created_invoice': '製作完成的發票',
      'updated_invoice': '更新發票成功',
      'archived_invoice': '歸檔發票資料成功',
      'deleted_invoice': '刪除發票成功',
      'restored_invoice': '復原發票成功',
      'archived_invoices': '歸檔 :count 筆發票資料成功',
      'deleted_invoices': '刪除 :count 筆發票成功',
      'restored_invoices': '已成功恢復:value發票',
      'emailed_invoice': '以電子郵件寄出發票成功',
      'emailed_payment': '以電子郵件寄出付款成功',
      'amount': '金額',
      'invoice_number': '發票號碼',
      'invoice_date': '發票日期',
      'discount': '折扣',
      'po_number': '採購訂單編號',
      'terms': '條款',
      'public_notes': '公開註記',
      'private_notes': '私人筆記',
      'frequency': '頻率',
      'start_date': '開始日期',
      'end_date': '結束日期',
      'quote_number': '報價單編號',
      'quote_date': '報價單日期',
      'valid_until': '有效至',
      'items': '個項目',
      'partial_deposit': '存款',
      'description': '描述',
      'unit_cost': '單位成本',
      'quantity': '數量',
      'add_item': '加入項目',
      'contact': '聯絡人',
      'work_phone': '電話',
      'total_amount': '總金額',
      'pdf': 'PDF',
      'due_date': '到期日',
      'partial_due_date': '部分截止日期',
      'paid_date': '支付日期',
      'status': '狀態',
      'invoice_status_id': '發票狀態',
      'quote_status': '報價單狀態',
      'click_plus_to_add_item': '按一下 + 來加入項目',
      'click_plus_to_add_time': '按一下 + 來加入項目',
      'count_selected': ':count 項已選取',
      'total': '總計',
      'percent': '百分比',
      'edit': '編輯',
      'dismiss': '撤銷',
      'please_select_a_date': '請選取日期',
      'please_select_a_client': '請選取一個用戶',
      'please_select_an_invoice': '請選取發票',
      'task_rate': '任務費率',
      'settings': '設定',
      'language': '語言',
      'currency': '貨幣',
      'created_at': '建立日期',
      'created_on': '創建於',
      'updated_at': '更新',
      'tax': '稅',
      'please_enter_an_invoice_number': '請輸入發票編號',
      'please_enter_a_quote_number': '請輸入報價單編號',
      'past_due': '過去到期',
      'draft': '草稿',
      'sent': '已傳送',
      'viewed': '已檢視',
      'approved': '已核准',
      'partial': '存款',
      'paid': '已付款',
      'mark_sent': '標記已傳送',
      'marked_invoice_as_sent': '標記發票為已傳送成功',
      'marked_invoice_as_paid': '已成功將發票標記為已付款',
      'marked_invoices_as_sent': '已成功將發票標記為已發送',
      'marked_invoices_as_paid': '已成功將發票標記為已付款',
      'done': '完畢',
      'please_enter_a_client_or_contact_name': '請輸入用戶或連絡人姓名',
      'dark_mode': '黑暗模式',
      'restart_app_to_apply_change': '重新啟動應用程式以套用變更',
      'refresh_data': '重新整理資料',
      'blank_contact': '空白連絡人',
      'activity': '活動',
      'no_records_found': '找不到記錄',
      'clone': '再製',
      'loading': '載入中',
      'industry': '工業',
      'size': '大小',
      'payment_terms': '付款條款',
      'payment_date': '付款日期',
      'payment_status': '付款狀態',
      'payment_status_1': '擱置',
      'payment_status_2': '作廢',
      'payment_status_3': '失敗',
      'payment_status_4': '完成',
      'payment_status_5': '部分退款',
      'payment_status_6': '退款',
      'payment_status_-1': '未應用',
      'payment_status_-2': '部分未應用',
      'net': '淨額',
      'client_portal': '用戶門戶頁面',
      'show_tasks': '顯示任務',
      'email_reminders': '電子郵件提醒',
      'enabled': '啟用',
      'recipients': '收件人',
      'initial_email': '最初的電子郵件',
      'first_reminder': '首次提醒',
      'second_reminder': '第二次提醒',
      'third_reminder': '第三次提醒',
      'reminder1': '首次提醒',
      'reminder2': '第二次提醒',
      'reminder3': '第三次提醒',
      'template': '範本',
      'send': '傳送',
      'subject': '主旨',
      'body': '內文',
      'send_email': '寄送電子郵件',
      'email_receipt': '以電子郵件傳送付款收據給用戶',
      'auto_billing': '自動計費',
      'button': '按鈕',
      'preview': '預覽',
      'customize': '自訂',
      'history': '歷史',
      'payment': '付款',
      'payments': '付款',
      'refunded': '退款',
      'payment_type': '付款方式',
      'transaction_reference': '轉帳資料',
      'enter_payment': '輸入付款',
      'new_payment': '輸入付款',
      'created_payment': '已建立完成的付款資料',
      'updated_payment': '更新付款資料成功',
      'archived_payment': '歸檔付款資料成功',
      'deleted_payment': '刪除付款資料成功',
      'restored_payment': '復原付款資料成功',
      'archived_payments': '歸檔 :count 筆付款資料成功',
      'deleted_payments': '刪除 :count 筆付款資料成功',
      'restored_payments': '已成功恢復:value付款',
      'quote': '報價單',
      'quotes': '報價單',
      'new_quote': '新報價單',
      'created_quote': '報價單建立成功',
      'updated_quote': '報價單更新成功',
      'archived_quote': '歸檔報價單成功',
      'deleted_quote': '報價單刪除成功',
      'restored_quote': '復原報價單成功',
      'archived_quotes': '歸檔 :count 份報價單成功',
      'deleted_quotes': '刪除 :count 筆報價單成功',
      'restored_quotes': '成功恢復:value報價',
      'expense': '支出',
      'expenses': '支出',
      'vendor': '供應商',
      'vendors': '供應商',
      'task': '任務',
      'tasks': '任務',
      'project': '專案',
      'projects': '專案',
      'activity_1': ':user 已建立用戶 :client',
      'activity_2': ':user 已將用戶 :client 歸檔',
      'activity_3': ':user 已刪除用戶 :client',
      'activity_4': ':user 已建立發票 :invoice',
      'activity_5': ':user 已更新發票 :invoice',
      'activity_6': ':user emailed invoice :invoice for :client to :contact',
      'activity_7': ':contact viewed invoice :invoice for :client',
      'activity_8': ':user 已將發票 :invoice 歸檔',
      'activity_9': ':user 已刪除發票 :invoice',
      'activity_10': ':user輸入了:payment的付款:payment發票上的金額:invoice的:client',
      'activity_11': ':user 已更新付款資料 :payment',
      'activity_12': ':user 已將付款資料 :payment 歸檔',
      'activity_13': ':user 已刪除付款資料 :payment',
      'activity_14': ':user 已輸入貸款資料 :credit',
      'activity_15': ':user 更新貸款 :credit',
      'activity_16': ':user 已將 :credit 貸款資料歸檔',
      'activity_17': ':user 已刪除 :credit 貸款資料',
      'activity_18': ':user 已建立報價單 :quote',
      'activity_19': ':user 已更新報價單 :quote',
      'activity_20': ':user emailed quote :quote for :client to :contact',
      'activity_21': ':contact 已檢視報價單 :quote',
      'activity_22': ':user 已將報價單 :quote 歸檔',
      'activity_23': ':user 已刪除發票 :quote',
      'activity_24': ':user 已復原報價單 :quote',
      'activity_25': ':user 已復原發票 :invoice',
      'activity_26': ':user 已復原用戶 :client 資料',
      'activity_27': ':user 已復原付款資料 :payment',
      'activity_28': ':user 已復原 :credit 貸款資料',
      'activity_29': ':contact approved quote :quote for :client',
      'activity_30': ':user 已建立供應商 :vendor',
      'activity_31': ':user 已將供應商 :vendor 歸檔',
      'activity_32': ':user 已刪除供應商 :vendor',
      'activity_33': ':user 已復原供應商 :vendor',
      'activity_34': ':user 已建立支出 :expense',
      'activity_35': ':user 已將支出 :expense 歸檔',
      'activity_36': ':user 已刪除支出 :expense',
      'activity_37': ':user 已復原支出 :expense',
      'activity_39': ':user 已取消一項 :payment_amount 的付款 :payment',
      'activity_40': ':user 獲得一筆金額 :payment_amount 付款 :payment 的退款 :adjustment',
      'activity_41': ':payment_amount 的付款 (:payment) 失敗',
      'activity_42': ':user 已建立任務 :task',
      'activity_43': ':user 已將任務 :task 更新',
      'activity_44': ':user 已將任務 :task 歸檔',
      'activity_45': ':user 已刪除任務 :task',
      'activity_46': ':user 已將任務 :task復原',
      'activity_47': ':user 已將支出 :expense 更新',
      'activity_48': ':user建立使用者:user',
      'activity_49': ':user更新用戶:user',
      'activity_50': ':user存檔用戶:user',
      'activity_51': ':user已刪除使用者:user',
      'activity_52': ':user恢復用戶:user',
      'activity_53': ':user標記已發送:invoice',
      'activity_54': ':user已付款發票:invoice',
      'activity_55': ':contact 已回覆票證 :ticket',
      'activity_56': ':user 已檢視票證 :ticket',
      'activity_57': '系統無法透過電子郵件發送發票:invoice',
      'activity_58': ':user沖銷發票:invoice',
      'activity_59': ':user取消的發票:invoice',
      'activity_60': ':contact查看報價:quote',
      'activity_61': ':user更新客戶端:client',
      'activity_62': ':user更新供應商:vendor',
      'activity_63': ':user透過電子郵件將發票:invoice的第一次提醒發送至:contact',
      'activity_64': ':user透過電子郵件將發票:invoice的第二次提醒發送至:contact',
      'activity_65': ':user透過電子郵件將發票:invoice的第三次提醒發送至:contact',
      'activity_66': ':user透過電子郵件發送了發票:invoice的無盡提醒至:contact',
      'activity_80': ':user建立訂閱:subscription',
      'activity_81': ':user更新訂閱:subscription',
      'activity_82': ':user存檔訂閱:subscription',
      'activity_83': ':user已刪除訂閱:subscription',
      'activity_84': ':user恢復訂閱:subscription',
      'one_time_password': '一次性密碼',
      'emailed_quote': '以電子郵件寄出報價單成功',
      'emailed_credit': '已成功透過電子郵件發送信用證',
      'marked_quote_as_sent': '標記報價單為已傳送成功',
      'marked_credit_as_sent': '已成功將信用標記為已發送',
      'expired': '過期',
      'all': '全部',
      'select': '選擇',
      'long_press_multiselect': '長按多選',
      'custom_value1': '自訂值1',
      'custom_value2': '自訂值2',
      'custom_value3': '自訂值3',
      'custom_value4': '定制值4',
      'email_style_custom': '自訂電子郵件樣式',
      'custom_message_dashboard': '自訂儀表板訊息',
      'custom_message_unpaid_invoice': '自訂未付發票訊息',
      'custom_message_paid_invoice': '自訂付費發票訊息',
      'custom_message_unapproved_quote': '自訂未經批准的報價訊息',
      'lock_invoices': '鎖定發票',
      'translations': '翻譯',
      'task_number_pattern': '任務編號模式',
      'task_number_counter': '任務數量計數器',
      'expense_number_pattern': '費用數字模式',
      'expense_number_counter': '費用計數器',
      'vendor_number_pattern': '供應商編號模式',
      'vendor_number_counter': '供應商編號計數器',
      'ticket_number_pattern': '票號圖案',
      'ticket_number_counter': '票號櫃檯',
      'payment_number_pattern': '付款號碼模式',
      'payment_number_counter': '付款號碼櫃檯',
      'invoice_number_pattern': '發票號碼模式',
      'invoice_number_counter': '發票號碼計數器',
      'quote_number_pattern': '報價號碼模式',
      'quote_number_counter': '報價單編號計數器',
      'client_number_pattern': '信用號模式',
      'client_number_counter': '信用號碼櫃檯',
      'credit_number_pattern': '信用號模式',
      'credit_number_counter': '信用號碼櫃檯',
      'reset_counter_date': '重置計數器日期',
      'counter_padding': '計數器填充',
      'shared_invoice_quote_counter': '共享發票/報價櫃檯',
      'default_tax_name_1': '預設稅名 1',
      'default_tax_rate_1': '預設稅率 1',
      'default_tax_name_2': '預設稅名 2',
      'default_tax_rate_2': '預設稅率2',
      'default_tax_name_3': '預設稅名 3',
      'default_tax_rate_3': '預設稅率3',
      'email_subject_invoice': '電子郵件發票主題',
      'email_subject_quote': '電子郵件報價主題',
      'email_subject_payment': '郵件付款主題',
      'email_subject_payment_partial': '電子郵件部分付款主題',
      'show_table': '顯示表',
      'show_list': '顯示清單',
      'client_city': '客戶城市',
      'client_state': '客戶狀態',
      'client_country': '客戶國家',
      'client_is_active': '客戶端處於活動狀態',
      'client_balance': '客戶餘額',
      'client_address1': '客戶街',
      'client_address2': '客戶公寓/套房',
      'vendor_address1': '供應商街',
      'vendor_address2': '供應商 公寓/套房',
      'client_shipping_address1': '客戶航運街',
      'client_shipping_address2': '客戶運送公寓/套房',
      'type': '類型',
      'invoice_amount': '發票金額',
      'invoice_due_date': '應付款日期',
      'tax_rate1': '稅率1',
      'tax_rate2': '稅率2',
      'tax_rate3': '稅率3',
      'auto_bill': '自動帳單',
      'archived_at': '存檔於',
      'has_expenses': '有費用',
      'custom_taxes1': '關稅 1',
      'custom_taxes2': '關稅 2',
      'custom_taxes3': '關稅 3',
      'custom_taxes4': '關稅 4',
      'custom_surcharge1': '客製化附加費1',
      'custom_surcharge2': '客製化附加費2',
      'custom_surcharge3': '客製化附加費3',
      'custom_surcharge4': '客製化附加費 4',
      'is_deleted': '已刪除',
      'vendor_city': '供應商城市',
      'vendor_state': '供應商狀態',
      'vendor_country': '供應商國家/地區',
      'is_approved': '被批准',
      'tax_name': '稅名',
      'tax_amount': '稅金金額',
      'tax_paid': '已付稅',
      'payment_amount': '付款金額',
      'age': '年齡',
      'is_running': '在跑',
      'time_log': '時間日誌',
      'bank_id': '銀行',
      'expense_category_id': '費用類別 ID',
      'expense_category': '支出類別',
      'invoice_currency_id': '發票貨幣 ID',
      'tax_name1': '稅名 1',
      'tax_name2': '稅名2',
      'tax_name3': '稅名 3',
      'transaction_id': '交易ID',
      'status_color_theme': '狀態顏色主題',
      'load_color_theme': '載入顏色主題',
    },
    'hr': {
      'location': 'Location',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Location Deleted',
      'added_location': 'Successfully added location',
      'updated_location': 'Updated Location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': 'Lokacije',
      'preference_product_notes_for_html_view': 'Use Item Notes for HTML View',
      'preference_product_notes_for_html_view_help':
          'Preference the item Description over the item title if displaying the invoice in HTML.',
      'in_stock_quantity': 'Količina zaliha',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update':
          'Dopustite klijentima da ažuriraju svoj profil',
      'enable_client_profile_update_help':
          'Dopustite klijentima da ažuriraju svoje podatke o profilu s portala za klijente',
      'participant': 'sudionik',
      'merged_vendors': 'Dobavljači su uspješno spojeni',
      'activity_146': 'E-račun :invoice za :client uspješno isporučen! :notes',
      'activity_147': 'E-račun :invoice za :client neuspjelu isporuku. :notes',
      'activity_148': 'E-trošak :expense primljen od :vendor',
      'payment_failed': 'Plaćanje nije uspjelo',
      'activity_141': 'Korisnik :user je unio bilješku: :notes',
      'activity_142': 'Citat :quote podsjetnik 1 poslan',
      'activity_143': 'Auto Bill je uspio za fakturu :invoice',
      'activity_144': 'Auto Bill nije uspio za fakturu :invoice . :notes',
      'activity_145': 'E-račun :invoice za :client je poslan. :notes',
      'ssl_host_override': 'Nadjačavanje SSL hosta',
      'upload_logo_short': 'Prijenos logotipa',
      'show_pdfhtml_on_mobile_help':
          'Za poboljšanu vizualizaciju, prikazuje HTML verziju fakture/ponude prilikom gledanja na mobilnom uređaju.',
      'accept_purchase_order': 'Prihvatite narudžbenicu',
      'one_page_checkout': 'Plaćanje na jednoj stranici',
      'one_page_checkout_help':
          'Omogućite novi tijek plaćanja na jednoj stranici',
      'applies_to': 'Odnosi se na',
      'purchase_order_items': 'Stavke iz narudžbenice',
      'assigned_group': 'Grupa je uspješno dodijeljena',
      'assign_group': 'Dodijelite grupu',
      'merge_to_pdf': 'Spoji u PDF',
      'emails': 'Emails',
      'latest_requires_php_version':
          'Napomena: najnovija verzija zahtijeva PHP :version',
      'quote_reminder1': 'Podsjetnik na prvu ponudu',
      'before_valid_until': 'Prije vrijedi do',
      'after_valid_until': 'Nakon što vrijedi do',
      'after_quote_date': 'Nakon datuma ponude',
      'remind_quote': 'Podsjeti Citat',
      'task_assigned_notification': 'Obavijest o dodijeljenom zadatku',
      'task_assigned_notification_help':
          'Pošaljite e-poruku kada je zadatak dodijeljen',
      'invoices_locked_end_of_month':
          'Fakture se zaključavaju na kraju mjeseca',
      'end_of_month': 'Kraj mjeseca',
      'referral_url': 'URL preporuke',
      'referral_program': 'Referentni progam',
      'comment': 'Comment',
      'add_comment': 'Dodaj komentar',
      'added_comment': 'Komentar uspješno spremljen',
      'disconnected': 'Isključeno',
      'reconnect': 'Ponovno se spojite',
      'e_invoice_settings': 'Postavke e-fakture',
      'calculate': 'Izračunati',
      'sum': 'Iznos',
      'money': 'Novac',
      'time': 'Vrijeme',
      'format': 'Format',
      'web_app': 'Web aplikacija',
      'desktop_app': 'Aplikacija za stolna računala',
      'invoice_net_amount': 'Neto iznos fakture',
      'round_to_seconds': 'Zaokruži na sekunde',
      '1_minute': '1 minuta',
      '5_minutes': '5 minuta',
      '15_minutes': '15 minuta',
      '30_minutes': '30 minuta',
      '1_hour': '1 sat',
      '1_day': '1 dan',
      'round_tasks': 'Smjer zaokruživanja zadatka',
      'round_tasks_help': 'Vremena kružnog zadatka gore ili dolje.',
      'direction': 'Smjer',
      'round_up': 'Zaokruži',
      'round_down': 'Zaokruži prema dolje',
      'task_round_to_nearest': 'Zaokruži na najbliži',
      'activity_139': 'Obavijest o trošku :expense poslana na :contact',
      'activity_140': 'Izjava poslana na :client',
      'bulk_updated': 'Uspješno ažurirani podaci',
      'bulk_update': 'Skupno ažuriranje',
      'advanced_cards': 'Napredne kartice',
      'always_show_required_fields':
          'Uvijek prikaži formular s obaveznim poljima',
      'always_show_required_fields_help':
          'Prikazuje obavezna polja obrasca uvijek prilikom naplate',
      'flutter_web_warning':
          'Za najbolju izvedbu preporučujemo korištenje nove web-aplikacije ili aplikacije za stolna računala',
      'rappen_rounding': 'Rappen zaokruživanje',
      'rappen_rounding_help': 'Okrugli iznos do 5 centi',
      'check_credentials': 'Provjerite vjerodajnice',
      'valid_credentials': 'Akreditivi su valjani',
      'invalid_credentials': 'Ove vjerodajnice se ne odgovaraju našim zapisima',
      'e_quote': 'E-Citat',
      'e_credit': 'E-kredit',
      'e_purchase_order': 'E-narudžbenica',
      'valid_vat_number': 'Važeći PDV broj',
      'use_available_payments': 'Koristite dostupna plaćanja',
      'test_email_sent': 'E-pošta je uspješno poslana',
      'send_test_email': 'Pošalji probnu e-poštu',
      'gateway_type': 'Vrsta pristupnika',
      'please_select_an_invoice_or_credit': 'Odaberite fakturu ili kredit',
      'mobile_version': 'Mobilna verzija',
      'venmo': 'Venmo',
      'mercado_pago': 'Mercado Pago',
      'my_bank': 'MyBank',
      'pay_later': 'Platite kasnije',
      'email_report': 'Izvješće e-poštom',
      'host': 'Host',
      'port': 'Port',
      'encryption': 'Encryption',
      'local_domain': 'Lokalna domena',
      'verify_peer': 'Potvrdi Peer',
      'username': 'Korisničko ime',
      'nordigen_help':
          'Napomena: povezivanje računa zahtijeva GoCardless/Nordigen API ključ',
      'participant_name': 'Ime sudionika',
      'yodlee_regions': 'Regije: SAD, UK, Australija i Indija',
      'nordigen_regions': 'Regije: Europa i UK',
      'select_provider': 'Odaberite Provider',
      'payment_type_credit': 'Vrsta plaćanja Kredit',
      'payment_type_debit': 'Vrsta plaćanja Debit',
      'send_emails_to': 'Pošalji e-poštu na',
      'primary_contact': 'Primarni kontakt',
      'all_contacts': 'Svi kontakti',
      'insert_below': 'Umetni ispod',
      'ar_detailed': 'Detaljan prikaz potraživanja',
      'ar_summary': 'Sažetak potraživanja',
      'client_sales': 'Prodaja klijentima',
      'tax_summary': 'Porezni sažetak',
      'user_sales': 'Korisnička prodaja',
      'run_template': 'Pokreni predložak',
      'task_extension_banner':
          'Dodajte proširenje za Chrome za upravljanje svojim zadacima',
      'watch_video': 'Pogledaj Video',
      'view_extension': 'Prikaži proširenje',
      'reactivate_email': 'Ponovno aktivirajte e-poštu',
      'email_reactivated': 'E-pošta je uspješno ponovno aktivirana',
      'template_help': 'Omogućite korištenje dizajna kao predloška',
      'delivery_note_design': 'Dizajn otpremnice',
      'statement_design': 'Dizajn izjave',
      'payment_receipt_design': 'Dizajn potvrde o plaćanju',
      'payment_refund_design': 'Dizajn povrata plaćanja',
      'quarter': 'Četvrt',
      'item_description': 'Opis stavke',
      'task_item': 'Stavka zadatka',
      'record_state': 'Stanje zapisa',
      'last_login': 'Zadnja prijava',
      'save_files_to_this_folder': 'Spremite datoteke u ovu mapu',
      'downloads_folder': 'Mapa preuzimanja',
      'total_invoiced_quotes': 'Fakturirane ponude',
      'total_invoice_paid_quotes': 'Cijene plaćene fakture',
      'downloads_folder_does_not_exist': 'Mapa preuzimanja ne postoji :value',
      'user_logged_in_notification': 'Obavijest o prijavi korisnika',
      'user_logged_in_notification_help':
          'Pošaljite e-poštu kada se prijavljujete s nove lokacije',
      'client_contact': 'Kontakt s klijentom',
      'expense_status_4': 'Neplaćeno',
      'expense_status_5': 'Plaćeno',
      'recurring': 'Redovni',
      'ziptax_help':
          'Napomena: ova značajka zahtijeva Zip-Tax API ključ za pretraživanje američkog poreza na promet po adresi',
      'cache_data': 'Predmemorija podataka',
      'unknown': 'Nepoznato',
      'webhook_failure': 'Webhook neuspjeh',
      'email_opened': 'E-pošta otvorena',
      'email_delivered': 'E-pošta isporučena',
      'log': 'Dnevnik',
      'individual': 'Pojedinac',
      'partnership': 'Partnerstvo',
      'trust': 'Povjerenje',
      'charity': 'milosrđe',
      'government': 'Vlada',
      'classification': 'Klasifikacija',
      'click_or_drop_files_here': 'Ovdje kliknite ili ispustite datoteke',
      'public': 'Javnost',
      'private': 'Privatno',
      'image': 'Slika',
      'other': 'ostalo',
      'hash': 'Haš',
      'linked_to': 'Povezano s',
      'file_saved_in_path': 'Datoteka je spremljena u :path',
      'unlinked_transactions': 'Transakcije :count uspješno su prekinute',
      'unlinked_transaction': 'Transakcija je uspješno prekinuta',
      'unlink': 'Razdvoji',
      'view_dashboard_permission':
          'Dopusti korisniku pristup nadzornoj ploči, podaci su ograničeni na dostupna dopuštenja',
      'is_tax_exempt': 'Oslobođeno poreza',
      'district': 'Distrikt',
      'region': 'Regija',
      'county': 'Okrug',
      'tax_details': 'Porezni detalji',
      'activity_10_online':
          ':contact izvršio plaćanje :payment za fakturu :invoice za :client',
      'activity_10_manual':
          ':user uneseno plaćanje :payment za fakturu :invoice za :client',
      'default_payment_type': 'Zadana vrsta plaćanja',
      'admin_initiated_payments': 'Uplate koje pokreće administrator',
      'admin_initiated_payments_help':
          'Podrška za unos uplate u admin portal bez fakture',
      'use_mobile_to_manage_plan':
          'Koristite svoje postavke telefonske pretplate za upravljanje svojim planom',
      'show_task_billable': 'Prikaži naplativi zadatak',
      'credit_item': 'Kreditna stavka',
      'files': 'Datoteke',
      'camera': 'Fotoaparat',
      'gallery': 'Galerija',
      'email_count_invoices': 'Pošaljite fakture :count e-poštom',
      'project_location': 'Lokacija projekta',
      'invoice_task_item_description': 'Opis stavke zadatka fakture',
      'invoice_task_item_description_help':
          'Dodajte opis artikla stavkama fakture',
      'next_send_time': 'Vrijeme sljedećeg slanja',
      'uploaded_certificate': 'Uspješno učitana potvrda',
      'certificate_set': 'Set certifikata',
      'certificate_not_set': 'Certifikat nije postavljen',
      'passphrase_set': 'Zaporka postavljena',
      'passphrase_not_set': 'Zaporka nije postavljena',
      'upload_certificate': 'Učitaj certifikat',
      'certificate_passphrase': 'Zaporka certifikata',
      'rename': 'Preimenovati',
      'renamed_document': 'Dokument je uspješno preimenovan',
      'e_invoice': 'E-račun',
      'light_dark_mode': 'Svjetlo/tamno način rada',
      'activities': 'Aktivnosti',
      'routing_id': 'ID usmjeravanja',
      'enable_e_invoice': 'Omogući E-račun',
      'e_invoice_type': 'Vrsta e-računa',
      'e_quote_type': 'Vrsta e-ponude',
      'reduced_tax': 'Smanjeni porez',
      'override_tax': 'Zaobići porez',
      'zero_rated': 'Nulta ocjena',
      'reverse_tax': 'Obrnuti porez',
      'updated_tax_category': 'Uspješno ažurirana porezna kategorija',
      'updated_tax_categories': 'Porezne kategorije su uspješno ažurirane',
      'set_tax_category': 'Postavite kategoriju poreza',
      'payment_manual': 'Priručnik za plaćanje',
      'tax_category': 'Porezna kategorija',
      'physical_goods': 'Fizička roba',
      'digital_products': 'Digitalni proizvodi',
      'services': 'Usluge',
      'shipping': 'Dostava',
      'tax_exempt': 'Oslobođeno poreza',
      'reduced_rate': 'Snižena stopa',
      'tax_all': 'Porez na sve',
      'tax_selected': 'Porez odabran',
      'version': 'verzija',
      'seller_subregion': 'Podregija prodavača',
      'calculate_taxes': 'Izračunajte poreze',
      'calculate_taxes_help':
          'Automatski izračunajte poreze prilikom spremanja faktura',
      'admin': 'Administracija',
      'owner': 'Vlasnik',
      'link_expenses': 'Troškovi veze',
      'converted_client_balance': 'Pretvoreni saldo klijenta',
      'converted_payment_balance': 'Konvertirano stanje plaćanja',
      'total_hours': 'Ukupno sati',
      'date_picker_hint': 'Koristite +days za postavljanje datuma u budućnosti',
      'browser_pdf_viewer': 'Koristite preglednik PDF preglednika',
      'browser_pdf_viewer_help':
          'Upozorenje: Sprječava interakciju s aplikacijom preko PDF-a',
      'increase_prices': 'Povećajte cijene',
      'update_prices': 'Ažuriraj cijene',
      'incresed_prices': 'Cijene su uspješno stavljene u red za povećanje',
      'updated_prices':
          'Cijene su uspješno stavljene u red čekanja za ažuriranje',
      'bacs': 'BACS Izravno zaduženje',
      'api_token': 'API token',
      'api_key': 'API ključ',
      'endpoint': 'Krajnja točka',
      'billable': 'Billable',
      'not_billable': 'Nije naplativo',
      'allow_billable_task_items': 'Dopusti naplative stavke zadatka',
      'allow_billable_task_items_help':
          'Omogućite konfiguriranje stavki zadatka koje se naplaćuju',
      'show_task_item_description': 'Prikaži opis stavke zadatka',
      'show_task_item_description_help':
          'Omogući navođenje opisa stavki zadatka',
      'email_record': 'Zapis e-pošte',
      'invoice_product_columns': 'Stupci proizvoda fakture',
      'quote_product_columns': 'Stupci ponude proizvoda',
      'minimum_payment_amount': 'Minimalni iznos uplate',
      'client_initiated_payments': 'Plaćanja koja pokreće klijent',
      'client_initiated_payments_help':
          'Podrška pri plaćanju na portalu za klijente bez fakture',
      'share_invoice_quote_columns': 'Podijelite stupce faktura/ponuda',
      'cc_email': 'CC e-pošta',
      'payment_balance': 'Saldo plaćanja',
      'view_report_permission':
          'Dopustite korisniku pristup izvješćima, podaci su ograničeni na dostupna dopuštenja',
      'activity_138': 'Uplata :payment poslana je e-poštom na :client',
      'one_time_products': 'Jednokratni proizvodi',
      'optional_one_time_products': 'Izborni jednokratni proizvodi',
      'required': 'Potreban',
      'hidden': 'Skriven',
      'payment_links': 'Veze za plaćanje',
      'action': 'Akcija',
      'upgrade_to_paid_plan_to_schedule':
          'Nadogradite na plaćeni plan za izradu rasporeda',
      'next_run': 'Sljedeće trčanje',
      'all_clients': 'Svi klijenti',
      'show_aging_table': 'Prikaži tablicu starenja',
      'show_payments_table': 'Prikaži tablicu plaćanja',
      'only_clients_with_invoices': 'Samo klijenti s fakturama',
      'email_statement': 'Izjava putem e-pošte',
      'once': 'Jednom',
      'schedule': 'Raspored',
      'schedules': 'Rasporedi',
      'new_schedule': 'Novi raspored',
      'edit_schedule': 'Uredi raspored',
      'created_schedule': 'Uspješno napravljen raspored',
      'updated_schedule': 'Raspored je uspješno ažuriran',
      'archived_schedule': 'Raspored je uspješno arhiviran',
      'deleted_schedule': 'Raspored je uspješno izbrisan',
      'removed_schedule': 'Raspored je uspješno uklonjen',
      'restored_schedule': 'Raspored je uspješno vraćen',
      'search_schedule': 'Raspored pretraživanja',
      'search_schedules': 'Rasporedi pretraživanja',
      'archive_payment': 'Arhiviraj uplatu',
      'archive_invoice': 'Arhiviraj račun',
      'archive_quote': 'Arhiviraj ponudu',
      'archive_credit': 'Arhiviraj kredit',
      'archive_task': 'Arhiviraj zadatak',
      'archive_client': 'Arhiviraj klijenta',
      'archive_project': 'Arhiviraj projekt',
      'archive_expense': 'Arhiviraj trošak',
      'restore_payment': 'Obnovi uplatu',
      'restore_invoice': 'Obnovi račun',
      'restore_quote': 'Obnovi narudžbu',
      'restore_credit': 'Obnovi kredit',
      'restore_task': 'Obnovi zadatak',
      'restore_client': 'Obnovi klijenta',
      'restore_project': 'Restore Project',
      'restore_expense': 'Obnovi trošak',
      'archive_vendor': 'Arhiviraj dobavljača',
      'restore_vendor': 'Restore Vendor',
      'create_product': 'Dodaj proizvod',
      'update_product': 'Ažurirajte proizvod',
      'delete_product': 'Izbriši proizvod',
      'restore_product': 'Restore Product',
      'archive_product': 'Arhiviraj proizvod',
      'create_purchase_order': 'Kreirajte narudžbenicu',
      'update_purchase_order': 'Ažurirajte narudžbenicu',
      'delete_purchase_order': 'Izbriši narudžbenicu',
      'restore_purchase_order': 'Obnovi narudžbenicu',
      'archive_purchase_order': 'Arhivirajte narudžbenicu',
      'sent_invoice': 'Poslana faktura',
      'sent_quote': 'Poslana ponuda',
      'sent_credit': 'Poslano dobro',
      'sent_purchase_order': 'Poslana narudžbenica',
      'image_url': 'URL slike',
      'max_quantity': 'Maksimalna količina',
      'test_url': 'Test URL',
      'auto_bill_help_off': 'Opcija nije prikazana',
      'auto_bill_help_optin': 'Opcija je prikazana, ali nije odabrana',
      'auto_bill_help_optout': 'Opcija je prikazana i odabrana',
      'auto_bill_help_always': 'Opcija nije prikazana',
      'payment_methods': 'Payment Methods',
      'view_all': 'Pogledaj sve',
      'edit_all': 'Uredi sve',
      'accept_purchase_order_number': 'Prihvatite broj narudžbenice',
      'accept_purchase_order_number_help':
          'Omogućite klijentima da navedu broj narudžbenice prilikom odobravanja ponude',
      'from_email': 'Iz e-pošte',
      'show_preview': 'Prikaži pregled',
      'show_paid_stamp': 'Prikaži plaćenu marku',
      'show_shipping_address': 'Prikaži adresu za dostavu',
      'no_documents_to_download':
          'U odabranim zapisima nema dokumenata za preuzimanje',
      'pixels': 'pikseli',
      'logo_size': 'Veličina logotipa',
      'postal_city': 'Poštanski/grad',
      'failed': 'nije uspjelo',
      'client_contacts': 'Kontakti klijenata',
      'sync_from': 'Sinkronizacija iz',
      'inventory_threshold': 'Prag inventara',
      'hour': 'sat',
      'emailed_statement': 'Izjava je uspješno stavljena u red za slanje',
      'show_email_footer': 'Prikaži podnožje e-pošte',
      'invoice_task_hours': 'Radno vrijeme fakture',
      'invoice_task_hours_help': 'Dodajte sate u stavke fakture',
      'auto_bill_standard_invoices': 'Auto Bill Standardne fakture',
      'auto_bill_recurring_invoices':
          'Ponavljajuće fakture s automatskim obračunom',
      'email_alignment': 'Usklađivanje e-pošte',
      'pdf_preview_location': 'Lokacija PDF pregleda',
      'mailgun': 'poštanski pištolj',
      'postmark': 'Poštanski žig',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Pritisnite + za stvaranje zapisa',
      'last365_days': 'Posljednjih 365 dana',
      'import_design': 'Uvozni dizajn',
      'imported_design': 'Uspješno uvezen dizajn',
      'invalid_design': 'Dizajn je nevažeći, nedostaje dio :value',
      'setup_wizard_logo': 'Želite li učitati svoj logo?',
      'upload': 'Otpremi',
      'installed_version': 'Instalirana verzija',
      'notify_vendor_when_paid': 'Obavijestite dobavljača kada platite',
      'notify_vendor_when_paid_help':
          'Pošaljite e-poruku dobavljaču kada je trošak označen kao plaćen',
      'update_payment': 'Ažuriraj plaćanje',
      'markup': 'Markup',
      'purchase_order_created': 'Narudžbenica je kreirana',
      'purchase_order_sent': 'Narudžbenica je poslana',
      'purchase_order_viewed': 'Pregledana narudžbenica',
      'purchase_order_accepted': 'Narudžbenica prihvaćena',
      'credit_payment_error':
          'Iznos kredita ne može biti veći od iznosa uplate',
      'klarna': 'Klarna',
      'convert_payment_currency_help':
          'Postavite tečaj prilikom unosa ručnog plaćanja',
      'convert_expense_currency_help':
          'Postavite tečaj prilikom kreiranja troška',
      'matomo_url': 'Matomo URL',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Dodaj na fakturu',
      'online_payment_email_help':
          'Pošaljite e-poruku kada se izvrši online plaćanje',
      'manual_payment_email_help':
          'Pošaljite e-poruku prilikom ručnog unosa plaćanja',
      'mark_paid_payment_email_help':
          'Pošaljite e-poruku kada fakturu označite kao plaćenu',
      'delete_project': 'Izbriši projekt',
      'linked_transaction': 'Uspješno povezana transakcija',
      'link_payment': 'Link Plaćanje',
      'link_expense': 'Trošak veze',
      'lock_invoiced_tasks': 'Zaključaj fakturirane zadatke',
      'lock_invoiced_tasks_help':
          'Spriječite uređivanje zadataka nakon fakturiranja',
      'registration_required': 'Obavezna registracija',
      'registration_required_help':
          'Zahtijevati od klijenata da se registriraju',
      'use_inventory_management': 'Koristite upravljanje zalihama',
      'use_inventory_management_help':
          'Zahtijevati da proizvodi budu na zalihi',
      'optional_products': 'Izborni proizvodi',
      'optional_recurring_products': 'Izborni ponavljajući proizvodi',
      'convert_matched': 'Pretvoriti',
      'auto_billed_invoice':
          'Faktura je uspješno stavljena u red čekanja za automatsku naplatu',
      'auto_billed_invoices':
          'Fakture su uspješno stavljene u red čekanja za automatsku naplatu',
      'operator': 'Operater',
      'value': 'Vrijednost',
      'is': 'Je',
      'contains': 'Sadrži',
      'starts_with': 'Počinje s',
      'is_empty': 'Prazna je',
      'add_rule': 'Dodaj pravilo',
      'match_all_rules': 'Podudaranje svih pravila',
      'match_all_rules_help':
          'Svi kriteriji moraju odgovarati da bi se pravilo primijenilo',
      'auto_convert_help':
          'Automatski pretvorite povezane transakcije u troškove',
      'rules': 'Pravila',
      'transaction_rule': 'Pravilo transakcije',
      'transaction_rules': 'Pravila transakcije',
      'new_transaction_rule': 'Novo transakcijsko pravilo',
      'edit_transaction_rule': 'Uredi pravilo transakcije',
      'created_transaction_rule': 'Uspješno kreirano pravilo',
      'updated_transaction_rule': 'Pravilo transakcije je uspješno ažurirano',
      'archived_transaction_rule': 'Pravilo transakcije je uspješno arhivirano',
      'deleted_transaction_rule': 'Pravilo transakcije je uspješno izbrisano',
      'removed_transaction_rule': 'Pravilo transakcije je uspješno uklonjeno',
      'restored_transaction_rule': 'Uspješno vraćeno pravilo transakcije',
      'search_transaction_rule': 'Pravilo transakcije pretraživanja',
      'search_transaction_rules': 'Pretraživanje Transakcijskih pravila',
      'save_as_default_terms': 'Pohrani kao zadane uvjete',
      'save_as_default_footer': 'Pohrani kao zadano podnožje',
      'auto_sync': 'Automatska sinkronizacija',
      'refresh_accounts': 'Osvježi račune',
      'upgrade_to_connect_bank_account':
          'Nadogradite na Enterprise da povežete svoj bankovni račun',
      'click_here_to_connect_bank_account':
          'Kliknite ovdje da povežete svoj bankovni račun',
      'disable_2fa': 'Onemogući 2FA',
      'change_number': 'Promjena broja',
      'resend_code': 'Ponovno pošalji kod',
      'base_type': 'Vrsta baze',
      'category_type': 'Vrsta kategorije',
      'bank_transaction': 'Transakcija',
      'bulk_print': 'Ispiši PDF',
      'vendor_postal_code': 'Poštanski broj dobavljača',
      'preview_location': 'Pregled lokacije',
      'bottom': 'Dno',
      'side': 'Strana',
      'pdf_preview': 'PDF pregled',
      'long_press_to_select': 'Dugo pritisnite za odabir',
      'purchase_order_number': 'Broj narudžbenice',
      'purchase_order_item': 'Stavka narudžbenice',
      'would_you_rate_the_app': 'Želite li ocijeniti aplikaciju?',
      'include_deleted': 'Uključi Izbrisano',
      'include_deleted_help': 'Uključi izbrisane zapise u izvješća',
      'due_on': 'Rok dospijeća',
      'converted_transactions': 'Uspješno konvertirane transakcije',
      'created_bank_account': 'Uspješno kreiran bankovni račun',
      'updated_bank_account': 'Uspješno ažuriran bankovni račun',
      'edit_bank_account': 'Uredi bankovni račun',
      'default_category': 'Zadana kategorija',
      'account_type': 'Vrsta računa',
      'new_bank_account': 'Dodajte bankovni račun',
      'connect_accounts': 'Povežite račune',
      'manage_rules': 'Upravljanje pravilima',
      'search_category': 'Traži 1 kategoriju',
      'search_categories': 'Pretražite :count Kategorije',
      'min_amount': 'Min. iznos',
      'max_amount': 'Maksimalni iznos',
      'selected': 'Selected',
      'converted_transaction': 'Uspješno konvertirana transakcija',
      'convert_to_payment': 'Pretvori u plaćanje',
      'deposit': 'Polog',
      'withdrawal': 'Povlačenje',
      'deposits': 'Depoziti',
      'withdrawals': 'Isplate',
      'matched': 'Podudaranje',
      'unmatched': 'Bez premca',
      'create_credit': 'Kreirajte kredit',
      'update_credit': 'Ažuriraj kredit',
      'delete_credit': 'Obriši kredit',
      'transaction': 'Transakcija',
      'transactions': 'Transakcije',
      'new_transaction': 'Nova transakcija',
      'edit_transaction': 'Uredi transakciju',
      'created_transaction': 'Uspješno kreirana transakcija',
      'updated_transaction': 'Transakcija je uspješno ažurirana',
      'archived_transaction': 'Transakcija je uspješno arhivirana',
      'deleted_transaction': 'Transakcija je uspješno izbrisana',
      'removed_transaction': 'Transakcija je uspješno uklonjena',
      'restored_transaction': 'Transakcija je uspješno vraćena',
      'search_transaction': 'Traženje transakcije',
      'search_transactions': 'Pretražite :count Transakcije',
      'bank_account': 'Bank Account',
      'bank_accounts': 'Kreditne kartice & banke',
      'archived_bank_account': 'Uspješno arhiviran bankovni račun',
      'deleted_bank_account': 'Uspješno izbrisan bankovni račun',
      'removed_bank_account': 'Uspješno uklonjen bankovni račun',
      'restored_bank_account': 'Bankovni račun uspješno vraćen',
      'search_bank_account': 'Pretraži bankovni račun',
      'search_bank_accounts': 'Pretražite :count bankovne račune',
      'connect': 'Poveži se',
      'mark_paid_payment_email': 'Označi plaćeno plaćanje e-poštom',
      'convert_to_project': 'Pretvori u projekt',
      'client_email': 'E-pošta klijenta',
      'invoice_task_project': 'Projekt zadatka fakture',
      'invoice_task_project_help': 'Dodajte projekt u stavke fakture',
      'field': 'Polje',
      'period': 'Razdoblje',
      'fields_per_row': 'Polja po retku',
      'total_active_invoices': 'Aktivne fakture',
      'total_outstanding_invoices': 'Nepodmirene fakture',
      'total_completed_payments': 'Dovršena plaćanja',
      'total_refunded_payments': 'Povratna plaćanja',
      'total_active_quotes': 'Aktivni citati',
      'total_approved_quotes': 'Odobreni citati',
      'total_unapproved_quotes': 'Neodobreni citati',
      'total_logged_tasks': 'Zabilježeni zadaci',
      'total_invoiced_tasks': 'Fakturirani zadaci',
      'total_paid_tasks': 'Plaćeni zadaci',
      'total_logged_expenses': 'Zabilježeni troškovi',
      'total_pending_expenses': 'Nepodmireni troškovi',
      'total_invoiced_expenses': 'Fakturirani troškovi',
      'total_invoice_paid_expenses': 'Plaćeni troškovi po fakturi',
      'activity_130': ':user kreirana narudžbenica :purchase_order',
      'activity_131': ':user ažurirana narudžbenica :purchase_order',
      'activity_132': ':user arhivirana narudžbenica :purchase_order',
      'activity_133': ':user izbrisana narudžbenica :purchase_order',
      'activity_134': ':user vraćena narudžbenica :purchase_order',
      'activity_135': ':user narudžbenica poslana e-poštom :purchase_order',
      'activity_136': ':contact pogledana narudžbenica :purchase_order',
      'activity_137': ':contact prihvaćena narudžbenica :purchase_order',
      'vendor_portal': 'Portal dobavljača',
      'send_code': 'Pošalji kod',
      'save_to_upload_documents': 'Spremite zapis za učitavanje dokumenata',
      'expense_tax_rates': 'Stope poreza na rashod',
      'invoice_item_tax_rates': 'Porezne stope stavki fakture',
      'verified_phone_number': 'Telefonski broj je uspješno potvrđen',
      'code_was_sent': 'Kôd je poslan putem SMS-a',
      'code_was_sent_to': 'Kôd je poslan putem SMS-a na :number',
      'resend': 'Ponovno pošalji',
      'verify': 'Potvrdi',
      'enter_phone_number': 'Molimo navedite telefonski broj',
      'invalid_phone_number': 'Nevažeći telefonski broj',
      'verify_phone_number': 'Potvrdite telefonski broj',
      'verify_phone_number_help':
          'Potvrdite svoj broj telefona za slanje e-pošte',
      'verify_phone_number_2fa_help':
          'Potvrdite svoj telefonski broj za 2FA sigurnosnu kopiju',
      'merged_clients': 'Uspješno spojeni klijenti',
      'merge_into': 'Spoji se u',
      'merge': 'Spoji',
      'price_change_accepted': 'Promjena cijene prihvatljiva',
      'price_change_failed': 'Promjena cijene nije uspjela kodom',
      'restore_purchases': 'Obnovi kupnje',
      'activate': 'Aktivirati',
      'connect_apple': 'Povežite Apple',
      'disconnect_apple': 'Odspojite Apple',
      'disconnected_apple': 'Apple je uspješno prekinut vezu',
      'send_now': 'Pošalji sada',
      'received': 'Primljeno',
      'purchase_order_date': 'Datum narudžbenice',
      'converted_to_expense': 'Uspješno pretvoreno u trošak',
      'converted_to_expenses': 'Uspješno pretvoreno u troškove',
      'convert_to_expense': 'Pretvori u trošak',
      'add_to_inventory': 'Dodaj u inventar',
      'added_purchase_order_to_inventory':
          'Narudžbenica je uspješno dodana u inventar',
      'added_purchase_orders_to_inventory':
          'Narudžbenice su uspješno dodane u inventar',
      'client_document_upload': 'Prijenos klijentovog dokumenta',
      'vendor_document_upload': 'Prijenos dokumenata dobavljača',
      'vendor_document_upload_help':
          'Omogućite dobavljačima učitavanje dokumenata',
      'are_you_enjoying_the_app': 'Uživate li u aplikaciji?',
      'yes_its_great': 'Da, super je!',
      'not_so_much': 'Ne toliko',
      'would_you_rate_it': 'Super za čuti! Želite li ga ocijeniti?',
      'would_you_tell_us_more':
          'Žao mi je što to čujem! Želite li nam reći nešto više?',
      'sure_happy_to': 'Naravno, rado',
      'no_not_now': 'Ne, ne sada',
      'add': 'Dodati',
      'last_sent_template': 'Zadnji poslani predložak',
      'enable_flexible_search': 'Omogući fleksibilno pretraživanje',
      'enable_flexible_search_help':
          'Spajanje nesusjednih znakova, tj. &quot;ct&quot; odgovara &quot;cat&quot;',
      'vendor_details': 'Podaci o dobavljaču',
      'purchase_order_details': 'Detalji narudžbenice',
      'qr_iban': 'QR IBAN',
      'besr_id': 'BESR ID',
      'accept': 'Accept',
      'clone_to_purchase_order': 'Kloniraj u PO',
      'vendor_email_not_set': 'Dobavljač nema postavljenu adresu e-pošte',
      'bulk_send_email': 'Pošalji e-poštu',
      'marked_purchase_order_as_sent':
          'Narudžbenica je uspješno označena kao poslana',
      'marked_purchase_orders_as_sent':
          'Narudžbenice su uspješno označene kao poslane',
      'accepted_purchase_order': 'Uspješno prihvaćena narudžbenica',
      'accepted_purchase_orders': 'Uspješno prihvaćene narudžbenice',
      'cancelled_purchase_order': 'Narudžbenica je uspješno otkazana',
      'cancelled_purchase_orders': 'Narudžbenice su uspješno otkazane',
      'accepted': 'Prihvaćeno',
      'please_select_a_vendor': 'Odaberite dobavljača',
      'purchase_order_total': 'Ukupna narudžbenica',
      'email_purchase_order': 'Narudžbenica putem e-pošte',
      'bulk_email_purchase_orders': 'Narudžbenice putem e-pošte',
      'disconnected_email': 'E-pošta je uspješno prekinuta',
      'connect_email': 'Povežite e-poštu',
      'disconnect_email': 'Prekini vezu s e-poštom',
      'use_web_app_to_connect_microsoft':
          'Upotrijebite web-aplikaciju za povezivanje s Microsoftom',
      'email_provider': 'Davatelj usluge e-pošte',
      'connect_microsoft': 'Povežite Microsoft',
      'disconnect_microsoft': 'Odspojite Microsoft',
      'connected_microsoft': 'Uspješno povezan Microsoft',
      'disconnected_microsoft': 'Microsoft je uspješno prekinut vezu',
      'microsoft_sign_in': 'Prijavite se s Microsoftom',
      'microsoft_sign_up': 'Prijavite se s Microsoftom',
      'emailed_purchase_order':
          'Narudžbenica je uspješno stavljena u red čekanja za slanje',
      'emailed_purchase_orders':
          'Narudžbenice su uspješno stavljene u red čekanja za slanje',
      'enable_react_app': 'Prijeđite na React web aplikaciju',
      'purchase_order_design': 'Dizajn narudžbenice',
      'purchase_order_terms': 'Uvjeti narudžbenice',
      'purchase_order_footer': 'Podnožje narudžbenice',
      'require_purchase_order_signature': 'Potpis narudžbenice',
      'require_purchase_order_signature_help':
          'Zahtijevajte od dobavljača da da svoj potpis.',
      'purchase_order': 'Narudžbenica',
      'purchase_orders': 'Narudžbenice',
      'new_purchase_order': 'Nova narudžbenica',
      'edit_purchase_order': 'Uredite narudžbenicu',
      'created_purchase_order': 'Uspješno kreirana narudžbenica',
      'updated_purchase_order': 'Narudžbenica je uspješno ažurirana',
      'archived_purchase_order': 'Narudžbenica je uspješno arhivirana',
      'deleted_purchase_order': 'Narudžbenica je uspješno izbrisana',
      'removed_purchase_order': 'Narudžbenica je uspješno uklonjena',
      'restored_purchase_order': 'Narudžbenica je uspješno vraćena',
      'search_purchase_order': 'Pretraživanje narudžbenice',
      'search_purchase_orders': 'Pretraživanje narudžbenica',
      'login_url': 'URL za prijavu',
      'payment_settings': 'Payment Settings',
      'default': 'Default',
      'stock_quantity': 'Količina zaliha',
      'notification_threshold': 'Prag obavijesti',
      'track_inventory': 'Pratite zalihe',
      'track_inventory_help':
          'Prikažite polje zaliha proizvoda i ažurirajte kada se fakture pošalju',
      'stock_notifications': 'Obavijesti o dionicama',
      'stock_notifications_help':
          'Pošaljite e-poruku kada dionice dosegnu prag',
      'vat': 'PDV',
      'standing': 'Stanje',
      'view_map': 'Pogledaj kartu',
      'set_default_design': 'Postavite zadani dizajn',
      'add_gateway': 'Dodajte pristupnik plaćanja',
      'add_gateway_help_message':
          'Dodajte pristupnik plaćanja (tj. Stripe, WePay ili PayPal) za prihvaćanje plaćanja putem interneta',
      'left': 'Lijevo',
      'right': 'Pravo',
      'center': 'Centar',
      'page_numbering': 'Numeriranje stranica',
      'page_numbering_alignment': 'Poravnanje numeriranja stranica',
      'invoice_sent_notification_label': 'Faktura poslana',
      'show_product_description': 'Prikaži opis proizvoda',
      'show_product_description_help':
          'Uključite opis u padajući izbornik proizvoda',
      'invoice_items': 'Stavke fakture',
      'quote_items': 'Predmeti ponude',
      'profitloss': 'Dobit i gubitak',
      'import_format': 'Format uvoza',
      'export_format': 'Format izvoza',
      'export_type': 'Vrsta izvoza',
      'stop_on_unpaid': 'Stop On Unpaid',
      'stop_on_unpaid_help':
          'Prestanite stvarati ponavljajuće fakture ako posljednja faktura nije plaćena.',
      'use_quote_terms': 'Koristite uvjete ponude',
      'use_quote_terms_help': 'Prilikom pretvaranja ponude u fakturu',
      'add_country': 'Dodaj zemlju',
      'enable_tooltips': 'Omogući opise alata',
      'enable_tooltips_help': 'Prikaži opise alata kada lebdite mišem',
      'multiple_client_error':
          'Pogreška: zapisi pripadaju više od jednog klijenta',
      'register_label': 'Izradite svoj račun u nekoliko sekundi',
      'login_label': 'Prijavite se na postojeći račun',
      'add_to_invoice': 'Dodaj računu :invoice',
      'no_invoices_found': 'Nisu pronađene fakture',
      'week': 'Tjedan',
      'created_record': 'Uspješno kreiran zapis',
      'auto_archive_paid_invoices': 'Automatsko arhiviranje plaćeno',
      'auto_archive_paid_invoices_help':
          'Automatski arhivirajte račune kada su plaćeni.',
      'auto_archive_cancelled_invoices': 'Automatsko arhiviranje otkazano',
      'auto_archive_cancelled_invoices_help':
          'Automatski arhivirajte fakture nakon otkazivanja.',
      'alternate_pdf_viewer': 'Alternativni PDF preglednik',
      'alternate_pdf_viewer_help':
          'Poboljšajte pomicanje preko PDF pregleda [BETA]',
      'invoice_currency': 'Valuta računa',
      'range': 'Raspon',
      'tax_amount1': 'Iznos poreza 1',
      'tax_amount2': 'Iznos poreza 2',
      'tax_amount3': 'Iznos poreza 3',
      'create_project': 'Create project',
      'update_project': 'Ažurirajte projekt',
      'view_task': 'Prikaži zadatak',
      'cancel_invoice': 'Otkazati',
      'changed_status': 'Uspješno promijenjen status zadatka',
      'change_status': 'Promjena statusa',
      'fees_sample': 'The fee for a :amount invoice would be :total.',
      'enable_touch_events': 'Omogući događaje dodira',
      'enable_touch_events_help': 'Podrška za povlačenje događaja za pomicanje',
      'after_saving': 'Nakon spremanja',
      'view_record': 'Pogledaj zapis',
      'enable_email_markdown': 'Omogući označavanje e-pošte',
      'enable_email_markdown_help':
          'Koristite uređivač vizualnog označavanja za e-poštu',
      'enable_pdf_markdown': 'Omogući PDF Markdown',
      'json_help':
          'Napomena: JSON datoteke koje generira aplikacija v4 nisu podržane',
      'release_notes': 'Bilješke o izdanju',
      'upgrade_to_view_reports': 'Nadogradite svoj plan za pregled izvješća',
      'started_tasks': 'Uspješno pokrenuti :value zadaci',
      'stopped_tasks': 'Uspješno zaustavljeni :value zadaci',
      'approved_quote': 'Ponuda je uspješno odobrena',
      'approved_quotes': 'Uspješno :value odobrene ponude',
      'approve': 'Odobri',
      'client_website': 'Web stranica klijenta',
      'invalid_time': 'Nevažeće vrijeme',
      'client_shipping_state': 'Stanje isporuke klijenta',
      'client_shipping_city': 'Grad dostave klijenta',
      'client_shipping_postal_code': 'Poštanski broj za otpremu klijenta',
      'client_shipping_country': 'Zemlja dostave klijenta',
      'load_pdf': 'Učitaj PDF',
      'start_free_trial': 'Započni besplatnu probu',
      'start_free_trial_message':
          'Započnite BESPLATNO 14-dnevno probno razdoblje Pro Plana',
      'due_on_receipt': 'Dospijeva pri primitku',
      'is_paid': 'Je Plaćeno',
      'age_group_paid': 'Plaćeno',
      'id': 'Id',
      'convert_to': 'Pretvori u',
      'client_currency': 'Valuta klijenta',
      'company_currency': 'Valuta tvrtke',
      'purged_client': 'Successfully purged client',
      'custom_emails_disabled_help':
          'Kako bismo spriječili spam, zahtijevamo nadogradnju na plaćeni račun za prilagodbu e-pošte',
      'upgrade_to_add_company': 'Nadogradite svoj plan za dodavanje tvrtki',
      'small': 'Mali',
      'marked_credit_as_paid': 'Kredit je uspješno označen kao plaćen',
      'marked_credits_as_paid': 'Krediti su uspješno označeni kao plaćeni',
      'wait_for_loading': 'Učitavanje podataka - pričekajte da se završi',
      'wait_for_saving': 'Spremanje podataka - pričekajte da se završi',
      'html_preview_warning':
          'Napomena: promjene napravljene ovdje mogu se samo pregledati, moraju se primijeniti na gornjim karticama da bi se spremile',
      'remaining': 'Preostalo',
      'invoice_paid': 'Faktura plaćena',
      'activity_120': ':user stvorio ponavljajući trošak :recurring_expense',
      'activity_121': ':user ažurirani tekući trošak :recurring_expense',
      'activity_122': ':user arhivirani tekući trošak :recurring_expense',
      'activity_123': ':user izbrisani tekući trošak :recurring_expense',
      'activity_124': ':user obnovljeni tekući trošak :recurring_expense',
      'normal': 'Normalan',
      'large': 'velika',
      'extra_large': 'Ekstra velika',
      'show_pdf_preview': 'Prikaži PDF pregled',
      'show_pdf_preview_help': 'Prikaz PDF pregleda tijekom uređivanja faktura',
      'print_pdf': 'Ispiši PDF',
      'remind_me': 'Podsjeti me',
      'instant_bank_pay': 'Instant bankovno plaćanje',
      'click_selected': 'Pritisnite Odabrano',
      'hide_preview': 'Sakrij pretpregled',
      'edit_record': 'Uredi zapis',
      'credit_is_more_than_invoice':
          'Iznos kredita ne može biti veći od iznosa fakture',
      'giropay': 'GiroPay',
      'direct_debit': 'Izravno zaduženje',
      'please_set_a_password': 'Molimo postavite lozinku za račun',
      'set_password': 'Postava zaporke',
      'disconnected_gateway': 'Pristupnik je uspješno isključen',
      'disconnect': 'Prekini vezu',
      'add_to_invoices': 'Dodaj u fakture',
      'acss': 'ACSS Debit',
      'becs': 'BECS Izravno zaduženje',
      'bulk_download': 'preuzimanje',
      'persist_data_help':
          'Spremite podatke lokalno kako biste omogućili brže pokretanje aplikacije, onemogućavanje može poboljšati izvedbu na velikim računima',
      'persist_ui': 'Trajno korisničko sučelje',
      'persist_ui_help':
          'Spremi stanje korisničkog sučelja lokalno kako bi se aplikaciji omogućilo pokretanje na zadnjoj lokaciji, onemogućavanjem se može poboljšati izvedba',
      'client_postal_code': 'Poštanski broj klijenta',
      'client_vat_number': 'PDV broj klijenta',
      'has_tasks': 'Ima zadatke',
      'registration': 'Registracija',
      'unauthorized_stripe_warning':
          'Ovlastite Stripe za prihvaćanje online plaćanja.',
      'view_expense': 'Pregled troškova # :expense',
      'view_statement': 'Moje Izvješće',
      'sepa': 'SEPA Direct Debit',
      'ideal': 'IDEALNO',
      'przelewy24': 'Przelewy24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'Ažurirajte sve zapise',
      'system': 'Sustav',
      'set_default_company': 'Postavite zadanu tvrtku',
      'updated_company': 'Uspješno ažurirana tvrtka',
      'kbc': 'KBC',
      'bancontact': 'Bancontact',
      'why_are_you_leaving':
          'Pomozite nam da se poboljšamo tako što ćete nam reći zašto (nije obavezno)',
      'webhook_success': 'Webhook uspjeh',
      'error_cross_client_tasks': 'Svi zadaci moraju pripadati istom klijentu',
      'error_cross_client_expenses':
          'Svi troškovi moraju pripadati istom klijentu',
      'app': 'aplikacija',
      'for_best_performance': 'Za najbolju izvedbu preuzmite aplikaciju :app',
      'gross_line_total': 'Ukupna bruto linija',
      'bulk_email_invoices': 'E-mail fakture',
      'bulk_email_quotes': 'Citati putem e-pošte',
      'bulk_email_credits': 'Krediti za e-poštu',
      'from_name': 'From Name',
      'clone_to_expense': 'Clone to Expense',
      'recurring_expense': 'Redovni trošak',
      'recurring_expenses': 'Redovni troškovi',
      'new_recurring_expense': 'Novi redovni trošak',
      'edit_recurring_expense': 'Uredi redovne troškove',
      'created_recurring_expense': 'Uspješno kreiran redovni trošak',
      'updated_recurring_expense': 'Uspješno uređen redovni trošak',
      'archived_recurring_expense': 'Uspješno arhiviran redovni trošak',
      'deleted_recurring_expense': 'Uspješno izbrisani ponavljajući trošak',
      'removed_recurring_expense': 'Uspješno uklonjen ponavljajući trošak',
      'restored_recurring_expense': 'Successfully restored recurring expense',
      'search_recurring_expense': 'Pretraživanje ponavljajućih troškova',
      'search_recurring_expenses': 'Pretraživanje tekućih troškova',
      'last_sent_date': 'Datum zadnjeg slanja',
      'include_drafts': 'Uključi nacrte',
      'include_drafts_help': 'Uključite nacrte zapisa u izvješća',
      'is_invoiced': 'Fakturirana je',
      'change_plan': 'Upravljanje planom',
      'persist_data': 'Trajanje podataka',
      'customer_count': 'Broj kupaca',
      'verify_customers': 'Provjerite kupce',
      'google_analytics': 'Google Analytics',
      'google_analytics_tracking_id': 'Google Analytics ID praćenja',
      'decimal_comma': 'Decimalni zarez',
      'use_comma_as_decimal_place':
          'Koristite zarez kao decimalno mjesto u obrascima',
      'select_method': 'Odaberite metodu',
      'select_platform': 'Odaberite Platforma',
      'use_web_app_to_connect_gmail':
          'Upotrijebite web-aplikaciju za povezivanje s Gmailom',
      'expense_tax_help': 'Stope poreza na artikle su onemogućene',
      'enable_markdown': 'Omogući Markdown',
      'enable_markdown_help': 'Pretvorite markdown u HTML na PDF-u',
      'user_guide': 'User Guide',
      'add_second_contact': 'Dodaj drugi kontakt',
      'previous_page': 'Prethodna stranica',
      'next_page': 'Sljedeća stranica',
      'export_colors': 'Izvoz boja',
      'import_colors': 'Uvoz boja',
      'clear_all': 'Obriši sve',
      'contrast': 'Kontrast',
      'custom_colors': 'Prilagođene boje',
      'colors': 'Boje',
      'sidebar_active_background_color': 'Boja aktivne pozadine bočne trake',
      'sidebar_active_font_color': 'Aktivna boja fonta bočne trake',
      'sidebar_inactive_background_color':
          'Neaktivna boja pozadine bočne trake',
      'sidebar_inactive_font_color': 'Neaktivna boja fonta bočne trake',
      'table_alternate_row_background_color':
          'Boja pozadine alternativnog retka tablice',
      'invoice_header_background_color': 'Boja pozadine zaglavlja fakture',
      'invoice_header_font_color': 'Boja fonta zaglavlja fakture',
      'net_subtotal': 'Neto',
      'review_app': 'Pregledajte aplikaciju',
      'check_status': 'Provjerite status',
      'free_trial': 'Besplatna proba',
      'free_trial_ends_in_days':
          'Probno razdoblje Pro plana završava za :count dana, kliknite za nadogradnju.',
      'free_trial_ends_today':
          'Danas je zadnji dan probnog razdoblja Pro plana, kliknite za nadogradnju.',
      'change_email': 'Promjena e-pošte',
      'client_portal_domain_hint':
          'Po želji konfigurirajte zasebnu domenu klijentskog portala',
      'tasks_shown_in_portal': 'Zadaci prikazani na portalu',
      'uninvoiced': 'Nefakturirano',
      'subdomain_guide':
          'Poddomena se koristi na klijentskom portalu za personalizaciju poveznica koje odgovaraju vašem brendu. tj. https://your-brand.invoicing.co',
      'send_time': 'Vrijeme slanja',
      'import_data': 'Uvezi podatke',
      'import_settings': 'Postavke uvoza',
      'json_file_missing': 'Navedite JSON datoteku',
      'json_option_missing': 'Odaberite uvoz postavki i/ili podataka',
      'json': 'JSON',
      'no_payment_types_enabled': 'Nema omogućenih vrsta plaćanja',
      'wait_for_data': 'Pričekajte da se podaci završe s učitavanjem',
      'net_total': 'Neto ukupno',
      'has_taxes': 'Ima poreze',
      'import_customers': 'Uvoz kupaca',
      'imported_customers': 'Uspješno započeo uvoz kupaca',
      'login_success': 'Uspješna prijava',
      'login_failure': 'Prijava nije uspjela',
      'exported_data':
          'Kada je datoteka spremna, primit ćete e-poruku s vezom za preuzimanje',
      'include_deleted_clients': 'Uključi izbrisane klijente',
      'include_deleted_clients_help':
          'Učitaj zapise koji pripadaju izbrisanim klijentima',
      'step_1_sign_in': 'Korak 1: Prijavite se',
      'step_2_authorize': 'Korak 2: Autorizirajte',
      'account_id': 'ID računa',
      'migration_not_yet_completed': 'Migracija još nije dovršena',
      'activity_100': ':user kreirana ponavljajuća faktura :recurring_invoice',
      'activity_101': ':user ažurirana ponavljajuća faktura :recurring_invoice',
      'activity_102':
          ':user arhivirana ponavljajuća faktura :recurring_invoice',
      'activity_103': ':user izbrisana ponavljajuća faktura :recurring_invoice',
      'activity_104': ':user vraćena ponavljajuća faktura :recurring_invoice',
      'show_task_end_date': 'Prikaži datum završetka zadatka',
      'show_task_end_date_help': 'Omogućite navođenje datuma završetka zadatka',
      'gateway_setup': 'Postavljanje pristupnika',
      'preview_sidebar': 'Bočna traka pregleda',
      'years_data_shown': 'Prikazani podaci o godinama',
      'ended_all_sessions': 'Uspješno završene sve sesije',
      'end_all_sessions': 'Završi sve sesije',
      'count_session': '1 sesija',
      'count_sessions': ':count Sesije',
      'invoice_created': 'Izrađena faktura',
      'quote_created': 'Ponuda stvorena',
      'credit_created': 'Kredit stvoren',
      'pro': 'Pro',
      'enterprise': 'Poduzeće',
      'last_updated': 'Zadnje ažuriranje',
      'invoice_item': 'Stavka fakture',
      'quote_item': 'Stavka citata',
      'contact_first_name': 'Contact First Name',
      'contact_last_name': 'Contact Last Name',
      'order': 'Redoslijed',
      'unassigned': 'Unassigned',
      'partial_value': 'Mora biti veće od nula i manje od zbroja',
      'search_kanban': 'Traži Kanban',
      'search_kanbans': 'Traži Kanban',
      'kanban': 'Kanban',
      'enable': 'Omogući',
      'move_top': 'Pomakni vrh',
      'move_up': 'Pomakni se gore',
      'move_down': 'Pomakni dolje',
      'move_bottom': 'Pomakni dno',
      'subdomain_help':
          'Postavi poddomenu ili prikazujte račune na vlastitoj web stranici.',
      'body_variable_missing':
          'Pogreška: prilagođena e-pošta mora sadržavati varijablu :body',
      'add_body_variable_message': 'Svakako uključite varijablu :body',
      'view_date_formats': 'Prikaz formata datuma',
      'is_viewed': 'Je pregledan',
      'letter': 'Pismo',
      'legal': 'Pravno',
      'page_layout': 'Izgled stranice',
      'portrait': 'Portret',
      'landscape': 'Krajolik',
      'owner_upgrade_to_paid_plan':
          'Vlasnik računa može nadograditi na plaćeni plan kako bi omogućio napredne napredne postavke',
      'upgrade_to_paid_plan':
          'Nadogradite na plaćeni plan kako biste omogućili napredne postavke',
      'invoice_payment_terms': 'Uvjeti plaćanja fakture',
      'quote_valid_until': 'Ponuda vrijedi do',
      'no_headers': 'Nema zaglavlja',
      'add_header': 'Dodaj zaglavlje',
      'remove_header': 'Ukloni zaglavlje',
      'return_url': 'Povratni URL',
      'rest_method': 'Metoda REST',
      'header_key': 'Ključ zaglavlja',
      'header_value': 'Vrijednost zaglavlja',
      'recurring_products': 'Proizvodi koji se ponavljaju',
      'promo_code': 'Promo kod',
      'promo_discount': 'Promo popust',
      'allow_cancellation': 'Dopusti otkazivanje',
      'per_seat_enabled': 'Omogućeno po sjedalu',
      'max_seats_limit': 'Maksimalno ograničenje mjesta',
      'trial_enabled': 'Probna verzija omogućena',
      'trial_duration': 'Trajanje probe',
      'allow_query_overrides': 'Dopusti nadjačavanje upita',
      'allow_plan_changes': 'Dopusti promjene plana',
      'plan_map': 'Karta plana',
      'refund_period': 'Razdoblje povrata',
      'webhook_configuration': 'Konfiguracija Webhooka',
      'purchase_page': 'Stranica za kupnju',
      'security': 'Security',
      'email_bounced': 'E-pošta odbijena',
      'email_spam_complaint': 'Žalba na spam',
      'email_delivery': 'Dostava e-pošte',
      'webhook_response': 'Webhook odgovor',
      'pdf_response': 'PDF odgovor',
      'authentication_failure': 'Neuspjeh provjere autentičnosti',
      'pdf_failed': 'PDF nije uspio',
      'pdf_success': 'PDF uspjeh',
      'modified': 'Izmijenjeno',
      'payment_link': 'Veza za plaćanje',
      'new_payment_link': 'Novi link za plaćanje',
      'edit_payment_link': 'Uredi vezu za plaćanje',
      'created_payment_link': 'Uspješno kreirana veza za plaćanje',
      'updated_payment_link': 'Veza za plaćanje je uspješno ažurirana',
      'archived_payment_link': 'Veza za plaćanje je uspješno arhivirana',
      'deleted_payment_link': 'Veza za plaćanje je uspješno izbrisana',
      'removed_payment_link': 'Veza za plaćanje je uspješno uklonjena',
      'restored_payment_link': 'Veza za plaćanje je uspješno vraćena',
      'search_payment_link': 'Pretražite 1 vezu za plaćanje',
      'search_payment_links': 'Pretražite :count Veze za plaćanje',
      'subdomain_is_not_available': 'Poddomena nije dostupna',
      'connect_gmail': 'Povežite Gmail',
      'disconnect_gmail': 'Odspojite Gmail',
      'connected_gmail': 'Gmail je uspješno povezan',
      'disconnected_gmail': 'Gmail je uspješno prekinut',
      'update_fail_help':
          'Promjene u bazi koda možda blokiraju ažuriranje, možete pokrenuti ovu naredbu da odbacite promjene:',
      'client_id_number': 'ID broj klijenta',
      'count_minutes': ':count Minute',
      'password_timeout': 'Istek lozinke',
      'shared_invoice_credit_counter': 'Podijelite brojač faktura/kredita',
      'use_last_email': 'Koristi posljednju e-poštu',
      'activate_company': 'Aktivirajte tvrtku',
      'activate_company_help':
          'Omogućite e-poštu, ponavljajuće fakture i obavijesti',
      'an_error_occurred_try_again': 'Došlo je do pogreške, pokušajte ponovo',
      'please_first_set_a_password': 'Prvo postavite lozinku',
      'changing_phone_disables_two_factor':
          'Upozorenje: Promjena vašeg telefonskog broja onemogućit će 2FA',
      'help_translate': 'Pomoć u prijevodu',
      'please_select_a_country': 'Odaberite državu',
      'resend_invite': 'Resend Invitation',
      'disabled_two_factor': 'Uspješno onemogućen 2FA',
      'connected_google': 'Uspješno povezan račun',
      'disconnected_google': 'Račun je uspješno prekinut',
      'delivered': 'Isporučeno',
      'bounced': 'Bounced',
      'spam': 'Spam',
      'view_docs': 'Pregledajte dokumente',
      'enter_phone_to_enable_two_factor':
          'Navedite broj mobilnog telefona kako biste omogućili provjeru autentičnosti u dva faktora',
      'send_sms': 'Pošalji SMS',
      'sms_code': 'SMS kod',
      'two_factor_setup_help': 'Scan the bar code with a :link compatible app.',
      'enabled_two_factor': 'Successfully enabled Two-Factor Authentication',
      'connect_google': 'Povežite Google',
      'disconnect_google': 'Odspojite Google',
      'enable_two_factor': 'Two-Factor Authentication',
      'disable_two_factor': 'Onemogući dva faktora',
      'require_password_with_social_login':
          'Zahtijeva lozinku s prijavom na društvene mreže',
      'stay_logged_in': 'Ostanite prijavljeni',
      'session_about_to_expire': 'Upozorenje: Vaša sesija će uskoro isteći',
      'count_hours': ':count',
      'count_day': '1 dan',
      'count_days': ':count Dana',
      'web_session_timeout': 'Isteklo vrijeme web sesije',
      'security_settings': 'Sigurnosne postavke',
      'resend_email': 'Ponovno pošalji e-poštu',
      'confirm_your_email_address': 'Molimo potvrdite svoju email adresu',
      'refunded_payment': 'Refunded Payment',
      'partially_unapplied': 'Djelomično neprimijenjeno',
      'select_a_gmail_user':
          'Odaberite korisnika koji je autentificiran putem Gmaila',
      'list_long_press': 'Popis dugim pritiskom',
      'show_actions': 'Prikaži radnje',
      'start_multiselect': 'Pokrenite višestruki odabir',
      'email_sent_to_confirm_email':
          'Poslana je e-pošta za potvrdu adrese e-pošte',
      'counter_pattern_error':
          'Za korištenje :client _counter molimo dodajte ili :client _number ili :client _id_number kako biste spriječili sukobe',
      'this_quarter': 'Ovo tromjesečje',
      'last_quarter': 'Prošlo tromjesječje',
      'to_update_run': 'Za ažuriranje pokrenuti',
      'convert_to_invoice': 'Konverzija računa',
      'registration_url': 'URL za registraciju',
      'invoice_project': 'Invoice Project',
      'invoice_task': 'Fakturiraj zadatak',
      'invoice_expense': 'Trošak računa',
      'search_payment_term': 'Traži 1 rok plaćanja',
      'search_payment_terms': 'Pretraživanje :count Uvjeti plaćanja',
      'save_and_preview': 'Spremi i pregledaj',
      'save_and_email': 'Spremi i e-poštom',
      'supported_events': 'Podržani događaji',
      'converted_amount': 'Converted Amount',
      'converted_balance': 'Preračunato stanje',
      'converted_paid_to_date': 'Preračunato plaćeno do danas',
      'converted_credit_balance': 'Konvertirano kreditno stanje',
      'converted_total': 'Pretvoreno ukupno',
      'is_sent': 'Poslano je',
      'default_documents': 'Default Documents',
      'document_upload': 'Prijenos dokumenta',
      'document_upload_help': 'Omogućite klijentima učitavanje dokumenata',
      'expense_total': 'Ukupni troškovi',
      'enter_taxes': 'Unesite poreze',
      'by_rate': 'Po stopi',
      'by_amount': 'Po iznosu',
      'enter_amount': 'Unesite iznos',
      'before_taxes': 'Prije poreza',
      'after_taxes': 'Nakon poreza',
      'color': 'Boja',
      'show': 'Pokazati',
      'hide': 'Sakrij',
      'empty_columns': 'Prazni stupci',
      'debug_mode_is_enabled': 'Način otklanjanja pogrešaka je omogućen',
      'debug_mode_is_enabled_help':
          'Upozorenje: namijenjeno je za korištenje na lokalnim računalima, mogu procuriti vjerodajnice. Kliknite da saznate više.',
      'running_tasks': 'Tekući zadaci',
      'recent_tasks': 'Nedavni zadaci',
      'recent_expenses': 'Nedavni troškovi',
      'upcoming_expenses': 'Nadolazeći troškovi',
      'update_app': 'Ažurirajte aplikaciju',
      'started_import': 'Uspješno pokrenut uvoz',
      'duplicate_column_mapping': 'Duplicirano mapiranje stupaca',
      'uses_inclusive_taxes': 'Koristi uključene poreze',
      'is_amount_discount': 'Je iznos popusta',
      'column': 'Kolona',
      'sample': 'Uzorak',
      'map_to': 'Karta do',
      'import': 'Uvoz',
      'first_row_as_column_names': 'Koristite prvi red kao nazive stupaca',
      'select_file': 'Molim odaberite datoteku',
      'no_file_selected': 'Nije odabrana datoteka',
      'csv_file': 'CSV datoteka',
      'csv': 'CSV',
      'freshbooks': 'FreshBooks',
      'invoice2go': 'Invoice2go',
      'invoicely': 'Fakturirano',
      'waveaccounting': 'Wave Accounting',
      'zoho': 'Zoho',
      'accounting': 'Računovodstvo',
      'required_files_missing': 'Navedite sve CSV-ove.',
      'import_type': 'Vrsta uvoza',
      'html_mode': 'HTML način',
      'html_mode_help': 'Pregled se ažurira brže, ali je manje točan',
      'view_licenses': 'Pregledajte licence',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': 'Uređivač cijelog zaslona',
      'sidebar_editor': 'Uređivač bočne trake',
      'please_type_to_confirm': 'Upišite &quot; :value &quot; za potvrdu',
      'purge': 'Čišćenje',
      'service': 'Service',
      'clone_to': 'Klonirati',
      'clone_to_other': 'Klonirati drugome',
      'labels': 'Etikete',
      'add_custom': 'Dodaj prilagođeno',
      'payment_tax': 'Porez na plaćanje',
      'unpaid': 'Neplaćeno',
      'white_label': 'Bijela oznaka',
      'delivery_note': 'Delivery Note',
      'sent_invoices_are_locked': 'Poslani računi su zaključani',
      'paid_invoices_are_locked': 'Plaćeni računi su zaključani',
      'source_code': 'Izvorni kod',
      'app_platforms': 'Platforme aplikacija',
      'invoice_late': 'Faktura kasni',
      'quote_expired': 'Ponuda istekla',
      'partial_due': 'Partial Due',
      'invoice_total': 'Ukupan iznos',
      'quote_total': 'Ukupan iznos',
      'credit_total': 'Credit Total',
      'recurring_invoice_total': 'Ukupna faktura',
      'actions': 'Radnje',
      'expense_number': 'Broj troškova',
      'task_number': 'Broj zadatka',
      'project_number': 'Broj projekta',
      'project_name': 'Naziv projekta',
      'warning': 'Warning',
      'view_settings': 'Prikaži postavke',
      'company_disabled_warning': 'Upozorenje: ova tvrtka još nije aktivirana',
      'late_invoice': 'Kasna faktura',
      'expired_quote': 'Istekla ponuda',
      'remind_invoice': 'Podsjetite fakturu',
      'cvv': 'CVV',
      'client_name': 'Klijent',
      'client_phone': 'Telefon klijenta',
      'required_fields': 'Obavezna polja',
      'calculated_rate': 'Izračunata stopa',
      'default_task_rate': 'Zadana stopa zadatka',
      'clear_cache': 'Očisti predmemoriju',
      'sort_order': 'Redoslijed sortiranja',
      'task_status': 'Status',
      'task_statuses': 'Statusi zadataka',
      'new_task_status': 'Novi status zadatka',
      'edit_task_status': 'Uredi status zadatka',
      'created_task_status': 'Uspješno kreiran status zadatka',
      'updated_task_status': 'Successfully update task status',
      'archived_task_status': 'Uspješno arhiviran status zadatka',
      'deleted_task_status': 'Status zadatka uspješno izbrisan',
      'removed_task_status': 'Status zadatka je uspješno uklonjen',
      'restored_task_status': 'Uspješno vraćen status zadatka',
      'archived_task_statuses': 'Uspješno arhivirani statusi zadataka :value',
      'deleted_task_statuses': 'Statusi zadataka :value uspješno su izbrisani',
      'restored_task_statuses': 'Uspješno vraćeni statusi zadataka :value',
      'search_task_status': 'Pretraga 1 Status zadatka',
      'search_task_statuses': 'Pretraži statuse zadataka :count',
      'show_tasks_table': 'Prikaži tablicu zadataka',
      'show_tasks_table_help':
          'Uvijek prikaži odjeljak zadataka prilikom izrade faktura',
      'invoice_task_timelog': 'Vremenski zapis zadatka fakture',
      'invoice_task_timelog_help':
          'Dodajte pojedinosti o vremenu stavkama fakture',
      'invoice_task_datelog': 'Datum zadatka fakture',
      'invoice_task_datelog_help':
          'Dodajte pojedinosti o datumu stavkama fakture',
      'auto_start_tasks_help': 'Pokrenite zadatke prije spremanja',
      'configure_statuses': 'Konfigurirajte statuse',
      'task_settings': 'Postavke zadatka',
      'configure_categories': 'Konfigurirajte kategorije',
      'expense_categories': 'Kategorije troškova',
      'new_expense_category': 'Nova kategorija troškova',
      'edit_expense_category': 'Uredite kategoriju troškova',
      'created_expense_category': 'Successfully created expense category',
      'updated_expense_category': 'Successfully updated expense category',
      'archived_expense_category': 'Successfully archived expense category',
      'deleted_expense_category': 'Successfully deleted category',
      'removed_expense_category': 'Kategorija troškova uspješno je uklonjena',
      'restored_expense_category': 'Successfully restored expense category',
      'archived_expense_categories':
          'Successfully archived :count expense category',
      'deleted_expense_categories':
          'Uspješno izbrisane kategorije troškova :value',
      'restored_expense_categories':
          'Uspješno vraćene kategorije troškova :value',
      'search_expense_category': 'Pretražite 1 kategoriju troškova',
      'search_expense_categories': 'Pretražite :count Kategorije troškova',
      'use_available_credits': 'Iskoristite dostupne kredite',
      'show_option': 'Prikaži opciju',
      'negative_payment_error': 'Iznos kredita ne može premašiti iznos uplate',
      'view_changes': 'Pogledaj izmjene',
      'force_update': 'Prisilno ažuriranje',
      'force_update_help':
          'Imate najnoviju verziju, ali možda postoje dostupni popravci na čekanju.',
      'mark_paid_help': 'Pratite da je trošak plaćen',
      'should_be_invoiced': 'Treba biti fakturiran',
      'should_be_invoiced_help': 'Omogućite fakturiranje troškova',
      'add_documents_to_invoice_help': 'Učinite dokumente vidljivima klijentu',
      'convert_currency_help': 'Postavite tečaj',
      'expense_settings': 'Postavke troškova',
      'clone_to_recurring': 'Klonirajte u ponavljajuće',
      'crypto': 'Kripto',
      'paypal': 'PayPal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple/Google Pay',
      'user_field': 'Korisničko polje',
      'variables': 'Varijable',
      'show_password': 'Prikaži lozinku',
      'hide_password': 'Sakrij lozinku',
      'copy_error': 'Kopiraj grešku',
      'capture_card': 'Kartica za snimanje',
      'auto_bill_enabled': 'Automatski račun omogućen',
      'total_taxes': 'Ukupni porezi',
      'line_taxes': 'Linijski porezi',
      'total_fields': 'Ukupna polja',
      'stopped_recurring_invoice': 'Uspješno zaustavljena ponavljajuća faktura',
      'started_recurring_invoice': 'Uspješno pokrenuta ponavljajuća faktura',
      'resumed_recurring_invoice': 'Uspješno nastavljena ponavljajuća faktura',
      'gateway_refund': 'Gateway povrat novca',
      'gateway_refund_help': 'Obradite povrat novca putem pristupnika plaćanja',
      'due_date_days': 'Datum dospijeća',
      'paused': 'Pauzirano',
      'mark_active': 'Označi kao aktivno',
      'day_count': ':count',
      'first_day_of_the_month': 'Prvi dan u mjesecu',
      'last_day_of_the_month': 'Zadnji dan u mjesecu',
      'use_payment_terms': 'Koristite Uvjete plaćanja',
      'endless': 'Beskrajno',
      'next_send_date': 'Sljedeći datum slanja',
      'remaining_cycles': 'Preostali ciklusi',
      'recurring_invoice': 'Redovni račun',
      'recurring_invoices': 'Redovni računi',
      'new_recurring_invoice': 'Novi redovni račun',
      'edit_recurring_invoice': 'Uredi ponavljajući račun',
      'created_recurring_invoice': 'Uspješno kreirana ponavljajuća faktura',
      'updated_recurring_invoice': 'Uspješno ažurirana ponavljajuća faktura',
      'archived_recurring_invoice': 'Uspješno arhiviran redoviti račun',
      'deleted_recurring_invoice': 'Uspješno obrisan redoviti račun',
      'removed_recurring_invoice': 'Ponavljajuća faktura uspješno je uklonjena',
      'restored_recurring_invoice': 'Uspješno obnovljen redoviti račun',
      'archived_recurring_invoices':
          'Uspješno arhivirane ponavljajuće :value fakture',
      'deleted_recurring_invoices':
          'Uspješno izbrisane ponavljajuće :value fakture',
      'restored_recurring_invoices':
          'Uspješno vraćene ponavljajuće :value fakture',
      'search_recurring_invoice': 'Pretražite 1 fakturu koja se ponavlja',
      'search_recurring_invoices': 'Pretražite :count Ponavljajuće fakture',
      'send_date': 'Datum slanja',
      'auto_bill_on': 'Automatski obračun',
      'minimum_under_payment_amount': 'Minimalni iznos za plaćanje',
      'profit': 'Profit',
      'line_item': 'Line Item',
      'allow_over_payment': 'Dopusti preplatu',
      'allow_over_payment_help':
          'Podrška uz dodatno plaćanje za prihvaćanje napojnica',
      'allow_under_payment': 'Dopustite podplatu',
      'allow_under_payment_help':
          'Podrška plaća minimalno djelomični iznos/iznos depozita',
      'test_mode': 'Testni način',
      'opened': 'Opened',
      'payment_reconciliation_failure': 'Neuspjeh pomirenja',
      'payment_reconciliation_success': 'Uspjeh pomirenja',
      'gateway_success': 'Gateway Uspjeh',
      'gateway_failure': 'Pogreška pristupnika',
      'gateway_error': 'Pogreška pristupnika',
      'email_send': 'Email poslan',
      'email_retry_queue': 'Red čekanja za ponovni pokušaj e-pošte',
      'failure': 'Neuspjeh',
      'quota_exceeded': 'Kvota premašena',
      'upstream_failure': 'Uzvodni neuspjeh',
      'system_logs': 'Zapisnici sustava',
      'view_portal': 'View Portal',
      'copy_link': 'Kopiraj link',
      'token_billing': 'Pohrani detalje kartice',
      'welcome_to_invoice_ninja': 'Dobrodošli u Invoice Ninja',
      'always': 'Always',
      'optin': 'Dragovoljno sudjeluj',
      'optout': 'Isključi se',
      'label': 'Label',
      'client_number': 'Client Number',
      'auto_convert': 'Automatski pretvoriti',
      'company_name': 'Company Name',
      'reminder1_sent': 'Podsjetnik 1 poslan',
      'reminder2_sent': 'Podsjetnik 2 poslan',
      'reminder3_sent': 'Podsjetnik 3 poslan',
      'reminder_last_sent': 'Podsjetnik 4 poslan',
      'pdf_page_info': 'Stranica :current od :total',
      'emailed_invoices': 'Successfully emailed invoices',
      'emailed_quotes': 'Successfully emailed quotes',
      'emailed_credits': 'Zasluge su uspješno poslane e-poštom',
      'gateway': 'Gateway',
      'view_in_stripe': 'Pogled u aplikaciji Stripe',
      'rows_per_page': 'Redova po stranici',
      'hours': 'sati',
      'statement': 'Izvješće o stanju duga',
      'taxes': 'Porezi',
      'surcharge': 'Surcharge',
      'apply_payment': 'Izvrši plaćanje',
      'apply_credit': 'Primjeni kredit',
      'apply': 'Apply',
      'unapplied': 'Neprovedeni',
      'select_label': 'Select Label',
      'custom_labels': 'Prilagođene oznake',
      'record_type': 'Vrsta zapisa',
      'record_name': 'Ime zapisa',
      'file_type': 'Vrsta datoteke',
      'height': 'Visina',
      'width': 'Širina',
      'to': 'Prima',
      'health_check': 'Provjera zdravlja',
      'payment_type_id': 'Tip uplate',
      'last_login_at': 'Posljednja prijava u',
      'company_key': 'Ključ tvrtke',
      'storefront': 'Izlog',
      'storefront_help':
          'Omogućite aplikacijama trećih strana za stvaranje računa',
      'client_created': 'Klijent stvoren',
      'online_payment_email': 'E-pošta za internetsko plaćanje',
      'manual_payment_email': 'E-pošta za ručno plaćanje',
      'completed': 'Dovršeno',
      'gross': 'Bruto',
      'net_amount': 'Neto iznos',
      'net_balance': 'Neto saldo',
      'client_settings': 'Postavke klijenta',
      'selected_invoices': 'Odabrani računi',
      'selected_payments': 'Odabrane transkacije',
      'selected_quotes': 'Odabrane ponude',
      'selected_tasks': 'Odabrani zadaci',
      'selected_expenses': 'Odabrani troškovi',
      'upcoming_invoices': 'Dolazni računi',
      'past_due_invoices': 'Dospjeli računi',
      'recent_payments': 'Nedavne uplate',
      'upcoming_quotes': 'Nadolazeće ponude',
      'expired_quotes': 'Istekle ponude',
      'create_client': 'Create Client',
      'create_invoice': 'Kreiraj račun',
      'create_quote': 'Kreiraj ponudu',
      'create_payment': 'Kreiraj plaćanje',
      'create_vendor': 'Create vendor',
      'update_quote': 'Ažuriraj ponudu',
      'delete_quote': 'Obriši ponudu',
      'update_invoice': 'Ažuriraj račun',
      'delete_invoice': 'Obriši račun',
      'update_client': 'Ažuriraj klijenta',
      'delete_client': 'Obriši klijenta',
      'delete_payment': 'Obriši uplatu',
      'update_vendor': 'Ažuriraj dobavljača',
      'delete_vendor': 'Obriši dobavljača',
      'create_expense': 'Stvori trošak',
      'update_expense': 'Ažuriraj trošak',
      'delete_expense': 'Obriši trošak',
      'create_task': 'Kreiraj zadatak',
      'update_task': 'Ažuriraj zadatak',
      'delete_task': 'Obriši zadatak',
      'approve_quote': 'Odobri ponudu',
      'off': 'Off',
      'when_paid': 'Kad se plati',
      'expires_on': 'Istječe u',
      'free': 'Slobodan',
      'plan': 'Plan',
      'show_sidebar': 'Pokaži bočnu traku',
      'hide_sidebar': 'Sakrij bočnu traku',
      'event_type': 'Vrsta događaja',
      'target_url': 'Target',
      'copy': 'Kopiraj',
      'must_be_online':
          'Ponovo pokrenite aplikaciju nakon povezivanja s internetom',
      'crons_not_enabled': 'CRON zadatak mora biti postavljen',
      'api_webhooks': 'API Webhooks',
      'search_webhooks': 'Pretraži :count Webhooks',
      'search_webhook': 'Pretraži 1 Webhook',
      'webhook': 'Webhook',
      'webhooks': 'Webhooks',
      'new_webhook': 'Novi Webhook',
      'edit_webhook': 'Uredi Webhook',
      'created_webhook': 'Webhook uspješno stvoren',
      'updated_webhook': 'Webhook uspješno ažuriran',
      'archived_webhook': 'Webhook uspješno arhiviran',
      'deleted_webhook': 'Webhook uspješno izbrisan',
      'removed_webhook': 'Webhook uspješno uklonjen',
      'restored_webhook': 'Webhook uspješno vraćen',
      'archived_webhooks': 'Uspješno arhivirani webdojavnici :value',
      'deleted_webhooks': 'Uspješno izbrisani web-dojavnici :value',
      'removed_webhooks': 'Uspješno uklonjeni web-dojavnici :value',
      'restored_webhooks': 'Uspješno vraćeni :value webdojavnici',
      'api_tokens': 'API tokeni',
      'api_docs': 'API dokumenti',
      'search_tokens': 'Pretraži :count tokena',
      'search_token': 'Pretraži 1 token',
      'token': 'Token',
      'tokens': 'Tokeni',
      'new_token': 'Novi token',
      'edit_token': 'Uredi token',
      'created_token': 'Uspješno kreiran token',
      'updated_token': 'Uspješno ažuriran token',
      'archived_token': 'Uspješno arhiviran token',
      'deleted_token': 'Uspješno obrisan token',
      'removed_token': 'Token uspješno uklonjen',
      'restored_token': 'Token uspješno vraćen',
      'archived_tokens': 'Uspješno arhivirani :value tokeni',
      'deleted_tokens': 'Uspješno izbrisani tokeni :value',
      'restored_tokens': 'Uspješno vraćeni :value tokeni',
      'client_registration': 'Registracija klijenta',
      'client_registration_help':
          'Omogućite klijentima da se sami registriraju na portalu',
      'email_invoice': 'Pošalji e-poštom',
      'email_quote': 'Šalji ponudu e-poštom',
      'email_credit': 'Kredit za e-poštu',
      'email_payment': 'Pošalji uplatu e-mailom',
      'client_email_not_set': 'Klijent nema postavljenu adresu e-pošte',
      'ledger': 'Glavna knjiga',
      'view_pdf': 'Pogledaj PDF',
      'all_records': 'Svi zapisi',
      'owned_by_user': 'Vlasništvo korisnika',
      'credit_remaining': 'Preostali kredit',
      'contact_name': 'Contact Name',
      'use_default': 'Upotrijebi zadanu vrijednost',
      'reminder_endless': 'Beskrajni podsjetnici',
      'number_of_days': 'Broj dana',
      'configure_payment_terms': 'Konfiguriraj rokove plaćanja',
      'payment_term': 'Rok plaćanja',
      'new_payment_term': 'Novi rok plaćanja',
      'edit_payment_term': 'Uredi uvjete plaćanja',
      'created_payment_term': 'Successfully created payment term',
      'updated_payment_term': 'Successfully updated payment term',
      'archived_payment_term': 'Successfully archived payment term',
      'deleted_payment_term': 'Uspješno izbrisan rok plaćanja',
      'removed_payment_term': 'Uspješno uklonjen rok plaćanja',
      'restored_payment_term': 'Uspješno vraćen rok plaćanja',
      'archived_payment_terms': 'Uspješno arhivirani :value uvjeti plaćanja',
      'deleted_payment_terms': 'Uspješno izbrisani :value uvjeti plaćanja',
      'restored_payment_terms': 'Uspješno vraćeni :value uvjeti plaćanja',
      'email_sign_in': 'Prijavite se e-poštom',
      'change': 'Promijeni',
      'change_to_mobile_layout': 'Promijeni na mobilni izgled?',
      'change_to_desktop_layout': 'Promijeni na izgled stolnog računala',
      'send_from_gmail': 'Pošalji s Gmaila',
      'reversed': 'Stornirano',
      'cancelled': 'Otkazani',
      'credit_amount': 'Iznos kredita',
      'quote_amount': 'Iznos Ponude',
      'hosted': 'Hosted',
      'selfhosted': 'Self-Hosted',
      'exclusive': 'Exclusive',
      'inclusive': 'Inclusive',
      'hide_menu': 'Sakri Izbornik',
      'show_menu': 'Prikaži Izbornik',
      'partially_refunded': 'Djelomičan Povrat',
      'search_documents': 'Pretraži Dokumente',
      'search_designs': 'Pretraži Dizajne',
      'search_invoices': 'Pretraži Račune',
      'search_clients': 'Pretraži Klijente',
      'search_products': 'Pretraži proizvode',
      'search_quotes': 'Pretraži Ponude',
      'search_credits': 'Traži kredite',
      'search_vendors': 'Pretraži Dobavljača',
      'search_users': 'Pretraži Korisnike',
      'search_tax_rates': 'Pretraži porezne stope',
      'search_tasks': 'Pretraži Zadatke',
      'search_settings': 'Pretraži Postavke',
      'search_projects': 'Pretraži projekte',
      'search_expenses': 'Pretraži troškove',
      'search_payments': 'Pretraži Uplate',
      'search_groups': 'Pretraži Grupe',
      'search_company': 'Pretraži Poduzeće',
      'search_document': 'Pretraži 1 dokument',
      'search_design': 'Pretraži 1 dizajn',
      'search_invoice': 'Pretraži 1 račun',
      'search_client': 'Pretraži 1 klijenta',
      'search_product': 'Pretraži 1 proizvod',
      'search_quote': 'Pretraži 1 ponudu',
      'search_credit': 'Traži 1 kredit',
      'search_vendor': 'Pretraži 1 dobavljača',
      'search_user': 'Pretraži 1 korisnika',
      'search_tax_rate': 'Pretraži 1 poreznu stopu',
      'search_task': 'Pretraži 1 zadatka',
      'search_project': 'Pretraži 1 projekta',
      'search_expense': 'Pretraži 1 troška',
      'search_payment': 'Pretraži 1 transakciju',
      'search_group': 'Pretraži 1 grupu',
      'refund_payment': 'Refund Payment',
      'cancelled_invoice': 'Uspješno otkazani račun',
      'cancelled_invoices': 'Uspješno otkazani račun',
      'reversed_invoice': 'Uspješno otkazani računi',
      'reversed_invoices': 'Uspješno storniran račun',
      'reverse': 'Storniraj',
      'full_name': 'Ime i prezime',
      'city_state_postal': 'City/State/Postal',
      'postal_city_state': 'Postal/City/State',
      'custom1': 'First Custom',
      'custom2': 'Second Custom',
      'custom3': 'Treći običaj',
      'custom4': 'Četvrti običaj',
      'optional': 'Neobavezno',
      'license': 'Licenca',
      'purge_data': 'Purge Data',
      'purge_successful': 'Successfully purged company data',
      'purge_data_message':
          'Warning: This will permanently erase your data, there is no undo.',
      'invoice_balance': 'Stanje računa',
      'age_group_0': '0 - 30 dana',
      'age_group_30': '30 - 60 dana',
      'age_group_60': '60 - 90 dana',
      'age_group_90': '90 - 120 dana',
      'age_group_120': '120+ dana',
      'refresh': 'Refresh',
      'saved_design': 'Uspješno spremljen dizajn',
      'client_details': 'Pojedinosti o klijentu',
      'company_address': 'Adresa tvrtke',
      'invoice_details': 'Detalji računa',
      'quote_details': 'Pojedinosti o ponudi',
      'credit_details': 'Pojedinosti o kreditu',
      'product_columns': 'Stupci proizvoda',
      'task_columns': 'Stupci zadatka',
      'add_field': 'Dodaj polje',
      'all_events': 'Svi događaji',
      'permissions': 'Permissions',
      'none': 'None',
      'owned': 'U vlasništvu',
      'payment_success': 'Uspjeh plaćanja',
      'payment_failure': 'Neuspjeh plaćanja',
      'invoice_sent': ':count invoice sent',
      'quote_sent': 'Ponuda poslana',
      'credit_sent': 'Kredit poslan',
      'invoice_viewed': 'Račun pregledan',
      'quote_viewed': 'Ponuda pogledana',
      'credit_viewed': 'Kredit pregledan',
      'quote_approved': 'Ponuda odobrena',
      'receive_all_notifications': 'Primi sve obavijesti',
      'purchase_license': 'Kupi licencu',
      'apply_license': 'Apply License',
      'cancel_account': 'Izbriši korisnički račun',
      'cancel_account_message':
          'Pozor: Ovo će trajno obrisati sve vaše podatke, nema povratka.',
      'delete_company': 'Delete Company',
      'delete_company_message':
          'Warning: This will permanently delete your company, there is no undo.',
      'enabled_modules': 'Omogućeni moduli',
      'converted_quote': 'Ponuda uspješno pretvorena',
      'credit_design': 'Dizajn kredita',
      'includes': 'Uključuje',
      'header': 'Zaglavlje',
      'load_design': 'Load Design',
      'css_framework': 'CSS Framework',
      'custom_designs': 'Prilagođeni dizajni',
      'designs': 'Dizajni',
      'new_design': 'Novi dizajn',
      'edit_design': 'Uredi dizajn',
      'created_design': 'Dizajn uspješno stvoren',
      'updated_design': 'Dizajn uspješno ažuriran',
      'archived_design': 'Dizajn uspješno arhiviran',
      'deleted_design': 'Dizajn uspješno izbrisan',
      'removed_design': 'Dizajn uspješno uklonjen',
      'restored_design': 'Dizajn uspješno vraćen',
      'archived_designs': 'Uspješno arhivirani :value dizajni',
      'deleted_designs': 'Uspješno izbrisani :value dizajni',
      'restored_designs': 'Uspješno restaurirani :value dizajni',
      'proposals': 'Prijedlozi',
      'tickets': 'Ulaznice',
      'recurring_quotes': 'Ponavljajuće ponude',
      'recurring_tasks': 'Ponavljajući zadaci',
      'account_management': 'Upravljanje računima',
      'credit_date': 'Datum kredita',
      'credit': 'Kredit',
      'credits': 'Krediti',
      'new_credit': 'Dodaj kredit',
      'edit_credit': 'Uredi kredit',
      'created_credit': 'Uspješno kreiran kredit',
      'updated_credit': 'Successfully updated credit',
      'archived_credit': 'Uspješno arhiviran kredit',
      'deleted_credit': 'Uspješno obrisan kredit',
      'removed_credit': 'Kredit je uspješno uklonjen',
      'restored_credit': 'Uspješno obnovljen kredit',
      'archived_credits': 'Uspješno arhivirano :count kredita',
      'deleted_credits': 'Uspješno obrisano :count kredita',
      'restored_credits': 'Uspješno vraćeni krediti :value',
      'current_version': 'Trenutna verzija',
      'latest_version': 'Najnovija verzija',
      'update_now': 'Ažuriraj sada',
      'a_new_version_is_available': 'Dostupna je nova verzija web aplikacije',
      'update_available': 'Ažuriranje dostupno',
      'app_updated': 'Ažuriranje je uspješno završeno',
      'learn_more': 'Više informacija',
      'integrations': 'Integracije',
      'tracking_id': 'Broj za praćenje',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': 'Kreditno podnožje',
      'credit_terms': 'Kreditni uvjeti',
      'new_company': 'Novo poduzeće',
      'added_company': 'Tvrtka je uspješno dodana',
      'company1': 'Prilagođena tvrtka 1',
      'company2': 'Prilagođena tvrtka 2',
      'company3': 'Prilagođena tvrtka 3',
      'company4': 'Prilagođena tvrtka 4',
      'product1': 'Prilagođeni proizvod 1',
      'product2': 'Prilagođeni proizvod 2',
      'product3': 'Prilagođeni proizvod 3',
      'product4': 'Prilagođeni proizvod 4',
      'client1': 'Prilagođeni klijent 1',
      'client2': 'Prilagođeni klijent 2',
      'client3': 'Prilagođeni klijent 3',
      'client4': 'Prilagođeni klijent 4',
      'contact1': 'Prilagođeni kontakt 1',
      'contact2': 'Prilagođeni kontakt 2',
      'contact3': 'Prilagođeni kontakt 3',
      'contact4': 'Prilagođeni kontakt 4',
      'task1': 'Prilagođeni zadatak 1',
      'task2': 'Prilagođeni zadatak 2',
      'task3': 'Prilagođeni zadatak 3',
      'task4': 'Prilagođeni zadatak 4',
      'project1': 'Prilagođeni projekt 1',
      'project2': 'Prilagođeni projekt 2',
      'project3': 'Prilagođeni projekt 3',
      'project4': 'Prilagođeni projekt 4',
      'expense1': 'Prilagođeni trošak 1',
      'expense2': 'Prilagođeni trošak 2',
      'expense3': 'Prilagođeni trošak 3',
      'expense4': 'Prilagođeni trošak 4',
      'vendor1': 'Prilagođeni dobavljač 1',
      'vendor2': 'Prilagođeni dobavljač 2',
      'vendor3': 'Prilagođeni dobavljač 3',
      'vendor4': 'Prilagođeni dobavljač 4',
      'invoice1': 'Prilagođena faktura 1',
      'invoice2': 'Prilagođena faktura 2',
      'invoice3': 'Prilagođena faktura 3',
      'invoice4': 'Prilagođena faktura 4',
      'payment1': 'Prilagođeno plaćanje 1',
      'payment2': 'Prilagođeno plaćanje 2',
      'payment3': 'Prilagođeno plaćanje 3',
      'payment4': 'Prilagođeno plaćanje 4',
      'surcharge1': 'Prilagođena doplata 1',
      'surcharge2': 'Prilagođena doplata 2',
      'surcharge3': 'Prilagođena doplata 3',
      'surcharge4': 'Prilagođena doplata 4',
      'group1': 'Prilagođena grupa 1',
      'group2': 'Prilagođena grupa 2',
      'group3': 'Prilagođena grupa 3',
      'group4': 'Prilagođena grupa 4',
      'reset': 'Resetiraj',
      'number': 'Broj',
      'export': 'Izvoz',
      'chart': 'Karte',
      'count': 'Zbroj',
      'totals': 'Zbrojevi',
      'blank': 'Blank',
      'day': 'Dan',
      'month': 'Mjesec',
      'year': 'Godina',
      'subgroup': 'Subgroup',
      'is_active': 'Je aktivan',
      'group_by': 'Grupiraj po',
      'credit_balance': 'Stanje kredita',
      'contact_last_login': 'Zadnje prijavljivanje kontakta',
      'contact_full_name': 'Puno ime kontakta',
      'contact_phone': 'Contact Phone',
      'contact_custom_value1': 'Prilagođena vrijednost 1 kontakta',
      'contact_custom_value2': 'Prilagođena vrijednost 2 kontakta',
      'contact_custom_value3': 'Prilagođena vrijednost 3 kontakta',
      'contact_custom_value4': 'Prilagođena vrijednost 4 kontakta',
      'shipping_address1': 'Shipping Street',
      'shipping_address2': 'Shipping Apt/Suite',
      'shipping_city': 'Shipping City',
      'shipping_state': 'Shipping State/Province',
      'shipping_postal_code': 'Shipping Postal Code',
      'shipping_country': 'Shipping Country',
      'billing_address1': 'Billing Street',
      'billing_address2': 'Billing Apt/Suite',
      'billing_city': 'Billing City',
      'billing_state': 'Billing State/Province',
      'billing_postal_code': 'Billing Postal Code',
      'billing_country': 'Billing Country',
      'client_id': 'Client Id',
      'assigned_to': 'Dodijeljeno za',
      'created_by': 'Created by :name',
      'assigned_to_id': 'Dodijeljeno ID-u',
      'created_by_id': 'Stvorio ID',
      'add_column': 'Dodaj stupac',
      'edit_columns': 'Uredi stupce',
      'columns': 'Kolone',
      'aging': 'Izvan dospijeća',
      'profit_and_loss': 'Profit i Trošak',
      'reports': 'Izvješća',
      'report': 'Izvješća',
      'add_company': 'Dodaj poduzeće',
      'unpaid_invoice': 'Unpaid Invoice',
      'paid_invoice': 'Paid Invoice',
      'unapproved_quote': 'Unapproved Quote',
      'help': 'Pomoć',
      'refund': 'Refund',
      'refund_date': 'Datum povrata novca',
      'filtered_by': 'Filtrirano po',
      'contact_email': 'Contact Email',
      'multiselect': 'Višestruki odabir',
      'entity_state': 'Kanton',
      'verify_password': 'Potvrdi lozinku',
      'applied': 'Primijenjeno',
      'include_recent_errors': 'Uključite nedavne pogreške iz zapisnika',
      'your_message_has_been_received':
          'Primili smo vašu poruku i pokušat ćemo brzo odgovoriti.',
      'message': 'Poruka',
      'from': 'Šalje',
      'show_product_details': 'Prikaži detalje o proizvodu',
      'show_product_details_help':
          'Uključite opis i cijenu u padajući izbornik proizvoda',
      'pdf_min_requirements': 'PDF renderer zahtijeva :version',
      'adjust_fee_percent': 'Prilagodite postotak naknade',
      'adjust_fee_percent_help':
          'Prilagodite postotak da biste uzeli u obzir naknadu',
      'configure_settings': 'Konfigurirajte postavke',
      'support_forum': 'Forumi podrške',
      'about': 'Oko',
      'documentation': 'Dokumentacija',
      'contact_us': 'Kontaktirajte nas',
      'subtotal': 'Osnovica',
      'line_total': 'Ukupno',
      'item': 'Stavka',
      'credit_email': 'Kreditna e-pošta',
      'iframe_url': 'iFrame URL',
      'domain_url': 'URL domene',
      'password_is_too_short': 'Lozinka je prekratka',
      'password_is_too_easy':
          'Lozinka mora sadržavati barem jedno veliko slovo i broj',
      'client_portal_tasks': 'Zadaci klijentskog portala',
      'client_portal_dashboard': 'Nadzorna ploča klijentskog portala',
      'please_enter_a_value': 'Molimo unesite vrijednost',
      'deleted_logo': 'Logo je uspješno izbrisan',
      'yes': 'Da',
      'no': 'Ne',
      'generate_number': 'Generiraj broj',
      'when_saved': 'Kada je spremljeno',
      'when_sent': 'Kada je poslano',
      'select_company': 'Odaberite tvrtku',
      'float': 'Plutati',
      'collapse': 'Kolaps',
      'show_or_hide': 'Pokaži/Sakrij',
      'menu_sidebar': 'Bočna traka izbornika',
      'history_sidebar': 'Bočna traka povijesti',
      'tablet': 'Tablet',
      'mobile': 'Mobile',
      'desktop': 'Desktop',
      'layout': 'Raspored',
      'view': 'Pregled',
      'module': 'Modul',
      'first_custom': 'Prvi stupac',
      'second_custom': 'Drugi stupac',
      'third_custom': 'Treći stupac',
      'show_cost': 'Prikaži trošak',
      'show_product_cost': 'Prikaži cijenu proizvoda',
      'show_cost_help':
          'Prikaži polje troškova proizvoda za praćenje marže / dobiti',
      'show_product_quantity': 'Prikaži količinu proizvoda',
      'show_product_quantity_help':
          'Prikaži polje s količinom proizvoda, inače zadano 1',
      'show_invoice_quantity': 'Prikaži količinu računa',
      'show_invoice_quantity_help':
          'Prikaži polje za količinu stavke, inače zadano 1',
      'show_product_discount': 'Prikaži popust na proizvod',
      'show_product_discount_help': 'Prikaz polja s popustom za stavku retka',
      'default_quantity': 'Zadana količina',
      'default_quantity_help': 'Količina stavke retka automatski postavi na 1',
      'one_tax_rate': 'Jedna porezna stopa',
      'two_tax_rates': 'Dvije porezne stope',
      'three_tax_rates': 'Tri porezne stope',
      'default_tax_rate': 'Zadana porezna stopa',
      'user': 'Korisnik',
      'invoice_tax': 'Porez na fakturu',
      'line_item_tax': 'Porez na stavke',
      'inclusive_taxes': 'Uključujući porezi',
      'invoice_tax_rates': 'Stope poreza na fakture',
      'item_tax_rates': 'Stope poreza na stavke',
      'no_client_selected': 'Please select a client',
      'configure_rates': 'Konfigurirajte stope',
      'configure_gateways': 'Konfigurirajte pristupnike',
      'tax_settings': 'Postavke poreza',
      'tax_settings_rates': 'Porezne stope',
      'accent_color': 'Boja akcenta',
      'switch': 'Switch',
      'comma_sparated_list': 'Popis odvojen zarezom',
      'options': 'Opcije',
      'single_line_text': 'Tekst u jednom retku',
      'multi_line_text': 'Tekst s više redaka',
      'dropdown': 'Padajući izbornik',
      'field_type': 'Vrsta polja',
      'recover_password_email_sent': 'Poslan je e-mail za oporavak lozinke',
      'submit': 'Submit',
      'recover_password': 'Obnovite vašu zaporku',
      'late_fees': 'Zakašnjele naknade',
      'credit_number': 'Credit Number',
      'payment_number': 'Broj transakcije',
      'late_fee_amount': 'Late Fee Amount',
      'late_fee_percent': 'Late Fee Percent',
      'before_due_date': 'Prije datuma dospijeća',
      'after_due_date': 'Nakon datuma dospijeća',
      'after_invoice_date': 'Nakon datuma računa',
      'days': 'Dani',
      'invoice_email': 'E-pošta računa',
      'payment_email': 'E-pošta uplate',
      'partial_payment': 'Djelomično plaćanje',
      'payment_partial': 'Djelomično plaćanje',
      'partial_payment_email': 'E-pošta za djelomično plaćanje',
      'quote_email': 'E-pošta ponude',
      'endless_reminder': 'Endless Reminder',
      'filtered_by_user': 'Filtrirano po korisniku',
      'administrator': 'Administrator',
      'administrator_help':
          'Allow user to manage users, change settings and modify all records',
      'user_management': 'Upravljanje korisnicima',
      'users': 'Korisnici',
      'new_user': 'Novi korisnik',
      'edit_user': 'Uredi korisnika',
      'created_user': 'Uspješno stvoren korisnik',
      'updated_user': 'Korisnik je uspješno ažuriran',
      'archived_user': 'Uspješno arhiviran korisnik',
      'deleted_user': 'Korisnik je uspješno obrisan',
      'removed_user': 'Korisnik je uspješno uklonjen',
      'restored_user': 'Uspješno obnovljen korisnik',
      'archived_users': 'Uspješno arhivirani :value korisnici',
      'deleted_users': 'Uspješno izbrisani korisnici :value',
      'removed_users': 'Uspješno uklonjeni korisnici :value',
      'restored_users': 'Uspješno vraćeni korisnici :value',
      'general_settings': 'Opće postavke',
      'invoice_options': 'Opcije računa',
      'hide_paid_to_date': 'Sakrij datum plaćanja',
      'hide_paid_to_date_help':
          'Prikažite \'Datum plaćanja\' na računima, onda kada je uplata primljena.',
      'invoice_embed_documents': 'Ugradite slike/dokumente',
      'invoice_embed_documents_help':
          'Uključite priložene slike/pdf-ove u fakturu.',
      'all_pages_header': 'Prikaži zaglavlje na',
      'all_pages_footer': 'Prikaži podnožje na',
      'first_page': 'First page',
      'all_pages': 'All pages',
      'last_page': 'Last page',
      'primary_font': 'Primarni font',
      'secondary_font': 'Sekundarni font',
      'primary_color': 'Primarna boja',
      'secondary_color': 'Sekundarna boja',
      'page_size': 'Page Size',
      'font_size': 'Veličina fonta',
      'quote_design': 'Quote Design',
      'invoice_fields': 'Polja računa',
      'product_fields': 'Product Fields',
      'invoice_terms': 'Uvjeti računa',
      'invoice_footer': 'Podnožje računa',
      'quote_terms': 'Uvjeti ponude',
      'quote_footer': 'Podnožje ponude',
      'auto_email_invoice': 'Auto Email',
      'auto_email_invoice_help':
          'Automatski pošaljite fakture koje se ponavljaju nakon izrade.',
      'auto_archive_quote': 'Auto Archive',
      'auto_archive_quote_help':
          'Automatski arhivirajte ponude kada se pretvore u fakturu.',
      'auto_convert_quote': 'Auto Convert',
      'auto_convert_quote_help':
          'Automatski pretvorite ponudu u fakturu nakon odobrenja.',
      'workflow_settings': 'Workflow Settings',
      'freq_daily': 'Daily',
      'freq_weekly': 'Weekly',
      'freq_two_weeks': 'Two weeks',
      'freq_four_weeks': 'Four weeks',
      'freq_monthly': 'Monthly',
      'freq_two_months': 'Two months',
      'freq_three_months': 'Three months',
      'freq_four_months': 'Four months',
      'freq_six_months': 'Six months',
      'freq_annually': 'Annually',
      'freq_two_years': 'Two years',
      'freq_three_years': 'Tri godine',
      'never': 'Never',
      'company': 'Company',
      'generated_numbers': 'Generirani brojevi',
      'charge_taxes': 'Naplati poreze',
      'next_reset': 'Slijedeći reset',
      'reset_counter': 'Resetiraj brojač',
      'recurring_prefix': 'Recurring Prefix',
      'number_padding': 'Ispuna brojevima',
      'general': 'Općenito',
      'surcharge_field': 'Polje doplate',
      'company_field': 'Company Field',
      'company_value': 'Vrijednost tvrtke',
      'credit_field': 'Kreditno polje',
      'invoice_field': 'Invoice Field',
      'invoice_surcharge': 'Invoice Surcharge',
      'client_field': 'Client Field',
      'product_field': 'Product Field',
      'payment_field': 'Polje transakcije',
      'contact_field': 'Contact Field',
      'vendor_field': 'Vendor Field',
      'expense_field': 'Expense Field',
      'project_field': 'Project Field',
      'task_field': 'Task Field',
      'group_field': 'Polje Grupe',
      'number_counter': 'Brojač brojeva',
      'prefix': 'Prefiks',
      'number_pattern': 'Uzorak broja',
      'messages': 'Messages',
      'custom_css': 'Prilagođeni CSS',
      'custom_javascript': 'Prilagođeni JavaScript',
      'signature_on_pdf': 'Pokaži na PDF-u',
      'signature_on_pdf_help':
          'Show the client signature on the invoice/quote PDF.',
      'show_accept_invoice_terms': 'Invoice Terms Checkbox',
      'show_accept_invoice_terms_help':
          'Require client to confirm that they accept the invoice terms.',
      'show_accept_quote_terms': 'Quote Terms Checkbox',
      'show_accept_quote_terms_help':
          'Require client to confirm that they accept the quote terms.',
      'require_invoice_signature': 'Invoice Signature',
      'require_invoice_signature_help':
          'Require client to provide their signature.',
      'require_quote_signature': 'Quote Signature',
      'enable_portal_password': 'Password Protect Invoices',
      'enable_portal_password_help':
          'Allows you to set a password for each contact. If a password is set, the contact will be required to enter a password before viewing invoices.',
      'authorization': 'Authorization',
      'subdomain': 'Poddomena',
      'domain': 'Domain',
      'portal_mode': 'Način rada Portal',
      'email_signature': 'Srdačno,',
      'enable_email_markup_help':
          'Olakšajte svojim klijentima plaćanje dodavanjem schema.org markupa vašoj e-pošti.',
      'plain': 'Obično',
      'light': 'Svijetlo',
      'dark': 'Tamno',
      'email_design': 'Dizajn e-pošte',
      'attach_pdf': 'Priloži PDF',
      'attach_documents': 'Priložite dokumente',
      'attach_ubl': 'Priložite UBL/E-račun',
      'email_style': 'Stil e-pošte',
      'enable_email_markup': 'Omogući markup',
      'reply_to_email': 'Reply-To Email',
      'reply_to_name': 'Ime odgovora',
      'bcc_email': 'BCC Email',
      'processed': 'Obrađeno',
      'credit_card': 'Kreditna kartica',
      'bank_transfer': 'Bankovni prijenos',
      'priority': 'Prioritet',
      'fee_amount': 'Iznos naknade',
      'fee_percent': 'Postotak naknade',
      'fee_cap': 'Kapacitet naknade',
      'limits_and_fees': 'Limiti/Naknade',
      'enable_min': 'Enable min',
      'enable_max': 'Enable max',
      'min_limit': 'Min: :min',
      'max_limit': 'Max: :max',
      'min': 'Min',
      'max': 'Max',
      'accepted_card_logos': 'Accepted Card Logos',
      'credentials': 'vjerodajnice',
      'update_address': 'Ažuriraj adresu',
      'update_address_help': 'Ažuriraj adresu klijenta uz osigurane detalje',
      'rate': 'Stopa',
      'tax_rate': 'Porezna stopa',
      'new_tax_rate': 'Nova porezna stopa',
      'edit_tax_rate': 'Uredi poreznu stopu',
      'created_tax_rate': 'Uspješno kreirana porezna stopa',
      'updated_tax_rate': 'Uspješno ažurirana porezna stopa',
      'archived_tax_rate': 'Uspješno arhivirana porezna stopa',
      'deleted_tax_rate': 'Uspješno izbrisana porezna stopa',
      'restored_tax_rate': 'Uspješno vraćena porezna stopa',
      'archived_tax_rates': 'Uspješno arhivirane :value porezne stope',
      'deleted_tax_rates': 'Uspješno izbrisane :value porezne stope',
      'restored_tax_rates': 'Uspješno vraćene :value porezne stope',
      'fill_products': 'Proizvodi sa samoispunom',
      'fill_products_help':
          'Odabir proizvoda će automatski ispuniti opis i cijenu',
      'update_products': 'Proizvidi sa autoažuriranjem',
      'update_products_help':
          'Ažuriranje računa automatski ažurirati registar proizvoda',
      'convert_products': 'Convert Products',
      'convert_products_help':
          'Automatically convert product prices to the client\'s currency',
      'fees': 'Fees',
      'limits': 'Limits',
      'provider': 'Dobavljač',
      'company_gateway': 'Sustav online plaćanja',
      'company_gateways': 'Sustavi online plaćanja',
      'new_company_gateway': 'Novi sustav online plaćanja',
      'edit_company_gateway': 'Uredi sustav online plaćanja',
      'created_company_gateway': 'Uspješno stvoren Sustav online plaćanja',
      'updated_company_gateway': 'Uspješno ažuriran sustav online plaćanja',
      'archived_company_gateway': 'Uspješno arhiviran sustav online plaćanja',
      'deleted_company_gateway': 'Uspješno izbrisan sustav online plaćanja',
      'restored_company_gateway': 'Uspješno vraćen sustav online plaćanja',
      'archived_company_gateways': 'Uspješno arhivirani :value pristupnici',
      'deleted_company_gateways': 'Uspješno izbrisani pristupnici :value',
      'restored_company_gateways': 'Uspješno vraćeni :value pristupnici',
      'continue_editing': 'Nastavi uređivati',
      'discard_changes': 'Discard Changes',
      'default_value': 'Zadana vrijednost',
      'disabled': 'Onemogućeno',
      'currency_format': 'Format valute',
      'first_day_of_the_week': 'Prvi dan u tjednu',
      'first_month_of_the_year': 'Prvi mjesec u godini',
      'sunday': 'Nedjelja',
      'monday': 'Ponedjeljak',
      'tuesday': 'Utorak',
      'wednesday': 'Srijeda',
      'thursday': 'Četvrtak',
      'friday': 'Petak',
      'saturday': 'Subota',
      'january': 'Siječanj',
      'february': 'Veljača',
      'march': 'Ožujak',
      'april': 'Travanj',
      'may': 'Svibanj',
      'june': 'Lipanj',
      'july': 'Srpanj',
      'august': 'Kolovoz',
      'september': 'Rujan',
      'october': 'Listopad',
      'november': 'Studeni',
      'december': 'Prosinac',
      'symbol': 'Simbol',
      'ocde': 'Kodirati',
      'date_format': 'Format datuma',
      'datetime_format': 'Format vremena',
      'military_time': '24 satno vrijeme',
      'military_time_help': '24-satni prikaz',
      'send_reminders': 'Pošalji podsjetnike',
      'timezone': 'Vremenska zona',
      'filtered_by_project': 'Filtrirano po Projektu',
      'filtered_by_group': 'Filtrirano po grupi',
      'filtered_by_invoice': 'Filtrirano po računu',
      'filtered_by_client': 'Filtrirano po klijentu',
      'filtered_by_vendor': 'Filtrirano po dobavljaču',
      'group_settings': 'Postavke grupe',
      'group': 'Group',
      'groups': 'Grupe',
      'new_group': 'Nova grupa',
      'edit_group': 'Uredi grupu',
      'created_group': 'Grupa je uspješno stvorena',
      'updated_group': 'Grupa je uspješno ažurirana',
      'archived_groups': 'Uspješno arhivirane :value grupe',
      'deleted_groups': 'Uspješno izbrisane grupe :value',
      'restored_groups': 'Uspješno vraćene :value grupe',
      'archived_group': 'Grupa je uspješno arhivirana',
      'deleted_group': 'Grupa je uspješno izbrisana',
      'restored_group': 'Grupa je uspješno vraćena',
      'upload_logo': 'Učitajte logotip svoje tvrtke',
      'uploaded_logo': 'Uspješno preneseni logo',
      'logo': 'Logo',
      'saved_settings': 'Postavke uspješno spremljene',
      'product_settings': 'Postavke proizvoda',
      'device_settings': 'Postavke uređaja',
      'defaults': 'Zadano',
      'basic_settings': 'Osnovne postavke',
      'advanced_settings': 'Napredne postavke',
      'company_details': 'Detalji poduzeća',
      'user_details': 'Detalji korisnika',
      'localization': 'Lokalizacija',
      'online_payments': 'Online uplate',
      'tax_rates': 'Porezne stope',
      'notifications': 'Obavijesti',
      'import_export': 'Uvoz | Izvoz',
      'custom_fields': 'Prilagođena polja',
      'invoice_design': 'Dizajn računa',
      'buy_now_buttons': 'Buy Now Buttons',
      'email_settings': 'Postavke e-pošte',
      'templates_and_reminders': 'Predlošci & podsjetnici',
      'credit_cards_and_banks': 'Kreditne kartice i banke',
      'data_visualizations': 'Vizualizacije podataka',
      'price': 'Cijena',
      'email_sign_up': 'Registrirajte se e-poštom',
      'google_sign_up': 'Registrirajte se putem Google računa',
      'thank_you_for_your_purchase': 'Hvala vam na kupnji!',
      'redeem': 'Otkupiti',
      'back': 'Natrag',
      'past_purchases': 'Prošle kupnje',
      'annual_subscription': 'Godišnja pretplata',
      'pro_plan': 'Pro plan',
      'enterprise_plan': 'Enterprise Plan',
      'count_users': ':count korisnika',
      'upgrade': 'Nadogradi',
      'please_enter_a_first_name': 'Molimo unesite ime',
      'please_enter_a_last_name': 'Molimo unesite prezime',
      'please_agree_to_terms_and_privacy':
          'Molimo vas da se složite s uvjetima pružanja usluge i pravilima o privatnosti za stvaranje računa.',
      'i_agree_to_the': 'Slažem se s',
      'terms_of_service': 'Uvjeti korištenja usluge',
      'privacy_policy': 'Privacy Policy',
      'sign_up': 'Prijava',
      'account_login': 'Korisnička prijava',
      'view_website': 'Pogledajte web stranicu',
      'create_account': 'Otvori račun',
      'email_login': 'Prijava putem e-pošte',
      'create_new': 'Create New',
      'no_record_selected': 'Nije odabran nijedan zapis',
      'error_unsaved_changes': 'Spremite ili poništite svoje promjene',
      'download': 'Preuzmi',
      'requires_an_enterprise_plan': 'Zahtijeva Enterprise Plan',
      'take_picture': 'Fotografiraj',
      'upload_files': 'Prijenos datoteka',
      'document': 'Document',
      'documents': 'Dokumenti',
      'new_document': 'Novi Dokument',
      'edit_document': 'Uredi Dokument',
      'uploaded_document': 'Uspješno preneseni dokument',
      'updated_document': 'Uspješno ažurirani dokument',
      'archived_document': 'Uspješno arhiviran dokument',
      'deleted_document': 'Uspješno izbrisani dokument',
      'restored_document': 'Uspješno vraćeni dokument',
      'archived_documents': 'Uspješno arhivirani :value dokumenti',
      'deleted_documents': 'Uspješno izbrisani :value dokumenti',
      'restored_documents': 'Uspješno vraćeni :value dokumenti',
      'no_history': 'Nema povijesti',
      'expense_date': 'Datum troška',
      'pending': 'Na čekanju',
      'expense_status_1': 'Evidentirano',
      'expense_status_2': 'U obradi',
      'expense_status_3': 'Fakturirano',
      'converted': 'Konvertirano',
      'add_documents_to_invoice': 'Dodajte dokumente fakturi',
      'exchange_rate': 'Tečaj',
      'convert_currency': 'Konvertiraj valutu',
      'mark_paid': 'Označi uplatu',
      'category': 'Kategorija',
      'address': 'Adresa',
      'new_vendor': 'Novi dobavljač',
      'created_vendor': 'Uspješno kreiran dobavljač',
      'updated_vendor': 'Uspješno ažuriran dobavljač',
      'archived_vendor': 'Uspješno arhiviran dobavljač',
      'deleted_vendor': 'Uspješno obrisan dobavljač',
      'restored_vendor': 'Successfully restored vendor',
      'archived_vendors': 'Uspješno arhivirano :count dobavljača',
      'deleted_vendors': 'Uspješno obrisano :count dobavljača',
      'restored_vendors': 'Uspješno vraćeni :value dobavljači',
      'new_expense': 'Novi trošak',
      'created_expense': 'Uspješno kreiran trošak',
      'updated_expense': 'Uspješno ažuriran trošak',
      'archived_expense': 'Uspješno arhiviran trošak',
      'deleted_expense': 'Uspješno obrisan trošak',
      'restored_expense': 'Successfully restored expense',
      'archived_expenses': 'Uspješno arhivirani troškovi',
      'deleted_expenses': 'Uspješno obrisan trošak',
      'restored_expenses': 'Uspješno vraćeni :value troškovi',
      'copy_shipping': 'Copy Shipping',
      'copy_billing': 'Copy Billing',
      'design': 'Dizajn',
      'failed_to_find_record': 'Pronalaženje zapisa nije uspjelo',
      'invoiced': 'Fakturirano',
      'logged': 'Logirano',
      'running': 'Pokrenuto',
      'resume': 'Nastavi',
      'task_errors': 'Molimo korigirajte preklopna vremena',
      'start': 'Početak',
      'stop': 'Završetak',
      'started_task': 'Successfully started task',
      'stopped_task': 'Uspješno završen zadatak',
      'resumed_task': 'Successfully resumed task',
      'now': 'Sada',
      'auto_start_tasks': 'Automatsko pokretanje zadataka',
      'timer': 'Štoperica',
      'manual': 'Ručno',
      'budgeted': 'Budžet',
      'start_time': 'Početno vrijeme',
      'end_time': 'Završno vrijeme',
      'date': 'Datum',
      'times': 'Vremena',
      'duration': 'Trajanje',
      'new_task': 'Novi zadatak',
      'created_task': 'Uspješno kreiran zadatak',
      'updated_task': 'Uspješno ažuriran zadatak',
      'archived_task': 'Uspješno arhiviran zadatak',
      'deleted_task': 'Uspješno obrisan zadatak',
      'restored_task': 'Uspješno obnovljen zadatak',
      'archived_tasks': 'Uspješno arhivirano :count zadataka',
      'deleted_tasks': 'Uspješno obrisano :count zadataka',
      'restored_tasks': 'Uspješno vraćeni :value zadaci',
      'please_enter_a_name': 'Molimo unesite ime',
      'budgeted_hours': 'Dogovoreno radnih sati',
      'created_project': 'Successfully created project',
      'updated_project': 'Successfully updated project',
      'archived_project': 'Successfully archived project',
      'deleted_project': 'Successfully deleted project',
      'restored_project': 'Successfully restored project',
      'archived_projects': 'Successfully archived :count projects',
      'deleted_projects': 'Successfully deleted :count projects',
      'restored_projects': 'Uspješno vraćeni :value projekti',
      'new_project': 'Novi projekt',
      'thank_you_for_using_our_app': 'Hvala vam što koristite našu aplikaciju!',
      'if_you_like_it': 'Ako vam se sviđa, molim vas',
      'click_here': 'kliknite ovdje',
      'click_here_capital': 'Kliknite ovdje',
      'to_rate_it': 'da bi ju ocijenili.',
      'average': 'Prosjek',
      'unapproved': 'Neodobreno',
      'authenticate_to_change_setting':
          'Potvrdite autentičnost da biste promijenili ovu postavku',
      'locked': 'Zaključano',
      'authenticate': 'Provjera autentičnosti',
      'please_authenticate': 'Molimo provjerite autentičnost',
      'biometric_authentication': 'Biometrijska provjera autentičnosti',
      'footer': 'Podnožje',
      'compare': 'Usporedi',
      'hosted_login': 'Hostirana prijava',
      'selfhost_login': 'Selfhost Prijava',
      'google_sign_in': 'Prijavite se s Google računom',
      'today': 'Danas',
      'custom_range': 'Prilagođeni Raspon',
      'date_range': 'Raspon datuma',
      'current': 'Trenutni',
      'previous': 'Prijašnji',
      'current_period': 'Tekuće Razdoblje',
      'comparison_period': 'Razdoblje usporedbe',
      'previous_period': 'Prethodno razdoblje',
      'previous_year': 'Prethodna godina',
      'compare_to': 'Usporedi s',
      'last7_days': 'Zadnjih 7 dana',
      'last_week': 'Prošli tjedan',
      'last30_days': 'Zadnjih 30 dana',
      'this_month': 'Ovaj mjesec',
      'last_month': 'Prošli mjesec',
      'this_year': 'Ova godina',
      'last_year': 'Prošla godina',
      'all_time': 'Sva vremena',
      'custom': 'Prilagođeno',
      'clone_to_invoice': 'Kloniraj u Račune',
      'clone_to_quote': 'Kloniraj u Ponude',
      'clone_to_credit': 'Kloniraj u kredit',
      'view_invoice': 'Pregled računa',
      'convert': 'Pretvori',
      'more': 'Više',
      'edit_client': 'Uredi klijenta',
      'edit_product': 'Uredi proizvod',
      'edit_invoice': 'Uredi račun',
      'edit_quote': 'Uredi ponudu',
      'edit_payment': 'Uredi uplatu',
      'edit_task': 'Uredi zadatak',
      'edit_expense': 'Uredi trošak',
      'edit_vendor': 'Uredi dobavljača',
      'edit_project': 'Uredi projekt',
      'edit_recurring_quote': 'Uredi ponavljajuću ponudu',
      'billing_address': 'Adresa računa',
      'shipping_address': 'Shipping Address',
      'total_revenue': 'Ukupni prihod',
      'average_invoice': 'Prosječni račun',
      'outstanding': 'Dospijeva',
      'invoices_sent': ':count invoices sent',
      'active_clients': 'aktivni klijenti',
      'close': 'Zatvori',
      'email': 'E-pošta',
      'password': 'Zaporka',
      'url': 'URL',
      'secret': 'Secret',
      'name': 'Ime',
      'logout': 'Odjava',
      'login': 'Prijava',
      'filter': 'Filter',
      'sort': 'Poredak',
      'search': 'Pretraga',
      'active': 'Aktivan',
      'archived': 'Arhivirano',
      'deleted': 'Obrisano',
      'dashboard': 'Kontrolna ploča',
      'archive': 'Arhiva',
      'delete': 'Obriši',
      'restore': 'Obnovi',
      'refresh_complete': 'Osvježavanje završeno',
      'please_enter_your_email': 'Molimo upišite vašu email adresu',
      'please_enter_your_password': 'Molimo upišite vašu zaporku',
      'please_enter_your_url': 'Molimo unesite URL',
      'please_enter_a_product_key': 'Molimo upišite šifru proizvoda',
      'ascending': 'Ascending',
      'descending': 'Descending',
      'save': 'Pohrani',
      'an_error_occurred': 'Dogodila se pogreška',
      'paid_to_date': 'Do sada plaćeno',
      'balance_due': 'Stanje duga',
      'balance': 'Potraživanje',
      'overview': 'Pregled',
      'details': 'Detalji',
      'phone': 'Telefon',
      'website': 'Web',
      'vat_number': 'OIB',
      'id_number': 'ID broj',
      'create': 'Kreiraj',
      'copied_to_clipboard': 'Kopirao :value u međuspremnik',
      'error': 'Greška',
      'could_not_launch': 'Pokretanje nije uspjelo',
      'contacts': 'Kontakti',
      'additional': 'Dodatno',
      'first_name': 'Ime',
      'last_name': 'Prezime',
      'add_contact': 'Dodaj kontakt',
      'are_you_sure': 'Da li ste sigurni?',
      'cancel': 'Odustani',
      'ok': 'Ok',
      'remove': 'Remove',
      'email_is_invalid': 'Email adresa je pogrešna',
      'product': 'Proizvod',
      'products': 'Proizvodi',
      'new_product': 'Novi proizvod / usluga',
      'created_product': 'Proizvod je uspješno kreiran',
      'updated_product': 'Proizvod je uspješno ažuriran',
      'archived_product': 'Proizvod je uspješno arhiviran',
      'deleted_product': 'Successfully deleted product',
      'restored_product': 'Successfully restored product',
      'archived_products': 'Successfully archived :count products',
      'deleted_products': 'Successfully deleted :count products',
      'restored_products': 'Uspješno vraćeni :value proizvodi',
      'product_key': 'Proizvod',
      'notes': 'Bilješke',
      'cost': 'Cijena',
      'client': 'Klijent',
      'clients': 'Klijenti',
      'new_client': 'Novi klijent',
      'created_client': 'Klijent je uspješno kreiran',
      'updated_client': 'Uspješno ažuriranje klijenta',
      'archived_client': 'Uspješno arhiviran klijent',
      'archived_clients': 'Uspješno arhivirano :count klijenata',
      'deleted_client': 'Uspješno obrisan klijent',
      'deleted_clients': 'Uspješno obrisano :count klijenata',
      'restored_client': 'Uspješno obnovljen  klijent',
      'restored_clients': 'Uspješno vraćeni :value klijenti',
      'address1': 'Ulica i kućni broj',
      'address2': 'Kat/Oznaka',
      'city': 'Grad',
      'state': 'Županija',
      'postal_code': 'Poštanski broj',
      'country': 'Zemlja',
      'invoice': 'Račun',
      'invoices': 'Računi',
      'new_invoice': 'Novi račun',
      'created_invoice': 'Uspješno kreiran račun',
      'updated_invoice': 'Uspješno ažuriran račun',
      'archived_invoice': 'Uspješno arhiviran račun',
      'deleted_invoice': 'Uspješno obrisan račun',
      'restored_invoice': 'Uspješno obnovljen račun',
      'archived_invoices': 'Uspješno arhivirano :count računa',
      'deleted_invoices': 'Uspješno obrisano :count računa',
      'restored_invoices': 'Uspješno vraćene :value fakture',
      'emailed_invoice': 'Račun uspješno poslan e-poštom',
      'emailed_payment': 'Successfully emailed payment',
      'amount': 'Iznos',
      'invoice_number': 'Broj računa',
      'invoice_date': 'Datum računa',
      'discount': 'Popust',
      'po_number': 'Broj narudžbe',
      'terms': 'Uvjeti',
      'public_notes': 'Javne bilješke',
      'private_notes': 'Privatne bilješke',
      'frequency': 'Frekvencija',
      'start_date': 'Početni datum',
      'end_date': 'Završni datum',
      'quote_number': 'Broj ponude',
      'quote_date': 'Datum ponude',
      'valid_until': 'Vrijedi do',
      'items': 'Stavke',
      'partial_deposit': 'Djelomično/Depozit',
      'description': 'Opis',
      'unit_cost': 'Jedinična cijena',
      'quantity': 'Količina',
      'add_item': 'Dodaj stavku',
      'contact': 'Kontakt',
      'work_phone': 'Telefon',
      'total_amount': 'Ukupan iznos',
      'pdf': 'PDF',
      'due_date': 'Datum dospijeća',
      'partial_due_date': 'Partial Due Date',
      'paid_date': 'Plaćeni datum',
      'status': 'Status',
      'invoice_status_id': 'Status računa',
      'quote_status': 'Status ponude',
      'click_plus_to_add_item': 'Kliknite + za dodavanje stavke',
      'click_plus_to_add_time': 'Pritisnite + za dodavanje vremena',
      'count_selected': ':count odabrano',
      'total': 'Sveukupno',
      'percent': 'Percent',
      'edit': 'Uredi',
      'dismiss': 'Odbaci',
      'please_select_a_date': 'Molimo odaberite datum',
      'please_select_a_client': 'Molimo odaberite klijenta',
      'please_select_an_invoice': 'Molimo odaberite račun',
      'task_rate': 'Satnica',
      'settings': 'Postavke',
      'language': 'Jezik',
      'currency': 'Currency',
      'created_at': 'Datum kreiranja',
      'created_on': 'Stvoreno u',
      'updated_at': 'Ažurirano',
      'tax': 'Porez',
      'please_enter_an_invoice_number': 'Molimo upišite broj računa',
      'please_enter_a_quote_number': 'Molimo upišite broj ponude',
      'past_due': 'Past Due',
      'draft': 'Skica',
      'sent': 'Poslano',
      'viewed': 'Pregledano',
      'approved': 'Odobreno',
      'partial': 'Partial/Deposit',
      'paid': 'Plaćeno',
      'mark_sent': 'Označi kao poslano',
      'marked_invoice_as_sent': 'Račun je uspješno označen kao poslan',
      'marked_invoice_as_paid': 'Faktura je uspješno označena kao plaćena',
      'marked_invoices_as_sent': 'Računi su uspješno označeni kao poslani',
      'marked_invoices_as_paid': 'Fakture su uspješno označene kao plaćene',
      'done': 'Dovršeno',
      'please_enter_a_client_or_contact_name':
          'Molimo upišite ime klijenta ili kontakta',
      'dark_mode': 'Tamni prikaz',
      'restart_app_to_apply_change':
          'Ponovno pokrenite aplikaciju za primjenu promjena',
      'refresh_data': 'Osvježi podatke',
      'blank_contact': 'Prazan kontakt',
      'activity': 'Aktivnost',
      'no_records_found': 'Nije pronađen zapis',
      'clone': 'Kloniraj',
      'loading': 'Loading',
      'industry': 'Industrija',
      'size': 'Veličina',
      'payment_terms': 'Uvjeti plaćanja',
      'payment_date': 'Datum uplate',
      'payment_status': 'Status uplate',
      'payment_status_1': 'U tijeku',
      'payment_status_2': 'Poništeno',
      'payment_status_3': 'Neuspješno',
      'payment_status_4': 'Završeno',
      'payment_status_5': 'Djelimični povrat',
      'payment_status_6': 'Povrat',
      'payment_status_-1': 'Neprimijenjeno',
      'payment_status_-2': 'Djelomično neprimijenjeno',
      'net': 'Neto',
      'client_portal': 'Klijentski portal',
      'show_tasks': 'Prikaži zadatke',
      'email_reminders': 'Email podsjetnici',
      'enabled': 'Enabled',
      'recipients': 'Primatelji',
      'initial_email': 'Prvi Email',
      'first_reminder': 'Prvi podsjetnik',
      'second_reminder': 'Drugi podsjetnik',
      'third_reminder': 'Treći podsjetnik',
      'reminder1': 'Prvi podsjetnik',
      'reminder2': 'Drugi podsjetnik',
      'reminder3': 'Treći podsjetnik',
      'template': 'Predložak',
      'send': 'Pošalji',
      'subject': 'Naslov',
      'body': 'Tijelo',
      'send_email': 'Slanje e-pošte',
      'email_receipt': 'Pošalji e-poštom račun klijentu',
      'auto_billing': 'Automatska naplata',
      'button': 'Gumb',
      'preview': 'Preview',
      'customize': 'Prilagodi',
      'history': 'Povijest',
      'payment': 'Uplata',
      'payments': 'Uplate',
      'refunded': 'Povrat',
      'payment_type': 'Payment Type',
      'transaction_reference': 'Referenca transakcije',
      'enter_payment': 'Unesi uplatu',
      'new_payment': 'Unesi uplatu',
      'created_payment': 'Uspješno kreirana uplata',
      'updated_payment': 'Uspješno ažurirana uplata',
      'archived_payment': 'Uspješno arhivirana uplata',
      'deleted_payment': 'Uspješno obrisana uplata',
      'restored_payment': 'Uspješno obnovljena uplata',
      'archived_payments': 'Uspješno arhivirana :count uplata',
      'deleted_payments': 'Uspješno obrisano :count uplata',
      'restored_payments': 'Uspješno vraćena :value plaćanja',
      'quote': 'Ponuda',
      'quotes': 'Ponude',
      'new_quote': 'Nova ponuda',
      'created_quote': 'Ponuda uspješno kreirana',
      'updated_quote': 'Ponuda je uspješno ažurirana',
      'archived_quote': 'Ponuda uspješno arhivirana',
      'deleted_quote': 'Ponuda uspješno obrisana',
      'restored_quote': 'Uspješno obnovljena ponuda',
      'archived_quotes': 'Uspješno arhivirano :count ponuda',
      'deleted_quotes': 'Uspješno obrisano :count ponuda',
      'restored_quotes': 'Uspješno vraćeni citati :value',
      'expense': 'Trošak',
      'expenses': 'Troškovi',
      'vendor': 'Dobavljač',
      'vendors': 'Dobavljači',
      'task': 'Task',
      'tasks': 'Zadaci',
      'project': 'Projekt',
      'projects': 'Projekti',
      'activity_1': ':user kreirao klijenta :client',
      'activity_2': ':user arhivirao klijenta :client',
      'activity_3': ':user obrisao klijenta :client',
      'activity_4': ':user kreirao račun :invoice',
      'activity_5': ':user ažurirao račun :invoice',
      'activity_6': ':user poslao e-poštom račun :invoice za :contact',
      'activity_7': ':contact pregledao račun :invoice',
      'activity_8': ':user arhivirao račun :invoice',
      'activity_9': ':user obrisao račun :invoce',
      'activity_10':
          ':user uneseno plaćanje :payment za :payment _iznos na fakturi :invoice za :client',
      'activity_11': ':user ažurirao uplatu :payment',
      'activity_12': ':user ahivirao uplatu :payment',
      'activity_13': ':user obrisao uplatu :payment',
      'activity_14': ':user upisao :credit kredit',
      'activity_15': ':user ažurirao :credit kredit',
      'activity_16': ':user arhivirao :credit kredit',
      'activity_17': ':user obrisao :credit kredit',
      'activity_18': ':user kreirao ponudu :quote',
      'activity_19': ':user ažurirao ponudu :quote',
      'activity_20': ':user poslao e-poštom ponudu :quote za :contact',
      'activity_21': ':contact pregledao ponudu :quote',
      'activity_22': ':user arhivirao ponudu :quote',
      'activity_23': ':user obrisao ponudu :quote',
      'activity_24': ':user obnovio ponudu :quote',
      'activity_25': ':user obnovio račun :invoice',
      'activity_26': ':user obnovio klijenta :client',
      'activity_27': ':user obnovio uplatu :payment',
      'activity_28': ':user obnovio :credit kredit',
      'activity_29': ':contact odobrio ponudu :quote',
      'activity_30': ':user created vendor :vendor',
      'activity_31': ':user archived vendor :vendor',
      'activity_32': ':user deleted vendor :vendor',
      'activity_33': ':user restored vendor :vendor',
      'activity_34': ':user kreirao trošak :expense',
      'activity_35': ':user archived expense :expense',
      'activity_36': ':user deleted expense :expense',
      'activity_37': ':user restored expense :expense',
      'activity_39': ':user cancelled a :payment_amount payment :payment',
      'activity_40':
          ':user refunded :adjustment of a :payment_amount payment :payment',
      'activity_41': ':payment_amount payment (:payment) failed',
      'activity_42': ':user created task :task',
      'activity_43': ':user updated task :task',
      'activity_44': ':user archived task :task',
      'activity_45': ':user deleted task :task',
      'activity_46': ':user restored task :task',
      'activity_47': ':user updated expense :expense',
      'activity_48': ':user stvorio korisnik :user',
      'activity_49': ':user ažurirao korisnik :user',
      'activity_50': ':user arhivirani korisnik :user',
      'activity_51': ':user izbrisani korisnik :user',
      'activity_52': ':user vraćeni korisnik :user',
      'activity_53': ':user označeno kao poslano :invoice',
      'activity_54': ':user plaćena faktura :invoice',
      'activity_55': 'Kontakt :contact je odgovorio na radni nalog :ticket',
      'activity_56': 'Korisnik :user je pregledao radni nalog :ticket',
      'activity_57': 'Sustav nije uspio poslati račun e-poštom :invoice',
      'activity_58': ':user je stornirao račun :invoice',
      'activity_59': ':user otkazao račun :invoice',
      'activity_60': ':contact pregledan citat :quote',
      'activity_61': ':user ažurirani klijent :client',
      'activity_62': ':user ažurirani dobavljač :vendor',
      'activity_63':
          ':user e-poštom poslao prvi podsjetnik za fakturu :invoice na :contact',
      'activity_64':
          ':user e-poštom poslao drugi podsjetnik za fakturu :invoice na :contact',
      'activity_65':
          ':user e-poštom poslao treći podsjetnik za fakturu :invoice na :contact',
      'activity_66':
          ':user e-poštom poslao beskrajni podsjetnik za fakturu :invoice na :contact',
      'activity_80': ':user stvorena pretplata :subscription',
      'activity_81': ':user ažurirana pretplata :subscription',
      'activity_82': ':user arhivirana pretplata :subscription',
      'activity_83': ':user izbrisana pretplata :subscription',
      'activity_84': ':user obnovljena pretplata :subscription',
      'one_time_password': 'One Time Password',
      'emailed_quote': 'Ponuda uspješno poslana e-poštom',
      'emailed_credit': 'Kredit je uspješno poslan e-poštom',
      'marked_quote_as_sent': 'Ponuda je uspješno označena kao poslana',
      'marked_credit_as_sent': 'Kredit je uspješno označen kao poslan',
      'expired': 'Isteklo',
      'all': 'Svi',
      'select': 'Odaberi',
      'long_press_multiselect': 'Dugo pritisnite za višestruku odabir',
      'custom_value1': 'Prilagođena vrijednost 1',
      'custom_value2': 'Prilagođena vrijednost 2',
      'custom_value3': 'Prilagođena vrijednost 3',
      'custom_value4': 'Prilagođena vrijednost 4',
      'email_style_custom': 'Prilagođeni stil e-pošte',
      'custom_message_dashboard': 'Prilagođena poruka nadzorne ploče',
      'custom_message_unpaid_invoice': 'Prilagođena poruka neplaćenog računa',
      'custom_message_paid_invoice': 'Prilagođena poruka plaćenog računa',
      'custom_message_unapproved_quote':
          'Prilagođena poruka ne odobrene ponude',
      'lock_invoices': 'Zaključaj račune',
      'translations': 'Prijevodi',
      'task_number_pattern': 'Uzorak broja zadatka',
      'task_number_counter': 'Brojač broja zadatka',
      'expense_number_pattern': 'Uzorak broja troškova',
      'expense_number_counter': 'Brojač broja troškova',
      'vendor_number_pattern': 'Uzorak broja dobavljača',
      'vendor_number_counter': 'Brojač brojeva dobavljača',
      'ticket_number_pattern': 'Uzorak broja radnog naloga',
      'ticket_number_counter': 'Brojač broj radnog naloga',
      'payment_number_pattern': 'Uzorak broja transakcije',
      'payment_number_counter': 'Brojač broja transakcije',
      'invoice_number_pattern': 'Uzorak broja računa',
      'invoice_number_counter': 'Brojač računa',
      'quote_number_pattern': 'Uzorak broja ponude',
      'quote_number_counter': 'Brojač ponuda',
      'client_number_pattern': 'Uzorak kreditnog broja',
      'client_number_counter': 'Brojač kredita',
      'credit_number_pattern': 'Uzorak kreditnog broja',
      'credit_number_counter': 'Brojač kredita',
      'reset_counter_date': 'Poništi datum brojača',
      'counter_padding': 'Ispuna broja brojača',
      'shared_invoice_quote_counter': 'Podijelite brojač faktura/ponuda',
      'default_tax_name_1': 'Zadani porezni naziv 1',
      'default_tax_rate_1': 'Zadana porezna stopa 1',
      'default_tax_name_2': 'Zadani porezni naziv 2',
      'default_tax_rate_2': 'Zadana porezna stopa 2',
      'default_tax_name_3': 'Zadani porezni naziv 3',
      'default_tax_rate_3': 'Zadana porezna stopa 3',
      'email_subject_invoice': 'Predmet fakture e-pošte',
      'email_subject_quote': 'Predmet citata e-pošte',
      'email_subject_payment': 'Predmet plaćanja e-poštom',
      'email_subject_payment_partial': 'Predmet djelomičnog plaćanja e-poštom',
      'show_table': 'Prikaz u tablici',
      'show_list': 'Prikaz u listi',
      'client_city': 'Grad klijenta',
      'client_state': 'Županija klijenta',
      'client_country': 'Država klijenta',
      'client_is_active': 'Klijent je aktivan',
      'client_balance': 'Stanje računa klijenta',
      'client_address1': 'Ulica klijenta',
      'client_address2': 'Klijentov stan/apartman',
      'vendor_address1': 'Ulica prodavača',
      'vendor_address2': 'Dobavljač Stan/apartman',
      'client_shipping_address1': 'Client Shipping Street',
      'client_shipping_address2': 'Stan/apartman za dostavu klijenata',
      'type': 'Tip',
      'invoice_amount': 'Iznos računa',
      'invoice_due_date': 'Datum valute',
      'tax_rate1': 'Porezna stopa 1',
      'tax_rate2': 'Porezna stopa 2',
      'tax_rate3': 'Porezna stopa 3',
      'auto_bill': 'Auto račun',
      'archived_at': 'Arhivirano u',
      'has_expenses': 'Ima troškove',
      'custom_taxes1': 'Carinski porezi 1',
      'custom_taxes2': 'Carinski porezi 2',
      'custom_taxes3': 'Carinski porezi 3',
      'custom_taxes4': 'Carinski porezi 4',
      'custom_surcharge1': 'Prilagođena doplata 1',
      'custom_surcharge2': 'Prilagođena doplata 2',
      'custom_surcharge3': 'Prilagođena doplata 3',
      'custom_surcharge4': 'Prilagođena doplata 4',
      'is_deleted': 'Izbrisan',
      'vendor_city': 'Grad dobavljača',
      'vendor_state': 'Županija dobavljača',
      'vendor_country': 'Država dobavljača',
      'is_approved': 'Odobreno je',
      'tax_name': 'Ime porezne stope',
      'tax_amount': 'Iznos poreza',
      'tax_paid': 'Plaćeno poreza',
      'payment_amount': 'Iznos uplate',
      'age': 'Dospijeće',
      'is_running': 'Trči',
      'time_log': 'Dnevnik vremena',
      'bank_id': 'Banka',
      'expense_category_id': 'ID kategorije rashoda',
      'expense_category': 'Expense Category',
      'invoice_currency_id': 'ID valute fakture',
      'tax_name1': 'Porezni naziv 1',
      'tax_name2': 'Porezni naziv 2',
      'tax_name3': 'Porezni naziv 3',
      'transaction_id': 'ID transakcije',
      'status_color_theme': 'Statusna tema u boji',
      'load_color_theme': 'Učitaj temu u boji',
    },
    'cs': {
      'location': 'Location',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Location Deleted',
      'added_location': 'Successfully added location',
      'updated_location': 'Updated Location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': 'Lokace',
      'preference_product_notes_for_html_view': 'Use Item Notes for HTML View',
      'preference_product_notes_for_html_view_help':
          'Preference the item Description over the item title if displaying the invoice in HTML.',
      'in_stock_quantity': 'Stock quantity',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update': 'Allow clients to update their profile',
      'enable_client_profile_update_help':
          'Allow clients to update their profile information from the client portal',
      'participant': 'Participant',
      'merged_vendors': 'Successfully merged vendors',
      'activity_146':
          'E-Invoice :invoice for :client successfully delivered! :notes',
      'activity_147': 'E-Invoice :invoice for :client failed delivery. :notes',
      'activity_148': 'E-Expense :expense received from :vendor',
      'payment_failed': 'Payment Failed',
      'activity_141': 'User :user entered note: :notes',
      'activity_142': 'Quote :quote reminder 1 sent',
      'activity_143': 'Auto Bill succeeded for invoice :invoice',
      'activity_144': 'Auto Bill failed for invoice :invoice. :notes',
      'activity_145': 'E-Invoice :invoice for :client was sent. :notes',
      'ssl_host_override': 'SSL Host Override',
      'upload_logo_short': 'Upload Logo',
      'show_pdfhtml_on_mobile_help':
          'For improved visualization, displays a HTML version of the invoice/quote when viewing on mobile.',
      'accept_purchase_order': 'Accept Purchase Order',
      'one_page_checkout': 'One-Page Checkout',
      'one_page_checkout_help': 'Enable the new single page payment flow',
      'applies_to': 'Applies To',
      'purchase_order_items': 'Purchase Order Items',
      'assigned_group': 'Successfully assigned group',
      'assign_group': 'Assign group',
      'merge_to_pdf': 'Merge to PDF',
      'emails': 'E-maily',
      'latest_requires_php_version':
          'Note: the latest version requires PHP :version',
      'quote_reminder1': 'First Quote Reminder',
      'before_valid_until': 'Before the valid until',
      'after_valid_until': 'After the valid until',
      'after_quote_date': 'After the quote date',
      'remind_quote': 'Remind Quote',
      'task_assigned_notification': 'Task Assigned Notification',
      'task_assigned_notification_help':
          'Send an email when a task is assigned',
      'invoices_locked_end_of_month':
          'Invoices are locked at the end of the month',
      'end_of_month': 'End Of Month',
      'referral_url': 'Referral URL',
      'referral_program': 'Referral program',
      'comment': 'Comments',
      'add_comment': 'Add Comment',
      'added_comment': 'Successfully saved comment',
      'disconnected': 'Disconnected',
      'reconnect': 'Reconnect',
      'e_invoice_settings': 'E-Invoice Settings',
      'calculate': 'Calculate',
      'sum': 'Sum',
      'money': 'Money',
      'time': 'Čas',
      'format': 'Formát',
      'web_app': 'Web App',
      'desktop_app': 'Desktop App',
      'invoice_net_amount': 'Invoice Net Amount',
      'round_to_seconds': 'Round To Seconds',
      '1_minute': '1 Minute',
      '5_minutes': '5 Minutes',
      '15_minutes': '15 Minutes',
      '30_minutes': '30 Minutes',
      '1_hour': '1 Hour',
      '1_day': '1 Day',
      'round_tasks': 'Task Rounding Direction',
      'round_tasks_help': 'Round task times up or down.',
      'direction': 'Direction',
      'round_up': 'Round Up',
      'round_down': 'Round Down',
      'task_round_to_nearest': 'Round To Nearest',
      'activity_139': 'Expense :expense notification sent to :contact',
      'activity_140': 'Statement sent to :client',
      'bulk_updated': 'Successfully updated data',
      'bulk_update': 'Bulk Update',
      'advanced_cards': 'Advanced Cards',
      'always_show_required_fields': 'Always show required fields form',
      'always_show_required_fields_help':
          'Displays the required fields form always at checkout',
      'flutter_web_warning':
          'We recommend using the new web app or the desktop app for the best performance',
      'rappen_rounding': 'Rappen Rounding',
      'rappen_rounding_help': 'Round amount to 5 cents',
      'check_credentials': 'Check Credentials',
      'valid_credentials': 'Credentials are valid',
      'invalid_credentials': 'Tyto údaje neodpovídají našim záznamům.',
      'e_quote': 'E-Quote',
      'e_credit': 'E-Credit',
      'e_purchase_order': 'E-Purchase Order',
      'valid_vat_number': 'Valid VAT Number',
      'use_available_payments': 'Use Available Payments',
      'test_email_sent': 'Successfully sent email',
      'send_test_email': 'Send Test Email',
      'gateway_type': 'Gateway Type',
      'please_select_an_invoice_or_credit':
          'Please select an invoice or credit',
      'mobile_version': 'Mobile Version',
      'venmo': 'Venmo',
      'mercado_pago': 'Mercado Pago',
      'my_bank': 'MyBank',
      'pay_later': 'Pay Later',
      'email_report': 'Email Report',
      'host': 'Host',
      'port': 'Port',
      'encryption': 'Šifrování',
      'local_domain': 'Local Domain',
      'verify_peer': 'Verify Peer',
      'username': 'Uživatelské jméno',
      'nordigen_help':
          'Note: connecting an account requires a GoCardless/Nordigen API key',
      'participant_name': 'Participant name',
      'yodlee_regions': 'Regions: USA, UK, Australia & India',
      'nordigen_regions': 'Regions: Europe & UK',
      'select_provider': 'Select Provider',
      'payment_type_credit': 'Payment Type Credit',
      'payment_type_debit': 'Payment Type Debit',
      'send_emails_to': 'Send Emails To',
      'primary_contact': 'Primary Contact',
      'all_contacts': 'All Contacts',
      'insert_below': 'Insert Below',
      'ar_detailed': 'Accounts Receivable Detailed',
      'ar_summary': 'Accounts Receivable Summary',
      'client_sales': 'Client Sales',
      'tax_summary': 'Tax Summary',
      'user_sales': 'User Sales',
      'run_template': 'Run Template',
      'task_extension_banner': 'Add the Chrome extension to manage your tasks',
      'watch_video': 'Watch Video',
      'view_extension': 'View Extension',
      'reactivate_email': 'Reactivate Email',
      'email_reactivated': 'Successfully reactivated email',
      'template_help': 'Enable using the design as a template',
      'delivery_note_design': 'Delivery Note Design',
      'statement_design': 'Statement Design',
      'payment_receipt_design': 'Payment Receipt Design',
      'payment_refund_design': 'Payment Refund Design',
      'quarter': 'Quarter',
      'item_description': 'Item Description',
      'task_item': 'Task Item',
      'record_state': 'Record State',
      'last_login': 'Poslední přihlášení',
      'save_files_to_this_folder': 'Save files to this folder',
      'downloads_folder': 'Downloads Folder',
      'total_invoiced_quotes': 'Invoiced Quotes',
      'total_invoice_paid_quotes': 'Invoice Paid Quotes',
      'downloads_folder_does_not_exist':
          'The downloads folder does not exist :value',
      'user_logged_in_notification': 'User Logged in Notification',
      'user_logged_in_notification_help':
          'Send an email when logging in from a new location',
      'client_contact': 'Kontakt na klienta',
      'expense_status_4': 'Neplacené',
      'expense_status_5': 'Placené',
      'recurring': 'Pravidelné',
      'ziptax_help':
          'Note: this feature requires a Zip-Tax API key to lookup US sales tax by address',
      'cache_data': 'Cache Data',
      'unknown': 'Unknown',
      'webhook_failure': 'Webhook Failure',
      'email_opened': 'E-mail otevřen',
      'email_delivered': 'E-mail doručen',
      'log': 'Log',
      'individual': 'Jednotlivec',
      'partnership': 'Partnership',
      'trust': 'Trust',
      'charity': 'Charita',
      'government': 'Vláda',
      'classification': 'Klasifikace',
      'click_or_drop_files_here': 'Click or drop files here',
      'public': 'Public',
      'private': 'Soukromé',
      'image': 'Image',
      'other': 'Other',
      'hash': 'Hash',
      'linked_to': 'Linked To',
      'file_saved_in_path': 'The file has been saved in :path',
      'unlinked_transactions': 'Successfully unlinked :count transactions',
      'unlinked_transaction': 'Successfully unlinked transaction',
      'unlink': 'Odpojit',
      'view_dashboard_permission':
          'Allow user to access the dashboard, data is limited to available permissions',
      'is_tax_exempt': 'Osvobozen od daní',
      'district': 'District',
      'region': 'Region',
      'county': 'County',
      'tax_details': 'Tax Details',
      'activity_10_online':
          ':contact made payment :payment for invoice :invoice for :client',
      'activity_10_manual':
          ':user entered payment :payment for invoice :invoice for :client',
      'default_payment_type': 'Default Payment Type',
      'admin_initiated_payments': 'Admin Initiated Payments',
      'admin_initiated_payments_help':
          'Support entering a payment in the admin portal without an invoice',
      'use_mobile_to_manage_plan':
          'Use your phone subscription settings to manage your plan',
      'show_task_billable': 'Show Task Billable',
      'credit_item': 'Credit Item',
      'files': 'Files',
      'camera': 'Camera',
      'gallery': 'Gallery',
      'email_count_invoices': 'Email :count invoices',
      'project_location': 'Project Location',
      'invoice_task_item_description': 'Invoice Task Item Description',
      'invoice_task_item_description_help':
          'Add the item description to the invoice line items',
      'next_send_time': 'Next Send Time',
      'uploaded_certificate': 'Successfully uploaded certificate',
      'certificate_set': 'Certificate set',
      'certificate_not_set': 'Certificate not set',
      'passphrase_set': 'Passphrase set',
      'passphrase_not_set': 'Passphrase not set',
      'upload_certificate': 'Upload Certificate',
      'certificate_passphrase': 'Certificate Passphrase',
      'rename': 'Rename',
      'renamed_document': 'Successfully renamed document',
      'e_invoice': 'E-Invoice',
      'light_dark_mode': 'Light/Dark Mode',
      'activities': 'Activities',
      'routing_id': 'Routing ID',
      'enable_e_invoice': 'Enable E-Invoice',
      'e_invoice_type': 'E-Invoice Type',
      'e_quote_type': 'E-Quote Type',
      'reduced_tax': 'Reduced Tax',
      'override_tax': 'Override Tax',
      'zero_rated': 'Zero Rated',
      'reverse_tax': 'Reverse Tax',
      'updated_tax_category': 'Successfully updated the tax category',
      'updated_tax_categories': 'Successfully updated the tax categories',
      'set_tax_category': 'Set Tax Category',
      'payment_manual': 'Payment Manual',
      'tax_category': 'Tax Category',
      'physical_goods': 'Physical Goods',
      'digital_products': 'Digitální produkty',
      'services': 'Služby',
      'shipping': 'Shipping',
      'tax_exempt': 'Osvobozen od daní',
      'reduced_rate': 'Reduced Rate',
      'tax_all': 'Tax All',
      'tax_selected': 'Tax Selected',
      'version': 'version',
      'seller_subregion': 'Seller Subregion',
      'calculate_taxes': 'Calculate Taxes',
      'calculate_taxes_help':
          'Automatically calculate taxes when saving invoices',
      'admin': 'Administrátor',
      'owner': 'Vlastník',
      'link_expenses': 'Link Expenses',
      'converted_client_balance': 'Converted Client Balance',
      'converted_payment_balance': 'Converted Payment Balance',
      'total_hours': 'Total Hours',
      'date_picker_hint': 'Use +days to set the date in the future',
      'browser_pdf_viewer': 'Use Browser PDF Viewer',
      'browser_pdf_viewer_help':
          'Warning: Prevents interacting with app over the PDF',
      'increase_prices': 'Increase Prices',
      'update_prices': 'Update Prices',
      'incresed_prices': 'Successfully queued prices to be increased',
      'updated_prices': 'Successfully queued prices to be updated',
      'bacs': 'BACS Direct Debit',
      'api_token': 'API Token',
      'api_key': 'API Key',
      'endpoint': 'Endpoint',
      'billable': 'Billable',
      'not_billable': 'Not Billable',
      'allow_billable_task_items': 'Allow Billable Task Items',
      'allow_billable_task_items_help':
          'Enable configuring which task items are billed',
      'show_task_item_description': 'Show Task Item Description',
      'show_task_item_description_help':
          'Enable specifying task item descriptions',
      'email_record': 'Email Record',
      'invoice_product_columns': 'Invoice Product Columns',
      'quote_product_columns': 'Quote Product Columns',
      'minimum_payment_amount': 'Minimum Payment Amount',
      'client_initiated_payments': 'Client Initiated Payments',
      'client_initiated_payments_help':
          'Support making a payment in the client portal without an invoice',
      'share_invoice_quote_columns': 'Share Invoice/Quote Columns',
      'cc_email': 'CC Email',
      'payment_balance': 'Payment Balance',
      'view_report_permission':
          'Allow user to access the reports, data is limited to available permissions',
      'activity_138': 'Payment :payment was emailed to :client',
      'one_time_products': 'Jednorázové produkty',
      'optional_one_time_products': 'Optional One-Time Products',
      'required': 'Required',
      'hidden': 'Hidden',
      'payment_links': 'Payment Links',
      'action': 'Akce',
      'upgrade_to_paid_plan_to_schedule':
          'Upgrade to a paid plan to create schedules',
      'next_run': 'Next Run',
      'all_clients': 'All Clients',
      'show_aging_table': 'Show Aging Table',
      'show_payments_table': 'Show Payments Table',
      'only_clients_with_invoices': 'Only Clients with Invoices',
      'email_statement': 'Email Statement',
      'once': 'Once',
      'schedule': 'Rozvrh',
      'schedules': 'Schedules',
      'new_schedule': 'New Schedule',
      'edit_schedule': 'Edit Schedule',
      'created_schedule': 'Successfully created schedule',
      'updated_schedule': 'Successfully updated schedule',
      'archived_schedule': 'Successfully archived schedule',
      'deleted_schedule': 'Successfully deleted schedule',
      'removed_schedule': 'Successfully removed schedule',
      'restored_schedule': 'Successfully restored schedule',
      'search_schedule': 'Search Schedule',
      'search_schedules': 'Search Schedules',
      'archive_payment': 'Archivovat platbu',
      'archive_invoice': 'Archivovat fakturu',
      'archive_quote': 'Archivovat nabídku',
      'archive_credit': 'Archivovat kredit',
      'archive_task': 'Archivovat úlohu',
      'archive_client': 'Archivovat klienta',
      'archive_project': 'Archivovat projekt',
      'archive_expense': 'Archivovat náklad',
      'restore_payment': 'Obnovit platbu',
      'restore_invoice': 'Obnovit fakturu',
      'restore_quote': 'Obnovit nabídku',
      'restore_credit': 'Obnovit kredit',
      'restore_task': 'Obnovit úlohu',
      'restore_client': 'Obnovit klienta',
      'restore_project': 'Obnovit projekt',
      'restore_expense': 'Obnovit náklad',
      'archive_vendor': 'Archivovat dodavatele',
      'restore_vendor': 'Obnovit dodavatele',
      'create_product': 'Přidat produkt',
      'update_product': 'Aktualizovat produkt',
      'delete_product': 'Smazat produkt',
      'restore_product': 'Obnovit produkt',
      'archive_product': 'Archivovat produkt',
      'create_purchase_order': 'Create Purchase Order',
      'update_purchase_order': 'Update Purchase Order',
      'delete_purchase_order': 'Delete Purchase Order',
      'restore_purchase_order': 'Restore Purchase Order',
      'archive_purchase_order': 'Archive Purchase Order',
      'sent_invoice': 'Sent Invoice',
      'sent_quote': 'Sent Quote',
      'sent_credit': 'Sent Credit',
      'sent_purchase_order': 'Sent Purchase Order',
      'image_url': 'Image URL',
      'max_quantity': 'Max Quantity',
      'test_url': 'Test URL',
      'auto_bill_help_off': 'Option is not shown',
      'auto_bill_help_optin': 'Option is shown but not selected',
      'auto_bill_help_optout': 'Option is shown and selected',
      'auto_bill_help_always': 'Option is not shown',
      'payment_methods': 'Platební metody',
      'view_all': 'View All',
      'edit_all': 'Edit All',
      'accept_purchase_order_number': 'Accept Purchase Order Number',
      'accept_purchase_order_number_help':
          'Enable clients to provide a PO number when approving a quote',
      'from_email': 'From Email',
      'show_preview': 'Show Preview',
      'show_paid_stamp': 'Show Paid Stamp',
      'show_shipping_address': 'Zobrazit doručovací adresu',
      'no_documents_to_download':
          'There are no documents in the selected records to download',
      'pixels': 'Pixels',
      'logo_size': 'Logo Size',
      'postal_city': 'Postal/City',
      'failed': 'Failed',
      'client_contacts': 'Client Contacts',
      'sync_from': 'Sync From',
      'inventory_threshold': 'Inventory Threshold',
      'hour': 'Hodina',
      'emailed_statement': 'Successfully queued statement to be sent',
      'show_email_footer': 'Show Email Footer',
      'invoice_task_hours': 'Invoice Task Hours',
      'invoice_task_hours_help': 'Add the hours to the invoice line items',
      'auto_bill_standard_invoices': 'Auto Bill Standard Invoices',
      'auto_bill_recurring_invoices': 'Auto Bill Recurring Invoices',
      'email_alignment': 'Email Alignment',
      'pdf_preview_location': 'PDF Preview Location',
      'mailgun': 'Mailgun',
      'postmark': 'Postmark',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Click + to create a record',
      'last365_days': 'Last 365 Days',
      'import_design': 'Import Design',
      'imported_design': 'Successfully imported design',
      'invalid_design': 'The design is invalid, the :value section is missing',
      'setup_wizard_logo': 'Would you like to upload your logo?',
      'upload': 'Nahrát',
      'installed_version': 'Installed Version',
      'notify_vendor_when_paid': 'Notify Vendor When Paid',
      'notify_vendor_when_paid_help':
          'Send an email to the vendor when the expense is marked as paid',
      'update_payment': 'Update Payment',
      'markup': 'Markup',
      'purchase_order_created': 'Purchase Order Created',
      'purchase_order_sent': 'Purchase Order Sent',
      'purchase_order_viewed': 'Purchase Order Viewed',
      'purchase_order_accepted': 'Purchase Order Accepted',
      'credit_payment_error':
          'The credit amount can not be greater than the payment amount',
      'klarna': 'Klarna',
      'convert_payment_currency_help':
          'Set an exchange rate when entering a manual payment',
      'convert_expense_currency_help':
          'Set an exchange rate when creating an expense',
      'matomo_url': 'Matomo URL',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Add To Invoice',
      'online_payment_email_help':
          'Send an email when an online payment is made',
      'manual_payment_email_help':
          'Send an email when manually entering a payment',
      'mark_paid_payment_email_help':
          'Send an email when marking an invoice as paid',
      'delete_project': 'Smazat projekt',
      'linked_transaction': 'Successfully linked transaction',
      'link_payment': 'Link Payment',
      'link_expense': 'Link Expense',
      'lock_invoiced_tasks': 'Lock Invoiced Tasks',
      'lock_invoiced_tasks_help':
          'Prevent tasks from being edited once invoiced',
      'registration_required': 'Registrace vyžadována',
      'registration_required_help': 'Require clients to register',
      'use_inventory_management': 'Use Inventory Management',
      'use_inventory_management_help': 'Require products to be in stock',
      'optional_products': 'Volitelné produkty',
      'optional_recurring_products': 'Volitelné pravidelné produkty',
      'convert_matched': 'Convert',
      'auto_billed_invoice': 'Successfully queued invoice to be auto-billed',
      'auto_billed_invoices': 'Successfully queued invoices to be auto-billed',
      'operator': 'Operator',
      'value': 'Value',
      'is': 'Is',
      'contains': 'Contains',
      'starts_with': 'Starts with',
      'is_empty': 'Is empty',
      'add_rule': 'Add Rule',
      'match_all_rules': 'Match All Rules',
      'match_all_rules_help':
          'All criteria needs to match for the rule to be applied',
      'auto_convert_help':
          'Automatically convert matched transactions to expenses',
      'rules': 'Rules',
      'transaction_rule': 'Transaction Rule',
      'transaction_rules': 'Transaction Rules',
      'new_transaction_rule': 'New Transaction Rule',
      'edit_transaction_rule': 'Edit Transaction Rule',
      'created_transaction_rule': 'Successfully created rule',
      'updated_transaction_rule': 'Successfully updated transaction rule',
      'archived_transaction_rule': 'Successfully archived transaction rule',
      'deleted_transaction_rule': 'Successfully deleted transaction rule',
      'removed_transaction_rule': 'Successfully removed transaction rule',
      'restored_transaction_rule': 'Successfully restored transaction rule',
      'search_transaction_rule': 'Search Transaction Rule',
      'search_transaction_rules': 'Search Transaction Rules',
      'save_as_default_terms': 'Uložit jako výchozí podmínky',
      'save_as_default_footer': 'Uložit jako výchozí patičku',
      'auto_sync': 'Auto Sync',
      'refresh_accounts': 'Refresh Accounts',
      'upgrade_to_connect_bank_account':
          'Upgrade to Enterprise to connect your bank account',
      'click_here_to_connect_bank_account':
          'Click here to connect your bank account',
      'disable_2fa': 'Disable 2FA',
      'change_number': 'Change Number',
      'resend_code': 'Resend Code',
      'base_type': 'Base Type',
      'category_type': 'Category Type',
      'bank_transaction': 'Transaction',
      'bulk_print': 'Print PDF',
      'vendor_postal_code': 'Vendor Postal Code',
      'preview_location': 'Preview Location',
      'bottom': 'Bottom',
      'side': 'Side',
      'pdf_preview': 'PDF Preview',
      'long_press_to_select': 'Long Press to Select',
      'purchase_order_number': 'Purchase Order Number',
      'purchase_order_item': 'Purchase Order Item',
      'would_you_rate_the_app': 'Would you like to rate the app?',
      'include_deleted': 'Include Deleted',
      'include_deleted_help': 'Include deleted records in reports',
      'due_on': 'Due On',
      'converted_transactions': 'Transakce úspěšně konvertovány',
      'created_bank_account': 'Bankovní účet úspěšně vytvořen',
      'updated_bank_account': 'Bankovní účet úspěšně změněn',
      'edit_bank_account': 'Editovat bankovní účet',
      'default_category': 'Default Category',
      'account_type': 'Typ účtu',
      'new_bank_account': 'Add Bank Account',
      'connect_accounts': 'Connect Accounts',
      'manage_rules': 'Manage Rules',
      'search_category': 'Search 1 Category',
      'search_categories': 'Search :count Categories',
      'min_amount': 'Min Amount',
      'max_amount': 'Max Amount',
      'selected': 'Selected',
      'converted_transaction': 'Successfully converted transaction',
      'convert_to_payment': 'Convert to Payment',
      'deposit': 'Deposit',
      'withdrawal': 'Withdrawal',
      'deposits': 'Deposits',
      'withdrawals': 'Withdrawals',
      'matched': 'Matched',
      'unmatched': 'Unmatched',
      'create_credit': 'Create Credit',
      'update_credit': 'Update Credit',
      'delete_credit': 'Smazat kredit',
      'transaction': 'Transaction',
      'transactions': 'Transakce',
      'new_transaction': 'New Transaction',
      'edit_transaction': 'Edit Transaction',
      'created_transaction': 'Successfully created transaction',
      'updated_transaction': 'Successfully updated transaction',
      'archived_transaction': 'Successfully archived transaction',
      'deleted_transaction': 'Successfully deleted transaction',
      'removed_transaction': 'Successfully removed transaction',
      'restored_transaction': 'Successfully restored transaction',
      'search_transaction': 'Search Transaction',
      'search_transactions': 'Hledat v :count transakcích',
      'bank_account': 'Bank Account',
      'bank_accounts': 'Platební karty a banky',
      'archived_bank_account': 'Bankovní účet úspěšně archivován',
      'deleted_bank_account': 'Successfully deleted bank account',
      'removed_bank_account': 'Successfully removed bank account',
      'restored_bank_account': 'Successfully restored bank account',
      'search_bank_account': 'Search Bank Account',
      'search_bank_accounts': 'Search :count Bank Accounts',
      'connect': 'Connect',
      'mark_paid_payment_email': 'Mark Paid Payment Email',
      'convert_to_project': 'Convert to Project',
      'client_email': 'Client Email',
      'invoice_task_project': 'Invoice Task Project',
      'invoice_task_project_help': 'Add the project to the invoice line items',
      'field': 'Field',
      'period': 'Period',
      'fields_per_row': 'Fields Per Row',
      'total_active_invoices': 'Active Invoices',
      'total_outstanding_invoices': 'Outstanding Invoices',
      'total_completed_payments': 'Completed Payments',
      'total_refunded_payments': 'Refunded Payments',
      'total_active_quotes': 'Active Quotes',
      'total_approved_quotes': 'Approved Quotes',
      'total_unapproved_quotes': 'Unapproved Quotes',
      'total_logged_tasks': 'Logged Tasks',
      'total_invoiced_tasks': 'Invoiced Tasks',
      'total_paid_tasks': 'Placené úlohy',
      'total_logged_expenses': 'Logged Expenses',
      'total_pending_expenses': 'Pending Expenses',
      'total_invoiced_expenses': 'Vyfakturované náklady',
      'total_invoice_paid_expenses': 'Invoice Paid Expenses',
      'activity_130': ':user created purchase order :purchase_order',
      'activity_131': ':user updated purchase order :purchase_order',
      'activity_132': ':user archived purchase order :purchase_order',
      'activity_133': ':user deleted purchase order :purchase_order',
      'activity_134': ':user restored purchase order :purchase_order',
      'activity_135': ':user emailed purchase order :purchase_order',
      'activity_136': ':contact viewed purchase order :purchase_order',
      'activity_137': ':contact accepted purchase order :purchase_order',
      'vendor_portal': 'Vendor Portal',
      'send_code': 'Send Code',
      'save_to_upload_documents':
          'Uložte záznam, abyste mohl/a nahrát dokumenty.',
      'expense_tax_rates': 'Expense Tax Rates',
      'invoice_item_tax_rates': 'Invoice Item Tax Rates',
      'verified_phone_number': 'Successfully verified phone number',
      'code_was_sent': 'A code has been sent via SMS',
      'code_was_sent_to': 'A code has been sent via SMS to :number',
      'resend': 'Resend',
      'verify': 'Verify',
      'enter_phone_number': 'Please provide a phone number',
      'invalid_phone_number': 'Invalid phone number',
      'verify_phone_number': 'Verify Phone Number',
      'verify_phone_number_help':
          'Please verify your phone number to send emails',
      'verify_phone_number_2fa_help':
          'Please verify your phone number for 2FA backup',
      'merged_clients': 'Successfully merged clients',
      'merge_into': 'Merge Into',
      'merge': 'Merge',
      'price_change_accepted': 'Price change accepted',
      'price_change_failed': 'Price change failed with code',
      'restore_purchases': 'Restore Purchases',
      'activate': 'Activate',
      'connect_apple': 'Connect Apple',
      'disconnect_apple': 'Disconnect Apple',
      'disconnected_apple': 'Successfully disconnected Apple',
      'send_now': 'Send Now',
      'received': 'Received',
      'purchase_order_date': 'Purchase Order Date',
      'converted_to_expense': 'Successfully converted to expense',
      'converted_to_expenses': 'Successfully converted to expenses',
      'convert_to_expense': 'Převést na náklad',
      'add_to_inventory': 'Add to Inventory',
      'added_purchase_order_to_inventory':
          'Successfully added purchase order to inventory',
      'added_purchase_orders_to_inventory':
          'Successfully added purchase orders to inventory',
      'client_document_upload': 'Client Document Upload',
      'vendor_document_upload': 'Vendor Document Upload',
      'vendor_document_upload_help': 'Umožnit dodavatelům nahrávat dokumenty',
      'are_you_enjoying_the_app': 'Are you enjoying the app?',
      'yes_its_great': 'Yes, it\'s great!',
      'not_so_much': 'Not so much',
      'would_you_rate_it': 'Great to hear! Would you like to rate it?',
      'would_you_tell_us_more':
          'Sorry to hear it! Would you like to tell us more?',
      'sure_happy_to': 'Sure, happy to',
      'no_not_now': 'No, not now',
      'add': 'Add',
      'last_sent_template': 'Last Sent Template',
      'enable_flexible_search': 'Enable Flexible Search',
      'enable_flexible_search_help':
          'Match non-contiguous characters, ie. \'ct\' matches \'cat\'',
      'vendor_details': 'Vendor Details',
      'purchase_order_details': 'Purchase Order Details',
      'qr_iban': 'QR IBAN',
      'besr_id': 'BESR ID',
      'accept': 'Přijmout',
      'clone_to_purchase_order': 'Clone to PO',
      'vendor_email_not_set': 'Vendor does not have an email address set',
      'bulk_send_email': 'Send Email',
      'marked_purchase_order_as_sent':
          'Successfully marked purchase order as sent',
      'marked_purchase_orders_as_sent':
          'Successfully marked purchase orders as sent',
      'accepted_purchase_order': 'Successfully accepted purchase order',
      'accepted_purchase_orders': 'Successfully accepted purchase orders',
      'cancelled_purchase_order': 'Successfully cancelled purchase order',
      'cancelled_purchase_orders': 'Successfully cancelled purchase orders',
      'accepted': 'Accepted',
      'please_select_a_vendor': 'Please select a vendor',
      'purchase_order_total': 'Purchase Order Total',
      'email_purchase_order': 'Email Purchase Order',
      'bulk_email_purchase_orders': 'Email Purchase Orders',
      'disconnected_email': 'Successfully disconnected email',
      'connect_email': 'Connect Email',
      'disconnect_email': 'Disconnect Email',
      'use_web_app_to_connect_microsoft':
          'Please use the web app to connect to Microsoft',
      'email_provider': 'Email Provider',
      'connect_microsoft': 'Connect Microsoft',
      'disconnect_microsoft': 'Disconnect Microsoft',
      'connected_microsoft': 'Successfully connected Microsoft',
      'disconnected_microsoft': 'Successfully disconnected Microsoft',
      'microsoft_sign_in': 'Login with Microsoft',
      'microsoft_sign_up': 'Sign up with Microsoft',
      'emailed_purchase_order': 'Successfully queued purchase order to be sent',
      'emailed_purchase_orders':
          'Successfully queued purchase orders to be sent',
      'enable_react_app': 'Change to the React web app',
      'purchase_order_design': 'Purchase Order Design',
      'purchase_order_terms': 'Purchase Order Terms',
      'purchase_order_footer': 'Purchase Order Footer',
      'require_purchase_order_signature': 'Purchase Order Signature',
      'require_purchase_order_signature_help':
          'Require vendor to provide their signature.',
      'purchase_order': 'Purchase Order',
      'purchase_orders': 'Purchase Orders',
      'new_purchase_order': 'New Purchase Order',
      'edit_purchase_order': 'Edit Purchase Order',
      'created_purchase_order': 'Successfully created purchase order',
      'updated_purchase_order': 'Successfully updated purchase order',
      'archived_purchase_order': 'Successfully archived purchase order',
      'deleted_purchase_order': 'Successfully deleted purchase order',
      'removed_purchase_order': 'Successfully removed purchase order',
      'restored_purchase_order': 'Successfully restored purchase order',
      'search_purchase_order': 'Search Purchase Order',
      'search_purchase_orders': 'Search Purchase Orders',
      'login_url': 'Login URL',
      'payment_settings': 'Nastavení plateb',
      'default': 'Default',
      'stock_quantity': 'Stock Quantity',
      'notification_threshold': 'Notification Threshold',
      'track_inventory': 'Track Inventory',
      'track_inventory_help':
          'Display a product stock field and update when invoices are sent',
      'stock_notifications': 'Stock Notifications',
      'stock_notifications_help':
          'Send an email when the stock reaches the threshold',
      'vat': 'VAT',
      'standing': 'Trvající',
      'view_map': 'View Map',
      'set_default_design': 'Set Default Design',
      'add_gateway': 'Přidat platební bránu',
      'add_gateway_help_message':
          'Add a payment gateway (ie. Stripe, WePay or PayPal) to accept online payments',
      'left': 'Left',
      'right': 'Right',
      'center': 'Center',
      'page_numbering': 'Page Numbering',
      'page_numbering_alignment': 'Page Numbering Alignment',
      'invoice_sent_notification_label': 'Invoice Sent',
      'show_product_description': 'Zobrazit popis produktu',
      'show_product_description_help':
          'Include the description in the product dropdown',
      'invoice_items': 'Invoice Items',
      'quote_items': 'Quote Items',
      'profitloss': 'Profit and Loss',
      'import_format': 'Import Format',
      'export_format': 'Export Format',
      'export_type': 'Export Type',
      'stop_on_unpaid': 'Stop On Unpaid',
      'stop_on_unpaid_help':
          'Stop creating recurring invoices if the last invoice is unpaid.',
      'use_quote_terms': 'Use Quote Terms',
      'use_quote_terms_help': 'When converting a quote to an invoice',
      'add_country': 'Add Country',
      'enable_tooltips': 'Enable Tooltips',
      'enable_tooltips_help': 'Show tooltips when hovering the mouse',
      'multiple_client_error': 'Error: records belong to more than one client',
      'register_label': 'Create your account in seconds',
      'login_label': 'Login to an existing account',
      'add_to_invoice': 'Přidat k faktuře :invoice',
      'no_invoices_found': 'No invoices found',
      'week': 'Week',
      'created_record': 'Successfully created record',
      'auto_archive_paid_invoices': 'Auto Archive Paid',
      'auto_archive_paid_invoices_help':
          'Automatically archive invoices when they are paid.',
      'auto_archive_cancelled_invoices': 'Auto Archive Cancelled',
      'auto_archive_cancelled_invoices_help':
          'Automatically archive invoices when cancelled.',
      'alternate_pdf_viewer': 'Alternate PDF Viewer',
      'alternate_pdf_viewer_help':
          'Improve scrolling over the PDF preview [BETA]',
      'invoice_currency': 'Měna faktury',
      'range': 'Rozsah',
      'tax_amount1': 'Tax Amount 1',
      'tax_amount2': 'Tax Amount 2',
      'tax_amount3': 'Tax Amount 3',
      'create_project': 'Vytvořit projekt',
      'update_project': 'Aktualizovat projekt',
      'view_task': 'View Task',
      'cancel_invoice': 'Cancel',
      'changed_status': 'Successfully changed task status',
      'change_status': 'Change Status',
      'fees_sample': 'The fee for a :amount invoice would be :total.',
      'enable_touch_events': 'Enable Touch Events',
      'enable_touch_events_help': 'Support drag events to scroll',
      'after_saving': 'After Saving',
      'view_record': 'View Record',
      'enable_email_markdown': 'Enable Email Markdown',
      'enable_email_markdown_help': 'Use visual markdown editor for emails',
      'enable_pdf_markdown': 'Enable PDF Markdown',
      'json_help': 'Note: JSON files generated by the v4 app are not supported',
      'release_notes': 'Release Notes',
      'upgrade_to_view_reports': 'Upgrade your plan to view reports',
      'started_tasks': 'Úspěšně zahájeno :value úloh',
      'stopped_tasks': 'Úspěšně ukončeno :value úloh',
      'approved_quote': 'Successfully apporved quote',
      'approved_quotes': 'Successfully :value approved quotes',
      'approve': 'Schválit',
      'client_website': 'Klientský web',
      'invalid_time': 'Invalid Time',
      'client_shipping_state': 'Client Shipping State',
      'client_shipping_city': 'Client Shipping City',
      'client_shipping_postal_code': 'Client Shipping Postal Code',
      'client_shipping_country': 'Client Shipping Country',
      'load_pdf': 'Načíst PDF',
      'start_free_trial': 'Start Free Trial',
      'start_free_trial_message':
          'Start your FREE 14 day trial of the Pro Plan',
      'due_on_receipt': 'Due on Receipt',
      'is_paid': 'Je zaplaceno',
      'age_group_paid': 'Zaplaceno',
      'id': 'ID',
      'convert_to': 'Konvertovat na',
      'client_currency': 'Měna klienta',
      'company_currency': 'Měna firmy',
      'purged_client': 'Successfully purged client',
      'custom_emails_disabled_help':
          'To prevent spam we require upgrading to a paid account to customize the email',
      'upgrade_to_add_company': 'Upgrade your plan to add companies',
      'small': 'Malý',
      'marked_credit_as_paid': 'Successfully marked credit as paid',
      'marked_credits_as_paid': 'Successfully marked credits as paid',
      'wait_for_loading': 'Data loading - please wait for it to complete',
      'wait_for_saving': 'Data saving - please wait for it to complete',
      'html_preview_warning':
          'Note: changes made here are only previewed, they must be applied in the tabs above to be saved',
      'remaining': 'Zbývá',
      'invoice_paid': 'Faktura zaplacena',
      'activity_120': ':user created recurring expense :recurring_expense',
      'activity_121': ':user updated recurring expense :recurring_expense',
      'activity_122': ':user archived recurring expense :recurring_expense',
      'activity_123': ':user deleted recurring expense :recurring_expense',
      'activity_124': ':user restored recurring expense :recurring_expense',
      'normal': 'Normální',
      'large': 'Velký',
      'extra_large': 'Extra velký',
      'show_pdf_preview': 'Zobrazovat náhled PDF',
      'show_pdf_preview_help': 'Zobrazovat náhled PDF při úpravě faktur',
      'print_pdf': 'Tisk PDF',
      'remind_me': 'Remind Me',
      'instant_bank_pay': 'Instant Bank Pay',
      'click_selected': 'Click Selected',
      'hide_preview': 'Skrýt náhle',
      'edit_record': 'Upravit záznam',
      'credit_is_more_than_invoice':
          'The credit amount can not be more than the invoice amount',
      'giropay': 'GiroPay',
      'direct_debit': 'Direct Debit',
      'please_set_a_password': 'Prosím nastavte si heslo účtu',
      'set_password': 'Nastavit heslo',
      'disconnected_gateway': 'Successfully disconnected gateway',
      'disconnect': 'Odpojit',
      'add_to_invoices': 'Přidávat do faktur',
      'acss': 'ACSS Debit',
      'becs': 'BECS Direct Debit',
      'bulk_download': 'Stáhnout',
      'persist_data_help':
          'Save data locally to enable the app to start faster, disabling may improve performance in large accounts',
      'persist_ui': 'Persist UI',
      'persist_ui_help':
          'Save UI state locally to enable the app to start at the last location, disabling may improve performance',
      'client_postal_code': 'PSČ klienta',
      'client_vat_number': 'DIČ klienta',
      'has_tasks': 'Má úkoly',
      'registration': 'Registrace',
      'unauthorized_stripe_warning':
          'Autorizujte Stripe pro přijmání online plateb.',
      'view_expense': 'Zobrazit náklad # :expense',
      'view_statement': 'View Statement',
      'sepa': 'SEPA Direct Debit',
      'ideal': 'iDEAL',
      'przelewy24': 'Przelewy24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'Aktualizovat všechny záznamy',
      'system': 'Systém',
      'set_default_company': 'Nastavit výchozí firmu',
      'updated_company': 'Firma úspěšně aktualizována',
      'kbc': 'KBC',
      'bancontact': 'Bancontact',
      'why_are_you_leaving': 'Help us improve by telling us why (optional)',
      'webhook_success': 'Webhook Success',
      'error_cross_client_tasks': 'Tasks must all belong to the same client',
      'error_cross_client_expenses':
          'Expenses must all belong to the same client',
      'app': 'Aplikace',
      'for_best_performance': 'For the best performance download the :app app',
      'gross_line_total': 'Gross Line Total',
      'bulk_email_invoices': 'Email Invoices',
      'bulk_email_quotes': 'Email Quotes',
      'bulk_email_credits': 'Email Credits',
      'from_name': 'From Name',
      'clone_to_expense': 'Clone to Expense',
      'recurring_expense': 'Pravidelný náklad',
      'recurring_expenses': 'Pravidelné náklady',
      'new_recurring_expense': 'Nový pravidelný náklad',
      'edit_recurring_expense': 'Upravit pravidelný náklad',
      'created_recurring_expense': 'Pravidelný náklad úspěšně vytvořen',
      'updated_recurring_expense': 'Pravidelný náklad úspěšně aktualizován',
      'archived_recurring_expense': 'Pravidelný náklad úspěšně archivován',
      'deleted_recurring_expense': 'Pravidelný náklad úspěšně smazán',
      'removed_recurring_expense': 'Pravidelný náklad úspěšně odstraněn',
      'restored_recurring_expense': 'Pravidelný náklad úspěšně obnoven',
      'search_recurring_expense': 'Hledat pravidelný náklad',
      'search_recurring_expenses': 'Hledat pravidelné náklady',
      'last_sent_date': 'Last Sent Date',
      'include_drafts': 'Zahrnout koncepty',
      'include_drafts_help': 'Zahrnout koncepty ve výpisech',
      'is_invoiced': 'Je vyfakturováno',
      'change_plan': 'Manage Plan',
      'persist_data': 'Persistovat data',
      'customer_count': 'Počet zákazníků',
      'verify_customers': 'Ověřit klienty',
      'google_analytics': 'Google Analytics',
      'google_analytics_tracking_id': 'Google Analytics Tracking ID',
      'decimal_comma': 'Desetinná čárka',
      'use_comma_as_decimal_place':
          'Použít čárku jako desetinný oddělovač ve formulářích',
      'select_method': 'Vybrat metodu',
      'select_platform': 'Vybrat platformu',
      'use_web_app_to_connect_gmail':
          'Please use the web app to connect to Gmail',
      'expense_tax_help': 'Item tax rates are disabled',
      'enable_markdown': 'Zapnout Markdown',
      'enable_markdown_help': 'Konvertovat Markdown  do HTML na PDF',
      'user_guide': 'Uživatelská příručka',
      'add_second_contact': 'Přidat druhý kontakt',
      'previous_page': 'Přechozí stránka',
      'next_page': 'Další stránka',
      'export_colors': 'Exportovat barvy',
      'import_colors': 'Importovat barvy',
      'clear_all': 'Clear All',
      'contrast': 'Kontrast',
      'custom_colors': 'Vlastní barvy',
      'colors': 'Barvy',
      'sidebar_active_background_color': 'Sidebar Active Background Color',
      'sidebar_active_font_color': 'Sidebar Active Font Color',
      'sidebar_inactive_background_color': 'Sidebar Inactive Background Color',
      'sidebar_inactive_font_color': 'Sidebar Inactive Font Color',
      'table_alternate_row_background_color':
          'Table Alternate Row Background Color',
      'invoice_header_background_color': 'Invoice Header Background Color',
      'invoice_header_font_color': 'Invoice Header Font Color',
      'net_subtotal': 'Net',
      'review_app': 'Ohodnotit aplikaci',
      'check_status': 'Zkontrolovat status',
      'free_trial': 'Free Trial',
      'free_trial_ends_in_days':
          'The Pro plan trial ends in :count days, click to upgrade.',
      'free_trial_ends_today':
          'Today is the last day of the Pro plan trial, click to upgrade.',
      'change_email': 'Změnit e-mail',
      'client_portal_domain_hint':
          'Optionally configure a separate client portal domain',
      'tasks_shown_in_portal': 'Tasks Shown in Portal',
      'uninvoiced': 'Nevyfakturováno',
      'subdomain_guide':
          'The subdomain is used in the client portal to personalize links to match your brand. ie, https://your-brand.invoicing.co',
      'send_time': 'Send Time',
      'import_data': 'Importovat data',
      'import_settings': 'Importovat nastavení',
      'json_file_missing': 'Prosím vyberte JSON soubor',
      'json_option_missing': 'Please select to import the settings and/or data',
      'json': 'JSON',
      'no_payment_types_enabled': 'No payment types enabled',
      'wait_for_data': 'Please wait for the data to finish loading',
      'net_total': 'Net Total',
      'has_taxes': 'Má daně',
      'import_customers': 'Importovat klienty',
      'imported_customers': 'Successfully started importing customers',
      'login_success': 'Přihlášení úspěšné',
      'login_failure': 'Přihlášení selhalo',
      'exported_data':
          'Once the file is ready you\'ll receive an email with a download link',
      'include_deleted_clients': 'Zahrnout odstraněné klienty',
      'include_deleted_clients_help':
          'Load records belonging to deleted clients',
      'step_1_sign_in': 'Krok 1: Přihlásit se',
      'step_2_authorize': 'Step 2: Authorize',
      'account_id': 'ID účtu',
      'migration_not_yet_completed': 'Migrace ještě není dokončená',
      'activity_100': ':user created recurring invoice :recurring_invoice',
      'activity_101': ':user updated recurring invoice :recurring_invoice',
      'activity_102': ':user archived recurring invoice :recurring_invoice',
      'activity_103': ':user deleted recurring invoice :recurring_invoice',
      'activity_104': ':user restored recurring invoice :recurring_invoice',
      'show_task_end_date': 'Show Task End Date',
      'show_task_end_date_help': 'Enable specifying the task end date',
      'gateway_setup': 'Gateway Setup',
      'preview_sidebar': 'Preview Sidebar',
      'years_data_shown': 'Years Data Shown',
      'ended_all_sessions': 'Successfully ended all sessions',
      'end_all_sessions': 'End All Sessions',
      'count_session': '1 Session',
      'count_sessions': ':count Sessions',
      'invoice_created': 'Faktura vytvořena',
      'quote_created': 'Nabídka vytvořena',
      'credit_created': 'Kredit vytvořen',
      'pro': 'Profi',
      'enterprise': 'Enterprise',
      'last_updated': 'Last Updated',
      'invoice_item': 'Fakturační položka',
      'quote_item': 'Nabídková položka',
      'contact_first_name': 'Křestní jméno',
      'contact_last_name': 'Přijmení',
      'order': 'Order',
      'unassigned': 'Unassigned',
      'partial_value': 'Musí být větší než nula  a méně než součet',
      'search_kanban': 'Search Kanban',
      'search_kanbans': 'Search Kanban',
      'kanban': 'Kanban',
      'enable': 'Povolit',
      'move_top': 'Move Top',
      'move_up': 'Move Up',
      'move_down': 'Move Down',
      'move_bottom': 'Move Bottom',
      'subdomain_help':
          'Nastavit subdoménu nebo zobrazit fakturu na vlastní webové stránce.',
      'body_variable_missing':
          'Error: the custom email must include a :body variable',
      'add_body_variable_message': 'Make sure to include a :body variable',
      'view_date_formats': 'View Date Formats',
      'is_viewed': 'Je zobrazeno',
      'letter': 'Letter',
      'legal': 'Legal',
      'page_layout': 'Rozložení stránky',
      'portrait': 'Portrét',
      'landscape': 'Landscape',
      'owner_upgrade_to_paid_plan':
          'The account owner can upgrade to a paid plan to enable the advanced advanced settings',
      'upgrade_to_paid_plan':
          'Upgrade to a paid plan to enable the advanced settings',
      'invoice_payment_terms': 'Invoice Payment Terms',
      'quote_valid_until': 'Quote Valid Until',
      'no_headers': 'No Headers',
      'add_header': 'Přidat hlavičku',
      'remove_header': 'Odstranit hlavičku',
      'return_url': 'Return URL',
      'rest_method': 'REST metoda',
      'header_key': 'Header Key',
      'header_value': 'Header Value',
      'recurring_products': 'Pravidelné produkty',
      'promo_code': 'Promo kód',
      'promo_discount': 'Promo Discount',
      'allow_cancellation': 'Allow Cancellation',
      'per_seat_enabled': 'Per Seat Enabled',
      'max_seats_limit': 'Max Seats Limit',
      'trial_enabled': 'Trial Enabled',
      'trial_duration': 'Trial Duration',
      'allow_query_overrides': 'Allow Query Overrides',
      'allow_plan_changes': 'Allow Plan Changes',
      'plan_map': 'Plan Map',
      'refund_period': 'Refund Period',
      'webhook_configuration': 'Webhook Configuration',
      'purchase_page': 'Purchase Page',
      'security': 'Zabezpečení',
      'email_bounced': 'Email Bounced',
      'email_spam_complaint': 'Spam Complaint',
      'email_delivery': 'Email Delivery',
      'webhook_response': 'Webhook Response',
      'pdf_response': 'PDF Response',
      'authentication_failure': 'Autentifikace selhala',
      'pdf_failed': 'PDF Failed',
      'pdf_success': 'PDF Success',
      'modified': 'Modifikováno',
      'payment_link': 'Payment Link',
      'new_payment_link': 'New Payment Link',
      'edit_payment_link': 'Edit Payment Link',
      'created_payment_link': 'Successfully created payment link',
      'updated_payment_link': 'Successfully updated payment link',
      'archived_payment_link': 'Successfully archived payment link',
      'deleted_payment_link': 'Successfully deleted payment link',
      'removed_payment_link': 'Successfully removed payment link',
      'restored_payment_link': 'Successfully restored payment link',
      'search_payment_link': 'Search 1 Payment Link',
      'search_payment_links': 'Search :count Payment Links',
      'subdomain_is_not_available': 'Subdoména není dostupná',
      'connect_gmail': 'Propojit s Gmail',
      'disconnect_gmail': 'Odpojit Gmail',
      'connected_gmail': 'Úspěšně propojeno s Gmail',
      'disconnected_gmail': 'Úspěšně odpojeno od Gmai',
      'update_fail_help':
          'Changes to the codebase may be blocking the update, you can run this command to discard the changes:',
      'client_id_number': 'Client ID Number',
      'count_minutes': ':count Minutes',
      'password_timeout': 'Password Timeout',
      'shared_invoice_credit_counter': 'Share Invoice/Credit Counter',
      'use_last_email': 'Use last email',
      'activate_company': 'Aktivovat firmu',
      'activate_company_help':
          'Enable emails, recurring invoices and notifications',
      'an_error_occurred_try_again':
          'Vyskytla se chyba, zkuste to prosím později',
      'please_first_set_a_password': 'Nejprve nastavte heslo',
      'changing_phone_disables_two_factor':
          'Warning: Changing your phone number will disable 2FA',
      'help_translate': 'Pomozte přeložit',
      'please_select_a_country': 'Vyberte zemi',
      'resend_invite': 'Resend Invitation',
      'disabled_two_factor': 'Dvoufázové ověření úspěšně deaktivováno',
      'connected_google': 'Účet úspěšně připojen',
      'disconnected_google': 'Účet úspěšně odpojen',
      'delivered': 'Doručeno',
      'bounced': 'Bounced',
      'spam': 'Spam',
      'view_docs': 'Zobrazit dokumenty',
      'enter_phone_to_enable_two_factor':
          'Please provide a mobile phone number to enable two factor authentication',
      'send_sms': 'Odeslat SMS',
      'sms_code': 'SMS kód',
      'two_factor_setup_help': 'Scan the bar code with a :link compatible app.',
      'enabled_two_factor': 'Dvoufaktorové ověření úspěšně nastaveno',
      'connect_google': 'Propojit s Google',
      'disconnect_google': 'Odpojit od Google',
      'enable_two_factor': 'Dvoufaktorové ověření',
      'disable_two_factor': 'Deaktivovat dvoufázové ověření',
      'require_password_with_social_login':
          'Require Password with Social Login',
      'stay_logged_in': 'Zůstat přihlášen',
      'session_about_to_expire': 'Warning: Your session is about to expire',
      'count_hours': ':count hodin',
      'count_day': '1 den',
      'count_days': ':count dní',
      'web_session_timeout': 'Web Session Timeout',
      'security_settings': 'Nastavení bezpečí',
      'resend_email': 'Znovu odeslat e-mail',
      'confirm_your_email_address': 'Potvrďte svou e-mailovou adresu',
      'refunded_payment': 'Vrácená platba',
      'partially_unapplied': 'Partially Unapplied',
      'select_a_gmail_user': 'Please select a user authenticated with Gmail',
      'list_long_press': 'List Long Press',
      'show_actions': 'Zobrazit akce',
      'start_multiselect': 'Start Multiselect',
      'email_sent_to_confirm_email':
          'An email has been sent to confirm the email address',
      'counter_pattern_error':
          'To use :client_counter please add either :client_number or :client_id_number to prevent conflicts',
      'this_quarter': 'This Quarter',
      'last_quarter': 'Last Quarter',
      'to_update_run': 'Pro aktualizaci spusťte',
      'convert_to_invoice': 'Změnit na fakturu',
      'registration_url': 'Registrační URL',
      'invoice_project': 'Invoice Project',
      'invoice_task': 'Fakturační úloha',
      'invoice_expense': 'Fakturovat náklady',
      'search_payment_term': 'Search 1 Payment Term',
      'search_payment_terms': 'Search :count Payment Terms',
      'save_and_preview': 'Uložit a zobrazit náhled',
      'save_and_email': 'Uložit a odeslat e-mailem',
      'supported_events': 'Supported Events',
      'converted_amount': 'Converted Amount',
      'converted_balance': 'Converted Balance',
      'converted_paid_to_date': 'Converted Paid to Date',
      'converted_credit_balance': 'Converted Credit Balance',
      'converted_total': 'Converted Total',
      'is_sent': 'Je odesláno',
      'default_documents': 'Default Documents',
      'document_upload': 'Nahrání dokumentu',
      'document_upload_help': 'Povolit klientům nahrávat dokumenty',
      'expense_total': 'Náklady celkem',
      'enter_taxes': 'Zadejte daně',
      'by_rate': 'Podle sazby',
      'by_amount': 'Podle částky',
      'enter_amount': 'Zadejte částku',
      'before_taxes': 'Před daní',
      'after_taxes': 'Po dani',
      'color': 'Barva',
      'show': 'Zobrazit',
      'hide': 'Skrýt',
      'empty_columns': 'Prázdné sloupce',
      'debug_mode_is_enabled': 'Debugovací mód je zapnutý',
      'debug_mode_is_enabled_help':
          'Varování: je určený pouze pro vývoj na lokálním serveru. Může vyzradit údaje. Klikněte pro další informace.',
      'running_tasks': 'Běžící úlohy',
      'recent_tasks': 'Nedávné úkoly',
      'recent_expenses': 'Nedávné náklady',
      'upcoming_expenses': 'Nadcházející náklady',
      'update_app': 'Update App',
      'started_import': 'Successfully started import',
      'duplicate_column_mapping': 'Duplicate column mapping',
      'uses_inclusive_taxes': 'Uses Inclusive Taxes',
      'is_amount_discount': 'Is Amount Discount',
      'column': 'Sloupec',
      'sample': 'Vzorek',
      'map_to': 'Map To',
      'import': 'Importovat',
      'first_row_as_column_names': 'Use first row as column names',
      'select_file': 'Prosím zvolte soubor',
      'no_file_selected': 'No File Selected',
      'csv_file': 'CSV soubor',
      'csv': 'CSV',
      'freshbooks': 'FreshBooks',
      'invoice2go': 'Invoice2go',
      'invoicely': 'Invoicely',
      'waveaccounting': 'Wave Accounting',
      'zoho': 'Zoho',
      'accounting': 'Účetnictví',
      'required_files_missing': 'Please provide all CSVs.',
      'import_type': 'Import Type',
      'html_mode': 'HTML mód',
      'html_mode_help': 'Preview updates faster but is less accurate',
      'view_licenses': 'View Licenses',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': 'Fullscreen Editor',
      'sidebar_editor': 'Sidebar Editor',
      'please_type_to_confirm': 'Please type \':value\' to confirm',
      'purge': 'Purge',
      'service': 'Služba',
      'clone_to': 'Clone To',
      'clone_to_other': 'Clone to Other',
      'labels': 'Labels',
      'add_custom': 'Add Custom',
      'payment_tax': 'Payment Tax',
      'unpaid': 'Unpaid',
      'white_label': 'White Label',
      'delivery_note': 'Dodací list',
      'sent_invoices_are_locked': 'Sent invoices are locked',
      'paid_invoices_are_locked': 'Paid invoices are locked',
      'source_code': 'Source Code',
      'app_platforms': 'App Platforms',
      'invoice_late': 'Invoice Late',
      'quote_expired': 'Quote Expired',
      'partial_due': 'Částečně splaceno',
      'invoice_total': 'Celková částka',
      'quote_total': 'Celkem',
      'credit_total': 'Credit Total',
      'recurring_invoice_total': 'Invoice Total',
      'actions': 'Actions',
      'expense_number': 'Expense Number',
      'task_number': 'Task Number',
      'project_number': 'Project Number',
      'project_name': 'Název projektu',
      'warning': 'Warning',
      'view_settings': 'Nastavení zobrazení',
      'company_disabled_warning':
          'Varování: tato firma ještě nebylo aktivována',
      'late_invoice': 'Late Invoice',
      'expired_quote': 'Expired Quote',
      'remind_invoice': 'Remind Invoice',
      'cvv': 'CVV kód',
      'client_name': 'Jméno klienta',
      'client_phone': 'Client Phone',
      'required_fields': 'Required Fields',
      'calculated_rate': 'Calculated Rate',
      'default_task_rate': 'Default Task Rate',
      'clear_cache': 'Clear Cache',
      'sort_order': 'Sort Order',
      'task_status': 'Status',
      'task_statuses': 'Task Statuses',
      'new_task_status': 'New Task Status',
      'edit_task_status': 'Edit Task Status',
      'created_task_status': 'Successfully created task status',
      'updated_task_status': 'Successfully update task status',
      'archived_task_status': 'Successfully archived task status',
      'deleted_task_status': 'Successfully deleted task status',
      'removed_task_status': 'Task status úspěšně odstraněn',
      'restored_task_status': 'Successfully restored task status',
      'archived_task_statuses': 'Successfully archived :value task statuses',
      'deleted_task_statuses': 'Successfully deleted :value task statuses',
      'restored_task_statuses': 'Successfully restored :value task statuses',
      'search_task_status': 'Search 1 Task Status',
      'search_task_statuses': 'Search :count Task Statuses',
      'show_tasks_table': 'Zobrazit tabulku úloh',
      'show_tasks_table_help':
          'Vždy zobrazovat sekci s úlohami při zakládání faktur',
      'invoice_task_timelog': 'Invoice Task Timelog',
      'invoice_task_timelog_help': 'Add time details to the invoice line items',
      'invoice_task_datelog': 'Invoice Task Datelog',
      'invoice_task_datelog_help': 'Add date details to the invoice line items',
      'auto_start_tasks_help': 'Zahájit úlohy před uložením',
      'configure_statuses': 'Configure Statuses',
      'task_settings': 'Nastavení úloh',
      'configure_categories': 'Configure Categories',
      'expense_categories': 'Expense Categories',
      'new_expense_category': 'New Expense Category',
      'edit_expense_category': 'Edit Expense Category',
      'created_expense_category': 'Successfully created expense category',
      'updated_expense_category': 'Successfully updated expense category',
      'archived_expense_category': 'Successfully archived expense category',
      'deleted_expense_category': 'Successfully deleted category',
      'removed_expense_category': 'Successfully removed expense category',
      'restored_expense_category': 'Successfully restored expense category',
      'archived_expense_categories':
          'Successfully archived :count expense category',
      'deleted_expense_categories':
          'Successfully deleted expense :value categories',
      'restored_expense_categories':
          'Successfully restored expense :value categories',
      'search_expense_category': 'Search 1 Expense Category',
      'search_expense_categories': 'Search :count Expense Categories',
      'use_available_credits': 'Use Available Credits',
      'show_option': 'Show Option',
      'negative_payment_error':
          'The credit amount cannot exceed the payment amount',
      'view_changes': 'View Changes',
      'force_update': 'Force Update',
      'force_update_help':
          'You are running the latest version but there may be pending fixes available.',
      'mark_paid_help': 'Track the expense has been paid',
      'should_be_invoiced': 'Má být fakturován',
      'should_be_invoiced_help': 'Enable the expense to be invoiced',
      'add_documents_to_invoice_help': 'Make the documents visible to client',
      'convert_currency_help': 'Set an exchange rate',
      'expense_settings': 'Nastavení nákladů',
      'clone_to_recurring': 'Clone to Recurring',
      'crypto': 'Crypto',
      'paypal': 'PayPal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple/Google Pay',
      'user_field': 'User Field',
      'variables': 'Variables',
      'show_password': 'Show Password',
      'hide_password': 'Hide Password',
      'copy_error': 'Copy Error',
      'capture_card': 'Capture Card',
      'auto_bill_enabled': 'Auto Bill Enabled',
      'total_taxes': 'Total Taxes',
      'line_taxes': 'Line Taxes',
      'total_fields': 'Total Fields',
      'stopped_recurring_invoice': 'Successfully stopped recurring invoice',
      'started_recurring_invoice': 'Successfully started recurring invoice',
      'resumed_recurring_invoice': 'Successfully resumed recurring invoice',
      'gateway_refund': 'Gateway Refund',
      'gateway_refund_help': 'Process the refund with the payment gateway',
      'due_date_days': 'Due Date',
      'paused': 'Paused',
      'mark_active': 'Mark Active',
      'day_count': 'Day :count',
      'first_day_of_the_month': 'První den v měsíci',
      'last_day_of_the_month': 'Last Day of the Month',
      'use_payment_terms': 'Use Payment Terms',
      'endless': 'Endless',
      'next_send_date': 'Next Send Date',
      'remaining_cycles': 'Remaining Cycles',
      'recurring_invoice': 'Pravidelná faktura',
      'recurring_invoices': 'Pravidelné faktury',
      'new_recurring_invoice': 'Nová pravidelná faktura',
      'edit_recurring_invoice': 'Edit Recurring Invoice',
      'created_recurring_invoice': 'Successfully created recurring invoice',
      'updated_recurring_invoice': 'Successfully updated recurring invoice',
      'archived_recurring_invoice': 'Pravidelná faktura úspěšně archivována',
      'deleted_recurring_invoice': 'Pravidelná faktura smazána',
      'removed_recurring_invoice': 'Pravidelná faktura úspěšně odstraněna',
      'restored_recurring_invoice': 'Pravidelná faktura obnovena',
      'archived_recurring_invoices':
          'Successfully archived recurring :value invoices',
      'deleted_recurring_invoices':
          'Successfully deleted recurring :value invoices',
      'restored_recurring_invoices':
          'Successfully restored recurring :value invoices',
      'search_recurring_invoice': 'Search 1 Recurring Invoice',
      'search_recurring_invoices': 'Search :count Recurring Invoices',
      'send_date': 'Send Date',
      'auto_bill_on': 'Auto Bill On',
      'minimum_under_payment_amount': 'Minimum Under Payment Amount',
      'profit': 'Profit',
      'line_item': 'Line Item',
      'allow_over_payment': 'Allow Overpayment',
      'allow_over_payment_help': 'Support paying extra to accept tips',
      'allow_under_payment': 'Allow Underpayment',
      'allow_under_payment_help':
          'Support paying at minimum the partial/deposit amount',
      'test_mode': 'Test Mode',
      'opened': 'Opened',
      'payment_reconciliation_failure': 'Reconciliation Failure',
      'payment_reconciliation_success': 'Reconciliation Success',
      'gateway_success': 'Gateway Success',
      'gateway_failure': 'Gateway Failure',
      'gateway_error': 'Gateway Error',
      'email_send': 'Email Send',
      'email_retry_queue': 'Email Retry Queue',
      'failure': 'Failure',
      'quota_exceeded': 'Quota Exceeded',
      'upstream_failure': 'Upstream Failure',
      'system_logs': 'System Logs',
      'view_portal': 'View Portal',
      'copy_link': 'Copy Link',
      'token_billing': 'Ukládat platební údaje',
      'welcome_to_invoice_ninja': 'Welcome to Invoice Ninja',
      'always': 'Vždy',
      'optin': 'Opt-In',
      'optout': 'Opt-Out',
      'label': 'Štítek',
      'client_number': 'Client Number',
      'auto_convert': 'Auto Convert',
      'company_name': 'Název firmy',
      'reminder1_sent': 'Reminder 1 Sent',
      'reminder2_sent': 'Reminder 2 Sent',
      'reminder3_sent': 'Reminder 3 Sent',
      'reminder_last_sent': 'Reminder Last Sent',
      'pdf_page_info': 'Page :current of :total',
      'emailed_invoices': 'Successfully emailed invoices',
      'emailed_quotes': 'Successfully emailed quotes',
      'emailed_credits': 'Successfully emailed credits',
      'gateway': 'Gateway',
      'view_in_stripe': 'View in Stripe',
      'rows_per_page': 'Rows Per Page',
      'hours': 'Hodiny',
      'statement': 'Statement',
      'taxes': 'Daně',
      'surcharge': 'Surcharge',
      'apply_payment': 'Apply Payment',
      'apply_credit': 'Použít kredit',
      'apply': 'Apply',
      'unapplied': 'Unapplied',
      'select_label': 'Vybrat štítek',
      'custom_labels': 'Custom Labels',
      'record_type': 'Record Type',
      'record_name': 'Record Name',
      'file_type': 'File Type',
      'height': 'Height',
      'width': 'Width',
      'to': 'Komu',
      'health_check': 'Health Check',
      'payment_type_id': 'Typ platby',
      'last_login_at': 'Last Login At',
      'company_key': 'Company Key',
      'storefront': 'Storefront',
      'storefront_help': 'Enable third-party apps to create invoices',
      'client_created': 'Client Created',
      'online_payment_email': 'Online Payment Email',
      'manual_payment_email': 'Manual Payment Email',
      'completed': 'Completed',
      'gross': 'Gross',
      'net_amount': 'Net Amount',
      'net_balance': 'Net Balance',
      'client_settings': 'Klientské nastavení',
      'selected_invoices': 'Selected Invoices',
      'selected_payments': 'Selected Payments',
      'selected_quotes': 'Selected Quotes',
      'selected_tasks': 'Vybrané úlohy',
      'selected_expenses': 'Vybrané náklady',
      'upcoming_invoices': 'Nadcházející faktury',
      'past_due_invoices': 'Past Due Invoices',
      'recent_payments': 'Poslední platby',
      'upcoming_quotes': 'Nadcházející nabídky',
      'expired_quotes': 'Prošlé nabídky',
      'create_client': 'Create Client',
      'create_invoice': 'Vytvořit fakturu',
      'create_quote': 'Vytvořit nabídku',
      'create_payment': 'Create Payment',
      'create_vendor': 'Create vendor',
      'update_quote': 'Update Quote',
      'delete_quote': 'Smazat nabídku',
      'update_invoice': 'Update Invoice',
      'delete_invoice': 'Smazat fakturu',
      'update_client': 'Update Client',
      'delete_client': 'Smazat klienta',
      'delete_payment': 'Smazat platbu',
      'update_vendor': 'Update Vendor',
      'delete_vendor': 'Smazat dodavatele',
      'create_expense': 'Vytvořit náklad',
      'update_expense': 'Aktualizovat náklad',
      'delete_expense': 'Smazat náklad',
      'create_task': 'Vytvořit úlohu',
      'update_task': 'Update Task',
      'delete_task': 'Smazat úlohu',
      'approve_quote': 'Approve Quote',
      'off': 'Off',
      'when_paid': 'When Paid',
      'expires_on': 'Expires On',
      'free': 'Zdarma',
      'plan': 'Plan',
      'show_sidebar': 'Show Sidebar',
      'hide_sidebar': 'Hide Sidebar',
      'event_type': 'Event Type',
      'target_url': 'Target',
      'copy': 'Copy',
      'must_be_online': 'Please restart the app once connected to the internet',
      'crons_not_enabled': 'The crons need to be enabled',
      'api_webhooks': 'API Webhooks',
      'search_webhooks': 'Search :count Webhooks',
      'search_webhook': 'Search 1 Webhook',
      'webhook': 'Webhook',
      'webhooks': 'Webhooks',
      'new_webhook': 'New Webhook',
      'edit_webhook': 'Edit Webhook',
      'created_webhook': 'Successfully created webhook',
      'updated_webhook': 'Successfully updated webhook',
      'archived_webhook': 'Successfully archived webhook',
      'deleted_webhook': 'Successfully deleted webhook',
      'removed_webhook': 'Webhook úspěšně odstraněn',
      'restored_webhook': 'Successfully restored webhook',
      'archived_webhooks': 'Successfully archived :value webhooks',
      'deleted_webhooks': 'Successfully deleted :value webhooks',
      'removed_webhooks': ':value webhooky úspěšně odstraněny',
      'restored_webhooks': 'Successfully restored :value webhooks',
      'api_tokens': 'API Tokeny',
      'api_docs': 'API Docs',
      'search_tokens': 'Search :count Tokens',
      'search_token': 'Search 1 Token',
      'token': 'Token',
      'tokens': 'Tokeny',
      'new_token': 'New Token',
      'edit_token': 'Editovat token',
      'created_token': 'Token úspěšně vytvořen',
      'updated_token': 'Token úspěšně změněn',
      'archived_token': 'Token úspěšně archivován',
      'deleted_token': 'Token úspěšně smazán',
      'removed_token': 'Token úspěšně odstraněn',
      'restored_token': 'Successfully restored token',
      'archived_tokens': 'Successfully archived :value tokens',
      'deleted_tokens': 'Successfully deleted :value tokens',
      'restored_tokens': 'Successfully restored :value tokens',
      'client_registration': 'Client Registration',
      'client_registration_help':
          'Enable clients to self register in the portal',
      'email_invoice': 'Poslat e-mailem',
      'email_quote': 'Odeslat nabídku e-mailem',
      'email_credit': 'Email Credit',
      'email_payment': 'Email Payment',
      'client_email_not_set': 'Client does not have an email address set',
      'ledger': 'Ledger',
      'view_pdf': 'View PDF',
      'all_records': 'All records',
      'owned_by_user': 'Owned by user',
      'credit_remaining': 'Credit Remaining',
      'contact_name': 'Jméno',
      'use_default': 'Use default',
      'reminder_endless': 'Endless Reminders',
      'number_of_days': 'Počet dní',
      'configure_payment_terms': 'Configure Payment Terms',
      'payment_term': 'Payment Term',
      'new_payment_term': 'New Payment Term',
      'edit_payment_term': 'Editovat platební podmínky',
      'created_payment_term': 'Successfully created payment term',
      'updated_payment_term': 'Successfully updated payment term',
      'archived_payment_term': 'Successfully archived payment term',
      'deleted_payment_term': 'Successfully deleted payment term',
      'removed_payment_term': 'Successfully removed payment term',
      'restored_payment_term': 'Successfully restored payment term',
      'archived_payment_terms': 'Successfully archived :value payment terms',
      'deleted_payment_terms': 'Successfully deleted :value payment terms',
      'restored_payment_terms': 'Successfully restored :value payment terms',
      'email_sign_in': 'Sign in with email',
      'change': 'Change',
      'change_to_mobile_layout': 'Change to the mobile layout?',
      'change_to_desktop_layout': 'Change to the desktop layout?',
      'send_from_gmail': 'Send from Gmail',
      'reversed': 'Reversed',
      'cancelled': 'Cancelled',
      'credit_amount': 'Počet kreditu',
      'quote_amount': 'Quote Amount',
      'hosted': 'Hosted',
      'selfhosted': 'Self-Hosted',
      'exclusive': 'Exclusive',
      'inclusive': 'Inclusive',
      'hide_menu': 'Hide Menu',
      'show_menu': 'Show Menu',
      'partially_refunded': 'Partially Refunded',
      'search_documents': 'Search Documents',
      'search_designs': 'Search Designs',
      'search_invoices': 'Hledat fakturu',
      'search_clients': 'Hledat klienty',
      'search_products': 'Hledat produkty',
      'search_quotes': 'Hledat nabídky',
      'search_credits': 'Hledat kredity',
      'search_vendors': 'Hledat dodavatele',
      'search_users': 'Hledat uživatele',
      'search_tax_rates': 'Search Tax Rates',
      'search_tasks': 'Hledat úlohy',
      'search_settings': 'Nastavení vyhledávání',
      'search_projects': 'Hledat projekt',
      'search_expenses': 'Hledat náklady',
      'search_payments': 'Search Payments',
      'search_groups': 'Search Groups',
      'search_company': 'Hledat firmu',
      'search_document': 'Search 1 Document',
      'search_design': 'Search 1 Design',
      'search_invoice': 'Hledat 1 fakturu',
      'search_client': 'Search 1 Client',
      'search_product': 'Hledat 1 produkt',
      'search_quote': 'Search 1 Quote',
      'search_credit': 'Search 1 Credit',
      'search_vendor': 'Search 1 Vendor',
      'search_user': 'Search 1 User',
      'search_tax_rate': 'Search 1 Tax Rate',
      'search_task': 'Search 1 Tasks',
      'search_project': 'Search 1 Project',
      'search_expense': 'Search 1 Expense',
      'search_payment': 'Search 1 Payment',
      'search_group': 'Search 1 Group',
      'refund_payment': 'Vrátit platbu',
      'cancelled_invoice': 'Successfully cancelled invoice',
      'cancelled_invoices': 'Successfully cancelled invoices',
      'reversed_invoice': 'Successfully reversed invoice',
      'reversed_invoices': 'Successfully reversed invoices',
      'reverse': 'Reverse',
      'full_name': 'Full Name',
      'city_state_postal': 'City/State/Postal',
      'postal_city_state': 'Postal/City/State',
      'custom1': 'First Custom',
      'custom2': 'Second Custom',
      'custom3': 'Third Custom',
      'custom4': 'Fourth Custom',
      'optional': 'Optional',
      'license': 'License',
      'purge_data': 'Purge Data',
      'purge_successful': 'Data firmy úspěšně smazána',
      'purge_data_message':
          'Warning: This will permanently erase your data, there is no undo.',
      'invoice_balance': 'Invoice Balance',
      'age_group_0': '0 - 30 Days',
      'age_group_30': '30 - 60 Days',
      'age_group_60': '60 - 90 Days',
      'age_group_90': '90 - 120 Days',
      'age_group_120': '120+ Days',
      'refresh': 'Refresh',
      'saved_design': 'Successfully saved design',
      'client_details': 'Client Details',
      'company_address': 'Adresa firmy',
      'invoice_details': 'Invoice Details',
      'quote_details': 'Quote Details',
      'credit_details': 'Credit Details',
      'product_columns': 'Product Columns',
      'task_columns': 'Task Columns',
      'add_field': 'Add Field',
      'all_events': 'All Events',
      'permissions': 'Práva',
      'none': 'None',
      'owned': 'Owned',
      'payment_success': 'Payment Success',
      'payment_failure': 'Payment Failure',
      'invoice_sent': ':count faktura odeslána',
      'quote_sent': 'Quote Sent',
      'credit_sent': 'Credit Sent',
      'invoice_viewed': 'Invoice Viewed',
      'quote_viewed': 'Quote Viewed',
      'credit_viewed': 'Credit Viewed',
      'quote_approved': 'Quote Approved',
      'receive_all_notifications': 'Receive All Notifications',
      'purchase_license': 'Purchase License',
      'apply_license': 'Apply License',
      'cancel_account': 'Smazat účet',
      'cancel_account_message':
          'Varování: Toto trvale odstraní Váš účet. Tato akce je nevratná.',
      'delete_company': 'Odstranit firmu',
      'delete_company_message':
          'Warning: This will permanently delete your company, there is no undo.',
      'enabled_modules': 'Aktivované moduly',
      'converted_quote': 'Successfully converted quote',
      'credit_design': 'Credit Design',
      'includes': 'Includes',
      'header': 'Hlavička',
      'load_design': 'Načíst design',
      'css_framework': 'CSS Framework',
      'custom_designs': 'Custom Designs',
      'designs': 'Designs',
      'new_design': 'New Design',
      'edit_design': 'Edit Design',
      'created_design': 'Successfully created design',
      'updated_design': 'Successfully updated design',
      'archived_design': 'Successfully archived design',
      'deleted_design': 'Successfully deleted design',
      'removed_design': 'Design úspěšně odstraněn',
      'restored_design': 'Successfully restored design',
      'archived_designs': 'Successfully archived :value designs',
      'deleted_designs': 'Successfully deleted :value designs',
      'restored_designs': 'Successfully restored :value designs',
      'proposals': 'Proposals',
      'tickets': 'Tickets',
      'recurring_quotes': 'Pravidelné nabídky',
      'recurring_tasks': 'Pravidelné úlohy',
      'account_management': 'Spravování účtů',
      'credit_date': 'Datum kreditu',
      'credit': 'Kredit',
      'credits': 'Kredity',
      'new_credit': 'Zadat kredit',
      'edit_credit': 'Edit Credit',
      'created_credit': 'Kredit úspěšně vytvořen',
      'updated_credit': 'Successfully updated credit',
      'archived_credit': 'Kredit úspěšně archivován',
      'deleted_credit': 'Kredit úspěšně smazán',
      'removed_credit': 'Successfully removed credit',
      'restored_credit': 'Kredit úspěšně obnoven',
      'archived_credits': ':count kreditů bylo úspěšně archivováno',
      'deleted_credits': ':count kreditů bylo úspěšně smazáno',
      'restored_credits': 'Successfully restored :value credits',
      'current_version': 'Současná verze',
      'latest_version': 'Latest Version',
      'update_now': 'Update Now',
      'a_new_version_is_available': 'A new version of the web app is available',
      'update_available': 'Update Available',
      'app_updated': 'Update successfully completed',
      'learn_more': 'Zjistit více',
      'integrations': 'Integrace',
      'tracking_id': 'Tracking Id',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': 'Credit Footer',
      'credit_terms': 'Credit Terms',
      'new_company': 'Nová firma',
      'added_company': 'Firma úspěšně přidána',
      'company1': 'Vlastní firma 1',
      'company2': 'Vlastní firma 2',
      'company3': 'Vlastní firma 3',
      'company4': 'Vlastní firma 4',
      'product1': 'Vlastní produkt 1',
      'product2': 'Vlastní produkt 2',
      'product3': 'Vlastní produkt 3',
      'product4': 'Vlastní produkt 4',
      'client1': 'Custom Client 1',
      'client2': 'Custom Client 2',
      'client3': 'Custom Client 3',
      'client4': 'Custom Client 4',
      'contact1': 'Custom Contact 1',
      'contact2': 'Custom Contact 2',
      'contact3': 'Custom Contact 3',
      'contact4': 'Custom Contact 4',
      'task1': 'Custom Task 1',
      'task2': 'Custom Task 2',
      'task3': 'Custom Task 3',
      'task4': 'Custom Task 4',
      'project1': 'Vlastní projekt 1',
      'project2': 'Vlastní projekt 2',
      'project3': 'Vlastní projekt 3',
      'project4': 'Vlastní projekt 4',
      'expense1': 'Vlastní náklad 1',
      'expense2': 'Vlastní náklad 2',
      'expense3': 'Vlastní náklad 3',
      'expense4': 'Vlastní náklad 4',
      'vendor1': 'Custom Vendor 1',
      'vendor2': 'Custom Vendor 2',
      'vendor3': 'Custom Vendor 3',
      'vendor4': 'Custom Vendor 4',
      'invoice1': 'Custom Invoice 1',
      'invoice2': 'Custom Invoice 2',
      'invoice3': 'Custom Invoice 3',
      'invoice4': 'Custom Invoice 4',
      'payment1': 'Custom Payment 1',
      'payment2': 'Custom Payment 2',
      'payment3': 'Custom Payment 3',
      'payment4': 'Custom Payment 4',
      'surcharge1': 'Custom Surcharge 1',
      'surcharge2': 'Custom Surcharge 2',
      'surcharge3': 'Custom Surcharge 3',
      'surcharge4': 'Custom Surcharge 4',
      'group1': 'Custom Group 1',
      'group2': 'Custom Group 2',
      'group3': 'Custom Group 3',
      'group4': 'Custom Group 4',
      'reset': 'Resetovat',
      'number': 'Number',
      'export': 'Export',
      'chart': 'Graf',
      'count': 'Count',
      'totals': 'Celkem',
      'blank': 'Blank',
      'day': 'Day',
      'month': 'Měsíc',
      'year': 'Year',
      'subgroup': 'Subgroup',
      'is_active': 'Is Active',
      'group_by': 'Seskupené podle',
      'credit_balance': 'Zůstatek kreditu',
      'contact_last_login': 'Contact Last Login',
      'contact_full_name': 'Contact Full Name',
      'contact_phone': 'Kontaktní tel. číslo',
      'contact_custom_value1': 'Contact Custom Value 1',
      'contact_custom_value2': 'Contact Custom Value 2',
      'contact_custom_value3': 'Contact Custom Value 3',
      'contact_custom_value4': 'Contact Custom Value 4',
      'shipping_address1': 'Doručovací ulice',
      'shipping_address2': 'Doručovací číslo patra/bytu',
      'shipping_city': 'Doručovací město',
      'shipping_state': 'Shipping State/Province',
      'shipping_postal_code': 'Shipping Postal Code',
      'shipping_country': 'Shipping Country',
      'billing_address1': 'Fakturační ulice',
      'billing_address2': 'Faktučaní číslo patra/bytu',
      'billing_city': 'Fakturační město',
      'billing_state': 'Billing State/Province',
      'billing_postal_code': 'Fakturační PSČ',
      'billing_country': 'Fakturační země',
      'client_id': 'ID klienta',
      'assigned_to': 'Assigned to',
      'created_by': 'Created by :name',
      'assigned_to_id': 'Assigned To Id',
      'created_by_id': 'Created By Id',
      'add_column': 'Add Column',
      'edit_columns': 'Edit Columns',
      'columns': 'Columns',
      'aging': 'Aging',
      'profit_and_loss': 'Profit and Loss',
      'reports': 'Reporty',
      'report': 'Report',
      'add_company': 'Přidat firmu',
      'unpaid_invoice': 'Unpaid Invoice',
      'paid_invoice': 'Paid Invoice',
      'unapproved_quote': 'Unapproved Quote',
      'help': 'Pomoc',
      'refund': 'Vrácení peněz',
      'refund_date': 'Refund Date',
      'filtered_by': 'Filtered by',
      'contact_email': 'E-mail',
      'multiselect': 'Multiselect',
      'entity_state': 'State',
      'verify_password': 'Verify Password',
      'applied': 'Applied',
      'include_recent_errors': 'Include recent errors from the logs',
      'your_message_has_been_received':
          'We have received your message and will try to respond promptly.',
      'message': 'Zpráva',
      'from': 'Od',
      'show_product_details': 'Zobrazit detaily produktu',
      'show_product_details_help':
          'Include the description and cost in the product dropdown',
      'pdf_min_requirements': 'The PDF renderer requires :version',
      'adjust_fee_percent': 'Adjust Fee Percent',
      'adjust_fee_percent_help': 'Adjust percent to account for fee',
      'configure_settings': 'Configure Settings',
      'support_forum': 'Support Forums',
      'about': 'O nás',
      'documentation': 'Dokumentace',
      'contact_us': 'Kontaktuje nás',
      'subtotal': 'Mezisoučet',
      'line_total': 'Celkem',
      'item': 'Položka',
      'credit_email': 'Credit Email',
      'iframe_url': 'iFrame URL',
      'domain_url': 'Domain URL',
      'password_is_too_short': 'Password is too short',
      'password_is_too_easy':
          'Password must contain an upper case character and a number',
      'client_portal_tasks': 'Client Portal Tasks',
      'client_portal_dashboard': 'Hlavní panel klientské zóny',
      'please_enter_a_value': 'Please enter a value',
      'deleted_logo': 'Successfully deleted logo',
      'yes': 'Ano',
      'no': 'Ne',
      'generate_number': 'Generate Number',
      'when_saved': 'When Saved',
      'when_sent': 'When Sent',
      'select_company': 'Vybrat firmu',
      'float': 'Float',
      'collapse': 'Collapse',
      'show_or_hide': 'Show/hide',
      'menu_sidebar': 'Menu Sidebar',
      'history_sidebar': 'History Sidebar',
      'tablet': 'Tablet',
      'mobile': 'Mobile',
      'desktop': 'Desktop',
      'layout': 'Layout',
      'view': 'Zobrazit',
      'module': 'Module',
      'first_custom': 'First Custom',
      'second_custom': 'Second Custom',
      'third_custom': 'Third Custom',
      'show_cost': 'Show Cost',
      'show_product_cost': 'Show Product Cost',
      'show_cost_help':
          'Display a product cost field to track the markup/profit',
      'show_product_quantity': 'Show Product Quantity',
      'show_product_quantity_help':
          'Display a product quantity field, otherwise default to one',
      'show_invoice_quantity': 'Show Invoice Quantity',
      'show_invoice_quantity_help':
          'Display a line item quantity field, otherwise default to one',
      'show_product_discount': 'Zobrazit slevu produktu',
      'show_product_discount_help': 'Display a line item discount field',
      'default_quantity': 'Default Quantity',
      'default_quantity_help':
          'Automatically set the line item quantity to one',
      'one_tax_rate': 'One Tax Rate',
      'two_tax_rates': 'Two Tax Rates',
      'three_tax_rates': 'Three Tax Rates',
      'default_tax_rate': 'Default Tax Rate',
      'user': 'Uživatel',
      'invoice_tax': 'Invoice Tax',
      'line_item_tax': 'Line Item Tax',
      'inclusive_taxes': 'Inclusive Taxes',
      'invoice_tax_rates': 'Invoice Tax Rates',
      'item_tax_rates': 'Item Tax Rates',
      'no_client_selected': 'Please select a client',
      'configure_rates': 'Configure rates',
      'configure_gateways': 'Configure Gateways',
      'tax_settings': 'Nastavení daní',
      'tax_settings_rates': 'Tax Rates',
      'accent_color': 'Akcentní barva',
      'switch': 'Switch',
      'comma_sparated_list': 'Comma separated list',
      'options': 'Options',
      'single_line_text': 'Single-line text',
      'multi_line_text': 'Multi-line text',
      'dropdown': 'Dropdown',
      'field_type': 'Field Type',
      'recover_password_email_sent': 'A password recovery email has been sent',
      'submit': 'Submit',
      'recover_password': 'Obnovit vaše heslo',
      'late_fees': 'Late Fees',
      'credit_number': 'Credit Number',
      'payment_number': 'Payment Number',
      'late_fee_amount': 'Late Fee Amount',
      'late_fee_percent': 'Late Fee Percent',
      'before_due_date': 'Before the due date',
      'after_due_date': 'After the due date',
      'after_invoice_date': 'After the invoice date',
      'days': 'Days',
      'invoice_email': 'E-mail pro fakturu',
      'payment_email': 'E-mail pro platbu',
      'partial_payment': 'Partial Payment',
      'payment_partial': 'Partial Payment',
      'partial_payment_email': 'Partial Payment Email',
      'quote_email': 'E-mail pro nabídku',
      'endless_reminder': 'Endless Reminder',
      'filtered_by_user': 'Filtered by User',
      'administrator': 'Administrátor',
      'administrator_help':
          'Povolit uživatelům spravovat další uživatele, měnit nastavení a všechny záznamy',
      'user_management': 'Správa uživatelů',
      'users': 'Uživatelé',
      'new_user': 'Nový uživatel',
      'edit_user': 'Upravit uživatele',
      'created_user': 'Successfully created user',
      'updated_user': 'Uživatel úspěšně změněn',
      'archived_user': 'Užival úspěšně archivován',
      'deleted_user': 'Uživatel úspěšně smazán',
      'removed_user': 'Uživatel úspěšně odstraněn',
      'restored_user': 'Uživatel úspěšně obnoven',
      'archived_users': 'Successfully archived :value users',
      'deleted_users': 'Successfully deleted :value users',
      'removed_users': ':value uživatelé úspěšně odstraněni',
      'restored_users': 'Successfully restored :value users',
      'general_settings': 'Obecné nastavení',
      'invoice_options': 'Možnosti faktury',
      'hide_paid_to_date': 'Skrýt Zaplaceno ke dni',
      'hide_paid_to_date_help':
          'Zobrazit na faktuře \'Zaplaceno ke dni\' pouze když přijde platba.',
      'invoice_embed_documents': 'Embed Images/Documents',
      'invoice_embed_documents_help':
          'Include attached images/pdfs in the invoice.',
      'all_pages_header': 'Zobrazit hlavičku',
      'all_pages_footer': 'Zobrazit patičku',
      'first_page': 'první stránka',
      'all_pages': 'všechny stránky',
      'last_page': 'poslední stránka',
      'primary_font': 'Primary Font',
      'secondary_font': 'Secondary Font',
      'primary_color': 'Základní barva',
      'secondary_color': 'Druhá barva',
      'page_size': 'Page Size',
      'font_size': 'Velikost fontu',
      'quote_design': 'Quote Design',
      'invoice_fields': 'Pole na faktuře',
      'product_fields': 'Product Fields',
      'invoice_terms': 'Fakturační podmínky',
      'invoice_footer': 'Patička faktury',
      'quote_terms': 'Podmínky nabídky',
      'quote_footer': 'Patička nabídky',
      'auto_email_invoice': 'Auto Email',
      'auto_email_invoice_help':
          'Automatically email recurring invoices when created.',
      'auto_archive_quote': 'Auto Archive',
      'auto_archive_quote_help':
          'Automatically archive quotes when converted to invoice.',
      'auto_convert_quote': 'Automaticky konvertovat',
      'auto_convert_quote_help':
          'Automatically convert a quote to an invoice when approved.',
      'workflow_settings': 'Workflow Settings',
      'freq_daily': 'Daily',
      'freq_weekly': 'týdně',
      'freq_two_weeks': 'Two weeks',
      'freq_four_weeks': 'Four weeks',
      'freq_monthly': 'Měsíčně',
      'freq_two_months': 'Two months',
      'freq_three_months': 'Three months',
      'freq_four_months': 'Four months',
      'freq_six_months': 'Six months',
      'freq_annually': 'Ročně',
      'freq_two_years': 'Two years',
      'freq_three_years': 'Three Years',
      'never': 'Never',
      'company': 'Firma',
      'generated_numbers': 'Generated Numbers',
      'charge_taxes': 'Použít daně',
      'next_reset': 'Next Reset',
      'reset_counter': 'Reset Counter',
      'recurring_prefix': 'Recurring Prefix',
      'number_padding': 'Number Padding',
      'general': 'General',
      'surcharge_field': 'Surcharge Field',
      'company_field': 'Company Field',
      'company_value': 'Company Value',
      'credit_field': 'Credit Field',
      'invoice_field': 'Invoice Field',
      'invoice_surcharge': 'Invoice Surcharge',
      'client_field': 'Client Field',
      'product_field': 'Pole produktu',
      'payment_field': 'Payment Field',
      'contact_field': 'Contact Field',
      'vendor_field': 'Vendor Field',
      'expense_field': 'Expense Field',
      'project_field': 'Project Field',
      'task_field': 'Task Field',
      'group_field': 'Group Field',
      'number_counter': 'Number Counter',
      'prefix': 'Prefix',
      'number_pattern': 'Number Pattern',
      'messages': 'Messages',
      'custom_css': 'Volitelné CSS',
      'custom_javascript': 'Custom JavaScript',
      'signature_on_pdf': 'Show on PDF',
      'signature_on_pdf_help':
          'Show the client signature on the invoice/quote PDF.',
      'show_accept_invoice_terms': 'Invoice Terms Checkbox',
      'show_accept_invoice_terms_help':
          'Require client to confirm that they accept the invoice terms.',
      'show_accept_quote_terms': 'Quote Terms Checkbox',
      'show_accept_quote_terms_help':
          'Require client to confirm that they accept the quote terms.',
      'require_invoice_signature': 'Invoice Signature',
      'require_invoice_signature_help':
          'Require client to provide their signature.',
      'require_quote_signature': 'Quote Signature',
      'enable_portal_password': 'Password Protect Invoices',
      'enable_portal_password_help':
          'Umožní Vám nastavit heslo pro každý kontakt. Pokud heslo nastavíte, tak kontakt ho bude pro zobrazení faktury vždy použít.',
      'authorization': 'Schválení',
      'subdomain': 'subdoména',
      'domain': 'Domain',
      'portal_mode': 'Portal Mode',
      'email_signature': 'S pozdravem,',
      'enable_email_markup_help':
          'Přidejte si mikroznačky schema.org do e-mailu a usnadněte tak vašim klientům platby.',
      'plain': 'Prostý text',
      'light': 'Světlý',
      'dark': 'Tmavý',
      'email_design': 'Vzhled e-mailu',
      'attach_pdf': 'Attach PDF',
      'attach_documents': 'Attach Documents',
      'attach_ubl': 'Attach UBL/E-Invoice',
      'email_style': 'Email Style',
      'enable_email_markup': 'Umožnit mikroznačky',
      'reply_to_email': 'Reply-To Email',
      'reply_to_name': 'Reply-To Name',
      'bcc_email': 'BCC Email',
      'processed': 'Processed',
      'credit_card': 'Credit Card',
      'bank_transfer': 'Bank Transfer',
      'priority': 'Priority',
      'fee_amount': 'Fee Amount',
      'fee_percent': 'Fee Percent',
      'fee_cap': 'Fee Cap',
      'limits_and_fees': 'Limits/Fees',
      'enable_min': 'Enable min',
      'enable_max': 'Enable max',
      'min_limit': 'Min: :min',
      'max_limit': 'Max: :max',
      'min': 'Min',
      'max': 'Max',
      'accepted_card_logos': 'Loga přijímaných karet',
      'credentials': 'Credentials',
      'update_address': 'Změnit adresu',
      'update_address_help': 'Změnit adresu klienta podle poskytnutých detailů',
      'rate': 'Sazba',
      'tax_rate': 'Daňová sazba',
      'new_tax_rate': 'Nová sazba daně',
      'edit_tax_rate': 'Editovat daňovou sazbu',
      'created_tax_rate': 'Daňová sazba úspěšně vytvořena',
      'updated_tax_rate': 'Daňová sazba úspěšně změněna',
      'archived_tax_rate': 'Daňová sazba úspěšně archivována',
      'deleted_tax_rate': 'Successfully deleted tax rate',
      'restored_tax_rate': 'Successfully restored tax rate',
      'archived_tax_rates': 'Successfully archived :value tax rates',
      'deleted_tax_rates': 'Successfully deleted :value tax rates',
      'restored_tax_rates': 'Successfully restored :value tax rates',
      'fill_products': 'Automaticky předvyplnit produkty',
      'fill_products_help': 'Výběr produktu automaticky vyplní popis a cenu',
      'update_products': 'Automaticky aktualizovat produkty',
      'update_products_help':
          'Změna na faktuře automaticky aktualizuje katalog produktů',
      'convert_products': 'Convert Products',
      'convert_products_help':
          'Automatically convert product prices to the client\'s currency',
      'fees': 'Fees',
      'limits': 'Limits',
      'provider': 'Provider',
      'company_gateway': 'Payment Gateway',
      'company_gateways': 'Payment Gateways',
      'new_company_gateway': 'New Gateway',
      'edit_company_gateway': 'Edit Gateway',
      'created_company_gateway': 'Successfully created gateway',
      'updated_company_gateway': 'Successfully updated gateway',
      'archived_company_gateway': 'Successfully archived gateway',
      'deleted_company_gateway': 'Successfully deleted gateway',
      'restored_company_gateway': 'Successfully restored gateway',
      'archived_company_gateways': 'Successfully archived :value gateways',
      'deleted_company_gateways': 'Successfully deleted :value gateways',
      'restored_company_gateways': 'Successfully restored :value gateways',
      'continue_editing': 'Continue Editing',
      'discard_changes': 'Discard Changes',
      'default_value': 'Default value',
      'disabled': 'Nepovolen',
      'currency_format': 'Currency Format',
      'first_day_of_the_week': 'První den v týdnu',
      'first_month_of_the_year': 'První měsíc v roce',
      'sunday': 'Neděle',
      'monday': 'Pondělí',
      'tuesday': 'Úterý',
      'wednesday': 'Středa',
      'thursday': 'Čtvrtek',
      'friday': 'Pátek',
      'saturday': 'Sobota',
      'january': 'Leden',
      'february': 'Únor',
      'march': 'Březen',
      'april': 'Duben',
      'may': 'Květen',
      'june': 'Červen',
      'july': 'Červenc',
      'august': 'Srpen',
      'september': 'Září',
      'october': 'Říjen',
      'november': 'Listopad',
      'december': 'Prosinec',
      'symbol': 'Symbol',
      'ocde': 'Code',
      'date_format': 'Date Format',
      'datetime_format': 'Datetime Format',
      'military_time': '24 hodinový čas',
      'military_time_help': '24 Hour Display',
      'send_reminders': 'Send Reminders',
      'timezone': 'Timezone',
      'filtered_by_project': 'Filtered by Project',
      'filtered_by_group': 'Filtered by Group',
      'filtered_by_invoice': 'Filtered by Invoice',
      'filtered_by_client': 'Filtered by Client',
      'filtered_by_vendor': 'Filtered by Vendor',
      'group_settings': 'Nastavení skupiny',
      'group': 'Group',
      'groups': 'Groups',
      'new_group': 'New Group',
      'edit_group': 'Edit Group',
      'created_group': 'Successfully created group',
      'updated_group': 'Successfully updated group',
      'archived_groups': 'Successfully archived :value groups',
      'deleted_groups': 'Successfully deleted :value groups',
      'restored_groups': 'Successfully restored :value groups',
      'archived_group': 'Successfully archived group',
      'deleted_group': 'Successfully deleted group',
      'restored_group': 'Successfully restored group',
      'upload_logo': 'Upload Your Company Logo',
      'uploaded_logo': 'Successfully uploaded logo',
      'logo': 'Logo',
      'saved_settings': 'Successfully saved settings',
      'product_settings': 'Nastavení produktu',
      'device_settings': 'Nastavení zařízení',
      'defaults': 'Výchozí',
      'basic_settings': 'Základní nastavení',
      'advanced_settings': 'Pokročilé nastavení',
      'company_details': 'Detaily firmy',
      'user_details': 'Uživatelské detaily',
      'localization': 'Lokalizace',
      'online_payments': 'Online platby',
      'tax_rates': 'Sazby daně',
      'notifications': 'Notifikace',
      'import_export': 'Import | Export',
      'custom_fields': 'Volitelná pole',
      'invoice_design': 'Vzhled faktur',
      'buy_now_buttons': 'Buy Now Buttons',
      'email_settings': 'Nastavení e-mailu',
      'templates_and_reminders': 'Šablony a připomínky',
      'credit_cards_and_banks': 'Kreditní karty a banky',
      'data_visualizations': 'Vizualizace dat',
      'price': 'Price',
      'email_sign_up': 'Email Sign Up',
      'google_sign_up': 'Google Sign Up',
      'thank_you_for_your_purchase': 'Thank you for your purchase!',
      'redeem': 'Redeem',
      'back': 'Zpět',
      'past_purchases': 'Past Purchases',
      'annual_subscription': 'Annual Subscription',
      'pro_plan': 'Pro Plan',
      'enterprise_plan': 'Enterprise Plan',
      'count_users': ':count users',
      'upgrade': 'Upgrade',
      'please_enter_a_first_name': 'Please enter a first name',
      'please_enter_a_last_name': 'Please enter a last name',
      'please_agree_to_terms_and_privacy':
          'Please agree to the terms of service and privacy policy to create an account.',
      'i_agree_to_the': 'I agree to the',
      'terms_of_service': 'Obchodní podmínky',
      'privacy_policy': 'Privacy Policy',
      'sign_up': 'Zaregistrovat se',
      'account_login': 'Přihlášení k účtu',
      'view_website': 'Navštívit web',
      'create_account': 'Create Account',
      'email_login': 'Email Login',
      'create_new': 'Create New',
      'no_record_selected': 'No record selected',
      'error_unsaved_changes': 'Please save or cancel your changes',
      'download': 'Stáhnout',
      'requires_an_enterprise_plan': 'Requires an Enterprise Plan',
      'take_picture': 'Take Picture',
      'upload_files': 'Upload Files',
      'document': 'Document',
      'documents': 'Dokumenty',
      'new_document': 'New Document',
      'edit_document': 'Edit Document',
      'uploaded_document': 'Successfully uploaded document',
      'updated_document': 'Successfully updated document',
      'archived_document': 'Successfully archived document',
      'deleted_document': 'Successfully deleted document',
      'restored_document': 'Successfully restored document',
      'archived_documents': 'Successfully archived :value documents',
      'deleted_documents': 'Successfully deleted :value documents',
      'restored_documents': 'Successfully restored :value documents',
      'no_history': 'No History',
      'expense_date': 'Datum nákladu',
      'pending': 'Nevyřízený',
      'expense_status_1': 'Logged',
      'expense_status_2': 'Pending',
      'expense_status_3': 'Invoiced',
      'converted': 'Zkonvertováno',
      'add_documents_to_invoice': 'Add Documents to Invoice',
      'exchange_rate': 'Měnový kurz',
      'convert_currency': 'Zkonvertovat měnu',
      'mark_paid': 'Mark Paid',
      'category': 'Category',
      'address': 'Adresa',
      'new_vendor': 'Nový dodavatel',
      'created_vendor': 'Dodavatel úspěšně vytvořen',
      'updated_vendor': 'Dodavatel úspěšně aktualizován',
      'archived_vendor': 'Dodavatel úspěšně archivován',
      'deleted_vendor': 'Dodavatel úspěšně smazán',
      'restored_vendor': 'Dodavatel úspěšně obnoven',
      'archived_vendors': ':count dodavatelů bylo úspěšně archivováno',
      'deleted_vendors': ':count dodavatelů bylo úspěšně smazáno',
      'restored_vendors': 'Successfully restored :value vendors',
      'new_expense': 'Zadat náklad',
      'created_expense': 'Náklad úspěšně vytvořen',
      'updated_expense': 'Náklad úspěšně změněn',
      'archived_expense': 'Náklad úspěšně archivován',
      'deleted_expense': 'Náklad úspěšně smazán',
      'restored_expense': 'Náklady úspěšně obnoveny',
      'archived_expenses': 'Náklad úspěšně archivovány',
      'deleted_expenses': 'Náklad úspěšně smazán',
      'restored_expenses': 'Successfully restored :value expenses',
      'copy_shipping': 'Copy Shipping',
      'copy_billing': 'Copy Billing',
      'design': 'Design',
      'failed_to_find_record': 'Failed to find record',
      'invoiced': 'Fakturováno',
      'logged': 'Přihlášen',
      'running': 'Bežící',
      'resume': 'Pokračovat',
      'task_errors': 'Prosím opravte překrývající se časy',
      'start': 'Začátek',
      'stop': 'Konec',
      'started_task': 'Successfully started task',
      'stopped_task': 'Úloha úspěšně zastavena',
      'resumed_task': 'Successfully resumed task',
      'now': 'Nyní',
      'auto_start_tasks': 'Auto Start Tasks',
      'timer': 'Časovač',
      'manual': 'Manuální',
      'budgeted': 'Budgeted',
      'start_time': 'Počáteční čas',
      'end_time': 'Čas konce',
      'date': 'Datum',
      'times': 'Časy',
      'duration': 'Trvání',
      'new_task': 'Nový úloha',
      'created_task': 'Úloha úspěšně vytvořena',
      'updated_task': 'Úloha úspěšně změněna',
      'archived_task': 'Úloha úspěšně archivována',
      'deleted_task': 'Úloha úspěšně smazána',
      'restored_task': 'Úloha úspěšně obnovena',
      'archived_tasks': 'Úspěšně archivováno :count úloh',
      'deleted_tasks': 'Úspěšně smazáno  :count úloh',
      'restored_tasks': 'Úspěšně obnoveno :value úloh',
      'please_enter_a_name': 'Please enter a name',
      'budgeted_hours': 'Budgeted Hours',
      'created_project': 'Projekt úspěšně vytvořen',
      'updated_project': 'Projekt úspěšně aktualizován',
      'archived_project': 'Projekt úspěšně archivován',
      'deleted_project': 'Projekt úspěšně smazán',
      'restored_project': 'Projekt úspěšně obnoven',
      'archived_projects': ':count projektů archivováno',
      'deleted_projects': ':count projektů smazáno',
      'restored_projects': 'Projekt :value obnoven',
      'new_project': 'Nový projekt',
      'thank_you_for_using_our_app': 'Thank you for using our app!',
      'if_you_like_it': 'If you like it please',
      'click_here': 'klikněte zde',
      'click_here_capital': 'Click here',
      'to_rate_it': 'to rate it.',
      'average': 'Average',
      'unapproved': 'Unapproved',
      'authenticate_to_change_setting':
          'Please authenticate to change this setting',
      'locked': 'Locked',
      'authenticate': 'Authenticate',
      'please_authenticate': 'Please authenticate',
      'biometric_authentication': 'Biometric Authentication',
      'footer': 'Patička',
      'compare': 'Compare',
      'hosted_login': 'Hosted Login',
      'selfhost_login': 'Selfhost Login',
      'google_sign_in': 'Sign in with Google',
      'today': 'Today',
      'custom_range': 'Custom Range',
      'date_range': 'Date Range',
      'current': 'Current',
      'previous': 'Previous',
      'current_period': 'Current Period',
      'comparison_period': 'Comparison Period',
      'previous_period': 'Previous Period',
      'previous_year': 'Previous Year',
      'compare_to': 'Compare to',
      'last7_days': 'Last 7 Days',
      'last_week': 'Last Week',
      'last30_days': 'Last 30 Days',
      'this_month': 'Tento měsíc',
      'last_month': 'Last Month',
      'this_year': 'This Year',
      'last_year': 'Last Year',
      'all_time': 'All Time',
      'custom': 'Volitelné',
      'clone_to_invoice': 'Clone to Invoice',
      'clone_to_quote': 'Clone to Quote',
      'clone_to_credit': 'Clone to Credit',
      'view_invoice': 'Zobrazit fakturu',
      'convert': 'Convert',
      'more': 'More',
      'edit_client': 'Editovat klienta',
      'edit_product': 'Upravit produkt',
      'edit_invoice': 'Editovat fakturu',
      'edit_quote': 'Upravit nabídku',
      'edit_payment': 'Editovat platbu',
      'edit_task': 'Editovat úlohu',
      'edit_expense': 'Upravit náklad',
      'edit_vendor': 'Editovat dodavatele',
      'edit_project': 'Upravit projekt',
      'edit_recurring_quote': 'Edit Recurring Quote',
      'billing_address': 'Fakturační adresa',
      'shipping_address': 'Doručovací adresa',
      'total_revenue': 'Celkové příjmy',
      'average_invoice': 'Průměrná faktura',
      'outstanding': 'Nezaplaceno',
      'invoices_sent': ':count faktur odesláno',
      'active_clients': 'aktivní klienti',
      'close': 'Zavřít',
      'email': 'E-mail',
      'password': 'Heslo',
      'url': 'URL',
      'secret': 'Secret',
      'name': 'Název',
      'logout': 'Odhlásit se',
      'login': 'Přihlášení',
      'filter': 'Filtr',
      'sort': 'Sort',
      'search': 'Vyhledat',
      'active': 'Aktivní',
      'archived': 'Archivováno',
      'deleted': 'Smazáno',
      'dashboard': 'Hlavní panel',
      'archive': 'Archivovat',
      'delete': 'Smazat',
      'restore': 'Obnovit',
      'refresh_complete': 'Refresh Complete',
      'please_enter_your_email': 'Prosím zadejte svůj e-mail',
      'please_enter_your_password': 'Prosím zadejte svoje heslo',
      'please_enter_your_url': 'Prosím zadejte svoji URL',
      'please_enter_a_product_key': 'Please enter a product key',
      'ascending': 'Ascending',
      'descending': 'Descending',
      'save': 'Uložit',
      'an_error_occurred': 'Došlo k chybě',
      'paid_to_date': 'Zaplaceno ke dni',
      'balance_due': 'Zbývá zaplatit',
      'balance': 'Zůstatek',
      'overview': 'Přehled',
      'details': 'Detaily',
      'phone': 'Telefon',
      'website': 'Web',
      'vat_number': 'DIČ',
      'id_number': 'IČO',
      'create': 'Vytvořit',
      'copied_to_clipboard': 'Copied :value to the clipboard',
      'error': 'Chyba',
      'could_not_launch': 'Could not launch',
      'contacts': 'Kontakty',
      'additional': 'Additional',
      'first_name': 'Jméno',
      'last_name': 'Příjmení',
      'add_contact': 'Přidat kontakt',
      'are_you_sure': 'Jste si jisti?',
      'cancel': 'Zrušit',
      'ok': 'OK',
      'remove': 'Odstranit',
      'email_is_invalid': 'E-mail je neplatný',
      'product': 'Produkt',
      'products': 'Produkty',
      'new_product': 'Nový produkt',
      'created_product': 'Produkt úspěšně vytvořen',
      'updated_product': 'Produkt úspěšně aktualizován',
      'archived_product': 'Produkt úspěšně archivován',
      'deleted_product': 'Produkt úspěšně smazán',
      'restored_product': 'Produkt úspěšně obnoven',
      'archived_products': 'Successfully archived :count products',
      'deleted_products': 'Úspěšně smazáno :count produktů',
      'restored_products': 'Successfully restored :value products',
      'product_key': 'Product',
      'notes': 'Poznámky',
      'cost': 'Cena',
      'client': 'Klient',
      'clients': 'Klienti',
      'new_client': 'Nový klient',
      'created_client': 'Klient úspěšně vytvořen',
      'updated_client': 'Klient úspěšně aktualizován',
      'archived_client': 'Klient úspěšně archivován',
      'archived_clients': ':count klientů bylo úspěšně archivováno',
      'deleted_client': 'Klient úspěšně smazán',
      'deleted_clients': ':count klientů bylo úspěšně smazáno',
      'restored_client': 'Klient úspěšně obnoven',
      'restored_clients': 'Successfully restored :value clients',
      'address1': 'Ulice',
      'address2': 'Číslo patra/bytu',
      'city': 'Město',
      'state': 'Kraj',
      'postal_code': 'PSČ',
      'country': 'Země',
      'invoice': 'Faktura',
      'invoices': 'Faktury',
      'new_invoice': 'Nová faktura',
      'created_invoice': 'Faktura úspěšně vytvořena',
      'updated_invoice': 'Faktura úspěšně aktualizována',
      'archived_invoice': 'Faktura úspěšně archivována',
      'deleted_invoice': 'Faktura úspěšně smazána',
      'restored_invoice': 'Faktura úspěšně obnovena',
      'archived_invoices': ':count faktur úspěšně archivováno',
      'deleted_invoices': ':count faktur úspěšně smazáno',
      'restored_invoices': 'Successfully restored :value invoices',
      'emailed_invoice': 'Faktura úspěšně odeslána',
      'emailed_payment': 'Successfully emailed payment',
      'amount': 'Částka',
      'invoice_number': 'Číslo faktury',
      'invoice_date': 'Datum vystavení',
      'discount': 'Sleva',
      'po_number': 'Číslo objednávky',
      'terms': 'Podmínky',
      'public_notes': 'Veřejné poznámky',
      'private_notes': 'Soukromé poznámky',
      'frequency': 'Frekvence',
      'start_date': 'Počáteční datum',
      'end_date': 'Konečné datum',
      'quote_number': 'Číslo nabídky',
      'quote_date': 'Datum nabídky',
      'valid_until': 'Platí do',
      'items': 'Položky',
      'partial_deposit': 'Partial/Deposit',
      'description': 'Popis',
      'unit_cost': 'Jedn. cena',
      'quantity': 'Množství',
      'add_item': 'Přidat položku',
      'contact': 'Kontakt',
      'work_phone': 'Telefon',
      'total_amount': 'Total Amount',
      'pdf': 'PDF',
      'due_date': 'Datum splatnosti',
      'partial_due_date': 'Partial Due Date',
      'paid_date': 'Paid Date',
      'status': 'Status',
      'invoice_status_id': 'Invoice Status',
      'quote_status': 'Quote Status',
      'click_plus_to_add_item': 'Stiskněte + pro přidání položky',
      'click_plus_to_add_time': 'Click + to add time',
      'count_selected': ':count selected',
      'total': 'Celkem',
      'percent': 'Percent',
      'edit': 'Upravit',
      'dismiss': 'Dismiss',
      'please_select_a_date': 'Prosím vyberte datum',
      'please_select_a_client': 'Please select a client',
      'please_select_an_invoice': 'Please select an invoice',
      'task_rate': 'Task Rate',
      'settings': 'Nastavení',
      'language': 'Jazyk',
      'currency': 'Currency',
      'created_at': 'Date Created',
      'created_on': 'Created On',
      'updated_at': 'Updated',
      'tax': 'DPH',
      'please_enter_an_invoice_number': 'Please enter an invoice number',
      'please_enter_a_quote_number': 'Please enter a quote number',
      'past_due': 'Past Due',
      'draft': 'Koncept',
      'sent': 'Odesláno',
      'viewed': 'Viewed',
      'approved': 'Approved',
      'partial': 'Záloha',
      'paid': 'Zaplacené',
      'mark_sent': 'Značka odesláno',
      'marked_invoice_as_sent': 'Successfully marked invoice as sent',
      'marked_invoice_as_paid': 'Successfully marked invoice as paid',
      'marked_invoices_as_sent': 'Successfully marked invoices as sent',
      'marked_invoices_as_paid': 'Successfully marked invoices as paid',
      'done': 'Dokončit',
      'please_enter_a_client_or_contact_name':
          'Please enter a client or contact name',
      'dark_mode': 'Tmavý mód',
      'restart_app_to_apply_change': 'Restart the app to apply the change',
      'refresh_data': 'Refresh Data',
      'blank_contact': 'Prázdný kontakt',
      'activity': 'Aktivita',
      'no_records_found': 'Nebyly nalezeny žádné záznamy',
      'clone': 'Duplikovat',
      'loading': 'Loading',
      'industry': 'Industry',
      'size': 'Size',
      'payment_terms': 'Platební podmínky',
      'payment_date': 'Datum platby',
      'payment_status': 'Payment Status',
      'payment_status_1': 'Pending',
      'payment_status_2': 'Voided',
      'payment_status_3': 'Failed',
      'payment_status_4': 'Completed',
      'payment_status_5': 'Partially Refunded',
      'payment_status_6': 'Refunded',
      'payment_status_-1': 'Unapplied',
      'payment_status_-2': 'Partially Unapplied',
      'net': 'Net',
      'client_portal': 'Klientský portál',
      'show_tasks': 'Zobrazit úlohy',
      'email_reminders': 'Email Reminders',
      'enabled': 'Zapnuto',
      'recipients': 'Recipients',
      'initial_email': 'Původní e-mail',
      'first_reminder': 'První připomínka',
      'second_reminder': 'Druhá připomínka',
      'third_reminder': 'Třetí připomínka',
      'reminder1': 'First Reminder',
      'reminder2': 'Second Reminder',
      'reminder3': 'Third Reminder',
      'template': 'Šablona',
      'send': 'Send',
      'subject': 'Předmět',
      'body': 'Tělo',
      'send_email': 'Odeslat e-mail',
      'email_receipt': 'Odeslat potvrzení platby klientovi',
      'auto_billing': 'Auto billing',
      'button': 'Button',
      'preview': 'Preview',
      'customize': 'Přizpůsobení',
      'history': 'Historie',
      'payment': 'Platba',
      'payments': 'Platby',
      'refunded': 'Refunded',
      'payment_type': 'Typ platby',
      'transaction_reference': 'Odkaz na transakci',
      'enter_payment': 'Zadat platbu',
      'new_payment': 'Zadat platbu',
      'created_payment': 'Platba úspěšně vytvořena',
      'updated_payment': 'Platba úspěšně změněna',
      'archived_payment': 'Platba úspěšně archivována',
      'deleted_payment': 'Platba úspěšně smazána',
      'restored_payment': 'Platba úspěšně obnovena',
      'archived_payments': ':count plateb úspěšně archivováno',
      'deleted_payments': ':count plateb bylo úspěšně smazáno',
      'restored_payments': 'Successfully restored :value payments',
      'quote': 'Nabídka',
      'quotes': 'Nabídky',
      'new_quote': 'Nová nabídka',
      'created_quote': 'Nabídka úspěšně vytvořena',
      'updated_quote': 'Nabídka úspěšně aktualizována',
      'archived_quote': 'Nabídka úspěšně archivována',
      'deleted_quote': 'Nabídka úspěšně smazána',
      'restored_quote': 'Nabídka úspěšně obnovena',
      'archived_quotes': ':count nabídek bylo úspěšně archivováno',
      'deleted_quotes': ':count nabídek bylo úspěšně smazáno',
      'restored_quotes': 'Successfully restored :value quotes',
      'expense': 'Náklad',
      'expenses': 'Náklady',
      'vendor': 'Dodavatel',
      'vendors': 'Dodavatelé',
      'task': 'Task',
      'tasks': 'Úlohy',
      'project': 'Projekt',
      'projects': 'Projekty',
      'activity_1': ':user vytvořil klienta :client',
      'activity_2': ':user archivoval klienta :client',
      'activity_3': ':user smazal klienta :client',
      'activity_4': ':user vytvořil fakturu :invoice',
      'activity_5': ':user změnil fakturu :invoice',
      'activity_6':
          ':user poslal e-mail s fakturou :invoice pro :client na :contact',
      'activity_7': 'Klient :contact zobrazil fakturu :invoice pro :client',
      'activity_8': ':user archivoval fakturu :invoice',
      'activity_9': ':user smazal fakturu :invoice',
      'activity_10':
          ':user entered payment :payment for :payment_amount on invoice :invoice for :client',
      'activity_11': ':user změnil platbu :payment',
      'activity_12': ':user archivoval platbu :payment',
      'activity_13': ':user smazal platbu :payment',
      'activity_14': ':user zadal :credit kredit',
      'activity_15': ':user změnil :credit kredit',
      'activity_16': ':user archivoval :credit kredit',
      'activity_17': ':user smazal :credit kredit',
      'activity_18': ':user vytvořil nabídku :quote',
      'activity_19': ':user změnil nabídku :quote',
      'activity_20': ':user emailed quote :quote for :client to :contact',
      'activity_21': ':contact zobrazil nabídku :quote',
      'activity_22': ':user archivoval nabídku :quote',
      'activity_23': ':user smazal nabídku :quote',
      'activity_24': ':user obnovil nabídku :quote',
      'activity_25': ':user obnovil fakturu :invoice',
      'activity_26': ':user obnovil klienta :client',
      'activity_27': ':user obnovil platbu :payment',
      'activity_28': ':user obnovil :credit kredit',
      'activity_29': ':contact approved quote :quote for :client',
      'activity_30': ':user vytvořil dodavatele :vendor',
      'activity_31': ':user archivoval dodavatele :vendor',
      'activity_32': ':user smazal dodavatele :vendor',
      'activity_33': ':user obnovil dodavatele :vendor',
      'activity_34': ':user vytvořil náklad :expense',
      'activity_35': ':user archivoval náklad :expense',
      'activity_36': ':user smazal náklad :expense',
      'activity_37': ':user obnovil náklad :expense',
      'activity_39': ':user zrušil platbu :payment v hodnotě :payment_amount',
      'activity_40':
          ':user refunded :adjustment of a :payment_amount payment :payment',
      'activity_41': ':payment_amount payment (:payment) failed',
      'activity_42': ':user vytvořil úkol :task',
      'activity_43': ':user aktualizoval úkol :task',
      'activity_44': ':user archivoval úkol :task',
      'activity_45': ':user smazal úkol :task',
      'activity_46': ':user obnovil úkol :task',
      'activity_47': ':user aktualizoval náklad :expense',
      'activity_48': ':user vytvořil uživatele :user',
      'activity_49': ':user aktualizoval uživatele :user',
      'activity_50': ':user archivoval uživatele :user',
      'activity_51': ':user smazal uživatele :user',
      'activity_52': ':user obnovil uživatele :user',
      'activity_53': ':user označil :invoice jako odeslanou',
      'activity_54': ':user zaplatil fakturu :invoice',
      'activity_55': ':contact odpověděl na tiket :ticket',
      'activity_56': ':user zobrazil tiket :ticket',
      'activity_57': 'System failed to email invoice :invoice',
      'activity_58': ':user reversed invoice :invoice',
      'activity_59': ':user cancelled invoice :invoice',
      'activity_60': ':contact viewed quote :quote',
      'activity_61': ':user updated client :client',
      'activity_62': ':user updated vendor :vendor',
      'activity_63':
          ':user emailed first reminder for invoice :invoice to :contact',
      'activity_64':
          ':user emailed second reminder for invoice :invoice to :contact',
      'activity_65':
          ':user emailed third reminder for invoice :invoice to :contact',
      'activity_66':
          ':user emailed endless reminder for invoice :invoice to :contact',
      'activity_80': ':user created subscription :subscription',
      'activity_81': ':user updated subscription :subscription',
      'activity_82': ':user archived subscription :subscription',
      'activity_83': ':user deleted subscription :subscription',
      'activity_84': ':user restored subscription :subscription',
      'one_time_password': 'One Time Password',
      'emailed_quote': 'Nabídka úspěšně odeslána',
      'emailed_credit': 'Successfully emailed credit',
      'marked_quote_as_sent': 'Successfully marked quote as sent',
      'marked_credit_as_sent': 'Successfully marked credit as sent',
      'expired': 'Expirované',
      'all': 'All',
      'select': 'Zvolit',
      'long_press_multiselect': 'Long-press Multiselect',
      'custom_value1': 'Custom Value 1',
      'custom_value2': 'Custom Value 2',
      'custom_value3': 'Custom Value 3',
      'custom_value4': 'Custom Value 4',
      'email_style_custom': 'Custom Email Style',
      'custom_message_dashboard': 'Vlastní zpráva na hlavním panelu',
      'custom_message_unpaid_invoice': 'Custom Unpaid Invoice Message',
      'custom_message_paid_invoice': 'Custom Paid Invoice Message',
      'custom_message_unapproved_quote': 'Custom Unapproved Quote Message',
      'lock_invoices': 'Lock Invoices',
      'translations': 'Translations',
      'task_number_pattern': 'Task Number Pattern',
      'task_number_counter': 'Task Number Counter',
      'expense_number_pattern': 'Expense Number Pattern',
      'expense_number_counter': 'Expense Number Counter',
      'vendor_number_pattern': 'Vendor Number Pattern',
      'vendor_number_counter': 'Vendor Number Counter',
      'ticket_number_pattern': 'Ticket Number Pattern',
      'ticket_number_counter': 'Ticket Number Counter',
      'payment_number_pattern': 'Payment Number Pattern',
      'payment_number_counter': 'Payment Number Counter',
      'invoice_number_pattern': 'Invoice Number Pattern',
      'invoice_number_counter': 'Číselná řada faktur',
      'quote_number_pattern': 'Quote Number Pattern',
      'quote_number_counter': 'Číselná řada nabídek',
      'client_number_pattern': 'Credit Number Pattern',
      'client_number_counter': 'Credit Number Counter',
      'credit_number_pattern': 'Credit Number Pattern',
      'credit_number_counter': 'Credit Number Counter',
      'reset_counter_date': 'Reset Counter Date',
      'counter_padding': 'Counter Padding',
      'shared_invoice_quote_counter': 'Share Invoice/Quote Counter',
      'default_tax_name_1': 'Default Tax Name 1',
      'default_tax_rate_1': 'Default Tax Rate 1',
      'default_tax_name_2': 'Default Tax Name 2',
      'default_tax_rate_2': 'Default Tax Rate 2',
      'default_tax_name_3': 'Default Tax Name 3',
      'default_tax_rate_3': 'Default Tax Rate 3',
      'email_subject_invoice': 'Email Invoice Subject',
      'email_subject_quote': 'Email Quote Subject',
      'email_subject_payment': 'Email Payment Subject',
      'email_subject_payment_partial': 'Email Partial Payment Subject',
      'show_table': 'Show Table',
      'show_list': 'Show List',
      'client_city': 'Client City',
      'client_state': 'Client State',
      'client_country': 'Client Country',
      'client_is_active': 'Client is Active',
      'client_balance': 'Client Balance',
      'client_address1': 'Client Street',
      'client_address2': 'Klientské číslo patra/bytu',
      'vendor_address1': 'Vendor Street',
      'vendor_address2': 'Dodavatelské číslo patra/bytu',
      'client_shipping_address1': 'Client Shipping Street',
      'client_shipping_address2': 'Klientské doručovací číslo patra/bytu',
      'type': 'Typ',
      'invoice_amount': 'Částka faktury',
      'invoice_due_date': 'Datum splatnosti',
      'tax_rate1': 'Tax Rate 1',
      'tax_rate2': 'Tax Rate 2',
      'tax_rate3': 'Tax Rate 3',
      'auto_bill': 'Automatické fakturování',
      'archived_at': 'Archived At',
      'has_expenses': 'Has Expenses',
      'custom_taxes1': 'Custom Taxes 1',
      'custom_taxes2': 'Custom Taxes 2',
      'custom_taxes3': 'Custom Taxes 3',
      'custom_taxes4': 'Custom Taxes 4',
      'custom_surcharge1': 'Custom Surcharge 1',
      'custom_surcharge2': 'Custom Surcharge 2',
      'custom_surcharge3': 'Custom Surcharge 3',
      'custom_surcharge4': 'Custom Surcharge 4',
      'is_deleted': 'Is Deleted',
      'vendor_city': 'Vendor City',
      'vendor_state': 'Vendor State',
      'vendor_country': 'Vendor Country',
      'is_approved': 'Is Approved',
      'tax_name': 'Název daně',
      'tax_amount': 'Tax Amount',
      'tax_paid': 'Tax Paid',
      'payment_amount': 'Částka k platbě',
      'age': 'Age',
      'is_running': 'Is Running',
      'time_log': 'Time Log',
      'bank_id': 'Banka',
      'expense_category_id': 'Expense Category ID',
      'expense_category': 'Expense Category',
      'invoice_currency_id': 'Invoice Currency ID',
      'tax_name1': 'Tax Name 1',
      'tax_name2': 'Tax Name 2',
      'tax_name3': 'Název daně 3',
      'transaction_id': 'Transaction ID',
      'status_color_theme': 'Status Color Theme',
      'load_color_theme': 'Load Color Theme',
    },
    'da': {
      'location': 'Placering',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Location Deleted',
      'added_location': 'Successfully added location',
      'updated_location': 'Updated Location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': 'Placeringer',
      'preference_product_notes_for_html_view': 'Use Item Notes for HTML View',
      'preference_product_notes_for_html_view_help':
          'Preference the item Description over the item title if displaying the invoice in HTML.',
      'in_stock_quantity': 'Lagermængde',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update': 'Allow clients to update their profile',
      'enable_client_profile_update_help':
          'Allow clients to update their profile information from the client portal',
      'participant': 'Deltager',
      'merged_vendors': 'Succesfuldt fusionerede leverandører',
      'activity_146':
          'E- Faktura :invoice for :client Succesfuldt leveret! :noter',
      'activity_147':
          'E- Faktura :invoice for :client mislykkedes levering. :notes',
      'activity_148': 'E- Udgift :expense modtaget fra :vendor',
      'payment_failed': 'Betaling mislykkedes',
      'activity_141': 'Bruger :user indtastet notat: :notes',
      'activity_142': 'tilbud :quote rykker 1 sendt',
      'activity_143': 'Auto Bill lykkedes for Faktura :invoice',
      'activity_144': 'Auto Bill mislykkedes for Faktura :invoice . :noter',
      'activity_145': 'E- Faktura :invoice for :client blev sendt. :noter',
      'ssl_host_override': 'SSL Host Override',
      'upload_logo_short': 'Upload logo',
      'show_pdfhtml_on_mobile_help':
          'For forbedret visualisering, viser en HTML-version af Faktura /citatet, når du ser på mobilen.',
      'accept_purchase_order': 'Accepter købsordre',
      'one_page_checkout': 'One-Page Checkout',
      'one_page_checkout_help': 'Aktiver det ny enkeltsides Betaling',
      'applies_to': 'Gælder for',
      'purchase_order_items': 'Indkøbsordrevarer',
      'assigned_group': 'Gruppe tildelt successfuldt',
      'assign_group': 'Tildel gruppe',
      'merge_to_pdf': 'Sammenflet til PDF',
      'emails': 'E-mails',
      'latest_requires_php_version':
          'Bemærk: den seneste version kræver PHP :version',
      'quote_reminder1': 'Første Tilbuds påmindelse',
      'before_valid_until': 'Før gældende indtil',
      'after_valid_until': 'Efter den gældende indtil',
      'after_quote_date': 'Efter tilbuds dato',
      'remind_quote': 'Tilbudspåmindelse',
      'task_assigned_notification': 'Opgave Tildelte Underretning',
      'task_assigned_notification_help':
          'Send en e-mail når en opgave bliver tildelt',
      'invoices_locked_end_of_month':
          'Fakturaer er låst i slutningen af måneden',
      'end_of_month': 'Sidste i måneden',
      'referral_url': 'Henvisnings-URL',
      'referral_program': 'Referral Program',
      'comment': 'Comment',
      'add_comment': 'Tilføj kommentar',
      'added_comment': 'Kommentar gemt successfuldt',
      'disconnected': 'Afbrudt',
      'reconnect': 'Genoprrettet',
      'e_invoice_settings': 'E-faktura indstillinger',
      'calculate': 'Beregn',
      'sum': 'Sum',
      'money': 'Penge',
      'time': 'Tid',
      'format': 'Format',
      'web_app': 'Web App',
      'desktop_app': 'Skrivebords App',
      'invoice_net_amount': 'Faktura netto beløb',
      'round_to_seconds': 'Runde til sekunder',
      '1_minute': '1 Minut',
      '5_minutes': '5 Minutter',
      '15_minutes': '15 Minutter',
      '30_minutes': '30 Minutter',
      '1_hour': '1 Time',
      '1_day': '1 Dag',
      'round_tasks': 'Opgave afrundingsretning',
      'round_tasks_help': 'Afrund opgave tider op eller ned.',
      'direction': 'Retning',
      'round_up': 'Afrund op',
      'round_down': 'Afrund ned',
      'task_round_to_nearest': 'Afrund til nærmeste',
      'activity_139': 'Udgift :expense meddelelse sendt til :contact',
      'activity_140': 'Kontoudtog sendt til :client',
      'bulk_updated': 'Data opdateret succesfuldt',
      'bulk_update': 'Bulk opdater',
      'advanced_cards': 'Avancerede Kort',
      'always_show_required_fields':
          'Vis altid formularen med obligatoriske felter',
      'always_show_required_fields_help':
          'Vis altid de obligatoriske formularfelter ved kassen',
      'flutter_web_warning':
          'Vi anbefaler at bruge den nye webapp eller desktop-appen for at få den bedste ydeevne',
      'rappen_rounding': 'Rappen afrunding',
      'rappen_rounding_help': 'Rund Beløb til 5 øre',
      'check_credentials': 'Tjek legitimationsoplysninger',
      'valid_credentials': 'Legitimationsoplysninger er gyldige',
      'invalid_credentials': 'These credentials do not match our records',
      'e_quote': 'E-Citat',
      'e_credit': 'E-kredit',
      'e_purchase_order': 'E-købsordre',
      'valid_vat_number': 'Gyldigt momsnummer',
      'use_available_payments': 'Brug tilgængelig Betalinger',
      'test_email_sent': 'Succesfuldt sendt e-mail',
      'send_test_email': 'Send test e-mail',
      'gateway_type': 'Gateway type',
      'please_select_an_invoice_or_credit':
          'Vælg venligst en Faktura eller kredit',
      'mobile_version': 'Mobil version',
      'venmo': 'Venmo',
      'mercado_pago': 'Mercado Pago',
      'my_bank': 'MyBank',
      'pay_later': 'Betal senere',
      'email_report': 'e-mail rapport',
      'host': 'Vært',
      'port': 'Port',
      'encryption': 'Kryptering',
      'local_domain': 'Lokalt domæne',
      'verify_peer': 'Bekræft Peer',
      'username': 'Username',
      'nordigen_help':
          'Bemærk : tilslutning af en konto kræver en GoCardless/Norden API-nøgle',
      'participant_name': 'Navn på deltager',
      'yodlee_regions': 'Regioner: USA, Storbritannien, Australien og Indien',
      'nordigen_regions': 'Regioner: Europa og Storbritannien',
      'select_provider': 'Vælg udbyder',
      'payment_type_credit': 'Betaling Type Kredit',
      'payment_type_debit': 'Betaling Type Debet',
      'send_emails_to': 'Send e-mails til',
      'primary_contact': 'Primær kontakt',
      'all_contacts': 'Alle kontakter',
      'insert_below': 'Indsæt nedenfor',
      'ar_detailed': 'Debitorer detaljeret',
      'ar_summary': 'Debitoroversigt',
      'client_sales': 'Klient',
      'tax_summary': 'Skatteoversigt',
      'user_sales': 'Bruger Salg',
      'run_template': 'Kør skabelon',
      'task_extension_banner':
          'Tilføj Chrome-udvidelsen for at administrere dine opgaver',
      'watch_video': 'Se video',
      'view_extension': 'Vis forlængelse',
      'reactivate_email': 'Genaktiver e-mail',
      'email_reactivated': 'Succesfuldt genaktiveret e-mail',
      'template_help': 'Aktiver brug af designet som skabelon',
      'delivery_note_design': 'Levering Bemærk Design',
      'statement_design': 'Statement Design',
      'payment_receipt_design': 'Betaling Kvittering Design',
      'payment_refund_design': 'Betaling Refusion Design',
      'quarter': 'Kvarter',
      'item_description': 'Varebeskrivelse',
      'task_item': 'Opgave Genstand',
      'record_state': 'Rekordtilstand',
      'last_login': 'Sidst set',
      'save_files_to_this_folder': 'Gem filer til denne mappe',
      'downloads_folder': 'Downloads mappe',
      'total_invoiced_quotes': 'Fakturerede tilbud',
      'total_invoice_paid_quotes': 'Faktura betalte tilbud',
      'downloads_folder_does_not_exist': 'Mappen downloads findes ikke :value',
      'user_logged_in_notification': 'Bruger Logget ind Notifikation',
      'user_logged_in_notification_help':
          'Send en e-mail , når du logger ind fra et nyt sted',
      'client_contact': 'Klient kontakt',
      'expense_status_4': 'Ubetalt',
      'expense_status_5': 'Betalt',
      'recurring': 'Gentagne',
      'ziptax_help':
          'Bemærk : denne funktion kræver en Zip-Tax API-nøgle for at slå amerikansk moms efter adresse',
      'cache_data': 'Cache data',
      'unknown': 'Ukendt',
      'webhook_failure': 'Webhook-fejl',
      'email_opened': 'e-mail åbnet',
      'email_delivered': 'e-mail leveret',
      'log': 'Log',
      'individual': 'Individuel',
      'partnership': 'Partnerskab',
      'trust': 'Tillid',
      'charity': 'Velgørenhed',
      'government': 'Regering',
      'classification': 'Klassifikation',
      'click_or_drop_files_here': 'Klik eller slip filer her',
      'public': 'Offentlig',
      'private': 'Privat',
      'image': 'Billede',
      'other': 'Andet',
      'hash': 'Hash',
      'linked_to': 'Knyttet til',
      'file_saved_in_path': 'Filen er blevet gemt i :sti',
      'unlinked_transactions': 'Succesfuldt ulinkede :count transaktioner',
      'unlinked_transaction': 'Succesfuldt ulinket transaktion',
      'unlink': 'Fjern sammenkædning',
      'view_dashboard_permission':
          'Tillad Bruger at få adgang til dashboardet, data er begrænset til tilgængelige tilladelser',
      'is_tax_exempt': 'Skattefritaget',
      'district': 'Distrikt',
      'region': 'Område',
      'county': 'Amt',
      'tax_details': 'Skatteoplysninger',
      'activity_10_online':
          ':contact lavet Betaling :payment for Faktura :invoice for :client',
      'activity_10_manual':
          ':user indtastet Betaling :payment for Faktura :invoice for :client',
      'default_payment_type': 'Standard Betaling',
      'admin_initiated_payments': 'Admin Påbegyndt Betalinger',
      'admin_initiated_payments_help':
          'Support til at indtaste en Betaling i adminportalen uden Faktura',
      'use_mobile_to_manage_plan':
          'Brug dit Telefon abonnement Indstillinger til at administrere din plan',
      'show_task_billable': 'Vis Opgave fakturerbar',
      'credit_item': 'Kreditting',
      'files': 'Filer',
      'camera': 'Kamera',
      'gallery': 'Galleri',
      'email_count_invoices': 'e-mail :count Fakturaer',
      'project_location': 'Projektets placering',
      'invoice_task_item_description': 'Faktura Opgave Varebeskrivelse',
      'invoice_task_item_description_help':
          'Tilføj varebeskrivelsen til Faktura linjeposterne',
      'next_send_time': 'Næste sendetid',
      'uploaded_certificate': 'Succesfuldt uploadet certifikat',
      'certificate_set': 'Certifikat sæt',
      'certificate_not_set': 'Certifikatet ikke indstillet',
      'passphrase_set': 'Adgangssætning sæt',
      'passphrase_not_set': 'Adgangssætning ikke angivet',
      'upload_certificate': 'Upload certifikat',
      'certificate_passphrase': 'Certifikatadgangssætning',
      'rename': 'Omdøb',
      'renamed_document': 'Succesfuldt omdøbt dokument',
      'e_invoice': 'E- Faktura',
      'light_dark_mode': 'Lys/Mørk tilstand',
      'activities': 'Aktiviteter',
      'routing_id': 'Routing ID',
      'enable_e_invoice': 'Aktiver E- Faktura',
      'e_invoice_type': 'E- Faktura Type',
      'e_quote_type': 'E-tilbudstype',
      'reduced_tax': 'Nedsat skat',
      'override_tax': 'Tilsidesæt skat',
      'zero_rated': 'Nul vurderet',
      'reverse_tax': 'Omvendt skat',
      'updated_tax_category': 'Succesfuldt opdateret skattekategorien',
      'updated_tax_categories': 'Succesfuldt opdateret skattekategorierne',
      'set_tax_category': 'Indstil skattekategori',
      'payment_manual': 'Betaling',
      'tax_category': 'Skattekategori',
      'physical_goods': 'Fysiske varer',
      'digital_products': 'Digitale produkter',
      'services': 'Tjenester',
      'shipping': 'Forsendelse',
      'tax_exempt': 'Skattefritaget',
      'reduced_rate': 'Reduceret sats',
      'tax_all': 'Skat alle',
      'tax_selected': 'Skat valgt',
      'version': 'version',
      'seller_subregion': 'Sælger Underregion',
      'calculate_taxes': 'Beregn skatter',
      'calculate_taxes_help': 'Beregn automatisk skat, når du gemmer Fakturaer',
      'admin': 'Admin',
      'owner': 'Owner',
      'link_expenses': 'Linkudgifter',
      'converted_client_balance': 'Konverteret Klient',
      'converted_payment_balance': 'Konverteret Betaling',
      'total_hours': 'Total timer',
      'date_picker_hint': 'Brug +dage til at indstille datoen i fremtiden',
      'browser_pdf_viewer': 'Brug Browser PDF Viewer',
      'browser_pdf_viewer_help':
          'Advarsel: Forhindrer interaktion med app over PDF',
      'increase_prices': 'Forøg priserne',
      'update_prices': 'Opdater priser',
      'incresed_prices': 'Succesfuldt køpriser skal hæves',
      'updated_prices':
          'Succesfuldt stillede priser i kø for at blive opdateret',
      'bacs': 'BACS direkte debitering',
      'api_token': 'API-token',
      'api_key': 'API nøgle',
      'endpoint': 'Slutpunkt',
      'billable': 'Fakturérbar',
      'not_billable': 'Ikke fakturerbar',
      'allow_billable_task_items': 'Tillad fakturerbare Opgave genstande',
      'allow_billable_task_items_help':
          'Aktiver konfiguration af, hvilke Opgave -varer der faktureres',
      'show_task_item_description': 'Vis Opgave varebeskrivelse',
      'show_task_item_description_help':
          'Aktiver angivelse af Opgave varebeskrivelser',
      'email_record': 'e-mail Record',
      'invoice_product_columns': 'Faktura produktkolonner',
      'quote_product_columns': 'Citat produktkolonner',
      'minimum_payment_amount': 'Minimum Betaling Beløb',
      'client_initiated_payments': 'Klient initieret Betalinger',
      'client_initiated_payments_help':
          'Støt at lave en Betaling i Klient uden Faktura',
      'share_invoice_quote_columns': 'Del Faktura /Citatkolonner',
      'cc_email': 'CC e-mail',
      'payment_balance': 'Betaling Saldo',
      'view_report_permission':
          'Tillad Bruger at få adgang til rapporterne, data er begrænset til tilgængelige tilladelser',
      'activity_138': 'Betaling :payment blev sendt til :client',
      'one_time_products': 'Engangsprodukter',
      'optional_one_time_products': 'Valgfri engangsprodukter',
      'required': 'Påkrævet',
      'hidden': 'Skjult',
      'payment_links': 'Betaling Links',
      'action': 'Handling',
      'upgrade_to_paid_plan_to_schedule':
          'Opgrader til en betalt plan til Opret planer',
      'next_run': 'Næste løb',
      'all_clients': 'Alle Klienter',
      'show_aging_table': 'Vis aldringstabel',
      'show_payments_table': 'Vis Betalinger Tabel',
      'only_clients_with_invoices': 'Kun Klienter med Fakturaer',
      'email_statement': 'E-mail Kontoudtog',
      'once': 'Enkelt gang',
      'schedule': 'Schedule',
      'schedules': 'Tidsplaner',
      'new_schedule': 'Nyt skema',
      'edit_schedule': 'Redigér Tidsplan',
      'created_schedule': 'Succesfuldt oprettet tidsplan',
      'updated_schedule': 'Succesfuldt opdateret tidsplan',
      'archived_schedule': 'Succesfuldt arkiveret tidsplan',
      'deleted_schedule': 'Succesfuldt slettet tidsplan',
      'removed_schedule': 'Succesfuldt fjernet tidsplan',
      'restored_schedule': 'Succesfuldt genskabt skema',
      'search_schedule': 'Søgeplan',
      'search_schedules': 'Søg skemaer',
      'archive_payment': 'Arkiv Betaling',
      'archive_invoice': 'Arkivér faktura',
      'archive_quote': 'Arkivér tilbud',
      'archive_credit': 'Arkiv Kredit',
      'archive_task': 'Arkiver opgave',
      'archive_client': 'Arkiv Kunde',
      'archive_project': 'Arkivér projekt',
      'archive_expense': 'Arkiver Udgift',
      'restore_payment': 'Genskab betaling',
      'restore_invoice': 'Genskab faktura',
      'restore_quote': 'Genskab tilbud',
      'restore_credit': 'Genskab kredit',
      'restore_task': 'Genskab opgave',
      'restore_client': 'Genskab kunde',
      'restore_project': 'Genskab projekt',
      'restore_expense': 'Gendan Udgift',
      'archive_vendor': 'Arkivér sælger',
      'restore_vendor': 'Genskab sælger',
      'create_product': 'Opret nyt produkt',
      'update_product': 'Opdater produkt',
      'delete_product': 'Slet produkt',
      'restore_product': 'Gendan produkt',
      'archive_product': 'Arkivér produkt',
      'create_purchase_order': 'Opret købsordre',
      'update_purchase_order': 'Opdater indkøbsordre',
      'delete_purchase_order': 'Slet Indkøbsordre',
      'restore_purchase_order': 'Genskab Indkøbsordre',
      'archive_purchase_order': 'Arkiv Indkøbsordre',
      'sent_invoice': 'Sendt Faktura',
      'sent_quote': 'Sendt tilbud',
      'sent_credit': 'Sendt kredit',
      'sent_purchase_order': 'Sendt indkøbsordre',
      'image_url': 'Billed-URL',
      'max_quantity': 'Max mængde',
      'test_url': 'Test URL',
      'auto_bill_help_off': 'Indstillingen vises ikke',
      'auto_bill_help_optin': 'Indstillingen vises, men er ikke valgt',
      'auto_bill_help_optout': 'Indstillingen vises og vælges',
      'auto_bill_help_always': 'Indstillingen vises ikke',
      'payment_methods': 'Betalingsmetoder',
      'view_all': 'Vis Alle',
      'edit_all': 'Redigér Alle',
      'accept_purchase_order_number': 'Accepter købsordrenummer',
      'accept_purchase_order_number_help':
          'Aktiver Klienter til at angive et PO-nummer, når du godkender et tilbud',
      'from_email': 'Fra e-mail',
      'show_preview': 'Vis forhåndsvisning',
      'show_paid_stamp': 'Vis betalt stempel',
      'show_shipping_address': 'Vis leveringsadresse',
      'no_documents_to_download':
          'Der er ingen dokumenter i de valgte poster at downloade',
      'pixels': 'Pixels',
      'logo_size': 'Logo størrelse',
      'postal_city': 'Postnr og by',
      'failed': 'mislykkedes',
      'client_contacts': 'Klient',
      'sync_from': 'Synkroniser fra',
      'inventory_threshold': 'Beholdningstærskel',
      'hour': 'Time',
      'emailed_statement': 'Succesfuldt sat kontoudtog i kø til afsendelse',
      'show_email_footer': 'Vis e-mail -sidefod',
      'invoice_task_hours': 'Faktura Opgave Timer',
      'invoice_task_hours_help': 'Tilføj timerne til Faktura linjeposterne',
      'auto_bill_standard_invoices': 'Auto Bill Standard Fakturaer',
      'auto_bill_recurring_invoices': 'Auto Bill Gentagen Fakturaer',
      'email_alignment': 'e-mail justering',
      'pdf_preview_location': 'PDF eksempelplacering',
      'mailgun': 'Mailgun',
      'postmark': 'Poststempel',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Klik på + for at Opret en post',
      'last365_days': 'Sidste 365 dage',
      'import_design': 'Import design',
      'imported_design': 'Succesfuldt importeret design',
      'invalid_design': 'Designet er ugyldigt, :value sektionen mangler',
      'setup_wizard_logo': 'Vil du uploade dit logo?',
      'upload': 'Upload',
      'installed_version': 'Installeret version',
      'notify_vendor_when_paid': 'Giv Sælger besked ved betaling',
      'notify_vendor_when_paid_help':
          'Send en e-mail til Sælger , når Udgift er markeret som betalt',
      'update_payment': 'Opdater Betaling',
      'markup': 'Markup',
      'purchase_order_created': 'Købsordre oprettet',
      'purchase_order_sent': 'Købsordre sendt',
      'purchase_order_viewed': 'Købsordre set',
      'purchase_order_accepted': 'Købsordre accepteret',
      'credit_payment_error':
          'Kreditten Beløb kan ikke være større end Betaling Beløb',
      'klarna': 'Klarna',
      'convert_payment_currency_help':
          'Indstil en valutakurs ved indtastning af en manuel Betaling',
      'convert_expense_currency_help':
          'Indstil en valutakurs, når du opretter en Udgift',
      'matomo_url': 'Matomo URL',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Tilføj til Faktura',
      'online_payment_email_help':
          'Send en e-mail , når en online Betaling er lavet',
      'manual_payment_email_help':
          'Send en e-mail ved manuel indtastning af en Betaling',
      'mark_paid_payment_email_help':
          'Send en e-mail , når du markerer en Faktura som betalt',
      'delete_project': 'Slet projekt',
      'linked_transaction': 'Succesfuldt forbundet transaktion',
      'link_payment': 'Link Betaling',
      'link_expense': 'Link Udgift',
      'lock_invoiced_tasks': 'Lås fakturerede opgaver',
      'lock_invoiced_tasks_help':
          'Undgå, at opgaver redigeres, når de er faktureret',
      'registration_required': 'Tilmelding påkrævet',
      'registration_required_help': 'Kræv, at Klienter registrerer sig',
      'use_inventory_management': 'Brug lagerstyring',
      'use_inventory_management_help': 'Kræv produkter på lager',
      'optional_products': 'Valgfrie produkter',
      'optional_recurring_products': 'Valgfri Gentagen -produkter',
      'convert_matched': 'Konvertere',
      'auto_billed_invoice':
          'Succesfuldt stillede Faktura i kø for at blive autofaktureret',
      'auto_billed_invoices':
          'Succesfuldt stillede Fakturaer i kø for at blive autofaktureret',
      'operator': 'Operatør',
      'value': 'Værdi',
      'is': 'Er',
      'contains': 'Indeholder',
      'starts_with': 'Starter med',
      'is_empty': 'Er tom',
      'add_rule': 'Tilføj regel',
      'match_all_rules': 'Match alle regler',
      'match_all_rules_help':
          'Alle kriterier skal matche, for at reglen kan anvendes',
      'auto_convert_help':
          'Konverter automatisk matchede transaktioner til udgifter',
      'rules': 'Regler',
      'transaction_rule': 'Transaktionsregel',
      'transaction_rules': 'Transaktionsregler',
      'new_transaction_rule': 'Ny transaktionsregel',
      'edit_transaction_rule': 'Redigér Transaktionsregel',
      'created_transaction_rule': 'Succesfuldt oprettet regel',
      'updated_transaction_rule': 'Succesfuldt opdateret transaktionsregel',
      'archived_transaction_rule': 'Succesfuldt arkiveret transaktionsregel',
      'deleted_transaction_rule': 'Succesfuldt slettet transaktionsregel',
      'removed_transaction_rule': 'Succesfuldt fjernet transaktionsregel',
      'restored_transaction_rule': 'Succesfuldt genskabt transaktionsregel',
      'search_transaction_rule': 'Søgetransaktionsregel',
      'search_transaction_rules': 'Søgetransaktionsregler',
      'save_as_default_terms': 'Gem som standardvilkår',
      'save_as_default_footer': 'Gem som standard fodnoter',
      'auto_sync': 'Automatisk synkronisering',
      'refresh_accounts': 'Opdater konti',
      'upgrade_to_connect_bank_account':
          'Opgrader til Enterprise for at tilknytte din bankkonto',
      'click_here_to_connect_bank_account':
          'Klik her for at tilknytte din bankkonto',
      'disable_2fa': 'Deaktiver 2FA',
      'change_number': 'Skift nummer',
      'resend_code': 'Gensend kode',
      'base_type': 'Base Type',
      'category_type': 'Kategori Type',
      'bank_transaction': 'Transaktion',
      'bulk_print': 'Udskriv PDF',
      'vendor_postal_code': 'Sælger Postnummer',
      'preview_location': 'Forhåndsvisning af placering',
      'bottom': 'Bund',
      'side': 'Side',
      'pdf_preview': 'PDF forhåndsvisning',
      'long_press_to_select': 'Langt tryk for at vælge',
      'purchase_order_number': 'Købsordrenummer',
      'purchase_order_item': 'Indkøbsordre vare',
      'would_you_rate_the_app': 'Vil du bedømme appen?',
      'include_deleted': 'Inkluder slettet',
      'include_deleted_help': 'Inkluder slettet i rapporter',
      'due_on': 'Forfalder',
      'converted_transactions': 'Succesfuldt konverterede transaktioner',
      'created_bank_account': 'Successfully created bank account',
      'updated_bank_account': 'Successfully updated bank account',
      'edit_bank_account': 'Edit Bank Account',
      'default_category': 'Standard kategori',
      'account_type': 'Kontotype',
      'new_bank_account': 'Tilføj bankkonto',
      'connect_accounts': 'Tilslut konti',
      'manage_rules': 'Administrer regler',
      'search_category': 'Søg 1 kategori',
      'search_categories': 'Søg i :count Kategorier',
      'min_amount': 'Min Beløb',
      'max_amount': 'Max Beløb',
      'selected': 'Valgt',
      'converted_transaction': 'Succesfuldt konverteret transaktion',
      'convert_to_payment': 'Konverter til Betaling',
      'deposit': 'Depositum',
      'withdrawal': 'Tilbagetrækning',
      'deposits': 'Indskud',
      'withdrawals': 'Udbetalinger',
      'matched': 'Matchet',
      'unmatched': 'Uovertruffen',
      'create_credit': 'Opret Kredit',
      'update_credit': 'Opdatér kredit',
      'delete_credit': 'Slet Kredit',
      'transaction': 'Transaktion',
      'transactions': 'Transaktioner',
      'new_transaction': 'Ny transaktion',
      'edit_transaction': 'Redigér Transaktion',
      'created_transaction': 'Succesfuldt oprettet transaktion',
      'updated_transaction': 'Succesfuldt opdateret transaktion',
      'archived_transaction': 'Succesfuldt arkiveret transaktion',
      'deleted_transaction': 'Succesfuldt slettet transaktion',
      'removed_transaction': 'Succesfuldt fjernet transaktion',
      'restored_transaction': 'Succesfuldt genskabt transaktion',
      'search_transaction': 'Søg transaktion',
      'search_transactions': 'Søg :count Transaktioner',
      'bank_account': 'Bankkonto',
      'bank_accounts': 'Bank Accounts',
      'archived_bank_account': 'Successfully archived bank account',
      'deleted_bank_account': 'Succesfuldt slettet bankkonto',
      'removed_bank_account': 'Succesfuldt fjernet bankkonto',
      'restored_bank_account': 'Succesfuldt genskabt bankkonto',
      'search_bank_account': 'Søg bankkonto',
      'search_bank_accounts': 'Søg på :count bankkonti',
      'connect': 'Forbinde',
      'mark_paid_payment_email': 'Mark Betalt Betaling e-mail',
      'convert_to_project': 'Konverter til projekt',
      'client_email': 'Klient e-mail',
      'invoice_task_project': 'Faktura Opgave Projekt',
      'invoice_task_project_help': 'Tilføj projektet til Faktura linjeposterne',
      'field': 'Mark',
      'period': 'Periode',
      'fields_per_row': 'Felter pr. række',
      'total_active_invoices': 'Aktiv Fakturaer',
      'total_outstanding_invoices': 'Udestående Fakturaer',
      'total_completed_payments': 'Gennemført Betalinger',
      'total_refunded_payments': 'Refunderet Betalinger',
      'total_active_quotes': 'Aktive citater',
      'total_approved_quotes': 'Godkendt Citater',
      'total_unapproved_quotes': 'Ikke-godkendte citater',
      'total_logged_tasks': 'Loggede opgaver',
      'total_invoiced_tasks': 'Fakturerede opgaver',
      'total_paid_tasks': 'Betalte opgaver',
      'total_logged_expenses': 'Loggede Udgifter',
      'total_pending_expenses': 'Afventende udgifter',
      'total_invoiced_expenses': 'Fakturerede udgifter',
      'total_invoice_paid_expenses': 'Faktura Betalte Udgifter',
      'activity_130': ':user oprettet indkøbsordre :purchase_order',
      'activity_131': ':user opdateret indkøbsordre :purchase_order',
      'activity_132': ':user arkiveret indkøbsordre :purchase_order',
      'activity_133': ':user slettet indkøbsordre :purchase_order',
      'activity_134': ':user genskabt indkøbsordre :purchase_order',
      'activity_135': ':user e-mailet indkøbsordre :purchase_order',
      'activity_136': ':contact set indkøbsordre :purchase_order',
      'activity_137': ':contact accepteret indkøbsordre :purchase_order',
      'vendor_portal': 'Sælger Portal',
      'send_code': 'Send kode',
      'save_to_upload_documents': 'Gem posten for at uploade dokumenter',
      'expense_tax_rates': 'Udgift Skattesatser',
      'invoice_item_tax_rates': 'Faktura Vareafgiftssatser',
      'verified_phone_number': 'Succesfuldt verificeret Telefon',
      'code_was_sent': 'En kode er sendt via SMS',
      'code_was_sent_to': 'En kode er sendt via SMS til :number',
      'resend': 'Send igen',
      'verify': 'Verificere',
      'enter_phone_number': 'Angiv venligst et Telefon',
      'invalid_phone_number': 'Ugyldigt Telefon',
      'verify_phone_number': 'Bekræft Telefon',
      'verify_phone_number_help':
          'Bekræft venligst dit Telefon for at sende e-mails',
      'verify_phone_number_2fa_help':
          'Bekræft venligst dit Telefon for 2FA backup',
      'merged_clients': 'Succesfuldt fusionerede Klienter',
      'merge_into': 'Flet ind i',
      'merge': 'Fusionere',
      'price_change_accepted': 'Prisændring accepteret',
      'price_change_failed': 'Prisændring mislykkedes med kode',
      'restore_purchases': 'Genskab Indkøb',
      'activate': 'Aktiver',
      'connect_apple': 'Tilslut Apple',
      'disconnect_apple': 'Afbryd Apple',
      'disconnected_apple': 'Succesfuldt afbrudt Apple',
      'send_now': 'Send nu',
      'received': 'Modtaget',
      'purchase_order_date': 'Dato for købsordre',
      'converted_to_expense': 'Succesfuldt konverteret til Udgift',
      'converted_to_expenses': 'Succesfuldt omregnet til udgifter',
      'convert_to_expense': 'Konverter til Udgift',
      'add_to_inventory': 'Tilføj til inventar',
      'added_purchase_order_to_inventory':
          'Succesfuldt tilføjede indkøbsordre til lagerbeholdningen',
      'added_purchase_orders_to_inventory':
          'Succesfuldt tilføjede indkøbsordrer til lagerbeholdningen',
      'client_document_upload': 'Klient dokument upload',
      'vendor_document_upload': 'Sælger Dokument Upload',
      'vendor_document_upload_help':
          'Gør det muligt for leverandører at uploade dokumenter',
      'are_you_enjoying_the_app': 'Nyder du appen?',
      'yes_its_great': 'Ja, det er fantastisk!',
      'not_so_much': 'Ikke så meget',
      'would_you_rate_it': 'Godt at høre! Vil du bedømme det?',
      'would_you_tell_us_more': 'Ked af at høre det! Vil du fortælle os mere?',
      'sure_happy_to': 'Selvfølgelig, glad for det',
      'no_not_now': 'Nej, ikke nu',
      'add': 'Tilføj',
      'last_sent_template': 'Sidst sendt skabelon',
      'enable_flexible_search': 'Aktiver fleksibel søgning',
      'enable_flexible_search_help':
          'Match ikke sammenhængende tegn, dvs. &quot;ct&quot; matcher &quot;kat&quot;',
      'vendor_details': 'Sælger Detaljer',
      'purchase_order_details': 'Købsordredetaljer',
      'qr_iban': 'QR IBAN',
      'besr_id': 'BESR ID',
      'accept': 'Acceptere',
      'clone_to_purchase_order': 'Klon til PO',
      'vendor_email_not_set': 'Sælger har ikke angivet en e-mail',
      'bulk_send_email': 'Send e-mail',
      'marked_purchase_order_as_sent':
          'Succesfuldt markeret indkøbsordre som sendt',
      'marked_purchase_orders_as_sent':
          'Succesfuldt markerede indkøbsordrer som afsendt',
      'accepted_purchase_order': 'Succesfuldt accepteret indkøbsordre',
      'accepted_purchase_orders': 'Succesfuldt accepterede indkøbsordrer',
      'cancelled_purchase_order': 'Succesfuldt annulleret indkøbsordre',
      'cancelled_purchase_orders': 'Succesfuldt annullerede indkøbsordrer',
      'accepted': 'Accepteret',
      'please_select_a_vendor': 'Vælg venligst en Sælger',
      'purchase_order_total': 'Købsordre Total',
      'email_purchase_order': 'e-mail Indkøbsordre',
      'bulk_email_purchase_orders': 'e-mail Indkøbsordrer',
      'disconnected_email': 'Succesfuldt afbrudt e-mail',
      'connect_email': 'Tilslut e-mail',
      'disconnect_email': 'Afbryd forbindelsen e-mail',
      'use_web_app_to_connect_microsoft':
          'Brug venligst webappen til at oprette forbindelse til Microsoft',
      'email_provider': 'e-mail udbyder',
      'connect_microsoft': 'Tilslut Microsoft',
      'disconnect_microsoft': 'Afbryd Microsoft',
      'connected_microsoft': 'Succesfuldt forbundet Microsoft',
      'disconnected_microsoft': 'Succesfuldt afbrudt Microsoft',
      'microsoft_sign_in': 'Log ind med Microsoft',
      'microsoft_sign_up': 'Tilmeld dig hos Microsoft',
      'emailed_purchase_order': 'Succesfuldt købsordre i kø skal sendes',
      'emailed_purchase_orders':
          'Succesfuldt stillede indkøbsordrer i kø, der skulle sendes',
      'enable_react_app': 'Skift til React-webappen',
      'purchase_order_design': 'Indkøbsordre design',
      'purchase_order_terms': 'Købsordre Betingelser',
      'purchase_order_footer': 'Indkøbsordre sidefod',
      'require_purchase_order_signature': 'Købsordresignatur',
      'require_purchase_order_signature_help':
          'Kræv Sælger om at give deres underskrift.',
      'purchase_order': 'Købsordre',
      'purchase_orders': 'Indkøbsordre',
      'new_purchase_order': 'Ny indkøbsordre',
      'edit_purchase_order': 'Redigér Indkøbsordre',
      'created_purchase_order': 'Succesfuldt oprettet indkøbsordre',
      'updated_purchase_order': 'Succesfuldt opdateret indkøbsordre',
      'archived_purchase_order': 'Succesfuldt arkiveret indkøbsordre',
      'deleted_purchase_order': 'Succesfuldt slettet indkøbsordre',
      'removed_purchase_order': 'Succesfuldt fjernet indkøbsordre',
      'restored_purchase_order': 'Succesfuldt genskabt indkøbsordre',
      'search_purchase_order': 'Søg indkøbsordre',
      'search_purchase_orders': 'Søg i indkøbsordrer',
      'login_url': 'Login URL',
      'payment_settings': 'Betalingsindstillinger',
      'default': 'Standard',
      'stock_quantity': 'Lagermængde',
      'notification_threshold': 'Underretningstærskel',
      'track_inventory': 'Spor inventar',
      'track_inventory_help':
          'Vis et produktlagerfelt og opdater, når Fakturaer sendes',
      'stock_notifications': 'Notifikation om lager',
      'stock_notifications_help':
          'Send en e-mail , når beholdningen når tærsklen',
      'vat': 'moms',
      'standing': 'Stående',
      'view_map': 'Vis kort',
      'set_default_design': 'Indstil standarddesign',
      'add_gateway': 'Tilføj Betalingsgateway',
      'add_gateway_help_message':
          'Tilføj en Betalingsgateway (dvs. Stripe, WePay eller PayPal) for at acceptere online Betalinger',
      'left': 'Venstre',
      'right': 'Højre',
      'center': 'Centrum',
      'page_numbering': 'Sidenummerering',
      'page_numbering_alignment': 'Sidenummereringsjustering',
      'invoice_sent_notification_label': 'Faktura Sendt',
      'show_product_description': 'Vis produktbeskrivelse',
      'show_product_description_help':
          'Inkluder beskrivelsen i produktrullemenuen',
      'invoice_items': 'Faktura varer',
      'quote_items': 'Citat varer',
      'profitloss': 'Fortjeneste og tab',
      'import_format': 'Format',
      'export_format': 'Eksporter Format',
      'export_type': 'Eksporttype',
      'stop_on_unpaid': 'Stop ved ulønnet',
      'stop_on_unpaid_help':
          'Stop med at oprette Gentagen Faktura er, hvis den sidste Faktura er ubetalt.',
      'use_quote_terms': 'Brug Citat Betingelser',
      'use_quote_terms_help': 'Ved konvertering af et tilbud til en Faktura',
      'add_country': 'Tilføj land',
      'enable_tooltips': 'Aktiver Værktøjstip',
      'enable_tooltips_help': 'Vis værktøjstip, når du holder musen over',
      'multiple_client_error': 'Fejl: Optegnelser tilhører mere end én Klient',
      'register_label': 'Opret din konto på få sekunder',
      'login_label': 'Log ind på en eksisterende konto',
      'add_to_invoice': 'Tilføj til faktura nr.: :invoice',
      'no_invoices_found': 'Ingen Fakturaer fundet',
      'week': 'Uge',
      'created_record': 'Succesfuldt oprettet record',
      'auto_archive_paid_invoices': 'Auto Arkiv Betalt',
      'auto_archive_paid_invoices_help':
          'Automatisk Arkiv Fakturaer når de er betalt.',
      'auto_archive_cancelled_invoices': 'Arkiv annulleret',
      'auto_archive_cancelled_invoices_help':
          'Automatisk Arkiv Fakturaer ved aflysning.',
      'alternate_pdf_viewer': 'Alternativ PDF fremviser',
      'alternate_pdf_viewer_help': 'Forbedre rulning over PDF eksemplet [BETA]',
      'invoice_currency': 'Faktura Valuta',
      'range': 'Interval',
      'tax_amount1': 'Skat Beløb 1',
      'tax_amount2': 'Skat Beløb 2',
      'tax_amount3': 'Skat Beløb 3',
      'create_project': 'Opret projekt',
      'update_project': 'Opdater projekt',
      'view_task': 'Vis Opgave',
      'cancel_invoice': 'Afbryd',
      'changed_status': 'Succesfuldt ændrede Opgave status',
      'change_status': 'Skift status',
      'fees_sample': 'Gebyret for en :amount Faktura ville være :total .',
      'enable_touch_events': 'Aktiver Touch Events',
      'enable_touch_events_help': 'Understøtter træk begivenheder for at rulle',
      'after_saving': 'Efter at have gemt',
      'view_record': 'Vis Rekord',
      'enable_email_markdown': 'Aktiver e-mail Markdown',
      'enable_email_markdown_help': 'Brug visuel markdown-editor til e-mails',
      'enable_pdf_markdown': 'Aktiver PDF Markdown',
      'json_help':
          'Bemærk : JSON-filer genereret af v4-appen understøttes ikke',
      'release_notes': 'Udgivelses noter',
      'upgrade_to_view_reports': 'Opgrader din plan til Vis rapporter',
      'started_tasks': 'Succesfuldt startede :value opgaver',
      'stopped_tasks': 'Succesfuldt stoppede :value opgaver',
      'approved_quote': 'Succesfuldt godkendt citat',
      'approved_quotes': 'Succesfuldt :value Godkendt citater',
      'approve': 'Godkend',
      'client_website': 'Klient hjemmeside',
      'invalid_time': 'Ugyldig tid',
      'client_shipping_state': 'Klient Shipping State',
      'client_shipping_city': 'Klient Shipping City',
      'client_shipping_postal_code': 'Klient forsendelses postnummer',
      'client_shipping_country': 'Klient forsendelsesland',
      'load_pdf': 'Indlæs PDF',
      'start_free_trial': 'Start gratis prøveperiode',
      'start_free_trial_message': 'Start din GRATIS 14 dages prove af Pro Plan',
      'due_on_receipt': 'Forfalder ved modtagelse',
      'is_paid': 'Er betalt',
      'age_group_paid': 'Betalt',
      'id': 'Id',
      'convert_to': 'Konvertere til',
      'client_currency': 'Klient valuta',
      'company_currency': 'Virksomhedens valuta',
      'purged_client': 'Kunden blev ryddet/opdateret',
      'custom_emails_disabled_help':
          'For at forhindre spam kræver vi opgradering til en betalt konto for at tilpasse e-mail',
      'upgrade_to_add_company': 'Opgrader din plan til Tilføj virksomheder',
      'small': 'Lille',
      'marked_credit_as_paid': 'Succesfuldt markerede kredit som betalt',
      'marked_credits_as_paid': 'Succesfuldt markerede kreditter som betalte',
      'wait_for_loading':
          'Dataindlæsning - vent venligst på, at det er fuldført',
      'wait_for_saving': 'Datalagring - vent venligst på, at det er fuldført',
      'html_preview_warning':
          'Bemærk : ændringer foretaget her er kun forhåndsvist, de skal anvendes i fanerne ovenfor for at blive gemt',
      'remaining': 'Tilbage',
      'invoice_paid': 'Faktura Betalt',
      'activity_120': ':user oprettet Gentagen Udgift :recurring_expense',
      'activity_121': ':user opdateret Gentagen Udgift :recurring_expense',
      'activity_122': ':user arkiveret Gentagen Udgift :recurring_expense',
      'activity_123': ':user slettet Gentagen Udgift :recurring_expense',
      'activity_124': ':user genskabt Gentagen Udgift :recurring_expense',
      'normal': 'Normal',
      'large': 'Stor',
      'extra_large': 'Ekstra stor',
      'show_pdf_preview': 'Vis PDF forhåndsvisning',
      'show_pdf_preview_help':
          'Vis PDF forhåndsvisning, mens du redigerer Fakturaer',
      'print_pdf': 'Udskriv PDF',
      'remind_me': 'Mind mig om',
      'instant_bank_pay': 'Øjeblikkelig bankbetaling',
      'click_selected': 'Klik på Valgt',
      'hide_preview': 'Skjul forhåndsvisning',
      'edit_record': 'Redigér Record',
      'credit_is_more_than_invoice':
          'Æren Beløb kan ikke være mere end Faktura Beløb',
      'giropay': 'GiroPay',
      'direct_debit': 'Direkte debitering',
      'please_set_a_password': 'Indstil venligst en kontoadgangskode',
      'set_password': 'Sæt adgangskode',
      'disconnected_gateway': 'Succesfuldt afbrudt Gateway',
      'disconnect': 'Koble fra',
      'add_to_invoices': 'Tilføj til Fakturaer',
      'acss': 'ACSS debet',
      'becs': 'BECS direkte debitering',
      'bulk_download': 'Hent',
      'persist_data_help':
          'Gem data lokalt for at gøre det muligt for appen at starte hurtigere. Deaktivering kan forbedre ydeevnen på store konti',
      'persist_ui': 'Vedvarende UI',
      'persist_ui_help':
          'Gem UI-tilstand lokalt for at aktivere appen til at starte på den sidste placering, deaktivering kan forbedre ydeevnen',
      'client_postal_code': 'Kunde Postnummer',
      'client_vat_number': 'Klient momsnummer',
      'has_tasks': 'Har opgaver',
      'registration': 'Registrering',
      'unauthorized_stripe_warning':
          'Giv venligst Stripe tilladelse til at acceptere online Betalinger .',
      'view_expense': 'View expense # :expense',
      'view_statement': 'Se Kontoudtog',
      'sepa': 'SEPA direkte debitering',
      'ideal': 'iDEAL',
      'przelewy24': 'Przelewy24',
      'eps': 'EPS',
      'fpx': 'FPX',
      'update_all_records': 'Opdater alle poster',
      'system': 'System',
      'set_default_company': 'Indstil standardfirma',
      'updated_company': 'Succesfuldt opdateret virksomhed',
      'kbc': 'KBC',
      'bancontact': 'Bancontact',
      'why_are_you_leaving':
          'Hjælp os med at blive bedre ved at fortælle os hvorfor (valgfrit)',
      'webhook_success': 'Webhook succes',
      'error_cross_client_tasks':
          'Opgaverne skal alle tilhøre den samme Klient',
      'error_cross_client_expenses': 'Udgifter skal alle tilhøre samme Klient',
      'app': 'App',
      'for_best_performance':
          'For den bedste ydeevne skal du downloade :app -appen',
      'gross_line_total': 'Brutto Linie Total',
      'bulk_email_invoices': 'e-mail Fakturaer',
      'bulk_email_quotes': 'e-mail tilbud',
      'bulk_email_credits': 'e-mail Credits',
      'from_name': 'Fra Navn',
      'clone_to_expense': 'Klon til Udgift',
      'recurring_expense': 'Gentagen Udgift',
      'recurring_expenses': 'Gentagen Udgifter',
      'new_recurring_expense': 'Ny Gentagen Udgift',
      'edit_recurring_expense': 'Redigér Gentagen Udgift',
      'created_recurring_expense': 'Succesfuldt oprettet Gentagen Udgift',
      'updated_recurring_expense': 'Succesfuldt opdateret Gentagen Udgift',
      'archived_recurring_expense': 'Succesfuldt arkiveret Gentagen Udgift',
      'deleted_recurring_expense': 'Succesfuldt slettet Gentagen Udgift',
      'removed_recurring_expense': 'Succesfuldt fjernet Gentagen Udgift',
      'restored_recurring_expense': 'Succesfuldt genskabt Gentagen Udgift',
      'search_recurring_expense': 'Søg Gentagen Udgift',
      'search_recurring_expenses': 'Søg Gentagen Udgifter',
      'last_sent_date': 'Sidste afsendelsesdato',
      'include_drafts': 'Inkluder udkast',
      'include_drafts_help': 'Medtag udkast til poster i rapporter',
      'is_invoiced': 'Er faktureret',
      'change_plan': 'Administrer plan',
      'persist_data': 'Vedvarende data',
      'customer_count': 'Kundeantal',
      'verify_customers': 'Bekræft kunder',
      'google_analytics': 'Google Analytics',
      'google_analytics_tracking_id': 'Google Analytics sporings-id',
      'decimal_comma': 'Decimalkomma',
      'use_comma_as_decimal_place': 'Brug komma som decimal i formularer',
      'select_method': 'Vælg metode',
      'select_platform': 'Vælg Platform',
      'use_web_app_to_connect_gmail':
          'Brug webappen til at oprette forbindelse til Gmail',
      'expense_tax_help': 'Vareafgiftssatser er deaktiveret',
      'enable_markdown': 'Aktiver Markdown',
      'enable_markdown_help': 'Konverter markdown til HTML på PDF',
      'user_guide': 'Brugerguide',
      'add_second_contact': 'Tilføj anden kontakt',
      'previous_page': 'Forrige side',
      'next_page': 'Næste side',
      'export_colors': 'Eksporter farver',
      'import_colors': 'Importer farver',
      'clear_all': 'Slet alt',
      'contrast': 'Kontrast',
      'custom_colors': 'Speciel farver',
      'colors': 'Farver',
      'sidebar_active_background_color': 'Sidebar aktiv baggrundsfarve',
      'sidebar_active_font_color': 'Sidebar aktiv skrifttypefarve',
      'sidebar_inactive_background_color': 'Sidebjælke inaktiv baggrundsfarve',
      'sidebar_inactive_font_color': 'Sidebjælke inaktiv skrifttypefarve',
      'table_alternate_row_background_color':
          'Tabel Alternativ Række baggrundsfarve',
      'invoice_header_background_color': 'Faktura Header Baggrundsfarve',
      'invoice_header_font_color': 'Faktura Header Font Farve',
      'net_subtotal': 'Net',
      'review_app': 'Gennemgå app',
      'check_status': 'Tjek Status',
      'free_trial': 'Gratis prøveversion',
      'free_trial_ends_in_days':
          'Prøveversionen af Pro-planen slutter om :count dage, klik for at opgradere.',
      'free_trial_ends_today':
          'I dag er den sidste dag af prøveversionen af Pro-planen, klik for at opgradere.',
      'change_email': 'Skift e-mail',
      'client_portal_domain_hint':
          'Konfigurer eventuelt et separat Klient portaldomæne',
      'tasks_shown_in_portal': 'Opgaver vist i portalen',
      'uninvoiced': 'Ufaktureret',
      'subdomain_guide':
          'Underdomænet bruges i Klient portalen til at tilpasse links, så de matcher dit brand. dvs. https://dit-mærke. Fakturering .co',
      'send_time': 'Send tid',
      'import_data': 'Import Data',
      'import_settings': 'Import Indstillinger',
      'json_file_missing': 'Angiv venligst JSON-filen',
      'json_option_missing':
          'Vælg venligst at importere Indstillinger og/eller data',
      'json': 'JSON',
      'no_payment_types_enabled': 'Ingen Betaling aktiveret',
      'wait_for_data': 'Vent venligst på, at dataene er færdige med at indlæse',
      'net_total': 'Netto Total',
      'has_taxes': 'Har Skatter',
      'import_customers': 'Importer kunder',
      'imported_customers': 'Succesfuldt begyndte at importere kunder',
      'login_success': 'Vellykket login',
      'login_failure': 'Mislykket login',
      'exported_data':
          'Når filen er klar, modtager du en e-mail med et downloadlink',
      'include_deleted_clients': 'Inkluder slettet Klienter',
      'include_deleted_clients_help':
          'Indlæs poster tilhørende slettet Klienter',
      'step_1_sign_in': 'Trin 1: Log ind',
      'step_2_authorize': 'Trin 2: Godkend',
      'account_id': 'Konto-id',
      'migration_not_yet_completed': 'Migreringen er endnu ikke afsluttet',
      'activity_100': ':user oprettet Gentagen Faktura :recurring_invoice',
      'activity_101': ':user opdateret Gentagen Faktura :recurring_invoice',
      'activity_102': ':user arkiveret Gentagen Faktura :recurring_invoice',
      'activity_103': ':user slettet Gentagen Faktura :recurring_invoice',
      'activity_104': ':user genskabt Gentagen Faktura :recurring_invoice',
      'show_task_end_date': 'Vis Opgave Slutdato',
      'show_task_end_date_help': 'Aktiver angivelse af Opgave slutdatoen',
      'gateway_setup': 'Gateway opsætning',
      'preview_sidebar': 'Forhåndsvisning af sidebjælke',
      'years_data_shown': 'Årsdata vist',
      'ended_all_sessions': 'Succesfuldt afsluttede alle sessioner',
      'end_all_sessions': 'Afslut alle sessioner',
      'count_session': '1 session',
      'count_sessions': ':count Sessioner',
      'invoice_created': 'Faktura oprettet',
      'quote_created': 'Citat oprettet',
      'credit_created': 'Kredit oprettet',
      'pro': 'Pro',
      'enterprise': 'Enterprise',
      'last_updated': 'Senest opdateret',
      'invoice_item': 'Faktura vare',
      'quote_item': 'Citat vare',
      'contact_first_name': 'kontakt Fornavn',
      'contact_last_name': 'kontakt Efternavn',
      'order': 'Bestille',
      'unassigned': 'Ikke tilknyttet',
      'partial_value': 'Skal være større end nul og mindre end totalen',
      'search_kanban': 'Søg efter Kanban',
      'search_kanbans': 'Søg efter Kanban',
      'kanban': 'Kanban',
      'enable': 'Aktivér',
      'move_top': 'Flyt Top',
      'move_up': 'Flyt op',
      'move_down': 'Flyt ned',
      'move_bottom': 'Flyt bund',
      'subdomain_help':
          'Angiv subdomænet eller vis fakturaen på din egen hjemmeside.',
      'body_variable_missing':
          'Fejl: Speciel e-mail skal indeholde en :body variabel',
      'add_body_variable_message': 'Sørg for at inkludere en :body -variabel',
      'view_date_formats': 'Vis datoformater',
      'is_viewed': 'Er set',
      'letter': 'Brev',
      'legal': 'gyldige',
      'page_layout': 'Sidelayout',
      'portrait': 'Portræt',
      'landscape': 'Landskab',
      'owner_upgrade_to_paid_plan':
          'Kontoejeren kan opgradere til en betalt plan for at aktivere de avancerede avancerede Indstillinger',
      'upgrade_to_paid_plan':
          'Opgrader til en betalt plan for at aktivere de avancerede Indstillinger',
      'invoice_payment_terms': 'Faktura Betaling Betingelser',
      'quote_valid_until': 'Tilbud Gælder til',
      'no_headers': 'Ingen overskrifter',
      'add_header': 'Tilføj Header',
      'remove_header': 'Fjern overskrift',
      'return_url': 'Returner URL',
      'rest_method': 'REST metode',
      'header_key': 'Hovednøgle',
      'header_value': 'Overskriftsværdi',
      'recurring_products': 'Gentagen produkter',
      'promo_code': 'Tilbudskode',
      'promo_discount': 'Kampagne rabat',
      'allow_cancellation': 'Tillad annullering',
      'per_seat_enabled': 'Per sæde aktiveret',
      'max_seats_limit': 'Max sædergrænse',
      'trial_enabled': 'Prøveversion aktiveret',
      'trial_duration': 'Prøvens varighed',
      'allow_query_overrides': 'Tillad tilsidesættelse af forespørgsler',
      'allow_plan_changes': 'Tillad planændringer',
      'plan_map': 'Plankort',
      'refund_period': 'Tilbagebetalingsperiode',
      'webhook_configuration': 'Webhook-konfiguration',
      'purchase_page': 'Købsside',
      'security': 'Sikkerhed',
      'email_bounced': 'e-mail Bounced',
      'email_spam_complaint': 'Spam klage',
      'email_delivery': 'e-mail levering',
      'webhook_response': 'Webhook-svar',
      'pdf_response': 'PDF svar',
      'authentication_failure': 'Godkendelsesfejl',
      'pdf_failed': 'PDF mislykkedes',
      'pdf_success': 'PDF succes',
      'modified': 'Ændret',
      'payment_link': 'Betaling Link',
      'new_payment_link': 'Nyt Betaling',
      'edit_payment_link': 'Redigér Betaling Link',
      'created_payment_link': 'Succesfuldt oprettet Betaling link',
      'updated_payment_link': 'Succesfuldt opdateret Betaling link',
      'archived_payment_link': 'Succesfuldt arkiveret Betaling link',
      'deleted_payment_link': 'Succesfuldt slettet Betaling link',
      'removed_payment_link': 'Succesfuldt fjernet Betaling',
      'restored_payment_link': 'Succesfuldt genskabt Betaling link',
      'search_payment_link': 'Søg 1 Betaling Link',
      'search_payment_links': 'Søg :count Betaling Links',
      'subdomain_is_not_available': 'Underdomæne er ikke tilgængeligt',
      'connect_gmail': 'Tilslut Gmail',
      'disconnect_gmail': 'Afbryd forbindelsen til Gmail',
      'connected_gmail': 'Succesfuldt forbundet Gmail',
      'disconnected_gmail': 'Succesfuldt afbrudt Gmail',
      'update_fail_help':
          'Ændringer i kodebasen blokerer muligvis for opdateringen. Du kan køre denne kommando for at kassere ændringerne:',
      'client_id_number': 'Kunde ID-nr.',
      'count_minutes': ':count Minutter',
      'password_timeout': 'Adgangskode timeout',
      'shared_invoice_credit_counter': 'Del Faktura /Kredittæller',
      'use_last_email': 'Brug sidste e-mail',
      'activate_company': 'Aktiver virksomheden',
      'activate_company_help':
          'Aktiver e-mails, Gentagen Fakturaer og meddelelser',
      'an_error_occurred_try_again': 'Der opstod en fejl, prøv venligst igen',
      'please_first_set_a_password': 'Indstil venligst først en adgangskode',
      'changing_phone_disables_two_factor':
          'Advarsel: Ændring af dit Telefon vil deaktivere 2FA',
      'help_translate': 'Hjælp til at oversætte',
      'please_select_a_country': 'Vælg venligst et land',
      'resend_invite': 'Send invitation igen',
      'disabled_two_factor': 'Succesfuldt deaktiveret 2FA',
      'connected_google': 'Succesfuldt forbundet konto',
      'disconnected_google': 'Succesfuldt afbrudt konto',
      'delivered': 'Leveret',
      'bounced': 'Bounced',
      'spam': 'Spam',
      'view_docs': 'Vis Docs',
      'enter_phone_to_enable_two_factor':
          'Angiv venligst et Telefon for at aktivere tofaktorautentificering',
      'send_sms': 'Send SMS',
      'sms_code': 'SMS kode',
      'two_factor_setup_help': 'Scan stregkoden med en :link kompatibel app.',
      'enabled_two_factor': 'Succesfuldt aktiveret to-faktor-godkendelse',
      'connect_google': 'Tilslut Google',
      'disconnect_google': 'Afbryd forbindelsen til Google',
      'enable_two_factor': 'To-faktor-godkendelse',
      'disable_two_factor': 'Deaktiver tofaktor',
      'require_password_with_social_login':
          'Kræv adgangskode med socialt login',
      'stay_logged_in': 'Forbliv logget ind',
      'session_about_to_expire': 'Advarsel: Din session er ved at udløbe',
      'count_hours': ':count Timer',
      'count_day': '1 dag',
      'count_days': ':count dage',
      'web_session_timeout': 'Websession timeout',
      'security_settings': 'Indstillinger',
      'resend_email': 'Send e-mail igen',
      'confirm_your_email_address': 'Bekræft venligst din e-mail',
      'refunded_payment': 'Refunderet betaling',
      'partially_unapplied': 'Delvist ikke anvendt',
      'select_a_gmail_user':
          'Vælg venligst en Bruger , der er godkendt med Gmail',
      'list_long_press': 'Liste Langt tryk',
      'show_actions': 'Vis handlinger',
      'start_multiselect': 'Start Multiselect',
      'email_sent_to_confirm_email':
          'Der er sendt en e-mail for at bekræfte e-mail',
      'counter_pattern_error':
          'For at bruge :client _counter skal du Tilføj enten :client _number eller :client _id_number for at forhindre konflikter',
      'this_quarter': 'Dette Kvartal',
      'last_quarter': 'Forrige kvartal',
      'to_update_run': 'Kør for at opdatere',
      'convert_to_invoice': 'Konvertér til en faktura',
      'registration_url': 'Registrerings-URL',
      'invoice_project': 'Fakturér projekt',
      'invoice_task': 'Fakturer opgave',
      'invoice_expense': 'Fakturer Udgift',
      'search_payment_term': 'Søg 1 Betaling Term',
      'search_payment_terms': 'Søg :count Betaling Betingelser',
      'save_and_preview': 'Gem og Preview',
      'save_and_email': 'Gem og e-mail',
      'supported_events': 'Understøttede begivenheder',
      'converted_amount': 'Ombygget Beløb',
      'converted_balance': 'Konverteret saldo',
      'converted_paid_to_date': 'Konverteret betalt til dato',
      'converted_credit_balance': 'Konverteret kreditsaldo',
      'converted_total': 'Omregnet Total',
      'is_sent': 'Er sendt',
      'default_documents': 'Standarddokumenter',
      'document_upload': 'Dokument upload',
      'document_upload_help':
          'Tillad Kunder at upload\'e dokumenter/vedhæftede filer',
      'expense_total': 'Udgift total',
      'enter_taxes': 'Indtast Skatter',
      'by_rate': 'Efter sats',
      'by_amount': 'Ved Beløb',
      'enter_amount': 'Indtast Beløb',
      'before_taxes': 'Før skat',
      'after_taxes': 'Efter skat',
      'color': 'Farve',
      'show': 'At vise',
      'hide': 'Skjul',
      'empty_columns': 'Tomme kolonner',
      'debug_mode_is_enabled': 'Debug-tilstand er aktiveret',
      'debug_mode_is_enabled_help':
          'Advarsel: det er beregnet til brug på lokale maskiner, det kan lække legitimationsoplysninger. Klik for at lære mere.',
      'running_tasks': 'Løbende opgaver',
      'recent_tasks': 'Seneste opgaver',
      'recent_expenses': 'Seneste udgifter',
      'upcoming_expenses': 'Kommende Udgifter',
      'update_app': 'Opdater app',
      'started_import': 'Succesfuldt startet import',
      'duplicate_column_mapping': 'Dubleret kolonnetilknytning',
      'uses_inclusive_taxes': 'Bruger inklusive skatter',
      'is_amount_discount': 'Er Beløb Rabat',
      'column': 'Kolonne',
      'sample': 'Eksempel',
      'map_to': 'Kort til',
      'import': 'Importér',
      'first_row_as_column_names': 'Brug første række som kolonnenavne',
      'select_file': 'Venligst vælg en fil',
      'no_file_selected': 'Ingen fil valgt',
      'csv_file': 'Vælg CSV-fil',
      'csv': 'CSV',
      'freshbooks': 'Friske bøger',
      'invoice2go': 'Invoice2go',
      'invoicely': 'Faktura',
      'waveaccounting': 'Wave regnskab',
      'zoho': 'Zoho',
      'accounting': 'Regnskab',
      'required_files_missing': 'Angiv alle CSV&#39;er.',
      'import_type': 'Importtype',
      'html_mode': 'HTML-tilstand',
      'html_mode_help':
          'Forhåndsvisning opdateres hurtigere, men er mindre nøjagtig',
      'view_licenses': 'Vis licenser',
      'webhook_url': 'Webhook URL',
      'fullscreen_editor': 'Fuldskærms-editor',
      'sidebar_editor': 'Sidebar Editor',
      'please_type_to_confirm':
          'Indtast venligst &quot; :value &quot; for at bekræfte',
      'purge': 'Udrensning',
      'service': 'Service',
      'clone_to': 'Klon Til',
      'clone_to_other': 'Klon til Andet',
      'labels': 'Etiketter',
      'add_custom': 'Tilføj Speciel',
      'payment_tax': 'Betaling Skat',
      'unpaid': 'Ikke betalt',
      'white_label': 'Hvidmærke',
      'delivery_note': 'Levering Bemærk',
      'sent_invoices_are_locked': 'Sendte Fakturaer er låst',
      'paid_invoices_are_locked': 'Betalte Fakturaer er låst',
      'source_code': 'Kildekode',
      'app_platforms': 'App-platforme',
      'invoice_late': 'Faktura Sen',
      'quote_expired': 'Citat udløbet',
      'partial_due': 'Partial Due',
      'invoice_total': 'Faktura total',
      'quote_total': 'Tilbud total',
      'credit_total': 'Kredit Total',
      'recurring_invoice_total': 'Faktura total',
      'actions': 'Handlinger',
      'expense_number': 'Udgift',
      'task_number': 'Opgave nummer',
      'project_number': 'Projektnummer',
      'project_name': 'Projekt navn',
      'warning': 'Advarsel',
      'view_settings': 'Vis Indstillinger',
      'company_disabled_warning':
          'Advarsel: dette firma er endnu ikke blevet aktiveret',
      'late_invoice': 'Sen Faktura',
      'expired_quote': 'Udløbet citat',
      'remind_invoice': 'Mind Faktura',
      'cvv': 'Kontrolcifre',
      'client_name': 'Kundenavn',
      'client_phone': 'Kunde Telefon',
      'required_fields': 'krævede felter',
      'calculated_rate': 'Beregnet rate',
      'default_task_rate': 'Standard Opgave Rate',
      'clear_cache': 'Ryd cache',
      'sort_order': 'Sorteringsrækkefølge',
      'task_status': 'Status',
      'task_statuses': 'Opgave Statusser',
      'new_task_status': 'Ny Opgave Status',
      'edit_task_status': 'Redigér Opgave Status',
      'created_task_status': 'Succesfuldt oprettet Opgave status',
      'updated_task_status': 'Succesfuldt opdatere Opgave status',
      'archived_task_status': 'Succesfuldt arkiveret Opgave status',
      'deleted_task_status': 'Succesfuldt slettet Opgave status',
      'removed_task_status': 'Succesfuldt fjernet Opgave status',
      'restored_task_status': 'Succesfuldt genskabt Opgave status',
      'archived_task_statuses': 'Succesfuldt arkiveret :value Opgave statusser',
      'deleted_task_statuses': 'Succesfuldt slettet :value Opgave statusser',
      'restored_task_statuses': 'Succesfuldt genskabt :value Opgave statusser',
      'search_task_status': 'Søg 1 Opgave Status',
      'search_task_statuses': 'Søg :count Opgave Statuss',
      'show_tasks_table': 'Vis opgavetabellen',
      'show_tasks_table_help':
          'Vis altid opgaveafsnittet, når du opretter Fakturaer',
      'invoice_task_timelog': 'Faktura Opgave Timelog',
      'invoice_task_timelog_help':
          'Tilføj tidsdetaljer til Faktura linjeposterne',
      'invoice_task_datelog': 'Faktura Opgave Datelog',
      'invoice_task_datelog_help':
          'Tilføj datodetaljer til Faktura linjeposterne',
      'auto_start_tasks_help': 'Start opgaver før du gemmer',
      'configure_statuses': 'Konfigurer statusser',
      'task_settings': 'Opgave Indstillinger',
      'configure_categories': 'Konfigurer kategorier',
      'expense_categories': 'Udgiftskategorier',
      'new_expense_category': 'Ny udgiftskategori',
      'edit_expense_category': 'Redigér Udgift Kategori',
      'created_expense_category': 'Udgiftskategori oprettet',
      'updated_expense_category': 'Ajourført udgiftskategori',
      'archived_expense_category': 'Udgiftskategori arkiveret',
      'deleted_expense_category': 'Sletning af kategori er gennemført',
      'removed_expense_category': 'Succesfuldt fjernet Udgift kategori',
      'restored_expense_category': 'Udgiftskategori genoprettet',
      'archived_expense_categories': '.count udgiftskategori(er) arkiveret',
      'deleted_expense_categories':
          'Succesfuldt slettet Udgift :value kategorier',
      'restored_expense_categories':
          'Succesfuldt genskabt Udgift :value kategorier',
      'search_expense_category': 'Søg 1 Udgift Kategori',
      'search_expense_categories': 'Søg :count Udgift Kategorier',
      'use_available_credits': 'Brug tilgængelige kreditter',
      'show_option': 'Vis indstilling',
      'negative_payment_error':
          'Kreditten Beløb kan ikke overstige Betaling Beløb',
      'view_changes': 'Vis ændringer',
      'force_update': 'Gennemtving opdatering',
      'force_update_help':
          'Du kører den seneste version, men der kan være afventende rettelser tilgængelige.',
      'mark_paid_help': 'Spor Udgift er betalt',
      'should_be_invoiced': 'Should be invoiced',
      'should_be_invoiced_help': 'Aktiver Udgift til at blive faktureret',
      'add_documents_to_invoice_help': 'Gør dokumenterne synlige for Kunden',
      'convert_currency_help': 'Indstil en valutakurs',
      'expense_settings': 'Udgift Indstillinger',
      'clone_to_recurring': 'Klon til Gentagen',
      'crypto': 'Krypto',
      'paypal': 'Paypal',
      'alipay': 'Alipay',
      'sofort': 'Sofort',
      'apple_pay': 'Apple/Google Pay',
      'user_field': 'Bruger Field',
      'variables': 'Variabler',
      'show_password': 'Vis adgangskode',
      'hide_password': 'Skjul adgangskode',
      'copy_error': 'Kopieringsfejl',
      'capture_card': 'Capture kort',
      'auto_bill_enabled': 'Automatisk fakturering aktiveret',
      'total_taxes': 'Total skatter',
      'line_taxes': 'Line Skatter',
      'total_fields': 'Felter Total',
      'stopped_recurring_invoice': 'Succesfuldt stoppede Gentagen Faktura',
      'started_recurring_invoice': 'Succesfuldt startede Gentagen Faktura',
      'resumed_recurring_invoice': 'Succesfuldt genoptog Gentagen Faktura',
      'gateway_refund': 'Gateway refusion',
      'gateway_refund_help': 'Behandle tilbagebetalingen med Betalingsgateway',
      'due_date_days': 'Afleveringsdato',
      'paused': 'Pause',
      'mark_active': 'Markér som aktiv',
      'day_count': 'Dag :count',
      'first_day_of_the_month': 'Første dag i måneden',
      'last_day_of_the_month': 'Sidste dag i måneden',
      'use_payment_terms': 'Brug Betaling Betingelser',
      'endless': 'Endeløs',
      'next_send_date': 'Næste afsendelsesdato',
      'remaining_cycles': 'Resterende cyklusser',
      'recurring_invoice': 'Gentaget faktura',
      'recurring_invoices': 'Gentagende fakturaer',
      'new_recurring_invoice': 'Ny gentaget fakture',
      'edit_recurring_invoice': 'Redigér Gentagen Faktura',
      'created_recurring_invoice': 'Succesfuldt oprettet Gentagen Faktura',
      'updated_recurring_invoice': 'Succesfuldt opdateret Gentagen Faktura',
      'archived_recurring_invoice': 'Successfully archived recurring invoice',
      'deleted_recurring_invoice': 'Successfully deleted recurring invoice',
      'removed_recurring_invoice': 'Succesfuldt fjernet Gentagen Faktura',
      'restored_recurring_invoice': 'Successfully restored recurring invoice',
      'archived_recurring_invoices':
          'Succesfuldt arkiveret Gentagen :value Fakturaer',
      'deleted_recurring_invoices':
          'Succesfuldt slettet Gentagen :value Fakturaer',
      'restored_recurring_invoices':
          'Succesfuldt genskabt Gentagen :value Fakturaer',
      'search_recurring_invoice': 'Søg 1 Gentagen Faktura',
      'search_recurring_invoices': 'Søg :count Gentagen Fakturaer',
      'send_date': 'Send dato',
      'auto_bill_on': 'Auto Bill On',
      'minimum_under_payment_amount': 'Minimum Under Betaling Beløb',
      'profit': 'Fortjeneste',
      'line_item': 'Linjepost',
      'allow_over_payment': 'Tillad overbetaling',
      'allow_over_payment_help':
          'Support, der betaler ekstra for at modtage drikkepenge',
      'allow_under_payment': 'Tillad underbetaling',
      'allow_under_payment_help':
          'Støtte betaling af minimum del-/depositum Beløb',
      'test_mode': 'Test mode',
      'opened': 'Åbnet',
      'payment_reconciliation_failure': 'Forsoningsfejl',
      'payment_reconciliation_success': 'Forsoningssucces',
      'gateway_success': 'Gateway succes',
      'gateway_failure': 'Gateway -fejl',
      'gateway_error': 'Gateway fejl',
      'email_send': 'e-mail Send',
      'email_retry_queue': 'e-mail Genforsøgskø',
      'failure': 'Fiasko',
      'quota_exceeded': 'Kvote overskredet',
      'upstream_failure': 'Upstream fiasko',
      'system_logs': 'Systemlogs',
      'view_portal': 'Se Portal',
      'copy_link': 'Kopier link',
      'token_billing': 'Gem kort detaljer',
      'welcome_to_invoice_ninja': 'Velkommen til Faktura Ninja',
      'always': 'Altid',
      'optin': 'Tilmeld',
      'optout': 'Opt-out',
      'label': 'Etiket',
      'client_number': 'Kundenr.',
      'auto_convert': 'Autokonvertering',
      'company_name': 'Firma navn',
      'reminder1_sent': 'Påmindelse 1 Sendt',
      'reminder2_sent': 'Påmindelse 2 Sendt',
      'reminder3_sent': 'Påmindelse 3 Sendt',
      'reminder_last_sent': 'Påmindelse sidst sendt',
      'pdf_page_info': 'Side :current af :total',
      'emailed_invoices': 'Succesfuldt mailede Fakturaer',
      'emailed_quotes': 'Succesfuldt mailede citater',
      'emailed_credits': 'Succesfuldt e-mailede kreditter',
      'gateway': 'Gateway',
      'view_in_stripe': 'Vis i Stripe',
      'rows_per_page': 'Rækker pr. side',
      'hours': 'Timer',
      'statement': 'Kontoudtog',
      'taxes': 'Skatter',
      'surcharge': 'Ekstragebyr',
      'apply_payment': 'Ansøg Betaling',
      'apply_credit': 'Apply Credit',
      'apply': 'ansøge',
      'unapplied': 'Ikke anvendt',
      'select_label': 'Vælg Label',
      'custom_labels': 'Speciel etiketter',
      'record_type': 'Record Type',
      'record_name': 'Optegnelsesnavn',
      'file_type': 'Filtype',
      'height': 'Højde',
      'width': 'Bredde',
      'to': 'Til',
      'health_check': 'Sundhedstjek',
      'payment_type_id': 'Betalingsmetode',
      'last_login_at': 'Sidste login kl',
      'company_key': 'Firmanøgle',
      'storefront': 'Butiksfacade',
      'storefront_help': 'Aktiver tredjepartsapps til Opret Fakturaer',
      'client_created': 'Klient oprettet',
      'online_payment_email': 'Online Betaling e-mail',
      'manual_payment_email': 'Manuel Betaling e-mail',
      'completed': 'Afsluttet',
      'gross': 'Brutto',
      'net_amount': 'Net Beløb',
      'net_balance': 'Nettobalance',
      'client_settings': 'Indstillinger Kundeoplysninger',
      'selected_invoices': 'Udvalgte Fakturaer',
      'selected_payments': 'Valgte Betalinger',
      'selected_quotes': 'Udvalgte citater',
      'selected_tasks': 'Udvalgte opgaver',
      'selected_expenses': 'Udvalgte Udgifter',
      'upcoming_invoices': 'Kommende Fakturaer',
      'past_due_invoices': 'Forfaldne fakturaer',
      'recent_payments': 'Seneste betalinger',
      'upcoming_quotes': 'Upcoming Quotes',
      'expired_quotes': 'Expired Quotes',
      'create_client': 'Opret Kunde',
      'create_invoice': 'Opret faktura',
      'create_quote': 'Opret tilbud',
      'create_payment': 'Opret Betaling',
      'create_vendor': 'Opret Sælger',
      'update_quote': 'Opdater citat',
      'delete_quote': 'Slet tilbud',
      'update_invoice': 'Opdater Faktura',
      'delete_invoice': 'Slet faktura',
      'update_client': 'Opdatér Kundeoplysninger',
      'delete_client': 'Slet Kunde',
      'delete_payment': 'Slet Betaling',
      'update_vendor': 'Opdater Sælger',
      'delete_vendor': 'Slet sælger',
      'create_expense': 'Opret Udgift',
      'update_expense': 'Opdater Udgift',
      'delete_expense': 'Slet Udgift',
      'create_task': 'Opret opgave',
      'update_task': 'Opdater Opgave',
      'delete_task': 'Slet opgave',
      'approve_quote': 'Godkend citat',
      'off': 'Deaktiver',
      'when_paid': 'Når betalt',
      'expires_on': 'Udløber på',
      'free': 'Free',
      'plan': 'Plan',
      'show_sidebar': 'Vis sidebjælke',
      'hide_sidebar': 'Skjul sidebjælke',
      'event_type': 'Begivenhedstype',
      'target_url': 'Mål',
      'copy': 'Kopi',
      'must_be_online':
          'Genstart appen, når du har forbindelse til internettet',
      'crons_not_enabled': 'Crons skal aktiveres',
      'api_webhooks': 'API Webhooks',
      'search_webhooks': 'Søg efter :count Webhooks',
      'search_webhook': 'Søg 1 Webhook',
      'webhook': 'Webhook',
      'webhooks': 'Webhooks',
      'new_webhook': 'Ny Webhook',
      'edit_webhook': 'Redigér Webhook',
      'created_webhook': 'Succesfuldt oprettet webhook',
      'updated_webhook': 'Succesfuldt opdateret webhook',
      'archived_webhook': 'Succesfuldt arkiveret webhook',
      'deleted_webhook': 'Succesfuldt slettet webhook',
      'removed_webhook': 'Succesfuldt fjernet webhook',
      'restored_webhook': 'Succesfuldt genskabt webhook',
      'archived_webhooks': 'Succesfuldt arkiveret :value webhooks',
      'deleted_webhooks': 'Succesfuldt slettet :value webhooks',
      'removed_webhooks': 'Succesfuldt fjernet :value webhooks',
      'restored_webhooks': 'Succesfuldt genskabt :value webhooks',
      'api_tokens': 'API Token\'s',
      'api_docs': 'API-dokumenter',
      'search_tokens': 'Søg :count Tokens',
      'search_token': 'Søg efter 1 token',
      'token': 'Token',
      'tokens': 'Token\'s',
      'new_token': 'Ny token',
      'edit_token': 'Redigér token',
      'created_token': 'Token oprettet',
      'updated_token': 'Token opdateret',
      'archived_token': 'Successfully archived token',
      'deleted_token': 'Token slettet',
      'removed_token': 'Succesfuldt fjernet token',
      'restored_token': 'Succesfuldt genskabt token',
      'archived_tokens': 'Succesfuldt arkiveret :value tokens',
      'deleted_tokens': 'Succesfuldt slettet :value tokens',
      'restored_tokens': 'Succesfuldt genskabt :value tokens',
      'client_registration': 'Kunde Oprettelse',
      'client_registration_help':
          'Giv Kunder adgang til at oprette sig i Kundeportalen',
      'email_invoice': 'e-mail faktura',
      'email_quote': 'E-mail tilbuddet',
      'email_credit': 'e-mail Kredit',
      'email_payment': 'e-mail Betaling',
      'client_email_not_set': 'Kunden har ikke angivet en e-mail',
      'ledger': 'Hovedbog',
      'view_pdf': 'Vis PDF',
      'all_records': 'Alle optegnelser',
      'owned_by_user': 'Ejes af Bruger',
      'credit_remaining': 'Tilbageværende kredit',
      'contact_name': 'Kontakt navn',
      'use_default': 'Brug standard',
      'reminder_endless': 'Uendelige påmindelser',
      'number_of_days': 'Antal dage',
      'configure_payment_terms': 'Konfigurer Betaling Betingelser',
      'payment_term': 'Betaling Term',
      'new_payment_term': 'Ny Betaling',
      'edit_payment_term': 'Edit Payment Term',
      'created_payment_term': 'Succesfuldt oprettet Betaling term',
      'updated_payment_term': 'Succesfuldt opdateret Betaling',
      'archived_payment_term': 'Succesfuldt arkiveret Betaling termin',
      'deleted_payment_term': 'Succesfuldt slettet Betaling termin',
      'removed_payment_term': 'Succesfuldt fjernet Betaling',
      'restored_payment_term': 'Succesfuldt genskabt Betaling termin',
      'archived_payment_terms':
          'Succesfuldt arkiveret :value Betaling Betingelser',
      'deleted_payment_terms':
          'Succesfuldt slettet :value Betaling Betingelser',
      'restored_payment_terms':
          'Succesfuldt genskabt :value Betaling Betingelser',
      'email_sign_in': 'Log ind med e-mail',
      'change': 'Lave om',
      'change_to_mobile_layout': 'Skift til mobillayoutet?',
      'change_to_desktop_layout': 'Skift til skrivebordslayout?',
      'send_from_gmail': 'Send fra Gmail',
      'reversed': 'Omvendt',
      'cancelled': 'Aflyst',
      'credit_amount': 'Kreditbeløb',
      'quote_amount': 'Citat Beløb',
      'hosted': 'Hostet',
      'selfhosted': 'Selvvært',
      'exclusive': 'Eksklusiv',
      'inclusive': 'Inklusiv',
      'hide_menu': 'Skjul menu',
      'show_menu': 'Vis menu',
      'partially_refunded': 'Delvist refunderet',
      'search_documents': 'Søg i dokumenter',
      'search_designs': 'Søg designs',
      'search_invoices': 'Søg Fakturaer',
      'search_clients': 'Søg efter Kunder',
      'search_products': 'Søg efter produkter',
      'search_quotes': 'Søg citater',
      'search_credits': 'Søg Credits',
      'search_vendors': 'Søg efter leverandører',
      'search_users': 'Søg efter brugere',
      'search_tax_rates': 'Søg efter skattesatser',
      'search_tasks': 'Søgeopgaver',
      'search_settings': 'Søg Indstillinger',
      'search_projects': 'Søg projekter',
      'search_expenses': 'Søgeudgifter',
      'search_payments': 'Søg Betalinger',
      'search_groups': 'Søg i grupper',
      'search_company': 'Søg efter firma',
      'search_document': 'Søg i 1 dokument',
      'search_design': 'Søg 1 Design',
      'search_invoice': 'Søg 1 Faktura',
      'search_client': 'Søg 1 Kunde',
      'search_product': 'Søg 1 produkt',
      'search_quote': 'Søg 1 citat',
      'search_credit': 'Søg 1 kredit',
      'search_vendor': 'Søg 1 Sælger',
      'search_user': 'Søg efter 1 Bruger',
      'search_tax_rate': 'Søg 1 Skattesats',
      'search_task': 'Søg 1 Opgaver',
      'search_project': 'Søg 1 projekt',
      'search_expense': 'Søg 1 Udgift',
      'search_payment': 'Søg 1 Betaling',
      'search_group': 'Søg 1 gruppe',
      'refund_payment': 'Refunder betaling',
      'cancelled_invoice': 'Succesfuldt aflyst Faktura',
      'cancelled_invoices': 'Succesfuldt aflyst Fakturaer',
      'reversed_invoice': 'Succesfuldt vendt Faktura',
      'reversed_invoices': 'Succesfuldt omvendt Fakturaer',
      'reverse': 'Baglæns',
      'full_name': 'Fulde navn',
      'city_state_postal': 'By/Postnummer',
      'postal_city_state': 'Postnummer/By/Region',
      'custom1': 'Første Speciel',
      'custom2': 'Andet Speciel',
      'custom3': 'Tredje Speciel',
      'custom4': 'Fjerde Speciel',
      'optional': 'Valgfri',
      'license': 'Licens',
      'purge_data': 'Rens data',
      'purge_successful': 'Succesfuldt rensede virksomhedsdata',
      'purge_data_message':
          'Advarsel: Dette vil slette dine data permanent, der er ingen måder at fortryde.',
      'invoice_balance': 'Faktura Balance',
      'age_group_0': '0 - 30 dage',
      'age_group_30': '30 - 60 dage',
      'age_group_60': '60 - 90 dage',
      'age_group_90': '90 - 120 dage',
      'age_group_120': '120+ dage',
      'refresh': 'Opdater',
      'saved_design': 'Succesfuldt gemt design',
      'client_details': 'Kundeoplysninger',
      'company_address': 'Virksomhedens adresse',
      'invoice_details': 'Fakturadetaljer',
      'quote_details': 'Citat detaljer',
      'credit_details': 'Kreditoplysninger',
      'product_columns': 'Produktkolonner',
      'task_columns': 'Opgave',
      'add_field': 'Tilføj felt',
      'all_events': 'Alle begivenheder',
      'permissions': 'Permissions',
      'none': 'Ingen',
      'owned': 'Ejet',
      'payment_success': 'Betaling succes',
      'payment_failure': 'Betaling',
      'invoice_sent': ':count fakturaer sendt',
      'quote_sent': 'Citat sendt',
      'credit_sent': 'Kredit sendt',
      'invoice_viewed': 'Faktura set',
      'quote_viewed': 'Citat set',
      'credit_viewed': 'Kredit set',
      'quote_approved': 'Citat Godkendt',
      'receive_all_notifications': 'Modtag alle meddelelser',
      'purchase_license': 'Køb Licens',
      'apply_license': 'Anvend licens',
      'cancel_account': 'Annuller konto',
      'cancel_account_message':
          'ADVARSEL: Dette vil permanent slette din konto, der er INGEN mulighed for at fortryde.',
      'delete_company': 'Slet Selskab',
      'delete_company_message':
          'Advarsel: Dette vil permanent Slet din virksomhed, der er ingen fortrydelse.',
      'enabled_modules': 'Aktiverede moduler',
      'converted_quote': 'Succesfuldt konverteret citat',
      'credit_design': 'Kreditdesign',
      'includes': 'Inkluderer',
      'header': 'Hoved',
      'load_design': 'Indlæs design',
      'css_framework': 'CSS Framework',
      'custom_designs': 'Speciel designs',
      'designs': 'Designs',
      'new_design': 'Nyt design',
      'edit_design': 'Redigér Design',
      'created_design': 'Succesfuldt oprettet design',
      'updated_design': 'Succesfuldt opdateret design',
      'archived_design': 'Succesfuldt arkiveret design',
      'deleted_design': 'Succesfuldt slettet design',
      'removed_design': 'Succesfuldt fjernet design',
      'restored_design': 'Succesfuldt genskabt design',
      'archived_designs': 'Succesfuldt arkiveret :value designs',
      'deleted_designs': 'Succesfuldt slettet :value designs',
      'restored_designs': 'Succesfuldt genskabt :value designs',
      'proposals': 'Projektforslag',
      'tickets': 'Tickets',
      'recurring_quotes': 'Gentagen Tilbud',
      'recurring_tasks': 'Gentagen opgaver',
      'account_management': 'Account Management',
      'credit_date': 'Kreditdato',
      'credit': 'Kredit',
      'credits': 'Kreditter',
      'new_credit': 'Indtast kredit',
      'edit_credit': 'Redigér kredit',
      'created_credit': 'Kredit oprettet',
      'updated_credit': 'Opdatering af kredit gennemført',
      'archived_credit': 'Kredit arkiveret',
      'deleted_credit': 'Kredit slettet',
      'removed_credit': 'Succesfuldt fjernet kredit',
      'restored_credit': 'Kredit genskabt',
      'archived_credits': 'Arkiverede :count kreditter',
      'deleted_credits': 'Slettede :count kreditter',
      'restored_credits': 'Succesfuldt genskabt :value credits',
      'current_version': 'Nuværende version',
      'latest_version': 'Nyeste version',
      'update_now': 'Opdatere nu',
      'a_new_version_is_available': 'En ny version af webappen er tilgængelig',
      'update_available': 'Opdatering tilgængelig',
      'app_updated': 'Opdatering Succesfuldt gennemført',
      'learn_more': 'Få flere oplysninger',
      'integrations': 'Integrationer',
      'tracking_id': 'Sporings-id',
      'slack_webhook_url': 'Slack Webhook URL',
      'credit_footer': 'Kreditsidefod',
      'credit_terms': 'Kredit Betingelser',
      'new_company': 'Nyt firma',
      'added_company': 'Succesfuldt tilføjet firma',
      'company1': 'Speciel 1',
      'company2': 'Speciel 2',
      'company3': 'Speciel 3',
      'company4': 'Speciel 4',
      'product1': 'Speciel produkt 1',
      'product2': 'Speciel produkt 2',
      'product3': 'Speciel produkt 3',
      'product4': 'Speciel produkt 4',
      'client1': 'Speciel Kunde 1',
      'client2': 'Speciel Kunde 2',
      'client3': 'Speciel Kunde 3',
      'client4': 'Speciel Kunde 4',
      'contact1': 'Speciel kontakt 1',
      'contact2': 'Speciel kontakt 2',
      'contact3': 'Speciel kontakt 3',
      'contact4': 'Speciel kontakt 4',
      'task1': 'Speciel Opgave 1',
      'task2': 'Speciel Opgave 2',
      'task3': 'Speciel Opgave 3',
      'task4': 'Speciel Opgave 4',
      'project1': 'Speciel 1',
      'project2': 'Speciel 2',
      'project3': 'Speciel 3',
      'project4': 'Speciel 4',
      'expense1': 'Speciel Udgift 1',
      'expense2': 'Speciel Udgift 2',
      'expense3': 'Speciel Udgift 3',
      'expense4': 'Speciel Udgift 4',
      'vendor1': 'Speciel Sælger 1',
      'vendor2': 'Speciel Sælger 2',
      'vendor3': 'Speciel Sælger 3',
      'vendor4': 'Speciel Sælger 4',
      'invoice1': 'Speciel Faktura 1',
      'invoice2': 'Speciel Faktura 2',
      'invoice3': 'Speciel Faktura 3',
      'invoice4': 'Speciel Faktura 4',
      'payment1': 'Speciel Betaling 1',
      'payment2': 'Speciel Betaling 2',
      'payment3': 'Speciel Betaling 3',
      'payment4': 'Speciel Betaling 4',
      'surcharge1': 'Speciel 1',
      'surcharge2': 'Speciel 2',
      'surcharge3': 'Speciel 3',
      'surcharge4': 'Speciel 4',
      'group1': 'Speciel 1',
      'group2': 'Speciel 2',
      'group3': 'Speciel 3',
      'group4': 'Speciel 4',
      'reset': 'Reset',
      'number': 'Nummer',
      'export': 'Eksport',
      'chart': 'Diagram',
      'count': 'Tælle',
      'totals': 'Totaler',
      'blank': 'Blank',
      'day': 'Dag',
      'month': 'Måned',
      'year': 'År',
      'subgroup': 'Undergruppe',
      'is_active': 'er aktiv',
      'group_by': 'Gruppér efter',
      'credit_balance': 'Kreditsaldo',
      'contact_last_login': 'kontakt Sidste login',
      'contact_full_name': 'kontakt fulde navn',
      'contact_phone': 'Kontakttelefon',
      'contact_custom_value1': 'kontakt Speciel 1',
      'contact_custom_value2': 'kontakt Speciel Value 2',
      'contact_custom_value3': 'kontakt Speciel Value 3',
      'contact_custom_value4': 'kontakt Speciel Value 4',
      'shipping_address1': 'Skibsgade',
      'shipping_address2': 'Forsendelseslejlighed/Suite',
      'shipping_city': 'Forsendelsesby',
      'shipping_state': 'Forsendelsesstat/provins',
      'shipping_postal_code': 'Forsendelses postnummer',
      'shipping_country': 'Forsendelsesland',
      'billing_address1': 'Billing Street',
      'billing_address2': 'Billing Apt/Suite',
      'billing_city': 'Billing City',
      'billing_state': 'Faktureringsstat/provins',
      'billing_postal_code': 'Faktureringspostnummer',
      'billing_country': 'Faktureringsland',
      'client_id': 'Kunde ID',
      'assigned_to': 'Tildelt',
      'created_by': 'Oprettet af :navn',
      'assigned_to_id': 'Tildelt til id',
      'created_by_id': 'oprettet Af Id',
      'add_column': 'Tilføj kolonne',
      'edit_columns': 'Redigér kolonner',
      'columns': 'Kolonner',
      'aging': 'Aldring',
      'profit_and_loss': 'Fortjeneste og tab',
      'reports': 'Rapporter',
      'report': 'Rapport',
      'add_company': 'Tilføj firma',
      'unpaid_invoice': 'Ubetalte Faktura',
      'paid_invoice': 'Betalt Faktura',
      'unapproved_quote': 'Ikke godkendt citat',
      'help': 'Hjælp',
      'refund': 'Refunder',
      'refund_date': 'Refusionsdato',
      'filtered_by': 'Filtreret efter',
      'contact_email': 'E-mailkontakt',
      'multiselect': 'Multiselect',
      'entity_state': 'Status',
      'verify_password': 'Bekræft adgangskode',
      'applied': 'Anvendt',
      'include_recent_errors': 'Medtag seneste fejl fra logs',
      'your_message_has_been_received':
          'Vi har modtaget din Besked og vil forsøge at svare hurtigt.',
      'message': 'Besked',
      'from': 'Fra',
      'show_product_details': 'Vis produktdetaljer',
      'show_product_details_help':
          'Inkluder beskrivelse og pris i produktrullemenuen',
      'pdf_min_requirements': 'PDF rendereren kræver :version',
      'adjust_fee_percent': 'Juster gebyrprocent',
      'adjust_fee_percent_help': 'Juster procent for at tage højde for gebyr',
      'configure_settings': 'Konfigurer Indstillinger',
      'support_forum': 'Supportfora',
      'about': 'Om',
      'documentation': 'Dokumentation',
      'contact_us': 'Kontakt os',
      'subtotal': 'Subtotal',
      'line_total': 'Sum',
      'item': 'Produkttype',
      'credit_email': 'Kredit e-mail',
      'iframe_url': 'iFrame URL',
      'domain_url': 'Domæne-URL',
      'password_is_too_short': 'Adgangskoden er for kort',
      'password_is_too_easy':
          'Adgangskoden skal indeholde et stort bogstav og et tal',
      'client_portal_tasks': 'Kundeportalen Opgaver',
      'client_portal_dashboard': 'Kundeportalen Dashboard',
      'please_enter_a_value': 'Indtast venligst en værdi',
      'deleted_logo': 'Succesfuldt slettet logo',
      'yes': 'Yes',
      'no': 'No',
      'generate_number': 'Generer nummer',
      'when_saved': 'Når gemt',
      'when_sent': 'Ved afsendelse',
      'select_company': 'Vælg Firma',
      'float': 'Flyde',
      'collapse': 'Bryder sammen',
      'show_or_hide': 'Vis/skjul',
      'menu_sidebar': 'Sidebjælke i menuen',
      'history_sidebar': 'Historie sidebjælke',
      'tablet': 'Tablet',
      'mobile': 'Mobil',
      'desktop': 'Desktop',
      'layout': 'Layout',
      'view': 'View',
      'module': 'modul',
      'first_custom': 'Første Speciel',
      'second_custom': 'Andet Speciel',
      'third_custom': 'Tredje Speciel',
      'show_cost': 'Vis pris',
      'show_product_cost': 'Vis produktomkostninger',
      'show_cost_help':
          'Vis et produktprisfelt for at spore opmærkningen/fortjenesten',
      'show_product_quantity': 'Vis produktmængde',
      'show_product_quantity_help':
          'Vis et felt for produktantal, ellers er der et som standard',
      'show_invoice_quantity': 'Vis Faktura Antal',
      'show_invoice_quantity_help':
          'Vis et linjepostantal felt, ellers standard til ét',
      'show_product_discount': 'Vis produktrabat',
      'show_product_discount_help': 'Vis et linjevarerabatfelt',
      'default_quantity': 'Standardmængde',
      'default_quantity_help': 'Indstil automatisk linjepostantallet til én',
      'one_tax_rate': 'Én skattesats',
      'two_tax_rates': 'To skattesatser',
      'three_tax_rates': 'Tre skattesatser',
      'default_tax_rate': 'Standard afgiftssats',
      'user': 'User',
      'invoice_tax': 'Faktura Skat',
      'line_item_tax': 'Linjepostafgift',
      'inclusive_taxes': 'Inklusiv skatter',
      'invoice_tax_rates': 'Faktura Skattesatser',
      'item_tax_rates': 'Vareafgiftssatser',
      'no_client_selected': 'Vælg venligst en kunde',
      'configure_rates': 'Konfigurer satser',
      'configure_gateways': 'Konfigurer gateways',
      'tax_settings': 'Tax Settings',
      'tax_settings_rates': 'Skattesatser',
      'accent_color': 'Accent farve',
      'switch': 'Skift',
      'comma_sparated_list': 'Kommasepareret liste',
      'options': 'Muligheder',
      'single_line_text': 'Enkeltlinjetekst',
      'multi_line_text': 'Tekst med flere linjer',
      'dropdown': 'Dropdown',
      'field_type': 'Felttype',
      'recover_password_email_sent':
          'En e-mail til gendannelse af adgangskode er blevet sendt',
      'submit': 'Indsend',
      'recover_password': 'Generhverv din adgangskode',
      'late_fees': 'Forsinkede gebyrer',
      'credit_number': 'Kreditnummer',
      'payment_number': 'Betaling',
      'late_fee_amount': 'Sengebyr Beløb',
      'late_fee_percent': 'Forsinket gebyr i procent',
      'before_due_date': 'Inden forfaldsdatoen',
      'after_due_date': 'Efter forfaldsdatoen',
      'after_invoice_date': 'Efter Faktura datoen',
      'days': 'Dage',
      'invoice_email': 'Faktura e-mail',
      'payment_email': 'Betalings e-mail',
      'partial_payment': 'Delvis Betaling',
      'payment_partial': 'Delvis Betaling',
      'partial_payment_email': 'Delvis Betaling e-mail',
      'quote_email': 'Tilbuds e-mail',
      'endless_reminder': 'Uendelig påmindelse',
      'filtered_by_user': 'Filtreret af Bruger',
      'administrator': 'Administrator',
      'administrator_help':
          'Allow user to manage users, change settings and modify all records',
      'user_management': 'Brugerhåndtering',
      'users': 'Brugere',
      'new_user': 'New User',
      'edit_user': 'Rediger bruger',
      'created_user': 'Succesfuldt oprettet Bruger',
      'updated_user': 'Bruger opdateret',
      'archived_user': 'Successfully archived user',
      'deleted_user': 'Bruger slettet',
      'removed_user': 'Succesfuldt fjernet Bruger',
      'restored_user': 'Bruger genskabt',
      'archived_users': 'Succesfuldt arkiveret :value brugere',
      'deleted_users': 'Succesfuldt slettet :value brugere',
      'removed_users': 'Succesfuldt fjernede :value brugere',
      'restored_users': 'Succesfuldt genskabt :value brugere',
      'general_settings': 'General Settings',
      'invoice_options': 'Fakturaindstillinger',
      'hide_paid_to_date': 'Skjul delbetalinger',
      'hide_paid_to_date_help':
          'Vis kun delbetalinger hvis der er forekommet en delbetaling.',
      'invoice_embed_documents': 'Embed Images/Documents',
      'invoice_embed_documents_help':
          'Include attached images/pdfs in the invoice.',
      'all_pages_header': 'Show header on',
      'all_pages_footer': 'Show footer on',
      'first_page': 'first page',
      'all_pages': 'all pages',
      'last_page': 'last page',
      'primary_font': 'Primær skrifttype',
      'secondary_font': 'Sekundær skrifttype',
      'primary_color': 'Primær Farve',
      'secondary_color': 'Sekundær Farve',
      'page_size': 'Page Size',
      'font_size': 'Font Størrelse',
      'quote_design': 'Citat design',
      'invoice_fields': 'Faktura felt',
      'product_fields': 'Produktfelter',
      'invoice_terms': 'Vilkår for fakturaen',
      'invoice_footer': 'Faktura fodnoter',
      'quote_terms': 'Quote Terms',
      'quote_footer': 'Quote Footer',
      'auto_email_invoice': 'Automatisk e-mail',
      'auto_email_invoice_help':
          'Send automatisk e-mail Gentagen Fakturaer , når oprettet .',
      'auto_archive_quote': 'Auto Arkiv',
      'auto_archive_quote_help':
          'Arkiv automatisk citater ved konvertering til Faktura .',
      'auto_convert_quote': 'Auto konvertering',
      'auto_convert_quote_help':
          'Konverter automatisk et tilbud til en Faktura , når Godkendt .',
      'workflow_settings': 'Workflow Indstillinger',
      'freq_daily': 'Daglig',
      'freq_weekly': 'Ugentlig',
      'freq_two_weeks': 'To uger',
      'freq_four_weeks': 'Fire uger',
      'freq_monthly': 'Månedlig',
      'freq_two_months': 'To måneder',
      'freq_three_months': 'Tre måneder',
      'freq_four_months': 'Fire måneder',
      'freq_six_months': 'Seks måneder',
      'freq_annually': 'Årlig',
      'freq_two_years': 'To år',
      'freq_three_years': '3 år',
      'never': 'Never',
      'company': 'Selskab',
      'generated_numbers': 'Dannede numre',
      'charge_taxes': 'Inkluder skat',
      'next_reset': 'Næste nulstilling',
      'reset_counter': 'Nulstil tæller',
      'recurring_prefix': 'Gentagen præfiks',
      'number_padding': 'Nummerpolstring',
      'general': 'Generel',
      'surcharge_field': 'Tillægsfelt',
      'company_field': 'Company Field',
      'company_value': 'Virksomhedens værdi',
      'credit_field': 'Kreditfelt',
      'invoice_field': 'Faktura Field',
      'invoice_surcharge': 'Faktura Tillæg',
      'client_field': 'Klient Field',
      'product_field': 'Produktfelt',
      'payment_field': 'Betaling',
      'contact_field': 'kontakt felt',
      'vendor_field': 'Sælger Mark',
      'expense_field': 'Udgift Mark',
      'project_field': 'Projektfelt',
      'task_field': 'Opgave Mark',
      'group_field': 'Gruppefelt',
      'number_counter': 'Nummertæller',
      'prefix': 'Præfix',
      'number_pattern': 'Nummermønster',
      'messages': 'Beskeder',
      'custom_css': 'Brugerdefineret CSS',
      'custom_javascript': 'Speciel JavaScript',
      'signature_on_pdf': 'Vis på PDF',
      'signature_on_pdf_help': 'Vis Kunde på Faktura /Tilbud PDF .',
      'show_accept_invoice_terms': 'Afkrydsningsfelt for fakturavilkår',
      'show_accept_invoice_terms_help':
          'Kunden skal acceptere fakturabetingelserne.',
      'show_accept_quote_terms': 'Tilbuds Betingelser Afkrydsningsfelt',
      'show_accept_quote_terms_help':
          'Kunden skal acceptere tilbudsbetingelserne.',
      'require_invoice_signature': 'Fakturasignatur',
      'require_invoice_signature_help':
          'Kunden skal bekræfte med sin underskrift.',
      'require_quote_signature': 'Tilbuds underskrift',
      'enable_portal_password': 'Adgangskodebeskyttet Fakturaer',
      'enable_portal_password_help':
          'Lader dig indtaste en adgangskode til hver kontakt. Hvis en adgangskode ikke er lavet, vil kontakten blive pålagt at indtaste en adgangskode før det er muligt at se fakturaer.',
      'authorization': 'Autorisation',
      'subdomain': 'Underdomain',
      'domain': 'Domæne',
      'portal_mode': 'Portaltilstand',
      'email_signature': 'Venlig hilsen,',
      'enable_email_markup_help':
          'Gør det lettere for dine klienter at betale dig ved at tilføje schema.org markup i dine e-mails.',
      'plain': 'Plain',
      'light': 'Light',
      'dark': 'Dark',
      'email_design': 'Email Design',
      'attach_pdf': 'Vedhæft PDF',
      'attach_documents': 'Vedhæft dokumenter',
      'attach_ubl': 'Vedhæft UBL/E- Faktura',
      'email_style': 'e-mail stil',
      'enable_email_markup': 'Brug HTML markup sprog',
      'reply_to_email': 'Svar-til e-mail',
      'reply_to_name': 'Svar-til-navn',
      'bcc_email': 'BCC-email',
      'processed': 'Bearbejdet',
      'credit_card': 'Kreditkort',
      'bank_transfer': 'Bankoverførsel',
      'priority': 'Prioritet',
      'fee_amount': 'Gebyr Beløb',
      'fee_percent': 'Gebyr i procent',
      'fee_cap': 'Gebyrloft',
      'limits_and_fees': 'Grænser/gebyrer',
      'enable_min': 'Aktivér minimum',
      'enable_max': 'Aktivér maksimum',
      'min_limit': 'Min: :min',
      'max_limit': 'Max: :max',
      'min': 'Min',
      'max': 'Max',
      'accepted_card_logos': 'Accepterede kortlogoer',
      'credentials': 'Legitimationsoplysninger',
      'update_address': 'Opdater adresse',
      'update_address_help': 'Opdater kundens adresse med de opgivne detaljer',
      'rate': 'Sats',
      'tax_rate': 'Tax Rate',
      'new_tax_rate': 'New Tax Rate',
      'edit_tax_rate': 'Edit tax rate',
      'created_tax_rate': 'Successfully created tax rate',
      'updated_tax_rate': 'Successfully updated tax rate',
      'archived_tax_rate': 'Successfully archived the tax rate',
      'deleted_tax_rate': 'Succesfuldt slettet skattesats',
      'restored_tax_rate': 'Succesfuldt genskabt skattesats',
      'archived_tax_rates': 'Succesfuldt arkiveret :value skattesatser',
      'deleted_tax_rates': 'Succesfuldt slettet :value skattesatser',
      'restored_tax_rates': 'Succesfuldt genskabt :value skattesatser',
      'fill_products': 'Automatisk-udfyld produkter',
      'fill_products_help':
          'Valg af produkt vil automatisk udfylde beskrivelse og pris',
      'update_products': 'Automatisk opdatering af produkter',
      'update_products_help':
          'En opdatering af en faktura vil automatisk opdaterer Produkt biblioteket',
      'convert_products': 'Konverter produkter',
      'convert_products_help':
          'Konverter automatisk produktpriser til kundens valuta',
      'fees': 'Gebyrer',
      'limits': 'Grænser',
      'provider': 'Udbyder',
      'company_gateway': 'Betalingsgateway',
      'company_gateways': 'Betaling Gateways',
      'new_company_gateway': 'Ny Gateway',
      'edit_company_gateway': 'Redigér Gateway',
      'created_company_gateway': 'Succesfuldt oprettet Gateway',
      'updated_company_gateway': 'Succesfuldt opdateret Gateway',
      'archived_company_gateway': 'Succesfuldt arkiveret Gateway',
      'deleted_company_gateway': 'Succesfuldt slettet Gateway',
      'restored_company_gateway': 'Succesfuldt genskabt Gateway',
      'archived_company_gateways': 'Succesfuldt arkiveret :value gateways',
      'deleted_company_gateways': 'Succesfuldt slettet :value gateways',
      'restored_company_gateways': 'Succesfuldt genskabt :value gateways',
      'continue_editing': 'Fortsæt redigering',
      'discard_changes': 'Kassér ændringer',
      'default_value': 'Standard værdi',
      'disabled': 'Disabled',
      'currency_format': 'Format',
      'first_day_of_the_week': 'Ugens første dag',
      'first_month_of_the_year': 'Årets første måned',
      'sunday': 'Sunday',
      'monday': 'Monday',
      'tuesday': 'Tuesday',
      'wednesday': 'Wednesday',
      'thursday': 'Thursday',
      'friday': 'Friday',
      'saturday': 'Saturday',
      'january': 'Januar',
      'february': 'Februar',
      'march': 'Marts',
      'april': 'April',
      'may': 'Maj',
      'june': 'Juni',
      'july': 'Juli',
      'august': 'August',
      'september': 'September',
      'october': 'October',
      'november': 'November',
      'december': 'December',
      'symbol': 'Symbol',
      'ocde': 'Kode',
      'date_format': 'Format',
      'datetime_format': 'Dato-tid Format',
      'military_time': '24 Hour Time',
      'military_time_help': '24 timers visning',
      'send_reminders': 'Send påmindelser',
      'timezone': 'Tidszone',
      'filtered_by_project': 'Filtreret efter projekt',
      'filtered_by_group': 'Filtreret efter gruppe',
      'filtered_by_invoice': 'Filtreret efter Faktura',
      'filtered_by_client': 'Filter: Kunde',
      'filtered_by_vendor': 'Filtreret af Sælger',
      'group_settings': 'Gruppe Indstillinger',
      'group': 'Gruppe',
      'groups': 'Grupper',
      'new_group': 'Ny gruppe',
      'edit_group': 'Redigér Group',
      'created_group': 'Succesfuldt oprettet gruppe',
      'updated_group': 'Succesfuldt opdateret gruppe',
      'archived_groups': 'Succesfuldt arkiveret :value grupper',
      'deleted_groups': 'Succesfuldt slettet :value grupper',
      'restored_groups': 'Succesfuldt genskabt :value grupper',
      'archived_group': 'Succesfuldt arkiveret gruppe',
      'deleted_group': 'Succesfuldt slettet gruppe',
      'restored_group': 'Succesfuldt genskabt gruppe',
      'upload_logo': 'Upload dit firmalogo',
      'uploaded_logo': 'Succesfuldt uploadet logo',
      'logo': 'Logo',
      'saved_settings': 'Succesfuldt reddede Indstillinger',
      'product_settings': 'Produkt Indstillinger',
      'device_settings': 'Indstillinger',
      'defaults': 'Standarder',
      'basic_settings': 'Indstillinger',
      'advanced_settings': 'Avancerede indstillinger',
      'company_details': 'Virksomhedsinformation',
      'user_details': 'User Details',
      'localization': 'Lokalisering',
      'online_payments': 'Onlinebetalinger',
      'tax_rates': 'Momssatser',
      'notifications': 'Meddelelser',
      'import_export': 'Import/Eksport',
      'custom_fields': 'Brugerdefineret felt',
      'invoice_design': 'Fakturadesign',
      'buy_now_buttons': '\'Køb nu\' knapper',
      'email_settings': 'E-mail-indstillinger',
      'templates_and_reminders': 'Templates & Reminders',
      'credit_cards_and_banks': 'Kreditkort og banker',
      'data_visualizations': 'Datavisualisering',
      'price': 'Pris',
      'email_sign_up': 'e-mail Tilmeld dig',
      'google_sign_up': 'Google Tilmeld dig',
      'thank_you_for_your_purchase': 'Tak for dit køb!',
      'redeem': 'Indløs',
      'back': 'Tilbage',
      'past_purchases': 'Tidligere køb',
      'annual_subscription': 'Årligt abonnement',
      'pro_plan': 'Pro Plan',
      'enterprise_plan': 'Enterprise Plan',
      'count_users': ':count brugere',
      'upgrade': 'Opgrader',
      'please_enter_a_first_name': 'Indtast venligst et fornavn',
      'please_enter_a_last_name': 'Indtast venligst et efternavn',
      'please_agree_to_terms_and_privacy':
          'Acceptér venligst Betingelser af service og privatlivspolitik for at Opret en konto.',
      'i_agree_to_the': 'Jeg er enig i',
      'terms_of_service': 'Vilkår for brug',
      'privacy_policy': 'Privatlivspolitik',
      'sign_up': 'Tilmeld dig',
      'account_login': 'Konto Log ind',
      'view_website': 'Vis hjemmeside',
      'create_account': 'Opret konto',
      'email_login': 'e-mail Login',
      'create_new': 'Opret ny',
      'no_record_selected': 'Ingen post valgt',
      'error_unsaved_changes': 'Venligst Gem eller Afbryd dine ændringer',
      'download': 'Download',
      'requires_an_enterprise_plan': 'Kræver en Enterprise Plan',
      'take_picture': 'Tage billede',
      'upload_files': 'Upload filer',
      'document': 'Dokument',
      'documents': 'Documents',
      'new_document': 'Nyt dokument',
      'edit_document': 'Redigér Dokument',
      'uploaded_document': 'Succesfuldt uploadet dokument',
      'updated_document': 'Succesfuldt opdateret dokument',
      'archived_document': 'Succesfuldt arkiveret dokument',
      'deleted_document': 'Succesfuldt slettet dokument',
      'restored_document': 'Succesfuldt genskabt dokument',
      'archived_documents': 'Succesfuldt arkiveret :value dokumenter',
      'deleted_documents': 'Succesfuldt slettet :value dokumenter',
      'restored_documents': 'Succesfuldt genskabt :value dokumenter',
      'no_history': 'Ingen historie',
      'expense_date': 'Udgifts Dato',
      'pending': 'Afventer',
      'expense_status_1': 'Logget',
      'expense_status_2': 'Verserende',
      'expense_status_3': 'Faktureret',
      'converted': 'Konverteret',
      'add_documents_to_invoice': 'Tilføj dokumenter til Faktura',
      'exchange_rate': 'Exchange Rate',
      'convert_currency': 'Convert currency',
      'mark_paid': 'Markér som betalt',
      'category': 'Kategori',
      'address': 'Adresse',
      'new_vendor': 'Ny sælger',
      'created_vendor': 'Sælger oprettet',
      'updated_vendor': 'Sælger opdateret succesfuldt',
      'archived_vendor': 'Gennemførte arkivering af sælger',
      'deleted_vendor': 'Sletning af sælger gennemført',
      'restored_vendor': 'Genskabelse af sælger gennemført',
      'archived_vendors': 'Gennemførte arkivering af :count sælgere',
      'deleted_vendors': 'Gennemførte sletning af :count sælgere',
      'restored_vendors': 'Succesfuldt genskabt :value sælgere',
      'new_expense': 'Indtast udgift',
      'created_expense': 'Udgift oprettet succesfuldt',
      'updated_expense': 'Udgift opdateret succesfuldt',
      'archived_expense': 'Udgift arkiveret succesfuldt',
      'deleted_expense': 'Udgift slettet succesfuldt',
      'restored_expense': 'Successfully restored expense',
      'archived_expenses': 'Udgifter arkiveret succesfuldt',
      'deleted_expenses': 'Udgifter slettet succesfuldt',
      'restored_expenses': 'Succesfuldt genskabt :value udgifter',
      'copy_shipping': 'Kopi Forsendelse',
      'copy_billing': 'Kopier fakturering',
      'design': 'Design',
      'failed_to_find_record': 'Det lykkedes ikke at finde posten',
      'invoiced': 'Faktureret',
      'logged': 'Ajourført',
      'running': 'Kører',
      'resume': 'Genoptag',
      'task_errors': 'Ret venligst de overlappende tider',
      'start': 'Start',
      'stop': 'Stop',
      'started_task': 'Succesfuldt startede Opgave',
      'stopped_task': 'Opgave stoppet',
      'resumed_task': 'Succesfuldt genoptog Opgave',
      'now': 'Nu',
      'auto_start_tasks': 'Autostart opgaver',
      'timer': 'Tidtager',
      'manual': 'Manuelt',
      'budgeted': 'Budgetteret',
      'start_time': 'Start Tidspunkt',
      'end_time': 'Slut tidspunkt',
      'date': 'Dato',
      'times': 'Gange',
      'duration': 'Varighed',
      'new_task': 'Ny opgave',
      'created_task': 'Opgave oprettet',
      'updated_task': 'Opgave opdateret',
      'archived_task': 'Opgave arkiveret',
      'deleted_task': 'Opgave slettet',
      'restored_task': 'Opgave genskabt',
      'archived_tasks': 'Antal arkiverede opgaver: :count',
      'deleted_tasks': 'Antal opgaver slettet: :count',
      'restored_tasks': 'Succesfuldt genskabt :value opgaver',
      'please_enter_a_name': 'Indtast venligst et navn',
      'budgeted_hours': 'Budgetterede timer',
      'created_project': 'Projektet blev oprettet',
      'updated_project': 'Projektet blev opdateret',
      'archived_project': 'Projektet blev arktiveret',
      'deleted_project': 'Projektet blev slettet',
      'restored_project': 'Projektet blev genskabt',
      'archived_projects': ':count projekter blev arkiveret',
      'deleted_projects': ':count projekter blev slettet',
      'restored_projects': 'Succesfuldt genskabt :value projekter',
      'new_project': 'Nyt projekt',
      'thank_you_for_using_our_app': 'Tak fordi du bruger vores app!',
      'if_you_like_it': 'Hvis du kan lide det venligst',
      'click_here': 'Klik her',
      'click_here_capital': 'Klik her',
      'to_rate_it': 'at bedømme det.',
      'average': 'Gennemsnit',
      'unapproved': 'Ikke godkendt',
      'authenticate_to_change_setting':
          'Godkend venligst for at ændre denne indstilling',
      'locked': 'Låst',
      'authenticate': 'Godkend',
      'please_authenticate': 'Godkend venligst',
      'biometric_authentication': 'Biometrisk autentificering',
      'footer': 'Fod',
      'compare': 'Sammenligne',
      'hosted_login': 'Hostet login',
      'selfhost_login': 'Selfhost Login',
      'google_sign_in': 'Log ind med Google',
      'today': 'I dag',
      'custom_range': 'Valgfri periode',
      'date_range': 'Dato område',
      'current': 'Nuværende',
      'previous': 'Tidligere',
      'current_period': 'Nuværende periode',
      'comparison_period': 'Sammenligningsperiode',
      'previous_period': 'Tidligere periode',
      'previous_year': 'Foregående år',
      'compare_to': 'Sammenligne med',
      'last7_days': 'Sidste 7 dage',
      'last_week': 'Sidste uge',
      'last30_days': 'Sidste 30 dage',
      'this_month': 'Denne måned',
      'last_month': 'Forrige måned',
      'this_year': 'Dette år',
      'last_year': 'Forrige år',
      'all_time': 'Hele tiden',
      'custom': 'Brugertilpasset',
      'clone_to_invoice': 'Klon til Faktura',
      'clone_to_quote': 'Klon at citere',
      'clone_to_credit': 'Klon til kredit',
      'view_invoice': 'Se faktura',
      'convert': 'Konvertere',
      'more': 'Mere',
      'edit_client': 'Rediger kunde',
      'edit_product': 'Rediger produkt',
      'edit_invoice': 'Rediger faktura',
      'edit_quote': 'Rediger tilbud',
      'edit_payment': 'Redigér betaling',
      'edit_task': 'Redigér opgave',
      'edit_expense': 'Redigér Udgift',
      'edit_vendor': 'Redigér sælger',
      'edit_project': 'Redigér projekt',
      'edit_recurring_quote': 'Redigér Gentagen citat',
      'billing_address': 'Faktura adresse',
      'shipping_address': 'Forsendelsesadresse',
      'total_revenue': 'Samlede indtægter',
      'average_invoice': 'Gennemsnitlig Faktura',
      'outstanding': 'Forfaldne',
      'invoices_sent': ':count fakturaer sendt',
      'active_clients': 'aktive Kunder',
      'close': 'Luk',
      'email': 'e-mail',
      'password': 'Kodeord',
      'url': 'URL',
      'secret': 'Hemmelighed',
      'name': 'Navn',
      'logout': 'Log ud',
      'login': 'Log ind',
      'filter': 'Filter',
      'sort': 'Sortere',
      'search': 'Søg',
      'active': 'Aktiv',
      'archived': 'Archived',
      'deleted': 'Slettet',
      'dashboard': 'Dashboard',
      'archive': 'Arkiv',
      'delete': 'Slet',
      'restore': 'Gendanne',
      'refresh_complete': 'Opdater fuldført',
      'please_enter_your_email': 'Indtast venligst din e-mail',
      'please_enter_your_password': 'Indtast venligst din adgangskode',
      'please_enter_your_url': 'Indtast venligst din URL',
      'please_enter_a_product_key': 'Indtast venligst en produktnøgle',
      'ascending': 'Stigende',
      'descending': 'Aftagende',
      'save': 'Gem',
      'an_error_occurred': 'En fejl opstod',
      'paid_to_date': 'Betalt til dato',
      'balance_due': 'Udestående beløb',
      'balance': 'Balance',
      'overview': 'Oversigt',
      'details': 'Detaljer',
      'phone': 'Telefon',
      'website': 'Hjemmeside',
      'vat_number': 'CVR/SE-nummer',
      'id_number': 'ID Nummer',
      'create': 'Opret',
      'copied_to_clipboard': 'Kopierede :value til udklipsholderen',
      'error': 'Fejl',
      'could_not_launch': 'Kunne ikke starte',
      'contacts': 'Kontaktpersoner',
      'additional': 'Ekstra',
      'first_name': 'Fornavn',
      'last_name': 'Efternavn',
      'add_contact': 'Tilføj kontakt',
      'are_you_sure': 'Er du sikker?',
      'cancel': 'Annullér',
      'ok': 'Okay',
      'remove': 'Fjern',
      'email_is_invalid': 'e-mail er ugyldig',
      'product': 'Produkt',
      'products': 'Produkter',
      'new_product': 'New Product',
      'created_product': 'Produkt oprettet',
      'updated_product': 'Produkt opdateret',
      'archived_product': 'Produkt arkiveret',
      'deleted_product': 'Sletning af produkt gennemført',
      'restored_product': 'Genskabelse af produkt gennemført',
      'archived_products': 'Succesfuldt arkiveret :count produkter',
      'deleted_products': 'Sletning af :count produkter gennemført',
      'restored_products': 'Succesfuldt genskabt :value produkter',
      'product_key': 'Produkt',
      'notes': 'Notes',
      'cost': 'Cost',
      'client': 'Kunde',
      'clients': 'Kunder',
      'new_client': 'Ny kunde',
      'created_client': 'Kunde oprettet succesfuldt',
      'updated_client': 'Kunde opdateret',
      'archived_client': 'Kunde arkiveret',
      'archived_clients': 'Arkiverede :count kunder',
      'deleted_client': 'Kunde slettet',
      'deleted_clients': 'Slettede :count kunder',
      'restored_client': 'Kunde genskabt',
      'restored_clients': 'Succesfuldt genskabt :value Klienter',
      'address1': 'Gade',
      'address2': 'Lejlighed/suite',
      'city': 'By',
      'state': 'Område',
      'postal_code': 'Postnummer',
      'country': 'Country',
      'invoice': 'Faktura',
      'invoices': 'Fakturaer',
      'new_invoice': 'Ny faktura',
      'created_invoice': 'Faktura oprettet',
      'updated_invoice': 'Faktura opdateret',
      'archived_invoice': 'Faktura arkiveret',
      'deleted_invoice': 'Faktura slettet',
      'restored_invoice': 'Faktura genskabt',
      'archived_invoices': 'Arkiverede :count fakturaer',
      'deleted_invoices': 'Slettede :count fakturaer',
      'restored_invoices': 'Succesfuldt genskabt :value Fakturaer',
      'emailed_invoice': 'E-mail faktura sendt',
      'emailed_payment': 'Succesfuldt mailet Betaling',
      'amount': 'Beløb',
      'invoice_number': 'Fakturanummer',
      'invoice_date': 'Faktureringsdato',
      'discount': 'Rabat',
      'po_number': 'PO-nummer',
      'terms': 'Vilkår',
      'public_notes': 'Public Notes',
      'private_notes': 'Private noter',
      'frequency': 'Frekvens',
      'start_date': 'Startdato',
      'end_date': 'Slutdato',
      'quote_number': 'Tilbuds nummer',
      'quote_date': 'Tilbuds dato',
      'valid_until': 'Gyldig indtil',
      'items': 'genstande',
      'partial_deposit': 'Delvis/Depositum',
      'description': 'Beskrivelse',
      'unit_cost': 'Enhedspris',
      'quantity': 'Styk',
      'add_item': 'Tilføj vare',
      'contact': 'Kontakt',
      'work_phone': 'Telefon',
      'total_amount': 'Total beløb',
      'pdf': 'PDF',
      'due_date': 'Betalingsfrist',
      'partial_due_date': 'Delvis forfaldsdato',
      'paid_date': 'Betalt dato',
      'status': 'Status',
      'invoice_status_id': 'Faktura Status',
      'quote_status': 'Citatstatus',
      'click_plus_to_add_item': 'Klik på + for at Tilføj et element',
      'click_plus_to_add_time': 'Klik på + for at Tilføj tid',
      'count_selected': ':count valgt',
      'total': 'Total',
      'percent': 'Procent',
      'edit': 'Rediger',
      'dismiss': 'Afskedige',
      'please_select_a_date': 'Vælg venligst en dato',
      'please_select_a_client': 'Vælg venligst en Kunde',
      'please_select_an_invoice': 'Vælg venligst en Faktura',
      'task_rate': 'Opgave',
      'settings': 'Indstillinger',
      'language': 'Sprog',
      'currency': 'betalingsmiddel',
      'created_at': 'Oprettelsesdato',
      'created_on': 'oprettet On',
      'updated_at': 'Opdateret',
      'tax': 'Moms',
      'please_enter_an_invoice_number': 'Indtast venligst et Faktura nummer',
      'please_enter_a_quote_number': 'Indtast venligst et tilbudsnummer',
      'past_due': 'Ikke betalt til tiden',
      'draft': 'Kladde',
      'sent': 'Sendt',
      'viewed': 'har set',
      'approved': 'Godkendt',
      'partial': 'Udbetaling',
      'paid': 'Betalt',
      'mark_sent': 'Markér som sendt',
      'marked_invoice_as_sent': 'Succesfuldt markeret Faktura som sendt',
      'marked_invoice_as_paid': 'Succesfuldt markeret Faktura som betalt',
      'marked_invoices_as_sent': 'Succesfuldt markeret Fakturaer som sendt',
      'marked_invoices_as_paid': 'Succesfuldt mærkede Fakturaer som betalt',
      'done': 'Gennemført',
      'please_enter_a_client_or_contact_name': 'Indtast en Kunde eller kontakt',
      'dark_mode': 'Mørk tilstand',
      'restart_app_to_apply_change': 'Genstart appen for at anvende ændringen',
      'refresh_data': 'Opdater data',
      'blank_contact': 'Blank kontakt',
      'activity': 'Aktivitet',
      'no_records_found': 'Ingen registreringer fundet',
      'clone': 'Kopiér',
      'loading': 'Indlæser',
      'industry': 'Industri',
      'size': 'Størrelse',
      'payment_terms': 'Betalingsvilkår',
      'payment_date': 'Betalingsdato',
      'payment_status': 'Betaling Status',
      'payment_status_1': 'Verserende',
      'payment_status_2': 'annulleret',
      'payment_status_3': 'mislykkedes',
      'payment_status_4': 'Afsluttet',
      'payment_status_5': 'Delvist refunderet',
      'payment_status_6': 'Refunderet',
      'payment_status_-1': 'Ikke anvendt',
      'payment_status_-2': 'Delvis ikke anvendt',
      'net': 'Net',
      'client_portal': 'Client Portal',
      'show_tasks': 'Vis opgaver',
      'email_reminders': 'e-mail påmindelser',
      'enabled': 'Aktiveret',
      'recipients': 'Modtagere',
      'initial_email': 'Indledende e-mail',
      'first_reminder': 'First Reminder',
      'second_reminder': 'Second Reminder',
      'third_reminder': 'Third Reminder',
      'reminder1': 'Første påmindelse',
      'reminder2': 'Anden påmindelse',
      'reminder3': 'Tredje påmindelse',
      'template': 'Skabelon',
      'send': 'Sende',
      'subject': 'Subject',
      'body': 'Body',
      'send_email': 'Send e-mail',
      'email_receipt': 'Send e-mail kvittering til kunden',
      'auto_billing': 'Automatisk fakturering',
      'button': 'Knap',
      'preview': 'Preview',
      'customize': 'Customize',
      'history': 'Historik',
      'payment': 'Betaling',
      'payments': 'Betalinger',
      'refunded': 'Refunderet',
      'payment_type': 'Betalingstype',
      'transaction_reference': 'Transaktionsreference',
      'enter_payment': 'Tilføj betaling',
      'new_payment': 'Indtast betaling',
      'created_payment': 'Betaling oprettet',
      'updated_payment': 'Betaling opdateret',
      'archived_payment': 'Betaling arkiveret',
      'deleted_payment': 'Betaling slettet',
      'restored_payment': 'Betaling genskabt',
      'archived_payments': 'Arkiverede :count betalinger',
      'deleted_payments': 'Slettede :count betalinger',
      'restored_payments': 'Succesfuldt genskabt :value Betalinger',
      'quote': 'Pristilbud',
      'quotes': 'Pristilbud',
      'new_quote': 'Nyt tilbud',
      'created_quote': 'Tilbud oprettet',
      'updated_quote': 'Tilbud opdateret',
      'archived_quote': 'Tilbud arkiveret',
      'deleted_quote': 'Tilbud slettet',
      'restored_quote': 'Tilbud genskabt',
      'archived_quotes': 'Arkiverede :count tilbud',
      'deleted_quotes': 'Slettede :count tilbud',
      'restored_quotes': 'Succesfuldt genskabt :value citater',
      'expense': 'Udgift',
      'expenses': 'Udgifter',
      'vendor': 'Sælger',
      'vendors': 'Sælgere',
      'task': 'Opgave',
      'tasks': 'Opgaver',
      'project': 'Projekt',
      'projects': 'Projekter',
      'activity_1': ':user created client :client',
      'activity_2': ':user arkiverede kunde :client',
      'activity_3': ':user slettede kunde :client',
      'activity_4': ':user oprettede faktura :invoice',
      'activity_5': ':user ajourførte faktura :invoice',
      'activity_6':
          ':user emailede fakturaen :invoice for :client til :contact',
      'activity_7': ':contact læste faktura :invoice for :client',
      'activity_8': ':user arkiverede faktura :invoice',
      'activity_9': ':user slettede faktura :invoice',
      'activity_10':
          ':user indtastet Betaling :payment for :payment _beløb på Faktura :invoice for :client',
      'activity_11': ':user ajourførte betaling :payment',
      'activity_12': ':user arkiverede betaling :payment',
      'activity_13': ':user slettede betaling :payment',
      'activity_14': ':user indtastede :credit kredit',
      'activity_15': ':user ajourførte :credit kredit',
      'activity_16': ':user arkiverede :credit kredit',
      'activity_17': ':user slettede :credit kredit',
      'activity_18': ':user oprettede tilbud :quote',
      'activity_19': ':user ajourførte tilbud :quote',
      'activity_20': ':user emailede tilbuddet :quote for :client til :contact',
      'activity_21': ':contact læste tilbud :quote',
      'activity_22': ':user arkiverede tilbud :quote',
      'activity_23': ':user slettede tilbud:quote',
      'activity_24': ':user genoprettede tilbud :quote',
      'activity_25': ':user genoprettede faktura :invoice',
      'activity_26': ':user genoprettede kunde :client',
      'activity_27': ':user genoprettede betaling :payment',
      'activity_28': ':user genoprettede :credit kredit',
      'activity_29': ':contact godkendte tilbuddet :quote for :client',
      'activity_30': ':user oprettede sælger :vendor',
      'activity_31': ':user arkiverede sælger :vendor',
      'activity_32': ':user slettede sælgeren :vendor',
      'activity_33': ':user genskabte sælgeren :vendor',
      'activity_34': ':user oprettede udgiften :expense',
      'activity_35': ':user arkiverede udgiften :expense',
      'activity_36': ':user slettede udgiften :expense',
      'activity_37': ':user genskabte udgiften :expense',
      'activity_39': ':user annullerede en :payment_amount betaling :payment',
      'activity_40':
          ':bruger refunderet :justering af en :betaling_beløb betaling :betaling',
      'activity_41': ':payment_amount betaling (:betaling) mislykkedes',
      'activity_42': ':user oprettede opgaven :task',
      'activity_43': ':user opdaterede opgaven :task',
      'activity_44': ':user arkiverede opgaven :task',
      'activity_45': ':user slettede opgave :task',
      'activity_46': ':user genoprettede opgave :task',
      'activity_47': ':user ajourførte udgift :expense',
      'activity_48': ':user oprettet Bruger :user',
      'activity_49': ':user opdateret Bruger :user',
      'activity_50': ':user arkiveret Bruger :user',
      'activity_51': ':user slettet Bruger :user',
      'activity_52': ':user genskabt Bruger :user',
      'activity_53': ':user markeret sendt :invoice',
      'activity_54': ':user betalt Faktura :invoice',
      'activity_55': ':contact besvarede sagen :ticket',
      'activity_56': ':user læste sagen :ticket',
      'activity_57': 'Systemet kunne ikke sende e-mail til Faktura :invoice',
      'activity_58': ':user omvendt Faktura :invoice',
      'activity_59': ':user annulleret Faktura :invoice',
      'activity_60': ':contact set citat :quote',
      'activity_61': ':user opdaterede Kunde :client',
      'activity_62': ':user opdateret Sælger :vendor',
      'activity_63':
          ':user e-mailede den første påmindelse for Faktura :invoice til :contact',
      'activity_64':
          ':user e-mailede anden påmindelse for Faktura :invoice til :contact',
      'activity_65':
          ':user har sendt en tredje påmindelse til Faktura :invoice via e-mail til :contact',
      'activity_66':
          ':user e-mailede en endeløs påmindelse om Faktura :invoice til :contact',
      'activity_80': ':user oprettet abonnement :subscription',
      'activity_81': ':user opdateret abonnement :subscription',
      'activity_82': ':user arkiveret abonnement :subscription',
      'activity_83': ':user slettet abonnement :subscription',
      'activity_84': ':user genskabt abonnement :subscription',
      'one_time_password': 'Engangskodeord',
      'emailed_quote': 'Tilbud sendt som e-mail',
      'emailed_credit': 'Succesfuldt emailet kredit',
      'marked_quote_as_sent': 'Succesfuldt markeret tilbud som sendt',
      'marked_credit_as_sent': 'Succesfuldt markeret kredit som sendt',
      'expired': 'Expired',
      'all': 'Alle',
      'select': 'Vælg',
      'long_press_multiselect': 'Tryk længe på Multiselect',
      'custom_value1': 'Speciel 1',
      'custom_value2': 'Speciel 2',
      'custom_value3': 'Speciel 3',
      'custom_value4': 'Speciel 4',
      'email_style_custom': 'Speciel e-mail stil',
      'custom_message_dashboard': 'Speciel Dashboard Besked',
      'custom_message_unpaid_invoice': 'Speciel Ubetalt Faktura Besked',
      'custom_message_paid_invoice': 'Speciel Paid Faktura Besked',
      'custom_message_unapproved_quote': 'Speciel Ugodkendt Citat Besked',
      'lock_invoices': 'Lock Fakturaer',
      'translations': 'Oversættelser',
      'task_number_pattern': 'Opgave nummermønster',
      'task_number_counter': 'Opgave nummertæller',
      'expense_number_pattern': 'Udgift Nummermønster',
      'expense_number_counter': 'Udgift Antal Tæller',
      'vendor_number_pattern': 'Sælger Talmønster',
      'vendor_number_counter': 'Sælger Taltæller',
      'ticket_number_pattern': 'Sag nummer mønster',
      'ticket_number_counter': 'Sag nummer tæller',
      'payment_number_pattern': 'Betaling',
      'payment_number_counter': 'Betaling',
      'invoice_number_pattern': 'Faktura nummermønster',
      'invoice_number_counter': 'Fakturanummer-tæller',
      'quote_number_pattern': 'Citatnummermønster',
      'quote_number_counter': 'Tilbuds nummer-tæller',
      'client_number_pattern': 'Kreditnummermønster',
      'client_number_counter': 'Kreditnummertæller',
      'credit_number_pattern': 'Kreditnummermønster',
      'credit_number_counter': 'Kreditnummertæller',
      'reset_counter_date': 'Nulstil tællerdato',
      'counter_padding': 'Bordpolstring',
      'shared_invoice_quote_counter': 'Del Faktura /Citat tæller',
      'default_tax_name_1': 'Standard skattenavn 1',
      'default_tax_rate_1': 'Standardafgiftssats 1',
      'default_tax_name_2': 'Standard skattenavn 2',
      'default_tax_rate_2': 'Standardafgiftssats 2',
      'default_tax_name_3': 'Standard skattenavn 3',
      'default_tax_rate_3': 'Standardafgiftssats 3',
      'email_subject_invoice': 'e-mail Faktura Emne',
      'email_subject_quote': 'e-mail Citat Emne',
      'email_subject_payment': 'e-mail Betaling Emne',
      'email_subject_payment_partial': 'e-mail Betaling Emne',
      'show_table': 'Vis tabel',
      'show_list': 'Vis liste',
      'client_city': 'Kunde By',
      'client_state': 'Kunde Region/Område',
      'client_country': 'Kunde Land',
      'client_is_active': 'Kunde er aktiv',
      'client_balance': 'Kunde Saldo',
      'client_address1': 'Kunde Gade/Vej',
      'client_address2': 'Kunde Etage/Lejl.',
      'vendor_address1': 'Sælger Gade',
      'vendor_address2': 'Sælger Apt/Suite',
      'client_shipping_address1': 'Kunde Levering Gade/Vej',
      'client_shipping_address2': 'Kunde Levering Etage/Lejl.',
      'type': 'Type',
      'invoice_amount': 'Invoice Amount',
      'invoice_due_date': 'Due Date',
      'tax_rate1': 'Skattesats 1',
      'tax_rate2': 'Skattesats 2',
      'tax_rate3': 'Skattesats 3',
      'auto_bill': 'Auto Bill',
      'archived_at': 'arkiveret Kl',
      'has_expenses': 'Har Udgifter',
      'custom_taxes1': 'Speciel 1',
      'custom_taxes2': 'Speciel 2',
      'custom_taxes3': 'Speciel 3',
      'custom_taxes4': 'Speciel 4',
      'custom_surcharge1': 'Speciel 1',
      'custom_surcharge2': 'Speciel 2',
      'custom_surcharge3': 'Speciel 3',
      'custom_surcharge4': 'Speciel 4',
      'is_deleted': 'Er slettet',
      'vendor_city': 'Sælger By',
      'vendor_state': 'Sælger Stat',
      'vendor_country': 'Sælger Land',
      'is_approved': 'Er Godkendt',
      'tax_name': 'Tax Name',
      'tax_amount': 'Skat Beløb',
      'tax_paid': 'Skat betalt',
      'payment_amount': 'Beløb',
      'age': 'Alder',
      'is_running': 'Løber',
      'time_log': 'Tids log',
      'bank_id': 'bank',
      'expense_category_id': 'Udgift Kategori ID',
      'expense_category': 'Udgiftskategori',
      'invoice_currency_id': 'Faktura Valuta ID',
      'tax_name1': 'Skattenavn 1',
      'tax_name2': 'Skattenavn 2',
      'tax_name3': 'Skattenavn 3',
      'transaction_id': 'Transaktions ID',
      'status_color_theme': 'Status farvetema',
      'load_color_theme': 'Indlæs farvetema',
    },
    'nl': {
      'location': 'Locatie',
      'is_shipping': 'Is Shipping',
      'deleted_location': 'Location Deleted',
      'added_location': 'Successfully added location',
      'updated_location': 'Updated Location',
      'edit_location': 'Edit Location',
      'add_location': 'Add Location',
      'locations': 'Locaties',
      'preference_product_notes_for_html_view': 'Use Item Notes for HTML View',
      'preference_product_notes_for_html_view_help':
          'Preference the item Description over the item title if displaying the invoice in HTML.',
      'in_stock_quantity': 'Voorraadhoeveelheid',
      'send_emails': 'Send Emails',
      'send_emails_permission': 'Allow user to send emails',
      'enable_client_profile_update':
          'Klanten toestaan hun profiel bij te werken',
      'enable_client_profile_update_help':
          'Klanten toestaan hun profielgegevens bij te werken via het klantenportaal',
      'participant': 'Deelnemer',
      'merged_vendors': 'Succesvol samengevoegde leveranciers',
      'activity_146':
          'E-factuur :invoice voor :client succesvol afgeleverd! :notes',
      'activity_147':
          'E-factuur :invoice voor :client is niet afgeleverd. :notes',
      'activity_148': 'E-Expense :expense ontvangen van :vendor',
      'payment_failed': 'Betaling mislukt',
      'activity_141': 'Gebruiker :user heeft een notitie toegevoegd: :notes',
      'activity_142': 'Citaat :quote herinnering 1 verzonden',
      'activity_143': 'Factuur :invoice is succesvol geïncasseerd',
      'activity_144': 'Incasso mislukt voor factuur :invoice. :notes',
      'activity_145': 'E-factuur :invoice voor :client is verzonden. :notes',
      'ssl_host_override': 'SSL Host Override',
      'upload_logo_short': 'Logo uploaden',
      'show_pdfhtml_on_mobile_help':
          'Voor een betere visualisatie wordt een HTML-versie van de factuur/offerte weergegeven wanneer deze op mobiel wordt bekeken.',
      'accept_purchase_order': 'Accepteer inkooporder',
      'one_page_checkout': 'Afrekenen op één pagina',
      'one_page_checkout_help':
          'Schakel de nieuwe betaalflow \'afrekenen op één pagina\' in',
      'applies_to': 'Is van toepassing op',
      'purchase_order_items': 'Inkooporderartikelen',
      'assigned_group': 'Groep succesvol toegewezen',
      'assign_group': 'Groep toewijzen',
      'merge_to_pdf': 'Samenvoegen in PDF',
      'emails': 'E-mails',
      'latest_requires_php_version':
          'Let op: voor de nieuwste versie is PHP :version vereist',
      'quote_reminder1': 'Eerste herinnering voor offerte',
      'before_valid_until': 'Voor de geldigheidsdatum',
      'after_valid_until': 'Na de geldigheidsdatum',
      'after_quote_date': 'Na de vervaldatum',
      'remind_quote': 'Herinneringen offerte',
      'task_assigned_notification': 'Notificatie voor toegewezen taak',
      'task_assigned_notification_help':
          'Verstuur een e-mail zodra een taak is toegewezen',
      'invoices_locked_end_of_month':
          'Facturen worden vastgezet aan het einde van de maand',
      'end_of_month': 'Einde van de maand',
      'referral_url': 'Referral-URL',
      'referral_program': 'Referral-programma',
      'comment': 'Comment',
      'add_comment': 'Commentaar toevoegen',
      'added_comment': 'Commentaar succesvol opgeslagen',
      'disconnected': 'Verbinding verbroken',
      'reconnect': 'Verbind opnieuw',
      'e_invoice_settings': 'E-factuurinstellingen',
      'calculate': 'Berekenen',
      'sum': 'Som',
      'money': 'Geld',
      'time': 'Tijd',
      'format': 'Formaat',
      'web_app': 'Web-app',
      'desktop_app': 'Desktopapplicatie',
      'invoice_net_amount': 'Nettobedrag',
      'round_to_seconds': 'Afronden op seconden',
      '1_minute': '1 minuut',
      '5_minutes': '5 minuten',
      '15_minutes': '15 minuten',
      '30_minutes': '30 minuten',
      '1_hour': '1 uur',
      '1_day': '1 dag',
      'round_tasks': 'Afrondrichting voor taken',
      'round_tasks_help': 'Rond tijden naar boven of beneden af',
      'direction': 'Richting',
      'round_up': 'Afronden naar boven',
      'round_down': 'Afronden naar beneden',
      'task_round_to_nearest': 'Afronden naar dichtstbijzijnde',
      'activity_139': 'Melding onkosten :expense verzonden naar :contact',
      'activity_140': 'Overzicht verzonden naar :client',
      'bulk_updated': 'Gegevens succesvol bijgewerkt',
      'bulk_update': 'In bulk bewerken',
      'advanced_cards': 'Uitgebreide kaarten',
      'always_show_required_fields':
          'Altijd het verplichte velden formulier tonen',
      'always_show_required_fields_help':
          'Toon het verplichte velden formulier altijd bij het afrekenen',
      'flutter_web_warning':
          'Voor de beste prestaties raden we u aan de nieuwe web-app of de desktop-app te gebruiken',
      'rappen_rounding': 'Afronden op 5 cent',
      'rappen_rounding_help': 'Rond het bedrag af op 5 cent',
      'check_credentials': 'Controleer inloggegevens',
      'valid_credentials': 'De legitimatiegegevens zijn geldig',
      'invalid_credentials': 'Deze inloggegevens zijn niet bij ons bekend',
      'e_quote': 'E-offerte',
      'e_credit': 'E-krediet',
      'e_purchase_order': 'E-inkooporder',
      'valid_vat_number': 'Geldig BTW-nummer',
      'use_available_payments': 'Gebruik beschikbare betalingen',
      'test_email_sent': 'E-mail succesvol verzonden',
      'send_test_email': 'Verstuur teste-mail',
      'gateway_type': 'Type betaalprovider',
      'please_select_an_invoice_or_credit': 'Selecteer een factuur of tegoed',
      'mobile_version': 'Mobiele versie',
      'venmo': 'Venmo',
      'mercado_pago': 'Mercado Pago',
      'my_bank': 'Mijn bank',
      'pay_later': 'Betaal later',
      'email_report': 'E-mailrapport',
      'host': 'Host',
      'port': 'Poort',
      'encryption': 'Encryptie',
      'local_domain': 'Lokaal domein',
      'verify_peer': 'Verifieer versleutelde verbinding',
      'username': 'Gebruikersnaam',
      'nordigen_help':
          'Let op: voor het koppelen van een account is een GoCardless/Nordigen API-sleutel vereist',
      'participant_name': 'Naam deelnemer',
      'yodlee_regions': 'Regio\'s: VS, VK, Australië en India',
      'nordigen_regions': 'Regio\'s: Europa en VK',
      'select_provider': 'Selecteer Aanbieder',
      'payment_type_credit': 'Betalingstype krediet',
      'payment_type_debit': 'Betalingswijze Debet',
      'send_emails_to': 'Stuur e-mails naar',
      'primary_contact': 'Primaire contactpersoon',
      'all_contacts': 'Alle contacten',
      'insert_below': 'Vul hieronder in',
      'ar_detailed': 'Debiteuren gedetailleerd',
      'ar_summary': 'Overzicht debiteuren',
      'client_sales': 'Verkoop van klanten',
      'tax_summary': 'Belastingoverzicht',
      'user_sales': 'Gebruikersverkoop',
      'run_template': 'Sjabloon toepassen',
      'task_extension_banner':
          'Voeg de Chrome-extensie toe om uw taken te beheren',
      'watch_video': 'Bekijk video',
      'view_extension': 'Bekijk Extensie',
      'reactivate_email': 'E-mail opnieuw activeren',
      'email_reactivated': 'E-mail opnieuw geactiveerd',
      'template_help': 'Schakel het gebruik van het ontwerp als sjabloon in',
      'delivery_note_design': 'Ontwerp van leveringsbon',
      'statement_design': 'Ontwerp van samenvatting',
      'payment_receipt_design': 'Ontwerp van betalingsontvangst',
      'payment_refund_design': 'Ontwerp van terugbetaling',
      'quarter': 'Kwartaal',
      'item_description': 'product beschrijving',
      'task_item': 'Taakitem',
      'record_state': 'Recordstatus',
      'last_login': 'Laatste login',
      'save_files_to_this_folder': 'Sla bestanden op in deze map',
      'downloads_folder': 'Map Downloads',
      'total_invoiced_quotes': 'Gefactureerde offertes',
      'total_invoice_paid_quotes': 'Factuur betaalde offertes',
      'downloads_folder_does_not_exist': 'De downloadmap bestaat niet :value',
      'user_logged_in_notification': 'Gebruiker ingelogd melding',
      'user_logged_in_notification_help':
          'Stuur een e-mail wanneer u inlogt vanaf een nieuwe locatie',
      'client_contact': 'Klantcontact',
      'expense_status_4': 'Onbetaald',
      'expense_status_5': 'Betaald',
      'recurring': 'Terugkerend',
      'ziptax_help':
          'Let op: deze functie vereist een Zip-Tax API-sleutel om de Amerikaanse omzetbelasting op adres op te zoeken',
      'cache_data': 'Cachegegevens',
      'unknown': 'Onbekend',
      'webhook_failure': 'Webhook-fout',
      'email_opened': 'E-mail geopend',
      'email_delivered': 'E-mail afgeleverd',
      'log': 'Logboek',
      'individual': 'Individueel',
      'partnership': 'Vennootschap',
      'trust': 'Trustfonds',
      'charity': 'Goed doel',
      'government': 'Overheid',
      'classification': 'Classificatie',
      'click_or_drop_files_here': 'Klik hier of sleep bestanden hierheen',
      'public': 'Openbaar',
      'private': 'Privé',
      'image': 'Afbeelding',
      'other': 'Overig',
      'hash': 'Hash',
      'linked_to': 'Gekoppeld aan',
      'file_saved_in_path': 'Het bestand is opgeslagen in :path',
      'unlinked_transactions': 'Succesvol :count transacties ontkoppeld',
      'unlinked_transaction': 'Transactie ontkoppeld',
      'unlink': 'Koppel los',
      'view_dashboard_permission':
          'Geef de gebruiker toegang tot het dashboard, waarbij de beschikbare rechten bepalen welke gegevens zij kunnen zien',
      'is_tax_exempt': 'Vrijgesteld van belasting',
      'district': 'Wijk',
      'region': 'Regio',
      'county': 'District',
      'tax_details': 'Belastinggegevens',
      'activity_10_online':
          ':contact heeft betaling uitgevoerd :payment voor factuur :invoice voor :client',
      'activity_10_manual':
          ':user heeft betaling :payment ingevoerd voor factuur :invoice voor :client',
      'default_payment_type': 'Standaard betalingstype',
      'admin_initiated_payments': 'Door de beheerder geïnitieerde betalingen',
      'admin_initiated_payments_help':
          'Ondersteuning voor het invoeren van een betaling in het adminportaal zonder factuur',
      'use_mobile_to_manage_plan':
          'Gebruik de instellingen van uw telefoonabonnement om uw abonnement te beheren',
      'show_task_billable': 'Toon factureerbare taken',
      'credit_item': 'Kredietartikel',
      'files': 'Bestanden',
      'camera': 'Camera',
      'gallery': 'Galerij',
      'email_count_invoices': 'E-mail :count -facturen',
      'project_location': 'Project Locatie',
      'invoice_task_item_description': 'Factuurtaak Itembeschrijving',
      'invoice_task_item_description_help':
          'Voeg de artikelbeschrijving toe aan de factuurregels',
      'next_send_time': 'Volgende verzendtijd',
      'uploaded_certificate': 'Certificaat succesvol geüpload',
      'certificate_set': 'Certificaat ingesteld',
      'certificate_not_set': 'Certificaat niet ingesteld',
      'passphrase_set': 'Wachtwoordzin ingesteld',
      'passphrase_not_set': 'Wachtwoordzin niet ingesteld',
      'upload_certificate': 'Certificaat uploaden',
      'certificate_passphrase': 'Wachtwoordzin voor certificaat',
      'rename': 'Hernoem',
      'renamed_document': 'Document succesvol hernoemd',
      'e_invoice': 'E-factuur',
      'light_dark_mode': 'Lichte-/donkere modus',
      'activities': 'Activiteiten',
      'routing_id': 'Routerings-ID',
      'enable_e_invoice': 'E-factuur activeren',
      'e_invoice_type': 'E-factuur type',
      'e_quote_type': 'Type e-offerte',
      'reduced_tax': 'Verlaagde belasting',
      'override_tax': 'Belasting overschrijven',
      'zero_rated': 'Nul nominaal',
      'reverse_tax': 'Omgekeerde belasting',
      'updated_tax_category': 'Belastingscategorie succesvol geüpdatet',
      'updated_tax_categories': 'Belastingscategorieën succesvol geüpdatet',
      'set_tax_category': 'Belastingscategorie ingesteld',
      'payment_manual': 'Betalingsaanwijzingen',
      'tax_category': 'Belastingcategorie',
      'physical_goods': 'Fysieke goederen',
      'digital_products': 'Digitale producten',
      'services': 'Diensten',
      'shipping': 'Verzending',
      'tax_exempt': 'Vrijgesteld van belasting',
      'reduced_rate': 'Gereduceerd tarief',
      'tax_all': 'Belasting allemaal',
      'tax_selected': 'Belasting geselecteerd',
      'version': 'versie',
      'seller_subregion': 'Verkoper Subregio',
      'calculate_taxes': 'Belastingen berekenen',
      'calculate_taxes_help':
          'Bereken automatisch belastingen bij het opslaan van facturen',
      'admin': 'Admin',
      'owner': 'Eigenaar',
      'link_expenses': 'Kosten koppelen',
      'converted_client_balance': 'Geconverteerd klantensaldo',
      'converted_payment_balance': 'Geconverteerd betalingssaldo',
      'total_hours': 'Totaal aantal uren',
      'date_picker_hint': 'Gebruik +days om de datum in de toekomst te zetten',
      'browser_pdf_viewer': 'Gebruik Browser PDF-viewer',
      'browser_pdf_viewer_help':
          'Waarschuwing: voorkomt interactie met de app via de pdf',
      'increase_prices': 'Verhoog de prijzen',
      'update_prices': 'Prijzen bijwerken',
      'incresed_prices':
          'Met succes in de wachtrij geplaatste prijzen worden verhoogd',
      'updated_prices':
          'Succesvol in de wachtrij geplaatste prijzen worden geüpdatet',
      'bacs': 'BACS-incasso',
      'api_token': 'API-token',
      'api_key': 'API sleutel',
      'endpoint': 'Eindpunt',
      'billable': 'Factureerbare uren',
      'not_billable': 'Niet factureerbaar',
      'allow_billable_task_items': 'Factureerbare taakitems toestaan',
      'allow_billable_task_items_help':
          'Schakel configureren in welke taakitems worden gefactureerd',
      'show_task_item_description': 'Beschrijving taakitem weergeven',
      'show_task_item_description_help':
          'Schakel het specificeren van taakitembeschrijvingen in',
      'email_record': 'E-mailrecord',
      'invoice_product_columns': 'Factuurproductkolommen',
      'quote_product_columns': 'Citeer productkolommen',
      'minimum_payment_amount': 'Minimum betalingsbedrag',
      'client_initiated_payments': 'Door de klant geïnitieerde betalingen',
      'client_initiated_payments_help':
          'Ondersteuning bij het uitvoeren van een betaling in het klantenportaal zonder factuur',
      'share_invoice_quote_columns': 'Deel factuur-/offertekolommen',
      'cc_email': 'CC-e-mail',
      'payment_balance': 'Betalingssaldo',
      'view_report_permission':
          'Geef de gebruiker toegang tot de rapporten, gegevens zijn beperkt tot de beschikbare machtigingen',
      'activity_138': 'Betaling :payment is gemaild naar :client',
      'one_time_products': 'Eenmalige producten',
      'optional_one_time_products': 'Optionele eenmalige producten',
      'required': 'Vereist',
      'hidden': 'Verborgen',
      'payment_links': 'Betaallinks',
      'action': 'Actie',
      'upgrade_to_paid_plan_to_schedule':
          'Upgrade naar een betaald abonnement om schema\'s te maken',
      'next_run': 'Volgende run',
      'all_clients': 'Alle klanten',
      'show_aging_table': 'Verouderingstabel tonen',
      'show_payments_table': 'Toon betalingstabel',
      'only_clients_with_invoices': 'Alleen klanten met facturen',
      'email_statement': 'E-mail verklaring',
      'once': 'Eenmalig',
      'schedule': 'Schema',
      'schedules': 'Schema\'s',
      'new_schedule': 'Nieuw schema',
      'edit_schedule': 'Schema bewerken',
      'created_schedule': 'Schema gemaakt',
      'updated_schedule': 'Schema is bijgewerkt',
      'archived_schedule': 'Schema is gearchiveerd',
      'deleted_schedule': 'Schema is succesvol verwijderd',
      'removed_schedule': 'Schema is succesvol verwijderd',
      'restored_schedule': 'Schema is hersteld',
      'search_schedule': 'Zoek schema',
      'search_schedules': 'Zoek schema\'s',
      'archive_payment': 'Betaling archiveren',
      'archive_invoice': 'Factuur archiveren',
      'archive_quote': 'Archiveer offerte',
      'archive_credit': 'Creditfactuur archiveren',
      'archive_task': 'Archiveer taak',
      'archive_client': 'Klant archiveren',
      'archive_project': 'Archiveer project',
      'archive_expense': 'Archiveer uitgave',
      'restore_payment': 'Herstel betaling',
      'restore_invoice': 'Herstel factuur',
      'restore_quote': 'Herstel offerte',
      'restore_credit': 'Herstel creditfactuur',
      'restore_task': 'Herstel taak',
      'restore_client': 'Herstel klant',
      'restore_project': 'Herstel project',
      'restore_expense': 'Herstel uitgave',
      'archive_vendor': 'Archiveer Leverancier',
      'restore_vendor': 'Herstel Leverancier',
      'create_product': 'Product toevoegen',
      'update_product': 'Product bijwerken',
      'delete_product': 'Verwijder product',
      'restore_product': 'Herstel product',
      'archive_product': 'Product archiveren',
      'create_purchase_order': 'Inkooporder maken',
      'update_purchase_order': 'Inkooporder bijwerken',
      'delete_purchase_order': 'Verwijder inkooporder',
      'restore_purchase_order': 'Herstel inkooporder',
      'archive_purchase_order': 'Archiveer inkooporder',
      'sent_invoice': 'Factuur verzonden',
      'sent_quote': 'Verzonden offerte',
      'sent_credit': 'Verzonden tegoed',
      'sent_purchase_order': 'Inkooporder verzonden',
      'image_url': 'Afbeeldings-URL',
      'max_quantity': 'Maximale hoeveelheid',
      'test_url': 'Test-URL',
      'auto_bill_help_off': 'Optie wordt niet getoond',
      'auto_bill_help_optin': 'Optie wordt weergegeven maar niet geselecteerd',
      'auto_bill_help_optout': 'Optie wordt weergegeven en geselecteerd',
      'auto_bill_help_always': 'Optie wordt niet getoond',
      'payment_methods': 'Betaalmethode',
      'view_all': 'Bekijk alles',
      'edit_all': 'Alles bewerken',
      'accept_purchase_order_number': 'Accepteer inkoopordernummer',
      'accept_purchase_order_number_help':
          'Stel klanten in staat om een PO-nummer op te geven bij het goedkeuren van een offerte',
      'from_email': 'Van e-mail',
      'show_preview': 'Toon voorbeeld',
      'show_paid_stamp': 'Betaalde zegel tonen',
      'show_shipping_address': 'Leveringsadres weergeven',
      'no_documents_to_download':
          'Er zijn geen documenten in de geselecteerde records om te downloaden',
      'pixels': 'Pixels',
      'logo_size': 'Logo-formaat',
      'postal_city': 'Postcode/stad',
      'failed': 'Mislukt',
      'client_contacts': 'Klantencontacten',
      'sync_from': 'Synchroniseren van',
      'inventory_threshold': 'Voorraaddrempel',
      'hour': 'Uur',
      'emailed_statement':
          'Verklaring in wachtrij geplaatst om te worden verzonden',
      'show_email_footer': 'Toon e-mailvoettekst',
      'invoice_task_hours': 'Gewerkte uren factureren',
      'invoice_task_hours_help': 'Voeg de uren toe aan de factuurregelitems',
      'auto_bill_standard_invoices': 'Standaardfacturen automatisch incasseren',
      'auto_bill_recurring_invoices':
          'Terugkerende facturen automatisch incasseren',
      'email_alignment': 'E-mailuitlijning',
      'pdf_preview_location': 'Pdf-voorbeeldlocatie',
      'mailgun': 'Mailgun',
      'postmark': 'Postmark',
      'microsoft': 'Microsoft',
      'click_plus_to_create_record': 'Klik op + om een record te maken',
      'last365_days': 'Afgelopen 365 dagen',
      'import_design': 'Ontwerp importeren',
      'imported_design': 'Ontwerp geïmporteerd',
      'invalid_design': 'Het ontwerp is ongeldig, de :value sectie ontbreekt',
      'setup_wizard_logo': 'Wilt u uw logo uploaden?',
      'upload': 'Uploaden',
      'installed_version': 'Geïnstalleerde versie',
      'notify_vendor_when_paid':
          'Leverancier op de hoogte stellen wanneer betaald',
      'notify_vendor_when_paid_help':
          'Stuur een e-mail naar de leverancier wanneer de onkosten zijn gemarkeerd als betaald',
      'update_payment': 'Betaling bijwerken',
      'markup': 'Opmaak',
      'purchase_order_created': 'Inkooporder aangemaakt',
      'purchase_order_sent': 'Inkooporder verzonden',
      'purchase_order_viewed': 'Inkooporder bekeken',
      'purchase_order_accepted': 'Inkooporder geaccepteerd',
      'credit_payment_error':
          'Het kredietbedrag mag niet hoger zijn dan de betaling',
      'klarna': 'Klarna',
      'convert_payment_currency_help':
          'Stel een wisselkoers in bij het invoeren van een handmatige betaling',
      'convert_expense_currency_help':
          'Stel een wisselkoers in bij het aanmaken van een uitgave',
      'matomo_url': 'Matomo-URL',
      'matomo_id': 'Matomo Id',
      'action_add_to_invoice': 'Toevoegen aan factuur',
      'online_payment_email_help':
          'Stuur een e-mail wanneer een online betaling is gedaan',
      'manual_payment_email_help':
          'Stuur een e-mail bij het handmatig invoeren van een betaling',
      'mark_paid_payment_email_help':
          'Stuur een e-mail wanneer u een factuur als betaald markeert',
      'delete_project': 'Verwijder project',
      'linked_transaction': 'Succesvol gekoppelde transactie',
      'link_payment': 'Betaling koppelen',
      'link_expense': 'Link kosten',
      'lock_invoiced_tasks': 'Gefactureerde taken vergrendelen',
      'lock_invoiced_tasks_help':
          'Voorkom dat taken worden bewerkt nadat ze zijn gefactureerd',
      'registration_required': 'Registratie verplicht',
      'registration_required_help': 'Vereisen dat klanten zich registreren',
      'use_inventory_management': 'Gebruik Voorraadbeheer',
      'use_inventory_management_help':
          'Vereisen dat producten op voorraad zijn',
      'optional_products': 'Optionele producten',
      'optional_recurring_products': 'Optionele terugkerende producten',
      'convert_matched': 'Overzetten',
      'auto_billed_invoice':
          'Factuur in wachtrij geplaatst om automatisch te worden gefactureerd',
      'auto_billed_invoices':
          'Facturen in de wachtrij geplaatst om automatisch te worden gefactureerd',
      'operator': 'Exploitant',
      'value': 'Waarde',
      'is': 'Is',
      'contains': 'Bevat',
      'starts_with': 'Begint met',
      'is_empty': 'Is leeg',
      'add_rule': 'Regel toevoegen',
      'match_all_rules': 'Overeenkomen met alle regels',
      'match_all_rules_help':
          'Alle criteria moeten overeenkomen om de regel toe te passen',
      'auto_convert_help':
          'Zet gekoppelde transacties automatisch om in onkosten',
      'rules': 'Reglement',
      'transaction_rule': 'Transactieregel',
      'transaction_rules': 'Transactieregels',
      'new_transaction_rule': 'Nieuwe transactieregel',
      'edit_transaction_rule': 'Transactieregel bewerken',
      'created_transaction_rule': 'Regel gemaakt',
      'updated_transaction_rule': 'Transactieregel geüpdatet',
      'archived_transaction_rule': 'Gearchiveerde transactieregel',
      'deleted_transaction_rule': 'Transactieregel succesvol verwijderd',
      'removed_transaction_rule': 'Transactieregel is verwijderd',
      'restored_transaction_rule': 'Transactieregel hersteld',
      'search_transaction_rule': 'Zoek transactieregel',
      'search_transaction_rules': 'Zoek transactieregels',
      'save_as_default_terms': 'Opslaan als standaardvoorwaarden',
      'save_as_default_footer': 'Bewaar als standaard voettekst',
      'auto_sync': 'Automatisch synchroniseren',
      'refresh_accounts': 'Ververs accounts',
      'upgrade_to_connect_bank_account':
          'Upgrade naar Enterprise om uw bankrekening te koppelen',
      'click_here_to_connect_bank_account':
          'Klik hier om uw bankrekening te koppelen',
      'disable_2fa': 'Schakel 2FA uit',
      'change_number': 'Wijzig Nummer',
      'resend_code': 'Code nogmaals versturen',
      'base_type': 'Basistype',
      'category_type': 'Categorietype',
      'bank_transaction': 'Transactie',
      'bulk_print': 'Druk PDF af',
      'vendor_postal_code': 'Leverancier Postcode',
      'preview_location': 'Voorbeeldlocatie',
      'bottom': 'Onderkant',
      'side': 'Kant',
      'pdf_preview': 'PDF-voorbeeld',
      'long_press_to_select': 'Lang indrukken om te selecteren',
      'purchase_order_number': 'Aankoop ordernummer',
      'purchase_order_item': 'Artikel inkooporder',
      'would_you_rate_the_app': 'Wilt u de app beoordelen?',
      'include_deleted': 'Inclusief verwijderd',
      'include_deleted_help': 'Neem verwijderde records op in rapporten',
      'due_on': 'Verschuldigd op',
      'converted_transactions': 'Transacties succesvol geconverteerd',
      'created_bank_account': 'Bankrekening toegevoeg