// Autogenerated from Pigeon (v10.0.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation
#if os(iOS)
import Flutter
#elseif os(macOS)
import FlutterMacOS
#else
#error("Unsupported platform.")
#endif

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)"
  ]
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}
/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol UserDefaultsAPI {
  func setAppGroup(appGroup: String) throws
  func get(key: String, appGroup: String?) throws -> Any?
  func getString(key: String, appGroup: String?) throws -> String?
  func getBool(key: String, appGroup: String?) throws -> Bool?
  func getInt(key: String, appGroup: String?) throws -> Int64?
  func getDouble(key: String, appGroup: String?) throws -> Double?
  func getMap(key: String, appGroup: String?) throws -> [AnyHashable: Any?]?
  func set(key: String, value: Any, appGroup: String?) throws
  func setString(key: String, value: String, appGroup: String?) throws
  func setBool(key: String, value: Bool, appGroup: String?) throws
  func setInt(key: String, value: Int64, appGroup: String?) throws
  func setDouble(key: String, value: Double, appGroup: String?) throws
  func setMap(key: String, value: [AnyHashable: Any?], appGroup: String?) throws
  func remove(key: String, appGroup: String?) throws
  func contains(key: String, appGroup: String?) throws -> Bool
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class UserDefaultsAPISetup {
  /// The codec used by UserDefaultsAPI.
  /// Sets up an instance of `UserDefaultsAPI` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: UserDefaultsAPI?) {
    let setAppGroupChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.setAppGroup", binaryMessenger: binaryMessenger)
    if let api = api {
      setAppGroupChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let appGroupArg = args[0] as! String
        do {
          try api.setAppGroup(appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setAppGroupChannel.setMessageHandler(nil)
    }
    let getChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.get", binaryMessenger: binaryMessenger)
    if let api = api {
      getChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.get(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getChannel.setMessageHandler(nil)
    }
    let getStringChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.getString", binaryMessenger: binaryMessenger)
    if let api = api {
      getStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.getString(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getStringChannel.setMessageHandler(nil)
    }
    let getBoolChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.getBool", binaryMessenger: binaryMessenger)
    if let api = api {
      getBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.getBool(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getBoolChannel.setMessageHandler(nil)
    }
    let getIntChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.getInt", binaryMessenger: binaryMessenger)
    if let api = api {
      getIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.getInt(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getIntChannel.setMessageHandler(nil)
    }
    let getDoubleChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.getDouble", binaryMessenger: binaryMessenger)
    if let api = api {
      getDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.getDouble(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getDoubleChannel.setMessageHandler(nil)
    }
    let getMapChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.getMap", binaryMessenger: binaryMessenger)
    if let api = api {
      getMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.getMap(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      getMapChannel.setMessageHandler(nil)
    }
    let setChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.set", binaryMessenger: binaryMessenger)
    if let api = api {
      setChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let valueArg = args[1]!
        let appGroupArg: String? = nilOrValue(args[2])
        do {
          try api.set(key: keyArg, value: valueArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setChannel.setMessageHandler(nil)
    }
    let setStringChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.setString", binaryMessenger: binaryMessenger)
    if let api = api {
      setStringChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let valueArg = args[1] as! String
        let appGroupArg: String? = nilOrValue(args[2])
        do {
          try api.setString(key: keyArg, value: valueArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setStringChannel.setMessageHandler(nil)
    }
    let setBoolChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.setBool", binaryMessenger: binaryMessenger)
    if let api = api {
      setBoolChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let valueArg = args[1] as! Bool
        let appGroupArg: String? = nilOrValue(args[2])
        do {
          try api.setBool(key: keyArg, value: valueArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setBoolChannel.setMessageHandler(nil)
    }
    let setIntChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.setInt", binaryMessenger: binaryMessenger)
    if let api = api {
      setIntChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let valueArg = args[1] is Int64 ? args[1] as! Int64 : Int64(args[1] as! Int32)
        let appGroupArg: String? = nilOrValue(args[2])
        do {
          try api.setInt(key: keyArg, value: valueArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setIntChannel.setMessageHandler(nil)
    }
    let setDoubleChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.setDouble", binaryMessenger: binaryMessenger)
    if let api = api {
      setDoubleChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let valueArg = args[1] as! Double
        let appGroupArg: String? = nilOrValue(args[2])
        do {
          try api.setDouble(key: keyArg, value: valueArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setDoubleChannel.setMessageHandler(nil)
    }
    let setMapChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.setMap", binaryMessenger: binaryMessenger)
    if let api = api {
      setMapChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let valueArg = args[1] as! [AnyHashable: Any?]
        let appGroupArg: String? = nilOrValue(args[2])
        do {
          try api.setMap(key: keyArg, value: valueArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setMapChannel.setMessageHandler(nil)
    }
    let removeChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.remove", binaryMessenger: binaryMessenger)
    if let api = api {
      removeChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          try api.remove(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      removeChannel.setMessageHandler(nil)
    }
    let containsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.UserDefaultsAPI.contains", binaryMessenger: binaryMessenger)
    if let api = api {
      containsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let keyArg = args[0] as! String
        let appGroupArg: String? = nilOrValue(args[1])
        do {
          let result = try api.contains(key: keyArg, appGroup: appGroupArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      containsChannel.setMessageHandler(nil)
    }
  }
}
