# 2.0.0 change details
Content:
* [Remove context subscription (Breaking change)](#Remove-context-subscription-(Breaking-change))
* [`setState` can do all that. Remove some API (Breaking change)](#`setState`-can-do-all-that-and-more...-Remove-some-API-(Breaking-change))
* [Listen to a ReactiveModel from outside the widget tree](#Listen-to-a-ReactiveModel-from-outside-the-widget-tree)
* [asynchronous dependency injection with `stateAsync`](#asynchronous-dependency-injection-with-`stateAsync`)

# Remove context subscription (Breaking change)
states_rebuilder is based on the observer pattern. To subscribe to an observable we can use :
* One of the four observer Widgets `StateBuilder`, `WhenRebuilder`, `WhenRebuilderOr` and `OnSetStateListener`.
* Using the context parameter when getting the injected ReactiveModel:
```dart
RM.get<Model>(context : context);
```
After building many examples and demo apps with states_rebuilder I found that I rarely used the context to subscribe because using one of the four observer widgets has been the first choice as they gave me more options.


# `setState` can do all that and more... Remove some API (Breaking change)

Do you know when to use :
* `setState` vs `setValue`(removed);
* `state` vs `value`(removed);
* `Inject.future`, `RM.getFuture`(removed), and `future`;
* `Inject.stream`, `RM.getStream`(removed), and `stream`.

Yes, this may seem confusing, and it is the right opportunity to clean the API.

Let's consider this model class that encapsulates all the possible method types found in real life.

```dart
class Model{

  int counter;

  void syncMutableMethod(){
    //mutate some state
    counter++;
  }

  Model syncImmutableMethod(){
    //
    return NewModelState();
  }

  futureMethod  () async {
    await fetchSomething()
  }

  streamMethod () async* {
    yield someThing;
  }
}
```
## 1. Sync state mutation.
Before this update to mutate mutable state we use `setState` and immutable state we use `setValue` and `value` getter.

Now With this 2.0.0 update, we use `setState` and `state` for both mutable and immutable.

1. `state` getter and setter for sync primitives and immutable states
    ```dart
    //use the state getter and setter to mutate primitives and  immutable state
    RM.create(0).state++; // increment 0 to 1 and notify observers
    ```
2. `setState` can do all sync and async mutation for mutable and immutable.
    ```dart
    //get into the model state and mutate a field
    RM.get<Model>().setSate(
      (Model currentState) => currentState.counter++,
    )
    ```
    ```dart
    //call a sync  method from the model state that mutates the state
    RM.get<Model>().setSate(
      (Model currentState) => currentState.syncMutableMethod(),
    )
    ```
    ```dart
    //call a sync method from the model state that returns a new state
    RM.get<Model>().setSate(
      (Model currentState) => currentState.syncImmutableMethod(),
    )
    ```
    ```dart
    //call a future method from the model state (fro both mutable and immutable)
    //set state will await the future and notify observer widgets with all possible ConnectionState.
    //For local ReactiveModels, when all observers are removed from the widget tree, the future will be canceled.
    //For Global ReactiveModel the future will  not canceled until the Injector widget that has injected it is disposed
    RM.get<Model>().setSate(
      (Model currentState) => currentState.futureMethod(),
    )
    ```
    ```dart
    //call a stream method from the model state (fro both mutable and immutable)
    //setState will subscribe to the stream and notify listener.
    //For local ReactiveModels, when all observers are removed from the widget tree, the stream will be canceled.
    //For Global ReactiveModel the stream will  not canceled until the Injector widget that has injected it is disposed
    RM.get<Model>().setSate(
      (Model currentState) => currentState.streamMethod(),
    )
    ```

So with setState, you can do all the 
mutation not mutter the state is mutable or immutable and whether the method returns, object, future, or stream.

As a reminder this what we can do with setState : 

```dart
reactiveModel.setState(
  (current state) => state.increment(),
  //Filter notification with tags
  filterTags: ['Tag1', Enumeration.Tag2],

  //onData, trigger notification from new reactive models with the seeds in the list,
  seeds:['seed1',Enumeration.Seed2 ],

  //set to true, you want to catch error, and not break the app.
  //IF onError is defined, catchError is set to true automatically
  catchError: false 
  
  watch: (Counter counter) {
    //Specify the parts of the state to be monitored so that the notification is not sent unless this part changes
    return counter.count; //if count value is not changed, no notification will be emitted.
  },
  onSetState: (BuildContext context) {
    /* 
    Side effects to be executed after sending notification and before rebuilding the observers. Side effects are navigating, opening the drawer, showing snackBar , ..

    You can use another nested setState here.
    */
  },
  onRebuildState: (BuildContext context) {
    //The same as in onSetState but called after the end rebuild process.
  },

  onData: (BuildContext context, T model){
    //Callback to be executed if the reactive model has data.
  }

  onError: (BuildContext context, dynamic error){
    //Callback to be executed if the reactive model throws an error.

    //It exposed the BuildContext of the last add observer widget. 
    //If no observer is registered yet it will be null

    //You do not have to set the parameter catchError to true. By defining onError parameter 
    //states_rebuilder catches the error by default.
  }
  
  //When a notification is issued, whether to notify all reactive instances of the model
  notifyAllReactiveInstances: true, 
  /*
  If defined, when a new reactive instance issues a notification, it will change the state of the reactive singleton.
  */
  joinSingleton: true,

  //message to be sent to the reactive singleton
  dynamic joinSingletonToNewData,

  //Silent the error if there is no observer registered to the ReactiveModel
  bool silent: false,

  //If the state is future, should await for the existing future or not
  bool shouldAwait : false,
),
```

## Creating a local ReactiveModel from a state.
To limit the rebuild it is wise to create local ReactiveModels. (Local means not injected using `Injector`).
To create a `ReactiveModel` we use the static methods :
```dart
RM.create<Foo>(Foo);// create new ReactiveModel from primitive or objects
RM.future<int>(myFuture); //create from future
RM.stream<int>(myStream); // create from stream

RM.get<Foo>().asNew(mySeed) // create new reactive from an already created ReactiveModel models
```

This is what we have until now. 
The new thing is that we can create future and stream new `ReactiveModel` from the returning of new methods.

```dart
RM.get<Foo>().future<int>(
  (Foo state, Future<Foo> stateAsync){
    return  state.fetchSomeThing();
  }
  initialValue: foo0,
)
```
Here we created a new `ReactiveModel` from the future return from `fetchSomeThing()` method of the foo object.

The future method exposed the current state of `Foo` object and the asynchronous state (`stateAsync`). 

`stateAsync` is useful if you want to await for the current future before firing the `fetchSomeThing` method.

```dart
RM.get<Foo>().future<int>(
  (Foo state, Future<Foo> stateAsync){
    return  stateAsync.then(
      (data) => state.fetchSomeThing(),
    );
  }
  initialValue: foo0,
)
```

Similarly, to create a new `ReactiveModel` from a method that returns a stream we use the stream method.


```dart
RM.get<Foo>().stream<int>(
  (Foo state, StreamSubscription currentSubscription){
    //You can use exposed StreamSubscription of the current stream 
    //(if  any) to close the current stream if you want
    return state.yieldSomeThing(),
    
  }
  initialValue: foo0,
)
```

The API is clearer now, with `setState` you do all.

see example 009 for [immutable](../../examples/009-clean_architecture_todo_mvc_cloud_firestore_immutable_state) and [mutable](../../examples/009-clean_architecture_todo_mvc_mutable_state) state management] in the example folder.

# Listen to a ReactiveModel from outside the widget tree

Some times it is useful to listen to a ReactiveModel from another model outside the widget tree.

  ```dart
  class ModelA{

  } 

  class ModelB {
    //void callback used for unsubscription
    void Function() unsubscribe;
    ModelB(){
      unsubscribe =   RM.get<ModelA>().listenToRM((ReactiveModel<ModelA> modelARM)){
            if(modelARM.hasError){
            //....
            }else if (modelARM.hasData){
            //...
            }

            //or you can use whenConnectionState

        }
    }


   dispose(){
       unsubscribe();
   }
  }
  ```

  In `states_rebuilder` all `ReactiveModel` are automatically disposed when the last observer widget is disposed. To remove a listener at the time you want you can use the void callback return by the `listenToRM`.

# asynchronous dependency injection with `stateAsync`

With states_rebuilder as dependency injection you can :
* Inject a primitive value or enum :
    ```dart
    Inject<int>(()=> 10);
    ```
* Inject service classes :
    ```dart
    Inject<Foo>(()=> Foo());
    ```
* Inject service classes via interface (loose dependence)
    ```dart
    Inject<FooInterface>(()=> Foo());
    ```
* Inject devolvement dependent implementation
    ```dart
    Inject<FooInterface>.interface({
        'dev' :() => FooDev(),
        'prod' :() => FooProd(),
    });
    ```
* Inject future and streams
    ```dart
    Inject<Foo>(()=> fooFuture()),
    Inject<Foo>(()=> fooStream()),
    ```
To consume any of the above injected model you can use :
```dart
IN.get<Foo>(); // to get the injected instance (equivalent to Injector.get<Foo>())
RM.get<Foo>(); // to get the injected instance decorated with ReactiveModel  (equivalent to Injector.getAsReactive<Foo>())
```

The limitation is that we can not inject a future that depended on another future until we are sure that the firs future resolves.

Before this update to inject coupled futures we use this pattern:

```dart
Injector(
    //Inject the first future
    inject : [ Inject<FutureA>.future( ()=> futureA() ) ],
    builder : (context){
        //Make the app await for the futureA to resolve
        return WhenRebuilderOr(
            observe : ()=> RM.get<FutureA>(),
            onWaiting : () => CircularProgressIndicator(),
            builder :(context, futureARM) {
                //Inject the second future after futureA is ready
                return Injector(
                    inject : [Inject(()=> futureB( futureARM.value ))],
                    builder : (context){
                        //await for the second future 
                        return WhenRebuilderOr(
                            observe : ()=> RM.get<FutureB>(),
                            onWaiting : () => CircularProgressIndicator(),
                            builder :(context, futureBRM) {
                                //
                                //Here we are ready to use the value of the futureA and futureB are ready
                                
                                final futureAValue = IN.get<FutureA>();
                                final futureBValue = IN.get<FutureB>();
                            }
                    )
            }
        )
    }
)
```

Imagine you have three dependent future!!

In a real situation it is common to have three dependent futures :
* A plugging (ex: SharedPreferences ).
* A repository that uses the plugging. We must wait until it is initialized before we can inject the repository.
* A service class that used the repository. We can not inject it before both futures are ready.

With this update, you can easily inject dependent asynchronous objects.

Let's reproduce the above example with tree futures:

```dart
Injector(
    inject: [
        //Inject the first future
        Inject<FutureA>.future(() => futureA()),
        //Inject the second future
        Inject<FutureB>.future(
          () async => futureB(await RM.get<FutureA>().stateAsync),
        ),
        Inject<FutureC>.future(
          () async => futureC(await RM.get<FutureB>().stateAsync),
        ),
    ],
    builder: (context) {
        return WhenRebuilderOr(
        observe: () => RM.get<FutureC>(),
        onWaiting: () => CircularProgressIndicator(),
        builder: (context, futureCRM) {
            //
            //here the three future are resolved and their values can be obtained
            final futureAValue = IN.get<FutureA>();
            final futureBValue = IN.get<FutureB>();
            final futureCValue = IN.get<FutureC>();
          },
        );
    },
),
```
Notes that the three future are available to be used in all the app not only the third future.

In this version, I added the `stateAsync` getter which is the value of the ReactiveModel wrapped inside a Future.

Here is a working demo example of a plugging, repository, service dependent futures:
```dart
void main() {
  runApp(MaterialApp(home: App()));
}

class Plugging {

  Plugging _instance;
  final String message = 'Hi I am Plugging';


  Future<Plugging> init() {
    return Future.delayed(
      Duration(seconds: 2),
      () {
        if (Random().nextBool()) {
          throw Exception('ERROR');
        }
        _instance = Plugging();
        return _instance;
      },
    );
  }

  Future<int> getSecretNumber() {
    return Future.delayed(Duration(seconds: 1), () => 700007);
  }
}

class Repository {
  Repository(this.plugging);

  final Plugging plugging;
  final String message = 'Repository';

  Future<String> fetchSecretNumber() async {
    await Future.delayed(Duration(seconds: 1));
    final secret = await plugging.getSecretNumber();
    return 'The Secret Number is $secret';
  }
}

class SecretService {
  SecretService(this.repository);

  final Repository repository;

  Future<String> fetchSecretNumber() async {
    final secret = await repository.fetchSecretNumber();
    return 'Secret from service : $secret';
  }
}

class App extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Injector(inject: [
      Inject.future(() => Plugging().init()),
      Inject.future(
        () async {
          final plugging = await RM.get<Plugging>().stateAsync;
          await Future.delayed(Duration(seconds: 1));
          return Repository(plugging);
        },
      ),
      Inject.future(
        () async => SecretService(
          await RM.get<Repository>().stateAsync,
        ),
      ),
    ], builder: (context) => HomePage(),
    );
  }
}

class HomePage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(),
      body: Center(
        child: Column(
          children: [
            WhenRebuilder<Plugging>(
              onIdle : ()=> Container(),
              observe: () => RM.get<Plugging>(),
              onWaiting: () => CircularProgressIndicator(),
              onError: (e) => Text('${e.message}'),
              builder: (context, pluggingRM) {
                return Text('${pluggingRM.value.message}');
              },
            ),
            WhenRebuilderOr<Repository>(
              observe: () => RM.get<Repository>(),
              onWaiting: () => CircularProgressIndicator(),
              onError: (e) => Text('${e.message}'),
              builder: (context, repositoryRM) {
                return Text('${repositoryRM.value.message}');
              },
            ),
            WhenRebuilderOr<String>(
              observe: () => RM.get<SecretService>().future(
                (SecretService state, Future<SecretService> stateAsync){
                  stateAsync.then(
                      (SecretService data) => data.fetchSecretNumber(),
                  )
                }
              ),
              onWaiting: () => CircularProgressIndicator(),
              onError: (e) => Text('${e.message}'),
              builder: (context, secretServiceRM) {
                return Text('${secretServiceRM.value}');
              },
            )
          ],
          mainAxisAlignment: MainAxisAlignment.spaceAround,
          crossAxisAlignment: CrossAxisAlignment.center,
        ),
      ),
    );
  }
}
```
