[![Build Status](https://github.com/dart-lang/native/actions/workflows/jnigen.yaml/badge.svg)](https://github.com/dart-lang/native/actions/workflows/jnigen.yaml)
[![Coverage Status](https://coveralls.io/repos/github/dart-lang/native/badge.svg?branch=main)](https://coveralls.io/github/dart-lang/native?branch=main)
[![pub package](https://img.shields.io/pub/v/jni.svg)](https://pub.dev/packages/jni)
[![package publisher](https://img.shields.io/pub/publisher/jni.svg)](https://pub.dev/packages/jni/publisher)

# jni

This is a support library to access JNI from Dart / Flutter code. This provides the common infrastructure to bindings generated by [jnigen](https://pub.dev/packages/jnigen), as well as some utility methods.

This library contains:

* Functions to access the JNIEnv and JavaVM variables from JNI, and wrapper functions to those provided by JNI. JNIEnv is exposed via `GlobalJniEnv` type which provides a thin abstraction over JNIEnv, so that it can be used from multiple threads.
* Functions to spawn a JVM on desktop platforms (`Jni.spawn`).
* Some Android-specific helpers (get application context and current activity references).
* `JObject` class, which provides base class for classes generated by jnigen.
* Commonly used Java classes like `JList`, `JMap`, `JInteger`, ...

Apart from being the base library for code generated by `jnigen` this can also be used for one-off uses of the JNI and debugging. __To generate type-safe bindings from Java libraries, use `jnigen`.__

## Documentation
The test/ directory contains files with comments explaining the basics of this module, and the example/ directory contains a flutter example which also touches some Android-specifics.

Using this library assumes some familiarity with JNI - it's threading model and object references, among other things.

## Migrating to 0.8.0

Check the [changelog](https://github.com/dart-lang/native/blob/main/pkgs/jni/CHANGELOG.md#080-wip).

The API for standalone use of `package:jni` (without `package:jnigen`) has
changed to use `JClass.forName` for finding classes. Find the methods and fields
by accessing them from the retrieved `JClass`. For example find an instance
method with a name and a signature using `jClass.instanceMethodId`. Then you can
`call` the resulting `JInstanceMethodId` to call the instance method.
