part of '../bidi.dart';

/// Unicode character categories.
enum CharacterCategory {
  /// Letter, Uppercase
  lu,

  /// Letter, Lowercase
  ll,

  /// Letter, Titlecase
  lt,

  /// Letter, Modifier
  lm,

  /// Letter, Other
  lo,

  /// Mark, Nonspacing
  mn,

  /// Mark, Spacing Combining
  mc,

  /// Mark, Enclosing
  me,

  /// Number, Decimal Digit
  nd,

  /// Number, Letter
  nl,

  /// Number, Other
  no,

  /// Punctuation, Connector
  pc,

  /// Punctuation, Dash
  pd,

  /// Punctuation, Open
  ps,

  /// Punctuation, Close
  pe,

  /// Punctuation, Initial quote (may behave like Ps or Pe depending on usage)
  pi,

  /// Punctuation, Final quote (may behave like Ps or Pe depending on usage)
  pf,

  /// Punctuation, Other
  po,

  /// Symbol, Math
  sm,

  /// Symbol, Currency
  sc,

  /// Symbol, Modifier
  sk,

  /// Symbol, Other
  so,

  /// Separator, Space
  zs,

  /// Separator, Line
  zl,

  /// Separator, Paragraph
  zp,

  /// Other, Control
  cc,

  /// Other, Format
  cf,

  /// Other, Surrogate
  cs,

  /// Other, Private Use
  co,

  /// Other, Not Assigned (no characters in the file have this property)
  cn
}

/// Character Categories.
const characterCategories = <int, CharacterCategory>{
  65: CharacterCategory.lu,
  66: CharacterCategory.lu,
  67: CharacterCategory.lu,
  68: CharacterCategory.lu,
  69: CharacterCategory.lu,
  70: CharacterCategory.lu,
  71: CharacterCategory.lu,
  72: CharacterCategory.lu,
  73: CharacterCategory.lu,
  74: CharacterCategory.lu,
  75: CharacterCategory.lu,
  76: CharacterCategory.lu,
  77: CharacterCategory.lu,
  78: CharacterCategory.lu,
  79: CharacterCategory.lu,
  80: CharacterCategory.lu,
  81: CharacterCategory.lu,
  82: CharacterCategory.lu,
  83: CharacterCategory.lu,
  84: CharacterCategory.lu,
  85: CharacterCategory.lu,
  86: CharacterCategory.lu,
  87: CharacterCategory.lu,
  88: CharacterCategory.lu,
  89: CharacterCategory.lu,
  90: CharacterCategory.lu,
  192: CharacterCategory.lu,
  193: CharacterCategory.lu,
  194: CharacterCategory.lu,
  195: CharacterCategory.lu,
  196: CharacterCategory.lu,
  197: CharacterCategory.lu,
  198: CharacterCategory.lu,
  199: CharacterCategory.lu,
  200: CharacterCategory.lu,
  201: CharacterCategory.lu,
  202: CharacterCategory.lu,
  203: CharacterCategory.lu,
  204: CharacterCategory.lu,
  205: CharacterCategory.lu,
  206: CharacterCategory.lu,
  207: CharacterCategory.lu,
  208: CharacterCategory.lu,
  209: CharacterCategory.lu,
  210: CharacterCategory.lu,
  211: CharacterCategory.lu,
  212: CharacterCategory.lu,
  213: CharacterCategory.lu,
  214: CharacterCategory.lu,
  216: CharacterCategory.lu,
  217: CharacterCategory.lu,
  218: CharacterCategory.lu,
  219: CharacterCategory.lu,
  220: CharacterCategory.lu,
  221: CharacterCategory.lu,
  222: CharacterCategory.lu,
  256: CharacterCategory.lu,
  258: CharacterCategory.lu,
  260: CharacterCategory.lu,
  262: CharacterCategory.lu,
  264: CharacterCategory.lu,
  266: CharacterCategory.lu,
  268: CharacterCategory.lu,
  270: CharacterCategory.lu,
  272: CharacterCategory.lu,
  274: CharacterCategory.lu,
  276: CharacterCategory.lu,
  278: CharacterCategory.lu,
  280: CharacterCategory.lu,
  282: CharacterCategory.lu,
  284: CharacterCategory.lu,
  286: CharacterCategory.lu,
  288: CharacterCategory.lu,
  290: CharacterCategory.lu,
  292: CharacterCategory.lu,
  294: CharacterCategory.lu,
  296: CharacterCategory.lu,
  298: CharacterCategory.lu,
  300: CharacterCategory.lu,
  302: CharacterCategory.lu,
  304: CharacterCategory.lu,
  306: CharacterCategory.lu,
  308: CharacterCategory.lu,
  310: CharacterCategory.lu,
  313: CharacterCategory.lu,
  315: CharacterCategory.lu,
  317: CharacterCategory.lu,
  319: CharacterCategory.lu,
  321: CharacterCategory.lu,
  323: CharacterCategory.lu,
  325: CharacterCategory.lu,
  327: CharacterCategory.lu,
  330: CharacterCategory.lu,
  332: CharacterCategory.lu,
  334: CharacterCategory.lu,
  336: CharacterCategory.lu,
  338: CharacterCategory.lu,
  340: CharacterCategory.lu,
  342: CharacterCategory.lu,
  344: CharacterCategory.lu,
  346: CharacterCategory.lu,
  348: CharacterCategory.lu,
  350: CharacterCategory.lu,
  352: CharacterCategory.lu,
  354: CharacterCategory.lu,
  356: CharacterCategory.lu,
  358: CharacterCategory.lu,
  360: CharacterCategory.lu,
  362: CharacterCategory.lu,
  364: CharacterCategory.lu,
  366: CharacterCategory.lu,
  368: CharacterCategory.lu,
  370: CharacterCategory.lu,
  372: CharacterCategory.lu,
  374: CharacterCategory.lu,
  376: CharacterCategory.lu,
  377: CharacterCategory.lu,
  379: CharacterCategory.lu,
  381: CharacterCategory.lu,
  385: CharacterCategory.lu,
  386: CharacterCategory.lu,
  388: CharacterCategory.lu,
  390: CharacterCategory.lu,
  391: CharacterCategory.lu,
  393: CharacterCategory.lu,
  394: CharacterCategory.lu,
  395: CharacterCategory.lu,
  398: CharacterCategory.lu,
  399: CharacterCategory.lu,
  400: CharacterCategory.lu,
  401: CharacterCategory.lu,
  403: CharacterCategory.lu,
  404: CharacterCategory.lu,
  406: CharacterCategory.lu,
  407: CharacterCategory.lu,
  408: CharacterCategory.lu,
  412: CharacterCategory.lu,
  413: CharacterCategory.lu,
  415: CharacterCategory.lu,
  416: CharacterCategory.lu,
  418: CharacterCategory.lu,
  420: CharacterCategory.lu,
  422: CharacterCategory.lu,
  423: CharacterCategory.lu,
  425: CharacterCategory.lu,
  428: CharacterCategory.lu,
  430: CharacterCategory.lu,
  431: CharacterCategory.lu,
  433: CharacterCategory.lu,
  434: CharacterCategory.lu,
  435: CharacterCategory.lu,
  437: CharacterCategory.lu,
  439: CharacterCategory.lu,
  440: CharacterCategory.lu,
  444: CharacterCategory.lu,
  452: CharacterCategory.lu,
  455: CharacterCategory.lu,
  458: CharacterCategory.lu,
  461: CharacterCategory.lu,
  463: CharacterCategory.lu,
  465: CharacterCategory.lu,
  467: CharacterCategory.lu,
  469: CharacterCategory.lu,
  471: CharacterCategory.lu,
  473: CharacterCategory.lu,
  475: CharacterCategory.lu,
  478: CharacterCategory.lu,
  480: CharacterCategory.lu,
  482: CharacterCategory.lu,
  484: CharacterCategory.lu,
  486: CharacterCategory.lu,
  488: CharacterCategory.lu,
  490: CharacterCategory.lu,
  492: CharacterCategory.lu,
  494: CharacterCategory.lu,
  497: CharacterCategory.lu,
  500: CharacterCategory.lu,
  502: CharacterCategory.lu,
  503: CharacterCategory.lu,
  504: CharacterCategory.lu,
  506: CharacterCategory.lu,
  508: CharacterCategory.lu,
  510: CharacterCategory.lu,
  512: CharacterCategory.lu,
  514: CharacterCategory.lu,
  516: CharacterCategory.lu,
  518: CharacterCategory.lu,
  520: CharacterCategory.lu,
  522: CharacterCategory.lu,
  524: CharacterCategory.lu,
  526: CharacterCategory.lu,
  528: CharacterCategory.lu,
  530: CharacterCategory.lu,
  532: CharacterCategory.lu,
  534: CharacterCategory.lu,
  536: CharacterCategory.lu,
  538: CharacterCategory.lu,
  540: CharacterCategory.lu,
  542: CharacterCategory.lu,
  544: CharacterCategory.lu,
  546: CharacterCategory.lu,
  548: CharacterCategory.lu,
  550: CharacterCategory.lu,
  552: CharacterCategory.lu,
  554: CharacterCategory.lu,
  556: CharacterCategory.lu,
  558: CharacterCategory.lu,
  560: CharacterCategory.lu,
  562: CharacterCategory.lu,
  570: CharacterCategory.lu,
  571: CharacterCategory.lu,
  573: CharacterCategory.lu,
  574: CharacterCategory.lu,
  577: CharacterCategory.lu,
  579: CharacterCategory.lu,
  580: CharacterCategory.lu,
  581: CharacterCategory.lu,
  582: CharacterCategory.lu,
  584: CharacterCategory.lu,
  586: CharacterCategory.lu,
  588: CharacterCategory.lu,
  590: CharacterCategory.lu,
  880: CharacterCategory.lu,
  882: CharacterCategory.lu,
  886: CharacterCategory.lu,
  895: CharacterCategory.lu,
  902: CharacterCategory.lu,
  904: CharacterCategory.lu,
  905: CharacterCategory.lu,
  906: CharacterCategory.lu,
  908: CharacterCategory.lu,
  910: CharacterCategory.lu,
  911: CharacterCategory.lu,
  913: CharacterCategory.lu,
  914: CharacterCategory.lu,
  915: CharacterCategory.lu,
  916: CharacterCategory.lu,
  917: CharacterCategory.lu,
  918: CharacterCategory.lu,
  919: CharacterCategory.lu,
  920: CharacterCategory.lu,
  921: CharacterCategory.lu,
  922: CharacterCategory.lu,
  923: CharacterCategory.lu,
  924: CharacterCategory.lu,
  925: CharacterCategory.lu,
  926: CharacterCategory.lu,
  927: CharacterCategory.lu,
  928: CharacterCategory.lu,
  929: CharacterCategory.lu,
  931: CharacterCategory.lu,
  932: CharacterCategory.lu,
  933: CharacterCategory.lu,
  934: CharacterCategory.lu,
  935: CharacterCategory.lu,
  936: CharacterCategory.lu,
  937: CharacterCategory.lu,
  938: CharacterCategory.lu,
  939: CharacterCategory.lu,
  975: CharacterCategory.lu,
  978: CharacterCategory.lu,
  979: CharacterCategory.lu,
  980: CharacterCategory.lu,
  984: CharacterCategory.lu,
  986: CharacterCategory.lu,
  988: CharacterCategory.lu,
  990: CharacterCategory.lu,
  992: CharacterCategory.lu,
  994: CharacterCategory.lu,
  996: CharacterCategory.lu,
  998: CharacterCategory.lu,
  1000: CharacterCategory.lu,
  1002: CharacterCategory.lu,
  1004: CharacterCategory.lu,
  1006: CharacterCategory.lu,
  1012: CharacterCategory.lu,
  1015: CharacterCategory.lu,
  1017: CharacterCategory.lu,
  1018: CharacterCategory.lu,
  1021: CharacterCategory.lu,
  1022: CharacterCategory.lu,
  1023: CharacterCategory.lu,
  1024: CharacterCategory.lu,
  1025: CharacterCategory.lu,
  1026: CharacterCategory.lu,
  1027: CharacterCategory.lu,
  1028: CharacterCategory.lu,
  1029: CharacterCategory.lu,
  1030: CharacterCategory.lu,
  1031: CharacterCategory.lu,
  1032: CharacterCategory.lu,
  1033: CharacterCategory.lu,
  1034: CharacterCategory.lu,
  1035: CharacterCategory.lu,
  1036: CharacterCategory.lu,
  1037: CharacterCategory.lu,
  1038: CharacterCategory.lu,
  1039: CharacterCategory.lu,
  1040: CharacterCategory.lu,
  1041: CharacterCategory.lu,
  1042: CharacterCategory.lu,
  1043: CharacterCategory.lu,
  1044: CharacterCategory.lu,
  1045: CharacterCategory.lu,
  1046: CharacterCategory.lu,
  1047: CharacterCategory.lu,
  1048: CharacterCategory.lu,
  1049: CharacterCategory.lu,
  1050: CharacterCategory.lu,
  1051: CharacterCategory.lu,
  1052: CharacterCategory.lu,
  1053: CharacterCategory.lu,
  1054: CharacterCategory.lu,
  1055: CharacterCategory.lu,
  1056: CharacterCategory.lu,
  1057: CharacterCategory.lu,
  1058: CharacterCategory.lu,
  1059: CharacterCategory.lu,
  1060: CharacterCategory.lu,
  1061: CharacterCategory.lu,
  1062: CharacterCategory.lu,
  1063: CharacterCategory.lu,
  1064: CharacterCategory.lu,
  1065: CharacterCategory.lu,
  1066: CharacterCategory.lu,
  1067: CharacterCategory.lu,
  1068: CharacterCategory.lu,
  1069: CharacterCategory.lu,
  1070: CharacterCategory.lu,
  1071: CharacterCategory.lu,
  1120: CharacterCategory.lu,
  1122: CharacterCategory.lu,
  1124: CharacterCategory.lu,
  1126: CharacterCategory.lu,
  1128: CharacterCategory.lu,
  1130: CharacterCategory.lu,
  1132: CharacterCategory.lu,
  1134: CharacterCategory.lu,
  1136: CharacterCategory.lu,
  1138: CharacterCategory.lu,
  1140: CharacterCategory.lu,
  1142: CharacterCategory.lu,
  1144: CharacterCategory.lu,
  1146: CharacterCategory.lu,
  1148: CharacterCategory.lu,
  1150: CharacterCategory.lu,
  1152: CharacterCategory.lu,
  1162: CharacterCategory.lu,
  1164: CharacterCategory.lu,
  1166: CharacterCategory.lu,
  1168: CharacterCategory.lu,
  1170: CharacterCategory.lu,
  1172: CharacterCategory.lu,
  1174: CharacterCategory.lu,
  1176: CharacterCategory.lu,
  1178: CharacterCategory.lu,
  1180: CharacterCategory.lu,
  1182: CharacterCategory.lu,
  1184: CharacterCategory.lu,
  1186: CharacterCategory.lu,
  1188: CharacterCategory.lu,
  1190: CharacterCategory.lu,
  1192: CharacterCategory.lu,
  1194: CharacterCategory.lu,
  1196: CharacterCategory.lu,
  1198: CharacterCategory.lu,
  1200: CharacterCategory.lu,
  1202: CharacterCategory.lu,
  1204: CharacterCategory.lu,
  1206: CharacterCategory.lu,
  1208: CharacterCategory.lu,
  1210: CharacterCategory.lu,
  1212: CharacterCategory.lu,
  1214: CharacterCategory.lu,
  1216: CharacterCategory.lu,
  1217: CharacterCategory.lu,
  1219: CharacterCategory.lu,
  1221: CharacterCategory.lu,
  1223: CharacterCategory.lu,
  1225: CharacterCategory.lu,
  1227: CharacterCategory.lu,
  1229: CharacterCategory.lu,
  1232: CharacterCategory.lu,
  1234: CharacterCategory.lu,
  1236: CharacterCategory.lu,
  1238: CharacterCategory.lu,
  1240: CharacterCategory.lu,
  1242: CharacterCategory.lu,
  1244: CharacterCategory.lu,
  1246: CharacterCategory.lu,
  1248: CharacterCategory.lu,
  1250: CharacterCategory.lu,
  1252: CharacterCategory.lu,
  1254: CharacterCategory.lu,
  1256: CharacterCategory.lu,
  1258: CharacterCategory.lu,
  1260: CharacterCategory.lu,
  1262: CharacterCategory.lu,
  1264: CharacterCategory.lu,
  1266: CharacterCategory.lu,
  1268: CharacterCategory.lu,
  1270: CharacterCategory.lu,
  1272: CharacterCategory.lu,
  1274: CharacterCategory.lu,
  1276: CharacterCategory.lu,
  1278: CharacterCategory.lu,
  1280: CharacterCategory.lu,
  1282: CharacterCategory.lu,
  1284: CharacterCategory.lu,
  1286: CharacterCategory.lu,
  1288: CharacterCategory.lu,
  1290: CharacterCategory.lu,
  1292: CharacterCategory.lu,
  1294: CharacterCategory.lu,
  1296: CharacterCategory.lu,
  1298: CharacterCategory.lu,
  1300: CharacterCategory.lu,
  1302: CharacterCategory.lu,
  1304: CharacterCategory.lu,
  1306: CharacterCategory.lu,
  1308: CharacterCategory.lu,
  1310: CharacterCategory.lu,
  1312: CharacterCategory.lu,
  1314: CharacterCategory.lu,
  1316: CharacterCategory.lu,
  1318: CharacterCategory.lu,
  1320: CharacterCategory.lu,
  1322: CharacterCategory.lu,
  1324: CharacterCategory.lu,
  1326: CharacterCategory.lu,
  1329: CharacterCategory.lu,
  1330: CharacterCategory.lu,
  1331: CharacterCategory.lu,
  1332: CharacterCategory.lu,
  1333: CharacterCategory.lu,
  1334: CharacterCategory.lu,
  1335: CharacterCategory.lu,
  1336: CharacterCategory.lu,
  1337: CharacterCategory.lu,
  1338: CharacterCategory.lu,
  1339: CharacterCategory.lu,
  1340: CharacterCategory.lu,
  1341: CharacterCategory.lu,
  1342: CharacterCategory.lu,
  1343: CharacterCategory.lu,
  1344: CharacterCategory.lu,
  1345: CharacterCategory.lu,
  1346: CharacterCategory.lu,
  1347: CharacterCategory.lu,
  1348: CharacterCategory.lu,
  1349: CharacterCategory.lu,
  1350: CharacterCategory.lu,
  1351: CharacterCategory.lu,
  1352: CharacterCategory.lu,
  1353: CharacterCategory.lu,
  1354: CharacterCategory.lu,
  1355: CharacterCategory.lu,
  1356: CharacterCategory.lu,
  1357: CharacterCategory.lu,
  1358: CharacterCategory.lu,
  1359: CharacterCategory.lu,
  1360: CharacterCategory.lu,
  1361: CharacterCategory.lu,
  1362: CharacterCategory.lu,
  1363: CharacterCategory.lu,
  1364: CharacterCategory.lu,
  1365: CharacterCategory.lu,
  1366: CharacterCategory.lu,
  4256: CharacterCategory.lu,
  4257: CharacterCategory.lu,
  4258: CharacterCategory.lu,
  4259: CharacterCategory.lu,
  4260: CharacterCategory.lu,
  4261: CharacterCategory.lu,
  4262: CharacterCategory.lu,
  4263: CharacterCategory.lu,
  4264: CharacterCategory.lu,
  4265: CharacterCategory.lu,
  4266: CharacterCategory.lu,
  4267: CharacterCategory.lu,
  4268: CharacterCategory.lu,
  4269: CharacterCategory.lu,
  4270: CharacterCategory.lu,
  4271: CharacterCategory.lu,
  4272: CharacterCategory.lu,
  4273: CharacterCategory.lu,
  4274: CharacterCategory.lu,
  4275: CharacterCategory.lu,
  4276: CharacterCategory.lu,
  4277: CharacterCategory.lu,
  4278: CharacterCategory.lu,
  4279: CharacterCategory.lu,
  4280: CharacterCategory.lu,
  4281: CharacterCategory.lu,
  4282: CharacterCategory.lu,
  4283: CharacterCategory.lu,
  4284: CharacterCategory.lu,
  4285: CharacterCategory.lu,
  4286: CharacterCategory.lu,
  4287: CharacterCategory.lu,
  4288: CharacterCategory.lu,
  4289: CharacterCategory.lu,
  4290: CharacterCategory.lu,
  4291: CharacterCategory.lu,
  4292: CharacterCategory.lu,
  4293: CharacterCategory.lu,
  4295: CharacterCategory.lu,
  4301: CharacterCategory.lu,
  7680: CharacterCategory.lu,
  7682: CharacterCategory.lu,
  7684: CharacterCategory.lu,
  7686: CharacterCategory.lu,
  7688: CharacterCategory.lu,
  7690: CharacterCategory.lu,
  7692: CharacterCategory.lu,
  7694: CharacterCategory.lu,
  7696: CharacterCategory.lu,
  7698: CharacterCategory.lu,
  7700: CharacterCategory.lu,
  7702: CharacterCategory.lu,
  7704: CharacterCategory.lu,
  7706: CharacterCategory.lu,
  7708: CharacterCategory.lu,
  7710: CharacterCategory.lu,
  7712: CharacterCategory.lu,
  7714: CharacterCategory.lu,
  7716: CharacterCategory.lu,
  7718: CharacterCategory.lu,
  7720: CharacterCategory.lu,
  7722: CharacterCategory.lu,
  7724: CharacterCategory.lu,
  7726: CharacterCategory.lu,
  7728: CharacterCategory.lu,
  7730: CharacterCategory.lu,
  7732: CharacterCategory.lu,
  7734: CharacterCategory.lu,
  7736: CharacterCategory.lu,
  7738: CharacterCategory.lu,
  7740: CharacterCategory.lu,
  7742: CharacterCategory.lu,
  7744: CharacterCategory.lu,
  7746: CharacterCategory.lu,
  7748: CharacterCategory.lu,
  7750: CharacterCategory.lu,
  7752: CharacterCategory.lu,
  7754: CharacterCategory.lu,
  7756: CharacterCategory.lu,
  7758: CharacterCategory.lu,
  7760: CharacterCategory.lu,
  7762: CharacterCategory.lu,
  7764: CharacterCategory.lu,
  7766: CharacterCategory.lu,
  7768: CharacterCategory.lu,
  7770: CharacterCategory.lu,
  7772: CharacterCategory.lu,
  7774: CharacterCategory.lu,
  7776: CharacterCategory.lu,
  7778: CharacterCategory.lu,
  7780: CharacterCategory.lu,
  7782: CharacterCategory.lu,
  7784: CharacterCategory.lu,
  7786: CharacterCategory.lu,
  7788: CharacterCategory.lu,
  7790: CharacterCategory.lu,
  7792: CharacterCategory.lu,
  7794: CharacterCategory.lu,
  7796: CharacterCategory.lu,
  7798: CharacterCategory.lu,
  7800: CharacterCategory.lu,
  7802: CharacterCategory.lu,
  7804: CharacterCategory.lu,
  7806: CharacterCategory.lu,
  7808: CharacterCategory.lu,
  7810: CharacterCategory.lu,
  7812: CharacterCategory.lu,
  7814: CharacterCategory.lu,
  7816: CharacterCategory.lu,
  7818: CharacterCategory.lu,
  7820: CharacterCategory.lu,
  7822: CharacterCategory.lu,
  7824: CharacterCategory.lu,
  7826: CharacterCategory.lu,
  7828: CharacterCategory.lu,
  7838: CharacterCategory.lu,
  7840: CharacterCategory.lu,
  7842: CharacterCategory.lu,
  7844: CharacterCategory.lu,
  7846: CharacterCategory.lu,
  7848: CharacterCategory.lu,
  7850: CharacterCategory.lu,
  7852: CharacterCategory.lu,
  7854: CharacterCategory.lu,
  7856: CharacterCategory.lu,
  7858: CharacterCategory.lu,
  7860: CharacterCategory.lu,
  7862: CharacterCategory.lu,
  7864: CharacterCategory.lu,
  7866: CharacterCategory.lu,
  7868: CharacterCategory.lu,
  7870: CharacterCategory.lu,
  7872: CharacterCategory.lu,
  7874: CharacterCategory.lu,
  7876: CharacterCategory.lu,
  7878: CharacterCategory.lu,
  7880: CharacterCategory.lu,
  7882: CharacterCategory.lu,
  7884: CharacterCategory.lu,
  7886: CharacterCategory.lu,
  7888: CharacterCategory.lu,
  7890: CharacterCategory.lu,
  7892: CharacterCategory.lu,
  7894: CharacterCategory.lu,
  7896: CharacterCategory.lu,
  7898: CharacterCategory.lu,
  7900: CharacterCategory.lu,
  7902: CharacterCategory.lu,
  7904: CharacterCategory.lu,
  7906: CharacterCategory.lu,
  7908: CharacterCategory.lu,
  7910: CharacterCategory.lu,
  7912: CharacterCategory.lu,
  7914: CharacterCategory.lu,
  7916: CharacterCategory.lu,
  7918: CharacterCategory.lu,
  7920: CharacterCategory.lu,
  7922: CharacterCategory.lu,
  7924: CharacterCategory.lu,
  7926: CharacterCategory.lu,
  7928: CharacterCategory.lu,
  7930: CharacterCategory.lu,
  7932: CharacterCategory.lu,
  7934: CharacterCategory.lu,
  7944: CharacterCategory.lu,
  7945: CharacterCategory.lu,
  7946: CharacterCategory.lu,
  7947: CharacterCategory.lu,
  7948: CharacterCategory.lu,
  7949: CharacterCategory.lu,
  7950: CharacterCategory.lu,
  7951: CharacterCategory.lu,
  7960: CharacterCategory.lu,
  7961: CharacterCategory.lu,
  7962: CharacterCategory.lu,
  7963: CharacterCategory.lu,
  7964: CharacterCategory.lu,
  7965: CharacterCategory.lu,
  7976: CharacterCategory.lu,
  7977: CharacterCategory.lu,
  7978: CharacterCategory.lu,
  7979: CharacterCategory.lu,
  7980: CharacterCategory.lu,
  7981: CharacterCategory.lu,
  7982: CharacterCategory.lu,
  7983: CharacterCategory.lu,
  7992: CharacterCategory.lu,
  7993: CharacterCategory.lu,
  7994: CharacterCategory.lu,
  7995: CharacterCategory.lu,
  7996: CharacterCategory.lu,
  7997: CharacterCategory.lu,
  7998: CharacterCategory.lu,
  7999: CharacterCategory.lu,
  8008: CharacterCategory.lu,
  8009: CharacterCategory.lu,
  8010: CharacterCategory.lu,
  8011: CharacterCategory.lu,
  8012: CharacterCategory.lu,
  8013: CharacterCategory.lu,
  8025: CharacterCategory.lu,
  8027: CharacterCategory.lu,
  8029: CharacterCategory.lu,
  8031: CharacterCategory.lu,
  8040: CharacterCategory.lu,
  8041: CharacterCategory.lu,
  8042: CharacterCategory.lu,
  8043: CharacterCategory.lu,
  8044: CharacterCategory.lu,
  8045: CharacterCategory.lu,
  8046: CharacterCategory.lu,
  8047: CharacterCategory.lu,
  8120: CharacterCategory.lu,
  8121: CharacterCategory.lu,
  8122: CharacterCategory.lu,
  8123: CharacterCategory.lu,
  8136: CharacterCategory.lu,
  8137: CharacterCategory.lu,
  8138: CharacterCategory.lu,
  8139: CharacterCategory.lu,
  8152: CharacterCategory.lu,
  8153: CharacterCategory.lu,
  8154: CharacterCategory.lu,
  8155: CharacterCategory.lu,
  8168: CharacterCategory.lu,
  8169: CharacterCategory.lu,
  8170: CharacterCategory.lu,
  8171: CharacterCategory.lu,
  8172: CharacterCategory.lu,
  8184: CharacterCategory.lu,
  8185: CharacterCategory.lu,
  8186: CharacterCategory.lu,
  8187: CharacterCategory.lu,
  8450: CharacterCategory.lu,
  8455: CharacterCategory.lu,
  8459: CharacterCategory.lu,
  8460: CharacterCategory.lu,
  8461: CharacterCategory.lu,
  8464: CharacterCategory.lu,
  8465: CharacterCategory.lu,
  8466: CharacterCategory.lu,
  8469: CharacterCategory.lu,
  8473: CharacterCategory.lu,
  8474: CharacterCategory.lu,
  8475: CharacterCategory.lu,
  8476: CharacterCategory.lu,
  8477: CharacterCategory.lu,
  8484: CharacterCategory.lu,
  8486: CharacterCategory.lu,
  8488: CharacterCategory.lu,
  8490: CharacterCategory.lu,
  8491: CharacterCategory.lu,
  8492: CharacterCategory.lu,
  8493: CharacterCategory.lu,
  8496: CharacterCategory.lu,
  8497: CharacterCategory.lu,
  8498: CharacterCategory.lu,
  8499: CharacterCategory.lu,
  8510: CharacterCategory.lu,
  8511: CharacterCategory.lu,
  8517: CharacterCategory.lu,
  8579: CharacterCategory.lu,
  11264: CharacterCategory.lu,
  11265: CharacterCategory.lu,
  11266: CharacterCategory.lu,
  11267: CharacterCategory.lu,
  11268: CharacterCategory.lu,
  11269: CharacterCategory.lu,
  11270: CharacterCategory.lu,
  11271: CharacterCategory.lu,
  11272: CharacterCategory.lu,
  11273: CharacterCategory.lu,
  11274: CharacterCategory.lu,
  11275: CharacterCategory.lu,
  11276: CharacterCategory.lu,
  11277: CharacterCategory.lu,
  11278: CharacterCategory.lu,
  11279: CharacterCategory.lu,
  11280: CharacterCategory.lu,
  11281: CharacterCategory.lu,
  11282: CharacterCategory.lu,
  11283: CharacterCategory.lu,
  11284: CharacterCategory.lu,
  11285: CharacterCategory.lu,
  11286: CharacterCategory.lu,
  11287: CharacterCategory.lu,
  11288: CharacterCategory.lu,
  11289: CharacterCategory.lu,
  11290: CharacterCategory.lu,
  11291: CharacterCategory.lu,
  11292: CharacterCategory.lu,
  11293: CharacterCategory.lu,
  11294: CharacterCategory.lu,
  11295: CharacterCategory.lu,
  11296: CharacterCategory.lu,
  11297: CharacterCategory.lu,
  11298: CharacterCategory.lu,
  11299: CharacterCategory.lu,
  11300: CharacterCategory.lu,
  11301: CharacterCategory.lu,
  11302: CharacterCategory.lu,
  11303: CharacterCategory.lu,
  11304: CharacterCategory.lu,
  11305: CharacterCategory.lu,
  11306: CharacterCategory.lu,
  11307: CharacterCategory.lu,
  11308: CharacterCategory.lu,
  11309: CharacterCategory.lu,
  11310: CharacterCategory.lu,
  11360: CharacterCategory.lu,
  11362: CharacterCategory.lu,
  11363: CharacterCategory.lu,
  11364: CharacterCategory.lu,
  11367: CharacterCategory.lu,
  11369: CharacterCategory.lu,
  11371: CharacterCategory.lu,
  11373: CharacterCategory.lu,
  11374: CharacterCategory.lu,
  11375: CharacterCategory.lu,
  11376: CharacterCategory.lu,
  11378: CharacterCategory.lu,
  11381: CharacterCategory.lu,
  11390: CharacterCategory.lu,
  11391: CharacterCategory.lu,
  11392: CharacterCategory.lu,
  11394: CharacterCategory.lu,
  11396: CharacterCategory.lu,
  11398: CharacterCategory.lu,
  11400: CharacterCategory.lu,
  11402: CharacterCategory.lu,
  11404: CharacterCategory.lu,
  11406: CharacterCategory.lu,
  11408: CharacterCategory.lu,
  11410: CharacterCategory.lu,
  11412: CharacterCategory.lu,
  11414: CharacterCategory.lu,
  11416: CharacterCategory.lu,
  11418: CharacterCategory.lu,
  11420: CharacterCategory.lu,
  11422: CharacterCategory.lu,
  11424: CharacterCategory.lu,
  11426: CharacterCategory.lu,
  11428: CharacterCategory.lu,
  11430: CharacterCategory.lu,
  11432: CharacterCategory.lu,
  11434: CharacterCategory.lu,
  11436: CharacterCategory.lu,
  11438: CharacterCategory.lu,
  11440: CharacterCategory.lu,
  11442: CharacterCategory.lu,
  11444: CharacterCategory.lu,
  11446: CharacterCategory.lu,
  11448: CharacterCategory.lu,
  11450: CharacterCategory.lu,
  11452: CharacterCategory.lu,
  11454: CharacterCategory.lu,
  11456: CharacterCategory.lu,
  11458: CharacterCategory.lu,
  11460: CharacterCategory.lu,
  11462: CharacterCategory.lu,
  11464: CharacterCategory.lu,
  11466: CharacterCategory.lu,
  11468: CharacterCategory.lu,
  11470: CharacterCategory.lu,
  11472: CharacterCategory.lu,
  11474: CharacterCategory.lu,
  11476: CharacterCategory.lu,
  11478: CharacterCategory.lu,
  11480: CharacterCategory.lu,
  11482: CharacterCategory.lu,
  11484: CharacterCategory.lu,
  11486: CharacterCategory.lu,
  11488: CharacterCategory.lu,
  11490: CharacterCategory.lu,
  11499: CharacterCategory.lu,
  11501: CharacterCategory.lu,
  11506: CharacterCategory.lu,
  42560: CharacterCategory.lu,
  42562: CharacterCategory.lu,
  42564: CharacterCategory.lu,
  42566: CharacterCategory.lu,
  42568: CharacterCategory.lu,
  42570: CharacterCategory.lu,
  42572: CharacterCategory.lu,
  42574: CharacterCategory.lu,
  42576: CharacterCategory.lu,
  42578: CharacterCategory.lu,
  42580: CharacterCategory.lu,
  42582: CharacterCategory.lu,
  42584: CharacterCategory.lu,
  42586: CharacterCategory.lu,
  42588: CharacterCategory.lu,
  42590: CharacterCategory.lu,
  42592: CharacterCategory.lu,
  42594: CharacterCategory.lu,
  42596: CharacterCategory.lu,
  42598: CharacterCategory.lu,
  42600: CharacterCategory.lu,
  42602: CharacterCategory.lu,
  42604: CharacterCategory.lu,
  42624: CharacterCategory.lu,
  42626: CharacterCategory.lu,
  42628: CharacterCategory.lu,
  42630: CharacterCategory.lu,
  42632: CharacterCategory.lu,
  42634: CharacterCategory.lu,
  42636: CharacterCategory.lu,
  42638: CharacterCategory.lu,
  42640: CharacterCategory.lu,
  42642: CharacterCategory.lu,
  42644: CharacterCategory.lu,
  42646: CharacterCategory.lu,
  42648: CharacterCategory.lu,
  42650: CharacterCategory.lu,
  42786: CharacterCategory.lu,
  42788: CharacterCategory.lu,
  42790: CharacterCategory.lu,
  42792: CharacterCategory.lu,
  42794: CharacterCategory.lu,
  42796: CharacterCategory.lu,
  42798: CharacterCategory.lu,
  42802: CharacterCategory.lu,
  42804: CharacterCategory.lu,
  42806: CharacterCategory.lu,
  42808: CharacterCategory.lu,
  42810: CharacterCategory.lu,
  42812: CharacterCategory.lu,
  42814: CharacterCategory.lu,
  42816: CharacterCategory.lu,
  42818: CharacterCategory.lu,
  42820: CharacterCategory.lu,
  42822: CharacterCategory.lu,
  42824: CharacterCategory.lu,
  42826: CharacterCategory.lu,
  42828: CharacterCategory.lu,
  42830: CharacterCategory.lu,
  42832: CharacterCategory.lu,
  42834: CharacterCategory.lu,
  42836: CharacterCategory.lu,
  42838: CharacterCategory.lu,
  42840: CharacterCategory.lu,
  42842: CharacterCategory.lu,
  42844: CharacterCategory.lu,
  42846: CharacterCategory.lu,
  42848: CharacterCategory.lu,
  42850: CharacterCategory.lu,
  42852: CharacterCategory.lu,
  42854: CharacterCategory.lu,
  42856: CharacterCategory.lu,
  42858: CharacterCategory.lu,
  42860: CharacterCategory.lu,
  42862: CharacterCategory.lu,
  42873: CharacterCategory.lu,
  42875: CharacterCategory.lu,
  42877: CharacterCategory.lu,
  42878: CharacterCategory.lu,
  42880: CharacterCategory.lu,
  42882: CharacterCategory.lu,
  42884: CharacterCategory.lu,
  42886: CharacterCategory.lu,
  42891: CharacterCategory.lu,
  42893: CharacterCategory.lu,
  42896: CharacterCategory.lu,
  42898: CharacterCategory.lu,
  42902: CharacterCategory.lu,
  42904: CharacterCategory.lu,
  42906: CharacterCategory.lu,
  42908: CharacterCategory.lu,
  42910: CharacterCategory.lu,
  42912: CharacterCategory.lu,
  42914: CharacterCategory.lu,
  42916: CharacterCategory.lu,
  42918: CharacterCategory.lu,
  42920: CharacterCategory.lu,
  42922: CharacterCategory.lu,
  42923: CharacterCategory.lu,
  42924: CharacterCategory.lu,
  42925: CharacterCategory.lu,
  42928: CharacterCategory.lu,
  42929: CharacterCategory.lu,
  65313: CharacterCategory.lu,
  65314: CharacterCategory.lu,
  65315: CharacterCategory.lu,
  65316: CharacterCategory.lu,
  65317: CharacterCategory.lu,
  65318: CharacterCategory.lu,
  65319: CharacterCategory.lu,
  65320: CharacterCategory.lu,
  65321: CharacterCategory.lu,
  65322: CharacterCategory.lu,
  65323: CharacterCategory.lu,
  65324: CharacterCategory.lu,
  65325: CharacterCategory.lu,
  65326: CharacterCategory.lu,
  65327: CharacterCategory.lu,
  65328: CharacterCategory.lu,
  65329: CharacterCategory.lu,
  65330: CharacterCategory.lu,
  65331: CharacterCategory.lu,
  65332: CharacterCategory.lu,
  65333: CharacterCategory.lu,
  65334: CharacterCategory.lu,
  65335: CharacterCategory.lu,
  65336: CharacterCategory.lu,
  65337: CharacterCategory.lu,
  65338: CharacterCategory.lu,
  97: CharacterCategory.ll,
  98: CharacterCategory.ll,
  99: CharacterCategory.ll,
  100: CharacterCategory.ll,
  101: CharacterCategory.ll,
  102: CharacterCategory.ll,
  103: CharacterCategory.ll,
  104: CharacterCategory.ll,
  105: CharacterCategory.ll,
  106: CharacterCategory.ll,
  107: CharacterCategory.ll,
  108: CharacterCategory.ll,
  109: CharacterCategory.ll,
  110: CharacterCategory.ll,
  111: CharacterCategory.ll,
  112: CharacterCategory.ll,
  113: CharacterCategory.ll,
  114: CharacterCategory.ll,
  115: CharacterCategory.ll,
  116: CharacterCategory.ll,
  117: CharacterCategory.ll,
  118: CharacterCategory.ll,
  119: CharacterCategory.ll,
  120: CharacterCategory.ll,
  121: CharacterCategory.ll,
  122: CharacterCategory.ll,
  181: CharacterCategory.ll,
  223: CharacterCategory.ll,
  224: CharacterCategory.ll,
  225: CharacterCategory.ll,
  226: CharacterCategory.ll,
  227: CharacterCategory.ll,
  228: CharacterCategory.ll,
  229: CharacterCategory.ll,
  230: CharacterCategory.ll,
  231: CharacterCategory.ll,
  232: CharacterCategory.ll,
  233: CharacterCategory.ll,
  234: CharacterCategory.ll,
  235: CharacterCategory.ll,
  236: CharacterCategory.ll,
  237: CharacterCategory.ll,
  238: CharacterCategory.ll,
  239: CharacterCategory.ll,
  240: CharacterCategory.ll,
  241: CharacterCategory.ll,
  242: CharacterCategory.ll,
  243: CharacterCategory.ll,
  244: CharacterCategory.ll,
  245: CharacterCategory.ll,
  246: CharacterCategory.ll,
  248: CharacterCategory.ll,
  249: CharacterCategory.ll,
  250: CharacterCategory.ll,
  251: CharacterCategory.ll,
  252: CharacterCategory.ll,
  253: CharacterCategory.ll,
  254: CharacterCategory.ll,
  255: CharacterCategory.ll,
  257: CharacterCategory.ll,
  259: CharacterCategory.ll,
  261: CharacterCategory.ll,
  263: CharacterCategory.ll,
  265: CharacterCategory.ll,
  267: CharacterCategory.ll,
  269: CharacterCategory.ll,
  271: CharacterCategory.ll,
  273: CharacterCategory.ll,
  275: CharacterCategory.ll,
  277: CharacterCategory.ll,
  279: CharacterCategory.ll,
  281: CharacterCategory.ll,
  283: CharacterCategory.ll,
  285: CharacterCategory.ll,
  287: CharacterCategory.ll,
  289: CharacterCategory.ll,
  291: CharacterCategory.ll,
  293: CharacterCategory.ll,
  295: CharacterCategory.ll,
  297: CharacterCategory.ll,
  299: CharacterCategory.ll,
  301: CharacterCategory.ll,
  303: CharacterCategory.ll,
  305: CharacterCategory.ll,
  307: CharacterCategory.ll,
  309: CharacterCategory.ll,
  311: CharacterCategory.ll,
  312: CharacterCategory.ll,
  314: CharacterCategory.ll,
  316: CharacterCategory.ll,
  318: CharacterCategory.ll,
  320: CharacterCategory.ll,
  322: CharacterCategory.ll,
  324: CharacterCategory.ll,
  326: CharacterCategory.ll,
  328: CharacterCategory.ll,
  329: CharacterCategory.ll,
  331: CharacterCategory.ll,
  333: CharacterCategory.ll,
  335: CharacterCategory.ll,
  337: CharacterCategory.ll,
  339: CharacterCategory.ll,
  341: CharacterCategory.ll,
  343: CharacterCategory.ll,
  345: CharacterCategory.ll,
  347: CharacterCategory.ll,
  349: CharacterCategory.ll,
  351: CharacterCategory.ll,
  353: CharacterCategory.ll,
  355: CharacterCategory.ll,
  357: CharacterCategory.ll,
  359: CharacterCategory.ll,
  361: CharacterCategory.ll,
  363: CharacterCategory.ll,
  365: CharacterCategory.ll,
  367: CharacterCategory.ll,
  369: CharacterCategory.ll,
  371: CharacterCategory.ll,
  373: CharacterCategory.ll,
  375: CharacterCategory.ll,
  378: CharacterCategory.ll,
  380: CharacterCategory.ll,
  382: CharacterCategory.ll,
  383: CharacterCategory.ll,
  384: CharacterCategory.ll,
  387: CharacterCategory.ll,
  389: CharacterCategory.ll,
  392: CharacterCategory.ll,
  396: CharacterCategory.ll,
  397: CharacterCategory.ll,
  402: CharacterCategory.ll,
  405: CharacterCategory.ll,
  409: CharacterCategory.ll,
  410: CharacterCategory.ll,
  411: CharacterCategory.ll,
  414: CharacterCategory.ll,
  417: CharacterCategory.ll,
  419: CharacterCategory.ll,
  421: CharacterCategory.ll,
  424: CharacterCategory.ll,
  426: CharacterCategory.ll,
  427: CharacterCategory.ll,
  429: CharacterCategory.ll,
  432: CharacterCategory.ll,
  436: CharacterCategory.ll,
  438: CharacterCategory.ll,
  441: CharacterCategory.ll,
  442: CharacterCategory.ll,
  445: CharacterCategory.ll,
  446: CharacterCategory.ll,
  447: CharacterCategory.ll,
  454: CharacterCategory.ll,
  457: CharacterCategory.ll,
  460: CharacterCategory.ll,
  462: CharacterCategory.ll,
  464: CharacterCategory.ll,
  466: CharacterCategory.ll,
  468: CharacterCategory.ll,
  470: CharacterCategory.ll,
  472: CharacterCategory.ll,
  474: CharacterCategory.ll,
  476: CharacterCategory.ll,
  477: CharacterCategory.ll,
  479: CharacterCategory.ll,
  481: CharacterCategory.ll,
  483: CharacterCategory.ll,
  485: CharacterCategory.ll,
  487: CharacterCategory.ll,
  489: CharacterCategory.ll,
  491: CharacterCategory.ll,
  493: CharacterCategory.ll,
  495: CharacterCategory.ll,
  496: CharacterCategory.ll,
  499: CharacterCategory.ll,
  501: CharacterCategory.ll,
  505: CharacterCategory.ll,
  507: CharacterCategory.ll,
  509: CharacterCategory.ll,
  511: CharacterCategory.ll,
  513: CharacterCategory.ll,
  515: CharacterCategory.ll,
  517: CharacterCategory.ll,
  519: CharacterCategory.ll,
  521: CharacterCategory.ll,
  523: CharacterCategory.ll,
  525: CharacterCategory.ll,
  527: CharacterCategory.ll,
  529: CharacterCategory.ll,
  531: CharacterCategory.ll,
  533: CharacterCategory.ll,
  535: CharacterCategory.ll,
  537: CharacterCategory.ll,
  539: CharacterCategory.ll,
  541: CharacterCategory.ll,
  543: CharacterCategory.ll,
  545: CharacterCategory.ll,
  547: CharacterCategory.ll,
  549: CharacterCategory.ll,
  551: CharacterCategory.ll,
  553: CharacterCategory.ll,
  555: CharacterCategory.ll,
  557: CharacterCategory.ll,
  559: CharacterCategory.ll,
  561: CharacterCategory.ll,
  563: CharacterCategory.ll,
  564: CharacterCategory.ll,
  565: CharacterCategory.ll,
  566: CharacterCategory.ll,
  567: CharacterCategory.ll,
  568: CharacterCategory.ll,
  569: CharacterCategory.ll,
  572: CharacterCategory.ll,
  575: CharacterCategory.ll,
  576: CharacterCategory.ll,
  578: CharacterCategory.ll,
  583: CharacterCategory.ll,
  585: CharacterCategory.ll,
  587: CharacterCategory.ll,
  589: CharacterCategory.ll,
  591: CharacterCategory.ll,
  592: CharacterCategory.ll,
  593: CharacterCategory.ll,
  594: CharacterCategory.ll,
  595: CharacterCategory.ll,
  596: CharacterCategory.ll,
  597: CharacterCategory.ll,
  598: CharacterCategory.ll,
  599: CharacterCategory.ll,
  600: CharacterCategory.ll,
  601: CharacterCategory.ll,
  602: CharacterCategory.ll,
  603: CharacterCategory.ll,
  604: CharacterCategory.ll,
  605: CharacterCategory.ll,
  606: CharacterCategory.ll,
  607: CharacterCategory.ll,
  608: CharacterCategory.ll,
  609: CharacterCategory.ll,
  610: CharacterCategory.ll,
  611: CharacterCategory.ll,
  612: CharacterCategory.ll,
  613: CharacterCategory.ll,
  614: CharacterCategory.ll,
  615: CharacterCategory.ll,
  616: CharacterCategory.ll,
  617: CharacterCategory.ll,
  618: CharacterCategory.ll,
  619: CharacterCategory.ll,
  620: CharacterCategory.ll,
  621: CharacterCategory.ll,
  622: CharacterCategory.ll,
  623: CharacterCategory.ll,
  624: CharacterCategory.ll,
  625: CharacterCategory.ll,
  626: CharacterCategory.ll,
  627: CharacterCategory.ll,
  628: CharacterCategory.ll,
  629: CharacterCategory.ll,
  630: CharacterCategory.ll,
  631: CharacterCategory.ll,
  632: CharacterCategory.ll,
  633: CharacterCategory.ll,
  634: CharacterCategory.ll,
  635: CharacterCategory.ll,
  636: CharacterCategory.ll,
  637: CharacterCategory.ll,
  638: CharacterCategory.ll,
  639: CharacterCategory.ll,
  640: CharacterCategory.ll,
  641: CharacterCategory.ll,
  642: CharacterCategory.ll,
  643: CharacterCategory.ll,
  644: CharacterCategory.ll,
  645: CharacterCategory.ll,
  646: CharacterCategory.ll,
  647: CharacterCategory.ll,
  648: CharacterCategory.ll,
  649: CharacterCategory.ll,
  650: CharacterCategory.ll,
  651: CharacterCategory.ll,
  652: CharacterCategory.ll,
  653: CharacterCategory.ll,
  654: CharacterCategory.ll,
  655: CharacterCategory.ll,
  656: CharacterCategory.ll,
  657: CharacterCategory.ll,
  658: CharacterCategory.ll,
  659: CharacterCategory.ll,
  661: CharacterCategory.ll,
  662: CharacterCategory.ll,
  663: CharacterCategory.ll,
  664: CharacterCategory.ll,
  665: CharacterCategory.ll,
  666: CharacterCategory.ll,
  667: CharacterCategory.ll,
  668: CharacterCategory.ll,
  669: CharacterCategory.ll,
  670: CharacterCategory.ll,
  671: CharacterCategory.ll,
  672: CharacterCategory.ll,
  673: CharacterCategory.ll,
  674: CharacterCategory.ll,
  675: CharacterCategory.ll,
  676: CharacterCategory.ll,
  677: CharacterCategory.ll,
  678: CharacterCategory.ll,
  679: CharacterCategory.ll,
  680: CharacterCategory.ll,
  681: CharacterCategory.ll,
  682: CharacterCategory.ll,
  683: CharacterCategory.ll,
  684: CharacterCategory.ll,
  685: CharacterCategory.ll,
  686: CharacterCategory.ll,
  687: CharacterCategory.ll,
  881: CharacterCategory.ll,
  883: CharacterCategory.ll,
  887: CharacterCategory.ll,
  891: CharacterCategory.ll,
  892: CharacterCategory.ll,
  893: CharacterCategory.ll,
  912: CharacterCategory.ll,
  940: CharacterCategory.ll,
  941: CharacterCategory.ll,
  942: CharacterCategory.ll,
  943: CharacterCategory.ll,
  944: CharacterCategory.ll,
  945: CharacterCategory.ll,
  946: CharacterCategory.ll,
  947: CharacterCategory.ll,
  948: CharacterCategory.ll,
  949: CharacterCategory.ll,
  950: CharacterCategory.ll,
  951: CharacterCategory.ll,
  952: CharacterCategory.ll,
  953: CharacterCategory.ll,
  954: CharacterCategory.ll,
  955: CharacterCategory.ll,
  956: CharacterCategory.ll,
  957: CharacterCategory.ll,
  958: CharacterCategory.ll,
  959: CharacterCategory.ll,
  960: CharacterCategory.ll,
  961: CharacterCategory.ll,
  962: CharacterCategory.ll,
  963: CharacterCategory.ll,
  964: CharacterCategory.ll,
  965: CharacterCategory.ll,
  966: CharacterCategory.ll,
  967: CharacterCategory.ll,
  968: CharacterCategory.ll,
  969: CharacterCategory.ll,
  970: CharacterCategory.ll,
  971: CharacterCategory.ll,
  972: CharacterCategory.ll,
  973: CharacterCategory.ll,
  974: CharacterCategory.ll,
  976: CharacterCategory.ll,
  977: CharacterCategory.ll,
  981: CharacterCategory.ll,
  982: CharacterCategory.ll,
  983: CharacterCategory.ll,
  985: CharacterCategory.ll,
  987: CharacterCategory.ll,
  989: CharacterCategory.ll,
  991: CharacterCategory.ll,
  993: CharacterCategory.ll,
  995: CharacterCategory.ll,
  997: CharacterCategory.ll,
  999: CharacterCategory.ll,
  1001: CharacterCategory.ll,
  1003: CharacterCategory.ll,
  1005: CharacterCategory.ll,
  1007: CharacterCategory.ll,
  1008: CharacterCategory.ll,
  1009: CharacterCategory.ll,
  1010: CharacterCategory.ll,
  1011: CharacterCategory.ll,
  1013: CharacterCategory.ll,
  1016: CharacterCategory.ll,
  1019: CharacterCategory.ll,
  1020: CharacterCategory.ll,
  1072: CharacterCategory.ll,
  1073: CharacterCategory.ll,
  1074: CharacterCategory.ll,
  1075: CharacterCategory.ll,
  1076: CharacterCategory.ll,
  1077: CharacterCategory.ll,
  1078: CharacterCategory.ll,
  1079: CharacterCategory.ll,
  1080: CharacterCategory.ll,
  1081: CharacterCategory.ll,
  1082: CharacterCategory.ll,
  1083: CharacterCategory.ll,
  1084: CharacterCategory.ll,
  1085: CharacterCategory.ll,
  1086: CharacterCategory.ll,
  1087: CharacterCategory.ll,
  1088: CharacterCategory.ll,
  1089: CharacterCategory.ll,
  1090: CharacterCategory.ll,
  1091: CharacterCategory.ll,
  1092: CharacterCategory.ll,
  1093: CharacterCategory.ll,
  1094: CharacterCategory.ll,
  1095: CharacterCategory.ll,
  1096: CharacterCategory.ll,
  1097: CharacterCategory.ll,
  1098: CharacterCategory.ll,
  1099: CharacterCategory.ll,
  1100: CharacterCategory.ll,
  1101: CharacterCategory.ll,
  1102: CharacterCategory.ll,
  1103: CharacterCategory.ll,
  1104: CharacterCategory.ll,
  1105: CharacterCategory.ll,
  1106: CharacterCategory.ll,
  1107: CharacterCategory.ll,
  1108: CharacterCategory.ll,
  1109: CharacterCategory.ll,
  1110: CharacterCategory.ll,
  1111: CharacterCategory.ll,
  1112: CharacterCategory.ll,
  1113: CharacterCategory.ll,
  1114: CharacterCategory.ll,
  1115: CharacterCategory.ll,
  1116: CharacterCategory.ll,
  1117: CharacterCategory.ll,
  1118: CharacterCategory.ll,
  1119: CharacterCategory.ll,
  1121: CharacterCategory.ll,
  1123: CharacterCategory.ll,
  1125: CharacterCategory.ll,
  1127: CharacterCategory.ll,
  1129: CharacterCategory.ll,
  1131: CharacterCategory.ll,
  1133: CharacterCategory.ll,
  1135: CharacterCategory.ll,
  1137: CharacterCategory.ll,
  1139: CharacterCategory.ll,
  1141: CharacterCategory.ll,
  1143: CharacterCategory.ll,
  1145: CharacterCategory.ll,
  1147: CharacterCategory.ll,
  1149: CharacterCategory.ll,
  1151: CharacterCategory.ll,
  1153: CharacterCategory.ll,
  1163: CharacterCategory.ll,
  1165: CharacterCategory.ll,
  1167: CharacterCategory.ll,
  1169: CharacterCategory.ll,
  1171: CharacterCategory.ll,
  1173: CharacterCategory.ll,
  1175: CharacterCategory.ll,
  1177: CharacterCategory.ll,
  1179: CharacterCategory.ll,
  1181: CharacterCategory.ll,
  1183: CharacterCategory.ll,
  1185: CharacterCategory.ll,
  1187: CharacterCategory.ll,
  1189: CharacterCategory.ll,
  1191: CharacterCategory.ll,
  1193: CharacterCategory.ll,
  1195: CharacterCategory.ll,
  1197: CharacterCategory.ll,
  1199: CharacterCategory.ll,
  1201: CharacterCategory.ll,
  1203: CharacterCategory.ll,
  1205: CharacterCategory.ll,
  1207: CharacterCategory.ll,
  1209: CharacterCategory.ll,
  1211: CharacterCategory.ll,
  1213: CharacterCategory.ll,
  1215: CharacterCategory.ll,
  1218: CharacterCategory.ll,
  1220: CharacterCategory.ll,
  1222: CharacterCategory.ll,
  1224: CharacterCategory.ll,
  1226: CharacterCategory.ll,
  1228: CharacterCategory.ll,
  1230: CharacterCategory.ll,
  1231: CharacterCategory.ll,
  1233: CharacterCategory.ll,
  1235: CharacterCategory.ll,
  1237: CharacterCategory.ll,
  1239: CharacterCategory.ll,
  1241: CharacterCategory.ll,
  1243: CharacterCategory.ll,
  1245: CharacterCategory.ll,
  1247: CharacterCategory.ll,
  1249: CharacterCategory.ll,
  1251: CharacterCategory.ll,
  1253: CharacterCategory.ll,
  1255: CharacterCategory.ll,
  1257: CharacterCategory.ll,
  1259: CharacterCategory.ll,
  1261: CharacterCategory.ll,
  1263: CharacterCategory.ll,
  1265: CharacterCategory.ll,
  1267: CharacterCategory.ll,
  1269: CharacterCategory.ll,
  1271: CharacterCategory.ll,
  1273: CharacterCategory.ll,
  1275: CharacterCategory.ll,
  1277: CharacterCategory.ll,
  1279: CharacterCategory.ll,
  1281: CharacterCategory.ll,
  1283: CharacterCategory.ll,
  1285: CharacterCategory.ll,
  1287: CharacterCategory.ll,
  1289: CharacterCategory.ll,
  1291: CharacterCategory.ll,
  1293: CharacterCategory.ll,
  1295: CharacterCategory.ll,
  1297: CharacterCategory.ll,
  1299: CharacterCategory.ll,
  1301: CharacterCategory.ll,
  1303: CharacterCategory.ll,
  1305: CharacterCategory.ll,
  1307: CharacterCategory.ll,
  1309: CharacterCategory.ll,
  1311: CharacterCategory.ll,
  1313: CharacterCategory.ll,
  1315: CharacterCategory.ll,
  1317: CharacterCategory.ll,
  1319: CharacterCategory.ll,
  1321: CharacterCategory.ll,
  1323: CharacterCategory.ll,
  1325: CharacterCategory.ll,
  1327: CharacterCategory.ll,
  1377: CharacterCategory.ll,
  1378: CharacterCategory.ll,
  1379: CharacterCategory.ll,
  1380: CharacterCategory.ll,
  1381: CharacterCategory.ll,
  1382: CharacterCategory.ll,
  1383: CharacterCategory.ll,
  1384: CharacterCategory.ll,
  1385: CharacterCategory.ll,
  1386: CharacterCategory.ll,
  1387: CharacterCategory.ll,
  1388: CharacterCategory.ll,
  1389: CharacterCategory.ll,
  1390: CharacterCategory.ll,
  1391: CharacterCategory.ll,
  1392: CharacterCategory.ll,
  1393: CharacterCategory.ll,
  1394: CharacterCategory.ll,
  1395: CharacterCategory.ll,
  1396: CharacterCategory.ll,
  1397: CharacterCategory.ll,
  1398: CharacterCategory.ll,
  1399: CharacterCategory.ll,
  1400: CharacterCategory.ll,
  1401: CharacterCategory.ll,
  1402: CharacterCategory.ll,
  1403: CharacterCategory.ll,
  1404: CharacterCategory.ll,
  1405: CharacterCategory.ll,
  1406: CharacterCategory.ll,
  1407: CharacterCategory.ll,
  1408: CharacterCategory.ll,
  1409: CharacterCategory.ll,
  1410: CharacterCategory.ll,
  1411: CharacterCategory.ll,
  1412: CharacterCategory.ll,
  1413: CharacterCategory.ll,
  1414: CharacterCategory.ll,
  1415: CharacterCategory.ll,
  7424: CharacterCategory.ll,
  7425: CharacterCategory.ll,
  7426: CharacterCategory.ll,
  7427: CharacterCategory.ll,
  7428: CharacterCategory.ll,
  7429: CharacterCategory.ll,
  7430: CharacterCategory.ll,
  7431: CharacterCategory.ll,
  7432: CharacterCategory.ll,
  7433: CharacterCategory.ll,
  7434: CharacterCategory.ll,
  7435: CharacterCategory.ll,
  7436: CharacterCategory.ll,
  7437: CharacterCategory.ll,
  7438: CharacterCategory.ll,
  7439: CharacterCategory.ll,
  7440: CharacterCategory.ll,
  7441: CharacterCategory.ll,
  7442: CharacterCategory.ll,
  7443: CharacterCategory.ll,
  7444: CharacterCategory.ll,
  7445: CharacterCategory.ll,
  7446: CharacterCategory.ll,
  7447: CharacterCategory.ll,
  7448: CharacterCategory.ll,
  7449: CharacterCategory.ll,
  7450: CharacterCategory.ll,
  7451: CharacterCategory.ll,
  7452: CharacterCategory.ll,
  7453: CharacterCategory.ll,
  7454: CharacterCategory.ll,
  7455: CharacterCategory.ll,
  7456: CharacterCategory.ll,
  7457: CharacterCategory.ll,
  7458: CharacterCategory.ll,
  7459: CharacterCategory.ll,
  7460: CharacterCategory.ll,
  7461: CharacterCategory.ll,
  7462: CharacterCategory.ll,
  7463: CharacterCategory.ll,
  7464: CharacterCategory.ll,
  7465: CharacterCategory.ll,
  7466: CharacterCategory.ll,
  7467: CharacterCategory.ll,
  7531: CharacterCategory.ll,
  7532: CharacterCategory.ll,
  7533: CharacterCategory.ll,
  7534: CharacterCategory.ll,
  7535: CharacterCategory.ll,
  7536: CharacterCategory.ll,
  7537: CharacterCategory.ll,
  7538: CharacterCategory.ll,
  7539: CharacterCategory.ll,
  7540: CharacterCategory.ll,
  7541: CharacterCategory.ll,
  7542: CharacterCategory.ll,
  7543: CharacterCategory.ll,
  7545: CharacterCategory.ll,
  7546: CharacterCategory.ll,
  7547: CharacterCategory.ll,
  7548: CharacterCategory.ll,
  7549: CharacterCategory.ll,
  7550: CharacterCategory.ll,
  7551: CharacterCategory.ll,
  7552: CharacterCategory.ll,
  7553: CharacterCategory.ll,
  7554: CharacterCategory.ll,
  7555: CharacterCategory.ll,
  7556: CharacterCategory.ll,
  7557: CharacterCategory.ll,
  7558: CharacterCategory.ll,
  7559: CharacterCategory.ll,
  7560: CharacterCategory.ll,
  7561: CharacterCategory.ll,
  7562: CharacterCategory.ll,
  7563: CharacterCategory.ll,
  7564: CharacterCategory.ll,
  7565: CharacterCategory.ll,
  7566: CharacterCategory.ll,
  7567: CharacterCategory.ll,
  7568: CharacterCategory.ll,
  7569: CharacterCategory.ll,
  7570: CharacterCategory.ll,
  7571: CharacterCategory.ll,
  7572: CharacterCategory.ll,
  7573: CharacterCategory.ll,
  7574: CharacterCategory.ll,
  7575: CharacterCategory.ll,
  7576: CharacterCategory.ll,
  7577: CharacterCategory.ll,
  7578: CharacterCategory.ll,
  7681: CharacterCategory.ll,
  7683: CharacterCategory.ll,
  7685: CharacterCategory.ll,
  7687: CharacterCategory.ll,
  7689: CharacterCategory.ll,
  7691: CharacterCategory.ll,
  7693: CharacterCategory.ll,
  7695: CharacterCategory.ll,
  7697: CharacterCategory.ll,
  7699: CharacterCategory.ll,
  7701: CharacterCategory.ll,
  7703: CharacterCategory.ll,
  7705: CharacterCategory.ll,
  7707: CharacterCategory.ll,
  7709: CharacterCategory.ll,
  7711: CharacterCategory.ll,
  7713: CharacterCategory.ll,
  7715: CharacterCategory.ll,
  7717: CharacterCategory.ll,
  7719: CharacterCategory.ll,
  7721: CharacterCategory.ll,
  7723: CharacterCategory.ll,
  7725: CharacterCategory.ll,
  7727: CharacterCategory.ll,
  7729: CharacterCategory.ll,
  7731: CharacterCategory.ll,
  7733: CharacterCategory.ll,
  7735: CharacterCategory.ll,
  7737: CharacterCategory.ll,
  7739: CharacterCategory.ll,
  7741: CharacterCategory.ll,
  7743: CharacterCategory.ll,
  7745: CharacterCategory.ll,
  7747: CharacterCategory.ll,
  7749: CharacterCategory.ll,
  7751: CharacterCategory.ll,
  7753: CharacterCategory.ll,
  7755: CharacterCategory.ll,
  7757: CharacterCategory.ll,
  7759: CharacterCategory.ll,
  7761: CharacterCategory.ll,
  7763: CharacterCategory.ll,
  7765: CharacterCategory.ll,
  7767: CharacterCategory.ll,
  7769: CharacterCategory.ll,
  7771: CharacterCategory.ll,
  7773: CharacterCategory.ll,
  7775: CharacterCategory.ll,
  7777: CharacterCategory.ll,
  7779: CharacterCategory.ll,
  7781: CharacterCategory.ll,
  7783: CharacterCategory.ll,
  7785: CharacterCategory.ll,
  7787: CharacterCategory.ll,
  7789: CharacterCategory.ll,
  7791: CharacterCategory.ll,
  7793: CharacterCategory.ll,
  7795: CharacterCategory.ll,
  7797: CharacterCategory.ll,
  7799: CharacterCategory.ll,
  7801: CharacterCategory.ll,
  7803: CharacterCategory.ll,
  7805: CharacterCategory.ll,
  7807: CharacterCategory.ll,
  7809: CharacterCategory.ll,
  7811: CharacterCategory.ll,
  7813: CharacterCategory.ll,
  7815: CharacterCategory.ll,
  7817: CharacterCategory.ll,
  7819: CharacterCategory.ll,
  7821: CharacterCategory.ll,
  7823: CharacterCategory.ll,
  7825: CharacterCategory.ll,
  7827: CharacterCategory.ll,
  7829: CharacterCategory.ll,
  7830: CharacterCategory.ll,
  7831: CharacterCategory.ll,
  7832: CharacterCategory.ll,
  7833: CharacterCategory.ll,
  7834: CharacterCategory.ll,
  7835: CharacterCategory.ll,
  7836: CharacterCategory.ll,
  7837: CharacterCategory.ll,
  7839: CharacterCategory.ll,
  7841: CharacterCategory.ll,
  7843: CharacterCategory.ll,
  7845: CharacterCategory.ll,
  7847: CharacterCategory.ll,
  7849: CharacterCategory.ll,
  7851: CharacterCategory.ll,
  7853: CharacterCategory.ll,
  7855: CharacterCategory.ll,
  7857: CharacterCategory.ll,
  7859: CharacterCategory.ll,
  7861: CharacterCategory.ll,
  7863: CharacterCategory.ll,
  7865: CharacterCategory.ll,
  7867: CharacterCategory.ll,
  7869: CharacterCategory.ll,
  7871: CharacterCategory.ll,
  7873: CharacterCategory.ll,
  7875: CharacterCategory.ll,
  7877: CharacterCategory.ll,
  7879: CharacterCategory.ll,
  7881: CharacterCategory.ll,
  7883: CharacterCategory.ll,
  7885: CharacterCategory.ll,
  7887: CharacterCategory.ll,
  7889: CharacterCategory.ll,
  7891: CharacterCategory.ll,
  7893: CharacterCategory.ll,
  7895: CharacterCategory.ll,
  7897: CharacterCategory.ll,
  7899: CharacterCategory.ll,
  7901: CharacterCategory.ll,
  7903: CharacterCategory.ll,
  7905: CharacterCategory.ll,
  7907: CharacterCategory.ll,
  7909: CharacterCategory.ll,
  7911: CharacterCategory.ll,
  7913: CharacterCategory.ll,
  7915: CharacterCategory.ll,
  7917: CharacterCategory.ll,
  7919: CharacterCategory.ll,
  7921: CharacterCategory.ll,
  7923: CharacterCategory.ll,
  7925: CharacterCategory.ll,
  7927: CharacterCategory.ll,
  7929: CharacterCategory.ll,
  7931: CharacterCategory.ll,
  7933: CharacterCategory.ll,
  7935: CharacterCategory.ll,
  7936: CharacterCategory.ll,
  7937: CharacterCategory.ll,
  7938: CharacterCategory.ll,
  7939: CharacterCategory.ll,
  7940: CharacterCategory.ll,
  7941: CharacterCategory.ll,
  7942: CharacterCategory.ll,
  7943: CharacterCategory.ll,
  7952: CharacterCategory.ll,
  7953: CharacterCategory.ll,
  7954: CharacterCategory.ll,
  7955: CharacterCategory.ll,
  7956: CharacterCategory.ll,
  7957: CharacterCategory.ll,
  7968: CharacterCategory.ll,
  7969: CharacterCategory.ll,
  7970: CharacterCategory.ll,
  7971: CharacterCategory.ll,
  7972: CharacterCategory.ll,
  7973: CharacterCategory.ll,
  7974: CharacterCategory.ll,
  7975: CharacterCategory.ll,
  7984: CharacterCategory.ll,
  7985: CharacterCategory.ll,
  7986: CharacterCategory.ll,
  7987: CharacterCategory.ll,
  7988: CharacterCategory.ll,
  7989: CharacterCategory.ll,
  7990: CharacterCategory.ll,
  7991: CharacterCategory.ll,
  8000: CharacterCategory.ll,
  8001: CharacterCategory.ll,
  8002: CharacterCategory.ll,
  8003: CharacterCategory.ll,
  8004: CharacterCategory.ll,
  8005: CharacterCategory.ll,
  8016: CharacterCategory.ll,
  8017: CharacterCategory.ll,
  8018: CharacterCategory.ll,
  8019: CharacterCategory.ll,
  8020: CharacterCategory.ll,
  8021: CharacterCategory.ll,
  8022: CharacterCategory.ll,
  8023: CharacterCategory.ll,
  8032: CharacterCategory.ll,
  8033: CharacterCategory.ll,
  8034: CharacterCategory.ll,
  8035: CharacterCategory.ll,
  8036: CharacterCategory.ll,
  8037: CharacterCategory.ll,
  8038: CharacterCategory.ll,
  8039: CharacterCategory.ll,
  8048: CharacterCategory.ll,
  8049: CharacterCategory.ll,
  8050: CharacterCategory.ll,
  8051: CharacterCategory.ll,
  8052: CharacterCategory.ll,
  8053: CharacterCategory.ll,
  8054: CharacterCategory.ll,
  8055: CharacterCategory.ll,
  8056: CharacterCategory.ll,
  8057: CharacterCategory.ll,
  8058: CharacterCategory.ll,
  8059: CharacterCategory.ll,
  8060: CharacterCategory.ll,
  8061: CharacterCategory.ll,
  8064: CharacterCategory.ll,
  8065: CharacterCategory.ll,
  8066: CharacterCategory.ll,
  8067: CharacterCategory.ll,
  8068: CharacterCategory.ll,
  8069: CharacterCategory.ll,
  8070: CharacterCategory.ll,
  8071: CharacterCategory.ll,
  8080: CharacterCategory.ll,
  8081: CharacterCategory.ll,
  8082: CharacterCategory.ll,
  8083: CharacterCategory.ll,
  8084: CharacterCategory.ll,
  8085: CharacterCategory.ll,
  8086: CharacterCategory.ll,
  8087: CharacterCategory.ll,
  8096: CharacterCategory.ll,
  8097: CharacterCategory.ll,
  8098: CharacterCategory.ll,
  8099: CharacterCategory.ll,
  8100: CharacterCategory.ll,
  8101: CharacterCategory.ll,
  8102: CharacterCategory.ll,
  8103: CharacterCategory.ll,
  8112: CharacterCategory.ll,
  8113: CharacterCategory.ll,
  8114: CharacterCategory.ll,
  8115: CharacterCategory.ll,
  8116: CharacterCategory.ll,
  8118: CharacterCategory.ll,
  8119: CharacterCategory.ll,
  8126: CharacterCategory.ll,
  8130: CharacterCategory.ll,
  8131: CharacterCategory.ll,
  8132: CharacterCategory.ll,
  8134: CharacterCategory.ll,
  8135: CharacterCategory.ll,
  8144: CharacterCategory.ll,
  8145: CharacterCategory.ll,
  8146: CharacterCategory.ll,
  8147: CharacterCategory.ll,
  8150: CharacterCategory.ll,
  8151: CharacterCategory.ll,
  8160: CharacterCategory.ll,
  8161: CharacterCategory.ll,
  8162: CharacterCategory.ll,
  8163: CharacterCategory.ll,
  8164: CharacterCategory.ll,
  8165: CharacterCategory.ll,
  8166: CharacterCategory.ll,
  8167: CharacterCategory.ll,
  8178: CharacterCategory.ll,
  8179: CharacterCategory.ll,
  8180: CharacterCategory.ll,
  8182: CharacterCategory.ll,
  8183: CharacterCategory.ll,
  8458: CharacterCategory.ll,
  8462: CharacterCategory.ll,
  8463: CharacterCategory.ll,
  8467: CharacterCategory.ll,
  8495: CharacterCategory.ll,
  8500: CharacterCategory.ll,
  8505: CharacterCategory.ll,
  8508: CharacterCategory.ll,
  8509: CharacterCategory.ll,
  8518: CharacterCategory.ll,
  8519: CharacterCategory.ll,
  8520: CharacterCategory.ll,
  8521: CharacterCategory.ll,
  8526: CharacterCategory.ll,
  8580: CharacterCategory.ll,
  11312: CharacterCategory.ll,
  11313: CharacterCategory.ll,
  11314: CharacterCategory.ll,
  11315: CharacterCategory.ll,
  11316: CharacterCategory.ll,
  11317: CharacterCategory.ll,
  11318: CharacterCategory.ll,
  11319: CharacterCategory.ll,
  11320: CharacterCategory.ll,
  11321: CharacterCategory.ll,
  11322: CharacterCategory.ll,
  11323: CharacterCategory.ll,
  11324: CharacterCategory.ll,
  11325: CharacterCategory.ll,
  11326: CharacterCategory.ll,
  11327: CharacterCategory.ll,
  11328: CharacterCategory.ll,
  11329: CharacterCategory.ll,
  11330: CharacterCategory.ll,
  11331: CharacterCategory.ll,
  11332: CharacterCategory.ll,
  11333: CharacterCategory.ll,
  11334: CharacterCategory.ll,
  11335: CharacterCategory.ll,
  11336: CharacterCategory.ll,
  11337: CharacterCategory.ll,
  11338: CharacterCategory.ll,
  11339: CharacterCategory.ll,
  11340: CharacterCategory.ll,
  11341: CharacterCategory.ll,
  11342: CharacterCategory.ll,
  11343: CharacterCategory.ll,
  11344: CharacterCategory.ll,
  11345: CharacterCategory.ll,
  11346: CharacterCategory.ll,
  11347: CharacterCategory.ll,
  11348: CharacterCategory.ll,
  11349: CharacterCategory.ll,
  11350: CharacterCategory.ll,
  11351: CharacterCategory.ll,
  11352: CharacterCategory.ll,
  11353: CharacterCategory.ll,
  11354: CharacterCategory.ll,
  11355: CharacterCategory.ll,
  11356: CharacterCategory.ll,
  11357: CharacterCategory.ll,
  11358: CharacterCategory.ll,
  11361: CharacterCategory.ll,
  11365: CharacterCategory.ll,
  11366: CharacterCategory.ll,
  11368: CharacterCategory.ll,
  11370: CharacterCategory.ll,
  11372: CharacterCategory.ll,
  11377: CharacterCategory.ll,
  11379: CharacterCategory.ll,
  11380: CharacterCategory.ll,
  11382: CharacterCategory.ll,
  11383: CharacterCategory.ll,
  11384: CharacterCategory.ll,
  11385: CharacterCategory.ll,
  11386: CharacterCategory.ll,
  11387: CharacterCategory.ll,
  11393: CharacterCategory.ll,
  11395: CharacterCategory.ll,
  11397: CharacterCategory.ll,
  11399: CharacterCategory.ll,
  11401: CharacterCategory.ll,
  11403: CharacterCategory.ll,
  11405: CharacterCategory.ll,
  11407: CharacterCategory.ll,
  11409: CharacterCategory.ll,
  11411: CharacterCategory.ll,
  11413: CharacterCategory.ll,
  11415: CharacterCategory.ll,
  11417: CharacterCategory.ll,
  11419: CharacterCategory.ll,
  11421: CharacterCategory.ll,
  11423: CharacterCategory.ll,
  11425: CharacterCategory.ll,
  11427: CharacterCategory.ll,
  11429: CharacterCategory.ll,
  11431: CharacterCategory.ll,
  11433: CharacterCategory.ll,
  11435: CharacterCategory.ll,
  11437: CharacterCategory.ll,
  11439: CharacterCategory.ll,
  11441: CharacterCategory.ll,
  11443: CharacterCategory.ll,
  11445: CharacterCategory.ll,
  11447: CharacterCategory.ll,
  11449: CharacterCategory.ll,
  11451: CharacterCategory.ll,
  11453: CharacterCategory.ll,
  11455: CharacterCategory.ll,
  11457: CharacterCategory.ll,
  11459: CharacterCategory.ll,
  11461: CharacterCategory.ll,
  11463: CharacterCategory.ll,
  11465: CharacterCategory.ll,
  11467: CharacterCategory.ll,
  11469: CharacterCategory.ll,
  11471: CharacterCategory.ll,
  11473: CharacterCategory.ll,
  11475: CharacterCategory.ll,
  11477: CharacterCategory.ll,
  11479: CharacterCategory.ll,
  11481: CharacterCategory.ll,
  11483: CharacterCategory.ll,
  11485: CharacterCategory.ll,
  11487: CharacterCategory.ll,
  11489: CharacterCategory.ll,
  11491: CharacterCategory.ll,
  11492: CharacterCategory.ll,
  11500: CharacterCategory.ll,
  11502: CharacterCategory.ll,
  11507: CharacterCategory.ll,
  11520: CharacterCategory.ll,
  11521: CharacterCategory.ll,
  11522: CharacterCategory.ll,
  11523: CharacterCategory.ll,
  11524: CharacterCategory.ll,
  11525: CharacterCategory.ll,
  11526: CharacterCategory.ll,
  11527: CharacterCategory.ll,
  11528: CharacterCategory.ll,
  11529: CharacterCategory.ll,
  11530: CharacterCategory.ll,
  11531: CharacterCategory.ll,
  11532: CharacterCategory.ll,
  11533: CharacterCategory.ll,
  11534: CharacterCategory.ll,
  11535: CharacterCategory.ll,
  11536: CharacterCategory.ll,
  11537: CharacterCategory.ll,
  11538: CharacterCategory.ll,
  11539: CharacterCategory.ll,
  11540: CharacterCategory.ll,
  11541: CharacterCategory.ll,
  11542: CharacterCategory.ll,
  11543: CharacterCategory.ll,
  11544: CharacterCategory.ll,
  11545: CharacterCategory.ll,
  11546: CharacterCategory.ll,
  11547: CharacterCategory.ll,
  11548: CharacterCategory.ll,
  11549: CharacterCategory.ll,
  11550: CharacterCategory.ll,
  11551: CharacterCategory.ll,
  11552: CharacterCategory.ll,
  11553: CharacterCategory.ll,
  11554: CharacterCategory.ll,
  11555: CharacterCategory.ll,
  11556: CharacterCategory.ll,
  11557: CharacterCategory.ll,
  11559: CharacterCategory.ll,
  11565: CharacterCategory.ll,
  42561: CharacterCategory.ll,
  42563: CharacterCategory.ll,
  42565: CharacterCategory.ll,
  42567: CharacterCategory.ll,
  42569: CharacterCategory.ll,
  42571: CharacterCategory.ll,
  42573: CharacterCategory.ll,
  42575: CharacterCategory.ll,
  42577: CharacterCategory.ll,
  42579: CharacterCategory.ll,
  42581: CharacterCategory.ll,
  42583: CharacterCategory.ll,
  42585: CharacterCategory.ll,
  42587: CharacterCategory.ll,
  42589: CharacterCategory.ll,
  42591: CharacterCategory.ll,
  42593: CharacterCategory.ll,
  42595: CharacterCategory.ll,
  42597: CharacterCategory.ll,
  42599: CharacterCategory.ll,
  42601: CharacterCategory.ll,
  42603: CharacterCategory.ll,
  42605: CharacterCategory.ll,
  42625: CharacterCategory.ll,
  42627: CharacterCategory.ll,
  42629: CharacterCategory.ll,
  42631: CharacterCategory.ll,
  42633: CharacterCategory.ll,
  42635: CharacterCategory.ll,
  42637: CharacterCategory.ll,
  42639: CharacterCategory.ll,
  42641: CharacterCategory.ll,
  42643: CharacterCategory.ll,
  42645: CharacterCategory.ll,
  42647: CharacterCategory.ll,
  42649: CharacterCategory.ll,
  42651: CharacterCategory.ll,
  42787: CharacterCategory.ll,
  42789: CharacterCategory.ll,
  42791: CharacterCategory.ll,
  42793: CharacterCategory.ll,
  42795: CharacterCategory.ll,
  42797: CharacterCategory.ll,
  42799: CharacterCategory.ll,
  42800: CharacterCategory.ll,
  42801: CharacterCategory.ll,
  42803: CharacterCategory.ll,
  42805: CharacterCategory.ll,
  42807: CharacterCategory.ll,
  42809: CharacterCategory.ll,
  42811: CharacterCategory.ll,
  42813: CharacterCategory.ll,
  42815: CharacterCategory.ll,
  42817: CharacterCategory.ll,
  42819: CharacterCategory.ll,
  42821: CharacterCategory.ll,
  42823: CharacterCategory.ll,
  42825: CharacterCategory.ll,
  42827: CharacterCategory.ll,
  42829: CharacterCategory.ll,
  42831: CharacterCategory.ll,
  42833: CharacterCategory.ll,
  42835: CharacterCategory.ll,
  42837: CharacterCategory.ll,
  42839: CharacterCategory.ll,
  42841: CharacterCategory.ll,
  42843: CharacterCategory.ll,
  42845: CharacterCategory.ll,
  42847: CharacterCategory.ll,
  42849: CharacterCategory.ll,
  42851: CharacterCategory.ll,
  42853: CharacterCategory.ll,
  42855: CharacterCategory.ll,
  42857: CharacterCategory.ll,
  42859: CharacterCategory.ll,
  42861: CharacterCategory.ll,
  42863: CharacterCategory.ll,
  42865: CharacterCategory.ll,
  42866: CharacterCategory.ll,
  42867: CharacterCategory.ll,
  42868: CharacterCategory.ll,
  42869: CharacterCategory.ll,
  42870: CharacterCategory.ll,
  42871: CharacterCategory.ll,
  42872: CharacterCategory.ll,
  42874: CharacterCategory.ll,
  42876: CharacterCategory.ll,
  42879: CharacterCategory.ll,
  42881: CharacterCategory.ll,
  42883: CharacterCategory.ll,
  42885: CharacterCategory.ll,
  42887: CharacterCategory.ll,
  42892: CharacterCategory.ll,
  42894: CharacterCategory.ll,
  42897: CharacterCategory.ll,
  42899: CharacterCategory.ll,
  42900: CharacterCategory.ll,
  42901: CharacterCategory.ll,
  42903: CharacterCategory.ll,
  42905: CharacterCategory.ll,
  42907: CharacterCategory.ll,
  42909: CharacterCategory.ll,
  42911: CharacterCategory.ll,
  42913: CharacterCategory.ll,
  42915: CharacterCategory.ll,
  42917: CharacterCategory.ll,
  42919: CharacterCategory.ll,
  42921: CharacterCategory.ll,
  43002: CharacterCategory.ll,
  43824: CharacterCategory.ll,
  43825: CharacterCategory.ll,
  43826: CharacterCategory.ll,
  43827: CharacterCategory.ll,
  43828: CharacterCategory.ll,
  43829: CharacterCategory.ll,
  43830: CharacterCategory.ll,
  43831: CharacterCategory.ll,
  43832: CharacterCategory.ll,
  43833: CharacterCategory.ll,
  43834: CharacterCategory.ll,
  43835: CharacterCategory.ll,
  43836: CharacterCategory.ll,
  43837: CharacterCategory.ll,
  43838: CharacterCategory.ll,
  43839: CharacterCategory.ll,
  43840: CharacterCategory.ll,
  43841: CharacterCategory.ll,
  43842: CharacterCategory.ll,
  43843: CharacterCategory.ll,
  43844: CharacterCategory.ll,
  43845: CharacterCategory.ll,
  43846: CharacterCategory.ll,
  43847: CharacterCategory.ll,
  43848: CharacterCategory.ll,
  43849: CharacterCategory.ll,
  43850: CharacterCategory.ll,
  43851: CharacterCategory.ll,
  43852: CharacterCategory.ll,
  43853: CharacterCategory.ll,
  43854: CharacterCategory.ll,
  43855: CharacterCategory.ll,
  43856: CharacterCategory.ll,
  43857: CharacterCategory.ll,
  43858: CharacterCategory.ll,
  43859: CharacterCategory.ll,
  43860: CharacterCategory.ll,
  43861: CharacterCategory.ll,
  43862: CharacterCategory.ll,
  43863: CharacterCategory.ll,
  43864: CharacterCategory.ll,
  43865: CharacterCategory.ll,
  43866: CharacterCategory.ll,
  43876: CharacterCategory.ll,
  43877: CharacterCategory.ll,
  64256: CharacterCategory.ll,
  64257: CharacterCategory.ll,
  64258: CharacterCategory.ll,
  64259: CharacterCategory.ll,
  64260: CharacterCategory.ll,
  64261: CharacterCategory.ll,
  64262: CharacterCategory.ll,
  64275: CharacterCategory.ll,
  64276: CharacterCategory.ll,
  64277: CharacterCategory.ll,
  64278: CharacterCategory.ll,
  64279: CharacterCategory.ll,
  65345: CharacterCategory.ll,
  65346: CharacterCategory.ll,
  65347: CharacterCategory.ll,
  65348: CharacterCategory.ll,
  65349: CharacterCategory.ll,
  65350: CharacterCategory.ll,
  65351: CharacterCategory.ll,
  65352: CharacterCategory.ll,
  65353: CharacterCategory.ll,
  65354: CharacterCategory.ll,
  65355: CharacterCategory.ll,
  65356: CharacterCategory.ll,
  65357: CharacterCategory.ll,
  65358: CharacterCategory.ll,
  65359: CharacterCategory.ll,
  65360: CharacterCategory.ll,
  65361: CharacterCategory.ll,
  65362: CharacterCategory.ll,
  65363: CharacterCategory.ll,
  65364: CharacterCategory.ll,
  65365: CharacterCategory.ll,
  65366: CharacterCategory.ll,
  65367: CharacterCategory.ll,
  65368: CharacterCategory.ll,
  65369: CharacterCategory.ll,
  65370: CharacterCategory.ll,
  453: CharacterCategory.lt,
  456: CharacterCategory.lt,
  459: CharacterCategory.lt,
  498: CharacterCategory.lt,
  8072: CharacterCategory.lt,
  8073: CharacterCategory.lt,
  8074: CharacterCategory.lt,
  8075: CharacterCategory.lt,
  8076: CharacterCategory.lt,
  8077: CharacterCategory.lt,
  8078: CharacterCategory.lt,
  8079: CharacterCategory.lt,
  8088: CharacterCategory.lt,
  8089: CharacterCategory.lt,
  8090: CharacterCategory.lt,
  8091: CharacterCategory.lt,
  8092: CharacterCategory.lt,
  8093: CharacterCategory.lt,
  8094: CharacterCategory.lt,
  8095: CharacterCategory.lt,
  8104: CharacterCategory.lt,
  8105: CharacterCategory.lt,
  8106: CharacterCategory.lt,
  8107: CharacterCategory.lt,
  8108: CharacterCategory.lt,
  8109: CharacterCategory.lt,
  8110: CharacterCategory.lt,
  8111: CharacterCategory.lt,
  8124: CharacterCategory.lt,
  8140: CharacterCategory.lt,
  8188: CharacterCategory.lt,
  688: CharacterCategory.lm,
  689: CharacterCategory.lm,
  690: CharacterCategory.lm,
  691: CharacterCategory.lm,
  692: CharacterCategory.lm,
  693: CharacterCategory.lm,
  694: CharacterCategory.lm,
  695: CharacterCategory.lm,
  696: CharacterCategory.lm,
  697: CharacterCategory.lm,
  698: CharacterCategory.lm,
  699: CharacterCategory.lm,
  700: CharacterCategory.lm,
  701: CharacterCategory.lm,
  702: CharacterCategory.lm,
  703: CharacterCategory.lm,
  704: CharacterCategory.lm,
  705: CharacterCategory.lm,
  710: CharacterCategory.lm,
  711: CharacterCategory.lm,
  712: CharacterCategory.lm,
  713: CharacterCategory.lm,
  714: CharacterCategory.lm,
  715: CharacterCategory.lm,
  716: CharacterCategory.lm,
  717: CharacterCategory.lm,
  718: CharacterCategory.lm,
  719: CharacterCategory.lm,
  720: CharacterCategory.lm,
  721: CharacterCategory.lm,
  736: CharacterCategory.lm,
  737: CharacterCategory.lm,
  738: CharacterCategory.lm,
  739: CharacterCategory.lm,
  740: CharacterCategory.lm,
  748: CharacterCategory.lm,
  750: CharacterCategory.lm,
  884: CharacterCategory.lm,
  890: CharacterCategory.lm,
  1369: CharacterCategory.lm,
  1600: CharacterCategory.lm,
  1765: CharacterCategory.lm,
  1766: CharacterCategory.lm,
  2036: CharacterCategory.lm,
  2037: CharacterCategory.lm,
  2042: CharacterCategory.lm,
  2074: CharacterCategory.lm,
  2084: CharacterCategory.lm,
  2088: CharacterCategory.lm,
  2417: CharacterCategory.lm,
  3654: CharacterCategory.lm,
  3782: CharacterCategory.lm,
  4348: CharacterCategory.lm,
  6103: CharacterCategory.lm,
  6211: CharacterCategory.lm,
  6823: CharacterCategory.lm,
  7288: CharacterCategory.lm,
  7289: CharacterCategory.lm,
  7290: CharacterCategory.lm,
  7291: CharacterCategory.lm,
  7292: CharacterCategory.lm,
  7293: CharacterCategory.lm,
  7468: CharacterCategory.lm,
  7469: CharacterCategory.lm,
  7470: CharacterCategory.lm,
  7471: CharacterCategory.lm,
  7472: CharacterCategory.lm,
  7473: CharacterCategory.lm,
  7474: CharacterCategory.lm,
  7475: CharacterCategory.lm,
  7476: CharacterCategory.lm,
  7477: CharacterCategory.lm,
  7478: CharacterCategory.lm,
  7479: CharacterCategory.lm,
  7480: CharacterCategory.lm,
  7481: CharacterCategory.lm,
  7482: CharacterCategory.lm,
  7483: CharacterCategory.lm,
  7484: CharacterCategory.lm,
  7485: CharacterCategory.lm,
  7486: CharacterCategory.lm,
  7487: CharacterCategory.lm,
  7488: CharacterCategory.lm,
  7489: CharacterCategory.lm,
  7490: CharacterCategory.lm,
  7491: CharacterCategory.lm,
  7492: CharacterCategory.lm,
  7493: CharacterCategory.lm,
  7494: CharacterCategory.lm,
  7495: CharacterCategory.lm,
  7496: CharacterCategory.lm,
  7497: CharacterCategory.lm,
  7498: CharacterCategory.lm,
  7499: CharacterCategory.lm,
  7500: CharacterCategory.lm,
  7501: CharacterCategory.lm,
  7502: CharacterCategory.lm,
  7503: CharacterCategory.lm,
  7504: CharacterCategory.lm,
  7505: CharacterCategory.lm,
  7506: CharacterCategory.lm,
  7507: CharacterCategory.lm,
  7508: CharacterCategory.lm,
  7509: CharacterCategory.lm,
  7510: CharacterCategory.lm,
  7511: CharacterCategory.lm,
  7512: CharacterCategory.lm,
  7513: CharacterCategory.lm,
  7514: CharacterCategory.lm,
  7515: CharacterCategory.lm,
  7516: CharacterCategory.lm,
  7517: CharacterCategory.lm,
  7518: CharacterCategory.lm,
  7519: CharacterCategory.lm,
  7520: CharacterCategory.lm,
  7521: CharacterCategory.lm,
  7522: CharacterCategory.lm,
  7523: CharacterCategory.lm,
  7524: CharacterCategory.lm,
  7525: CharacterCategory.lm,
  7526: CharacterCategory.lm,
  7527: CharacterCategory.lm,
  7528: CharacterCategory.lm,
  7529: CharacterCategory.lm,
  7530: CharacterCategory.lm,
  7544: CharacterCategory.lm,
  7579: CharacterCategory.lm,
  7580: CharacterCategory.lm,
  7581: CharacterCategory.lm,
  7582: CharacterCategory.lm,
  7583: CharacterCategory.lm,
  7584: CharacterCategory.lm,
  7585: CharacterCategory.lm,
  7586: CharacterCategory.lm,
  7587: CharacterCategory.lm,
  7588: CharacterCategory.lm,
  7589: CharacterCategory.lm,
  7590: CharacterCategory.lm,
  7591: CharacterCategory.lm,
  7592: CharacterCategory.lm,
  7593: CharacterCategory.lm,
  7594: CharacterCategory.lm,
  7595: CharacterCategory.lm,
  7596: CharacterCategory.lm,
  7597: CharacterCategory.lm,
  7598: CharacterCategory.lm,
  7599: CharacterCategory.lm,
  7600: CharacterCategory.lm,
  7601: CharacterCategory.lm,
  7602: CharacterCategory.lm,
  7603: CharacterCategory.lm,
  7604: CharacterCategory.lm,
  7605: CharacterCategory.lm,
  7606: CharacterCategory.lm,
  7607: CharacterCategory.lm,
  7608: CharacterCategory.lm,
  7609: CharacterCategory.lm,
  7610: CharacterCategory.lm,
  7611: CharacterCategory.lm,
  7612: CharacterCategory.lm,
  7613: CharacterCategory.lm,
  7614: CharacterCategory.lm,
  7615: CharacterCategory.lm,
  8305: CharacterCategory.lm,
  8319: CharacterCategory.lm,
  8336: CharacterCategory.lm,
  8337: CharacterCategory.lm,
  8338: CharacterCategory.lm,
  8339: CharacterCategory.lm,
  8340: CharacterCategory.lm,
  8341: CharacterCategory.lm,
  8342: CharacterCategory.lm,
  8343: CharacterCategory.lm,
  8344: CharacterCategory.lm,
  8345: CharacterCategory.lm,
  8346: CharacterCategory.lm,
  8347: CharacterCategory.lm,
  8348: CharacterCategory.lm,
  11388: CharacterCategory.lm,
  11389: CharacterCategory.lm,
  11631: CharacterCategory.lm,
  11823: CharacterCategory.lm,
  12293: CharacterCategory.lm,
  12337: CharacterCategory.lm,
  12338: CharacterCategory.lm,
  12339: CharacterCategory.lm,
  12340: CharacterCategory.lm,
  12341: CharacterCategory.lm,
  12347: CharacterCategory.lm,
  12445: CharacterCategory.lm,
  12446: CharacterCategory.lm,
  12540: CharacterCategory.lm,
  12541: CharacterCategory.lm,
  12542: CharacterCategory.lm,
  40981: CharacterCategory.lm,
  42232: CharacterCategory.lm,
  42233: CharacterCategory.lm,
  42234: CharacterCategory.lm,
  42235: CharacterCategory.lm,
  42236: CharacterCategory.lm,
  42237: CharacterCategory.lm,
  42508: CharacterCategory.lm,
  42623: CharacterCategory.lm,
  42652: CharacterCategory.lm,
  42653: CharacterCategory.lm,
  42775: CharacterCategory.lm,
  42776: CharacterCategory.lm,
  42777: CharacterCategory.lm,
  42778: CharacterCategory.lm,
  42779: CharacterCategory.lm,
  42780: CharacterCategory.lm,
  42781: CharacterCategory.lm,
  42782: CharacterCategory.lm,
  42783: CharacterCategory.lm,
  42864: CharacterCategory.lm,
  42888: CharacterCategory.lm,
  43000: CharacterCategory.lm,
  43001: CharacterCategory.lm,
  43471: CharacterCategory.lm,
  43494: CharacterCategory.lm,
  43632: CharacterCategory.lm,
  43741: CharacterCategory.lm,
  43763: CharacterCategory.lm,
  43764: CharacterCategory.lm,
  43868: CharacterCategory.lm,
  43869: CharacterCategory.lm,
  43870: CharacterCategory.lm,
  43871: CharacterCategory.lm,
  65392: CharacterCategory.lm,
  65438: CharacterCategory.lm,
  65439: CharacterCategory.lm,
  170: CharacterCategory.lo,
  186: CharacterCategory.lo,
  443: CharacterCategory.lo,
  448: CharacterCategory.lo,
  449: CharacterCategory.lo,
  450: CharacterCategory.lo,
  451: CharacterCategory.lo,
  660: CharacterCategory.lo,
  1488: CharacterCategory.lo,
  1489: CharacterCategory.lo,
  1490: CharacterCategory.lo,
  1491: CharacterCategory.lo,
  1492: CharacterCategory.lo,
  1493: CharacterCategory.lo,
  1494: CharacterCategory.lo,
  1495: CharacterCategory.lo,
  1496: CharacterCategory.lo,
  1497: CharacterCategory.lo,
  1498: CharacterCategory.lo,
  1499: CharacterCategory.lo,
  1500: CharacterCategory.lo,
  1501: CharacterCategory.lo,
  1502: CharacterCategory.lo,
  1503: CharacterCategory.lo,
  1504: CharacterCategory.lo,
  1505: CharacterCategory.lo,
  1506: CharacterCategory.lo,
  1507: CharacterCategory.lo,
  1508: CharacterCategory.lo,
  1509: CharacterCategory.lo,
  1510: CharacterCategory.lo,
  1511: CharacterCategory.lo,
  1512: CharacterCategory.lo,
  1513: CharacterCategory.lo,
  1514: CharacterCategory.lo,
  1520: CharacterCategory.lo,
  1521: CharacterCategory.lo,
  1522: CharacterCategory.lo,
  1568: CharacterCategory.lo,
  1569: CharacterCategory.lo,
  1570: CharacterCategory.lo,
  1571: CharacterCategory.lo,
  1572: CharacterCategory.lo,
  1573: CharacterCategory.lo,
  1574: CharacterCategory.lo,
  1575: CharacterCategory.lo,
  1576: CharacterCategory.lo,
  1577: CharacterCategory.lo,
  1578: CharacterCategory.lo,
  1579: CharacterCategory.lo,
  1580: CharacterCategory.lo,
  1581: CharacterCategory.lo,
  1582: CharacterCategory.lo,
  1583: CharacterCategory.lo,
  1584: CharacterCategory.lo,
  1585: CharacterCategory.lo,
  1586: CharacterCategory.lo,
  1587: CharacterCategory.lo,
  1588: CharacterCategory.lo,
  1589: CharacterCategory.lo,
  1590: CharacterCategory.lo,
  1591: CharacterCategory.lo,
  1592: CharacterCategory.lo,
  1593: CharacterCategory.lo,
  1594: CharacterCategory.lo,
  1595: CharacterCategory.lo,
  1596: CharacterCategory.lo,
  1597: CharacterCategory.lo,
  1598: CharacterCategory.lo,
  1599: CharacterCategory.lo,
  1601: CharacterCategory.lo,
  1602: CharacterCategory.lo,
  1603: CharacterCategory.lo,
  1604: CharacterCategory.lo,
  1605: CharacterCategory.lo,
  1606: CharacterCategory.lo,
  1607: CharacterCategory.lo,
  1608: CharacterCategory.lo,
  1609: CharacterCategory.lo,
  1610: CharacterCategory.lo,
  1646: CharacterCategory.lo,
  1647: CharacterCategory.lo,
  1649: CharacterCategory.lo,
  1650: CharacterCategory.lo,
  1651: CharacterCategory.lo,
  1652: CharacterCategory.lo,
  1653: CharacterCategory.lo,
  1654: CharacterCategory.lo,
  1655: CharacterCategory.lo,
  1656: CharacterCategory.lo,
  1657: CharacterCategory.lo,
  1658: CharacterCategory.lo,
  1659: CharacterCategory.lo,
  1660: CharacterCategory.lo,
  1661: CharacterCategory.lo,
  1662: CharacterCategory.lo,
  1663: CharacterCategory.lo,
  1664: CharacterCategory.lo,
  1665: CharacterCategory.lo,
  1666: CharacterCategory.lo,
  1667: CharacterCategory.lo,
  1668: CharacterCategory.lo,
  1669: CharacterCategory.lo,
  1670: CharacterCategory.lo,
  1671: CharacterCategory.lo,
  1672: CharacterCategory.lo,
  1673: CharacterCategory.lo,
  1674: CharacterCategory.lo,
  1675: CharacterCategory.lo,
  1676: CharacterCategory.lo,
  1677: CharacterCategory.lo,
  1678: CharacterCategory.lo,
  1679: CharacterCategory.lo,
  1680: CharacterCategory.lo,
  1681: CharacterCategory.lo,
  1682: CharacterCategory.lo,
  1683: CharacterCategory.lo,
  1684: CharacterCategory.lo,
  1685: CharacterCategory.lo,
  1686: CharacterCategory.lo,
  1687: CharacterCategory.lo,
  1688: CharacterCategory.lo,
  1689: CharacterCategory.lo,
  1690: CharacterCategory.lo,
  1691: CharacterCategory.lo,
  1692: CharacterCategory.lo,
  1693: CharacterCategory.lo,
  1694: CharacterCategory.lo,
  1695: CharacterCategory.lo,
  1696: CharacterCategory.lo,
  1697: CharacterCategory.lo,
  1698: CharacterCategory.lo,
  1699: CharacterCategory.lo,
  1700: CharacterCategory.lo,
  1701: CharacterCategory.lo,
  1702: CharacterCategory.lo,
  1703: CharacterCategory.lo,
  1704: CharacterCategory.lo,
  1705: CharacterCategory.lo,
  1706: CharacterCategory.lo,
  1707: CharacterCategory.lo,
  1708: CharacterCategory.lo,
  1709: CharacterCategory.lo,
  1710: CharacterCategory.lo,
  1711: CharacterCategory.lo,
  1712: CharacterCategory.lo,
  1713: CharacterCategory.lo,
  1714: CharacterCategory.lo,
  1715: CharacterCategory.lo,
  1716: CharacterCategory.lo,
  1717: CharacterCategory.lo,
  1718: CharacterCategory.lo,
  1719: CharacterCategory.lo,
  1720: CharacterCategory.lo,
  1721: CharacterCategory.lo,
  1722: CharacterCategory.lo,
  1723: CharacterCategory.lo,
  1724: CharacterCategory.lo,
  1725: CharacterCategory.lo,
  1726: CharacterCategory.lo,
  1727: CharacterCategory.lo,
  1728: CharacterCategory.lo,
  1729: CharacterCategory.lo,
  1730: CharacterCategory.lo,
  1731: CharacterCategory.lo,
  1732: CharacterCategory.lo,
  1733: CharacterCategory.lo,
  1734: CharacterCategory.lo,
  1735: CharacterCategory.lo,
  1736: CharacterCategory.lo,
  1737: CharacterCategory.lo,
  1738: CharacterCategory.lo,
  1739: CharacterCategory.lo,
  1740: CharacterCategory.lo,
  1741: CharacterCategory.lo,
  1742: CharacterCategory.lo,
  1743: CharacterCategory.lo,
  1744: CharacterCategory.lo,
  1745: CharacterCategory.lo,
  1746: CharacterCategory.lo,
  1747: CharacterCategory.lo,
  1749: CharacterCategory.lo,
  1774: CharacterCategory.lo,
  1775: CharacterCategory.lo,
  1786: CharacterCategory.lo,
  1787: CharacterCategory.lo,
  1788: CharacterCategory.lo,
  1791: CharacterCategory.lo,
  1808: CharacterCategory.lo,
  1810: CharacterCategory.lo,
  1811: CharacterCategory.lo,
  1812: CharacterCategory.lo,
  1813: CharacterCategory.lo,
  1814: CharacterCategory.lo,
  1815: CharacterCategory.lo,
  1816: CharacterCategory.lo,
  1817: CharacterCategory.lo,
  1818: CharacterCategory.lo,
  1819: CharacterCategory.lo,
  1820: CharacterCategory.lo,
  1821: CharacterCategory.lo,
  1822: CharacterCategory.lo,
  1823: CharacterCategory.lo,
  1824: CharacterCategory.lo,
  1825: CharacterCategory.lo,
  1826: CharacterCategory.lo,
  1827: CharacterCategory.lo,
  1828: CharacterCategory.lo,
  1829: CharacterCategory.lo,
  1830: CharacterCategory.lo,
  1831: CharacterCategory.lo,
  1832: CharacterCategory.lo,
  1833: CharacterCategory.lo,
  1834: CharacterCategory.lo,
  1835: CharacterCategory.lo,
  1836: CharacterCategory.lo,
  1837: CharacterCategory.lo,
  1838: CharacterCategory.lo,
  1839: CharacterCategory.lo,
  1869: CharacterCategory.lo,
  1870: CharacterCategory.lo,
  1871: CharacterCategory.lo,
  1872: CharacterCategory.lo,
  1873: CharacterCategory.lo,
  1874: CharacterCategory.lo,
  1875: CharacterCategory.lo,
  1876: CharacterCategory.lo,
  1877: CharacterCategory.lo,
  1878: CharacterCategory.lo,
  1879: CharacterCategory.lo,
  1880: CharacterCategory.lo,
  1881: CharacterCategory.lo,
  1882: CharacterCategory.lo,
  1883: CharacterCategory.lo,
  1884: CharacterCategory.lo,
  1885: CharacterCategory.lo,
  1886: CharacterCategory.lo,
  1887: CharacterCategory.lo,
  1888: CharacterCategory.lo,
  1889: CharacterCategory.lo,
  1890: CharacterCategory.lo,
  1891: CharacterCategory.lo,
  1892: CharacterCategory.lo,
  1893: CharacterCategory.lo,
  1894: CharacterCategory.lo,
  1895: CharacterCategory.lo,
  1896: CharacterCategory.lo,
  1897: CharacterCategory.lo,
  1898: CharacterCategory.lo,
  1899: CharacterCategory.lo,
  1900: CharacterCategory.lo,
  1901: CharacterCategory.lo,
  1902: CharacterCategory.lo,
  1903: CharacterCategory.lo,
  1904: CharacterCategory.lo,
  1905: CharacterCategory.lo,
  1906: CharacterCategory.lo,
  1907: CharacterCategory.lo,
  1908: CharacterCategory.lo,
  1909: CharacterCategory.lo,
  1910: CharacterCategory.lo,
  1911: CharacterCategory.lo,
  1912: CharacterCategory.lo,
  1913: CharacterCategory.lo,
  1914: CharacterCategory.lo,
  1915: CharacterCategory.lo,
  1916: CharacterCategory.lo,
  1917: CharacterCategory.lo,
  1918: CharacterCategory.lo,
  1919: CharacterCategory.lo,
  1920: CharacterCategory.lo,
  1921: CharacterCategory.lo,
  1922: CharacterCategory.lo,
  1923: CharacterCategory.lo,
  1924: CharacterCategory.lo,
  1925: CharacterCategory.lo,
  1926: CharacterCategory.lo,
  1927: CharacterCategory.lo,
  1928: CharacterCategory.lo,
  1929: CharacterCategory.lo,
  1930: CharacterCategory.lo,
  1931: CharacterCategory.lo,
  1932: CharacterCategory.lo,
  1933: CharacterCategory.lo,
  1934: CharacterCategory.lo,
  1935: CharacterCategory.lo,
  1936: CharacterCategory.lo,
  1937: CharacterCategory.lo,
  1938: CharacterCategory.lo,
  1939: CharacterCategory.lo,
  1940: CharacterCategory.lo,
  1941: CharacterCategory.lo,
  1942: CharacterCategory.lo,
  1943: CharacterCategory.lo,
  1944: CharacterCategory.lo,
  1945: CharacterCategory.lo,
  1946: CharacterCategory.lo,
  1947: CharacterCategory.lo,
  1948: CharacterCategory.lo,
  1949: CharacterCategory.lo,
  1950: CharacterCategory.lo,
  1951: CharacterCategory.lo,
  1952: CharacterCategory.lo,
  1953: CharacterCategory.lo,
  1954: CharacterCategory.lo,
  1955: CharacterCategory.lo,
  1956: CharacterCategory.lo,
  1957: CharacterCategory.lo,
  1969: CharacterCategory.lo,
  1994: CharacterCategory.lo,
  1995: CharacterCategory.lo,
  1996: CharacterCategory.lo,
  1997: CharacterCategory.lo,
  1998: CharacterCategory.lo,
  1999: CharacterCategory.lo,
  2000: CharacterCategory.lo,
  2001: CharacterCategory.lo,
  2002: CharacterCategory.lo,
  2003: CharacterCategory.lo,
  2004: CharacterCategory.lo,
  2005: CharacterCategory.lo,
  2006: CharacterCategory.lo,
  2007: CharacterCategory.lo,
  2008: CharacterCategory.lo,
  2009: CharacterCategory.lo,
  2010: CharacterCategory.lo,
  2011: CharacterCategory.lo,
  2012: CharacterCategory.lo,
  2013: CharacterCategory.lo,
  2014: CharacterCategory.lo,
  2015: CharacterCategory.lo,
  2016: CharacterCategory.lo,
  2017: CharacterCategory.lo,
  2018: CharacterCategory.lo,
  2019: CharacterCategory.lo,
  2020: CharacterCategory.lo,
  2021: CharacterCategory.lo,
  2022: CharacterCategory.lo,
  2023: CharacterCategory.lo,
  2024: CharacterCategory.lo,
  2025: CharacterCategory.lo,
  2026: CharacterCategory.lo,
  2048: CharacterCategory.lo,
  2049: CharacterCategory.lo,
  2050: CharacterCategory.lo,
  2051: CharacterCategory.lo,
  2052: CharacterCategory.lo,
  2053: CharacterCategory.lo,
  2054: CharacterCategory.lo,
  2055: CharacterCategory.lo,
  2056: CharacterCategory.lo,
  2057: CharacterCategory.lo,
  2058: CharacterCategory.lo,
  2059: CharacterCategory.lo,
  2060: CharacterCategory.lo,
  2061: CharacterCategory.lo,
  2062: CharacterCategory.lo,
  2063: CharacterCategory.lo,
  2064: CharacterCategory.lo,
  2065: CharacterCategory.lo,
  2066: CharacterCategory.lo,
  2067: CharacterCategory.lo,
  2068: CharacterCategory.lo,
  2069: CharacterCategory.lo,
  2112: CharacterCategory.lo,
  2113: CharacterCategory.lo,
  2114: CharacterCategory.lo,
  2115: CharacterCategory.lo,
  2116: CharacterCategory.lo,
  2117: CharacterCategory.lo,
  2118: CharacterCategory.lo,
  2119: CharacterCategory.lo,
  2120: CharacterCategory.lo,
  2121: CharacterCategory.lo,
  2122: CharacterCategory.lo,
  2123: CharacterCategory.lo,
  2124: CharacterCategory.lo,
  2125: CharacterCategory.lo,
  2126: CharacterCategory.lo,
  2127: CharacterCategory.lo,
  2128: CharacterCategory.lo,
  2129: CharacterCategory.lo,
  2130: CharacterCategory.lo,
  2131: CharacterCategory.lo,
  2132: CharacterCategory.lo,
  2133: CharacterCategory.lo,
  2134: CharacterCategory.lo,
  2135: CharacterCategory.lo,
  2136: CharacterCategory.lo,
  2208: CharacterCategory.lo,
  2209: CharacterCategory.lo,
  2210: CharacterCategory.lo,
  2211: CharacterCategory.lo,
  2212: CharacterCategory.lo,
  2213: CharacterCategory.lo,
  2214: CharacterCategory.lo,
  2215: CharacterCategory.lo,
  2216: CharacterCategory.lo,
  2217: CharacterCategory.lo,
  2218: CharacterCategory.lo,
  2219: CharacterCategory.lo,
  2220: CharacterCategory.lo,
  2221: CharacterCategory.lo,
  2222: CharacterCategory.lo,
  2223: CharacterCategory.lo,
  2224: CharacterCategory.lo,
  2225: CharacterCategory.lo,
  2226: CharacterCategory.lo,
  2308: CharacterCategory.lo,
  2309: CharacterCategory.lo,
  2310: CharacterCategory.lo,
  2311: CharacterCategory.lo,
  2312: CharacterCategory.lo,
  2313: CharacterCategory.lo,
  2314: CharacterCategory.lo,
  2315: CharacterCategory.lo,
  2316: CharacterCategory.lo,
  2317: CharacterCategory.lo,
  2318: CharacterCategory.lo,
  2319: CharacterCategory.lo,
  2320: CharacterCategory.lo,
  2321: CharacterCategory.lo,
  2322: CharacterCategory.lo,
  2323: CharacterCategory.lo,
  2324: CharacterCategory.lo,
  2325: CharacterCategory.lo,
  2326: CharacterCategory.lo,
  2327: CharacterCategory.lo,
  2328: CharacterCategory.lo,
  2329: CharacterCategory.lo,
  2330: CharacterCategory.lo,
  2331: CharacterCategory.lo,
  2332: CharacterCategory.lo,
  2333: CharacterCategory.lo,
  2334: CharacterCategory.lo,
  2335: CharacterCategory.lo,
  2336: CharacterCategory.lo,
  2337: CharacterCategory.lo,
  2338: CharacterCategory.lo,
  2339: CharacterCategory.lo,
  2340: CharacterCategory.lo,
  2341: CharacterCategory.lo,
  2342: CharacterCategory.lo,
  2343: CharacterCategory.lo,
  2344: CharacterCategory.lo,
  2345: CharacterCategory.lo,
  2346: CharacterCategory.lo,
  2347: CharacterCategory.lo,
  2348: CharacterCategory.lo,
  2349: CharacterCategory.lo,
  2350: CharacterCategory.lo,
  2351: CharacterCategory.lo,
  2352: CharacterCategory.lo,
  2353: CharacterCategory.lo,
  2354: CharacterCategory.lo,
  2355: CharacterCategory.lo,
  2356: CharacterCategory.lo,
  2357: CharacterCategory.lo,
  2358: CharacterCategory.lo,
  2359: CharacterCategory.lo,
  2360: CharacterCategory.lo,
  2361: CharacterCategory.lo,
  2365: CharacterCategory.lo,
  2384: CharacterCategory.lo,
  2392: CharacterCategory.lo,
  2393: CharacterCategory.lo,
  2394: CharacterCategory.lo,
  2395: CharacterCategory.lo,
  2396: CharacterCategory.lo,
  2397: CharacterCategory.lo,
  2398: CharacterCategory.lo,
  2399: CharacterCategory.lo,
  2400: CharacterCategory.lo,
  2401: CharacterCategory.lo,
  2418: CharacterCategory.lo,
  2419: CharacterCategory.lo,
  2420: CharacterCategory.lo,
  2421: CharacterCategory.lo,
  2422: CharacterCategory.lo,
  2423: CharacterCategory.lo,
  2424: CharacterCategory.lo,
  2425: CharacterCategory.lo,
  2426: CharacterCategory.lo,
  2427: CharacterCategory.lo,
  2428: CharacterCategory.lo,
  2429: CharacterCategory.lo,
  2430: CharacterCategory.lo,
  2431: CharacterCategory.lo,
  2432: CharacterCategory.lo,
  2437: CharacterCategory.lo,
  2438: CharacterCategory.lo,
  2439: CharacterCategory.lo,
  2440: CharacterCategory.lo,
  2441: CharacterCategory.lo,
  2442: CharacterCategory.lo,
  2443: CharacterCategory.lo,
  2444: CharacterCategory.lo,
  2447: CharacterCategory.lo,
  2448: CharacterCategory.lo,
  2451: CharacterCategory.lo,
  2452: CharacterCategory.lo,
  2453: CharacterCategory.lo,
  2454: CharacterCategory.lo,
  2455: CharacterCategory.lo,
  2456: CharacterCategory.lo,
  2457: CharacterCategory.lo,
  2458: CharacterCategory.lo,
  2459: CharacterCategory.lo,
  2460: CharacterCategory.lo,
  2461: CharacterCategory.lo,
  2462: CharacterCategory.lo,
  2463: CharacterCategory.lo,
  2464: CharacterCategory.lo,
  2465: CharacterCategory.lo,
  2466: CharacterCategory.lo,
  2467: CharacterCategory.lo,
  2468: CharacterCategory.lo,
  2469: CharacterCategory.lo,
  2470: CharacterCategory.lo,
  2471: CharacterCategory.lo,
  2472: CharacterCategory.lo,
  2474: CharacterCategory.lo,
  2475: CharacterCategory.lo,
  2476: CharacterCategory.lo,
  2477: CharacterCategory.lo,
  2478: CharacterCategory.lo,
  2479: CharacterCategory.lo,
  2480: CharacterCategory.lo,
  2482: CharacterCategory.lo,
  2486: CharacterCategory.lo,
  2487: CharacterCategory.lo,
  2488: CharacterCategory.lo,
  2489: CharacterCategory.lo,
  2493: CharacterCategory.lo,
  2510: CharacterCategory.lo,
  2524: CharacterCategory.lo,
  2525: CharacterCategory.lo,
  2527: CharacterCategory.lo,
  2528: CharacterCategory.lo,
  2529: CharacterCategory.lo,
  2544: CharacterCategory.lo,
  2545: CharacterCategory.lo,
  2565: CharacterCategory.lo,
  2566: CharacterCategory.lo,
  2567: CharacterCategory.lo,
  2568: CharacterCategory.lo,
  2569: CharacterCategory.lo,
  2570: CharacterCategory.lo,
  2575: CharacterCategory.lo,
  2576: CharacterCategory.lo,
  2579: CharacterCategory.lo,
  2580: CharacterCategory.lo,
  2581: CharacterCategory.lo,
  2582: CharacterCategory.lo,
  2583: CharacterCategory.lo,
  2584: CharacterCategory.lo,
  2585: CharacterCategory.lo,
  2586: CharacterCategory.lo,
  2587: CharacterCategory.lo,
  2588: CharacterCategory.lo,
  2589: CharacterCategory.lo,
  2590: CharacterCategory.lo,
  2591: CharacterCategory.lo,
  2592: CharacterCategory.lo,
  2593: CharacterCategory.lo,
  2594: CharacterCategory.lo,
  2595: CharacterCategory.lo,
  2596: CharacterCategory.lo,
  2597: CharacterCategory.lo,
  2598: CharacterCategory.lo,
  2599: CharacterCategory.lo,
  2600: CharacterCategory.lo,
  2602: CharacterCategory.lo,
  2603: CharacterCategory.lo,
  2604: CharacterCategory.lo,
  2605: CharacterCategory.lo,
  2606: CharacterCategory.lo,
  2607: CharacterCategory.lo,
  2608: CharacterCategory.lo,
  2610: CharacterCategory.lo,
  2611: CharacterCategory.lo,
  2613: CharacterCategory.lo,
  2614: CharacterCategory.lo,
  2616: CharacterCategory.lo,
  2617: CharacterCategory.lo,
  2649: CharacterCategory.lo,
  2650: CharacterCategory.lo,
  2651: CharacterCategory.lo,
  2652: CharacterCategory.lo,
  2654: CharacterCategory.lo,
  2674: CharacterCategory.lo,
  2675: CharacterCategory.lo,
  2676: CharacterCategory.lo,
  2693: CharacterCategory.lo,
  2694: CharacterCategory.lo,
  2695: CharacterCategory.lo,
  2696: CharacterCategory.lo,
  2697: CharacterCategory.lo,
  2698: CharacterCategory.lo,
  2699: CharacterCategory.lo,
  2700: CharacterCategory.lo,
  2701: CharacterCategory.lo,
  2703: CharacterCategory.lo,
  2704: CharacterCategory.lo,
  2705: CharacterCategory.lo,
  2707: CharacterCategory.lo,
  2708: CharacterCategory.lo,
  2709: CharacterCategory.lo,
  2710: CharacterCategory.lo,
  2711: CharacterCategory.lo,
  2712: CharacterCategory.lo,
  2713: CharacterCategory.lo,
  2714: CharacterCategory.lo,
  2715: CharacterCategory.lo,
  2716: CharacterCategory.lo,
  2717: CharacterCategory.lo,
  2718: CharacterCategory.lo,
  2719: CharacterCategory.lo,
  2720: CharacterCategory.lo,
  2721: CharacterCategory.lo,
  2722: CharacterCategory.lo,
  2723: CharacterCategory.lo,
  2724: CharacterCategory.lo,
  2725: CharacterCategory.lo,
  2726: CharacterCategory.lo,
  2727: CharacterCategory.lo,
  2728: CharacterCategory.lo,
  2730: CharacterCategory.lo,
  2731: CharacterCategory.lo,
  2732: CharacterCategory.lo,
  2733: CharacterCategory.lo,
  2734: CharacterCategory.lo,
  2735: CharacterCategory.lo,
  2736: CharacterCategory.lo,
  2738: CharacterCategory.lo,
  2739: CharacterCategory.lo,
  2741: CharacterCategory.lo,
  2742: CharacterCategory.lo,
  2743: CharacterCategory.lo,
  2744: CharacterCategory.lo,
  2745: CharacterCategory.lo,
  2749: CharacterCategory.lo,
  2768: CharacterCategory.lo,
  2784: CharacterCategory.lo,
  2785: CharacterCategory.lo,
  2821: CharacterCategory.lo,
  2822: CharacterCategory.lo,
  2823: CharacterCategory.lo,
  2824: CharacterCategory.lo,
  2825: CharacterCategory.lo,
  2826: CharacterCategory.lo,
  2827: CharacterCategory.lo,
  2828: CharacterCategory.lo,
  2831: CharacterCategory.lo,
  2832: CharacterCategory.lo,
  2835: CharacterCategory.lo,
  2836: CharacterCategory.lo,
  2837: CharacterCategory.lo,
  2838: CharacterCategory.lo,
  2839: CharacterCategory.lo,
  2840: CharacterCategory.lo,
  2841: CharacterCategory.lo,
  2842: CharacterCategory.lo,
  2843: CharacterCategory.lo,
  2844: CharacterCategory.lo,
  2845: CharacterCategory.lo,
  2846: CharacterCategory.lo,
  2847: CharacterCategory.lo,
  2848: CharacterCategory.lo,
  2849: CharacterCategory.lo,
  2850: CharacterCategory.lo,
  2851: CharacterCategory.lo,
  2852: CharacterCategory.lo,
  2853: CharacterCategory.lo,
  2854: CharacterCategory.lo,
  2855: CharacterCategory.lo,
  2856: CharacterCategory.lo,
  2858: CharacterCategory.lo,
  2859: CharacterCategory.lo,
  2860: CharacterCategory.lo,
  2861: CharacterCategory.lo,
  2862: CharacterCategory.lo,
  2863: CharacterCategory.lo,
  2864: CharacterCategory.lo,
  2866: CharacterCategory.lo,
  2867: CharacterCategory.lo,
  2869: CharacterCategory.lo,
  2870: CharacterCategory.lo,
  2871: CharacterCategory.lo,
  2872: CharacterCategory.lo,
  2873: CharacterCategory.lo,
  2877: CharacterCategory.lo,
  2908: CharacterCategory.lo,
  2909: CharacterCategory.lo,
  2911: CharacterCategory.lo,
  2912: CharacterCategory.lo,
  2913: CharacterCategory.lo,
  2929: CharacterCategory.lo,
  2947: CharacterCategory.lo,
  2949: CharacterCategory.lo,
  2950: CharacterCategory.lo,
  2951: CharacterCategory.lo,
  2952: CharacterCategory.lo,
  2953: CharacterCategory.lo,
  2954: CharacterCategory.lo,
  2958: CharacterCategory.lo,
  2959: CharacterCategory.lo,
  2960: CharacterCategory.lo,
  2962: CharacterCategory.lo,
  2963: CharacterCategory.lo,
  2964: CharacterCategory.lo,
  2965: CharacterCategory.lo,
  2969: CharacterCategory.lo,
  2970: CharacterCategory.lo,
  2972: CharacterCategory.lo,
  2974: CharacterCategory.lo,
  2975: CharacterCategory.lo,
  2979: CharacterCategory.lo,
  2980: CharacterCategory.lo,
  2984: CharacterCategory.lo,
  2985: CharacterCategory.lo,
  2986: CharacterCategory.lo,
  2990: CharacterCategory.lo,
  2991: CharacterCategory.lo,
  2992: CharacterCategory.lo,
  2993: CharacterCategory.lo,
  2994: CharacterCategory.lo,
  2995: CharacterCategory.lo,
  2996: CharacterCategory.lo,
  2997: CharacterCategory.lo,
  2998: CharacterCategory.lo,
  2999: CharacterCategory.lo,
  3000: CharacterCategory.lo,
  3001: CharacterCategory.lo,
  3024: CharacterCategory.lo,
  3077: CharacterCategory.lo,
  3078: CharacterCategory.lo,
  3079: CharacterCategory.lo,
  3080: CharacterCategory.lo,
  3081: CharacterCategory.lo,
  3082: CharacterCategory.lo,
  3083: CharacterCategory.lo,
  3084: CharacterCategory.lo,
  3086: CharacterCategory.lo,
  3087: CharacterCategory.lo,
  3088: CharacterCategory.lo,
  3090: CharacterCategory.lo,
  3091: CharacterCategory.lo,
  3092: CharacterCategory.lo,
  3093: CharacterCategory.lo,
  3094: CharacterCategory.lo,
  3095: CharacterCategory.lo,
  3096: CharacterCategory.lo,
  3097: CharacterCategory.lo,
  3098: CharacterCategory.lo,
  3099: CharacterCategory.lo,
  3100: CharacterCategory.lo,
  3101: CharacterCategory.lo,
  3102: CharacterCategory.lo,
  3103: CharacterCategory.lo,
  3104: CharacterCategory.lo,
  3105: CharacterCategory.lo,
  3106: CharacterCategory.lo,
  3107: CharacterCategory.lo,
  3108: CharacterCategory.lo,
  3109: CharacterCategory.lo,
  3110: CharacterCategory.lo,
  3111: CharacterCategory.lo,
  3112: CharacterCategory.lo,
  3114: CharacterCategory.lo,
  3115: CharacterCategory.lo,
  3116: CharacterCategory.lo,
  3117: CharacterCategory.lo,
  3118: CharacterCategory.lo,
  3119: CharacterCategory.lo,
  3120: CharacterCategory.lo,
  3121: CharacterCategory.lo,
  3122: CharacterCategory.lo,
  3123: CharacterCategory.lo,
  3124: CharacterCategory.lo,
  3125: CharacterCategory.lo,
  3126: CharacterCategory.lo,
  3127: CharacterCategory.lo,
  3128: CharacterCategory.lo,
  3129: CharacterCategory.lo,
  3133: CharacterCategory.lo,
  3160: CharacterCategory.lo,
  3161: CharacterCategory.lo,
  3168: CharacterCategory.lo,
  3169: CharacterCategory.lo,
  3205: CharacterCategory.lo,
  3206: CharacterCategory.lo,
  3207: CharacterCategory.lo,
  3208: CharacterCategory.lo,
  3209: CharacterCategory.lo,
  3210: CharacterCategory.lo,
  3211: CharacterCategory.lo,
  3212: CharacterCategory.lo,
  3214: CharacterCategory.lo,
  3215: CharacterCategory.lo,
  3216: CharacterCategory.lo,
  3218: CharacterCategory.lo,
  3219: CharacterCategory.lo,
  3220: CharacterCategory.lo,
  3221: CharacterCategory.lo,
  3222: CharacterCategory.lo,
  3223: CharacterCategory.lo,
  3224: CharacterCategory.lo,
  3225: CharacterCategory.lo,
  3226: CharacterCategory.lo,
  3227: CharacterCategory.lo,
  3228: CharacterCategory.lo,
  3229: CharacterCategory.lo,
  3230: CharacterCategory.lo,
  3231: CharacterCategory.lo,
  3232: CharacterCategory.lo,
  3233: CharacterCategory.lo,
  3234: CharacterCategory.lo,
  3235: CharacterCategory.lo,
  3236: CharacterCategory.lo,
  3237: CharacterCategory.lo,
  3238: CharacterCategory.lo,
  3239: CharacterCategory.lo,
  3240: CharacterCategory.lo,
  3242: CharacterCategory.lo,
  3243: CharacterCategory.lo,
  3244: CharacterCategory.lo,
  3245: CharacterCategory.lo,
  3246: CharacterCategory.lo,
  3247: CharacterCategory.lo,
  3248: CharacterCategory.lo,
  3249: CharacterCategory.lo,
  3250: CharacterCategory.lo,
  3251: CharacterCategory.lo,
  3253: CharacterCategory.lo,
  3254: CharacterCategory.lo,
  3255: CharacterCategory.lo,
  3256: CharacterCategory.lo,
  3257: CharacterCategory.lo,
  3261: CharacterCategory.lo,
  3294: CharacterCategory.lo,
  3296: CharacterCategory.lo,
  3297: CharacterCategory.lo,
  3313: CharacterCategory.lo,
  3314: CharacterCategory.lo,
  3333: CharacterCategory.lo,
  3334: CharacterCategory.lo,
  3335: CharacterCategory.lo,
  3336: CharacterCategory.lo,
  3337: CharacterCategory.lo,
  3338: CharacterCategory.lo,
  3339: CharacterCategory.lo,
  3340: CharacterCategory.lo,
  3342: CharacterCategory.lo,
  3343: CharacterCategory.lo,
  3344: CharacterCategory.lo,
  3346: CharacterCategory.lo,
  3347: CharacterCategory.lo,
  3348: CharacterCategory.lo,
  3349: CharacterCategory.lo,
  3350: CharacterCategory.lo,
  3351: CharacterCategory.lo,
  3352: CharacterCategory.lo,
  3353: CharacterCategory.lo,
  3354: CharacterCategory.lo,
  3355: CharacterCategory.lo,
  3356: CharacterCategory.lo,
  3357: CharacterCategory.lo,
  3358: CharacterCategory.lo,
  3359: CharacterCategory.lo,
  3360: CharacterCategory.lo,
  3361: CharacterCategory.lo,
  3362: CharacterCategory.lo,
  3363: CharacterCategory.lo,
  3364: CharacterCategory.lo,
  3365: CharacterCategory.lo,
  3366: CharacterCategory.lo,
  3367: CharacterCategory.lo,
  3368: CharacterCategory.lo,
  3369: CharacterCategory.lo,
  3370: CharacterCategory.lo,
  3371: CharacterCategory.lo,
  3372: CharacterCategory.lo,
  3373: CharacterCategory.lo,
  3374: CharacterCategory.lo,
  3375: CharacterCategory.lo,
  3376: CharacterCategory.lo,
  3377: CharacterCategory.lo,
  3378: CharacterCategory.lo,
  3379: CharacterCategory.lo,
  3380: CharacterCategory.lo,
  3381: CharacterCategory.lo,
  3382: CharacterCategory.lo,
  3383: CharacterCategory.lo,
  3384: CharacterCategory.lo,
  3385: CharacterCategory.lo,
  3386: CharacterCategory.lo,
  3389: CharacterCategory.lo,
  3406: CharacterCategory.lo,
  3424: CharacterCategory.lo,
  3425: CharacterCategory.lo,
  3450: CharacterCategory.lo,
  3451: CharacterCategory.lo,
  3452: CharacterCategory.lo,
  3453: CharacterCategory.lo,
  3454: CharacterCategory.lo,
  3455: CharacterCategory.lo,
  3461: CharacterCategory.lo,
  3462: CharacterCategory.lo,
  3463: CharacterCategory.lo,
  3464: CharacterCategory.lo,
  3465: CharacterCategory.lo,
  3466: CharacterCategory.lo,
  3467: CharacterCategory.lo,
  3468: CharacterCategory.lo,
  3469: CharacterCategory.lo,
  3470: CharacterCategory.lo,
  3471: CharacterCategory.lo,
  3472: CharacterCategory.lo,
  3473: CharacterCategory.lo,
  3474: CharacterCategory.lo,
  3475: CharacterCategory.lo,
  3476: CharacterCategory.lo,
  3477: CharacterCategory.lo,
  3478: CharacterCategory.lo,
  3482: CharacterCategory.lo,
  3483: CharacterCategory.lo,
  3484: CharacterCategory.lo,
  3485: CharacterCategory.lo,
  3486: CharacterCategory.lo,
  3487: CharacterCategory.lo,
  3488: CharacterCategory.lo,
  3489: CharacterCategory.lo,
  3490: CharacterCategory.lo,
  3491: CharacterCategory.lo,
  3492: CharacterCategory.lo,
  3493: CharacterCategory.lo,
  3494: CharacterCategory.lo,
  3495: CharacterCategory.lo,
  3496: CharacterCategory.lo,
  3497: CharacterCategory.lo,
  3498: CharacterCategory.lo,
  3499: CharacterCategory.lo,
  3500: CharacterCategory.lo,
  3501: CharacterCategory.lo,
  3502: CharacterCategory.lo,
  3503: CharacterCategory.lo,
  3504: CharacterCategory.lo,
  3505: CharacterCategory.lo,
  3507: CharacterCategory.lo,
  3508: CharacterCategory.lo,
  3509: CharacterCategory.lo,
  3510: CharacterCategory.lo,
  3511: CharacterCategory.lo,
  3512: CharacterCategory.lo,
  3513: CharacterCategory.lo,
  3514: CharacterCategory.lo,
  3515: CharacterCategory.lo,
  3517: CharacterCategory.lo,
  3520: CharacterCategory.lo,
  3521: CharacterCategory.lo,
  3522: CharacterCategory.lo,
  3523: CharacterCategory.lo,
  3524: CharacterCategory.lo,
  3525: CharacterCategory.lo,
  3526: CharacterCategory.lo,
  3585: CharacterCategory.lo,
  3586: CharacterCategory.lo,
  3587: CharacterCategory.lo,
  3588: CharacterCategory.lo,
  3589: CharacterCategory.lo,
  3590: CharacterCategory.lo,
  3591: CharacterCategory.lo,
  3592: CharacterCategory.lo,
  3593: CharacterCategory.lo,
  3594: CharacterCategory.lo,
  3595: CharacterCategory.lo,
  3596: CharacterCategory.lo,
  3597: CharacterCategory.lo,
  3598: CharacterCategory.lo,
  3599: CharacterCategory.lo,
  3600: CharacterCategory.lo,
  3601: CharacterCategory.lo,
  3602: CharacterCategory.lo,
  3603: CharacterCategory.lo,
  3604: CharacterCategory.lo,
  3605: CharacterCategory.lo,
  3606: CharacterCategory.lo,
  3607: CharacterCategory.lo,
  3608: CharacterCategory.lo,
  3609: CharacterCategory.lo,
  3610: CharacterCategory.lo,
  3611: CharacterCategory.lo,
  3612: CharacterCategory.lo,
  3613: CharacterCategory.lo,
  3614: CharacterCategory.lo,
  3615: CharacterCategory.lo,
  3616: CharacterCategory.lo,
  3617: CharacterCategory.lo,
  3618: CharacterCategory.lo,
  3619: CharacterCategory.lo,
  3620: CharacterCategory.lo,
  3621: CharacterCategory.lo,
  3622: CharacterCategory.lo,
  3623: CharacterCategory.lo,
  3624: CharacterCategory.lo,
  3625: CharacterCategory.lo,
  3626: CharacterCategory.lo,
  3627: CharacterCategory.lo,
  3628: CharacterCategory.lo,
  3629: CharacterCategory.lo,
  3630: CharacterCategory.lo,
  3631: CharacterCategory.lo,
  3632: CharacterCategory.lo,
  3634: CharacterCategory.lo,
  3635: CharacterCategory.lo,
  3648: CharacterCategory.lo,
  3649: CharacterCategory.lo,
  3650: CharacterCategory.lo,
  3651: CharacterCategory.lo,
  3652: CharacterCategory.lo,
  3653: CharacterCategory.lo,
  3713: CharacterCategory.lo,
  3714: CharacterCategory.lo,
  3716: CharacterCategory.lo,
  3719: CharacterCategory.lo,
  3720: CharacterCategory.lo,
  3722: CharacterCategory.lo,
  3725: CharacterCategory.lo,
  3732: CharacterCategory.lo,
  3733: CharacterCategory.lo,
  3734: CharacterCategory.lo,
  3735: CharacterCategory.lo,
  3737: CharacterCategory.lo,
  3738: CharacterCategory.lo,
  3739: CharacterCategory.lo,
  3740: CharacterCategory.lo,
  3741: CharacterCategory.lo,
  3742: CharacterCategory.lo,
  3743: CharacterCategory.lo,
  3745: CharacterCategory.lo,
  3746: CharacterCategory.lo,
  3747: CharacterCategory.lo,
  3749: CharacterCategory.lo,
  3751: CharacterCategory.lo,
  3754: CharacterCategory.lo,
  3755: CharacterCategory.lo,
  3757: CharacterCategory.lo,
  3758: CharacterCategory.lo,
  3759: CharacterCategory.lo,
  3760: CharacterCategory.lo,
  3762: CharacterCategory.lo,
  3763: CharacterCategory.lo,
  3773: CharacterCategory.lo,
  3776: CharacterCategory.lo,
  3777: CharacterCategory.lo,
  3778: CharacterCategory.lo,
  3779: CharacterCategory.lo,
  3780: CharacterCategory.lo,
  3804: CharacterCategory.lo,
  3805: CharacterCategory.lo,
  3806: CharacterCategory.lo,
  3807: CharacterCategory.lo,
  3840: CharacterCategory.lo,
  3904: CharacterCategory.lo,
  3905: CharacterCategory.lo,
  3906: CharacterCategory.lo,
  3907: CharacterCategory.lo,
  3908: CharacterCategory.lo,
  3909: CharacterCategory.lo,
  3910: CharacterCategory.lo,
  3911: CharacterCategory.lo,
  3913: CharacterCategory.lo,
  3914: CharacterCategory.lo,
  3915: CharacterCategory.lo,
  3916: CharacterCategory.lo,
  3917: CharacterCategory.lo,
  3918: CharacterCategory.lo,
  3919: CharacterCategory.lo,
  3920: CharacterCategory.lo,
  3921: CharacterCategory.lo,
  3922: CharacterCategory.lo,
  3923: CharacterCategory.lo,
  3924: CharacterCategory.lo,
  3925: CharacterCategory.lo,
  3926: CharacterCategory.lo,
  3927: CharacterCategory.lo,
  3928: CharacterCategory.lo,
  3929: CharacterCategory.lo,
  3930: CharacterCategory.lo,
  3931: CharacterCategory.lo,
  3932: CharacterCategory.lo,
  3933: CharacterCategory.lo,
  3934: CharacterCategory.lo,
  3935: CharacterCategory.lo,
  3936: CharacterCategory.lo,
  3937: CharacterCategory.lo,
  3938: CharacterCategory.lo,
  3939: CharacterCategory.lo,
  3940: CharacterCategory.lo,
  3941: CharacterCategory.lo,
  3942: CharacterCategory.lo,
  3943: CharacterCategory.lo,
  3944: CharacterCategory.lo,
  3945: CharacterCategory.lo,
  3946: CharacterCategory.lo,
  3947: CharacterCategory.lo,
  3948: CharacterCategory.lo,
  3976: CharacterCategory.lo,
  3977: CharacterCategory.lo,
  3978: CharacterCategory.lo,
  3979: CharacterCategory.lo,
  3980: CharacterCategory.lo,
  4096: CharacterCategory.lo,
  4097: CharacterCategory.lo,
  4098: CharacterCategory.lo,
  4099: CharacterCategory.lo,
  4100: CharacterCategory.lo,
  4101: CharacterCategory.lo,
  4102: CharacterCategory.lo,
  4103: CharacterCategory.lo,
  4104: CharacterCategory.lo,
  4105: CharacterCategory.lo,
  4106: CharacterCategory.lo,
  4107: CharacterCategory.lo,
  4108: CharacterCategory.lo,
  4109: CharacterCategory.lo,
  4110: CharacterCategory.lo,
  4111: CharacterCategory.lo,
  4112: CharacterCategory.lo,
  4113: CharacterCategory.lo,
  4114: CharacterCategory.lo,
  4115: CharacterCategory.lo,
  4116: CharacterCategory.lo,
  4117: CharacterCategory.lo,
  4118: CharacterCategory.lo,
  4119: CharacterCategory.lo,
  4120: CharacterCategory.lo,
  4121: CharacterCategory.lo,
  4122: CharacterCategory.lo,
  4123: CharacterCategory.lo,
  4124: CharacterCategory.lo,
  4125: CharacterCategory.lo,
  4126: CharacterCategory.lo,
  4127: CharacterCategory.lo,
  4128: CharacterCategory.lo,
  4129: CharacterCategory.lo,
  4130: CharacterCategory.lo,
  4131: CharacterCategory.lo,
  4132: CharacterCategory.lo,
  4133: CharacterCategory.lo,
  4134: CharacterCategory.lo,
  4135: CharacterCategory.lo,
  4136: CharacterCategory.lo,
  4137: CharacterCategory.lo,
  4138: CharacterCategory.lo,
  4159: CharacterCategory.lo,
  4176: CharacterCategory.lo,
  4177: CharacterCategory.lo,
  4178: CharacterCategory.lo,
  4179: CharacterCategory.lo,
  4180: CharacterCategory.lo,
  4181: CharacterCategory.lo,
  4186: CharacterCategory.lo,
  4187: CharacterCategory.lo,
  4188: CharacterCategory.lo,
  4189: CharacterCategory.lo,
  4193: CharacterCategory.lo,
  4197: CharacterCategory.lo,
  4198: CharacterCategory.lo,
  4206: CharacterCategory.lo,
  4207: CharacterCategory.lo,
  4208: CharacterCategory.lo,
  4213: CharacterCategory.lo,
  4214: CharacterCategory.lo,
  4215: CharacterCategory.lo,
  4216: CharacterCategory.lo,
  4217: CharacterCategory.lo,
  4218: CharacterCategory.lo,
  4219: CharacterCategory.lo,
  4220: CharacterCategory.lo,
  4221: CharacterCategory.lo,
  4222: CharacterCategory.lo,
  4223: CharacterCategory.lo,
  4224: CharacterCategory.lo,
  4225: CharacterCategory.lo,
  4238: CharacterCategory.lo,
  4304: CharacterCategory.lo,
  4305: CharacterCategory.lo,
  4306: CharacterCategory.lo,
  4307: CharacterCategory.lo,
  4308: CharacterCategory.lo,
  4309: CharacterCategory.lo,
  4310: CharacterCategory.lo,
  4311: CharacterCategory.lo,
  4312: CharacterCategory.lo,
  4313: CharacterCategory.lo,
  4314: CharacterCategory.lo,
  4315: CharacterCategory.lo,
  4316: CharacterCategory.lo,
  4317: CharacterCategory.lo,
  4318: CharacterCategory.lo,
  4319: CharacterCategory.lo,
  4320: CharacterCategory.lo,
  4321: CharacterCategory.lo,
  4322: CharacterCategory.lo,
  4323: CharacterCategory.lo,
  4324: CharacterCategory.lo,
  4325: CharacterCategory.lo,
  4326: CharacterCategory.lo,
  4327: CharacterCategory.lo,
  4328: CharacterCategory.lo,
  4329: CharacterCategory.lo,
  4330: CharacterCategory.lo,
  4331: CharacterCategory.lo,
  4332: CharacterCategory.lo,
  4333: CharacterCategory.lo,
  4334: CharacterCategory.lo,
  4335: CharacterCategory.lo,
  4336: CharacterCategory.lo,
  4337: CharacterCategory.lo,
  4338: CharacterCategory.lo,
  4339: CharacterCategory.lo,
  4340: CharacterCategory.lo,
  4341: CharacterCategory.lo,
  4342: CharacterCategory.lo,
  4343: CharacterCategory.lo,
  4344: CharacterCategory.lo,
  4345: CharacterCategory.lo,
  4346: CharacterCategory.lo,
  4349: CharacterCategory.lo,
  4350: CharacterCategory.lo,
  4351: CharacterCategory.lo,
  4352: CharacterCategory.lo,
  4353: CharacterCategory.lo,
  4354: CharacterCategory.lo,
  4355: CharacterCategory.lo,
  4356: CharacterCategory.lo,
  4357: CharacterCategory.lo,
  4358: CharacterCategory.lo,
  4359: CharacterCategory.lo,
  4360: CharacterCategory.lo,
  4361: CharacterCategory.lo,
  4362: CharacterCategory.lo,
  4363: CharacterCategory.lo,
  4364: CharacterCategory.lo,
  4365: CharacterCategory.lo,
  4366: CharacterCategory.lo,
  4367: CharacterCategory.lo,
  4368: CharacterCategory.lo,
  4369: CharacterCategory.lo,
  4370: CharacterCategory.lo,
  4371: CharacterCategory.lo,
  4372: CharacterCategory.lo,
  4373: CharacterCategory.lo,
  4374: CharacterCategory.lo,
  4375: CharacterCategory.lo,
  4376: CharacterCategory.lo,
  4377: CharacterCategory.lo,
  4378: CharacterCategory.lo,
  4379: CharacterCategory.lo,
  4380: CharacterCategory.lo,
  4381: CharacterCategory.lo,
  4382: CharacterCategory.lo,
  4383: CharacterCategory.lo,
  4384: CharacterCategory.lo,
  4385: CharacterCategory.lo,
  4386: CharacterCategory.lo,
  4387: CharacterCategory.lo,
  4388: CharacterCategory.lo,
  4389: CharacterCategory.lo,
  4390: CharacterCategory.lo,
  4391: CharacterCategory.lo,
  4392: CharacterCategory.lo,
  4393: CharacterCategory.lo,
  4394: CharacterCategory.lo,
  4395: CharacterCategory.lo,
  4396: CharacterCategory.lo,
  4397: CharacterCategory.lo,
  4398: CharacterCategory.lo,
  4399: CharacterCategory.lo,
  4400: CharacterCategory.lo,
  4401: CharacterCategory.lo,
  4402: CharacterCategory.lo,
  4403: CharacterCategory.lo,
  4404: CharacterCategory.lo,
  4405: CharacterCategory.lo,
  4406: CharacterCategory.lo,
  4407: CharacterCategory.lo,
  4408: CharacterCategory.lo,
  4409: CharacterCategory.lo,
  4410: CharacterCategory.lo,
  4411: CharacterCategory.lo,
  4412: CharacterCategory.lo,
  4413: CharacterCategory.lo,
  4414: CharacterCategory.lo,
  4415: CharacterCategory.lo,
  4416: CharacterCategory.lo,
  4417: CharacterCategory.lo,
  4418: CharacterCategory.lo,
  4419: CharacterCategory.lo,
  4420: CharacterCategory.lo,
  4421: CharacterCategory.lo,
  4422: CharacterCategory.lo,
  4423: CharacterCategory.lo,
  4424: CharacterCategory.lo,
  4425: CharacterCategory.lo,
  4426: CharacterCategory.lo,
  4427: CharacterCategory.lo,
  4428: CharacterCategory.lo,
  4429: CharacterCategory.lo,
  4430: CharacterCategory.lo,
  4431: CharacterCategory.lo,
  4432: CharacterCategory.lo,
  4433: CharacterCategory.lo,
  4434: CharacterCategory.lo,
  4435: CharacterCategory.lo,
  4436: CharacterCategory.lo,
  4437: CharacterCategory.lo,
  4438: CharacterCategory.lo,
  4439: CharacterCategory.lo,
  4440: CharacterCategory.lo,
  4441: CharacterCategory.lo,
  4442: CharacterCategory.lo,
  4443: CharacterCategory.lo,
  4444: CharacterCategory.lo,
  4445: CharacterCategory.lo,
  4446: CharacterCategory.lo,
  4447: CharacterCategory.lo,
  4448: CharacterCategory.lo,
  4449: CharacterCategory.lo,
  4450: CharacterCategory.lo,
  4451: CharacterCategory.lo,
  4452: CharacterCategory.lo,
  4453: CharacterCategory.lo,
  4454: CharacterCategory.lo,
  4455: CharacterCategory.lo,
  4456: CharacterCategory.lo,
  4457: CharacterCategory.lo,
  4458: CharacterCategory.lo,
  4459: CharacterCategory.lo,
  4460: CharacterCategory.lo,
  4461: CharacterCategory.lo,
  4462: CharacterCategory.lo,
  4463: CharacterCategory.lo,
  4464: CharacterCategory.lo,
  4465: CharacterCategory.lo,
  4466: CharacterCategory.lo,
  4467: CharacterCategory.lo,
  4468: CharacterCategory.lo,
  4469: CharacterCategory.lo,
  4470: CharacterCategory.lo,
  4471: CharacterCategory.lo,
  4472: CharacterCategory.lo,
  4473: CharacterCategory.lo,
  4474: CharacterCategory.lo,
  4475: CharacterCategory.lo,
  4476: CharacterCategory.lo,
  4477: CharacterCategory.lo,
  4478: CharacterCategory.lo,
  4479: CharacterCategory.lo,
  4480: CharacterCategory.lo,
  4481: CharacterCategory.lo,
  4482: CharacterCategory.lo,
  4483: CharacterCategory.lo,
  4484: CharacterCategory.lo,
  4485: CharacterCategory.lo,
  4486: CharacterCategory.lo,
  4487: CharacterCategory.lo,
  4488: CharacterCategory.lo,
  4489: CharacterCategory.lo,
  4490: CharacterCategory.lo,
  4491: CharacterCategory.lo,
  4492: CharacterCategory.lo,
  4493: CharacterCategory.lo,
  4494: CharacterCategory.lo,
  4495: CharacterCategory.lo,
  4496: CharacterCategory.lo,
  4497: CharacterCategory.lo,
  4498: CharacterCategory.lo,
  4499: CharacterCategory.lo,
  4500: CharacterCategory.lo,
  4501: CharacterCategory.lo,
  4502: CharacterCategory.lo,
  4503: CharacterCategory.lo,
  4504: CharacterCategory.lo,
  4505: CharacterCategory.lo,
  4506: CharacterCategory.lo,
  4507: CharacterCategory.lo,
  4508: CharacterCategory.lo,
  4509: CharacterCategory.lo,
  4510: CharacterCategory.lo,
  4511: CharacterCategory.lo,
  4512: CharacterCategory.lo,
  4513: CharacterCategory.lo,
  4514: CharacterCategory.lo,
  4515: CharacterCategory.lo,
  4516: CharacterCategory.lo,
  4517: CharacterCategory.lo,
  4518: CharacterCategory.lo,
  4519: CharacterCategory.lo,
  4520: CharacterCategory.lo,
  4521: CharacterCategory.lo,
  4522: CharacterCategory.lo,
  4523: CharacterCategory.lo,
  4524: CharacterCategory.lo,
  4525: CharacterCategory.lo,
  4526: CharacterCategory.lo,
  4527: CharacterCategory.lo,
  4528: CharacterCategory.lo,
  4529: CharacterCategory.lo,
  4530: CharacterCategory.lo,
  4531: CharacterCategory.lo,
  4532: CharacterCategory.lo,
  4533: CharacterCategory.lo,
  4534: CharacterCategory.lo,
  4535: CharacterCategory.lo,
  4536: CharacterCategory.lo,
  4537: CharacterCategory.lo,
  4538: CharacterCategory.lo,
  4539: CharacterCategory.lo,
  4540: CharacterCategory.lo,
  4541: CharacterCategory.lo,
  4542: CharacterCategory.lo,
  4543: CharacterCategory.lo,
  4544: CharacterCategory.lo,
  4545: CharacterCategory.lo,
  4546: CharacterCategory.lo,
  4547: CharacterCategory.lo,
  4548: CharacterCategory.lo,
  4549: CharacterCategory.lo,
  4550: CharacterCategory.lo,
  4551: CharacterCategory.lo,
  4552: CharacterCategory.lo,
  4553: CharacterCategory.lo,
  4554: CharacterCategory.lo,
  4555: CharacterCategory.lo,
  4556: CharacterCategory.lo,
  4557: CharacterCategory.lo,
  4558: CharacterCategory.lo,
  4559: CharacterCategory.lo,
  4560: CharacterCategory.lo,
  4561: CharacterCategory.lo,
  4562: CharacterCategory.lo,
  4563: CharacterCategory.lo,
  4564: CharacterCategory.lo,
  4565: CharacterCategory.lo,
  4566: CharacterCategory.lo,
  4567: CharacterCategory.lo,
  4568: CharacterCategory.lo,
  4569: CharacterCategory.lo,
  4570: CharacterCategory.lo,
  4571: CharacterCategory.lo,
  4572: CharacterCategory.lo,
  4573: CharacterCategory.lo,
  4574: CharacterCategory.lo,
  4575: CharacterCategory.lo,
  4576: CharacterCategory.lo,
  4577: CharacterCategory.lo,
  4578: CharacterCategory.lo,
  4579: CharacterCategory.lo,
  4580: CharacterCategory.lo,
  4581: CharacterCategory.lo,
  4582: CharacterCategory.lo,
  4583: CharacterCategory.lo,
  4584: CharacterCategory.lo,
  4585: CharacterCategory.lo,
  4586: CharacterCategory.lo,
  4587: CharacterCategory.lo,
  4588: CharacterCategory.lo,
  4589: CharacterCategory.lo,
  4590: CharacterCategory.lo,
  4591: CharacterCategory.lo,
  4592: CharacterCategory.lo,
  4593: CharacterCategory.lo,
  4594: CharacterCategory.lo,
  4595: CharacterCategory.lo,
  4596: CharacterCategory.lo,
  4597: CharacterCategory.lo,
  4598: CharacterCategory.lo,
  4599: CharacterCategory.lo,
  4600: CharacterCategory.lo,
  4601: CharacterCategory.lo,
  4602: CharacterCategory.lo,
  4603: CharacterCategory.lo,
  4604: CharacterCategory.lo,
  4605: CharacterCategory.lo,
  4606: CharacterCategory.lo,
  4607: CharacterCategory.lo,
  4608: CharacterCategory.lo,
  4609: CharacterCategory.lo,
  4610: CharacterCategory.lo,
  4611: CharacterCategory.lo,
  4612: CharacterCategory.lo,
  4613: CharacterCategory.lo,
  4614: CharacterCategory.lo,
  4615: CharacterCategory.lo,
  4616: CharacterCategory.lo,
  4617: CharacterCategory.lo,
  4618: CharacterCategory.lo,
  4619: CharacterCategory.lo,
  4620: CharacterCategory.lo,
  4621: CharacterCategory.lo,
  4622: CharacterCategory.lo,
  4623: CharacterCategory.lo,
  4624: CharacterCategory.lo,
  4625: CharacterCategory.lo,
  4626: CharacterCategory.lo,
  4627: CharacterCategory.lo,
  4628: CharacterCategory.lo,
  4629: CharacterCategory.lo,
  4630: CharacterCategory.lo,
  4631: CharacterCategory.lo,
  4632: CharacterCategory.lo,
  4633: CharacterCategory.lo,
  4634: CharacterCategory.lo,
  4635: CharacterCategory.lo,
  4636: CharacterCategory.lo,
  4637: CharacterCategory.lo,
  4638: CharacterCategory.lo,
  4639: CharacterCategory.lo,
  4640: CharacterCategory.lo,
  4641: CharacterCategory.lo,
  4642: CharacterCategory.lo,
  4643: CharacterCategory.lo,
  4644: CharacterCategory.lo,
  4645: CharacterCategory.lo,
  4646: CharacterCategory.lo,
  4647: CharacterCategory.lo,
  4648: CharacterCategory.lo,
  4649: CharacterCategory.lo,
  4650: CharacterCategory.lo,
  4651: CharacterCategory.lo,
  4652: CharacterCategory.lo,
  4653: CharacterCategory.lo,
  4654: CharacterCategory.lo,
  4655: CharacterCategory.lo,
  4656: CharacterCategory.lo,
  4657: CharacterCategory.lo,
  4658: CharacterCategory.lo,
  4659: CharacterCategory.lo,
  4660: CharacterCategory.lo,
  4661: CharacterCategory.lo,
  4662: CharacterCategory.lo,
  4663: CharacterCategory.lo,
  4664: CharacterCategory.lo,
  4665: CharacterCategory.lo,
  4666: CharacterCategory.lo,
  4667: CharacterCategory.lo,
  4668: CharacterCategory.lo,
  4669: CharacterCategory.lo,
  4670: CharacterCategory.lo,
  4671: CharacterCategory.lo,
  4672: CharacterCategory.lo,
  4673: CharacterCategory.lo,
  4674: CharacterCategory.lo,
  4675: CharacterCategory.lo,
  4676: CharacterCategory.lo,
  4677: CharacterCategory.lo,
  4678: CharacterCategory.lo,
  4679: CharacterCategory.lo,
  4680: CharacterCategory.lo,
  4682: CharacterCategory.lo,
  4683: CharacterCategory.lo,
  4684: CharacterCategory.lo,
  4685: CharacterCategory.lo,
  4688: CharacterCategory.lo,
  4689: CharacterCategory.lo,
  4690: CharacterCategory.lo,
  4691: CharacterCategory.lo,
  4692: CharacterCategory.lo,
  4693: CharacterCategory.lo,
  4694: CharacterCategory.lo,
  4696: CharacterCategory.lo,
  4698: CharacterCategory.lo,
  4699: CharacterCategory.lo,
  4700: CharacterCategory.lo,
  4701: CharacterCategory.lo,
  4704: CharacterCategory.lo,
  4705: CharacterCategory.lo,
  4706: CharacterCategory.lo,
  4707: CharacterCategory.lo,
  4708: CharacterCategory.lo,
  4709: CharacterCategory.lo,
  4710: CharacterCategory.lo,
  4711: CharacterCategory.lo,
  4712: CharacterCategory.lo,
  4713: CharacterCategory.lo,
  4714: CharacterCategory.lo,
  4715: CharacterCategory.lo,
  4716: CharacterCategory.lo,
  4717: CharacterCategory.lo,
  4718: CharacterCategory.lo,
  4719: CharacterCategory.lo,
  4720: CharacterCategory.lo,
  4721: CharacterCategory.lo,
  4722: CharacterCategory.lo,
  4723: CharacterCategory.lo,
  4724: CharacterCategory.lo,
  4725: CharacterCategory.lo,
  4726: CharacterCategory.lo,
  4727: CharacterCategory.lo,
  4728: CharacterCategory.lo,
  4729: CharacterCategory.lo,
  4730: CharacterCategory.lo,
  4731: CharacterCategory.lo,
  4732: CharacterCategory.lo,
  4733: CharacterCategory.lo,
  4734: CharacterCategory.lo,
  4735: CharacterCategory.lo,
  4736: CharacterCategory.lo,
  4737: CharacterCategory.lo,
  4738: CharacterCategory.lo,
  4739: CharacterCategory.lo,
  4740: CharacterCategory.lo,
  4741: CharacterCategory.lo,
  4742: CharacterCategory.lo,
  4743: CharacterCategory.lo,
  4744: CharacterCategory.lo,
  4746: CharacterCategory.lo,
  4747: CharacterCategory.lo,
  4748: CharacterCategory.lo,
  4749: CharacterCategory.lo,
  4752: CharacterCategory.lo,
  4753: CharacterCategory.lo,
  4754: CharacterCategory.lo,
  4755: CharacterCategory.lo,
  4756: CharacterCategory.lo,
  4757: CharacterCategory.lo,
  4758: CharacterCategory.lo,
  4759: CharacterCategory.lo,
  4760: CharacterCategory.lo,
  4761: CharacterCategory.lo,
  4762: CharacterCategory.lo,
  4763: CharacterCategory.lo,
  4764: CharacterCategory.lo,
  4765: CharacterCategory.lo,
  4766: CharacterCategory.lo,
  4767: CharacterCategory.lo,
  4768: CharacterCategory.lo,
  4769: CharacterCategory.lo,
  4770: CharacterCategory.lo,
  4771: CharacterCategory.lo,
  4772: CharacterCategory.lo,
  4773: CharacterCategory.lo,
  4774: CharacterCategory.lo,
  4775: CharacterCategory.lo,
  4776: CharacterCategory.lo,
  4777: CharacterCategory.lo,
  4778: CharacterCategory.lo,
  4779: CharacterCategory.lo,
  4780: CharacterCategory.lo,
  4781: CharacterCategory.lo,
  4782: CharacterCategory.lo,
  4783: CharacterCategory.lo,
  4784: CharacterCategory.lo,
  4786: CharacterCategory.lo,
  4787: CharacterCategory.lo,
  4788: CharacterCategory.lo,
  4789: CharacterCategory.lo,
  4792: CharacterCategory.lo,
  4793: CharacterCategory.lo,
  4794: CharacterCategory.lo,
  4795: CharacterCategory.lo,
  4796: CharacterCategory.lo,
  4797: CharacterCategory.lo,
  4798: CharacterCategory.lo,
  4800: CharacterCategory.lo,
  4802: CharacterCategory.lo,
  4803: CharacterCategory.lo,
  4804: CharacterCategory.lo,
  4805: CharacterCategory.lo,
  4808: CharacterCategory.lo,
  4809: CharacterCategory.lo,
  4810: CharacterCategory.lo,
  4811: CharacterCategory.lo,
  4812: CharacterCategory.lo,
  4813: CharacterCategory.lo,
  4814: CharacterCategory.lo,
  4815: CharacterCategory.lo,
  4816: CharacterCategory.lo,
  4817: CharacterCategory.lo,
  4818: CharacterCategory.lo,
  4819: CharacterCategory.lo,
  4820: CharacterCategory.lo,
  4821: CharacterCategory.lo,
  4822: CharacterCategory.lo,
  4824: CharacterCategory.lo,
  4825: CharacterCategory.lo,
  4826: CharacterCategory.lo,
  4827: CharacterCategory.lo,
  4828: CharacterCategory.lo,
  4829: CharacterCategory.lo,
  4830: CharacterCategory.lo,
  4831: CharacterCategory.lo,
  4832: CharacterCategory.lo,
  4833: CharacterCategory.lo,
  4834: CharacterCategory.lo,
  4835: CharacterCategory.lo,
  4836: CharacterCategory.lo,
  4837: CharacterCategory.lo,
  4838: CharacterCategory.lo,
  4839: CharacterCategory.lo,
  4840: CharacterCategory.lo,
  4841: CharacterCategory.lo,
  4842: CharacterCategory.lo,
  4843: CharacterCategory.lo,
  4844: CharacterCategory.lo,
  4845: CharacterCategory.lo,
  4846: CharacterCategory.lo,
  4847: CharacterCategory.lo,
  4848: CharacterCategory.lo,
  4849: CharacterCategory.lo,
  4850: CharacterCategory.lo,
  4851: CharacterCategory.lo,
  4852: CharacterCategory.lo,
  4853: CharacterCategory.lo,
  4854: CharacterCategory.lo,
  4855: CharacterCategory.lo,
  4856: CharacterCategory.lo,
  4857: CharacterCategory.lo,
  4858: CharacterCategory.lo,
  4859: CharacterCategory.lo,
  4860: CharacterCategory.lo,
  4861: CharacterCategory.lo,
  4862: CharacterCategory.lo,
  4863: CharacterCategory.lo,
  4864: CharacterCategory.lo,
  4865: CharacterCategory.lo,
  4866: CharacterCategory.lo,
  4867: CharacterCategory.lo,
  4868: CharacterCategory.lo,
  4869: CharacterCategory.lo,
  4870: CharacterCategory.lo,
  4871: CharacterCategory.lo,
  4872: CharacterCategory.lo,
  4873: CharacterCategory.lo,
  4874: CharacterCategory.lo,
  4875: CharacterCategory.lo,
  4876: CharacterCategory.lo,
  4877: CharacterCategory.lo,
  4878: CharacterCategory.lo,
  4879: CharacterCategory.lo,
  4880: CharacterCategory.lo,
  4882: CharacterCategory.lo,
  4883: CharacterCategory.lo,
  4884: CharacterCategory.lo,
  4885: CharacterCategory.lo,
  4888: CharacterCategory.lo,
  4889: CharacterCategory.lo,
  4890: CharacterCategory.lo,
  4891: CharacterCategory.lo,
  4892: CharacterCategory.lo,
  4893: CharacterCategory.lo,
  4894: CharacterCategory.lo,
  4895: CharacterCategory.lo,
  4896: CharacterCategory.lo,
  4897: CharacterCategory.lo,
  4898: CharacterCategory.lo,
  4899: CharacterCategory.lo,
  4900: CharacterCategory.lo,
  4901: CharacterCategory.lo,
  4902: CharacterCategory.lo,
  4903: CharacterCategory.lo,
  4904: CharacterCategory.lo,
  4905: CharacterCategory.lo,
  4906: CharacterCategory.lo,
  4907: CharacterCategory.lo,
  4908: CharacterCategory.lo,
  4909: CharacterCategory.lo,
  4910: CharacterCategory.lo,
  4911: CharacterCategory.lo,
  4912: CharacterCategory.lo,
  4913: CharacterCategory.lo,
  4914: CharacterCategory.lo,
  4915: CharacterCategory.lo,
  4916: CharacterCategory.lo,
  4917: CharacterCategory.lo,
  4918: CharacterCategory.lo,
  4919: CharacterCategory.lo,
  4920: CharacterCategory.lo,
  4921: CharacterCategory.lo,
  4922: CharacterCategory.lo,
  4923: CharacterCategory.lo,
  4924: CharacterCategory.lo,
  4925: CharacterCategory.lo,
  4926: CharacterCategory.lo,
  4927: CharacterCategory.lo,
  4928: CharacterCategory.lo,
  4929: CharacterCategory.lo,
  4930: CharacterCategory.lo,
  4931: CharacterCategory.lo,
  4932: CharacterCategory.lo,
  4933: CharacterCategory.lo,
  4934: CharacterCategory.lo,
  4935: CharacterCategory.lo,
  4936: CharacterCategory.lo,
  4937: CharacterCategory.lo,
  4938: CharacterCategory.lo,
  4939: CharacterCategory.lo,
  4940: CharacterCategory.lo,
  4941: CharacterCategory.lo,
  4942: CharacterCategory.lo,
  4943: CharacterCategory.lo,
  4944: CharacterCategory.lo,
  4945: CharacterCategory.lo,
  4946: CharacterCategory.lo,
  4947: CharacterCategory.lo,
  4948: CharacterCategory.lo,
  4949: CharacterCategory.lo,
  4950: CharacterCategory.lo,
  4951: CharacterCategory.lo,
  4952: CharacterCategory.lo,
  4953: CharacterCategory.lo,
  4954: CharacterCategory.lo,
  4992: CharacterCategory.lo,
  4993: CharacterCategory.lo,
  4994: CharacterCategory.lo,
  4995: CharacterCategory.lo,
  4996: CharacterCategory.lo,
  4997: CharacterCategory.lo,
  4998: CharacterCategory.lo,
  4999: CharacterCategory.lo,
  5000: CharacterCategory.lo,
  5001: CharacterCategory.lo,
  5002: CharacterCategory.lo,
  5003: CharacterCategory.lo,
  5004: CharacterCategory.lo,
  5005: CharacterCategory.lo,
  5006: CharacterCategory.lo,
  5007: CharacterCategory.lo,
  5024: CharacterCategory.lo,
  5025: CharacterCategory.lo,
  5026: CharacterCategory.lo,
  5027: CharacterCategory.lo,
  5028: CharacterCategory.lo,
  5029: CharacterCategory.lo,
  5030: CharacterCategory.lo,
  5031: CharacterCategory.lo,
  5032: CharacterCategory.lo,
  5033: CharacterCategory.lo,
  5034: CharacterCategory.lo,
  5035: CharacterCategory.lo,
  5036: CharacterCategory.lo,
  5037: CharacterCategory.lo,
  5038: CharacterCategory.lo,
  5039: CharacterCategory.lo,
  5040: CharacterCategory.lo,
  5041: CharacterCategory.lo,
  5042: CharacterCategory.lo,
  5043: CharacterCategory.lo,
  5044: CharacterCategory.lo,
  5045: CharacterCategory.lo,
  5046: CharacterCategory.lo,
  5047: CharacterCategory.lo,
  5048: CharacterCategory.lo,
  5049: CharacterCategory.lo,
  5050: CharacterCategory.lo,
  5051: CharacterCategory.lo,
  5052: CharacterCategory.lo,
  5053: CharacterCategory.lo,
  5054: CharacterCategory.lo,
  5055: CharacterCategory.lo,
  5056: CharacterCategory.lo,
  5057: CharacterCategory.lo,
  5058: CharacterCategory.lo,
  5059: CharacterCategory.lo,
  5060: CharacterCategory.lo,
  5061: CharacterCategory.lo,
  5062: CharacterCategory.lo,
  5063: CharacterCategory.lo,
  5064: CharacterCategory.lo,
  5065: CharacterCategory.lo,
  5066: CharacterCategory.lo,
  5067: CharacterCategory.lo,
  5068: CharacterCategory.lo,
  5069: CharacterCategory.lo,
  5070: CharacterCategory.lo,
  5071: CharacterCategory.lo,
  5072: CharacterCategory.lo,
  5073: CharacterCategory.lo,
  5074: CharacterCategory.lo,
  5075: CharacterCategory.lo,
  5076: CharacterCategory.lo,
  5077: CharacterCategory.lo,
  5078: CharacterCategory.lo,
  5079: CharacterCategory.lo,
  5080: CharacterCategory.lo,
  5081: CharacterCategory.lo,
  5082: CharacterCategory.lo,
  5083: CharacterCategory.lo,
  5084: CharacterCategory.lo,
  5085: CharacterCategory.lo,
  5086: CharacterCategory.lo,
  5087: CharacterCategory.lo,
  5088: CharacterCategory.lo,
  5089: CharacterCategory.lo,
  5090: CharacterCategory.lo,
  5091: CharacterCategory.lo,
  5092: CharacterCategory.lo,
  5093: CharacterCategory.lo,
  5094: CharacterCategory.lo,
  5095: CharacterCategory.lo,
  5096: CharacterCategory.lo,
  5097: CharacterCategory.lo,
  5098: CharacterCategory.lo,
  5099: CharacterCategory.lo,
  5100: CharacterCategory.lo,
  5101: CharacterCategory.lo,
  5102: CharacterCategory.lo,
  5103: CharacterCategory.lo,
  5104: CharacterCategory.lo,
  5105: CharacterCategory.lo,
  5106: CharacterCategory.lo,
  5107: CharacterCategory.lo,
  5108: CharacterCategory.lo,
  5121: CharacterCategory.lo,
  5122: CharacterCategory.lo,
  5123: CharacterCategory.lo,
  5124: CharacterCategory.lo,
  5125: CharacterCategory.lo,
  5126: CharacterCategory.lo,
  5127: CharacterCategory.lo,
  5128: CharacterCategory.lo,
  5129: CharacterCategory.lo,
  5130: CharacterCategory.lo,
  5131: CharacterCategory.lo,
  5132: CharacterCategory.lo,
  5133: CharacterCategory.lo,
  5134: CharacterCategory.lo,
  5135: CharacterCategory.lo,
  5136: CharacterCategory.lo,
  5137: CharacterCategory.lo,
  5138: CharacterCategory.lo,
  5139: CharacterCategory.lo,
  5140: CharacterCategory.lo,
  5141: CharacterCategory.lo,
  5142: CharacterCategory.lo,
  5143: CharacterCategory.lo,
  5144: CharacterCategory.lo,
  5145: CharacterCategory.lo,
  5146: CharacterCategory.lo,
  5147: CharacterCategory.lo,
  5148: CharacterCategory.lo,
  5149: CharacterCategory.lo,
  5150: CharacterCategory.lo,
  5151: CharacterCategory.lo,
  5152: CharacterCategory.lo,
  5153: CharacterCategory.lo,
  5154: CharacterCategory.lo,
  5155: CharacterCategory.lo,
  5156: CharacterCategory.lo,
  5157: CharacterCategory.lo,
  5158: CharacterCategory.lo,
  5159: CharacterCategory.lo,
  5160: CharacterCategory.lo,
  5161: CharacterCategory.lo,
  5162: CharacterCategory.lo,
  5163: CharacterCategory.lo,
  5164: CharacterCategory.lo,
  5165: CharacterCategory.lo,
  5166: CharacterCategory.lo,
  5167: CharacterCategory.lo,
  5168: CharacterCategory.lo,
  5169: CharacterCategory.lo,
  5170: CharacterCategory.lo,
  5171: CharacterCategory.lo,
  5172: CharacterCategory.lo,
  5173: CharacterCategory.lo,
  5174: CharacterCategory.lo,
  5175: CharacterCategory.lo,
  5176: CharacterCategory.lo,
  5177: CharacterCategory.lo,
  5178: CharacterCategory.lo,
  5179: CharacterCategory.lo,
  5180: CharacterCategory.lo,
  5181: CharacterCategory.lo,
  5182: CharacterCategory.lo,
  5183: CharacterCategory.lo,
  5184: CharacterCategory.lo,
  5185: CharacterCategory.lo,
  5186: CharacterCategory.lo,
  5187: CharacterCategory.lo,
  5188: CharacterCategory.lo,
  5189: CharacterCategory.lo,
  5190: CharacterCategory.lo,
  5191: CharacterCategory.lo,
  5192: CharacterCategory.lo,
  5193: CharacterCategory.lo,
  5194: CharacterCategory.lo,
  5195: CharacterCategory.lo,
  5196: CharacterCategory.lo,
  5197: CharacterCategory.lo,
  5198: CharacterCategory.lo,
  5199: CharacterCategory.lo,
  5200: CharacterCategory.lo,
  5201: CharacterCategory.lo,
  5202: CharacterCategory.lo,
  5203: CharacterCategory.lo,
  5204: CharacterCategory.lo,
  5205: CharacterCategory.lo,
  5206: CharacterCategory.lo,
  5207: CharacterCategory.lo,
  5208: CharacterCategory.lo,
  5209: CharacterCategory.lo,
  5210: CharacterCategory.lo,
  5211: CharacterCategory.lo,
  5212: CharacterCategory.lo,
  5213: CharacterCategory.lo,
  5214: CharacterCategory.lo,
  5215: CharacterCategory.lo,
  5216: CharacterCategory.lo,
  5217: CharacterCategory.lo,
  5218: CharacterCategory.lo,
  5219: CharacterCategory.lo,
  5220: CharacterCategory.lo,
  5221: CharacterCategory.lo,
  5222: CharacterCategory.lo,
  5223: CharacterCategory.lo,
  5224: CharacterCategory.lo,
  5225: CharacterCategory.lo,
  5226: CharacterCategory.lo,
  5227: CharacterCategory.lo,
  5228: CharacterCategory.lo,
  5229: CharacterCategory.lo,
  5230: CharacterCategory.lo,
  5231: CharacterCategory.lo,
  5232: CharacterCategory.lo,
  5233: CharacterCategory.lo,
  5234: CharacterCategory.lo,
  5235: CharacterCategory.lo,
  5236: CharacterCategory.lo,
  5237: CharacterCategory.lo,
  5238: CharacterCategory.lo,
  5239: CharacterCategory.lo,
  5240: CharacterCategory.lo,
  5241: CharacterCategory.lo,
  5242: CharacterCategory.lo,
  5243: CharacterCategory.lo,
  5244: CharacterCategory.lo,
  5245: CharacterCategory.lo,
  5246: CharacterCategory.lo,
  5247: CharacterCategory.lo,
  5248: CharacterCategory.lo,
  5249: CharacterCategory.lo,
  5250: CharacterCategory.lo,
  5251: CharacterCategory.lo,
  5252: CharacterCategory.lo,
  5253: CharacterCategory.lo,
  5254: CharacterCategory.lo,
  5255: CharacterCategory.lo,
  5256: CharacterCategory.lo,
  5257: CharacterCategory.lo,
  5258: CharacterCategory.lo,
  5259: CharacterCategory.lo,
  5260: CharacterCategory.lo,
  5261: CharacterCategory.lo,
  5262: CharacterCategory.lo,
  5263: CharacterCategory.lo,
  5264: CharacterCategory.lo,
  5265: CharacterCategory.lo,
  5266: CharacterCategory.lo,
  5267: CharacterCategory.lo,
  5268: CharacterCategory.lo,
  5269: CharacterCategory.lo,
  5270: CharacterCategory.lo,
  5271: CharacterCategory.lo,
  5272: CharacterCategory.lo,
  5273: CharacterCategory.lo,
  5274: CharacterCategory.lo,
  5275: CharacterCategory.lo,
  5276: CharacterCategory.lo,
  5277: CharacterCategory.lo,
  5278: CharacterCategory.lo,
  5279: CharacterCategory.lo,
  5280: CharacterCategory.lo,
  5281: CharacterCategory.lo,
  5282: CharacterCategory.lo,
  5283: CharacterCategory.lo,
  5284: CharacterCategory.lo,
  5285: CharacterCategory.lo,
  5286: CharacterCategory.lo,
  5287: CharacterCategory.lo,
  5288: CharacterCategory.lo,
  5289: CharacterCategory.lo,
  5290: CharacterCategory.lo,
  5291: CharacterCategory.lo,
  5292: CharacterCategory.lo,
  5293: CharacterCategory.lo,
  5294: CharacterCategory.lo,
  5295: CharacterCategory.lo,
  5296: CharacterCategory.lo,
  5297: CharacterCategory.lo,
  5298: CharacterCategory.lo,
  5299: CharacterCategory.lo,
  5300: CharacterCategory.lo,
  5301: CharacterCategory.lo,
  5302: CharacterCategory.lo,
  5303: CharacterCategory.lo,
  5304: CharacterCategory.lo,
  5305: CharacterCategory.lo,
  5306: CharacterCategory.lo,
  5307: CharacterCategory.lo,
  5308: CharacterCategory.lo,
  5309: CharacterCategory.lo,
  5310: CharacterCategory.lo,
  5311: CharacterCategory.lo,
  5312: CharacterCategory.lo,
  5313: CharacterCategory.lo,
  5314: CharacterCategory.lo,
  5315: CharacterCategory.lo,
  5316: CharacterCategory.lo,
  5317: CharacterCategory.lo,
  5318: CharacterCategory.lo,
  5319: CharacterCategory.lo,
  5320: CharacterCategory.lo,
  5321: CharacterCategory.lo,
  5322: CharacterCategory.lo,
  5323: CharacterCategory.lo,
  5324: CharacterCategory.lo,
  5325: CharacterCategory.lo,
  5326: CharacterCategory.lo,
  5327: CharacterCategory.lo,
  5328: CharacterCategory.lo,
  5329: CharacterCategory.lo,
  5330: CharacterCategory.lo,
  5331: CharacterCategory.lo,
  5332: CharacterCategory.lo,
  5333: CharacterCategory.lo,
  5334: CharacterCategory.lo,
  5335: CharacterCategory.lo,
  5336: CharacterCategory.lo,
  5337: CharacterCategory.lo,
  5338: CharacterCategory.lo,
  5339: CharacterCategory.lo,
  5340: CharacterCategory.lo,
  5341: CharacterCategory.lo,
  5342: CharacterCategory.lo,
  5343: CharacterCategory.lo,
  5344: CharacterCategory.lo,
  5345: CharacterCategory.lo,
  5346: CharacterCategory.lo,
  5347: CharacterCategory.lo,
  5348: CharacterCategory.lo,
  5349: CharacterCategory.lo,
  5350: CharacterCategory.lo,
  5351: CharacterCategory.lo,
  5352: CharacterCategory.lo,
  5353: CharacterCategory.lo,
  5354: CharacterCategory.lo,
  5355: CharacterCategory.lo,
  5356: CharacterCategory.lo,
  5357: CharacterCategory.lo,
  5358: CharacterCategory.lo,
  5359: CharacterCategory.lo,
  5360: CharacterCategory.lo,
  5361: CharacterCategory.lo,
  5362: CharacterCategory.lo,
  5363: CharacterCategory.lo,
  5364: CharacterCategory.lo,
  5365: CharacterCategory.lo,
  5366: CharacterCategory.lo,
  5367: CharacterCategory.lo,
  5368: CharacterCategory.lo,
  5369: CharacterCategory.lo,
  5370: CharacterCategory.lo,
  5371: CharacterCategory.lo,
  5372: CharacterCategory.lo,
  5373: CharacterCategory.lo,
  5374: CharacterCategory.lo,
  5375: CharacterCategory.lo,
  5376: CharacterCategory.lo,
  5377: CharacterCategory.lo,
  5378: CharacterCategory.lo,
  5379: CharacterCategory.lo,
  5380: CharacterCategory.lo,
  5381: CharacterCategory.lo,
  5382: CharacterCategory.lo,
  5383: CharacterCategory.lo,
  5384: CharacterCategory.lo,
  5385: CharacterCategory.lo,
  5386: CharacterCategory.lo,
  5387: CharacterCategory.lo,
  5388: CharacterCategory.lo,
  5389: CharacterCategory.lo,
  5390: CharacterCategory.lo,
  5391: CharacterCategory.lo,
  5392: CharacterCategory.lo,
  5393: CharacterCategory.lo,
  5394: CharacterCategory.lo,
  5395: CharacterCategory.lo,
  5396: CharacterCategory.lo,
  5397: CharacterCategory.lo,
  5398: CharacterCategory.lo,
  5399: CharacterCategory.lo,
  5400: CharacterCategory.lo,
  5401: CharacterCategory.lo,
  5402: CharacterCategory.lo,
  5403: CharacterCategory.lo,
  5404: CharacterCategory.lo,
  5405: CharacterCategory.lo,
  5406: CharacterCategory.lo,
  5407: CharacterCategory.lo,
  5408: CharacterCategory.lo,
  5409: CharacterCategory.lo,
  5410: CharacterCategory.lo,
  5411: CharacterCategory.lo,
  5412: CharacterCategory.lo,
  5413: CharacterCategory.lo,
  5414: CharacterCategory.lo,
  5415: CharacterCategory.lo,
  5416: CharacterCategory.lo,
  5417: CharacterCategory.lo,
  5418: CharacterCategory.lo,
  5419: CharacterCategory.lo,
  5420: CharacterCategory.lo,
  5421: CharacterCategory.lo,
  5422: CharacterCategory.lo,
  5423: CharacterCategory.lo,
  5424: CharacterCategory.lo,
  5425: CharacterCategory.lo,
  5426: CharacterCategory.lo,
  5427: CharacterCategory.lo,
  5428: CharacterCategory.lo,
  5429: CharacterCategory.lo,
  5430: CharacterCategory.lo,
  5431: CharacterCategory.lo,
  5432: CharacterCategory.lo,
  5433: CharacterCategory.lo,
  5434: CharacterCategory.lo,
  5435: CharacterCategory.lo,
  5436: CharacterCategory.lo,
  5437: CharacterCategory.lo,
  5438: CharacterCategory.lo,
  5439: CharacterCategory.lo,
  5440: CharacterCategory.lo,
  5441: CharacterCategory.lo,
  5442: CharacterCategory.lo,
  5443: CharacterCategory.lo,
  5444: CharacterCategory.lo,
  5445: CharacterCategory.lo,
  5446: CharacterCategory.lo,
  5447: CharacterCategory.lo,
  5448: CharacterCategory.lo,
  5449: CharacterCategory.lo,
  5450: CharacterCategory.lo,
  5451: CharacterCategory.lo,
  5452: CharacterCategory.lo,
  5453: CharacterCategory.lo,
  5454: CharacterCategory.lo,
  5455: CharacterCategory.lo,
  5456: CharacterCategory.lo,
  5457: CharacterCategory.lo,
  5458: CharacterCategory.lo,
  5459: CharacterCategory.lo,
  5460: CharacterCategory.lo,
  5461: CharacterCategory.lo,
  5462: CharacterCategory.lo,
  5463: CharacterCategory.lo,
  5464: CharacterCategory.lo,
  5465: CharacterCategory.lo,
  5466: CharacterCategory.lo,
  5467: CharacterCategory.lo,
  5468: CharacterCategory.lo,
  5469: CharacterCategory.lo,
  5470: CharacterCategory.lo,
  5471: CharacterCategory.lo,
  5472: CharacterCategory.lo,
  5473: CharacterCategory.lo,
  5474: CharacterCategory.lo,
  5475: CharacterCategory.lo,
  5476: CharacterCategory.lo,
  5477: CharacterCategory.lo,
  5478: CharacterCategory.lo,
  5479: CharacterCategory.lo,
  5480: CharacterCategory.lo,
  5481: CharacterCategory.lo,
  5482: CharacterCategory.lo,
  5483: CharacterCategory.lo,
  5484: CharacterCategory.lo,
  5485: CharacterCategory.lo,
  5486: CharacterCategory.lo,
  5487: CharacterCategory.lo,
  5488: CharacterCategory.lo,
  5489: CharacterCategory.lo,
  5490: CharacterCategory.lo,
  5491: CharacterCategory.lo,
  5492: CharacterCategory.lo,
  5493: CharacterCategory.lo,
  5494: CharacterCategory.lo,
  5495: CharacterCategory.lo,
  5496: CharacterCategory.lo,
  5497: CharacterCategory.lo,
  5498: CharacterCategory.lo,
  5499: CharacterCategory.lo,
  5500: CharacterCategory.lo,
  5501: CharacterCategory.lo,
  5502: CharacterCategory.lo,
  5503: CharacterCategory.lo,
  5504: CharacterCategory.lo,
  5505: CharacterCategory.lo,
  5506: CharacterCategory.lo,
  5507: CharacterCategory.lo,
  5508: CharacterCategory.lo,
  5509: CharacterCategory.lo,
  5510: CharacterCategory.lo,
  5511: CharacterCategory.lo,
  5512: CharacterCategory.lo,
  5513: CharacterCategory.lo,
  5514: CharacterCategory.lo,
  5515: CharacterCategory.lo,
  5516: CharacterCategory.lo,
  5517: CharacterCategory.lo,
  5518: CharacterCategory.lo,
  5519: CharacterCategory.lo,
  5520: CharacterCategory.lo,
  5521: CharacterCategory.lo,
  5522: CharacterCategory.lo,
  5523: CharacterCategory.lo,
  5524: CharacterCategory.lo,
  5525: CharacterCategory.lo,
  5526: CharacterCategory.lo,
  5527: CharacterCategory.lo,
  5528: CharacterCategory.lo,
  5529: CharacterCategory.lo,
  5530: CharacterCategory.lo,
  5531: CharacterCategory.lo,
  5532: CharacterCategory.lo,
  5533: CharacterCategory.lo,
  5534: CharacterCategory.lo,
  5535: CharacterCategory.lo,
  5536: CharacterCategory.lo,
  5537: CharacterCategory.lo,
  5538: CharacterCategory.lo,
  5539: CharacterCategory.lo,
  5540: CharacterCategory.lo,
  5541: CharacterCategory.lo,
  5542: CharacterCategory.lo,
  5543: CharacterCategory.lo,
  5544: CharacterCategory.lo,
  5545: CharacterCategory.lo,
  5546: CharacterCategory.lo,
  5547: CharacterCategory.lo,
  5548: CharacterCategory.lo,
  5549: CharacterCategory.lo,
  5550: CharacterCategory.lo,
  5551: CharacterCategory.lo,
  5552: CharacterCategory.lo,
  5553: CharacterCategory.lo,
  5554: CharacterCategory.lo,
  5555: CharacterCategory.lo,
  5556: CharacterCategory.lo,
  5557: CharacterCategory.lo,
  5558: CharacterCategory.lo,
  5559: CharacterCategory.lo,
  5560: CharacterCategory.lo,
  5561: CharacterCategory.lo,
  5562: CharacterCategory.lo,
  5563: CharacterCategory.lo,
  5564: CharacterCategory.lo,
  5565: CharacterCategory.lo,
  5566: CharacterCategory.lo,
  5567: CharacterCategory.lo,
  5568: CharacterCategory.lo,
  5569: CharacterCategory.lo,
  5570: CharacterCategory.lo,
  5571: CharacterCategory.lo,
  5572: CharacterCategory.lo,
  5573: CharacterCategory.lo,
  5574: CharacterCategory.lo,
  5575: CharacterCategory.lo,
  5576: CharacterCategory.lo,
  5577: CharacterCategory.lo,
  5578: CharacterCategory.lo,
  5579: CharacterCategory.lo,
  5580: CharacterCategory.lo,
  5581: CharacterCategory.lo,
  5582: CharacterCategory.lo,
  5583: CharacterCategory.lo,
  5584: CharacterCategory.lo,
  5585: CharacterCategory.lo,
  5586: CharacterCategory.lo,
  5587: CharacterCategory.lo,
  5588: CharacterCategory.lo,
  5589: CharacterCategory.lo,
  5590: CharacterCategory.lo,
  5591: CharacterCategory.lo,
  5592: CharacterCategory.lo,
  5593: CharacterCategory.lo,
  5594: CharacterCategory.lo,
  5595: CharacterCategory.lo,
  5596: CharacterCategory.lo,
  5597: CharacterCategory.lo,
  5598: CharacterCategory.lo,
  5599: CharacterCategory.lo,
  5600: CharacterCategory.lo,
  5601: CharacterCategory.lo,
  5602: CharacterCategory.lo,
  5603: CharacterCategory.lo,
  5604: CharacterCategory.lo,
  5605: CharacterCategory.lo,
  5606: CharacterCategory.lo,
  5607: CharacterCategory.lo,
  5608: CharacterCategory.lo,
  5609: CharacterCategory.lo,
  5610: CharacterCategory.lo,
  5611: CharacterCategory.lo,
  5612: CharacterCategory.lo,
  5613: CharacterCategory.lo,
  5614: CharacterCategory.lo,
  5615: CharacterCategory.lo,
  5616: CharacterCategory.lo,
  5617: CharacterCategory.lo,
  5618: CharacterCategory.lo,
  5619: CharacterCategory.lo,
  5620: CharacterCategory.lo,
  5621: CharacterCategory.lo,
  5622: CharacterCategory.lo,
  5623: CharacterCategory.lo,
  5624: CharacterCategory.lo,
  5625: CharacterCategory.lo,
  5626: CharacterCategory.lo,
  5627: CharacterCategory.lo,
  5628: CharacterCategory.lo,
  5629: CharacterCategory.lo,
  5630: CharacterCategory.lo,
  5631: CharacterCategory.lo,
  5632: CharacterCategory.lo,
  5633: CharacterCategory.lo,
  5634: CharacterCategory.lo,
  5635: CharacterCategory.lo,
  5636: CharacterCategory.lo,
  5637: CharacterCategory.lo,
  5638: CharacterCategory.lo,
  5639: CharacterCategory.lo,
  5640: CharacterCategory.lo,
  5641: CharacterCategory.lo,
  5642: CharacterCategory.lo,
  5643: CharacterCategory.lo,
  5644: CharacterCategory.lo,
  5645: CharacterCategory.lo,
  5646: CharacterCategory.lo,
  5647: CharacterCategory.lo,
  5648: CharacterCategory.lo,
  5649: CharacterCategory.lo,
  5650: CharacterCategory.lo,
  5651: CharacterCategory.lo,
  5652: CharacterCategory.lo,
  5653: CharacterCategory.lo,
  5654: CharacterCategory.lo,
  5655: CharacterCategory.lo,
  5656: CharacterCategory.lo,
  5657: CharacterCategory.lo,
  5658: CharacterCategory.lo,
  5659: CharacterCategory.lo,
  5660: CharacterCategory.lo,
  5661: CharacterCategory.lo,
  5662: CharacterCategory.lo,
  5663: CharacterCategory.lo,
  5664: CharacterCategory.lo,
  5665: CharacterCategory.lo,
  5666: CharacterCategory.lo,
  5667: CharacterCategory.lo,
  5668: CharacterCategory.lo,
  5669: CharacterCategory.lo,
  5670: CharacterCategory.lo,
  5671: CharacterCategory.lo,
  5672: CharacterCategory.lo,
  5673: CharacterCategory.lo,
  5674: CharacterCategory.lo,
  5675: CharacterCategory.lo,
  5676: CharacterCategory.lo,
  5677: CharacterCategory.lo,
  5678: CharacterCategory.lo,
  5679: CharacterCategory.lo,
  5680: CharacterCategory.lo,
  5681: CharacterCategory.lo,
  5682: CharacterCategory.lo,
  5683: CharacterCategory.lo,
  5684: CharacterCategory.lo,
  5685: CharacterCategory.lo,
  5686: CharacterCategory.lo,
  5687: CharacterCategory.lo,
  5688: CharacterCategory.lo,
  5689: CharacterCategory.lo,
  5690: CharacterCategory.lo,
  5691: CharacterCategory.lo,
  5692: CharacterCategory.lo,
  5693: CharacterCategory.lo,
  5694: CharacterCategory.lo,
  5695: CharacterCategory.lo,
  5696: CharacterCategory.lo,
  5697: CharacterCategory.lo,
  5698: CharacterCategory.lo,
  5699: CharacterCategory.lo,
  5700: CharacterCategory.lo,
  5701: CharacterCategory.lo,
  5702: CharacterCategory.lo,
  5703: CharacterCategory.lo,
  5704: CharacterCategory.lo,
  5705: CharacterCategory.lo,
  5706: CharacterCategory.lo,
  5707: CharacterCategory.lo,
  5708: CharacterCategory.lo,
  5709: CharacterCategory.lo,
  5710: CharacterCategory.lo,
  5711: CharacterCategory.lo,
  5712: CharacterCategory.lo,
  5713: CharacterCategory.lo,
  5714: CharacterCategory.lo,
  5715: CharacterCategory.lo,
  5716: CharacterCategory.lo,
  5717: CharacterCategory.lo,
  5718: CharacterCategory.lo,
  5719: CharacterCategory.lo,
  5720: CharacterCategory.lo,
  5721: CharacterCategory.lo,
  5722: CharacterCategory.lo,
  5723: CharacterCategory.lo,
  5724: CharacterCategory.lo,
  5725: CharacterCategory.lo,
  5726: CharacterCategory.lo,
  5727: CharacterCategory.lo,
  5728: CharacterCategory.lo,
  5729: CharacterCategory.lo,
  5730: CharacterCategory.lo,
  5731: CharacterCategory.lo,
  5732: CharacterCategory.lo,
  5733: CharacterCategory.lo,
  5734: CharacterCategory.lo,
  5735: CharacterCategory.lo,
  5736: CharacterCategory.lo,
  5737: CharacterCategory.lo,
  5738: CharacterCategory.lo,
  5739: CharacterCategory.lo,
  5740: CharacterCategory.lo,
  5743: CharacterCategory.lo,
  5744: CharacterCategory.lo,
  5745: CharacterCategory.lo,
  5746: CharacterCategory.lo,
  5747: CharacterCategory.lo,
  5748: CharacterCategory.lo,
  5749: CharacterCategory.lo,
  5750: CharacterCategory.lo,
  5751: CharacterCategory.lo,
  5752: CharacterCategory.lo,
  5753: CharacterCategory.lo,
  5754: CharacterCategory.lo,
  5755: CharacterCategory.lo,
  5756: CharacterCategory.lo,
  5757: CharacterCategory.lo,
  5758: CharacterCategory.lo,
  5759: CharacterCategory.lo,
  5761: CharacterCategory.lo,
  5762: CharacterCategory.lo,
  5763: CharacterCategory.lo,
  5764: CharacterCategory.lo,
  5765: CharacterCategory.lo,
  5766: CharacterCategory.lo,
  5767: CharacterCategory.lo,
  5768: CharacterCategory.lo,
  5769: CharacterCategory.lo,
  5770: CharacterCategory.lo,
  5771: CharacterCategory.lo,
  5772: CharacterCategory.lo,
  5773: CharacterCategory.lo,
  5774: CharacterCategory.lo,
  5775: CharacterCategory.lo,
  5776: CharacterCategory.lo,
  5777: CharacterCategory.lo,
  5778: CharacterCategory.lo,
  5779: CharacterCategory.lo,
  5780: CharacterCategory.lo,
  5781: CharacterCategory.lo,
  5782: CharacterCategory.lo,
  5783: CharacterCategory.lo,
  5784: CharacterCategory.lo,
  5785: CharacterCategory.lo,
  5786: CharacterCategory.lo,
  5792: CharacterCategory.lo,
  5793: CharacterCategory.lo,
  5794: CharacterCategory.lo,
  5795: CharacterCategory.lo,
  5796: CharacterCategory.lo,
  5797: CharacterCategory.lo,
  5798: CharacterCategory.lo,
  5799: CharacterCategory.lo,
  5800: CharacterCategory.lo,
  5801: CharacterCategory.lo,
  5802: CharacterCategory.lo,
  5803: CharacterCategory.lo,
  5804: CharacterCategory.lo,
  5805: CharacterCategory.lo,
  5806: CharacterCategory.lo,
  5807: CharacterCategory.lo,
  5808: CharacterCategory.lo,
  5809: CharacterCategory.lo,
  5810: CharacterCategory.lo,
  5811: CharacterCategory.lo,
  5812: CharacterCategory.lo,
  5813: CharacterCategory.lo,
  5814: CharacterCategory.lo,
  5815: CharacterCategory.lo,
  5816: CharacterCategory.lo,
  5817: CharacterCategory.lo,
  5818: CharacterCategory.lo,
  5819: CharacterCategory.lo,
  5820: CharacterCategory.lo,
  5821: CharacterCategory.lo,
  5822: CharacterCategory.lo,
  5823: CharacterCategory.lo,
  5824: CharacterCategory.lo,
  5825: CharacterCategory.lo,
  5826: CharacterCategory.lo,
  5827: CharacterCategory.lo,
  5828: CharacterCategory.lo,
  5829: CharacterCategory.lo,
  5830: CharacterCategory.lo,
  5831: CharacterCategory.lo,
  5832: CharacterCategory.lo,
  5833: CharacterCategory.lo,
  5834: CharacterCategory.lo,
  5835: CharacterCategory.lo,
  5836: CharacterCategory.lo,
  5837: CharacterCategory.lo,
  5838: CharacterCategory.lo,
  5839: CharacterCategory.lo,
  5840: CharacterCategory.lo,
  5841: CharacterCategory.lo,
  5842: CharacterCategory.lo,
  5843: CharacterCategory.lo,
  5844: CharacterCategory.lo,
  5845: CharacterCategory.lo,
  5846: CharacterCategory.lo,
  5847: CharacterCategory.lo,
  5848: CharacterCategory.lo,
  5849: CharacterCategory.lo,
  5850: CharacterCategory.lo,
  5851: CharacterCategory.lo,
  5852: CharacterCategory.lo,
  5853: CharacterCategory.lo,
  5854: CharacterCategory.lo,
  5855: CharacterCategory.lo,
  5856: CharacterCategory.lo,
  5857: CharacterCategory.lo,
  5858: CharacterCategory.lo,
  5859: CharacterCategory.lo,
  5860: CharacterCategory.lo,
  5861: CharacterCategory.lo,
  5862: CharacterCategory.lo,
  5863: CharacterCategory.lo,
  5864: CharacterCategory.lo,
  5865: CharacterCategory.lo,
  5866: CharacterCategory.lo,
  5873: CharacterCategory.lo,
  5874: CharacterCategory.lo,
  5875: CharacterCategory.lo,
  5876: CharacterCategory.lo,
  5877: CharacterCategory.lo,
  5878: CharacterCategory.lo,
  5879: CharacterCategory.lo,
  5880: CharacterCategory.lo,
  5888: CharacterCategory.lo,
  5889: CharacterCategory.lo,
  5890: CharacterCategory.lo,
  5891: CharacterCategory.lo,
  5892: CharacterCategory.lo,
  5893: CharacterCategory.lo,
  5894: CharacterCategory.lo,
  5895: CharacterCategory.lo,
  5896: CharacterCategory.lo,
  5897: CharacterCategory.lo,
  5898: CharacterCategory.lo,
  5899: CharacterCategory.lo,
  5900: CharacterCategory.lo,
  5902: CharacterCategory.lo,
  5903: CharacterCategory.lo,
  5904: CharacterCategory.lo,
  5905: CharacterCategory.lo,
  5920: CharacterCategory.lo,
  5921: CharacterCategory.lo,
  5922: CharacterCategory.lo,
  5923: CharacterCategory.lo,
  5924: CharacterCategory.lo,
  5925: CharacterCategory.lo,
  5926: CharacterCategory.lo,
  5927: CharacterCategory.lo,
  5928: CharacterCategory.lo,
  5929: CharacterCategory.lo,
  5930: CharacterCategory.lo,
  5931: CharacterCategory.lo,
  5932: CharacterCategory.lo,
  5933: CharacterCategory.lo,
  5934: CharacterCategory.lo,
  5935: CharacterCategory.lo,
  5936: CharacterCategory.lo,
  5937: CharacterCategory.lo,
  5952: CharacterCategory.lo,
  5953: CharacterCategory.lo,
  5954: CharacterCategory.lo,
  5955: CharacterCategory.lo,
  5956: CharacterCategory.lo,
  5957: CharacterCategory.lo,
  5958: CharacterCategory.lo,
  5959: CharacterCategory.lo,
  5960: CharacterCategory.lo,
  5961: CharacterCategory.lo,
  5962: CharacterCategory.lo,
  5963: CharacterCategory.lo,
  5964: CharacterCategory.lo,
  5965: CharacterCategory.lo,
  5966: CharacterCategory.lo,
  5967: CharacterCategory.lo,
  5968: CharacterCategory.lo,
  5969: CharacterCategory.lo,
  5984: CharacterCategory.lo,
  5985: CharacterCategory.lo,
  5986: CharacterCategory.lo,
  5987: CharacterCategory.lo,
  5988: CharacterCategory.lo,
  5989: CharacterCategory.lo,
  5990: CharacterCategory.lo,
  5991: CharacterCategory.lo,
  5992: CharacterCategory.lo,
  5993: CharacterCategory.lo,
  5994: CharacterCategory.lo,
  5995: CharacterCategory.lo,
  5996: CharacterCategory.lo,
  5998: CharacterCategory.lo,
  5999: CharacterCategory.lo,
  6000: CharacterCategory.lo,
  6016: CharacterCategory.lo,
  6017: CharacterCategory.lo,
  6018: CharacterCategory.lo,
  6019: CharacterCategory.lo,
  6020: CharacterCategory.lo,
  6021: CharacterCategory.lo,
  6022: CharacterCategory.lo,
  6023: CharacterCategory.lo,
  6024: CharacterCategory.lo,
  6025: CharacterCategory.lo,
  6026: CharacterCategory.lo,
  6027: CharacterCategory.lo,
  6028: CharacterCategory.lo,
  6029: CharacterCategory.lo,
  6030: CharacterCategory.lo,
  6031: CharacterCategory.lo,
  6032: CharacterCategory.lo,
  6033: CharacterCategory.lo,
  6034: CharacterCategory.lo,
  6035: CharacterCategory.lo,
  6036: CharacterCategory.lo,
  6037: CharacterCategory.lo,
  6038: CharacterCategory.lo,
  6039: CharacterCategory.lo,
  6040: CharacterCategory.lo,
  6041: CharacterCategory.lo,
  6042: CharacterCategory.lo,
  6043: CharacterCategory.lo,
  6044: CharacterCategory.lo,
  6045: CharacterCategory.lo,
  6046: CharacterCategory.lo,
  6047: CharacterCategory.lo,
  6048: CharacterCategory.lo,
  6049: CharacterCategory.lo,
  6050: CharacterCategory.lo,
  6051: CharacterCategory.lo,
  6052: CharacterCategory.lo,
  6053: CharacterCategory.lo,
  6054: CharacterCategory.lo,
  6055: CharacterCategory.lo,
  6056: CharacterCategory.lo,
  6057: CharacterCategory.lo,
  6058: CharacterCategory.lo,
  6059: CharacterCategory.lo,
  6060: CharacterCategory.lo,
  6061: CharacterCategory.lo,
  6062: CharacterCategory.lo,
  6063: CharacterCategory.lo,
  6064: CharacterCategory.lo,
  6065: CharacterCategory.lo,
  6066: CharacterCategory.lo,
  6067: CharacterCategory.lo,
  6108: CharacterCategory.lo,
  6176: CharacterCategory.lo,
  6177: CharacterCategory.lo,
  6178: CharacterCategory.lo,
  6179: CharacterCategory.lo,
  6180: CharacterCategory.lo,
  6181: CharacterCategory.lo,
  6182: CharacterCategory.lo,
  6183: CharacterCategory.lo,
  6184: CharacterCategory.lo,
  6185: CharacterCategory.lo,
  6186: CharacterCategory.lo,
  6187: CharacterCategory.lo,
  6188: CharacterCategory.lo,
  6189: CharacterCategory.lo,
  6190: CharacterCategory.lo,
  6191: CharacterCategory.lo,
  6192: CharacterCategory.lo,
  6193: CharacterCategory.lo,
  6194: CharacterCategory.lo,
  6195: CharacterCategory.lo,
  6196: CharacterCategory.lo,
  6197: CharacterCategory.lo,
  6198: CharacterCategory.lo,
  6199: CharacterCategory.lo,
  6200: CharacterCategory.lo,
  6201: CharacterCategory.lo,
  6202: CharacterCategory.lo,
  6203: CharacterCategory.lo,
  6204: CharacterCategory.lo,
  6205: CharacterCategory.lo,
  6206: CharacterCategory.lo,
  6207: CharacterCategory.lo,
  6208: CharacterCategory.lo,
  6209: CharacterCategory.lo,
  6210: CharacterCategory.lo,
  6212: CharacterCategory.lo,
  6213: CharacterCategory.lo,
  6214: CharacterCategory.lo,
  6215: CharacterCategory.lo,
  6216: CharacterCategory.lo,
  6217: CharacterCategory.lo,
  6218: CharacterCategory.lo,
  6219: CharacterCategory.lo,
  6220: CharacterCategory.lo,
  6221: CharacterCategory.lo,
  6222: CharacterCategory.lo,
  6223: CharacterCategory.lo,
  6224: CharacterCategory.lo,
  6225: CharacterCategory.lo,
  6226: CharacterCategory.lo,
  6227: CharacterCategory.lo,
  6228: CharacterCategory.lo,
  6229: CharacterCategory.lo,
  6230: CharacterCategory.lo,
  6231: CharacterCategory.lo,
  6232: CharacterCategory.lo,
  6233: CharacterCategory.lo,
  6234: CharacterCategory.lo,
  6235: CharacterCategory.lo,
  6236: CharacterCategory.lo,
  6237: CharacterCategory.lo,
  6238: CharacterCategory.lo,
  6239: CharacterCategory.lo,
  6240: CharacterCategory.lo,
  6241: CharacterCategory.lo,
  6242: CharacterCategory.lo,
  6243: CharacterCategory.lo,
  6244: CharacterCategory.lo,
  6245: CharacterCategory.lo,
  6246: CharacterCategory.lo,
  6247: CharacterCategory.lo,
  6248: CharacterCategory.lo,
  6249: CharacterCategory.lo,
  6250: CharacterCategory.lo,
  6251: CharacterCategory.lo,
  6252: CharacterCategory.lo,
  6253: CharacterCategory.lo,
  6254: CharacterCategory.lo,
  6255: CharacterCategory.lo,
  6256: CharacterCategory.lo,
  6257: CharacterCategory.lo,
  6258: CharacterCategory.lo,
  6259: CharacterCategory.lo,
  6260: CharacterCategory.lo,
  6261: CharacterCategory.lo,
  6262: CharacterCategory.lo,
  6263: CharacterCategory.lo,
  6272: CharacterCategory.lo,
  6273: CharacterCategory.lo,
  6274: CharacterCategory.lo,
  6275: CharacterCategory.lo,
  6276: CharacterCategory.lo,
  6277: CharacterCategory.lo,
  6278: CharacterCategory.lo,
  6279: CharacterCategory.lo,
  6280: CharacterCategory.lo,
  6281: CharacterCategory.lo,
  6282: CharacterCategory.lo,
  6283: CharacterCategory.lo,
  6284: CharacterCategory.lo,
  6285: CharacterCategory.lo,
  6286: CharacterCategory.lo,
  6287: CharacterCategory.lo,
  6288: CharacterCategory.lo,
  6289: CharacterCategory.lo,
  6290: CharacterCategory.lo,
  6291: CharacterCategory.lo,
  6292: CharacterCategory.lo,
  6293: CharacterCategory.lo,
  6294: CharacterCategory.lo,
  6295: CharacterCategory.lo,
  6296: CharacterCategory.lo,
  6297: CharacterCategory.lo,
  6298: CharacterCategory.lo,
  6299: CharacterCategory.lo,
  6300: CharacterCategory.lo,
  6301: CharacterCategory.lo,
  6302: CharacterCategory.lo,
  6303: CharacterCategory.lo,
  6304: CharacterCategory.lo,
  6305: CharacterCategory.lo,
  6306: CharacterCategory.lo,
  6307: CharacterCategory.lo,
  6308: CharacterCategory.lo,
  6309: CharacterCategory.lo,
  6310: CharacterCategory.lo,
  6311: CharacterCategory.lo,
  6312: CharacterCategory.lo,
  6314: CharacterCategory.lo,
  6320: CharacterCategory.lo,
  6321: CharacterCategory.lo,
  6322: CharacterCategory.lo,
  6323: CharacterCategory.lo,
  6324: CharacterCategory.lo,
  6325: CharacterCategory.lo,
  6326: CharacterCategory.lo,
  6327: CharacterCategory.lo,
  6328: CharacterCategory.lo,
  6329: CharacterCategory.lo,
  6330: CharacterCategory.lo,
  6331: CharacterCategory.lo,
  6332: CharacterCategory.lo,
  6333: CharacterCategory.lo,
  6334: CharacterCategory.lo,
  6335: CharacterCategory.lo,
  6336: CharacterCategory.lo,
  6337: CharacterCategory.lo,
  6338: CharacterCategory.lo,
  6339: CharacterCategory.lo,
  6340: CharacterCategory.lo,
  6341: CharacterCategory.lo,
  6342: CharacterCategory.lo,
  6343: CharacterCategory.lo,
  6344: CharacterCategory.lo,
  6345: CharacterCategory.lo,
  6346: CharacterCategory.lo,
  6347: CharacterCategory.lo,
  6348: CharacterCategory.lo,
  6349: CharacterCategory.lo,
  6350: CharacterCategory.lo,
  6351: CharacterCategory.lo,
  6352: CharacterCategory.lo,
  6353: CharacterCategory.lo,
  6354: CharacterCategory.lo,
  6355: CharacterCategory.lo,
  6356: CharacterCategory.lo,
  6357: CharacterCategory.lo,
  6358: CharacterCategory.lo,
  6359: CharacterCategory.lo,
  6360: CharacterCategory.lo,
  6361: CharacterCategory.lo,
  6362: CharacterCategory.lo,
  6363: CharacterCategory.lo,
  6364: CharacterCategory.lo,
  6365: CharacterCategory.lo,
  6366: CharacterCategory.lo,
  6367: CharacterCategory.lo,
  6368: CharacterCategory.lo,
  6369: CharacterCategory.lo,
  6370: CharacterCategory.lo,
  6371: CharacterCategory.lo,
  6372: CharacterCategory.lo,
  6373: CharacterCategory.lo,
  6374: CharacterCategory.lo,
  6375: CharacterCategory.lo,
  6376: CharacterCategory.lo,
  6377: CharacterCategory.lo,
  6378: CharacterCategory.lo,
  6379: CharacterCategory.lo,
  6380: CharacterCategory.lo,
  6381: CharacterCategory.lo,
  6382: CharacterCategory.lo,
  6383: CharacterCategory.lo,
  6384: CharacterCategory.lo,
  6385: CharacterCategory.lo,
  6386: CharacterCategory.lo,
  6387: CharacterCategory.lo,
  6388: CharacterCategory.lo,
  6389: CharacterCategory.lo,
  6400: CharacterCategory.lo,
  6401: CharacterCategory.lo,
  6402: CharacterCategory.lo,
  6403: CharacterCategory.lo,
  6404: CharacterCategory.lo,
  6405: CharacterCategory.lo,
  6406: CharacterCategory.lo,
  6407: CharacterCategory.lo,
  6408: CharacterCategory.lo,
  6409: CharacterCategory.lo,
  6410: CharacterCategory.lo,
  6411: CharacterCategory.lo,
  6412: CharacterCategory.lo,
  6413: CharacterCategory.lo,
  6414: CharacterCategory.lo,
  6415: CharacterCategory.lo,
  6416: CharacterCategory.lo,
  6417: CharacterCategory.lo,
  6418: CharacterCategory.lo,
  6419: CharacterCategory.lo,
  6420: CharacterCategory.lo,
  6421: CharacterCategory.lo,
  6422: CharacterCategory.lo,
  6423: CharacterCategory.lo,
  6424: CharacterCategory.lo,
  6425: CharacterCategory.lo,
  6426: CharacterCategory.lo,
  6427: CharacterCategory.lo,
  6428: CharacterCategory.lo,
  6429: CharacterCategory.lo,
  6430: CharacterCategory.lo,
  6480: CharacterCategory.lo,
  6481: CharacterCategory.lo,
  6482: CharacterCategory.lo,
  6483: CharacterCategory.lo,
  6484: CharacterCategory.lo,
  6485: CharacterCategory.lo,
  6486: CharacterCategory.lo,
  6487: CharacterCategory.lo,
  6488: CharacterCategory.lo,
  6489: CharacterCategory.lo,
  6490: CharacterCategory.lo,
  6491: CharacterCategory.lo,
  6492: CharacterCategory.lo,
  6493: CharacterCategory.lo,
  6494: CharacterCategory.lo,
  6495: CharacterCategory.lo,
  6496: CharacterCategory.lo,
  6497: CharacterCategory.lo,
  6498: CharacterCategory.lo,
  6499: CharacterCategory.lo,
  6500: CharacterCategory.lo,
  6501: CharacterCategory.lo,
  6502: CharacterCategory.lo,
  6503: CharacterCategory.lo,
  6504: CharacterCategory.lo,
  6505: CharacterCategory.lo,
  6506: CharacterCategory.lo,
  6507: CharacterCategory.lo,
  6508: CharacterCategory.lo,
  6509: CharacterCategory.lo,
  6512: CharacterCategory.lo,
  6513: CharacterCategory.lo,
  6514: CharacterCategory.lo,
  6515: CharacterCategory.lo,
  6516: CharacterCategory.lo,
  6528: CharacterCategory.lo,
  6529: CharacterCategory.lo,
  6530: CharacterCategory.lo,
  6531: CharacterCategory.lo,
  6532: CharacterCategory.lo,
  6533: CharacterCategory.lo,
  6534: CharacterCategory.lo,
  6535: CharacterCategory.lo,
  6536: CharacterCategory.lo,
  6537: CharacterCategory.lo,
  6538: CharacterCategory.lo,
  6539: CharacterCategory.lo,
  6540: CharacterCategory.lo,
  6541: CharacterCategory.lo,
  6542: CharacterCategory.lo,
  6543: CharacterCategory.lo,
  6544: CharacterCategory.lo,
  6545: CharacterCategory.lo,
  6546: CharacterCategory.lo,
  6547: CharacterCategory.lo,
  6548: CharacterCategory.lo,
  6549: CharacterCategory.lo,
  6550: CharacterCategory.lo,
  6551: CharacterCategory.lo,
  6552: CharacterCategory.lo,
  6553: CharacterCategory.lo,
  6554: CharacterCategory.lo,
  6555: CharacterCategory.lo,
  6556: CharacterCategory.lo,
  6557: CharacterCategory.lo,
  6558: CharacterCategory.lo,
  6559: CharacterCategory.lo,
  6560: CharacterCategory.lo,
  6561: CharacterCategory.lo,
  6562: CharacterCategory.lo,
  6563: CharacterCategory.lo,
  6564: CharacterCategory.lo,
  6565: CharacterCategory.lo,
  6566: CharacterCategory.lo,
  6567: CharacterCategory.lo,
  6568: CharacterCategory.lo,
  6569: CharacterCategory.lo,
  6570: CharacterCategory.lo,
  6571: CharacterCategory.lo,
  6593: CharacterCategory.lo,
  6594: CharacterCategory.lo,
  6595: CharacterCategory.lo,
  6596: CharacterCategory.lo,
  6597: CharacterCategory.lo,
  6598: CharacterCategory.lo,
  6599: CharacterCategory.lo,
  6656: CharacterCategory.lo,
  6657: CharacterCategory.lo,
  6658: CharacterCategory.lo,
  6659: CharacterCategory.lo,
  6660: CharacterCategory.lo,
  6661: CharacterCategory.lo,
  6662: CharacterCategory.lo,
  6663: CharacterCategory.lo,
  6664: CharacterCategory.lo,
  6665: CharacterCategory.lo,
  6666: CharacterCategory.lo,
  6667: CharacterCategory.lo,
  6668: CharacterCategory.lo,
  6669: CharacterCategory.lo,
  6670: CharacterCategory.lo,
  6671: CharacterCategory.lo,
  6672: CharacterCategory.lo,
  6673: CharacterCategory.lo,
  6674: CharacterCategory.lo,
  6675: CharacterCategory.lo,
  6676: CharacterCategory.lo,
  6677: CharacterCategory.lo,
  6678: CharacterCategory.lo,
  6688: CharacterCategory.lo,
  6689: CharacterCategory.lo,
  6690: CharacterCategory.lo,
  6691: CharacterCategory.lo,
  6692: CharacterCategory.lo,
  6693: CharacterCategory.lo,
  6694: CharacterCategory.lo,
  6695: CharacterCategory.lo,
  6696: CharacterCategory.lo,
  6697: CharacterCategory.lo,
  6698: CharacterCategory.lo,
  6699: CharacterCategory.lo,
  6700: CharacterCategory.lo,
  6701: CharacterCategory.lo,
  6702: CharacterCategory.lo,
  6703: CharacterCategory.lo,
  6704: CharacterCategory.lo,
  6705: CharacterCategory.lo,
  6706: CharacterCategory.lo,
  6707: CharacterCategory.lo,
  6708: CharacterCategory.lo,
  6709: CharacterCategory.lo,
  6710: CharacterCategory.lo,
  6711: CharacterCategory.lo,
  6712: CharacterCategory.lo,
  6713: CharacterCategory.lo,
  6714: CharacterCategory.lo,
  6715: CharacterCategory.lo,
  6716: CharacterCategory.lo,
  6717: CharacterCategory.lo,
  6718: CharacterCategory.lo,
  6719: CharacterCategory.lo,
  6720: CharacterCategory.lo,
  6721: CharacterCategory.lo,
  6722: CharacterCategory.lo,
  6723: CharacterCategory.lo,
  6724: CharacterCategory.lo,
  6725: CharacterCategory.lo,
  6726: CharacterCategory.lo,
  6727: CharacterCategory.lo,
  6728: CharacterCategory.lo,
  6729: CharacterCategory.lo,
  6730: CharacterCategory.lo,
  6731: CharacterCategory.lo,
  6732: CharacterCategory.lo,
  6733: CharacterCategory.lo,
  6734: CharacterCategory.lo,
  6735: CharacterCategory.lo,
  6736: CharacterCategory.lo,
  6737: CharacterCategory.lo,
  6738: CharacterCategory.lo,
  6739: CharacterCategory.lo,
  6740: CharacterCategory.lo,
  6917: CharacterCategory.lo,
  6918: CharacterCategory.lo,
  6919: CharacterCategory.lo,
  6920: CharacterCategory.lo,
  6921: CharacterCategory.lo,
  6922: CharacterCategory.lo,
  6923: CharacterCategory.lo,
  6924: CharacterCategory.lo,
  6925: CharacterCategory.lo,
  6926: CharacterCategory.lo,
  6927: CharacterCategory.lo,
  6928: CharacterCategory.lo,
  6929: CharacterCategory.lo,
  6930: CharacterCategory.lo,
  6931: CharacterCategory.lo,
  6932: CharacterCategory.lo,
  6933: CharacterCategory.lo,
  6934: CharacterCategory.lo,
  6935: CharacterCategory.lo,
  6936: CharacterCategory.lo,
  6937: CharacterCategory.lo,
  6938: CharacterCategory.lo,
  6939: CharacterCategory.lo,
  6940: CharacterCategory.lo,
  6941: CharacterCategory.lo,
  6942: CharacterCategory.lo,
  6943: CharacterCategory.lo,
  6944: CharacterCategory.lo,
  6945: CharacterCategory.lo,
  6946: CharacterCategory.lo,
  6947: CharacterCategory.lo,
  6948: CharacterCategory.lo,
  6949: CharacterCategory.lo,
  6950: CharacterCategory.lo,
  6951: CharacterCategory.lo,
  6952: CharacterCategory.lo,
  6953: CharacterCategory.lo,
  6954: CharacterCategory.lo,
  6955: CharacterCategory.lo,
  6956: CharacterCategory.lo,
  6957: CharacterCategory.lo,
  6958: CharacterCategory.lo,
  6959: CharacterCategory.lo,
  6960: CharacterCategory.lo,
  6961: CharacterCategory.lo,
  6962: CharacterCategory.lo,
  6963: CharacterCategory.lo,
  6981: CharacterCategory.lo,
  6982: CharacterCategory.lo,
  6983: CharacterCategory.lo,
  6984: CharacterCategory.lo,
  6985: CharacterCategory.lo,
  6986: CharacterCategory.lo,
  6987: CharacterCategory.lo,
  7043: CharacterCategory.lo,
  7044: CharacterCategory.lo,
  7045: CharacterCategory.lo,
  7046: CharacterCategory.lo,
  7047: CharacterCategory.lo,
  7048: CharacterCategory.lo,
  7049: CharacterCategory.lo,
  7050: CharacterCategory.lo,
  7051: CharacterCategory.lo,
  7052: CharacterCategory.lo,
  7053: CharacterCategory.lo,
  7054: CharacterCategory.lo,
  7055: CharacterCategory.lo,
  7056: CharacterCategory.lo,
  7057: CharacterCategory.lo,
  7058: CharacterCategory.lo,
  7059: CharacterCategory.lo,
  7060: CharacterCategory.lo,
  7061: CharacterCategory.lo,
  7062: CharacterCategory.lo,
  7063: CharacterCategory.lo,
  7064: CharacterCategory.lo,
  7065: CharacterCategory.lo,
  7066: CharacterCategory.lo,
  7067: CharacterCategory.lo,
  7068: CharacterCategory.lo,
  7069: CharacterCategory.lo,
  7070: CharacterCategory.lo,
  7071: CharacterCategory.lo,
  7072: CharacterCategory.lo,
  7086: CharacterCategory.lo,
  7087: CharacterCategory.lo,
  7098: CharacterCategory.lo,
  7099: CharacterCategory.lo,
  7100: CharacterCategory.lo,
  7101: CharacterCategory.lo,
  7102: CharacterCategory.lo,
  7103: CharacterCategory.lo,
  7104: CharacterCategory.lo,
  7105: CharacterCategory.lo,
  7106: CharacterCategory.lo,
  7107: CharacterCategory.lo,
  7108: CharacterCategory.lo,
  7109: CharacterCategory.lo,
  7110: CharacterCategory.lo,
  7111: CharacterCategory.lo,
  7112: CharacterCategory.lo,
  7113: CharacterCategory.lo,
  7114: CharacterCategory.lo,
  7115: CharacterCategory.lo,
  7116: CharacterCategory.lo,
  7117: CharacterCategory.lo,
  7118: CharacterCategory.lo,
  7119: CharacterCategory.lo,
  7120: CharacterCategory.lo,
  7121: CharacterCategory.lo,
  7122: CharacterCategory.lo,
  7123: CharacterCategory.lo,
  7124: CharacterCategory.lo,
  7125: CharacterCategory.lo,
  7126: CharacterCategory.lo,
  7127: CharacterCategory.lo,
  7128: CharacterCategory.lo,
  7129: CharacterCategory.lo,
  7130: CharacterCategory.lo,
  7131: CharacterCategory.lo,
  7132: CharacterCategory.lo,
  7133: CharacterCategory.lo,
  7134: CharacterCategory.lo,
  7135: CharacterCategory.lo,
  7136: CharacterCategory.lo,
  7137: CharacterCategory.lo,
  7138: CharacterCategory.lo,
  7139: CharacterCategory.lo,
  7140: CharacterCategory.lo,
  7141: CharacterCategory.lo,
  7168: CharacterCategory.lo,
  7169: CharacterCategory.lo,
  7170: CharacterCategory.lo,
  7171: CharacterCategory.lo,
  7172: CharacterCategory.lo,
  7173: CharacterCategory.lo,
  7174: CharacterCategory.lo,
  7175: CharacterCategory.lo,
  7176: CharacterCategory.lo,
  7177: CharacterCategory.lo,
  7178: CharacterCategory.lo,
  7179: CharacterCategory.lo,
  7180: CharacterCategory.lo,
  7181: CharacterCategory.lo,
  7182: CharacterCategory.lo,
  7183: CharacterCategory.lo,
  7184: CharacterCategory.lo,
  7185: CharacterCategory.lo,
  7186: CharacterCategory.lo,
  7187: CharacterCategory.lo,
  7188: CharacterCategory.lo,
  7189: CharacterCategory.lo,
  7190: CharacterCategory.lo,
  7191: CharacterCategory.lo,
  7192: CharacterCategory.lo,
  7193: CharacterCategory.lo,
  7194: CharacterCategory.lo,
  7195: CharacterCategory.lo,
  7196: CharacterCategory.lo,
  7197: CharacterCategory.lo,
  7198: CharacterCategory.lo,
  7199: CharacterCategory.lo,
  7200: CharacterCategory.lo,
  7201: CharacterCategory.lo,
  7202: CharacterCategory.lo,
  7203: CharacterCategory.lo,
  7245: CharacterCategory.lo,
  7246: CharacterCategory.lo,
  7247: CharacterCategory.lo,
  7258: CharacterCategory.lo,
  7259: CharacterCategory.lo,
  7260: CharacterCategory.lo,
  7261: CharacterCategory.lo,
  7262: CharacterCategory.lo,
  7263: CharacterCategory.lo,
  7264: CharacterCategory.lo,
  7265: CharacterCategory.lo,
  7266: CharacterCategory.lo,
  7267: CharacterCategory.lo,
  7268: CharacterCategory.lo,
  7269: CharacterCategory.lo,
  7270: CharacterCategory.lo,
  7271: CharacterCategory.lo,
  7272: CharacterCategory.lo,
  7273: CharacterCategory.lo,
  7274: CharacterCategory.lo,
  7275: CharacterCategory.lo,
  7276: CharacterCategory.lo,
  7277: CharacterCategory.lo,
  7278: CharacterCategory.lo,
  7279: CharacterCategory.lo,
  7280: CharacterCategory.lo,
  7281: CharacterCategory.lo,
  7282: CharacterCategory.lo,
  7283: CharacterCategory.lo,
  7284: CharacterCategory.lo,
  7285: CharacterCategory.lo,
  7286: CharacterCategory.lo,
  7287: CharacterCategory.lo,
  7401: CharacterCategory.lo,
  7402: CharacterCategory.lo,
  7403: CharacterCategory.lo,
  7404: CharacterCategory.lo,
  7406: CharacterCategory.lo,
  7407: CharacterCategory.lo,
  7408: CharacterCategory.lo,
  7409: CharacterCategory.lo,
  7413: CharacterCategory.lo,
  7414: CharacterCategory.lo,
  8501: CharacterCategory.lo,
  8502: CharacterCategory.lo,
  8503: CharacterCategory.lo,
  8504: CharacterCategory.lo,
  11568: CharacterCategory.lo,
  11569: CharacterCategory.lo,
  11570: CharacterCategory.lo,
  11571: CharacterCategory.lo,
  11572: CharacterCategory.lo,
  11573: CharacterCategory.lo,
  11574: CharacterCategory.lo,
  11575: CharacterCategory.lo,
  11576: CharacterCategory.lo,
  11577: CharacterCategory.lo,
  11578: CharacterCategory.lo,
  11579: CharacterCategory.lo,
  11580: CharacterCategory.lo,
  11581: CharacterCategory.lo,
  11582: CharacterCategory.lo,
  11583: CharacterCategory.lo,
  11584: CharacterCategory.lo,
  11585: CharacterCategory.lo,
  11586: CharacterCategory.lo,
  11587: CharacterCategory.lo,
  11588: CharacterCategory.lo,
  11589: CharacterCategory.lo,
  11590: CharacterCategory.lo,
  11591: CharacterCategory.lo,
  11592: CharacterCategory.lo,
  11593: CharacterCategory.lo,
  11594: CharacterCategory.lo,
  11595: CharacterCategory.lo,
  11596: CharacterCategory.lo,
  11597: CharacterCategory.lo,
  11598: CharacterCategory.lo,
  11599: CharacterCategory.lo,
  11600: CharacterCategory.lo,
  11601: CharacterCategory.lo,
  11602: CharacterCategory.lo,
  11603: CharacterCategory.lo,
  11604: CharacterCategory.lo,
  11605: CharacterCategory.lo,
  11606: CharacterCategory.lo,
  11607: CharacterCategory.lo,
  11608: CharacterCategory.lo,
  11609: CharacterCategory.lo,
  11610: CharacterCategory.lo,
  11611: CharacterCategory.lo,
  11612: CharacterCategory.lo,
  11613: CharacterCategory.lo,
  11614: CharacterCategory.lo,
  11615: CharacterCategory.lo,
  11616: CharacterCategory.lo,
  11617: CharacterCategory.lo,
  11618: CharacterCategory.lo,
  11619: CharacterCategory.lo,
  11620: CharacterCategory.lo,
  11621: CharacterCategory.lo,
  11622: CharacterCategory.lo,
  11623: CharacterCategory.lo,
  11648: CharacterCategory.lo,
  11649: CharacterCategory.lo,
  11650: CharacterCategory.lo,
  11651: CharacterCategory.lo,
  11652: CharacterCategory.lo,
  11653: CharacterCategory.lo,
  11654: CharacterCategory.lo,
  11655: CharacterCategory.lo,
  11656: CharacterCategory.lo,
  11657: CharacterCategory.lo,
  11658: CharacterCategory.lo,
  11659: CharacterCategory.lo,
  11660: CharacterCategory.lo,
  11661: CharacterCategory.lo,
  11662: CharacterCategory.lo,
  11663: CharacterCategory.lo,
  11664: CharacterCategory.lo,
  11665: CharacterCategory.lo,
  11666: CharacterCategory.lo,
  11667: CharacterCategory.lo,
  11668: CharacterCategory.lo,
  11669: CharacterCategory.lo,
  11670: CharacterCategory.lo,
  11680: CharacterCategory.lo,
  11681: CharacterCategory.lo,
  11682: CharacterCategory.lo,
  11683: CharacterCategory.lo,
  11684: CharacterCategory.lo,
  11685: CharacterCategory.lo,
  11686: CharacterCategory.lo,
  11688: CharacterCategory.lo,
  11689: CharacterCategory.lo,
  11690: CharacterCategory.lo,
  11691: CharacterCategory.lo,
  11692: CharacterCategory.lo,
  11693: CharacterCategory.lo,
  11694: CharacterCategory.lo,
  11696: CharacterCategory.lo,
  11697: CharacterCategory.lo,
  11698: CharacterCategory.lo,
  11699: CharacterCategory.lo,
  11700: CharacterCategory.lo,
  11701: CharacterCategory.lo,
  11702: CharacterCategory.lo,
  11704: CharacterCategory.lo,
  11705: CharacterCategory.lo,
  11706: CharacterCategory.lo,
  11707: CharacterCategory.lo,
  11708: CharacterCategory.lo,
  11709: CharacterCategory.lo,
  11710: CharacterCategory.lo,
  11712: CharacterCategory.lo,
  11713: CharacterCategory.lo,
  11714: CharacterCategory.lo,
  11715: CharacterCategory.lo,
  11716: CharacterCategory.lo,
  11717: CharacterCategory.lo,
  11718: CharacterCategory.lo,
  11720: CharacterCategory.lo,
  11721: CharacterCategory.lo,
  11722: CharacterCategory.lo,
  11723: CharacterCategory.lo,
  11724: CharacterCategory.lo,
  11725: CharacterCategory.lo,
  11726: CharacterCategory.lo,
  11728: CharacterCategory.lo,
  11729: CharacterCategory.lo,
  11730: CharacterCategory.lo,
  11731: CharacterCategory.lo,
  11732: CharacterCategory.lo,
  11733: CharacterCategory.lo,
  11734: CharacterCategory.lo,
  11736: CharacterCategory.lo,
  11737: CharacterCategory.lo,
  11738: CharacterCategory.lo,
  11739: CharacterCategory.lo,
  11740: CharacterCategory.lo,
  11741: CharacterCategory.lo,
  11742: CharacterCategory.lo,
  12294: CharacterCategory.lo,
  12348: CharacterCategory.lo,
  12353: CharacterCategory.lo,
  12354: CharacterCategory.lo,
  12355: CharacterCategory.lo,
  12356: CharacterCategory.lo,
  12357: CharacterCategory.lo,
  12358: CharacterCategory.lo,
  12359: CharacterCategory.lo,
  12360: CharacterCategory.lo,
  12361: CharacterCategory.lo,
  12362: CharacterCategory.lo,
  12363: CharacterCategory.lo,
  12364: CharacterCategory.lo,
  12365: CharacterCategory.lo,
  12366: CharacterCategory.lo,
  12367: CharacterCategory.lo,
  12368: CharacterCategory.lo,
  12369: CharacterCategory.lo,
  12370: CharacterCategory.lo,
  12371: CharacterCategory.lo,
  12372: CharacterCategory.lo,
  12373: CharacterCategory.lo,
  12374: CharacterCategory.lo,
  12375: CharacterCategory.lo,
  12376: CharacterCategory.lo,
  12377: CharacterCategory.lo,
  12378: CharacterCategory.lo,
  12379: CharacterCategory.lo,
  12380: CharacterCategory.lo,
  12381: CharacterCategory.lo,
  12382: CharacterCategory.lo,
  12383: CharacterCategory.lo,
  12384: CharacterCategory.lo,
  12385: CharacterCategory.lo,
  12386: CharacterCategory.lo,
  12387: CharacterCategory.lo,
  12388: CharacterCategory.lo,
  12389: CharacterCategory.lo,
  12390: CharacterCategory.lo,
  12391: CharacterCategory.lo,
  12392: CharacterCategory.lo,
  12393: CharacterCategory.lo,
  12394: CharacterCategory.lo,
  12395: CharacterCategory.lo,
  12396: CharacterCategory.lo,
  12397: CharacterCategory.lo,
  12398: CharacterCategory.lo,
  12399: CharacterCategory.lo,
  12400: CharacterCategory.lo,
  12401: CharacterCategory.lo,
  12402: CharacterCategory.lo,
  12403: CharacterCategory.lo,
  12404: CharacterCategory.lo,
  12405: CharacterCategory.lo,
  12406: CharacterCategory.lo,
  12407: CharacterCategory.lo,
  12408: CharacterCategory.lo,
  12409: CharacterCategory.lo,
  12410: CharacterCategory.lo,
  12411: CharacterCategory.lo,
  12412: CharacterCategory.lo,
  12413: CharacterCategory.lo,
  12414: CharacterCategory.lo,
  12415: CharacterCategory.lo,
  12416: CharacterCategory.lo,
  12417: CharacterCategory.lo,
  12418: CharacterCategory.lo,
  12419: CharacterCategory.lo,
  12420: CharacterCategory.lo,
  12421: CharacterCategory.lo,
  12422: CharacterCategory.lo,
  12423: CharacterCategory.lo,
  12424: CharacterCategory.lo,
  12425: CharacterCategory.lo,
  12426: CharacterCategory.lo,
  12427: CharacterCategory.lo,
  12428: CharacterCategory.lo,
  12429: CharacterCategory.lo,
  12430: CharacterCategory.lo,
  12431: CharacterCategory.lo,
  12432: CharacterCategory.lo,
  12433: CharacterCategory.lo,
  12434: CharacterCategory.lo,
  12435: CharacterCategory.lo,
  12436: CharacterCategory.lo,
  12437: CharacterCategory.lo,
  12438: CharacterCategory.lo,
  12447: CharacterCategory.lo,
  12449: CharacterCategory.lo,
  12450: CharacterCategory.lo,
  12451: CharacterCategory.lo,
  12452: CharacterCategory.lo,
  12453: CharacterCategory.lo,
  12454: CharacterCategory.lo,
  12455: CharacterCategory.lo,
  12456: CharacterCategory.lo,
  12457: CharacterCategory.lo,
  12458: CharacterCategory.lo,
  12459: CharacterCategory.lo,
  12460: CharacterCategory.lo,
  12461: CharacterCategory.lo,
  12462: CharacterCategory.lo,
  12463: CharacterCategory.lo,
  12464: CharacterCategory.lo,
  12465: CharacterCategory.lo,
  12466: CharacterCategory.lo,
  12467: CharacterCategory.lo,
  12468: CharacterCategory.lo,
  12469: CharacterCategory.lo,
  12470: CharacterCategory.lo,
  12471: CharacterCategory.lo,
  12472: CharacterCategory.lo,
  12473: CharacterCategory.lo,
  12474: CharacterCategory.lo,
  12475: CharacterCategory.lo,
  12476: CharacterCategory.lo,
  12477: CharacterCategory.lo,
  12478: CharacterCategory.lo,
  12479: CharacterCategory.lo,
  12480: CharacterCategory.lo,
  12481: CharacterCategory.lo,
  12482: CharacterCategory.lo,
  12483: CharacterCategory.lo,
  12484: CharacterCategory.lo,
  12485: CharacterCategory.lo,
  12486: CharacterCategory.lo,
  12487: CharacterCategory.lo,
  12488: CharacterCategory.lo,
  12489: CharacterCategory.lo,
  12490: CharacterCategory.lo,
  12491: CharacterCategory.lo,
  12492: CharacterCategory.lo,
  12493: CharacterCategory.lo,
  12494: CharacterCategory.lo,
  12495: CharacterCategory.lo,
  12496: CharacterCategory.lo,
  12497: CharacterCategory.lo,
  12498: CharacterCategory.lo,
  12499: CharacterCategory.lo,
  12500: CharacterCategory.lo,
  12501: CharacterCategory.lo,
  12502: CharacterCategory.lo,
  12503: CharacterCategory.lo,
  12504: CharacterCategory.lo,
  12505: CharacterCategory.lo,
  12506: CharacterCategory.lo,
  12507: CharacterCategory.lo,
  12508: CharacterCategory.lo,
  12509: CharacterCategory.lo,
  12510: CharacterCategory.lo,
  12511: CharacterCategory.lo,
  12512: CharacterCategory.lo,
  12513: CharacterCategory.lo,
  12514: CharacterCategory.lo,
  12515: CharacterCategory.lo,
  12516: CharacterCategory.lo,
  12517: CharacterCategory.lo,
  12518: CharacterCategory.lo,
  12519: CharacterCategory.lo,
  12520: CharacterCategory.lo,
  12521: CharacterCategory.lo,
  12522: CharacterCategory.lo,
  12523: CharacterCategory.lo,
  12524: CharacterCategory.lo,
  12525: CharacterCategory.lo,
  12526: CharacterCategory.lo,
  12527: CharacterCategory.lo,
  12528: CharacterCategory.lo,
  12529: CharacterCategory.lo,
  12530: CharacterCategory.lo,
  12531: CharacterCategory.lo,
  12532: CharacterCategory.lo,
  12533: CharacterCategory.lo,
  12534: CharacterCategory.lo,
  12535: CharacterCategory.lo,
  12536: CharacterCategory.lo,
  12537: CharacterCategory.lo,
  12538: CharacterCategory.lo,
  12543: CharacterCategory.lo,
  12549: CharacterCategory.lo,
  12550: CharacterCategory.lo,
  12551: CharacterCategory.lo,
  12552: CharacterCategory.lo,
  12553: CharacterCategory.lo,
  12554: CharacterCategory.lo,
  12555: CharacterCategory.lo,
  12556: CharacterCategory.lo,
  12557: CharacterCategory.lo,
  12558: CharacterCategory.lo,
  12559: CharacterCategory.lo,
  12560: CharacterCategory.lo,
  12561: CharacterCategory.lo,
  12562: CharacterCategory.lo,
  12563: CharacterCategory.lo,
  12564: CharacterCategory.lo,
  12565: CharacterCategory.lo,
  12566: CharacterCategory.lo,
  12567: CharacterCategory.lo,
  12568: CharacterCategory.lo,
  12569: CharacterCategory.lo,
  12570: CharacterCategory.lo,
  12571: CharacterCategory.lo,
  12572: CharacterCategory.lo,
  12573: CharacterCategory.lo,
  12574: CharacterCategory.lo,
  12575: CharacterCategory.lo,
  12576: CharacterCategory.lo,
  12577: CharacterCategory.lo,
  12578: CharacterCategory.lo,
  12579: CharacterCategory.lo,
  12580: CharacterCategory.lo,
  12581: CharacterCategory.lo,
  12582: CharacterCategory.lo,
  12583: CharacterCategory.lo,
  12584: CharacterCategory.lo,
  12585: CharacterCategory.lo,
  12586: CharacterCategory.lo,
  12587: CharacterCategory.lo,
  12588: CharacterCategory.lo,
  12589: CharacterCategory.lo,
  12593: CharacterCategory.lo,
  12594: CharacterCategory.lo,
  12595: CharacterCategory.lo,
  12596: CharacterCategory.lo,
  12597: CharacterCategory.lo,
  12598: CharacterCategory.lo,
  12599: CharacterCategory.lo,
  12600: CharacterCategory.lo,
  12601: CharacterCategory.lo,
  12602: CharacterCategory.lo,
  12603: CharacterCategory.lo,
  12604: CharacterCategory.lo,
  12605: CharacterCategory.lo,
  12606: CharacterCategory.lo,
  12607: CharacterCategory.lo,
  12608: CharacterCategory.lo,
  12609: CharacterCategory.lo,
  12610: CharacterCategory.lo,
  12611: CharacterCategory.lo,
  12612: CharacterCategory.lo,
  12613: CharacterCategory.lo,
  12614: CharacterCategory.lo,
  12615: CharacterCategory.lo,
  12616: CharacterCategory.lo,
  12617: CharacterCategory.lo,
  12618: CharacterCategory.lo,
  12619: CharacterCategory.lo,
  12620: CharacterCategory.lo,
  12621: CharacterCategory.lo,
  12622: CharacterCategory.lo,
  12623: CharacterCategory.lo,
  12624: CharacterCategory.lo,
  12625: CharacterCategory.lo,
  12626: CharacterCategory.lo,
  12627: CharacterCategory.lo,
  12628: CharacterCategory.lo,
  12629: CharacterCategory.lo,
  12630: CharacterCategory.lo,
  12631: CharacterCategory.lo,
  12632: CharacterCategory.lo,
  12633: CharacterCategory.lo,
  12634: CharacterCategory.lo,
  12635: CharacterCategory.lo,
  12636: CharacterCategory.lo,
  12637: CharacterCategory.lo,
  12638: CharacterCategory.lo,
  12639: CharacterCategory.lo,
  12640: CharacterCategory.lo,
  12641: CharacterCategory.lo,
  12642: CharacterCategory.lo,
  12643: CharacterCategory.lo,
  12644: CharacterCategory.lo,
  12645: CharacterCategory.lo,
  12646: CharacterCategory.lo,
  12647: CharacterCategory.lo,
  12648: CharacterCategory.lo,
  12649: CharacterCategory.lo,
  12650: CharacterCategory.lo,
  12651: CharacterCategory.lo,
  12652: CharacterCategory.lo,
  12653: CharacterCategory.lo,
  12654: CharacterCategory.lo,
  12655: CharacterCategory.lo,
  12656: CharacterCategory.lo,
  12657: CharacterCategory.lo,
  12658: CharacterCategory.lo,
  12659: CharacterCategory.lo,
  12660: CharacterCategory.lo,
  12661: CharacterCategory.lo,
  12662: CharacterCategory.lo,
  12663: CharacterCategory.lo,
  12664: CharacterCategory.lo,
  12665: CharacterCategory.lo,
  12666: CharacterCategory.lo,
  12667: CharacterCategory.lo,
  12668: CharacterCategory.lo,
  12669: CharacterCategory.lo,
  12670: CharacterCategory.lo,
  12671: CharacterCategory.lo,
  12672: CharacterCategory.lo,
  12673: CharacterCategory.lo,
  12674: CharacterCategory.lo,
  12675: CharacterCategory.lo,
  12676: CharacterCategory.lo,
  12677: CharacterCategory.lo,
  12678: CharacterCategory.lo,
  12679: CharacterCategory.lo,
  12680: CharacterCategory.lo,
  12681: CharacterCategory.lo,
  12682: CharacterCategory.lo,
  12683: CharacterCategory.lo,
  12684: CharacterCategory.lo,
  12685: CharacterCategory.lo,
  12686: CharacterCategory.lo,
  12704: CharacterCategory.lo,
  12705: CharacterCategory.lo,
  12706: CharacterCategory.lo,
  12707: CharacterCategory.lo,
  12708: CharacterCategory.lo,
  12709: CharacterCategory.lo,
  12710: CharacterCategory.lo,
  12711: CharacterCategory.lo,
  12712: CharacterCategory.lo,
  12713: CharacterCategory.lo,
  12714: CharacterCategory.lo,
  12715: CharacterCategory.lo,
  12716: CharacterCategory.lo,
  12717: CharacterCategory.lo,
  12718: CharacterCategory.lo,
  12719: CharacterCategory.lo,
  12720: CharacterCategory.lo,
  12721: CharacterCategory.lo,
  12722: CharacterCategory.lo,
  12723: CharacterCategory.lo,
  12724: CharacterCategory.lo,
  12725: CharacterCategory.lo,
  12726: CharacterCategory.lo,
  12727: CharacterCategory.lo,
  12728: CharacterCategory.lo,
  12729: CharacterCategory.lo,
  12730: CharacterCategory.lo,
  12784: CharacterCategory.lo,
  12785: CharacterCategory.lo,
  12786: CharacterCategory.lo,
  12787: CharacterCategory.lo,
  12788: CharacterCategory.lo,
  12789: CharacterCategory.lo,
  12790: CharacterCategory.lo,
  12791: CharacterCategory.lo,
  12792: CharacterCategory.lo,
  12793: CharacterCategory.lo,
  12794: CharacterCategory.lo,
  12795: CharacterCategory.lo,
  12796: CharacterCategory.lo,
  12797: CharacterCategory.lo,
  12798: CharacterCategory.lo,
  12799: CharacterCategory.lo,
  13312: CharacterCategory.lo,
  19893: CharacterCategory.lo,
  19968: CharacterCategory.lo,
  40908: CharacterCategory.lo,
  40960: CharacterCategory.lo,
  40961: CharacterCategory.lo,
  40962: CharacterCategory.lo,
  40963: CharacterCategory.lo,
  40964: CharacterCategory.lo,
  40965: CharacterCategory.lo,
  40966: CharacterCategory.lo,
  40967: CharacterCategory.lo,
  40968: CharacterCategory.lo,
  40969: CharacterCategory.lo,
  40970: CharacterCategory.lo,
  40971: CharacterCategory.lo,
  40972: CharacterCategory.lo,
  40973: CharacterCategory.lo,
  40974: CharacterCategory.lo,
  40975: CharacterCategory.lo,
  40976: CharacterCategory.lo,
  40977: CharacterCategory.lo,
  40978: CharacterCategory.lo,
  40979: CharacterCategory.lo,
  40980: CharacterCategory.lo,
  40982: CharacterCategory.lo,
  40983: CharacterCategory.lo,
  40984: CharacterCategory.lo,
  40985: CharacterCategory.lo,
  40986: CharacterCategory.lo,
  40987: CharacterCategory.lo,
  40988: CharacterCategory.lo,
  40989: CharacterCategory.lo,
  40990: CharacterCategory.lo,
  40991: CharacterCategory.lo,
  40992: CharacterCategory.lo,
  40993: CharacterCategory.lo,
  40994: CharacterCategory.lo,
  40995: CharacterCategory.lo,
  40996: CharacterCategory.lo,
  40997: CharacterCategory.lo,
  40998: CharacterCategory.lo,
  40999: CharacterCategory.lo,
  41000: CharacterCategory.lo,
  41001: CharacterCategory.lo,
  41002: CharacterCategory.lo,
  41003: CharacterCategory.lo,
  41004: CharacterCategory.lo,
  41005: CharacterCategory.lo,
  41006: CharacterCategory.lo,
  41007: CharacterCategory.lo,
  41008: CharacterCategory.lo,
  41009: CharacterCategory.lo,
  41010: CharacterCategory.lo,
  41011: CharacterCategory.lo,
  41012: CharacterCategory.lo,
  41013: CharacterCategory.lo,
  41014: CharacterCategory.lo,
  41015: CharacterCategory.lo,
  41016: CharacterCategory.lo,
  41017: CharacterCategory.lo,
  41018: CharacterCategory.lo,
  41019: CharacterCategory.lo,
  41020: CharacterCategory.lo,
  41021: CharacterCategory.lo,
  41022: CharacterCategory.lo,
  41023: CharacterCategory.lo,
  41024: CharacterCategory.lo,
  41025: CharacterCategory.lo,
  41026: CharacterCategory.lo,
  41027: CharacterCategory.lo,
  41028: CharacterCategory.lo,
  41029: CharacterCategory.lo,
  41030: CharacterCategory.lo,
  41031: CharacterCategory.lo,
  41032: CharacterCategory.lo,
  41033: CharacterCategory.lo,
  41034: CharacterCategory.lo,
  41035: CharacterCategory.lo,
  41036: CharacterCategory.lo,
  41037: CharacterCategory.lo,
  41038: CharacterCategory.lo,
  41039: CharacterCategory.lo,
  41040: CharacterCategory.lo,
  41041: CharacterCategory.lo,
  41042: CharacterCategory.lo,
  41043: CharacterCategory.lo,
  41044: CharacterCategory.lo,
  41045: CharacterCategory.lo,
  41046: CharacterCategory.lo,
  41047: CharacterCategory.lo,
  41048: CharacterCategory.lo,
  41049: CharacterCategory.lo,
  41050: CharacterCategory.lo,
  41051: CharacterCategory.lo,
  41052: CharacterCategory.lo,
  41053: CharacterCategory.lo,
  41054: CharacterCategory.lo,
  41055: CharacterCategory.lo,
  41056: CharacterCategory.lo,
  41057: CharacterCategory.lo,
  41058: CharacterCategory.lo,
  41059: CharacterCategory.lo,
  41060: CharacterCategory.lo,
  41061: CharacterCategory.lo,
  41062: CharacterCategory.lo,
  41063: CharacterCategory.lo,
  41064: CharacterCategory.lo,
  41065: CharacterCategory.lo,
  41066: CharacterCategory.lo,
  41067: CharacterCategory.lo,
  41068: CharacterCategory.lo,
  41069: CharacterCategory.lo,
  41070: CharacterCategory.lo,
  41071: CharacterCategory.lo,
  41072: CharacterCategory.lo,
  41073: CharacterCategory.lo,
  41074: CharacterCategory.lo,
  41075: CharacterCategory.lo,
  41076: CharacterCategory.lo,
  41077: CharacterCategory.lo,
  41078: CharacterCategory.lo,
  41079: CharacterCategory.lo,
  41080: CharacterCategory.lo,
  41081: CharacterCategory.lo,
  41082: CharacterCategory.lo,
  41083: CharacterCategory.lo,
  41084: CharacterCategory.lo,
  41085: CharacterCategory.lo,
  41086: CharacterCategory.lo,
  41087: CharacterCategory.lo,
  41088: CharacterCategory.lo,
  41089: CharacterCategory.lo,
  41090: CharacterCategory.lo,
  41091: CharacterCategory.lo,
  41092: CharacterCategory.lo,
  41093: CharacterCategory.lo,
  41094: CharacterCategory.lo,
  41095: CharacterCategory.lo,
  41096: CharacterCategory.lo,
  41097: CharacterCategory.lo,
  41098: CharacterCategory.lo,
  41099: CharacterCategory.lo,
  41100: CharacterCategory.lo,
  41101: CharacterCategory.lo,
  41102: CharacterCategory.lo,
  41103: CharacterCategory.lo,
  41104: CharacterCategory.lo,
  41105: CharacterCategory.lo,
  41106: CharacterCategory.lo,
  41107: CharacterCategory.lo,
  41108: CharacterCategory.lo,
  41109: CharacterCategory.lo,
  41110: CharacterCategory.lo,
  41111: CharacterCategory.lo,
  41112: CharacterCategory.lo,
  41113: CharacterCategory.lo,
  41114: CharacterCategory.lo,
  41115: CharacterCategory.lo,
  41116: CharacterCategory.lo,
  41117: CharacterCategory.lo,
  41118: CharacterCategory.lo,
  41119: CharacterCategory.lo,
  41120: CharacterCategory.lo,
  41121: CharacterCategory.lo,
  41122: CharacterCategory.lo,
  41123: CharacterCategory.lo,
  41124: CharacterCategory.lo,
  41125: CharacterCategory.lo,
  41126: CharacterCategory.lo,
  41127: CharacterCategory.lo,
  41128: CharacterCategory.lo,
  41129: CharacterCategory.lo,
  41130: CharacterCategory.lo,
  41131: CharacterCategory.lo,
  41132: CharacterCategory.lo,
  41133: CharacterCategory.lo,
  41134: CharacterCategory.lo,
  41135: CharacterCategory.lo,
  41136: CharacterCategory.lo,
  41137: CharacterCategory.lo,
  41138: CharacterCategory.lo,
  41139: CharacterCategory.lo,
  41140: CharacterCategory.lo,
  41141: CharacterCategory.lo,
  41142: CharacterCategory.lo,
  41143: CharacterCategory.lo,
  41144: CharacterCategory.lo,
  41145: CharacterCategory.lo,
  41146: CharacterCategory.lo,
  41147: CharacterCategory.lo,
  41148: CharacterCategory.lo,
  41149: CharacterCategory.lo,
  41150: CharacterCategory.lo,
  41151: CharacterCategory.lo,
  41152: CharacterCategory.lo,
  41153: CharacterCategory.lo,
  41154: CharacterCategory.lo,
  41155: CharacterCategory.lo,
  41156: CharacterCategory.lo,
  41157: CharacterCategory.lo,
  41158: CharacterCategory.lo,
  41159: CharacterCategory.lo,
  41160: CharacterCategory.lo,
  41161: CharacterCategory.lo,
  41162: CharacterCategory.lo,
  41163: CharacterCategory.lo,
  41164: CharacterCategory.lo,
  41165: CharacterCategory.lo,
  41166: CharacterCategory.lo,
  41167: CharacterCategory.lo,
  41168: CharacterCategory.lo,
  41169: CharacterCategory.lo,
  41170: CharacterCategory.lo,
  41171: CharacterCategory.lo,
  41172: CharacterCategory.lo,
  41173: CharacterCategory.lo,
  41174: CharacterCategory.lo,
  41175: CharacterCategory.lo,
  41176: CharacterCategory.lo,
  41177: CharacterCategory.lo,
  41178: CharacterCategory.lo,
  41179: CharacterCategory.lo,
  41180: CharacterCategory.lo,
  41181: CharacterCategory.lo,
  41182: CharacterCategory.lo,
  41183: CharacterCategory.lo,
  41184: CharacterCategory.lo,
  41185: CharacterCategory.lo,
  41186: CharacterCategory.lo,
  41187: CharacterCategory.lo,
  41188: CharacterCategory.lo,
  41189: CharacterCategory.lo,
  41190: CharacterCategory.lo,
  41191: CharacterCategory.lo,
  41192: CharacterCategory.lo,
  41193: CharacterCategory.lo,
  41194: CharacterCategory.lo,
  41195: CharacterCategory.lo,
  41196: CharacterCategory.lo,
  41197: CharacterCategory.lo,
  41198: CharacterCategory.lo,
  41199: CharacterCategory.lo,
  41200: CharacterCategory.lo,
  41201: CharacterCategory.lo,
  41202: CharacterCategory.lo,
  41203: CharacterCategory.lo,
  41204: CharacterCategory.lo,
  41205: CharacterCategory.lo,
  41206: CharacterCategory.lo,
  41207: CharacterCategory.lo,
  41208: CharacterCategory.lo,
  41209: CharacterCategory.lo,
  41210: CharacterCategory.lo,
  41211: CharacterCategory.lo,
  41212: CharacterCategory.lo,
  41213: CharacterCategory.lo,
  41214: CharacterCategory.lo,
  41215: CharacterCategory.lo,
  41216: CharacterCategory.lo,
  41217: CharacterCategory.lo,
  41218: CharacterCategory.lo,
  41219: CharacterCategory.lo,
  41220: CharacterCategory.lo,
  41221: CharacterCategory.lo,
  41222: CharacterCategory.lo,
  41223: CharacterCategory.lo,
  41224: CharacterCategory.lo,
  41225: CharacterCategory.lo,
  41226: CharacterCategory.lo,
  41227: CharacterCategory.lo,
  41228: CharacterCategory.lo,
  41229: CharacterCategory.lo,
  41230: CharacterCategory.lo,
  41231: CharacterCategory.lo,
  41232: CharacterCategory.lo,
  41233: CharacterCategory.lo,
  41234: CharacterCategory.lo,
  41235: CharacterCategory.lo,
  41236: CharacterCategory.lo,
  41237: CharacterCategory.lo,
  41238: CharacterCategory.lo,
  41239: CharacterCategory.lo,
  41240: CharacterCategory.lo,
  41241: CharacterCategory.lo,
  41242: CharacterCategory.lo,
  41243: CharacterCategory.lo,
  41244: CharacterCategory.lo,
  41245: CharacterCategory.lo,
  41246: CharacterCategory.lo,
  41247: CharacterCategory.lo,
  41248: CharacterCategory.lo,
  41249: CharacterCategory.lo,
  41250: CharacterCategory.lo,
  41251: CharacterCategory.lo,
  41252: CharacterCategory.lo,
  41253: CharacterCategory.lo,
  41254: CharacterCategory.lo,
  41255: CharacterCategory.lo,
  41256: CharacterCategory.lo,
  41257: CharacterCategory.lo,
  41258: CharacterCategory.lo,
  41259: CharacterCategory.lo,
  41260: CharacterCategory.lo,
  41261: CharacterCategory.lo,
  41262: CharacterCategory.lo,
  41263: CharacterCategory.lo,
  41264: CharacterCategory.lo,
  41265: CharacterCategory.lo,
  41266: CharacterCategory.lo,
  41267: CharacterCategory.lo,
  41268: CharacterCategory.lo,
  41269: CharacterCategory.lo,
  41270: CharacterCategory.lo,
  41271: CharacterCategory.lo,
  41272: CharacterCategory.lo,
  41273: CharacterCategory.lo,
  41274: CharacterCategory.lo,
  41275: CharacterCategory.lo,
  41276: CharacterCategory.lo,
  41277: CharacterCategory.lo,
  41278: CharacterCategory.lo,
  41279: CharacterCategory.lo,
  41280: CharacterCategory.lo,
  41281: CharacterCategory.lo,
  41282: CharacterCategory.lo,
  41283: CharacterCategory.lo,
  41284: CharacterCategory.lo,
  41285: CharacterCategory.lo,
  41286: CharacterCategory.lo,
  41287: CharacterCategory.lo,
  41288: CharacterCategory.lo,
  41289: CharacterCategory.lo,
  41290: CharacterCategory.lo,
  41291: CharacterCategory.lo,
  41292: CharacterCategory.lo,
  41293: CharacterCategory.lo,
  41294: CharacterCategory.lo,
  41295: CharacterCategory.lo,
  41296: CharacterCategory.lo,
  41297: CharacterCategory.lo,
  41298: CharacterCategory.lo,
  41299: CharacterCategory.lo,
  41300: CharacterCategory.lo,
  41301: CharacterCategory.lo,
  41302: CharacterCategory.lo,
  41303: CharacterCategory.lo,
  41304: CharacterCategory.lo,
  41305: CharacterCategory.lo,
  41306: CharacterCategory.lo,
  41307: CharacterCategory.lo,
  41308: CharacterCategory.lo,
  41309: CharacterCategory.lo,
  41310: CharacterCategory.lo,
  41311: CharacterCategory.lo,
  41312: CharacterCategory.lo,
  41313: CharacterCategory.lo,
  41314: CharacterCategory.lo,
  41315: CharacterCategory.lo,
  41316: CharacterCategory.lo,
  41317: CharacterCategory.lo,
  41318: CharacterCategory.lo,
  41319: CharacterCategory.lo,
  41320: CharacterCategory.lo,
  41321: CharacterCategory.lo,
  41322: CharacterCategory.lo,
  41323: CharacterCategory.lo,
  41324: CharacterCategory.lo,
  41325: CharacterCategory.lo,
  41326: CharacterCategory.lo,
  41327: CharacterCategory.lo,
  41328: CharacterCategory.lo,
  41329: CharacterCategory.lo,
  41330: CharacterCategory.lo,
  41331: CharacterCategory.lo,
  41332: CharacterCategory.lo,
  41333: CharacterCategory.lo,
  41334: CharacterCategory.lo,
  41335: CharacterCategory.lo,
  41336: CharacterCategory.lo,
  41337: CharacterCategory.lo,
  41338: CharacterCategory.lo,
  41339: CharacterCategory.lo,
  41340: CharacterCategory.lo,
  41341: CharacterCategory.lo,
  41342: CharacterCategory.lo,
  41343: CharacterCategory.lo,
  41344: CharacterCategory.lo,
  41345: CharacterCategory.lo,
  41346: CharacterCategory.lo,
  41347: CharacterCategory.lo,
  41348: CharacterCategory.lo,
  41349: CharacterCategory.lo,
  41350: CharacterCategory.lo,
  41351: CharacterCategory.lo,
  41352: CharacterCategory.lo,
  41353: CharacterCategory.lo,
  41354: CharacterCategory.lo,
  41355: CharacterCategory.lo,
  41356: CharacterCategory.lo,
  41357: CharacterCategory.lo,
  41358: CharacterCategory.lo,
  41359: CharacterCategory.lo,
  41360: CharacterCategory.lo,
  41361: CharacterCategory.lo,
  41362: CharacterCategory.lo,
  41363: CharacterCategory.lo,
  41364: CharacterCategory.lo,
  41365: CharacterCategory.lo,
  41366: CharacterCategory.lo,
  41367: CharacterCategory.lo,
  41368: CharacterCategory.lo,
  41369: CharacterCategory.lo,
  41370: CharacterCategory.lo,
  41371: CharacterCategory.lo,
  41372: CharacterCategory.lo,
  41373: CharacterCategory.lo,
  41374: CharacterCategory.lo,
  41375: CharacterCategory.lo,
  41376: CharacterCategory.lo,
  41377: CharacterCategory.lo,
  41378: CharacterCategory.lo,
  41379: CharacterCategory.lo,
  41380: CharacterCategory.lo,
  41381: CharacterCategory.lo,
  41382: CharacterCategory.lo,
  41383: CharacterCategory.lo,
  41384: CharacterCategory.lo,
  41385: CharacterCategory.lo,
  41386: CharacterCategory.lo,
  41387: CharacterCategory.lo,
  41388: CharacterCategory.lo,
  41389: CharacterCategory.lo,
  41390: CharacterCategory.lo,
  41391: CharacterCategory.lo,
  41392: CharacterCategory.lo,
  41393: CharacterCategory.lo,
  41394: CharacterCategory.lo,
  41395: CharacterCategory.lo,
  41396: CharacterCategory.lo,
  41397: CharacterCategory.lo,
  41398: CharacterCategory.lo,
  41399: CharacterCategory.lo,
  41400: CharacterCategory.lo,
  41401: CharacterCategory.lo,
  41402: CharacterCategory.lo,
  41403: CharacterCategory.lo,
  41404: CharacterCategory.lo,
  41405: CharacterCategory.lo,
  41406: CharacterCategory.lo,
  41407: CharacterCategory.lo,
  41408: CharacterCategory.lo,
  41409: CharacterCategory.lo,
  41410: CharacterCategory.lo,
  41411: CharacterCategory.lo,
  41412: CharacterCategory.lo,
  41413: CharacterCategory.lo,
  41414: CharacterCategory.lo,
  41415: CharacterCategory.lo,
  41416: CharacterCategory.lo,
  41417: CharacterCategory.lo,
  41418: CharacterCategory.lo,
  41419: CharacterCategory.lo,
  41420: CharacterCategory.lo,
  41421: CharacterCategory.lo,
  41422: CharacterCategory.lo,
  41423: CharacterCategory.lo,
  41424: CharacterCategory.lo,
  41425: CharacterCategory.lo,
  41426: CharacterCategory.lo,
  41427: CharacterCategory.lo,
  41428: CharacterCategory.lo,
  41429: CharacterCategory.lo,
  41430: CharacterCategory.lo,
  41431: CharacterCategory.lo,
  41432: CharacterCategory.lo,
  41433: CharacterCategory.lo,
  41434: CharacterCategory.lo,
  41435: CharacterCategory.lo,
  41436: CharacterCategory.lo,
  41437: CharacterCategory.lo,
  41438: CharacterCategory.lo,
  41439: CharacterCategory.lo,
  41440: CharacterCategory.lo,
  41441: CharacterCategory.lo,
  41442: CharacterCategory.lo,
  41443: CharacterCategory.lo,
  41444: CharacterCategory.lo,
  41445: CharacterCategory.lo,
  41446: CharacterCategory.lo,
  41447: CharacterCategory.lo,
  41448: CharacterCategory.lo,
  41449: CharacterCategory.lo,
  41450: CharacterCategory.lo,
  41451: CharacterCategory.lo,
  41452: CharacterCategory.lo,
  41453: CharacterCategory.lo,
  41454: CharacterCategory.lo,
  41455: CharacterCategory.lo,
  41456: CharacterCategory.lo,
  41457: CharacterCategory.lo,
  41458: CharacterCategory.lo,
  41459: CharacterCategory.lo,
  41460: CharacterCategory.lo,
  41461: CharacterCategory.lo,
  41462: CharacterCategory.lo,
  41463: CharacterCategory.lo,
  41464: CharacterCategory.lo,
  41465: CharacterCategory.lo,
  41466: CharacterCategory.lo,
  41467: CharacterCategory.lo,
  41468: CharacterCategory.lo,
  41469: CharacterCategory.lo,
  41470: CharacterCategory.lo,
  41471: CharacterCategory.lo,
  41472: CharacterCategory.lo,
  41473: CharacterCategory.lo,
  41474: CharacterCategory.lo,
  41475: CharacterCategory.lo,
  41476: CharacterCategory.lo,
  41477: CharacterCategory.lo,
  41478: CharacterCategory.lo,
  41479: CharacterCategory.lo,
  41480: CharacterCategory.lo,
  41481: CharacterCategory.lo,
  41482: CharacterCategory.lo,
  41483: CharacterCategory.lo,
  41484: CharacterCategory.lo,
  41485: CharacterCategory.lo,
  41486: CharacterCategory.lo,
  41487: CharacterCategory.lo,
  41488: CharacterCategory.lo,
  41489: CharacterCategory.lo,
  41490: CharacterCategory.lo,
  41491: CharacterCategory.lo,
  41492: CharacterCategory.lo,
  41493: CharacterCategory.lo,
  41494: CharacterCategory.lo,
  41495: CharacterCategory.lo,
  41496: CharacterCategory.lo,
  41497: CharacterCategory.lo,
  41498: CharacterCategory.lo,
  41499: CharacterCategory.lo,
  41500: CharacterCategory.lo,
  41501: CharacterCategory.lo,
  41502: CharacterCategory.lo,
  41503: CharacterCategory.lo,
  41504: CharacterCategory.lo,
  41505: CharacterCategory.lo,
  41506: CharacterCategory.lo,
  41507: CharacterCategory.lo,
  41508: CharacterCategory.lo,
  41509: CharacterCategory.lo,
  41510: CharacterCategory.lo,
  41511: CharacterCategory.lo,
  41512: CharacterCategory.lo,
  41513: CharacterCategory.lo,
  41514: CharacterCategory.lo,
  41515: CharacterCategory.lo,
  41516: CharacterCategory.lo,
  41517: CharacterCategory.lo,
  41518: CharacterCategory.lo,
  41519: CharacterCategory.lo,
  41520: CharacterCategory.lo,
  41521: CharacterCategory.lo,
  41522: CharacterCategory.lo,
  41523: CharacterCategory.lo,
  41524: CharacterCategory.lo,
  41525: CharacterCategory.lo,
  41526: CharacterCategory.lo,
  41527: CharacterCategory.lo,
  41528: CharacterCategory.lo,
  41529: CharacterCategory.lo,
  41530: CharacterCategory.lo,
  41531: CharacterCategory.lo,
  41532: CharacterCategory.lo,
  41533: CharacterCategory.lo,
  41534: CharacterCategory.lo,
  41535: CharacterCategory.lo,
  41536: CharacterCategory.lo,
  41537: CharacterCategory.lo,
  41538: CharacterCategory.lo,
  41539: CharacterCategory.lo,
  41540: CharacterCategory.lo,
  41541: CharacterCategory.lo,
  41542: CharacterCategory.lo,
  41543: CharacterCategory.lo,
  41544: CharacterCategory.lo,
  41545: CharacterCategory.lo,
  41546: CharacterCategory.lo,
  41547: CharacterCategory.lo,
  41548: CharacterCategory.lo,
  41549: CharacterCategory.lo,
  41550: CharacterCategory.lo,
  41551: CharacterCategory.lo,
  41552: CharacterCategory.lo,
  41553: CharacterCategory.lo,
  41554: CharacterCategory.lo,
  41555: CharacterCategory.lo,
  41556: CharacterCategory.lo,
  41557: CharacterCategory.lo,
  41558: CharacterCategory.lo,
  41559: CharacterCategory.lo,
  41560: CharacterCategory.lo,
  41561: CharacterCategory.lo,
  41562: CharacterCategory.lo,
  41563: CharacterCategory.lo,
  41564: CharacterCategory.lo,
  41565: CharacterCategory.lo,
  41566: CharacterCategory.lo,
  41567: CharacterCategory.lo,
  41568: CharacterCategory.lo,
  41569: CharacterCategory.lo,
  41570: CharacterCategory.lo,
  41571: CharacterCategory.lo,
  41572: CharacterCategory.lo,
  41573: CharacterCategory.lo,
  41574: CharacterCategory.lo,
  41575: CharacterCategory.lo,
  41576: CharacterCategory.lo,
  41577: CharacterCategory.lo,
  41578: CharacterCategory.lo,
  41579: CharacterCategory.lo,
  41580: CharacterCategory.lo,
  41581: CharacterCategory.lo,
  41582: CharacterCategory.lo,
  41583: CharacterCategory.lo,
  41584: CharacterCategory.lo,
  41585: CharacterCategory.lo,
  41586: CharacterCategory.lo,
  41587: CharacterCategory.lo,
  41588: CharacterCategory.lo,
  41589: CharacterCategory.lo,
  41590: CharacterCategory.lo,
  41591: CharacterCategory.lo,
  41592: CharacterCategory.lo,
  41593: CharacterCategory.lo,
  41594: CharacterCategory.lo,
  41595: CharacterCategory.lo,
  41596: CharacterCategory.lo,
  41597: CharacterCategory.lo,
  41598: CharacterCategory.lo,
  41599: CharacterCategory.lo,
  41600: CharacterCategory.lo,
  41601: CharacterCategory.lo,
  41602: CharacterCategory.lo,
  41603: CharacterCategory.lo,
  41604: CharacterCategory.lo,
  41605: CharacterCategory.lo,
  41606: CharacterCategory.lo,
  41607: CharacterCategory.lo,
  41608: CharacterCategory.lo,
  41609: CharacterCategory.lo,
  41610: CharacterCategory.lo,
  41611: CharacterCategory.lo,
  41612: CharacterCategory.lo,
  41613: CharacterCategory.lo,
  41614: CharacterCategory.lo,
  41615: CharacterCategory.lo,
  41616: CharacterCategory.lo,
  41617: CharacterCategory.lo,
  41618: CharacterCategory.lo,
  41619: CharacterCategory.lo,
  41620: CharacterCategory.lo,
  41621: CharacterCategory.lo,
  41622: CharacterCategory.lo,
  41623: CharacterCategory.lo,
  41624: CharacterCategory.lo,
  41625: CharacterCategory.lo,
  41626: CharacterCategory.lo,
  41627: CharacterCategory.lo,
  41628: CharacterCategory.lo,
  41629: CharacterCategory.lo,
  41630: CharacterCategory.lo,
  41631: CharacterCategory.lo,
  41632: CharacterCategory.lo,
  41633: CharacterCategory.lo,
  41634: CharacterCategory.lo,
  41635: CharacterCategory.lo,
  41636: CharacterCategory.lo,
  41637: CharacterCategory.lo,
  41638: CharacterCategory.lo,
  41639: CharacterCategory.lo,
  41640: CharacterCategory.lo,
  41641: CharacterCategory.lo,
  41642: CharacterCategory.lo,
  41643: CharacterCategory.lo,
  41644: CharacterCategory.lo,
  41645: CharacterCategory.lo,
  41646: CharacterCategory.lo,
  41647: CharacterCategory.lo,
  41648: CharacterCategory.lo,
  41649: CharacterCategory.lo,
  41650: CharacterCategory.lo,
  41651: CharacterCategory.lo,
  41652: CharacterCategory.lo,
  41653: CharacterCategory.lo,
  41654: CharacterCategory.lo,
  41655: CharacterCategory.lo,
  41656: CharacterCategory.lo,
  41657: CharacterCategory.lo,
  41658: CharacterCategory.lo,
  41659: CharacterCategory.lo,
  41660: CharacterCategory.lo,
  41661: CharacterCategory.lo,
  41662: CharacterCategory.lo,
  41663: CharacterCategory.lo,
  41664: CharacterCategory.lo,
  41665: CharacterCategory.lo,
  41666: CharacterCategory.lo,
  41667: CharacterCategory.lo,
  41668: CharacterCategory.lo,
  41669: CharacterCategory.lo,
  41670: CharacterCategory.lo,
  41671: CharacterCategory.lo,
  41672: CharacterCategory.lo,
  41673: CharacterCategory.lo,
  41674: CharacterCategory.lo,
  41675: CharacterCategory.lo,
  41676: CharacterCategory.lo,
  41677: CharacterCategory.lo,
  41678: CharacterCategory.lo,
  41679: CharacterCategory.lo,
  41680: CharacterCategory.lo,
  41681: CharacterCategory.lo,
  41682: CharacterCategory.lo,
  41683: CharacterCategory.lo,
  41684: CharacterCategory.lo,
  41685: CharacterCategory.lo,
  41686: CharacterCategory.lo,
  41687: CharacterCategory.lo,
  41688: CharacterCategory.lo,
  41689: CharacterCategory.lo,
  41690: CharacterCategory.lo,
  41691: CharacterCategory.lo,
  41692: CharacterCategory.lo,
  41693: CharacterCategory.lo,
  41694: CharacterCategory.lo,
  41695: CharacterCategory.lo,
  41696: CharacterCategory.lo,
  41697: CharacterCategory.lo,
  41698: CharacterCategory.lo,
  41699: CharacterCategory.lo,
  41700: CharacterCategory.lo,
  41701: CharacterCategory.lo,
  41702: CharacterCategory.lo,
  41703: CharacterCategory.lo,
  41704: CharacterCategory.lo,
  41705: CharacterCategory.lo,
  41706: CharacterCategory.lo,
  41707: CharacterCategory.lo,
  41708: CharacterCategory.lo,
  41709: CharacterCategory.lo,
  41710: CharacterCategory.lo,
  41711: CharacterCategory.lo,
  41712: CharacterCategory.lo,
  41713: CharacterCategory.lo,
  41714: CharacterCategory.lo,
  41715: CharacterCategory.lo,
  41716: CharacterCategory.lo,
  41717: CharacterCategory.lo,
  41718: CharacterCategory.lo,
  41719: CharacterCategory.lo,
  41720: CharacterCategory.lo,
  41721: CharacterCategory.lo,
  41722: CharacterCategory.lo,
  41723: CharacterCategory.lo,
  41724: CharacterCategory.lo,
  41725: CharacterCategory.lo,
  41726: CharacterCategory.lo,
  41727: CharacterCategory.lo,
  41728: CharacterCategory.lo,
  41729: CharacterCategory.lo,
  41730: CharacterCategory.lo,
  41731: CharacterCategory.lo,
  41732: CharacterCategory.lo,
  41733: CharacterCategory.lo,
  41734: CharacterCategory.lo,
  41735: CharacterCategory.lo,
  41736: CharacterCategory.lo,
  41737: CharacterCategory.lo,
  41738: CharacterCategory.lo,
  41739: CharacterCategory.lo,
  41740: CharacterCategory.lo,
  41741: CharacterCategory.lo,
  41742: CharacterCategory.lo,
  41743: CharacterCategory.lo,
  41744: CharacterCategory.lo,
  41745: CharacterCategory.lo,
  41746: CharacterCategory.lo,
  41747: CharacterCategory.lo,
  41748: CharacterCategory.lo,
  41749: CharacterCategory.lo,
  41750: CharacterCategory.lo,
  41751: CharacterCategory.lo,
  41752: CharacterCategory.lo,
  41753: CharacterCategory.lo,
  41754: CharacterCategory.lo,
  41755: CharacterCategory.lo,
  41756: CharacterCategory.lo,
  41757: CharacterCategory.lo,
  41758: CharacterCategory.lo,
  41759: CharacterCategory.lo,
  41760: CharacterCategory.lo,
  41761: CharacterCategory.lo,
  41762: CharacterCategory.lo,
  41763: CharacterCategory.lo,
  41764: CharacterCategory.lo,
  41765: CharacterCategory.lo,
  41766: CharacterCategory.lo,
  41767: CharacterCategory.lo,
  41768: CharacterCategory.lo,
  41769: CharacterCategory.lo,
  41770: CharacterCategory.lo,
  41771: CharacterCategory.lo,
  41772: CharacterCategory.lo,
  41773: CharacterCategory.lo,
  41774: CharacterCategory.lo,
  41775: CharacterCategory.lo,
  41776: CharacterCategory.lo,
  41777: CharacterCategory.lo,
  41778: CharacterCategory.lo,
  41779: CharacterCategory.lo,
  41780: CharacterCategory.lo,
  41781: CharacterCategory.lo,
  41782: CharacterCategory.lo,
  41783: CharacterCategory.lo,
  41784: CharacterCategory.lo,
  41785: CharacterCategory.lo,
  41786: CharacterCategory.lo,
  41787: CharacterCategory.lo,
  41788: CharacterCategory.lo,
  41789: CharacterCategory.lo,
  41790: CharacterCategory.lo,
  41791: CharacterCategory.lo,
  41792: CharacterCategory.lo,
  41793: CharacterCategory.lo,
  41794: CharacterCategory.lo,
  41795: CharacterCategory.lo,
  41796: CharacterCategory.lo,
  41797: CharacterCategory.lo,
  41798: CharacterCategory.lo,
  41799: CharacterCategory.lo,
  41800: CharacterCategory.lo,
  41801: CharacterCategory.lo,
  41802: CharacterCategory.lo,
  41803: CharacterCategory.lo,
  41804: CharacterCategory.lo,
  41805: CharacterCategory.lo,
  41806: CharacterCategory.lo,
  41807: CharacterCategory.lo,
  41808: CharacterCategory.lo,
  41809: CharacterCategory.lo,
  41810: CharacterCategory.lo,
  41811: CharacterCategory.lo,
  41812: CharacterCategory.lo,
  41813: CharacterCategory.lo,
  41814: CharacterCategory.lo,
  41815: CharacterCategory.lo,
  41816: CharacterCategory.lo,
  41817: CharacterCategory.lo,
  41818: CharacterCategory.lo,
  41819: CharacterCategory.lo,
  41820: CharacterCategory.lo,
  41821: CharacterCategory.lo,
  41822: CharacterCategory.lo,
  41823: CharacterCategory.lo,
  41824: CharacterCategory.lo,
  41825: CharacterCategory.lo,
  41826: CharacterCategory.lo,
  41827: CharacterCategory.lo,
  41828: CharacterCategory.lo,
  41829: CharacterCategory.lo,
  41830: CharacterCategory.lo,
  41831: CharacterCategory.lo,
  41832: CharacterCategory.lo,
  41833: CharacterCategory.lo,
  41834: CharacterCategory.lo,
  41835: CharacterCategory.lo,
  41836: CharacterCategory.lo,
  41837: CharacterCategory.lo,
  41838: CharacterCategory.lo,
  41839: CharacterCategory.lo,
  41840: CharacterCategory.lo,
  41841: CharacterCategory.lo,
  41842: CharacterCategory.lo,
  41843: CharacterCategory.lo,
  41844: CharacterCategory.lo,
  41845: CharacterCategory.lo,
  41846: CharacterCategory.lo,
  41847: CharacterCategory.lo,
  41848: CharacterCategory.lo,
  41849: CharacterCategory.lo,
  41850: CharacterCategory.lo,
  41851: CharacterCategory.lo,
  41852: CharacterCategory.lo,
  41853: CharacterCategory.lo,
  41854: CharacterCategory.lo,
  41855: CharacterCategory.lo,
  41856: CharacterCategory.lo,
  41857: CharacterCategory.lo,
  41858: CharacterCategory.lo,
  41859: CharacterCategory.lo,
  41860: CharacterCategory.lo,
  41861: CharacterCategory.lo,
  41862: CharacterCategory.lo,
  41863: CharacterCategory.lo,
  41864: CharacterCategory.lo,
  41865: CharacterCategory.lo,
  41866: CharacterCategory.lo,
  41867: CharacterCategory.lo,
  41868: CharacterCategory.lo,
  41869: CharacterCategory.lo,
  41870: CharacterCategory.lo,
  41871: CharacterCategory.lo,
  41872: CharacterCategory.lo,
  41873: CharacterCategory.lo,
  41874: CharacterCategory.lo,
  41875: CharacterCategory.lo,
  41876: CharacterCategory.lo,
  41877: CharacterCategory.lo,
  41878: CharacterCategory.lo,
  41879: CharacterCategory.lo,
  41880: CharacterCategory.lo,
  41881: CharacterCategory.lo,
  41882: CharacterCategory.lo,
  41883: CharacterCategory.lo,
  41884: CharacterCategory.lo,
  41885: CharacterCategory.lo,
  41886: CharacterCategory.lo,
  41887: CharacterCategory.lo,
  41888: CharacterCategory.lo,
  41889: CharacterCategory.lo,
  41890: CharacterCategory.lo,
  41891: CharacterCategory.lo,
  41892: CharacterCategory.lo,
  41893: CharacterCategory.lo,
  41894: CharacterCategory.lo,
  41895: CharacterCategory.lo,
  41896: CharacterCategory.lo,
  41897: CharacterCategory.lo,
  41898: CharacterCategory.lo,
  41899: CharacterCategory.lo,
  41900: CharacterCategory.lo,
  41901: CharacterCategory.lo,
  41902: CharacterCategory.lo,
  41903: CharacterCategory.lo,
  41904: CharacterCategory.lo,
  41905: CharacterCategory.lo,
  41906: CharacterCategory.lo,
  41907: CharacterCategory.lo,
  41908: CharacterCategory.lo,
  41909: CharacterCategory.lo,
  41910: CharacterCategory.lo,
  41911: CharacterCategory.lo,
  41912: CharacterCategory.lo,
  41913: CharacterCategory.lo,
  41914: CharacterCategory.lo,
  41915: CharacterCategory.lo,
  41916: CharacterCategory.lo,
  41917: CharacterCategory.lo,
  41918: CharacterCategory.lo,
  41919: CharacterCategory.lo,
  41920: CharacterCategory.lo,
  41921: CharacterCategory.lo,
  41922: CharacterCategory.lo,
  41923: CharacterCategory.lo,
  41924: CharacterCategory.lo,
  41925: CharacterCategory.lo,
  41926: CharacterCategory.lo,
  41927: CharacterCategory.lo,
  41928: CharacterCategory.lo,
  41929: CharacterCategory.lo,
  41930: CharacterCategory.lo,
  41931: CharacterCategory.lo,
  41932: CharacterCategory.lo,
  41933: CharacterCategory.lo,
  41934: CharacterCategory.lo,
  41935: CharacterCategory.lo,
  41936: CharacterCategory.lo,
  41937: CharacterCategory.lo,
  41938: CharacterCategory.lo,
  41939: CharacterCategory.lo,
  41940: CharacterCategory.lo,
  41941: CharacterCategory.lo,
  41942: CharacterCategory.lo,
  41943: CharacterCategory.lo,
  41944: CharacterCategory.lo,
  41945: CharacterCategory.lo,
  41946: CharacterCategory.lo,
  41947: CharacterCategory.lo,
  41948: CharacterCategory.lo,
  41949: CharacterCategory.lo,
  41950: CharacterCategory.lo,
  41951: CharacterCategory.lo,
  41952: CharacterCategory.lo,
  41953: CharacterCategory.lo,
  41954: CharacterCategory.lo,
  41955: CharacterCategory.lo,
  41956: CharacterCategory.lo,
  41957: CharacterCategory.lo,
  41958: CharacterCategory.lo,
  41959: CharacterCategory.lo,
  41960: CharacterCategory.lo,
  41961: CharacterCategory.lo,
  41962: CharacterCategory.lo,
  41963: CharacterCategory.lo,
  41964: CharacterCategory.lo,
  41965: CharacterCategory.lo,
  41966: CharacterCategory.lo,
  41967: CharacterCategory.lo,
  41968: CharacterCategory.lo,
  41969: CharacterCategory.lo,
  41970: CharacterCategory.lo,
  41971: CharacterCategory.lo,
  41972: CharacterCategory.lo,
  41973: CharacterCategory.lo,
  41974: CharacterCategory.lo,
  41975: CharacterCategory.lo,
  41976: CharacterCategory.lo,
  41977: CharacterCategory.lo,
  41978: CharacterCategory.lo,
  41979: CharacterCategory.lo,
  41980: CharacterCategory.lo,
  41981: CharacterCategory.lo,
  41982: CharacterCategory.lo,
  41983: CharacterCategory.lo,
  41984: CharacterCategory.lo,
  41985: CharacterCategory.lo,
  41986: CharacterCategory.lo,
  41987: CharacterCategory.lo,
  41988: CharacterCategory.lo,
  41989: CharacterCategory.lo,
  41990: CharacterCategory.lo,
  41991: CharacterCategory.lo,
  41992: CharacterCategory.lo,
  41993: CharacterCategory.lo,
  41994: CharacterCategory.lo,
  41995: CharacterCategory.lo,
  41996: CharacterCategory.lo,
  41997: CharacterCategory.lo,
  41998: CharacterCategory.lo,
  41999: CharacterCategory.lo,
  42000: CharacterCategory.lo,
  42001: CharacterCategory.lo,
  42002: CharacterCategory.lo,
  42003: CharacterCategory.lo,
  42004: CharacterCategory.lo,
  42005: CharacterCategory.lo,
  42006: CharacterCategory.lo,
  42007: CharacterCategory.lo,
  42008: CharacterCategory.lo,
  42009: CharacterCategory.lo,
  42010: CharacterCategory.lo,
  42011: CharacterCategory.lo,
  42012: CharacterCategory.lo,
  42013: CharacterCategory.lo,
  42014: CharacterCategory.lo,
  42015: CharacterCategory.lo,
  42016: CharacterCategory.lo,
  42017: CharacterCategory.lo,
  42018: CharacterCategory.lo,
  42019: CharacterCategory.lo,
  42020: CharacterCategory.lo,
  42021: CharacterCategory.lo,
  42022: CharacterCategory.lo,
  42023: CharacterCategory.lo,
  42024: CharacterCategory.lo,
  42025: CharacterCategory.lo,
  42026: CharacterCategory.lo,
  42027: CharacterCategory.lo,
  42028: CharacterCategory.lo,
  42029: CharacterCategory.lo,
  42030: CharacterCategory.lo,
  42031: CharacterCategory.lo,
  42032: CharacterCategory.lo,
  42033: CharacterCategory.lo,
  42034: CharacterCategory.lo,
  42035: CharacterCategory.lo,
  42036: CharacterCategory.lo,
  42037: CharacterCategory.lo,
  42038: CharacterCategory.lo,
  42039: CharacterCategory.lo,
  42040: CharacterCategory.lo,
  42041: CharacterCategory.lo,
  42042: CharacterCategory.lo,
  42043: CharacterCategory.lo,
  42044: CharacterCategory.lo,
  42045: CharacterCategory.lo,
  42046: CharacterCategory.lo,
  42047: CharacterCategory.lo,
  42048: CharacterCategory.lo,
  42049: CharacterCategory.lo,
  42050: CharacterCategory.lo,
  42051: CharacterCategory.lo,
  42052: CharacterCategory.lo,
  42053: CharacterCategory.lo,
  42054: CharacterCategory.lo,
  42055: CharacterCategory.lo,
  42056: CharacterCategory.lo,
  42057: CharacterCategory.lo,
  42058: CharacterCategory.lo,
  42059: CharacterCategory.lo,
  42060: CharacterCategory.lo,
  42061: CharacterCategory.lo,
  42062: CharacterCategory.lo,
  42063: CharacterCategory.lo,
  42064: CharacterCategory.lo,
  42065: CharacterCategory.lo,
  42066: CharacterCategory.lo,
  42067: CharacterCategory.lo,
  42068: CharacterCategory.lo,
  42069: CharacterCategory.lo,
  42070: CharacterCategory.lo,
  42071: CharacterCategory.lo,
  42072: CharacterCategory.lo,
  42073: CharacterCategory.lo,
  42074: CharacterCategory.lo,
  42075: CharacterCategory.lo,
  42076: CharacterCategory.lo,
  42077: CharacterCategory.lo,
  42078: CharacterCategory.lo,
  42079: CharacterCategory.lo,
  42080: CharacterCategory.lo,
  42081: CharacterCategory.lo,
  42082: CharacterCategory.lo,
  42083: CharacterCategory.lo,
  42084: CharacterCategory.lo,
  42085: CharacterCategory.lo,
  42086: CharacterCategory.lo,
  42087: CharacterCategory.lo,
  42088: CharacterCategory.lo,
  42089: CharacterCategory.lo,
  42090: CharacterCategory.lo,
  42091: CharacterCategory.lo,
  42092: CharacterCategory.lo,
  42093: CharacterCategory.lo,
  42094: CharacterCategory.lo,
  42095: CharacterCategory.lo,
  42096: CharacterCategory.lo,
  42097: CharacterCategory.lo,
  42098: CharacterCategory.lo,
  42099: CharacterCategory.lo,
  42100: CharacterCategory.lo,
  42101: CharacterCategory.lo,
  42102: CharacterCategory.lo,
  42103: CharacterCategory.lo,
  42104: CharacterCategory.lo,
  42105: CharacterCategory.lo,
  42106: CharacterCategory.lo,
  42107: CharacterCategory.lo,
  42108: CharacterCategory.lo,
  42109: CharacterCategory.lo,
  42110: CharacterCategory.lo,
  42111: CharacterCategory.lo,
  42112: CharacterCategory.lo,
  42113: CharacterCategory.lo,
  42114: CharacterCategory.lo,
  42115: CharacterCategory.lo,
  42116: CharacterCategory.lo,
  42117: CharacterCategory.lo,
  42118: CharacterCategory.lo,
  42119: CharacterCategory.lo,
  42120: CharacterCategory.lo,
  42121: CharacterCategory.lo,
  42122: CharacterCategory.lo,
  42123: CharacterCategory.lo,
  42124: CharacterCategory.lo,
  42192: CharacterCategory.lo,
  42193: CharacterCategory.lo,
  42194: CharacterCategory.lo,
  42195: CharacterCategory.lo,
  42196: CharacterCategory.lo,
  42197: CharacterCategory.lo,
  42198: CharacterCategory.lo,
  42199: CharacterCategory.lo,
  42200: CharacterCategory.lo,
  42201: CharacterCategory.lo,
  42202: CharacterCategory.lo,
  42203: CharacterCategory.lo,
  42204: CharacterCategory.lo,
  42205: CharacterCategory.lo,
  42206: CharacterCategory.lo,
  42207: CharacterCategory.lo,
  42208: CharacterCategory.lo,
  42209: CharacterCategory.lo,
  42210: CharacterCategory.lo,
  42211: CharacterCategory.lo,
  42212: CharacterCategory.lo,
  42213: CharacterCategory.lo,
  42214: CharacterCategory.lo,
  42215: CharacterCategory.lo,
  42216: CharacterCategory.lo,
  42217: CharacterCategory.lo,
  42218: CharacterCategory.lo,
  42219: CharacterCategory.lo,
  42220: CharacterCategory.lo,
  42221: CharacterCategory.lo,
  42222: CharacterCategory.lo,
  42223: CharacterCategory.lo,
  42224: CharacterCategory.lo,
  42225: CharacterCategory.lo,
  42226: CharacterCategory.lo,
  42227: CharacterCategory.lo,
  42228: CharacterCategory.lo,
  42229: CharacterCategory.lo,
  42230: CharacterCategory.lo,
  42231: CharacterCategory.lo,
  42240: CharacterCategory.lo,
  42241: CharacterCategory.lo,
  42242: CharacterCategory.lo,
  42243: CharacterCategory.lo,
  42244: CharacterCategory.lo,
  42245: CharacterCategory.lo,
  42246: CharacterCategory.lo,
  42247: CharacterCategory.lo,
  42248: CharacterCategory.lo,
  42249: CharacterCategory.lo,
  42250: CharacterCategory.lo,
  42251: CharacterCategory.lo,
  42252: CharacterCategory.lo,
  42253: CharacterCategory.lo,
  42254: CharacterCategory.lo,
  42255: CharacterCategory.lo,
  42256: CharacterCategory.lo,
  42257: CharacterCategory.lo,
  42258: CharacterCategory.lo,
  42259: CharacterCategory.lo,
  42260: CharacterCategory.lo,
  42261: CharacterCategory.lo,
  42262: CharacterCategory.lo,
  42263: CharacterCategory.lo,
  42264: CharacterCategory.lo,
  42265: CharacterCategory.lo,
  42266: CharacterCategory.lo,
  42267: CharacterCategory.lo,
  42268: CharacterCategory.lo,
  42269: CharacterCategory.lo,
  42270: CharacterCategory.lo,
  42271: CharacterCategory.lo,
  42272: CharacterCategory.lo,
  42273: CharacterCategory.lo,
  42274: CharacterCategory.lo,
  42275: CharacterCategory.lo,
  42276: CharacterCategory.lo,
  42277: CharacterCategory.lo,
  42278: CharacterCategory.lo,
  42279: CharacterCategory.lo,
  42280: CharacterCategory.lo,
  42281: CharacterCategory.lo,
  42282: CharacterCategory.lo,
  42283: CharacterCategory.lo,
  42284: CharacterCategory.lo,
  42285: CharacterCategory.lo,
  42286: CharacterCategory.lo,
  42287: CharacterCategory.lo,
  42288: CharacterCategory.lo,
  42289: CharacterCategory.lo,
  42290: CharacterCategory.lo,
  42291: CharacterCategory.lo,
  42292: CharacterCategory.lo,
  42293: CharacterCategory.lo,
  42294: CharacterCategory.lo,
  42295: CharacterCategory.lo,
  42296: CharacterCategory.lo,
  42297: CharacterCategory.lo,
  42298: CharacterCategory.lo,
  42299: CharacterCategory.lo,
  42300: CharacterCategory.lo,
  42301: CharacterCategory.lo,
  42302: CharacterCategory.lo,
  42303: CharacterCategory.lo,
  42304: CharacterCategory.lo,
  42305: CharacterCategory.lo,
  42306: CharacterCategory.lo,
  42307: CharacterCategory.lo,
  42308: CharacterCategory.lo,
  42309: CharacterCategory.lo,
  42310: CharacterCategory.lo,
  42311: CharacterCategory.lo,
  42312: CharacterCategory.lo,
  42313: CharacterCategory.lo,
  42314: CharacterCategory.lo,
  42315: CharacterCategory.lo,
  42316: CharacterCategory.lo,
  42317: CharacterCategory.lo,
  42318: CharacterCategory.lo,
  42319: CharacterCategory.lo,
  42320: CharacterCategory.lo,
  42321: CharacterCategory.lo,
  42322: CharacterCategory.lo,
  42323: CharacterCategory.lo,
  42324: CharacterCategory.lo,
  42325: CharacterCategory.lo,
  42326: CharacterCategory.lo,
  42327: CharacterCategory.lo,
  42328: CharacterCategory.lo,
  42329: CharacterCategory.lo,
  42330: CharacterCategory.lo,
  42331: CharacterCategory.lo,
  42332: CharacterCategory.lo,
  42333: CharacterCategory.lo,
  42334: CharacterCategory.lo,
  42335: CharacterCategory.lo,
  42336: CharacterCategory.lo,
  42337: CharacterCategory.lo,
  42338: CharacterCategory.lo,
  42339: CharacterCategory.lo,
  42340: CharacterCategory.lo,
  42341: CharacterCategory.lo,
  42342: CharacterCategory.lo,
  42343: CharacterCategory.lo,
  42344: CharacterCategory.lo,
  42345: CharacterCategory.lo,
  42346: CharacterCategory.lo,
  42347: CharacterCategory.lo,
  42348: CharacterCategory.lo,
  42349: CharacterCategory.lo,
  42350: CharacterCategory.lo,
  42351: CharacterCategory.lo,
  42352: CharacterCategory.lo,
  42353: CharacterCategory.lo,
  42354: CharacterCategory.lo,
  42355: CharacterCategory.lo,
  42356: CharacterCategory.lo,
  42357: CharacterCategory.lo,
  42358: CharacterCategory.lo,
  42359: CharacterCategory.lo,
  42360: CharacterCategory.lo,
  42361: CharacterCategory.lo,
  42362: CharacterCategory.lo,
  42363: CharacterCategory.lo,
  42364: CharacterCategory.lo,
  42365: CharacterCategory.lo,
  42366: CharacterCategory.lo,
  42367: CharacterCategory.lo,
  42368: CharacterCategory.lo,
  42369: CharacterCategory.lo,
  42370: CharacterCategory.lo,
  42371: CharacterCategory.lo,
  42372: CharacterCategory.lo,
  42373: CharacterCategory.lo,
  42374: CharacterCategory.lo,
  42375: CharacterCategory.lo,
  42376: CharacterCategory.lo,
  42377: CharacterCategory.lo,
  42378: CharacterCategory.lo,
  42379: CharacterCategory.lo,
  42380: CharacterCategory.lo,
  42381: CharacterCategory.lo,
  42382: CharacterCategory.lo,
  42383: CharacterCategory.lo,
  42384: CharacterCategory.lo,
  42385: CharacterCategory.lo,
  42386: CharacterCategory.lo,
  42387: CharacterCategory.lo,
  42388: CharacterCategory.lo,
  42389: CharacterCategory.lo,
  42390: CharacterCategory.lo,
  42391: CharacterCategory.lo,
  42392: CharacterCategory.lo,
  42393: CharacterCategory.lo,
  42394: CharacterCategory.lo,
  42395: CharacterCategory.lo,
  42396: CharacterCategory.lo,
  42397: CharacterCategory.lo,
  42398: CharacterCategory.lo,
  42399: CharacterCategory.lo,
  42400: CharacterCategory.lo,
  42401: CharacterCategory.lo,
  42402: CharacterCategory.lo,
  42403: CharacterCategory.lo,
  42404: CharacterCategory.lo,
  42405: CharacterCategory.lo,
  42406: CharacterCategory.lo,
  42407: CharacterCategory.lo,
  42408: CharacterCategory.lo,
  42409: CharacterCategory.lo,
  42410: CharacterCategory.lo,
  42411: CharacterCategory.lo,
  42412: CharacterCategory.lo,
  42413: CharacterCategory.lo,
  42414: CharacterCategory.lo,
  42415: CharacterCategory.lo,
  42416: CharacterCategory.lo,
  42417: CharacterCategory.lo,
  42418: CharacterCategory.lo,
  42419: CharacterCategory.lo,
  42420: CharacterCategory.lo,
  42421: CharacterCategory.lo,
  42422: CharacterCategory.lo,
  42423: CharacterCategory.lo,
  42424: CharacterCategory.lo,
  42425: CharacterCategory.lo,
  42426: CharacterCategory.lo,
  42427: CharacterCategory.lo,
  42428: CharacterCategory.lo,
  42429: CharacterCategory.lo,
  42430: CharacterCategory.lo,
  42431: CharacterCategory.lo,
  42432: CharacterCategory.lo,
  42433: CharacterCategory.lo,
  42434: CharacterCategory.lo,
  42435: CharacterCategory.lo,
  42436: CharacterCategory.lo,
  42437: CharacterCategory.lo,
  42438: CharacterCategory.lo,
  42439: CharacterCategory.lo,
  42440: CharacterCategory.lo,
  42441: CharacterCategory.lo,
  42442: CharacterCategory.lo,
  42443: CharacterCategory.lo,
  42444: CharacterCategory.lo,
  42445: CharacterCategory.lo,
  42446: CharacterCategory.lo,
  42447: CharacterCategory.lo,
  42448: CharacterCategory.lo,
  42449: CharacterCategory.lo,
  42450: CharacterCategory.lo,
  42451: CharacterCategory.lo,
  42452: CharacterCategory.lo,
  42453: CharacterCategory.lo,
  42454: CharacterCategory.lo,
  42455: CharacterCategory.lo,
  42456: CharacterCategory.lo,
  42457: CharacterCategory.lo,
  42458: CharacterCategory.lo,
  42459: CharacterCategory.lo,
  42460: CharacterCategory.lo,
  42461: CharacterCategory.lo,
  42462: CharacterCategory.lo,
  42463: CharacterCategory.lo,
  42464: CharacterCategory.lo,
  42465: CharacterCategory.lo,
  42466: CharacterCategory.lo,
  42467: CharacterCategory.lo,
  42468: CharacterCategory.lo,
  42469: CharacterCategory.lo,
  42470: CharacterCategory.lo,
  42471: CharacterCategory.lo,
  42472: CharacterCategory.lo,
  42473: CharacterCategory.lo,
  42474: CharacterCategory.lo,
  42475: CharacterCategory.lo,
  42476: CharacterCategory.lo,
  42477: CharacterCategory.lo,
  42478: CharacterCategory.lo,
  42479: CharacterCategory.lo,
  42480: CharacterCategory.lo,
  42481: CharacterCategory.lo,
  42482: CharacterCategory.lo,
  42483: CharacterCategory.lo,
  42484: CharacterCategory.lo,
  42485: CharacterCategory.lo,
  42486: CharacterCategory.lo,
  42487: CharacterCategory.lo,
  42488: CharacterCategory.lo,
  42489: CharacterCategory.lo,
  42490: CharacterCategory.lo,
  42491: CharacterCategory.lo,
  42492: CharacterCategory.lo,
  42493: CharacterCategory.lo,
  42494: CharacterCategory.lo,
  42495: CharacterCategory.lo,
  42496: CharacterCategory.lo,
  42497: CharacterCategory.lo,
  42498: CharacterCategory.lo,
  42499: CharacterCategory.lo,
  42500: CharacterCategory.lo,
  42501: CharacterCategory.lo,
  42502: CharacterCategory.lo,
  42503: CharacterCategory.lo,
  42504: CharacterCategory.lo,
  42505: CharacterCategory.lo,
  42506: CharacterCategory.lo,
  42507: CharacterCategory.lo,
  42512: CharacterCategory.lo,
  42513: CharacterCategory.lo,
  42514: CharacterCategory.lo,
  42515: CharacterCategory.lo,
  42516: CharacterCategory.lo,
  42517: CharacterCategory.lo,
  42518: CharacterCategory.lo,
  42519: CharacterCategory.lo,
  42520: CharacterCategory.lo,
  42521: CharacterCategory.lo,
  42522: CharacterCategory.lo,
  42523: CharacterCategory.lo,
  42524: CharacterCategory.lo,
  42525: CharacterCategory.lo,
  42526: CharacterCategory.lo,
  42527: CharacterCategory.lo,
  42538: CharacterCategory.lo,
  42539: CharacterCategory.lo,
  42606: CharacterCategory.lo,
  42656: CharacterCategory.lo,
  42657: CharacterCategory.lo,
  42658: CharacterCategory.lo,
  42659: CharacterCategory.lo,
  42660: CharacterCategory.lo,
  42661: CharacterCategory.lo,
  42662: CharacterCategory.lo,
  42663: CharacterCategory.lo,
  42664: CharacterCategory.lo,
  42665: CharacterCategory.lo,
  42666: CharacterCategory.lo,
  42667: CharacterCategory.lo,
  42668: CharacterCategory.lo,
  42669: CharacterCategory.lo,
  42670: CharacterCategory.lo,
  42671: CharacterCategory.lo,
  42672: CharacterCategory.lo,
  42673: CharacterCategory.lo,
  42674: CharacterCategory.lo,
  42675: CharacterCategory.lo,
  42676: CharacterCategory.lo,
  42677: CharacterCategory.lo,
  42678: CharacterCategory.lo,
  42679: CharacterCategory.lo,
  42680: CharacterCategory.lo,
  42681: CharacterCategory.lo,
  42682: CharacterCategory.lo,
  42683: CharacterCategory.lo,
  42684: CharacterCategory.lo,
  42685: CharacterCategory.lo,
  42686: CharacterCategory.lo,
  42687: CharacterCategory.lo,
  42688: CharacterCategory.lo,
  42689: CharacterCategory.lo,
  42690: CharacterCategory.lo,
  42691: CharacterCategory.lo,
  42692: CharacterCategory.lo,
  42693: CharacterCategory.lo,
  42694: CharacterCategory.lo,
  42695: CharacterCategory.lo,
  42696: CharacterCategory.lo,
  42697: CharacterCategory.lo,
  42698: CharacterCategory.lo,
  42699: CharacterCategory.lo,
  42700: CharacterCategory.lo,
  42701: CharacterCategory.lo,
  42702: CharacterCategory.lo,
  42703: CharacterCategory.lo,
  42704: CharacterCategory.lo,
  42705: CharacterCategory.lo,
  42706: CharacterCategory.lo,
  42707: CharacterCategory.lo,
  42708: CharacterCategory.lo,
  42709: CharacterCategory.lo,
  42710: CharacterCategory.lo,
  42711: CharacterCategory.lo,
  42712: CharacterCategory.lo,
  42713: CharacterCategory.lo,
  42714: CharacterCategory.lo,
  42715: CharacterCategory.lo,
  42716: CharacterCategory.lo,
  42717: CharacterCategory.lo,
  42718: CharacterCategory.lo,
  42719: CharacterCategory.lo,
  42720: CharacterCategory.lo,
  42721: CharacterCategory.lo,
  42722: CharacterCategory.lo,
  42723: CharacterCategory.lo,
  42724: CharacterCategory.lo,
  42725: CharacterCategory.lo,
  42999: CharacterCategory.lo,
  43003: CharacterCategory.lo,
  43004: CharacterCategory.lo,
  43005: CharacterCategory.lo,
  43006: CharacterCategory.lo,
  43007: CharacterCategory.lo,
  43008: CharacterCategory.lo,
  43009: CharacterCategory.lo,
  43011: CharacterCategory.lo,
  43012: CharacterCategory.lo,
  43013: CharacterCategory.lo,
  43015: CharacterCategory.lo,
  43016: CharacterCategory.lo,
  43017: CharacterCategory.lo,
  43018: CharacterCategory.lo,
  43020: CharacterCategory.lo,
  43021: CharacterCategory.lo,
  43022: CharacterCategory.lo,
  43023: CharacterCategory.lo,
  43024: CharacterCategory.lo,
  43025: CharacterCategory.lo,
  43026: CharacterCategory.lo,
  43027: CharacterCategory.lo,
  43028: CharacterCategory.lo,
  43029: CharacterCategory.lo,
  43030: CharacterCategory.lo,
  43031: CharacterCategory.lo,
  43032: CharacterCategory.lo,
  43033: CharacterCategory.lo,
  43034: CharacterCategory.lo,
  43035: CharacterCategory.lo,
  43036: CharacterCategory.lo,
  43037: CharacterCategory.lo,
  43038: CharacterCategory.lo,
  43039: CharacterCategory.lo,
  43040: CharacterCategory.lo,
  43041: CharacterCategory.lo,
  43042: CharacterCategory.lo,
  43072: CharacterCategory.lo,
  43073: CharacterCategory.lo,
  43074: CharacterCategory.lo,
  43075: CharacterCategory.lo,
  43076: CharacterCategory.lo,
  43077: CharacterCategory.lo,
  43078: CharacterCategory.lo,
  43079: CharacterCategory.lo,
  43080: CharacterCategory.lo,
  43081: CharacterCategory.lo,
  43082: CharacterCategory.lo,
  43083: CharacterCategory.lo,
  43084: CharacterCategory.lo,
  43085: CharacterCategory.lo,
  43086: CharacterCategory.lo,
  43087: CharacterCategory.lo,
  43088: CharacterCategory.lo,
  43089: CharacterCategory.lo,
  43090: CharacterCategory.lo,
  43091: CharacterCategory.lo,
  43092: CharacterCategory.lo,
  43093: CharacterCategory.lo,
  43094: CharacterCategory.lo,
  43095: CharacterCategory.lo,
  43096: CharacterCategory.lo,
  43097: CharacterCategory.lo,
  43098: CharacterCategory.lo,
  43099: CharacterCategory.lo,
  43100: CharacterCategory.lo,
  43101: CharacterCategory.lo,
  43102: CharacterCategory.lo,
  43103: CharacterCategory.lo,
  43104: CharacterCategory.lo,
  43105: CharacterCategory.lo,
  43106: CharacterCategory.lo,
  43107: CharacterCategory.lo,
  43108: CharacterCategory.lo,
  43109: CharacterCategory.lo,
  43110: CharacterCategory.lo,
  43111: CharacterCategory.lo,
  43112: CharacterCategory.lo,
  43113: CharacterCategory.lo,
  43114: CharacterCategory.lo,
  43115: CharacterCategory.lo,
  43116: CharacterCategory.lo,
  43117: CharacterCategory.lo,
  43118: CharacterCategory.lo,
  43119: CharacterCategory.lo,
  43120: CharacterCategory.lo,
  43121: CharacterCategory.lo,
  43122: CharacterCategory.lo,
  43123: CharacterCategory.lo,
  43138: CharacterCategory.lo,
  43139: CharacterCategory.lo,
  43140: CharacterCategory.lo,
  43141: CharacterCategory.lo,
  43142: CharacterCategory.lo,
  43143: CharacterCategory.lo,
  43144: CharacterCategory.lo,
  43145: CharacterCategory.lo,
  43146: CharacterCategory.lo,
  43147: CharacterCategory.lo,
  43148: CharacterCategory.lo,
  43149: CharacterCategory.lo,
  43150: CharacterCategory.lo,
  43151: CharacterCategory.lo,
  43152: CharacterCategory.lo,
  43153: CharacterCategory.lo,
  43154: CharacterCategory.lo,
  43155: CharacterCategory.lo,
  43156: CharacterCategory.lo,
  43157: CharacterCategory.lo,
  43158: CharacterCategory.lo,
  43159: CharacterCategory.lo,
  43160: CharacterCategory.lo,
  43161: CharacterCategory.lo,
  43162: CharacterCategory.lo,
  43163: CharacterCategory.lo,
  43164: CharacterCategory.lo,
  43165: CharacterCategory.lo,
  43166: CharacterCategory.lo,
  43167: CharacterCategory.lo,
  43168: CharacterCategory.lo,
  43169: CharacterCategory.lo,
  43170: CharacterCategory.lo,
  43171: CharacterCategory.lo,
  43172: CharacterCategory.lo,
  43173: CharacterCategory.lo,
  43174: CharacterCategory.lo,
  43175: CharacterCategory.lo,
  43176: CharacterCategory.lo,
  43177: CharacterCategory.lo,
  43178: CharacterCategory.lo,
  43179: CharacterCategory.lo,
  43180: CharacterCategory.lo,
  43181: CharacterCategory.lo,
  43182: CharacterCategory.lo,
  43183: CharacterCategory.lo,
  43184: CharacterCategory.lo,
  43185: CharacterCategory.lo,
  43186: CharacterCategory.lo,
  43187: CharacterCategory.lo,
  43250: CharacterCategory.lo,
  43251: CharacterCategory.lo,
  43252: CharacterCategory.lo,
  43253: CharacterCategory.lo,
  43254: CharacterCategory.lo,
  43255: CharacterCategory.lo,
  43259: CharacterCategory.lo,
  43274: CharacterCategory.lo,
  43275: CharacterCategory.lo,
  43276: CharacterCategory.lo,
  43277: CharacterCategory.lo,
  43278: CharacterCategory.lo,
  43279: CharacterCategory.lo,
  43280: CharacterCategory.lo,
  43281: CharacterCategory.lo,
  43282: CharacterCategory.lo,
  43283: CharacterCategory.lo,
  43284: CharacterCategory.lo,
  43285: CharacterCategory.lo,
  43286: CharacterCategory.lo,
  43287: CharacterCategory.lo,
  43288: CharacterCategory.lo,
  43289: CharacterCategory.lo,
  43290: CharacterCategory.lo,
  43291: CharacterCategory.lo,
  43292: CharacterCategory.lo,
  43293: CharacterCategory.lo,
  43294: CharacterCategory.lo,
  43295: CharacterCategory.lo,
  43296: CharacterCategory.lo,
  43297: CharacterCategory.lo,
  43298: CharacterCategory.lo,
  43299: CharacterCategory.lo,
  43300: CharacterCategory.lo,
  43301: CharacterCategory.lo,
  43312: CharacterCategory.lo,
  43313: CharacterCategory.lo,
  43314: CharacterCategory.lo,
  43315: CharacterCategory.lo,
  43316: CharacterCategory.lo,
  43317: CharacterCategory.lo,
  43318: CharacterCategory.lo,
  43319: CharacterCategory.lo,
  43320: CharacterCategory.lo,
  43321: CharacterCategory.lo,
  43322: CharacterCategory.lo,
  43323: CharacterCategory.lo,
  43324: CharacterCategory.lo,
  43325: CharacterCategory.lo,
  43326: CharacterCategory.lo,
  43327: CharacterCategory.lo,
  43328: CharacterCategory.lo,
  43329: CharacterCategory.lo,
  43330: CharacterCategory.lo,
  43331: CharacterCategory.lo,
  43332: CharacterCategory.lo,
  43333: CharacterCategory.lo,
  43334: CharacterCategory.lo,
  43360: CharacterCategory.lo,
  43361: CharacterCategory.lo,
  43362: CharacterCategory.lo,
  43363: CharacterCategory.lo,
  43364: CharacterCategory.lo,
  43365: CharacterCategory.lo,
  43366: CharacterCategory.lo,
  43367: CharacterCategory.lo,
  43368: CharacterCategory.lo,
  43369: CharacterCategory.lo,
  43370: CharacterCategory.lo,
  43371: CharacterCategory.lo,
  43372: CharacterCategory.lo,
  43373: CharacterCategory.lo,
  43374: CharacterCategory.lo,
  43375: CharacterCategory.lo,
  43376: CharacterCategory.lo,
  43377: CharacterCategory.lo,
  43378: CharacterCategory.lo,
  43379: CharacterCategory.lo,
  43380: CharacterCategory.lo,
  43381: CharacterCategory.lo,
  43382: CharacterCategory.lo,
  43383: CharacterCategory.lo,
  43384: CharacterCategory.lo,
  43385: CharacterCategory.lo,
  43386: CharacterCategory.lo,
  43387: CharacterCategory.lo,
  43388: CharacterCategory.lo,
  43396: CharacterCategory.lo,
  43397: CharacterCategory.lo,
  43398: CharacterCategory.lo,
  43399: CharacterCategory.lo,
  43400: CharacterCategory.lo,
  43401: CharacterCategory.lo,
  43402: CharacterCategory.lo,
  43403: CharacterCategory.lo,
  43404: CharacterCategory.lo,
  43405: CharacterCategory.lo,
  43406: CharacterCategory.lo,
  43407: CharacterCategory.lo,
  43408: CharacterCategory.lo,
  43409: CharacterCategory.lo,
  43410: CharacterCategory.lo,
  43411: CharacterCategory.lo,
  43412: CharacterCategory.lo,
  43413: CharacterCategory.lo,
  43414: CharacterCategory.lo,
  43415: CharacterCategory.lo,
  43416: CharacterCategory.lo,
  43417: CharacterCategory.lo,
  43418: CharacterCategory.lo,
  43419: CharacterCategory.lo,
  43420: CharacterCategory.lo,
  43421: CharacterCategory.lo,
  43422: CharacterCategory.lo,
  43423: CharacterCategory.lo,
  43424: CharacterCategory.lo,
  43425: CharacterCategory.lo,
  43426: CharacterCategory.lo,
  43427: CharacterCategory.lo,
  43428: CharacterCategory.lo,
  43429: CharacterCategory.lo,
  43430: CharacterCategory.lo,
  43431: CharacterCategory.lo,
  43432: CharacterCategory.lo,
  43433: CharacterCategory.lo,
  43434: CharacterCategory.lo,
  43435: CharacterCategory.lo,
  43436: CharacterCategory.lo,
  43437: CharacterCategory.lo,
  43438: CharacterCategory.lo,
  43439: CharacterCategory.lo,
  43440: CharacterCategory.lo,
  43441: CharacterCategory.lo,
  43442: CharacterCategory.lo,
  43488: CharacterCategory.lo,
  43489: CharacterCategory.lo,
  43490: CharacterCategory.lo,
  43491: CharacterCategory.lo,
  43492: CharacterCategory.lo,
  43495: CharacterCategory.lo,
  43496: CharacterCategory.lo,
  43497: CharacterCategory.lo,
  43498: CharacterCategory.lo,
  43499: CharacterCategory.lo,
  43500: CharacterCategory.lo,
  43501: CharacterCategory.lo,
  43502: CharacterCategory.lo,
  43503: CharacterCategory.lo,
  43514: CharacterCategory.lo,
  43515: CharacterCategory.lo,
  43516: CharacterCategory.lo,
  43517: CharacterCategory.lo,
  43518: CharacterCategory.lo,
  43520: CharacterCategory.lo,
  43521: CharacterCategory.lo,
  43522: CharacterCategory.lo,
  43523: CharacterCategory.lo,
  43524: CharacterCategory.lo,
  43525: CharacterCategory.lo,
  43526: CharacterCategory.lo,
  43527: CharacterCategory.lo,
  43528: CharacterCategory.lo,
  43529: CharacterCategory.lo,
  43530: CharacterCategory.lo,
  43531: CharacterCategory.lo,
  43532: CharacterCategory.lo,
  43533: CharacterCategory.lo,
  43534: CharacterCategory.lo,
  43535: CharacterCategory.lo,
  43536: CharacterCategory.lo,
  43537: CharacterCategory.lo,
  43538: CharacterCategory.lo,
  43539: CharacterCategory.lo,
  43540: CharacterCategory.lo,
  43541: CharacterCategory.lo,
  43542: CharacterCategory.lo,
  43543: CharacterCategory.lo,
  43544: CharacterCategory.lo,
  43545: CharacterCategory.lo,
  43546: CharacterCategory.lo,
  43547: CharacterCategory.lo,
  43548: CharacterCategory.lo,
  43549: CharacterCategory.lo,
  43550: CharacterCategory.lo,
  43551: CharacterCategory.lo,
  43552: CharacterCategory.lo,
  43553: CharacterCategory.lo,
  43554: CharacterCategory.lo,
  43555: CharacterCategory.lo,
  43556: CharacterCategory.lo,
  43557: CharacterCategory.lo,
  43558: CharacterCategory.lo,
  43559: CharacterCategory.lo,
  43560: CharacterCategory.lo,
  43584: CharacterCategory.lo,
  43585: CharacterCategory.lo,
  43586: CharacterCategory.lo,
  43588: CharacterCategory.lo,
  43589: CharacterCategory.lo,
  43590: CharacterCategory.lo,
  43591: CharacterCategory.lo,
  43592: CharacterCategory.lo,
  43593: CharacterCategory.lo,
  43594: CharacterCategory.lo,
  43595: CharacterCategory.lo,
  43616: CharacterCategory.lo,
  43617: CharacterCategory.lo,
  43618: CharacterCategory.lo,
  43619: CharacterCategory.lo,
  43620: CharacterCategory.lo,
  43621: CharacterCategory.lo,
  43622: CharacterCategory.lo,
  43623: CharacterCategory.lo,
  43624: CharacterCategory.lo,
  43625: CharacterCategory.lo,
  43626: CharacterCategory.lo,
  43627: CharacterCategory.lo,
  43628: CharacterCategory.lo,
  43629: CharacterCategory.lo,
  43630: CharacterCategory.lo,
  43631: CharacterCategory.lo,
  43633: CharacterCategory.lo,
  43634: CharacterCategory.lo,
  43635: CharacterCategory.lo,
  43636: CharacterCategory.lo,
  43637: CharacterCategory.lo,
  43638: CharacterCategory.lo,
  43642: CharacterCategory.lo,
  43646: CharacterCategory.lo,
  43647: CharacterCategory.lo,
  43648: CharacterCategory.lo,
  43649: CharacterCategory.lo,
  43650: CharacterCategory.lo,
  43651: CharacterCategory.lo,
  43652: CharacterCategory.lo,
  43653: CharacterCategory.lo,
  43654: CharacterCategory.lo,
  43655: CharacterCategory.lo,
  43656: CharacterCategory.lo,
  43657: CharacterCategory.lo,
  43658: CharacterCategory.lo,
  43659: CharacterCategory.lo,
  43660: CharacterCategory.lo,
  43661: CharacterCategory.lo,
  43662: CharacterCategory.lo,
  43663: CharacterCategory.lo,
  43664: CharacterCategory.lo,
  43665: CharacterCategory.lo,
  43666: CharacterCategory.lo,
  43667: CharacterCategory.lo,
  43668: CharacterCategory.lo,
  43669: CharacterCategory.lo,
  43670: CharacterCategory.lo,
  43671: CharacterCategory.lo,
  43672: CharacterCategory.lo,
  43673: CharacterCategory.lo,
  43674: CharacterCategory.lo,
  43675: CharacterCategory.lo,
  43676: CharacterCategory.lo,
  43677: CharacterCategory.lo,
  43678: CharacterCategory.lo,
  43679: CharacterCategory.lo,
  43680: CharacterCategory.lo,
  43681: CharacterCategory.lo,
  43682: CharacterCategory.lo,
  43683: CharacterCategory.lo,
  43684: CharacterCategory.lo,
  43685: CharacterCategory.lo,
  43686: CharacterCategory.lo,
  43687: CharacterCategory.lo,
  43688: CharacterCategory.lo,
  43689: CharacterCategory.lo,
  43690: CharacterCategory.lo,
  43691: CharacterCategory.lo,
  43692: CharacterCategory.lo,
  43693: CharacterCategory.lo,
  43694: CharacterCategory.lo,
  43695: CharacterCategory.lo,
  43697: CharacterCategory.lo,
  43701: CharacterCategory.lo,
  43702: CharacterCategory.lo,
  43705: CharacterCategory.lo,
  43706: CharacterCategory.lo,
  43707: CharacterCategory.lo,
  43708: CharacterCategory.lo,
  43709: CharacterCategory.lo,
  43712: CharacterCategory.lo,
  43714: CharacterCategory.lo,
  43739: CharacterCategory.lo,
  43740: CharacterCategory.lo,
  43744: CharacterCategory.lo,
  43745: CharacterCategory.lo,
  43746: CharacterCategory.lo,
  43747: CharacterCategory.lo,
  43748: CharacterCategory.lo,
  43749: CharacterCategory.lo,
  43750: CharacterCategory.lo,
  43751: CharacterCategory.lo,
  43752: CharacterCategory.lo,
  43753: CharacterCategory.lo,
  43754: CharacterCategory.lo,
  43762: CharacterCategory.lo,
  43777: CharacterCategory.lo,
  43778: CharacterCategory.lo,
  43779: CharacterCategory.lo,
  43780: CharacterCategory.lo,
  43781: CharacterCategory.lo,
  43782: CharacterCategory.lo,
  43785: CharacterCategory.lo,
  43786: CharacterCategory.lo,
  43787: CharacterCategory.lo,
  43788: CharacterCategory.lo,
  43789: CharacterCategory.lo,
  43790: CharacterCategory.lo,
  43793: CharacterCategory.lo,
  43794: CharacterCategory.lo,
  43795: CharacterCategory.lo,
  43796: CharacterCategory.lo,
  43797: CharacterCategory.lo,
  43798: CharacterCategory.lo,
  43808: CharacterCategory.lo,
  43809: CharacterCategory.lo,
  43810: CharacterCategory.lo,
  43811: CharacterCategory.lo,
  43812: CharacterCategory.lo,
  43813: CharacterCategory.lo,
  43814: CharacterCategory.lo,
  43816: CharacterCategory.lo,
  43817: CharacterCategory.lo,
  43818: CharacterCategory.lo,
  43819: CharacterCategory.lo,
  43820: CharacterCategory.lo,
  43821: CharacterCategory.lo,
  43822: CharacterCategory.lo,
  43968: CharacterCategory.lo,
  43969: CharacterCategory.lo,
  43970: CharacterCategory.lo,
  43971: CharacterCategory.lo,
  43972: CharacterCategory.lo,
  43973: CharacterCategory.lo,
  43974: CharacterCategory.lo,
  43975: CharacterCategory.lo,
  43976: CharacterCategory.lo,
  43977: CharacterCategory.lo,
  43978: CharacterCategory.lo,
  43979: CharacterCategory.lo,
  43980: CharacterCategory.lo,
  43981: CharacterCategory.lo,
  43982: CharacterCategory.lo,
  43983: CharacterCategory.lo,
  43984: CharacterCategory.lo,
  43985: CharacterCategory.lo,
  43986: CharacterCategory.lo,
  43987: CharacterCategory.lo,
  43988: CharacterCategory.lo,
  43989: CharacterCategory.lo,
  43990: CharacterCategory.lo,
  43991: CharacterCategory.lo,
  43992: CharacterCategory.lo,
  43993: CharacterCategory.lo,
  43994: CharacterCategory.lo,
  43995: CharacterCategory.lo,
  43996: CharacterCategory.lo,
  43997: CharacterCategory.lo,
  43998: CharacterCategory.lo,
  43999: CharacterCategory.lo,
  44000: CharacterCategory.lo,
  44001: CharacterCategory.lo,
  44002: CharacterCategory.lo,
  44032: CharacterCategory.lo,
  55203: CharacterCategory.lo,
  55216: CharacterCategory.lo,
  55217: CharacterCategory.lo,
  55218: CharacterCategory.lo,
  55219: CharacterCategory.lo,
  55220: CharacterCategory.lo,
  55221: CharacterCategory.lo,
  55222: CharacterCategory.lo,
  55223: CharacterCategory.lo,
  55224: CharacterCategory.lo,
  55225: CharacterCategory.lo,
  55226: CharacterCategory.lo,
  55227: CharacterCategory.lo,
  55228: CharacterCategory.lo,
  55229: CharacterCategory.lo,
  55230: CharacterCategory.lo,
  55231: CharacterCategory.lo,
  55232: CharacterCategory.lo,
  55233: CharacterCategory.lo,
  55234: CharacterCategory.lo,
  55235: CharacterCategory.lo,
  55236: CharacterCategory.lo,
  55237: CharacterCategory.lo,
  55238: CharacterCategory.lo,
  55243: CharacterCategory.lo,
  55244: CharacterCategory.lo,
  55245: CharacterCategory.lo,
  55246: CharacterCategory.lo,
  55247: CharacterCategory.lo,
  55248: CharacterCategory.lo,
  55249: CharacterCategory.lo,
  55250: CharacterCategory.lo,
  55251: CharacterCategory.lo,
  55252: CharacterCategory.lo,
  55253: CharacterCategory.lo,
  55254: CharacterCategory.lo,
  55255: CharacterCategory.lo,
  55256: CharacterCategory.lo,
  55257: CharacterCategory.lo,
  55258: CharacterCategory.lo,
  55259: CharacterCategory.lo,
  55260: CharacterCategory.lo,
  55261: CharacterCategory.lo,
  55262: CharacterCategory.lo,
  55263: CharacterCategory.lo,
  55264: CharacterCategory.lo,
  55265: CharacterCategory.lo,
  55266: CharacterCategory.lo,
  55267: CharacterCategory.lo,
  55268: CharacterCategory.lo,
  55269: CharacterCategory.lo,
  55270: CharacterCategory.lo,
  55271: CharacterCategory.lo,
  55272: CharacterCategory.lo,
  55273: CharacterCategory.lo,
  55274: CharacterCategory.lo,
  55275: CharacterCategory.lo,
  55276: CharacterCategory.lo,
  55277: CharacterCategory.lo,
  55278: CharacterCategory.lo,
  55279: CharacterCategory.lo,
  55280: CharacterCategory.lo,
  55281: CharacterCategory.lo,
  55282: CharacterCategory.lo,
  55283: CharacterCategory.lo,
  55284: CharacterCategory.lo,
  55285: CharacterCategory.lo,
  55286: CharacterCategory.lo,
  55287: CharacterCategory.lo,
  55288: CharacterCategory.lo,
  55289: CharacterCategory.lo,
  55290: CharacterCategory.lo,
  55291: CharacterCategory.lo,
  63744: CharacterCategory.lo,
  63745: CharacterCategory.lo,
  63746: CharacterCategory.lo,
  63747: CharacterCategory.lo,
  63748: CharacterCategory.lo,
  63749: CharacterCategory.lo,
  63750: CharacterCategory.lo,
  63751: CharacterCategory.lo,
  63752: CharacterCategory.lo,
  63753: CharacterCategory.lo,
  63754: CharacterCategory.lo,
  63755: CharacterCategory.lo,
  63756: CharacterCategory.lo,
  63757: CharacterCategory.lo,
  63758: CharacterCategory.lo,
  63759: CharacterCategory.lo,
  63760: CharacterCategory.lo,
  63761: CharacterCategory.lo,
  63762: CharacterCategory.lo,
  63763: CharacterCategory.lo,
  63764: CharacterCategory.lo,
  63765: CharacterCategory.lo,
  63766: CharacterCategory.lo,
  63767: CharacterCategory.lo,
  63768: CharacterCategory.lo,
  63769: CharacterCategory.lo,
  63770: CharacterCategory.lo,
  63771: CharacterCategory.lo,
  63772: CharacterCategory.lo,
  63773: CharacterCategory.lo,
  63774: CharacterCategory.lo,
  63775: CharacterCategory.lo,
  63776: CharacterCategory.lo,
  63777: CharacterCategory.lo,
  63778: CharacterCategory.lo,
  63779: CharacterCategory.lo,
  63780: CharacterCategory.lo,
  63781: CharacterCategory.lo,
  63782: CharacterCategory.lo,
  63783: CharacterCategory.lo,
  63784: CharacterCategory.lo,
  63785: CharacterCategory.lo,
  63786: CharacterCategory.lo,
  63787: CharacterCategory.lo,
  63788: CharacterCategory.lo,
  63789: CharacterCategory.lo,
  63790: CharacterCategory.lo,
  63791: CharacterCategory.lo,
  63792: CharacterCategory.lo,
  63793: CharacterCategory.lo,
  63794: CharacterCategory.lo,
  63795: CharacterCategory.lo,
  63796: CharacterCategory.lo,
  63797: CharacterCategory.lo,
  63798: CharacterCategory.lo,
  63799: CharacterCategory.lo,
  63800: CharacterCategory.lo,
  63801: CharacterCategory.lo,
  63802: CharacterCategory.lo,
  63803: CharacterCategory.lo,
  63804: CharacterCategory.lo,
  63805: CharacterCategory.lo,
  63806: CharacterCategory.lo,
  63807: CharacterCategory.lo,
  63808: CharacterCategory.lo,
  63809: CharacterCategory.lo,
  63810: CharacterCategory.lo,
  63811: CharacterCategory.lo,
  63812: CharacterCategory.lo,
  63813: CharacterCategory.lo,
  63814: CharacterCategory.lo,
  63815: CharacterCategory.lo,
  63816: CharacterCategory.lo,
  63817: CharacterCategory.lo,
  63818: CharacterCategory.lo,
  63819: CharacterCategory.lo,
  63820: CharacterCategory.lo,
  63821: CharacterCategory.lo,
  63822: CharacterCategory.lo,
  63823: CharacterCategory.lo,
  63824: CharacterCategory.lo,
  63825: CharacterCategory.lo,
  63826: CharacterCategory.lo,
  63827: CharacterCategory.lo,
  63828: CharacterCategory.lo,
  63829: CharacterCategory.lo,
  63830: CharacterCategory.lo,
  63831: CharacterCategory.lo,
  63832: CharacterCategory.lo,
  63833: CharacterCategory.lo,
  63834: CharacterCategory.lo,
  63835: CharacterCategory.lo,
  63836: CharacterCategory.lo,
  63837: CharacterCategory.lo,
  63838: CharacterCategory.lo,
  63839: CharacterCategory.lo,
  63840: CharacterCategory.lo,
  63841: CharacterCategory.lo,
  63842: CharacterCategory.lo,
  63843: CharacterCategory.lo,
  63844: CharacterCategory.lo,
  63845: CharacterCategory.lo,
  63846: CharacterCategory.lo,
  63847: CharacterCategory.lo,
  63848: CharacterCategory.lo,
  63849: CharacterCategory.lo,
  63850: CharacterCategory.lo,
  63851: CharacterCategory.lo,
  63852: CharacterCategory.lo,
  63853: CharacterCategory.lo,
  63854: CharacterCategory.lo,
  63855: CharacterCategory.lo,
  63856: CharacterCategory.lo,
  63857: CharacterCategory.lo,
  63858: CharacterCategory.lo,
  63859: CharacterCategory.lo,
  63860: CharacterCategory.lo,
  63861: CharacterCategory.lo,
  63862: CharacterCategory.lo,
  63863: CharacterCategory.lo,
  63864: CharacterCategory.lo,
  63865: CharacterCategory.lo,
  63866: CharacterCategory.lo,
  63867: CharacterCategory.lo,
  63868: CharacterCategory.lo,
  63869: CharacterCategory.lo,
  63870: CharacterCategory.lo,
  63871: CharacterCategory.lo,
  63872: CharacterCategory.lo,
  63873: CharacterCategory.lo,
  63874: CharacterCategory.lo,
  63875: CharacterCategory.lo,
  63876: CharacterCategory.lo,
  63877: CharacterCategory.lo,
  63878: CharacterCategory.lo,
  63879: CharacterCategory.lo,
  63880: CharacterCategory.lo,
  63881: CharacterCategory.lo,
  63882: CharacterCategory.lo,
  63883: CharacterCategory.lo,
  63884: CharacterCategory.lo,
  63885: CharacterCategory.lo,
  63886: CharacterCategory.lo,
  63887: CharacterCategory.lo,
  63888: CharacterCategory.lo,
  63889: CharacterCategory.lo,
  63890: CharacterCategory.lo,
  63891: CharacterCategory.lo,
  63892: CharacterCategory.lo,
  63893: CharacterCategory.lo,
  63894: CharacterCategory.lo,
  63895: CharacterCategory.lo,
  63896: CharacterCategory.lo,
  63897: CharacterCategory.lo,
  63898: CharacterCategory.lo,
  63899: CharacterCategory.lo,
  63900: CharacterCategory.lo,
  63901: CharacterCategory.lo,
  63902: CharacterCategory.lo,
  63903: CharacterCategory.lo,
  63904: CharacterCategory.lo,
  63905: CharacterCategory.lo,
  63906: CharacterCategory.lo,
  63907: CharacterCategory.lo,
  63908: CharacterCategory.lo,
  63909: CharacterCategory.lo,
  63910: CharacterCategory.lo,
  63911: CharacterCategory.lo,
  63912: CharacterCategory.lo,
  63913: CharacterCategory.lo,
  63914: CharacterCategory.lo,
  63915: CharacterCategory.lo,
  63916: CharacterCategory.lo,
  63917: CharacterCategory.lo,
  63918: CharacterCategory.lo,
  63919: CharacterCategory.lo,
  63920: CharacterCategory.lo,
  63921: CharacterCategory.lo,
  63922: CharacterCategory.lo,
  63923: CharacterCategory.lo,
  63924: CharacterCategory.lo,
  63925: CharacterCategory.lo,
  63926: CharacterCategory.lo,
  63927: CharacterCategory.lo,
  63928: CharacterCategory.lo,
  63929: CharacterCategory.lo,
  63930: CharacterCategory.lo,
  63931: CharacterCategory.lo,
  63932: CharacterCategory.lo,
  63933: CharacterCategory.lo,
  63934: CharacterCategory.lo,
  63935: CharacterCategory.lo,
  63936: CharacterCategory.lo,
  63937: CharacterCategory.lo,
  63938: CharacterCategory.lo,
  63939: CharacterCategory.lo,
  63940: CharacterCategory.lo,
  63941: CharacterCategory.lo,
  63942: CharacterCategory.lo,
  63943: CharacterCategory.lo,
  63944: CharacterCategory.lo,
  63945: CharacterCategory.lo,
  63946: CharacterCategory.lo,
  63947: CharacterCategory.lo,
  63948: CharacterCategory.lo,
  63949: CharacterCategory.lo,
  63950: CharacterCategory.lo,
  63951: CharacterCategory.lo,
  63952: CharacterCategory.lo,
  63953: CharacterCategory.lo,
  63954: CharacterCategory.lo,
  63955: CharacterCategory.lo,
  63956: CharacterCategory.lo,
  63957: CharacterCategory.lo,
  63958: CharacterCategory.lo,
  63959: CharacterCategory.lo,
  63960: CharacterCategory.lo,
  63961: CharacterCategory.lo,
  63962: CharacterCategory.lo,
  63963: CharacterCategory.lo,
  63964: CharacterCategory.lo,
  63965: CharacterCategory.lo,
  63966: CharacterCategory.lo,
  63967: CharacterCategory.lo,
  63968: CharacterCategory.lo,
  63969: CharacterCategory.lo,
  63970: CharacterCategory.lo,
  63971: CharacterCategory.lo,
  63972: CharacterCategory.lo,
  63973: CharacterCategory.lo,
  63974: CharacterCategory.lo,
  63975: CharacterCategory.lo,
  63976: CharacterCategory.lo,
  63977: CharacterCategory.lo,
  63978: CharacterCategory.lo,
  63979: CharacterCategory.lo,
  63980: CharacterCategory.lo,
  63981: CharacterCategory.lo,
  63982: CharacterCategory.lo,
  63983: CharacterCategory.lo,
  63984: CharacterCategory.lo,
  63985: CharacterCategory.lo,
  63986: CharacterCategory.lo,
  63987: CharacterCategory.lo,
  63988: CharacterCategory.lo,
  63989: CharacterCategory.lo,
  63990: CharacterCategory.lo,
  63991: CharacterCategory.lo,
  63992: CharacterCategory.lo,
  63993: CharacterCategory.lo,
  63994: CharacterCategory.lo,
  63995: CharacterCategory.lo,
  63996: CharacterCategory.lo,
  63997: CharacterCategory.lo,
  63998: CharacterCategory.lo,
  63999: CharacterCategory.lo,
  64000: CharacterCategory.lo,
  64001: CharacterCategory.lo,
  64002: CharacterCategory.lo,
  64003: CharacterCategory.lo,
  64004: CharacterCategory.lo,
  64005: CharacterCategory.lo,
  64006: CharacterCategory.lo,
  64007: CharacterCategory.lo,
  64008: CharacterCategory.lo,
  64009: CharacterCategory.lo,
  64010: CharacterCategory.lo,
  64011: CharacterCategory.lo,
  64012: CharacterCategory.lo,
  64013: CharacterCategory.lo,
  64014: CharacterCategory.lo,
  64015: CharacterCategory.lo,
  64016: CharacterCategory.lo,
  64017: CharacterCategory.lo,
  64018: CharacterCategory.lo,
  64019: CharacterCategory.lo,
  64020: CharacterCategory.lo,
  64021: CharacterCategory.lo,
  64022: CharacterCategory.lo,
  64023: CharacterCategory.lo,
  64024: CharacterCategory.lo,
  64025: CharacterCategory.lo,
  64026: CharacterCategory.lo,
  64027: CharacterCategory.lo,
  64028: CharacterCategory.lo,
  64029: CharacterCategory.lo,
  64030: CharacterCategory.lo,
  64031: CharacterCategory.lo,
  64032: CharacterCategory.lo,
  64033: CharacterCategory.lo,
  64034: CharacterCategory.lo,
  64035: CharacterCategory.lo,
  64036: CharacterCategory.lo,
  64037: CharacterCategory.lo,
  64038: CharacterCategory.lo,
  64039: CharacterCategory.lo,
  64040: CharacterCategory.lo,
  64041: CharacterCategory.lo,
  64042: CharacterCategory.lo,
  64043: CharacterCategory.lo,
  64044: CharacterCategory.lo,
  64045: CharacterCategory.lo,
  64046: CharacterCategory.lo,
  64047: CharacterCategory.lo,
  64048: CharacterCategory.lo,
  64049: CharacterCategory.lo,
  64050: CharacterCategory.lo,
  64051: CharacterCategory.lo,
  64052: CharacterCategory.lo,
  64053: CharacterCategory.lo,
  64054: CharacterCategory.lo,
  64055: CharacterCategory.lo,
  64056: CharacterCategory.lo,
  64057: CharacterCategory.lo,
  64058: CharacterCategory.lo,
  64059: CharacterCategory.lo,
  64060: CharacterCategory.lo,
  64061: CharacterCategory.lo,
  64062: CharacterCategory.lo,
  64063: CharacterCategory.lo,
  64064: CharacterCategory.lo,
  64065: CharacterCategory.lo,
  64066: CharacterCategory.lo,
  64067: CharacterCategory.lo,
  64068: CharacterCategory.lo,
  64069: CharacterCategory.lo,
  64070: CharacterCategory.lo,
  64071: CharacterCategory.lo,
  64072: CharacterCategory.lo,
  64073: CharacterCategory.lo,
  64074: CharacterCategory.lo,
  64075: CharacterCategory.lo,
  64076: CharacterCategory.lo,
  64077: CharacterCategory.lo,
  64078: CharacterCategory.lo,
  64079: CharacterCategory.lo,
  64080: CharacterCategory.lo,
  64081: CharacterCategory.lo,
  64082: CharacterCategory.lo,
  64083: CharacterCategory.lo,
  64084: CharacterCategory.lo,
  64085: CharacterCategory.lo,
  64086: CharacterCategory.lo,
  64087: CharacterCategory.lo,
  64088: CharacterCategory.lo,
  64089: CharacterCategory.lo,
  64090: CharacterCategory.lo,
  64091: CharacterCategory.lo,
  64092: CharacterCategory.lo,
  64093: CharacterCategory.lo,
  64094: CharacterCategory.lo,
  64095: CharacterCategory.lo,
  64096: CharacterCategory.lo,
  64097: CharacterCategory.lo,
  64098: CharacterCategory.lo,
  64099: CharacterCategory.lo,
  64100: CharacterCategory.lo,
  64101: CharacterCategory.lo,
  64102: CharacterCategory.lo,
  64103: CharacterCategory.lo,
  64104: CharacterCategory.lo,
  64105: CharacterCategory.lo,
  64106: CharacterCategory.lo,
  64107: CharacterCategory.lo,
  64108: CharacterCategory.lo,
  64109: CharacterCategory.lo,
  64112: CharacterCategory.lo,
  64113: CharacterCategory.lo,
  64114: CharacterCategory.lo,
  64115: CharacterCategory.lo,
  64116: CharacterCategory.lo,
  64117: CharacterCategory.lo,
  64118: CharacterCategory.lo,
  64119: CharacterCategory.lo,
  64120: CharacterCategory.lo,
  64121: CharacterCategory.lo,
  64122: CharacterCategory.lo,
  64123: CharacterCategory.lo,
  64124: CharacterCategory.lo,
  64125: CharacterCategory.lo,
  64126: CharacterCategory.lo,
  64127: CharacterCategory.lo,
  64128: CharacterCategory.lo,
  64129: CharacterCategory.lo,
  64130: CharacterCategory.lo,
  64131: CharacterCategory.lo,
  64132: CharacterCategory.lo,
  64133: CharacterCategory.lo,
  64134: CharacterCategory.lo,
  64135: CharacterCategory.lo,
  64136: CharacterCategory.lo,
  64137: CharacterCategory.lo,
  64138: CharacterCategory.lo,
  64139: CharacterCategory.lo,
  64140: CharacterCategory.lo,
  64141: CharacterCategory.lo,
  64142: CharacterCategory.lo,
  64143: CharacterCategory.lo,
  64144: CharacterCategory.lo,
  64145: CharacterCategory.lo,
  64146: CharacterCategory.lo,
  64147: CharacterCategory.lo,
  64148: CharacterCategory.lo,
  64149: CharacterCategory.lo,
  64150: CharacterCategory.lo,
  64151: CharacterCategory.lo,
  64152: CharacterCategory.lo,
  64153: CharacterCategory.lo,
  64154: CharacterCategory.lo,
  64155: CharacterCategory.lo,
  64156: CharacterCategory.lo,
  64157: CharacterCategory.lo,
  64158: CharacterCategory.lo,
  64159: CharacterCategory.lo,
  64160: CharacterCategory.lo,
  64161: CharacterCategory.lo,
  64162: CharacterCategory.lo,
  64163: CharacterCategory.lo,
  64164: CharacterCategory.lo,
  64165: CharacterCategory.lo,
  64166: CharacterCategory.lo,
  64167: CharacterCategory.lo,
  64168: CharacterCategory.lo,
  64169: CharacterCategory.lo,
  64170: CharacterCategory.lo,
  64171: CharacterCategory.lo,
  64172: CharacterCategory.lo,
  64173: CharacterCategory.lo,
  64174: CharacterCategory.lo,
  64175: CharacterCategory.lo,
  64176: CharacterCategory.lo,
  64177: CharacterCategory.lo,
  64178: CharacterCategory.lo,
  64179: CharacterCategory.lo,
  64180: CharacterCategory.lo,
  64181: CharacterCategory.lo,
  64182: CharacterCategory.lo,
  64183: CharacterCategory.lo,
  64184: CharacterCategory.lo,
  64185: CharacterCategory.lo,
  64186: CharacterCategory.lo,
  64187: CharacterCategory.lo,
  64188: CharacterCategory.lo,
  64189: CharacterCategory.lo,
  64190: CharacterCategory.lo,
  64191: CharacterCategory.lo,
  64192: CharacterCategory.lo,
  64193: CharacterCategory.lo,
  64194: CharacterCategory.lo,
  64195: CharacterCategory.lo,
  64196: CharacterCategory.lo,
  64197: CharacterCategory.lo,
  64198: CharacterCategory.lo,
  64199: CharacterCategory.lo,
  64200: CharacterCategory.lo,
  64201: CharacterCategory.lo,
  64202: CharacterCategory.lo,
  64203: CharacterCategory.lo,
  64204: CharacterCategory.lo,
  64205: CharacterCategory.lo,
  64206: CharacterCategory.lo,
  64207: CharacterCategory.lo,
  64208: CharacterCategory.lo,
  64209: CharacterCategory.lo,
  64210: CharacterCategory.lo,
  64211: CharacterCategory.lo,
  64212: CharacterCategory.lo,
  64213: CharacterCategory.lo,
  64214: CharacterCategory.lo,
  64215: CharacterCategory.lo,
  64216: CharacterCategory.lo,
  64217: CharacterCategory.lo,
  64285: CharacterCategory.lo,
  64287: CharacterCategory.lo,
  64288: CharacterCategory.lo,
  64289: CharacterCategory.lo,
  64290: CharacterCategory.lo,
  64291: CharacterCategory.lo,
  64292: CharacterCategory.lo,
  64293: CharacterCategory.lo,
  64294: CharacterCategory.lo,
  64295: CharacterCategory.lo,
  64296: CharacterCategory.lo,
  64298: CharacterCategory.lo,
  64299: CharacterCategory.lo,
  64300: CharacterCategory.lo,
  64301: CharacterCategory.lo,
  64302: CharacterCategory.lo,
  64303: CharacterCategory.lo,
  64304: CharacterCategory.lo,
  64305: CharacterCategory.lo,
  64306: CharacterCategory.lo,
  64307: CharacterCategory.lo,
  64308: CharacterCategory.lo,
  64309: CharacterCategory.lo,
  64310: CharacterCategory.lo,
  64312: CharacterCategory.lo,
  64313: CharacterCategory.lo,
  64314: CharacterCategory.lo,
  64315: CharacterCategory.lo,
  64316: CharacterCategory.lo,
  64318: CharacterCategory.lo,
  64320: CharacterCategory.lo,
  64321: CharacterCategory.lo,
  64323: CharacterCategory.lo,
  64324: CharacterCategory.lo,
  64326: CharacterCategory.lo,
  64327: CharacterCategory.lo,
  64328: CharacterCategory.lo,
  64329: CharacterCategory.lo,
  64330: CharacterCategory.lo,
  64331: CharacterCategory.lo,
  64332: CharacterCategory.lo,
  64333: CharacterCategory.lo,
  64334: CharacterCategory.lo,
  64335: CharacterCategory.lo,
  64336: CharacterCategory.lo,
  64337: CharacterCategory.lo,
  64338: CharacterCategory.lo,
  64339: CharacterCategory.lo,
  64340: CharacterCategory.lo,
  64341: CharacterCategory.lo,
  64342: CharacterCategory.lo,
  64343: CharacterCategory.lo,
  64344: CharacterCategory.lo,
  64345: CharacterCategory.lo,
  64346: CharacterCategory.lo,
  64347: CharacterCategory.lo,
  64348: CharacterCategory.lo,
  64349: CharacterCategory.lo,
  64350: CharacterCategory.lo,
  64351: CharacterCategory.lo,
  64352: CharacterCategory.lo,
  64353: CharacterCategory.lo,
  64354: CharacterCategory.lo,
  64355: CharacterCategory.lo,
  64356: CharacterCategory.lo,
  64357: CharacterCategory.lo,
  64358: CharacterCategory.lo,
  64359: CharacterCategory.lo,
  64360: CharacterCategory.lo,
  64361: CharacterCategory.lo,
  64362: CharacterCategory.lo,
  64363: CharacterCategory.lo,
  64364: CharacterCategory.lo,
  64365: CharacterCategory.lo,
  64366: CharacterCategory.lo,
  64367: CharacterCategory.lo,
  64368: CharacterCategory.lo,
  64369: CharacterCategory.lo,
  64370: CharacterCategory.lo,
  64371: CharacterCategory.lo,
  64372: CharacterCategory.lo,
  64373: CharacterCategory.lo,
  64374: CharacterCategory.lo,
  64375: CharacterCategory.lo,
  64376: CharacterCategory.lo,
  64377: CharacterCategory.lo,
  64378: CharacterCategory.lo,
  64379: CharacterCategory.lo,
  64380: CharacterCategory.lo,
  64381: CharacterCategory.lo,
  64382: CharacterCategory.lo,
  64383: CharacterCategory.lo,
  64384: CharacterCategory.lo,
  64385: CharacterCategory.lo,
  64386: CharacterCategory.lo,
  64387: CharacterCategory.lo,
  64388: CharacterCategory.lo,
  64389: CharacterCategory.lo,
  64390: CharacterCategory.lo,
  64391: CharacterCategory.lo,
  64392: CharacterCategory.lo,
  64393: CharacterCategory.lo,
  64394: CharacterCategory.lo,
  64395: CharacterCategory.lo,
  64396: CharacterCategory.lo,
  64397: CharacterCategory.lo,
  64398: CharacterCategory.lo,
  64399: CharacterCategory.lo,
  64400: CharacterCategory.lo,
  64401: CharacterCategory.lo,
  64402: CharacterCategory.lo,
  64403: CharacterCategory.lo,
  64404: CharacterCategory.lo,
  64405: CharacterCategory.lo,
  64406: CharacterCategory.lo,
  64407: CharacterCategory.lo,
  64408: CharacterCategory.lo,
  64409: CharacterCategory.lo,
  64410: CharacterCategory.lo,
  64411: CharacterCategory.lo,
  64412: CharacterCategory.lo,
  64413: CharacterCategory.lo,
  64414: CharacterCategory.lo,
  64415: CharacterCategory.lo,
  64416: CharacterCategory.lo,
  64417: CharacterCategory.lo,
  64418: CharacterCategory.lo,
  64419: CharacterCategory.lo,
  64420: CharacterCategory.lo,
  64421: CharacterCategory.lo,
  64422: CharacterCategory.lo,
  64423: CharacterCategory.lo,
  64424: CharacterCategory.lo,
  64425: CharacterCategory.lo,
  64426: CharacterCategory.lo,
  64427: CharacterCategory.lo,
  64428: CharacterCategory.lo,
  64429: CharacterCategory.lo,
  64430: CharacterCategory.lo,
  64431: CharacterCategory.lo,
  64432: CharacterCategory.lo,
  64433: CharacterCategory.lo,
  64467: CharacterCategory.lo,
  64468: CharacterCategory.lo,
  64469: CharacterCategory.lo,
  64470: CharacterCategory.lo,
  64471: CharacterCategory.lo,
  64472: CharacterCategory.lo,
  64473: CharacterCategory.lo,
  64474: CharacterCategory.lo,
  64475: CharacterCategory.lo,
  64476: CharacterCategory.lo,
  64477: CharacterCategory.lo,
  64478: CharacterCategory.lo,
  64479: CharacterCategory.lo,
  64480: CharacterCategory.lo,
  64481: CharacterCategory.lo,
  64482: CharacterCategory.lo,
  64483: CharacterCategory.lo,
  64484: CharacterCategory.lo,
  64485: CharacterCategory.lo,
  64486: CharacterCategory.lo,
  64487: CharacterCategory.lo,
  64488: CharacterCategory.lo,
  64489: CharacterCategory.lo,
  64490: CharacterCategory.lo,
  64491: CharacterCategory.lo,
  64492: CharacterCategory.lo,
  64493: CharacterCategory.lo,
  64494: CharacterCategory.lo,
  64495: CharacterCategory.lo,
  64496: CharacterCategory.lo,
  64497: CharacterCategory.lo,
  64498: CharacterCategory.lo,
  64499: CharacterCategory.lo,
  64500: CharacterCategory.lo,
  64501: CharacterCategory.lo,
  64502: CharacterCategory.lo,
  64503: CharacterCategory.lo,
  64504: CharacterCategory.lo,
  64505: CharacterCategory.lo,
  64506: CharacterCategory.lo,
  64507: CharacterCategory.lo,
  64508: CharacterCategory.lo,
  64509: CharacterCategory.lo,
  64510: CharacterCategory.lo,
  64511: CharacterCategory.lo,
  64512: CharacterCategory.lo,
  64513: CharacterCategory.lo,
  64514: CharacterCategory.lo,
  64515: CharacterCategory.lo,
  64516: CharacterCategory.lo,
  64517: CharacterCategory.lo,
  64518: CharacterCategory.lo,
  64519: CharacterCategory.lo,
  64520: CharacterCategory.lo,
  64521: CharacterCategory.lo,
  64522: CharacterCategory.lo,
  64523: CharacterCategory.lo,
  64524: CharacterCategory.lo,
  64525: CharacterCategory.lo,
  64526: CharacterCategory.lo,
  64527: CharacterCategory.lo,
  64528: CharacterCategory.lo,
  64529: CharacterCategory.lo,
  64530: CharacterCategory.lo,
  64531: CharacterCategory.lo,
  64532: CharacterCategory.lo,
  64533: CharacterCategory.lo,
  64534: CharacterCategory.lo,
  64535: CharacterCategory.lo,
  64536: CharacterCategory.lo,
  64537: CharacterCategory.lo,
  64538: CharacterCategory.lo,
  64539: CharacterCategory.lo,
  64540: CharacterCategory.lo,
  64541: CharacterCategory.lo,
  64542: CharacterCategory.lo,
  64543: CharacterCategory.lo,
  64544: CharacterCategory.lo,
  64545: CharacterCategory.lo,
  64546: CharacterCategory.lo,
  64547: CharacterCategory.lo,
  64548: CharacterCategory.lo,
  64549: CharacterCategory.lo,
  64550: CharacterCategory.lo,
  64551: CharacterCategory.lo,
  64552: CharacterCategory.lo,
  64553: CharacterCategory.lo,
  64554: CharacterCategory.lo,
  64555: CharacterCategory.lo,
  64556: CharacterCategory.lo,
  64557: CharacterCategory.lo,
  64558: CharacterCategory.lo,
  64559: CharacterCategory.lo,
  64560: CharacterCategory.lo,
  64561: CharacterCategory.lo,
  64562: CharacterCategory.lo,
  64563: CharacterCategory.lo,
  64564: CharacterCategory.lo,
  64565: CharacterCategory.lo,
  64566: CharacterCategory.lo,
  64567: CharacterCategory.lo,
  64568: CharacterCategory.lo,
  64569: CharacterCategory.lo,
  64570: CharacterCategory.lo,
  64571: CharacterCategory.lo,
  64572: CharacterCategory.lo,
  64573: CharacterCategory.lo,
  64574: CharacterCategory.lo,
  64575: CharacterCategory.lo,
  64576: CharacterCategory.lo,
  64577: CharacterCategory.lo,
  64578: CharacterCategory.lo,
  64579: CharacterCategory.lo,
  64580: CharacterCategory.lo,
  64581: CharacterCategory.lo,
  64582: CharacterCategory.lo,
  64583: CharacterCategory.lo,
  64584: CharacterCategory.lo,
  64585: CharacterCategory.lo,
  64586: CharacterCategory.lo,
  64587: CharacterCategory.lo,
  64588: CharacterCategory.lo,
  64589: CharacterCategory.lo,
  64590: CharacterCategory.lo,
  64591: CharacterCategory.lo,
  64592: CharacterCategory.lo,
  64593: CharacterCategory.lo,
  64594: CharacterCategory.lo,
  64595: CharacterCategory.lo,
  64596: CharacterCategory.lo,
  64597: CharacterCategory.lo,
  64598: CharacterCategory.lo,
  64599: CharacterCategory.lo,
  64600: CharacterCategory.lo,
  64601: CharacterCategory.lo,
  64602: CharacterCategory.lo,
  64603: CharacterCategory.lo,
  64604: CharacterCategory.lo,
  64605: CharacterCategory.lo,
  64606: CharacterCategory.cf,
  64607: CharacterCategory.cf,
  64608: CharacterCategory.cf,
  64609: CharacterCategory.cf,
  64610: CharacterCategory.cf,
  64611: CharacterCategory.cf,
  64612: CharacterCategory.cf,
  64613: CharacterCategory.lo,
  64614: CharacterCategory.lo,
  64615: CharacterCategory.lo,
  64616: CharacterCategory.lo,
  64617: CharacterCategory.lo,
  64618: CharacterCategory.lo,
  64619: CharacterCategory.lo,
  64620: CharacterCategory.lo,
  64621: CharacterCategory.lo,
  64622: CharacterCategory.lo,
  64623: CharacterCategory.lo,
  64624: CharacterCategory.lo,
  64625: CharacterCategory.lo,
  64626: CharacterCategory.lo,
  64627: CharacterCategory.lo,
  64628: CharacterCategory.lo,
  64629: CharacterCategory.lo,
  64630: CharacterCategory.lo,
  64631: CharacterCategory.lo,
  64632: CharacterCategory.lo,
  64633: CharacterCategory.lo,
  64634: CharacterCategory.lo,
  64635: CharacterCategory.lo,
  64636: CharacterCategory.lo,
  64637: CharacterCategory.lo,
  64638: CharacterCategory.lo,
  64639: CharacterCategory.lo,
  64640: CharacterCategory.lo,
  64641: CharacterCategory.lo,
  64642: CharacterCategory.lo,
  64643: CharacterCategory.lo,
  64644: CharacterCategory.lo,
  64645: CharacterCategory.lo,
  64646: CharacterCategory.lo,
  64647: CharacterCategory.lo,
  64648: CharacterCategory.lo,
  64649: CharacterCategory.lo,
  64650: CharacterCategory.lo,
  64651: CharacterCategory.lo,
  64652: CharacterCategory.lo,
  64653: CharacterCategory.lo,
  64654: CharacterCategory.lo,
  64655: CharacterCategory.lo,
  64656: CharacterCategory.lo,
  64657: CharacterCategory.lo,
  64658: CharacterCategory.lo,
  64659: CharacterCategory.lo,
  64660: CharacterCategory.lo,
  64661: CharacterCategory.lo,
  64662: CharacterCategory.lo,
  64663: CharacterCategory.lo,
  64664: CharacterCategory.lo,
  64665: CharacterCategory.lo,
  64666: CharacterCategory.lo,
  64667: CharacterCategory.lo,
  64668: CharacterCategory.lo,
  64669: CharacterCategory.lo,
  64670: CharacterCategory.lo,
  64671: CharacterCategory.lo,
  64672: CharacterCategory.lo,
  64673: CharacterCategory.lo,
  64674: CharacterCategory.lo,
  64675: CharacterCategory.lo,
  64676: CharacterCategory.lo,
  64677: CharacterCategory.lo,
  64678: CharacterCategory.lo,
  64679: CharacterCategory.lo,
  64680: CharacterCategory.lo,
  64681: CharacterCategory.lo,
  64682: CharacterCategory.lo,
  64683: CharacterCategory.lo,
  64684: CharacterCategory.lo,
  64685: CharacterCategory.lo,
  64686: CharacterCategory.lo,
  64687: CharacterCategory.lo,
  64688: CharacterCategory.lo,
  64689: CharacterCategory.lo,
  64690: CharacterCategory.lo,
  64691: CharacterCategory.lo,
  64692: CharacterCategory.lo,
  64693: CharacterCategory.lo,
  64694: CharacterCategory.lo,
  64695: CharacterCategory.lo,
  64696: CharacterCategory.lo,
  64697: CharacterCategory.lo,
  64698: CharacterCategory.lo,
  64699: CharacterCategory.lo,
  64700: CharacterCategory.lo,
  64701: CharacterCategory.lo,
  64702: CharacterCategory.lo,
  64703: CharacterCategory.lo,
  64704: CharacterCategory.lo,
  64705: CharacterCategory.lo,
  64706: CharacterCategory.lo,
  64707: CharacterCategory.lo,
  64708: CharacterCategory.lo,
  64709: CharacterCategory.lo,
  64710: CharacterCategory.lo,
  64711: CharacterCategory.lo,
  64712: CharacterCategory.lo,
  64713: CharacterCategory.lo,
  64714: CharacterCategory.lo,
  64715: CharacterCategory.lo,
  64716: CharacterCategory.lo,
  64717: CharacterCategory.lo,
  64718: CharacterCategory.lo,
  64719: CharacterCategory.lo,
  64720: CharacterCategory.lo,
  64721: CharacterCategory.lo,
  64722: CharacterCategory.lo,
  64723: CharacterCategory.lo,
  64724: CharacterCategory.lo,
  64725: CharacterCategory.lo,
  64726: CharacterCategory.lo,
  64727: CharacterCategory.lo,
  64728: CharacterCategory.lo,
  64729: CharacterCategory.lo,
  64730: CharacterCategory.lo,
  64731: CharacterCategory.lo,
  64732: CharacterCategory.lo,
  64733: CharacterCategory.lo,
  64734: CharacterCategory.lo,
  64735: CharacterCategory.lo,
  64736: CharacterCategory.lo,
  64737: CharacterCategory.lo,
  64738: CharacterCategory.lo,
  64739: CharacterCategory.lo,
  64740: CharacterCategory.lo,
  64741: CharacterCategory.lo,
  64742: CharacterCategory.lo,
  64743: CharacterCategory.lo,
  64744: CharacterCategory.lo,
  64745: CharacterCategory.lo,
  64746: CharacterCategory.lo,
  64747: CharacterCategory.lo,
  64748: CharacterCategory.lo,
  64749: CharacterCategory.lo,
  64750: CharacterCategory.lo,
  64751: CharacterCategory.lo,
  64752: CharacterCategory.lo,
  64753: CharacterCategory.lo,
  64754: CharacterCategory.lo,
  64755: CharacterCategory.lo,
  64756: CharacterCategory.lo,
  64757: CharacterCategory.lo,
  64758: CharacterCategory.lo,
  64759: CharacterCategory.lo,
  64760: CharacterCategory.lo,
  64761: CharacterCategory.lo,
  64762: CharacterCategory.lo,
  64763: CharacterCategory.lo,
  64764: CharacterCategory.lo,
  64765: CharacterCategory.lo,
  64766: CharacterCategory.lo,
  64767: CharacterCategory.lo,
  64768: CharacterCategory.lo,
  64769: CharacterCategory.lo,
  64770: CharacterCategory.lo,
  64771: CharacterCategory.lo,
  64772: CharacterCategory.lo,
  64773: CharacterCategory.lo,
  64774: CharacterCategory.lo,
  64775: CharacterCategory.lo,
  64776: CharacterCategory.lo,
  64777: CharacterCategory.lo,
  64778: CharacterCategory.lo,
  64779: CharacterCategory.lo,
  64780: CharacterCategory.lo,
  64781: CharacterCategory.lo,
  64782: CharacterCategory.lo,
  64783: CharacterCategory.lo,
  64784: CharacterCategory.lo,
  64785: CharacterCategory.lo,
  64786: CharacterCategory.lo,
  64787: CharacterCategory.lo,
  64788: CharacterCategory.lo,
  64789: CharacterCategory.lo,
  64790: CharacterCategory.lo,
  64791: CharacterCategory.lo,
  64792: CharacterCategory.lo,
  64793: CharacterCategory.lo,
  64794: CharacterCategory.lo,
  64795: CharacterCategory.lo,
  64796: CharacterCategory.lo,
  64797: CharacterCategory.lo,
  64798: CharacterCategory.lo,
  64799: CharacterCategory.lo,
  64800: CharacterCategory.lo,
  64801: CharacterCategory.lo,
  64802: CharacterCategory.lo,
  64803: CharacterCategory.lo,
  64804: CharacterCategory.lo,
  64805: CharacterCategory.lo,
  64806: CharacterCategory.lo,
  64807: CharacterCategory.lo,
  64808: CharacterCategory.lo,
  64809: CharacterCategory.lo,
  64810: CharacterCategory.lo,
  64811: CharacterCategory.lo,
  64812: CharacterCategory.lo,
  64813: CharacterCategory.lo,
  64814: CharacterCategory.lo,
  64815: CharacterCategory.lo,
  64816: CharacterCategory.lo,
  64817: CharacterCategory.lo,
  64818: CharacterCategory.lo,
  64819: CharacterCategory.lo,
  64820: CharacterCategory.lo,
  64821: CharacterCategory.lo,
  64822: CharacterCategory.lo,
  64823: CharacterCategory.lo,
  64824: CharacterCategory.lo,
  64825: CharacterCategory.lo,
  64826: CharacterCategory.lo,
  64827: CharacterCategory.lo,
  64828: CharacterCategory.lo,
  64829: CharacterCategory.lo,
  64848: CharacterCategory.lo,
  64849: CharacterCategory.lo,
  64850: CharacterCategory.lo,
  64851: CharacterCategory.lo,
  64852: CharacterCategory.lo,
  64853: CharacterCategory.lo,
  64854: CharacterCategory.lo,
  64855: CharacterCategory.lo,
  64856: CharacterCategory.lo,
  64857: CharacterCategory.lo,
  64858: CharacterCategory.lo,
  64859: CharacterCategory.lo,
  64860: CharacterCategory.lo,
  64861: CharacterCategory.lo,
  64862: CharacterCategory.lo,
  64863: CharacterCategory.lo,
  64864: CharacterCategory.lo,
  64865: CharacterCategory.lo,
  64866: CharacterCategory.lo,
  64867: CharacterCategory.lo,
  64868: CharacterCategory.lo,
  64869: CharacterCategory.lo,
  64870: CharacterCategory.lo,
  64871: CharacterCategory.lo,
  64872: CharacterCategory.lo,
  64873: CharacterCategory.lo,
  64874: CharacterCategory.lo,
  64875: CharacterCategory.lo,
  64876: CharacterCategory.lo,
  64877: CharacterCategory.lo,
  64878: CharacterCategory.lo,
  64879: CharacterCategory.lo,
  64880: CharacterCategory.lo,
  64881: CharacterCategory.lo,
  64882: CharacterCategory.lo,
  64883: CharacterCategory.lo,
  64884: CharacterCategory.lo,
  64885: CharacterCategory.lo,
  64886: CharacterCategory.lo,
  64887: CharacterCategory.lo,
  64888: CharacterCategory.lo,
  64889: CharacterCategory.lo,
  64890: CharacterCategory.lo,
  64891: CharacterCategory.lo,
  64892: CharacterCategory.lo,
  64893: CharacterCategory.lo,
  64894: CharacterCategory.lo,
  64895: CharacterCategory.lo,
  64896: CharacterCategory.lo,
  64897: CharacterCategory.lo,
  64898: CharacterCategory.lo,
  64899: CharacterCategory.lo,
  64900: CharacterCategory.lo,
  64901: CharacterCategory.lo,
  64902: CharacterCategory.lo,
  64903: CharacterCategory.lo,
  64904: CharacterCategory.lo,
  64905: CharacterCategory.lo,
  64906: CharacterCategory.lo,
  64907: CharacterCategory.lo,
  64908: CharacterCategory.lo,
  64909: CharacterCategory.lo,
  64910: CharacterCategory.lo,
  64911: CharacterCategory.lo,
  64914: CharacterCategory.lo,
  64915: CharacterCategory.lo,
  64916: CharacterCategory.lo,
  64917: CharacterCategory.lo,
  64918: CharacterCategory.lo,
  64919: CharacterCategory.lo,
  64920: CharacterCategory.lo,
  64921: CharacterCategory.lo,
  64922: CharacterCategory.lo,
  64923: CharacterCategory.lo,
  64924: CharacterCategory.lo,
  64925: CharacterCategory.lo,
  64926: CharacterCategory.lo,
  64927: CharacterCategory.lo,
  64928: CharacterCategory.lo,
  64929: CharacterCategory.lo,
  64930: CharacterCategory.lo,
  64931: CharacterCategory.lo,
  64932: CharacterCategory.lo,
  64933: CharacterCategory.lo,
  64934: CharacterCategory.lo,
  64935: CharacterCategory.lo,
  64936: CharacterCategory.lo,
  64937: CharacterCategory.lo,
  64938: CharacterCategory.lo,
  64939: CharacterCategory.lo,
  64940: CharacterCategory.lo,
  64941: CharacterCategory.lo,
  64942: CharacterCategory.lo,
  64943: CharacterCategory.lo,
  64944: CharacterCategory.lo,
  64945: CharacterCategory.lo,
  64946: CharacterCategory.lo,
  64947: CharacterCategory.lo,
  64948: CharacterCategory.lo,
  64949: CharacterCategory.lo,
  64950: CharacterCategory.lo,
  64951: CharacterCategory.lo,
  64952: CharacterCategory.lo,
  64953: CharacterCategory.lo,
  64954: CharacterCategory.lo,
  64955: CharacterCategory.lo,
  64956: CharacterCategory.lo,
  64957: CharacterCategory.lo,
  64958: CharacterCategory.lo,
  64959: CharacterCategory.lo,
  64960: CharacterCategory.lo,
  64961: CharacterCategory.lo,
  64962: CharacterCategory.lo,
  64963: CharacterCategory.lo,
  64964: CharacterCategory.lo,
  64965: CharacterCategory.lo,
  64966: CharacterCategory.lo,
  64967: CharacterCategory.lo,
  65008: CharacterCategory.lo,
  65009: CharacterCategory.lo,
  65010: CharacterCategory.lo,
  65011: CharacterCategory.lo,
  65012: CharacterCategory.lo,
  65013: CharacterCategory.lo,
  65014: CharacterCategory.lo,
  65015: CharacterCategory.lo,
  65016: CharacterCategory.lo,
  65017: CharacterCategory.lo,
  65018: CharacterCategory.lo,
  65019: CharacterCategory.lo,
  65136: CharacterCategory.lo,
  65137: CharacterCategory.lo,
  65138: CharacterCategory.lo,
  65139: CharacterCategory.lo,
  65140: CharacterCategory.lo,
  65142: CharacterCategory.lo,
  65143: CharacterCategory.lo,
  65144: CharacterCategory.lo,
  65145: CharacterCategory.lo,
  65146: CharacterCategory.lo,
  65147: CharacterCategory.lo,
  65148: CharacterCategory.lo,
  65149: CharacterCategory.lo,
  65150: CharacterCategory.lo,
  65151: CharacterCategory.lo,
  65152: CharacterCategory.lo,
  65153: CharacterCategory.lo,
  65154: CharacterCategory.lo,
  65155: CharacterCategory.lo,
  65156: CharacterCategory.lo,
  65157: CharacterCategory.lo,
  65158: CharacterCategory.lo,
  65159: CharacterCategory.lo,
  65160: CharacterCategory.lo,
  65161: CharacterCategory.lo,
  65162: CharacterCategory.lo,
  65163: CharacterCategory.lo,
  65164: CharacterCategory.lo,
  65165: CharacterCategory.lo,
  65166: CharacterCategory.lo,
  65167: CharacterCategory.lo,
  65168: CharacterCategory.lo,
  65169: CharacterCategory.lo,
  65170: CharacterCategory.lo,
  65171: CharacterCategory.lo,
  65172: CharacterCategory.lo,
  65173: CharacterCategory.lo,
  65174: CharacterCategory.lo,
  65175: CharacterCategory.lo,
  65176: CharacterCategory.lo,
  65177: CharacterCategory.lo,
  65178: CharacterCategory.lo,
  65179: CharacterCategory.lo,
  65180: CharacterCategory.lo,
  65181: CharacterCategory.lo,
  65182: CharacterCategory.lo,
  65183: CharacterCategory.lo,
  65184: CharacterCategory.lo,
  65185: CharacterCategory.lo,
  65186: CharacterCategory.lo,
  65187: CharacterCategory.lo,
  65188: CharacterCategory.lo,
  65189: CharacterCategory.lo,
  65190: CharacterCategory.lo,
  65191: CharacterCategory.lo,
  65192: CharacterCategory.lo,
  65193: CharacterCategory.lo,
  65194: CharacterCategory.lo,
  65195: CharacterCategory.lo,
  65196: CharacterCategory.lo,
  65197: CharacterCategory.lo,
  65198: CharacterCategory.lo,
  65199: CharacterCategory.lo,
  65200: CharacterCategory.lo,
  65201: CharacterCategory.lo,
  65202: CharacterCategory.lo,
  65203: CharacterCategory.lo,
  65204: CharacterCategory.lo,
  65205: CharacterCategory.lo,
  65206: CharacterCategory.lo,
  65207: CharacterCategory.lo,
  65208: CharacterCategory.lo,
  65209: CharacterCategory.lo,
  65210: CharacterCategory.lo,
  65211: CharacterCategory.lo,
  65212: CharacterCategory.lo,
  65213: CharacterCategory.lo,
  65214: CharacterCategory.lo,
  65215: CharacterCategory.lo,
  65216: CharacterCategory.lo,
  65217: CharacterCategory.lo,
  65218: CharacterCategory.lo,
  65219: CharacterCategory.lo,
  65220: CharacterCategory.lo,
  65221: CharacterCategory.lo,
  65222: CharacterCategory.lo,
  65223: CharacterCategory.lo,
  65224: CharacterCategory.lo,
  65225: CharacterCategory.lo,
  65226: CharacterCategory.lo,
  65227: CharacterCategory.lo,
  65228: CharacterCategory.lo,
  65229: CharacterCategory.lo,
  65230: CharacterCategory.lo,
  65231: CharacterCategory.lo,
  65232: CharacterCategory.lo,
  65233: CharacterCategory.lo,
  65234: CharacterCategory.lo,
  65235: CharacterCategory.lo,
  65236: CharacterCategory.lo,
  65237: CharacterCategory.lo,
  65238: CharacterCategory.lo,
  65239: CharacterCategory.lo,
  65240: CharacterCategory.lo,
  65241: CharacterCategory.lo,
  65242: CharacterCategory.lo,
  65243: CharacterCategory.lo,
  65244: CharacterCategory.lo,
  65245: CharacterCategory.lo,
  65246: CharacterCategory.lo,
  65247: CharacterCategory.lo,
  65248: CharacterCategory.lo,
  65249: CharacterCategory.lo,
  65250: CharacterCategory.lo,
  65251: CharacterCategory.lo,
  65252: CharacterCategory.lo,
  65253: CharacterCategory.lo,
  65254: CharacterCategory.lo,
  65255: CharacterCategory.lo,
  65256: CharacterCategory.lo,
  65257: CharacterCategory.lo,
  65258: CharacterCategory.lo,
  65259: CharacterCategory.lo,
  65260: CharacterCategory.lo,
  65261: CharacterCategory.lo,
  65262: CharacterCategory.lo,
  65263: CharacterCategory.lo,
  65264: CharacterCategory.lo,
  65265: CharacterCategory.lo,
  65266: CharacterCategory.lo,
  65267: CharacterCategory.lo,
  65268: CharacterCategory.lo,
  65269: CharacterCategory.lo,
  65270: CharacterCategory.lo,
  65271: CharacterCategory.lo,
  65272: CharacterCategory.lo,
  65273: CharacterCategory.lo,
  65274: CharacterCategory.lo,
  65275: CharacterCategory.lo,
  65276: CharacterCategory.lo,
  65382: CharacterCategory.lo,
  65383: CharacterCategory.lo,
  65384: CharacterCategory.lo,
  65385: CharacterCategory.lo,
  65386: CharacterCategory.lo,
  65387: CharacterCategory.lo,
  65388: CharacterCategory.lo,
  65389: CharacterCategory.lo,
  65390: CharacterCategory.lo,
  65391: CharacterCategory.lo,
  65393: CharacterCategory.lo,
  65394: CharacterCategory.lo,
  65395: CharacterCategory.lo,
  65396: CharacterCategory.lo,
  65397: CharacterCategory.lo,
  65398: CharacterCategory.lo,
  65399: CharacterCategory.lo,
  65400: CharacterCategory.lo,
  65401: CharacterCategory.lo,
  65402: CharacterCategory.lo,
  65403: CharacterCategory.lo,
  65404: CharacterCategory.lo,
  65405: CharacterCategory.lo,
  65406: CharacterCategory.lo,
  65407: CharacterCategory.lo,
  65408: CharacterCategory.lo,
  65409: CharacterCategory.lo,
  65410: CharacterCategory.lo,
  65411: CharacterCategory.lo,
  65412: CharacterCategory.lo,
  65413: CharacterCategory.lo,
  65414: CharacterCategory.lo,
  65415: CharacterCategory.lo,
  65416: CharacterCategory.lo,
  65417: CharacterCategory.lo,
  65418: CharacterCategory.lo,
  65419: CharacterCategory.lo,
  65420: CharacterCategory.lo,
  65421: CharacterCategory.lo,
  65422: CharacterCategory.lo,
  65423: CharacterCategory.lo,
  65424: CharacterCategory.lo,
  65425: CharacterCategory.lo,
  65426: CharacterCategory.lo,
  65427: CharacterCategory.lo,
  65428: CharacterCategory.lo,
  65429: CharacterCategory.lo,
  65430: CharacterCategory.lo,
  65431: CharacterCategory.lo,
  65432: CharacterCategory.lo,
  65433: CharacterCategory.lo,
  65434: CharacterCategory.lo,
  65435: CharacterCategory.lo,
  65436: CharacterCategory.lo,
  65437: CharacterCategory.lo,
  65440: CharacterCategory.lo,
  65441: CharacterCategory.lo,
  65442: CharacterCategory.lo,
  65443: CharacterCategory.lo,
  65444: CharacterCategory.lo,
  65445: CharacterCategory.lo,
  65446: CharacterCategory.lo,
  65447: CharacterCategory.lo,
  65448: CharacterCategory.lo,
  65449: CharacterCategory.lo,
  65450: CharacterCategory.lo,
  65451: CharacterCategory.lo,
  65452: CharacterCategory.lo,
  65453: CharacterCategory.lo,
  65454: CharacterCategory.lo,
  65455: CharacterCategory.lo,
  65456: CharacterCategory.lo,
  65457: CharacterCategory.lo,
  65458: CharacterCategory.lo,
  65459: CharacterCategory.lo,
  65460: CharacterCategory.lo,
  65461: CharacterCategory.lo,
  65462: CharacterCategory.lo,
  65463: CharacterCategory.lo,
  65464: CharacterCategory.lo,
  65465: CharacterCategory.lo,
  65466: CharacterCategory.lo,
  65467: CharacterCategory.lo,
  65468: CharacterCategory.lo,
  65469: CharacterCategory.lo,
  65470: CharacterCategory.lo,
  65474: CharacterCategory.lo,
  65475: CharacterCategory.lo,
  65476: CharacterCategory.lo,
  65477: CharacterCategory.lo,
  65478: CharacterCategory.lo,
  65479: CharacterCategory.lo,
  65482: CharacterCategory.lo,
  65483: CharacterCategory.lo,
  65484: CharacterCategory.lo,
  65485: CharacterCategory.lo,
  65486: CharacterCategory.lo,
  65487: CharacterCategory.lo,
  65490: CharacterCategory.lo,
  65491: CharacterCategory.lo,
  65492: CharacterCategory.lo,
  65493: CharacterCategory.lo,
  65494: CharacterCategory.lo,
  65495: CharacterCategory.lo,
  65498: CharacterCategory.lo,
  65499: CharacterCategory.lo,
  65500: CharacterCategory.lo,
  768: CharacterCategory.mn,
  769: CharacterCategory.mn,
  770: CharacterCategory.mn,
  771: CharacterCategory.mn,
  772: CharacterCategory.mn,
  773: CharacterCategory.mn,
  774: CharacterCategory.mn,
  775: CharacterCategory.mn,
  776: CharacterCategory.mn,
  777: CharacterCategory.mn,
  778: CharacterCategory.mn,
  779: CharacterCategory.mn,
  780: CharacterCategory.mn,
  781: CharacterCategory.mn,
  782: CharacterCategory.mn,
  783: CharacterCategory.mn,
  784: CharacterCategory.mn,
  785: CharacterCategory.mn,
  786: CharacterCategory.mn,
  787: CharacterCategory.mn,
  788: CharacterCategory.mn,
  789: CharacterCategory.mn,
  790: CharacterCategory.mn,
  791: CharacterCategory.mn,
  792: CharacterCategory.mn,
  793: CharacterCategory.mn,
  794: CharacterCategory.mn,
  795: CharacterCategory.mn,
  796: CharacterCategory.mn,
  797: CharacterCategory.mn,
  798: CharacterCategory.mn,
  799: CharacterCategory.mn,
  800: CharacterCategory.mn,
  801: CharacterCategory.mn,
  802: CharacterCategory.mn,
  803: CharacterCategory.mn,
  804: CharacterCategory.mn,
  805: CharacterCategory.mn,
  806: CharacterCategory.mn,
  807: CharacterCategory.mn,
  808: CharacterCategory.mn,
  809: CharacterCategory.mn,
  810: CharacterCategory.mn,
  811: CharacterCategory.mn,
  812: CharacterCategory.mn,
  813: CharacterCategory.mn,
  814: CharacterCategory.mn,
  815: CharacterCategory.mn,
  816: CharacterCategory.mn,
  817: CharacterCategory.mn,
  818: CharacterCategory.mn,
  819: CharacterCategory.mn,
  820: CharacterCategory.mn,
  821: CharacterCategory.mn,
  822: CharacterCategory.mn,
  823: CharacterCategory.mn,
  824: CharacterCategory.mn,
  825: CharacterCategory.mn,
  826: CharacterCategory.mn,
  827: CharacterCategory.mn,
  828: CharacterCategory.mn,
  829: CharacterCategory.mn,
  830: CharacterCategory.mn,
  831: CharacterCategory.mn,
  832: CharacterCategory.mn,
  833: CharacterCategory.mn,
  834: CharacterCategory.mn,
  835: CharacterCategory.mn,
  836: CharacterCategory.mn,
  837: CharacterCategory.mn,
  838: CharacterCategory.mn,
  839: CharacterCategory.mn,
  840: CharacterCategory.mn,
  841: CharacterCategory.mn,
  842: CharacterCategory.mn,
  843: CharacterCategory.mn,
  844: CharacterCategory.mn,
  845: CharacterCategory.mn,
  846: CharacterCategory.mn,
  847: CharacterCategory.mn,
  848: CharacterCategory.mn,
  849: CharacterCategory.mn,
  850: CharacterCategory.mn,
  851: CharacterCategory.mn,
  852: CharacterCategory.mn,
  853: CharacterCategory.mn,
  854: CharacterCategory.mn,
  855: CharacterCategory.mn,
  856: CharacterCategory.mn,
  857: CharacterCategory.mn,
  858: CharacterCategory.mn,
  859: CharacterCategory.mn,
  860: CharacterCategory.mn,
  861: CharacterCategory.mn,
  862: CharacterCategory.mn,
  863: CharacterCategory.mn,
  864: CharacterCategory.mn,
  865: CharacterCategory.mn,
  866: CharacterCategory.mn,
  867: CharacterCategory.mn,
  868: CharacterCategory.mn,
  869: CharacterCategory.mn,
  870: CharacterCategory.mn,
  871: CharacterCategory.mn,
  872: CharacterCategory.mn,
  873: CharacterCategory.mn,
  874: CharacterCategory.mn,
  875: CharacterCategory.mn,
  876: CharacterCategory.mn,
  877: CharacterCategory.mn,
  878: CharacterCategory.mn,
  879: CharacterCategory.mn,
  1155: CharacterCategory.mn,
  1156: CharacterCategory.mn,
  1157: CharacterCategory.mn,
  1158: CharacterCategory.mn,
  1159: CharacterCategory.mn,
  1425: CharacterCategory.mn,
  1426: CharacterCategory.mn,
  1427: CharacterCategory.mn,
  1428: CharacterCategory.mn,
  1429: CharacterCategory.mn,
  1430: CharacterCategory.mn,
  1431: CharacterCategory.mn,
  1432: CharacterCategory.mn,
  1433: CharacterCategory.mn,
  1434: CharacterCategory.mn,
  1435: CharacterCategory.mn,
  1436: CharacterCategory.mn,
  1437: CharacterCategory.mn,
  1438: CharacterCategory.mn,
  1439: CharacterCategory.mn,
  1440: CharacterCategory.mn,
  1441: CharacterCategory.mn,
  1442: CharacterCategory.mn,
  1443: CharacterCategory.mn,
  1444: CharacterCategory.mn,
  1445: CharacterCategory.mn,
  1446: CharacterCategory.mn,
  1447: CharacterCategory.mn,
  1448: CharacterCategory.mn,
  1449: CharacterCategory.mn,
  1450: CharacterCategory.mn,
  1451: CharacterCategory.mn,
  1452: CharacterCategory.mn,
  1453: CharacterCategory.mn,
  1454: CharacterCategory.mn,
  1455: CharacterCategory.mn,
  1456: CharacterCategory.mn,
  1457: CharacterCategory.mn,
  1458: CharacterCategory.mn,
  1459: CharacterCategory.mn,
  1460: CharacterCategory.mn,
  1461: CharacterCategory.mn,
  1462: CharacterCategory.mn,
  1463: CharacterCategory.mn,
  1464: CharacterCategory.mn,
  1465: CharacterCategory.mn,
  1466: CharacterCategory.mn,
  1467: CharacterCategory.mn,
  1468: CharacterCategory.mn,
  1469: CharacterCategory.mn,
  1471: CharacterCategory.mn,
  1473: CharacterCategory.mn,
  1474: CharacterCategory.mn,
  1476: CharacterCategory.mn,
  1477: CharacterCategory.mn,
  1479: CharacterCategory.mn,
  1552: CharacterCategory.mn,
  1553: CharacterCategory.mn,
  1554: CharacterCategory.mn,
  1555: CharacterCategory.mn,
  1556: CharacterCategory.mn,
  1557: CharacterCategory.mn,
  1558: CharacterCategory.mn,
  1559: CharacterCategory.mn,
  1560: CharacterCategory.mn,
  1561: CharacterCategory.mn,
  1562: CharacterCategory.mn,
  1611: CharacterCategory.mn,
  1612: CharacterCategory.mn,
  1613: CharacterCategory.mn,
  1614: CharacterCategory.mn,
  1615: CharacterCategory.mn,
  1616: CharacterCategory.mn,
  1617: CharacterCategory.mn,
  1618: CharacterCategory.mn,
  1619: CharacterCategory.mn,
  1620: CharacterCategory.mn,
  1621: CharacterCategory.mn,
  1622: CharacterCategory.mn,
  1623: CharacterCategory.mn,
  1624: CharacterCategory.mn,
  1625: CharacterCategory.mn,
  1626: CharacterCategory.mn,
  1627: CharacterCategory.mn,
  1628: CharacterCategory.mn,
  1629: CharacterCategory.mn,
  1630: CharacterCategory.mn,
  1631: CharacterCategory.mn,
  1648: CharacterCategory.mn,
  1750: CharacterCategory.mn,
  1751: CharacterCategory.mn,
  1752: CharacterCategory.mn,
  1753: CharacterCategory.mn,
  1754: CharacterCategory.mn,
  1755: CharacterCategory.mn,
  1756: CharacterCategory.mn,
  1759: CharacterCategory.mn,
  1760: CharacterCategory.mn,
  1761: CharacterCategory.mn,
  1762: CharacterCategory.mn,
  1763: CharacterCategory.mn,
  1764: CharacterCategory.mn,
  1767: CharacterCategory.mn,
  1768: CharacterCategory.mn,
  1770: CharacterCategory.mn,
  1771: CharacterCategory.mn,
  1772: CharacterCategory.mn,
  1773: CharacterCategory.mn,
  1809: CharacterCategory.mn,
  1840: CharacterCategory.mn,
  1841: CharacterCategory.mn,
  1842: CharacterCategory.mn,
  1843: CharacterCategory.mn,
  1844: CharacterCategory.mn,
  1845: CharacterCategory.mn,
  1846: CharacterCategory.mn,
  1847: CharacterCategory.mn,
  1848: CharacterCategory.mn,
  1849: CharacterCategory.mn,
  1850: CharacterCategory.mn,
  1851: CharacterCategory.mn,
  1852: CharacterCategory.mn,
  1853: CharacterCategory.mn,
  1854: CharacterCategory.mn,
  1855: CharacterCategory.mn,
  1856: CharacterCategory.mn,
  1857: CharacterCategory.mn,
  1858: CharacterCategory.mn,
  1859: CharacterCategory.mn,
  1860: CharacterCategory.mn,
  1861: CharacterCategory.mn,
  1862: CharacterCategory.mn,
  1863: CharacterCategory.mn,
  1864: CharacterCategory.mn,
  1865: CharacterCategory.mn,
  1866: CharacterCategory.mn,
  1958: CharacterCategory.mn,
  1959: CharacterCategory.mn,
  1960: CharacterCategory.mn,
  1961: CharacterCategory.mn,
  1962: CharacterCategory.mn,
  1963: CharacterCategory.mn,
  1964: CharacterCategory.mn,
  1965: CharacterCategory.mn,
  1966: CharacterCategory.mn,
  1967: CharacterCategory.mn,
  1968: CharacterCategory.mn,
  2027: CharacterCategory.mn,
  2028: CharacterCategory.mn,
  2029: CharacterCategory.mn,
  2030: CharacterCategory.mn,
  2031: CharacterCategory.mn,
  2032: CharacterCategory.mn,
  2033: CharacterCategory.mn,
  2034: CharacterCategory.mn,
  2035: CharacterCategory.mn,
  2070: CharacterCategory.mn,
  2071: CharacterCategory.mn,
  2072: CharacterCategory.mn,
  2073: CharacterCategory.mn,
  2075: CharacterCategory.mn,
  2076: CharacterCategory.mn,
  2077: CharacterCategory.mn,
  2078: CharacterCategory.mn,
  2079: CharacterCategory.mn,
  2080: CharacterCategory.mn,
  2081: CharacterCategory.mn,
  2082: CharacterCategory.mn,
  2083: CharacterCategory.mn,
  2085: CharacterCategory.mn,
  2086: CharacterCategory.mn,
  2087: CharacterCategory.mn,
  2089: CharacterCategory.mn,
  2090: CharacterCategory.mn,
  2091: CharacterCategory.mn,
  2092: CharacterCategory.mn,
  2093: CharacterCategory.mn,
  2137: CharacterCategory.mn,
  2138: CharacterCategory.mn,
  2139: CharacterCategory.mn,
  2276: CharacterCategory.mn,
  2277: CharacterCategory.mn,
  2278: CharacterCategory.mn,
  2279: CharacterCategory.mn,
  2280: CharacterCategory.mn,
  2281: CharacterCategory.mn,
  2282: CharacterCategory.mn,
  2283: CharacterCategory.mn,
  2284: CharacterCategory.mn,
  2285: CharacterCategory.mn,
  2286: CharacterCategory.mn,
  2287: CharacterCategory.mn,
  2288: CharacterCategory.mn,
  2289: CharacterCategory.mn,
  2290: CharacterCategory.mn,
  2291: CharacterCategory.mn,
  2292: CharacterCategory.mn,
  2293: CharacterCategory.mn,
  2294: CharacterCategory.mn,
  2295: CharacterCategory.mn,
  2296: CharacterCategory.mn,
  2297: CharacterCategory.mn,
  2298: CharacterCategory.mn,
  2299: CharacterCategory.mn,
  2300: CharacterCategory.mn,
  2301: CharacterCategory.mn,
  2302: CharacterCategory.mn,
  2303: CharacterCategory.mn,
  2304: CharacterCategory.mn,
  2305: CharacterCategory.mn,
  2306: CharacterCategory.mn,
  2362: CharacterCategory.mn,
  2364: CharacterCategory.mn,
  2369: CharacterCategory.mn,
  2370: CharacterCategory.mn,
  2371: CharacterCategory.mn,
  2372: CharacterCategory.mn,
  2373: CharacterCategory.mn,
  2374: CharacterCategory.mn,
  2375: CharacterCategory.mn,
  2376: CharacterCategory.mn,
  2381: CharacterCategory.mn,
  2385: CharacterCategory.mn,
  2386: CharacterCategory.mn,
  2387: CharacterCategory.mn,
  2388: CharacterCategory.mn,
  2389: CharacterCategory.mn,
  2390: CharacterCategory.mn,
  2391: CharacterCategory.mn,
  2402: CharacterCategory.mn,
  2403: CharacterCategory.mn,
  2433: CharacterCategory.mn,
  2492: CharacterCategory.mn,
  2497: CharacterCategory.mn,
  2498: CharacterCategory.mn,
  2499: CharacterCategory.mn,
  2500: CharacterCategory.mn,
  2509: CharacterCategory.mn,
  2530: CharacterCategory.mn,
  2531: CharacterCategory.mn,
  2561: CharacterCategory.mn,
  2562: CharacterCategory.mn,
  2620: CharacterCategory.mn,
  2625: CharacterCategory.mn,
  2626: CharacterCategory.mn,
  2631: CharacterCategory.mn,
  2632: CharacterCategory.mn,
  2635: CharacterCategory.mn,
  2636: CharacterCategory.mn,
  2637: CharacterCategory.mn,
  2641: CharacterCategory.mn,
  2672: CharacterCategory.mn,
  2673: CharacterCategory.mn,
  2677: CharacterCategory.mn,
  2689: CharacterCategory.mn,
  2690: CharacterCategory.mn,
  2748: CharacterCategory.mn,
  2753: CharacterCategory.mn,
  2754: CharacterCategory.mn,
  2755: CharacterCategory.mn,
  2756: CharacterCategory.mn,
  2757: CharacterCategory.mn,
  2759: CharacterCategory.mn,
  2760: CharacterCategory.mn,
  2765: CharacterCategory.mn,
  2786: CharacterCategory.mn,
  2787: CharacterCategory.mn,
  2817: CharacterCategory.mn,
  2876: CharacterCategory.mn,
  2879: CharacterCategory.mn,
  2881: CharacterCategory.mn,
  2882: CharacterCategory.mn,
  2883: CharacterCategory.mn,
  2884: CharacterCategory.mn,
  2893: CharacterCategory.mn,
  2902: CharacterCategory.mn,
  2914: CharacterCategory.mn,
  2915: CharacterCategory.mn,
  2946: CharacterCategory.mn,
  3008: CharacterCategory.mn,
  3021: CharacterCategory.mn,
  3072: CharacterCategory.mn,
  3134: CharacterCategory.mn,
  3135: CharacterCategory.mn,
  3136: CharacterCategory.mn,
  3142: CharacterCategory.mn,
  3143: CharacterCategory.mn,
  3144: CharacterCategory.mn,
  3146: CharacterCategory.mn,
  3147: CharacterCategory.mn,
  3148: CharacterCategory.mn,
  3149: CharacterCategory.mn,
  3157: CharacterCategory.mn,
  3158: CharacterCategory.mn,
  3170: CharacterCategory.mn,
  3171: CharacterCategory.mn,
  3201: CharacterCategory.mn,
  3260: CharacterCategory.mn,
  3263: CharacterCategory.mn,
  3270: CharacterCategory.mn,
  3276: CharacterCategory.mn,
  3277: CharacterCategory.mn,
  3298: CharacterCategory.mn,
  3299: CharacterCategory.mn,
  3329: CharacterCategory.mn,
  3393: CharacterCategory.mn,
  3394: CharacterCategory.mn,
  3395: CharacterCategory.mn,
  3396: CharacterCategory.mn,
  3405: CharacterCategory.mn,
  3426: CharacterCategory.mn,
  3427: CharacterCategory.mn,
  3530: CharacterCategory.mn,
  3538: CharacterCategory.mn,
  3539: CharacterCategory.mn,
  3540: CharacterCategory.mn,
  3542: CharacterCategory.mn,
  3633: CharacterCategory.mn,
  3636: CharacterCategory.mn,
  3637: CharacterCategory.mn,
  3638: CharacterCategory.mn,
  3639: CharacterCategory.mn,
  3640: CharacterCategory.mn,
  3641: CharacterCategory.mn,
  3642: CharacterCategory.mn,
  3655: CharacterCategory.mn,
  3656: CharacterCategory.mn,
  3657: CharacterCategory.mn,
  3658: CharacterCategory.mn,
  3659: CharacterCategory.mn,
  3660: CharacterCategory.mn,
  3661: CharacterCategory.mn,
  3662: CharacterCategory.mn,
  3761: CharacterCategory.mn,
  3764: CharacterCategory.mn,
  3765: CharacterCategory.mn,
  3766: CharacterCategory.mn,
  3767: CharacterCategory.mn,
  3768: CharacterCategory.mn,
  3769: CharacterCategory.mn,
  3771: CharacterCategory.mn,
  3772: CharacterCategory.mn,
  3784: CharacterCategory.mn,
  3785: CharacterCategory.mn,
  3786: CharacterCategory.mn,
  3787: CharacterCategory.mn,
  3788: CharacterCategory.mn,
  3789: CharacterCategory.mn,
  3864: CharacterCategory.mn,
  3865: CharacterCategory.mn,
  3893: CharacterCategory.mn,
  3895: CharacterCategory.mn,
  3897: CharacterCategory.mn,
  3953: CharacterCategory.mn,
  3954: CharacterCategory.mn,
  3955: CharacterCategory.mn,
  3956: CharacterCategory.mn,
  3957: CharacterCategory.mn,
  3958: CharacterCategory.mn,
  3959: CharacterCategory.mn,
  3960: CharacterCategory.mn,
  3961: CharacterCategory.mn,
  3962: CharacterCategory.mn,
  3963: CharacterCategory.mn,
  3964: CharacterCategory.mn,
  3965: CharacterCategory.mn,
  3966: CharacterCategory.mn,
  3968: CharacterCategory.mn,
  3969: CharacterCategory.mn,
  3970: CharacterCategory.mn,
  3971: CharacterCategory.mn,
  3972: CharacterCategory.mn,
  3974: CharacterCategory.mn,
  3975: CharacterCategory.mn,
  3981: CharacterCategory.mn,
  3982: CharacterCategory.mn,
  3983: CharacterCategory.mn,
  3984: CharacterCategory.mn,
  3985: CharacterCategory.mn,
  3986: CharacterCategory.mn,
  3987: CharacterCategory.mn,
  3988: CharacterCategory.mn,
  3989: CharacterCategory.mn,
  3990: CharacterCategory.mn,
  3991: CharacterCategory.mn,
  3993: CharacterCategory.mn,
  3994: CharacterCategory.mn,
  3995: CharacterCategory.mn,
  3996: CharacterCategory.mn,
  3997: CharacterCategory.mn,
  3998: CharacterCategory.mn,
  3999: CharacterCategory.mn,
  4000: CharacterCategory.mn,
  4001: CharacterCategory.mn,
  4002: CharacterCategory.mn,
  4003: CharacterCategory.mn,
  4004: CharacterCategory.mn,
  4005: CharacterCategory.mn,
  4006: CharacterCategory.mn,
  4007: CharacterCategory.mn,
  4008: CharacterCategory.mn,
  4009: CharacterCategory.mn,
  4010: CharacterCategory.mn,
  4011: CharacterCategory.mn,
  4012: CharacterCategory.mn,
  4013: CharacterCategory.mn,
  4014: CharacterCategory.mn,
  4015: CharacterCategory.mn,
  4016: CharacterCategory.mn,
  4017: CharacterCategory.mn,
  4018: CharacterCategory.mn,
  4019: CharacterCategory.mn,
  4020: CharacterCategory.mn,
  4021: CharacterCategory.mn,
  4022: CharacterCategory.mn,
  4023: CharacterCategory.mn,
  4024: CharacterCategory.mn,
  4025: CharacterCategory.mn,
  4026: CharacterCategory.mn,
  4027: CharacterCategory.mn,
  4028: CharacterCategory.mn,
  4038: CharacterCategory.mn,
  4141: CharacterCategory.mn,
  4142: CharacterCategory.mn,
  4143: CharacterCategory.mn,
  4144: CharacterCategory.mn,
  4146: CharacterCategory.mn,
  4147: CharacterCategory.mn,
  4148: CharacterCategory.mn,
  4149: CharacterCategory.mn,
  4150: CharacterCategory.mn,
  4151: CharacterCategory.mn,
  4153: CharacterCategory.mn,
  4154: CharacterCategory.mn,
  4157: CharacterCategory.mn,
  4158: CharacterCategory.mn,
  4184: CharacterCategory.mn,
  4185: CharacterCategory.mn,
  4190: CharacterCategory.mn,
  4191: CharacterCategory.mn,
  4192: CharacterCategory.mn,
  4209: CharacterCategory.mn,
  4210: CharacterCategory.mn,
  4211: CharacterCategory.mn,
  4212: CharacterCategory.mn,
  4226: CharacterCategory.mn,
  4229: CharacterCategory.mn,
  4230: CharacterCategory.mn,
  4237: CharacterCategory.mn,
  4253: CharacterCategory.mn,
  4957: CharacterCategory.mn,
  4958: CharacterCategory.mn,
  4959: CharacterCategory.mn,
  5906: CharacterCategory.mn,
  5907: CharacterCategory.mn,
  5908: CharacterCategory.mn,
  5938: CharacterCategory.mn,
  5939: CharacterCategory.mn,
  5940: CharacterCategory.mn,
  5970: CharacterCategory.mn,
  5971: CharacterCategory.mn,
  6002: CharacterCategory.mn,
  6003: CharacterCategory.mn,
  6068: CharacterCategory.mn,
  6069: CharacterCategory.mn,
  6071: CharacterCategory.mn,
  6072: CharacterCategory.mn,
  6073: CharacterCategory.mn,
  6074: CharacterCategory.mn,
  6075: CharacterCategory.mn,
  6076: CharacterCategory.mn,
  6077: CharacterCategory.mn,
  6086: CharacterCategory.mn,
  6089: CharacterCategory.mn,
  6090: CharacterCategory.mn,
  6091: CharacterCategory.mn,
  6092: CharacterCategory.mn,
  6093: CharacterCategory.mn,
  6094: CharacterCategory.mn,
  6095: CharacterCategory.mn,
  6096: CharacterCategory.mn,
  6097: CharacterCategory.mn,
  6098: CharacterCategory.mn,
  6099: CharacterCategory.mn,
  6109: CharacterCategory.mn,
  6155: CharacterCategory.mn,
  6156: CharacterCategory.mn,
  6157: CharacterCategory.mn,
  6313: CharacterCategory.mn,
  6432: CharacterCategory.mn,
  6433: CharacterCategory.mn,
  6434: CharacterCategory.mn,
  6439: CharacterCategory.mn,
  6440: CharacterCategory.mn,
  6450: CharacterCategory.mn,
  6457: CharacterCategory.mn,
  6458: CharacterCategory.mn,
  6459: CharacterCategory.mn,
  6679: CharacterCategory.mn,
  6680: CharacterCategory.mn,
  6683: CharacterCategory.mn,
  6742: CharacterCategory.mn,
  6744: CharacterCategory.mn,
  6745: CharacterCategory.mn,
  6746: CharacterCategory.mn,
  6747: CharacterCategory.mn,
  6748: CharacterCategory.mn,
  6749: CharacterCategory.mn,
  6750: CharacterCategory.mn,
  6752: CharacterCategory.mn,
  6754: CharacterCategory.mn,
  6757: CharacterCategory.mn,
  6758: CharacterCategory.mn,
  6759: CharacterCategory.mn,
  6760: CharacterCategory.mn,
  6761: CharacterCategory.mn,
  6762: CharacterCategory.mn,
  6763: CharacterCategory.mn,
  6764: CharacterCategory.mn,
  6771: CharacterCategory.mn,
  6772: CharacterCategory.mn,
  6773: CharacterCategory.mn,
  6774: CharacterCategory.mn,
  6775: CharacterCategory.mn,
  6776: CharacterCategory.mn,
  6777: CharacterCategory.mn,
  6778: CharacterCategory.mn,
  6779: CharacterCategory.mn,
  6780: CharacterCategory.mn,
  6783: CharacterCategory.mn,
  6832: CharacterCategory.mn,
  6833: CharacterCategory.mn,
  6834: CharacterCategory.mn,
  6835: CharacterCategory.mn,
  6836: CharacterCategory.mn,
  6837: CharacterCategory.mn,
  6838: CharacterCategory.mn,
  6839: CharacterCategory.mn,
  6840: CharacterCategory.mn,
  6841: CharacterCategory.mn,
  6842: CharacterCategory.mn,
  6843: CharacterCategory.mn,
  6844: CharacterCategory.mn,
  6845: CharacterCategory.mn,
  6912: CharacterCategory.mn,
  6913: CharacterCategory.mn,
  6914: CharacterCategory.mn,
  6915: CharacterCategory.mn,
  6964: CharacterCategory.mn,
  6966: CharacterCategory.mn,
  6967: CharacterCategory.mn,
  6968: CharacterCategory.mn,
  6969: CharacterCategory.mn,
  6970: CharacterCategory.mn,
  6972: CharacterCategory.mn,
  6978: CharacterCategory.mn,
  7019: CharacterCategory.mn,
  7020: CharacterCategory.mn,
  7021: CharacterCategory.mn,
  7022: CharacterCategory.mn,
  7023: CharacterCategory.mn,
  7024: CharacterCategory.mn,
  7025: CharacterCategory.mn,
  7026: CharacterCategory.mn,
  7027: CharacterCategory.mn,
  7040: CharacterCategory.mn,
  7041: CharacterCategory.mn,
  7074: CharacterCategory.mn,
  7075: CharacterCategory.mn,
  7076: CharacterCategory.mn,
  7077: CharacterCategory.mn,
  7080: CharacterCategory.mn,
  7081: CharacterCategory.mn,
  7083: CharacterCategory.mn,
  7084: CharacterCategory.mn,
  7085: CharacterCategory.mn,
  7142: CharacterCategory.mn,
  7144: CharacterCategory.mn,
  7145: CharacterCategory.mn,
  7149: CharacterCategory.mn,
  7151: CharacterCategory.mn,
  7152: CharacterCategory.mn,
  7153: CharacterCategory.mn,
  7212: CharacterCategory.mn,
  7213: CharacterCategory.mn,
  7214: CharacterCategory.mn,
  7215: CharacterCategory.mn,
  7216: CharacterCategory.mn,
  7217: CharacterCategory.mn,
  7218: CharacterCategory.mn,
  7219: CharacterCategory.mn,
  7222: CharacterCategory.mn,
  7223: CharacterCategory.mn,
  7376: CharacterCategory.mn,
  7377: CharacterCategory.mn,
  7378: CharacterCategory.mn,
  7380: CharacterCategory.mn,
  7381: CharacterCategory.mn,
  7382: CharacterCategory.mn,
  7383: CharacterCategory.mn,
  7384: CharacterCategory.mn,
  7385: CharacterCategory.mn,
  7386: CharacterCategory.mn,
  7387: CharacterCategory.mn,
  7388: CharacterCategory.mn,
  7389: CharacterCategory.mn,
  7390: CharacterCategory.mn,
  7391: CharacterCategory.mn,
  7392: CharacterCategory.mn,
  7394: CharacterCategory.mn,
  7395: CharacterCategory.mn,
  7396: CharacterCategory.mn,
  7397: CharacterCategory.mn,
  7398: CharacterCategory.mn,
  7399: CharacterCategory.mn,
  7400: CharacterCategory.mn,
  7405: CharacterCategory.mn,
  7412: CharacterCategory.mn,
  7416: CharacterCategory.mn,
  7417: CharacterCategory.mn,
  7616: CharacterCategory.mn,
  7617: CharacterCategory.mn,
  7618: CharacterCategory.mn,
  7619: CharacterCategory.mn,
  7620: CharacterCategory.mn,
  7621: CharacterCategory.mn,
  7622: CharacterCategory.mn,
  7623: CharacterCategory.mn,
  7624: CharacterCategory.mn,
  7625: CharacterCategory.mn,
  7626: CharacterCategory.mn,
  7627: CharacterCategory.mn,
  7628: CharacterCategory.mn,
  7629: CharacterCategory.mn,
  7630: CharacterCategory.mn,
  7631: CharacterCategory.mn,
  7632: CharacterCategory.mn,
  7633: CharacterCategory.mn,
  7634: CharacterCategory.mn,
  7635: CharacterCategory.mn,
  7636: CharacterCategory.mn,
  7637: CharacterCategory.mn,
  7638: CharacterCategory.mn,
  7639: CharacterCategory.mn,
  7640: CharacterCategory.mn,
  7641: CharacterCategory.mn,
  7642: CharacterCategory.mn,
  7643: CharacterCategory.mn,
  7644: CharacterCategory.mn,
  7645: CharacterCategory.mn,
  7646: CharacterCategory.mn,
  7647: CharacterCategory.mn,
  7648: CharacterCategory.mn,
  7649: CharacterCategory.mn,
  7650: CharacterCategory.mn,
  7651: CharacterCategory.mn,
  7652: CharacterCategory.mn,
  7653: CharacterCategory.mn,
  7654: CharacterCategory.mn,
  7655: CharacterCategory.mn,
  7656: CharacterCategory.mn,
  7657: CharacterCategory.mn,
  7658: CharacterCategory.mn,
  7659: CharacterCategory.mn,
  7660: CharacterCategory.mn,
  7661: CharacterCategory.mn,
  7662: CharacterCategory.mn,
  7663: CharacterCategory.mn,
  7664: CharacterCategory.mn,
  7665: CharacterCategory.mn,
  7666: CharacterCategory.mn,
  7667: CharacterCategory.mn,
  7668: CharacterCategory.mn,
  7669: CharacterCategory.mn,
  7676: CharacterCategory.mn,
  7677: CharacterCategory.mn,
  7678: CharacterCategory.mn,
  7679: CharacterCategory.mn,
  8400: CharacterCategory.mn,
  8401: CharacterCategory.mn,
  8402: CharacterCategory.mn,
  8403: CharacterCategory.mn,
  8404: CharacterCategory.mn,
  8405: CharacterCategory.mn,
  8406: CharacterCategory.mn,
  8407: CharacterCategory.mn,
  8408: CharacterCategory.mn,
  8409: CharacterCategory.mn,
  8410: CharacterCategory.mn,
  8411: CharacterCategory.mn,
  8412: CharacterCategory.mn,
  8417: CharacterCategory.mn,
  8421: CharacterCategory.mn,
  8422: CharacterCategory.mn,
  8423: CharacterCategory.mn,
  8424: CharacterCategory.mn,
  8425: CharacterCategory.mn,
  8426: CharacterCategory.mn,
  8427: CharacterCategory.mn,
  8428: CharacterCategory.mn,
  8429: CharacterCategory.mn,
  8430: CharacterCategory.mn,
  8431: CharacterCategory.mn,
  8432: CharacterCategory.mn,
  11503: CharacterCategory.mn,
  11504: CharacterCategory.mn,
  11505: CharacterCategory.mn,
  11647: CharacterCategory.mn,
  11744: CharacterCategory.mn,
  11745: CharacterCategory.mn,
  11746: CharacterCategory.mn,
  11747: CharacterCategory.mn,
  11748: CharacterCategory.mn,
  11749: CharacterCategory.mn,
  11750: CharacterCategory.mn,
  11751: CharacterCategory.mn,
  11752: CharacterCategory.mn,
  11753: CharacterCategory.mn,
  11754: CharacterCategory.mn,
  11755: CharacterCategory.mn,
  11756: CharacterCategory.mn,
  11757: CharacterCategory.mn,
  11758: CharacterCategory.mn,
  11759: CharacterCategory.mn,
  11760: CharacterCategory.mn,
  11761: CharacterCategory.mn,
  11762: CharacterCategory.mn,
  11763: CharacterCategory.mn,
  11764: CharacterCategory.mn,
  11765: CharacterCategory.mn,
  11766: CharacterCategory.mn,
  11767: CharacterCategory.mn,
  11768: CharacterCategory.mn,
  11769: CharacterCategory.mn,
  11770: CharacterCategory.mn,
  11771: CharacterCategory.mn,
  11772: CharacterCategory.mn,
  11773: CharacterCategory.mn,
  11774: CharacterCategory.mn,
  11775: CharacterCategory.mn,
  12330: CharacterCategory.mn,
  12331: CharacterCategory.mn,
  12332: CharacterCategory.mn,
  12333: CharacterCategory.mn,
  12441: CharacterCategory.mn,
  12442: CharacterCategory.mn,
  42607: CharacterCategory.mn,
  42612: CharacterCategory.mn,
  42613: CharacterCategory.mn,
  42614: CharacterCategory.mn,
  42615: CharacterCategory.mn,
  42616: CharacterCategory.mn,
  42617: CharacterCategory.mn,
  42618: CharacterCategory.mn,
  42619: CharacterCategory.mn,
  42620: CharacterCategory.mn,
  42621: CharacterCategory.mn,
  42655: CharacterCategory.mn,
  42736: CharacterCategory.mn,
  42737: CharacterCategory.mn,
  43010: CharacterCategory.mn,
  43014: CharacterCategory.mn,
  43019: CharacterCategory.mn,
  43045: CharacterCategory.mn,
  43046: CharacterCategory.mn,
  43204: CharacterCategory.mn,
  43232: CharacterCategory.mn,
  43233: CharacterCategory.mn,
  43234: CharacterCategory.mn,
  43235: CharacterCategory.mn,
  43236: CharacterCategory.mn,
  43237: CharacterCategory.mn,
  43238: CharacterCategory.mn,
  43239: CharacterCategory.mn,
  43240: CharacterCategory.mn,
  43241: CharacterCategory.mn,
  43242: CharacterCategory.mn,
  43243: CharacterCategory.mn,
  43244: CharacterCategory.mn,
  43245: CharacterCategory.mn,
  43246: CharacterCategory.mn,
  43247: CharacterCategory.mn,
  43248: CharacterCategory.mn,
  43249: CharacterCategory.mn,
  43302: CharacterCategory.mn,
  43303: CharacterCategory.mn,
  43304: CharacterCategory.mn,
  43305: CharacterCategory.mn,
  43306: CharacterCategory.mn,
  43307: CharacterCategory.mn,
  43308: CharacterCategory.mn,
  43309: CharacterCategory.mn,
  43335: CharacterCategory.mn,
  43336: CharacterCategory.mn,
  43337: CharacterCategory.mn,
  43338: CharacterCategory.mn,
  43339: CharacterCategory.mn,
  43340: CharacterCategory.mn,
  43341: CharacterCategory.mn,
  43342: CharacterCategory.mn,
  43343: CharacterCategory.mn,
  43344: CharacterCategory.mn,
  43345: CharacterCategory.mn,
  43392: CharacterCategory.mn,
  43393: CharacterCategory.mn,
  43394: CharacterCategory.mn,
  43443: CharacterCategory.mn,
  43446: CharacterCategory.mn,
  43447: CharacterCategory.mn,
  43448: CharacterCategory.mn,
  43449: CharacterCategory.mn,
  43452: CharacterCategory.mn,
  43493: CharacterCategory.mn,
  43561: CharacterCategory.mn,
  43562: CharacterCategory.mn,
  43563: CharacterCategory.mn,
  43564: CharacterCategory.mn,
  43565: CharacterCategory.mn,
  43566: CharacterCategory.mn,
  43569: CharacterCategory.mn,
  43570: CharacterCategory.mn,
  43573: CharacterCategory.mn,
  43574: CharacterCategory.mn,
  43587: CharacterCategory.mn,
  43596: CharacterCategory.mn,
  43644: CharacterCategory.mn,
  43696: CharacterCategory.mn,
  43698: CharacterCategory.mn,
  43699: CharacterCategory.mn,
  43700: CharacterCategory.mn,
  43703: CharacterCategory.mn,
  43704: CharacterCategory.mn,
  43710: CharacterCategory.mn,
  43711: CharacterCategory.mn,
  43713: CharacterCategory.mn,
  43756: CharacterCategory.mn,
  43757: CharacterCategory.mn,
  43766: CharacterCategory.mn,
  44005: CharacterCategory.mn,
  44008: CharacterCategory.mn,
  44013: CharacterCategory.mn,
  64286: CharacterCategory.mn,
  65024: CharacterCategory.mn,
  65025: CharacterCategory.mn,
  65026: CharacterCategory.mn,
  65027: CharacterCategory.mn,
  65028: CharacterCategory.mn,
  65029: CharacterCategory.mn,
  65030: CharacterCategory.mn,
  65031: CharacterCategory.mn,
  65032: CharacterCategory.mn,
  65033: CharacterCategory.mn,
  65034: CharacterCategory.mn,
  65035: CharacterCategory.mn,
  65036: CharacterCategory.mn,
  65037: CharacterCategory.mn,
  65038: CharacterCategory.mn,
  65039: CharacterCategory.mn,
  65056: CharacterCategory.mn,
  65057: CharacterCategory.mn,
  65058: CharacterCategory.mn,
  65059: CharacterCategory.mn,
  65060: CharacterCategory.mn,
  65061: CharacterCategory.mn,
  65062: CharacterCategory.mn,
  65063: CharacterCategory.mn,
  65064: CharacterCategory.mn,
  65065: CharacterCategory.mn,
  65066: CharacterCategory.mn,
  65067: CharacterCategory.mn,
  65068: CharacterCategory.mn,
  65069: CharacterCategory.mn,
  2307: CharacterCategory.mc,
  2363: CharacterCategory.mc,
  2366: CharacterCategory.mc,
  2367: CharacterCategory.mc,
  2368: CharacterCategory.mc,
  2377: CharacterCategory.mc,
  2378: CharacterCategory.mc,
  2379: CharacterCategory.mc,
  2380: CharacterCategory.mc,
  2382: CharacterCategory.mc,
  2383: CharacterCategory.mc,
  2434: CharacterCategory.mc,
  2435: CharacterCategory.mc,
  2494: CharacterCategory.mc,
  2495: CharacterCategory.mc,
  2496: CharacterCategory.mc,
  2503: CharacterCategory.mc,
  2504: CharacterCategory.mc,
  2507: CharacterCategory.mc,
  2508: CharacterCategory.mc,
  2519: CharacterCategory.mc,
  2563: CharacterCategory.mc,
  2622: CharacterCategory.mc,
  2623: CharacterCategory.mc,
  2624: CharacterCategory.mc,
  2691: CharacterCategory.mc,
  2750: CharacterCategory.mc,
  2751: CharacterCategory.mc,
  2752: CharacterCategory.mc,
  2761: CharacterCategory.mc,
  2763: CharacterCategory.mc,
  2764: CharacterCategory.mc,
  2818: CharacterCategory.mc,
  2819: CharacterCategory.mc,
  2878: CharacterCategory.mc,
  2880: CharacterCategory.mc,
  2887: CharacterCategory.mc,
  2888: CharacterCategory.mc,
  2891: CharacterCategory.mc,
  2892: CharacterCategory.mc,
  2903: CharacterCategory.mc,
  3006: CharacterCategory.mc,
  3007: CharacterCategory.mc,
  3009: CharacterCategory.mc,
  3010: CharacterCategory.mc,
  3014: CharacterCategory.mc,
  3015: CharacterCategory.mc,
  3016: CharacterCategory.mc,
  3018: CharacterCategory.mc,
  3019: CharacterCategory.mc,
  3020: CharacterCategory.mc,
  3031: CharacterCategory.mc,
  3073: CharacterCategory.mc,
  3074: CharacterCategory.mc,
  3075: CharacterCategory.mc,
  3137: CharacterCategory.mc,
  3138: CharacterCategory.mc,
  3139: CharacterCategory.mc,
  3140: CharacterCategory.mc,
  3202: CharacterCategory.mc,
  3203: CharacterCategory.mc,
  3262: CharacterCategory.mc,
  3264: CharacterCategory.mc,
  3265: CharacterCategory.mc,
  3266: CharacterCategory.mc,
  3267: CharacterCategory.mc,
  3268: CharacterCategory.mc,
  3271: CharacterCategory.mc,
  3272: CharacterCategory.mc,
  3274: CharacterCategory.mc,
  3275: CharacterCategory.mc,
  3285: CharacterCategory.mc,
  3286: CharacterCategory.mc,
  3330: CharacterCategory.mc,
  3331: CharacterCategory.mc,
  3390: CharacterCategory.mc,
  3391: CharacterCategory.mc,
  3392: CharacterCategory.mc,
  3398: CharacterCategory.mc,
  3399: CharacterCategory.mc,
  3400: CharacterCategory.mc,
  3402: CharacterCategory.mc,
  3403: CharacterCategory.mc,
  3404: CharacterCategory.mc,
  3415: CharacterCategory.mc,
  3458: CharacterCategory.mc,
  3459: CharacterCategory.mc,
  3535: CharacterCategory.mc,
  3536: CharacterCategory.mc,
  3537: CharacterCategory.mc,
  3544: CharacterCategory.mc,
  3545: CharacterCategory.mc,
  3546: CharacterCategory.mc,
  3547: CharacterCategory.mc,
  3548: CharacterCategory.mc,
  3549: CharacterCategory.mc,
  3550: CharacterCategory.mc,
  3551: CharacterCategory.mc,
  3570: CharacterCategory.mc,
  3571: CharacterCategory.mc,
  3902: CharacterCategory.mc,
  3903: CharacterCategory.mc,
  3967: CharacterCategory.mc,
  4139: CharacterCategory.mc,
  4140: CharacterCategory.mc,
  4145: CharacterCategory.mc,
  4152: CharacterCategory.mc,
  4155: CharacterCategory.mc,
  4156: CharacterCategory.mc,
  4182: CharacterCategory.mc,
  4183: CharacterCategory.mc,
  4194: CharacterCategory.mc,
  4195: CharacterCategory.mc,
  4196: CharacterCategory.mc,
  4199: CharacterCategory.mc,
  4200: CharacterCategory.mc,
  4201: CharacterCategory.mc,
  4202: CharacterCategory.mc,
  4203: CharacterCategory.mc,
  4204: CharacterCategory.mc,
  4205: CharacterCategory.mc,
  4227: CharacterCategory.mc,
  4228: CharacterCategory.mc,
  4231: CharacterCategory.mc,
  4232: CharacterCategory.mc,
  4233: CharacterCategory.mc,
  4234: CharacterCategory.mc,
  4235: CharacterCategory.mc,
  4236: CharacterCategory.mc,
  4239: CharacterCategory.mc,
  4250: CharacterCategory.mc,
  4251: CharacterCategory.mc,
  4252: CharacterCategory.mc,
  6070: CharacterCategory.mc,
  6078: CharacterCategory.mc,
  6079: CharacterCategory.mc,
  6080: CharacterCategory.mc,
  6081: CharacterCategory.mc,
  6082: CharacterCategory.mc,
  6083: CharacterCategory.mc,
  6084: CharacterCategory.mc,
  6085: CharacterCategory.mc,
  6087: CharacterCategory.mc,
  6088: CharacterCategory.mc,
  6435: CharacterCategory.mc,
  6436: CharacterCategory.mc,
  6437: CharacterCategory.mc,
  6438: CharacterCategory.mc,
  6441: CharacterCategory.mc,
  6442: CharacterCategory.mc,
  6443: CharacterCategory.mc,
  6448: CharacterCategory.mc,
  6449: CharacterCategory.mc,
  6451: CharacterCategory.mc,
  6452: CharacterCategory.mc,
  6453: CharacterCategory.mc,
  6454: CharacterCategory.mc,
  6455: CharacterCategory.mc,
  6456: CharacterCategory.mc,
  6576: CharacterCategory.mc,
  6577: CharacterCategory.mc,
  6578: CharacterCategory.mc,
  6579: CharacterCategory.mc,
  6580: CharacterCategory.mc,
  6581: CharacterCategory.mc,
  6582: CharacterCategory.mc,
  6583: CharacterCategory.mc,
  6584: CharacterCategory.mc,
  6585: CharacterCategory.mc,
  6586: CharacterCategory.mc,
  6587: CharacterCategory.mc,
  6588: CharacterCategory.mc,
  6589: CharacterCategory.mc,
  6590: CharacterCategory.mc,
  6591: CharacterCategory.mc,
  6592: CharacterCategory.mc,
  6600: CharacterCategory.mc,
  6601: CharacterCategory.mc,
  6681: CharacterCategory.mc,
  6682: CharacterCategory.mc,
  6741: CharacterCategory.mc,
  6743: CharacterCategory.mc,
  6753: CharacterCategory.mc,
  6755: CharacterCategory.mc,
  6756: CharacterCategory.mc,
  6765: CharacterCategory.mc,
  6766: CharacterCategory.mc,
  6767: CharacterCategory.mc,
  6768: CharacterCategory.mc,
  6769: CharacterCategory.mc,
  6770: CharacterCategory.mc,
  6916: CharacterCategory.mc,
  6965: CharacterCategory.mc,
  6971: CharacterCategory.mc,
  6973: CharacterCategory.mc,
  6974: CharacterCategory.mc,
  6975: CharacterCategory.mc,
  6976: CharacterCategory.mc,
  6977: CharacterCategory.mc,
  6979: CharacterCategory.mc,
  6980: CharacterCategory.mc,
  7042: CharacterCategory.mc,
  7073: CharacterCategory.mc,
  7078: CharacterCategory.mc,
  7079: CharacterCategory.mc,
  7082: CharacterCategory.mc,
  7143: CharacterCategory.mc,
  7146: CharacterCategory.mc,
  7147: CharacterCategory.mc,
  7148: CharacterCategory.mc,
  7150: CharacterCategory.mc,
  7154: CharacterCategory.mc,
  7155: CharacterCategory.mc,
  7204: CharacterCategory.mc,
  7205: CharacterCategory.mc,
  7206: CharacterCategory.mc,
  7207: CharacterCategory.mc,
  7208: CharacterCategory.mc,
  7209: CharacterCategory.mc,
  7210: CharacterCategory.mc,
  7211: CharacterCategory.mc,
  7220: CharacterCategory.mc,
  7221: CharacterCategory.mc,
  7393: CharacterCategory.mc,
  7410: CharacterCategory.mc,
  7411: CharacterCategory.mc,
  12334: CharacterCategory.mc,
  12335: CharacterCategory.mc,
  43043: CharacterCategory.mc,
  43044: CharacterCategory.mc,
  43047: CharacterCategory.mc,
  43136: CharacterCategory.mc,
  43137: CharacterCategory.mc,
  43188: CharacterCategory.mc,
  43189: CharacterCategory.mc,
  43190: CharacterCategory.mc,
  43191: CharacterCategory.mc,
  43192: CharacterCategory.mc,
  43193: CharacterCategory.mc,
  43194: CharacterCategory.mc,
  43195: CharacterCategory.mc,
  43196: CharacterCategory.mc,
  43197: CharacterCategory.mc,
  43198: CharacterCategory.mc,
  43199: CharacterCategory.mc,
  43200: CharacterCategory.mc,
  43201: CharacterCategory.mc,
  43202: CharacterCategory.mc,
  43203: CharacterCategory.mc,
  43346: CharacterCategory.mc,
  43347: CharacterCategory.mc,
  43395: CharacterCategory.mc,
  43444: CharacterCategory.mc,
  43445: CharacterCategory.mc,
  43450: CharacterCategory.mc,
  43451: CharacterCategory.mc,
  43453: CharacterCategory.mc,
  43454: CharacterCategory.mc,
  43455: CharacterCategory.mc,
  43456: CharacterCategory.mc,
  43567: CharacterCategory.mc,
  43568: CharacterCategory.mc,
  43571: CharacterCategory.mc,
  43572: CharacterCategory.mc,
  43597: CharacterCategory.mc,
  43643: CharacterCategory.mc,
  43645: CharacterCategory.mc,
  43755: CharacterCategory.mc,
  43758: CharacterCategory.mc,
  43759: CharacterCategory.mc,
  43765: CharacterCategory.mc,
  44003: CharacterCategory.mc,
  44004: CharacterCategory.mc,
  44006: CharacterCategory.mc,
  44007: CharacterCategory.mc,
  44009: CharacterCategory.mc,
  44010: CharacterCategory.mc,
  44012: CharacterCategory.mc,
  1160: CharacterCategory.me,
  1161: CharacterCategory.me,
  6846: CharacterCategory.me,
  8413: CharacterCategory.me,
  8414: CharacterCategory.me,
  8415: CharacterCategory.me,
  8416: CharacterCategory.me,
  8418: CharacterCategory.me,
  8419: CharacterCategory.me,
  8420: CharacterCategory.me,
  42608: CharacterCategory.me,
  42609: CharacterCategory.me,
  42610: CharacterCategory.me,
  48: CharacterCategory.nd,
  49: CharacterCategory.nd,
  50: CharacterCategory.nd,
  51: CharacterCategory.nd,
  52: CharacterCategory.nd,
  53: CharacterCategory.nd,
  54: CharacterCategory.nd,
  55: CharacterCategory.nd,
  56: CharacterCategory.nd,
  57: CharacterCategory.nd,
  1632: CharacterCategory.nd,
  1633: CharacterCategory.nd,
  1634: CharacterCategory.nd,
  1635: CharacterCategory.nd,
  1636: CharacterCategory.nd,
  1637: CharacterCategory.nd,
  1638: CharacterCategory.nd,
  1639: CharacterCategory.nd,
  1640: CharacterCategory.nd,
  1641: CharacterCategory.nd,
  1776: CharacterCategory.nd,
  1777: CharacterCategory.nd,
  1778: CharacterCategory.nd,
  1779: CharacterCategory.nd,
  1780: CharacterCategory.nd,
  1781: CharacterCategory.nd,
  1782: CharacterCategory.nd,
  1783: CharacterCategory.nd,
  1784: CharacterCategory.nd,
  1785: CharacterCategory.nd,
  1984: CharacterCategory.nd,
  1985: CharacterCategory.nd,
  1986: CharacterCategory.nd,
  1987: CharacterCategory.nd,
  1988: CharacterCategory.nd,
  1989: CharacterCategory.nd,
  1990: CharacterCategory.nd,
  1991: CharacterCategory.nd,
  1992: CharacterCategory.nd,
  1993: CharacterCategory.nd,
  2406: CharacterCategory.nd,
  2407: CharacterCategory.nd,
  2408: CharacterCategory.nd,
  2409: CharacterCategory.nd,
  2410: CharacterCategory.nd,
  2411: CharacterCategory.nd,
  2412: CharacterCategory.nd,
  2413: CharacterCategory.nd,
  2414: CharacterCategory.nd,
  2415: CharacterCategory.nd,
  2534: CharacterCategory.nd,
  2535: CharacterCategory.nd,
  2536: CharacterCategory.nd,
  2537: CharacterCategory.nd,
  2538: CharacterCategory.nd,
  2539: CharacterCategory.nd,
  2540: CharacterCategory.nd,
  2541: CharacterCategory.nd,
  2542: CharacterCategory.nd,
  2543: CharacterCategory.nd,
  2662: CharacterCategory.nd,
  2663: CharacterCategory.nd,
  2664: CharacterCategory.nd,
  2665: CharacterCategory.nd,
  2666: CharacterCategory.nd,
  2667: CharacterCategory.nd,
  2668: CharacterCategory.nd,
  2669: CharacterCategory.nd,
  2670: CharacterCategory.nd,
  2671: CharacterCategory.nd,
  2790: CharacterCategory.nd,
  2791: CharacterCategory.nd,
  2792: CharacterCategory.nd,
  2793: CharacterCategory.nd,
  2794: CharacterCategory.nd,
  2795: CharacterCategory.nd,
  2796: CharacterCategory.nd,
  2797: CharacterCategory.nd,
  2798: CharacterCategory.nd,
  2799: CharacterCategory.nd,
  2918: CharacterCategory.nd,
  2919: CharacterCategory.nd,
  2920: CharacterCategory.nd,
  2921: CharacterCategory.nd,
  2922: CharacterCategory.nd,
  2923: CharacterCategory.nd,
  2924: CharacterCategory.nd,
  2925: CharacterCategory.nd,
  2926: CharacterCategory.nd,
  2927: CharacterCategory.nd,
  3046: CharacterCategory.nd,
  3047: CharacterCategory.nd,
  3048: CharacterCategory.nd,
  3049: CharacterCategory.nd,
  3050: CharacterCategory.nd,
  3051: CharacterCategory.nd,
  3052: CharacterCategory.nd,
  3053: CharacterCategory.nd,
  3054: CharacterCategory.nd,
  3055: CharacterCategory.nd,
  3174: CharacterCategory.nd,
  3175: CharacterCategory.nd,
  3176: CharacterCategory.nd,
  3177: CharacterCategory.nd,
  3178: CharacterCategory.nd,
  3179: CharacterCategory.nd,
  3180: CharacterCategory.nd,
  3181: CharacterCategory.nd,
  3182: CharacterCategory.nd,
  3183: CharacterCategory.nd,
  3302: CharacterCategory.nd,
  3303: CharacterCategory.nd,
  3304: CharacterCategory.nd,
  3305: CharacterCategory.nd,
  3306: CharacterCategory.nd,
  3307: CharacterCategory.nd,
  3308: CharacterCategory.nd,
  3309: CharacterCategory.nd,
  3310: CharacterCategory.nd,
  3311: CharacterCategory.nd,
  3430: CharacterCategory.nd,
  3431: CharacterCategory.nd,
  3432: CharacterCategory.nd,
  3433: CharacterCategory.nd,
  3434: CharacterCategory.nd,
  3435: CharacterCategory.nd,
  3436: CharacterCategory.nd,
  3437: CharacterCategory.nd,
  3438: CharacterCategory.nd,
  3439: CharacterCategory.nd,
  3558: CharacterCategory.nd,
  3559: CharacterCategory.nd,
  3560: CharacterCategory.nd,
  3561: CharacterCategory.nd,
  3562: CharacterCategory.nd,
  3563: CharacterCategory.nd,
  3564: CharacterCategory.nd,
  3565: CharacterCategory.nd,
  3566: CharacterCategory.nd,
  3567: CharacterCategory.nd,
  3664: CharacterCategory.nd,
  3665: CharacterCategory.nd,
  3666: CharacterCategory.nd,
  3667: CharacterCategory.nd,
  3668: CharacterCategory.nd,
  3669: CharacterCategory.nd,
  3670: CharacterCategory.nd,
  3671: CharacterCategory.nd,
  3672: CharacterCategory.nd,
  3673: CharacterCategory.nd,
  3792: CharacterCategory.nd,
  3793: CharacterCategory.nd,
  3794: CharacterCategory.nd,
  3795: CharacterCategory.nd,
  3796: CharacterCategory.nd,
  3797: CharacterCategory.nd,
  3798: CharacterCategory.nd,
  3799: CharacterCategory.nd,
  3800: CharacterCategory.nd,
  3801: CharacterCategory.nd,
  3872: CharacterCategory.nd,
  3873: CharacterCategory.nd,
  3874: CharacterCategory.nd,
  3875: CharacterCategory.nd,
  3876: CharacterCategory.nd,
  3877: CharacterCategory.nd,
  3878: CharacterCategory.nd,
  3879: CharacterCategory.nd,
  3880: CharacterCategory.nd,
  3881: CharacterCategory.nd,
  4160: CharacterCategory.nd,
  4161: CharacterCategory.nd,
  4162: CharacterCategory.nd,
  4163: CharacterCategory.nd,
  4164: CharacterCategory.nd,
  4165: CharacterCategory.nd,
  4166: CharacterCategory.nd,
  4167: CharacterCategory.nd,
  4168: CharacterCategory.nd,
  4169: CharacterCategory.nd,
  4240: CharacterCategory.nd,
  4241: CharacterCategory.nd,
  4242: CharacterCategory.nd,
  4243: CharacterCategory.nd,
  4244: CharacterCategory.nd,
  4245: CharacterCategory.nd,
  4246: CharacterCategory.nd,
  4247: CharacterCategory.nd,
  4248: CharacterCategory.nd,
  4249: CharacterCategory.nd,
  6112: CharacterCategory.nd,
  6113: CharacterCategory.nd,
  6114: CharacterCategory.nd,
  6115: CharacterCategory.nd,
  6116: CharacterCategory.nd,
  6117: CharacterCategory.nd,
  6118: CharacterCategory.nd,
  6119: CharacterCategory.nd,
  6120: CharacterCategory.nd,
  6121: CharacterCategory.nd,
  6160: CharacterCategory.nd,
  6161: CharacterCategory.nd,
  6162: CharacterCategory.nd,
  6163: CharacterCategory.nd,
  6164: CharacterCategory.nd,
  6165: CharacterCategory.nd,
  6166: CharacterCategory.nd,
  6167: CharacterCategory.nd,
  6168: CharacterCategory.nd,
  6169: CharacterCategory.nd,
  6470: CharacterCategory.nd,
  6471: CharacterCategory.nd,
  6472: CharacterCategory.nd,
  6473: CharacterCategory.nd,
  6474: CharacterCategory.nd,
  6475: CharacterCategory.nd,
  6476: CharacterCategory.nd,
  6477: CharacterCategory.nd,
  6478: CharacterCategory.nd,
  6479: CharacterCategory.nd,
  6608: CharacterCategory.nd,
  6609: CharacterCategory.nd,
  6610: CharacterCategory.nd,
  6611: CharacterCategory.nd,
  6612: CharacterCategory.nd,
  6613: CharacterCategory.nd,
  6614: CharacterCategory.nd,
  6615: CharacterCategory.nd,
  6616: CharacterCategory.nd,
  6617: CharacterCategory.nd,
  6784: CharacterCategory.nd,
  6785: CharacterCategory.nd,
  6786: CharacterCategory.nd,
  6787: CharacterCategory.nd,
  6788: CharacterCategory.nd,
  6789: CharacterCategory.nd,
  6790: CharacterCategory.nd,
  6791: CharacterCategory.nd,
  6792: CharacterCategory.nd,
  6793: CharacterCategory.nd,
  6800: CharacterCategory.nd,
  6801: CharacterCategory.nd,
  6802: CharacterCategory.nd,
  6803: CharacterCategory.nd,
  6804: CharacterCategory.nd,
  6805: CharacterCategory.nd,
  6806: CharacterCategory.nd,
  6807: CharacterCategory.nd,
  6808: CharacterCategory.nd,
  6809: CharacterCategory.nd,
  6992: CharacterCategory.nd,
  6993: CharacterCategory.nd,
  6994: CharacterCategory.nd,
  6995: CharacterCategory.nd,
  6996: CharacterCategory.nd,
  6997: CharacterCategory.nd,
  6998: CharacterCategory.nd,
  6999: CharacterCategory.nd,
  7000: CharacterCategory.nd,
  7001: CharacterCategory.nd,
  7088: CharacterCategory.nd,
  7089: CharacterCategory.nd,
  7090: CharacterCategory.nd,
  7091: CharacterCategory.nd,
  7092: CharacterCategory.nd,
  7093: CharacterCategory.nd,
  7094: CharacterCategory.nd,
  7095: CharacterCategory.nd,
  7096: CharacterCategory.nd,
  7097: CharacterCategory.nd,
  7232: CharacterCategory.nd,
  7233: CharacterCategory.nd,
  7234: CharacterCategory.nd,
  7235: CharacterCategory.nd,
  7236: CharacterCategory.nd,
  7237: CharacterCategory.nd,
  7238: CharacterCategory.nd,
  7239: CharacterCategory.nd,
  7240: CharacterCategory.nd,
  7241: CharacterCategory.nd,
  7248: CharacterCategory.nd,
  7249: CharacterCategory.nd,
  7250: CharacterCategory.nd,
  7251: CharacterCategory.nd,
  7252: CharacterCategory.nd,
  7253: CharacterCategory.nd,
  7254: CharacterCategory.nd,
  7255: CharacterCategory.nd,
  7256: CharacterCategory.nd,
  7257: CharacterCategory.nd,
  42528: CharacterCategory.nd,
  42529: CharacterCategory.nd,
  42530: CharacterCategory.nd,
  42531: CharacterCategory.nd,
  42532: CharacterCategory.nd,
  42533: CharacterCategory.nd,
  42534: CharacterCategory.nd,
  42535: CharacterCategory.nd,
  42536: CharacterCategory.nd,
  42537: CharacterCategory.nd,
  43216: CharacterCategory.nd,
  43217: CharacterCategory.nd,
  43218: CharacterCategory.nd,
  43219: CharacterCategory.nd,
  43220: CharacterCategory.nd,
  43221: CharacterCategory.nd,
  43222: CharacterCategory.nd,
  43223: CharacterCategory.nd,
  43224: CharacterCategory.nd,
  43225: CharacterCategory.nd,
  43264: CharacterCategory.nd,
  43265: CharacterCategory.nd,
  43266: CharacterCategory.nd,
  43267: CharacterCategory.nd,
  43268: CharacterCategory.nd,
  43269: CharacterCategory.nd,
  43270: CharacterCategory.nd,
  43271: CharacterCategory.nd,
  43272: CharacterCategory.nd,
  43273: CharacterCategory.nd,
  43472: CharacterCategory.nd,
  43473: CharacterCategory.nd,
  43474: CharacterCategory.nd,
  43475: CharacterCategory.nd,
  43476: CharacterCategory.nd,
  43477: CharacterCategory.nd,
  43478: CharacterCategory.nd,
  43479: CharacterCategory.nd,
  43480: CharacterCategory.nd,
  43481: CharacterCategory.nd,
  43504: CharacterCategory.nd,
  43505: CharacterCategory.nd,
  43506: CharacterCategory.nd,
  43507: CharacterCategory.nd,
  43508: CharacterCategory.nd,
  43509: CharacterCategory.nd,
  43510: CharacterCategory.nd,
  43511: CharacterCategory.nd,
  43512: CharacterCategory.nd,
  43513: CharacterCategory.nd,
  43600: CharacterCategory.nd,
  43601: CharacterCategory.nd,
  43602: CharacterCategory.nd,
  43603: CharacterCategory.nd,
  43604: CharacterCategory.nd,
  43605: CharacterCategory.nd,
  43606: CharacterCategory.nd,
  43607: CharacterCategory.nd,
  43608: CharacterCategory.nd,
  43609: CharacterCategory.nd,
  44016: CharacterCategory.nd,
  44017: CharacterCategory.nd,
  44018: CharacterCategory.nd,
  44019: CharacterCategory.nd,
  44020: CharacterCategory.nd,
  44021: CharacterCategory.nd,
  44022: CharacterCategory.nd,
  44023: CharacterCategory.nd,
  44024: CharacterCategory.nd,
  44025: CharacterCategory.nd,
  65296: CharacterCategory.nd,
  65297: CharacterCategory.nd,
  65298: CharacterCategory.nd,
  65299: CharacterCategory.nd,
  65300: CharacterCategory.nd,
  65301: CharacterCategory.nd,
  65302: CharacterCategory.nd,
  65303: CharacterCategory.nd,
  65304: CharacterCategory.nd,
  65305: CharacterCategory.nd,
  5870: CharacterCategory.nl,
  5871: CharacterCategory.nl,
  5872: CharacterCategory.nl,
  8544: CharacterCategory.nl,
  8545: CharacterCategory.nl,
  8546: CharacterCategory.nl,
  8547: CharacterCategory.nl,
  8548: CharacterCategory.nl,
  8549: CharacterCategory.nl,
  8550: CharacterCategory.nl,
  8551: CharacterCategory.nl,
  8552: CharacterCategory.nl,
  8553: CharacterCategory.nl,
  8554: CharacterCategory.nl,
  8555: CharacterCategory.nl,
  8556: CharacterCategory.nl,
  8557: CharacterCategory.nl,
  8558: CharacterCategory.nl,
  8559: CharacterCategory.nl,
  8560: CharacterCategory.nl,
  8561: CharacterCategory.nl,
  8562: CharacterCategory.nl,
  8563: CharacterCategory.nl,
  8564: CharacterCategory.nl,
  8565: CharacterCategory.nl,
  8566: CharacterCategory.nl,
  8567: CharacterCategory.nl,
  8568: CharacterCategory.nl,
  8569: CharacterCategory.nl,
  8570: CharacterCategory.nl,
  8571: CharacterCategory.nl,
  8572: CharacterCategory.nl,
  8573: CharacterCategory.nl,
  8574: CharacterCategory.nl,
  8575: CharacterCategory.nl,
  8576: CharacterCategory.nl,
  8577: CharacterCategory.nl,
  8578: CharacterCategory.nl,
  8581: CharacterCategory.nl,
  8582: CharacterCategory.nl,
  8583: CharacterCategory.nl,
  8584: CharacterCategory.nl,
  12295: CharacterCategory.nl,
  12321: CharacterCategory.nl,
  12322: CharacterCategory.nl,
  12323: CharacterCategory.nl,
  12324: CharacterCategory.nl,
  12325: CharacterCategory.nl,
  12326: CharacterCategory.nl,
  12327: CharacterCategory.nl,
  12328: CharacterCategory.nl,
  12329: CharacterCategory.nl,
  12344: CharacterCategory.nl,
  12345: CharacterCategory.nl,
  12346: CharacterCategory.nl,
  42726: CharacterCategory.nl,
  42727: CharacterCategory.nl,
  42728: CharacterCategory.nl,
  42729: CharacterCategory.nl,
  42730: CharacterCategory.nl,
  42731: CharacterCategory.nl,
  42732: CharacterCategory.nl,
  42733: CharacterCategory.nl,
  42734: CharacterCategory.nl,
  42735: CharacterCategory.nl,
  178: CharacterCategory.no,
  179: CharacterCategory.no,
  185: CharacterCategory.no,
  188: CharacterCategory.no,
  189: CharacterCategory.no,
  190: CharacterCategory.no,
  2548: CharacterCategory.no,
  2549: CharacterCategory.no,
  2550: CharacterCategory.no,
  2551: CharacterCategory.no,
  2552: CharacterCategory.no,
  2553: CharacterCategory.no,
  2930: CharacterCategory.no,
  2931: CharacterCategory.no,
  2932: CharacterCategory.no,
  2933: CharacterCategory.no,
  2934: CharacterCategory.no,
  2935: CharacterCategory.no,
  3056: CharacterCategory.no,
  3057: CharacterCategory.no,
  3058: CharacterCategory.no,
  3192: CharacterCategory.no,
  3193: CharacterCategory.no,
  3194: CharacterCategory.no,
  3195: CharacterCategory.no,
  3196: CharacterCategory.no,
  3197: CharacterCategory.no,
  3198: CharacterCategory.no,
  3440: CharacterCategory.no,
  3441: CharacterCategory.no,
  3442: CharacterCategory.no,
  3443: CharacterCategory.no,
  3444: CharacterCategory.no,
  3445: CharacterCategory.no,
  3882: CharacterCategory.no,
  3883: CharacterCategory.no,
  3884: CharacterCategory.no,
  3885: CharacterCategory.no,
  3886: CharacterCategory.no,
  3887: CharacterCategory.no,
  3888: CharacterCategory.no,
  3889: CharacterCategory.no,
  3890: CharacterCategory.no,
  3891: CharacterCategory.no,
  4969: CharacterCategory.no,
  4970: CharacterCategory.no,
  4971: CharacterCategory.no,
  4972: CharacterCategory.no,
  4973: CharacterCategory.no,
  4974: CharacterCategory.no,
  4975: CharacterCategory.no,
  4976: CharacterCategory.no,
  4977: CharacterCategory.no,
  4978: CharacterCategory.no,
  4979: CharacterCategory.no,
  4980: CharacterCategory.no,
  4981: CharacterCategory.no,
  4982: CharacterCategory.no,
  4983: CharacterCategory.no,
  4984: CharacterCategory.no,
  4985: CharacterCategory.no,
  4986: CharacterCategory.no,
  4987: CharacterCategory.no,
  4988: CharacterCategory.no,
  6128: CharacterCategory.no,
  6129: CharacterCategory.no,
  6130: CharacterCategory.no,
  6131: CharacterCategory.no,
  6132: CharacterCategory.no,
  6133: CharacterCategory.no,
  6134: CharacterCategory.no,
  6135: CharacterCategory.no,
  6136: CharacterCategory.no,
  6137: CharacterCategory.no,
  6618: CharacterCategory.no,
  8304: CharacterCategory.no,
  8308: CharacterCategory.no,
  8309: CharacterCategory.no,
  8310: CharacterCategory.no,
  8311: CharacterCategory.no,
  8312: CharacterCategory.no,
  8313: CharacterCategory.no,
  8320: CharacterCategory.no,
  8321: CharacterCategory.no,
  8322: CharacterCategory.no,
  8323: CharacterCategory.no,
  8324: CharacterCategory.no,
  8325: CharacterCategory.no,
  8326: CharacterCategory.no,
  8327: CharacterCategory.no,
  8328: CharacterCategory.no,
  8329: CharacterCategory.no,
  8528: CharacterCategory.no,
  8529: CharacterCategory.no,
  8530: CharacterCategory.no,
  8531: CharacterCategory.no,
  8532: CharacterCategory.no,
  8533: CharacterCategory.no,
  8534: CharacterCategory.no,
  8535: CharacterCategory.no,
  8536: CharacterCategory.no,
  8537: CharacterCategory.no,
  8538: CharacterCategory.no,
  8539: CharacterCategory.no,
  8540: CharacterCategory.no,
  8541: CharacterCategory.no,
  8542: CharacterCategory.no,
  8543: CharacterCategory.no,
  8585: CharacterCategory.no,
  9312: CharacterCategory.no,
  9313: CharacterCategory.no,
  9314: CharacterCategory.no,
  9315: CharacterCategory.no,
  9316: CharacterCategory.no,
  9317: CharacterCategory.no,
  9318: CharacterCategory.no,
  9319: CharacterCategory.no,
  9320: CharacterCategory.no,
  9321: CharacterCategory.no,
  9322: CharacterCategory.no,
  9323: CharacterCategory.no,
  9324: CharacterCategory.no,
  9325: CharacterCategory.no,
  9326: CharacterCategory.no,
  9327: CharacterCategory.no,
  9328: CharacterCategory.no,
  9329: CharacterCategory.no,
  9330: CharacterCategory.no,
  9331: CharacterCategory.no,
  9332: CharacterCategory.no,
  9333: CharacterCategory.no,
  9334: CharacterCategory.no,
  9335: CharacterCategory.no,
  9336: CharacterCategory.no,
  9337: CharacterCategory.no,
  9338: CharacterCategory.no,
  9339: CharacterCategory.no,
  9340: CharacterCategory.no,
  9341: CharacterCategory.no,
  9342: CharacterCategory.no,
  9343: CharacterCategory.no,
  9344: CharacterCategory.no,
  9345: CharacterCategory.no,
  9346: CharacterCategory.no,
  9347: CharacterCategory.no,
  9348: CharacterCategory.no,
  9349: CharacterCategory.no,
  9350: CharacterCategory.no,
  9351: CharacterCategory.no,
  9352: CharacterCategory.no,
  9353: CharacterCategory.no,
  9354: CharacterCategory.no,
  9355: CharacterCategory.no,
  9356: CharacterCategory.no,
  9357: CharacterCategory.no,
  9358: CharacterCategory.no,
  9359: CharacterCategory.no,
  9360: CharacterCategory.no,
  9361: CharacterCategory.no,
  9362: CharacterCategory.no,
  9363: CharacterCategory.no,
  9364: CharacterCategory.no,
  9365: CharacterCategory.no,
  9366: CharacterCategory.no,
  9367: CharacterCategory.no,
  9368: CharacterCategory.no,
  9369: CharacterCategory.no,
  9370: CharacterCategory.no,
  9371: CharacterCategory.no,
  9450: CharacterCategory.no,
  9451: CharacterCategory.no,
  9452: CharacterCategory.no,
  9453: CharacterCategory.no,
  9454: CharacterCategory.no,
  9455: CharacterCategory.no,
  9456: CharacterCategory.no,
  9457: CharacterCategory.no,
  9458: CharacterCategory.no,
  9459: CharacterCategory.no,
  9460: CharacterCategory.no,
  9461: CharacterCategory.no,
  9462: CharacterCategory.no,
  9463: CharacterCategory.no,
  9464: CharacterCategory.no,
  9465: CharacterCategory.no,
  9466: CharacterCategory.no,
  9467: CharacterCategory.no,
  9468: CharacterCategory.no,
  9469: CharacterCategory.no,
  9470: CharacterCategory.no,
  9471: CharacterCategory.no,
  10102: CharacterCategory.no,
  10103: CharacterCategory.no,
  10104: CharacterCategory.no,
  10105: CharacterCategory.no,
  10106: CharacterCategory.no,
  10107: CharacterCategory.no,
  10108: CharacterCategory.no,
  10109: CharacterCategory.no,
  10110: CharacterCategory.no,
  10111: CharacterCategory.no,
  10112: CharacterCategory.no,
  10113: CharacterCategory.no,
  10114: CharacterCategory.no,
  10115: CharacterCategory.no,
  10116: CharacterCategory.no,
  10117: CharacterCategory.no,
  10118: CharacterCategory.no,
  10119: CharacterCategory.no,
  10120: CharacterCategory.no,
  10121: CharacterCategory.no,
  10122: CharacterCategory.no,
  10123: CharacterCategory.no,
  10124: CharacterCategory.no,
  10125: CharacterCategory.no,
  10126: CharacterCategory.no,
  10127: CharacterCategory.no,
  10128: CharacterCategory.no,
  10129: CharacterCategory.no,
  10130: CharacterCategory.no,
  10131: CharacterCategory.no,
  11517: CharacterCategory.no,
  12690: CharacterCategory.no,
  12691: CharacterCategory.no,
  12692: CharacterCategory.no,
  12693: CharacterCategory.no,
  12832: CharacterCategory.no,
  12833: CharacterCategory.no,
  12834: CharacterCategory.no,
  12835: CharacterCategory.no,
  12836: CharacterCategory.no,
  12837: CharacterCategory.no,
  12838: CharacterCategory.no,
  12839: CharacterCategory.no,
  12840: CharacterCategory.no,
  12841: CharacterCategory.no,
  12872: CharacterCategory.no,
  12873: CharacterCategory.no,
  12874: CharacterCategory.no,
  12875: CharacterCategory.no,
  12876: CharacterCategory.no,
  12877: CharacterCategory.no,
  12878: CharacterCategory.no,
  12879: CharacterCategory.no,
  12881: CharacterCategory.no,
  12882: CharacterCategory.no,
  12883: CharacterCategory.no,
  12884: CharacterCategory.no,
  12885: CharacterCategory.no,
  12886: CharacterCategory.no,
  12887: CharacterCategory.no,
  12888: CharacterCategory.no,
  12889: CharacterCategory.no,
  12890: CharacterCategory.no,
  12891: CharacterCategory.no,
  12892: CharacterCategory.no,
  12893: CharacterCategory.no,
  12894: CharacterCategory.no,
  12895: CharacterCategory.no,
  12928: CharacterCategory.no,
  12929: CharacterCategory.no,
  12930: CharacterCategory.no,
  12931: CharacterCategory.no,
  12932: CharacterCategory.no,
  12933: CharacterCategory.no,
  12934: CharacterCategory.no,
  12935: CharacterCategory.no,
  12936: CharacterCategory.no,
  12937: CharacterCategory.no,
  12977: CharacterCategory.no,
  12978: CharacterCategory.no,
  12979: CharacterCategory.no,
  12980: CharacterCategory.no,
  12981: CharacterCategory.no,
  12982: CharacterCategory.no,
  12983: CharacterCategory.no,
  12984: CharacterCategory.no,
  12985: CharacterCategory.no,
  12986: CharacterCategory.no,
  12987: CharacterCategory.no,
  12988: CharacterCategory.no,
  12989: CharacterCategory.no,
  12990: CharacterCategory.no,
  12991: CharacterCategory.no,
  43056: CharacterCategory.no,
  43057: CharacterCategory.no,
  43058: CharacterCategory.no,
  43059: CharacterCategory.no,
  43060: CharacterCategory.no,
  43061: CharacterCategory.no,
  95: CharacterCategory.pc,
  8255: CharacterCategory.pc,
  8256: CharacterCategory.pc,
  8276: CharacterCategory.pc,
  65075: CharacterCategory.pc,
  65076: CharacterCategory.pc,
  65101: CharacterCategory.pc,
  65102: CharacterCategory.pc,
  65103: CharacterCategory.pc,
  65343: CharacterCategory.pc,
  45: CharacterCategory.pd,
  1418: CharacterCategory.pd,
  1470: CharacterCategory.pd,
  5120: CharacterCategory.pd,
  6150: CharacterCategory.pd,
  8208: CharacterCategory.pd,
  8209: CharacterCategory.pd,
  8210: CharacterCategory.pd,
  8211: CharacterCategory.pd,
  8212: CharacterCategory.pd,
  8213: CharacterCategory.pd,
  11799: CharacterCategory.pd,
  11802: CharacterCategory.pd,
  11834: CharacterCategory.pd,
  11835: CharacterCategory.pd,
  11840: CharacterCategory.pd,
  12316: CharacterCategory.pd,
  12336: CharacterCategory.pd,
  12448: CharacterCategory.pd,
  65073: CharacterCategory.pd,
  65074: CharacterCategory.pd,
  65112: CharacterCategory.pd,
  65123: CharacterCategory.pd,
  65293: CharacterCategory.pd,
  40: CharacterCategory.ps,
  91: CharacterCategory.ps,
  123: CharacterCategory.ps,
  3898: CharacterCategory.ps,
  3900: CharacterCategory.ps,
  5787: CharacterCategory.ps,
  8218: CharacterCategory.ps,
  8222: CharacterCategory.ps,
  8261: CharacterCategory.ps,
  8317: CharacterCategory.ps,
  8333: CharacterCategory.ps,
  8968: CharacterCategory.ps,
  8970: CharacterCategory.ps,
  9001: CharacterCategory.ps,
  10088: CharacterCategory.ps,
  10090: CharacterCategory.ps,
  10092: CharacterCategory.ps,
  10094: CharacterCategory.ps,
  10096: CharacterCategory.ps,
  10098: CharacterCategory.ps,
  10100: CharacterCategory.ps,
  10181: CharacterCategory.ps,
  10214: CharacterCategory.ps,
  10216: CharacterCategory.ps,
  10218: CharacterCategory.ps,
  10220: CharacterCategory.ps,
  10222: CharacterCategory.ps,
  10627: CharacterCategory.ps,
  10629: CharacterCategory.ps,
  10631: CharacterCategory.ps,
  10633: CharacterCategory.ps,
  10635: CharacterCategory.ps,
  10637: CharacterCategory.ps,
  10639: CharacterCategory.ps,
  10641: CharacterCategory.ps,
  10643: CharacterCategory.ps,
  10645: CharacterCategory.ps,
  10647: CharacterCategory.ps,
  10712: CharacterCategory.ps,
  10714: CharacterCategory.ps,
  10748: CharacterCategory.ps,
  11810: CharacterCategory.ps,
  11812: CharacterCategory.ps,
  11814: CharacterCategory.ps,
  11816: CharacterCategory.ps,
  11842: CharacterCategory.ps,
  12296: CharacterCategory.ps,
  12298: CharacterCategory.ps,
  12300: CharacterCategory.ps,
  12302: CharacterCategory.ps,
  12304: CharacterCategory.ps,
  12308: CharacterCategory.ps,
  12310: CharacterCategory.ps,
  12312: CharacterCategory.ps,
  12314: CharacterCategory.ps,
  12317: CharacterCategory.ps,
  64831: CharacterCategory.ps,
  65047: CharacterCategory.ps,
  65077: CharacterCategory.ps,
  65079: CharacterCategory.ps,
  65081: CharacterCategory.ps,
  65083: CharacterCategory.ps,
  65085: CharacterCategory.ps,
  65087: CharacterCategory.ps,
  65089: CharacterCategory.ps,
  65091: CharacterCategory.ps,
  65095: CharacterCategory.ps,
  65113: CharacterCategory.ps,
  65115: CharacterCategory.ps,
  65117: CharacterCategory.ps,
  65288: CharacterCategory.ps,
  65339: CharacterCategory.ps,
  65371: CharacterCategory.ps,
  65375: CharacterCategory.ps,
  65378: CharacterCategory.ps,
  41: CharacterCategory.pe,
  93: CharacterCategory.pe,
  125: CharacterCategory.pe,
  3899: CharacterCategory.pe,
  3901: CharacterCategory.pe,
  5788: CharacterCategory.pe,
  8262: CharacterCategory.pe,
  8318: CharacterCategory.pe,
  8334: CharacterCategory.pe,
  8969: CharacterCategory.pe,
  8971: CharacterCategory.pe,
  9002: CharacterCategory.pe,
  10089: CharacterCategory.pe,
  10091: CharacterCategory.pe,
  10093: CharacterCategory.pe,
  10095: CharacterCategory.pe,
  10097: CharacterCategory.pe,
  10099: CharacterCategory.pe,
  10101: CharacterCategory.pe,
  10182: CharacterCategory.pe,
  10215: CharacterCategory.pe,
  10217: CharacterCategory.pe,
  10219: CharacterCategory.pe,
  10221: CharacterCategory.pe,
  10223: CharacterCategory.pe,
  10628: CharacterCategory.pe,
  10630: CharacterCategory.pe,
  10632: CharacterCategory.pe,
  10634: CharacterCategory.pe,
  10636: CharacterCategory.pe,
  10638: CharacterCategory.pe,
  10640: CharacterCategory.pe,
  10642: CharacterCategory.pe,
  10644: CharacterCategory.pe,
  10646: CharacterCategory.pe,
  10648: CharacterCategory.pe,
  10713: CharacterCategory.pe,
  10715: CharacterCategory.pe,
  10749: CharacterCategory.pe,
  11811: CharacterCategory.pe,
  11813: CharacterCategory.pe,
  11815: CharacterCategory.pe,
  11817: CharacterCategory.pe,
  12297: CharacterCategory.pe,
  12299: CharacterCategory.pe,
  12301: CharacterCategory.pe,
  12303: CharacterCategory.pe,
  12305: CharacterCategory.pe,
  12309: CharacterCategory.pe,
  12311: CharacterCategory.pe,
  12313: CharacterCategory.pe,
  12315: CharacterCategory.pe,
  12318: CharacterCategory.pe,
  12319: CharacterCategory.pe,
  64830: CharacterCategory.pe,
  65048: CharacterCategory.pe,
  65078: CharacterCategory.pe,
  65080: CharacterCategory.pe,
  65082: CharacterCategory.pe,
  65084: CharacterCategory.pe,
  65086: CharacterCategory.pe,
  65088: CharacterCategory.pe,
  65090: CharacterCategory.pe,
  65092: CharacterCategory.pe,
  65096: CharacterCategory.pe,
  65114: CharacterCategory.pe,
  65116: CharacterCategory.pe,
  65118: CharacterCategory.pe,
  65289: CharacterCategory.pe,
  65341: CharacterCategory.pe,
  65373: CharacterCategory.pe,
  65376: CharacterCategory.pe,
  65379: CharacterCategory.pe,
  171: CharacterCategory.pi,
  8216: CharacterCategory.pi,
  8219: CharacterCategory.pi,
  8220: CharacterCategory.pi,
  8223: CharacterCategory.pi,
  8249: CharacterCategory.pi,
  11778: CharacterCategory.pi,
  11780: CharacterCategory.pi,
  11785: CharacterCategory.pi,
  11788: CharacterCategory.pi,
  11804: CharacterCategory.pi,
  11808: CharacterCategory.pi,
  187: CharacterCategory.pf,
  8217: CharacterCategory.pf,
  8221: CharacterCategory.pf,
  8250: CharacterCategory.pf,
  11779: CharacterCategory.pf,
  11781: CharacterCategory.pf,
  11786: CharacterCategory.pf,
  11789: CharacterCategory.pf,
  11805: CharacterCategory.pf,
  11809: CharacterCategory.pf,
  33: CharacterCategory.po,
  34: CharacterCategory.po,
  35: CharacterCategory.po,
  37: CharacterCategory.po,
  38: CharacterCategory.po,
  39: CharacterCategory.po,
  42: CharacterCategory.po,
  44: CharacterCategory.po,
  46: CharacterCategory.po,
  47: CharacterCategory.po,
  58: CharacterCategory.po,
  59: CharacterCategory.po,
  63: CharacterCategory.po,
  64: CharacterCategory.po,
  92: CharacterCategory.po,
  161: CharacterCategory.po,
  167: CharacterCategory.po,
  182: CharacterCategory.po,
  183: CharacterCategory.po,
  191: CharacterCategory.po,
  894: CharacterCategory.po,
  903: CharacterCategory.po,
  1370: CharacterCategory.po,
  1371: CharacterCategory.po,
  1372: CharacterCategory.po,
  1373: CharacterCategory.po,
  1374: CharacterCategory.po,
  1375: CharacterCategory.po,
  1417: CharacterCategory.po,
  1472: CharacterCategory.po,
  1475: CharacterCategory.po,
  1478: CharacterCategory.po,
  1523: CharacterCategory.po,
  1524: CharacterCategory.po,
  1545: CharacterCategory.po,
  1546: CharacterCategory.po,
  1548: CharacterCategory.po,
  1549: CharacterCategory.po,
  1563: CharacterCategory.po,
  1566: CharacterCategory.po,
  1567: CharacterCategory.po,
  1642: CharacterCategory.po,
  1643: CharacterCategory.po,
  1644: CharacterCategory.po,
  1645: CharacterCategory.po,
  1748: CharacterCategory.po,
  1792: CharacterCategory.po,
  1793: CharacterCategory.po,
  1794: CharacterCategory.po,
  1795: CharacterCategory.po,
  1796: CharacterCategory.po,
  1797: CharacterCategory.po,
  1798: CharacterCategory.po,
  1799: CharacterCategory.po,
  1800: CharacterCategory.po,
  1801: CharacterCategory.po,
  1802: CharacterCategory.po,
  1803: CharacterCategory.po,
  1804: CharacterCategory.po,
  1805: CharacterCategory.po,
  2039: CharacterCategory.po,
  2040: CharacterCategory.po,
  2041: CharacterCategory.po,
  2096: CharacterCategory.po,
  2097: CharacterCategory.po,
  2098: CharacterCategory.po,
  2099: CharacterCategory.po,
  2100: CharacterCategory.po,
  2101: CharacterCategory.po,
  2102: CharacterCategory.po,
  2103: CharacterCategory.po,
  2104: CharacterCategory.po,
  2105: CharacterCategory.po,
  2106: CharacterCategory.po,
  2107: CharacterCategory.po,
  2108: CharacterCategory.po,
  2109: CharacterCategory.po,
  2110: CharacterCategory.po,
  2142: CharacterCategory.po,
  2404: CharacterCategory.po,
  2405: CharacterCategory.po,
  2416: CharacterCategory.po,
  2800: CharacterCategory.po,
  3572: CharacterCategory.po,
  3663: CharacterCategory.po,
  3674: CharacterCategory.po,
  3675: CharacterCategory.po,
  3844: CharacterCategory.po,
  3845: CharacterCategory.po,
  3846: CharacterCategory.po,
  3847: CharacterCategory.po,
  3848: CharacterCategory.po,
  3849: CharacterCategory.po,
  3850: CharacterCategory.po,
  3851: CharacterCategory.po,
  3852: CharacterCategory.po,
  3853: CharacterCategory.po,
  3854: CharacterCategory.po,
  3855: CharacterCategory.po,
  3856: CharacterCategory.po,
  3857: CharacterCategory.po,
  3858: CharacterCategory.po,
  3860: CharacterCategory.po,
  3973: CharacterCategory.po,
  4048: CharacterCategory.po,
  4049: CharacterCategory.po,
  4050: CharacterCategory.po,
  4051: CharacterCategory.po,
  4052: CharacterCategory.po,
  4057: CharacterCategory.po,
  4058: CharacterCategory.po,
  4170: CharacterCategory.po,
  4171: CharacterCategory.po,
  4172: CharacterCategory.po,
  4173: CharacterCategory.po,
  4174: CharacterCategory.po,
  4175: CharacterCategory.po,
  4347: CharacterCategory.po,
  4960: CharacterCategory.po,
  4961: CharacterCategory.po,
  4962: CharacterCategory.po,
  4963: CharacterCategory.po,
  4964: CharacterCategory.po,
  4965: CharacterCategory.po,
  4966: CharacterCategory.po,
  4967: CharacterCategory.po,
  4968: CharacterCategory.po,
  5741: CharacterCategory.po,
  5742: CharacterCategory.po,
  5867: CharacterCategory.po,
  5868: CharacterCategory.po,
  5869: CharacterCategory.po,
  5941: CharacterCategory.po,
  5942: CharacterCategory.po,
  6100: CharacterCategory.po,
  6101: CharacterCategory.po,
  6102: CharacterCategory.po,
  6104: CharacterCategory.po,
  6105: CharacterCategory.po,
  6106: CharacterCategory.po,
  6144: CharacterCategory.po,
  6145: CharacterCategory.po,
  6146: CharacterCategory.po,
  6147: CharacterCategory.po,
  6148: CharacterCategory.po,
  6149: CharacterCategory.po,
  6151: CharacterCategory.po,
  6152: CharacterCategory.po,
  6153: CharacterCategory.po,
  6154: CharacterCategory.po,
  6468: CharacterCategory.po,
  6469: CharacterCategory.po,
  6686: CharacterCategory.po,
  6687: CharacterCategory.po,
  6816: CharacterCategory.po,
  6817: CharacterCategory.po,
  6818: CharacterCategory.po,
  6819: CharacterCategory.po,
  6820: CharacterCategory.po,
  6821: CharacterCategory.po,
  6822: CharacterCategory.po,
  6824: CharacterCategory.po,
  6825: CharacterCategory.po,
  6826: CharacterCategory.po,
  6827: CharacterCategory.po,
  6828: CharacterCategory.po,
  6829: CharacterCategory.po,
  7002: CharacterCategory.po,
  7003: CharacterCategory.po,
  7004: CharacterCategory.po,
  7005: CharacterCategory.po,
  7006: CharacterCategory.po,
  7007: CharacterCategory.po,
  7008: CharacterCategory.po,
  7164: CharacterCategory.po,
  7165: CharacterCategory.po,
  7166: CharacterCategory.po,
  7167: CharacterCategory.po,
  7227: CharacterCategory.po,
  7228: CharacterCategory.po,
  7229: CharacterCategory.po,
  7230: CharacterCategory.po,
  7231: CharacterCategory.po,
  7294: CharacterCategory.po,
  7295: CharacterCategory.po,
  7360: CharacterCategory.po,
  7361: CharacterCategory.po,
  7362: CharacterCategory.po,
  7363: CharacterCategory.po,
  7364: CharacterCategory.po,
  7365: CharacterCategory.po,
  7366: CharacterCategory.po,
  7367: CharacterCategory.po,
  7379: CharacterCategory.po,
  8214: CharacterCategory.po,
  8215: CharacterCategory.po,
  8224: CharacterCategory.po,
  8225: CharacterCategory.po,
  8226: CharacterCategory.po,
  8227: CharacterCategory.po,
  8228: CharacterCategory.po,
  8229: CharacterCategory.po,
  8230: CharacterCategory.po,
  8231: CharacterCategory.po,
  8240: CharacterCategory.po,
  8241: CharacterCategory.po,
  8242: CharacterCategory.po,
  8243: CharacterCategory.po,
  8244: CharacterCategory.po,
  8245: CharacterCategory.po,
  8246: CharacterCategory.po,
  8247: CharacterCategory.po,
  8248: CharacterCategory.po,
  8251: CharacterCategory.po,
  8252: CharacterCategory.po,
  8253: CharacterCategory.po,
  8254: CharacterCategory.po,
  8257: CharacterCategory.po,
  8258: CharacterCategory.po,
  8259: CharacterCategory.po,
  8263: CharacterCategory.po,
  8264: CharacterCategory.po,
  8265: CharacterCategory.po,
  8266: CharacterCategory.po,
  8267: CharacterCategory.po,
  8268: CharacterCategory.po,
  8269: CharacterCategory.po,
  8270: CharacterCategory.po,
  8271: CharacterCategory.po,
  8272: CharacterCategory.po,
  8273: CharacterCategory.po,
  8275: CharacterCategory.po,
  8277: CharacterCategory.po,
  8278: CharacterCategory.po,
  8279: CharacterCategory.po,
  8280: CharacterCategory.po,
  8281: CharacterCategory.po,
  8282: CharacterCategory.po,
  8283: CharacterCategory.po,
  8284: CharacterCategory.po,
  8285: CharacterCategory.po,
  8286: CharacterCategory.po,
  11513: CharacterCategory.po,
  11514: CharacterCategory.po,
  11515: CharacterCategory.po,
  11516: CharacterCategory.po,
  11518: CharacterCategory.po,
  11519: CharacterCategory.po,
  11632: CharacterCategory.po,
  11776: CharacterCategory.po,
  11777: CharacterCategory.po,
  11782: CharacterCategory.po,
  11783: CharacterCategory.po,
  11784: CharacterCategory.po,
  11787: CharacterCategory.po,
  11790: CharacterCategory.po,
  11791: CharacterCategory.po,
  11792: CharacterCategory.po,
  11793: CharacterCategory.po,
  11794: CharacterCategory.po,
  11795: CharacterCategory.po,
  11796: CharacterCategory.po,
  11797: CharacterCategory.po,
  11798: CharacterCategory.po,
  11800: CharacterCategory.po,
  11801: CharacterCategory.po,
  11803: CharacterCategory.po,
  11806: CharacterCategory.po,
  11807: CharacterCategory.po,
  11818: CharacterCategory.po,
  11819: CharacterCategory.po,
  11820: CharacterCategory.po,
  11821: CharacterCategory.po,
  11822: CharacterCategory.po,
  11824: CharacterCategory.po,
  11825: CharacterCategory.po,
  11826: CharacterCategory.po,
  11827: CharacterCategory.po,
  11828: CharacterCategory.po,
  11829: CharacterCategory.po,
  11830: CharacterCategory.po,
  11831: CharacterCategory.po,
  11832: CharacterCategory.po,
  11833: CharacterCategory.po,
  11836: CharacterCategory.po,
  11837: CharacterCategory.po,
  11838: CharacterCategory.po,
  11839: CharacterCategory.po,
  11841: CharacterCategory.po,
  12289: CharacterCategory.po,
  12290: CharacterCategory.po,
  12291: CharacterCategory.po,
  12349: CharacterCategory.po,
  12539: CharacterCategory.po,
  42238: CharacterCategory.po,
  42239: CharacterCategory.po,
  42509: CharacterCategory.po,
  42510: CharacterCategory.po,
  42511: CharacterCategory.po,
  42611: CharacterCategory.po,
  42622: CharacterCategory.po,
  42738: CharacterCategory.po,
  42739: CharacterCategory.po,
  42740: CharacterCategory.po,
  42741: CharacterCategory.po,
  42742: CharacterCategory.po,
  42743: CharacterCategory.po,
  43124: CharacterCategory.po,
  43125: CharacterCategory.po,
  43126: CharacterCategory.po,
  43127: CharacterCategory.po,
  43214: CharacterCategory.po,
  43215: CharacterCategory.po,
  43256: CharacterCategory.po,
  43257: CharacterCategory.po,
  43258: CharacterCategory.po,
  43310: CharacterCategory.po,
  43311: CharacterCategory.po,
  43359: CharacterCategory.po,
  43457: CharacterCategory.po,
  43458: CharacterCategory.po,
  43459: CharacterCategory.po,
  43460: CharacterCategory.po,
  43461: CharacterCategory.po,
  43462: CharacterCategory.po,
  43463: CharacterCategory.po,
  43464: CharacterCategory.po,
  43465: CharacterCategory.po,
  43466: CharacterCategory.po,
  43467: CharacterCategory.po,
  43468: CharacterCategory.po,
  43469: CharacterCategory.po,
  43486: CharacterCategory.po,
  43487: CharacterCategory.po,
  43612: CharacterCategory.po,
  43613: CharacterCategory.po,
  43614: CharacterCategory.po,
  43615: CharacterCategory.po,
  43742: CharacterCategory.po,
  43743: CharacterCategory.po,
  43760: CharacterCategory.po,
  43761: CharacterCategory.po,
  44011: CharacterCategory.po,
  65040: CharacterCategory.po,
  65041: CharacterCategory.po,
  65042: CharacterCategory.po,
  65043: CharacterCategory.po,
  65044: CharacterCategory.po,
  65045: CharacterCategory.po,
  65046: CharacterCategory.po,
  65049: CharacterCategory.po,
  65072: CharacterCategory.po,
  65093: CharacterCategory.po,
  65094: CharacterCategory.po,
  65097: CharacterCategory.po,
  65098: CharacterCategory.po,
  65099: CharacterCategory.po,
  65100: CharacterCategory.po,
  65104: CharacterCategory.po,
  65105: CharacterCategory.po,
  65106: CharacterCategory.po,
  65108: CharacterCategory.po,
  65109: CharacterCategory.po,
  65110: CharacterCategory.po,
  65111: CharacterCategory.po,
  65119: CharacterCategory.po,
  65120: CharacterCategory.po,
  65121: CharacterCategory.po,
  65128: CharacterCategory.po,
  65130: CharacterCategory.po,
  65131: CharacterCategory.po,
  65281: CharacterCategory.po,
  65282: CharacterCategory.po,
  65283: CharacterCategory.po,
  65285: CharacterCategory.po,
  65286: CharacterCategory.po,
  65287: CharacterCategory.po,
  65290: CharacterCategory.po,
  65292: CharacterCategory.po,
  65294: CharacterCategory.po,
  65295: CharacterCategory.po,
  65306: CharacterCategory.po,
  65307: CharacterCategory.po,
  65311: CharacterCategory.po,
  65312: CharacterCategory.po,
  65340: CharacterCategory.po,
  65377: CharacterCategory.po,
  65380: CharacterCategory.po,
  65381: CharacterCategory.po,
  43: CharacterCategory.sm,
  60: CharacterCategory.sm,
  61: CharacterCategory.sm,
  62: CharacterCategory.sm,
  124: CharacterCategory.sm,
  126: CharacterCategory.sm,
  172: CharacterCategory.sm,
  177: CharacterCategory.sm,
  215: CharacterCategory.sm,
  247: CharacterCategory.sm,
  1014: CharacterCategory.sm,
  1542: CharacterCategory.sm,
  1543: CharacterCategory.sm,
  1544: CharacterCategory.sm,
  8260: CharacterCategory.sm,
  8274: CharacterCategory.sm,
  8314: CharacterCategory.sm,
  8315: CharacterCategory.sm,
  8316: CharacterCategory.sm,
  8330: CharacterCategory.sm,
  8331: CharacterCategory.sm,
  8332: CharacterCategory.sm,
  8472: CharacterCategory.sm,
  8512: CharacterCategory.sm,
  8513: CharacterCategory.sm,
  8514: CharacterCategory.sm,
  8515: CharacterCategory.sm,
  8516: CharacterCategory.sm,
  8523: CharacterCategory.sm,
  8592: CharacterCategory.sm,
  8593: CharacterCategory.sm,
  8594: CharacterCategory.sm,
  8595: CharacterCategory.sm,
  8596: CharacterCategory.sm,
  8602: CharacterCategory.sm,
  8603: CharacterCategory.sm,
  8608: CharacterCategory.sm,
  8611: CharacterCategory.sm,
  8614: CharacterCategory.sm,
  8622: CharacterCategory.sm,
  8654: CharacterCategory.sm,
  8655: CharacterCategory.sm,
  8658: CharacterCategory.sm,
  8660: CharacterCategory.sm,
  8692: CharacterCategory.sm,
  8693: CharacterCategory.sm,
  8694: CharacterCategory.sm,
  8695: CharacterCategory.sm,
  8696: CharacterCategory.sm,
  8697: CharacterCategory.sm,
  8698: CharacterCategory.sm,
  8699: CharacterCategory.sm,
  8700: CharacterCategory.sm,
  8701: CharacterCategory.sm,
  8702: CharacterCategory.sm,
  8703: CharacterCategory.sm,
  8704: CharacterCategory.sm,
  8705: CharacterCategory.sm,
  8706: CharacterCategory.sm,
  8707: CharacterCategory.sm,
  8708: CharacterCategory.sm,
  8709: CharacterCategory.sm,
  8710: CharacterCategory.sm,
  8711: CharacterCategory.sm,
  8712: CharacterCategory.sm,
  8713: CharacterCategory.sm,
  8714: CharacterCategory.sm,
  8715: CharacterCategory.sm,
  8716: CharacterCategory.sm,
  8717: CharacterCategory.sm,
  8718: CharacterCategory.sm,
  8719: CharacterCategory.sm,
  8720: CharacterCategory.sm,
  8721: CharacterCategory.sm,
  8722: CharacterCategory.sm,
  8723: CharacterCategory.sm,
  8724: CharacterCategory.sm,
  8725: CharacterCategory.sm,
  8726: CharacterCategory.sm,
  8727: CharacterCategory.sm,
  8728: CharacterCategory.sm,
  8729: CharacterCategory.sm,
  8730: CharacterCategory.sm,
  8731: CharacterCategory.sm,
  8732: CharacterCategory.sm,
  8733: CharacterCategory.sm,
  8734: CharacterCategory.sm,
  8735: CharacterCategory.sm,
  8736: CharacterCategory.sm,
  8737: CharacterCategory.sm,
  8738: CharacterCategory.sm,
  8739: CharacterCategory.sm,
  8740: CharacterCategory.sm,
  8741: CharacterCategory.sm,
  8742: CharacterCategory.sm,
  8743: CharacterCategory.sm,
  8744: CharacterCategory.sm,
  8745: CharacterCategory.sm,
  8746: CharacterCategory.sm,
  8747: CharacterCategory.sm,
  8748: CharacterCategory.sm,
  8749: CharacterCategory.sm,
  8750: CharacterCategory.sm,
  8751: CharacterCategory.sm,
  8752: CharacterCategory.sm,
  8753: CharacterCategory.sm,
  8754: CharacterCategory.sm,
  8755: CharacterCategory.sm,
  8756: CharacterCategory.sm,
  8757: CharacterCategory.sm,
  8758: CharacterCategory.sm,
  8759: CharacterCategory.sm,
  8760: CharacterCategory.sm,
  8761: CharacterCategory.sm,
  8762: CharacterCategory.sm,
  8763: CharacterCategory.sm,
  8764: CharacterCategory.sm,
  8765: CharacterCategory.sm,
  8766: CharacterCategory.sm,
  8767: CharacterCategory.sm,
  8768: CharacterCategory.sm,
  8769: CharacterCategory.sm,
  8770: CharacterCategory.sm,
  8771: CharacterCategory.sm,
  8772: CharacterCategory.sm,
  8773: CharacterCategory.sm,
  8774: CharacterCategory.sm,
  8775: CharacterCategory.sm,
  8776: CharacterCategory.sm,
  8777: CharacterCategory.sm,
  8778: CharacterCategory.sm,
  8779: CharacterCategory.sm,
  8780: CharacterCategory.sm,
  8781: CharacterCategory.sm,
  8782: CharacterCategory.sm,
  8783: CharacterCategory.sm,
  8784: CharacterCategory.sm,
  8785: CharacterCategory.sm,
  8786: CharacterCategory.sm,
  8787: CharacterCategory.sm,
  8788: CharacterCategory.sm,
  8789: CharacterCategory.sm,
  8790: CharacterCategory.sm,
  8791: CharacterCategory.sm,
  8792: CharacterCategory.sm,
  8793: CharacterCategory.sm,
  8794: CharacterCategory.sm,
  8795: CharacterCategory.sm,
  8796: CharacterCategory.sm,
  8797: CharacterCategory.sm,
  8798: CharacterCategory.sm,
  8799: CharacterCategory.sm,
  8800: CharacterCategory.sm,
  8801: CharacterCategory.sm,
  8802: CharacterCategory.sm,
  8803: CharacterCategory.sm,
  8804: CharacterCategory.sm,
  8805: CharacterCategory.sm,
  8806: CharacterCategory.sm,
  8807: CharacterCategory.sm,
  8808: CharacterCategory.sm,
  8809: CharacterCategory.sm,
  8810: CharacterCategory.sm,
  8811: CharacterCategory.sm,
  8812: CharacterCategory.sm,
  8813: CharacterCategory.sm,
  8814: CharacterCategory.sm,
  8815: CharacterCategory.sm,
  8816: CharacterCategory.sm,
  8817: CharacterCategory.sm,
  8818: CharacterCategory.sm,
  8819: CharacterCategory.sm,
  8820: CharacterCategory.sm,
  8821: CharacterCategory.sm,
  8822: CharacterCategory.sm,
  8823: CharacterCategory.sm,
  8824: CharacterCategory.sm,
  8825: CharacterCategory.sm,
  8826: CharacterCategory.sm,
  8827: CharacterCategory.sm,
  8828: CharacterCategory.sm,
  8829: CharacterCategory.sm,
  8830: CharacterCategory.sm,
  8831: CharacterCategory.sm,
  8832: CharacterCategory.sm,
  8833: CharacterCategory.sm,
  8834: CharacterCategory.sm,
  8835: CharacterCategory.sm,
  8836: CharacterCategory.sm,
  8837: CharacterCategory.sm,
  8838: CharacterCategory.sm,
  8839: CharacterCategory.sm,
  8840: CharacterCategory.sm,
  8841: CharacterCategory.sm,
  8842: CharacterCategory.sm,
  8843: CharacterCategory.sm,
  8844: CharacterCategory.sm,
  8845: CharacterCategory.sm,
  8846: CharacterCategory.sm,
  8847: CharacterCategory.sm,
  8848: CharacterCategory.sm,
  8849: CharacterCategory.sm,
  8850: CharacterCategory.sm,
  8851: CharacterCategory.sm,
  8852: CharacterCategory.sm,
  8853: CharacterCategory.sm,
  8854: CharacterCategory.sm,
  8855: CharacterCategory.sm,
  8856: CharacterCategory.sm,
  8857: CharacterCategory.sm,
  8858: CharacterCategory.sm,
  8859: CharacterCategory.sm,
  8860: CharacterCategory.sm,
  8861: CharacterCategory.sm,
  8862: CharacterCategory.sm,
  8863: CharacterCategory.sm,
  8864: CharacterCategory.sm,
  8865: CharacterCategory.sm,
  8866: CharacterCategory.sm,
  8867: CharacterCategory.sm,
  8868: CharacterCategory.sm,
  8869: CharacterCategory.sm,
  8870: CharacterCategory.sm,
  8871: CharacterCategory.sm,
  8872: CharacterCategory.sm,
  8873: CharacterCategory.sm,
  8874: CharacterCategory.sm,
  8875: CharacterCategory.sm,
  8876: CharacterCategory.sm,
  8877: CharacterCategory.sm,
  8878: CharacterCategory.sm,
  8879: CharacterCategory.sm,
  8880: CharacterCategory.sm,
  8881: CharacterCategory.sm,
  8882: CharacterCategory.sm,
  8883: CharacterCategory.sm,
  8884: CharacterCategory.sm,
  8885: CharacterCategory.sm,
  8886: CharacterCategory.sm,
  8887: CharacterCategory.sm,
  8888: CharacterCategory.sm,
  8889: CharacterCategory.sm,
  8890: CharacterCategory.sm,
  8891: CharacterCategory.sm,
  8892: CharacterCategory.sm,
  8893: CharacterCategory.sm,
  8894: CharacterCategory.sm,
  8895: CharacterCategory.sm,
  8896: CharacterCategory.sm,
  8897: CharacterCategory.sm,
  8898: CharacterCategory.sm,
  8899: CharacterCategory.sm,
  8900: CharacterCategory.sm,
  8901: CharacterCategory.sm,
  8902: CharacterCategory.sm,
  8903: CharacterCategory.sm,
  8904: CharacterCategory.sm,
  8905: CharacterCategory.sm,
  8906: CharacterCategory.sm,
  8907: CharacterCategory.sm,
  8908: CharacterCategory.sm,
  8909: CharacterCategory.sm,
  8910: CharacterCategory.sm,
  8911: CharacterCategory.sm,
  8912: CharacterCategory.sm,
  8913: CharacterCategory.sm,
  8914: CharacterCategory.sm,
  8915: CharacterCategory.sm,
  8916: CharacterCategory.sm,
  8917: CharacterCategory.sm,
  8918: CharacterCategory.sm,
  8919: CharacterCategory.sm,
  8920: CharacterCategory.sm,
  8921: CharacterCategory.sm,
  8922: CharacterCategory.sm,
  8923: CharacterCategory.sm,
  8924: CharacterCategory.sm,
  8925: CharacterCategory.sm,
  8926: CharacterCategory.sm,
  8927: CharacterCategory.sm,
  8928: CharacterCategory.sm,
  8929: CharacterCategory.sm,
  8930: CharacterCategory.sm,
  8931: CharacterCategory.sm,
  8932: CharacterCategory.sm,
  8933: CharacterCategory.sm,
  8934: CharacterCategory.sm,
  8935: CharacterCategory.sm,
  8936: CharacterCategory.sm,
  8937: CharacterCategory.sm,
  8938: CharacterCategory.sm,
  8939: CharacterCategory.sm,
  8940: CharacterCategory.sm,
  8941: CharacterCategory.sm,
  8942: CharacterCategory.sm,
  8943: CharacterCategory.sm,
  8944: CharacterCategory.sm,
  8945: CharacterCategory.sm,
  8946: CharacterCategory.sm,
  8947: CharacterCategory.sm,
  8948: CharacterCategory.sm,
  8949: CharacterCategory.sm,
  8950: CharacterCategory.sm,
  8951: CharacterCategory.sm,
  8952: CharacterCategory.sm,
  8953: CharacterCategory.sm,
  8954: CharacterCategory.sm,
  8955: CharacterCategory.sm,
  8956: CharacterCategory.sm,
  8957: CharacterCategory.sm,
  8958: CharacterCategory.sm,
  8959: CharacterCategory.sm,
  8992: CharacterCategory.sm,
  8993: CharacterCategory.sm,
  9084: CharacterCategory.sm,
  9115: CharacterCategory.sm,
  9116: CharacterCategory.sm,
  9117: CharacterCategory.sm,
  9118: CharacterCategory.sm,
  9119: CharacterCategory.sm,
  9120: CharacterCategory.sm,
  9121: CharacterCategory.sm,
  9122: CharacterCategory.sm,
  9123: CharacterCategory.sm,
  9124: CharacterCategory.sm,
  9125: CharacterCategory.sm,
  9126: CharacterCategory.sm,
  9127: CharacterCategory.sm,
  9128: CharacterCategory.sm,
  9129: CharacterCategory.sm,
  9130: CharacterCategory.sm,
  9131: CharacterCategory.sm,
  9132: CharacterCategory.sm,
  9133: CharacterCategory.sm,
  9134: CharacterCategory.sm,
  9135: CharacterCategory.sm,
  9136: CharacterCategory.sm,
  9137: CharacterCategory.sm,
  9138: CharacterCategory.sm,
  9139: CharacterCategory.sm,
  9180: CharacterCategory.sm,
  9181: CharacterCategory.sm,
  9182: CharacterCategory.sm,
  9183: CharacterCategory.sm,
  9184: CharacterCategory.sm,
  9185: CharacterCategory.sm,
  9655: CharacterCategory.sm,
  9665: CharacterCategory.sm,
  9720: CharacterCategory.sm,
  9721: CharacterCategory.sm,
  9722: CharacterCategory.sm,
  9723: CharacterCategory.sm,
  9724: CharacterCategory.sm,
  9725: CharacterCategory.sm,
  9726: CharacterCategory.sm,
  9727: CharacterCategory.sm,
  9839: CharacterCategory.sm,
  10176: CharacterCategory.sm,
  10177: CharacterCategory.sm,
  10178: CharacterCategory.sm,
  10179: CharacterCategory.sm,
  10180: CharacterCategory.sm,
  10183: CharacterCategory.sm,
  10184: CharacterCategory.sm,
  10185: CharacterCategory.sm,
  10186: CharacterCategory.sm,
  10187: CharacterCategory.sm,
  10188: CharacterCategory.sm,
  10189: CharacterCategory.sm,
  10190: CharacterCategory.sm,
  10191: CharacterCategory.sm,
  10192: CharacterCategory.sm,
  10193: CharacterCategory.sm,
  10194: CharacterCategory.sm,
  10195: CharacterCategory.sm,
  10196: CharacterCategory.sm,
  10197: CharacterCategory.sm,
  10198: CharacterCategory.sm,
  10199: CharacterCategory.sm,
  10200: CharacterCategory.sm,
  10201: CharacterCategory.sm,
  10202: CharacterCategory.sm,
  10203: CharacterCategory.sm,
  10204: CharacterCategory.sm,
  10205: CharacterCategory.sm,
  10206: CharacterCategory.sm,
  10207: CharacterCategory.sm,
  10208: CharacterCategory.sm,
  10209: CharacterCategory.sm,
  10210: CharacterCategory.sm,
  10211: CharacterCategory.sm,
  10212: CharacterCategory.sm,
  10213: CharacterCategory.sm,
  10224: CharacterCategory.sm,
  10225: CharacterCategory.sm,
  10226: CharacterCategory.sm,
  10227: CharacterCategory.sm,
  10228: CharacterCategory.sm,
  10229: CharacterCategory.sm,
  10230: CharacterCategory.sm,
  10231: CharacterCategory.sm,
  10232: CharacterCategory.sm,
  10233: CharacterCategory.sm,
  10234: CharacterCategory.sm,
  10235: CharacterCategory.sm,
  10236: CharacterCategory.sm,
  10237: CharacterCategory.sm,
  10238: CharacterCategory.sm,
  10239: CharacterCategory.sm,
  10496: CharacterCategory.sm,
  10497: CharacterCategory.sm,
  10498: CharacterCategory.sm,
  10499: CharacterCategory.sm,
  10500: CharacterCategory.sm,
  10501: CharacterCategory.sm,
  10502: CharacterCategory.sm,
  10503: CharacterCategory.sm,
  10504: CharacterCategory.sm,
  10505: CharacterCategory.sm,
  10506: CharacterCategory.sm,
  10507: CharacterCategory.sm,
  10508: CharacterCategory.sm,
  10509: CharacterCategory.sm,
  10510: CharacterCategory.sm,
  10511: CharacterCategory.sm,
  10512: CharacterCategory.sm,
  10513: CharacterCategory.sm,
  10514: CharacterCategory.sm,
  10515: CharacterCategory.sm,
  10516: CharacterCategory.sm,
  10517: CharacterCategory.sm,
  10518: CharacterCategory.sm,
  10519: CharacterCategory.sm,
  10520: CharacterCategory.sm,
  10521: CharacterCategory.sm,
  10522: CharacterCategory.sm,
  10523: CharacterCategory.sm,
  10524: CharacterCategory.sm,
  10525: CharacterCategory.sm,
  10526: CharacterCategory.sm,
  10527: CharacterCategory.sm,
  10528: CharacterCategory.sm,
  10529: CharacterCategory.sm,
  10530: CharacterCategory.sm,
  10531: CharacterCategory.sm,
  10532: CharacterCategory.sm,
  10533: CharacterCategory.sm,
  10534: CharacterCategory.sm,
  10535: CharacterCategory.sm,
  10536: CharacterCategory.sm,
  10537: CharacterCategory.sm,
  10538: CharacterCategory.sm,
  10539: CharacterCategory.sm,
  10540: CharacterCategory.sm,
  10541: CharacterCategory.sm,
  10542: CharacterCategory.sm,
  10543: CharacterCategory.sm,
  10544: CharacterCategory.sm,
  10545: CharacterCategory.sm,
  10546: CharacterCategory.sm,
  10547: CharacterCategory.sm,
  10548: CharacterCategory.sm,
  10549: CharacterCategory.sm,
  10550: CharacterCategory.sm,
  10551: CharacterCategory.sm,
  10552: CharacterCategory.sm,
  10553: CharacterCategory.sm,
  10554: CharacterCategory.sm,
  10555: CharacterCategory.sm,
  10556: CharacterCategory.sm,
  10557: CharacterCategory.sm,
  10558: CharacterCategory.sm,
  10559: CharacterCategory.sm,
  10560: CharacterCategory.sm,
  10561: CharacterCategory.sm,
  10562: CharacterCategory.sm,
  10563: CharacterCategory.sm,
  10564: CharacterCategory.sm,
  10565: CharacterCategory.sm,
  10566: CharacterCategory.sm,
  10567: CharacterCategory.sm,
  10568: CharacterCategory.sm,
  10569: CharacterCategory.sm,
  10570: CharacterCategory.sm,
  10571: CharacterCategory.sm,
  10572: CharacterCategory.sm,
  10573: CharacterCategory.sm,
  10574: CharacterCategory.sm,
  10575: CharacterCategory.sm,
  10576: CharacterCategory.sm,
  10577: CharacterCategory.sm,
  10578: CharacterCategory.sm,
  10579: CharacterCategory.sm,
  10580: CharacterCategory.sm,
  10581: CharacterCategory.sm,
  10582: CharacterCategory.sm,
  10583: CharacterCategory.sm,
  10584: CharacterCategory.sm,
  10585: CharacterCategory.sm,
  10586: CharacterCategory.sm,
  10587: CharacterCategory.sm,
  10588: CharacterCategory.sm,
  10589: CharacterCategory.sm,
  10590: CharacterCategory.sm,
  10591: CharacterCategory.sm,
  10592: CharacterCategory.sm,
  10593: CharacterCategory.sm,
  10594: CharacterCategory.sm,
  10595: CharacterCategory.sm,
  10596: CharacterCategory.sm,
  10597: CharacterCategory.sm,
  10598: CharacterCategory.sm,
  10599: CharacterCategory.sm,
  10600: CharacterCategory.sm,
  10601: CharacterCategory.sm,
  10602: CharacterCategory.sm,
  10603: CharacterCategory.sm,
  10604: CharacterCategory.sm,
  10605: CharacterCategory.sm,
  10606: CharacterCategory.sm,
  10607: CharacterCategory.sm,
  10608: CharacterCategory.sm,
  10609: CharacterCategory.sm,
  10610: CharacterCategory.sm,
  10611: CharacterCategory.sm,
  10612: CharacterCategory.sm,
  10613: CharacterCategory.sm,
  10614: CharacterCategory.sm,
  10615: CharacterCategory.sm,
  10616: CharacterCategory.sm,
  10617: CharacterCategory.sm,
  10618: CharacterCategory.sm,
  10619: CharacterCategory.sm,
  10620: CharacterCategory.sm,
  10621: CharacterCategory.sm,
  10622: CharacterCategory.sm,
  10623: CharacterCategory.sm,
  10624: CharacterCategory.sm,
  10625: CharacterCategory.sm,
  10626: CharacterCategory.sm,
  10649: CharacterCategory.sm,
  10650: CharacterCategory.sm,
  10651: CharacterCategory.sm,
  10652: CharacterCategory.sm,
  10653: CharacterCategory.sm,
  10654: CharacterCategory.sm,
  10655: CharacterCategory.sm,
  10656: CharacterCategory.sm,
  10657: CharacterCategory.sm,
  10658: CharacterCategory.sm,
  10659: CharacterCategory.sm,
  10660: CharacterCategory.sm,
  10661: CharacterCategory.sm,
  10662: CharacterCategory.sm,
  10663: CharacterCategory.sm,
  10664: CharacterCategory.sm,
  10665: CharacterCategory.sm,
  10666: CharacterCategory.sm,
  10667: CharacterCategory.sm,
  10668: CharacterCategory.sm,
  10669: CharacterCategory.sm,
  10670: CharacterCategory.sm,
  10671: CharacterCategory.sm,
  10672: CharacterCategory.sm,
  10673: CharacterCategory.sm,
  10674: CharacterCategory.sm,
  10675: CharacterCategory.sm,
  10676: CharacterCategory.sm,
  10677: CharacterCategory.sm,
  10678: CharacterCategory.sm,
  10679: CharacterCategory.sm,
  10680: CharacterCategory.sm,
  10681: CharacterCategory.sm,
  10682: CharacterCategory.sm,
  10683: CharacterCategory.sm,
  10684: CharacterCategory.sm,
  10685: CharacterCategory.sm,
  10686: CharacterCategory.sm,
  10687: CharacterCategory.sm,
  10688: CharacterCategory.sm,
  10689: CharacterCategory.sm,
  10690: CharacterCategory.sm,
  10691: CharacterCategory.sm,
  10692: CharacterCategory.sm,
  10693: CharacterCategory.sm,
  10694: CharacterCategory.sm,
  10695: CharacterCategory.sm,
  10696: CharacterCategory.sm,
  10697: CharacterCategory.sm,
  10698: CharacterCategory.sm,
  10699: CharacterCategory.sm,
  10700: CharacterCategory.sm,
  10701: CharacterCategory.sm,
  10702: CharacterCategory.sm,
  10703: CharacterCategory.sm,
  10704: CharacterCategory.sm,
  10705: CharacterCategory.sm,
  10706: CharacterCategory.sm,
  10707: CharacterCategory.sm,
  10708: CharacterCategory.sm,
  10709: CharacterCategory.sm,
  10710: CharacterCategory.sm,
  10711: CharacterCategory.sm,
  10716: CharacterCategory.sm,
  10717: CharacterCategory.sm,
  10718: CharacterCategory.sm,
  10719: CharacterCategory.sm,
  10720: CharacterCategory.sm,
  10721: CharacterCategory.sm,
  10722: CharacterCategory.sm,
  10723: CharacterCategory.sm,
  10724: CharacterCategory.sm,
  10725: CharacterCategory.sm,
  10726: CharacterCategory.sm,
  10727: CharacterCategory.sm,
  10728: CharacterCategory.sm,
  10729: CharacterCategory.sm,
  10730: CharacterCategory.sm,
  10731: CharacterCategory.sm,
  10732: CharacterCategory.sm,
  10733: CharacterCategory.sm,
  10734: CharacterCategory.sm,
  10735: CharacterCategory.sm,
  10736: CharacterCategory.sm,
  10737: CharacterCategory.sm,
  10738: CharacterCategory.sm,
  10739: CharacterCategory.sm,
  10740: CharacterCategory.sm,
  10741: CharacterCategory.sm,
  10742: CharacterCategory.sm,
  10743: CharacterCategory.sm,
  10744: CharacterCategory.sm,
  10745: CharacterCategory.sm,
  10746: CharacterCategory.sm,
  10747: CharacterCategory.sm,
  10750: CharacterCategory.sm,
  10751: CharacterCategory.sm,
  10752: CharacterCategory.sm,
  10753: CharacterCategory.sm,
  10754: CharacterCategory.sm,
  10755: CharacterCategory.sm,
  10756: CharacterCategory.sm,
  10757: CharacterCategory.sm,
  10758: CharacterCategory.sm,
  10759: CharacterCategory.sm,
  10760: CharacterCategory.sm,
  10761: CharacterCategory.sm,
  10762: CharacterCategory.sm,
  10763: CharacterCategory.sm,
  10764: CharacterCategory.sm,
  10765: CharacterCategory.sm,
  10766: CharacterCategory.sm,
  10767: CharacterCategory.sm,
  10768: CharacterCategory.sm,
  10769: CharacterCategory.sm,
  10770: CharacterCategory.sm,
  10771: CharacterCategory.sm,
  10772: CharacterCategory.sm,
  10773: CharacterCategory.sm,
  10774: CharacterCategory.sm,
  10775: CharacterCategory.sm,
  10776: CharacterCategory.sm,
  10777: CharacterCategory.sm,
  10778: CharacterCategory.sm,
  10779: CharacterCategory.sm,
  10780: CharacterCategory.sm,
  10781: CharacterCategory.sm,
  10782: CharacterCategory.sm,
  10783: CharacterCategory.sm,
  10784: CharacterCategory.sm,
  10785: CharacterCategory.sm,
  10786: CharacterCategory.sm,
  10787: CharacterCategory.sm,
  10788: CharacterCategory.sm,
  10789: CharacterCategory.sm,
  10790: CharacterCategory.sm,
  10791: CharacterCategory.sm,
  10792: CharacterCategory.sm,
  10793: CharacterCategory.sm,
  10794: CharacterCategory.sm,
  10795: CharacterCategory.sm,
  10796: CharacterCategory.sm,
  10797: CharacterCategory.sm,
  10798: CharacterCategory.sm,
  10799: CharacterCategory.sm,
  10800: CharacterCategory.sm,
  10801: CharacterCategory.sm,
  10802: CharacterCategory.sm,
  10803: CharacterCategory.sm,
  10804: CharacterCategory.sm,
  10805: CharacterCategory.sm,
  10806: CharacterCategory.sm,
  10807: CharacterCategory.sm,
  10808: CharacterCategory.sm,
  10809: CharacterCategory.sm,
  10810: CharacterCategory.sm,
  10811: CharacterCategory.sm,
  10812: CharacterCategory.sm,
  10813: CharacterCategory.sm,
  10814: CharacterCategory.sm,
  10815: CharacterCategory.sm,
  10816: CharacterCategory.sm,
  10817: CharacterCategory.sm,
  10818: CharacterCategory.sm,
  10819: CharacterCategory.sm,
  10820: CharacterCategory.sm,
  10821: CharacterCategory.sm,
  10822: CharacterCategory.sm,
  10823: CharacterCategory.sm,
  10824: CharacterCategory.sm,
  10825: CharacterCategory.sm,
  10826: CharacterCategory.sm,
  10827: CharacterCategory.sm,
  10828: CharacterCategory.sm,
  10829: CharacterCategory.sm,
  10830: CharacterCategory.sm,
  10831: CharacterCategory.sm,
  10832: CharacterCategory.sm,
  10833: CharacterCategory.sm,
  10834: CharacterCategory.sm,
  10835: CharacterCategory.sm,
  10836: CharacterCategory.sm,
  10837: CharacterCategory.sm,
  10838: CharacterCategory.sm,
  10839: CharacterCategory.sm,
  10840: CharacterCategory.sm,
  10841: CharacterCategory.sm,
  10842: CharacterCategory.sm,
  10843: CharacterCategory.sm,
  10844: CharacterCategory.sm,
  10845: CharacterCategory.sm,
  10846: CharacterCategory.sm,
  10847: CharacterCategory.sm,
  10848: CharacterCategory.sm,
  10849: CharacterCategory.sm,
  10850: CharacterCategory.sm,
  10851: CharacterCategory.sm,
  10852: CharacterCategory.sm,
  10853: CharacterCategory.sm,
  10854: CharacterCategory.sm,
  10855: CharacterCategory.sm,
  10856: CharacterCategory.sm,
  10857: CharacterCategory.sm,
  10858: CharacterCategory.sm,
  10859: CharacterCategory.sm,
  10860: CharacterCategory.sm,
  10861: CharacterCategory.sm,
  10862: CharacterCategory.sm,
  10863: CharacterCategory.sm,
  10864: CharacterCategory.sm,
  10865: CharacterCategory.sm,
  10866: CharacterCategory.sm,
  10867: CharacterCategory.sm,
  10868: CharacterCategory.sm,
  10869: CharacterCategory.sm,
  10870: CharacterCategory.sm,
  10871: CharacterCategory.sm,
  10872: CharacterCategory.sm,
  10873: CharacterCategory.sm,
  10874: CharacterCategory.sm,
  10875: CharacterCategory.sm,
  10876: CharacterCategory.sm,
  10877: CharacterCategory.sm,
  10878: CharacterCategory.sm,
  10879: CharacterCategory.sm,
  10880: CharacterCategory.sm,
  10881: CharacterCategory.sm,
  10882: CharacterCategory.sm,
  10883: CharacterCategory.sm,
  10884: CharacterCategory.sm,
  10885: CharacterCategory.sm,
  10886: CharacterCategory.sm,
  10887: CharacterCategory.sm,
  10888: CharacterCategory.sm,
  10889: CharacterCategory.sm,
  10890: CharacterCategory.sm,
  10891: CharacterCategory.sm,
  10892: CharacterCategory.sm,
  10893: CharacterCategory.sm,
  10894: CharacterCategory.sm,
  10895: CharacterCategory.sm,
  10896: CharacterCategory.sm,
  10897: CharacterCategory.sm,
  10898: CharacterCategory.sm,
  10899: CharacterCategory.sm,
  10900: CharacterCategory.sm,
  10901: CharacterCategory.sm,
  10902: CharacterCategory.sm,
  10903: CharacterCategory.sm,
  10904: CharacterCategory.sm,
  10905: CharacterCategory.sm,
  10906: CharacterCategory.sm,
  10907: CharacterCategory.sm,
  10908: CharacterCategory.sm,
  10909: CharacterCategory.sm,
  10910: CharacterCategory.sm,
  10911: CharacterCategory.sm,
  10912: CharacterCategory.sm,
  10913: CharacterCategory.sm,
  10914: CharacterCategory.sm,
  10915: CharacterCategory.sm,
  10916: CharacterCategory.sm,
  10917: CharacterCategory.sm,
  10918: CharacterCategory.sm,
  10919: CharacterCategory.sm,
  10920: CharacterCategory.sm,
  10921: CharacterCategory.sm,
  10922: CharacterCategory.sm,
  10923: CharacterCategory.sm,
  10924: CharacterCategory.sm,
  10925: CharacterCategory.sm,
  10926: CharacterCategory.sm,
  10927: CharacterCategory.sm,
  10928: CharacterCategory.sm,
  10929: CharacterCategory.sm,
  10930: CharacterCategory.sm,
  10931: CharacterCategory.sm,
  10932: CharacterCategory.sm,
  10933: CharacterCategory.sm,
  10934: CharacterCategory.sm,
  10935: CharacterCategory.sm,
  10936: CharacterCategory.sm,
  10937: CharacterCategory.sm,
  10938: CharacterCategory.sm,
  10939: CharacterCategory.sm,
  10940: CharacterCategory.sm,
  10941: CharacterCategory.sm,
  10942: CharacterCategory.sm,
  10943: CharacterCategory.sm,
  10944: CharacterCategory.sm,
  10945: CharacterCategory.sm,
  10946: CharacterCategory.sm,
  10947: CharacterCategory.sm,
  10948: CharacterCategory.sm,
  10949: CharacterCategory.sm,
  10950: CharacterCategory.sm,
  10951: CharacterCategory.sm,
  10952: CharacterCategory.sm,
  10953: CharacterCategory.sm,
  10954: CharacterCategory.sm,
  10955: CharacterCategory.sm,
  10956: CharacterCategory.sm,
  10957: CharacterCategory.sm,
  10958: CharacterCategory.sm,
  10959: CharacterCategory.sm,
  10960: CharacterCategory.sm,
  10961: CharacterCategory.sm,
  10962: CharacterCategory.sm,
  10963: CharacterCategory.sm,
  10964: CharacterCategory.sm,
  10965: CharacterCategory.sm,
  10966: CharacterCategory.sm,
  10967: CharacterCategory.sm,
  10968: CharacterCategory.sm,
  10969: CharacterCategory.sm,
  10970: CharacterCategory.sm,
  10971: CharacterCategory.sm,
  10972: CharacterCategory.sm,
  10973: CharacterCategory.sm,
  10974: CharacterCategory.sm,
  10975: CharacterCategory.sm,
  10976: CharacterCategory.sm,
  10977: CharacterCategory.sm,
  10978: CharacterCategory.sm,
  10979: CharacterCategory.sm,
  10980: CharacterCategory.sm,
  10981: CharacterCategory.sm,
  10982: CharacterCategory.sm,
  10983: CharacterCategory.sm,
  10984: CharacterCategory.sm,
  10985: CharacterCategory.sm,
  10986: CharacterCategory.sm,
  10987: CharacterCategory.sm,
  10988: CharacterCategory.sm,
  10989: CharacterCategory.sm,
  10990: CharacterCategory.sm,
  10991: CharacterCategory.sm,
  10992: CharacterCategory.sm,
  10993: CharacterCategory.sm,
  10994: CharacterCategory.sm,
  10995: CharacterCategory.sm,
  10996: CharacterCategory.sm,
  10997: CharacterCategory.sm,
  10998: CharacterCategory.sm,
  10999: CharacterCategory.sm,
  11000: CharacterCategory.sm,
  11001: CharacterCategory.sm,
  11002: CharacterCategory.sm,
  11003: CharacterCategory.sm,
  11004: CharacterCategory.sm,
  11005: CharacterCategory.sm,
  11006: CharacterCategory.sm,
  11007: CharacterCategory.sm,
  11056: CharacterCategory.sm,
  11057: CharacterCategory.sm,
  11058: CharacterCategory.sm,
  11059: CharacterCategory.sm,
  11060: CharacterCategory.sm,
  11061: CharacterCategory.sm,
  11062: CharacterCategory.sm,
  11063: CharacterCategory.sm,
  11064: CharacterCategory.sm,
  11065: CharacterCategory.sm,
  11066: CharacterCategory.sm,
  11067: CharacterCategory.sm,
  11068: CharacterCategory.sm,
  11069: CharacterCategory.sm,
  11070: CharacterCategory.sm,
  11071: CharacterCategory.sm,
  11072: CharacterCategory.sm,
  11073: CharacterCategory.sm,
  11074: CharacterCategory.sm,
  11075: CharacterCategory.sm,
  11076: CharacterCategory.sm,
  11079: CharacterCategory.sm,
  11080: CharacterCategory.sm,
  11081: CharacterCategory.sm,
  11082: CharacterCategory.sm,
  11083: CharacterCategory.sm,
  11084: CharacterCategory.sm,
  64297: CharacterCategory.sm,
  65122: CharacterCategory.sm,
  65124: CharacterCategory.sm,
  65125: CharacterCategory.sm,
  65126: CharacterCategory.sm,
  65291: CharacterCategory.sm,
  65308: CharacterCategory.sm,
  65309: CharacterCategory.sm,
  65310: CharacterCategory.sm,
  65372: CharacterCategory.sm,
  65374: CharacterCategory.sm,
  65506: CharacterCategory.sm,
  65513: CharacterCategory.sm,
  65514: CharacterCategory.sm,
  65515: CharacterCategory.sm,
  65516: CharacterCategory.sm,
  36: CharacterCategory.sc,
  162: CharacterCategory.sc,
  163: CharacterCategory.sc,
  164: CharacterCategory.sc,
  165: CharacterCategory.sc,
  1423: CharacterCategory.sc,
  1547: CharacterCategory.sc,
  2546: CharacterCategory.sc,
  2547: CharacterCategory.sc,
  2555: CharacterCategory.sc,
  2801: CharacterCategory.sc,
  3065: CharacterCategory.sc,
  3647: CharacterCategory.sc,
  6107: CharacterCategory.sc,
  8352: CharacterCategory.sc,
  8353: CharacterCategory.sc,
  8354: CharacterCategory.sc,
  8355: CharacterCategory.sc,
  8356: CharacterCategory.sc,
  8357: CharacterCategory.sc,
  8358: CharacterCategory.sc,
  8359: CharacterCategory.sc,
  8360: CharacterCategory.sc,
  8361: CharacterCategory.sc,
  8362: CharacterCategory.sc,
  8363: CharacterCategory.sc,
  8364: CharacterCategory.sc,
  8365: CharacterCategory.sc,
  8366: CharacterCategory.sc,
  8367: CharacterCategory.sc,
  8368: CharacterCategory.sc,
  8369: CharacterCategory.sc,
  8370: CharacterCategory.sc,
  8371: CharacterCategory.sc,
  8372: CharacterCategory.sc,
  8373: CharacterCategory.sc,
  8374: CharacterCategory.sc,
  8375: CharacterCategory.sc,
  8376: CharacterCategory.sc,
  8377: CharacterCategory.sc,
  8378: CharacterCategory.sc,
  8379: CharacterCategory.sc,
  8380: CharacterCategory.sc,
  8381: CharacterCategory.sc,
  43064: CharacterCategory.sc,
  65020: CharacterCategory.sc,
  65129: CharacterCategory.sc,
  65284: CharacterCategory.sc,
  65504: CharacterCategory.sc,
  65505: CharacterCategory.sc,
  65509: CharacterCategory.sc,
  65510: CharacterCategory.sc,
  94: CharacterCategory.sk,
  96: CharacterCategory.sk,
  168: CharacterCategory.sk,
  175: CharacterCategory.sk,
  180: CharacterCategory.sk,
  184: CharacterCategory.sk,
  706: CharacterCategory.sk,
  707: CharacterCategory.sk,
  708: CharacterCategory.sk,
  709: CharacterCategory.sk,
  722: CharacterCategory.sk,
  723: CharacterCategory.sk,
  724: CharacterCategory.sk,
  725: CharacterCategory.sk,
  726: CharacterCategory.sk,
  727: CharacterCategory.sk,
  728: CharacterCategory.sk,
  729: CharacterCategory.sk,
  730: CharacterCategory.sk,
  731: CharacterCategory.sk,
  732: CharacterCategory.sk,
  733: CharacterCategory.sk,
  734: CharacterCategory.sk,
  735: CharacterCategory.sk,
  741: CharacterCategory.sk,
  742: CharacterCategory.sk,
  743: CharacterCategory.sk,
  744: CharacterCategory.sk,
  745: CharacterCategory.sk,
  746: CharacterCategory.sk,
  747: CharacterCategory.sk,
  749: CharacterCategory.sk,
  751: CharacterCategory.sk,
  752: CharacterCategory.sk,
  753: CharacterCategory.sk,
  754: CharacterCategory.sk,
  755: CharacterCategory.sk,
  756: CharacterCategory.sk,
  757: CharacterCategory.sk,
  758: CharacterCategory.sk,
  759: CharacterCategory.sk,
  760: CharacterCategory.sk,
  761: CharacterCategory.sk,
  762: CharacterCategory.sk,
  763: CharacterCategory.sk,
  764: CharacterCategory.sk,
  765: CharacterCategory.sk,
  766: CharacterCategory.sk,
  767: CharacterCategory.sk,
  885: CharacterCategory.sk,
  900: CharacterCategory.sk,
  901: CharacterCategory.sk,
  8125: CharacterCategory.sk,
  8127: CharacterCategory.sk,
  8128: CharacterCategory.sk,
  8129: CharacterCategory.sk,
  8141: CharacterCategory.sk,
  8142: CharacterCategory.sk,
  8143: CharacterCategory.sk,
  8157: CharacterCategory.sk,
  8158: CharacterCategory.sk,
  8159: CharacterCategory.sk,
  8173: CharacterCategory.sk,
  8174: CharacterCategory.sk,
  8175: CharacterCategory.sk,
  8189: CharacterCategory.sk,
  8190: CharacterCategory.sk,
  12443: CharacterCategory.sk,
  12444: CharacterCategory.sk,
  42752: CharacterCategory.sk,
  42753: CharacterCategory.sk,
  42754: CharacterCategory.sk,
  42755: CharacterCategory.sk,
  42756: CharacterCategory.sk,
  42757: CharacterCategory.sk,
  42758: CharacterCategory.sk,
  42759: CharacterCategory.sk,
  42760: CharacterCategory.sk,
  42761: CharacterCategory.sk,
  42762: CharacterCategory.sk,
  42763: CharacterCategory.sk,
  42764: CharacterCategory.sk,
  42765: CharacterCategory.sk,
  42766: CharacterCategory.sk,
  42767: CharacterCategory.sk,
  42768: CharacterCategory.sk,
  42769: CharacterCategory.sk,
  42770: CharacterCategory.sk,
  42771: CharacterCategory.sk,
  42772: CharacterCategory.sk,
  42773: CharacterCategory.sk,
  42774: CharacterCategory.sk,
  42784: CharacterCategory.sk,
  42785: CharacterCategory.sk,
  42889: CharacterCategory.sk,
  42890: CharacterCategory.sk,
  43867: CharacterCategory.sk,
  64434: CharacterCategory.sk,
  64435: CharacterCategory.sk,
  64436: CharacterCategory.sk,
  64437: CharacterCategory.sk,
  64438: CharacterCategory.sk,
  64439: CharacterCategory.sk,
  64440: CharacterCategory.sk,
  64441: CharacterCategory.sk,
  64442: CharacterCategory.sk,
  64443: CharacterCategory.sk,
  64444: CharacterCategory.sk,
  64445: CharacterCategory.sk,
  64446: CharacterCategory.sk,
  64447: CharacterCategory.sk,
  64448: CharacterCategory.sk,
  64449: CharacterCategory.sk,
  65342: CharacterCategory.sk,
  65344: CharacterCategory.sk,
  65507: CharacterCategory.sk,
  166: CharacterCategory.so,
  169: CharacterCategory.so,
  174: CharacterCategory.so,
  176: CharacterCategory.so,
  1154: CharacterCategory.so,
  1421: CharacterCategory.so,
  1422: CharacterCategory.so,
  1550: CharacterCategory.so,
  1551: CharacterCategory.so,
  1758: CharacterCategory.so,
  1769: CharacterCategory.so,
  1789: CharacterCategory.so,
  1790: CharacterCategory.so,
  2038: CharacterCategory.so,
  2554: CharacterCategory.so,
  2928: CharacterCategory.so,
  3059: CharacterCategory.so,
  3060: CharacterCategory.so,
  3061: CharacterCategory.so,
  3062: CharacterCategory.so,
  3063: CharacterCategory.so,
  3064: CharacterCategory.so,
  3066: CharacterCategory.so,
  3199: CharacterCategory.so,
  3449: CharacterCategory.so,
  3841: CharacterCategory.so,
  3842: CharacterCategory.so,
  3843: CharacterCategory.so,
  3859: CharacterCategory.so,
  3861: CharacterCategory.so,
  3862: CharacterCategory.so,
  3863: CharacterCategory.so,
  3866: CharacterCategory.so,
  3867: CharacterCategory.so,
  3868: CharacterCategory.so,
  3869: CharacterCategory.so,
  3870: CharacterCategory.so,
  3871: CharacterCategory.so,
  3892: CharacterCategory.so,
  3894: CharacterCategory.so,
  3896: CharacterCategory.so,
  4030: CharacterCategory.so,
  4031: CharacterCategory.so,
  4032: CharacterCategory.so,
  4033: CharacterCategory.so,
  4034: CharacterCategory.so,
  4035: CharacterCategory.so,
  4036: CharacterCategory.so,
  4037: CharacterCategory.so,
  4039: CharacterCategory.so,
  4040: CharacterCategory.so,
  4041: CharacterCategory.so,
  4042: CharacterCategory.so,
  4043: CharacterCategory.so,
  4044: CharacterCategory.so,
  4046: CharacterCategory.so,
  4047: CharacterCategory.so,
  4053: CharacterCategory.so,
  4054: CharacterCategory.so,
  4055: CharacterCategory.so,
  4056: CharacterCategory.so,
  4254: CharacterCategory.so,
  4255: CharacterCategory.so,
  5008: CharacterCategory.so,
  5009: CharacterCategory.so,
  5010: CharacterCategory.so,
  5011: CharacterCategory.so,
  5012: CharacterCategory.so,
  5013: CharacterCategory.so,
  5014: CharacterCategory.so,
  5015: CharacterCategory.so,
  5016: CharacterCategory.so,
  5017: CharacterCategory.so,
  6464: CharacterCategory.so,
  6622: CharacterCategory.so,
  6623: CharacterCategory.so,
  6624: CharacterCategory.so,
  6625: CharacterCategory.so,
  6626: CharacterCategory.so,
  6627: CharacterCategory.so,
  6628: CharacterCategory.so,
  6629: CharacterCategory.so,
  6630: CharacterCategory.so,
  6631: CharacterCategory.so,
  6632: CharacterCategory.so,
  6633: CharacterCategory.so,
  6634: CharacterCategory.so,
  6635: CharacterCategory.so,
  6636: CharacterCategory.so,
  6637: CharacterCategory.so,
  6638: CharacterCategory.so,
  6639: CharacterCategory.so,
  6640: CharacterCategory.so,
  6641: CharacterCategory.so,
  6642: CharacterCategory.so,
  6643: CharacterCategory.so,
  6644: CharacterCategory.so,
  6645: CharacterCategory.so,
  6646: CharacterCategory.so,
  6647: CharacterCategory.so,
  6648: CharacterCategory.so,
  6649: CharacterCategory.so,
  6650: CharacterCategory.so,
  6651: CharacterCategory.so,
  6652: CharacterCategory.so,
  6653: CharacterCategory.so,
  6654: CharacterCategory.so,
  6655: CharacterCategory.so,
  7009: CharacterCategory.so,
  7010: CharacterCategory.so,
  7011: CharacterCategory.so,
  7012: CharacterCategory.so,
  7013: CharacterCategory.so,
  7014: CharacterCategory.so,
  7015: CharacterCategory.so,
  7016: CharacterCategory.so,
  7017: CharacterCategory.so,
  7018: CharacterCategory.so,
  7028: CharacterCategory.so,
  7029: CharacterCategory.so,
  7030: CharacterCategory.so,
  7031: CharacterCategory.so,
  7032: CharacterCategory.so,
  7033: CharacterCategory.so,
  7034: CharacterCategory.so,
  7035: CharacterCategory.so,
  7036: CharacterCategory.so,
  8448: CharacterCategory.so,
  8449: CharacterCategory.so,
  8451: CharacterCategory.so,
  8452: CharacterCategory.so,
  8453: CharacterCategory.so,
  8454: CharacterCategory.so,
  8456: CharacterCategory.so,
  8457: CharacterCategory.so,
  8468: CharacterCategory.so,
  8470: CharacterCategory.so,
  8471: CharacterCategory.so,
  8478: CharacterCategory.so,
  8479: CharacterCategory.so,
  8480: CharacterCategory.so,
  8481: CharacterCategory.so,
  8482: CharacterCategory.so,
  8483: CharacterCategory.so,
  8485: CharacterCategory.so,
  8487: CharacterCategory.so,
  8489: CharacterCategory.so,
  8494: CharacterCategory.so,
  8506: CharacterCategory.so,
  8507: CharacterCategory.so,
  8522: CharacterCategory.so,
  8524: CharacterCategory.so,
  8525: CharacterCategory.so,
  8527: CharacterCategory.so,
  8597: CharacterCategory.so,
  8598: CharacterCategory.so,
  8599: CharacterCategory.so,
  8600: CharacterCategory.so,
  8601: CharacterCategory.so,
  8604: CharacterCategory.so,
  8605: CharacterCategory.so,
  8606: CharacterCategory.so,
  8607: CharacterCategory.so,
  8609: CharacterCategory.so,
  8610: CharacterCategory.so,
  8612: CharacterCategory.so,
  8613: CharacterCategory.so,
  8615: CharacterCategory.so,
  8616: CharacterCategory.so,
  8617: CharacterCategory.so,
  8618: CharacterCategory.so,
  8619: CharacterCategory.so,
  8620: CharacterCategory.so,
  8621: CharacterCategory.so,
  8623: CharacterCategory.so,
  8624: CharacterCategory.so,
  8625: CharacterCategory.so,
  8626: CharacterCategory.so,
  8627: CharacterCategory.so,
  8628: CharacterCategory.so,
  8629: CharacterCategory.so,
  8630: CharacterCategory.so,
  8631: CharacterCategory.so,
  8632: CharacterCategory.so,
  8633: CharacterCategory.so,
  8634: CharacterCategory.so,
  8635: CharacterCategory.so,
  8636: CharacterCategory.so,
  8637: CharacterCategory.so,
  8638: CharacterCategory.so,
  8639: CharacterCategory.so,
  8640: CharacterCategory.so,
  8641: CharacterCategory.so,
  8642: CharacterCategory.so,
  8643: CharacterCategory.so,
  8644: CharacterCategory.so,
  8645: CharacterCategory.so,
  8646: CharacterCategory.so,
  8647: CharacterCategory.so,
  8648: CharacterCategory.so,
  8649: CharacterCategory.so,
  8650: CharacterCategory.so,
  8651: CharacterCategory.so,
  8652: CharacterCategory.so,
  8653: CharacterCategory.so,
  8656: CharacterCategory.so,
  8657: CharacterCategory.so,
  8659: CharacterCategory.so,
  8661: CharacterCategory.so,
  8662: CharacterCategory.so,
  8663: CharacterCategory.so,
  8664: CharacterCategory.so,
  8665: CharacterCategory.so,
  8666: CharacterCategory.so,
  8667: CharacterCategory.so,
  8668: CharacterCategory.so,
  8669: CharacterCategory.so,
  8670: CharacterCategory.so,
  8671: CharacterCategory.so,
  8672: CharacterCategory.so,
  8673: CharacterCategory.so,
  8674: CharacterCategory.so,
  8675: CharacterCategory.so,
  8676: CharacterCategory.so,
  8677: CharacterCategory.so,
  8678: CharacterCategory.so,
  8679: CharacterCategory.so,
  8680: CharacterCategory.so,
  8681: CharacterCategory.so,
  8682: CharacterCategory.so,
  8683: CharacterCategory.so,
  8684: CharacterCategory.so,
  8685: CharacterCategory.so,
  8686: CharacterCategory.so,
  8687: CharacterCategory.so,
  8688: CharacterCategory.so,
  8689: CharacterCategory.so,
  8690: CharacterCategory.so,
  8691: CharacterCategory.so,
  8960: CharacterCategory.so,
  8961: CharacterCategory.so,
  8962: CharacterCategory.so,
  8963: CharacterCategory.so,
  8964: CharacterCategory.so,
  8965: CharacterCategory.so,
  8966: CharacterCategory.so,
  8967: CharacterCategory.so,
  8972: CharacterCategory.so,
  8973: CharacterCategory.so,
  8974: CharacterCategory.so,
  8975: CharacterCategory.so,
  8976: CharacterCategory.so,
  8977: CharacterCategory.so,
  8978: CharacterCategory.so,
  8979: CharacterCategory.so,
  8980: CharacterCategory.so,
  8981: CharacterCategory.so,
  8982: CharacterCategory.so,
  8983: CharacterCategory.so,
  8984: CharacterCategory.so,
  8985: CharacterCategory.so,
  8986: CharacterCategory.so,
  8987: CharacterCategory.so,
  8988: CharacterCategory.so,
  8989: CharacterCategory.so,
  8990: CharacterCategory.so,
  8991: CharacterCategory.so,
  8994: CharacterCategory.so,
  8995: CharacterCategory.so,
  8996: CharacterCategory.so,
  8997: CharacterCategory.so,
  8998: CharacterCategory.so,
  8999: CharacterCategory.so,
  9000: CharacterCategory.so,
  9003: CharacterCategory.so,
  9004: CharacterCategory.so,
  9005: CharacterCategory.so,
  9006: CharacterCategory.so,
  9007: CharacterCategory.so,
  9008: CharacterCategory.so,
  9009: CharacterCategory.so,
  9010: CharacterCategory.so,
  9011: CharacterCategory.so,
  9012: CharacterCategory.so,
  9013: CharacterCategory.so,
  9014: CharacterCategory.so,
  9015: CharacterCategory.so,
  9016: CharacterCategory.so,
  9017: CharacterCategory.so,
  9018: CharacterCategory.so,
  9019: CharacterCategory.so,
  9020: CharacterCategory.so,
  9021: CharacterCategory.so,
  9022: CharacterCategory.so,
  9023: CharacterCategory.so,
  9024: CharacterCategory.so,
  9025: CharacterCategory.so,
  9026: CharacterCategory.so,
  9027: CharacterCategory.so,
  9028: CharacterCategory.so,
  9029: CharacterCategory.so,
  9030: CharacterCategory.so,
  9031: CharacterCategory.so,
  9032: CharacterCategory.so,
  9033: CharacterCategory.so,
  9034: CharacterCategory.so,
  9035: CharacterCategory.so,
  9036: CharacterCategory.so,
  9037: CharacterCategory.so,
  9038: CharacterCategory.so,
  9039: CharacterCategory.so,
  9040: CharacterCategory.so,
  9041: CharacterCategory.so,
  9042: CharacterCategory.so,
  9043: CharacterCategory.so,
  9044: CharacterCategory.so,
  9045: CharacterCategory.so,
  9046: CharacterCategory.so,
  9047: CharacterCategory.so,
  9048: CharacterCategory.so,
  9049: CharacterCategory.so,
  9050: CharacterCategory.so,
  9051: CharacterCategory.so,
  9052: CharacterCategory.so,
  9053: CharacterCategory.so,
  9054: CharacterCategory.so,
  9055: CharacterCategory.so,
  9056: CharacterCategory.so,
  9057: CharacterCategory.so,
  9058: CharacterCategory.so,
  9059: CharacterCategory.so,
  9060: CharacterCategory.so,
  9061: CharacterCategory.so,
  9062: CharacterCategory.so,
  9063: CharacterCategory.so,
  9064: CharacterCategory.so,
  9065: CharacterCategory.so,
  9066: CharacterCategory.so,
  9067: CharacterCategory.so,
  9068: CharacterCategory.so,
  9069: CharacterCategory.so,
  9070: CharacterCategory.so,
  9071: CharacterCategory.so,
  9072: CharacterCategory.so,
  9073: CharacterCategory.so,
  9074: CharacterCategory.so,
  9075: CharacterCategory.so,
  9076: CharacterCategory.so,
  9077: CharacterCategory.so,
  9078: CharacterCategory.so,
  9079: CharacterCategory.so,
  9080: CharacterCategory.so,
  9081: CharacterCategory.so,
  9082: CharacterCategory.so,
  9083: CharacterCategory.so,
  9085: CharacterCategory.so,
  9086: CharacterCategory.so,
  9087: CharacterCategory.so,
  9088: CharacterCategory.so,
  9089: CharacterCategory.so,
  9090: CharacterCategory.so,
  9091: CharacterCategory.so,
  9092: CharacterCategory.so,
  9093: CharacterCategory.so,
  9094: CharacterCategory.so,
  9095: CharacterCategory.so,
  9096: CharacterCategory.so,
  9097: CharacterCategory.so,
  9098: CharacterCategory.so,
  9099: CharacterCategory.so,
  9100: CharacterCategory.so,
  9101: CharacterCategory.so,
  9102: CharacterCategory.so,
  9103: CharacterCategory.so,
  9104: CharacterCategory.so,
  9105: CharacterCategory.so,
  9106: CharacterCategory.so,
  9107: CharacterCategory.so,
  9108: CharacterCategory.so,
  9109: CharacterCategory.so,
  9110: CharacterCategory.so,
  9111: CharacterCategory.so,
  9112: CharacterCategory.so,
  9113: CharacterCategory.so,
  9114: CharacterCategory.so,
  9140: CharacterCategory.so,
  9141: CharacterCategory.so,
  9142: CharacterCategory.so,
  9143: CharacterCategory.so,
  9144: CharacterCategory.so,
  9145: CharacterCategory.so,
  9146: CharacterCategory.so,
  9147: CharacterCategory.so,
  9148: CharacterCategory.so,
  9149: CharacterCategory.so,
  9150: CharacterCategory.so,
  9151: CharacterCategory.so,
  9152: CharacterCategory.so,
  9153: CharacterCategory.so,
  9154: CharacterCategory.so,
  9155: CharacterCategory.so,
  9156: CharacterCategory.so,
  9157: CharacterCategory.so,
  9158: CharacterCategory.so,
  9159: CharacterCategory.so,
  9160: CharacterCategory.so,
  9161: CharacterCategory.so,
  9162: CharacterCategory.so,
  9163: CharacterCategory.so,
  9164: CharacterCategory.so,
  9165: CharacterCategory.so,
  9166: CharacterCategory.so,
  9167: CharacterCategory.so,
  9168: CharacterCategory.so,
  9169: CharacterCategory.so,
  9170: CharacterCategory.so,
  9171: CharacterCategory.so,
  9172: CharacterCategory.so,
  9173: CharacterCategory.so,
  9174: CharacterCategory.so,
  9175: CharacterCategory.so,
  9176: CharacterCategory.so,
  9177: CharacterCategory.so,
  9178: CharacterCategory.so,
  9179: CharacterCategory.so,
  9186: CharacterCategory.so,
  9187: CharacterCategory.so,
  9188: CharacterCategory.so,
  9189: CharacterCategory.so,
  9190: CharacterCategory.so,
  9191: CharacterCategory.so,
  9192: CharacterCategory.so,
  9193: CharacterCategory.so,
  9194: CharacterCategory.so,
  9195: CharacterCategory.so,
  9196: CharacterCategory.so,
  9197: CharacterCategory.so,
  9198: CharacterCategory.so,
  9199: CharacterCategory.so,
  9200: CharacterCategory.so,
  9201: CharacterCategory.so,
  9202: CharacterCategory.so,
  9203: CharacterCategory.so,
  9204: CharacterCategory.so,
  9205: CharacterCategory.so,
  9206: CharacterCategory.so,
  9207: CharacterCategory.so,
  9208: CharacterCategory.so,
  9209: CharacterCategory.so,
  9210: CharacterCategory.so,
  9216: CharacterCategory.so,
  9217: CharacterCategory.so,
  9218: CharacterCategory.so,
  9219: CharacterCategory.so,
  9220: CharacterCategory.so,
  9221: CharacterCategory.so,
  9222: CharacterCategory.so,
  9223: CharacterCategory.so,
  9224: CharacterCategory.so,
  9225: CharacterCategory.so,
  9226: CharacterCategory.so,
  9227: CharacterCategory.so,
  9228: CharacterCategory.so,
  9229: CharacterCategory.so,
  9230: CharacterCategory.so,
  9231: CharacterCategory.so,
  9232: CharacterCategory.so,
  9233: CharacterCategory.so,
  9234: CharacterCategory.so,
  9235: CharacterCategory.so,
  9236: CharacterCategory.so,
  9237: CharacterCategory.so,
  9238: CharacterCategory.so,
  9239: CharacterCategory.so,
  9240: CharacterCategory.so,
  9241: CharacterCategory.so,
  9242: CharacterCategory.so,
  9243: CharacterCategory.so,
  9244: CharacterCategory.so,
  9245: CharacterCategory.so,
  9246: CharacterCategory.so,
  9247: CharacterCategory.so,
  9248: CharacterCategory.so,
  9249: CharacterCategory.so,
  9250: CharacterCategory.so,
  9251: CharacterCategory.so,
  9252: CharacterCategory.so,
  9253: CharacterCategory.so,
  9254: CharacterCategory.so,
  9280: CharacterCategory.so,
  9281: CharacterCategory.so,
  9282: CharacterCategory.so,
  9283: CharacterCategory.so,
  9284: CharacterCategory.so,
  9285: CharacterCategory.so,
  9286: CharacterCategory.so,
  9287: CharacterCategory.so,
  9288: CharacterCategory.so,
  9289: CharacterCategory.so,
  9290: CharacterCategory.so,
  9372: CharacterCategory.so,
  9373: CharacterCategory.so,
  9374: CharacterCategory.so,
  9375: CharacterCategory.so,
  9376: CharacterCategory.so,
  9377: CharacterCategory.so,
  9378: CharacterCategory.so,
  9379: CharacterCategory.so,
  9380: CharacterCategory.so,
  9381: CharacterCategory.so,
  9382: CharacterCategory.so,
  9383: CharacterCategory.so,
  9384: CharacterCategory.so,
  9385: CharacterCategory.so,
  9386: CharacterCategory.so,
  9387: CharacterCategory.so,
  9388: CharacterCategory.so,
  9389: CharacterCategory.so,
  9390: CharacterCategory.so,
  9391: CharacterCategory.so,
  9392: CharacterCategory.so,
  9393: CharacterCategory.so,
  9394: CharacterCategory.so,
  9395: CharacterCategory.so,
  9396: CharacterCategory.so,
  9397: CharacterCategory.so,
  9398: CharacterCategory.so,
  9399: CharacterCategory.so,
  9400: CharacterCategory.so,
  9401: CharacterCategory.so,
  9402: CharacterCategory.so,
  9403: CharacterCategory.so,
  9404: CharacterCategory.so,
  9405: CharacterCategory.so,
  9406: CharacterCategory.so,
  9407: CharacterCategory.so,
  9408: CharacterCategory.so,
  9409: CharacterCategory.so,
  9410: CharacterCategory.so,
  9411: CharacterCategory.so,
  9412: CharacterCategory.so,
  9413: CharacterCategory.so,
  9414: CharacterCategory.so,
  9415: CharacterCategory.so,
  9416: CharacterCategory.so,
  9417: CharacterCategory.so,
  9418: CharacterCategory.so,
  9419: CharacterCategory.so,
  9420: CharacterCategory.so,
  9421: CharacterCategory.so,
  9422: CharacterCategory.so,
  9423: CharacterCategory.so,
  9424: CharacterCategory.so,
  9425: CharacterCategory.so,
  9426: CharacterCategory.so,
  9427: CharacterCategory.so,
  9428: CharacterCategory.so,
  9429: CharacterCategory.so,
  9430: CharacterCategory.so,
  9431: CharacterCategory.so,
  9432: CharacterCategory.so,
  9433: CharacterCategory.so,
  9434: CharacterCategory.so,
  9435: CharacterCategory.so,
  9436: CharacterCategory.so,
  9437: CharacterCategory.so,
  9438: CharacterCategory.so,
  9439: CharacterCategory.so,
  9440: CharacterCategory.so,
  9441: CharacterCategory.so,
  9442: CharacterCategory.so,
  9443: CharacterCategory.so,
  9444: CharacterCategory.so,
  9445: CharacterCategory.so,
  9446: CharacterCategory.so,
  9447: CharacterCategory.so,
  9448: CharacterCategory.so,
  9449: CharacterCategory.so,
  9472: CharacterCategory.so,
  9473: CharacterCategory.so,
  9474: CharacterCategory.so,
  9475: CharacterCategory.so,
  9476: CharacterCategory.so,
  9477: CharacterCategory.so,
  9478: CharacterCategory.so,
  9479: CharacterCategory.so,
  9480: CharacterCategory.so,
  9481: CharacterCategory.so,
  9482: CharacterCategory.so,
  9483: CharacterCategory.so,
  9484: CharacterCategory.so,
  9485: CharacterCategory.so,
  9486: CharacterCategory.so,
  9487: CharacterCategory.so,
  9488: CharacterCategory.so,
  9489: CharacterCategory.so,
  9490: CharacterCategory.so,
  9491: CharacterCategory.so,
  9492: CharacterCategory.so,
  9493: CharacterCategory.so,
  9494: CharacterCategory.so,
  9495: CharacterCategory.so,
  9496: CharacterCategory.so,
  9497: CharacterCategory.so,
  9498: CharacterCategory.so,
  9499: CharacterCategory.so,
  9500: CharacterCategory.so,
  9501: CharacterCategory.so,
  9502: CharacterCategory.so,
  9503: CharacterCategory.so,
  9504: CharacterCategory.so,
  9505: CharacterCategory.so,
  9506: CharacterCategory.so,
  9507: CharacterCategory.so,
  9508: CharacterCategory.so,
  9509: CharacterCategory.so,
  9510: CharacterCategory.so,
  9511: CharacterCategory.so,
  9512: CharacterCategory.so,
  9513: CharacterCategory.so,
  9514: CharacterCategory.so,
  9515: CharacterCategory.so,
  9516: CharacterCategory.so,
  9517: CharacterCategory.so,
  9518: CharacterCategory.so,
  9519: CharacterCategory.so,
  9520: CharacterCategory.so,
  9521: CharacterCategory.so,
  9522: CharacterCategory.so,
  9523: CharacterCategory.so,
  9524: CharacterCategory.so,
  9525: CharacterCategory.so,
  9526: CharacterCategory.so,
  9527: CharacterCategory.so,
  9528: CharacterCategory.so,
  9529: CharacterCategory.so,
  9530: CharacterCategory.so,
  9531: CharacterCategory.so,
  9532: CharacterCategory.so,
  9533: CharacterCategory.so,
  9534: CharacterCategory.so,
  9535: CharacterCategory.so,
  9536: CharacterCategory.so,
  9537: CharacterCategory.so,
  9538: CharacterCategory.so,
  9539: CharacterCategory.so,
  9540: CharacterCategory.so,
  9541: CharacterCategory.so,
  9542: CharacterCategory.so,
  9543: CharacterCategory.so,
  9544: CharacterCategory.so,
  9545: CharacterCategory.so,
  9546: CharacterCategory.so,
  9547: CharacterCategory.so,
  9548: CharacterCategory.so,
  9549: CharacterCategory.so,
  9550: CharacterCategory.so,
  9551: CharacterCategory.so,
  9552: CharacterCategory.so,
  9553: CharacterCategory.so,
  9554: CharacterCategory.so,
  9555: CharacterCategory.so,
  9556: CharacterCategory.so,
  9557: CharacterCategory.so,
  9558: CharacterCategory.so,
  9559: CharacterCategory.so,
  9560: CharacterCategory.so,
  9561: CharacterCategory.so,
  9562: CharacterCategory.so,
  9563: CharacterCategory.so,
  9564: CharacterCategory.so,
  9565: CharacterCategory.so,
  9566: CharacterCategory.so,
  9567: CharacterCategory.so,
  9568: CharacterCategory.so,
  9569: CharacterCategory.so,
  9570: CharacterCategory.so,
  9571: CharacterCategory.so,
  9572: CharacterCategory.so,
  9573: CharacterCategory.so,
  9574: CharacterCategory.so,
  9575: CharacterCategory.so,
  9576: CharacterCategory.so,
  9577: CharacterCategory.so,
  9578: CharacterCategory.so,
  9579: CharacterCategory.so,
  9580: CharacterCategory.so,
  9581: CharacterCategory.so,
  9582: CharacterCategory.so,
  9583: CharacterCategory.so,
  9584: CharacterCategory.so,
  9585: CharacterCategory.so,
  9586: CharacterCategory.so,
  9587: CharacterCategory.so,
  9588: CharacterCategory.so,
  9589: CharacterCategory.so,
  9590: CharacterCategory.so,
  9591: CharacterCategory.so,
  9592: CharacterCategory.so,
  9593: CharacterCategory.so,
  9594: CharacterCategory.so,
  9595: CharacterCategory.so,
  9596: CharacterCategory.so,
  9597: CharacterCategory.so,
  9598: CharacterCategory.so,
  9599: CharacterCategory.so,
  9600: CharacterCategory.so,
  9601: CharacterCategory.so,
  9602: CharacterCategory.so,
  9603: CharacterCategory.so,
  9604: CharacterCategory.so,
  9605: CharacterCategory.so,
  9606: CharacterCategory.so,
  9607: CharacterCategory.so,
  9608: CharacterCategory.so,
  9609: CharacterCategory.so,
  9610: CharacterCategory.so,
  9611: CharacterCategory.so,
  9612: CharacterCategory.so,
  9613: CharacterCategory.so,
  9614: CharacterCategory.so,
  9615: CharacterCategory.so,
  9616: CharacterCategory.so,
  9617: CharacterCategory.so,
  9618: CharacterCategory.so,
  9619: CharacterCategory.so,
  9620: CharacterCategory.so,
  9621: CharacterCategory.so,
  9622: CharacterCategory.so,
  9623: CharacterCategory.so,
  9624: CharacterCategory.so,
  9625: CharacterCategory.so,
  9626: CharacterCategory.so,
  9627: CharacterCategory.so,
  9628: CharacterCategory.so,
  9629: CharacterCategory.so,
  9630: CharacterCategory.so,
  9631: CharacterCategory.so,
  9632: CharacterCategory.so,
  9633: CharacterCategory.so,
  9634: CharacterCategory.so,
  9635: CharacterCategory.so,
  9636: CharacterCategory.so,
  9637: CharacterCategory.so,
  9638: CharacterCategory.so,
  9639: CharacterCategory.so,
  9640: CharacterCategory.so,
  9641: CharacterCategory.so,
  9642: CharacterCategory.so,
  9643: CharacterCategory.so,
  9644: CharacterCategory.so,
  9645: CharacterCategory.so,
  9646: CharacterCategory.so,
  9647: CharacterCategory.so,
  9648: CharacterCategory.so,
  9649: CharacterCategory.so,
  9650: CharacterCategory.so,
  9651: CharacterCategory.so,
  9652: CharacterCategory.so,
  9653: CharacterCategory.so,
  9654: CharacterCategory.so,
  9656: CharacterCategory.so,
  9657: CharacterCategory.so,
  9658: CharacterCategory.so,
  9659: CharacterCategory.so,
  9660: CharacterCategory.so,
  9661: CharacterCategory.so,
  9662: CharacterCategory.so,
  9663: CharacterCategory.so,
  9664: CharacterCategory.so,
  9666: CharacterCategory.so,
  9667: CharacterCategory.so,
  9668: CharacterCategory.so,
  9669: CharacterCategory.so,
  9670: CharacterCategory.so,
  9671: CharacterCategory.so,
  9672: CharacterCategory.so,
  9673: CharacterCategory.so,
  9674: CharacterCategory.so,
  9675: CharacterCategory.so,
  9676: CharacterCategory.so,
  9677: CharacterCategory.so,
  9678: CharacterCategory.so,
  9679: CharacterCategory.so,
  9680: CharacterCategory.so,
  9681: CharacterCategory.so,
  9682: CharacterCategory.so,
  9683: CharacterCategory.so,
  9684: CharacterCategory.so,
  9685: CharacterCategory.so,
  9686: CharacterCategory.so,
  9687: CharacterCategory.so,
  9688: CharacterCategory.so,
  9689: CharacterCategory.so,
  9690: CharacterCategory.so,
  9691: CharacterCategory.so,
  9692: CharacterCategory.so,
  9693: CharacterCategory.so,
  9694: CharacterCategory.so,
  9695: CharacterCategory.so,
  9696: CharacterCategory.so,
  9697: CharacterCategory.so,
  9698: CharacterCategory.so,
  9699: CharacterCategory.so,
  9700: CharacterCategory.so,
  9701: CharacterCategory.so,
  9702: CharacterCategory.so,
  9703: CharacterCategory.so,
  9704: CharacterCategory.so,
  9705: CharacterCategory.so,
  9706: CharacterCategory.so,
  9707: CharacterCategory.so,
  9708: CharacterCategory.so,
  9709: CharacterCategory.so,
  9710: CharacterCategory.so,
  9711: CharacterCategory.so,
  9712: CharacterCategory.so,
  9713: CharacterCategory.so,
  9714: CharacterCategory.so,
  9715: CharacterCategory.so,
  9716: CharacterCategory.so,
  9717: CharacterCategory.so,
  9718: CharacterCategory.so,
  9719: CharacterCategory.so,
  9728: CharacterCategory.so,
  9729: CharacterCategory.so,
  9730: CharacterCategory.so,
  9731: CharacterCategory.so,
  9732: CharacterCategory.so,
  9733: CharacterCategory.so,
  9734: CharacterCategory.so,
  9735: CharacterCategory.so,
  9736: CharacterCategory.so,
  9737: CharacterCategory.so,
  9738: CharacterCategory.so,
  9739: CharacterCategory.so,
  9740: CharacterCategory.so,
  9741: CharacterCategory.so,
  9742: CharacterCategory.so,
  9743: CharacterCategory.so,
  9744: CharacterCategory.so,
  9745: CharacterCategory.so,
  9746: CharacterCategory.so,
  9747: CharacterCategory.so,
  9748: CharacterCategory.so,
  9749: CharacterCategory.so,
  9750: CharacterCategory.so,
  9751: CharacterCategory.so,
  9752: CharacterCategory.so,
  9753: CharacterCategory.so,
  9754: CharacterCategory.so,
  9755: CharacterCategory.so,
  9756: CharacterCategory.so,
  9757: CharacterCategory.so,
  9758: CharacterCategory.so,
  9759: CharacterCategory.so,
  9760: CharacterCategory.so,
  9761: CharacterCategory.so,
  9762: CharacterCategory.so,
  9763: CharacterCategory.so,
  9764: CharacterCategory.so,
  9765: CharacterCategory.so,
  9766: CharacterCategory.so,
  9767: CharacterCategory.so,
  9768: CharacterCategory.so,
  9769: CharacterCategory.so,
  9770: CharacterCategory.so,
  9771: CharacterCategory.so,
  9772: CharacterCategory.so,
  9773: CharacterCategory.so,
  9774: CharacterCategory.so,
  9775: CharacterCategory.so,
  9776: CharacterCategory.so,
  9777: CharacterCategory.so,
  9778: CharacterCategory.so,
  9779: CharacterCategory.so,
  9780: CharacterCategory.so,
  9781: CharacterCategory.so,
  9782: CharacterCategory.so,
  9783: CharacterCategory.so,
  9784: CharacterCategory.so,
  9785: CharacterCategory.so,
  9786: CharacterCategory.so,
  9787: CharacterCategory.so,
  9788: CharacterCategory.so,
  9789: CharacterCategory.so,
  9790: CharacterCategory.so,
  9791: CharacterCategory.so,
  9792: CharacterCategory.so,
  9793: CharacterCategory.so,
  9794: CharacterCategory.so,
  9795: CharacterCategory.so,
  9796: CharacterCategory.so,
  9797: CharacterCategory.so,
  9798: CharacterCategory.so,
  9799: CharacterCategory.so,
  9800: CharacterCategory.so,
  9801: CharacterCategory.so,
  9802: CharacterCategory.so,
  9803: CharacterCategory.so,
  9804: CharacterCategory.so,
  9805: CharacterCategory.so,
  9806: CharacterCategory.so,
  9807: CharacterCategory.so,
  9808: CharacterCategory.so,
  9809: CharacterCategory.so,
  9810: CharacterCategory.so,
  9811: CharacterCategory.so,
  9812: CharacterCategory.so,
  9813: CharacterCategory.so,
  9814: CharacterCategory.so,
  9815: CharacterCategory.so,
  9816: CharacterCategory.so,
  9817: CharacterCategory.so,
  9818: CharacterCategory.so,
  9819: CharacterCategory.so,
  9820: CharacterCategory.so,
  9821: CharacterCategory.so,
  9822: CharacterCategory.so,
  9823: CharacterCategory.so,
  9824: CharacterCategory.so,
  9825: CharacterCategory.so,
  9826: CharacterCategory.so,
  9827: CharacterCategory.so,
  9828: CharacterCategory.so,
  9829: CharacterCategory.so,
  9830: CharacterCategory.so,
  9831: CharacterCategory.so,
  9832: CharacterCategory.so,
  9833: CharacterCategory.so,
  9834: CharacterCategory.so,
  9835: CharacterCategory.so,
  9836: CharacterCategory.so,
  9837: CharacterCategory.so,
  9838: CharacterCategory.so,
  9840: CharacterCategory.so,
  9841: CharacterCategory.so,
  9842: CharacterCategory.so,
  9843: CharacterCategory.so,
  9844: CharacterCategory.so,
  9845: CharacterCategory.so,
  9846: CharacterCategory.so,
  9847: CharacterCategory.so,
  9848: CharacterCategory.so,
  9849: CharacterCategory.so,
  9850: CharacterCategory.so,
  9851: CharacterCategory.so,
  9852: CharacterCategory.so,
  9853: CharacterCategory.so,
  9854: CharacterCategory.so,
  9855: CharacterCategory.so,
  9856: CharacterCategory.so,
  9857: CharacterCategory.so,
  9858: CharacterCategory.so,
  9859: CharacterCategory.so,
  9860: CharacterCategory.so,
  9861: CharacterCategory.so,
  9862: CharacterCategory.so,
  9863: CharacterCategory.so,
  9864: CharacterCategory.so,
  9865: CharacterCategory.so,
  9866: CharacterCategory.so,
  9867: CharacterCategory.so,
  9868: CharacterCategory.so,
  9869: CharacterCategory.so,
  9870: CharacterCategory.so,
  9871: CharacterCategory.so,
  9872: CharacterCategory.so,
  9873: CharacterCategory.so,
  9874: CharacterCategory.so,
  9875: CharacterCategory.so,
  9876: CharacterCategory.so,
  9877: CharacterCategory.so,
  9878: CharacterCategory.so,
  9879: CharacterCategory.so,
  9880: CharacterCategory.so,
  9881: CharacterCategory.so,
  9882: CharacterCategory.so,
  9883: CharacterCategory.so,
  9884: CharacterCategory.so,
  9885: CharacterCategory.so,
  9886: CharacterCategory.so,
  9887: CharacterCategory.so,
  9888: CharacterCategory.so,
  9889: CharacterCategory.so,
  9890: CharacterCategory.so,
  9891: CharacterCategory.so,
  9892: CharacterCategory.so,
  9893: CharacterCategory.so,
  9894: CharacterCategory.so,
  9895: CharacterCategory.so,
  9896: CharacterCategory.so,
  9897: CharacterCategory.so,
  9898: CharacterCategory.so,
  9899: CharacterCategory.so,
  9900: CharacterCategory.so,
  9901: CharacterCategory.so,
  9902: CharacterCategory.so,
  9903: CharacterCategory.so,
  9904: CharacterCategory.so,
  9905: CharacterCategory.so,
  9906: CharacterCategory.so,
  9907: CharacterCategory.so,
  9908: CharacterCategory.so,
  9909: CharacterCategory.so,
  9910: CharacterCategory.so,
  9911: CharacterCategory.so,
  9912: CharacterCategory.so,
  9913: CharacterCategory.so,
  9914: CharacterCategory.so,
  9915: CharacterCategory.so,
  9916: CharacterCategory.so,
  9917: CharacterCategory.so,
  9918: CharacterCategory.so,
  9919: CharacterCategory.so,
  9920: CharacterCategory.so,
  9921: CharacterCategory.so,
  9922: CharacterCategory.so,
  9923: CharacterCategory.so,
  9924: CharacterCategory.so,
  9925: CharacterCategory.so,
  9926: CharacterCategory.so,
  9927: CharacterCategory.so,
  9928: CharacterCategory.so,
  9929: CharacterCategory.so,
  9930: CharacterCategory.so,
  9931: CharacterCategory.so,
  9932: CharacterCategory.so,
  9933: CharacterCategory.so,
  9934: CharacterCategory.so,
  9935: CharacterCategory.so,
  9936: CharacterCategory.so,
  9937: CharacterCategory.so,
  9938: CharacterCategory.so,
  9939: CharacterCategory.so,
  9940: CharacterCategory.so,
  9941: CharacterCategory.so,
  9942: CharacterCategory.so,
  9943: CharacterCategory.so,
  9944: CharacterCategory.so,
  9945: CharacterCategory.so,
  9946: CharacterCategory.so,
  9947: CharacterCategory.so,
  9948: CharacterCategory.so,
  9949: CharacterCategory.so,
  9950: CharacterCategory.so,
  9951: CharacterCategory.so,
  9952: CharacterCategory.so,
  9953: CharacterCategory.so,
  9954: CharacterCategory.so,
  9955: CharacterCategory.so,
  9956: CharacterCategory.so,
  9957: CharacterCategory.so,
  9958: CharacterCategory.so,
  9959: CharacterCategory.so,
  9960: CharacterCategory.so,
  9961: CharacterCategory.so,
  9962: CharacterCategory.so,
  9963: CharacterCategory.so,
  9964: CharacterCategory.so,
  9965: CharacterCategory.so,
  9966: CharacterCategory.so,
  9967: CharacterCategory.so,
  9968: CharacterCategory.so,
  9969: CharacterCategory.so,
  9970: CharacterCategory.so,
  9971: CharacterCategory.so,
  9972: CharacterCategory.so,
  9973: CharacterCategory.so,
  9974: CharacterCategory.so,
  9975: CharacterCategory.so,
  9976: CharacterCategory.so,
  9977: CharacterCategory.so,
  9978: CharacterCategory.so,
  9979: CharacterCategory.so,
  9980: CharacterCategory.so,
  9981: CharacterCategory.so,
  9982: CharacterCategory.so,
  9983: CharacterCategory.so,
  9984: CharacterCategory.so,
  9985: CharacterCategory.so,
  9986: CharacterCategory.so,
  9987: CharacterCategory.so,
  9988: CharacterCategory.so,
  9989: CharacterCategory.so,
  9990: CharacterCategory.so,
  9991: CharacterCategory.so,
  9992: CharacterCategory.so,
  9993: CharacterCategory.so,
  9994: CharacterCategory.so,
  9995: CharacterCategory.so,
  9996: CharacterCategory.so,
  9997: CharacterCategory.so,
  9998: CharacterCategory.so,
  9999: CharacterCategory.so,
  10000: CharacterCategory.so,
  10001: CharacterCategory.so,
  10002: CharacterCategory.so,
  10003: CharacterCategory.so,
  10004: CharacterCategory.so,
  10005: CharacterCategory.so,
  10006: CharacterCategory.so,
  10007: CharacterCategory.so,
  10008: CharacterCategory.so,
  10009: CharacterCategory.so,
  10010: CharacterCategory.so,
  10011: CharacterCategory.so,
  10012: CharacterCategory.so,
  10013: CharacterCategory.so,
  10014: CharacterCategory.so,
  10015: CharacterCategory.so,
  10016: CharacterCategory.so,
  10017: CharacterCategory.so,
  10018: CharacterCategory.so,
  10019: CharacterCategory.so,
  10020: CharacterCategory.so,
  10021: CharacterCategory.so,
  10022: CharacterCategory.so,
  10023: CharacterCategory.so,
  10024: CharacterCategory.so,
  10025: CharacterCategory.so,
  10026: CharacterCategory.so,
  10027: CharacterCategory.so,
  10028: CharacterCategory.so,
  10029: CharacterCategory.so,
  10030: CharacterCategory.so,
  10031: CharacterCategory.so,
  10032: CharacterCategory.so,
  10033: CharacterCategory.so,
  10034: CharacterCategory.so,
  10035: CharacterCategory.so,
  10036: CharacterCategory.so,
  10037: CharacterCategory.so,
  10038: CharacterCategory.so,
  10039: CharacterCategory.so,
  10040: CharacterCategory.so,
  10041: CharacterCategory.so,
  10042: CharacterCategory.so,
  10043: CharacterCategory.so,
  10044: CharacterCategory.so,
  10045: CharacterCategory.so,
  10046: CharacterCategory.so,
  10047: CharacterCategory.so,
  10048: CharacterCategory.so,
  10049: CharacterCategory.so,
  10050: CharacterCategory.so,
  10051: CharacterCategory.so,
  10052: CharacterCategory.so,
  10053: CharacterCategory.so,
  10054: CharacterCategory.so,
  10055: CharacterCategory.so,
  10056: CharacterCategory.so,
  10057: CharacterCategory.so,
  10058: CharacterCategory.so,
  10059: CharacterCategory.so,
  10060: CharacterCategory.so,
  10061: CharacterCategory.so,
  10062: CharacterCategory.so,
  10063: CharacterCategory.so,
  10064: CharacterCategory.so,
  10065: CharacterCategory.so,
  10066: CharacterCategory.so,
  10067: CharacterCategory.so,
  10068: CharacterCategory.so,
  10069: CharacterCategory.so,
  10070: CharacterCategory.so,
  10071: CharacterCategory.so,
  10072: CharacterCategory.so,
  10073: CharacterCategory.so,
  10074: CharacterCategory.so,
  10075: CharacterCategory.so,
  10076: CharacterCategory.so,
  10077: CharacterCategory.so,
  10078: CharacterCategory.so,
  10079: CharacterCategory.so,
  10080: CharacterCategory.so,
  10081: CharacterCategory.so,
  10082: CharacterCategory.so,
  10083: CharacterCategory.so,
  10084: CharacterCategory.so,
  10085: CharacterCategory.so,
  10086: CharacterCategory.so,
  10087: CharacterCategory.so,
  10132: CharacterCategory.so,
  10133: CharacterCategory.so,
  10134: CharacterCategory.so,
  10135: CharacterCategory.so,
  10136: CharacterCategory.so,
  10137: CharacterCategory.so,
  10138: CharacterCategory.so,
  10139: CharacterCategory.so,
  10140: CharacterCategory.so,
  10141: CharacterCategory.so,
  10142: CharacterCategory.so,
  10143: CharacterCategory.so,
  10144: CharacterCategory.so,
  10145: CharacterCategory.so,
  10146: CharacterCategory.so,
  10147: CharacterCategory.so,
  10148: CharacterCategory.so,
  10149: CharacterCategory.so,
  10150: CharacterCategory.so,
  10151: CharacterCategory.so,
  10152: CharacterCategory.so,
  10153: CharacterCategory.so,
  10154: CharacterCategory.so,
  10155: CharacterCategory.so,
  10156: CharacterCategory.so,
  10157: CharacterCategory.so,
  10158: CharacterCategory.so,
  10159: CharacterCategory.so,
  10160: CharacterCategory.so,
  10161: CharacterCategory.so,
  10162: CharacterCategory.so,
  10163: CharacterCategory.so,
  10164: CharacterCategory.so,
  10165: CharacterCategory.so,
  10166: CharacterCategory.so,
  10167: CharacterCategory.so,
  10168: CharacterCategory.so,
  10169: CharacterCategory.so,
  10170: CharacterCategory.so,
  10171: CharacterCategory.so,
  10172: CharacterCategory.so,
  10173: CharacterCategory.so,
  10174: CharacterCategory.so,
  10175: CharacterCategory.so,
  10240: CharacterCategory.so,
  10241: CharacterCategory.so,
  10242: CharacterCategory.so,
  10243: CharacterCategory.so,
  10244: CharacterCategory.so,
  10245: CharacterCategory.so,
  10246: CharacterCategory.so,
  10247: CharacterCategory.so,
  10248: CharacterCategory.so,
  10249: CharacterCategory.so,
  10250: CharacterCategory.so,
  10251: CharacterCategory.so,
  10252: CharacterCategory.so,
  10253: CharacterCategory.so,
  10254: CharacterCategory.so,
  10255: CharacterCategory.so,
  10256: CharacterCategory.so,
  10257: CharacterCategory.so,
  10258: CharacterCategory.so,
  10259: CharacterCategory.so,
  10260: CharacterCategory.so,
  10261: CharacterCategory.so,
  10262: CharacterCategory.so,
  10263: CharacterCategory.so,
  10264: CharacterCategory.so,
  10265: CharacterCategory.so,
  10266: CharacterCategory.so,
  10267: CharacterCategory.so,
  10268: CharacterCategory.so,
  10269: CharacterCategory.so,
  10270: CharacterCategory.so,
  10271: CharacterCategory.so,
  10272: CharacterCategory.so,
  10273: CharacterCategory.so,
  10274: CharacterCategory.so,
  10275: CharacterCategory.so,
  10276: CharacterCategory.so,
  10277: CharacterCategory.so,
  10278: CharacterCategory.so,
  10279: CharacterCategory.so,
  10280: CharacterCategory.so,
  10281: CharacterCategory.so,
  10282: CharacterCategory.so,
  10283: CharacterCategory.so,
  10284: CharacterCategory.so,
  10285: CharacterCategory.so,
  10286: CharacterCategory.so,
  10287: CharacterCategory.so,
  10288: CharacterCategory.so,
  10289: CharacterCategory.so,
  10290: CharacterCategory.so,
  10291: CharacterCategory.so,
  10292: CharacterCategory.so,
  10293: CharacterCategory.so,
  10294: CharacterCategory.so,
  10295: CharacterCategory.so,
  10296: CharacterCategory.so,
  10297: CharacterCategory.so,
  10298: CharacterCategory.so,
  10299: CharacterCategory.so,
  10300: CharacterCategory.so,
  10301: CharacterCategory.so,
  10302: CharacterCategory.so,
  10303: CharacterCategory.so,
  10304: CharacterCategory.so,
  10305: CharacterCategory.so,
  10306: CharacterCategory.so,
  10307: CharacterCategory.so,
  10308: CharacterCategory.so,
  10309: CharacterCategory.so,
  10310: CharacterCategory.so,
  10311: CharacterCategory.so,
  10312: CharacterCategory.so,
  10313: CharacterCategory.so,
  10314: CharacterCategory.so,
  10315: CharacterCategory.so,
  10316: CharacterCategory.so,
  10317: CharacterCategory.so,
  10318: CharacterCategory.so,
  10319: CharacterCategory.so,
  10320: CharacterCategory.so,
  10321: CharacterCategory.so,
  10322: CharacterCategory.so,
  10323: CharacterCategory.so,
  10324: CharacterCategory.so,
  10325: CharacterCategory.so,
  10326: CharacterCategory.so,
  10327: CharacterCategory.so,
  10328: CharacterCategory.so,
  10329: CharacterCategory.so,
  10330: CharacterCategory.so,
  10331: CharacterCategory.so,
  10332: CharacterCategory.so,
  10333: CharacterCategory.so,
  10334: CharacterCategory.so,
  10335: CharacterCategory.so,
  10336: CharacterCategory.so,
  10337: CharacterCategory.so,
  10338: CharacterCategory.so,
  10339: CharacterCategory.so,
  10340: CharacterCategory.so,
  10341: CharacterCategory.so,
  10342: CharacterCategory.so,
  10343: CharacterCategory.so,
  10344: CharacterCategory.so,
  10345: CharacterCategory.so,
  10346: CharacterCategory.so,
  10347: CharacterCategory.so,
  10348: CharacterCategory.so,
  10349: CharacterCategory.so,
  10350: CharacterCategory.so,
  10351: CharacterCategory.so,
  10352: CharacterCategory.so,
  10353: CharacterCategory.so,
  10354: CharacterCategory.so,
  10355: CharacterCategory.so,
  10356: CharacterCategory.so,
  10357: CharacterCategory.so,
  10358: CharacterCategory.so,
  10359: CharacterCategory.so,
  10360: CharacterCategory.so,
  10361: CharacterCategory.so,
  10362: CharacterCategory.so,
  10363: CharacterCategory.so,
  10364: CharacterCategory.so,
  10365: CharacterCategory.so,
  10366: CharacterCategory.so,
  10367: CharacterCategory.so,
  10368: CharacterCategory.so,
  10369: CharacterCategory.so,
  10370: CharacterCategory.so,
  10371: CharacterCategory.so,
  10372: CharacterCategory.so,
  10373: CharacterCategory.so,
  10374: CharacterCategory.so,
  10375: CharacterCategory.so,
  10376: CharacterCategory.so,
  10377: CharacterCategory.so,
  10378: CharacterCategory.so,
  10379: CharacterCategory.so,
  10380: CharacterCategory.so,
  10381: CharacterCategory.so,
  10382: CharacterCategory.so,
  10383: CharacterCategory.so,
  10384: CharacterCategory.so,
  10385: CharacterCategory.so,
  10386: CharacterCategory.so,
  10387: CharacterCategory.so,
  10388: CharacterCategory.so,
  10389: CharacterCategory.so,
  10390: CharacterCategory.so,
  10391: CharacterCategory.so,
  10392: CharacterCategory.so,
  10393: CharacterCategory.so,
  10394: CharacterCategory.so,
  10395: CharacterCategory.so,
  10396: CharacterCategory.so,
  10397: CharacterCategory.so,
  10398: CharacterCategory.so,
  10399: CharacterCategory.so,
  10400: CharacterCategory.so,
  10401: CharacterCategory.so,
  10402: CharacterCategory.so,
  10403: CharacterCategory.so,
  10404: CharacterCategory.so,
  10405: CharacterCategory.so,
  10406: CharacterCategory.so,
  10407: CharacterCategory.so,
  10408: CharacterCategory.so,
  10409: CharacterCategory.so,
  10410: CharacterCategory.so,
  10411: CharacterCategory.so,
  10412: CharacterCategory.so,
  10413: CharacterCategory.so,
  10414: CharacterCategory.so,
  10415: CharacterCategory.so,
  10416: CharacterCategory.so,
  10417: CharacterCategory.so,
  10418: CharacterCategory.so,
  10419: CharacterCategory.so,
  10420: CharacterCategory.so,
  10421: CharacterCategory.so,
  10422: CharacterCategory.so,
  10423: CharacterCategory.so,
  10424: CharacterCategory.so,
  10425: CharacterCategory.so,
  10426: CharacterCategory.so,
  10427: CharacterCategory.so,
  10428: CharacterCategory.so,
  10429: CharacterCategory.so,
  10430: CharacterCategory.so,
  10431: CharacterCategory.so,
  10432: CharacterCategory.so,
  10433: CharacterCategory.so,
  10434: CharacterCategory.so,
  10435: CharacterCategory.so,
  10436: CharacterCategory.so,
  10437: CharacterCategory.so,
  10438: CharacterCategory.so,
  10439: CharacterCategory.so,
  10440: CharacterCategory.so,
  10441: CharacterCategory.so,
  10442: CharacterCategory.so,
  10443: CharacterCategory.so,
  10444: CharacterCategory.so,
  10445: CharacterCategory.so,
  10446: CharacterCategory.so,
  10447: CharacterCategory.so,
  10448: CharacterCategory.so,
  10449: CharacterCategory.so,
  10450: CharacterCategory.so,
  10451: CharacterCategory.so,
  10452: CharacterCategory.so,
  10453: CharacterCategory.so,
  10454: CharacterCategory.so,
  10455: CharacterCategory.so,
  10456: CharacterCategory.so,
  10457: CharacterCategory.so,
  10458: CharacterCategory.so,
  10459: CharacterCategory.so,
  10460: CharacterCategory.so,
  10461: CharacterCategory.so,
  10462: CharacterCategory.so,
  10463: CharacterCategory.so,
  10464: CharacterCategory.so,
  10465: CharacterCategory.so,
  10466: CharacterCategory.so,
  10467: CharacterCategory.so,
  10468: CharacterCategory.so,
  10469: CharacterCategory.so,
  10470: CharacterCategory.so,
  10471: CharacterCategory.so,
  10472: CharacterCategory.so,
  10473: CharacterCategory.so,
  10474: CharacterCategory.so,
  10475: CharacterCategory.so,
  10476: CharacterCategory.so,
  10477: CharacterCategory.so,
  10478: CharacterCategory.so,
  10479: CharacterCategory.so,
  10480: CharacterCategory.so,
  10481: CharacterCategory.so,
  10482: CharacterCategory.so,
  10483: CharacterCategory.so,
  10484: CharacterCategory.so,
  10485: CharacterCategory.so,
  10486: CharacterCategory.so,
  10487: CharacterCategory.so,
  10488: CharacterCategory.so,
  10489: CharacterCategory.so,
  10490: CharacterCategory.so,
  10491: CharacterCategory.so,
  10492: CharacterCategory.so,
  10493: CharacterCategory.so,
  10494: CharacterCategory.so,
  10495: CharacterCategory.so,
  11008: CharacterCategory.so,
  11009: CharacterCategory.so,
  11010: CharacterCategory.so,
  11011: CharacterCategory.so,
  11012: CharacterCategory.so,
  11013: CharacterCategory.so,
  11014: CharacterCategory.so,
  11015: CharacterCategory.so,
  11016: CharacterCategory.so,
  11017: CharacterCategory.so,
  11018: CharacterCategory.so,
  11019: CharacterCategory.so,
  11020: CharacterCategory.so,
  11021: CharacterCategory.so,
  11022: CharacterCategory.so,
  11023: CharacterCategory.so,
  11024: CharacterCategory.so,
  11025: CharacterCategory.so,
  11026: CharacterCategory.so,
  11027: CharacterCategory.so,
  11028: CharacterCategory.so,
  11029: CharacterCategory.so,
  11030: CharacterCategory.so,
  11031: CharacterCategory.so,
  11032: CharacterCategory.so,
  11033: CharacterCategory.so,
  11034: CharacterCategory.so,
  11035: CharacterCategory.so,
  11036: CharacterCategory.so,
  11037: CharacterCategory.so,
  11038: CharacterCategory.so,
  11039: CharacterCategory.so,
  11040: CharacterCategory.so,
  11041: CharacterCategory.so,
  11042: CharacterCategory.so,
  11043: CharacterCategory.so,
  11044: CharacterCategory.so,
  11045: CharacterCategory.so,
  11046: CharacterCategory.so,
  11047: CharacterCategory.so,
  11048: CharacterCategory.so,
  11049: CharacterCategory.so,
  11050: CharacterCategory.so,
  11051: CharacterCategory.so,
  11052: CharacterCategory.so,
  11053: CharacterCategory.so,
  11054: CharacterCategory.so,
  11055: CharacterCategory.so,
  11077: CharacterCategory.so,
  11078: CharacterCategory.so,
  11085: CharacterCategory.so,
  11086: CharacterCategory.so,
  11087: CharacterCategory.so,
  11088: CharacterCategory.so,
  11089: CharacterCategory.so,
  11090: CharacterCategory.so,
  11091: CharacterCategory.so,
  11092: CharacterCategory.so,
  11093: CharacterCategory.so,
  11094: CharacterCategory.so,
  11095: CharacterCategory.so,
  11096: CharacterCategory.so,
  11097: CharacterCategory.so,
  11098: CharacterCategory.so,
  11099: CharacterCategory.so,
  11100: CharacterCategory.so,
  11101: CharacterCategory.so,
  11102: CharacterCategory.so,
  11103: CharacterCategory.so,
  11104: CharacterCategory.so,
  11105: CharacterCategory.so,
  11106: CharacterCategory.so,
  11107: CharacterCategory.so,
  11108: CharacterCategory.so,
  11109: CharacterCategory.so,
  11110: CharacterCategory.so,
  11111: CharacterCategory.so,
  11112: CharacterCategory.so,
  11113: CharacterCategory.so,
  11114: CharacterCategory.so,
  11115: CharacterCategory.so,
  11116: CharacterCategory.so,
  11117: CharacterCategory.so,
  11118: CharacterCategory.so,
  11119: CharacterCategory.so,
  11120: CharacterCategory.so,
  11121: CharacterCategory.so,
  11122: CharacterCategory.so,
  11123: CharacterCategory.so,
  11126: CharacterCategory.so,
  11127: CharacterCategory.so,
  11128: CharacterCategory.so,
  11129: CharacterCategory.so,
  11130: CharacterCategory.so,
  11131: CharacterCategory.so,
  11132: CharacterCategory.so,
  11133: CharacterCategory.so,
  11134: CharacterCategory.so,
  11135: CharacterCategory.so,
  11136: CharacterCategory.so,
  11137: CharacterCategory.so,
  11138: CharacterCategory.so,
  11139: CharacterCategory.so,
  11140: CharacterCategory.so,
  11141: CharacterCategory.so,
  11142: CharacterCategory.so,
  11143: CharacterCategory.so,
  11144: CharacterCategory.so,
  11145: CharacterCategory.so,
  11146: CharacterCategory.so,
  11147: CharacterCategory.so,
  11148: CharacterCategory.so,
  11149: CharacterCategory.so,
  11150: CharacterCategory.so,
  11151: CharacterCategory.so,
  11152: CharacterCategory.so,
  11153: CharacterCategory.so,
  11154: CharacterCategory.so,
  11155: CharacterCategory.so,
  11156: CharacterCategory.so,
  11157: CharacterCategory.so,
  11160: CharacterCategory.so,
  11161: CharacterCategory.so,
  11162: CharacterCategory.so,
  11163: CharacterCategory.so,
  11164: CharacterCategory.so,
  11165: CharacterCategory.so,
  11166: CharacterCategory.so,
  11167: CharacterCategory.so,
  11168: CharacterCategory.so,
  11169: CharacterCategory.so,
  11170: CharacterCategory.so,
  11171: CharacterCategory.so,
  11172: CharacterCategory.so,
  11173: CharacterCategory.so,
  11174: CharacterCategory.so,
  11175: CharacterCategory.so,
  11176: CharacterCategory.so,
  11177: CharacterCategory.so,
  11178: CharacterCategory.so,
  11179: CharacterCategory.so,
  11180: CharacterCategory.so,
  11181: CharacterCategory.so,
  11182: CharacterCategory.so,
  11183: CharacterCategory.so,
  11184: CharacterCategory.so,
  11185: CharacterCategory.so,
  11186: CharacterCategory.so,
  11187: CharacterCategory.so,
  11188: CharacterCategory.so,
  11189: CharacterCategory.so,
  11190: CharacterCategory.so,
  11191: CharacterCategory.so,
  11192: CharacterCategory.so,
  11193: CharacterCategory.so,
  11197: CharacterCategory.so,
  11198: CharacterCategory.so,
  11199: CharacterCategory.so,
  11200: CharacterCategory.so,
  11201: CharacterCategory.so,
  11202: CharacterCategory.so,
  11203: CharacterCategory.so,
  11204: CharacterCategory.so,
  11205: CharacterCategory.so,
  11206: CharacterCategory.so,
  11207: CharacterCategory.so,
  11208: CharacterCategory.so,
  11210: CharacterCategory.so,
  11211: CharacterCategory.so,
  11212: CharacterCategory.so,
  11213: CharacterCategory.so,
  11214: CharacterCategory.so,
  11215: CharacterCategory.so,
  11216: CharacterCategory.so,
  11217: CharacterCategory.so,
  11493: CharacterCategory.so,
  11494: CharacterCategory.so,
  11495: CharacterCategory.so,
  11496: CharacterCategory.so,
  11497: CharacterCategory.so,
  11498: CharacterCategory.so,
  11904: CharacterCategory.so,
  11905: CharacterCategory.so,
  11906: CharacterCategory.so,
  11907: CharacterCategory.so,
  11908: CharacterCategory.so,
  11909: CharacterCategory.so,
  11910: CharacterCategory.so,
  11911: CharacterCategory.so,
  11912: CharacterCategory.so,
  11913: CharacterCategory.so,
  11914: CharacterCategory.so,
  11915: CharacterCategory.so,
  11916: CharacterCategory.so,
  11917: CharacterCategory.so,
  11918: CharacterCategory.so,
  11919: CharacterCategory.so,
  11920: CharacterCategory.so,
  11921: CharacterCategory.so,
  11922: CharacterCategory.so,
  11923: CharacterCategory.so,
  11924: CharacterCategory.so,
  11925: CharacterCategory.so,
  11926: CharacterCategory.so,
  11927: CharacterCategory.so,
  11928: CharacterCategory.so,
  11929: CharacterCategory.so,
  11931: CharacterCategory.so,
  11932: CharacterCategory.so,
  11933: CharacterCategory.so,
  11934: CharacterCategory.so,
  11935: CharacterCategory.so,
  11936: CharacterCategory.so,
  11937: CharacterCategory.so,
  11938: CharacterCategory.so,
  11939: CharacterCategory.so,
  11940: CharacterCategory.so,
  11941: CharacterCategory.so,
  11942: CharacterCategory.so,
  11943: CharacterCategory.so,
  11944: CharacterCategory.so,
  11945: CharacterCategory.so,
  11946: CharacterCategory.so,
  11947: CharacterCategory.so,
  11948: CharacterCategory.so,
  11949: CharacterCategory.so,
  11950: CharacterCategory.so,
  11951: CharacterCategory.so,
  11952: CharacterCategory.so,
  11953: CharacterCategory.so,
  11954: CharacterCategory.so,
  11955: CharacterCategory.so,
  11956: CharacterCategory.so,
  11957: CharacterCategory.so,
  11958: CharacterCategory.so,
  11959: CharacterCategory.so,
  11960: CharacterCategory.so,
  11961: CharacterCategory.so,
  11962: CharacterCategory.so,
  11963: CharacterCategory.so,
  11964: CharacterCategory.so,
  11965: CharacterCategory.so,
  11966: CharacterCategory.so,
  11967: CharacterCategory.so,
  11968: CharacterCategory.so,
  11969: CharacterCategory.so,
  11970: CharacterCategory.so,
  11971: CharacterCategory.so,
  11972: CharacterCategory.so,
  11973: CharacterCategory.so,
  11974: CharacterCategory.so,
  11975: CharacterCategory.so,
  11976: CharacterCategory.so,
  11977: CharacterCategory.so,
  11978: CharacterCategory.so,
  11979: CharacterCategory.so,
  11980: CharacterCategory.so,
  11981: CharacterCategory.so,
  11982: CharacterCategory.so,
  11983: CharacterCategory.so,
  11984: CharacterCategory.so,
  11985: CharacterCategory.so,
  11986: CharacterCategory.so,
  11987: CharacterCategory.so,
  11988: CharacterCategory.so,
  11989: CharacterCategory.so,
  11990: CharacterCategory.so,
  11991: CharacterCategory.so,
  11992: CharacterCategory.so,
  11993: CharacterCategory.so,
  11994: CharacterCategory.so,
  11995: CharacterCategory.so,
  11996: CharacterCategory.so,
  11997: CharacterCategory.so,
  11998: CharacterCategory.so,
  11999: CharacterCategory.so,
  12000: CharacterCategory.so,
  12001: CharacterCategory.so,
  12002: CharacterCategory.so,
  12003: CharacterCategory.so,
  12004: CharacterCategory.so,
  12005: CharacterCategory.so,
  12006: CharacterCategory.so,
  12007: CharacterCategory.so,
  12008: CharacterCategory.so,
  12009: CharacterCategory.so,
  12010: CharacterCategory.so,
  12011: CharacterCategory.so,
  12012: CharacterCategory.so,
  12013: CharacterCategory.so,
  12014: CharacterCategory.so,
  12015: CharacterCategory.so,
  12016: CharacterCategory.so,
  12017: CharacterCategory.so,
  12018: CharacterCategory.so,
  12019: CharacterCategory.so,
  12032: CharacterCategory.so,
  12033: CharacterCategory.so,
  12034: CharacterCategory.so,
  12035: CharacterCategory.so,
  12036: CharacterCategory.so,
  12037: CharacterCategory.so,
  12038: CharacterCategory.so,
  12039: CharacterCategory.so,
  12040: CharacterCategory.so,
  12041: CharacterCategory.so,
  12042: CharacterCategory.so,
  12043: CharacterCategory.so,
  12044: CharacterCategory.so,
  12045: CharacterCategory.so,
  12046: CharacterCategory.so,
  12047: CharacterCategory.so,
  12048: CharacterCategory.so,
  12049: CharacterCategory.so,
  12050: CharacterCategory.so,
  12051: CharacterCategory.so,
  12052: CharacterCategory.so,
  12053: CharacterCategory.so,
  12054: CharacterCategory.so,
  12055: CharacterCategory.so,
  12056: CharacterCategory.so,
  12057: CharacterCategory.so,
  12058: CharacterCategory.so,
  12059: CharacterCategory.so,
  12060: CharacterCategory.so,
  12061: CharacterCategory.so,
  12062: CharacterCategory.so,
  12063: CharacterCategory.so,
  12064: CharacterCategory.so,
  12065: CharacterCategory.so,
  12066: CharacterCategory.so,
  12067: CharacterCategory.so,
  12068: CharacterCategory.so,
  12069: CharacterCategory.so,
  12070: CharacterCategory.so,
  12071: CharacterCategory.so,
  12072: CharacterCategory.so,
  12073: CharacterCategory.so,
  12074: CharacterCategory.so,
  12075: CharacterCategory.so,
  12076: CharacterCategory.so,
  12077: CharacterCategory.so,
  12078: CharacterCategory.so,
  12079: CharacterCategory.so,
  12080: CharacterCategory.so,
  12081: CharacterCategory.so,
  12082: CharacterCategory.so,
  12083: CharacterCategory.so,
  12084: CharacterCategory.so,
  12085: CharacterCategory.so,
  12086: CharacterCategory.so,
  12087: CharacterCategory.so,
  12088: CharacterCategory.so,
  12089: CharacterCategory.so,
  12090: CharacterCategory.so,
  12091: CharacterCategory.so,
  12092: CharacterCategory.so,
  12093: CharacterCategory.so,
  12094: CharacterCategory.so,
  12095: CharacterCategory.so,
  12096: CharacterCategory.so,
  12097: CharacterCategory.so,
  12098: CharacterCategory.so,
  12099: CharacterCategory.so,
  12100: CharacterCategory.so,
  12101: CharacterCategory.so,
  12102: CharacterCategory.so,
  12103: CharacterCategory.so,
  12104: CharacterCategory.so,
  12105: CharacterCategory.so,
  12106: CharacterCategory.so,
  12107: CharacterCategory.so,
  12108: CharacterCategory.so,
  12109: CharacterCategory.so,
  12110: CharacterCategory.so,
  12111: CharacterCategory.so,
  12112: CharacterCategory.so,
  12113: CharacterCategory.so,
  12114: CharacterCategory.so,
  12115: CharacterCategory.so,
  12116: CharacterCategory.so,
  12117: CharacterCategory.so,
  12118: CharacterCategory.so,
  12119: CharacterCategory.so,
  12120: CharacterCategory.so,
  12121: CharacterCategory.so,
  12122: CharacterCategory.so,
  12123: CharacterCategory.so,
  12124: CharacterCategory.so,
  12125: CharacterCategory.so,
  12126: CharacterCategory.so,
  12127: CharacterCategory.so,
  12128: CharacterCategory.so,
  12129: CharacterCategory.so,
  12130: CharacterCategory.so,
  12131: CharacterCategory.so,
  12132: CharacterCategory.so,
  12133: CharacterCategory.so,
  12134: CharacterCategory.so,
  12135: CharacterCategory.so,
  12136: CharacterCategory.so,
  12137: CharacterCategory.so,
  12138: CharacterCategory.so,
  12139: CharacterCategory.so,
  12140: CharacterCategory.so,
  12141: CharacterCategory.so,
  12142: CharacterCategory.so,
  12143: CharacterCategory.so,
  12144: CharacterCategory.so,
  12145: CharacterCategory.so,
  12146: CharacterCategory.so,
  12147: CharacterCategory.so,
  12148: CharacterCategory.so,
  12149: CharacterCategory.so,
  12150: CharacterCategory.so,
  12151: CharacterCategory.so,
  12152: CharacterCategory.so,
  12153: CharacterCategory.so,
  12154: CharacterCategory.so,
  12155: CharacterCategory.so,
  12156: CharacterCategory.so,
  12157: CharacterCategory.so,
  12158: CharacterCategory.so,
  12159: CharacterCategory.so,
  12160: CharacterCategory.so,
  12161: CharacterCategory.so,
  12162: CharacterCategory.so,
  12163: CharacterCategory.so,
  12164: CharacterCategory.so,
  12165: CharacterCategory.so,
  12166: CharacterCategory.so,
  12167: CharacterCategory.so,
  12168: CharacterCategory.so,
  12169: CharacterCategory.so,
  12170: CharacterCategory.so,
  12171: CharacterCategory.so,
  12172: CharacterCategory.so,
  12173: CharacterCategory.so,
  12174: CharacterCategory.so,
  12175: CharacterCategory.so,
  12176: CharacterCategory.so,
  12177: CharacterCategory.so,
  12178: CharacterCategory.so,
  12179: CharacterCategory.so,
  12180: CharacterCategory.so,
  12181: CharacterCategory.so,
  12182: CharacterCategory.so,
  12183: CharacterCategory.so,
  12184: CharacterCategory.so,
  12185: CharacterCategory.so,
  12186: CharacterCategory.so,
  12187: CharacterCategory.so,
  12188: CharacterCategory.so,
  12189: CharacterCategory.so,
  12190: CharacterCategory.so,
  12191: CharacterCategory.so,
  12192: CharacterCategory.so,
  12193: CharacterCategory.so,
  12194: CharacterCategory.so,
  12195: CharacterCategory.so,
  12196: CharacterCategory.so,
  12197: CharacterCategory.so,
  12198: CharacterCategory.so,
  12199: CharacterCategory.so,
  12200: CharacterCategory.so,
  12201: CharacterCategory.so,
  12202: CharacterCategory.so,
  12203: CharacterCategory.so,
  12204: CharacterCategory.so,
  12205: CharacterCategory.so,
  12206: CharacterCategory.so,
  12207: CharacterCategory.so,
  12208: CharacterCategory.so,
  12209: CharacterCategory.so,
  12210: CharacterCategory.so,
  12211: CharacterCategory.so,
  12212: CharacterCategory.so,
  12213: CharacterCategory.so,
  12214: CharacterCategory.so,
  12215: CharacterCategory.so,
  12216: CharacterCategory.so,
  12217: CharacterCategory.so,
  12218: CharacterCategory.so,
  12219: CharacterCategory.so,
  12220: CharacterCategory.so,
  12221: CharacterCategory.so,
  12222: CharacterCategory.so,
  12223: CharacterCategory.so,
  12224: CharacterCategory.so,
  12225: CharacterCategory.so,
  12226: CharacterCategory.so,
  12227: CharacterCategory.so,
  12228: CharacterCategory.so,
  12229: CharacterCategory.so,
  12230: CharacterCategory.so,
  12231: CharacterCategory.so,
  12232: CharacterCategory.so,
  12233: CharacterCategory.so,
  12234: CharacterCategory.so,
  12235: CharacterCategory.so,
  12236: CharacterCategory.so,
  12237: CharacterCategory.so,
  12238: CharacterCategory.so,
  12239: CharacterCategory.so,
  12240: CharacterCategory.so,
  12241: CharacterCategory.so,
  12242: CharacterCategory.so,
  12243: CharacterCategory.so,
  12244: CharacterCategory.so,
  12245: CharacterCategory.so,
  12272: CharacterCategory.so,
  12273: CharacterCategory.so,
  12274: CharacterCategory.so,
  12275: CharacterCategory.so,
  12276: CharacterCategory.so,
  12277: CharacterCategory.so,
  12278: CharacterCategory.so,
  12279: CharacterCategory.so,
  12280: CharacterCategory.so,
  12281: CharacterCategory.so,
  12282: CharacterCategory.so,
  12283: CharacterCategory.so,
  12292: CharacterCategory.so,
  12306: CharacterCategory.so,
  12307: CharacterCategory.so,
  12320: CharacterCategory.so,
  12342: CharacterCategory.so,
  12343: CharacterCategory.so,
  12350: CharacterCategory.so,
  12351: CharacterCategory.so,
  12688: CharacterCategory.so,
  12689: CharacterCategory.so,
  12694: CharacterCategory.so,
  12695: CharacterCategory.so,
  12696: CharacterCategory.so,
  12697: CharacterCategory.so,
  12698: CharacterCategory.so,
  12699: CharacterCategory.so,
  12700: CharacterCategory.so,
  12701: CharacterCategory.so,
  12702: CharacterCategory.so,
  12703: CharacterCategory.so,
  12736: CharacterCategory.so,
  12737: CharacterCategory.so,
  12738: CharacterCategory.so,
  12739: CharacterCategory.so,
  12740: CharacterCategory.so,
  12741: CharacterCategory.so,
  12742: CharacterCategory.so,
  12743: CharacterCategory.so,
  12744: CharacterCategory.so,
  12745: CharacterCategory.so,
  12746: CharacterCategory.so,
  12747: CharacterCategory.so,
  12748: CharacterCategory.so,
  12749: CharacterCategory.so,
  12750: CharacterCategory.so,
  12751: CharacterCategory.so,
  12752: CharacterCategory.so,
  12753: CharacterCategory.so,
  12754: CharacterCategory.so,
  12755: CharacterCategory.so,
  12756: CharacterCategory.so,
  12757: CharacterCategory.so,
  12758: CharacterCategory.so,
  12759: CharacterCategory.so,
  12760: CharacterCategory.so,
  12761: CharacterCategory.so,
  12762: CharacterCategory.so,
  12763: CharacterCategory.so,
  12764: CharacterCategory.so,
  12765: CharacterCategory.so,
  12766: CharacterCategory.so,
  12767: CharacterCategory.so,
  12768: CharacterCategory.so,
  12769: CharacterCategory.so,
  12770: CharacterCategory.so,
  12771: CharacterCategory.so,
  12800: CharacterCategory.so,
  12801: CharacterCategory.so,
  12802: CharacterCategory.so,
  12803: CharacterCategory.so,
  12804: CharacterCategory.so,
  12805: CharacterCategory.so,
  12806: CharacterCategory.so,
  12807: CharacterCategory.so,
  12808: CharacterCategory.so,
  12809: CharacterCategory.so,
  12810: CharacterCategory.so,
  12811: CharacterCategory.so,
  12812: CharacterCategory.so,
  12813: CharacterCategory.so,
  12814: CharacterCategory.so,
  12815: CharacterCategory.so,
  12816: CharacterCategory.so,
  12817: CharacterCategory.so,
  12818: CharacterCategory.so,
  12819: CharacterCategory.so,
  12820: CharacterCategory.so,
  12821: CharacterCategory.so,
  12822: CharacterCategory.so,
  12823: CharacterCategory.so,
  12824: CharacterCategory.so,
  12825: CharacterCategory.so,
  12826: CharacterCategory.so,
  12827: CharacterCategory.so,
  12828: CharacterCategory.so,
  12829: CharacterCategory.so,
  12830: CharacterCategory.so,
  12842: CharacterCategory.so,
  12843: CharacterCategory.so,
  12844: CharacterCategory.so,
  12845: CharacterCategory.so,
  12846: CharacterCategory.so,
  12847: CharacterCategory.so,
  12848: CharacterCategory.so,
  12849: CharacterCategory.so,
  12850: CharacterCategory.so,
  12851: CharacterCategory.so,
  12852: CharacterCategory.so,
  12853: CharacterCategory.so,
  12854: CharacterCategory.so,
  12855: CharacterCategory.so,
  12856: CharacterCategory.so,
  12857: CharacterCategory.so,
  12858: CharacterCategory.so,
  12859: CharacterCategory.so,
  12860: CharacterCategory.so,
  12861: CharacterCategory.so,
  12862: CharacterCategory.so,
  12863: CharacterCategory.so,
  12864: CharacterCategory.so,
  12865: CharacterCategory.so,
  12866: CharacterCategory.so,
  12867: CharacterCategory.so,
  12868: CharacterCategory.so,
  12869: CharacterCategory.so,
  12870: CharacterCategory.so,
  12871: CharacterCategory.so,
  12880: CharacterCategory.so,
  12896: CharacterCategory.so,
  12897: CharacterCategory.so,
  12898: CharacterCategory.so,
  12899: CharacterCategory.so,
  12900: CharacterCategory.so,
  12901: CharacterCategory.so,
  12902: CharacterCategory.so,
  12903: CharacterCategory.so,
  12904: CharacterCategory.so,
  12905: CharacterCategory.so,
  12906: CharacterCategory.so,
  12907: CharacterCategory.so,
  12908: CharacterCategory.so,
  12909: CharacterCategory.so,
  12910: CharacterCategory.so,
  12911: CharacterCategory.so,
  12912: CharacterCategory.so,
  12913: CharacterCategory.so,
  12914: CharacterCategory.so,
  12915: CharacterCategory.so,
  12916: CharacterCategory.so,
  12917: CharacterCategory.so,
  12918: CharacterCategory.so,
  12919: CharacterCategory.so,
  12920: CharacterCategory.so,
  12921: CharacterCategory.so,
  12922: CharacterCategory.so,
  12923: CharacterCategory.so,
  12924: CharacterCategory.so,
  12925: CharacterCategory.so,
  12926: CharacterCategory.so,
  12927: CharacterCategory.so,
  12938: CharacterCategory.so,
  12939: CharacterCategory.so,
  12940: CharacterCategory.so,
  12941: CharacterCategory.so,
  12942: CharacterCategory.so,
  12943: CharacterCategory.so,
  12944: CharacterCategory.so,
  12945: CharacterCategory.so,
  12946: CharacterCategory.so,
  12947: CharacterCategory.so,
  12948: CharacterCategory.so,
  12949: CharacterCategory.so,
  12950: CharacterCategory.so,
  12951: CharacterCategory.so,
  12952: CharacterCategory.so,
  12953: CharacterCategory.so,
  12954: CharacterCategory.so,
  12955: CharacterCategory.so,
  12956: CharacterCategory.so,
  12957: CharacterCategory.so,
  12958: CharacterCategory.so,
  12959: CharacterCategory.so,
  12960: CharacterCategory.so,
  12961: CharacterCategory.so,
  12962: CharacterCategory.so,
  12963: CharacterCategory.so,
  12964: CharacterCategory.so,
  12965: CharacterCategory.so,
  12966: CharacterCategory.so,
  12967: CharacterCategory.so,
  12968: CharacterCategory.so,
  12969: CharacterCategory.so,
  12970: CharacterCategory.so,
  12971: CharacterCategory.so,
  12972: CharacterCategory.so,
  12973: CharacterCategory.so,
  12974: CharacterCategory.so,
  12975: CharacterCategory.so,
  12976: CharacterCategory.so,
  12992: CharacterCategory.so,
  12993: CharacterCategory.so,
  12994: CharacterCategory.so,
  12995: CharacterCategory.so,
  12996: CharacterCategory.so,
  12997: CharacterCategory.so,
  12998: CharacterCategory.so,
  12999: CharacterCategory.so,
  13000: CharacterCategory.so,
  13001: CharacterCategory.so,
  13002: CharacterCategory.so,
  13003: CharacterCategory.so,
  13004: CharacterCategory.so,
  13005: CharacterCategory.so,
  13006: CharacterCategory.so,
  13007: CharacterCategory.so,
  13008: CharacterCategory.so,
  13009: CharacterCategory.so,
  13010: CharacterCategory.so,
  13011: CharacterCategory.so,
  13012: CharacterCategory.so,
  13013: CharacterCategory.so,
  13014: CharacterCategory.so,
  13015: CharacterCategory.so,
  13016: CharacterCategory.so,
  13017: CharacterCategory.so,
  13018: CharacterCategory.so,
  13019: CharacterCategory.so,
  13020: CharacterCategory.so,
  13021: CharacterCategory.so,
  13022: CharacterCategory.so,
  13023: CharacterCategory.so,
  13024: CharacterCategory.so,
  13025: CharacterCategory.so,
  13026: CharacterCategory.so,
  13027: CharacterCategory.so,
  13028: CharacterCategory.so,
  13029: CharacterCategory.so,
  13030: CharacterCategory.so,
  13031: CharacterCategory.so,
  13032: CharacterCategory.so,
  13033: CharacterCategory.so,
  13034: CharacterCategory.so,
  13035: CharacterCategory.so,
  13036: CharacterCategory.so,
  13037: CharacterCategory.so,
  13038: CharacterCategory.so,
  13039: CharacterCategory.so,
  13040: CharacterCategory.so,
  13041: CharacterCategory.so,
  13042: CharacterCategory.so,
  13043: CharacterCategory.so,
  13044: CharacterCategory.so,
  13045: CharacterCategory.so,
  13046: CharacterCategory.so,
  13047: CharacterCategory.so,
  13048: CharacterCategory.so,
  13049: CharacterCategory.so,
  13050: CharacterCategory.so,
  13051: CharacterCategory.so,
  13052: CharacterCategory.so,
  13053: CharacterCategory.so,
  13054: CharacterCategory.so,
  13056: CharacterCategory.so,
  13057: CharacterCategory.so,
  13058: CharacterCategory.so,
  13059: CharacterCategory.so,
  13060: CharacterCategory.so,
  13061: CharacterCategory.so,
  13062: CharacterCategory.so,
  13063: CharacterCategory.so,
  13064: CharacterCategory.so,
  13065: CharacterCategory.so,
  13066: CharacterCategory.so,
  13067: CharacterCategory.so,
  13068: CharacterCategory.so,
  13069: CharacterCategory.so,
  13070: CharacterCategory.so,
  13071: CharacterCategory.so,
  13072: CharacterCategory.so,
  13073: CharacterCategory.so,
  13074: CharacterCategory.so,
  13075: CharacterCategory.so,
  13076: CharacterCategory.so,
  13077: CharacterCategory.so,
  13078: CharacterCategory.so,
  13079: CharacterCategory.so,
  13080: CharacterCategory.so,
  13081: CharacterCategory.so,
  13082: CharacterCategory.so,
  13083: CharacterCategory.so,
  13084: CharacterCategory.so,
  13085: CharacterCategory.so,
  13086: CharacterCategory.so,
  13087: CharacterCategory.so,
  13088: CharacterCategory.so,
  13089: CharacterCategory.so,
  13090: CharacterCategory.so,
  13091: CharacterCategory.so,
  13092: CharacterCategory.so,
  13093: CharacterCategory.so,
  13094: CharacterCategory.so,
  13095: CharacterCategory.so,
  13096: CharacterCategory.so,
  13097: CharacterCategory.so,
  13098: CharacterCategory.so,
  13099: CharacterCategory.so,
  13100: CharacterCategory.so,
  13101: CharacterCategory.so,
  13102: CharacterCategory.so,
  13103: CharacterCategory.so,
  13104: CharacterCategory.so,
  13105: CharacterCategory.so,
  13106: CharacterCategory.so,
  13107: CharacterCategory.so,
  13108: CharacterCategory.so,
  13109: CharacterCategory.so,
  13110: CharacterCategory.so,
  13111: CharacterCategory.so,
  13112: CharacterCategory.so,
  13113: CharacterCategory.so,
  13114: CharacterCategory.so,
  13115: CharacterCategory.so,
  13116: CharacterCategory.so,
  13117: CharacterCategory.so,
  13118: CharacterCategory.so,
  13119: CharacterCategory.so,
  13120: CharacterCategory.so,
  13121: CharacterCategory.so,
  13122: CharacterCategory.so,
  13123: CharacterCategory.so,
  13124: CharacterCategory.so,
  13125: CharacterCategory.so,
  13126: CharacterCategory.so,
  13127: CharacterCategory.so,
  13128: CharacterCategory.so,
  13129: CharacterCategory.so,
  13130: CharacterCategory.so,
  13131: CharacterCategory.so,
  13132: CharacterCategory.so,
  13133: CharacterCategory.so,
  13134: CharacterCategory.so,
  13135: CharacterCategory.so,
  13136: CharacterCategory.so,
  13137: CharacterCategory.so,
  13138: CharacterCategory.so,
  13139: CharacterCategory.so,
  13140: CharacterCategory.so,
  13141: CharacterCategory.so,
  13142: CharacterCategory.so,
  13143: CharacterCategory.so,
  13144: CharacterCategory.so,
  13145: CharacterCategory.so,
  13146: CharacterCategory.so,
  13147: CharacterCategory.so,
  13148: CharacterCategory.so,
  13149: CharacterCategory.so,
  13150: CharacterCategory.so,
  13151: CharacterCategory.so,
  13152: CharacterCategory.so,
  13153: CharacterCategory.so,
  13154: CharacterCategory.so,
  13155: CharacterCategory.so,
  13156: CharacterCategory.so,
  13157: CharacterCategory.so,
  13158: CharacterCategory.so,
  13159: CharacterCategory.so,
  13160: CharacterCategory.so,
  13161: CharacterCategory.so,
  13162: CharacterCategory.so,
  13163: CharacterCategory.so,
  13164: CharacterCategory.so,
  13165: CharacterCategory.so,
  13166: CharacterCategory.so,
  13167: CharacterCategory.so,
  13168: CharacterCategory.so,
  13169: CharacterCategory.so,
  13170: CharacterCategory.so,
  13171: CharacterCategory.so,
  13172: CharacterCategory.so,
  13173: CharacterCategory.so,
  13174: CharacterCategory.so,
  13175: CharacterCategory.so,
  13176: CharacterCategory.so,
  13177: CharacterCategory.so,
  13178: CharacterCategory.so,
  13179: CharacterCategory.so,
  13180: CharacterCategory.so,
  13181: CharacterCategory.so,
  13182: CharacterCategory.so,
  13183: CharacterCategory.so,
  13184: CharacterCategory.so,
  13185: CharacterCategory.so,
  13186: CharacterCategory.so,
  13187: CharacterCategory.so,
  13188: CharacterCategory.so,
  13189: CharacterCategory.so,
  13190: CharacterCategory.so,
  13191: CharacterCategory.so,
  13192: CharacterCategory.so,
  13193: CharacterCategory.so,
  13194: CharacterCategory.so,
  13195: CharacterCategory.so,
  13196: CharacterCategory.so,
  13197: CharacterCategory.so,
  13198: CharacterCategory.so,
  13199: CharacterCategory.so,
  13200: CharacterCategory.so,
  13201: CharacterCategory.so,
  13202: CharacterCategory.so,
  13203: CharacterCategory.so,
  13204: CharacterCategory.so,
  13205: CharacterCategory.so,
  13206: CharacterCategory.so,
  13207: CharacterCategory.so,
  13208: CharacterCategory.so,
  13209: CharacterCategory.so,
  13210: CharacterCategory.so,
  13211: CharacterCategory.so,
  13212: CharacterCategory.so,
  13213: CharacterCategory.so,
  13214: CharacterCategory.so,
  13215: CharacterCategory.so,
  13216: CharacterCategory.so,
  13217: CharacterCategory.so,
  13218: CharacterCategory.so,
  13219: CharacterCategory.so,
  13220: CharacterCategory.so,
  13221: CharacterCategory.so,
  13222: CharacterCategory.so,
  13223: CharacterCategory.so,
  13224: CharacterCategory.so,
  13225: CharacterCategory.so,
  13226: CharacterCategory.so,
  13227: CharacterCategory.so,
  13228: CharacterCategory.so,
  13229: CharacterCategory.so,
  13230: CharacterCategory.so,
  13231: CharacterCategory.so,
  13232: CharacterCategory.so,
  13233: CharacterCategory.so,
  13234: CharacterCategory.so,
  13235: CharacterCategory.so,
  13236: CharacterCategory.so,
  13237: CharacterCategory.so,
  13238: CharacterCategory.so,
  13239: CharacterCategory.so,
  13240: CharacterCategory.so,
  13241: CharacterCategory.so,
  13242: CharacterCategory.so,
  13243: CharacterCategory.so,
  13244: CharacterCategory.so,
  13245: CharacterCategory.so,
  13246: CharacterCategory.so,
  13247: CharacterCategory.so,
  13248: CharacterCategory.so,
  13249: CharacterCategory.so,
  13250: CharacterCategory.so,
  13251: CharacterCategory.so,
  13252: CharacterCategory.so,
  13253: CharacterCategory.so,
  13254: CharacterCategory.so,
  13255: CharacterCategory.so,
  13256: CharacterCategory.so,
  13257: CharacterCategory.so,
  13258: CharacterCategory.so,
  13259: CharacterCategory.so,
  13260: CharacterCategory.so,
  13261: CharacterCategory.so,
  13262: CharacterCategory.so,
  13263: CharacterCategory.so,
  13264: CharacterCategory.so,
  13265: CharacterCategory.so,
  13266: CharacterCategory.so,
  13267: CharacterCategory.so,
  13268: CharacterCategory.so,
  13269: CharacterCategory.so,
  13270: CharacterCategory.so,
  13271: CharacterCategory.so,
  13272: CharacterCategory.so,
  13273: CharacterCategory.so,
  13274: CharacterCategory.so,
  13275: CharacterCategory.so,
  13276: CharacterCategory.so,
  13277: CharacterCategory.so,
  13278: CharacterCategory.so,
  13279: CharacterCategory.so,
  13280: CharacterCategory.so,
  13281: CharacterCategory.so,
  13282: CharacterCategory.so,
  13283: CharacterCategory.so,
  13284: CharacterCategory.so,
  13285: CharacterCategory.so,
  13286: CharacterCategory.so,
  13287: CharacterCategory.so,
  13288: CharacterCategory.so,
  13289: CharacterCategory.so,
  13290: CharacterCategory.so,
  13291: CharacterCategory.so,
  13292: CharacterCategory.so,
  13293: CharacterCategory.so,
  13294: CharacterCategory.so,
  13295: CharacterCategory.so,
  13296: CharacterCategory.so,
  13297: CharacterCategory.so,
  13298: CharacterCategory.so,
  13299: CharacterCategory.so,
  13300: CharacterCategory.so,
  13301: CharacterCategory.so,
  13302: CharacterCategory.so,
  13303: CharacterCategory.so,
  13304: CharacterCategory.so,
  13305: CharacterCategory.so,
  13306: CharacterCategory.so,
  13307: CharacterCategory.so,
  13308: CharacterCategory.so,
  13309: CharacterCategory.so,
  13310: CharacterCategory.so,
  13311: CharacterCategory.so,
  19904: CharacterCategory.so,
  19905: CharacterCategory.so,
  19906: CharacterCategory.so,
  19907: CharacterCategory.so,
  19908: CharacterCategory.so,
  19909: CharacterCategory.so,
  19910: CharacterCategory.so,
  19911: CharacterCategory.so,
  19912: CharacterCategory.so,
  19913: CharacterCategory.so,
  19914: CharacterCategory.so,
  19915: CharacterCategory.so,
  19916: CharacterCategory.so,
  19917: CharacterCategory.so,
  19918: CharacterCategory.so,
  19919: CharacterCategory.so,
  19920: CharacterCategory.so,
  19921: CharacterCategory.so,
  19922: CharacterCategory.so,
  19923: CharacterCategory.so,
  19924: CharacterCategory.so,
  19925: CharacterCategory.so,
  19926: CharacterCategory.so,
  19927: CharacterCategory.so,
  19928: CharacterCategory.so,
  19929: CharacterCategory.so,
  19930: CharacterCategory.so,
  19931: CharacterCategory.so,
  19932: CharacterCategory.so,
  19933: CharacterCategory.so,
  19934: CharacterCategory.so,
  19935: CharacterCategory.so,
  19936: CharacterCategory.so,
  19937: CharacterCategory.so,
  19938: CharacterCategory.so,
  19939: CharacterCategory.so,
  19940: CharacterCategory.so,
  19941: CharacterCategory.so,
  19942: CharacterCategory.so,
  19943: CharacterCategory.so,
  19944: CharacterCategory.so,
  19945: CharacterCategory.so,
  19946: CharacterCategory.so,
  19947: CharacterCategory.so,
  19948: CharacterCategory.so,
  19949: CharacterCategory.so,
  19950: CharacterCategory.so,
  19951: CharacterCategory.so,
  19952: CharacterCategory.so,
  19953: CharacterCategory.so,
  19954: CharacterCategory.so,
  19955: CharacterCategory.so,
  19956: CharacterCategory.so,
  19957: CharacterCategory.so,
  19958: CharacterCategory.so,
  19959: CharacterCategory.so,
  19960: CharacterCategory.so,
  19961: CharacterCategory.so,
  19962: CharacterCategory.so,
  19963: CharacterCategory.so,
  19964: CharacterCategory.so,
  19965: CharacterCategory.so,
  19966: CharacterCategory.so,
  19967: CharacterCategory.so,
  42128: CharacterCategory.so,
  42129: CharacterCategory.so,
  42130: CharacterCategory.so,
  42131: CharacterCategory.so,
  42132: CharacterCategory.so,
  42133: CharacterCategory.so,
  42134: CharacterCategory.so,
  42135: CharacterCategory.so,
  42136: CharacterCategory.so,
  42137: CharacterCategory.so,
  42138: CharacterCategory.so,
  42139: CharacterCategory.so,
  42140: CharacterCategory.so,
  42141: CharacterCategory.so,
  42142: CharacterCategory.so,
  42143: CharacterCategory.so,
  42144: CharacterCategory.so,
  42145: CharacterCategory.so,
  42146: CharacterCategory.so,
  42147: CharacterCategory.so,
  42148: CharacterCategory.so,
  42149: CharacterCategory.so,
  42150: CharacterCategory.so,
  42151: CharacterCategory.so,
  42152: CharacterCategory.so,
  42153: CharacterCategory.so,
  42154: CharacterCategory.so,
  42155: CharacterCategory.so,
  42156: CharacterCategory.so,
  42157: CharacterCategory.so,
  42158: CharacterCategory.so,
  42159: CharacterCategory.so,
  42160: CharacterCategory.so,
  42161: CharacterCategory.so,
  42162: CharacterCategory.so,
  42163: CharacterCategory.so,
  42164: CharacterCategory.so,
  42165: CharacterCategory.so,
  42166: CharacterCategory.so,
  42167: CharacterCategory.so,
  42168: CharacterCategory.so,
  42169: CharacterCategory.so,
  42170: CharacterCategory.so,
  42171: CharacterCategory.so,
  42172: CharacterCategory.so,
  42173: CharacterCategory.so,
  42174: CharacterCategory.so,
  42175: CharacterCategory.so,
  42176: CharacterCategory.so,
  42177: CharacterCategory.so,
  42178: CharacterCategory.so,
  42179: CharacterCategory.so,
  42180: CharacterCategory.so,
  42181: CharacterCategory.so,
  42182: CharacterCategory.so,
  43048: CharacterCategory.so,
  43049: CharacterCategory.so,
  43050: CharacterCategory.so,
  43051: CharacterCategory.so,
  43062: CharacterCategory.so,
  43063: CharacterCategory.so,
  43065: CharacterCategory.so,
  43639: CharacterCategory.so,
  43640: CharacterCategory.so,
  43641: CharacterCategory.so,
  65021: CharacterCategory.so,
  65508: CharacterCategory.so,
  65512: CharacterCategory.so,
  65517: CharacterCategory.so,
  65518: CharacterCategory.so,
  65532: CharacterCategory.so,
  65533: CharacterCategory.so,
  32: CharacterCategory.zs,
  160: CharacterCategory.zs,
  5760: CharacterCategory.zs,
  8192: CharacterCategory.zs,
  8193: CharacterCategory.zs,
  8194: CharacterCategory.zs,
  8195: CharacterCategory.zs,
  8196: CharacterCategory.zs,
  8197: CharacterCategory.zs,
  8198: CharacterCategory.zs,
  8199: CharacterCategory.zs,
  8200: CharacterCategory.zs,
  8201: CharacterCategory.zs,
  8202: CharacterCategory.zs,
  8239: CharacterCategory.zs,
  8287: CharacterCategory.zs,
  12288: CharacterCategory.zs,
  8232: CharacterCategory.zl,
  8233: CharacterCategory.zp,
  0: CharacterCategory.cc,
  1: CharacterCategory.cc,
  2: CharacterCategory.cc,
  3: CharacterCategory.cc,
  4: CharacterCategory.cc,
  5: CharacterCategory.cc,
  6: CharacterCategory.cc,
  7: CharacterCategory.cc,
  8: CharacterCategory.cc,
  9: CharacterCategory.cc,
  10: CharacterCategory.cc,
  11: CharacterCategory.cc,
  12: CharacterCategory.cc,
  13: CharacterCategory.cc,
  14: CharacterCategory.cc,
  15: CharacterCategory.cc,
  16: CharacterCategory.cc,
  17: CharacterCategory.cc,
  18: CharacterCategory.cc,
  19: CharacterCategory.cc,
  20: CharacterCategory.cc,
  21: CharacterCategory.cc,
  22: CharacterCategory.cc,
  23: CharacterCategory.cc,
  24: CharacterCategory.cc,
  25: CharacterCategory.cc,
  26: CharacterCategory.cc,
  27: CharacterCategory.cc,
  28: CharacterCategory.cc,
  29: CharacterCategory.cc,
  30: CharacterCategory.cc,
  31: CharacterCategory.cc,
  127: CharacterCategory.cc,
  128: CharacterCategory.cc,
  129: CharacterCategory.cc,
  130: CharacterCategory.cc,
  131: CharacterCategory.cc,
  132: CharacterCategory.cc,
  133: CharacterCategory.cc,
  134: CharacterCategory.cc,
  135: CharacterCategory.cc,
  136: CharacterCategory.cc,
  137: CharacterCategory.cc,
  138: CharacterCategory.cc,
  139: CharacterCategory.cc,
  140: CharacterCategory.cc,
  141: CharacterCategory.cc,
  142: CharacterCategory.cc,
  143: CharacterCategory.cc,
  144: CharacterCategory.cc,
  145: CharacterCategory.cc,
  146: CharacterCategory.cc,
  147: CharacterCategory.cc,
  148: CharacterCategory.cc,
  149: CharacterCategory.cc,
  150: CharacterCategory.cc,
  151: CharacterCategory.cc,
  152: CharacterCategory.cc,
  153: CharacterCategory.cc,
  154: CharacterCategory.cc,
  155: CharacterCategory.cc,
  156: CharacterCategory.cc,
  157: CharacterCategory.cc,
  158: CharacterCategory.cc,
  159: CharacterCategory.cc,
  173: CharacterCategory.cf,
  1536: CharacterCategory.cf,
  1537: CharacterCategory.cf,
  1538: CharacterCategory.cf,
  1539: CharacterCategory.cf,
  1540: CharacterCategory.cf,
  1541: CharacterCategory.cf,
  1564: CharacterCategory.cf,
  1757: CharacterCategory.cf,
  1807: CharacterCategory.cf,
  6158: CharacterCategory.cf,
  8203: CharacterCategory.cf,
  8204: CharacterCategory.cf,
  8205: CharacterCategory.cf,
  8206: CharacterCategory.cf,
  8207: CharacterCategory.cf,
  8234: CharacterCategory.cf,
  8235: CharacterCategory.cf,
  8236: CharacterCategory.cf,
  8237: CharacterCategory.cf,
  8238: CharacterCategory.cf,
  8288: CharacterCategory.cf,
  8289: CharacterCategory.cf,
  8290: CharacterCategory.cf,
  8291: CharacterCategory.cf,
  8292: CharacterCategory.cf,
  8294: CharacterCategory.cf,
  8295: CharacterCategory.cf,
  8296: CharacterCategory.cf,
  8297: CharacterCategory.cf,
  8298: CharacterCategory.cf,
  8299: CharacterCategory.cf,
  8300: CharacterCategory.cf,
  8301: CharacterCategory.cf,
  8302: CharacterCategory.cf,
  8303: CharacterCategory.cf,
  65279: CharacterCategory.cf,
  65529: CharacterCategory.cf,
  65530: CharacterCategory.cf,
  65531: CharacterCategory.cf,
  55296: CharacterCategory.cs,
  56191: CharacterCategory.cs,
  56192: CharacterCategory.cs,
  56319: CharacterCategory.cs,
  56320: CharacterCategory.cs,
  57343: CharacterCategory.cs,
  57344: CharacterCategory.co,
  63743: CharacterCategory.co
};
