// Autogenerated from Pigeon (v21.2.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Any?

  init(code: String, message: String?, details: Any?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
      }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

/// A range of characters in a string of text.
///
/// The text included in the range includes the character at [start], but not
/// the one at [end].
///
/// This is used because we can't use `TextRange` in pigeon.
///
/// Generated class from Pigeon that represents data sent in messages.
struct PigeonRange {
  var start: Int64
  var end: Int64



  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> PigeonRange? {
    let start = pigeonVar_list[0] is Int64 ? pigeonVar_list[0] as! Int64 : Int64(pigeonVar_list[0] as! Int32)
    let end = pigeonVar_list[1] is Int64 ? pigeonVar_list[1] as! Int64 : Int64(pigeonVar_list[1] as! Int32)

    return PigeonRange(
      start: start,
      end: end
    )
  }
  func toList() -> [Any?] {
    return [
      start,
      end,
    ]
  }
}

/// The result of a grammatical analysis.
///
/// Generated class from Pigeon that represents data sent in messages.
struct PigeonCheckGrammarResult {
  /// The range of the first error found in the text or `null` if no errors were found.
  var firstError: PigeonRange? = nil
  /// A list of details about the grammatical errors found in the text or `null`
  /// if no errors were found.
  var details: [PigeonGrammaticalAnalysisDetail?]? = nil



  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> PigeonCheckGrammarResult? {
    let firstError: PigeonRange? = nilOrValue(pigeonVar_list[0])
    let details: [PigeonGrammaticalAnalysisDetail?]? = nilOrValue(pigeonVar_list[1])

    return PigeonCheckGrammarResult(
      firstError: firstError,
      details: details
    )
  }
  func toList() -> [Any?] {
    return [
      firstError,
      details,
    ]
  }
}

/// A detail about a grammatical error found in a text.
///
/// Generated class from Pigeon that represents data sent in messages.
struct PigeonGrammaticalAnalysisDetail {
  /// The range of the grammatical error in the text.
  var range: PigeonRange
  /// A description of the grammatical error.
  var userDescription: String



  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> PigeonGrammaticalAnalysisDetail? {
    let range = pigeonVar_list[0] as! PigeonRange
    let userDescription = pigeonVar_list[1] as! String

    return PigeonGrammaticalAnalysisDetail(
      range: range,
      userDescription: userDescription
    )
  }
  func toList() -> [Any?] {
    return [
      range,
      userDescription,
    ]
  }
}

private class messagesPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      return PigeonRange.fromList(self.readValue() as! [Any?])
    case 130:
      return PigeonCheckGrammarResult.fromList(self.readValue() as! [Any?])
    case 131:
      return PigeonGrammaticalAnalysisDetail.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class messagesPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? PigeonRange {
      super.writeByte(129)
      super.writeValue(value.toList())
    } else if let value = value as? PigeonCheckGrammarResult {
      super.writeByte(130)
      super.writeValue(value.toList())
    } else if let value = value as? PigeonGrammaticalAnalysisDetail {
      super.writeByte(131)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class messagesPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return messagesPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return messagesPigeonCodecWriter(data: data)
  }
}

class messagesPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = messagesPigeonCodec(readerWriter: messagesPigeonCodecReaderWriter())
}

/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol SpellCheckMac {
  /// {@template mac_spell_checker_available_languages}
  /// A list containing all the available spell checking languages.
  ///
  /// The languages are ordered in the user’s preferred order as set in the
  /// system preferences.
  /// {@endtemplate}
  func availableLanguages() throws -> [String?]
  /// {@template mac_spell_checker_unique_spell_document_tag}
  /// Returns a unique tag to partition stateful operations in the spell checking system.
  ///
  /// Use the tag returned by this method in the spell checking methods when there are different
  /// texts being spell checked.
  ///
  /// For example, if there are two texts being spell checked, with tags `1` and `2`,
  /// the spell checker will keep the state of the ignored words separate for each one. If an
  /// ignored word is added to the tag `1`, it won't be seen as misspelled for tag `1`, but it
  /// will be for the tag `2`.
  ///
  /// Call [closeSpellDocument] when you are done with the tag to release resources.
  /// {@endtemplate}
  func uniqueSpellDocumentTag() throws -> Int64
  /// {@template mac_spell_checker_close_spell_document}
  /// Notifies the spell checking system that the user has finished with the tagged document.
  ///
  /// The spell checker will release any resources associated with the document,
  /// including but not necessarily limited to, ignored words.
  /// {@endtemplate}
  func closeSpellDocument(tag: Int64) throws
  /// {@template mac_spell_checker_check_spelling}
  /// Searches for a misspelled word in [stringToCheck], starting at [startingOffset], and returns the
  /// [TextRange] surrounding the misspelled word.
  ///
  /// If no misspelled word is found, a [TextRange] is returned with bounds of `-1`, which can also be
  /// queried more conveniently with [TextRange.isValid].
  ///
  /// To find all (or multiple) misspelled words in a given string, call this
  /// method repeatedly, passing in different values for [startingOffset].
  /// {@endtemplate}
  func checkSpelling(stringToCheck: String, startingOffset: Int64, language: String?, wrap: Bool, inSpellDocumentWithTag: Int64) throws -> PigeonRange
  /// {@template mac_spell_checker_guesses}
  /// Returns possible substitutions for the specified misspelled word at [range] inside the [text].
  ///
  /// - [range]: The range, within the [text], for which possible substitutions should be generated.
  /// - [text]: The string containing the word/text for which substitutions should be generated.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [text] in isolation, without connection to any given document.
  /// {@endtemplate}
  func guesses(text: String, range: PigeonRange, language: String?, inSpellDocumentWithTag: Int64) throws -> [String?]?
  /// {@template mac_spell_checker_correction}
  /// Returns a single proposed correction if a word is mis-spelled.
  ///
  /// - [range]: The range, within the [text], for which a possible should be generated.
  /// - [text]: The string containing the word/text for which the correction should be generated.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [text] in isolation, without connection to any given document.
  /// {@endtemplate}
  func correction(text: String, range: PigeonRange, language: String, inSpellDocumentWithTag: Int64) throws -> String?
  /// {@template mac_spell_checker_check_grammar}
  /// Performs a grammatical analysis of [stringToCheck], starting at [startingOffset].
  ///
  /// - [stringToCheck]: The string containing the text to be analyzed.
  /// - [startingOffset]: Location within the text at which the analysis should start.
  /// - [wrap]: `true` to specify that the analysis continue to the beginning of the text when
  ///   the end is reached. `false` to have the analysis stop at the end of the text.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [stringToCheck] in isolation, without connection to any given document.
  /// {@endtemplate}
  func checkGrammar(stringToCheck: String, startingOffset: Int64, language: String?, wrap: Bool, inSpellDocumentWithTag: Int64) throws -> PigeonCheckGrammarResult
  /// {@template mac_spell_checker_completions}
  /// Provides a list of complete words that the user might be trying to type based on a partial word
  /// at [partialWordRange] in the given [text].
  ///
  /// - [partialWordRange] - The range, within the [text], for which possible completions should be generated.
  /// - [text] - The string containing the partial word for which completions should be generated.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [text] in isolation, without connection to any given document.
  ///
  /// The items of the list are in the order they should be presented to the user.
  /// {@endtemplate}
  func completions(partialWordRange: PigeonRange, text: String, language: String?, inSpellDocumentWithTag: Int64) throws -> [String]?
  /// {@template mac_spell_checker_count_words}
  /// Returns the number of words in the specified string.
  /// {@endtemplate}
  func countWords(text: String, language: String?) throws -> Int64
  /// {@template mac_spell_checker_learn_word}
  /// Adds the [word] to the spell checker dictionary.
  /// {@endtemplate}
  func learnWord(word: String) throws
  /// {@template mac_spell_checker_has_learned_word}
  /// Indicates whether the spell checker has learned a given word.
  /// {@endtemplate}
  func hasLearnedWord(word: String) throws -> Bool
  /// {@template mac_spell_checker_unlearn_word}
  /// Tells the spell checker to unlearn a given word.
  /// {@endtemplate}
  func unlearnWord(word: String) throws
  /// {@template mac_spell_checker_ignore_word}
  /// Instructs the spell checker to ignore all future occurrences of [word] in the document
  /// identified by [documentTag].
  /// {@endtemplate}
  func ignoreWord(word: String, documentTag: Int64) throws
  /// {@template mac_spell_checker_ignored_words}
  /// Returns the array of ignored words for a document identified by [documentTag].
  /// {@endtemplate}
  func ignoredWords(documentTag: Int64) throws -> [String]?
  /// {@template mac_spell_checker_set_ignored_words}
  /// Updates the ignored-words document (a dictionary identified by [documentTag] with [words])
  /// with a list of [words] to ignore.
  /// {@endtemplate}
  func setIgnoredWords(words: [String], documentTag: Int64) throws
  /// {@template mac_spell_checker_user_replacements_dictionary}
  /// Returns the dictionary used when replacing words, as defined by the user in the system preferences.
  ///
  /// This can be used to create an UI with replacement options when the user types a certain
  /// combination of characters. For example, the user might want to automatically replace
  /// "omw" with "on my way". When the user types "omw", an UI should display "on my way" as
  /// a possible replacement.
  /// {@endtemplate}
  func userReplacementsDictionary() throws -> [String: String]
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class SpellCheckMacSetup {
  static var codec: FlutterStandardMessageCodec { messagesPigeonCodec.shared }
  /// Sets up an instance of `SpellCheckMac` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: SpellCheckMac?, messageChannelSuffix: String = "") {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    /// {@template mac_spell_checker_available_languages}
    /// A list containing all the available spell checking languages.
    ///
    /// The languages are ordered in the user’s preferred order as set in the
    /// system preferences.
    /// {@endtemplate}
    let availableLanguagesChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.availableLanguages\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      availableLanguagesChannel.setMessageHandler { _, reply in
        do {
          let result = try api.availableLanguages()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      availableLanguagesChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_unique_spell_document_tag}
    /// Returns a unique tag to partition stateful operations in the spell checking system.
    ///
    /// Use the tag returned by this method in the spell checking methods when there are different
    /// texts being spell checked.
    ///
    /// For example, if there are two texts being spell checked, with tags `1` and `2`,
    /// the spell checker will keep the state of the ignored words separate for each one. If an
    /// ignored word is added to the tag `1`, it won't be seen as misspelled for tag `1`, but it
    /// will be for the tag `2`.
    ///
    /// Call [closeSpellDocument] when you are done with the tag to release resources.
    /// {@endtemplate}
    let uniqueSpellDocumentTagChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.uniqueSpellDocumentTag\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      uniqueSpellDocumentTagChannel.setMessageHandler { _, reply in
        do {
          let result = try api.uniqueSpellDocumentTag()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      uniqueSpellDocumentTagChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_close_spell_document}
    /// Notifies the spell checking system that the user has finished with the tagged document.
    ///
    /// The spell checker will release any resources associated with the document,
    /// including but not necessarily limited to, ignored words.
    /// {@endtemplate}
    let closeSpellDocumentChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.closeSpellDocument\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      closeSpellDocumentChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let tagArg = args[0] is Int64 ? args[0] as! Int64 : Int64(args[0] as! Int32)
        do {
          try api.closeSpellDocument(tag: tagArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      closeSpellDocumentChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_check_spelling}
    /// Searches for a misspelled word in [stringToCheck], starting at [startingOffset], and returns the
    /// [TextRange] surrounding the misspelled word.
    ///
    /// If no misspelled word is found, a [TextRange] is returned with bounds of `-1`, which can also be
    /// queried more conveniently with [TextRange.isValid].
    ///
    /// To find all (or multiple) misspelled words in a given string, call this
    /// method repeatedly, passing in different values for [startingOffset].
    /// {@endtemplate}
    let checkSpellingChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.checkSpelling\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      checkSpellingChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringToCheckArg = args[0] as! String
        let startingOffsetArg = args[1] is Int64 ? args[1] as! Int64 : Int64(args[1] as! Int32)
        let languageArg: String? = nilOrValue(args[2])
        let wrapArg = args[3] as! Bool
        let inSpellDocumentWithTagArg = args[4] is Int64 ? args[4] as! Int64 : Int64(args[4] as! Int32)
        do {
          let result = try api.checkSpelling(stringToCheck: stringToCheckArg, startingOffset: startingOffsetArg, language: languageArg, wrap: wrapArg, inSpellDocumentWithTag: inSpellDocumentWithTagArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      checkSpellingChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_guesses}
    /// Returns possible substitutions for the specified misspelled word at [range] inside the [text].
    ///
    /// - [range]: The range, within the [text], for which possible substitutions should be generated.
    /// - [text]: The string containing the word/text for which substitutions should be generated.
    /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
    ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
    ///   the guessing system to consider the [text] in isolation, without connection to any given document.
    /// {@endtemplate}
    let guessesChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.guesses\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      guessesChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let textArg = args[0] as! String
        let rangeArg = args[1] as! PigeonRange
        let languageArg: String? = nilOrValue(args[2])
        let inSpellDocumentWithTagArg = args[3] is Int64 ? args[3] as! Int64 : Int64(args[3] as! Int32)
        do {
          let result = try api.guesses(text: textArg, range: rangeArg, language: languageArg, inSpellDocumentWithTag: inSpellDocumentWithTagArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      guessesChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_correction}
    /// Returns a single proposed correction if a word is mis-spelled.
    ///
    /// - [range]: The range, within the [text], for which a possible should be generated.
    /// - [text]: The string containing the word/text for which the correction should be generated.
    /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
    ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
    ///   the guessing system to consider the [text] in isolation, without connection to any given document.
    /// {@endtemplate}
    let correctionChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.correction\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      correctionChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let textArg = args[0] as! String
        let rangeArg = args[1] as! PigeonRange
        let languageArg = args[2] as! String
        let inSpellDocumentWithTagArg = args[3] is Int64 ? args[3] as! Int64 : Int64(args[3] as! Int32)
        do {
          let result = try api.correction(text: textArg, range: rangeArg, language: languageArg, inSpellDocumentWithTag: inSpellDocumentWithTagArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      correctionChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_check_grammar}
    /// Performs a grammatical analysis of [stringToCheck], starting at [startingOffset].
    ///
    /// - [stringToCheck]: The string containing the text to be analyzed.
    /// - [startingOffset]: Location within the text at which the analysis should start.
    /// - [wrap]: `true` to specify that the analysis continue to the beginning of the text when
    ///   the end is reached. `false` to have the analysis stop at the end of the text.
    /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
    ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
    ///   the guessing system to consider the [stringToCheck] in isolation, without connection to any given document.
    /// {@endtemplate}
    let checkGrammarChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.checkGrammar\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      checkGrammarChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let stringToCheckArg = args[0] as! String
        let startingOffsetArg = args[1] is Int64 ? args[1] as! Int64 : Int64(args[1] as! Int32)
        let languageArg: String? = nilOrValue(args[2])
        let wrapArg = args[3] as! Bool
        let inSpellDocumentWithTagArg = args[4] is Int64 ? args[4] as! Int64 : Int64(args[4] as! Int32)
        do {
          let result = try api.checkGrammar(stringToCheck: stringToCheckArg, startingOffset: startingOffsetArg, language: languageArg, wrap: wrapArg, inSpellDocumentWithTag: inSpellDocumentWithTagArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      checkGrammarChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_completions}
    /// Provides a list of complete words that the user might be trying to type based on a partial word
    /// at [partialWordRange] in the given [text].
    ///
    /// - [partialWordRange] - The range, within the [text], for which possible completions should be generated.
    /// - [text] - The string containing the partial word for which completions should be generated.
    /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
    ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
    ///   the guessing system to consider the [text] in isolation, without connection to any given document.
    ///
    /// The items of the list are in the order they should be presented to the user.
    /// {@endtemplate}
    let completionsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.completions\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      completionsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let partialWordRangeArg = args[0] as! PigeonRange
        let textArg = args[1] as! String
        let languageArg: String? = nilOrValue(args[2])
        let inSpellDocumentWithTagArg = args[3] is Int64 ? args[3] as! Int64 : Int64(args[3] as! Int32)
        do {
          let result = try api.completions(partialWordRange: partialWordRangeArg, text: textArg, language: languageArg, inSpellDocumentWithTag: inSpellDocumentWithTagArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      completionsChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_count_words}
    /// Returns the number of words in the specified string.
    /// {@endtemplate}
    let countWordsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.countWords\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      countWordsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let textArg = args[0] as! String
        let languageArg: String? = nilOrValue(args[1])
        do {
          let result = try api.countWords(text: textArg, language: languageArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      countWordsChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_learn_word}
    /// Adds the [word] to the spell checker dictionary.
    /// {@endtemplate}
    let learnWordChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.learnWord\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      learnWordChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wordArg = args[0] as! String
        do {
          try api.learnWord(word: wordArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      learnWordChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_has_learned_word}
    /// Indicates whether the spell checker has learned a given word.
    /// {@endtemplate}
    let hasLearnedWordChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.hasLearnedWord\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      hasLearnedWordChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wordArg = args[0] as! String
        do {
          let result = try api.hasLearnedWord(word: wordArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      hasLearnedWordChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_unlearn_word}
    /// Tells the spell checker to unlearn a given word.
    /// {@endtemplate}
    let unlearnWordChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.unlearnWord\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      unlearnWordChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wordArg = args[0] as! String
        do {
          try api.unlearnWord(word: wordArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      unlearnWordChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_ignore_word}
    /// Instructs the spell checker to ignore all future occurrences of [word] in the document
    /// identified by [documentTag].
    /// {@endtemplate}
    let ignoreWordChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.ignoreWord\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      ignoreWordChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wordArg = args[0] as! String
        let documentTagArg = args[1] is Int64 ? args[1] as! Int64 : Int64(args[1] as! Int32)
        do {
          try api.ignoreWord(word: wordArg, documentTag: documentTagArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      ignoreWordChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_ignored_words}
    /// Returns the array of ignored words for a document identified by [documentTag].
    /// {@endtemplate}
    let ignoredWordsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.ignoredWords\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      ignoredWordsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let documentTagArg = args[0] is Int64 ? args[0] as! Int64 : Int64(args[0] as! Int32)
        do {
          let result = try api.ignoredWords(documentTag: documentTagArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      ignoredWordsChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_set_ignored_words}
    /// Updates the ignored-words document (a dictionary identified by [documentTag] with [words])
    /// with a list of [words] to ignore.
    /// {@endtemplate}
    let setIgnoredWordsChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.setIgnoredWords\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      setIgnoredWordsChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let wordsArg = args[0] as! [String]
        let documentTagArg = args[1] is Int64 ? args[1] as! Int64 : Int64(args[1] as! Int32)
        do {
          try api.setIgnoredWords(words: wordsArg, documentTag: documentTagArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      setIgnoredWordsChannel.setMessageHandler(nil)
    }
    /// {@template mac_spell_checker_user_replacements_dictionary}
    /// Returns the dictionary used when replacing words, as defined by the user in the system preferences.
    ///
    /// This can be used to create an UI with replacement options when the user types a certain
    /// combination of characters. For example, the user might want to automatically replace
    /// "omw" with "on my way". When the user types "omw", an UI should display "on my way" as
    /// a possible replacement.
    /// {@endtemplate}
    let userReplacementsDictionaryChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.userReplacementsDictionary\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      userReplacementsDictionaryChannel.setMessageHandler { _, reply in
        do {
          let result = try api.userReplacementsDictionary()
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      userReplacementsDictionaryChannel.setMessageHandler(nil)
    }
  }
}
