// Autogenerated from Pigeon (v21.2.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

/// A range of characters in a string of text.
///
/// The text included in the range includes the character at [start], but not
/// the one at [end].
///
/// This is used because we can't use `TextRange` in pigeon.
class PigeonRange {
  PigeonRange({
    required this.start,
    required this.end,
  });

  int start;

  int end;

  Object encode() {
    return <Object?>[
      start,
      end,
    ];
  }

  static PigeonRange decode(Object result) {
    result as List<Object?>;
    return PigeonRange(
      start: result[0]! as int,
      end: result[1]! as int,
    );
  }
}

/// The result of a grammatical analysis.
class PigeonCheckGrammarResult {
  PigeonCheckGrammarResult({
    this.firstError,
    this.details,
  });

  /// The range of the first error found in the text or `null` if no errors were found.
  PigeonRange? firstError;

  /// A list of details about the grammatical errors found in the text or `null`
  /// if no errors were found.
  List<PigeonGrammaticalAnalysisDetail?>? details;

  Object encode() {
    return <Object?>[
      firstError,
      details,
    ];
  }

  static PigeonCheckGrammarResult decode(Object result) {
    result as List<Object?>;
    return PigeonCheckGrammarResult(
      firstError: result[0] as PigeonRange?,
      details: (result[1] as List<Object?>?)?.cast<PigeonGrammaticalAnalysisDetail?>(),
    );
  }
}

/// A detail about a grammatical error found in a text.
class PigeonGrammaticalAnalysisDetail {
  PigeonGrammaticalAnalysisDetail({
    required this.range,
    required this.userDescription,
  });

  /// The range of the grammatical error in the text.
  PigeonRange range;

  /// A description of the grammatical error.
  String userDescription;

  Object encode() {
    return <Object?>[
      range,
      userDescription,
    ];
  }

  static PigeonGrammaticalAnalysisDetail decode(Object result) {
    result as List<Object?>;
    return PigeonGrammaticalAnalysisDetail(
      range: result[0]! as PigeonRange,
      userDescription: result[1]! as String,
    );
  }
}


class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is PigeonRange) {
      buffer.putUint8(129);
      writeValue(buffer, value.encode());
    } else     if (value is PigeonCheckGrammarResult) {
      buffer.putUint8(130);
      writeValue(buffer, value.encode());
    } else     if (value is PigeonGrammaticalAnalysisDetail) {
      buffer.putUint8(131);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129: 
        return PigeonRange.decode(readValue(buffer)!);
      case 130: 
        return PigeonCheckGrammarResult.decode(readValue(buffer)!);
      case 131: 
        return PigeonGrammaticalAnalysisDetail.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class SpellCheckMac {
  /// Constructor for [SpellCheckMac].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  SpellCheckMac({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// {@template mac_spell_checker_available_languages}
  /// A list containing all the available spell checking languages.
  ///
  /// The languages are ordered in the user’s preferred order as set in the
  /// system preferences.
  /// {@endtemplate}
  Future<List<String?>> availableLanguages() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.availableLanguages$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<String?>();
    }
  }

  /// {@template mac_spell_checker_unique_spell_document_tag}
  /// Returns a unique tag to partition stateful operations in the spell checking system.
  ///
  /// Use the tag returned by this method in the spell checking methods when there are different
  /// texts being spell checked.
  ///
  /// For example, if there are two texts being spell checked, with tags `1` and `2`,
  /// the spell checker will keep the state of the ignored words separate for each one. If an
  /// ignored word is added to the tag `1`, it won't be seen as misspelled for tag `1`, but it
  /// will be for the tag `2`.
  ///
  /// Call [closeSpellDocument] when you are done with the tag to release resources.
  /// {@endtemplate}
  Future<int> uniqueSpellDocumentTag() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.uniqueSpellDocumentTag$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// {@template mac_spell_checker_close_spell_document}
  /// Notifies the spell checking system that the user has finished with the tagged document.
  ///
  /// The spell checker will release any resources associated with the document,
  /// including but not necessarily limited to, ignored words.
  /// {@endtemplate}
  Future<void> closeSpellDocument(int tag) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.closeSpellDocument$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[tag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// {@template mac_spell_checker_check_spelling}
  /// Searches for a misspelled word in [stringToCheck], starting at [startingOffset], and returns the
  /// [TextRange] surrounding the misspelled word.
  ///
  /// If no misspelled word is found, a [TextRange] is returned with bounds of `-1`, which can also be
  /// queried more conveniently with [TextRange.isValid].
  ///
  /// To find all (or multiple) misspelled words in a given string, call this
  /// method repeatedly, passing in different values for [startingOffset].
  /// {@endtemplate}
  Future<PigeonRange> checkSpelling({required String stringToCheck, required int startingOffset, String? language, bool wrap = false, int inSpellDocumentWithTag = 0,}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.checkSpelling$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[stringToCheck, startingOffset, language, wrap, inSpellDocumentWithTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as PigeonRange?)!;
    }
  }

  /// {@template mac_spell_checker_guesses}
  /// Returns possible substitutions for the specified misspelled word at [range] inside the [text].
  ///
  /// - [range]: The range, within the [text], for which possible substitutions should be generated.
  /// - [text]: The string containing the word/text for which substitutions should be generated.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [text] in isolation, without connection to any given document.
  /// {@endtemplate}
  Future<List<String?>?> guesses({required String text, required PigeonRange range, String? language, int inSpellDocumentWithTag = 0,}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.guesses$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[text, range, language, inSpellDocumentWithTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<String?>();
    }
  }

  /// {@template mac_spell_checker_correction}
  /// Returns a single proposed correction if a word is mis-spelled.
  ///
  /// - [range]: The range, within the [text], for which a possible should be generated.
  /// - [text]: The string containing the word/text for which the correction should be generated.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [text] in isolation, without connection to any given document.
  /// {@endtemplate}
  Future<String?> correction({required String text, required PigeonRange range, required String language, int inSpellDocumentWithTag = 0,}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.correction$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[text, range, language, inSpellDocumentWithTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// {@template mac_spell_checker_check_grammar}
  /// Performs a grammatical analysis of [stringToCheck], starting at [startingOffset].
  ///
  /// - [stringToCheck]: The string containing the text to be analyzed.
  /// - [startingOffset]: Location within the text at which the analysis should start.
  /// - [wrap]: `true` to specify that the analysis continue to the beginning of the text when
  ///   the end is reached. `false` to have the analysis stop at the end of the text.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [stringToCheck] in isolation, without connection to any given document.
  /// {@endtemplate}
  Future<PigeonCheckGrammarResult> checkGrammar({required String stringToCheck, required int startingOffset, String? language, bool wrap = false, int inSpellDocumentWithTag = 0,}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.checkGrammar$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[stringToCheck, startingOffset, language, wrap, inSpellDocumentWithTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as PigeonCheckGrammarResult?)!;
    }
  }

  /// {@template mac_spell_checker_completions}
  /// Provides a list of complete words that the user might be trying to type based on a partial word
  /// at [partialWordRange] in the given [text].
  ///
  /// - [partialWordRange] - The range, within the [text], for which possible completions should be generated.
  /// - [text] - The string containing the partial word for which completions should be generated.
  /// - [inSpellDocumentWithTag]: The (optional) ID of the loaded document that contains the given [text],
  ///   which is used to provide additional context to the substitution guesses. A value of '0' instructs
  ///   the guessing system to consider the [text] in isolation, without connection to any given document.
  ///
  /// The items of the list are in the order they should be presented to the user.
  /// {@endtemplate}
  Future<List<String?>?> completions({required PigeonRange partialWordRange, required String text, String? language, int inSpellDocumentWithTag = 0,}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.completions$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[partialWordRange, text, language, inSpellDocumentWithTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<String?>();
    }
  }

  /// {@template mac_spell_checker_count_words}
  /// Returns the number of words in the specified string.
  /// {@endtemplate}
  Future<int> countWords({required String text, String? language}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.countWords$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[text, language]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  /// {@template mac_spell_checker_learn_word}
  /// Adds the [word] to the spell checker dictionary.
  /// {@endtemplate}
  Future<void> learnWord(String word) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.learnWord$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[word]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// {@template mac_spell_checker_has_learned_word}
  /// Indicates whether the spell checker has learned a given word.
  /// {@endtemplate}
  Future<bool> hasLearnedWord(String word) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.hasLearnedWord$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[word]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// {@template mac_spell_checker_unlearn_word}
  /// Tells the spell checker to unlearn a given word.
  /// {@endtemplate}
  Future<void> unlearnWord(String word) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.unlearnWord$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[word]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// {@template mac_spell_checker_ignore_word}
  /// Instructs the spell checker to ignore all future occurrences of [word] in the document
  /// identified by [documentTag].
  /// {@endtemplate}
  Future<void> ignoreWord({required String word, required int documentTag}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.ignoreWord$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[word, documentTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// {@template mac_spell_checker_ignored_words}
  /// Returns the array of ignored words for a document identified by [documentTag].
  /// {@endtemplate}
  Future<List<String?>?> ignoredWords(int documentTag) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.ignoredWords$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[documentTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<String?>();
    }
  }

  /// {@template mac_spell_checker_set_ignored_words}
  /// Updates the ignored-words document (a dictionary identified by [documentTag] with [words])
  /// with a list of [words] to ignore.
  /// {@endtemplate}
  Future<void> setIgnoredWords({required List<String?> words, required int documentTag}) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.setIgnoredWords$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[words, documentTag]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// {@template mac_spell_checker_user_replacements_dictionary}
  /// Returns the dictionary used when replacing words, as defined by the user in the system preferences.
  ///
  /// This can be used to create an UI with replacement options when the user types a certain
  /// combination of characters. For example, the user might want to automatically replace
  /// "omw" with "on my way". When the user types "omw", an UI should display "on my way" as
  /// a possible replacement.
  /// {@endtemplate}
  Future<Map<String?, String?>> userReplacementsDictionary() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_editor_spellcheck.SpellCheckMac.userReplacementsDictionary$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)!.cast<String?, String?>();
    }
  }
}
