/// MacOS selector names that are sent to [TextInputClient.performSelector].
///
/// These selectors express the user intent and are generated by shortcuts. For example,
/// pressing SHIFT + Left Arrow key generates a moveLeftAndModifySelection selector.
///
/// The full list can be found on https://developer.apple.com/documentation/appkit/nsstandardkeybindingresponding?changes=_8&language=objc
class MacOsSelectors {
  static const String deleteBackward = 'deleteBackward:';
  static const String deleteWordBackward = 'deleteWordBackward:';
  static const String deleteToBeginningOfLine = 'deleteToBeginningOfLine:';
  static const String deleteForward = 'deleteForward:';
  static const String deleteWordForward = 'deleteWordForward:';
  static const String deleteToEndOfLine = 'deleteToEndOfLine:';
  static const String deleteBackwardByDecomposingPreviousCharacter = 'deleteBackwardByDecomposingPreviousCharacter:';

  static const String moveLeft = 'moveLeft:';
  static const String moveRight = 'moveRight:';
  static const String moveForward = 'moveForward:';
  static const String moveBackward = 'moveBackward:';
  static const String moveUp = 'moveUp:';
  static const String moveDown = 'moveDown:';

  static const String moveWordLeft = 'moveWordLeft:';
  static const String moveWordRight = 'moveWordRight:';
  static const String moveToBeginningOfParagraph = 'moveToBeginningOfParagraph:';
  static const String moveToEndOfParagraph = 'moveToEndOfParagraph:';

  static const String moveToLeftEndOfLine = 'moveToLeftEndOfLine:';
  static const String moveToRightEndOfLine = 'moveToRightEndOfLine:';
  static const String moveToBeginningOfDocument = 'moveToBeginningOfDocument:';
  static const String moveToEndOfDocument = 'moveToEndOfDocument:';

  static const String moveLeftAndModifySelection = 'moveLeftAndModifySelection:';
  static const String moveRightAndModifySelection = 'moveRightAndModifySelection:';
  static const String moveUpAndModifySelection = 'moveUpAndModifySelection:';
  static const String moveDownAndModifySelection = 'moveDownAndModifySelection:';

  static const String moveWordLeftAndModifySelection = 'moveWordLeftAndModifySelection:';
  static const String moveWordRightAndModifySelection = 'moveWordRightAndModifySelection:';
  static const String moveParagraphBackwardAndModifySelection = 'moveParagraphBackwardAndModifySelection:';
  static const String moveParagraphForwardAndModifySelection = 'moveParagraphForwardAndModifySelection:';

  static const String moveToLeftEndOfLineAndModifySelection = 'moveToLeftEndOfLineAndModifySelection:';
  static const String moveToRightEndOfLineAndModifySelection = 'moveToRightEndOfLineAndModifySelection:';
  static const String moveToBeginningOfDocumentAndModifySelection = 'moveToBeginningOfDocumentAndModifySelection:';
  static const String moveToEndOfDocumentAndModifySelection = 'moveToEndOfDocumentAndModifySelection:';

  static const String transpose = 'transpose:';

  static const String scrollToBeginningOfDocument = 'scrollToBeginningOfDocument:';
  static const String scrollToEndOfDocument = 'scrollToEndOfDocument:';

  static const String scrollPageUp = 'scrollPageUp:';
  static const String scrollPageDown = 'scrollPageDown:';
  static const String pageUpAndModifySelection = 'pageUpAndModifySelection:';
  static const String pageDownAndModifySelection = 'pageDownAndModifySelection:';

  static const String cancelOperation = 'cancelOperation:';

  static const String insertTab = 'insertTab:';
  static const String insertBacktab = 'insertBacktab:';
  static const String insertNewLine = 'insertNewline:';
}
