import java.io.FileInputStream
import java.util.Properties

plugins {
    alias(libs.plugins.androidApplication)
    alias(libs.plugins.jetbrainsKotlinAndroid)
    alias(libs.plugins.hilt)
    id("kotlin-parcelize")
    alias(libs.plugins.compose.compiler)
    alias(libs.plugins.room)
    alias(libs.plugins.ksp)
    kotlin("plugin.serialization") version "2.0.0"
    id("com.jaredsburrows.license") version "0.9.8"
}

room {
    schemaDirectory("$projectDir/schemas")
}

android {
    namespace = "com.inky.fitnesscalendar"
    compileSdk = 36

    androidResources {
        @Suppress("UnstableApiUsage")
        generateLocaleConfig = true
    }
    defaultConfig {
        val properties = Properties().apply {
            load(FileInputStream(projectDir.resolve("version.properties")))
        }

        applicationId = "com.inky.fitnesscalendar"
        minSdk = 28
        targetSdk = 36
        versionCode = properties.getProperty("versionCode").toInt()
        versionName = properties.getProperty("versionName").toString()

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        vectorDrawables {
            useSupportLibrary = true
        }
    }


    buildTypes {
        getByName("debug") {
            isDebuggable = true
            applicationIdSuffix = ".debug"
        }
        getByName("release") {
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
        create("releaseTest") {
            isMinifyEnabled = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            applicationIdSuffix = ".releaseTest"
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }
    kotlinOptions {
        jvmTarget = "17"
        freeCompilerArgs = listOf("-XXLanguage:+PropertyParamAnnotationDefaultTargetMode")
    }
    testOptions {
        unitTests {
            isIncludeAndroidResources = true
        }
    }
    buildFeatures {
        buildConfig = true
        compose = true
    }
    packaging {
        resources {
            excludes += "/META-INF/{AL2.0,LGPL2.1}"
        }
    }
    dependenciesInfo {
        // These two settings exclude dependency information in the apk
        // As far as I can tell, this might or might not be required by google play, but
        // it interferes with fdroid reproducible builds.
        includeInApk = false
        includeInBundle = false
    }
    hilt {
        enableAggregatingTask = true
    }
    lint {
        checkAllWarnings = true
        warningsAsErrors = true
        checkDependencies = true

        disable += "ComposableLambdaParameterNaming"
        disable += "ComposableLambdaParameterPosition"
        disable += "LogConditional" // Logging in release mode is fine for this app
        disable += "SyntheticAccessor" // Not a issue in this app
        disable += "DuplicateStrings" // I don't care
    }
}

dependencies {
    implementation(libs.androidx.hilt.navigation.compose)
    implementation(libs.hilt.android)
    implementation(libs.androidx.room.runtime)
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.lifecycle.runtime.ktx)
    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.androidx.ui)
    implementation(libs.androidx.ui.graphics)
    implementation(libs.androidx.ui.tooling.preview)
    implementation(libs.androidx.material3)
    implementation(libs.androidx.navigation.compose)
    implementation(libs.vico.compose)
    implementation(libs.vico.compose.m3)
    implementation(libs.vico.core)
    implementation(libs.androidx.datastore.preferences)
    implementation(libs.coil.compose)
    implementation(libs.google.accompanist.permissions)
    implementation(libs.kotlinx.serialization.json)
    implementation(libs.androidx.emoji2.emojipicker)
    implementation(libs.androidx.documentfile)

    ksp(libs.hilt.android.compiler)
    ksp(libs.androidx.room.compiler)

    testImplementation(libs.junit)
    testImplementation(libs.approvaltests)
    testImplementation(libs.robolectric)
    testImplementation(libs.androidx.core)
    testImplementation(libs.androidx.ui.test.junit4)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(platform(libs.androidx.compose.bom))
    androidTestImplementation(libs.screengrab)

    debugImplementation(libs.androidx.ui.tooling)
    debugImplementation(libs.androidx.ui.test.manifest)
}
