plugins {
    id("com.android.library")
    alias(core.plugins.kotlin.android)
    alias(core.plugins.compose.compiler)
}

val coreCompileSdk: Int by rootProject.extra
val coreMinSdk: Int by rootProject.extra
val javaVersion: JavaVersion by rootProject.extra

android {
    namespace = "com.infomaniak.core.filetypes"
    compileSdk = coreCompileSdk

    defaultConfig {
        minSdk = coreMinSdk

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = javaVersion
        targetCompatibility = javaVersion
    }
    kotlinOptions {
        jvmTarget = javaVersion.toString()
    }
    buildFeatures {
        compose = true
    }
}

dependencies {
    implementation(project(":Core:Compose:Margin"))

    implementation(core.androidx.core.ktx)
    implementation(platform(core.compose.bom))
    implementation(core.compose.foundation)
    implementation(core.compose.ui)
    implementation(core.compose.ui.tooling.preview)

    testImplementation(core.junit)
    androidTestImplementation(core.androidx.junit)
    debugImplementation(core.compose.ui.tooling)
}
