/*
 * Infomaniak Mail - Android
 * Copyright (C) 2024 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.mail.ui.main.thread.calendar

import android.graphics.drawable.InsetDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.navigation.fragment.navArgs
import com.infomaniak.core.legacy.utils.context
import com.infomaniak.core.legacy.utils.safeBinding
import com.infomaniak.core.legacy.views.DividerItemDecorator
import com.infomaniak.mail.R
import com.infomaniak.mail.databinding.BottomSheetAttendeesBinding
import com.infomaniak.mail.ui.bottomSheetDialogs.EdgeToEdgeBottomSheetDialog
import com.infomaniak.mail.utils.UiUtils

class AttendeesBottomSheetDialog : EdgeToEdgeBottomSheetDialog() {

    private var binding: BottomSheetAttendeesBinding by safeBinding()
    private val navigationArgs: AttendeesBottomSheetDialogArgs by navArgs()

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        return BottomSheetAttendeesBinding.inflate(inflater, container, false).also { binding = it }.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) = with(binding) {
        super.onViewCreated(view, savedInstanceState)

        val attendees = navigationArgs.attendees.toList()
        root.title = context.getString(R.string.attendeesListTitle, attendees.count())
        attendeeRecyclerView.adapter = AttendeesAdapter(attendees)

        val margin = context.resources.getDimensionPixelSize(R.dimen.dividerHorizontalPadding)
        val divider = DividerItemDecorator(InsetDrawable(UiUtils.dividerDrawable(context), margin, 0, margin, 0))
        attendeeRecyclerView.addItemDecoration(divider)
    }
}
