/*
 * Infomaniak Mail - Android
 * Copyright (C) 2025 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.mail.ui.main.emojiPicker

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.navigation.fragment.navArgs
import com.infomaniak.core.legacy.utils.safeBinding
import com.infomaniak.core.legacy.utils.setBackNavigationResult
import com.infomaniak.mail.databinding.FragmentEmojiPickerBinding
import com.infomaniak.mail.ui.bottomSheetDialogs.EdgeToEdgeBottomSheetDialog

class EmojiPickerBottomSheetDialog : EdgeToEdgeBottomSheetDialog() {

    private var binding: FragmentEmojiPickerBinding by safeBinding()
    private val navigationArgs: EmojiPickerBottomSheetDialogArgs by navArgs()

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        return FragmentEmojiPickerBinding.inflate(inflater, container, false).also { binding = it }.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        binding.emojiPicker.setOnEmojiPickedListener {
            setBackNavigationResult(
                key = navigationArgs.pickedEmojiNavigationKey.name,
                value = PickedEmojiPayload(it.emoji, navigationArgs.messageUid)
            )
        }
    }

    // The enum is used to determine where the emoji sending logic will be processed.
    // If the thread is open, then the logic in ThreadViewModel must always be used so that FakeEmoji can be used, even in tablet mode.
    // Otherwise, use the logic in ThreadListViewModel.
    enum class EmojiPickerObserverTarget {
        Thread,
        ThreadList
    }
}
