/*
 * Infomaniak Mail - Android
 * Copyright (C) 2023-2025 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.mail.receivers

import android.util.ArrayMap
import androidx.annotation.MainThread
import kotlinx.coroutines.Job
import javax.inject.Inject
import javax.inject.Singleton

@Singleton
class NotificationJobsBus @Inject constructor() {

    private val jobs = ArrayMap<Int, Job>()

    @MainThread
    fun register(notificationId: Int, job: Job) {
        jobs[notificationId] = job
    }

    @MainThread
    fun unregister(notificationId: Int) {
        jobs[notificationId]?.cancel()
        jobs.remove(notificationId)
    }
}
