/*
 * Infomaniak Core - Android
 * Copyright (C) 2024 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.core.legacy.stores.updatemanagers

import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.lifecycleScope
import com.infomaniak.core.legacy.fdroidTools.FdroidApiTools
import com.infomaniak.core.legacy.utils.SentryLog
import com.infomaniak.core.legacy.stores.BaseInAppUpdateManager
import com.infomaniak.core.legacy.stores.StoreUtils
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class InAppUpdateManager(
    private val activity: FragmentActivity,
    private val appId: String,
    private val versionCode: Int,
) : BaseInAppUpdateManager(activity) {

    override fun checkUpdateIsAvailable() {
        SentryLog.d(StoreUtils.APP_UPDATE_TAG, "Checking for update on FDroid")
        activity.lifecycleScope.launch(Dispatchers.IO) {
            val lastVersionCode = FdroidApiTools().getLastRelease(appId)

            withContext(Dispatchers.Main) { onFDroidResult?.invoke(versionCode < lastVersionCode) }
        }
    }
}
