/*
 * Infomaniak Mail - Android
 * Copyright (C) 2023-2025 Infomaniak Network SA
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.infomaniak.mail.views.itemViews

import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.content.res.AppCompatResources
import com.infomaniak.mail.R

class InvalidMailboxItemView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
) : DecoratedItemView(context, attrs, defStyleAttr) {

    private val warningIcon by lazy { AppCompatResources.getDrawable(context, R.drawable.ic_warning) }

    var hasNoValidMailboxes = false

    fun computeEndIconVisibility() {
        val (endIcon, contentDescription) = if (!hasNoValidMailboxes) {
            warningIcon to R.string.contentDescriptionWarningIcon
        } else {
            null to null
        }

        setEndIcon(endIcon, contentDescription)
    }

    fun initSetOnClickListener(onInvalidMailboxClicked: (() -> Unit)?) {
        super.setOnClickListener { onInvalidMailboxClicked?.invoke() }
    }
}
